/* AMD Zen gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

/* Disable use of slow functions.  FIXME: We should disable lib inclusion.  */
#undef HAVE_NATIVE_mpn_mul_2
#undef HAVE_NATIVE_mpn_addmul_2

/* 3700-4300 MHz Pinnacle Ridge */
/* FFT tuning limit = 468,514,360 */
/* Generated by tuneup.c, 2019-10-18, gcc 8.3 */

#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          4
#define MOD_1U_TO_MOD_1_1_THRESHOLD          3
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        13
#define MOD_1_2_TO_MOD_1_4_THRESHOLD        18
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD      9
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1_NORM_THRESHOLD              1
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD              32
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           22

#define DIV_1_VS_MUL_1_PERCENT             338

#define MUL_TOOM22_THRESHOLD                16
#define MUL_TOOM33_THRESHOLD               107
#define MUL_TOOM44_THRESHOLD               190
#define MUL_TOOM6H_THRESHOLD               230
#define MUL_TOOM8H_THRESHOLD               272

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      97
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     110
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     106
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     117
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     136

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 32
#define SQR_TOOM3_THRESHOLD                114
#define SQR_TOOM4_THRESHOLD                422
#define SQR_TOOM6_THRESHOLD                  0  /* always */
#define SQR_TOOM8_THRESHOLD                  0  /* always */

#define MULMID_TOOM42_THRESHOLD             40

#define MULMOD_BNM1_THRESHOLD               12
#define SQRMOD_BNM1_THRESHOLD               17

#define MUL_FFT_MODF_THRESHOLD             540  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    540, 5}, {     22, 6}, {     12, 5}, {     25, 6}, \
    {     25, 7}, {     13, 6}, {     29, 7}, {     15, 6}, \
    {     31, 7}, {     21, 8}, {     11, 7}, {     25, 8}, \
    {     13, 7}, {     29, 8}, {     15, 7}, {     32, 8}, \
    {     17, 7}, {     35, 8}, {     19, 7}, {     39, 8}, \
    {     21, 7}, {     43, 9}, {     11, 8}, {     29, 9}, \
    {     15, 8}, {     35, 9}, {     19, 8}, {     43, 9}, \
    {     23, 8}, {     49, 9}, {     27,10}, {     15, 9}, \
    {     31, 8}, {     63, 9}, {     43,10}, {     23, 9}, \
    {     55,11}, {     15,10}, {     31, 9}, {     67,10}, \
    {     39, 9}, {     83,10}, {     47, 9}, {     99,10}, \
    {     55,11}, {     31,10}, {     79,11}, {     47,10}, \
    {    103,12}, {     31,11}, {     63,10}, {    135,11}, \
    {     79,10}, {    167,11}, {     95,10}, {    191,12}, \
    {     63,11}, {    159,12}, {     95,11}, {    191,13}, \
    {     63,12}, {    127,11}, {    255,10}, {    511,11}, \
    {    271,10}, {    543,11}, {    287,12}, {    159,11}, \
    {    319,10}, {    639,11}, {    335,10}, {    671, 9}, \
    {   1343,11}, {    351,12}, {    191,11}, {    383,10}, \
    {    767,11}, {    415,10}, {    831,12}, {    223,11}, \
    {    447,13}, {    127,12}, {    255,11}, {    543,10}, \
    {   1087,12}, {    287,11}, {    575,10}, {   1151,11}, \
    {    607,10}, {   1215,12}, {    319,11}, {    639,10}, \
    {   1279,11}, {    671,10}, {   1343, 9}, {   2687,12}, \
    {    351,11}, {    703,13}, {    191,12}, {    383,11}, \
    {    767,12}, {    415,11}, {    831,10}, {   1663,12}, \
    {    447,14}, {    127,13}, {    255,12}, {    511,11}, \
    {   1023,12}, {    543,11}, {   1087,12}, {    575,11}, \
    {   1151,12}, {    607,11}, {   1215,13}, {    319,12}, \
    {    639,11}, {   1279,12}, {    671,11}, {   1343,10}, \
    {   2687,12}, {    703,11}, {   1407,13}, {    383,12}, \
    {    799,11}, {   1599,12}, {    831,11}, {   1663,13}, \
    {    447,12}, {    895,11}, {   1791,12}, {    927,11}, \
    {   1855,12}, {    959,11}, {   1919,10}, {   3839,13}, \
    {    511,12}, {   1087,11}, {   2175,13}, {    575,12}, \
    {   1215,11}, {   2431,13}, {    639,12}, {   1343,11}, \
    {   2687,13}, {    703,12}, {   1407,14}, {    383,13}, \
    {    767,12}, {   1599,13}, {    831,12}, {   1727,11}, \
    {   3455,13}, {    895,12}, {   1855,13}, {    959,12}, \
    {   1919,11}, {   3839,14}, {    511,13}, {   1087,12}, \
    {   2175,13}, {   1215,12}, {   2431,14}, {    639,13}, \
    {   1343,12}, {   2687,13}, {   1471,12}, {   2943,14}, \
    {    767,13}, {   1599,12}, {   3199,13}, {   1727,12}, \
    {   3455,14}, {    895,13}, {   1855,12}, {   3711,13}, \
    {   1919,15}, {    511,14}, {   1023,13}, {   2175,14}, \
    {   1151,13}, {   2431,12}, {   4863,14}, {   1279,13}, \
    {   2687,14}, {   1407,13}, {   2815,15}, {    767,14}, \
    {   1535,13}, {   3199,14}, {   1663,13}, {   3455,12}, \
    {   6911,14}, {   1791,13}, {   3583,14}, {   1919,16}, \
    {    511,15}, {   1023,14}, {   2175,13}, {   4479,14}, \
    {   2431,13}, {   4863,15}, {   1279,14}, {   2687,13}, \
    {   5375,14}, {   2943,13}, {   5887,15}, {   1535,14}, \
    {   3455,13}, {   6911,15}, {   1791,14}, {   3839,13}, \
    {   7679,16}, {   1023,15}, {   2047,14}, {   4479,15}, \
    {   2303,14}, {   4991,15}, {   2559,14}, {   5247,15}, \
    {   2815,14}, {   5887,16}, {   1535,15}, {   3327,14}, \
    {   6911,15}, {   3839,14}, {   7679,17}, {   1023,16}, \
    {   2047,15}, {   4095,14}, {   8191,15}, {   4351,14}, \
    {   8959,15}, {   4863,16}, {   2559,15}, {   5375,14}, \
    {  11007,15}, {   5887,14}, {  11775,16}, {   3071,15}, \
    {   6911,16}, {   3583,15}, {   7167,14}, {  14335,15}, \
    {   7679,14}, {  15359,15}, {   7935,14}, {  15871,17}, \
    {   2047,16}, {   4095,15}, {   8959,16}, {   4607,15}, \
    {   9215,14}, {  18431,15}, {   9727,14}, {  19455,15}, \
    {   9983,14}, {  19967,16}, {   5119,15}, {  11007,16}, \
    {   5631,15}, {  11775,17}, {   3071,16}, {  65536,17}, \
    { 131072,18}, { 262144,19}, { 524288,20}, {1048576,21}, \
    {2097152,22}, {4194304,23}, {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 271
#define MUL_FFT_THRESHOLD                 6272

#define SQR_FFT_MODF_THRESHOLD             404  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    404, 5}, {     13, 4}, {     27, 5}, {     21, 6}, \
    {     11, 5}, {     25, 6}, {     13, 5}, {     27, 6}, \
    {     14, 5}, {     29, 6}, {     29, 7}, {     15, 6}, \
    {     31, 7}, {     17, 6}, {     35, 7}, {     25, 8}, \
    {     13, 7}, {     29, 8}, {     15, 7}, {     33, 8}, \
    {     17, 7}, {     35, 8}, {     19, 7}, {     39, 8}, \
    {     29, 9}, {     15, 8}, {     35, 9}, {     19, 8}, \
    {     41, 9}, {     23, 8}, {     49, 9}, {     27,10}, \
    {     15, 9}, {     31, 8}, {     63, 9}, {     43,10}, \
    {     23, 9}, {     51,11}, {     15,10}, {     31, 9}, \
    {     67,10}, {     39, 9}, {     79,10}, {     47, 9}, \
    {     95,10}, {     55,11}, {     31,10}, {     79,11}, \
    {     47,10}, {     95,12}, {     31,11}, {     63,10}, \
    {    135,11}, {     79,10}, {    159,11}, {     95,12}, \
    {     63,11}, {    127,10}, {    255, 9}, {    511,11}, \
    {    143,10}, {    287, 9}, {    575,11}, {    159,12}, \
    {     95,11}, {    191,13}, {     63,12}, {    127,11}, \
    {    255,10}, {    511,11}, {    271,10}, {    543,11}, \
    {    287,10}, {    575,11}, {    303,12}, {    159,11}, \
    {    319,10}, {    639,11}, {    335,10}, {    671, 9}, \
    {   1343,11}, {    351,10}, {    703,11}, {    367,10}, \
    {    735,12}, {    191,11}, {    383,10}, {    767,11}, \
    {    399,10}, {    799,11}, {    415,10}, {    831,12}, \
    {    223,11}, {    447,10}, {    895,13}, {    127,12}, \
    {    255,11}, {    511,10}, {   1023,11}, {    543,10}, \
    {   1087,12}, {    287,11}, {    575,10}, {   1151,11}, \
    {    607,10}, {   1215,12}, {    319,11}, {    639,10}, \
    {   1279,11}, {    671,10}, {   1343,12}, {    351,11}, \
    {    703,10}, {   1407,11}, {    735,10}, {   1471,13}, \
    {    191,12}, {    383,11}, {    767,10}, {   1535,11}, \
    {    799,12}, {    415,11}, {    831,10}, {   1663,12}, \
    {    447,11}, {    895,14}, {    127,13}, {    255,12}, \
    {    511,11}, {   1023,12}, {    543,11}, {   1087,12}, \
    {    575,11}, {   1151,12}, {    607,11}, {   1215,13}, \
    {    319,12}, {    639,11}, {   1279,12}, {    671,11}, \
    {   1343,12}, {    703,11}, {   1407,12}, {    735,11}, \
    {   1471,13}, {    383,12}, {    767,11}, {   1535,12}, \
    {    799,11}, {   1599,12}, {    831,11}, {   1663,13}, \
    {    447,12}, {    895,11}, {   1791,12}, {    959,14}, \
    {    255,13}, {    511,12}, {   1023,11}, {   2047,12}, \
    {   1087,11}, {   2175,13}, {    575,12}, {   1215,11}, \
    {   2431,13}, {    639,12}, {   1343,13}, {    703,12}, \
    {   1471,11}, {   2943,14}, {    383,13}, {    767,12}, \
    {   1599,13}, {    831,12}, {   1727,11}, {   3455,13}, \
    {    895,12}, {   1855,13}, {    959,15}, {    255,14}, \
    {    511,13}, {   1023,12}, {   2047,13}, {   1087,12}, \
    {   2175,13}, {   1215,12}, {   2431,14}, {    639,13}, \
    {   1343,12}, {   2687,13}, {   1471,12}, {   2943,14}, \
    {    767,13}, {   1599,12}, {   3199,13}, {   1727,12}, \
    {   3455,14}, {    895,13}, {   1855,12}, {   3711,13}, \
    {   1919,15}, {    511,14}, {   1023,13}, {   2175,14}, \
    {   1151,13}, {   2431,12}, {   4863,14}, {   1279,13}, \
    {   2687,14}, {   1407,13}, {   2943,15}, {    767,14}, \
    {   1535,13}, {   3199,14}, {   1663,13}, {   3455,12}, \
    {   6911,14}, {   1791,13}, {   3583,14}, {   1919,16}, \
    {    511,15}, {   1023,14}, {   2047,13}, {   4095,14}, \
    {   2175,13}, {   4479,12}, {   8959,14}, {   2431,13}, \
    {   4863,15}, {   1279,14}, {   2943,13}, {   5887,12}, \
    {  11775,15}, {   1535,14}, {   3455,13}, {   6911,15}, \
    {   1791,14}, {   3839,13}, {   7679,14}, {   3967,16}, \
    {   1023,15}, {   2047,14}, {   4479,15}, {   2303,14}, \
    {   4991,15}, {   2559,14}, {   5247,15}, {   2815,14}, \
    {   5887,13}, {  11775,16}, {   1535,15}, {   3071,14}, \
    {   6143,15}, {   3327,14}, {   6911,15}, {   3839,14}, \
    {   7679,17}, {   1023,16}, {   2047,15}, {   4095,14}, \
    {   8191,15}, {   4351,14}, {   8959,15}, {   4863,14}, \
    {   9727,16}, {   2559,15}, {   5887,14}, {  11775,16}, \
    {   3071,15}, {   6911,16}, {   3583,15}, {   7167,14}, \
    {  14335,15}, {   7679,14}, {  15359,15}, {   7935,14}, \
    {  15871,17}, {   2047,16}, {   4095,15}, {   8959,16}, \
    {   4607,15}, {   9215,14}, {  18431,15}, {   9727,14}, \
    {  19455,15}, {   9983,14}, {  19967,16}, {   5119,15}, \
    {  10239,16}, {   5631,15}, {  11775,17}, {   3071,16}, \
    {   6655,15}, {  13311,16}, {  65536,17}, { 131072,18}, \
    { 262144,19}, { 524288,20}, {1048576,21}, {2097152,22}, \
    {4194304,23}, {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 302
#define SQR_FFT_THRESHOLD                 4224

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  69
#define MULLO_MUL_N_THRESHOLD            11278
#define SQRLO_BASECASE_THRESHOLD            12
#define SQRLO_DC_THRESHOLD                  82
#define SQRLO_SQR_THRESHOLD               8207

#define DC_DIV_QR_THRESHOLD                 76
#define DC_DIVAPPR_Q_THRESHOLD             232
#define DC_BDIV_QR_THRESHOLD                76
#define DC_BDIV_Q_THRESHOLD                104

#define INV_MULMOD_BNM1_THRESHOLD           37
#define INV_NEWTON_THRESHOLD               274
#define INV_APPR_THRESHOLD                 230

#define BINV_NEWTON_THRESHOLD              372
#define REDC_1_TO_REDC_N_THRESHOLD          68

#define MU_DIV_QR_THRESHOLD               1499
#define MU_DIVAPPR_Q_THRESHOLD            1718
#define MUPI_DIV_QR_THRESHOLD              108
#define MU_BDIV_QR_THRESHOLD              1470
#define MU_BDIV_Q_THRESHOLD               1787

#define POWM_SEC_TABLE  3,22,81,494

#define GET_STR_DC_THRESHOLD                12
#define GET_STR_PRECOMPUTE_THRESHOLD        20
#define SET_STR_DC_THRESHOLD               486
#define SET_STR_PRECOMPUTE_THRESHOLD      1264

#define FAC_DSC_THRESHOLD                  187
#define FAC_ODD_THRESHOLD                    0  /* always */

#define MATRIX22_STRASSEN_THRESHOLD         23
#define HGCD2_DIV1_METHOD                    1  /* 9.20% faster than 3 */
#define HGCD_THRESHOLD                     109
#define HGCD_APPR_THRESHOLD                104
#define HGCD_REDUCE_THRESHOLD             3014
#define GCD_DC_THRESHOLD                   566
#define GCDEXT_DC_THRESHOLD                382
#define JACOBI_BASE_METHOD                   1  /* 15.55% faster than 3 */

/* Tuneup completed successfully, took 281243 seconds */
