; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -global-isel -o - \
; RUN:   -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names -verify-machineinstrs < %s | FileCheck %s

define i64 @load_i64(ptr %p) {
; CHECK-LABEL: load_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    blr
entry:
  %ret = load i64, ptr %p, align 8
  ret i64 %ret
}

define i64 @load2_i64(ptr %p, i64 %a) {
; CHECK-LABEL: load2_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    add r3, r3, r4
; CHECK-NEXT:    blr
entry:
  %load = load i64, ptr %p, align 8
  %ret = add i64 %load, %a
  ret i64 %ret
}

define float @load3_i64(ptr %p) {
; CHECK-LABEL: load3_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xscvsxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %load = load i64, ptr %p, align 8
  %ret = sitofp i64 %load to float
  ret float %ret
}

define double @load4_i64(ptr %p) {
; CHECK-LABEL: load4_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xscvsxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %load = load i64, ptr %p, align 8
  %ret = sitofp i64 %load to double
  ret double %ret
}

define float @load5_i64(ptr %p) {
; CHECK-LABEL: load5_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xscvuxdsp f1, f0
; CHECK-NEXT:    blr
entry:
  %load = load i64, ptr %p, align 8
  %ret = uitofp i64 %load to float
  ret float %ret
}

define double @load6_i64(ptr %p) {
; CHECK-LABEL: load6_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    mtfprd f0, r3
; CHECK-NEXT:    xscvuxddp f1, f0
; CHECK-NEXT:    blr
entry:
  %load = load i64, ptr %p, align 8
  %ret = uitofp i64 %load to double
  ret double %ret
}

define double @load_f64(ptr %p) {
; CHECK-LABEL: load_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  %ret = load double, ptr %p, align 8
  ret double %ret
}

define double @load2_f64(ptr %p, double %a) {
; CHECK-LABEL: load2_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xsadddp f1, f0, f1
; CHECK-NEXT:    blr
entry:
  %load = load double, ptr %p, align 8
  %ret = fadd double %load, %a
  ret double %ret
}

define i64 @load3_f64(ptr %p) {
; CHECK-LABEL: load3_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpsxds f0, f0
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    blr
entry:
  %load = load double, ptr %p, align 8
  %ret = fptosi double %load to i64
  ret i64 %ret
}

define i64 @load4_f64(ptr %p) {
; CHECK-LABEL: load4_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lfd f0, 0(r3)
; CHECK-NEXT:    xscvdpuxds f0, f0
; CHECK-NEXT:    mffprd r3, f0
; CHECK-NEXT:    blr
entry:
  %load = load double, ptr %p, align 8
  %ret = fptoui double %load to i64
  ret i64 %ret
}

define void @store_i64(ptr %p) {
; CHECK-LABEL: store_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r4, 100
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  store i64 100, ptr %p, align 8
  ret void
}

define void @store2_i64(ptr %p, i64 %a, i64 %b) {
; CHECK-LABEL: store2_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    add r4, r4, r5
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %add = add i64 %a, %b
  store i64 %add, ptr %p, align 8
  ret void
}

define void @store3_i64(ptr %p, float %a) {
; CHECK-LABEL: store3_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxds f0, f1
; CHECK-NEXT:    mffprd r4, f0
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptosi float %a to i64
  store i64 %conv, ptr %p, align 8
  ret void
}

define void @store4_i64(ptr %p, double %a) {
; CHECK-LABEL: store4_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpsxds f0, f1
; CHECK-NEXT:    mffprd r4, f0
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptosi double %a to i64
  store i64 %conv, ptr %p, align 8
  ret void
}

define void @store5_i64(ptr %p, float %a) {
; CHECK-LABEL: store5_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxds f0, f1
; CHECK-NEXT:    mffprd r4, f0
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptoui float %a to i64
  store i64 %conv, ptr %p, align 8
  ret void
}

define void @store6_i64(ptr %p, double %a) {
; CHECK-LABEL: store6_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdpuxds f0, f1
; CHECK-NEXT:    mffprd r4, f0
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = fptoui double %a to i64
  store i64 %conv, ptr %p, align 8
  ret void
}

define void @store_f64(ptr %p, double %a) {
; CHECK-LABEL: store_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stfd f1, 0(r3)
; CHECK-NEXT:    blr
entry:
  store double %a, ptr %p, align 8
  ret void
}

define void @store2_f64(ptr %p, double %a, double %b) {
; CHECK-LABEL: store2_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xsadddp f0, f1, f2
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %fadd = fadd double %a, %b
  store double %fadd, ptr %p, align 8
  ret void
}

define void @store3_f64(ptr %p, i64 %a) {
; CHECK-LABEL: store3_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprd f0, r4
; CHECK-NEXT:    xscvsxddp f0, f0
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = sitofp i64 %a to double
  store double %conv, ptr %p, align 8
  ret void
}

define void @store4_f64(ptr %p, i64 %a) {
; CHECK-LABEL: store4_f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mtfprd f0, r4
; CHECK-NEXT:    xscvuxddp f0, f0
; CHECK-NEXT:    stfd f0, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = uitofp i64 %a to double
  store double %conv, ptr %p, align 8
  ret void
}
