/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.standard.AWTCursor;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;

public class CreationTool
extends AbstractTool {
    private List fAddedFigures;
    private Figure fCreatedFigure;
    private Figure myAddedFigure;
    private Figure myPrototypeFigure;

    public CreationTool(DrawingEditor drawingEditor, Figure figure) {
        super(drawingEditor);
        this.setPrototypeFigure(figure);
    }

    protected CreationTool(DrawingEditor drawingEditor) {
        this(drawingEditor, null);
    }

    public void activate() {
        super.activate();
        if (this.isUsable()) {
            this.getActiveView().setCursor(new AWTCursor(1));
        }
        this.setAddedFigures(CollectionsFactory.current().createList());
    }

    public void deactivate() {
        this.setCreatedFigure(null);
        this.setAddedFigure(null);
        this.setAddedFigures(null);
        super.deactivate();
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        this.setCreatedFigure(this.createFigure());
        this.setAddedFigure(this.getActiveView().add(this.getCreatedFigure()));
        this.getAddedFigure().displayBox(new Point(this.getAnchorX(), this.getAnchorY()), new Point(this.getAnchorX(), this.getAnchorY()));
    }

    protected Figure createFigure() {
        if (this.getPrototypeFigure() == null) {
            throw new JHotDrawRuntimeException("No protoype defined");
        }
        return (Figure)this.getPrototypeFigure().clone();
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.getAddedFigure() != null) {
            this.getAddedFigure().displayBox(new Point(this.getAnchorX(), this.getAnchorY()), new Point(n, n2));
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.getAddedFigure() != null && !this.getCreatedFigure().isEmpty()) {
            this.getAddedFigures().add(this.getAddedFigure());
        } else {
            this.getActiveView().remove(this.getAddedFigure());
        }
        if (this.getAddedFigures().isEmpty()) {
            this.setUndoActivity(null);
        } else {
            this.setUndoActivity(this.createUndoActivity());
            this.getUndoActivity().setAffectedFigures(new FigureEnumerator(this.getAddedFigures()));
        }
        this.editor().toolDone();
    }

    protected void setPrototypeFigure(Figure figure) {
        this.myPrototypeFigure = figure;
    }

    protected Figure getPrototypeFigure() {
        return this.myPrototypeFigure;
    }

    protected List getAddedFigures() {
        return this.fAddedFigures;
    }

    protected void setAddedFigures(List list) {
        this.fAddedFigures = list;
    }

    protected Figure getCreatedFigure() {
        return this.fCreatedFigure;
    }

    protected void setCreatedFigure(Figure figure) {
        this.fCreatedFigure = figure;
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    protected void setAddedFigure(Figure figure) {
        this.myAddedFigure = figure;
    }

    protected Undoable createUndoActivity() {
        return new PasteCommand.UndoActivity(this.getActiveView());
    }
}

