# Write a new HTTP authentication crate

Date: 2022-10-20

# Problem statement

I'd like a crate for HTTP authentication that has the following goals
(described more in [`http-auth`'s README](../README.md)):

1.  sound
2.  correct
3.  light-weight
4.  complete
5.  ergonomic
6.  fast enough

## Considered options

*   Write a new crate
*   Use/extend an existing crate

The existing crates don't seem to match these goals partially well:

### [`www-authenticate`](https://crates.io/crates/www-authenticate)

*   sound: `www-authenticate` has some unsound `transmute`s to static lifetime.
    (These likely aren't hard to fix though.)
*   light-weight: `www-authenticate` depends on `hyperx` and `unicase`, large
    dependencies which many useful programs don't include.
*   complete: `www-authenticate` only supports parsing of challenge lists, not
    responding to them.

### [`digest_auth`](https://crates.io/crates/digest_auth)

*   complete: `digest_auth` only supports `Digest`. It can't parse multiple
    challenges and will fail if given a list that starts with another scheme.
    Thus, if the server follows the advice of
    [RFC 7235 section 2.1](https://datatracker.ietf.org/doc/html/rfc7235) and
    lists another scheme such as `Basic` first, `digest_auth`'s parsing is
    insufficient.

### `www-authenticate` + `digest_auth` together

In addition to the "sound" and "light-weight" `www-authenticate` caveats above,
responding to password challenges by using both `www-authenticate` and
`digest_auth` is still incomplete and not ergonomic. The caller must do extra work:

*    explicitly consider both `Digest` and `Basic`, rather than using the
     abstract `http_auth::PasswordClient` that chooses the challenge for you.
*    when responding to a `Digest` challenge, construct a matching
     `digest_auth::WwwAuthenticateHeader` from the
     `www_authenticate::DigestChallenge`.
*    when responding to a `Basic` challenge, do the encoding manually.

## Decision Outcome

Write the new `http-auth` crate.
