/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.NumberAssert;
import org.fest.assertions.PrimitiveAssert;
import org.fest.util.Strings;

public class FloatAssert
extends PrimitiveAssert
implements NumberAssert {
    private static final float ZERO = 0.0f;
    private final float actual;

    protected FloatAssert(float actual) {
        this.actual = actual;
    }

    public FloatAssert as(String description) {
        this.description(description);
        return this;
    }

    public FloatAssert describedAs(String description) {
        return this.as(description);
    }

    public FloatAssert as(Description description) {
        this.description(description);
        return this;
    }

    public FloatAssert describedAs(Description description) {
        return this.as(description);
    }

    public FloatAssert isEqualTo(float expected) {
        if (this.compareTo(expected) == 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(Float.valueOf(this.actual), Float.valueOf(expected)));
    }

    @Deprecated
    public FloatAssert isEqualTo(float expected, Delta delta) {
        return this.isEqualTo(expected, delta.value);
    }

    public FloatAssert isEqualTo(float expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.floatValue());
    }

    private FloatAssert isEqualTo(float expected, float deltaValue) {
        if (this.compareTo(expected) == 0) {
            return this;
        }
        if (Math.abs(expected - this.actual) <= deltaValue) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{ErrorMessages.unexpectedNotEqual(Float.valueOf(this.actual), Float.valueOf(expected)), " using delta:", Formatting.inBrackets(Float.valueOf(deltaValue))}));
    }

    public FloatAssert isNotEqualTo(float other) {
        if (this.compareTo(other) != 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(Float.valueOf(this.actual), Float.valueOf(other)));
    }

    public FloatAssert isGreaterThan(float other) {
        if (this.compareTo(other) > 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(Float.valueOf(this.actual), Float.valueOf(other)));
    }

    public FloatAssert isLessThan(float other) {
        if (this.compareTo(other) < 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(Float.valueOf(this.actual), Float.valueOf(other)));
    }

    public FloatAssert isGreaterThanOrEqualTo(float other) {
        if (this.compareTo(other) >= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(Float.valueOf(this.actual), Float.valueOf(other)));
    }

    public FloatAssert isLessThanOrEqualTo(float other) {
        if (this.compareTo(other) <= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(Float.valueOf(this.actual), Float.valueOf(other)));
    }

    private int compareTo(float other) {
        return Float.compare(this.actual, other);
    }

    public FloatAssert isNaN() {
        return this.isEqualTo(Float.NaN);
    }

    public FloatAssert isZero() {
        return this.isEqualTo(0.0f);
    }

    public FloatAssert isPositive() {
        return this.isGreaterThan(0.0f);
    }

    public FloatAssert isNegative() {
        return this.isLessThan(0.0f);
    }

    @Deprecated
    public static Delta delta(float d) {
        return new Delta(d);
    }

    public FloatAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    @Deprecated
    public static class Delta {
        final float value;

        private Delta(float value) {
            this.value = value;
        }
    }
}

