/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.SessionAtts;

final class NIOHeader {
    int length;
    int packetChecksum;
    int flags;
    int headerChecksum;
    int type;
    final SessionAtts session;

    NIOHeader(SessionAtts sessionAtts) {
        this.session = sessionAtts;
    }

    final void readHeaderBuffer() throws IOException {
        this.session.headerBuffer.clear();
        while (this.session.headerBuffer.hasRemaining()) {
            this.session.socketChannel.read(this.session.headerBuffer);
        }
        this.session.headerBuffer.rewind();
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12)) {
            this.length = this.session.headerBuffer.getInt() & 0xFFFFFFFF;
        } else {
            this.length = this.session.headerBuffer.getShort() & 0xFFFF;
            this.packetChecksum = this.session.headerBuffer.getShort() & 0xFFFF;
        }
        this.type = this.session.headerBuffer.get() & 0xFF;
        this.flags = this.session.headerBuffer.get() & 0xFF;
        this.headerChecksum = this.session.headerBuffer.getShort() & 0xFFFF;
    }

    final void fillHeaderBuffer() throws IOException {
        this.session.headerBuffer.clear();
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12) || this.type == 15) {
            this.session.headerBuffer.putInt(this.length);
        } else {
            this.session.headerBuffer.putShort((short)this.length);
            this.session.headerBuffer.putShort((short)0);
        }
        this.session.headerBuffer.put((byte)this.type);
        this.session.headerBuffer.put((byte)this.flags);
        this.session.headerBuffer.putShort((short)0);
    }
}

