/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.Bin;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBAMFileIndex
implements BAMIndex {
    private final IndexFileBuffer mIndexBuffer;
    private SAMSequenceDictionary mBamDictionary = null;
    final int[] sequenceIndexes;

    protected AbstractBAMFileIndex(SeekableStream stream, SAMSequenceDictionary dictionary) {
        this.mBamDictionary = dictionary;
        this.mIndexBuffer = new IndexStreamBuffer(stream);
        this.verifyBAMMagicNumber(stream.getSource());
        this.sequenceIndexes = new int[this.readInteger() + 1];
        Arrays.fill(this.sequenceIndexes, -1);
    }

    protected AbstractBAMFileIndex(File file, SAMSequenceDictionary dictionary) {
        this(file, dictionary, true);
    }

    protected AbstractBAMFileIndex(File file, SAMSequenceDictionary dictionary, boolean useMemoryMapping) {
        this.mBamDictionary = dictionary;
        this.mIndexBuffer = useMemoryMapping ? new MemoryMappedFileBuffer(file) : new RandomAccessFileBuffer(file);
        this.verifyBAMMagicNumber(file.getName());
        this.sequenceIndexes = new int[this.readInteger() + 1];
        Arrays.fill(this.sequenceIndexes, -1);
    }

    @Override
    public void close() {
        this.mIndexBuffer.close();
    }

    public static int getNumIndexLevels() {
        return GenomicIndexUtil.LEVEL_STARTS.length;
    }

    public static int getFirstBinInLevel(int levelNumber) {
        return GenomicIndexUtil.LEVEL_STARTS[levelNumber];
    }

    public int getLevelSize(int levelNumber) {
        if (levelNumber == AbstractBAMFileIndex.getNumIndexLevels()) {
            return 37451 - GenomicIndexUtil.LEVEL_STARTS[levelNumber];
        }
        return GenomicIndexUtil.LEVEL_STARTS[levelNumber + 1] - GenomicIndexUtil.LEVEL_STARTS[levelNumber];
    }

    public int getLevelForBin(Bin bin) {
        if (bin.getBinNumber() >= 37450) {
            throw new SAMException("Tried to get level for invalid bin.");
        }
        for (int i = AbstractBAMFileIndex.getNumIndexLevels() - 1; i >= 0; --i) {
            if (bin.getBinNumber() < GenomicIndexUtil.LEVEL_STARTS[i]) continue;
            return i;
        }
        throw new SAMException("Unable to find correct bin for bin " + bin);
    }

    public int getFirstLocusInBin(Bin bin) {
        int level = this.getLevelForBin(bin);
        int levelStart = GenomicIndexUtil.LEVEL_STARTS[level];
        int levelSize = (level == AbstractBAMFileIndex.getNumIndexLevels() - 1 ? 37449 : GenomicIndexUtil.LEVEL_STARTS[level + 1]) - levelStart;
        return (bin.getBinNumber() - levelStart) * (0x20000000 / levelSize) + 1;
    }

    public int getLastLocusInBin(Bin bin) {
        int level = this.getLevelForBin(bin);
        int levelStart = GenomicIndexUtil.LEVEL_STARTS[level];
        int levelSize = (level == AbstractBAMFileIndex.getNumIndexLevels() - 1 ? 37449 : GenomicIndexUtil.LEVEL_STARTS[level + 1]) - levelStart;
        return (bin.getBinNumber() - levelStart + 1) * (0x20000000 / levelSize);
    }

    public int getNumberOfReferences() {
        this.seek(4);
        return this.readInteger();
    }

    @Override
    public long getStartOfLastLinearBin() {
        this.seek(4);
        int sequenceCount = this.readInteger();
        long lastLinearIndexPointer = -1L;
        for (int i = 0; i < sequenceCount; ++i) {
            int nBins = this.readInteger();
            for (int j1 = 0; j1 < nBins; ++j1) {
                this.skipBytes(4);
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
            }
            int nLinearBins = this.readInteger();
            if (nLinearBins <= 0) continue;
            this.skipBytes(8 * (nLinearBins - 1));
            lastLinearIndexPointer = this.readLong();
        }
        return lastLinearIndexPointer;
    }

    @Override
    public BAMIndexMetaData getMetaData(int reference) {
        this.seek(4);
        ArrayList<Chunk> metaDataChunks = new ArrayList<Chunk>();
        int sequenceCount = this.readInteger();
        if (reference >= sequenceCount) {
            return null;
        }
        this.skipToSequence(reference);
        int binCount = this.readInteger();
        for (int binNumber = 0; binNumber < binCount; ++binNumber) {
            int indexBin = this.readInteger();
            int nChunks = this.readInteger();
            if (indexBin == 37450) {
                for (int ci = 0; ci < nChunks; ++ci) {
                    long chunkBegin = this.readLong();
                    long chunkEnd = this.readLong();
                    metaDataChunks.add(new Chunk(chunkBegin, chunkEnd));
                }
                continue;
            }
            this.skipBytes(16 * nChunks);
        }
        return new BAMIndexMetaData(metaDataChunks);
    }

    public Long getNoCoordinateCount() {
        this.seek(4);
        int sequenceCount = this.readInteger();
        this.skipToSequence(sequenceCount);
        try {
            return this.readLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected BAMIndexContent query(int referenceSequence, int startPos, int endPos) {
        this.seek(4);
        ArrayList<Chunk> metaDataChunks = new ArrayList<Chunk>();
        int sequenceCount = this.readInteger();
        if (referenceSequence >= sequenceCount) {
            return null;
        }
        BitSet regionBins = GenomicIndexUtil.regionToBins(startPos, endPos);
        if (regionBins == null) {
            return null;
        }
        this.skipToSequence(referenceSequence);
        int binCount = this.readInteger();
        boolean metaDataSeen = false;
        Bin[] bins = new Bin[this.getMaxBinNumberForReference(referenceSequence) + 1];
        for (int binNumber = 0; binNumber < binCount; ++binNumber) {
            long chunkEnd;
            long chunkBegin;
            int indexBin = this.readInteger();
            int nChunks = this.readInteger();
            ArrayList<Chunk> chunks = null;
            Chunk lastChunk = null;
            if (regionBins.get(indexBin)) {
                chunks = new ArrayList(nChunks);
                for (int ci = 0; ci < nChunks; ++ci) {
                    chunkBegin = this.readLong();
                    chunkEnd = this.readLong();
                    lastChunk = new Chunk(chunkBegin, chunkEnd);
                    chunks.add(lastChunk);
                }
            } else {
                if (indexBin == 37450) {
                    for (int ci = 0; ci < nChunks; ++ci) {
                        chunkBegin = this.readLong();
                        chunkEnd = this.readLong();
                        lastChunk = new Chunk(chunkBegin, chunkEnd);
                        metaDataChunks.add(lastChunk);
                    }
                    metaDataSeen = true;
                    continue;
                }
                this.skipBytes(16 * nChunks);
                chunks = Collections.emptyList();
            }
            Bin bin = new Bin(referenceSequence, indexBin);
            bin.setChunkList(chunks);
            bin.setLastChunk(lastChunk);
            bins[indexBin] = bin;
        }
        int nLinearBins = this.readInteger();
        int regionLinearBinStart = LinearIndex.convertToLinearIndexOffset(startPos);
        int regionLinearBinStop = endPos > 0 ? LinearIndex.convertToLinearIndexOffset(endPos) : nLinearBins - 1;
        int actualStop = Math.min(regionLinearBinStop, nLinearBins - 1);
        long[] linearIndexEntries = new long[]{};
        if (regionLinearBinStart < nLinearBins) {
            linearIndexEntries = new long[actualStop - regionLinearBinStart + 1];
            this.skipBytes(8 * regionLinearBinStart);
            for (int linearBin = regionLinearBinStart; linearBin <= actualStop; ++linearBin) {
                linearIndexEntries[linearBin - regionLinearBinStart] = this.readLong();
            }
        }
        LinearIndex linearIndex = new LinearIndex(referenceSequence, regionLinearBinStart, linearIndexEntries);
        return new BAMIndexContent(referenceSequence, bins, binCount - (metaDataSeen ? 1 : 0), new BAMIndexMetaData(metaDataChunks), linearIndex);
    }

    private int getMaxBinNumberForReference(int reference) {
        try {
            int sequenceLength = this.mBamDictionary.getSequence(reference).getSequenceLength();
            return AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(sequenceLength);
        }
        catch (Exception e) {
            return 37450;
        }
    }

    static int getMaxBinNumberForSequenceLength(int sequenceLength) {
        return AbstractBAMFileIndex.getFirstBinInLevel(AbstractBAMFileIndex.getNumIndexLevels() - 1) + (sequenceLength >> 14);
    }

    protected abstract BAMIndexContent getQueryResults(int var1);

    protected int getMaxAddressibleGenomicLocation() {
        return 0x20000000;
    }

    protected BitSet regionToBins(int startPos, int endPos) {
        int k;
        int end;
        int maxPos = 0x1FFFFFFF;
        int start = startPos <= 0 ? 0 : startPos - 1 & 0x1FFFFFFF;
        int n = end = endPos <= 0 ? 0x1FFFFFFF : endPos - 1 & 0x1FFFFFFF;
        if (start > end) {
            return null;
        }
        BitSet bitSet = new BitSet(37450);
        bitSet.set(0);
        for (k = 1 + (start >> 26); k <= 1 + (end >> 26); ++k) {
            bitSet.set(k);
        }
        for (k = 9 + (start >> 23); k <= 9 + (end >> 23); ++k) {
            bitSet.set(k);
        }
        for (k = 73 + (start >> 20); k <= 73 + (end >> 20); ++k) {
            bitSet.set(k);
        }
        for (k = 585 + (start >> 17); k <= 585 + (end >> 17); ++k) {
            bitSet.set(k);
        }
        for (k = 4681 + (start >> 14); k <= 4681 + (end >> 14); ++k) {
            bitSet.set(k);
        }
        return bitSet;
    }

    @Deprecated
    protected List<Chunk> optimizeChunkList(List<Chunk> chunks, long minimumOffset) {
        return Chunk.optimizeChunkList(chunks, minimumOffset);
    }

    private void verifyBAMMagicNumber(String sourceName) {
        this.seek(0);
        byte[] buffer = new byte[4];
        this.readBytes(buffer);
        if (!Arrays.equals(buffer, BAMFileConstants.BAM_INDEX_MAGIC)) {
            throw new RuntimeIOException("Invalid file header in BAM index " + sourceName + ": " + new String(buffer));
        }
    }

    private void skipToSequence(int sequenceIndex) {
        if (this.sequenceIndexes[sequenceIndex] != -1) {
            this.seek(this.sequenceIndexes[sequenceIndex]);
            return;
        }
        for (int i = 0; i < sequenceIndex; ++i) {
            int nBins = this.readInteger();
            for (int j = 0; j < nBins; ++j) {
                this.readInteger();
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
            }
            int nLinearBins = this.readInteger();
            this.skipBytes(8 * nLinearBins);
        }
        this.sequenceIndexes[sequenceIndex] = this.position();
    }

    private void readBytes(byte[] bytes) {
        this.mIndexBuffer.readBytes(bytes);
    }

    private int readInteger() {
        return this.mIndexBuffer.readInteger();
    }

    private long readLong() {
        return this.mIndexBuffer.readLong();
    }

    private void skipBytes(int count) {
        this.mIndexBuffer.skipBytes(count);
    }

    private void seek(int position) {
        this.mIndexBuffer.seek(position);
    }

    private int position() {
        return this.mIndexBuffer.position();
    }

    static class IndexStreamBuffer
    extends IndexFileBuffer {
        private final SeekableStream in;
        private final ByteBuffer tmpBuf;

        private static void readFully(SeekableStream in, byte[] buffer, int offset, int length) {
            int read;
            int readThisLoop;
            for (read = 0; read < length; read += readThisLoop) {
                try {
                    readThisLoop = in.read(buffer, read, length - read);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
                if (readThisLoop == -1) break;
            }
            if (read != length) {
                throw new RuntimeIOException("Expected to read " + length + " bytes, but expired stream after " + read + ".");
            }
        }

        public IndexStreamBuffer(SeekableStream s) {
            this.in = s;
            this.tmpBuf = ByteBuffer.allocate(8);
            this.tmpBuf.order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public void close() {
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public void readBytes(byte[] bytes) {
            IndexStreamBuffer.readFully(this.in, bytes, 0, bytes.length);
        }

        @Override
        public void seek(int position) {
            try {
                this.in.seek(position);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public int readInteger() {
            IndexStreamBuffer.readFully(this.in, this.tmpBuf.array(), 0, 4);
            return this.tmpBuf.getInt(0);
        }

        @Override
        public long readLong() {
            IndexStreamBuffer.readFully(this.in, this.tmpBuf.array(), 0, 8);
            return this.tmpBuf.getLong(0);
        }

        @Override
        public void skipBytes(int count) {
            try {
                int skipped;
                for (int s = count; s > 0; s -= skipped) {
                    skipped = (int)this.in.skip(s);
                    if (skipped > 0) continue;
                    throw new RuntimeIOException("Failed to skip " + s);
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        public int position() {
            try {
                return (int)this.in.position();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    private static class RandomAccessFileBuffer
    extends IndexFileBuffer {
        private static final int PAGE_SIZE = 4096;
        private static final int PAGE_OFFSET_MASK = 4095;
        private static final int PAGE_MASK = -4096;
        private static final int INVALID_PAGE = 1;
        private final File mFile;
        private RandomAccessFile mRandomAccessFile;
        private final int mFileLength;
        private int mFilePointer = 0;
        private int mCurrentPage = 1;
        private final byte[] mBuffer = new byte[4096];

        RandomAccessFileBuffer(File file) {
            this.mFile = file;
            try {
                this.mRandomAccessFile = new RandomAccessFile(file, "r");
                long fileLength = this.mRandomAccessFile.length();
                if (fileLength > Integer.MAX_VALUE) {
                    throw new RuntimeIOException("BAM index file " + this.mFile + " is too large: " + fileLength);
                }
                this.mFileLength = (int)fileLength;
            }
            catch (IOException exc) {
                throw new RuntimeIOException(exc.getMessage(), exc);
            }
        }

        @Override
        void readBytes(byte[] bytes) {
            int resultOffset = 0;
            int resultLength = bytes.length;
            if (this.mFilePointer + resultLength > this.mFileLength) {
                throw new RuntimeIOException("Attempt to read past end of BAM index file (file is truncated?): " + this.mFile);
            }
            while (resultLength > 0) {
                this.loadPage(this.mFilePointer);
                int pageOffset = this.mFilePointer & 0xFFF;
                int copyLength = Math.min(resultLength, 4096 - pageOffset);
                System.arraycopy(this.mBuffer, pageOffset, bytes, resultOffset, copyLength);
                this.mFilePointer += copyLength;
                resultOffset += copyLength;
                resultLength -= copyLength;
            }
        }

        @Override
        int readInteger() {
            this.loadPage(this.mFilePointer);
            int pageOffset = this.mFilePointer & 0xFFF;
            this.mFilePointer += 4;
            return this.mBuffer[pageOffset + 0] & 0xFF | (this.mBuffer[pageOffset + 1] & 0xFF) << 8 | (this.mBuffer[pageOffset + 2] & 0xFF) << 16 | (this.mBuffer[pageOffset + 3] & 0xFF) << 24;
        }

        @Override
        long readLong() {
            long lower = this.readInteger();
            long upper = this.readInteger();
            return upper << 32 | lower & 0xFFFFFFFFL;
        }

        @Override
        void skipBytes(int count) {
            this.mFilePointer += count;
        }

        @Override
        void seek(int position) {
            this.mFilePointer = position;
        }

        @Override
        int position() {
            return this.mFilePointer;
        }

        @Override
        void close() {
            this.mFilePointer = 0;
            this.mCurrentPage = 1;
            if (this.mRandomAccessFile != null) {
                try {
                    this.mRandomAccessFile.close();
                }
                catch (IOException exc) {
                    throw new RuntimeIOException(exc.getMessage(), exc);
                }
                this.mRandomAccessFile = null;
            }
        }

        private void loadPage(int filePosition) {
            int page = filePosition & 0xFFFFF000;
            if (page == this.mCurrentPage) {
                return;
            }
            try {
                this.mRandomAccessFile.seek(page);
                int readLength = Math.min(this.mFileLength - page, 4096);
                this.mRandomAccessFile.readFully(this.mBuffer, 0, readLength);
                this.mCurrentPage = page;
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Exception reading BAM index file " + this.mFile + ": " + exc.getMessage(), exc);
            }
        }
    }

    private static class MemoryMappedFileBuffer
    extends IndexFileBuffer {
        private MappedByteBuffer mFileBuffer;

        MemoryMappedFileBuffer(File file) {
            try {
                FileInputStream fileStream = new FileInputStream(file);
                FileChannel fileChannel = fileStream.getChannel();
                this.mFileBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                this.mFileBuffer.order(ByteOrder.LITTLE_ENDIAN);
                fileChannel.close();
                fileStream.close();
            }
            catch (IOException exc) {
                throw new RuntimeIOException(exc.getMessage(), exc);
            }
        }

        @Override
        void readBytes(byte[] bytes) {
            this.mFileBuffer.get(bytes);
        }

        @Override
        int readInteger() {
            return this.mFileBuffer.getInt();
        }

        @Override
        long readLong() {
            return this.mFileBuffer.getLong();
        }

        @Override
        void skipBytes(int count) {
            this.mFileBuffer.position(this.mFileBuffer.position() + count);
        }

        @Override
        void seek(int position) {
            this.mFileBuffer.position(position);
        }

        @Override
        int position() {
            return this.mFileBuffer.position();
        }

        @Override
        void close() {
            this.mFileBuffer = null;
        }
    }

    private static abstract class IndexFileBuffer {
        private IndexFileBuffer() {
        }

        abstract void readBytes(byte[] var1);

        abstract int readInteger();

        abstract long readLong();

        abstract void skipBytes(int var1);

        abstract void seek(int var1);

        abstract int position();

        abstract void close();
    }
}

