#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SensorConformsToProfile.mof
	cimmof -aE -n $4 $6/mof/OpenDRIM_SensorConformsToProfile.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SensorConformsToProfile provider module";
Name = "Sensors_OpenDRIM_SensorConformsToProfileModule";
Location = "cmpiSensors_OpenDRIM_SensorConformsToProfileProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SensorConformsToProfile provider";
Name = "Sensors_OpenDRIM_SensorConformsToProfileProvider";
ProviderModuleName = "Sensors_OpenDRIM_SensorConformsToProfileModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SensorConformsToProfile provider capabilities";
ProviderModuleName = "Sensors_OpenDRIM_SensorConformsToProfileModule";
ProviderName = "Sensors_OpenDRIM_SensorConformsToProfileProvider";
ClassName = "OpenDRIM_SensorConformsToProfile";
ProviderType = {2, 3};
Namespaces = {"$1", "$4"};
SupportedProperties = {"ConformantStandard", "ManagedElement"};
CapabilityID = "Sensors_OpenDRIM_SensorConformsToProfile";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SensorConformsToProfile.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SensorConformsToProfile]   
   provider: Sensors_OpenDRIM_SensorConformsToProfileProvider
   location: cmpiSensors_OpenDRIM_SensorConformsToProfileProvider
   type: instance association
   namespace: $1 $4
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SensorConformsToProfile.mof
	sfcbstage -r $OUTFILE -n $4 $6/mof/OpenDRIM_SensorConformsToProfile.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SensorConformsToProfile-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SensorConformsToProfile.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	owmofc -u http://localhost/$4 $OUTFILE
	
	rm -f $OUTFILE
	
fi
