/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterizedTypeReference<T> {
    private final Type type;

    protected ParameterizedTypeReference() {
        Class<?> parameterizedTypeReferenceSubClass = ParameterizedTypeReference.findParameterizedTypeReferenceSubClass(this.getClass());
        Type type = parameterizedTypeReferenceSubClass.getGenericSuperclass();
        Assert.isInstanceOf(ParameterizedType.class, type);
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Assert.isTrue(parameterizedType.getActualTypeArguments().length == 1);
        this.type = parameterizedType.getActualTypeArguments()[0];
    }

    private static Class<?> findParameterizedTypeReferenceSubClass(Class<?> child) {
        Class<?> parent = child.getSuperclass();
        if (Object.class.equals(parent)) {
            throw new IllegalStateException("Expected ParameterizedTypeReference superclass");
        }
        if (ParameterizedTypeReference.class.equals(parent)) {
            return child;
        }
        return ParameterizedTypeReference.findParameterizedTypeReferenceSubClass(parent);
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ParameterizedTypeReference) {
            ParameterizedTypeReference other = (ParameterizedTypeReference)o;
            return this.type.equals(other.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "ParameterizedTypeReference<" + this.type + ">";
    }
}

