#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hidden Through Time
# send your bug reports to contact@dotslashplay.it
###

script_version=20241016.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='hidden-through-time-1'
GAME_NAME='Hidden Through Time'

ARCHIVE_BASE_1_NAME='setup_hidden_through_time_1.0.9b_(56935).exe'
ARCHIVE_BASE_1_MD5='fafb6b639f687a13c2c6c293550a0ec6'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='632768'
ARCHIVE_BASE_1_VERSION='1.0.9b-gog56935'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/hidden_through_time'

ARCHIVE_BASE_0_NAME='setup_hidden_through_time_1.0.7_(46929).exe'
ARCHIVE_BASE_0_MD5='f64269fa2f3627fe5ad74cae5ff11869'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='520000'
ARCHIVE_BASE_0_VERSION='1.0.7-gog46929'

UNITY3D_NAME='hidden'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Crazy Monkey Studios/Hidden Through Time'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## Ensure smooth upgrades from packages generated with pre-20240220.1 game scripts.
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
hidden-through-time"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Ensure smooth upgrades from packages generated with pre-20240220.1 game scripts.
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
hidden-through-time-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
