#ifndef TEXTEDIT_H
#define TEXTEDIT_H

#include <QtWidgets/QWidget>
#include <QtWidgets/QTextEdit>
#include <QtWidgets/QPushButton>

class TextEdit : public QWidget
{
  Q_OBJECT

  private:
    QTextEdit *text;
    QPushButton *cancelButton, *okButton;

  public:
    TextEdit(QWidget* parent=0, Qt::WindowFlags f=0);
    ~TextEdit();
    QString getText();
    void setText(QString qs);
    void setReadOnly(bool flag);
    void setCancel(bool flag);
    void clear();

  signals:
    void cancelText();
    void textOK();

  public slots:
    void cancelClicked();
    void okClicked();
};
  
#endif
