# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Mon Oct  4 22:14:31 2004

import wx
from bibOOo.CONST import BIB_TYPE,BIB_FIELDS,NAME_FIELD,NAME_TYPE,TYPE_NAME

# begin wxGlade: dependencies
# end wxGlade

class AnonymousDialog(wx.Dialog):
	def __init__(self, *args, **kwds):
		self.settings = kwds["settings"]
		del kwds["settings"]
		self.current_type = "ARTICLE"
		# begin wxGlade: AnonymousDialog.__init__
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.an_type = wx.ListBox(self, -1, choices=[])
		self.an_replace = wx.RadioBox(self, -1, _("If author Field is empty, replace it with:"), choices=[_("Nothing"), _("a Field"), _("a String")], majorDimension=1, style=wx.RA_SPECIFY_ROWS)
		self.an_field = wx.Choice(self, -1, choices=[_("BibliographicType")])
		self.an_text = wx.TextCtrl(self, -1, _("Anonymous"))
		self.static_line_3 = wx.StaticLine(self, -1)
		self.an_Cancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
		self.an_OK = wx.Button(self, wx.ID_OK, _("OK"))

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		self.__set_evt()

	def __set_properties(self):
		# begin wxGlade: AnonymousDialog.__set_properties
		self.SetTitle(_("Anonymous author format"))
		self.an_replace.SetSelection(0)
		self.an_field.SetSelection(0)
		self.an_OK.SetDefault()
		# end wxGlade
		self.an_type.AppendItems([NAME_TYPE[typ] for typ in BIB_TYPE])
		self.an_type.SetSelection(0)
		self.an_field.Clear()
		self.an_field.AppendItems([NAME_FIELD[field] for field in BIB_FIELDS])
		self.an_field.SetSelection(0)
		self.current_type = TYPE_NAME[self.an_type.GetStringSelection()]
		self.__set_settings()

	def __do_layout(self):
		# begin wxGlade: AnonymousDialog.__do_layout
		sizer_27 = wx.BoxSizer(wx.VERTICAL)
		sizer_28 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_29 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_30 = wx.BoxSizer(wx.VERTICAL)
		sizer_29.Add(self.an_type, 0, wx.EXPAND, 0)
		sizer_30.Add(self.an_replace, 0, 0, 0)
		sizer_30.Add(self.an_field, 0, wx.ALL, 20)
		sizer_30.Add(self.an_text, 0, wx.ALL, 20)
		sizer_29.Add(sizer_30, 1, wx.EXPAND, 0)
		sizer_27.Add(sizer_29, 1, wx.EXPAND, 0)
		sizer_27.Add(self.static_line_3, 0, wx.EXPAND, 0)
		sizer_28.Add(self.an_Cancel, 0, wx.ALL, 5)
		sizer_28.Add(self.an_OK, 0, wx.ALL, 5)
		sizer_27.Add(sizer_28, 0, wx.ALIGN_RIGHT, 0)
		self.SetSizer(sizer_27)
		sizer_27.Fit(self)
		self.Layout()
		self.Centre()
		# end wxGlade

	def __set_evt(self):
		wx.EVT_RADIOBOX(self,self.an_replace.GetId(),self.__on_an_replace)
		wx.EVT_LISTBOX(self,self.an_type.GetId(),self.__on_type)
		wx.EVT_BUTTON(self,wx.ID_OK,self.OnOK)

	def __on_an_replace(self,evt):
		self.an_field.Enable(False)
		self.an_text.Enable(False)
		if self.an_replace.GetSelection() == 1:
			self.an_field.Enable(True)
		elif self.an_replace.GetSelection() == 2:
			self.an_text.Enable(True)

	def __set_settings(self):
		"""Set the settings according to the current selected type"""
		self.an_replace.SetSelection(self.settings[self.current_type]['type'])
		self.an_field.SetStringSelection(NAME_FIELD[self.settings[self.current_type]['field']])
		self.an_text.SetValue(self.settings[self.current_type]['string'])

	def __save_settings(self):
		"""Save the settings before displaying the values for the new selected type"""
		self.settings[self.current_type]['type'] = self.an_replace.GetSelection()
		self.settings[self.current_type]['field'] = BIB_FIELDS[self.an_field.GetSelection()]
		self.settings[self.current_type]['string'] = self.an_text.GetValue()
		self.current_type = TYPE_NAME[self.an_type.GetStringSelection()]	# keep a reference to the currently selected type
		self.__set_settings()

	def __on_type(self,evt):
		self.__save_settings()

	def OnOK(self,evt):
		self.__save_settings()
		self.EndModal(wx.ID_OK)

# end of class AnonymousDialog


