//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/FromCore/ItemizeSimulation.h
//! @brief     Defines namespace GUI::Model::ObjectBuilder
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_FROMCORE_ITEMIZESIMULATION_H
#define BORNAGAIN_GUI_MODEL_FROMCORE_ITEMIZESIMULATION_H

class SimulationOptionsItem;
class ISimulation;
class InstrumentModel;

//! Contains set of methods to populate GUI models with content from domain.

namespace GUI::FromCore {

InstrumentModel* itemizeInstruments(const ISimulation& simulation);

SimulationOptionsItem* itemizeOptions(const ISimulation& simulation);

} // namespace GUI::FromCore

#endif // BORNAGAIN_GUI_MODEL_FROMCORE_ITEMIZESIMULATION_H
