/****************************************************************************
 *    lib/c/Constraint.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Constraint.h"

using namespace C;

Constraint::Constraint(Variable* left_var, Variable* right_var, string* text, string* type) {
	init(text, type);
	vars_.push_back(left_var);
	vars_.push_back(right_var);
}

Constraint::Constraint(Variable* var, string* text, string* type) {
	init(text, type);
	vars_.push_back(var);
}

Constraint::Constraint(string* text, string* type) {
	init(text, type);
}

void Constraint::init(string* text, string* type) {
	vars_ = vector<Variable*>();
	text_ = *text;
	delete text;
	if(type) {
		type_ = *type;
		delete type;
	}
}

Constraint::~Constraint () {
	for(vector<Variable*>::iterator n = vars_.begin(); n != vars_.end(); ++n) {
		delete *n;
	}
}

/**
 * @return vector<Variable*>
 */
set<Variable*>* Constraint::getVariables ( ) {
	set<Variable*>* vars = new set<Variable*>();
	
	for(vector<Variable*>::iterator n = vars_.begin(); n != vars_.end(); ++n) {
		Variable* var = *n;
		
		vars->insert(var);
	}
	
	return vars;
}

string Constraint::getText() {
	return text_;
}

string Constraint::getType() {
	return type_;
}


void Constraint::merge(Constraint* constraint, string* type) {
	text_ += constraint->getText();
	vars_.insert(vars_.begin(), constraint->getVariables()->begin(), constraint->getVariables()->end());
	if(type) type_ = *type;
}

void Constraint::merge(string* text, Variable* var, string* type) {
	text_ += *text;
	vars_.push_back(var);
	if(type) type_ = *type;
}

void Constraint::merge(string* text, string* type) {
	text_ += *text;
	if(type) type_ = *type;
}

void Constraint::mergeLeft(string* text, Variable* var, string* type) {
	text_ = *text + text_;
	vars_.push_back(var);
	if(type) type_ = *type;
}

void Constraint::mergeLeft(string* text, string* type) {
	text_ = *text + text_;
	if(type) type_ = *type;
}

string Constraint::print(Printer* p) {
	return text_;
}
