/* Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com */
package com.db4odoc.Storage;

import com.db4o.internal.caching.*;
import com.db4o.io.*;

public class FullLRUCachingStorage extends CachingStorage {

	private int _pageCount = 64;
	
	public FullLRUCachingStorage(Storage storage) {
		super(storage);
	}
	
	public FullLRUCachingStorage(Storage storage, int pageCount, int pageSize) {
		super(storage, pageCount, pageSize);
		_pageCount = pageCount;
	}
	
	@Override
	protected Cache4<Object, Object> newCache() {
		// for a simple LRU algorythm use CacheFactory.newLRUCache(_pageCount);
	    return CacheFactory.new2QXCache(_pageCount);
    }

}
