C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      INTEGER FUNCTION WV2DPPP(ISEC2, ISEC4, NLONS, NLATS, STEP,
     X                         OLDWAVE, NEWWAVE, NORTH, WEST, PMISS)
C
C---->
C*****WV2DPPP*
C
C     PURPOSE
C     -------
C
C     Interface routine to call WV2DINT using (inconsistent)
C     GRIB headers in 2D wave spectra fields.
C
C
C     INTERFACE
C     ---------
C
C     IRET = WV2DPPP(ISEC2, ISEC4, NLONS, NLATS, STEP,
C    X               OLDWAVE, NEWWAVE, NORTH, WEST, PMISS)
C
C     Input arguments
C     ---------------
C
C     ISEC2   - Unpacked section 2 header from 2D wave spectra field
C     ISEC4   - Unpacked section 4 header from 2D wave spectra field
C     NLONS   - Number of points E-W in new grid
C     NLATS   - Number of points N-S in new grid
C     STEP    - Output grid resolution (degrees)
C     OLDWAVE - Original wave field
C     NORTH   - Output grid northernmost latitude (degrees)
C     WEST    - Output grid westernmost longitude (degrees)
C     PMISS   - Missing data value 
C
C     Output arguments
C     ----------------

C     NEWWAVE - New wave field
C
C     Function returns 0 if the interpolation was OK.
C
C
C     METHOD
C     ------
C
C     Setes up call to WV2DINT from 2D wave spectra field headers.
C
C
C     EXTERNALS
C     ---------
C
C     None.
C
C
C     REFERENCE
C     ---------
C
C     None.
C
C
C     Author.
C     -------
C
C     J.D.Chambers      ECMWF    November 1996
C
C
C----<
C
      IMPLICIT NONE
C
C     Subroutine arguments
C
      INTEGER ISEC2, ISEC4, NLONS, NLATS
      DIMENSION ISEC2(*), ISEC4(*)
      REAL STEP, OLDWAVE, NEWWAVE, NORTH, WEST, PMISS
      DIMENSION OLDWAVE(*), NEWWAVE(*)
C
C     Parameters
C
      INTEGER JPROUTINE, JPMXLAT
      PARAMETER (JPROUTINE = 19420)
      PARAMETER (JPMXLAT = 361)
C
C     Local arguments
C
      INTEGER NSPEC, MISSLAT, LOOP, NPTS, NUMLATS
      DIMENSION NPTS(JPMXLAT)
C
C     Externals
C
      INTEGER WV2DINT
      EXTERNAL WV2DINT
C
C ---------------------------------------------------------------------
C*    Section 1. Initalisation.
C ---------------------------------------------------------------------
C
  100 CONTINUE
C
      WV2DPPP = 0
C
C     Setup number of spectra at each point
C
      IF( ISEC4(8).EQ.64 ) THEN
        NSPEC = ISEC4(50)*ISEC4(51)
      ELSE
        NSPEC = 1
      ENDIF
C
C     Calculate number of latitudes if grid had been full from
C     North pole to South pole
C
      NUMLATS = (180000/ISEC2(10)) + 1
      IF( NUMLATS.GT.JPMXLAT ) THEN
        WV2DPPP = JPROUTINE + 1
        GOTO 900
      ENDIF
C
C     Fill an array with the number of points at each latitude
C     (this is a reduced latitude/longitude grid)
C
      MISSLAT = (90000 - ISEC2(4))/ISEC2(10)
      DO LOOP = 1, MISSLAT
        NPTS(LOOP) = 0
      ENDDO
      DO LOOP = 1, ISEC2(3)
        NPTS(LOOP+MISSLAT) = ISEC2(22+LOOP)
      ENDDO
      DO LOOP = MISSLAT+ISEC2(3), NUMLATS
        NPTS(LOOP) = 0
      ENDDO
C
C ---------------------------------------------------------------------
C*    Section 2. Do the interpolation.
C ---------------------------------------------------------------------
C
  200 CONTINUE
C
      WV2DPPP = WV2DINT(NUMLATS,NPTS,NLONS,NLATS,STEP,OLDWAVE,
     X                  NEWWAVE,NORTH,WEST,NSPEC,PMISS)
C
C ---------------------------------------------------------------------
C*    Section 9. Closedown.
C ---------------------------------------------------------------------
C
  900 CONTINUE
      RETURN
      END
