/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright (C) CNRS, INRIA, Université Bordeaux 1, Telecom SudParis
 * See COPYING in top-level directory.
 */

#ifndef __STDIO_EV_CODES_H__
#define __STDIO_EV_CODES_H__

#include "ev_codes.h"

#define EZTRACE_STDIO_EVENTS_ID SYSTEM_MODULE_ID(0x03)
#define EZTRACE_STDIO_PREFIX    GENERATE_SYSTEM_MODULE_PREFIX(EZTRACE_STDIO_EVENTS_ID)

#define EZTRACE_STDIO_READ_START     (EZTRACE_STDIO_PREFIX | 0X0110)
#define EZTRACE_STDIO_PREAD_START    (EZTRACE_STDIO_PREFIX | 0X0120)
#define EZTRACE_STDIO_READV_START    (EZTRACE_STDIO_PREFIX | 0X0130)
#define EZTRACE_STDIO_FREAD_START    (EZTRACE_STDIO_PREFIX | 0X0140)

#define EZTRACE_STDIO_WRITE_START    (EZTRACE_STDIO_PREFIX | 0X0210)
#define EZTRACE_STDIO_PWRITE_START   (EZTRACE_STDIO_PREFIX | 0X0220)
#define EZTRACE_STDIO_WRITEV_START   (EZTRACE_STDIO_PREFIX | 0X0230)
#define EZTRACE_STDIO_FWRITE_START   (EZTRACE_STDIO_PREFIX | 0X0240)

#define EZTRACE_STDIO_SELECT_START   (EZTRACE_STDIO_PREFIX | 0X0310)
#define EZTRACE_STDIO_PSELECT_START  (EZTRACE_STDIO_PREFIX | 0X0320)
#define EZTRACE_STDIO_LSEEK_START    (EZTRACE_STDIO_PREFIX | 0X0330)
#define EZTRACE_STDIO_POLL_START     (EZTRACE_STDIO_PREFIX | 0X0340)
#define EZTRACE_STDIO_PPOLL_START    (EZTRACE_STDIO_PREFIX | 0X0350)

#define EZTRACE_STDIO_READ_STOP      (EZTRACE_STDIO_PREFIX | 0X0111)
#define EZTRACE_STDIO_PREAD_STOP     (EZTRACE_STDIO_PREFIX | 0X0121)
#define EZTRACE_STDIO_READV_STOP     (EZTRACE_STDIO_PREFIX | 0X0131)
#define EZTRACE_STDIO_FREAD_STOP     (EZTRACE_STDIO_PREFIX | 0X0141)

#define EZTRACE_STDIO_WRITE_STOP     (EZTRACE_STDIO_PREFIX | 0X0211)
#define EZTRACE_STDIO_PWRITE_STOP    (EZTRACE_STDIO_PREFIX | 0X0221)
#define EZTRACE_STDIO_WRITEV_STOP    (EZTRACE_STDIO_PREFIX | 0X0231)
#define EZTRACE_STDIO_FWRITE_STOP    (EZTRACE_STDIO_PREFIX | 0X0241)

#define EZTRACE_STDIO_SELECT_STOP    (EZTRACE_STDIO_PREFIX | 0X0311)
#define EZTRACE_STDIO_PSELECT_STOP   (EZTRACE_STDIO_PREFIX | 0X0321)
#define EZTRACE_STDIO_LSEEK_STOP     (EZTRACE_STDIO_PREFIX | 0X0331)
#define EZTRACE_STDIO_POLL_STOP      (EZTRACE_STDIO_PREFIX | 0X0341)
#define EZTRACE_STDIO_PPOLL_STOP     (EZTRACE_STDIO_PREFIX | 0X0351)

#endif	/* __STDIO_EV_CODES_H__ */
