# Simple cmake file to find and configure imgui
# Should be part of the libimgui-dev package
# Author: Francois Mazen <mzf@debian.org>


add_library(imgui::imgui INTERFACE IMPORTED)

find_path(imgui_INCLUDE_DIR NAMES imgui.h HINTS "/usr/include/imgui/" REQUIRED)
find_package_handle_standard_args(imgui DEFAULT_MSG imgui_INCLUDE_DIR)
set_property(TARGET imgui::imgui APPEND PROPERTY INTERFACE_INCLUDE_DIRECTORIES ${imgui_INCLUDE_DIR})

find_library(imgui_STATIC_LIB_PATH NAMES libimgui.a REQUIRED)
find_library(stb_LIB_PATH NAMES libstb.so REQUIRED)
find_package_handle_standard_args(imgui DEFAULT_MSG imgui_STATIC_LIB_PATH stb_LIB_PATH)
set_property(TARGET imgui::imgui APPEND PROPERTY INTERFACE_LINK_LIBRARIES ${imgui_STATIC_LIB_PATH} ${stb_LIB_PATH})
