/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fannj;

import com.googlecode.fannj.ActivationFunction;

public class Neuron {
    public static final ActivationFunction DEFAULT_ACTIVATION_FUNCTION = ActivationFunction.FANN_SIGMOID_STEPWISE;
    public static final float DEFAULT_ACTIVATION_STEEPNESS = 0.5f;
    ActivationFunction activationFunction;
    float steepness;

    public Neuron() {
        this(DEFAULT_ACTIVATION_FUNCTION);
    }

    public Neuron(ActivationFunction activationFunction) {
        this(activationFunction, 0.5f);
    }

    public Neuron(ActivationFunction activationFunction, float steepness) {
        if (activationFunction == null) {
            throw new IllegalArgumentException("activationFunction is null");
        }
        this.activationFunction = activationFunction;
        this.steepness = steepness;
    }

    public float getSteepness() {
        return this.steepness;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activationFunction == null ? 0 : this.activationFunction.hashCode());
        result = 31 * result + Float.floatToIntBits(this.steepness);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Neuron other = (Neuron)obj;
        if (this.activationFunction == null ? other.activationFunction != null : !this.activationFunction.equals((Object)other.activationFunction)) {
            return false;
        }
        return Float.floatToIntBits(this.steepness) == Float.floatToIntBits(other.steepness);
    }
}

