/* $Id: PhysicalType.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PHYSICAL_TYPE_HPP_INCLUDED
#define __PHYSICAL_TYPE_HPP_INCLUDED

#include <list>
#include "frontend/ast/TypeDeclaration.hpp"
#include "frontend/ast/PhysicalTypeUnit.hpp"
#include "frontend/ast/DiscreteRange.hpp"

namespace ast {

//! VHDL physical type definition.
/** This class represents one VHDL physical type definition. 
 */
class PhysicalType : public TypeDeclaration {
public:
	//! c'tor
	/** @param declName name of the declared type.
          * @param constraint range constrained of the type.
          * @param assocUnits list of associated units 
	  *        (primary + secondaries).
          * @param loc location of the declaration.
          */
	PhysicalType(
		std::string *declName,
		DiscreteRange *range,
		std::list<PhysicalTypeUnit*> *assocUnits,
		Location loc
	);

	//! Accept a Visitor.
	//
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << "Physical Type " << *this->name;
		if (this->constraint) {
			stream << ' ' << this->constraint;
		}
	}


	/** range constraint of the type */
	DiscreteRange *constraint;
	/** List of registered units (primary unit first) */
	std::list<PhysicalTypeUnit*> *units;

protected:
	/** Destructor */
	virtual ~PhysicalType();
};

}; /* namespace ast */

#endif /* __PHYSICAL_TYPE_HPP_INCLUDED */
