/* $Id: SimplifyExpressions.hpp 4824 2009-10-16 16:02:26Z potyra $ 
 * 
 * SimplifyExpressions: simplify nested expressions to simple expressions.
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIMPLIFY_EXPRESSION_HPP_INCLUDED
#define __SIMPLIFY_EXPRESSION_HPP_INCLUDED

#include "frontend/visitor/TopDownVisitor.hpp"
#include <list>

namespace ast {

/** Simplify nested Expressions to simple Expressions 
 *  Dependencies: 
 *      TransformSigAssign
 */
class SimplifyExpressions : public TopDownVisitor {
public:
	/** c'tor */
	SimplifyExpressions() : simpleSeqs(std::list<SeqStat*>()),
				repexp(NULL) {}
	
private:
	/** Visit a Process node.
	 *  @param node Process node that get's visited.
	 */
	virtual void visit(Process &node);

	/** Visit a VarAssignStat
	 *  @param node VarAssignStat node that get's visited.
	 */
	virtual void visit(VarAssignStat &node);

	/** Visit a SigAssignStat
	 *  @param node SigAssignStat node that get's visited.
	 */
	virtual void visit(SigAssignStat &node);

	/** Visit a CondalSigAssign node.
	 *  @param node CondalSigAssign node that get's visited.
	 */
	virtual void visit(CondalSigAssign &node);

	/** Visit a FunctionCall.
	 *  @param node FunctionCall node that get's visited.
	 */
	virtual void visit(FunctionCall &node);

	/** replace Expression with current replacement Expression,
	 *  if set.
	 *  @param e Expression to be eventually replaced.
	 */
	void setNode(Expression *&e);

	/** generate a temporary variable.
	 *  @param type type of the temporary.
	 *  @param name name (prefix) of the variable
	 *  @param suffix suffix of the variable (optional).
	 *  @return name referring to the generated variable.
	 */
	SimpleName *genTemporary(
		SubtypeIndication *type,
		std::string name, 
		const char *suffix);

	/** List with simplified sequential statements to add before node.
	 *  This list will get added before the currently traversed sequential
	 *  statement.
	 */
	std::list<SeqStat *> simpleSeqs;

	/** simplifed Expression to replace the currently traversed
	 *  Expression.
	 */
	Expression *repexp;
};

} /* namespace ast */

#endif /* __SIMPLIFY_EXPRESSION_HPP_INCLUDED */
