# Geoclue Stumbler

Copyright (C) 2024, Chris Talbot

<div align="center">
  <img src="https://gitlab.com/kop316/geoclue-stumbler/-/raw/main/data/metainfo/screenshot.png?inline=false" width="200" >
  <img src="https://gitlab.com/kop316/geoclue-stumbler/-/raw/main/data/metainfo/screenshot2.png?inline=false" width="200" >
  <img src="https://gitlab.com/kop316/geoclue-stumbler/-/raw/main/data/metainfo/screenshot3.png?inline=false" width="200" >
  <img src="https://gitlab.com/kop316/geoclue-stumbler/-/raw/main/data/metainfo/screenshot4.png?inline=false" width="200" >
</div>

## About
[Geoclue](https://gitlab.freedesktop.org/geoclue/geoclue) has the ability
(assuming the hardware is supported) to collect Cell tower and WiFi Access Point
(AP) location data and submit the data to an
[Ichnaea](https://ichnaea.readthedocs.io/en/latest/api/geosubmit2.html)
compatible server (e.g. [beaconDB](https://beacondb.net/)). However, geoclue only
collects/submits data if and only if a client is actively connected to geoclue.

Geoclue Stumbler is geoclue client in GTK4/Libadwaita. While running, it ensures
geoclue is active to submit cell tower/WiFi Access point data, provides the user
feedback on if geoclue can submit data.

The user also has an option to show the path of that user has been on during
active collection/submission. It will show various statistics (distance travelled,
average speed, and current speed) and gives the user the option of saving
their path as a GPX file.

If the user desires, Geoclue Stumbler also can act as an HTTP-Proxy for Geoclue.
This way, the user can review the submission files (located in `~/.local/share/geoclue_stumbler/submissions/`)
to make sure they are not leaking any sensitive data (and are not leaking their
location near real time to the submission URL). Note that  *No data leaves your device with out you explicitly sending it*

## Setting up geoclue with BeaconDB

Please read [here](https://gitlab.com/kop316/geoclue-stumbler/-/wikis/home#how-can-i-set-up-geoclue-with-beacondb).

## License
Unless otherwise specified, all code is licensed under the
[GPL Version 3 or later](https://www.gnu.org/licenses/gpl-3.0.en.html), and all
other images/data is licensed under  Creative Commons
Attribution-ShareAlike 4.0 International [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).

Path Marker Logo from [GNOME Maps](https://apps.gnome.org/Maps/) and is licensed under [GPL 2+](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html).

Map Marker Logo from [libshumate](https://gitlab.gnome.org/GNOME/libshumate/) and is licensed under [LGPL 2.1+](https://www.gnu.org/licenses/old-licenses/lgpl-2.1.html).

Icon from Yann Couturier and is licensed under Creative Commons Attribution 4.0 International
[CC BY 4.0](https://creativecommons.org/licenses/by/4.0/).

### Install dependencies

On a Debian based system run

``` bash
    sudo apt-get -y install build-essential
    sudo apt-get -y build-dep .
```

For an explicit list of dependencies, check the Build-Depends entry in the
[debian/control](https://gitlab.com/kop316/gtk-meshtastic-client/-/blob/main/debian/control)
file or the .gitlab-ci.yml file.

## Build Debian Package

After installing the dependencies, simply run

``` bash
    dpkg-buildpackage -B
```

## Compiling Geoclue Stumbler
In order to compile Geoclue Stumbler you need following software packages:

- GCC compiler
- GTK4 library
- libadwaita
- libgeoclue


## Installing Geoclue Stumbler
Build tools requirements

When building and testing directly from the repository it is important to
have at least meson version 0.56 or later installed. In addition, some
supported Meson backend is required (e.g. ninja).

To prepare/configure the project for compilation:

``` bash
    meson setup _build
```

However, if you want to install it, run

``` bash
    meson setup _build -Dprefix=/usr --sysconfdir=/etc
```

`--sysconfdir=/etc` will install the autostart file in the correct place, and
`-Dprefix=/usr` installs `Geoclue Stumbler` in `/usr/bin/` rather than `/usr/local/bin`

To build the project:

``` bash
    meson compile -C _build
```

Install (may require sudo or root privileges):

``` bash
    meson install -C _build
```

Uninstall (may require sudo or root privileges):

``` bash
    ninja uninstall -C _build/
```

## Note to packagers

`Geoclue Stumbler` has an accompanying http proxy to allow the app to cache
geoclue submissions and upload them at a later time. To make this work seamlessly,
you will need to do two things.

1. Install the [systemd user service](https://gitlab.com/kop316/geoclue-stumbler/-/blob/main/debian/geoclue-stumbler.user.service?ref_type=heads)
2. Install the [geoclue conf.d file](https://gitlab.com/kop316/geoclue-stumbler/-/blob/main/debian/conf.d/99-geoclue-stumbler.conf?ref_type=heads)

The systemd user service makes sure that the proxy is always on, and the conf.d
file turns on geoclue submission and points it to the proxy (*No data leaves your device with this configuration*).

While this isn't strictly necessary (as Geoclue will still submit data without
this), the statistics page will be useless without the http proxy.

## Running from within the source code repository
Meson will build the binary in builddir (_build, using the examples above), and
can be invoked directly.

Run with debugging
``` bash
    ./_build/src/Geoclue Stumbler -d
```
