// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package backupstorageiface provides an interface to enable mocking the AWS Backup Storage service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package backupstorageiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/backupstorage"
)

// BackupStorageAPI provides an interface to enable mocking the
// backupstorage.BackupStorage service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Backup Storage.
//	func myFunc(svc backupstorageiface.BackupStorageAPI) bool {
//	    // Make svc.DeleteObject request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := backupstorage.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockBackupStorageClient struct {
//	    backupstorageiface.BackupStorageAPI
//	}
//	func (m *mockBackupStorageClient) DeleteObject(input *backupstorage.DeleteObjectInput) (*backupstorage.DeleteObjectOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockBackupStorageClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type BackupStorageAPI interface {
	DeleteObject(*backupstorage.DeleteObjectInput) (*backupstorage.DeleteObjectOutput, error)
	DeleteObjectWithContext(aws.Context, *backupstorage.DeleteObjectInput, ...request.Option) (*backupstorage.DeleteObjectOutput, error)
	DeleteObjectRequest(*backupstorage.DeleteObjectInput) (*request.Request, *backupstorage.DeleteObjectOutput)

	GetChunk(*backupstorage.GetChunkInput) (*backupstorage.GetChunkOutput, error)
	GetChunkWithContext(aws.Context, *backupstorage.GetChunkInput, ...request.Option) (*backupstorage.GetChunkOutput, error)
	GetChunkRequest(*backupstorage.GetChunkInput) (*request.Request, *backupstorage.GetChunkOutput)

	GetObjectMetadata(*backupstorage.GetObjectMetadataInput) (*backupstorage.GetObjectMetadataOutput, error)
	GetObjectMetadataWithContext(aws.Context, *backupstorage.GetObjectMetadataInput, ...request.Option) (*backupstorage.GetObjectMetadataOutput, error)
	GetObjectMetadataRequest(*backupstorage.GetObjectMetadataInput) (*request.Request, *backupstorage.GetObjectMetadataOutput)

	ListChunks(*backupstorage.ListChunksInput) (*backupstorage.ListChunksOutput, error)
	ListChunksWithContext(aws.Context, *backupstorage.ListChunksInput, ...request.Option) (*backupstorage.ListChunksOutput, error)
	ListChunksRequest(*backupstorage.ListChunksInput) (*request.Request, *backupstorage.ListChunksOutput)

	ListChunksPages(*backupstorage.ListChunksInput, func(*backupstorage.ListChunksOutput, bool) bool) error
	ListChunksPagesWithContext(aws.Context, *backupstorage.ListChunksInput, func(*backupstorage.ListChunksOutput, bool) bool, ...request.Option) error

	ListObjects(*backupstorage.ListObjectsInput) (*backupstorage.ListObjectsOutput, error)
	ListObjectsWithContext(aws.Context, *backupstorage.ListObjectsInput, ...request.Option) (*backupstorage.ListObjectsOutput, error)
	ListObjectsRequest(*backupstorage.ListObjectsInput) (*request.Request, *backupstorage.ListObjectsOutput)

	ListObjectsPages(*backupstorage.ListObjectsInput, func(*backupstorage.ListObjectsOutput, bool) bool) error
	ListObjectsPagesWithContext(aws.Context, *backupstorage.ListObjectsInput, func(*backupstorage.ListObjectsOutput, bool) bool, ...request.Option) error

	NotifyObjectComplete(*backupstorage.NotifyObjectCompleteInput) (*backupstorage.NotifyObjectCompleteOutput, error)
	NotifyObjectCompleteWithContext(aws.Context, *backupstorage.NotifyObjectCompleteInput, ...request.Option) (*backupstorage.NotifyObjectCompleteOutput, error)
	NotifyObjectCompleteRequest(*backupstorage.NotifyObjectCompleteInput) (*request.Request, *backupstorage.NotifyObjectCompleteOutput)

	PutChunk(*backupstorage.PutChunkInput) (*backupstorage.PutChunkOutput, error)
	PutChunkWithContext(aws.Context, *backupstorage.PutChunkInput, ...request.Option) (*backupstorage.PutChunkOutput, error)
	PutChunkRequest(*backupstorage.PutChunkInput) (*request.Request, *backupstorage.PutChunkOutput)

	PutObject(*backupstorage.PutObjectInput) (*backupstorage.PutObjectOutput, error)
	PutObjectWithContext(aws.Context, *backupstorage.PutObjectInput, ...request.Option) (*backupstorage.PutObjectOutput, error)
	PutObjectRequest(*backupstorage.PutObjectInput) (*request.Request, *backupstorage.PutObjectOutput)

	StartObject(*backupstorage.StartObjectInput) (*backupstorage.StartObjectOutput, error)
	StartObjectWithContext(aws.Context, *backupstorage.StartObjectInput, ...request.Option) (*backupstorage.StartObjectOutput, error)
	StartObjectRequest(*backupstorage.StartObjectInput) (*request.Request, *backupstorage.StartObjectOutput)
}

var _ BackupStorageAPI = (*backupstorage.BackupStorage)(nil)
