// Copyright 2018 The go-libvirt Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Code generated by internal/lvgen/generate.go. DO NOT EDIT.
//
// To regenerate, run 'go generate' in internal/lvgen.
//

package constants

// These are libvirt procedure numbers which correspond to each respective
// API call between remote_internal driver and libvirtd. Each procedure is
// identified by a unique number.
const (
	// From enums:
	// QEMUProcDomainMonitorCommand is libvirt's QEMU_PROC_DOMAIN_MONITOR_COMMAND
	QEMUProcDomainMonitorCommand = 1
	// QEMUProcDomainAttach is libvirt's QEMU_PROC_DOMAIN_ATTACH
	QEMUProcDomainAttach = 2
	// QEMUProcDomainAgentCommand is libvirt's QEMU_PROC_DOMAIN_AGENT_COMMAND
	QEMUProcDomainAgentCommand = 3
	// QEMUProcConnectDomainMonitorEventRegister is libvirt's QEMU_PROC_CONNECT_DOMAIN_MONITOR_EVENT_REGISTER
	QEMUProcConnectDomainMonitorEventRegister = 4
	// QEMUProcConnectDomainMonitorEventDeregister is libvirt's QEMU_PROC_CONNECT_DOMAIN_MONITOR_EVENT_DEREGISTER
	QEMUProcConnectDomainMonitorEventDeregister = 5
	// QEMUProcDomainMonitorEvent is libvirt's QEMU_PROC_DOMAIN_MONITOR_EVENT
	QEMUProcDomainMonitorEvent = 6
	// QEMUProcDomainMonitorCommandWithFiles is libvirt's QEMU_PROC_DOMAIN_MONITOR_COMMAND_WITH_FILES
	QEMUProcDomainMonitorCommandWithFiles = 7


	// From consts:
	// QEMUProgram is libvirt's QEMU_PROGRAM
	QEMUProgram = 0x20008087
	// QEMUProtocolVersion is libvirt's QEMU_PROTOCOL_VERSION
	QEMUProtocolVersion = 1
)
