// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/home/graph/v1/homegraph.proto

package graph

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request type for the
// [`RequestSyncDevices`](#google.home.graph.v1.HomeGraphApiService.RequestSyncDevices)
// call.
type RequestSyncDevicesRequest struct {
	// Required. Third-party user ID.
	AgentUserId string `protobuf:"bytes,1,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	// Optional. If set, the request will be added to a queue and a response will
	// be returned immediately. This enables concurrent requests for the given
	// `agent_user_id`, but the caller will not receive any error responses.
	Async                bool     `protobuf:"varint,2,opt,name=async,proto3" json:"async,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RequestSyncDevicesRequest) Reset()         { *m = RequestSyncDevicesRequest{} }
func (m *RequestSyncDevicesRequest) String() string { return proto.CompactTextString(m) }
func (*RequestSyncDevicesRequest) ProtoMessage()    {}
func (*RequestSyncDevicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{0}
}

func (m *RequestSyncDevicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RequestSyncDevicesRequest.Unmarshal(m, b)
}
func (m *RequestSyncDevicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RequestSyncDevicesRequest.Marshal(b, m, deterministic)
}
func (m *RequestSyncDevicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestSyncDevicesRequest.Merge(m, src)
}
func (m *RequestSyncDevicesRequest) XXX_Size() int {
	return xxx_messageInfo_RequestSyncDevicesRequest.Size(m)
}
func (m *RequestSyncDevicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestSyncDevicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RequestSyncDevicesRequest proto.InternalMessageInfo

func (m *RequestSyncDevicesRequest) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

func (m *RequestSyncDevicesRequest) GetAsync() bool {
	if m != nil {
		return m.Async
	}
	return false
}

// Response type for the
// [`RequestSyncDevices`](#google.home.graph.v1.HomeGraphApiService.RequestSyncDevices)
// call.
//
// Intentionally empty upon success. An HTTP response code is returned
// with more details upon failure.
type RequestSyncDevicesResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RequestSyncDevicesResponse) Reset()         { *m = RequestSyncDevicesResponse{} }
func (m *RequestSyncDevicesResponse) String() string { return proto.CompactTextString(m) }
func (*RequestSyncDevicesResponse) ProtoMessage()    {}
func (*RequestSyncDevicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{1}
}

func (m *RequestSyncDevicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RequestSyncDevicesResponse.Unmarshal(m, b)
}
func (m *RequestSyncDevicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RequestSyncDevicesResponse.Marshal(b, m, deterministic)
}
func (m *RequestSyncDevicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestSyncDevicesResponse.Merge(m, src)
}
func (m *RequestSyncDevicesResponse) XXX_Size() int {
	return xxx_messageInfo_RequestSyncDevicesResponse.Size(m)
}
func (m *RequestSyncDevicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestSyncDevicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RequestSyncDevicesResponse proto.InternalMessageInfo

// Request type for the
// [`ReportStateAndNotification`](#google.home.graph.v1.HomeGraphApiService.ReportStateAndNotification)
// call. It may include states, notifications, or both. States and notifications
// are defined per `device_id` (for example, "123" and "456" in the following
// example).
// # Example
//
// ```json
// {
//   "requestId": "ff36a3cc-ec34-11e6-b1a0-64510650abcf",
//   "agentUserId": "1234",
//   "payload": {
//     "devices": {
//       "states": {
//         "123": {
//           "on": true
//         },
//         "456": {
//           "on": true,
//           "brightness": 10
//         }
//       },
//     }
//   }
// }
// ```
type ReportStateAndNotificationRequest struct {
	// Request ID used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Unique identifier per event (for example, a doorbell press).
	EventId string `protobuf:"bytes,4,opt,name=event_id,json=eventId,proto3" json:"event_id,omitempty"`
	// Required. Third-party user ID.
	AgentUserId string `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	// Token to maintain state in the follow up notification response.
	FollowUpToken string `protobuf:"bytes,5,opt,name=follow_up_token,json=followUpToken,proto3" json:"follow_up_token,omitempty"`
	// Required. State of devices to update and notification metadata for devices.
	Payload              *StateAndNotificationPayload `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *ReportStateAndNotificationRequest) Reset()         { *m = ReportStateAndNotificationRequest{} }
func (m *ReportStateAndNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*ReportStateAndNotificationRequest) ProtoMessage()    {}
func (*ReportStateAndNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{2}
}

func (m *ReportStateAndNotificationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportStateAndNotificationRequest.Unmarshal(m, b)
}
func (m *ReportStateAndNotificationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportStateAndNotificationRequest.Marshal(b, m, deterministic)
}
func (m *ReportStateAndNotificationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportStateAndNotificationRequest.Merge(m, src)
}
func (m *ReportStateAndNotificationRequest) XXX_Size() int {
	return xxx_messageInfo_ReportStateAndNotificationRequest.Size(m)
}
func (m *ReportStateAndNotificationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportStateAndNotificationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportStateAndNotificationRequest proto.InternalMessageInfo

func (m *ReportStateAndNotificationRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *ReportStateAndNotificationRequest) GetEventId() string {
	if m != nil {
		return m.EventId
	}
	return ""
}

func (m *ReportStateAndNotificationRequest) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

func (m *ReportStateAndNotificationRequest) GetFollowUpToken() string {
	if m != nil {
		return m.FollowUpToken
	}
	return ""
}

func (m *ReportStateAndNotificationRequest) GetPayload() *StateAndNotificationPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Response type for the
// [`ReportStateAndNotification`](#google.home.graph.v1.HomeGraphApiService.ReportStateAndNotification)
// call.
type ReportStateAndNotificationResponse struct {
	// Request ID copied from [ReportStateAndNotificationRequest][google.home.graph.v1.ReportStateAndNotificationRequest].
	RequestId            string   `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportStateAndNotificationResponse) Reset()         { *m = ReportStateAndNotificationResponse{} }
func (m *ReportStateAndNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*ReportStateAndNotificationResponse) ProtoMessage()    {}
func (*ReportStateAndNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{3}
}

func (m *ReportStateAndNotificationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportStateAndNotificationResponse.Unmarshal(m, b)
}
func (m *ReportStateAndNotificationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportStateAndNotificationResponse.Marshal(b, m, deterministic)
}
func (m *ReportStateAndNotificationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportStateAndNotificationResponse.Merge(m, src)
}
func (m *ReportStateAndNotificationResponse) XXX_Size() int {
	return xxx_messageInfo_ReportStateAndNotificationResponse.Size(m)
}
func (m *ReportStateAndNotificationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportStateAndNotificationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportStateAndNotificationResponse proto.InternalMessageInfo

func (m *ReportStateAndNotificationResponse) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Payload containing the state and notification information for devices.
type StateAndNotificationPayload struct {
	// The devices for updating state and sending notifications.
	Devices              *ReportStateAndNotificationDevice `protobuf:"bytes,1,opt,name=devices,proto3" json:"devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *StateAndNotificationPayload) Reset()         { *m = StateAndNotificationPayload{} }
func (m *StateAndNotificationPayload) String() string { return proto.CompactTextString(m) }
func (*StateAndNotificationPayload) ProtoMessage()    {}
func (*StateAndNotificationPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{4}
}

func (m *StateAndNotificationPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAndNotificationPayload.Unmarshal(m, b)
}
func (m *StateAndNotificationPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAndNotificationPayload.Marshal(b, m, deterministic)
}
func (m *StateAndNotificationPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAndNotificationPayload.Merge(m, src)
}
func (m *StateAndNotificationPayload) XXX_Size() int {
	return xxx_messageInfo_StateAndNotificationPayload.Size(m)
}
func (m *StateAndNotificationPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAndNotificationPayload.DiscardUnknown(m)
}

var xxx_messageInfo_StateAndNotificationPayload proto.InternalMessageInfo

func (m *StateAndNotificationPayload) GetDevices() *ReportStateAndNotificationDevice {
	if m != nil {
		return m.Devices
	}
	return nil
}

// The states and notifications specific to a device.
type ReportStateAndNotificationDevice struct {
	// States of devices to update. See the **Device STATES** section
	// of the individual trait [reference
	// guides](https://developers.google.com/assistant/smarthome/traits).
	States *_struct.Struct `protobuf:"bytes,1,opt,name=states,proto3" json:"states,omitempty"`
	// Notifications metadata for devices. See the **Device NOTIFICATIONS**
	// section of the individual trait [reference
	// guides](https://developers.google.com/assistant/smarthome/traits).
	Notifications        *_struct.Struct `protobuf:"bytes,2,opt,name=notifications,proto3" json:"notifications,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ReportStateAndNotificationDevice) Reset()         { *m = ReportStateAndNotificationDevice{} }
func (m *ReportStateAndNotificationDevice) String() string { return proto.CompactTextString(m) }
func (*ReportStateAndNotificationDevice) ProtoMessage()    {}
func (*ReportStateAndNotificationDevice) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{5}
}

func (m *ReportStateAndNotificationDevice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportStateAndNotificationDevice.Unmarshal(m, b)
}
func (m *ReportStateAndNotificationDevice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportStateAndNotificationDevice.Marshal(b, m, deterministic)
}
func (m *ReportStateAndNotificationDevice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportStateAndNotificationDevice.Merge(m, src)
}
func (m *ReportStateAndNotificationDevice) XXX_Size() int {
	return xxx_messageInfo_ReportStateAndNotificationDevice.Size(m)
}
func (m *ReportStateAndNotificationDevice) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportStateAndNotificationDevice.DiscardUnknown(m)
}

var xxx_messageInfo_ReportStateAndNotificationDevice proto.InternalMessageInfo

func (m *ReportStateAndNotificationDevice) GetStates() *_struct.Struct {
	if m != nil {
		return m.States
	}
	return nil
}

func (m *ReportStateAndNotificationDevice) GetNotifications() *_struct.Struct {
	if m != nil {
		return m.Notifications
	}
	return nil
}

// Request type for the
// [`DeleteAgentUser`](#google.home.graph.v1.HomeGraphApiService.DeleteAgentUser)
// call.
type DeleteAgentUserRequest struct {
	// Request ID used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. Third-party user ID.
	AgentUserId          string   `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAgentUserRequest) Reset()         { *m = DeleteAgentUserRequest{} }
func (m *DeleteAgentUserRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAgentUserRequest) ProtoMessage()    {}
func (*DeleteAgentUserRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{6}
}

func (m *DeleteAgentUserRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAgentUserRequest.Unmarshal(m, b)
}
func (m *DeleteAgentUserRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAgentUserRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAgentUserRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAgentUserRequest.Merge(m, src)
}
func (m *DeleteAgentUserRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAgentUserRequest.Size(m)
}
func (m *DeleteAgentUserRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAgentUserRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAgentUserRequest proto.InternalMessageInfo

func (m *DeleteAgentUserRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *DeleteAgentUserRequest) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

// Request type for the
// [`Query`](#google.home.graph.v1.HomeGraphApiService.Query) call.
type QueryRequest struct {
	// Request ID used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. Third-party user ID.
	AgentUserId string `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	// Required. Inputs containing third-party device IDs for which to
	// get the device states.
	Inputs               []*QueryRequestInput `protobuf:"bytes,3,rep,name=inputs,proto3" json:"inputs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *QueryRequest) Reset()         { *m = QueryRequest{} }
func (m *QueryRequest) String() string { return proto.CompactTextString(m) }
func (*QueryRequest) ProtoMessage()    {}
func (*QueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{7}
}

func (m *QueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryRequest.Unmarshal(m, b)
}
func (m *QueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryRequest.Marshal(b, m, deterministic)
}
func (m *QueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryRequest.Merge(m, src)
}
func (m *QueryRequest) XXX_Size() int {
	return xxx_messageInfo_QueryRequest.Size(m)
}
func (m *QueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryRequest proto.InternalMessageInfo

func (m *QueryRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *QueryRequest) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

func (m *QueryRequest) GetInputs() []*QueryRequestInput {
	if m != nil {
		return m.Inputs
	}
	return nil
}

// Device ID inputs to [QueryRequest][google.home.graph.v1.QueryRequest].
type QueryRequestInput struct {
	// Payload containing third-party device IDs.
	Payload              *QueryRequestPayload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *QueryRequestInput) Reset()         { *m = QueryRequestInput{} }
func (m *QueryRequestInput) String() string { return proto.CompactTextString(m) }
func (*QueryRequestInput) ProtoMessage()    {}
func (*QueryRequestInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{8}
}

func (m *QueryRequestInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryRequestInput.Unmarshal(m, b)
}
func (m *QueryRequestInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryRequestInput.Marshal(b, m, deterministic)
}
func (m *QueryRequestInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryRequestInput.Merge(m, src)
}
func (m *QueryRequestInput) XXX_Size() int {
	return xxx_messageInfo_QueryRequestInput.Size(m)
}
func (m *QueryRequestInput) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryRequestInput.DiscardUnknown(m)
}

var xxx_messageInfo_QueryRequestInput proto.InternalMessageInfo

func (m *QueryRequestInput) GetPayload() *QueryRequestPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Payload containing device IDs.
type QueryRequestPayload struct {
	// Third-party device IDs for which to get the device states.
	Devices              []*AgentDeviceId `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *QueryRequestPayload) Reset()         { *m = QueryRequestPayload{} }
func (m *QueryRequestPayload) String() string { return proto.CompactTextString(m) }
func (*QueryRequestPayload) ProtoMessage()    {}
func (*QueryRequestPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{9}
}

func (m *QueryRequestPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryRequestPayload.Unmarshal(m, b)
}
func (m *QueryRequestPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryRequestPayload.Marshal(b, m, deterministic)
}
func (m *QueryRequestPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryRequestPayload.Merge(m, src)
}
func (m *QueryRequestPayload) XXX_Size() int {
	return xxx_messageInfo_QueryRequestPayload.Size(m)
}
func (m *QueryRequestPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryRequestPayload.DiscardUnknown(m)
}

var xxx_messageInfo_QueryRequestPayload proto.InternalMessageInfo

func (m *QueryRequestPayload) GetDevices() []*AgentDeviceId {
	if m != nil {
		return m.Devices
	}
	return nil
}

// Third-party device ID for one device.
type AgentDeviceId struct {
	// Third-party device ID.
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AgentDeviceId) Reset()         { *m = AgentDeviceId{} }
func (m *AgentDeviceId) String() string { return proto.CompactTextString(m) }
func (*AgentDeviceId) ProtoMessage()    {}
func (*AgentDeviceId) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{10}
}

func (m *AgentDeviceId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AgentDeviceId.Unmarshal(m, b)
}
func (m *AgentDeviceId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AgentDeviceId.Marshal(b, m, deterministic)
}
func (m *AgentDeviceId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgentDeviceId.Merge(m, src)
}
func (m *AgentDeviceId) XXX_Size() int {
	return xxx_messageInfo_AgentDeviceId.Size(m)
}
func (m *AgentDeviceId) XXX_DiscardUnknown() {
	xxx_messageInfo_AgentDeviceId.DiscardUnknown(m)
}

var xxx_messageInfo_AgentDeviceId proto.InternalMessageInfo

func (m *AgentDeviceId) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Response type for the
// [`Query`](#google.home.graph.v1.HomeGraphApiService.Query) call.
// This should follow the same format as the Google smart home
// `action.devices.QUERY`
// [response](https://developers.google.com/assistant/smarthome/reference/intent/query).
// # Example
//
// ```json
// {
//   "requestId": "ff36a3cc-ec34-11e6-b1a0-64510650abcf",
//   "payload": {
//     "devices": {
//       "123": {
//         "on": true,
//         "online": true
//       },
//       "456": {
//         "on": true,
//         "online": true,
//         "brightness": 80,
//         "color": {
//           "name": "cerulean",
//           "spectrumRGB": 31655
//         }
//       }
//     }
//   }
// }
// ```
type QueryResponse struct {
	// Request ID used for debugging. Copied from the request.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Device states for the devices given in the request.
	Payload              *QueryResponsePayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *QueryResponse) Reset()         { *m = QueryResponse{} }
func (m *QueryResponse) String() string { return proto.CompactTextString(m) }
func (*QueryResponse) ProtoMessage()    {}
func (*QueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{11}
}

func (m *QueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResponse.Unmarshal(m, b)
}
func (m *QueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResponse.Marshal(b, m, deterministic)
}
func (m *QueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResponse.Merge(m, src)
}
func (m *QueryResponse) XXX_Size() int {
	return xxx_messageInfo_QueryResponse.Size(m)
}
func (m *QueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResponse proto.InternalMessageInfo

func (m *QueryResponse) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *QueryResponse) GetPayload() *QueryResponsePayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Payload containing device states information.
type QueryResponsePayload struct {
	// States of the devices. Map of third-party device ID to struct of device
	// states.
	Devices              map[string]*_struct.Struct `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *QueryResponsePayload) Reset()         { *m = QueryResponsePayload{} }
func (m *QueryResponsePayload) String() string { return proto.CompactTextString(m) }
func (*QueryResponsePayload) ProtoMessage()    {}
func (*QueryResponsePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{12}
}

func (m *QueryResponsePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResponsePayload.Unmarshal(m, b)
}
func (m *QueryResponsePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResponsePayload.Marshal(b, m, deterministic)
}
func (m *QueryResponsePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResponsePayload.Merge(m, src)
}
func (m *QueryResponsePayload) XXX_Size() int {
	return xxx_messageInfo_QueryResponsePayload.Size(m)
}
func (m *QueryResponsePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResponsePayload.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResponsePayload proto.InternalMessageInfo

func (m *QueryResponsePayload) GetDevices() map[string]*_struct.Struct {
	if m != nil {
		return m.Devices
	}
	return nil
}

// Request type for the [`Sync`](#google.home.graph.v1.HomeGraphApiService.Sync)
// call.
type SyncRequest struct {
	// Request ID used for debugging.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. Third-party user ID.
	AgentUserId          string   `protobuf:"bytes,2,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SyncRequest) Reset()         { *m = SyncRequest{} }
func (m *SyncRequest) String() string { return proto.CompactTextString(m) }
func (*SyncRequest) ProtoMessage()    {}
func (*SyncRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{13}
}

func (m *SyncRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SyncRequest.Unmarshal(m, b)
}
func (m *SyncRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SyncRequest.Marshal(b, m, deterministic)
}
func (m *SyncRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncRequest.Merge(m, src)
}
func (m *SyncRequest) XXX_Size() int {
	return xxx_messageInfo_SyncRequest.Size(m)
}
func (m *SyncRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SyncRequest proto.InternalMessageInfo

func (m *SyncRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *SyncRequest) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

// Response type for the
// [`Sync`](#google.home.graph.v1.HomeGraphApiService.Sync) call.
// This should follow the same format as the Google smart home
// `action.devices.SYNC`
// [response](https://developers.google.com/assistant/smarthome/reference/intent/sync).
// # Example
//
// ```json
// {
//   "requestId": "ff36a3cc-ec34-11e6-b1a0-64510650abcf",
//   "payload": {
//     "agentUserId": "1836.15267389",
//     "devices": [{
//       "id": "123",
//       "type": "action.devices.types.OUTLET",
//       "traits": [
//         "action.devices.traits.OnOff"
//       ],
//       "name": {
//         "defaultNames": ["My Outlet 1234"],
//         "name": "Night light",
//         "nicknames": ["wall plug"]
//       },
//       "willReportState": false,
//       "deviceInfo": {
//         "manufacturer": "lights-out-inc",
//         "model": "hs1234",
//         "hwVersion": "3.2",
//         "swVersion": "11.4"
//       },
//       "customData": {
//         "fooValue": 74,
//         "barValue": true,
//         "bazValue": "foo"
//       }
//     }]
//   }
// }
// ```
type SyncResponse struct {
	// Request ID used for debugging. Copied from the request.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Devices associated with the third-party user.
	Payload              *SyncResponsePayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SyncResponse) Reset()         { *m = SyncResponse{} }
func (m *SyncResponse) String() string { return proto.CompactTextString(m) }
func (*SyncResponse) ProtoMessage()    {}
func (*SyncResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{14}
}

func (m *SyncResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SyncResponse.Unmarshal(m, b)
}
func (m *SyncResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SyncResponse.Marshal(b, m, deterministic)
}
func (m *SyncResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncResponse.Merge(m, src)
}
func (m *SyncResponse) XXX_Size() int {
	return xxx_messageInfo_SyncResponse.Size(m)
}
func (m *SyncResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SyncResponse proto.InternalMessageInfo

func (m *SyncResponse) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *SyncResponse) GetPayload() *SyncResponsePayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Payload containing device information.
type SyncResponsePayload struct {
	// Third-party user ID
	AgentUserId string `protobuf:"bytes,1,opt,name=agent_user_id,json=agentUserId,proto3" json:"agent_user_id,omitempty"`
	// Devices associated with the third-party user.
	Devices              []*Device `protobuf:"bytes,2,rep,name=devices,proto3" json:"devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *SyncResponsePayload) Reset()         { *m = SyncResponsePayload{} }
func (m *SyncResponsePayload) String() string { return proto.CompactTextString(m) }
func (*SyncResponsePayload) ProtoMessage()    {}
func (*SyncResponsePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_7c06ecdbcb0515e5, []int{15}
}

func (m *SyncResponsePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SyncResponsePayload.Unmarshal(m, b)
}
func (m *SyncResponsePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SyncResponsePayload.Marshal(b, m, deterministic)
}
func (m *SyncResponsePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncResponsePayload.Merge(m, src)
}
func (m *SyncResponsePayload) XXX_Size() int {
	return xxx_messageInfo_SyncResponsePayload.Size(m)
}
func (m *SyncResponsePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncResponsePayload.DiscardUnknown(m)
}

var xxx_messageInfo_SyncResponsePayload proto.InternalMessageInfo

func (m *SyncResponsePayload) GetAgentUserId() string {
	if m != nil {
		return m.AgentUserId
	}
	return ""
}

func (m *SyncResponsePayload) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func init() {
	proto.RegisterType((*RequestSyncDevicesRequest)(nil), "google.home.graph.v1.RequestSyncDevicesRequest")
	proto.RegisterType((*RequestSyncDevicesResponse)(nil), "google.home.graph.v1.RequestSyncDevicesResponse")
	proto.RegisterType((*ReportStateAndNotificationRequest)(nil), "google.home.graph.v1.ReportStateAndNotificationRequest")
	proto.RegisterType((*ReportStateAndNotificationResponse)(nil), "google.home.graph.v1.ReportStateAndNotificationResponse")
	proto.RegisterType((*StateAndNotificationPayload)(nil), "google.home.graph.v1.StateAndNotificationPayload")
	proto.RegisterType((*ReportStateAndNotificationDevice)(nil), "google.home.graph.v1.ReportStateAndNotificationDevice")
	proto.RegisterType((*DeleteAgentUserRequest)(nil), "google.home.graph.v1.DeleteAgentUserRequest")
	proto.RegisterType((*QueryRequest)(nil), "google.home.graph.v1.QueryRequest")
	proto.RegisterType((*QueryRequestInput)(nil), "google.home.graph.v1.QueryRequestInput")
	proto.RegisterType((*QueryRequestPayload)(nil), "google.home.graph.v1.QueryRequestPayload")
	proto.RegisterType((*AgentDeviceId)(nil), "google.home.graph.v1.AgentDeviceId")
	proto.RegisterType((*QueryResponse)(nil), "google.home.graph.v1.QueryResponse")
	proto.RegisterType((*QueryResponsePayload)(nil), "google.home.graph.v1.QueryResponsePayload")
	proto.RegisterMapType((map[string]*_struct.Struct)(nil), "google.home.graph.v1.QueryResponsePayload.DevicesEntry")
	proto.RegisterType((*SyncRequest)(nil), "google.home.graph.v1.SyncRequest")
	proto.RegisterType((*SyncResponse)(nil), "google.home.graph.v1.SyncResponse")
	proto.RegisterType((*SyncResponsePayload)(nil), "google.home.graph.v1.SyncResponsePayload")
}

func init() {
	proto.RegisterFile("google/home/graph/v1/homegraph.proto", fileDescriptor_7c06ecdbcb0515e5)
}

var fileDescriptor_7c06ecdbcb0515e5 = []byte{
	// 1030 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0x97, 0x9d, 0x6d, 0xbb, 0x3b, 0x69, 0xd8, 0xdd, 0xe9, 0xd2, 0xba, 0x69, 0x50, 0xd3, 0x29,
	0xea, 0x66, 0x43, 0xb0, 0x69, 0x90, 0xba, 0x4b, 0x51, 0x91, 0xdc, 0x66, 0x05, 0xb9, 0xa0, 0x6e,
	0xb2, 0x95, 0x10, 0x12, 0x8a, 0xdc, 0x78, 0x9a, 0x58, 0x9b, 0x78, 0x5c, 0x7b, 0x12, 0x14, 0xa1,
	0x95, 0x10, 0x12, 0x27, 0x38, 0x20, 0xb8, 0xc2, 0x27, 0xe0, 0x23, 0x20, 0xf1, 0x01, 0xb8, 0x72,
	0xeb, 0x69, 0x0f, 0x9c, 0x38, 0xf0, 0x01, 0x38, 0xa1, 0xf9, 0x93, 0xd8, 0x49, 0xec, 0xc4, 0x2b,
	0x71, 0xf3, 0xcc, 0xfb, 0xf7, 0x7b, 0xef, 0xfd, 0xe6, 0x3d, 0x83, 0xb7, 0x3b, 0x84, 0x74, 0x7a,
	0xd8, 0xe8, 0x92, 0x3e, 0x36, 0x3a, 0xbe, 0xe5, 0x75, 0x8d, 0xe1, 0x21, 0x3f, 0xf1, 0x83, 0xee,
	0xf9, 0x84, 0x12, 0xf8, 0x40, 0x68, 0xe9, 0xec, 0x5e, 0x17, 0x82, 0xe1, 0x61, 0xbe, 0x20, 0x6d,
	0x2d, 0xcf, 0x31, 0x2c, 0xd7, 0x25, 0xd4, 0xa2, 0x0e, 0x71, 0x03, 0x61, 0x93, 0xdf, 0x8a, 0x48,
	0xdb, 0x3d, 0x07, 0xbb, 0x54, 0x0a, 0x76, 0x23, 0x82, 0x2b, 0x07, 0xf7, 0xec, 0xd6, 0x25, 0xee,
	0x5a, 0x43, 0x87, 0xf8, 0x52, 0x61, 0x3b, 0xa2, 0xe0, 0xe3, 0x80, 0x0c, 0xfc, 0x36, 0x96, 0xa2,
	0xbd, 0x58, 0xb8, 0x36, 0x1e, 0x3a, 0x13, 0x95, 0x1d, 0xa9, 0xc2, 0x4f, 0x97, 0x83, 0x2b, 0x03,
	0xf7, 0x3d, 0x3a, 0x92, 0xc2, 0xc2, 0xac, 0x30, 0xa0, 0xfe, 0xa0, 0x2d, 0x91, 0xa1, 0x16, 0xd8,
	0x6e, 0xe0, 0xeb, 0x01, 0x0e, 0x68, 0x73, 0xe4, 0xb6, 0x6b, 0xdc, 0x6b, 0x20, 0x6f, 0xe0, 0x43,
	0x90, 0xb3, 0x3a, 0xd8, 0xa5, 0xad, 0x41, 0x80, 0xfd, 0x96, 0x63, 0x6b, 0x4a, 0x51, 0x29, 0xdd,
	0x39, 0xcd, 0xbc, 0x32, 0xd5, 0x46, 0x96, 0x4b, 0x2e, 0x02, 0xec, 0xd7, 0x6d, 0xb8, 0x0d, 0x56,
	0xac, 0x60, 0xe4, 0xb6, 0x35, 0xb5, 0xa8, 0x94, 0x6e, 0x33, 0x05, 0xa5, 0x21, 0x6e, 0x50, 0x01,
	0xe4, 0xe3, 0x02, 0x04, 0x1e, 0x71, 0x03, 0x8c, 0xbe, 0x56, 0xc1, 0x5e, 0x03, 0x7b, 0xc4, 0xa7,
	0x4d, 0x6a, 0x51, 0x6c, 0xba, 0xf6, 0xa7, 0x84, 0x3a, 0x57, 0x4e, 0x9b, 0xd7, 0x75, 0x8c, 0xe3,
	0x2d, 0x00, 0x7c, 0xf1, 0x39, 0x01, 0xd1, 0xb8, 0x23, 0x6f, 0x78, 0xf4, 0xdb, 0x78, 0xc8, 0x60,
	0x3a, 0xb6, 0x76, 0x8b, 0x0b, 0xd7, 0xf8, 0xb9, 0x6e, 0xcf, 0x67, 0xa0, 0x26, 0x64, 0x70, 0x00,
	0xee, 0x5e, 0x91, 0x5e, 0x8f, 0x7c, 0xd9, 0x1a, 0x78, 0x2d, 0x4a, 0x5e, 0x60, 0x57, 0x5b, 0xe1,
	0xae, 0x72, 0xe2, 0xfa, 0xc2, 0x7b, 0xce, 0x2e, 0xe1, 0x39, 0x58, 0xf3, 0xac, 0x51, 0x8f, 0x58,
	0xb6, 0x96, 0x29, 0x2a, 0xa5, 0x6c, 0xf5, 0x50, 0x8f, 0x23, 0x8a, 0x1e, 0x97, 0xce, 0xb9, 0x30,
	0x14, 0xd1, 0xc7, 0x6e, 0xd0, 0x19, 0x40, 0x8b, 0x2a, 0x20, 0x0a, 0xb5, 0xa4, 0x04, 0x88, 0x80,
	0x9d, 0x05, 0x11, 0x19, 0x6a, 0x41, 0x98, 0x80, 0x9b, 0x66, 0xab, 0x47, 0xf1, 0xa8, 0x93, 0x81,
	0x88, 0xc6, 0x35, 0xc6, 0x6e, 0xd0, 0x8f, 0x0a, 0x28, 0x2e, 0xd3, 0x86, 0x06, 0x58, 0x0d, 0x98,
	0x74, 0x1c, 0x75, 0x6b, 0x1c, 0x75, 0xcc, 0x45, 0xbd, 0xc9, 0xb9, 0xd8, 0x90, 0x6a, 0xf0, 0x04,
	0xe4, 0xdc, 0x88, 0x9b, 0x80, 0xb7, 0x6b, 0x81, 0xdd, 0xb4, 0x36, 0xfa, 0x4e, 0x01, 0x9b, 0x35,
	0xdc, 0xc3, 0x14, 0x9b, 0xe3, 0xd6, 0xa6, 0xa4, 0x50, 0x23, 0x9e, 0x27, 0xfa, 0x2b, 0x53, 0xfd,
	0xd7, 0x2c, 0x81, 0x83, 0x70, 0x3a, 0x08, 0x24, 0x96, 0xe7, 0x04, 0x7a, 0x9b, 0xf4, 0x8d, 0x49,
	0xa0, 0x73, 0x8b, 0x76, 0xa7, 0x28, 0x85, 0x7e, 0x56, 0xc0, 0xfa, 0xb3, 0x01, 0xf6, 0x47, 0x29,
	0x31, 0xa4, 0xe6, 0x6a, 0x0d, 0xac, 0x3a, 0xae, 0x37, 0xa0, 0x81, 0x96, 0x29, 0x66, 0x4a, 0xd9,
	0xea, 0xc3, 0xf8, 0x66, 0x46, 0x63, 0xd7, 0x99, 0xbe, 0x70, 0x25, 0x6d, 0xd1, 0x67, 0xe0, 0xfe,
	0x9c, 0x06, 0x3c, 0x0b, 0xe9, 0x2d, 0x5a, 0xf6, 0x68, 0xb9, 0x6f, 0x49, 0xb2, 0x90, 0xd1, 0xcf,
	0xc1, 0x46, 0x8c, 0x1c, 0x9e, 0x44, 0x49, 0xc8, 0x70, 0xef, 0xc7, 0xfb, 0xe6, 0x25, 0x15, 0x0c,
	0xaa, 0xdb, 0x21, 0xe3, 0x76, 0x41, 0x6e, 0x4a, 0x02, 0xdf, 0x00, 0xea, 0xa4, 0x8c, 0xaa, 0x63,
	0x23, 0x0a, 0x72, 0x32, 0x6c, 0xaa, 0x37, 0x03, 0x6b, 0x61, 0xae, 0x82, 0x66, 0xe5, 0x85, 0xb9,
	0x0a, 0xa7, 0x73, 0xc9, 0xfe, 0xae, 0x80, 0x07, 0x71, 0x1a, 0xf0, 0xd9, 0x6c, 0xba, 0x8f, 0xd3,
	0xbb, 0xd7, 0xe5, 0x9c, 0x7c, 0xea, 0x52, 0x7f, 0x34, 0x29, 0x41, 0xbe, 0x09, 0xd6, 0xa3, 0x02,
	0x78, 0x0f, 0x64, 0x5e, 0xe0, 0x91, 0xcc, 0x8c, 0x7d, 0xc2, 0x77, 0xc1, 0xca, 0xd0, 0xea, 0x0d,
	0xf0, 0xb2, 0x87, 0x23, 0xb4, 0x8e, 0xd5, 0x27, 0x0a, 0xba, 0x00, 0x59, 0x36, 0x99, 0xff, 0x67,
	0x92, 0x22, 0x1f, 0xac, 0x0b, 0xb7, 0xe9, 0x9a, 0x71, 0x36, 0xdb, 0x8c, 0x04, 0xe2, 0x45, 0x7d,
	0xce, 0xf5, 0xe2, 0x1a, 0x6c, 0xc4, 0xc8, 0x21, 0x8a, 0x5d, 0x63, 0xd3, 0x6f, 0xea, 0x28, 0xec,
	0x96, 0xca, 0xbb, 0x55, 0x88, 0x8f, 0x3f, 0x33, 0x07, 0xab, 0xdf, 0xaf, 0x81, 0x8d, 0x4f, 0x48,
	0x1f, 0x7f, 0xcc, 0x14, 0x4c, 0xcf, 0x69, 0x62, 0x9f, 0x8f, 0xbe, 0x5f, 0x15, 0x00, 0xe7, 0xf7,
	0x1e, 0x34, 0x92, 0xe6, 0x6e, 0xc2, 0x0a, 0xce, 0xbf, 0x97, 0xde, 0x40, 0xae, 0xd4, 0xea, 0x8d,
	0x39, 0x9d, 0xee, 0x37, 0x7f, 0xfe, 0xf5, 0x93, 0x5a, 0x40, 0x5b, 0xe1, 0x6f, 0x43, 0x70, 0xec,
	0x87, 0xf6, 0xc7, 0x4a, 0x19, 0xfe, 0xa3, 0xb0, 0x2d, 0x9d, 0x34, 0xcd, 0xe1, 0xe3, 0xd7, 0xdd,
	0x16, 0x63, 0xf4, 0x4f, 0x5e, 0xdf, 0x50, 0x66, 0xf1, 0xc5, 0x8d, 0xf9, 0x28, 0xe4, 0x4b, 0x65,
	0xbc, 0xdf, 0x2b, 0x53, 0x99, 0x55, 0x64, 0xe3, 0x79, 0x86, 0xef, 0xa0, 0x83, 0xe9, 0x0c, 0x93,
	0x62, 0xb0, 0x84, 0x7f, 0x51, 0xc0, 0xdd, 0x99, 0x4d, 0x01, 0x2b, 0x49, 0x1d, 0x8f, 0x5b, 0x28,
	0xf9, 0xcd, 0xb9, 0xa7, 0xf5, 0x94, 0xfd, 0x74, 0xa1, 0xda, 0x8d, 0xa9, 0x45, 0x80, 0xcf, 0x77,
	0x62, 0xbf, 0xbc, 0xc7, 0x70, 0x7e, 0x35, 0x25, 0x39, 0x99, 0x70, 0x31, 0x30, 0xca, 0xe5, 0x97,
	0xf0, 0x07, 0x05, 0xac, 0xf0, 0xc1, 0x00, 0xd1, 0xf2, 0x01, 0x9c, 0xdf, 0x4f, 0x31, 0x59, 0xd0,
	0x47, 0x37, 0xe6, 0x6e, 0x12, 0xb0, 0x8a, 0xd8, 0x09, 0x1c, 0xdf, 0x26, 0xba, 0x1f, 0xad, 0xe3,
	0x35, 0x73, 0xc2, 0x4a, 0xf6, 0xad, 0x02, 0x6e, 0x31, 0xbe, 0xc0, 0xbd, 0x45, 0x2f, 0x53, 0x00,
	0x42, 0xcb, 0x1f, 0x2f, 0x3a, 0x5a, 0x56, 0xa8, 0x37, 0xd1, 0xbd, 0x28, 0x90, 0x40, 0x70, 0x35,
	0xbf, 0xf3, 0x87, 0xa9, 0x25, 0xad, 0xe3, 0xd3, 0xdf, 0x94, 0xbf, 0xcd, 0x7a, 0xda, 0x75, 0x0d,
	0x77, 0x23, 0x55, 0x8f, 0xf6, 0xc3, 0xb3, 0x68, 0xf7, 0xa4, 0x5c, 0x7e, 0x09, 0xb4, 0x36, 0xe9,
	0xc7, 0xa6, 0x72, 0xaa, 0xc5, 0x3c, 0xfa, 0x73, 0xc6, 0x84, 0xcf, 0x3f, 0x90, 0xfa, 0x1d, 0xd2,
	0xb3, 0xdc, 0x8e, 0x4e, 0xfc, 0x8e, 0xd1, 0xc1, 0x2e, 0x67, 0x89, 0x11, 0xa2, 0x99, 0xfe, 0x9d,
	0xff, 0x90, 0x7f, 0x5c, 0xae, 0x72, 0xad, 0xf7, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x1f, 0xaa,
	0x0a, 0xd7, 0xa2, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// HomeGraphApiServiceClient is the client API for HomeGraphApiService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HomeGraphApiServiceClient interface {
	// Requests Google to send an `action.devices.SYNC`
	// [intent](https://developers.google.com/assistant/smarthome/reference/intent/sync)
	// to your smart home Action to update device metadata for the given user.
	//
	//
	// The third-party user's identity is passed via the `agent_user_id`
	// (see [RequestSyncDevicesRequest][google.home.graph.v1.RequestSyncDevicesRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	RequestSyncDevices(ctx context.Context, in *RequestSyncDevicesRequest, opts ...grpc.CallOption) (*RequestSyncDevicesResponse, error)
	// Reports device state and optionally sends device notifications.
	// Called by your smart home Action when the state of a third-party device
	// changes or you need to send a notification about the device.
	// See [Implement Report
	// State](https://developers.google.com/assistant/smarthome/develop/report-state)
	// for more information.
	//
	// This method updates the device state according to its declared
	// [traits](https://developers.google.com/assistant/smarthome/concepts/devices-traits).
	// Publishing a new state value outside of these traits will result in an
	// `INVALID_ARGUMENT` error response.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [ReportStateAndNotificationRequest][google.home.graph.v1.ReportStateAndNotificationRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	ReportStateAndNotification(ctx context.Context, in *ReportStateAndNotificationRequest, opts ...grpc.CallOption) (*ReportStateAndNotificationResponse, error)
	// Unlinks the given third-party user from your smart home Action.
	// All data related to this user will be deleted.
	//
	// For more details on how users link their accounts, see
	// [fulfillment and
	// authentication](https://developers.google.com/assistant/smarthome/concepts/fulfillment-authentication).
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [DeleteAgentUserRequest][google.home.graph.v1.DeleteAgentUserRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	DeleteAgentUser(ctx context.Context, in *DeleteAgentUserRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the current states in Home Graph for the given set of the third-party
	// user's devices.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [QueryRequest][google.home.graph.v1.QueryRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	Query(ctx context.Context, in *QueryRequest, opts ...grpc.CallOption) (*QueryResponse, error)
	// Gets all the devices associated with the given third-party user.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [SyncRequest][google.home.graph.v1.SyncRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	Sync(ctx context.Context, in *SyncRequest, opts ...grpc.CallOption) (*SyncResponse, error)
}

type homeGraphApiServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHomeGraphApiServiceClient(cc grpc.ClientConnInterface) HomeGraphApiServiceClient {
	return &homeGraphApiServiceClient{cc}
}

func (c *homeGraphApiServiceClient) RequestSyncDevices(ctx context.Context, in *RequestSyncDevicesRequest, opts ...grpc.CallOption) (*RequestSyncDevicesResponse, error) {
	out := new(RequestSyncDevicesResponse)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/RequestSyncDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) ReportStateAndNotification(ctx context.Context, in *ReportStateAndNotificationRequest, opts ...grpc.CallOption) (*ReportStateAndNotificationResponse, error) {
	out := new(ReportStateAndNotificationResponse)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/ReportStateAndNotification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) DeleteAgentUser(ctx context.Context, in *DeleteAgentUserRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/DeleteAgentUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) Query(ctx context.Context, in *QueryRequest, opts ...grpc.CallOption) (*QueryResponse, error) {
	out := new(QueryResponse)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/Query", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *homeGraphApiServiceClient) Sync(ctx context.Context, in *SyncRequest, opts ...grpc.CallOption) (*SyncResponse, error) {
	out := new(SyncResponse)
	err := c.cc.Invoke(ctx, "/google.home.graph.v1.HomeGraphApiService/Sync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HomeGraphApiServiceServer is the server API for HomeGraphApiService service.
type HomeGraphApiServiceServer interface {
	// Requests Google to send an `action.devices.SYNC`
	// [intent](https://developers.google.com/assistant/smarthome/reference/intent/sync)
	// to your smart home Action to update device metadata for the given user.
	//
	//
	// The third-party user's identity is passed via the `agent_user_id`
	// (see [RequestSyncDevicesRequest][google.home.graph.v1.RequestSyncDevicesRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	RequestSyncDevices(context.Context, *RequestSyncDevicesRequest) (*RequestSyncDevicesResponse, error)
	// Reports device state and optionally sends device notifications.
	// Called by your smart home Action when the state of a third-party device
	// changes or you need to send a notification about the device.
	// See [Implement Report
	// State](https://developers.google.com/assistant/smarthome/develop/report-state)
	// for more information.
	//
	// This method updates the device state according to its declared
	// [traits](https://developers.google.com/assistant/smarthome/concepts/devices-traits).
	// Publishing a new state value outside of these traits will result in an
	// `INVALID_ARGUMENT` error response.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [ReportStateAndNotificationRequest][google.home.graph.v1.ReportStateAndNotificationRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	ReportStateAndNotification(context.Context, *ReportStateAndNotificationRequest) (*ReportStateAndNotificationResponse, error)
	// Unlinks the given third-party user from your smart home Action.
	// All data related to this user will be deleted.
	//
	// For more details on how users link their accounts, see
	// [fulfillment and
	// authentication](https://developers.google.com/assistant/smarthome/concepts/fulfillment-authentication).
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [DeleteAgentUserRequest][google.home.graph.v1.DeleteAgentUserRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	DeleteAgentUser(context.Context, *DeleteAgentUserRequest) (*empty.Empty, error)
	// Gets the current states in Home Graph for the given set of the third-party
	// user's devices.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [QueryRequest][google.home.graph.v1.QueryRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	Query(context.Context, *QueryRequest) (*QueryResponse, error)
	// Gets all the devices associated with the given third-party user.
	//
	// The third-party user's identity is passed in via the `agent_user_id`
	// (see [SyncRequest][google.home.graph.v1.SyncRequest]).
	// This request must be authorized using service account credentials from your
	// Actions console project.
	Sync(context.Context, *SyncRequest) (*SyncResponse, error)
}

// UnimplementedHomeGraphApiServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHomeGraphApiServiceServer struct {
}

func (*UnimplementedHomeGraphApiServiceServer) RequestSyncDevices(ctx context.Context, req *RequestSyncDevicesRequest) (*RequestSyncDevicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestSyncDevices not implemented")
}
func (*UnimplementedHomeGraphApiServiceServer) ReportStateAndNotification(ctx context.Context, req *ReportStateAndNotificationRequest) (*ReportStateAndNotificationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportStateAndNotification not implemented")
}
func (*UnimplementedHomeGraphApiServiceServer) DeleteAgentUser(ctx context.Context, req *DeleteAgentUserRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAgentUser not implemented")
}
func (*UnimplementedHomeGraphApiServiceServer) Query(ctx context.Context, req *QueryRequest) (*QueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Query not implemented")
}
func (*UnimplementedHomeGraphApiServiceServer) Sync(ctx context.Context, req *SyncRequest) (*SyncResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Sync not implemented")
}

func RegisterHomeGraphApiServiceServer(s *grpc.Server, srv HomeGraphApiServiceServer) {
	s.RegisterService(&_HomeGraphApiService_serviceDesc, srv)
}

func _HomeGraphApiService_RequestSyncDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestSyncDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).RequestSyncDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/RequestSyncDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).RequestSyncDevices(ctx, req.(*RequestSyncDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_ReportStateAndNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportStateAndNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).ReportStateAndNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/ReportStateAndNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).ReportStateAndNotification(ctx, req.(*ReportStateAndNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_DeleteAgentUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).DeleteAgentUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/DeleteAgentUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).DeleteAgentUser(ctx, req.(*DeleteAgentUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_Query_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).Query(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/Query",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).Query(ctx, req.(*QueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HomeGraphApiService_Sync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HomeGraphApiServiceServer).Sync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.home.graph.v1.HomeGraphApiService/Sync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HomeGraphApiServiceServer).Sync(ctx, req.(*SyncRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HomeGraphApiService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.home.graph.v1.HomeGraphApiService",
	HandlerType: (*HomeGraphApiServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RequestSyncDevices",
			Handler:    _HomeGraphApiService_RequestSyncDevices_Handler,
		},
		{
			MethodName: "ReportStateAndNotification",
			Handler:    _HomeGraphApiService_ReportStateAndNotification_Handler,
		},
		{
			MethodName: "DeleteAgentUser",
			Handler:    _HomeGraphApiService_DeleteAgentUser_Handler,
		},
		{
			MethodName: "Query",
			Handler:    _HomeGraphApiService_Query_Handler,
		},
		{
			MethodName: "Sync",
			Handler:    _HomeGraphApiService_Sync_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/home/graph/v1/homegraph.proto",
}
