/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller.multipart;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.FileUploadLimitExceededException;
import net.sourceforge.stripes.controller.multipart.MultipartWrapper;
import net.sourceforge.stripes.controller.multipart.MultipartWrapperFactory;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;

public class DefaultMultipartWrapperFactory
implements MultipartWrapperFactory {
    public static final String WRAPPER_CLASS_NAME = "MultipartWrapper.Class";
    public static final String[] BUNDLED_IMPLEMENTATIONS = new String[]{"net.sourceforge.stripes.controller.multipart.CommonsMultipartWrapper", "net.sourceforge.stripes.controller.multipart.CosMultipartWrapper"};
    public static final String MAX_POST = "FileUpload.MaximumPostSize";
    private static final Log log = Log.getInstance(DefaultMultipartWrapperFactory.class);
    private Class<? extends MultipartWrapper> multipartClass;
    private long maxPostSizeInBytes = 0xA00000L;
    private File temporaryDirectory;

    public void init(Configuration config) throws Exception {
        this.multipartClass = config.getBootstrapPropertyResolver().getClassProperty(WRAPPER_CLASS_NAME, MultipartWrapper.class);
        if (this.multipartClass == null) {
            for (String className : BUNDLED_IMPLEMENTATIONS) {
                try {
                    this.multipartClass = Class.forName(className);
                    break;
                }
                catch (Throwable t) {
                    log.debug(this.getClass().getSimpleName(), " not using ", className, " because it failed to load. This likely means the supporting ", "file upload library is not present on the classpath.");
                }
            }
        }
        if (this.multipartClass == null) {
            log.warn("No ", MultipartWrapper.class.getSimpleName(), " implementation could be loaded");
        } else {
            log.info("Using ", this.multipartClass.getName(), " as ", MultipartWrapper.class.getSimpleName(), " implementation.");
        }
        File tempDir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this.temporaryDirectory = tempDir != null ? tempDir : new File(System.getProperty("java.io.tmpdir")).getAbsoluteFile();
        String limit = config.getBootstrapPropertyResolver().getProperty(MAX_POST);
        if (limit != null) {
            Pattern pattern = Pattern.compile("([\\d,]+)([kKmMgG]?).*");
            Matcher matcher = pattern.matcher(limit);
            if (!matcher.matches()) {
                log.error("Did not understand value of configuration parameter ", MAX_POST, " You supplied: ", limit, ". Valid values are any string of numbers ", "optionally followed by (case insensitive) [k|kb|m|mb|g|gb]. ", "Default value of ", this.maxPostSizeInBytes, " bytes will be used instead.");
            } else {
                String digits = matcher.group(1);
                String suffix = matcher.group(2).toLowerCase();
                int number = Integer.parseInt(digits);
                if ("k".equals(suffix)) {
                    number *= 1024;
                } else if ("m".equals(suffix)) {
                    number = number * 1024 * 1024;
                } else if ("g".equals(suffix)) {
                    number = number * 1024 * 1024 * 1024;
                }
                this.maxPostSizeInBytes = number;
                log.info("Configured file upload post size limit: ", number, " bytes.");
            }
        }
    }

    public MultipartWrapper wrap(HttpServletRequest request) throws IOException, FileUploadLimitExceededException {
        try {
            MultipartWrapper wrapper = this.multipartClass.newInstance();
            wrapper.build(request, this.temporaryDirectory, this.maxPostSizeInBytes);
            return wrapper;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (FileUploadLimitExceededException fulee) {
            throw fulee;
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not construct a MultipartWrapper for the current request.", e);
        }
    }
}

