/*
** pdfwrite.c   Routines to help write a PDF file.
**
** Part of willus.com general purpose C code library.
**
** Copyright (C) 2022  http://willus.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU Affero General Public License as
** published by the Free Software Foundation, either version 3 of the
** License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "willus.h"


#define ABOVEBASEMEAN 0.6
#define WIDTHMEAN     0.45
#define NEXTCHARMEAN  0.12

WILLUSCHARINFO pdffonts_helvetica[224] =
    {
    /*        Above base  below   x0      width    nextchar */
    /*    */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* !  */ { 0.72944,-0.00080, 0.12352, 0.08496, 0.27792},
    /* "  */ { 0.70928,-0.46448, 0.05152, 0.25344, 0.35568},
    /* #  */ { 0.69776, 0.01936, 0.01264, 0.52992, 0.55584},
    /* $  */ { 0.77120, 0.12448, 0.03136, 0.48672, 0.55584},
    /* %  */ { 0.70928, 0.01936, 0.02848, 0.83088, 0.88992},
    /* &  */ { 0.70928, 0.02224, 0.05152, 0.58608, 0.66672},
    /* '  */ { 0.72944,-0.49760, 0.06448, 0.09360, 0.22176},
    /* (  */ { 0.72944, 0.21088, 0.07168, 0.22032, 0.33264},
    /* )  */ { 0.72944, 0.21088, 0.03712, 0.21888, 0.33264},
    /* *  */ { 0.72944,-0.44144, 0.03856, 0.30528, 0.38880},
    /* +  */ { 0.47456, 0.00928, 0.04864, 0.48528, 0.58464},
    /* ,  */ { 0.10448, 0.14608, 0.08608, 0.10656, 0.27792},
    /* -  */ { 0.31328,-0.24128, 0.04576, 0.23904, 0.33264},
    /* .  */ { 0.10448,-0.00080, 0.08608, 0.10512, 0.27792},
    /* /  */ { 0.72944, 0.01936,-0.00896, 0.29376, 0.27792},
    /* 0  */ { 0.70928, 0.02224, 0.04288, 0.46512, 0.55584},
    /* 1  */ { 0.70928,-0.00080, 0.10192, 0.24624, 0.55584},
    /* 2  */ { 0.70928,-0.00080, 0.03280, 0.47952, 0.55584},
    /* 3  */ { 0.70928, 0.02224, 0.03136, 0.47520, 0.55584},
    /* 4  */ { 0.70928,-0.00080, 0.02704, 0.49392, 0.55584},
    /* 5  */ { 0.70928, 0.02224, 0.03424, 0.47952, 0.55584},
    /* 6  */ { 0.70928, 0.02224, 0.04288, 0.47088, 0.55584},
    /* 7  */ { 0.70928,-0.00080, 0.04576, 0.47520, 0.55584},
    /* 8  */ { 0.70928, 0.02224, 0.03568, 0.47808, 0.55584},
    /* 9  */ { 0.70928, 0.02224, 0.03712, 0.47232, 0.55584},
    /* :  */ { 0.52496,-0.00080, 0.10912, 0.10512, 0.27792},
    /* ;  */ { 0.52496, 0.14608, 0.10912, 0.10656, 0.27792},
    /* <  */ { 0.47456, 0.00784, 0.04432, 0.48960, 0.58464},
    /* =  */ { 0.35360,-0.11168, 0.04864, 0.48528, 0.58464},
    /* >  */ { 0.47456, 0.00784, 0.04864, 0.49104, 0.58464},
    /* ?  */ { 0.74240,-0.00080, 0.07600, 0.43344, 0.55584},
    /* @  */ { 0.74240, 0.14176, 0.03280, 0.91872, 1.01520},
    /* A  */ { 0.72944,-0.00080, 0.01696, 0.63648, 0.66672},
    /* B  */ { 0.72944,-0.00080, 0.07888, 0.54432, 0.66672},
    /* C  */ { 0.74240, 0.02224, 0.04720, 0.63072, 0.72288},
    /* D  */ { 0.72944,-0.00080, 0.08896, 0.57888, 0.72288},
    /* E  */ { 0.72944,-0.00080, 0.08896, 0.52416, 0.66672},
    /* F  */ { 0.72944,-0.00080, 0.08896, 0.49104, 0.61056},
    /* G  */ { 0.74240, 0.02224, 0.04288, 0.66672, 0.77760},
    /* H  */ { 0.72944,-0.00080, 0.08176, 0.56304, 0.72288},
    /* I  */ { 0.72944,-0.00080, 0.09904, 0.09504, 0.27792},
    /* J  */ { 0.72944, 0.02224, 0.01696, 0.40896, 0.49968},
    /* K  */ { 0.72944,-0.00080, 0.07888, 0.58032, 0.66672},
    /* L  */ { 0.72944,-0.00080, 0.07888, 0.45504, 0.55584},
    /* M  */ { 0.72944,-0.00080, 0.07456, 0.68688, 0.83376},
    /* N  */ { 0.72944,-0.00080, 0.07600, 0.57024, 0.72288},
    /* O  */ { 0.74240, 0.02224, 0.03712, 0.70560, 0.77760},
    /* P  */ { 0.72944,-0.00080, 0.09040, 0.52704, 0.66672},
    /* Q  */ { 0.74240, 0.05824, 0.03712, 0.70560, 0.77760},
    /* R  */ { 0.72944,-0.00080, 0.09184, 0.58752, 0.72288},
    /* S  */ { 0.74240, 0.02224, 0.04720, 0.57456, 0.66672},
    /* T  */ { 0.72944,-0.00080, 0.01984, 0.57312, 0.61056},
    /* U  */ { 0.72944, 0.02224, 0.08464, 0.56160, 0.72288},
    /* V  */ { 0.72944,-0.00080, 0.02992, 0.61632, 0.66672},
    /* W  */ { 0.72944,-0.00080, 0.02128, 0.90864, 0.94464},
    /* X  */ { 0.72944,-0.00080, 0.02128, 0.62784, 0.66672},
    /* Y  */ { 0.72944,-0.00080, 0.01264, 0.64944, 0.66672},
    /* Z  */ { 0.72944,-0.00080, 0.02704, 0.55728, 0.61056},
    /* [  */ { 0.72944, 0.21088, 0.06304, 0.18720, 0.27792},
    /* \  */ { 0.72944, 0.01936,-0.00896, 0.29376, 0.27792},
    /* ]  */ { 0.72944, 0.21088, 0.02272, 0.18720, 0.27792},
    /* ^  */ { 0.70928,-0.32912, 0.04288, 0.38304, 0.46944},
    /* _  */ {-0.12592, 0.17488,-0.02336, 0.60192, 0.55584},
    /* `  */ { 0.70928,-0.47744, 0.06448, 0.09360, 0.22176},
    /* a  */ { 0.53936, 0.02224, 0.04144, 0.49392, 0.55584},
    /* b  */ { 0.72944, 0.02224, 0.05296, 0.47088, 0.55584},
    /* c  */ { 0.53936, 0.02224, 0.02992, 0.44784, 0.49968},
    /* d  */ { 0.72944, 0.02224, 0.02560, 0.46944, 0.55584},
    /* e  */ { 0.53936, 0.02224, 0.03856, 0.47520, 0.55584},
    /* f  */ { 0.73232,-0.00080, 0.01696, 0.24192, 0.27792},
    /* g  */ { 0.53936, 0.21664, 0.02848, 0.46080, 0.55584},
    /* h  */ { 0.72944,-0.00080, 0.06880, 0.41760, 0.55584},
    /* i  */ { 0.72944,-0.00080, 0.06592, 0.08496, 0.22176},
    /* j  */ { 0.72944, 0.21664,-0.01904, 0.17280, 0.22176},
    /* k  */ { 0.72944,-0.00080, 0.05728, 0.44496, 0.49968},
    /* l  */ { 0.72944,-0.00080, 0.06736, 0.08496, 0.22176},
    /* m  */ { 0.53936,-0.00080, 0.06880, 0.69408, 0.83376},
    /* n  */ { 0.53936,-0.00080, 0.06880, 0.41904, 0.55584},
    /* o  */ { 0.53936, 0.02224, 0.03568, 0.47520, 0.55584},
    /* p  */ { 0.53936, 0.21664, 0.05296, 0.47088, 0.55584},
    /* q  */ { 0.53936, 0.21664, 0.02560, 0.46944, 0.55584},
    /* r  */ { 0.53936,-0.00080, 0.06880, 0.25344, 0.33264},
    /* s  */ { 0.53936, 0.02224, 0.03280, 0.42624, 0.49968},
    /* t  */ { 0.66896, 0.02224, 0.01264, 0.24192, 0.27792},
    /* u  */ { 0.52496, 0.02224, 0.06448, 0.41760, 0.55584},
    /* v  */ { 0.52496,-0.00080, 0.00976, 0.47664, 0.49968},
    /* w  */ { 0.52496,-0.00080, 0.00544, 0.70272, 0.72288},
    /* x  */ { 0.52496,-0.00080, 0.01696, 0.45648, 0.49968},
    /* y  */ { 0.52496, 0.21664, 0.01984, 0.45936, 0.49968},
    /* z  */ { 0.52496,-0.00080, 0.02992, 0.42768, 0.49968},
    /* {  */ { 0.72944, 0.21088, 0.04288, 0.23328, 0.33408},
    /* |  */ { 0.72944, 0.21088, 0.09904, 0.06192, 0.26064},
    /* }  */ { 0.72944, 0.21088, 0.02848, 0.23472, 0.33408},
    /* ~  */ { 0.43856,-0.26864, 0.07456, 0.43344, 0.58464},
    /* 7F */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 80 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 81 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 82 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 83 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 84 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 85 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 86 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 87 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 88 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 89 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 8A */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 8B */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 8C */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 8D */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 8E */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 8F */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 90 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 91 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 92 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 93 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 94 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 95 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 96 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 97 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 98 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 99 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 9A */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 9B */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 9C */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 9D */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 9E */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* 9F */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* A0 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* A1 */ { 0.52496, 0.20368, 0.12064, 0.08496, 0.33264},
    /* A2 */ { 0.62864, 0.11872, 0.05152, 0.45936, 0.55584},
    /* A3 */ { 0.72944, 0.02224, 0.02560, 0.50976, 0.55584},
    /* A4 */ { 0.67904, 0.01936,-0.17456, 0.43344, 0.16704},
    /* A5 */ { 0.70928,-0.00080, 0.00976, 0.53568, 0.55584},
    /* A6 */ { 0.73808, 0.21088, 0.00976, 0.53280, 0.55584},
    /* A7 */ { 0.72944, 0.21232, 0.04288, 0.46368, 0.55584},
    /* A8 */ { 0.55232,-0.13328, 0.06592, 0.42336, 0.55584},
    /* A9 */ { 0.70928,-0.46448, 0.04720, 0.09504, 0.19152},
    /* AA */ { 0.70928,-0.47744, 0.04720, 0.25200, 0.33264},
    /* AB */ { 0.43856,-0.10736, 0.09760, 0.35856, 0.55584},
    /* AC */ { 0.43856,-0.10736, 0.09040, 0.15264, 0.33264},
    /* AD */ { 0.43856,-0.10736, 0.08464, 0.15552, 0.33264},
    /* AE */ { 0.73232,-0.00080, 0.01120, 0.42480, 0.49968},
    /* AF */ { 0.73232,-0.00080, 0.01696, 0.41328, 0.49968},
    /* B0 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* B1 */ { 0.31328,-0.24128,-0.00608, 0.56736, 0.55584},
    /* B2 */ { 0.70928, 0.17632, 0.03712, 0.47664, 0.55584},
    /* B3 */ { 0.70928, 0.17632, 0.03712, 0.47664, 0.55584},
    /* B4 */ { 0.42704,-0.30320, 0.08608, 0.12528, 0.27792},
    /* B5 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* B6 */ { 0.72944, 0.17632, 0.04720, 0.47520, 0.53712},
    /* B7 */ { 0.47024,-0.22112, 0.04864, 0.25200, 0.34992},
    /* B8 */ { 0.10448, 0.12736, 0.06304, 0.09504, 0.22176},
    /* B9 */ { 0.10448, 0.12736, 0.04576, 0.25488, 0.33264},
    /* BA */ { 0.70928,-0.47744, 0.04864, 0.25344, 0.33264},
    /* BB */ { 0.43856,-0.10736, 0.09760, 0.35424, 0.55584},
    /* BC */ { 0.10448,-0.00080, 0.11488, 0.77040, 1.00080},
    /* BD */ { 0.73808, 0.02080, 0.00832, 0.98496, 1.00080},
    /* BE */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* BF */ { 0.52496, 0.21664, 0.09472, 0.43344, 0.61056},
    /* C0 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* C1 */ { 0.74096,-0.59264, 0.02128, 0.21024, 0.33264},
    /* C2 */ { 0.74096,-0.59264, 0.09184, 0.21024, 0.33264},
    /* C3 */ { 0.74240,-0.59120, 0.01984, 0.28800, 0.33264},
    /* C4 */ { 0.71792,-0.61424, 0.00400, 0.31536, 0.33264},
    /* C5 */ { 0.70208,-0.63152, 0.02704, 0.27504, 0.33264},
    /* C6 */ { 0.73232,-0.59840, 0.01408, 0.30240, 0.33264},
    /* C7 */ { 0.71648,-0.61280, 0.11488, 0.10512, 0.33264},
    /* C8 */ { 0.71504,-0.61280, 0.02992, 0.26640, 0.33264},
    /* C9 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* CA */ { 0.75536,-0.57968, 0.07888, 0.17712, 0.33264},
    /* CB */ { 0.00080, 0.21376, 0.03856, 0.24912, 0.33264},
    /* CC */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* CD */ { 0.74096,-0.59120,-0.03632, 0.38448, 0.33264},
    /* CE */ { 0.00080, 0.20368, 0.05584, 0.21024, 0.33264},
    /* CF */ { 0.74240,-0.59120, 0.01840, 0.28800, 0.33264},
    /* D0 */ { 0.31328,-0.24128,-0.01040, 1.01232, 1.00080},
    /* D1 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* D2 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* D3 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* D4 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* D5 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* D6 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* D7 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* D8 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* D9 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* DA */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* DB */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* DC */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* DD */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* DE */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* DF */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* E0 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* E1 */ { 0.72944,-0.00080, 0.00976, 0.94032, 1.00080},
    /* E2 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* E3 */ { 0.74240,-0.30320, 0.03568, 0.29808, 0.37008},
    /* E4 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* E5 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* E6 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* E7 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* E8 */ { 0.72944,-0.00080,-0.00032, 0.55296, 0.55584},
    /* E9 */ { 0.75536, 0.02224, 0.02992, 0.71424, 0.77760},
    /* EA */ { 0.74240, 0.01936, 0.04288, 0.91728, 1.00080},
    /* EB */ { 0.74240,-0.30320, 0.03856, 0.28656, 0.36576},
    /* EC */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* ED */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* EE */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* EF */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* F0 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* F1 */ { 0.53936, 0.02224, 0.03280, 0.81216, 0.88992},
    /* F2 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* F3 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* F4 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* F5 */ { 0.52496,-0.00080, 0.09328, 0.08496, 0.27792},
    /* F6 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* F7 */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* F8 */ { 0.72944,-0.00080,-0.00032, 0.21312, 0.22176},
    /* F9 */ { 0.53936, 0.02944, 0.01696, 0.51264, 0.61056},
    /* FA */ { 0.53936, 0.02224, 0.03856, 0.86112, 0.94464},
    /* FB */ { 0.72944, 0.01936, 0.12496, 0.44208, 0.61056},
    /* FC */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* FD */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* FE */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792},
    /* FF */ {-1.00000,-1.00000,-1.00000,-1.00000, 0.27792}
    };
