/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
* This program is free software; you can redistribute it and/or           *
* modify it either under the terms of the GNU Lesser General Public       *
* License version 3 as published by the Free Software Foundation          *
* (the "LGPL") or, at your option, any later version.                     *
* If you do not alter this notice, a recipient may use your version       *
* of this file under the LGPL.                                            *
*                                                                         *
* You should have received a copy of the LGPL along with this library     *
* in the file COPYING; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                         *
* This software is distributed on an "AS IS" basis, WITHOUT WARRANTY      *
* OF ANY KIND, either express or implied. See the LGPL for                *
* the specific language governing rights and limitations.                 *
**************************************************************************/

#include "rsa_utils.h"

char* RSA_Key_to_char_array(RSA *rsa, int key_type, char * password)
{
    if (key_type == PRIVATE_KEY && rsa != NULL) {
        char *str;
        BIO* memPrivateKey = BIO_new(BIO_s_mem());
        if (password == NULL)
            PEM_write_bio_RSAPrivateKey(memPrivateKey,
                                        rsa, NULL, NULL, NULL,NULL, NULL);
        else
            PEM_write_bio_RSAPrivateKey(memPrivateKey,
                                        rsa, EVP_des_ede3_cbc(),
                                        (unsigned char *)password ,
                                        strlen(password),NULL, NULL);

        BIO_get_mem_data(memPrivateKey, &str);
        BIO_set_close(memPrivateKey, BIO_NOCLOSE);
        BIO_free_all(memPrivateKey);
        return str;
    } else if (key_type == PUBLIC_KEY && rsa != NULL) {
        char *str;
        BIO* mem = BIO_new(BIO_s_mem());
        PEM_write_bio_RSAPublicKey(mem, rsa);
        BIO_get_mem_data(mem, &str);
        BIO_set_close(mem, BIO_NOCLOSE);
        BIO_free_all(mem);
        return str;
    } else {
        return NULL;
    }
}

RSA* char_array_to_RSA_key(char *str, int key_type, char * password)
{
    if (key_type == PRIVATE_KEY && str != NULL) {
        BIO *mem_back_pk = BIO_new(BIO_s_mem());
        BIO_puts(mem_back_pk, str);
        RSA *rsa = RSA_new();
        if (password == NULL)
            rsa = PEM_read_bio_RSAPrivateKey(
                    mem_back_pk, &rsa, NULL, NULL);

        else
            rsa = PEM_read_bio_RSAPrivateKey(
                    mem_back_pk, &rsa, pass_cb, (unsigned char *)password);

        BIO_free_all(mem_back_pk);
        return rsa;
    } else if (key_type == PUBLIC_KEY  && str != NULL) {
        BIO *mem_back = BIO_new(BIO_s_mem());
        BIO_puts(mem_back, str);
        RSA *rsa = RSA_new();
        rsa = PEM_read_bio_RSAPublicKey(
                mem_back,NULL, NULL, NULL);

        BIO_free_all(mem_back);
        return rsa;
    } else {
        return NULL;
    }
}


int pass_cb(char *buf, int size, int rwflag, void *u)
{
    int len; char *tmp;
    rwflag = 1;
    printf("Enter pass phrase for \"%s\"\n",
           (char*)u);

    /* get pass phrase, length 'len' into 'tmp' */
    /* If password does not match 3DES password,
     then segmentation fault.*/
    tmp = (char*)"mypassword";
    len = strlen(tmp);

    if (len <= 0) return 0;
    /* if too long, truncate */
    if (len > size) len = size;
    memcpy(buf, tmp, len);
    return len;
}
