/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "standardosd.h"

#include <QLabel>
#include <Plasma/Theme>

StandardOsd::StandardOsd()
    : Osd()
{
    QSize size(240, 90);

    QGraphicsWidget *widget = new QGraphicsWidget();
    widget->setMaximumSize(size);
    widget->setMinimumSize(size);

    QGraphicsScene *scene = new QGraphicsScene(this);
    scene->addItem(widget);

    setGraphicsWidget(widget);

    QFont font = Plasma::Theme::defaultTheme()->font(Plasma::Theme::DefaultFont);
    font.setBold(true);
    font.setPixelSize(18);

    m_icon = new Plasma::Label(widget);
    m_icon->setScaledContents(false);
    m_icon->setMaximumSize(QSizeF(48, 48));
    m_icon->setMinimumSize(QSizeF(48, 48));

    m_text = new Plasma::Label(widget);
    m_text->setFont(font);
    m_text->setAlignment(Qt::AlignCenter);
    m_text->setWordWrap(true);

    m_meter = new Plasma::Meter(widget);
    m_meter->setMeterType(Plasma::Meter::BarMeterHorizontal);
    m_meter->setMaximumHeight(18);
    m_meter->setMinimumHeight(18);

    m_hlayout = new QGraphicsLinearLayout(Qt::Horizontal);
    m_hlayout->addItem(m_icon);
    m_hlayout->addItem(m_text);

    m_vlayout = new QGraphicsLinearLayout(Qt::Vertical, widget);
    m_vlayout->setContentsMargins(10, 5, 10, 5);
    m_vlayout->addItem(m_hlayout);
    m_vlayout->addItem(m_meter);
}


StandardOsd::~StandardOsd()
{
}


QSize StandardOsd::requestedPixmapSize() const
{
    return m_icon->size().toSize();
}


void StandardOsd::setContents(const QPixmap &pixmap, const QString &text, unsigned char percent)
{
    m_icon->nativeWidget()->setPixmap(pixmap);
    m_text->setText(text);
    m_meter->setValue(percent);
}
