/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *                 Jehan <jehan@girinstud.io>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSBCharSetProber.h"

/********* Language model for: German *********/

/**
 * Generated by BuildLangModel.py
 * On: 2016-05-04 10:59:07.704692
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static unsigned char Windows1252CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  5, 15, 12,  8,  0, 17, 14,  7,  3, 23, 16,  9, 13,  2, 11, /* 4X */
   18, 30,  1,  4,  6, 10, 21, 19, 28, 25, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  5, 15, 12,  8,  0, 17, 14,  7,  3, 23, 16,  9, 13,  2, 11, /* 6X */
   18, 30,  1,  4,  6, 10, 21, 19, 28, 25, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 61,SYM,SYM,SYM,SYM,SYM,SYM, 36,SYM, 58,ILL, 43,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 36,SYM, 58,ILL, 43, 60, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 57,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   40, 31, 46, 44, 22, 42, 53, 35, 34, 29, 50, 41, 54, 32, 52, 49, /* CX */
   51, 37, 48, 33, 47, 55, 26,SYM, 39, 56, 38, 62, 24, 45, 59, 27, /* DX */
   40, 31, 46, 44, 22, 42, 53, 35, 34, 29, 50, 41, 54, 32, 52, 49, /* EX */
   51, 37, 48, 33, 47, 55, 26,SYM, 39, 56, 38, 63, 24, 45, 59, 60, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static unsigned char Latin1CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  5, 15, 12,  8,  0, 17, 14,  7,  3, 23, 16,  9, 13,  2, 11, /* 4X */
   18, 30,  1,  4,  6, 10, 21, 19, 28, 25, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  5, 15, 12,  8,  0, 17, 14,  7,  3, 23, 16,  9, 13,  2, 11, /* 6X */
   18, 30,  1,  4,  6, 10, 21, 19, 28, 25, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 57,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   40, 31, 46, 44, 22, 42, 53, 35, 34, 29, 50, 41, 54, 32, 52, 49, /* CX */
   51, 37, 48, 33, 47, 55, 26,SYM, 39, 56, 38, 64, 24, 45, 59, 27, /* DX */
   40, 31, 46, 44, 22, 42, 53, 35, 34, 29, 50, 41, 54, 32, 52, 49, /* EX */
   51, 37, 48, 33, 47, 55, 26,SYM, 39, 56, 38, 65, 24, 45, 59, 60, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1267
 * First 512 sequences: 0.9935224307549352
 * Next 512 sequences (512-1024): 0.006324372703476695
 * Rest: 0.00015319654158812285
 * Negative sequences: TODO
 */
static char GermanLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,2,3,3,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,2,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,0,2,2,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,0,1,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,3,0,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,2,2,
  3,3,3,3,3,3,3,2,3,3,3,3,2,3,3,3,3,3,2,3,2,2,3,2,3,3,3,0,0,2,1,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,2,3,2,2,3,2,2,3,2,0,0,2,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,0,2,2,2,
  3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,2,2,2,2,0,3,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,3,1,3,3,1,2,
  3,3,2,3,2,3,3,3,2,3,3,3,3,2,2,2,3,2,2,1,3,2,2,2,0,3,1,0,0,2,2,
  3,3,2,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,2,2,2,3,2,3,3,3,0,0,2,1,
  3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,3,2,2,3,3,2,2,2,3,3,2,0,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,2,2,2,2,2,2,3,2,3,3,3,0,0,2,0,
  3,3,3,3,3,3,3,3,2,3,3,3,1,3,2,2,3,2,3,3,2,2,3,2,3,3,3,0,2,2,0,
  3,3,3,3,3,3,3,2,2,3,3,3,2,3,3,2,2,3,2,2,2,2,3,2,3,2,3,0,0,2,1,
  3,3,2,3,3,3,3,3,2,3,3,3,2,2,2,2,2,3,3,2,2,2,3,2,2,2,2,1,0,2,0,
  3,3,2,3,3,3,2,2,2,2,3,3,2,2,2,2,2,2,2,2,1,0,3,3,3,2,2,0,0,1,0,
  3,2,2,3,3,3,3,3,2,3,3,3,2,3,2,3,2,2,2,3,3,2,2,1,2,3,3,0,0,2,2,
  3,2,2,3,2,3,2,2,2,2,2,3,1,2,2,2,2,2,2,0,0,2,2,2,0,2,3,0,0,2,0,
  2,3,3,3,3,2,3,3,3,3,3,2,3,3,3,2,2,3,2,0,2,2,1,0,0,0,0,2,1,0,2,
  3,2,2,3,2,3,2,2,2,2,3,3,2,2,1,1,2,0,2,1,2,2,3,2,3,2,2,0,0,2,0,
  2,3,3,1,3,1,3,3,3,3,0,0,3,2,3,3,2,2,2,1,2,1,0,0,1,0,1,2,0,0,0,
  3,3,3,3,3,3,3,2,3,3,2,3,3,3,2,2,3,2,3,2,2,2,0,2,2,2,2,2,1,1,0,
  2,3,3,2,3,1,3,3,3,3,0,1,3,3,3,2,2,3,2,2,2,2,0,0,0,0,1,3,0,0,0,
  3,2,2,3,2,2,3,2,2,2,2,2,0,2,2,3,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,
  3,0,2,3,2,3,3,2,1,2,2,3,2,1,0,2,2,2,3,2,2,2,0,0,0,2,1,0,2,0,0,
  2,3,2,0,2,2,2,1,2,2,1,2,2,2,2,2,2,1,2,0,2,2,0,1,0,2,0,0,1,0,1,
  1,0,0,2,0,2,0,0,0,0,3,0,0,1,0,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,0,
};


SequenceModel Windows1252_GermanModel =
{
  Windows1252CharToOrderMap,
  GermanLangModel,
  31,
  (float)0.9935224307549352,
  PR_TRUE,
  "windows-1252"
};

SequenceModel Latin1_GermanModel =
{
  Latin1CharToOrderMap,
  GermanLangModel,
  31,
  (float)0.9935224307549352,
  PR_TRUE,
  "ISO-8859-1"
};
