with Ada.Text_IO;                use Ada.Text_IO;

with GNATCOLL.Projects; use GNATCOLL.Projects;
with GNATCOLL.VFS;      use GNATCOLL.VFS;
with GNATCOLL.Traces;   use GNATCOLL.Traces;

procedure Main is
   PT : Project_Tree;
   Env : Project_Environment_Access;
begin

   Initialize (Env);
   Load (PT, Create (+"agg.gpr"), Env, Report_Missing_Dirs => False);

   declare
      Iter : Project_Iterator := Start (PT.Root_Project);
      P : Project_Type;
   begin
      while Current (Iter) /= No_Project loop
         P := Current (Iter);

--           Put_Line (P.Project_Path.Display_Full_Name);

         declare
            Iter_Imp : Project_Iterator :=
              Find_All_Projects_Importing
                (P,Include_Self => True, Direct_Only => True);
            --  Used to crash here.
         begin
            while Current (Iter_Imp) /= No_Project loop

--                 Put_Line (" is imported by " & Current (Iter_Imp).Name);
               Next (Iter_Imp);
            end loop;
         end;

         Next (Iter);
      end loop;
   end;

   Unload (PT);
   Free (Env);
end Main;
