/*
 *  @(#)ErrorImpl.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.engine;


import java.io.StringWriter;
import java.io.PrintWriter;

import net.sourceforge.groboutils.mbtf.v1.IError;
import net.sourceforge.groboutils.mbtf.v1.IPathHistory;


/**
 * Immutible IError implementation.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:26 $
 * @since      June 12, 2002
 */
public class ErrorImpl implements IError
{
    private IPathHistory pathHistory;
    private Throwable err;
    private String msg;
    
    
    public ErrorImpl( String msg, Throwable err, IPathHistory ph )
    {
        this.msg = msg;
        this.err = err;
        this.pathHistory = ph;
    }
    
    
    /**
     * The path history at the time of the error, if any history was known.
     *
     * @return the path history, or <tt>null</tt>.
     */
    public IPathHistory getPathHistory()
    {
        return this.pathHistory;
    }
    
    
    /**
     * Returns the <tt>Throwable</tt> registered with the error report, if
     * any.
     *
     * @return the registered throwable, or <tt>null</tt>.
     */
    public Throwable getThrowable()
    {
        return this.err;
    }
    
    
    /**
     * Returns the human-readable message associated with the error, if any.
     *
     * @return the human-readable message, or <tt>null</tt>.
     */
    public String getMessage()
    {
        return this.msg;
    }
    
    
    public String toString()
    {
        String ls = System.getProperty("line.separator");
        if (ls == null)
        {
            ls = "\n";
        }
        StringBuffer sb = new StringBuffer( "ERROR: " );
        if (getMessage() != null)
        {
            sb.append( getMessage() );
            sb.append( ":" );
        }
        sb.append( ls );
        if (getThrowable() != null)
        {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter( sw );
            getThrowable().printStackTrace( pw );
            
            sb.append( sw.toString() );
        }
        if (getPathHistory() != null)
        {
            sb.append("at").append( ls ).append( getPathHistory() );
        }
        
        return sb.toString();
    }
}

