/* This file was created by './ut_uniform_IEEEkat 1' on a reference
   platform, and is #included in the recompilation of ./ut_uniform_IEEEkat
   on a target platform.  When ./ut_uniform_IEEEkat is run with no arguments
   on the target platform, it asserts that the values computed
   on the target platform match the reference values recorded here.
   These reference values were computed on an x86_64 using 32-bit,
   64-bit and 80-bit IEEE arithmetic for float, double and long double
   respectively.  Other platforms with different representations of
   floating point values or different conventions for how intermediates
   are stored and rounded will almost certainly fail these tests
   even though their results might be perfectly valid.
*/
insert("u01<float>(minu32 + uint32_t(a)) a=0", 1.16415321826934814453e-10L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=0", 2.32830643653869628906e-10L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=0", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=0", 1.16415321826934814453e-10L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=0", 2.32830643653869628906e-10L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=0", 1.16415321826934814453e-10L);
insert("u01<long double>(minu32 + uint32_t(a)) a=0", 1.16415321826934814453e-10L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=0", 2.32830643653869628906e-10L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=0", 1.16415321826934814453e-10L);
insert("u01<float>(minu64 + uint64_t(a)) a=0", 2.71050543121376108502e-20L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=0", 5.42101086242752217004e-20L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=0", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=0", 2.71050543121376108502e-20L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=0", 5.42101086242752217004e-20L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=0", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=0", 2.71050543121376108502e-20L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=0", 5.42101086242752217004e-20L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=0", 5.42101086242752217004e-20L);
insert("u01<float>(mini32 + int32_t(a)) a=0", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=0", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=0", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=0", 0.500000000116415321827L);
insert("uneg11<double>(mini32 + int32_t(a)) a=0", -0.999999999767169356346L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=0", 0.500000000116415321827L);
insert("u01<long double>(mini32 + int32_t(a)) a=0", 0.500000000116415321827L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=0", -0.999999999767169356346L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=0", 0.500000000116415321827L);
insert("u01<float>(mini64 + int64_t(a)) a=0", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=0", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=0", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=0", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=0", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=0", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=0", 0.500000000000000000000L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=0", -0.999999999999999999946L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=0", 0.500000000000000000054L);
insert("u01<float>(maxu32 - uint32_t(a)) a=0", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=0", -2.32830643653869628906e-10L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=0", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=0", 0.999999999883584678173L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=0", -2.32830643653869628906e-10L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=0", 0.999999999883584678173L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=0", 0.999999999883584678173L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=0", -2.32830643653869628906e-10L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=0", 0.999999999883584678173L);
insert("u01<float>(maxu64 - uint64_t(a)) a=0", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=0", -5.42101086242752217004e-20L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=0", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=0", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=0", -5.42101086242752217004e-20L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=0", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=0", 1.00000000000000000000L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=0", -5.42101086242752217004e-20L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=0", 0.999999999999999999946L);
insert("u01<float>(maxi32 - int32_t(a)) a=0", 0.500000000000000000000L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=0", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=0", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=0", 0.499999999883584678173L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=0", 0.999999999767169356346L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=0", 0.499999999883584678173L);
insert("u01<long double>(maxi32 - int32_t(a)) a=0", 0.499999999883584678173L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=0", 0.999999999767169356346L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=0", 0.499999999883584678173L);
insert("u01<float>(maxi64 - int64_t(a)) a=0", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=0", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=0", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=0", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=0", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=0", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=0", 0.499999999999999999973L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=0", 0.999999999999999999946L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=0", 0.499999999999999999946L);
insert("u01<float>(minu32 + uint32_t(a)) a=1", 3.49245965480804443359e-10L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=1", 6.98491930961608886719e-10L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=1", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=1", 3.49245965480804443359e-10L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=1", 6.98491930961608886719e-10L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=1", 3.49245965480804443359e-10L);
insert("u01<long double>(minu32 + uint32_t(a)) a=1", 3.49245965480804443359e-10L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=1", 6.98491930961608886719e-10L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=1", 3.49245965480804443359e-10L);
insert("u01<float>(minu64 + uint64_t(a)) a=1", 8.13151629364128325506e-20L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=1", 1.62630325872825665101e-19L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=1", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=1", 8.13151629364128325506e-20L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=1", 1.62630325872825665101e-19L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=1", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=1", 8.13151629364128325506e-20L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=1", 1.62630325872825665101e-19L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=1", 5.42101086242752217004e-20L);
insert("u01<float>(mini32 + int32_t(a)) a=1", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=1", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=1", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=1", 0.500000000349245965481L);
insert("uneg11<double>(mini32 + int32_t(a)) a=1", -0.999999999301508069038L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=1", 0.500000000349245965481L);
insert("u01<long double>(mini32 + int32_t(a)) a=1", 0.500000000349245965481L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=1", -0.999999999301508069038L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=1", 0.500000000349245965481L);
insert("u01<float>(mini64 + int64_t(a)) a=1", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=1", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=1", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=1", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=1", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=1", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=1", 0.500000000000000000108L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=1", -0.999999999999999999837L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=1", 0.500000000000000000054L);
insert("u01<float>(maxu32 - uint32_t(a)) a=1", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=1", -6.98491930961608886719e-10L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=1", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=1", 0.999999999650754034519L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=1", -6.98491930961608886719e-10L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=1", 0.999999999650754034519L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=1", 0.999999999650754034519L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=1", -6.98491930961608886719e-10L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=1", 0.999999999650754034519L);
insert("u01<float>(maxu64 - uint64_t(a)) a=1", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=1", -1.62630325872825665101e-19L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=1", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=1", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=1", -1.62630325872825665101e-19L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=1", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=1", 0.999999999999999999892L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=1", -1.62630325872825665101e-19L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=1", 0.999999999999999999946L);
insert("u01<float>(maxi32 - int32_t(a)) a=1", 0.500000000000000000000L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=1", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=1", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=1", 0.499999999650754034519L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=1", 0.999999999301508069038L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=1", 0.499999999650754034519L);
insert("u01<long double>(maxi32 - int32_t(a)) a=1", 0.499999999650754034519L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=1", 0.999999999301508069038L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=1", 0.499999999650754034519L);
insert("u01<float>(maxi64 - int64_t(a)) a=1", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=1", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=1", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=1", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=1", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=1", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=1", 0.499999999999999999919L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=1", 0.999999999999999999837L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=1", 0.499999999999999999946L);
insert("u01<float>(minu32 + uint32_t(a)) a=2", 5.82076609134674072266e-10L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=2", 1.16415321826934814453e-09L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=2", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=2", 5.82076609134674072266e-10L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=2", 1.16415321826934814453e-09L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=2", 5.82076609134674072266e-10L);
insert("u01<long double>(minu32 + uint32_t(a)) a=2", 5.82076609134674072266e-10L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=2", 1.16415321826934814453e-09L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=2", 5.82076609134674072266e-10L);
insert("u01<float>(minu64 + uint64_t(a)) a=2", 1.35525271560688054251e-19L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=2", 2.71050543121376108502e-19L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=2", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=2", 1.35525271560688054251e-19L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=2", 2.71050543121376108502e-19L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=2", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=2", 1.35525271560688054251e-19L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=2", 2.71050543121376108502e-19L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=2", 1.62630325872825665101e-19L);
insert("u01<float>(mini32 + int32_t(a)) a=2", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=2", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=2", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=2", 0.500000000582076609135L);
insert("uneg11<double>(mini32 + int32_t(a)) a=2", -0.999999998835846781731L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=2", 0.500000000582076609135L);
insert("u01<long double>(mini32 + int32_t(a)) a=2", 0.500000000582076609135L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=2", -0.999999998835846781731L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=2", 0.500000000582076609135L);
insert("u01<float>(mini64 + int64_t(a)) a=2", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=2", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=2", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=2", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=2", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=2", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=2", 0.500000000000000000108L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=2", -0.999999999999999999729L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=2", 0.500000000000000000163L);
insert("u01<float>(maxu32 - uint32_t(a)) a=2", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=2", -1.16415321826934814453e-09L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=2", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=2", 0.999999999417923390865L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=2", -1.16415321826934814453e-09L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=2", 0.999999999417923390865L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=2", 0.999999999417923390865L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=2", -1.16415321826934814453e-09L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=2", 0.999999999417923390865L);
insert("u01<float>(maxu64 - uint64_t(a)) a=2", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=2", -2.71050543121376108502e-19L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=2", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=2", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=2", -2.71050543121376108502e-19L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=2", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=2", 0.999999999999999999892L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=2", -2.71050543121376108502e-19L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=2", 0.999999999999999999837L);
insert("u01<float>(maxi32 - int32_t(a)) a=2", 0.500000000000000000000L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=2", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=2", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=2", 0.499999999417923390865L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=2", 0.999999998835846781731L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=2", 0.499999999417923390865L);
insert("u01<long double>(maxi32 - int32_t(a)) a=2", 0.499999999417923390865L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=2", 0.999999998835846781731L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=2", 0.499999999417923390865L);
insert("u01<float>(maxi64 - int64_t(a)) a=2", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=2", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=2", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=2", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=2", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=2", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=2", 0.499999999999999999864L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=2", 0.999999999999999999729L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=2", 0.499999999999999999837L);
insert("u01<float>(minu32 + uint32_t(a)) a=3", 8.14907252788543701172e-10L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=3", 1.62981450557708740234e-09L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=3", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=3", 8.14907252788543701172e-10L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=3", 1.62981450557708740234e-09L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=3", 8.14907252788543701172e-10L);
insert("u01<long double>(minu32 + uint32_t(a)) a=3", 8.14907252788543701172e-10L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=3", 1.62981450557708740234e-09L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=3", 8.14907252788543701172e-10L);
insert("u01<float>(minu64 + uint64_t(a)) a=3", 1.89735380184963275951e-19L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=3", 3.79470760369926551903e-19L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=3", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=3", 1.89735380184963275951e-19L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=3", 3.79470760369926551903e-19L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=3", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=3", 1.89735380184963275951e-19L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=3", 3.79470760369926551903e-19L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=3", 1.62630325872825665101e-19L);
insert("u01<float>(mini32 + int32_t(a)) a=3", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=3", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=3", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=3", 0.500000000814907252789L);
insert("uneg11<double>(mini32 + int32_t(a)) a=3", -0.999999998370185494423L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=3", 0.500000000814907252789L);
insert("u01<long double>(mini32 + int32_t(a)) a=3", 0.500000000814907252789L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=3", -0.999999998370185494423L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=3", 0.500000000814907252789L);
insert("u01<float>(mini64 + int64_t(a)) a=3", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=3", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=3", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=3", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=3", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=3", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=3", 0.500000000000000000217L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=3", -0.999999999999999999621L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=3", 0.500000000000000000163L);
insert("u01<float>(maxu32 - uint32_t(a)) a=3", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=3", -1.62981450557708740234e-09L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=3", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=3", 0.999999999185092747211L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=3", -1.62981450557708740234e-09L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=3", 0.999999999185092747211L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=3", 0.999999999185092747211L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=3", -1.62981450557708740234e-09L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=3", 0.999999999185092747211L);
insert("u01<float>(maxu64 - uint64_t(a)) a=3", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=3", -3.79470760369926551903e-19L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=3", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=3", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=3", -3.79470760369926551903e-19L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=3", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=3", 0.999999999999999999783L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=3", -3.79470760369926551903e-19L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=3", 0.999999999999999999837L);
insert("u01<float>(maxi32 - int32_t(a)) a=3", 0.500000000000000000000L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=3", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=3", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=3", 0.499999999185092747211L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=3", 0.999999998370185494423L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=3", 0.499999999185092747211L);
insert("u01<long double>(maxi32 - int32_t(a)) a=3", 0.499999999185092747211L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=3", 0.999999998370185494423L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=3", 0.499999999185092747211L);
insert("u01<float>(maxi64 - int64_t(a)) a=3", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=3", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=3", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=3", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=3", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=3", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=3", 0.499999999999999999810L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=3", 0.999999999999999999621L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=3", 0.499999999999999999837L);
insert("u01<float>(minu32 + uint32_t(a)) a=4", 1.04773789644241333008e-09L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=4", 2.09547579288482666016e-09L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=4", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=4", 1.04773789644241333008e-09L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=4", 2.09547579288482666016e-09L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=4", 1.04773789644241333008e-09L);
insert("u01<long double>(minu32 + uint32_t(a)) a=4", 1.04773789644241333008e-09L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=4", 2.09547579288482666016e-09L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=4", 1.04773789644241333008e-09L);
insert("u01<float>(minu64 + uint64_t(a)) a=4", 2.43945488809238497652e-19L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=4", 4.87890977618476995303e-19L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=4", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=4", 2.43945488809238497652e-19L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=4", 4.87890977618476995303e-19L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=4", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=4", 2.43945488809238497652e-19L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=4", 4.87890977618476995303e-19L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=4", 2.71050543121376108502e-19L);
insert("u01<float>(mini32 + int32_t(a)) a=4", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=4", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=4", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=4", 0.500000001047737896442L);
insert("uneg11<double>(mini32 + int32_t(a)) a=4", -0.999999997904524207115L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=4", 0.500000001047737896442L);
insert("u01<long double>(mini32 + int32_t(a)) a=4", 0.500000001047737896442L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=4", -0.999999997904524207115L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=4", 0.500000001047737896442L);
insert("u01<float>(mini64 + int64_t(a)) a=4", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=4", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=4", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=4", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=4", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=4", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=4", 0.500000000000000000217L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=4", -0.999999999999999999512L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=4", 0.500000000000000000271L);
insert("u01<float>(maxu32 - uint32_t(a)) a=4", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=4", -2.09547579288482666016e-09L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=4", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=4", 0.999999998952262103558L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=4", -2.09547579288482666016e-09L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=4", 0.999999998952262103558L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=4", 0.999999998952262103558L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=4", -2.09547579288482666016e-09L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=4", 0.999999998952262103558L);
insert("u01<float>(maxu64 - uint64_t(a)) a=4", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=4", -4.87890977618476995303e-19L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=4", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=4", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=4", -4.87890977618476995303e-19L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=4", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=4", 0.999999999999999999783L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=4", -4.87890977618476995303e-19L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=4", 0.999999999999999999729L);
insert("u01<float>(maxi32 - int32_t(a)) a=4", 0.500000000000000000000L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=4", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=4", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=4", 0.499999998952262103558L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=4", 0.999999997904524207115L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=4", 0.499999998952262103558L);
insert("u01<long double>(maxi32 - int32_t(a)) a=4", 0.499999998952262103558L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=4", 0.999999997904524207115L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=4", 0.499999998952262103558L);
insert("u01<float>(maxi64 - int64_t(a)) a=4", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=4", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=4", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=4", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=4", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=4", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=4", 0.499999999999999999756L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=4", 0.999999999999999999512L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=4", 0.499999999999999999729L);
insert("u01<float>(minu32 + uint32_t(a)) a=5", 1.28056854009628295898e-09L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=5", 2.56113708019256591797e-09L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=5", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=5", 1.28056854009628295898e-09L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=5", 2.56113708019256591797e-09L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=5", 1.28056854009628295898e-09L);
insert("u01<long double>(minu32 + uint32_t(a)) a=5", 1.28056854009628295898e-09L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=5", 2.56113708019256591797e-09L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=5", 1.28056854009628295898e-09L);
insert("u01<float>(minu64 + uint64_t(a)) a=5", 2.98155597433513719352e-19L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=5", 5.96311194867027438704e-19L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=5", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=5", 2.98155597433513719352e-19L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=5", 5.96311194867027438704e-19L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=5", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=5", 2.98155597433513719352e-19L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=5", 5.96311194867027438704e-19L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=5", 2.71050543121376108502e-19L);
insert("u01<float>(mini32 + int32_t(a)) a=5", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=5", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=5", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=5", 0.500000001280568540096L);
insert("uneg11<double>(mini32 + int32_t(a)) a=5", -0.999999997438862919807L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=5", 0.500000001280568540096L);
insert("u01<long double>(mini32 + int32_t(a)) a=5", 0.500000001280568540096L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=5", -0.999999997438862919807L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=5", 0.500000001280568540096L);
insert("u01<float>(mini64 + int64_t(a)) a=5", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=5", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=5", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=5", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=5", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=5", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=5", 0.500000000000000000325L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=5", -0.999999999999999999404L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=5", 0.500000000000000000271L);
insert("u01<float>(maxu32 - uint32_t(a)) a=5", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=5", -2.56113708019256591797e-09L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=5", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=5", 0.999999998719431459904L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=5", -2.56113708019256591797e-09L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=5", 0.999999998719431459904L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=5", 0.999999998719431459904L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=5", -2.56113708019256591797e-09L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=5", 0.999999998719431459904L);
insert("u01<float>(maxu64 - uint64_t(a)) a=5", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=5", -5.96311194867027438704e-19L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=5", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=5", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=5", -5.96311194867027438704e-19L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=5", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=5", 0.999999999999999999675L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=5", -5.96311194867027438704e-19L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=5", 0.999999999999999999729L);
insert("u01<float>(maxi32 - int32_t(a)) a=5", 0.500000000000000000000L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=5", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=5", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=5", 0.499999998719431459904L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=5", 0.999999997438862919807L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=5", 0.499999998719431459904L);
insert("u01<long double>(maxi32 - int32_t(a)) a=5", 0.499999998719431459904L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=5", 0.999999997438862919807L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=5", 0.499999998719431459904L);
insert("u01<float>(maxi64 - int64_t(a)) a=5", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=5", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=5", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=5", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=5", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=5", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=5", 0.499999999999999999702L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=5", 0.999999999999999999404L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=5", 0.499999999999999999729L);
insert("u01<float>(minu32 + uint32_t(a)) a=63", 1.47847458720207214355e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=63", 2.95694917440414428711e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=63", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=63", 1.47847458720207214355e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=63", 2.95694917440414428711e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=63", 1.47847458720207214355e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=63", 1.47847458720207214355e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=63", 2.95694917440414428711e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=63", 1.47847458720207214355e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=63", 3.44234189764147657797e-18L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=63", 6.88468379528295315595e-18L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=63", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=63", 3.44234189764147657797e-18L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=63", 6.88468379528295315595e-18L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=63", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=63", 3.44234189764147657797e-18L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=63", 6.88468379528295315595e-18L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=63", 3.41523684332933896712e-18L);
insert("u01<float>(mini32 + int32_t(a)) a=63", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=63", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=63", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=63", 0.500000014784745872021L);
insert("uneg11<double>(mini32 + int32_t(a)) a=63", -0.999999970430508255959L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=63", 0.500000014784745872021L);
insert("u01<long double>(mini32 + int32_t(a)) a=63", 0.500000014784745872021L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=63", -0.999999970430508255959L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=63", 0.500000014784745872021L);
insert("u01<float>(mini64 + int64_t(a)) a=63", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=63", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=63", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=63", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=63", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=63", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=63", 0.500000000000000003469L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=63", -0.999999999999999993115L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=63", 0.500000000000000003415L);
insert("u01<float>(maxu32 - uint32_t(a)) a=63", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=63", -2.95694917440414428711e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=63", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=63", 0.999999985215254127979L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=63", -2.95694917440414428711e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=63", 0.999999985215254127979L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=63", 0.999999985215254127979L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=63", -2.95694917440414428711e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=63", 0.999999985215254127979L);
insert("u01<float>(maxu64 - uint64_t(a)) a=63", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=63", -6.88468379528295315595e-18L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=63", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=63", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=63", -6.88468379528295315595e-18L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=63", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=63", 0.999999999999999996531L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=63", -6.88468379528295315595e-18L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=63", 0.999999999999999996585L);
insert("u01<float>(maxi32 - int32_t(a)) a=63", 0.500000000000000000000L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=63", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=63", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=63", 0.499999985215254127979L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=63", 0.999999970430508255959L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=63", 0.499999985215254127979L);
insert("u01<long double>(maxi32 - int32_t(a)) a=63", 0.499999985215254127979L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=63", 0.999999970430508255959L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=63", 0.499999985215254127979L);
insert("u01<float>(maxi64 - int64_t(a)) a=63", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=63", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=63", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=63", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=63", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=63", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=63", 0.499999999999999996558L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=63", 0.999999999999999993115L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=63", 0.499999999999999996585L);
insert("u01<float>(minu32 + uint32_t(a)) a=64", 1.50175765156745910645e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=64", 3.00351530313491821289e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=64", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=64", 1.50175765156745910645e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=64", 3.00351530313491821289e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=64", 1.50175765156745910645e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=64", 1.50175765156745910645e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=64", 3.00351530313491821289e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=64", 1.50175765156745910645e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=64", 3.49655200626575179967e-18L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=64", 6.99310401253150359935e-18L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=64", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=64", 3.49655200626575179967e-18L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=64", 6.99310401253150359935e-18L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=64", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=64", 3.49655200626575179967e-18L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=64", 6.99310401253150359935e-18L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=64", 3.52365706057788941052e-18L);
insert("u01<float>(mini32 + int32_t(a)) a=64", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=64", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=64", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=64", 0.500000015017576515675L);
insert("uneg11<double>(mini32 + int32_t(a)) a=64", -0.999999969964846968651L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=64", 0.500000015017576515675L);
insert("u01<long double>(mini32 + int32_t(a)) a=64", 0.500000015017576515675L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=64", -0.999999969964846968651L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=64", 0.500000015017576515675L);
insert("u01<float>(mini64 + int64_t(a)) a=64", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=64", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=64", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=64", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=64", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=64", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=64", 0.500000000000000003469L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=64", -0.999999999999999993007L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=64", 0.500000000000000003524L);
insert("u01<float>(maxu32 - uint32_t(a)) a=64", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=64", -3.00351530313491821289e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=64", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=64", 0.999999984982423484325L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=64", -3.00351530313491821289e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=64", 0.999999984982423484325L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=64", 0.999999984982423484325L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=64", -3.00351530313491821289e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=64", 0.999999984982423484325L);
insert("u01<float>(maxu64 - uint64_t(a)) a=64", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=64", -6.99310401253150359935e-18L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=64", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=64", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=64", -6.99310401253150359935e-18L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=64", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=64", 0.999999999999999996531L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=64", -6.99310401253150359935e-18L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=64", 0.999999999999999996476L);
insert("u01<float>(maxi32 - int32_t(a)) a=64", 0.499999970197677612305L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=64", 0.999999940395355224609L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=64", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=64", 0.499999984982423484325L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=64", 0.999999969964846968651L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=64", 0.499999984982423484325L);
insert("u01<long double>(maxi32 - int32_t(a)) a=64", 0.499999984982423484325L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=64", 0.999999969964846968651L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=64", 0.499999984982423484325L);
insert("u01<float>(maxi64 - int64_t(a)) a=64", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=64", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=64", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=64", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=64", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=64", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=64", 0.499999999999999996503L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=64", 0.999999999999999993007L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=64", 0.499999999999999996476L);
insert("u01<float>(minu32 + uint32_t(a)) a=65", 1.52504071593284606934e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=65", 3.05008143186569213867e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=65", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=65", 1.52504071593284606934e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=65", 3.05008143186569213867e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=65", 1.52504071593284606934e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=65", 1.52504071593284606934e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=65", 3.05008143186569213867e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=65", 1.52504071593284606934e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=65", 3.55076211489002702137e-18L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=65", 7.10152422978005404275e-18L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=65", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=65", 3.55076211489002702137e-18L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=65", 7.10152422978005404275e-18L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=65", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=65", 3.55076211489002702137e-18L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=65", 7.10152422978005404275e-18L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=65", 3.52365706057788941052e-18L);
insert("u01<float>(mini32 + int32_t(a)) a=65", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=65", -0.999999940395355224609L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=65", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=65", 0.500000015250407159328L);
insert("uneg11<double>(mini32 + int32_t(a)) a=65", -0.999999969499185681343L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=65", 0.500000015250407159328L);
insert("u01<long double>(mini32 + int32_t(a)) a=65", 0.500000015250407159328L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=65", -0.999999969499185681343L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=65", 0.500000015250407159328L);
insert("u01<float>(mini64 + int64_t(a)) a=65", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=65", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=65", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=65", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=65", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=65", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=65", 0.500000000000000003578L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=65", -0.999999999999999992898L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=65", 0.500000000000000003524L);
insert("u01<float>(maxu32 - uint32_t(a)) a=65", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=65", -3.05008143186569213867e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=65", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=65", 0.999999984749592840672L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=65", -3.05008143186569213867e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=65", 0.999999984749592840672L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=65", 0.999999984749592840672L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=65", -3.05008143186569213867e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=65", 0.999999984749592840672L);
insert("u01<float>(maxu64 - uint64_t(a)) a=65", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=65", -7.10152422978005404275e-18L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=65", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=65", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=65", -7.10152422978005404275e-18L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=65", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=65", 0.999999999999999996422L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=65", -7.10152422978005404275e-18L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=65", 0.999999999999999996476L);
insert("u01<float>(maxi32 - int32_t(a)) a=65", 0.499999970197677612305L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=65", 0.999999940395355224609L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=65", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=65", 0.499999984749592840672L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=65", 0.999999969499185681343L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=65", 0.499999984749592840672L);
insert("u01<long double>(maxi32 - int32_t(a)) a=65", 0.499999984749592840672L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=65", 0.999999969499185681343L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=65", 0.499999984749592840672L);
insert("u01<float>(maxi64 - int64_t(a)) a=65", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=65", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=65", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=65", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=65", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=65", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=65", 0.499999999999999996449L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=65", 0.999999999999999992898L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=65", 0.499999999999999996476L);
insert("u01<float>(minu32 + uint32_t(a)) a=127", 2.96859070658683776855e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=127", 5.93718141317367553711e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=127", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=127", 2.96859070658683776855e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=127", 5.93718141317367553711e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=127", 2.96859070658683776855e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=127", 2.96859070658683776855e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=127", 5.93718141317367553711e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=127", 2.96859070658683776855e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=127", 6.91178884959509076680e-18L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=127", 1.38235776991901815336e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=127", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=127", 6.91178884959509076680e-18L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=127", 1.38235776991901815336e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=127", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=127", 6.91178884959509076680e-18L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=127", 1.38235776991901815336e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=127", 6.88468379528295315595e-18L);
insert("u01<float>(mini32 + int32_t(a)) a=127", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=127", -0.999999940395355224609L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=127", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=127", 0.500000029685907065868L);
insert("uneg11<double>(mini32 + int32_t(a)) a=127", -0.999999940628185868263L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=127", 0.500000029685907065868L);
insert("u01<long double>(mini32 + int32_t(a)) a=127", 0.500000029685907065868L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=127", -0.999999940628185868263L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=127", 0.500000029685907065868L);
insert("u01<float>(mini64 + int64_t(a)) a=127", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=127", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=127", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=127", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=127", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=127", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=127", 0.500000000000000006939L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=127", -0.999999999999999986176L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=127", 0.500000000000000006885L);
insert("u01<float>(maxu32 - uint32_t(a)) a=127", 1.00000000000000000000L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=127", -5.93718141317367553711e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=127", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=127", 0.999999970314092934132L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=127", -5.93718141317367553711e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=127", 0.999999970314092934132L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=127", 0.999999970314092934132L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=127", -5.93718141317367553711e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=127", 0.999999970314092934132L);
insert("u01<float>(maxu64 - uint64_t(a)) a=127", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=127", -1.38235776991901815336e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=127", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=127", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=127", -1.38235776991901815336e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=127", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=127", 0.999999999999999993061L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=127", -1.38235776991901815336e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=127", 0.999999999999999993115L);
insert("u01<float>(maxi32 - int32_t(a)) a=127", 0.499999970197677612305L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=127", 0.999999940395355224609L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=127", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=127", 0.499999970314092934132L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=127", 0.999999940628185868263L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=127", 0.499999970314092934132L);
insert("u01<long double>(maxi32 - int32_t(a)) a=127", 0.499999970314092934132L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=127", 0.999999940628185868263L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=127", 0.499999970314092934132L);
insert("u01<float>(maxi64 - int64_t(a)) a=127", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=127", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=127", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=127", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=127", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=127", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=127", 0.499999999999999993088L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=127", 0.999999999999999986176L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=127", 0.499999999999999993115L);
insert("u01<float>(minu32 + uint32_t(a)) a=128", 2.99187377095222473145e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=128", 5.98374754190444946289e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=128", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=128", 2.99187377095222473145e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=128", 5.98374754190444946289e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=128", 2.99187377095222473145e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=128", 2.99187377095222473145e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=128", 5.98374754190444946289e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=128", 2.99187377095222473145e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=128", 6.96599895821936598850e-18L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=128", 1.39319979164387319770e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=128", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=128", 6.96599895821936598850e-18L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=128", 1.39319979164387319770e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=128", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=128", 6.96599895821936598850e-18L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=128", 1.39319979164387319770e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=128", 6.99310401253150359935e-18L);
insert("u01<float>(mini32 + int32_t(a)) a=128", 0.500000000000000000000L);
insert("uneg11<float>(mini32 + int32_t(a)) a=128", -0.999999940395355224609L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=128", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=128", 0.500000029918737709522L);
insert("uneg11<double>(mini32 + int32_t(a)) a=128", -0.999999940162524580956L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=128", 0.500000029918737709522L);
insert("u01<long double>(mini32 + int32_t(a)) a=128", 0.500000029918737709522L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=128", -0.999999940162524580956L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=128", 0.500000029918737709522L);
insert("u01<float>(mini64 + int64_t(a)) a=128", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=128", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=128", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=128", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=128", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=128", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=128", 0.500000000000000006939L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=128", -0.999999999999999986068L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=128", 0.500000000000000006993L);
insert("u01<float>(maxu32 - uint32_t(a)) a=128", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=128", -5.98374754190444946289e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=128", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=128", 0.999999970081262290478L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=128", -5.98374754190444946289e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=128", 0.999999970081262290478L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=128", 0.999999970081262290478L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=128", -5.98374754190444946289e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=128", 0.999999970081262290478L);
insert("u01<float>(maxu64 - uint64_t(a)) a=128", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=128", -1.39319979164387319770e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=128", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=128", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=128", -1.39319979164387319770e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=128", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=128", 0.999999999999999993061L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=128", -1.39319979164387319770e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=128", 0.999999999999999993007L);
insert("u01<float>(maxi32 - int32_t(a)) a=128", 0.499999970197677612305L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=128", 0.999999940395355224609L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=128", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=128", 0.499999970081262290478L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=128", 0.999999940162524580956L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=128", 0.499999970081262290478L);
insert("u01<long double>(maxi32 - int32_t(a)) a=128", 0.499999970081262290478L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=128", 0.999999940162524580956L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=128", 0.499999970081262290478L);
insert("u01<float>(maxi64 - int64_t(a)) a=128", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=128", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=128", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=128", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=128", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=128", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=128", 0.499999999999999993034L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=128", 0.999999999999999986068L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=128", 0.499999999999999993007L);
insert("u01<float>(minu32 + uint32_t(a)) a=129", 3.01515683531761169434e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=129", 6.03031367063522338867e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=129", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=129", 3.01515683531761169434e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=129", 6.03031367063522338867e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=129", 3.01515683531761169434e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=129", 3.01515683531761169434e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=129", 6.03031367063522338867e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=129", 3.01515683531761169434e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=129", 7.02020906684364121020e-18L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=129", 1.40404181336872824204e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=129", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=129", 7.02020906684364121020e-18L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=129", 1.40404181336872824204e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=129", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=129", 7.02020906684364121020e-18L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=129", 1.40404181336872824204e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=129", 6.99310401253150359935e-18L);
insert("u01<float>(mini32 + int32_t(a)) a=129", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=129", -0.999999940395355224609L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=129", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=129", 0.500000030151568353176L);
insert("uneg11<double>(mini32 + int32_t(a)) a=129", -0.999999939696863293648L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=129", 0.500000030151568353176L);
insert("u01<long double>(mini32 + int32_t(a)) a=129", 0.500000030151568353176L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=129", -0.999999939696863293648L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=129", 0.500000030151568353176L);
insert("u01<float>(mini64 + int64_t(a)) a=129", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=129", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=129", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=129", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=129", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=129", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=129", 0.500000000000000007047L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=129", -0.999999999999999985960L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=129", 0.500000000000000006993L);
insert("u01<float>(maxu32 - uint32_t(a)) a=129", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=129", -6.03031367063522338867e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=129", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=129", 0.999999969848431646824L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=129", -6.03031367063522338867e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=129", 0.999999969848431646824L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=129", 0.999999969848431646824L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=129", -6.03031367063522338867e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=129", 0.999999969848431646824L);
insert("u01<float>(maxu64 - uint64_t(a)) a=129", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=129", -1.40404181336872824204e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=129", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=129", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=129", -1.40404181336872824204e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=129", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=129", 0.999999999999999992953L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=129", -1.40404181336872824204e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=129", 0.999999999999999993007L);
insert("u01<float>(maxi32 - int32_t(a)) a=129", 0.499999970197677612305L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=129", 0.999999940395355224609L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=129", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=129", 0.499999969848431646824L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=129", 0.999999939696863293648L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=129", 0.499999969848431646824L);
insert("u01<long double>(maxi32 - int32_t(a)) a=129", 0.499999969848431646824L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=129", 0.999999939696863293648L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=129", 0.499999969848431646824L);
insert("u01<float>(maxi64 - int64_t(a)) a=129", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=129", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=129", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=129", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=129", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=129", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=129", 0.499999999999999992980L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=129", 0.999999999999999985960L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=129", 0.499999999999999993007L);
insert("u01<float>(minu32 + uint32_t(a)) a=191", 4.45870682597160339355e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=191", 8.91741365194320678711e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=191", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=191", 4.45870682597160339355e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=191", 8.91741365194320678711e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=191", 4.45870682597160339355e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=191", 4.45870682597160339355e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=191", 8.91741365194320678711e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=191", 4.45870682597160339355e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=191", 1.03812358015487049556e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=191", 2.07624716030974099112e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=191", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=191", 1.03812358015487049556e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=191", 2.07624716030974099112e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=191", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=191", 1.03812358015487049556e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=191", 2.07624716030974099112e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=191", 1.03541307472365673448e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=191", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=191", -0.999999940395355224609L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=191", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=191", 0.500000044587068259716L);
insert("uneg11<double>(mini32 + int32_t(a)) a=191", -0.999999910825863480568L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=191", 0.500000044587068259716L);
insert("u01<long double>(mini32 + int32_t(a)) a=191", 0.500000044587068259716L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=191", -0.999999910825863480568L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=191", 0.500000044587068259716L);
insert("u01<float>(mini64 + int64_t(a)) a=191", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=191", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=191", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=191", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=191", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=191", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=191", 0.500000000000000010408L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=191", -0.999999999999999979238L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=191", 0.500000000000000010354L);
insert("u01<float>(maxu32 - uint32_t(a)) a=191", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=191", -8.91741365194320678711e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=191", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=191", 0.999999955412931740284L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=191", -8.91741365194320678711e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=191", 0.999999955412931740284L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=191", 0.999999955412931740284L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=191", -8.91741365194320678711e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=191", 0.999999955412931740284L);
insert("u01<float>(maxu64 - uint64_t(a)) a=191", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=191", -2.07624716030974099112e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=191", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=191", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=191", -2.07624716030974099112e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=191", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=191", 0.999999999999999989592L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=191", -2.07624716030974099112e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=191", 0.999999999999999989646L);
insert("u01<float>(maxi32 - int32_t(a)) a=191", 0.499999940395355224609L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=191", 0.999999880790710449219L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=191", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=191", 0.499999955412931740284L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=191", 0.999999910825863480568L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=191", 0.499999955412931740284L);
insert("u01<long double>(maxi32 - int32_t(a)) a=191", 0.499999955412931740284L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=191", 0.999999910825863480568L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=191", 0.499999955412931740284L);
insert("u01<float>(maxi64 - int64_t(a)) a=191", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=191", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=191", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=191", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=191", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=191", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=191", 0.499999999999999989619L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=191", 0.999999999999999979238L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=191", 0.499999999999999989646L);
insert("u01<float>(minu32 + uint32_t(a)) a=192", 4.48198989033699035645e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=192", 8.96397978067398071289e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=192", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=192", 4.48198989033699035645e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=192", 8.96397978067398071289e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=192", 4.48198989033699035645e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=192", 4.48198989033699035645e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=192", 8.96397978067398071289e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=192", 4.48198989033699035645e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=192", 1.04354459101729801773e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=192", 2.08708918203459603546e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=192", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=192", 1.04354459101729801773e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=192", 2.08708918203459603546e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=192", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=192", 1.04354459101729801773e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=192", 2.08708918203459603546e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=192", 1.04625509644851177882e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=192", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=192", -0.999999880790710449219L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=192", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=192", 0.500000044819898903370L);
insert("uneg11<double>(mini32 + int32_t(a)) a=192", -0.999999910360202193260L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=192", 0.500000044819898903370L);
insert("u01<long double>(mini32 + int32_t(a)) a=192", 0.500000044819898903370L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=192", -0.999999910360202193260L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=192", 0.500000044819898903370L);
insert("u01<float>(mini64 + int64_t(a)) a=192", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=192", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=192", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=192", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=192", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=192", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=192", 0.500000000000000010408L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=192", -0.999999999999999979129L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=192", 0.500000000000000010463L);
insert("u01<float>(maxu32 - uint32_t(a)) a=192", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=192", -8.96397978067398071289e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=192", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=192", 0.999999955180101096630L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=192", -8.96397978067398071289e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=192", 0.999999955180101096630L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=192", 0.999999955180101096630L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=192", -8.96397978067398071289e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=192", 0.999999955180101096630L);
insert("u01<float>(maxu64 - uint64_t(a)) a=192", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=192", -2.08708918203459603546e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=192", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=192", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=192", -2.08708918203459603546e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=192", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=192", 0.999999999999999989592L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=192", -2.08708918203459603546e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=192", 0.999999999999999989537L);
insert("u01<float>(maxi32 - int32_t(a)) a=192", 0.499999940395355224609L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=192", 0.999999880790710449219L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=192", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=192", 0.499999955180101096630L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=192", 0.999999910360202193260L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=192", 0.499999955180101096630L);
insert("u01<long double>(maxi32 - int32_t(a)) a=192", 0.499999955180101096630L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=192", 0.999999910360202193260L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=192", 0.499999955180101096630L);
insert("u01<float>(maxi64 - int64_t(a)) a=192", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=192", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=192", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=192", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=192", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=192", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=192", 0.499999999999999989565L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=192", 0.999999999999999979129L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=192", 0.499999999999999989537L);
insert("u01<float>(minu32 + uint32_t(a)) a=193", 4.50527295470237731934e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=193", 9.01054590940475463867e-08L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=193", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=193", 4.50527295470237731934e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=193", 9.01054590940475463867e-08L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=193", 4.50527295470237731934e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=193", 4.50527295470237731934e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=193", 9.01054590940475463867e-08L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=193", 4.50527295470237731934e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=193", 1.04896560187972553990e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=193", 2.09793120375945107980e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=193", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=193", 1.04896560187972553990e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=193", 2.09793120375945107980e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=193", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=193", 1.04896560187972553990e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=193", 2.09793120375945107980e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=193", 1.04625509644851177882e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=193", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=193", -0.999999880790710449219L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=193", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=193", 0.500000045052729547024L);
insert("uneg11<double>(mini32 + int32_t(a)) a=193", -0.999999909894540905952L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=193", 0.500000045052729547024L);
insert("u01<long double>(mini32 + int32_t(a)) a=193", 0.500000045052729547024L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=193", -0.999999909894540905952L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=193", 0.500000045052729547024L);
insert("u01<float>(mini64 + int64_t(a)) a=193", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=193", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=193", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=193", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=193", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=193", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=193", 0.500000000000000010517L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=193", -0.999999999999999979021L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=193", 0.500000000000000010463L);
insert("u01<float>(maxu32 - uint32_t(a)) a=193", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=193", -9.01054590940475463867e-08L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=193", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=193", 0.999999954947270452976L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=193", -9.01054590940475463867e-08L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=193", 0.999999954947270452976L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=193", 0.999999954947270452976L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=193", -9.01054590940475463867e-08L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=193", 0.999999954947270452976L);
insert("u01<float>(maxu64 - uint64_t(a)) a=193", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=193", -2.09793120375945107980e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=193", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=193", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=193", -2.09793120375945107980e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=193", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=193", 0.999999999999999989483L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=193", -2.09793120375945107980e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=193", 0.999999999999999989537L);
insert("u01<float>(maxi32 - int32_t(a)) a=193", 0.499999940395355224609L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=193", 0.999999880790710449219L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=193", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=193", 0.499999954947270452976L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=193", 0.999999909894540905952L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=193", 0.499999954947270452976L);
insert("u01<long double>(maxi32 - int32_t(a)) a=193", 0.499999954947270452976L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=193", 0.999999909894540905952L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=193", 0.499999954947270452976L);
insert("u01<float>(maxi64 - int64_t(a)) a=193", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=193", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=193", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=193", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=193", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=193", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=193", 0.499999999999999989510L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=193", 0.999999999999999979021L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=193", 0.499999999999999989537L);
insert("u01<float>(minu32 + uint32_t(a)) a=255", 5.94882294535636901855e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=255", 1.18976458907127380371e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=255", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=255", 5.94882294535636901855e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=255", 1.18976458907127380371e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=255", 5.94882294535636901855e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=255", 5.94882294535636901855e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=255", 1.18976458907127380371e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=255", 5.94882294535636901855e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=255", 1.38506827535023191444e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=255", 2.77013655070046382889e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=255", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=255", 1.38506827535023191444e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=255", 2.77013655070046382889e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=255", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=255", 1.38506827535023191444e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=255", 2.77013655070046382889e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=255", 1.38235776991901815336e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=255", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=255", -0.999999880790710449219L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=255", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=255", 0.500000059488229453564L);
insert("uneg11<double>(mini32 + int32_t(a)) a=255", -0.999999881023541092873L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=255", 0.500000059488229453564L);
insert("u01<long double>(mini32 + int32_t(a)) a=255", 0.500000059488229453564L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=255", -0.999999881023541092873L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=255", 0.500000059488229453564L);
insert("u01<float>(mini64 + int64_t(a)) a=255", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=255", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=255", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=255", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=255", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=255", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=255", 0.500000000000000013878L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=255", -0.999999999999999972299L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=255", 0.500000000000000013824L);
insert("u01<float>(maxu32 - uint32_t(a)) a=255", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=255", -1.18976458907127380371e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=255", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=255", 0.999999940511770546436L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=255", -1.18976458907127380371e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=255", 0.999999940511770546436L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=255", 0.999999940511770546436L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=255", -1.18976458907127380371e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=255", 0.999999940511770546436L);
insert("u01<float>(maxu64 - uint64_t(a)) a=255", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=255", -2.77013655070046382889e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=255", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=255", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=255", -2.77013655070046382889e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=255", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=255", 0.999999999999999986122L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=255", -2.77013655070046382889e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=255", 0.999999999999999986176L);
insert("u01<float>(maxi32 - int32_t(a)) a=255", 0.499999940395355224609L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=255", 0.999999880790710449219L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=255", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=255", 0.499999940511770546436L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=255", 0.999999881023541092873L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=255", 0.499999940511770546436L);
insert("u01<long double>(maxi32 - int32_t(a)) a=255", 0.499999940511770546436L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=255", 0.999999881023541092873L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=255", 0.499999940511770546436L);
insert("u01<float>(maxi64 - int64_t(a)) a=255", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=255", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=255", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=255", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=255", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=255", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=255", 0.499999999999999986149L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=255", 0.999999999999999972299L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=255", 0.499999999999999986176L);
insert("u01<float>(minu32 + uint32_t(a)) a=256", 5.97210600972175598145e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=256", 1.19442120194435119629e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=256", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=256", 5.97210600972175598145e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=256", 1.19442120194435119629e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=256", 5.97210600972175598145e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=256", 5.97210600972175598145e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=256", 1.19442120194435119629e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=256", 5.97210600972175598145e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=256", 1.39048928621265943661e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=256", 2.78097857242531887323e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=256", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=256", 1.39048928621265943661e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=256", 2.78097857242531887323e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=256", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=256", 1.39048928621265943661e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=256", 2.78097857242531887323e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=256", 1.39319979164387319770e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=256", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=256", -0.999999880790710449219L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=256", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=256", 0.500000059721060097218L);
insert("uneg11<double>(mini32 + int32_t(a)) a=256", -0.999999880557879805565L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=256", 0.500000059721060097218L);
insert("u01<long double>(mini32 + int32_t(a)) a=256", 0.500000059721060097218L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=256", -0.999999880557879805565L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=256", 0.500000059721060097218L);
insert("u01<float>(mini64 + int64_t(a)) a=256", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=256", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=256", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=256", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=256", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=256", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=256", 0.500000000000000013878L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=256", -0.999999999999999972190L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=256", 0.500000000000000013932L);
insert("u01<float>(maxu32 - uint32_t(a)) a=256", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=256", -1.19442120194435119629e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=256", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=256", 0.999999940278939902782L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=256", -1.19442120194435119629e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=256", 0.999999940278939902782L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=256", 0.999999940278939902782L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=256", -1.19442120194435119629e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=256", 0.999999940278939902782L);
insert("u01<float>(maxu64 - uint64_t(a)) a=256", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=256", -2.78097857242531887323e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=256", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=256", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=256", -2.78097857242531887323e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=256", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=256", 0.999999999999999986122L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=256", -2.78097857242531887323e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=256", 0.999999999999999986068L);
insert("u01<float>(maxi32 - int32_t(a)) a=256", 0.499999940395355224609L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=256", 0.999999880790710449219L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=256", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=256", 0.499999940278939902782L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=256", 0.999999880557879805565L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=256", 0.499999940278939902782L);
insert("u01<long double>(maxi32 - int32_t(a)) a=256", 0.499999940278939902782L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=256", 0.999999880557879805565L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=256", 0.499999940278939902782L);
insert("u01<float>(maxi64 - int64_t(a)) a=256", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=256", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=256", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=256", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=256", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=256", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=256", 0.499999999999999986095L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=256", 0.999999999999999972190L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=256", 0.499999999999999986068L);
insert("u01<float>(minu32 + uint32_t(a)) a=257", 5.99538907408714294434e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=257", 1.19907781481742858887e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=257", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=257", 5.99538907408714294434e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=257", 1.19907781481742858887e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=257", 5.99538907408714294434e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=257", 5.99538907408714294434e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=257", 1.19907781481742858887e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=257", 5.99538907408714294434e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=257", 1.39591029707508695878e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=257", 2.79182059415017391757e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=257", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=257", 1.39591029707508695878e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=257", 2.79182059415017391757e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=257", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=257", 1.39591029707508695878e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=257", 2.79182059415017391757e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=257", 1.39319979164387319770e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=257", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=257", -0.999999880790710449219L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=257", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=257", 0.500000059953890740871L);
insert("uneg11<double>(mini32 + int32_t(a)) a=257", -0.999999880092218518257L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=257", 0.500000059953890740871L);
insert("u01<long double>(mini32 + int32_t(a)) a=257", 0.500000059953890740871L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=257", -0.999999880092218518257L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=257", 0.500000059953890740871L);
insert("u01<float>(mini64 + int64_t(a)) a=257", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=257", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=257", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=257", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=257", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=257", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=257", 0.500000000000000013986L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=257", -0.999999999999999972082L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=257", 0.500000000000000013932L);
insert("u01<float>(maxu32 - uint32_t(a)) a=257", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=257", -1.19907781481742858887e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=257", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=257", 0.999999940046109259129L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=257", -1.19907781481742858887e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=257", 0.999999940046109259129L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=257", 0.999999940046109259129L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=257", -1.19907781481742858887e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=257", 0.999999940046109259129L);
insert("u01<float>(maxu64 - uint64_t(a)) a=257", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=257", -2.79182059415017391757e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=257", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=257", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=257", -2.79182059415017391757e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=257", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=257", 0.999999999999999986014L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=257", -2.79182059415017391757e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=257", 0.999999999999999986068L);
insert("u01<float>(maxi32 - int32_t(a)) a=257", 0.499999940395355224609L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=257", 0.999999880790710449219L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=257", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=257", 0.499999940046109259129L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=257", 0.999999880092218518257L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=257", 0.499999940046109259129L);
insert("u01<long double>(maxi32 - int32_t(a)) a=257", 0.499999940046109259129L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=257", 0.999999880092218518257L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=257", 0.499999940046109259129L);
insert("u01<float>(maxi64 - int64_t(a)) a=257", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=257", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=257", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=257", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=257", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=257", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=257", 0.499999999999999986041L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=257", 0.999999999999999972082L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=257", 0.499999999999999986068L);
insert("u01<float>(minu32 + uint32_t(a)) a=319", 7.43893906474113464355e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=319", 1.48778781294822692871e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=319", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=319", 7.43893906474113464355e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=319", 1.48778781294822692871e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=319", 7.43893906474113464355e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=319", 7.43893906474113464355e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=319", 1.48778781294822692871e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=319", 7.43893906474113464355e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=319", 1.73201297054559333333e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=319", 3.46402594109118666665e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=319", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=319", 1.73201297054559333333e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=319", 3.46402594109118666665e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=319", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=319", 1.73201297054559333333e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=319", 3.46402594109118666665e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=319", 1.72930246511437957224e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=319", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=319", -0.999999880790710449219L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=319", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=319", 0.500000074389390647411L);
insert("uneg11<double>(mini32 + int32_t(a)) a=319", -0.999999851221218705177L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=319", 0.500000074389390647411L);
insert("u01<long double>(mini32 + int32_t(a)) a=319", 0.500000074389390647411L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=319", -0.999999851221218705177L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=319", 0.500000074389390647411L);
insert("u01<float>(mini64 + int64_t(a)) a=319", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=319", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=319", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=319", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=319", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=319", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=319", 0.500000000000000017347L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=319", -0.999999999999999965360L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=319", 0.500000000000000017293L);
insert("u01<float>(maxu32 - uint32_t(a)) a=319", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=319", -1.48778781294822692871e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=319", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=319", 0.999999925610609352589L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=319", -1.48778781294822692871e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=319", 0.999999925610609352589L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=319", 0.999999925610609352589L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=319", -1.48778781294822692871e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=319", 0.999999925610609352589L);
insert("u01<float>(maxu64 - uint64_t(a)) a=319", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=319", -3.46402594109118666665e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=319", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=319", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=319", -3.46402594109118666665e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=319", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=319", 0.999999999999999982653L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=319", -3.46402594109118666665e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=319", 0.999999999999999982707L);
insert("u01<float>(maxi32 - int32_t(a)) a=319", 0.499999940395355224609L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=319", 0.999999880790710449219L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=319", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=319", 0.499999925610609352589L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=319", 0.999999851221218705177L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=319", 0.499999925610609352589L);
insert("u01<long double>(maxi32 - int32_t(a)) a=319", 0.499999925610609352589L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=319", 0.999999851221218705177L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=319", 0.499999925610609352589L);
insert("u01<float>(maxi64 - int64_t(a)) a=319", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=319", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=319", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=319", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=319", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=319", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=319", 0.499999999999999982680L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=319", 0.999999999999999965360L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=319", 0.499999999999999982707L);
insert("u01<float>(minu32 + uint32_t(a)) a=320", 7.46222212910652160645e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=320", 1.49244442582130432129e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=320", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=320", 7.46222212910652160645e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=320", 1.49244442582130432129e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=320", 7.46222212910652160645e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=320", 7.46222212910652160645e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=320", 1.49244442582130432129e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=320", 7.46222212910652160645e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=320", 1.73743398140802085550e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=320", 3.47486796281604171099e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=320", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=320", 1.73743398140802085550e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=320", 3.47486796281604171099e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=320", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=320", 1.73743398140802085550e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=320", 3.47486796281604171099e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=320", 1.74014448683923461658e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=320", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=320", -0.999999880790710449219L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=320", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=320", 0.500000074622221291065L);
insert("uneg11<double>(mini32 + int32_t(a)) a=320", -0.999999850755557417870L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=320", 0.500000074622221291065L);
insert("u01<long double>(mini32 + int32_t(a)) a=320", 0.500000074622221291065L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=320", -0.999999850755557417870L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=320", 0.500000074622221291065L);
insert("u01<float>(mini64 + int64_t(a)) a=320", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=320", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=320", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=320", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=320", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=320", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=320", 0.500000000000000017347L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=320", -0.999999999999999965251L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=320", 0.500000000000000017401L);
insert("u01<float>(maxu32 - uint32_t(a)) a=320", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=320", -1.49244442582130432129e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=320", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=320", 0.999999925377778708935L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=320", -1.49244442582130432129e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=320", 0.999999925377778708935L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=320", 0.999999925377778708935L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=320", -1.49244442582130432129e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=320", 0.999999925377778708935L);
insert("u01<float>(maxu64 - uint64_t(a)) a=320", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=320", -3.47486796281604171099e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=320", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=320", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=320", -3.47486796281604171099e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=320", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=320", 0.999999999999999982653L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=320", -3.47486796281604171099e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=320", 0.999999999999999982599L);
insert("u01<float>(maxi32 - int32_t(a)) a=320", 0.499999910593032836914L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=320", 0.999999821186065673828L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=320", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=320", 0.499999925377778708935L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=320", 0.999999850755557417870L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=320", 0.499999925377778708935L);
insert("u01<long double>(maxi32 - int32_t(a)) a=320", 0.499999925377778708935L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=320", 0.999999850755557417870L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=320", 0.499999925377778708935L);
insert("u01<float>(maxi64 - int64_t(a)) a=320", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=320", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=320", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=320", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=320", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=320", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=320", 0.499999999999999982626L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=320", 0.999999999999999965251L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=320", 0.499999999999999982599L);
insert("u01<float>(minu32 + uint32_t(a)) a=321", 7.48550519347190856934e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=321", 1.49710103869438171387e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=321", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=321", 7.48550519347190856934e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=321", 1.49710103869438171387e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=321", 7.48550519347190856934e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=321", 7.48550519347190856934e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=321", 1.49710103869438171387e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=321", 7.48550519347190856934e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=321", 1.74285499227044837767e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=321", 3.48570998454089675533e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=321", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=321", 1.74285499227044837767e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=321", 3.48570998454089675533e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=321", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=321", 1.74285499227044837767e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=321", 3.48570998454089675533e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=321", 1.74014448683923461658e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=321", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=321", -0.999999821186065673828L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=321", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=321", 0.500000074855051934719L);
insert("uneg11<double>(mini32 + int32_t(a)) a=321", -0.999999850289896130562L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=321", 0.500000074855051934719L);
insert("u01<long double>(mini32 + int32_t(a)) a=321", 0.500000074855051934719L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=321", -0.999999850289896130562L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=321", 0.500000074855051934719L);
insert("u01<float>(mini64 + int64_t(a)) a=321", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=321", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=321", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=321", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=321", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=321", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=321", 0.500000000000000017456L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=321", -0.999999999999999965143L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=321", 0.500000000000000017401L);
insert("u01<float>(maxu32 - uint32_t(a)) a=321", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=321", -1.49710103869438171387e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=321", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=321", 0.999999925144948065281L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=321", -1.49710103869438171387e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=321", 0.999999925144948065281L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=321", 0.999999925144948065281L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=321", -1.49710103869438171387e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=321", 0.999999925144948065281L);
insert("u01<float>(maxu64 - uint64_t(a)) a=321", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=321", -3.48570998454089675533e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=321", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=321", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=321", -3.48570998454089675533e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=321", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=321", 0.999999999999999982544L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=321", -3.48570998454089675533e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=321", 0.999999999999999982599L);
insert("u01<float>(maxi32 - int32_t(a)) a=321", 0.499999910593032836914L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=321", 0.999999821186065673828L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=321", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=321", 0.499999925144948065281L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=321", 0.999999850289896130562L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=321", 0.499999925144948065281L);
insert("u01<long double>(maxi32 - int32_t(a)) a=321", 0.499999925144948065281L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=321", 0.999999850289896130562L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=321", 0.499999925144948065281L);
insert("u01<float>(maxi64 - int64_t(a)) a=321", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=321", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=321", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=321", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=321", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=321", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=321", 0.499999999999999982571L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=321", 0.999999999999999965143L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=321", 0.499999999999999982599L);
insert("u01<float>(minu32 + uint32_t(a)) a=382", 8.90577211976051330566e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=382", 1.78115442395210266113e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=382", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=382", 8.90577211976051330566e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=382", 1.78115442395210266113e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=382", 8.90577211976051330566e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=382", 8.90577211976051330566e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=382", 1.78115442395210266113e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=382", 8.90577211976051330566e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=382", 2.07353665487852723004e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=382", 4.14707330975705446008e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=382", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=382", 2.07353665487852723004e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=382", 4.14707330975705446008e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=382", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=382", 2.07353665487852723004e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=382", 4.14707330975705446008e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=382", 2.07624716030974099112e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=382", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=382", -0.999999821186065673828L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=382", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=382", 0.500000089057721197605L);
insert("uneg11<double>(mini32 + int32_t(a)) a=382", -0.999999821884557604790L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=382", 0.500000089057721197605L);
insert("u01<long double>(mini32 + int32_t(a)) a=382", 0.500000089057721197605L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=382", -0.999999821884557604790L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=382", 0.500000089057721197605L);
insert("u01<float>(mini64 + int64_t(a)) a=382", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=382", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=382", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=382", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=382", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=382", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=382", 0.500000000000000020708L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=382", -0.999999999999999958529L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=382", 0.500000000000000020762L);
insert("u01<float>(maxu32 - uint32_t(a)) a=382", 0.999999940395355224609L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=382", -1.78115442395210266113e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=382", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=382", 0.999999910942278802395L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=382", -1.78115442395210266113e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=382", 0.999999910942278802395L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=382", 0.999999910942278802395L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=382", -1.78115442395210266113e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=382", 0.999999910942278802395L);
insert("u01<float>(maxu64 - uint64_t(a)) a=382", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=382", -4.14707330975705446008e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=382", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=382", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=382", -4.14707330975705446008e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=382", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=382", 0.999999999999999979292L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=382", -4.14707330975705446008e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=382", 0.999999999999999979238L);
insert("u01<float>(maxi32 - int32_t(a)) a=382", 0.499999910593032836914L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=382", 0.999999821186065673828L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=382", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=382", 0.499999910942278802395L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=382", 0.999999821884557604790L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=382", 0.499999910942278802395L);
insert("u01<long double>(maxi32 - int32_t(a)) a=382", 0.499999910942278802395L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=382", 0.999999821884557604790L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=382", 0.499999910942278802395L);
insert("u01<float>(maxi64 - int64_t(a)) a=382", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=382", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=382", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=382", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=382", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=382", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=382", 0.499999999999999979265L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=382", 0.999999999999999958529L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=382", 0.499999999999999979238L);
insert("u01<float>(minu32 + uint32_t(a)) a=383", 8.92905518412590026855e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=383", 1.78581103682518005371e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=383", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=383", 8.92905518412590026855e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=383", 1.78581103682518005371e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=383", 8.92905518412590026855e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=383", 8.92905518412590026855e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=383", 1.78581103682518005371e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=383", 8.92905518412590026855e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=383", 2.07895766574095475221e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=383", 4.15791533148190950442e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=383", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=383", 2.07895766574095475221e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=383", 4.15791533148190950442e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=383", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=383", 2.07895766574095475221e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=383", 4.15791533148190950442e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=383", 2.07624716030974099112e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=383", 0.500000059604644775391L);
insert("uneg11<float>(mini32 + int32_t(a)) a=383", -0.999999821186065673828L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=383", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=383", 0.500000089290551841259L);
insert("uneg11<double>(mini32 + int32_t(a)) a=383", -0.999999821418896317482L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=383", 0.500000089290551841259L);
insert("u01<long double>(mini32 + int32_t(a)) a=383", 0.500000089290551841259L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=383", -0.999999821418896317482L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=383", 0.500000089290551841259L);
insert("u01<float>(mini64 + int64_t(a)) a=383", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=383", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=383", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=383", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=383", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=383", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=383", 0.500000000000000020817L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=383", -0.999999999999999958421L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=383", 0.500000000000000020762L);
insert("u01<float>(maxu32 - uint32_t(a)) a=383", 0.999999880790710449219L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=383", -1.78581103682518005371e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=383", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=383", 0.999999910709448158741L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=383", -1.78581103682518005371e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=383", 0.999999910709448158741L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=383", 0.999999910709448158741L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=383", -1.78581103682518005371e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=383", 0.999999910709448158741L);
insert("u01<float>(maxu64 - uint64_t(a)) a=383", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=383", -4.15791533148190950442e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=383", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=383", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=383", -4.15791533148190950442e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=383", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=383", 0.999999999999999979183L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=383", -4.15791533148190950442e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=383", 0.999999999999999979238L);
insert("u01<float>(maxi32 - int32_t(a)) a=383", 0.499999910593032836914L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=383", 0.999999821186065673828L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=383", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=383", 0.499999910709448158741L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=383", 0.999999821418896317482L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=383", 0.499999910709448158741L);
insert("u01<long double>(maxi32 - int32_t(a)) a=383", 0.499999910709448158741L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=383", 0.999999821418896317482L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=383", 0.499999910709448158741L);
insert("u01<float>(maxi64 - int64_t(a)) a=383", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=383", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=383", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=383", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=383", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=383", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=383", 0.499999999999999979210L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=383", 0.999999999999999958421L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=383", 0.499999999999999979238L);
insert("u01<float>(minu32 + uint32_t(a)) a=384", 8.95233824849128723145e-08L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=384", 1.79046764969825744629e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=384", 5.96046447753906250000e-08L);
insert("u01<double>(minu32 + uint32_t(a)) a=384", 8.95233824849128723145e-08L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=384", 1.79046764969825744629e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=384", 8.95233824849128723145e-08L);
insert("u01<long double>(minu32 + uint32_t(a)) a=384", 8.95233824849128723145e-08L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=384", 1.79046764969825744629e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=384", 8.95233824849128723145e-08L);
insert("u01<float>(minu64 + uint64_t(a)) a=384", 2.08437867660338227438e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=384", 4.16875735320676454876e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=384", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=384", 2.08437867660338227438e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=384", 4.16875735320676454876e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=384", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=384", 2.08437867660338227438e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=384", 4.16875735320676454876e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=384", 2.08708918203459603546e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=384", 0.500000119209289550781L);
insert("uneg11<float>(mini32 + int32_t(a)) a=384", -0.999999821186065673828L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=384", 0.500000059604644775391L);
insert("u01<double>(mini32 + int32_t(a)) a=384", 0.500000089523382484913L);
insert("uneg11<double>(mini32 + int32_t(a)) a=384", -0.999999820953235030174L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=384", 0.500000089523382484913L);
insert("u01<long double>(mini32 + int32_t(a)) a=384", 0.500000089523382484913L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=384", -0.999999820953235030174L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=384", 0.500000089523382484913L);
insert("u01<float>(mini64 + int64_t(a)) a=384", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=384", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=384", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=384", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=384", -1.00000000000000000000L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=384", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=384", 0.500000000000000020817L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=384", -0.999999999999999958312L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=384", 0.500000000000000020871L);
insert("u01<float>(maxu32 - uint32_t(a)) a=384", 0.999999880790710449219L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=384", -1.79046764969825744629e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=384", 0.999999940395355224609L);
insert("u01<double>(maxu32 - uint32_t(a)) a=384", 0.999999910476617515087L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=384", -1.79046764969825744629e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=384", 0.999999910476617515087L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=384", 0.999999910476617515087L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=384", -1.79046764969825744629e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=384", 0.999999910476617515087L);
insert("u01<float>(maxu64 - uint64_t(a)) a=384", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=384", -4.16875735320676454876e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=384", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=384", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=384", -4.16875735320676454876e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=384", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=384", 0.999999999999999979183L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=384", -4.16875735320676454876e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=384", 0.999999999999999979129L);
insert("u01<float>(maxi32 - int32_t(a)) a=384", 0.499999910593032836914L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=384", 0.999999821186065673828L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=384", 0.499999940395355224609L);
insert("u01<double>(maxi32 - int32_t(a)) a=384", 0.499999910476617515087L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=384", 0.999999820953235030174L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=384", 0.499999910476617515087L);
insert("u01<long double>(maxi32 - int32_t(a)) a=384", 0.499999910476617515087L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=384", 0.999999820953235030174L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=384", 0.499999910476617515087L);
insert("u01<float>(maxi64 - int64_t(a)) a=384", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=384", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=384", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=384", 0.500000000000000000000L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=384", 1.00000000000000000000L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=384", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=384", 0.499999999999999979156L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=384", 0.999999999999999958312L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=384", 0.499999999999999979129L);
insert("u01<float>(minu32 + uint32_t(a)) a=639", 1.48895196616649627686e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=639", 2.97790393233299255371e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=639", 1.78813934326171875000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=639", 1.48895196616649627686e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=639", 2.97790393233299255371e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=639", 1.48895196616649627686e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=639", 1.48895196616649627686e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=639", 2.97790393233299255371e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=639", 1.48895196616649627686e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=639", 3.46673644652240042774e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=639", 6.93347289304480085548e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=639", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=639", 3.46673644652240042774e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=639", 6.93347289304480085548e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=639", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=639", 3.46673644652240042774e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=639", 6.93347289304480085548e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=639", 3.46402594109118666665e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=639", 0.500000119209289550781L);
insert("uneg11<float>(mini32 + int32_t(a)) a=639", -0.999999701976776123047L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=639", 0.500000178813934326172L);
insert("u01<double>(mini32 + int32_t(a)) a=639", 0.500000148895196616650L);
insert("uneg11<double>(mini32 + int32_t(a)) a=639", -0.999999702209606766701L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=639", 0.500000148895196616650L);
insert("u01<long double>(mini32 + int32_t(a)) a=639", 0.500000148895196616650L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=639", -0.999999702209606766701L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=639", 0.500000148895196616650L);
insert("u01<float>(mini64 + int64_t(a)) a=639", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=639", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=639", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=639", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=639", -0.999999999999999888978L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=639", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=639", 0.500000000000000034694L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=639", -0.999999999999999930665L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=639", 0.500000000000000034640L);
insert("u01<float>(maxu32 - uint32_t(a)) a=639", 0.999999880790710449219L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=639", -2.97790393233299255371e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=639", 0.999999821186065673828L);
insert("u01<double>(maxu32 - uint32_t(a)) a=639", 0.999999851104803383350L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=639", -2.97790393233299255371e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=639", 0.999999851104803383350L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=639", 0.999999851104803383350L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=639", -2.97790393233299255371e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=639", 0.999999851104803383350L);
insert("u01<float>(maxu64 - uint64_t(a)) a=639", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=639", -6.93347289304480085548e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=639", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=639", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=639", -6.93347289304480085548e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=639", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=639", 0.999999999999999965306L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=639", -6.93347289304480085548e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=639", 0.999999999999999965360L);
insert("u01<float>(maxi32 - int32_t(a)) a=639", 0.499999850988388061523L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=639", 0.999999701976776123047L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=639", 0.499999821186065673828L);
insert("u01<double>(maxi32 - int32_t(a)) a=639", 0.499999851104803383350L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=639", 0.999999702209606766701L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=639", 0.499999851104803383350L);
insert("u01<long double>(maxi32 - int32_t(a)) a=639", 0.499999851104803383350L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=639", 0.999999702209606766701L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=639", 0.499999851104803383350L);
insert("u01<float>(maxi64 - int64_t(a)) a=639", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=639", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=639", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=639", 0.499999999999999944489L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=639", 0.999999999999999888978L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=639", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=639", 0.499999999999999965333L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=639", 0.999999999999999930665L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=639", 0.499999999999999965360L);
insert("u01<float>(minu32 + uint32_t(a)) a=640", 1.49128027260303497314e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=640", 2.98256054520606994629e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=640", 1.78813934326171875000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=640", 1.49128027260303497314e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=640", 2.98256054520606994629e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=640", 1.49128027260303497314e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=640", 1.49128027260303497314e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=640", 2.98256054520606994629e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=640", 1.49128027260303497314e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=640", 3.47215745738482794991e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=640", 6.94431491476965589982e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=640", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=640", 3.47215745738482794991e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=640", 6.94431491476965589982e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=640", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=640", 3.47215745738482794991e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=640", 6.94431491476965589982e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=640", 3.47486796281604171099e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=640", 0.500000119209289550781L);
insert("uneg11<float>(mini32 + int32_t(a)) a=640", -0.999999701976776123047L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=640", 0.500000178813934326172L);
insert("u01<double>(mini32 + int32_t(a)) a=640", 0.500000149128027260303L);
insert("uneg11<double>(mini32 + int32_t(a)) a=640", -0.999999701743945479393L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=640", 0.500000149128027260303L);
insert("u01<long double>(mini32 + int32_t(a)) a=640", 0.500000149128027260303L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=640", -0.999999701743945479393L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=640", 0.500000149128027260303L);
insert("u01<float>(mini64 + int64_t(a)) a=640", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=640", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=640", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=640", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=640", -0.999999999999999888978L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=640", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=640", 0.500000000000000034694L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=640", -0.999999999999999930557L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=640", 0.500000000000000034749L);
insert("u01<float>(maxu32 - uint32_t(a)) a=640", 0.999999821186065673828L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=640", -2.98256054520606994629e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=640", 0.999999821186065673828L);
insert("u01<double>(maxu32 - uint32_t(a)) a=640", 0.999999850871972739697L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=640", -2.98256054520606994629e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=640", 0.999999850871972739697L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=640", 0.999999850871972739697L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=640", -2.98256054520606994629e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=640", 0.999999850871972739697L);
insert("u01<float>(maxu64 - uint64_t(a)) a=640", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=640", -6.94431491476965589982e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=640", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=640", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=640", -6.94431491476965589982e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=640", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=640", 0.999999999999999965306L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=640", -6.94431491476965589982e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=640", 0.999999999999999965251L);
insert("u01<float>(maxi32 - int32_t(a)) a=640", 0.499999850988388061523L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=640", 0.999999701976776123047L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=640", 0.499999821186065673828L);
insert("u01<double>(maxi32 - int32_t(a)) a=640", 0.499999850871972739697L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=640", 0.999999701743945479393L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=640", 0.499999850871972739697L);
insert("u01<long double>(maxi32 - int32_t(a)) a=640", 0.499999850871972739697L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=640", 0.999999701743945479393L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=640", 0.499999850871972739697L);
insert("u01<float>(maxi64 - int64_t(a)) a=640", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=640", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=640", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=640", 0.499999999999999944489L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=640", 0.999999999999999888978L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=640", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=640", 0.499999999999999965278L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=640", 0.999999999999999930557L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=640", 0.499999999999999965251L);
insert("u01<float>(minu32 + uint32_t(a)) a=641", 1.49360857903957366943e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=641", 2.98721715807914733887e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=641", 1.78813934326171875000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=641", 1.49360857903957366943e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=641", 2.98721715807914733887e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=641", 1.49360857903957366943e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=641", 1.49360857903957366943e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=641", 2.98721715807914733887e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=641", 1.49360857903957366943e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=641", 3.47757846824725547208e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=641", 6.95515693649451094416e-17L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=641", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=641", 3.47757846824725547208e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=641", 6.95515693649451094416e-17L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=641", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=641", 3.47757846824725547208e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=641", 6.95515693649451094416e-17L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=641", 3.47486796281604171099e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=641", 0.500000178813934326172L);
insert("uneg11<float>(mini32 + int32_t(a)) a=641", -0.999999701976776123047L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=641", 0.500000178813934326172L);
insert("u01<double>(mini32 + int32_t(a)) a=641", 0.500000149360857903957L);
insert("uneg11<double>(mini32 + int32_t(a)) a=641", -0.999999701278284192085L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=641", 0.500000149360857903957L);
insert("u01<long double>(mini32 + int32_t(a)) a=641", 0.500000149360857903957L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=641", -0.999999701278284192085L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=641", 0.500000149360857903957L);
insert("u01<float>(mini64 + int64_t(a)) a=641", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=641", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=641", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=641", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=641", -0.999999999999999888978L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=641", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=641", 0.500000000000000034803L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=641", -0.999999999999999930448L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=641", 0.500000000000000034749L);
insert("u01<float>(maxu32 - uint32_t(a)) a=641", 0.999999821186065673828L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=641", -2.98721715807914733887e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=641", 0.999999821186065673828L);
insert("u01<double>(maxu32 - uint32_t(a)) a=641", 0.999999850639142096043L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=641", -2.98721715807914733887e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=641", 0.999999850639142096043L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=641", 0.999999850639142096043L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=641", -2.98721715807914733887e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=641", 0.999999850639142096043L);
insert("u01<float>(maxu64 - uint64_t(a)) a=641", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=641", -6.95515693649451094416e-17L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=641", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=641", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=641", -6.95515693649451094416e-17L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=641", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=641", 0.999999999999999965197L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=641", -6.95515693649451094416e-17L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=641", 0.999999999999999965251L);
insert("u01<float>(maxi32 - int32_t(a)) a=641", 0.499999850988388061523L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=641", 0.999999701976776123047L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=641", 0.499999821186065673828L);
insert("u01<double>(maxi32 - int32_t(a)) a=641", 0.499999850639142096043L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=641", 0.999999701278284192085L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=641", 0.499999850639142096043L);
insert("u01<long double>(maxi32 - int32_t(a)) a=641", 0.499999850639142096043L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=641", 0.999999701278284192085L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=641", 0.499999850639142096043L);
insert("u01<float>(maxi64 - int64_t(a)) a=641", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=641", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=641", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=641", 0.499999999999999944489L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=641", 0.999999999999999888978L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=641", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=641", 0.499999999999999965224L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=641", 0.999999999999999930448L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=641", 0.499999999999999965251L);
insert("u01<float>(minu32 + uint32_t(a)) a=1023", 2.38302163779735565186e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=1023", 4.76604327559471130371e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=1023", 1.78813934326171875000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=1023", 2.38302163779735565186e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=1023", 4.76604327559471130371e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=1023", 2.38302163779735565186e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=1023", 2.38302163779735565186e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=1023", 4.76604327559471130371e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=1023", 2.38302163779735565186e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=1023", 5.54840461769456894103e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=1023", 1.10968092353891378821e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=1023", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=1023", 5.54840461769456894103e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=1023", 1.10968092353891378821e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=1023", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=1023", 5.54840461769456894103e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=1023", 1.10968092353891378821e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=1023", 5.54569411226335517995e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=1023", 0.500000238418579101562L);
insert("uneg11<float>(mini32 + int32_t(a)) a=1023", -0.999999523162841796875L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=1023", 0.500000178813934326172L);
insert("u01<double>(mini32 + int32_t(a)) a=1023", 0.500000238302163779736L);
insert("uneg11<double>(mini32 + int32_t(a)) a=1023", -0.999999523395672440529L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=1023", 0.500000238302163779736L);
insert("u01<long double>(mini32 + int32_t(a)) a=1023", 0.500000238302163779736L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=1023", -0.999999523395672440529L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=1023", 0.500000238302163779736L);
insert("u01<float>(mini64 + int64_t(a)) a=1023", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=1023", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=1023", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=1023", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=1023", -0.999999999999999888978L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=1023", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=1023", 0.500000000000000055511L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=1023", -0.999999999999999889032L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=1023", 0.500000000000000055457L);
insert("u01<float>(maxu32 - uint32_t(a)) a=1023", 0.999999761581420898438L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=1023", -4.76604327559471130371e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=1023", 0.999999821186065673828L);
insert("u01<double>(maxu32 - uint32_t(a)) a=1023", 0.999999761697836220264L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=1023", -4.76604327559471130371e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=1023", 0.999999761697836220264L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=1023", 0.999999761697836220264L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=1023", -4.76604327559471130371e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=1023", 0.999999761697836220264L);
insert("u01<float>(maxu64 - uint64_t(a)) a=1023", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=1023", -1.10968092353891378821e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=1023", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=1023", 1.00000000000000000000L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=1023", -1.10968092353891378821e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=1023", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=1023", 0.999999999999999944489L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=1023", -1.10968092353891378821e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=1023", 0.999999999999999944543L);
insert("u01<float>(maxi32 - int32_t(a)) a=1023", 0.499999761581420898438L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=1023", 0.999999523162841796875L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=1023", 0.499999821186065673828L);
insert("u01<double>(maxi32 - int32_t(a)) a=1023", 0.499999761697836220264L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=1023", 0.999999523395672440529L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=1023", 0.499999761697836220264L);
insert("u01<long double>(maxi32 - int32_t(a)) a=1023", 0.499999761697836220264L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=1023", 0.999999523395672440529L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=1023", 0.499999761697836220264L);
insert("u01<float>(maxi64 - int64_t(a)) a=1023", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=1023", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=1023", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=1023", 0.499999999999999944489L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=1023", 0.999999999999999888978L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=1023", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=1023", 0.499999999999999944516L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=1023", 0.999999999999999889032L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=1023", 0.499999999999999944543L);
insert("u01<float>(minu32 + uint32_t(a)) a=1024", 2.38534994423389434814e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=1024", 4.77069988846778869629e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=1024", 2.98023223876953125000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=1024", 2.38534994423389434814e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=1024", 4.77069988846778869629e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=1024", 2.38534994423389434814e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=1024", 2.38534994423389434814e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=1024", 4.77069988846778869629e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=1024", 2.38534994423389434814e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=1024", 5.55382562855699646320e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=1024", 1.11076512571139929264e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=1024", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=1024", 5.55382562855699646320e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=1024", 1.11076512571139929264e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=1024", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=1024", 5.55382562855699646320e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=1024", 1.11076512571139929264e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=1024", 5.55653613398821022429e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=1024", 0.500000238418579101562L);
insert("uneg11<float>(mini32 + int32_t(a)) a=1024", -0.999999523162841796875L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=1024", 0.500000298023223876953L);
insert("u01<double>(mini32 + int32_t(a)) a=1024", 0.500000238534994423389L);
insert("uneg11<double>(mini32 + int32_t(a)) a=1024", -0.999999522930011153221L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=1024", 0.500000238534994423389L);
insert("u01<long double>(mini32 + int32_t(a)) a=1024", 0.500000238534994423389L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=1024", -0.999999522930011153221L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=1024", 0.500000238534994423389L);
insert("u01<float>(mini64 + int64_t(a)) a=1024", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=1024", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=1024", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=1024", 0.500000000000000000000L);
insert("uneg11<double>(mini64 + int64_t(a)) a=1024", -0.999999999999999888978L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=1024", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=1024", 0.500000000000000055511L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=1024", -0.999999999999999888923L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=1024", 0.500000000000000055565L);
insert("u01<float>(maxu32 - uint32_t(a)) a=1024", 0.999999761581420898438L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=1024", -4.77069988846778869629e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=1024", 0.999999701976776123047L);
insert("u01<double>(maxu32 - uint32_t(a)) a=1024", 0.999999761465005576611L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=1024", -4.77069988846778869629e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=1024", 0.999999761465005576611L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=1024", 0.999999761465005576611L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=1024", -4.77069988846778869629e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=1024", 0.999999761465005576611L);
insert("u01<float>(maxu64 - uint64_t(a)) a=1024", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=1024", -1.11076512571139929264e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=1024", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=1024", 0.999999999999999888978L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=1024", -1.11076512571139929264e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=1024", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=1024", 0.999999999999999944489L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=1024", -1.11076512571139929264e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=1024", 0.999999999999999944435L);
insert("u01<float>(maxi32 - int32_t(a)) a=1024", 0.499999761581420898438L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=1024", 0.999999523162841796875L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=1024", 0.499999701976776123047L);
insert("u01<double>(maxi32 - int32_t(a)) a=1024", 0.499999761465005576611L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=1024", 0.999999522930011153221L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=1024", 0.499999761465005576611L);
insert("u01<long double>(maxi32 - int32_t(a)) a=1024", 0.499999761465005576611L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=1024", 0.999999522930011153221L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=1024", 0.499999761465005576611L);
insert("u01<float>(maxi64 - int64_t(a)) a=1024", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=1024", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=1024", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=1024", 0.499999999999999944489L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=1024", 0.999999999999999888978L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=1024", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=1024", 0.499999999999999944462L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=1024", 0.999999999999999888923L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=1024", 0.499999999999999944435L);
insert("u01<float>(minu32 + uint32_t(a)) a=1025", 2.38767825067043304443e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=1025", 4.77535650134086608887e-07L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=1025", 2.98023223876953125000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=1025", 2.38767825067043304443e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=1025", 4.77535650134086608887e-07L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=1025", 2.38767825067043304443e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=1025", 2.38767825067043304443e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=1025", 4.77535650134086608887e-07L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=1025", 2.38767825067043304443e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=1025", 5.55924663941942398537e-17L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=1025", 1.11184932788388479707e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=1025", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=1025", 5.55924663941942398537e-17L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=1025", 1.11184932788388479707e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=1025", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=1025", 5.55924663941942398537e-17L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=1025", 1.11184932788388479707e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=1025", 5.55653613398821022429e-17L);
insert("u01<float>(mini32 + int32_t(a)) a=1025", 0.500000238418579101562L);
insert("uneg11<float>(mini32 + int32_t(a)) a=1025", -0.999999523162841796875L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=1025", 0.500000298023223876953L);
insert("u01<double>(mini32 + int32_t(a)) a=1025", 0.500000238767825067043L);
insert("uneg11<double>(mini32 + int32_t(a)) a=1025", -0.999999522464349865913L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=1025", 0.500000238767825067043L);
insert("u01<long double>(mini32 + int32_t(a)) a=1025", 0.500000238767825067043L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=1025", -0.999999522464349865913L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=1025", 0.500000238767825067043L);
insert("u01<float>(mini64 + int64_t(a)) a=1025", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=1025", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=1025", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=1025", 0.500000000000000111022L);
insert("uneg11<double>(mini64 + int64_t(a)) a=1025", -0.999999999999999888978L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=1025", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=1025", 0.500000000000000055620L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=1025", -0.999999999999999888815L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=1025", 0.500000000000000055565L);
insert("u01<float>(maxu32 - uint32_t(a)) a=1025", 0.999999761581420898438L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=1025", -4.77535650134086608887e-07L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=1025", 0.999999701976776123047L);
insert("u01<double>(maxu32 - uint32_t(a)) a=1025", 0.999999761232174932957L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=1025", -4.77535650134086608887e-07L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=1025", 0.999999761232174932957L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=1025", 0.999999761232174932957L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=1025", -4.77535650134086608887e-07L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=1025", 0.999999761232174932957L);
insert("u01<float>(maxu64 - uint64_t(a)) a=1025", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=1025", -1.11184932788388479707e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=1025", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=1025", 0.999999999999999888978L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=1025", -1.11184932788388479707e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=1025", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=1025", 0.999999999999999944380L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=1025", -1.11184932788388479707e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=1025", 0.999999999999999944435L);
insert("u01<float>(maxi32 - int32_t(a)) a=1025", 0.499999761581420898438L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=1025", 0.999999523162841796875L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=1025", 0.499999701976776123047L);
insert("u01<double>(maxi32 - int32_t(a)) a=1025", 0.499999761232174932957L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=1025", 0.999999522464349865913L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=1025", 0.499999761232174932957L);
insert("u01<long double>(maxi32 - int32_t(a)) a=1025", 0.499999761232174932957L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=1025", 0.999999522464349865913L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=1025", 0.499999761232174932957L);
insert("u01<float>(maxi64 - int64_t(a)) a=1025", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=1025", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=1025", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=1025", 0.499999999999999944489L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=1025", 0.999999999999999888978L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=1025", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=1025", 0.499999999999999944408L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=1025", 0.999999999999999888815L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=1025", 0.499999999999999944435L);
insert("u01<float>(minu32 + uint32_t(a)) a=3070", 7.14906491339206695557e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=3070", 1.42981298267841339111e-06L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=3070", 6.55651092529296875000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=3070", 7.14906491339206695557e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=3070", 1.42981298267841339111e-06L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=3070", 7.14906491339206695557e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=3070", 7.14906491339206695557e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=3070", 1.42981298267841339111e-06L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=3070", 7.14906491339206695557e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=3070", 1.66452138530837068231e-16L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=3070", 3.32904277061674136462e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=3070", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=3070", 1.66452138530837068231e-16L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=3070", 3.32904277061674136462e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=3070", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=3070", 1.66452138530837068231e-16L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=3070", 3.32904277061674136462e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=3070", 1.66479243585149205842e-16L);
insert("u01<float>(mini32 + int32_t(a)) a=3070", 0.500000715255737304688L);
insert("uneg11<float>(mini32 + int32_t(a)) a=3070", -0.999998569488525390625L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=3070", 0.500000655651092529297L);
insert("u01<double>(mini32 + int32_t(a)) a=3070", 0.500000714906491339207L);
insert("uneg11<double>(mini32 + int32_t(a)) a=3070", -0.999998570187017321587L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=3070", 0.500000714906491339207L);
insert("u01<long double>(mini32 + int32_t(a)) a=3070", 0.500000714906491339207L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=3070", -0.999998570187017321587L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=3070", 0.500000714906491339207L);
insert("u01<float>(mini64 + int64_t(a)) a=3070", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=3070", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=3070", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=3070", 0.500000000000000111022L);
insert("uneg11<double>(mini64 + int64_t(a)) a=3070", -0.999999999999999666933L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=3070", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=3070", 0.500000000000000166425L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=3070", -0.999999999999999667096L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=3070", 0.500000000000000166479L);
insert("u01<float>(maxu32 - uint32_t(a)) a=3070", 0.999999284744262695312L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=3070", -1.42981298267841339111e-06L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=3070", 0.999999344348907470703L);
insert("u01<double>(maxu32 - uint32_t(a)) a=3070", 0.999999285093508660793L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=3070", -1.42981298267841339111e-06L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=3070", 0.999999285093508660793L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=3070", 0.999999285093508660793L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=3070", -1.42981298267841339111e-06L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=3070", 0.999999285093508660793L);
insert("u01<float>(maxu64 - uint64_t(a)) a=3070", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=3070", -3.32904277061674136462e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=3070", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=3070", 0.999999999999999888978L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=3070", -3.32904277061674136462e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=3070", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=3070", 0.999999999999999833575L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=3070", -3.32904277061674136462e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=3070", 0.999999999999999833521L);
insert("u01<float>(maxi32 - int32_t(a)) a=3070", 0.499999284744262695312L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=3070", 0.999998569488525390625L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=3070", 0.499999344348907470703L);
insert("u01<double>(maxi32 - int32_t(a)) a=3070", 0.499999285093508660793L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=3070", 0.999998570187017321587L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=3070", 0.499999285093508660793L);
insert("u01<long double>(maxi32 - int32_t(a)) a=3070", 0.499999285093508660793L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=3070", 0.999998570187017321587L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=3070", 0.499999285093508660793L);
insert("u01<float>(maxi64 - int64_t(a)) a=3070", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=3070", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=3070", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=3070", 0.499999999999999833467L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=3070", 0.999999999999999666933L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=3070", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=3070", 0.499999999999999833548L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=3070", 0.999999999999999667096L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=3070", 0.499999999999999833521L);
insert("u01<float>(minu32 + uint32_t(a)) a=3071", 7.15139321982860565186e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=3071", 1.43027864396572113037e-06L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=3071", 6.55651092529296875000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=3071", 7.15139321982860565186e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=3071", 1.43027864396572113037e-06L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=3071", 7.15139321982860565186e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=3071", 7.15139321982860565186e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=3071", 1.43027864396572113037e-06L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=3071", 7.15139321982860565186e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=3071", 1.66506348639461343453e-16L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=3071", 3.33012697278922686905e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=3071", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=3071", 1.66506348639461343453e-16L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=3071", 3.33012697278922686905e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=3071", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=3071", 1.66506348639461343453e-16L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=3071", 3.33012697278922686905e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=3071", 1.66479243585149205842e-16L);
insert("u01<float>(mini32 + int32_t(a)) a=3071", 0.500000715255737304688L);
insert("uneg11<float>(mini32 + int32_t(a)) a=3071", -0.999998569488525390625L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=3071", 0.500000655651092529297L);
insert("u01<double>(mini32 + int32_t(a)) a=3071", 0.500000715139321982861L);
insert("uneg11<double>(mini32 + int32_t(a)) a=3071", -0.999998569721356034279L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=3071", 0.500000715139321982861L);
insert("u01<long double>(mini32 + int32_t(a)) a=3071", 0.500000715139321982861L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=3071", -0.999998569721356034279L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=3071", 0.500000715139321982861L);
insert("u01<float>(mini64 + int64_t(a)) a=3071", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=3071", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=3071", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=3071", 0.500000000000000111022L);
insert("uneg11<double>(mini64 + int64_t(a)) a=3071", -0.999999999999999666933L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=3071", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=3071", 0.500000000000000166533L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=3071", -0.999999999999999666987L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=3071", 0.500000000000000166479L);
insert("u01<float>(maxu32 - uint32_t(a)) a=3071", 0.999999284744262695312L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=3071", -1.43027864396572113037e-06L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=3071", 0.999999344348907470703L);
insert("u01<double>(maxu32 - uint32_t(a)) a=3071", 0.999999284860678017139L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=3071", -1.43027864396572113037e-06L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=3071", 0.999999284860678017139L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=3071", 0.999999284860678017139L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=3071", -1.43027864396572113037e-06L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=3071", 0.999999284860678017139L);
insert("u01<float>(maxu64 - uint64_t(a)) a=3071", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=3071", -3.33012697278922686905e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=3071", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=3071", 0.999999999999999777955L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=3071", -3.33012697278922686905e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=3071", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=3071", 0.999999999999999833467L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=3071", -3.33012697278922686905e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=3071", 0.999999999999999833521L);
insert("u01<float>(maxi32 - int32_t(a)) a=3071", 0.499999284744262695312L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=3071", 0.999998569488525390625L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=3071", 0.499999344348907470703L);
insert("u01<double>(maxi32 - int32_t(a)) a=3071", 0.499999284860678017139L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=3071", 0.999998569721356034279L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=3071", 0.499999284860678017139L);
insert("u01<long double>(maxi32 - int32_t(a)) a=3071", 0.499999284860678017139L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=3071", 0.999998569721356034279L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=3071", 0.499999284860678017139L);
insert("u01<float>(maxi64 - int64_t(a)) a=3071", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=3071", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=3071", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=3071", 0.499999999999999833467L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=3071", 0.999999999999999666933L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=3071", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=3071", 0.499999999999999833494L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=3071", 0.999999999999999666987L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=3071", 0.499999999999999833521L);
insert("u01<float>(minu32 + uint32_t(a)) a=3072", 7.15372152626514434814e-07L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=3072", 1.43074430525302886963e-06L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=3072", 7.74860382080078125000e-07L);
insert("u01<double>(minu32 + uint32_t(a)) a=3072", 7.15372152626514434814e-07L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=3072", 1.43074430525302886963e-06L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=3072", 7.15372152626514434814e-07L);
insert("u01<long double>(minu32 + uint32_t(a)) a=3072", 7.15372152626514434814e-07L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=3072", 1.43074430525302886963e-06L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=3072", 7.15372152626514434814e-07L);
insert("u01<float>(minu64 + uint64_t(a)) a=3072", 1.66560558748085618674e-16L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=3072", 3.33121117496171237349e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=3072", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=3072", 1.66560558748085618674e-16L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=3072", 3.33121117496171237349e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=3072", 1.11022302462515654042e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=3072", 1.66560558748085618674e-16L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=3072", 3.33121117496171237349e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=3072", 1.66587663802397756285e-16L);
insert("u01<float>(mini32 + int32_t(a)) a=3072", 0.500000715255737304688L);
insert("uneg11<float>(mini32 + int32_t(a)) a=3072", -0.999998569488525390625L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=3072", 0.500000774860382080078L);
insert("u01<double>(mini32 + int32_t(a)) a=3072", 0.500000715372152626514L);
insert("uneg11<double>(mini32 + int32_t(a)) a=3072", -0.999998569255694746971L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=3072", 0.500000715372152626514L);
insert("u01<long double>(mini32 + int32_t(a)) a=3072", 0.500000715372152626514L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=3072", -0.999998569255694746971L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=3072", 0.500000715372152626514L);
insert("u01<float>(mini64 + int64_t(a)) a=3072", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=3072", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=3072", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=3072", 0.500000000000000222045L);
insert("uneg11<double>(mini64 + int64_t(a)) a=3072", -0.999999999999999666933L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=3072", 0.500000000000000111022L);
insert("u01<long double>(mini64 + int64_t(a)) a=3072", 0.500000000000000166533L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=3072", -0.999999999999999666879L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=3072", 0.500000000000000166588L);
insert("u01<float>(maxu32 - uint32_t(a)) a=3072", 0.999999284744262695312L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=3072", -1.43074430525302886963e-06L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=3072", 0.999999225139617919922L);
insert("u01<double>(maxu32 - uint32_t(a)) a=3072", 0.999999284627847373486L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=3072", -1.43074430525302886963e-06L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=3072", 0.999999284627847373486L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=3072", 0.999999284627847373486L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=3072", -1.43074430525302886963e-06L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=3072", 0.999999284627847373486L);
insert("u01<float>(maxu64 - uint64_t(a)) a=3072", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=3072", -3.33121117496171237349e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=3072", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=3072", 0.999999999999999777955L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=3072", -3.33121117496171237349e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=3072", 0.999999999999999888978L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=3072", 0.999999999999999833467L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=3072", -3.33121117496171237349e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=3072", 0.999999999999999833412L);
insert("u01<float>(maxi32 - int32_t(a)) a=3072", 0.499999284744262695312L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=3072", 0.999998569488525390625L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=3072", 0.499999225139617919922L);
insert("u01<double>(maxi32 - int32_t(a)) a=3072", 0.499999284627847373486L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=3072", 0.999998569255694746971L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=3072", 0.499999284627847373486L);
insert("u01<long double>(maxi32 - int32_t(a)) a=3072", 0.499999284627847373486L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=3072", 0.999998569255694746971L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=3072", 0.499999284627847373486L);
insert("u01<float>(maxi64 - int64_t(a)) a=3072", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=3072", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=3072", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=3072", 0.499999999999999833467L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=3072", 0.999999999999999666933L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=3072", 0.499999999999999888978L);
insert("u01<long double>(maxi64 - int64_t(a)) a=3072", 0.499999999999999833439L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=3072", 0.999999999999999666879L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=3072", 0.499999999999999833412L);
insert("u01<float>(minu32 + uint32_t(a)) a=5119", 1.19197648018598556519e-06L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=5119", 2.38395296037197113037e-06L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=5119", 1.13248825073242187500e-06L);
insert("u01<double>(minu32 + uint32_t(a)) a=5119", 1.19197648018598556519e-06L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=5119", 2.38395296037197113037e-06L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=5119", 1.19197648018598556519e-06L);
insert("u01<long double>(minu32 + uint32_t(a)) a=5119", 1.19197648018598556519e-06L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=5119", 2.38395296037197113037e-06L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=5119", 1.19197648018598556519e-06L);
insert("u01<float>(minu64 + uint64_t(a)) a=5119", 2.77528651101976997495e-16L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=5119", 5.55057302203953994990e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=5119", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=5119", 2.77528651101976997495e-16L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=5119", 5.55057302203953994990e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=5119", 3.33066907387546962127e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=5119", 2.77528651101976997495e-16L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=5119", 5.55057302203953994990e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=5119", 2.77501546047664859884e-16L);
insert("u01<float>(mini32 + int32_t(a)) a=5119", 0.500001192092895507812L);
insert("uneg11<float>(mini32 + int32_t(a)) a=5119", -0.999997615814208984375L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=5119", 0.500001132488250732422L);
insert("u01<double>(mini32 + int32_t(a)) a=5119", 0.500001191976480185986L);
insert("uneg11<double>(mini32 + int32_t(a)) a=5119", -0.999997616047039628029L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=5119", 0.500001191976480185986L);
insert("u01<long double>(mini32 + int32_t(a)) a=5119", 0.500001191976480185986L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=5119", -0.999997616047039628029L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=5119", 0.500001191976480185986L);
insert("u01<float>(mini64 + int64_t(a)) a=5119", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=5119", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=5119", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=5119", 0.500000000000000222045L);
insert("uneg11<double>(mini64 + int64_t(a)) a=5119", -0.999999999999999444888L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=5119", 0.500000000000000333067L);
insert("u01<long double>(mini64 + int64_t(a)) a=5119", 0.500000000000000277556L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=5119", -0.999999999999999444943L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=5119", 0.500000000000000277502L);
insert("u01<float>(maxu32 - uint32_t(a)) a=5119", 0.999998807907104492188L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=5119", -2.38395296037197113037e-06L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=5119", 0.999998867511749267578L);
insert("u01<double>(maxu32 - uint32_t(a)) a=5119", 0.999998808023519814014L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=5119", -2.38395296037197113037e-06L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=5119", 0.999998808023519814014L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=5119", 0.999998808023519814014L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=5119", -2.38395296037197113037e-06L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=5119", 0.999998808023519814014L);
insert("u01<float>(maxu64 - uint64_t(a)) a=5119", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=5119", -5.55057302203953994990e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=5119", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=5119", 0.999999999999999777955L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=5119", -5.55057302203953994990e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=5119", 0.999999999999999666933L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=5119", 0.999999999999999722444L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=5119", -5.55057302203953994990e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=5119", 0.999999999999999722498L);
insert("u01<float>(maxi32 - int32_t(a)) a=5119", 0.499998807907104492188L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=5119", 0.999997615814208984375L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=5119", 0.499998867511749267578L);
insert("u01<double>(maxi32 - int32_t(a)) a=5119", 0.499998808023519814014L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=5119", 0.999997616047039628029L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=5119", 0.499998808023519814014L);
insert("u01<long double>(maxi32 - int32_t(a)) a=5119", 0.499998808023519814014L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=5119", 0.999997616047039628029L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=5119", 0.499998808023519814014L);
insert("u01<float>(maxi64 - int64_t(a)) a=5119", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=5119", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=5119", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=5119", 0.499999999999999722444L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=5119", 0.999999999999999444888L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=5119", 0.499999999999999666933L);
insert("u01<long double>(maxi64 - int64_t(a)) a=5119", 0.499999999999999722471L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=5119", 0.999999999999999444943L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=5119", 0.499999999999999722498L);
insert("u01<float>(minu32 + uint32_t(a)) a=5120", 1.19220931082963943481e-06L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=5120", 2.38441862165927886963e-06L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=5120", 1.25169754028320312500e-06L);
insert("u01<double>(minu32 + uint32_t(a)) a=5120", 1.19220931082963943481e-06L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=5120", 2.38441862165927886963e-06L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=5120", 1.19220931082963943481e-06L);
insert("u01<long double>(minu32 + uint32_t(a)) a=5120", 1.19220931082963943481e-06L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=5120", 2.38441862165927886963e-06L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=5120", 1.19220931082963943481e-06L);
insert("u01<float>(minu64 + uint64_t(a)) a=5120", 2.77582861210601272717e-16L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=5120", 5.55165722421202545434e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=5120", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=5120", 2.77582861210601272717e-16L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=5120", 5.55165722421202545434e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=5120", 3.33066907387546962127e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=5120", 2.77582861210601272717e-16L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=5120", 5.55165722421202545434e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=5120", 2.77609966264913410328e-16L);
insert("u01<float>(mini32 + int32_t(a)) a=5120", 0.500001192092895507812L);
insert("uneg11<float>(mini32 + int32_t(a)) a=5120", -0.999997615814208984375L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=5120", 0.500001251697540283203L);
insert("u01<double>(mini32 + int32_t(a)) a=5120", 0.500001192209310829639L);
insert("uneg11<double>(mini32 + int32_t(a)) a=5120", -0.999997615581378340721L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=5120", 0.500001192209310829639L);
insert("u01<long double>(mini32 + int32_t(a)) a=5120", 0.500001192209310829639L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=5120", -0.999997615581378340721L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=5120", 0.500001192209310829639L);
insert("u01<float>(mini64 + int64_t(a)) a=5120", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=5120", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=5120", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=5120", 0.500000000000000222045L);
insert("uneg11<double>(mini64 + int64_t(a)) a=5120", -0.999999999999999444888L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=5120", 0.500000000000000333067L);
insert("u01<long double>(mini64 + int64_t(a)) a=5120", 0.500000000000000277556L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=5120", -0.999999999999999444834L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=5120", 0.500000000000000277610L);
insert("u01<float>(maxu32 - uint32_t(a)) a=5120", 0.999998807907104492188L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=5120", -2.38441862165927886963e-06L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=5120", 0.999998748302459716797L);
insert("u01<double>(maxu32 - uint32_t(a)) a=5120", 0.999998807790689170361L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=5120", -2.38441862165927886963e-06L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=5120", 0.999998807790689170361L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=5120", 0.999998807790689170361L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=5120", -2.38441862165927886963e-06L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=5120", 0.999998807790689170361L);
insert("u01<float>(maxu64 - uint64_t(a)) a=5120", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=5120", -5.55165722421202545434e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=5120", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=5120", 0.999999999999999666933L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=5120", -5.55165722421202545434e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=5120", 0.999999999999999666933L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=5120", 0.999999999999999722444L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=5120", -5.55165722421202545434e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=5120", 0.999999999999999722390L);
insert("u01<float>(maxi32 - int32_t(a)) a=5120", 0.499998807907104492188L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=5120", 0.999997615814208984375L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=5120", 0.499998748302459716797L);
insert("u01<double>(maxi32 - int32_t(a)) a=5120", 0.499998807790689170361L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=5120", 0.999997615581378340721L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=5120", 0.499998807790689170361L);
insert("u01<long double>(maxi32 - int32_t(a)) a=5120", 0.499998807790689170361L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=5120", 0.999997615581378340721L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=5120", 0.499998807790689170361L);
insert("u01<float>(maxi64 - int64_t(a)) a=5120", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=5120", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=5120", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=5120", 0.499999999999999722444L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=5120", 0.999999999999999444888L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=5120", 0.499999999999999666933L);
insert("u01<long double>(maxi64 - int64_t(a)) a=5120", 0.499999999999999722417L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=5120", 0.999999999999999444834L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=5120", 0.499999999999999722390L);
insert("u01<float>(minu32 + uint32_t(a)) a=5121", 1.19244214147329330444e-06L);
insert("uneg11<float>(minu32 + uint32_t(a)) a=5121", 2.38488428294658660889e-06L);
insert("u01fixedpt<float>(minu32 + uint32_t(a)) a=5121", 1.25169754028320312500e-06L);
insert("u01<double>(minu32 + uint32_t(a)) a=5121", 1.19244214147329330444e-06L);
insert("uneg11<double>(minu32 + uint32_t(a)) a=5121", 2.38488428294658660889e-06L);
insert("u01fixedpt<double>(minu32 + uint32_t(a)) a=5121", 1.19244214147329330444e-06L);
insert("u01<long double>(minu32 + uint32_t(a)) a=5121", 1.19244214147329330444e-06L);
insert("uneg11<long double>(minu32 + uint32_t(a)) a=5121", 2.38488428294658660889e-06L);
insert("u01fixedpt<long double>(minu32 + uint32_t(a)) a=5121", 1.19244214147329330444e-06L);
insert("u01<float>(minu64 + uint64_t(a)) a=5121", 2.77637071319225547938e-16L);
insert("uneg11<float>(minu64 + uint64_t(a)) a=5121", 5.55274142638451095877e-16L);
insert("u01fixedpt<float>(minu64 + uint64_t(a)) a=5121", 5.96046447753906250000e-08L);
insert("u01<double>(minu64 + uint64_t(a)) a=5121", 2.77637071319225547938e-16L);
insert("uneg11<double>(minu64 + uint64_t(a)) a=5121", 5.55274142638451095877e-16L);
insert("u01fixedpt<double>(minu64 + uint64_t(a)) a=5121", 3.33066907387546962127e-16L);
insert("u01<long double>(minu64 + uint64_t(a)) a=5121", 2.77637071319225547938e-16L);
insert("uneg11<long double>(minu64 + uint64_t(a)) a=5121", 5.55274142638451095877e-16L);
insert("u01fixedpt<long double>(minu64 + uint64_t(a)) a=5121", 2.77609966264913410328e-16L);
insert("u01<float>(mini32 + int32_t(a)) a=5121", 0.500001192092895507812L);
insert("uneg11<float>(mini32 + int32_t(a)) a=5121", -0.999997615814208984375L);
insert("u01fixedpt<float>(mini32 + int32_t(a)) a=5121", 0.500001251697540283203L);
insert("u01<double>(mini32 + int32_t(a)) a=5121", 0.500001192442141473293L);
insert("uneg11<double>(mini32 + int32_t(a)) a=5121", -0.999997615115717053413L);
insert("u01fixedpt<double>(mini32 + int32_t(a)) a=5121", 0.500001192442141473293L);
insert("u01<long double>(mini32 + int32_t(a)) a=5121", 0.500001192442141473293L);
insert("uneg11<long double>(mini32 + int32_t(a)) a=5121", -0.999997615115717053413L);
insert("u01fixedpt<long double>(mini32 + int32_t(a)) a=5121", 0.500001192442141473293L);
insert("u01<float>(mini64 + int64_t(a)) a=5121", 0.500000000000000000000L);
insert("uneg11<float>(mini64 + int64_t(a)) a=5121", -1.00000000000000000000L);
insert("u01fixedpt<float>(mini64 + int64_t(a)) a=5121", 0.500000059604644775391L);
insert("u01<double>(mini64 + int64_t(a)) a=5121", 0.500000000000000333067L);
insert("uneg11<double>(mini64 + int64_t(a)) a=5121", -0.999999999999999444888L);
insert("u01fixedpt<double>(mini64 + int64_t(a)) a=5121", 0.500000000000000333067L);
insert("u01<long double>(mini64 + int64_t(a)) a=5121", 0.500000000000000277664L);
insert("uneg11<long double>(mini64 + int64_t(a)) a=5121", -0.999999999999999444726L);
insert("u01fixedpt<long double>(mini64 + int64_t(a)) a=5121", 0.500000000000000277610L);
insert("u01<float>(maxu32 - uint32_t(a)) a=5121", 0.999998807907104492188L);
insert("uneg11<float>(maxu32 - uint32_t(a)) a=5121", -2.38488428294658660889e-06L);
insert("u01fixedpt<float>(maxu32 - uint32_t(a)) a=5121", 0.999998748302459716797L);
insert("u01<double>(maxu32 - uint32_t(a)) a=5121", 0.999998807557858526707L);
insert("uneg11<double>(maxu32 - uint32_t(a)) a=5121", -2.38488428294658660889e-06L);
insert("u01fixedpt<double>(maxu32 - uint32_t(a)) a=5121", 0.999998807557858526707L);
insert("u01<long double>(maxu32 - uint32_t(a)) a=5121", 0.999998807557858526707L);
insert("uneg11<long double>(maxu32 - uint32_t(a)) a=5121", -2.38488428294658660889e-06L);
insert("u01fixedpt<long double>(maxu32 - uint32_t(a)) a=5121", 0.999998807557858526707L);
insert("u01<float>(maxu64 - uint64_t(a)) a=5121", 1.00000000000000000000L);
insert("uneg11<float>(maxu64 - uint64_t(a)) a=5121", -5.55274142638451095877e-16L);
insert("u01fixedpt<float>(maxu64 - uint64_t(a)) a=5121", 0.999999940395355224609L);
insert("u01<double>(maxu64 - uint64_t(a)) a=5121", 0.999999999999999666933L);
insert("uneg11<double>(maxu64 - uint64_t(a)) a=5121", -5.55274142638451095877e-16L);
insert("u01fixedpt<double>(maxu64 - uint64_t(a)) a=5121", 0.999999999999999666933L);
insert("u01<long double>(maxu64 - uint64_t(a)) a=5121", 0.999999999999999722336L);
insert("uneg11<long double>(maxu64 - uint64_t(a)) a=5121", -5.55274142638451095877e-16L);
insert("u01fixedpt<long double>(maxu64 - uint64_t(a)) a=5121", 0.999999999999999722390L);
insert("u01<float>(maxi32 - int32_t(a)) a=5121", 0.499998807907104492188L);
insert("uneg11<float>(maxi32 - int32_t(a)) a=5121", 0.999997615814208984375L);
insert("u01fixedpt<float>(maxi32 - int32_t(a)) a=5121", 0.499998748302459716797L);
insert("u01<double>(maxi32 - int32_t(a)) a=5121", 0.499998807557858526707L);
insert("uneg11<double>(maxi32 - int32_t(a)) a=5121", 0.999997615115717053413L);
insert("u01fixedpt<double>(maxi32 - int32_t(a)) a=5121", 0.499998807557858526707L);
insert("u01<long double>(maxi32 - int32_t(a)) a=5121", 0.499998807557858526707L);
insert("uneg11<long double>(maxi32 - int32_t(a)) a=5121", 0.999997615115717053413L);
insert("u01fixedpt<long double>(maxi32 - int32_t(a)) a=5121", 0.499998807557858526707L);
insert("u01<float>(maxi64 - int64_t(a)) a=5121", 0.500000000000000000000L);
insert("uneg11<float>(maxi64 - int64_t(a)) a=5121", 1.00000000000000000000L);
insert("u01fixedpt<float>(maxi64 - int64_t(a)) a=5121", 0.499999940395355224609L);
insert("u01<double>(maxi64 - int64_t(a)) a=5121", 0.499999999999999722444L);
insert("uneg11<double>(maxi64 - int64_t(a)) a=5121", 0.999999999999999444888L);
insert("u01fixedpt<double>(maxi64 - int64_t(a)) a=5121", 0.499999999999999666933L);
insert("u01<long double>(maxi64 - int64_t(a)) a=5121", 0.499999999999999722363L);
insert("uneg11<long double>(maxi64 - int64_t(a)) a=5121", 0.999999999999999444726L);
insert("u01fixedpt<long double>(maxi64 - int64_t(a)) a=5121", 0.499999999999999722390L);
// ./ut_uniform_IEEEkat: SUCCESS
