/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File FolderDrawers.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef FolderDrawers_H
#define FolderDrawers_H

#ifndef FolderObserver_H  
#include "FolderObserver.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#include <Xm/Xm.h>

class IconDrawer;

class FolderDrawers :  public FolderObserver {

public:

// -- Exceptions
	// None

// -- Contructors

	FolderDrawers(Folder*);

// -- Destructor

	virtual ~FolderDrawers(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	
	void install(Widget);
	virtual bool fill(int) = 0;

	Widget widget();
	virtual void newFolder();

// -- Overridden methods
	// None

// -- Class members
	// None 


// -- Class methods
	// None 
	

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected: 
	// -- Contructors


// -- Members
	// None
	FolderH folder_;


// -- Methods

	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None 

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed
	FolderDrawers(const FolderDrawers&);
	FolderDrawers& operator=(const FolderDrawers&);

// -- Members

	map<FolderH,IconDrawer*> drawers_;
	Widget  widget_;
	static bool doneFill_;
	static bool doneUpdate_;

// -- Methods  

// -- Overridden methods
       	 
	 // from FolderObserver

	virtual void arrived(IconObject*);
	virtual void gone(IconObject*);
	virtual void position(IconObject*,int,int);
	virtual void renamed(IconObject*);

	virtual void opened(IconObject*);
	virtual void closed(IconObject*);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const FolderDrawers& p)
	//	{ p.print(s); return s; }

};

inline void destroy(FolderDrawers**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FolderDrawers);
//#endif

#endif
