C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_vs98.F 
C> The nwxcm_c_vs98 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_vs98 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}\,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_8} &=& {{2.0\,\tau_\alpha}\over{\rho_\alpha^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_9} &=& 0.00515088\,\left({\it t_8}+{\it t_7}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{10}} &=& {{1}\over{{\it t_9}}}\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{12}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_9}^2}}\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{15}} &=& {\it t_8}-9.11559972\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{23}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{22}}+2.225569421150687\,{\it t_{21}}+0.8004286349993635
C>    \,{\it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{21}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{22}}+3.844746237447211\,{\it t_{21}}+1.644733775567609
C>    \,{\it t_{20}}+0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{21}}+1.0\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{25}} &=& {\it t_{24}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{26}} &=& {{2.0\,\tau_\beta}\over{\rho_\beta^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_{27}} &=& 0.00515088\,\left({\it t_{26}}+{\it t_{25}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{27}}}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{{\it t_{27}}^2}}\\\\ 
C>   {\it t_{30}} &=& {\it t_{26}}-9.11559972\\\\ 
C>   {\it t_{31}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{31}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{33}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{34}} &=& {\it t_{33}}^4\\\\ 
C>   {\it t_{35}} &=& {{1}\over{{\it t_{31}}^4}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_{31}}}}\\\\ 
C>   {\it t_{37}} &=& \left({\it t_{33}}\,{\it t_{36}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{33}}\,{
C>    \it t_{36}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{38}} &=& -1.923661050931536\,{\it t_{34}}\,{\it t_{35}}
C>    \,{\it t_{37}}\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{31}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\sqrt{{\it t_{31}}}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{31}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{42}} &=& 0.00304966\,\left({\it t_{26}}+{\it t_8}+{
C>    \it t_{25}}+{\it t_7}-18.23119944\right)+1.0\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{42}}}}\\\\ 
C>   {\it t_{44}} &=& {\it t_{25}}+{\it t_7}\\\\ 
C>   {\it t_{45}} &=& {{1}\over{{\it t_{42}}^2}}\\\\ 
C>   {\it t_{46}} &=& {\it t_{26}}+{\it t_8}-18.23119944\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{51}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{52}} &=& {{2.0\,\tau_s}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{53}} &=& 0.00515088\,\left({\it t_{52}}+{\it t_{51}}
C>    \,\sigma_{ss}-9.11559972\right)+1.0\\\\ 
C>   {\it t_{54}} &=& {{1}\over{{\it t_{53}}}}\\\\ 
C>   {\it t_{55}} &=& {{1}\over{{\it t_{53}}^2}}\\\\ 
C>   {\it t_{56}} &=& {\it t_{52}}-9.11559972\\\\ 
C>   f &=& 1.0\,\left({\it t_{31}}\,\left(-0.0598079686361971\,{
C>    \it t_{34}}\,{\it t_{35}}\,\left(0.1274696188700087\,{
C>    \it t_{32}}+1.0\right)\,{\it t_{37}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{41}}
C>    +3.844746237447211\,{\it t_{32}}+1.644733775567609\,{\it t_{40}}
C>    +0.2405871291288192\,{\it t_{39}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{32}}
C>    +1.0\right)\,\left({\it t_{38}}+1.923661050931536\,{
C>    \it t_{37}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{41}}+2.247591863577616\,{
C>    \it t_{32}}+0.4300972471276643\,{\it t_{40}}
C>    +0.1911512595127337\,{\it t_{39}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{32}}+1.0\right)\,\left({
C>    \it t_{38}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{41}}+2.225569421150687\,{
C>    \it t_{32}}+0.8004286349993635\,{\it t_{40}}
C>    +0.1897004325747558\,{\it t_{39}}}}+1.0\right)\right)-{
C>    \it t_{23}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)\,{
C>    \it t_{43}}\,\left({\it param}\left(3\right)\,{\it t_{46}}
C>    \,{\it t_{43}}+{\it param}\left(2\right)\,{\it t_{44}}\,{
C>    \it t_{43}}+{\it param}\left(6\right)\,{\it t_{46}}^2\,{
C>    \it t_{45}}+{\it param}\left(5\right)\,{\it t_{44}}\,{
C>    \it t_{46}}\,{\it t_{45}}+{\it param}\left(4\right)\,{
C>    \it t_{44}}^2\,{\it t_{45}}+{\it param}\left(1\right)\right)
C>    +1.0\,{\it t_{23}}\,\rho_\beta\,\left(1.0-{{0.125\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta\,\tau_\beta}}\right)\,{
C>    \it t_{28}}\,\left({\it t_{18}}\,{\it t_{30}}\,{\it t_{28}}
C>    +{\it t_{17}}\,{\it t_{24}}\,\sigma_{\beta\beta}\,{\it t_{28}}
C>    +{\it t_{16}}\,{\it t_{30}}^2\,{\it t_{29}}+{\it t_{14}}\,{
C>    \it t_{24}}\,\sigma_{\beta\beta}\,{\it t_{30}}\,{\it t_{29}}
C>    +{{{\it t_{12}}\,\sigma_{\beta\beta}^2\,{\it t_{29}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{11}}\right)+1.0
C>    \,{\it t_5}\,\rho_\alpha\,\left(1.0-{{0.125\,
C>    \sigma_{\alpha\alpha}}\over{\rho_\alpha\,\tau_\alpha}}\right)
C>    \,{\it t_{10}}\,\left({\it t_{18}}\,{\it t_{15}}\,{\it t_{10}}
C>    +{\it t_{17}}\,{\it t_6}\,\sigma_{\alpha\alpha}\,{\it t_{10}}
C>    +{\it t_{16}}\,{\it t_{15}}^2\,{\it t_{13}}+{\it t_{14}}\,{
C>    \it t_6}\,\sigma_{\alpha\alpha}\,{\it t_{15}}\,{\it t_{13}}
C>    +{{{\it t_{12}}\,\sigma_{\alpha\alpha}^2\,{\it t_{13}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{11}}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{50}}+2.225569421150687\,{\it t_{49}}+0.8004286349993635
C>    \,{\it t_{48}}+0.1897004325747558\,{\it t_{47}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{49}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{50}}+3.844746237447211\,{\it t_{49}}+1.644733775567609
C>    \,{\it t_{48}}+0.2405871291288192\,{\it t_{47}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{49}}+1.0\right)\right)
C>    \,\rho_s\,\left(1.0-{{0.125\,\sigma_{ss}}\over{\rho_s
C>    \,\tau_s}}\right)\,{\it t_{54}}\,\left({\it t_{18}}\,{
C>    \it t_{56}}\,{\it t_{54}}+{\it t_{17}}\,{\it t_{51}}\,
C>    \sigma_{ss}\,{\it t_{54}}+{\it t_{16}}\,{\it t_{56}}^2\,{
C>    \it t_{55}}+{\it t_{14}}\,{\it t_{51}}\,\sigma_{ss}\,{
C>    \it t_{56}}\,{\it t_{55}}+{{{\it t_{12}}\,\sigma_{ss}^2\,{
C>    \it t_{55}}}\over{\rho_s^{{{16}\over{3}}}}}+{
C>    \it t_{11}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] T van Voorhis, GE Scuseria, J.Chem.Phys. 109, 400 (1998)  , DOI: 
C> <a href="https://doi.org/10.1063/1.3005348 "> 
C> 10.1063/1.3005348 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_vs98(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taua
              t21 = 5.15088d-3*(t20+gammaaa*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammaaa**2
              t25 = 1/rhoa**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammaaa*t18*t22*t31+t26*t29*t30+gammaaa*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = -2*rhoa*t14
              t35 = 4.0d+0*t19*taua
              t36 = 3.04966d-3*(t35+2*gammaaa*t18-1.823119944d+1)+1.0d+0
              t37 = 1/t36
              t38 = param(4)
              t39 = 1/t36**2
              t40 = param(5)
              t41 = t35-1.823119944d+1
              t42 = param(6)
              t43 = t41**2
              t44 = param(2)
              t45 = param(3)
              t46 = t37*t41*t45+2*gammaaa*t18*t37*t44+t39*t42*t43+2*gamm
     1           aaa*t18*t39*t40*t41+4*t24*t25*t38*t39+param(1)
              t47 = 1/rhoa**3.6666666666666664d+0
              t48 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d+
     1           0*gammaaa*t47
              t49 = 1/t21**3
              t50 = 1/rhoa**6.333333333333333d+0
              t51 = 1/t2**3
              t52 = 1/rhoa**1.3333333333333333d+0
              t53 = 1/rhoa**1.1666666666666667d+0
              t54 = 1.0d+0*(-1.8533958105157808d+0*t53-1.281582079149070
     1           4d+0*t52-8.223668877838045d-1*t51-1.6039141941921276d-1
     2           *t19)*t9/(t6**2*t7)+1.3210398931339265d-3*t52*t8+1.1102
     3           230246251565d-16*t13*(-9.970917392951799d-1*t53-7.41856
     4           4737168958d-1*t52-4.002143174996817d-1*t51-1.2646695504
     5           98372d-1*t19)/(t10**2*t11)+3.0506411443514264d-19*t12*t
     6           52
              t55 = 1.414213562373095d+0
              t56 = 7.937005259840998d-1
              t57 = 2.2255694211506874d+0*t4*t56+8.004286349993635d-1*t3
     1           /t55+5.329846514438382d+0*t5+1.1950378408754898d-1*t1
              t58 = 1.6081979498692536d+1/t57+1.0d+0
              t59 = log(t58)
              t60 = 1.3256889990520176d-1*t4*t56+1.0d+0
              t61 = t34-1.243628d-1*rhoa*t59*t60
              t62 = 1/t36**3
              t63 = 3.968502629920499d-1
              t64 = 1/rhoa**8
              t65 = 1/rhoa**7
              t66 = 1/rhoa**4.333333333333333d+0
              fnc(iq) = (1.0d+0*t37*t46*(t34-1.243628d-1*rhoa*(1.0522000
     1           558389212d-1*t4+1.0d+0)*log(1.6081979498692536d+1/(5.32
     2           9846514438383d+0*t5+1.766435620181429d+0*t4+5.659885156
     3           639418d-1*t3+1.19503784087549d-1*t1)+1.0d+0))+2.0d+0*rh
     4           oa*t14*t17*t22*t33)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t37*(1.0d+0*t61*(-3.3333333333333337d+0*
     1           t18*t37*t45*taua-6.666666666666667d+0*t18*t39*t41*t42*t
     2           aua-6.666666666666667d+0*gammaaa*t25*t39*t40*taua-6.099
     3           32d-3*t42*t43*t48*t62-1.219864d-2*gammaaa*t18*t40*t41*t
     4           48*t62-2.439728d-2*t24*t25*t38*t48*t62-1.06666666666666
     5           66d+1*t24*t38*t39*t50-3.04966d-3*t39*t41*t45*t48-6.0993
     6           2d-3*gammaaa*t18*t39*t44*t48-2.6666666666666666d+0*gamm
     7           aaa*t37*t44*t47-2.6666666666666666d+0*gammaaa*t39*t40*t
     8           41*t47)+1.0d+0*t46*(3.1090699999999993d-2*t8*t9+2*rhoa*
     9           (1.0d+0*t60*(-7.418564737168958d-1*t52*t63-4.0021431749
     :           96817d-1*t51/t55**3-4.4415387620319857d-1*t53-3.9834594
     ;           695849657d-2*t19)/(t57**2*t58)+2.747773264188437d-3*t52
     <           *t59*t63)-6.21814d-2*t59*t60-rhoa*t54+6.903522198342671
     =           d-18*t12*t13))+t22*(1.0d+0*rhoa*t14*t17*(-3.33333333333
     >           33337d+0*t18*t22*t32*taua-6.666666666666667d+0*t18*t26*
     ?           t28*t29*taua-3.3333333333333337d+0*gammaaa*t25*t26*t27*
     @           taua-5.333333333333333d+0*t23*t24*t26*t50-1.030176d-2*t
     1           29*t30*t48*t49-1.030176d-2*gammaaa*t18*t27*t28*t48*t49-
     2           1.030176d-2*t23*t24*t25*t48*t49-5.15088d-3*t26*t28*t32*
     3           t48-5.15088d-3*gammaaa*t18*t26*t31*t48-2.66666666666666
     4           66d+0*gammaaa*t22*t31*t47-2.6666666666666666d+0*gammaaa
     5           *t26*t27*t28*t47)+1.0d+0*rhoa*t17*t33*t54+1.0d+0*t14*t1
     6           7*t33)-3.04966d-3*t39*t46*t48*t61-5.15088d-3*rhoa*t14*t
     7           17*t26*t33*t48+1.25d-1*gammaaa*t14*t15*t16*t22*t33)*wgh
     8           t+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (1.0d+0*t37*t61*(-2.439728d-2*t24*t38*t6
     1           2*t64-6.09932d-3*t18*t42*t43*t62-1.219864d-2*gammaaa*t2
     2           5*t40*t41*t62-3.04966d-3*t18*t39*t41*t45-6.09932d-3*gam
     3           maaa*t25*t39*t44+t18*t37*t44+t18*t39*t40*t41+4*gammaaa*
     4           t25*t38*t39)+1.0d+0*rhoa*t14*t17*t22*(-1.030176d-2*t23*
     5           t24*t49*t64-1.030176d-2*t18*t29*t30*t49-1.030176d-2*gam
     6           maaa*t25*t27*t28*t49-5.15088d-3*t18*t26*t28*t32-5.15088
     7           d-3*gammaaa*t25*t26*t31+t18*t22*t31+t18*t26*t27*t28+2*g
     8           ammaaa*t23*t25*t26)-3.04966d-3*t18*t39*t46*t61-5.15088d
     9           -3*t14*t17*t19*t26*t33-1.25d-1*t14*t16*t22*t33)*wght+Cm
     :           at(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.25d-1*gammaaa*t14*t22*t33/taua**2+1.0d
     1           +0*t37*t61*(-2.439728d-2*gammaaa*t40*t41*t62*t66-1.2198
     2           64d-2*gammaaa*t39*t44*t66+4.0d+0*gammaaa*t39*t40*t66-4.
     3           879456d-2*t24*t38*t62*t65-1.219864d-2*t19*t42*t43*t62-6
     4           .09932d-3*t19*t39*t41*t45+2.0d+0*t19*t37*t45+4.0d+0*t19
     5           *t39*t41*t42)+1.0d+0*rhoa*t14*t17*t22*(-2.060352d-2*gam
     6           maaa*t27*t28*t49*t66-1.030176d-2*gammaaa*t26*t31*t66+2.
     7           0d+0*gammaaa*t26*t27*t66-2.060352d-2*t23*t24*t49*t65-2.
     8           060352d-2*t19*t29*t30*t49-1.030176d-2*t19*t26*t28*t32+2
     9           .0d+0*t19*t22*t32+4.0d+0*t19*t26*t28*t29)-6.09932d-3*t1
     :           9*t39*t46*t61-1.030176d-2*t1*t14*t17*t26*t33)*wght+Mmat
     ;           (iq,D1_TA)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = 1/rhoa**3.3333333333333337d+0
              t10 = param(9)
              t11 = param(8)
              t12 = param(11)
              t13 = 1.6d-99*t5*t8*t9+t4*t5*t7+4.0d-50*t1*t12*t5*t6+t10*t
     1           3*t6+4.0d-50*t1*t11*t3+param(7)
              t14 = 1/rhoa**6.666666666666666d-1
              t15 = rhoa**5.0d-1
              t16 = 1/t15
              t17 = 1/rhoa**3.333333333333333d-1
              t18 = 1/rhoa**1.6666666666666666d-1
              t19 = 1.1120374863094686d+1*t18+3.8447462374472113d+0*t17+
     1           1.644733775567609d+0*t16+2.4058712912881916d-1*t14
              t20 = 3.216395899738507d+1/t19+1.0d+0
              t21 = log(t20)
              t22 = 1.274696188700087d-1*t17+1.0d+0
              t23 = 5.982550435771079d+0*t18+2.2255694211506874d+0*t17+8
     1           .004286349993635d-1*t16+1.8970043257475583d-1*t14
              t24 = 1.6081979498692536d+1/t23+1.0d+0
              t25 = log(t24)
              t26 = 1.3256889990520176d-1*t17+1.0d+0
              t27 = -6.903522198342671d-18*t25*t26-3.1090699999999993d-2
     1           *t21*t22
              t28 = 3.04966d-3*(1.2d-49*t1-1.823119944d+1)+1.0d+0
              t29 = 1/t28
              t30 = param(6)
              t31 = 1/t28**2
              t32 = 4.0d-50*t1-1.823119944d+1
              t33 = t32**2
              t34 = param(4)
              t35 = param(3)
              t36 = param(2)
              t37 = param(5)
              t38 = 6.4d-99*t31*t34*t9+8.0d-50*t1*t31*t32*t37+8.0d-50*t1
     1           *t29*t36+t29*t32*t35+t30*t31*t33+param(1)
              t39 = -2*rhoa*t27
              t40 = 1/t15**3
              t41 = 1/rhoa**1.3333333333333333d+0
              t42 = 1/rhoa**1.1666666666666667d+0
              t43 = 1.1102230246251565d-16*t26*(-9.970917392951799d-1*t4
     1           2-7.418564737168958d-1*t41-4.002143174996817d-1*t40-1.2
     2           64669550498372d-1*t1)/(t23**2*t24)+1.0d+0*t22*(-1.85339
     3           58105157808d+0*t42-1.2815820791490704d+0*t41-8.22366887
     4           7838045d-1*t40-1.6039141941921276d-1*t1)/(t19**2*t20)+3
     5           .0506411443514264d-19*t25*t41+1.3210398931339265d-3*t21
     6           *t41
              t44 = 1/t2**3
              t45 = 1/rhoa**6
              t46 = 1/rhoa**4.333333333333333d+0
              t47 = 1/rhoa**2.6666666666666666d+0
              t48 = 1.414213562373095d+0
              t49 = 7.937005259840998d-1
              t50 = 2.2255694211506874d+0*t17*t49+8.004286349993635d-1*t
     1           16/t48+5.329846514438382d+0*t18+1.1950378408754898d-1*t
     2           14
              t51 = 1.6081979498692536d+1/t50+1.0d+0
              t52 = log(t51)
              t53 = 1.3256889990520176d-1*t17*t49+1.0d+0
              t54 = t39-1.243628d-1*rhoa*t52*t53
              t55 = 3.968502629920499d-1
              t56 = 1/t28**3
              fnc(iq) = (1.0d+0*t29*t38*(t39-1.243628d-1*rhoa*(1.0522000
     1           558389212d-1*t17+1.0d+0)*log(1.6081979498692536d+1/(5.3
     2           29846514438383d+0*t18+1.766435620181429d+0*t17+5.659885
     3           156639418d-1*t16+1.19503784087549d-1*t14)+1.0d+0))+1.0d
     4           +0*rhoa*t13*t27*t3)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t3*(5.0d-1*rhoa*t27*(-5.333333333333334d
     1           -99*t46*t5*t8+1.6482816d-150*t44*t45*t8+1.030176d-51*t4
     2           *t44*t47*t7-6.666666666666666d-50*t4*t47*t5*t6-6.666666
     3           666666666d-50*t12*t47*t5*t6+5.15088d-52*t10*t47*t5*t6+4
     4           .1207039999999995d-101*t12*t44*t46*t6-1.333333333333333
     5           3d-99*t12*t46*t5+2.0603519999999997d-101*t11*t46*t5-6.6
     6           66666666666666d-50*t11*t3*t47-3.333333333333333d-50*t10
     7           *t3*t47)+5.0d-1*rhoa*t13*t43+5.0d-1*t13*t27)+t29*(1.0d+
     8           0*t54*(6.09932d-52*t30*t33*t47*t56+4.8794560000000003d-
     9           101*t32*t37*t46*t56+3.9035648d-150*t34*t45*t56-6.666666
     :           666666666d-50*t31*t32*t37*t47-6.666666666666666d-50*t29
     ;           *t36*t47+3.04966d-52*t31*t32*t35*t47-3.333333333333333d
     <           -50*t29*t35*t47-6.666666666666666d-50*t30*t31*t32*t47-2
     =           .6666666666666666d-99*t31*t37*t46+2.4397280000000002d-1
     >           01*t31*t36*t46-1.0666666666666666d-98*t31*t34*t46)+1.0d
     ?           +0*t38*(2*rhoa*(1.0d+0*t53*(-7.418564737168958d-1*t41*t
     @           55-4.002143174996817d-1*t40/t48**3-4.4415387620319857d-
     1           1*t42-3.9834594695849657d-2*t1)/(t50**2*t51)+2.74777326
     2           4188437d-3*t41*t52*t55)-6.21814d-2*t52*t53-rhoa*t43+6.9
     3           03522198342671d-18*t25*t26+3.1090699999999993d-2*t21*t2
     4           2))+3.04966d-52*t31*t38*t47*t54+2.57544d-52*t1*t13*t27*
     5           t5)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = gammaaa*t18
              t20 = 1/rhoa**1.6666666666666669d+0
              t21 = 2.0d+0*t20*taua
              t22 = 5.15088d-3*(t21+t19-9.11559972d+0)+1.0d+0
              t23 = 1/t22
              t24 = param(7)
              t25 = param(10)
              t26 = gammaaa**2
              t27 = 1/rhoa**5.333333333333333d+0
              t28 = 1/t22**2
              t29 = param(11)
              t30 = t21-9.11559972d+0
              t31 = param(12)
              t32 = t30**2
              t33 = param(8)
              t34 = param(9)
              t35 = t23*t30*t34+gammaaa*t18*t23*t33+t28*t31*t32+gammaaa*
     1           t18*t28*t29*t30+t25*t26*t27*t28+t24
              t36 = 1/rhob**6.666666666666666d-1
              t37 = rhob**5.0d-1
              t38 = 1/t37
              t39 = 1/rhob**3.333333333333333d-1
              t40 = 1/rhob**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = 1/rhob
              t51 = 1/taub
              t52 = 1.0d+0-1.25d-1*gammabb*t50*t51
              t53 = 1/rhob**2.6666666666666666d+0
              t54 = gammabb*t53
              t55 = 1/rhob**1.6666666666666669d+0
              t56 = 2.0d+0*t55*taub
              t57 = 5.15088d-3*(t56+t54-9.11559972d+0)+1.0d+0
              t58 = 1/t57
              t59 = gammabb**2
              t60 = 1/rhob**5.333333333333333d+0
              t61 = 1/t57**2
              t62 = t56-9.11559972d+0
              t63 = t62**2
              t64 = t31*t61*t63+gammabb*t29*t53*t61*t62+t34*t58*t62+t25*
     1           t59*t60*t61+gammabb*t33*t53*t58+t24
              t65 = rhob+rhoa
              t66 = 1/t65**3.333333333333333d-1
              t67 = 1.3256889990520176d-1*t66+1.0d+0
              t68 = rhoa-rhob
              t69 = t68**4
              t70 = 1/t65**4
              t71 = 1/t65
              t72 = 1.0d+0-t68*t71
              t73 = t68*t71+1.0d+0
              t74 = t73**1.3333333333333333d+0+t72**1.3333333333333333d+
     1           0-2.0d+0
              t75 = -1.923661050931536d+0*t69*t70*t74
              t76 = t75+1.0d+0
              t77 = 1/t65**6.666666666666666d-1
              t78 = t65**5.0d-1
              t79 = 1/t78
              t80 = 1/t65**1.6666666666666666d-1
              t81 = 5.982550435771079d+0*t80+8.004286349993635d-1*t79+1.
     1           8970043257475583d-1*t77+2.2255694211506874d+0*t66
              t82 = 1.6081979498692536d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = -6.21814d-2*t67*t76*t83
              t85 = 6.901399211255825d-2*t66+1.0d+0
              t86 = t75+1.923661050931536d+0*t74
              t87 = 8.157414703487641d+0*t80+4.3009724712766434d-1*t79+1
     1           .9115125951273373d-1*t77+2.247591863577616d+0*t66
              t88 = 2.9608813203268075d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = 1.9751631321680768d-2*t85*t86*t89
              t91 = 1.274696188700087d-1*t66+1.0d+0
              t92 = 1.1120374863094686d+1*t80+1.644733775567609d+0*t79+2
     1           .4058712912881916d-1*t77+3.8447462374472113d+0*t66
              t93 = 3.216395899738507d+1/t92+1.0d+0
              t94 = log(t93)
              t95 = -5.980796863619711d-2*t69*t70*t74*t91*t94
              t96 = t65*(t95+t90+t84)-rhob*t49-rhoa*t14
              t97 = 3.04966d-3*(t56+t54+t21+t19-1.823119944d+1)+1.0d+0
              t98 = 1/t97
              t99 = param(4)
              t100 = t54+t19
              t101 = t100**2
              t102 = 1/t97**2
              t103 = param(5)
              t104 = t56+t21-1.823119944d+1
              t105 = param(6)
              t106 = t104**2
              t107 = param(2)
              t108 = param(3)
              t109 = t101*t102*t99+t104*t108*t98+t100*t107*t98+t102*t105
     1           *t106+t100*t102*t103*t104+param(1)
              t110 = 1/rhoa**3.6666666666666664d+0
              t111 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d
     1           +0*gammaaa*t110
              t112 = 1/t22**3
              t113 = 1/t2**3
              t114 = 1/rhoa**1.3333333333333333d+0
              t115 = 1/rhoa**1.1666666666666667d+0
              t116 = 1.0d+0*(-1.6039141941921276d-1*t20-1.85339581051578
     1           08d+0*t115-1.2815820791490704d+0*t114-8.223668877838045
     2           d-1*t113)*t9/(t6**2*t7)+1.3210398931339265d-3*t114*t8+1
     3           .1102230246251565d-16*t13*(-1.264669550498372d-1*t20-9.
     4           970917392951799d-1*t115-7.418564737168958d-1*t114-4.002
     5           143174996817d-1*t113)/(t10**2*t11)+3.0506411443514264d-
     6           19*t114*t12
              t117 = 1/t97**3
              t118 = 1/t65**1.6666666666666669d+0
              t119 = 1/t78**3
              t120 = 1/t65**1.3333333333333333d+0
              t121 = 1/t65**1.1666666666666667d+0
              t122 = 1.0d+0*(-9.970917392951799d-1*t121-7.41856473716895
     1           8d-1*t120-4.002143174996817d-1*t119-1.264669550498372d-
     2           1*t118)*t67*t76/(t81**2*t82)
              t123 = -5.848223622634647d-1*(-1.3595691172479402d+0*t121-
     1           7.491972878592053d-1*t120-2.1504862356383217d-1*t119-1.
     2           2743417300848914d-1*t118)*t85*t86/(t87**2*t88)
              t124 = 1.923661050931536d+0*(-1.8533958105157808d+0*t121-1
     1           .2815820791490704d+0*t120-8.223668877838045d-1*t119-1.6
     2           039141941921276d-1*t118)*t69*t70*t74*t91/(t92**2*t93)
              t125 = 1/t65**2
              t126 = t125*t68
              t127 = -t71
              t128 = t72**3.333333333333333d-1
              t129 = -t125*t68
              t130 = t73**3.333333333333333d-1
              t131 = 1.3333333333333333d+0*t130*(t71+t129)+1.33333333333
     1           33333d+0*(t127+t126)*t128
              t132 = -1.923661050931536d+0*t131*t69*t70
              t133 = 1/t65**5
              t134 = 7.694644203726144d+0*t133*t69*t74
              t135 = t68**3
              t136 = -7.694644203726144d+0*t135*t70*t74
              t137 = 2.747773264188437d-3*t120*t76*t83
              t138 = -4.5437964274821163d-4*t120*t86*t89
              t139 = 2.541232989148493d-3*t69*t74*t94/t65**5.33333333333
     1           3333d+0
              t140 = 2.3923187454478842d-1*t133*t69*t74*t91*t94
              t141 = 1/rhob**3.6666666666666664d+0
              t142 = -3.3333333333333337d+0*t53*taub-2.6666666666666666d
     1           +0*gammabb*t141
              t143 = 1/t57**3
              t144 = 1/t37**3
              t145 = 1/rhob**1.3333333333333333d+0
              t146 = 1/rhob**1.1666666666666667d+0
              t147 = 1.1102230246251565d-16*t48*(-1.264669550498372d-1*t
     1           55-9.970917392951799d-1*t146-7.418564737168958d-1*t145-
     2           4.002143174996817d-1*t144)/(t45**2*t46)+1.0d+0*t44*(-1.
     3           6039141941921276d-1*t55-1.8533958105157808d+0*t146-1.28
     4           15820791490704d+0*t145-8.223668877838045d-1*t144)/(t41*
     5           *2*t42)+3.0506411443514264d-19*t145*t47+1.3210398931339
     6           265d-3*t145*t43
              t148 = 1.3333333333333333d+0*t128*(t71+t126)+1.33333333333
     1           33333d+0*(t129+t127)*t130
              t149 = -1.923661050931536d+0*t148*t69*t70
              t150 = 7.694644203726144d+0*t135*t70*t74
              t151 = 1/rhoa**4.333333333333333d+0
              t152 = 1/rhob**4.333333333333333d+0
              fnc(iq) = (1.0d+0*t109*t96*t98+1.0d+0*rhob*t49*t52*t58*t64
     1           +1.0d+0*rhoa*t14*t17*t23*t35)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t98*(1.0d+0*t96*(-3.3333333333333337d+0*
     1           t108*t18*t98*taua-6.666666666666667d+0*t102*t104*t105*t
     2           18*taua-3.3333333333333337d+0*t100*t102*t103*t18*taua-6
     3           .09932d-3*t101*t111*t117*t99-5.333333333333333d+0*gamma
     4           aa*t100*t102*t110*t99-2.6666666666666666d+0*gammaaa*t10
     5           7*t110*t98-6.09932d-3*t105*t106*t111*t117-6.09932d-3*t1
     6           00*t103*t104*t111*t117-3.04966d-3*t102*t104*t108*t111-3
     7           .04966d-3*t100*t102*t107*t111-2.6666666666666666d+0*gam
     8           maaa*t102*t103*t104*t110)+1.0d+0*t109*(t95+t65*(-2.3923
     9           187454478842d-1*t135*t70*t74*t91*t94-5.980796863619711d
     :           -2*t131*t69*t70*t91*t94+1.9751631321680768d-2*(t136+t13
     ;           4+t132+1.923661050931536d+0*t131)*t85*t89-6.21814d-2*(t
     <           136+t134+t132)*t67*t83+t140+t139+t138+t137+t124+t123+t1
     =           22)+t90+3.1090699999999993d-2*t8*t9+t84+6.9035221983426
     >           71d-18*t12*t13-rhoa*t116))+t23*(1.0d+0*rhoa*t14*t17*(-3
     ?           .3333333333333337d+0*t18*t23*t34*taua-6.666666666666667
     @           d+0*t18*t28*t30*t31*taua-3.3333333333333337d+0*gammaaa*
     1           t27*t28*t29*taua-5.15088d-3*t111*t28*t30*t34-5.15088d-3
     2           *gammaaa*t111*t18*t28*t33-2.6666666666666666d+0*gammaaa
     3           *t110*t23*t33-1.030176d-2*t111*t112*t31*t32-2.666666666
     4           6666666d+0*gammaaa*t110*t28*t29*t30-1.030176d-2*gammaaa
     5           *t111*t112*t18*t29*t30-5.333333333333333d+0*t25*t26*t28
     6           /rhoa**6.333333333333333d+0-1.030176d-2*t111*t112*t25*t
     7           26*t27)+1.0d+0*t14*t17*t35+1.0d+0*rhoa*t116*t17*t35)-3.
     8           04966d-3*t102*t109*t111*t96-5.15088d-3*rhoa*t111*t14*t1
     9           7*t28*t35+1.25d-1*gammaaa*t14*t15*t16*t23*t35)*wght+Ama
     :           t(iq,D1_RA)
              Amat(iq,D1_RB) = (t98*(1.0d+0*t96*(-3.3333333333333337d+0*
     1           t108*t53*t98*taub-6.666666666666667d+0*t102*t104*t105*t
     2           53*taub-3.3333333333333337d+0*t100*t102*t103*t53*taub-6
     3           .09932d-3*t101*t117*t142*t99-5.333333333333333d+0*gamma
     4           bb*t100*t102*t141*t99-2.6666666666666666d+0*gammabb*t10
     5           7*t141*t98-6.09932d-3*t105*t106*t117*t142-6.09932d-3*t1
     6           00*t103*t104*t117*t142-3.04966d-3*t102*t104*t108*t142-3
     7           .04966d-3*t100*t102*t107*t142-2.6666666666666666d+0*gam
     8           mabb*t102*t103*t104*t141)+1.0d+0*t109*(t95+t65*(2.39231
     9           87454478842d-1*t135*t70*t74*t91*t94-5.980796863619711d-
     :           2*t148*t69*t70*t91*t94+1.9751631321680768d-2*(t150+t149
     ;           +1.923661050931536d+0*t148+t134)*t85*t89-6.21814d-2*(t1
     <           50+t149+t134)*t67*t83+t140+t139+t138+t137+t124+t123+t12
     =           2)+t90+t84+6.903522198342671d-18*t47*t48+3.109069999999
     >           9993d-2*t43*t44-rhob*t147))+t58*(1.0d+0*rhob*t49*t52*(-
     ?           6.666666666666667d+0*t31*t53*t61*t62*taub-3.33333333333
     @           33337d+0*gammabb*t29*t60*t61*taub-3.3333333333333337d+0
     1           *t34*t53*t58*taub-1.030176d-2*t142*t143*t31*t63-5.15088
     2           d-3*t142*t34*t61*t62-2.6666666666666666d+0*gammabb*t141
     3           *t29*t61*t62-1.030176d-2*gammabb*t142*t143*t29*t53*t62-
     4           5.333333333333333d+0*t25*t59*t61/rhob**6.33333333333333
     5           3d+0-5.15088d-3*gammabb*t142*t33*t53*t61-1.030176d-2*t1
     6           42*t143*t25*t59*t60-2.6666666666666666d+0*gammabb*t141*
     7           t33*t58)+1.0d+0*t49*t52*t64+1.0d+0*rhob*t147*t52*t64)-3
     8           .04966d-3*t102*t109*t142*t96-5.15088d-3*rhob*t142*t49*t
     9           52*t61*t64+1.25d-1*gammabb*t49*t50*t51*t58*t64)*wght+Am
     :           at(iq,D1_RB)
              Cmat(iq,D1_GAA) = (1.0d+0*t96*t98*(-6.09932d-3*t101*t117*t
     1           18*t99+2*t100*t102*t18*t99+t107*t18*t98-6.09932d-3*t105
     2           *t106*t117*t18-6.09932d-3*t100*t103*t104*t117*t18-3.049
     3           66d-3*t102*t104*t108*t18-3.04966d-3*t100*t102*t107*t18+
     4           t102*t103*t104*t18)-3.04966d-3*t102*t109*t18*t96-5.1508
     5           8d-3*t14*t17*t20*t28*t35-1.25d-1*t14*t16*t23*t35+1.0d+0
     6           *rhoa*t14*t17*t23*(-5.15088d-3*t18*t28*t30*t34-5.15088d
     7           -3*gammaaa*t27*t28*t33+t18*t23*t33-1.030176d-2*t112*t18
     8           *t31*t32+t18*t28*t29*t30-1.030176d-2*gammaaa*t112*t27*t
     9           29*t30+2*gammaaa*t25*t27*t28-1.030176d-2*t112*t25*t26/r
     :           hoa**8))*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (1.0d+0*t96*t98*(-6.09932d-3*t101*t117*t
     1           53*t99+2*t100*t102*t53*t99+t107*t53*t98-6.09932d-3*t105
     2           *t106*t117*t53-6.09932d-3*t100*t103*t104*t117*t53-3.049
     3           66d-3*t102*t104*t108*t53-3.04966d-3*t100*t102*t107*t53+
     4           t102*t103*t104*t53)-3.04966d-3*t102*t109*t53*t96-5.1508
     5           8d-3*t49*t52*t55*t61*t64-1.25d-1*t49*t51*t58*t64+1.0d+0
     6           *rhob*t49*t52*t58*(-1.030176d-2*t143*t31*t53*t63-5.1508
     7           8d-3*t34*t53*t61*t62+t29*t53*t61*t62-1.030176d-2*gammab
     8           b*t143*t29*t60*t62-5.15088d-3*gammabb*t33*t60*t61+2*gam
     9           mabb*t25*t60*t61-1.030176d-2*t143*t25*t59/rhob**8+t33*t
     :           53*t58))*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.25d-1*gammaaa*t14*t23*t35/taua**2+1.0d
     1           +0*t96*t98*(-1.219864d-2*t101*t117*t20*t99+2.0d+0*t108*
     2           t20*t98-1.219864d-2*t105*t106*t117*t20-1.219864d-2*t100
     3           *t103*t104*t117*t20-6.09932d-3*t102*t104*t108*t20-6.099
     4           32d-3*t100*t102*t107*t20+4.0d+0*t102*t104*t105*t20+2.0d
     5           +0*t100*t102*t103*t20)-6.09932d-3*t102*t109*t20*t96-1.0
     6           30176d-2*t1*t14*t17*t28*t35+1.0d+0*rhoa*t14*t17*t23*(-1
     7           .030176d-2*t20*t28*t30*t34+2.0d+0*t20*t23*t34-1.030176d
     8           -2*gammaaa*t151*t28*t33-2.060352d-2*t112*t20*t31*t32+4.
     9           0d+0*t20*t28*t30*t31-2.060352d-2*gammaaa*t112*t151*t29*
     :           t30+2.0d+0*gammaaa*t151*t28*t29-2.060352d-2*t112*t25*t2
     ;           6/rhoa**7))*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.25d-1*gammabb*t49*t58*t64/taub**2+1.0d
     1           +0*t96*t98*(-1.219864d-2*t101*t117*t55*t99+2.0d+0*t108*
     2           t55*t98-1.219864d-2*t105*t106*t117*t55-1.219864d-2*t100
     3           *t103*t104*t117*t55-6.09932d-3*t102*t104*t108*t55-6.099
     4           32d-3*t100*t102*t107*t55+4.0d+0*t102*t104*t105*t55+2.0d
     5           +0*t100*t102*t103*t55)-6.09932d-3*t102*t109*t55*t96-1.0
     6           30176d-2*t36*t49*t52*t61*t64+1.0d+0*rhob*t49*t52*t58*(-
     7           2.060352d-2*t143*t31*t55*t63-1.030176d-2*t34*t55*t61*t6
     8           2+4.0d+0*t31*t55*t61*t62-2.060352d-2*gammabb*t143*t152*
     9           t29*t62-1.030176d-2*gammabb*t152*t33*t61+2.0d+0*gammabb
     :           *t152*t29*t61-2.060352d-2*t143*t25*t59/rhob**7+2.0d+0*t
     ;           34*t55*t58))*wght+Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhob**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhob**6.666666666666666d-1
              t17 = rhob**5.0d-1
              t18 = 1/t17
              t19 = 1/rhob**3.333333333333333d-1
              t20 = 1/rhob**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = 1/rhoa**6.666666666666666d-1
              t31 = rhoa**5.0d-1
              t32 = 1/t31
              t33 = 1/rhoa**3.333333333333333d-1
              t34 = 1/rhoa**1.6666666666666666d-1
              t35 = 1.1120374863094686d+1*t34+3.8447462374472113d+0*t33+
     1           1.644733775567609d+0*t32+2.4058712912881916d-1*t30
              t36 = 3.216395899738507d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.274696188700087d-1*t33+1.0d+0
              t39 = 5.982550435771079d+0*t34+2.2255694211506874d+0*t33+8
     1           .004286349993635d-1*t32+1.8970043257475583d-1*t30
              t40 = 1.6081979498692536d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.3256889990520176d-1*t33+1.0d+0
              t43 = -6.903522198342671d-18*t41*t42-3.1090699999999993d-2
     1           *t37*t38
              t44 = 1/rhoa
              t45 = 1/taua
              t46 = 1.0d+0-1.25d-1*gammaaa*t44*t45
              t47 = 1/rhoa**2.6666666666666666d+0
              t48 = gammaaa*t47
              t49 = 1/rhoa**1.6666666666666669d+0
              t50 = 2.0d+0*t49*taua
              t51 = 5.15088d-3*(t50+t48-9.11559972d+0)+1.0d+0
              t52 = 1/t51
              t53 = gammaaa**2
              t54 = 1/rhoa**5.333333333333333d+0
              t55 = 1/t51**2
              t56 = t50-9.11559972d+0
              t57 = t56**2
              t58 = t55*t57*t6+gammaaa*t14*t47*t55*t56+t12*t52*t56+t11*t
     1           53*t54*t55+gammaaa*t13*t47*t52+t5
              t59 = rhob+rhoa
              t60 = 1/t59**3.333333333333333d-1
              t61 = 1.3256889990520176d-1*t60+1.0d+0
              t62 = rhoa-rhob
              t63 = t62**4
              t64 = 1/t59**4
              t65 = 1/t59
              t66 = 1.0d+0-t62*t65
              t67 = t62*t65+1.0d+0
              t68 = t67**1.3333333333333333d+0+t66**1.3333333333333333d+
     1           0-2.0d+0
              t69 = -1.923661050931536d+0*t63*t64*t68
              t70 = t69+1.0d+0
              t71 = 1/t59**6.666666666666666d-1
              t72 = t59**5.0d-1
              t73 = 1/t72
              t74 = 1/t59**1.6666666666666666d-1
              t75 = 5.982550435771079d+0*t74+8.004286349993635d-1*t73+1.
     1           8970043257475583d-1*t71+2.2255694211506874d+0*t60
              t76 = 1.6081979498692536d+1/t75+1.0d+0
              t77 = log(t76)
              t78 = -6.21814d-2*t61*t70*t77
              t79 = 6.901399211255825d-2*t60+1.0d+0
              t80 = t69+1.923661050931536d+0*t68
              t81 = 8.157414703487641d+0*t74+4.3009724712766434d-1*t73+1
     1           .9115125951273373d-1*t71+2.247591863577616d+0*t60
              t82 = 2.9608813203268075d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = 1.9751631321680768d-2*t79*t80*t83
              t85 = 1.274696188700087d-1*t60+1.0d+0
              t86 = 1.1120374863094686d+1*t74+1.644733775567609d+0*t73+2
     1           .4058712912881916d-1*t71+3.8447462374472113d+0*t60
              t87 = 3.216395899738507d+1/t86+1.0d+0
              t88 = log(t87)
              t89 = -5.980796863619711d-2*t63*t64*t68*t85*t88
              t90 = t59*(t89+t84+t78)-rhoa*t43-rhob*t29
              t91 = 3.04966d-3*(t50+t48+t2-1.823119944d+1)+1.0d+0
              t92 = 1/t91
              t93 = param(4)
              t94 = t48+4.0d-50*t1
              t95 = t94**2
              t96 = 1/t91**2
              t97 = param(5)
              t98 = t8+t50-1.823119944d+1
              t99 = param(6)
              t100 = t98**2
              t101 = param(2)
              t102 = param(3)
              t103 = t100*t96*t99+t94*t96*t97*t98+t102*t92*t98+t93*t95*t
     1           96+t101*t92*t94+param(1)
              t104 = 1/rhoa**3.6666666666666664d+0
              t105 = -3.3333333333333337d+0*t47*taua-2.6666666666666666d
     1           +0*gammaaa*t104
              t106 = 1/t51**3
              t107 = 1/t31**3
              t108 = 1/rhoa**1.3333333333333333d+0
              t109 = 1/rhoa**1.1666666666666667d+0
              t110 = 1.1102230246251565d-16*t42*(-1.264669550498372d-1*t
     1           49-9.970917392951799d-1*t109-7.418564737168958d-1*t108-
     2           4.002143174996817d-1*t107)/(t39**2*t40)+1.0d+0*t38*(-1.
     3           6039141941921276d-1*t49-1.8533958105157808d+0*t109-1.28
     4           15820791490704d+0*t108-8.223668877838045d-1*t107)/(t35*
     5           *2*t36)+3.0506411443514264d-19*t108*t41+1.3210398931339
     6           265d-3*t108*t37
              t111 = 1/t91**3
              t112 = 1/t59**1.6666666666666669d+0
              t113 = 1/t72**3
              t114 = 1/t59**1.3333333333333333d+0
              t115 = 1/t59**1.1666666666666667d+0
              t116 = 1.0d+0*(-9.970917392951799d-1*t115-7.41856473716895
     1           8d-1*t114-4.002143174996817d-1*t113-1.264669550498372d-
     2           1*t112)*t61*t70/(t75**2*t76)
              t117 = -5.848223622634647d-1*(-1.3595691172479402d+0*t115-
     1           7.491972878592053d-1*t114-2.1504862356383217d-1*t113-1.
     2           2743417300848914d-1*t112)*t79*t80/(t81**2*t82)
              t118 = 1.923661050931536d+0*(-1.8533958105157808d+0*t115-1
     1           .2815820791490704d+0*t114-8.223668877838045d-1*t113-1.6
     2           039141941921276d-1*t112)*t63*t64*t68*t85/(t86**2*t87)
              t119 = 1/t59**2
              t120 = t119*t62
              t121 = -t65
              t122 = t66**3.333333333333333d-1
              t123 = -t119*t62
              t124 = t67**3.333333333333333d-1
              t125 = 1.3333333333333333d+0*t124*(t65+t123)+1.33333333333
     1           33333d+0*(t121+t120)*t122
              t126 = -1.923661050931536d+0*t125*t63*t64
              t127 = 1/t59**5
              t128 = 7.694644203726144d+0*t127*t63*t68
              t129 = t62**3
              t130 = -7.694644203726144d+0*t129*t64*t68
              t131 = 2.747773264188437d-3*t114*t70*t77
              t132 = -4.5437964274821163d-4*t114*t80*t83
              t133 = 2.541232989148493d-3*t63*t68*t88/t59**5.33333333333
     1           3333d+0
              t134 = 2.3923187454478842d-1*t127*t63*t68*t85*t88
              t135 = 1/t17**3
              t136 = 1/rhob**1.3333333333333333d+0
              t137 = 1/rhob**1.1666666666666667d+0
              t138 = 1.1102230246251565d-16*(-9.970917392951799d-1*t137-
     1           7.418564737168958d-1*t136-4.002143174996817d-1*t135-1.2
     2           64669550498372d-1*t1)*t28/(t25**2*t26)+3.05064114435142
     3           64d-19*t136*t27+1.0d+0*(-1.8533958105157808d+0*t137-1.2
     4           815820791490704d+0*t136-8.223668877838045d-1*t135-1.603
     5           9141941921276d-1*t1)*t24/(t21**2*t22)+1.321039893133926
     6           5d-3*t136*t23
              t139 = 1/t3**3
              t140 = 1/rhob**4.333333333333333d+0
              t141 = 1/rhob**2.6666666666666666d+0
              t142 = 1.3333333333333333d+0*t122*(t65+t120)+1.33333333333
     1           33333d+0*(t123+t121)*t124
              t143 = -1.923661050931536d+0*t142*t63*t64
              t144 = 7.694644203726144d+0*t129*t64*t68
              t145 = 1/rhoa**4.333333333333333d+0
              fnc(iq) = (1.0d+0*t103*t90*t92+1.0d+0*rhoa*t43*t46*t52*t58
     1           +5.0d-1*rhob*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t92*(1.0d+0*t90*(-6.666666666666667d+0*t
     1           47*t96*t98*t99*taua-3.3333333333333337d+0*t47*t94*t96*t
     2           97*taua-3.3333333333333337d+0*t102*t47*t92*taua-6.09932
     3           d-3*t100*t105*t111*t99-2.6666666666666666d+0*gammaaa*t1
     4           04*t96*t97*t98-6.09932d-3*t105*t111*t94*t97*t98-3.04966
     5           d-3*t102*t105*t96*t98-5.333333333333333d+0*gammaaa*t104
     6           *t93*t94*t96-3.04966d-3*t101*t105*t94*t96-6.09932d-3*t1
     7           05*t111*t93*t95-2.6666666666666666d+0*gammaaa*t101*t104
     8           *t92)+1.0d+0*t103*(t89+t59*(-2.3923187454478842d-1*t129
     9           *t64*t68*t85*t88-5.980796863619711d-2*t125*t63*t64*t85*
     :           t88+1.9751631321680768d-2*(t130+t128+t126+1.92366105093
     ;           1536d+0*t125)*t79*t83-6.21814d-2*(t130+t128+t126)*t61*t
     <           77+t134+t133+t132+t131+t118+t117+t116)+t84+t78+6.903522
     =           198342671d-18*t41*t42+3.1090699999999993d-2*t37*t38-rho
     >           a*t110))+t52*(1.0d+0*rhoa*t43*t46*(-6.666666666666667d+
     ?           0*t47*t55*t56*t6*taua-3.3333333333333337d+0*gammaaa*t14
     @           *t54*t55*taua-3.3333333333333337d+0*t12*t47*t52*taua-1.
     1           030176d-2*t105*t106*t57*t6-2.6666666666666666d+0*gammaa
     2           a*t104*t14*t55*t56-5.15088d-3*t105*t12*t55*t56-1.030176
     3           d-2*gammaaa*t105*t106*t14*t47*t56-5.333333333333333d+0*
     4           t11*t53*t55/rhoa**6.333333333333333d+0-5.15088d-3*gamma
     5           aa*t105*t13*t47*t55-1.030176d-2*t105*t106*t11*t53*t54-2
     6           .6666666666666666d+0*gammaaa*t104*t13*t52)+1.0d+0*t43*t
     7           46*t58+1.0d+0*rhoa*t110*t46*t58)-3.04966d-3*t103*t105*t
     8           90*t96-5.15088d-3*rhoa*t105*t43*t46*t55*t58+1.25d-1*gam
     9           maaa*t43*t44*t45*t52*t58)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t92*(1.0d+0*t90*(-6.666666666666666d-50*
     1           t141*t96*t98*t99+6.09932d-52*t100*t111*t141*t99-6.66666
     2           6666666666d-50*t141*t96*t97*t98+6.09932d-52*t111*t141*t
     3           94*t97*t98+3.04966d-52*t102*t141*t96*t98-3.333333333333
     4           333d-50*t141*t94*t96*t97-1.3333333333333333d-49*t141*t9
     5           3*t94*t96+3.04966d-52*t101*t141*t94*t96+6.09932d-52*t11
     6           1*t141*t93*t95-3.333333333333333d-50*t102*t141*t92-6.66
     7           6666666666666d-50*t101*t141*t92)+1.0d+0*t103*(t89+t59*(
     8           2.3923187454478842d-1*t129*t64*t68*t85*t88-5.9807968636
     9           19711d-2*t142*t63*t64*t85*t88+1.9751631321680768d-2*(t1
     :           44+t143+1.923661050931536d+0*t142+t128)*t79*t83-6.21814
     ;           d-2*(t144+t143+t128)*t61*t77+t134+t133+t132+t131+t118+t
     <           117+t116)+t84+t78+6.903522198342671d-18*t27*t28+3.10906
     =           99999999993d-2*t23*t24-rhob*t138))+3.04966d-52*t103*t14
     >           1*t90*t96+t4*(5.0d-1*rhob*t29*(-6.666666666666666d-50*t
     ?           141*t6*t7*t9-6.666666666666666d-50*t14*t141*t7*t9+5.150
     @           88d-52*t12*t141*t7*t9+4.1207039999999995d-101*t139*t14*
     1           t140*t9-1.3333333333333333d-99*t14*t140*t7+2.0603519999
     2           999997d-101*t13*t140*t7-5.333333333333334d-99*t11*t140*
     3           t7+1.030176d-51*t10*t139*t141*t6-6.666666666666666d-50*
     4           t13*t141*t4-3.333333333333333d-50*t12*t141*t4+1.6482816
     5           d-150*t11*t139/rhob**6)+5.0d-1*t15*t29+5.0d-1*rhob*t138
     6           *t15)+2.57544d-52*t1*t15*t29*t7)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (1.0d+0*t90*t92*(-6.09932d-3*t100*t111*t
     1           47*t99+t47*t96*t97*t98-6.09932d-3*t111*t47*t94*t97*t98-
     2           3.04966d-3*t102*t47*t96*t98+2*t47*t93*t94*t96-3.04966d-
     3           3*t101*t47*t94*t96-6.09932d-3*t111*t47*t93*t95+t101*t47
     4           *t92)-3.04966d-3*t103*t47*t90*t96+1.0d+0*rhoa*t43*t46*t
     5           52*(-1.030176d-2*t106*t47*t57*t6+t14*t47*t55*t56-5.1508
     6           8d-3*t12*t47*t55*t56-1.030176d-2*gammaaa*t106*t14*t54*t
     7           56-5.15088d-3*gammaaa*t13*t54*t55+2*gammaaa*t11*t54*t55
     8           -1.030176d-2*t106*t11*t53/rhoa**8+t13*t47*t52)-5.15088d
     9           -3*t43*t46*t49*t55*t58-1.25d-1*t43*t45*t52*t58)*wght+Cm
     :           at(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (1.25d-1*gammaaa*t43*t52*t58/taua**2+1.0d
     1           +0*t90*t92*(4.0d+0*t49*t96*t98*t99-1.219864d-2*t100*t11
     2           1*t49*t99-1.219864d-2*t111*t49*t94*t97*t98-6.09932d-3*t
     3           102*t49*t96*t98+2.0d+0*t49*t94*t96*t97-6.09932d-3*t101*
     4           t49*t94*t96-1.219864d-2*t111*t49*t93*t95+2.0d+0*t102*t4
     5           9*t92)-6.09932d-3*t103*t49*t90*t96+1.0d+0*rhoa*t43*t46*
     6           t52*(-2.060352d-2*t106*t49*t57*t6+4.0d+0*t49*t55*t56*t6
     7           -1.030176d-2*t12*t49*t55*t56-2.060352d-2*gammaaa*t106*t
     8           14*t145*t56+2.0d+0*gammaaa*t14*t145*t55-1.030176d-2*gam
     9           maaa*t13*t145*t55-2.060352d-2*t106*t11*t53/rhoa**7+2.0d
     :           +0*t12*t49*t52)-1.030176d-2*t30*t43*t46*t55*t58)*wght+M
     ;           mat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhoa**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhoa**6.666666666666666d-1
              t17 = rhoa**5.0d-1
              t18 = 1/t17
              t19 = 1/rhoa**3.333333333333333d-1
              t20 = 1/rhoa**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = 1/rhob**6.666666666666666d-1
              t31 = rhob**5.0d-1
              t32 = 1/t31
              t33 = 1/rhob**3.333333333333333d-1
              t34 = 1/rhob**1.6666666666666666d-1
              t35 = 1.1120374863094686d+1*t34+3.8447462374472113d+0*t33+
     1           1.644733775567609d+0*t32+2.4058712912881916d-1*t30
              t36 = 3.216395899738507d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.274696188700087d-1*t33+1.0d+0
              t39 = 5.982550435771079d+0*t34+2.2255694211506874d+0*t33+8
     1           .004286349993635d-1*t32+1.8970043257475583d-1*t30
              t40 = 1.6081979498692536d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.3256889990520176d-1*t33+1.0d+0
              t43 = -6.903522198342671d-18*t41*t42-3.1090699999999993d-2
     1           *t37*t38
              t44 = 1/rhob
              t45 = 1/taub
              t46 = 1.0d+0-1.25d-1*gammabb*t44*t45
              t47 = 1/rhob**2.6666666666666666d+0
              t48 = gammabb*t47
              t49 = 1/rhob**1.6666666666666669d+0
              t50 = 2.0d+0*t49*taub
              t51 = 5.15088d-3*(t50+t48-9.11559972d+0)+1.0d+0
              t52 = 1/t51
              t53 = gammabb**2
              t54 = 1/rhob**5.333333333333333d+0
              t55 = 1/t51**2
              t56 = t50-9.11559972d+0
              t57 = t56**2
              t58 = t55*t57*t6+gammabb*t14*t47*t55*t56+t12*t52*t56+t11*t
     1           53*t54*t55+gammabb*t13*t47*t52+t5
              t59 = rhob+rhoa
              t60 = 1/t59**3.333333333333333d-1
              t61 = 1.3256889990520176d-1*t60+1.0d+0
              t62 = rhoa-rhob
              t63 = t62**4
              t64 = 1/t59**4
              t65 = 1/t59
              t66 = 1.0d+0-t62*t65
              t67 = t62*t65+1.0d+0
              t68 = t67**1.3333333333333333d+0+t66**1.3333333333333333d+
     1           0-2.0d+0
              t69 = -1.923661050931536d+0*t63*t64*t68
              t70 = t69+1.0d+0
              t71 = 1/t59**6.666666666666666d-1
              t72 = t59**5.0d-1
              t73 = 1/t72
              t74 = 1/t59**1.6666666666666666d-1
              t75 = 5.982550435771079d+0*t74+8.004286349993635d-1*t73+1.
     1           8970043257475583d-1*t71+2.2255694211506874d+0*t60
              t76 = 1.6081979498692536d+1/t75+1.0d+0
              t77 = log(t76)
              t78 = -6.21814d-2*t61*t70*t77
              t79 = 6.901399211255825d-2*t60+1.0d+0
              t80 = t69+1.923661050931536d+0*t68
              t81 = 8.157414703487641d+0*t74+4.3009724712766434d-1*t73+1
     1           .9115125951273373d-1*t71+2.247591863577616d+0*t60
              t82 = 2.9608813203268075d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = 1.9751631321680768d-2*t79*t80*t83
              t85 = 1.274696188700087d-1*t60+1.0d+0
              t86 = 1.1120374863094686d+1*t74+1.644733775567609d+0*t73+2
     1           .4058712912881916d-1*t71+3.8447462374472113d+0*t60
              t87 = 3.216395899738507d+1/t86+1.0d+0
              t88 = log(t87)
              t89 = -5.980796863619711d-2*t63*t64*t68*t85*t88
              t90 = t59*(t89+t84+t78)-rhob*t43-rhoa*t29
              t91 = 3.04966d-3*(t50+t48+t2-1.823119944d+1)+1.0d+0
              t92 = 1/t91
              t93 = param(4)
              t94 = t48+4.0d-50*t1
              t95 = t94**2
              t96 = 1/t91**2
              t97 = param(5)
              t98 = t8+t50-1.823119944d+1
              t99 = param(6)
              t100 = t98**2
              t101 = param(2)
              t102 = param(3)
              t103 = t100*t96*t99+t94*t96*t97*t98+t102*t92*t98+t93*t95*t
     1           96+t101*t92*t94+param(1)
              t104 = 1/t17**3
              t105 = 1/rhoa**1.3333333333333333d+0
              t106 = 1/rhoa**1.1666666666666667d+0
              t107 = 1.1102230246251565d-16*(-9.970917392951799d-1*t106-
     1           7.418564737168958d-1*t105-4.002143174996817d-1*t104-1.2
     2           64669550498372d-1*t1)*t28/(t25**2*t26)+3.05064114435142
     3           64d-19*t105*t27+1.0d+0*(-1.8533958105157808d+0*t106-1.2
     4           815820791490704d+0*t105-8.223668877838045d-1*t104-1.603
     5           9141941921276d-1*t1)*t24/(t21**2*t22)+1.321039893133926
     6           5d-3*t105*t23
              t108 = 1/t3**3
              t109 = 1/rhoa**4.333333333333333d+0
              t110 = 1/rhoa**2.6666666666666666d+0
              t111 = 1/t91**3
              t112 = 1/t59**1.6666666666666669d+0
              t113 = 1/t72**3
              t114 = 1/t59**1.3333333333333333d+0
              t115 = 1/t59**1.1666666666666667d+0
              t116 = 1.0d+0*(-9.970917392951799d-1*t115-7.41856473716895
     1           8d-1*t114-4.002143174996817d-1*t113-1.264669550498372d-
     2           1*t112)*t61*t70/(t75**2*t76)
              t117 = -5.848223622634647d-1*(-1.3595691172479402d+0*t115-
     1           7.491972878592053d-1*t114-2.1504862356383217d-1*t113-1.
     2           2743417300848914d-1*t112)*t79*t80/(t81**2*t82)
              t118 = 1.923661050931536d+0*(-1.8533958105157808d+0*t115-1
     1           .2815820791490704d+0*t114-8.223668877838045d-1*t113-1.6
     2           039141941921276d-1*t112)*t63*t64*t68*t85/(t86**2*t87)
              t119 = 1/t59**2
              t120 = t119*t62
              t121 = -t65
              t122 = t66**3.333333333333333d-1
              t123 = -t119*t62
              t124 = t67**3.333333333333333d-1
              t125 = 1.3333333333333333d+0*t124*(t65+t123)+1.33333333333
     1           33333d+0*(t121+t120)*t122
              t126 = -1.923661050931536d+0*t125*t63*t64
              t127 = 1/t59**5
              t128 = 7.694644203726144d+0*t127*t63*t68
              t129 = t62**3
              t130 = -7.694644203726144d+0*t129*t64*t68
              t131 = 2.747773264188437d-3*t114*t70*t77
              t132 = -4.5437964274821163d-4*t114*t80*t83
              t133 = 2.541232989148493d-3*t63*t68*t88/t59**5.33333333333
     1           3333d+0
              t134 = 2.3923187454478842d-1*t127*t63*t68*t85*t88
              t135 = 1/rhob**3.6666666666666664d+0
              t136 = -3.3333333333333337d+0*t47*taub-2.6666666666666666d
     1           +0*gammabb*t135
              t137 = 1/t51**3
              t138 = 1/t31**3
              t139 = 1/rhob**1.3333333333333333d+0
              t140 = 1/rhob**1.1666666666666667d+0
              t141 = 1.1102230246251565d-16*t42*(-1.264669550498372d-1*t
     1           49-9.970917392951799d-1*t140-7.418564737168958d-1*t139-
     2           4.002143174996817d-1*t138)/(t39**2*t40)+1.0d+0*t38*(-1.
     3           6039141941921276d-1*t49-1.8533958105157808d+0*t140-1.28
     4           15820791490704d+0*t139-8.223668877838045d-1*t138)/(t35*
     5           *2*t36)+3.0506411443514264d-19*t139*t41+1.3210398931339
     6           265d-3*t139*t37
              t142 = 1.3333333333333333d+0*t122*(t65+t120)+1.33333333333
     1           33333d+0*(t123+t121)*t124
              t143 = -1.923661050931536d+0*t142*t63*t64
              t144 = 7.694644203726144d+0*t129*t64*t68
              t145 = 1/rhob**4.333333333333333d+0
              fnc(iq) = (1.0d+0*t103*t90*t92+1.0d+0*rhob*t43*t46*t52*t58
     1           +5.0d-1*rhoa*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t92*(1.0d+0*t90*(-6.666666666666666d-50*
     1           t110*t96*t98*t99+6.09932d-52*t100*t110*t111*t99-6.66666
     2           6666666666d-50*t110*t96*t97*t98+6.09932d-52*t110*t111*t
     3           94*t97*t98+3.04966d-52*t102*t110*t96*t98-3.333333333333
     4           333d-50*t110*t94*t96*t97-1.3333333333333333d-49*t110*t9
     5           3*t94*t96+3.04966d-52*t101*t110*t94*t96+6.09932d-52*t11
     6           0*t111*t93*t95-3.333333333333333d-50*t102*t110*t92-6.66
     7           6666666666666d-50*t101*t110*t92)+1.0d+0*t103*(t89+t59*(
     8           -2.3923187454478842d-1*t129*t64*t68*t85*t88-5.980796863
     9           619711d-2*t125*t63*t64*t85*t88+1.9751631321680768d-2*(t
     :           130+t128+t126+1.923661050931536d+0*t125)*t79*t83-6.2181
     ;           4d-2*(t130+t128+t126)*t61*t77+t134+t133+t132+t131+t118+
     <           t117+t116)+t84+t78+6.903522198342671d-18*t27*t28+3.1090
     =           699999999993d-2*t23*t24-rhoa*t107))+3.04966d-52*t103*t1
     >           10*t90*t96+t4*(5.0d-1*rhoa*t29*(-6.666666666666666d-50*
     ?           t110*t6*t7*t9-6.666666666666666d-50*t110*t14*t7*t9+5.15
     @           088d-52*t110*t12*t7*t9+4.1207039999999995d-101*t108*t10
     1           9*t14*t9-1.3333333333333333d-99*t109*t14*t7+2.060351999
     2           9999997d-101*t109*t13*t7-5.333333333333334d-99*t109*t11
     3           *t7+1.030176d-51*t10*t108*t110*t6-6.666666666666666d-50
     4           *t110*t13*t4-3.333333333333333d-50*t110*t12*t4+1.648281
     5           6d-150*t108*t11/rhoa**6)+5.0d-1*t15*t29+5.0d-1*rhoa*t10
     6           7*t15)+2.57544d-52*t1*t15*t29*t7)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t92*(1.0d+0*t90*(-6.666666666666667d+0*t
     1           47*t96*t98*t99*taub-3.3333333333333337d+0*t47*t94*t96*t
     2           97*taub-3.3333333333333337d+0*t102*t47*t92*taub-6.09932
     3           d-3*t100*t111*t136*t99-2.6666666666666666d+0*gammabb*t1
     4           35*t96*t97*t98-6.09932d-3*t111*t136*t94*t97*t98-3.04966
     5           d-3*t102*t136*t96*t98-5.333333333333333d+0*gammabb*t135
     6           *t93*t94*t96-3.04966d-3*t101*t136*t94*t96-6.09932d-3*t1
     7           11*t136*t93*t95-2.6666666666666666d+0*gammabb*t101*t135
     8           *t92)+1.0d+0*t103*(t89+t59*(2.3923187454478842d-1*t129*
     9           t64*t68*t85*t88-5.980796863619711d-2*t142*t63*t64*t85*t
     :           88+1.9751631321680768d-2*(t144+t143+1.923661050931536d+
     ;           0*t142+t128)*t79*t83-6.21814d-2*(t144+t143+t128)*t61*t7
     <           7+t134+t133+t132+t131+t118+t117+t116)+t84+t78+6.9035221
     =           98342671d-18*t41*t42+3.1090699999999993d-2*t37*t38-rhob
     >           *t141))+t52*(1.0d+0*rhob*t43*t46*(-6.666666666666667d+0
     ?           *t47*t55*t56*t6*taub-3.3333333333333337d+0*gammabb*t14*
     @           t54*t55*taub-3.3333333333333337d+0*t12*t47*t52*taub-1.0
     1           30176d-2*t136*t137*t57*t6-2.6666666666666666d+0*gammabb
     2           *t135*t14*t55*t56-5.15088d-3*t12*t136*t55*t56-1.030176d
     3           -2*gammabb*t136*t137*t14*t47*t56-5.333333333333333d+0*t
     4           11*t53*t55/rhob**6.333333333333333d+0-5.15088d-3*gammab
     5           b*t13*t136*t47*t55-1.030176d-2*t11*t136*t137*t53*t54-2.
     6           6666666666666666d+0*gammabb*t13*t135*t52)+1.0d+0*t43*t4
     7           6*t58+1.0d+0*rhob*t141*t46*t58)-3.04966d-3*t103*t136*t9
     8           0*t96-5.15088d-3*rhob*t136*t43*t46*t55*t58+1.25d-1*gamm
     9           abb*t43*t44*t45*t52*t58)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (1.0d+0*t90*t92*(-6.09932d-3*t100*t111*t
     1           47*t99+t47*t96*t97*t98-6.09932d-3*t111*t47*t94*t97*t98-
     2           3.04966d-3*t102*t47*t96*t98+2*t47*t93*t94*t96-3.04966d-
     3           3*t101*t47*t94*t96-6.09932d-3*t111*t47*t93*t95+t101*t47
     4           *t92)-3.04966d-3*t103*t47*t90*t96+1.0d+0*rhob*t43*t46*t
     5           52*(-1.030176d-2*t137*t47*t57*t6+t14*t47*t55*t56-5.1508
     6           8d-3*t12*t47*t55*t56-1.030176d-2*gammabb*t137*t14*t54*t
     7           56-5.15088d-3*gammabb*t13*t54*t55+2*gammabb*t11*t54*t55
     8           -1.030176d-2*t11*t137*t53/rhob**8+t13*t47*t52)-5.15088d
     9           -3*t43*t46*t49*t55*t58-1.25d-1*t43*t45*t52*t58)*wght+Cm
     :           at(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.25d-1*gammabb*t43*t52*t58/taub**2+1.0d
     1           +0*t90*t92*(4.0d+0*t49*t96*t98*t99-1.219864d-2*t100*t11
     2           1*t49*t99-1.219864d-2*t111*t49*t94*t97*t98-6.09932d-3*t
     3           102*t49*t96*t98+2.0d+0*t49*t94*t96*t97-6.09932d-3*t101*
     4           t49*t94*t96-1.219864d-2*t111*t49*t93*t95+2.0d+0*t102*t4
     5           9*t92)-6.09932d-3*t103*t49*t90*t96+1.0d+0*rhob*t43*t46*
     6           t52*(-2.060352d-2*t137*t49*t57*t6+4.0d+0*t49*t55*t56*t6
     7           -1.030176d-2*t12*t49*t55*t56-2.060352d-2*gammabb*t137*t
     8           14*t145*t56+2.0d+0*gammabb*t14*t145*t55-1.030176d-2*gam
     9           mabb*t13*t145*t55-2.060352d-2*t11*t137*t53/rhob**7+2.0d
     :           +0*t12*t49*t52)-1.030176d-2*t30*t43*t46*t55*t58)*wght+M
     ;           mat(iq,D1_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhoa**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhoa**6.666666666666666d-1
              t17 = rhoa**5.0d-1
              t18 = 1/t17
              t19 = 1/rhoa**3.333333333333333d-1
              t20 = 1/rhoa**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = 1/rhob**1.6666666666666669d+0
              t31 = 6.0d-50*t30
              t32 = 5.15088d-3*(t31-9.11559972d+0)+1.0d+0
              t33 = 1/t32
              t34 = 1/t32**2
              t35 = 2.0d-50*t30
              t36 = t35-9.11559972d+0
              t37 = t36**2
              t38 = t34*t37*t6+t5+4.0d-50*t14*t30*t34*t36+t12*t33*t36+1.
     1           6d-99*t11*t34/rhob**3.3333333333333337d+0+4.0d-50*t13*t
     2           30*t33
              t39 = 1/rhob**6.666666666666666d-1
              t40 = rhob**5.0d-1
              t41 = 1/t40
              t42 = 1/rhob**3.333333333333333d-1
              t43 = 1/rhob**1.6666666666666666d-1
              t44 = 1.1120374863094686d+1*t43+3.8447462374472113d+0*t42+
     1           1.644733775567609d+0*t41+2.4058712912881916d-1*t39
              t45 = 3.216395899738507d+1/t44+1.0d+0
              t46 = log(t45)
              t47 = 1.274696188700087d-1*t42+1.0d+0
              t48 = 5.982550435771079d+0*t43+2.2255694211506874d+0*t42+8
     1           .004286349993635d-1*t41+1.8970043257475583d-1*t39
              t49 = 1.6081979498692536d+1/t48+1.0d+0
              t50 = log(t49)
              t51 = 1.3256889990520176d-1*t42+1.0d+0
              t52 = -6.903522198342671d-18*t50*t51-3.1090699999999993d-2
     1           *t46*t47
              t53 = param(6)
              t54 = 3.04966d-3*(t31+t2-1.823119944d+1)+1.0d+0
              t55 = 1/t54**2
              t56 = t8+t35-1.823119944d+1
              t57 = t56**2
              t58 = param(4)
              t59 = 4.0d-50*t30+4.0d-50*t1
              t60 = t59**2
              t61 = param(3)
              t62 = 1/t54
              t63 = param(2)
              t64 = param(5)
              t65 = t55*t56*t59*t64+t59*t62*t63+t56*t61*t62+t55*t58*t60+
     1           t53*t55*t57+param(1)
              t66 = rhob+rhoa
              t67 = 1/t66**3.333333333333333d-1
              t68 = 1.3256889990520176d-1*t67+1.0d+0
              t69 = rhoa-rhob
              t70 = t69**4
              t71 = 1/t66**4
              t72 = 1/t66
              t73 = 1.0d+0-t69*t72
              t74 = t69*t72+1.0d+0
              t75 = t74**1.3333333333333333d+0+t73**1.3333333333333333d+
     1           0-2.0d+0
              t76 = -1.923661050931536d+0*t70*t71*t75
              t77 = t76+1.0d+0
              t78 = 1/t66**6.666666666666666d-1
              t79 = t66**5.0d-1
              t80 = 1/t79
              t81 = 1/t66**1.6666666666666666d-1
              t82 = 5.982550435771079d+0*t81+8.004286349993635d-1*t80+1.
     1           8970043257475583d-1*t78+2.2255694211506874d+0*t67
              t83 = 1.6081979498692536d+1/t82+1.0d+0
              t84 = log(t83)
              t85 = -6.21814d-2*t68*t77*t84
              t86 = 6.901399211255825d-2*t67+1.0d+0
              t87 = t76+1.923661050931536d+0*t75
              t88 = 8.157414703487641d+0*t81+4.3009724712766434d-1*t80+1
     1           .9115125951273373d-1*t78+2.247591863577616d+0*t67
              t89 = 2.9608813203268075d+1/t88+1.0d+0
              t90 = log(t89)
              t91 = 1.9751631321680768d-2*t86*t87*t90
              t92 = 1.274696188700087d-1*t67+1.0d+0
              t93 = 1.1120374863094686d+1*t81+1.644733775567609d+0*t80+2
     1           .4058712912881916d-1*t78+3.8447462374472113d+0*t67
              t94 = 3.216395899738507d+1/t93+1.0d+0
              t95 = log(t94)
              t96 = -5.980796863619711d-2*t70*t71*t75*t92*t95
              t97 = t66*(t96+t91+t85)-rhob*t52-rhoa*t29
              t98 = 1/t17**3
              t99 = 1/rhoa**1.3333333333333333d+0
              t100 = 1/rhoa**1.1666666666666667d+0
              t101 = 3.0506411443514264d-19*t27*t99+1.3210398931339265d-
     1           3*t23*t99+1.1102230246251565d-16*t28*(-7.41856473716895
     2           8d-1*t99-4.002143174996817d-1*t98-9.970917392951799d-1*
     3           t100-1.264669550498372d-1*t1)/(t25**2*t26)+1.0d+0*t24*(
     4           -1.2815820791490704d+0*t99-8.223668877838045d-1*t98-1.8
     5           533958105157808d+0*t100-1.6039141941921276d-1*t1)/(t21*
     6           *2*t22)
              t102 = 1/t3**3
              t103 = 1/rhoa**4.333333333333333d+0
              t104 = 1/rhoa**2.6666666666666666d+0
              t105 = 1/t66**1.6666666666666669d+0
              t106 = 1/t79**3
              t107 = 1/t66**1.3333333333333333d+0
              t108 = 1/t66**1.1666666666666667d+0
              t109 = 1.0d+0*(-9.970917392951799d-1*t108-7.41856473716895
     1           8d-1*t107-4.002143174996817d-1*t106-1.264669550498372d-
     2           1*t105)*t68*t77/(t82**2*t83)
              t110 = -5.848223622634647d-1*(-1.3595691172479402d+0*t108-
     1           7.491972878592053d-1*t107-2.1504862356383217d-1*t106-1.
     2           2743417300848914d-1*t105)*t86*t87/(t88**2*t89)
              t111 = 1.923661050931536d+0*(-1.8533958105157808d+0*t108-1
     1           .2815820791490704d+0*t107-8.223668877838045d-1*t106-1.6
     2           039141941921276d-1*t105)*t70*t71*t75*t92/(t93**2*t94)
              t112 = 1/t66**2
              t113 = t112*t69
              t114 = -t72
              t115 = t73**3.333333333333333d-1
              t116 = -t112*t69
              t117 = t74**3.333333333333333d-1
              t118 = 1.3333333333333333d+0*t117*(t72+t116)+1.33333333333
     1           33333d+0*(t114+t113)*t115
              t119 = -1.923661050931536d+0*t118*t70*t71
              t120 = 1/t66**5
              t121 = 7.694644203726144d+0*t120*t70*t75
              t122 = t69**3
              t123 = -7.694644203726144d+0*t122*t71*t75
              t124 = 2.747773264188437d-3*t107*t77*t84
              t125 = -4.5437964274821163d-4*t107*t87*t90
              t126 = 2.541232989148493d-3*t70*t75*t95/t66**5.33333333333
     1           3333d+0
              t127 = 2.3923187454478842d-1*t120*t70*t75*t92*t95
              t128 = 1/t54**3
              t129 = 1/t40**3
              t130 = 1/rhob**1.3333333333333333d+0
              t131 = 1/rhob**1.1666666666666667d+0
              t132 = 1.1102230246251565d-16*(-1.264669550498372d-1*t30-9
     1           .970917392951799d-1*t131-7.418564737168958d-1*t130-4.00
     2           2143174996817d-1*t129)*t51/(t48**2*t49)+3.0506411443514
     3           264d-19*t130*t50+1.0d+0*(-1.6039141941921276d-1*t30-1.8
     4           533958105157808d+0*t131-1.2815820791490704d+0*t130-8.22
     5           3668877838045d-1*t129)*t47/(t44**2*t45)+1.3210398931339
     6           265d-3*t130*t46
              t133 = 1/t32**3
              t134 = 1/rhob**4.333333333333333d+0
              t135 = 1/rhob**2.6666666666666666d+0
              t136 = 1.3333333333333333d+0*t115*(t72+t113)+1.33333333333
     1           33333d+0*(t116+t114)*t117
              t137 = -1.923661050931536d+0*t136*t70*t71
              t138 = 7.694644203726144d+0*t122*t71*t75
              fnc(iq) = (1.0d+0*t62*t65*t97+5.0d-1*rhob*t33*t38*t52+5.0d
     1           -1*rhoa*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t62*(1.0d+0*(6.09932d-52*t104*t128*t56*t
     1           59*t64-3.333333333333333d-50*t104*t55*t59*t64-6.6666666
     2           66666666d-50*t104*t55*t56*t64-6.666666666666666d-50*t10
     3           4*t62*t63+3.04966d-52*t104*t55*t59*t63-3.33333333333333
     4           3d-50*t104*t61*t62+3.04966d-52*t104*t55*t56*t61+6.09932
     5           d-52*t104*t128*t58*t60-1.3333333333333333d-49*t104*t55*
     6           t58*t59+6.09932d-52*t104*t128*t53*t57-6.666666666666666
     7           d-50*t104*t53*t55*t56)*t97+1.0d+0*t65*(t96+t66*(-2.3923
     8           187454478842d-1*t122*t71*t75*t92*t95-5.980796863619711d
     9           -2*t118*t70*t71*t92*t95+1.9751631321680768d-2*(t123+t12
     :           1+t119+1.923661050931536d+0*t118)*t86*t90-6.21814d-2*(t
     ;           123+t121+t119)*t68*t84+t127+t126+t125+t124+t111+t110+t1
     <           09)+t91+t85+6.903522198342671d-18*t27*t28+3.10906999999
     =           99993d-2*t23*t24-rhoa*t101))+3.04966d-52*t104*t55*t65*t
     >           97+t4*(5.0d-1*rhoa*t29*(-6.666666666666666d-50*t104*t6*
     ?           t7*t9-6.666666666666666d-50*t104*t14*t7*t9+5.15088d-52*
     @           t104*t12*t7*t9+4.1207039999999995d-101*t102*t103*t14*t9
     1           -1.3333333333333333d-99*t103*t14*t7+2.0603519999999997d
     2           -101*t103*t13*t7-5.333333333333334d-99*t103*t11*t7+1.03
     3           0176d-51*t10*t102*t104*t6-6.666666666666666d-50*t104*t1
     4           3*t4-3.333333333333333d-50*t104*t12*t4+1.6482816d-150*t
     5           102*t11/rhoa**6)+5.0d-1*t15*t29+5.0d-1*rhoa*t101*t15)+2
     6           .57544d-52*t1*t15*t29*t7)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t62*(1.0d+0*(6.09932d-52*t128*t135*t56*t
     1           59*t64-3.333333333333333d-50*t135*t55*t59*t64-6.6666666
     2           66666666d-50*t135*t55*t56*t64-6.666666666666666d-50*t13
     3           5*t62*t63+3.04966d-52*t135*t55*t59*t63-3.33333333333333
     4           3d-50*t135*t61*t62+3.04966d-52*t135*t55*t56*t61+6.09932
     5           d-52*t128*t135*t58*t60-1.3333333333333333d-49*t135*t55*
     6           t58*t59+6.09932d-52*t128*t135*t53*t57-6.666666666666666
     7           d-50*t135*t53*t55*t56)*t97+1.0d+0*t65*(t96+t66*(2.39231
     8           87454478842d-1*t122*t71*t75*t92*t95-5.980796863619711d-
     9           2*t136*t70*t71*t92*t95+1.9751631321680768d-2*(t138+t137
     :           +1.923661050931536d+0*t136+t121)*t86*t90-6.21814d-2*(t1
     ;           38+t137+t121)*t68*t84+t127+t126+t125+t124+t111+t110+t10
     <           9)+t91+t85+6.903522198342671d-18*t50*t51+3.109069999999
     =           9993d-2*t46*t47-rhob*t132))+3.04966d-52*t135*t55*t65*t9
     >           7+t33*(5.0d-1*rhob*t52*(1.030176d-51*t133*t135*t37*t6-6
     ?           .666666666666666d-50*t135*t34*t36*t6-6.666666666666666d
     @           -50*t135*t14*t34*t36+5.15088d-52*t12*t135*t34*t36+4.120
     1           7039999999995d-101*t133*t134*t14*t36-1.3333333333333333
     2           d-99*t134*t14*t34+2.0603519999999997d-101*t13*t134*t34-
     3           5.333333333333334d-99*t11*t134*t34-6.666666666666666d-5
     4           0*t13*t135*t33-3.333333333333333d-50*t12*t135*t33+1.648
     5           2816d-150*t11*t133/rhob**6)+5.0d-1*t38*t52+5.0d-1*rhob*
     6           t132*t38)+2.57544d-52*t30*t34*t38*t52)*wght+Amat(iq,D1_
     7           RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taua
              t21 = 5.15088d-3*(t20+gammaaa*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammaaa**2
              t25 = 1/rhoa**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammaaa*t18*t22*t31+t26*t29*t30+gammaaa*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = 1/rhoa**3.6666666666666664d+0
              t35 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d+
     1           0*gammaaa*t34
              t36 = 1/t21**3
              t37 = 1/t2**3
              t38 = 1/rhoa**1.3333333333333333d+0
              t39 = 1/rhoa**1.1666666666666667d+0
              t40 = 1/rhoa**4.333333333333333d+0
              fnc(iq) = 1.0d+0*rhoa*t14*t17*t22*t33*wght+fnc(iq)
              Amat(iq,D1_RA) = t22*(1.0d+0*rhoa*t14*t17*(-3.333333333333
     1           3337d+0*t18*t22*t32*taua-6.666666666666667d+0*t18*t26*t
     2           28*t29*taua-3.3333333333333337d+0*gammaaa*t25*t26*t27*t
     3           aua-1.030176d-2*t29*t30*t35*t36-1.030176d-2*gammaaa*t18
     4           *t27*t28*t35*t36-1.030176d-2*t23*t24*t25*t35*t36-5.1508
     5           8d-3*t26*t28*t32*t35-5.15088d-3*gammaaa*t18*t26*t31*t35
     6           -2.6666666666666666d+0*gammaaa*t22*t31*t34-2.6666666666
     7           666666d+0*gammaaa*t26*t27*t28*t34-5.333333333333333d+0*
     8           t23*t24*t26/rhoa**6.333333333333333d+0)*wght+1.0d+0*rho
     9           a*t17*t33*(1.0d+0*(-1.8533958105157808d+0*t39-1.2815820
     :           791490704d+0*t38-8.223668877838045d-1*t37-1.60391419419
     ;           21276d-1*t19)*t9/(t6**2*t7)+1.3210398931339265d-3*t38*t
     <           8+1.1102230246251565d-16*t13*(-9.970917392951799d-1*t39
     =           -7.418564737168958d-1*t38-4.002143174996817d-1*t37-1.26
     >           4669550498372d-1*t19)/(t10**2*t11)+3.0506411443514264d-
     ?           19*t12*t38)*wght+1.0d+0*t14*t17*t33*wght)-5.15088d-3*rh
     @           oa*t14*t17*t26*t33*t35*wght+1.25d-1*gammaaa*t14*t15*t16
     1           *t22*t33*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t14*t17*t22*(-1.030176d-2*t1
     1           8*t29*t30*t36-1.030176d-2*gammaaa*t25*t27*t28*t36-1.030
     2           176d-2*t23*t24*t36/rhoa**8-5.15088d-3*t18*t26*t28*t32-5
     3           .15088d-3*gammaaa*t25*t26*t31+t18*t22*t31+t18*t26*t27*t
     4           28+2*gammaaa*t23*t25*t26)*wght-5.15088d-3*t14*t17*t19*t
     5           26*t33*wght-1.25d-1*t14*t16*t22*t33*wght+Cmat(iq,D1_GAA
     6           )
              Mmat(iq,D1_TA) = 1.25d-1*gammaaa*t14*t22*t33*wght/taua**2+
     1           1.0d+0*rhoa*t14*t17*t22*(-2.060352d-2*gammaaa*t27*t28*t
     2           36*t40-1.030176d-2*gammaaa*t26*t31*t40+2.0d+0*gammaaa*t
     3           26*t27*t40-2.060352d-2*t19*t29*t30*t36-2.060352d-2*t23*
     4           t24*t36/rhoa**7-1.030176d-2*t19*t26*t28*t32+2.0d+0*t19*
     5           t22*t32+4.0d+0*t19*t26*t28*t29)*wght-1.030176d-2*t1*t14
     6           *t17*t26*t33*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taua
              t21 = 5.15088d-3*(t20+gammaaa*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammaaa**2
              t25 = 1/rhoa**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammaaa*t18*t22*t31+t26*t29*t30+gammaaa*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = 1/rhoa**3.6666666666666664d+0
              t35 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d+
     1           0*gammaaa*t34
              t36 = 1/t21**3
              t37 = 1/t2**3
              t38 = 1/rhoa**1.3333333333333333d+0
              t39 = 1/rhoa**1.1666666666666667d+0
              t40 = 1/rhoa**4.333333333333333d+0
              fnc(iq) = 1.0d+0*rhoa*t14*t17*t22*t33*wght+fnc(iq)
              Amat(iq,D1_RA) = t22*(1.0d+0*rhoa*t14*t17*(-3.333333333333
     1           3337d+0*t18*t22*t32*taua-6.666666666666667d+0*t18*t26*t
     2           28*t29*taua-3.3333333333333337d+0*gammaaa*t25*t26*t27*t
     3           aua-1.030176d-2*t29*t30*t35*t36-1.030176d-2*gammaaa*t18
     4           *t27*t28*t35*t36-1.030176d-2*t23*t24*t25*t35*t36-5.1508
     5           8d-3*t26*t28*t32*t35-5.15088d-3*gammaaa*t18*t26*t31*t35
     6           -2.6666666666666666d+0*gammaaa*t22*t31*t34-2.6666666666
     7           666666d+0*gammaaa*t26*t27*t28*t34-5.333333333333333d+0*
     8           t23*t24*t26/rhoa**6.333333333333333d+0)*wght+1.0d+0*rho
     9           a*t17*t33*(1.0d+0*(-1.8533958105157808d+0*t39-1.2815820
     :           791490704d+0*t38-8.223668877838045d-1*t37-1.60391419419
     ;           21276d-1*t19)*t9/(t6**2*t7)+1.3210398931339265d-3*t38*t
     <           8+1.1102230246251565d-16*t13*(-9.970917392951799d-1*t39
     =           -7.418564737168958d-1*t38-4.002143174996817d-1*t37-1.26
     >           4669550498372d-1*t19)/(t10**2*t11)+3.0506411443514264d-
     ?           19*t12*t38)*wght+1.0d+0*t14*t17*t33*wght)-5.15088d-3*rh
     @           oa*t14*t17*t26*t33*t35*wght+1.25d-1*gammaaa*t14*t15*t16
     1           *t22*t33*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t14*t17*t22*(-1.030176d-2*t1
     1           8*t29*t30*t36-1.030176d-2*gammaaa*t25*t27*t28*t36-1.030
     2           176d-2*t23*t24*t36/rhoa**8-5.15088d-3*t18*t26*t28*t32-5
     3           .15088d-3*gammaaa*t25*t26*t31+t18*t22*t31+t18*t26*t27*t
     4           28+2*gammaaa*t23*t25*t26)*wght-5.15088d-3*t14*t17*t19*t
     5           26*t33*wght-1.25d-1*t14*t16*t22*t33*wght+Cmat(iq,D1_GAA
     6           )
              Mmat(iq,D1_TA) = 1.25d-1*gammaaa*t14*t22*t33*wght/taua**2+
     1           1.0d+0*rhoa*t14*t17*t22*(-2.060352d-2*gammaaa*t27*t28*t
     2           36*t40-1.030176d-2*gammaaa*t26*t31*t40+2.0d+0*gammaaa*t
     3           26*t27*t40-2.060352d-2*t19*t29*t30*t36-2.060352d-2*t23*
     4           t24*t36/rhoa**7-1.030176d-2*t19*t26*t28*t32+2.0d+0*t19*
     5           t22*t32+4.0d+0*t19*t26*t28*t29)*wght-1.030176d-2*t1*t14
     6           *t17*t26*t33*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhoa**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/t14**3
              t28 = 1/rhoa**1.3333333333333333d+0
              t29 = 1/rhoa**1.1666666666666667d+0
              t30 = 1/t2**3
              t31 = 1/rhoa**4.333333333333333d+0
              t32 = 1/rhoa**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhoa*t12*t26*t3*wght+fnc(iq)
              Amat(iq,D1_RA) = t3*(5.0d-1*rhoa*t26*(5.15088d-52*t32*t5*t
     1           6*t9-3.333333333333333d-50*t3*t32*t9-5.333333333333334d
     2           -99*t31*t5*t8+1.6482816d-150*t30*t8/rhoa**6+1.030176d-5
     3           1*t30*t32*t4*t7-6.666666666666666d-50*t32*t4*t5*t6-6.66
     4           6666666666666d-50*t11*t32*t5*t6+4.1207039999999995d-101
     5           *t11*t30*t31*t6-1.3333333333333333d-99*t11*t31*t5+2.060
     6           3519999999997d-101*t10*t31*t5-6.666666666666666d-50*t10
     7           *t3*t32)*wght+5.0d-1*rhoa*t12*(1.1102230246251565d-16*t
     8           25*(-9.970917392951799d-1*t29-7.418564737168958d-1*t28-
     9           4.002143174996817d-1*t27-1.264669550498372d-1*t1)/(t22*
     :           *2*t23)+1.0d+0*t21*(-1.8533958105157808d+0*t29-1.281582
     ;           0791490704d+0*t28-8.223668877838045d-1*t27-1.6039141941
     <           921276d-1*t1)/(t18**2*t19)+3.0506411443514264d-19*t24*t
     =           28+1.3210398931339265d-3*t20*t28)*wght+5.0d-1*t12*t26*w
     >           ght)+2.57544d-52*t1*t12*t26*t5*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhoa**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/t14**3
              t28 = 1/rhoa**1.3333333333333333d+0
              t29 = 1/rhoa**1.1666666666666667d+0
              t30 = 1/t2**3
              t31 = 1/rhoa**4.333333333333333d+0
              t32 = 1/rhoa**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhoa*t12*t26*t3*wght+fnc(iq)
              Amat(iq,D1_RA) = t3*(5.0d-1*rhoa*t26*(5.15088d-52*t32*t5*t
     1           6*t9-3.333333333333333d-50*t3*t32*t9-5.333333333333334d
     2           -99*t31*t5*t8+1.6482816d-150*t30*t8/rhoa**6+1.030176d-5
     3           1*t30*t32*t4*t7-6.666666666666666d-50*t32*t4*t5*t6-6.66
     4           6666666666666d-50*t11*t32*t5*t6+4.1207039999999995d-101
     5           *t11*t30*t31*t6-1.3333333333333333d-99*t11*t31*t5+2.060
     6           3519999999997d-101*t10*t31*t5-6.666666666666666d-50*t10
     7           *t3*t32)*wght+5.0d-1*rhoa*t12*(1.1102230246251565d-16*t
     8           25*(-9.970917392951799d-1*t29-7.418564737168958d-1*t28-
     9           4.002143174996817d-1*t27-1.264669550498372d-1*t1)/(t22*
     :           *2*t23)+1.0d+0*t21*(-1.8533958105157808d+0*t29-1.281582
     ;           0791490704d+0*t28-8.223668877838045d-1*t27-1.6039141941
     <           921276d-1*t1)/(t18**2*t19)+3.0506411443514264d-19*t24*t
     =           28+1.3210398931339265d-3*t20*t28)*wght+5.0d-1*t12*t26*w
     >           ght)+2.57544d-52*t1*t12*t26*t5*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**6.666666666666666d-1
              t2 = rhob**5.0d-1
              t3 = 1/t2
              t4 = 1/rhob**3.333333333333333d-1
              t5 = 1/rhob**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhob
              t16 = 1/taub
              t17 = 1.0d+0-1.25d-1*gammabb*t15*t16
              t18 = 1/rhob**2.6666666666666666d+0
              t19 = 1/rhob**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taub
              t21 = 5.15088d-3*(t20+gammabb*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammabb**2
              t25 = 1/rhob**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammabb*t18*t22*t31+t26*t29*t30+gammabb*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = 1/rhob**3.6666666666666664d+0
              t35 = -3.3333333333333337d+0*t18*taub-2.6666666666666666d+
     1           0*gammabb*t34
              t36 = 1/t21**3
              t37 = 1/t2**3
              t38 = 1/rhob**1.3333333333333333d+0
              t39 = 1/rhob**1.1666666666666667d+0
              t40 = 1/rhob**4.333333333333333d+0
              fnc(iq) = 1.0d+0*rhob*t14*t17*t22*t33*wght+fnc(iq)
              Amat(iq,D1_RB) = t22*(1.0d+0*rhob*t14*t17*(-3.333333333333
     1           3337d+0*t18*t22*t32*taub-6.666666666666667d+0*t18*t26*t
     2           28*t29*taub-3.3333333333333337d+0*gammabb*t25*t26*t27*t
     3           aub-1.030176d-2*t29*t30*t35*t36-1.030176d-2*gammabb*t18
     4           *t27*t28*t35*t36-1.030176d-2*t23*t24*t25*t35*t36-5.1508
     5           8d-3*t26*t28*t32*t35-5.15088d-3*gammabb*t18*t26*t31*t35
     6           -2.6666666666666666d+0*gammabb*t22*t31*t34-2.6666666666
     7           666666d+0*gammabb*t26*t27*t28*t34-5.333333333333333d+0*
     8           t23*t24*t26/rhob**6.333333333333333d+0)*wght+1.0d+0*rho
     9           b*t17*t33*(1.0d+0*(-1.8533958105157808d+0*t39-1.2815820
     :           791490704d+0*t38-8.223668877838045d-1*t37-1.60391419419
     ;           21276d-1*t19)*t9/(t6**2*t7)+1.3210398931339265d-3*t38*t
     <           8+1.1102230246251565d-16*t13*(-9.970917392951799d-1*t39
     =           -7.418564737168958d-1*t38-4.002143174996817d-1*t37-1.26
     >           4669550498372d-1*t19)/(t10**2*t11)+3.0506411443514264d-
     ?           19*t12*t38)*wght+1.0d+0*t14*t17*t33*wght)-5.15088d-3*rh
     @           ob*t14*t17*t26*t33*t35*wght+1.25d-1*gammabb*t14*t15*t16
     1           *t22*t33*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = 1.0d+0*rhob*t14*t17*t22*(-1.030176d-2*t1
     1           8*t29*t30*t36-1.030176d-2*gammabb*t25*t27*t28*t36-1.030
     2           176d-2*t23*t24*t36/rhob**8-5.15088d-3*t18*t26*t28*t32-5
     3           .15088d-3*gammabb*t25*t26*t31+t18*t22*t31+t18*t26*t27*t
     4           28+2*gammabb*t23*t25*t26)*wght-5.15088d-3*t14*t17*t19*t
     5           26*t33*wght-1.25d-1*t14*t16*t22*t33*wght+Cmat(iq,D1_GBB
     6           )
              Mmat(iq,D1_TB) = 1.25d-1*gammabb*t14*t22*t33*wght/taub**2+
     1           1.0d+0*rhob*t14*t17*t22*(-2.060352d-2*gammabb*t27*t28*t
     2           36*t40-1.030176d-2*gammabb*t26*t31*t40+2.0d+0*gammabb*t
     3           26*t27*t40-2.060352d-2*t19*t29*t30*t36-2.060352d-2*t23*
     4           t24*t36/rhob**7-1.030176d-2*t19*t26*t28*t32+2.0d+0*t19*
     5           t22*t32+4.0d+0*t19*t26*t28*t29)*wght-1.030176d-2*t1*t14
     6           *t17*t26*t33*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhob**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/t14**3
              t28 = 1/rhob**1.3333333333333333d+0
              t29 = 1/rhob**1.1666666666666667d+0
              t30 = 1/t2**3
              t31 = 1/rhob**4.333333333333333d+0
              t32 = 1/rhob**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhob*t12*t26*t3*wght+fnc(iq)
              Amat(iq,D1_RB) = t3*(5.0d-1*rhob*t26*(5.15088d-52*t32*t5*t
     1           6*t9-3.333333333333333d-50*t3*t32*t9-5.333333333333334d
     2           -99*t31*t5*t8+1.6482816d-150*t30*t8/rhob**6+1.030176d-5
     3           1*t30*t32*t4*t7-6.666666666666666d-50*t32*t4*t5*t6-6.66
     4           6666666666666d-50*t11*t32*t5*t6+4.1207039999999995d-101
     5           *t11*t30*t31*t6-1.3333333333333333d-99*t11*t31*t5+2.060
     6           3519999999997d-101*t10*t31*t5-6.666666666666666d-50*t10
     7           *t3*t32)*wght+5.0d-1*rhob*t12*(1.1102230246251565d-16*t
     8           25*(-9.970917392951799d-1*t29-7.418564737168958d-1*t28-
     9           4.002143174996817d-1*t27-1.264669550498372d-1*t1)/(t22*
     :           *2*t23)+1.0d+0*t21*(-1.8533958105157808d+0*t29-1.281582
     ;           0791490704d+0*t28-8.223668877838045d-1*t27-1.6039141941
     <           921276d-1*t1)/(t18**2*t19)+3.0506411443514264d-19*t24*t
     =           28+1.3210398931339265d-3*t20*t28)*wght+5.0d-1*t12*t26*w
     >           ght)+2.57544d-52*t1*t12*t26*t5*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**6.666666666666666d-1
              t2 = rhob**5.0d-1
              t3 = 1/t2
              t4 = 1/rhob**3.333333333333333d-1
              t5 = 1/rhob**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhob
              t16 = 1/taub
              t17 = 1.0d+0-1.25d-1*gammabb*t15*t16
              t18 = 1/rhob**2.6666666666666666d+0
              t19 = 1/rhob**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taub
              t21 = 5.15088d-3*(t20+gammabb*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammabb**2
              t25 = 1/rhob**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammabb*t18*t22*t31+t26*t29*t30+gammabb*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = 1/rhob**3.6666666666666664d+0
              t35 = -3.3333333333333337d+0*t18*taub-2.6666666666666666d+
     1           0*gammabb*t34
              t36 = 1/t21**3
              t37 = 1/t2**3
              t38 = 1/rhob**1.3333333333333333d+0
              t39 = 1/rhob**1.1666666666666667d+0
              t40 = 1/rhob**4.333333333333333d+0
              fnc(iq) = 1.0d+0*rhob*t14*t17*t22*t33*wght+fnc(iq)
              Amat(iq,D1_RB) = t22*(1.0d+0*rhob*t14*t17*(-3.333333333333
     1           3337d+0*t18*t22*t32*taub-6.666666666666667d+0*t18*t26*t
     2           28*t29*taub-3.3333333333333337d+0*gammabb*t25*t26*t27*t
     3           aub-1.030176d-2*t29*t30*t35*t36-1.030176d-2*gammabb*t18
     4           *t27*t28*t35*t36-1.030176d-2*t23*t24*t25*t35*t36-5.1508
     5           8d-3*t26*t28*t32*t35-5.15088d-3*gammabb*t18*t26*t31*t35
     6           -2.6666666666666666d+0*gammabb*t22*t31*t34-2.6666666666
     7           666666d+0*gammabb*t26*t27*t28*t34-5.333333333333333d+0*
     8           t23*t24*t26/rhob**6.333333333333333d+0)*wght+1.0d+0*rho
     9           b*t17*t33*(1.0d+0*(-1.8533958105157808d+0*t39-1.2815820
     :           791490704d+0*t38-8.223668877838045d-1*t37-1.60391419419
     ;           21276d-1*t19)*t9/(t6**2*t7)+1.3210398931339265d-3*t38*t
     <           8+1.1102230246251565d-16*t13*(-9.970917392951799d-1*t39
     =           -7.418564737168958d-1*t38-4.002143174996817d-1*t37-1.26
     >           4669550498372d-1*t19)/(t10**2*t11)+3.0506411443514264d-
     ?           19*t12*t38)*wght+1.0d+0*t14*t17*t33*wght)-5.15088d-3*rh
     @           ob*t14*t17*t26*t33*t35*wght+1.25d-1*gammabb*t14*t15*t16
     1           *t22*t33*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = 1.0d+0*rhob*t14*t17*t22*(-1.030176d-2*t1
     1           8*t29*t30*t36-1.030176d-2*gammabb*t25*t27*t28*t36-1.030
     2           176d-2*t23*t24*t36/rhob**8-5.15088d-3*t18*t26*t28*t32-5
     3           .15088d-3*gammabb*t25*t26*t31+t18*t22*t31+t18*t26*t27*t
     4           28+2*gammabb*t23*t25*t26)*wght-5.15088d-3*t14*t17*t19*t
     5           26*t33*wght-1.25d-1*t14*t16*t22*t33*wght+Cmat(iq,D1_GBB
     6           )
              Mmat(iq,D1_TB) = 1.25d-1*gammabb*t14*t22*t33*wght/taub**2+
     1           1.0d+0*rhob*t14*t17*t22*(-2.060352d-2*gammabb*t27*t28*t
     2           36*t40-1.030176d-2*gammabb*t26*t31*t40+2.0d+0*gammabb*t
     3           26*t27*t40-2.060352d-2*t19*t29*t30*t36-2.060352d-2*t23*
     4           t24*t36/rhob**7-1.030176d-2*t19*t26*t28*t32+2.0d+0*t19*
     5           t22*t32+4.0d+0*t19*t26*t28*t29)*wght-1.030176d-2*t1*t14
     6           *t17*t26*t33*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhob**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/t14**3
              t28 = 1/rhob**1.3333333333333333d+0
              t29 = 1/rhob**1.1666666666666667d+0
              t30 = 1/t2**3
              t31 = 1/rhob**4.333333333333333d+0
              t32 = 1/rhob**2.6666666666666666d+0
              fnc(iq) = 5.0d-1*rhob*t12*t26*t3*wght+fnc(iq)
              Amat(iq,D1_RB) = t3*(5.0d-1*rhob*t26*(5.15088d-52*t32*t5*t
     1           6*t9-3.333333333333333d-50*t3*t32*t9-5.333333333333334d
     2           -99*t31*t5*t8+1.6482816d-150*t30*t8/rhob**6+1.030176d-5
     3           1*t30*t32*t4*t7-6.666666666666666d-50*t32*t4*t5*t6-6.66
     4           6666666666666d-50*t11*t32*t5*t6+4.1207039999999995d-101
     5           *t11*t30*t31*t6-1.3333333333333333d-99*t11*t31*t5+2.060
     6           3519999999997d-101*t10*t31*t5-6.666666666666666d-50*t10
     7           *t3*t32)*wght+5.0d-1*rhob*t12*(1.1102230246251565d-16*t
     8           25*(-9.970917392951799d-1*t29-7.418564737168958d-1*t28-
     9           4.002143174996817d-1*t27-1.264669550498372d-1*t1)/(t22*
     :           *2*t23)+1.0d+0*t21*(-1.8533958105157808d+0*t29-1.281582
     ;           0791490704d+0*t28-8.223668877838045d-1*t27-1.6039141941
     <           921276d-1*t1)/(t18**2*t19)+3.0506411443514264d-19*t24*t
     =           28+1.3210398931339265d-3*t20*t28)*wght+5.0d-1*t12*t26*w
     >           ght)+2.57544d-52*t1*t12*t26*t5*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vs98 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}\,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_8} &=& {{2.0\,\tau_\alpha}\over{\rho_\alpha^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_9} &=& 0.00515088\,\left({\it t_8}+{\it t_7}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{10}} &=& {{1}\over{{\it t_9}}}\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{12}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_9}^2}}\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{15}} &=& {\it t_8}-9.11559972\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{23}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{22}}+2.225569421150687\,{\it t_{21}}+0.8004286349993635
C>    \,{\it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{21}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{22}}+3.844746237447211\,{\it t_{21}}+1.644733775567609
C>    \,{\it t_{20}}+0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{21}}+1.0\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{25}} &=& {\it t_{24}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{26}} &=& {{2.0\,\tau_\beta}\over{\rho_\beta^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_{27}} &=& 0.00515088\,\left({\it t_{26}}+{\it t_{25}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{27}}}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{{\it t_{27}}^2}}\\\\ 
C>   {\it t_{30}} &=& {\it t_{26}}-9.11559972\\\\ 
C>   {\it t_{31}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{31}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{33}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{34}} &=& {\it t_{33}}^4\\\\ 
C>   {\it t_{35}} &=& {{1}\over{{\it t_{31}}^4}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_{31}}}}\\\\ 
C>   {\it t_{37}} &=& \left({\it t_{33}}\,{\it t_{36}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{33}}\,{
C>    \it t_{36}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{38}} &=& -1.923661050931536\,{\it t_{34}}\,{\it t_{35}}
C>    \,{\it t_{37}}\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{31}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\sqrt{{\it t_{31}}}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{31}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{42}} &=& 0.00304966\,\left({\it t_{26}}+{\it t_8}+{
C>    \it t_{25}}+{\it t_7}-18.23119944\right)+1.0\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{42}}}}\\\\ 
C>   {\it t_{44}} &=& {\it t_{25}}+{\it t_7}\\\\ 
C>   {\it t_{45}} &=& {{1}\over{{\it t_{42}}^2}}\\\\ 
C>   {\it t_{46}} &=& {\it t_{26}}+{\it t_8}-18.23119944\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{51}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{52}} &=& {{2.0\,\tau_s}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{53}} &=& 0.00515088\,\left({\it t_{52}}+{\it t_{51}}
C>    \,\sigma_{ss}-9.11559972\right)+1.0\\\\ 
C>   {\it t_{54}} &=& {{1}\over{{\it t_{53}}}}\\\\ 
C>   {\it t_{55}} &=& {{1}\over{{\it t_{53}}^2}}\\\\ 
C>   {\it t_{56}} &=& {\it t_{52}}-9.11559972\\\\ 
C>   f &=& 1.0\,\left({\it t_{31}}\,\left(-0.0598079686361971\,{
C>    \it t_{34}}\,{\it t_{35}}\,\left(0.1274696188700087\,{
C>    \it t_{32}}+1.0\right)\,{\it t_{37}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{41}}
C>    +3.844746237447211\,{\it t_{32}}+1.644733775567609\,{\it t_{40}}
C>    +0.2405871291288192\,{\it t_{39}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{32}}
C>    +1.0\right)\,\left({\it t_{38}}+1.923661050931536\,{
C>    \it t_{37}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{41}}+2.247591863577616\,{
C>    \it t_{32}}+0.4300972471276643\,{\it t_{40}}
C>    +0.1911512595127337\,{\it t_{39}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{32}}+1.0\right)\,\left({
C>    \it t_{38}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{41}}+2.225569421150687\,{
C>    \it t_{32}}+0.8004286349993635\,{\it t_{40}}
C>    +0.1897004325747558\,{\it t_{39}}}}+1.0\right)\right)-{
C>    \it t_{23}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)\,{
C>    \it t_{43}}\,\left({\it param}\left(3\right)\,{\it t_{46}}
C>    \,{\it t_{43}}+{\it param}\left(2\right)\,{\it t_{44}}\,{
C>    \it t_{43}}+{\it param}\left(6\right)\,{\it t_{46}}^2\,{
C>    \it t_{45}}+{\it param}\left(5\right)\,{\it t_{44}}\,{
C>    \it t_{46}}\,{\it t_{45}}+{\it param}\left(4\right)\,{
C>    \it t_{44}}^2\,{\it t_{45}}+{\it param}\left(1\right)\right)
C>    +1.0\,{\it t_{23}}\,\rho_\beta\,\left(1.0-{{0.125\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta\,\tau_\beta}}\right)\,{
C>    \it t_{28}}\,\left({\it t_{18}}\,{\it t_{30}}\,{\it t_{28}}
C>    +{\it t_{17}}\,{\it t_{24}}\,\sigma_{\beta\beta}\,{\it t_{28}}
C>    +{\it t_{16}}\,{\it t_{30}}^2\,{\it t_{29}}+{\it t_{14}}\,{
C>    \it t_{24}}\,\sigma_{\beta\beta}\,{\it t_{30}}\,{\it t_{29}}
C>    +{{{\it t_{12}}\,\sigma_{\beta\beta}^2\,{\it t_{29}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{11}}\right)+1.0
C>    \,{\it t_5}\,\rho_\alpha\,\left(1.0-{{0.125\,
C>    \sigma_{\alpha\alpha}}\over{\rho_\alpha\,\tau_\alpha}}\right)
C>    \,{\it t_{10}}\,\left({\it t_{18}}\,{\it t_{15}}\,{\it t_{10}}
C>    +{\it t_{17}}\,{\it t_6}\,\sigma_{\alpha\alpha}\,{\it t_{10}}
C>    +{\it t_{16}}\,{\it t_{15}}^2\,{\it t_{13}}+{\it t_{14}}\,{
C>    \it t_6}\,\sigma_{\alpha\alpha}\,{\it t_{15}}\,{\it t_{13}}
C>    +{{{\it t_{12}}\,\sigma_{\alpha\alpha}^2\,{\it t_{13}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{11}}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{50}}+2.225569421150687\,{\it t_{49}}+0.8004286349993635
C>    \,{\it t_{48}}+0.1897004325747558\,{\it t_{47}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{49}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{50}}+3.844746237447211\,{\it t_{49}}+1.644733775567609
C>    \,{\it t_{48}}+0.2405871291288192\,{\it t_{47}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{49}}+1.0\right)\right)
C>    \,\rho_s\,\left(1.0-{{0.125\,\sigma_{ss}}\over{\rho_s
C>    \,\tau_s}}\right)\,{\it t_{54}}\,\left({\it t_{18}}\,{
C>    \it t_{56}}\,{\it t_{54}}+{\it t_{17}}\,{\it t_{51}}\,
C>    \sigma_{ss}\,{\it t_{54}}+{\it t_{16}}\,{\it t_{56}}^2\,{
C>    \it t_{55}}+{\it t_{14}}\,{\it t_{51}}\,\sigma_{ss}\,{
C>    \it t_{56}}\,{\it t_{55}}+{{{\it t_{12}}\,\sigma_{ss}^2\,{
C>    \it t_{55}}}\over{\rho_s^{{{16}\over{3}}}}}+{
C>    \it t_{11}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] T van Voorhis, GE Scuseria, J.Chem.Phys. 109, 400 (1998)  , DOI: 
C> <a href="https://doi.org/10.1063/1.3005348 "> 
C> 10.1063/1.3005348 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_vs98_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taua
              t21 = 5.15088d-3*(t20+gammaaa*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammaaa**2
              t25 = 1/rhoa**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammaaa*t18*t22*t31+t26*t29*t30+gammaaa*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = -2*rhoa*t14
              t35 = 4.0d+0*t19*taua
              t36 = 3.04966d-3*(t35+2*gammaaa*t18-1.823119944d+1)+1.0d+0
              t37 = 1/t36
              t38 = param(4)
              t39 = 1/t36**2
              t40 = param(5)
              t41 = t35-1.823119944d+1
              t42 = param(6)
              t43 = t41**2
              t44 = param(2)
              t45 = param(3)
              t46 = t37*t41*t45+2*gammaaa*t18*t37*t44+t39*t42*t43+2*gamm
     1           aaa*t18*t39*t40*t41+4*t24*t25*t38*t39+param(1)
              t47 = 1/rhoa**3.6666666666666664d+0
              t48 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d+
     1           0*gammaaa*t47
              t49 = 1/t21**3
              t50 = 1/rhoa**6.333333333333333d+0
              t51 = -3.3333333333333337d+0*t18*t22*t32*taua-6.6666666666
     1           66667d+0*t18*t26*t28*t29*taua-3.3333333333333337d+0*gam
     2           maaa*t25*t26*t27*taua-5.333333333333333d+0*t23*t24*t26*
     3           t50-1.030176d-2*t29*t30*t48*t49-1.030176d-2*gammaaa*t18
     4           *t27*t28*t48*t49-1.030176d-2*t23*t24*t25*t48*t49-5.1508
     5           8d-3*t26*t28*t32*t48-5.15088d-3*gammaaa*t18*t26*t31*t48
     6           -2.6666666666666666d+0*gammaaa*t22*t31*t47-2.6666666666
     7           666666d+0*gammaaa*t26*t27*t28*t47
              t52 = 1/t11
              t53 = 1/t2**3
              t54 = 1/rhoa**1.3333333333333333d+0
              t55 = 1/rhoa**1.1666666666666667d+0
              t56 = -9.970917392951799d-1*t55-7.418564737168958d-1*t54-4
     1           .002143174996817d-1*t53-1.264669550498372d-1*t19
              t57 = 1/t10**2
              t58 = 1/t7
              t59 = -1.8533958105157808d+0*t55-1.2815820791490704d+0*t54
     1           -8.223668877838045d-1*t53-1.6039141941921276d-1*t19
              t60 = 1/t6**2
              t61 = 1.0d+0*t58*t59*t60*t9+1.3210398931339265d-3*t54*t8+1
     1           .1102230246251565d-16*t13*t52*t56*t57+3.050641144351426
     2           4d-19*t12*t54
              t62 = 1.0d+0*rhoa*t17*t33*t61+1.0d+0*rhoa*t14*t17*t51+1.0d
     1           +0*t14*t17*t33
              t63 = 6.299605249474366d-1
              t64 = 1.414213562373095d+0
              t65 = 1/t64
              t66 = 7.937005259840998d-1
              t67 = 8.908987181403393d-1
              t68 = 5.982550435771079d+0*t5*t67+2.2255694211506874d+0*t4
     1           *t66+8.004286349993635d-1*t3*t65+1.8970043257475583d-1*
     2           t1*t63
              t69 = 1.6081979498692536d+1/t68+1.0d+0
              t70 = log(t69)
              t71 = 1.3256889990520176d-1*t4*t66+1.0d+0
              t72 = t34-1.243628d-1*rhoa*t70*t71
              t73 = 1/t36**3
              t74 = -3.3333333333333337d+0*t18*t37*t45*taua-6.6666666666
     1           66667d+0*t18*t39*t41*t42*taua-6.666666666666667d+0*gamm
     2           aaa*t25*t39*t40*taua-6.09932d-3*t42*t43*t48*t73-1.21986
     3           4d-2*gammaaa*t18*t40*t41*t48*t73-2.439728d-2*t24*t25*t3
     4           8*t48*t73-1.0666666666666666d+1*t24*t38*t39*t50-3.04966
     5           d-3*t39*t41*t45*t48-6.09932d-3*gammaaa*t18*t39*t44*t48-
     6           2.6666666666666666d+0*gammaaa*t37*t44*t47-2.66666666666
     7           66666d+0*gammaaa*t39*t40*t41*t47
              t75 = 1/t69
              t76 = 3.968502629920499d-1
              t77 = -7.418564737168958d-1*t54*t76-4.002143174996817d-1*t
     1           53/t64**3-4.4415387620319857d-1*t55-3.9834594695849657d
     2           -2*t19
              t78 = 1/t68**2
              t79 = 3.1090699999999993d-2*t8*t9+2*rhoa*(1.0d+0*t71*t75*t
     1           77*t78+2.747773264188437d-3*t54*t70*t76)-6.21814d-2*t70
     2           *t71-rhoa*t61+6.903522198342671d-18*t12*t13
              t80 = 1.0d+0*t46*t79+1.0d+0*t72*t74
              t81 = 1/rhoa**8
              t82 = -1.030176d-2*t23*t24*t49*t81-1.030176d-2*t18*t29*t30
     1           *t49-1.030176d-2*gammaaa*t25*t27*t28*t49-5.15088d-3*t18
     2           *t26*t28*t32-5.15088d-3*gammaaa*t25*t26*t31+t18*t22*t31
     3           +t18*t26*t27*t28+2*gammaaa*t23*t25*t26
              t83 = -2.439728d-2*t24*t38*t73*t81-6.09932d-3*t18*t42*t43*
     1           t73-1.219864d-2*gammaaa*t25*t40*t41*t73-3.04966d-3*t18*
     2           t39*t41*t45-6.09932d-3*gammaaa*t25*t39*t44+t18*t37*t44+
     3           t18*t39*t40*t41+4*gammaaa*t25*t38*t39
              t84 = 1/rhoa**7
              t85 = 1/rhoa**4.333333333333333d+0
              t86 = -2.060352d-2*gammaaa*t27*t28*t49*t85-1.030176d-2*gam
     1           maaa*t26*t31*t85+2.0d+0*gammaaa*t26*t27*t85-2.060352d-2
     2           *t23*t24*t49*t84-2.060352d-2*t19*t29*t30*t49-1.030176d-
     3           2*t19*t26*t28*t32+2.0d+0*t19*t22*t32+4.0d+0*t19*t26*t28
     4           *t29
              t87 = taua**2
              t88 = 1/t87
              t89 = -2.439728d-2*gammaaa*t40*t41*t73*t85-1.219864d-2*gam
     1           maaa*t39*t44*t85+4.0d+0*gammaaa*t39*t40*t85-4.879456d-2
     2           *t24*t38*t73*t84-1.219864d-2*t19*t42*t43*t73-6.09932d-3
     3           *t19*t39*t41*t45+2.0d+0*t19*t37*t45+4.0d+0*t19*t39*t41*
     4           t42
              t90 = t48**2
              t91 = 1/rhoa**2
              t92 = 1/t21**4
              t93 = 1/rhoa**4.666666666666667d+0
              t94 = 8.88888888888889d+0*t47*taua+9.777777777777779d+0*ga
     1           mmaaa*t93
              t95 = 1/rhoa**7.333333333333333d+0
              t96 = t56**2
              t97 = 1/t2**5
              t98 = 1/rhoa**2.3333333333333334d+0
              t99 = 1/rhoa**2.1666666666666665d+0
              t100 = t59**2
              t101 = 1.0d+0*t58*t60*t9*(2.1622951122684114d+0*t99+1.7087
     1           761055320938d+0*t98+1.2335503316757068d+0*t97+2.6731903
     2           23653546d-1*t18)+1.1102230246251565d-16*t13*t52*t57*(1.
     3           1632736958443765d+0*t99+9.89141964955861d-1*t98+6.00321
     4           4762495226d-1*t97+2.1077825841639536d-1*t18)-1.76138652
     5           41785684d-3*t8*t98-4.0675215258019015d-19*t12*t98-2.220
     6           446049250313d-16*t13*t52*t96/t10**3+1.7854583920998188d
     7           -15*t13*t96/(t10**4*t11**2)+3.216395899738507d+1*t100*t
     8           9/(t6**4*t7**2)-2.0d+0*t100*t58*t9/t6**3-8.497974591333
     9           913d-2*t54*t58*t59*t60-9.812069668265515d-18*t52*t54*t5
     :           6*t57
              t102 = 1.86008522312d-5*t46*t72*t73*t90
              t103 = 1/t36**4
              t104 = 1.1160511338720001d-4*gammaaa*t103*t18*t40*t41*t90
              t105 = 2.2321022677440003d-4*t103*t24*t25*t38*t90
              t106 = 5.580255669360001d-5*t103*t42*t43*t90
              t107 = 1.3011882666666666d-1*t24*t38*t48*t50*t73
              t108 = 8.132426666666668d-2*gammaaa*t25*t40*t48*t73*taua
              t109 = 3.2529706666666663d-2*gammaaa*t40*t41*t47*t48*t73
              t110 = 8.132426666666668d-2*t18*t41*t42*t48*t73*taua
              t111 = 1.86008522312d-5*t41*t45*t73*t90
              t112 = 3.72017044624d-5*gammaaa*t18*t44*t73*t90
              t113 = 1.6264853333333332d-2*gammaaa*t39*t44*t47*t48
              t114 = 2.033106666666667d-2*t18*t39*t45*t48*taua
              t115 = 2.2222222222222224d+1*t25*t39*t42*t87
              t116 = 2.0d+0*t74*t79
              t117 = 2.0d+0*t71*t75*t77*t78
              t118 = 5.495546528376875d-3*t54*t70*t76
              t119 = t77**2
              t120 = 1.6081979498692536d+1*t119*t71/(t68**4*t69**2)
              t121 = -2.0d+0*t119*t71*t75/t68**3
              t122 = 1.9842513149602492d-1
              t123 = 1.0d+0*t71*t75*t78*(2.5908976111853255d-1*t99+9.891
     1           41964955861d-1*t122*t98+6.003214762495226d-1*t97/t64**5
     2           +3.319549557987472d-2*t18)
              t124 = -3.663697685584583d-3*t122*t70*t98
              t125 = log(2.9608813203268075d+1/(8.157414703487641d+0*t5*
     1           t67+2.247591863577616d+0*t4*t66+4.3009724712766434d-1*t
     2           3*t65+1.9115125951273373d-1*t1*t63)+1.0d+0)
              t126 = 6.901399211255825d-2*t4*t66+1.0d+0
              t127 = -8.837926660346784d-2*t54*t75*t76*t77*t78
              t128 = -3.04966d-3*t48*t72*t74
              t129 = -3.04966d-3*t46*t48*t79
              t130 = -3.04966d-3*t48*t80
              t131 = 1.25d-1*gammaaa*t14*t82+1.25d-1*t14*t33
              t132 = 1/rhoa**9
              t133 = -3.04966d-3*t39*t48*t72*t83
              t134 = 1.86008522312d-5*t18*t46*t48*t72*t73
              t135 = 2.2321022677440003d-4*t103*t24*t38*t48*t81
              t136 = 1.1160511338720001d-4*gammaaa*t103*t25*t40*t41*t48
              t137 = 5.580255669360001d-5*t103*t18*t42*t43*t48
              t138 = 4.066213333333334d-2*gammaaa*t40*t73*t81*taua
              t139 = 3.72017044624d-5*gammaaa*t25*t44*t48*t73
              t140 = -2.439728d-2*gammaaa*t25*t38*t48*t73
              t141 = 4.066213333333334d-2*t25*t41*t42*t73*taua
              t142 = 1.86008522312d-5*t18*t41*t45*t48*t73
              t143 = -6.09932d-3*t18*t40*t41*t48*t73
              t144 = 1.0165533333333335d-2*t25*t39*t45*taua
              t145 = -3.3333333333333337d+0*t25*t39*t40*taua
              t146 = -3.04966d-3*t18*t39*t44*t48
              t147 = 1.0d+0*t79*t83
              t148 = -3.04966d-3*t18*t39*t80
              t149 = 1/rhoa**1.0666666666666666d+1
              t150 = 1.0d+0*t37*t72*(3.72017044624d-5*gammaaa*t44*t73*t8
     1           1-4.879456d-2*gammaaa*t38*t73*t81+1.1160511338720001d-4
     2           *gammaaa*t103*t40*t41*t81+1.86008522312d-5*t25*t41*t45*
     3           t73-1.219864d-2*t25*t40*t41*t73-6.09932d-3*t25*t39*t44+
     4           5.580255669360001d-5*t103*t25*t42*t43+2*t25*t38*t39+2.2
     5           321022677440003d-4*t103*t149*t24*t38)
              t151 = -6.09932d-3*t18*t39*t72*t83
              t152 = 1.86008522312d-5*t25*t46*t72*t73
              t153 = -3.04966d-3*t39*t48*t72*t89
              t154 = 3.72017044624d-5*t19*t46*t48*t72*t73
              t155 = 4.4642045354880006d-4*t103*t24*t38*t48*t84
              t156 = 2.2321022677440003d-4*gammaaa*t103*t40*t41*t48*t85
              t157 = 1.1160511338720001d-4*t103*t19*t42*t43*t48
              t158 = 8.132426666666668d-2*gammaaa*t40*t73*t84*taua
              t159 = 7.44034089248d-5*gammaaa*t44*t48*t73*t85
              t160 = -2.439728d-2*gammaaa*t40*t48*t73*t85
              t161 = 8.132426666666668d-2*t41*t42*t73*t85*taua
              t162 = 3.72017044624d-5*t19*t41*t45*t48*t73
              t163 = -2.439728d-2*t19*t41*t42*t48*t73
              t164 = 2.033106666666667d-2*t39*t45*t85*taua
              t165 = -1.3333333333333333d+1*t39*t42*t85*taua
              t166 = -6.09932d-3*t19*t39*t45*t48
              t167 = 1.0d+0*t79*t89
              t168 = -6.09932d-3*t19*t39*t80
              t169 = 1/rhoa**9.666666666666666d+0
              t170 = 1/rhoa**3.3333333333333337d+0
              t171 = 1.0d+0*t37*t72*(3.72017044624d-5*t41*t45*t73*t85-2.
     1           439728d-2*t41*t42*t73*t85-1.219864d-2*t40*t41*t73*t85-6
     2           .09932d-3*t39*t45*t85-6.09932d-3*t39*t44*t85+1.11605113
     3           38720001d-4*t103*t42*t43*t85+2.0d+0*t39*t40*t85+7.44034
     4           089248d-5*gammaaa*t44*t73*t84-2.439728d-2*gammaaa*t40*t
     5           73*t84-4.879456d-2*gammaaa*t38*t73*t84+2.23210226774400
     6           03d-4*gammaaa*t103*t40*t41*t84+4.4642045354880006d-4*t1
     7           03*t169*t24*t38)
              t172 = -6.09932d-3*t19*t39*t72*t83
              t173 = -3.04966d-3*t18*t39*t72*t89
              t174 = 3.72017044624d-5*t46*t72*t73*t85
              t175 = 1/rhoa**8.666666666666666d+0
              t176 = 1/rhoa**6
              t177 = 1.0d+0*t37*t72*(7.44034089248d-5*t170*t41*t45*t73+1
     1           .488068178496d-4*gammaaa*t176*t44*t73-9.758912d-2*t170*
     2           t41*t42*t73-9.758912d-2*gammaaa*t176*t40*t73-2.439728d-
     3           2*t170*t39*t45+2.2321022677440003d-4*t103*t170*t42*t43+
     4           8.0d+0*t170*t39*t42+4.4642045354880006d-4*gammaaa*t103*
     5           t176*t40*t41+8.928409070976001d-4*t103*t175*t24*t38)
              t178 = -1.219864d-2*t19*t39*t72*t89
              t179 = 7.44034089248d-5*t170*t46*t72*t73
              fnc(iq) = (1.0d+0*t37*t46*(t34-1.243628d-1*rhoa*(1.0522000
     1           558389212d-1*t4+1.0d+0)*log(1.6081979498692536d+1/(5.32
     2           9846514438383d+0*t5+1.766435620181429d+0*t4+5.659885156
     3           639418d-1*t3+1.19503784087549d-1*t1)+1.0d+0))+2.0d+0*rh
     4           oa*t14*t17*t22*t33)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t37*t80-3.04966d-3*t39*t46*t48*t72+t22*t
     1           62-5.15088d-3*rhoa*t14*t17*t26*t33*t48+1.25d-1*gammaaa*
     2           t14*t15*t16*t22*t33)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (1.0d+0*t37*t72*t83+1.0d+0*rhoa*t14*t17*
     1           t22*t82-3.04966d-3*t18*t39*t46*t72-5.15088d-3*t14*t17*t
     2           19*t26*t33-1.25d-1*t14*t16*t22*t33)*wght+Cmat(iq,D1_GAA
     3           )
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.0d+0*t37*t72*t89+1.25d-1*gammaaa*t14*t
     1           22*t33*t88+1.0d+0*rhoa*t14*t17*t22*t86-6.09932d-3*t19*t
     2           39*t46*t72-1.030176d-2*t1*t14*t17*t26*t33)*wght+Mmat(iq
     3           ,D1_TA)
              Amat2(iq,D2_RA_RA) = (t37*(1.0d+0*t72*(3.5555555555555557d
     1           +1*gammaaa*t39*t40*t50*taua+8.88888888888889d+0*t37*t45
     2           *t47*taua+1.7777777777777778d+1*t39*t41*t42*t47*taua+5.
     3           333333333333333d+1*t24*t38*t39*t95-6.09932d-3*t42*t43*t
     4           73*t94-1.219864d-2*gammaaa*t18*t40*t41*t73*t94-2.439728
     5           d-2*t24*t25*t38*t73*t94-3.04966d-3*t39*t41*t45*t94-6.09
     6           932d-3*gammaaa*t18*t39*t44*t94+9.777777777777779d+0*gam
     7           maaa*t37*t44*t93+9.777777777777779d+0*gammaaa*t39*t40*t
     8           41*t93+t115+t114+t113+t112+t111+t110+t109+t108+t107+t10
     9           6+t105+t104)+1.0d+0*t46*(2*rhoa*(8.443431970194815d-3*t
     :           125*t126*t91+t127+t124+t123+t121+t120)-2.0d+0*t58*t59*t
     ;           60*t9-2.642079786267853d-3*t54*t8-2.220446049250313d-16
     <           *t13*t52*t56*t57-6.101282288702853d-19*t12*t54+t118+t11
     =           7-rhoa*t101)+t116)+t22*(1.0d+0*rhoa*t14*t17*(2.66666666
     >           66666666d+1*gammaaa*t26*t27*t50*taua+1.373568d-1*t18*t2
     ?           8*t29*t48*t49*taua+6.867840000000001d-2*gammaaa*t25*t27
     @           *t48*t49*taua+3.4339200000000003d-2*t18*t26*t32*t48*tau
     1           a+8.88888888888889d+0*t22*t32*t47*taua+1.77777777777777
     2           78d+1*t26*t28*t29*t47*taua+3.377777777777778d+1*t23*t24
     3           *t26*t95-1.030176d-2*t29*t30*t49*t94-1.030176d-2*gammaa
     4           a*t18*t27*t28*t49*t94-1.030176d-2*t23*t24*t25*t49*t94-5
     5           .15088d-3*t26*t28*t32*t94-5.15088d-3*gammaaa*t18*t26*t3
     6           1*t94+9.777777777777779d+0*gammaaa*t22*t31*t93+9.777777
     7           777777779d+0*gammaaa*t26*t27*t28*t93+1.591893886464d-4*
     8           t29*t30*t90*t92+1.591893886464d-4*gammaaa*t18*t27*t28*t
     9           90*t92+1.591893886464d-4*t23*t24*t25*t90*t92+5.30631295
     :           488d-5*t28*t32*t49*t90+5.30631295488d-5*gammaaa*t18*t31
     ;           *t49*t90+2.2222222222222224d+1*t25*t26*t29*t87+1.098854
     <           4d-1*t23*t24*t48*t49*t50+5.494272d-2*gammaaa*t27*t28*t4
     =           7*t48*t49+2.747136d-2*gammaaa*t26*t31*t47*t48)+1.25d-1*
     >           gammaaa*t14*t16*t33*t91+2.0d+0*rhoa*t17*t51*t61+2.0d+0*
     ?           t17*t33*t61+1.25d-1*gammaaa*t15*t16*t33*t61+2.0d+0*t14*
     @           t17*t51+1.25d-1*gammaaa*t14*t15*t16*t51+1.0d+0*rhoa*t10
     1           1*t17*t33)+t39*(-3.04966d-3*t46*t72*t94+t130+t129+t128)
     2           +t26*(-5.15088d-3*rhoa*t14*t17*t33*t94-5.15088d-3*t48*t
     3           62-5.15088d-3*rhoa*t17*t33*t48*t61-5.15088d-3*rhoa*t14*
     4           t17*t48*t51-5.15088d-3*t14*t17*t33*t48)-1.25d-1*gammaaa
     5           *t14*t16*t22*t33*t91+5.30631295488d-5*rhoa*t14*t17*t33*
     6           t49*t90+t15*t16*t22*(1.25d-1*gammaaa*t33*t61+1.25d-1*ga
     7           mmaaa*t14*t51)-1.28772d-3*gammaaa*t14*t15*t16*t26*t33*t
     8           48+t102)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t37*(1.0d+0*t72*(1.7777777777777778d
     1           +1*gammaaa*t39*t40*t50*taua+1.4222222222222222d+1*t24*t
     2           38*t39*t95+t115+t114+t113+t112+t111+t110+t109+t108+t107
     3           +t106+t105+t104)+1.0d+0*t46*(2*rhoa*(-8.443431970194815
     4           d-3*t125*t126*t91+t127+t124+t123+t121+t120)+t118+t117)+
     5           t116)+(t130+t129+t128)*t39+t102)*wght+Amat2(iq,D2_RA_RB
     6           )
              Cmat2(iq,D2_RA_GAA) = (t22*(1.0d+0*rhoa*t14*t17*(3.4339200
     1           000000003d-2*gammaaa*t27*t49*t81*taua+6.867840000000001
     2           d-2*t25*t28*t29*t49*taua+1.7169600000000002d-2*t25*t26*
     3           t32*taua-3.3333333333333337d+0*t25*t26*t27*taua+1.59189
     4           3886464d-4*t23*t24*t48*t81*t92+1.591893886464d-4*t18*t2
     5           9*t30*t48*t92+1.591893886464d-4*gammaaa*t25*t27*t28*t48
     6           *t92+5.494272d-2*gammaaa*t27*t28*t49*t50+2.747136d-2*ga
     7           mmaaa*t26*t31*t50-1.0666666666666666d+1*gammaaa*t23*t26
     8           *t50+5.30631295488d-5*t18*t28*t32*t48*t49+5.30631295488
     9           d-5*gammaaa*t25*t31*t48*t49-1.030176d-2*t18*t27*t28*t48
     :           *t49-2.060352d-2*gammaaa*t23*t25*t48*t49+2.747136d-2*t2
     ;           9*t30*t47*t49+8.241408d-2*t132*t23*t24*t49-5.15088d-3*t
     <           18*t26*t31*t48+1.373568d-2*t26*t28*t32*t47-2.6666666666
     =           666666d+0*t22*t31*t47-2.6666666666666666d+0*t26*t27*t28
     >           *t47)+1.0d+0*rhoa*t17*t61*t82+1.0d+0*t14*t17*t82-1.25d-
     ?           1*t16*t33*t61-1.25d-1*t14*t16*t51-1.25d-1*t14*t15*t16*t
     @           33)-5.15088d-3*rhoa*t14*t17*t26*t48*t82+t37*(1.0d+0*t72
     1           *(4.879456d-2*gammaaa*t40*t41*t50*t73+1.626485333333333
     2           2d-2*t42*t43*t47*t73+1.3011882666666666d-1*t132*t24*t38
     3           *t73+2.439728d-2*gammaaa*t39*t44*t50-16*gammaaa*t38*t39
     4           *t50+8.132426666666667d-3*t39*t41*t45*t47-2.66666666666
     5           66666d+0*t37*t44*t47-2.6666666666666666d+0*t39*t40*t41*
     6           t47+t146+t145+t144+t143+t142+t141+t140+t139+t138+t137+t
     7           136+t135)+t147)+8.132426666666667d-3*t39*t46*t47*t72+t1
     8           8*t26*(1.373568d-2*t14*t17*t33-5.15088d-3*t62)+5.306312
     9           95488d-5*t14*t17*t19*t33*t48*t49+6.4386d-4*t14*t16*t26*
     :           t33*t48-6.4386d-4*gammaaa*t14*t16*t26*t33*t47+t131*t15*
     ;           t16*t22+t148+t134+t133)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t37*(1.0d+0*t72*(1.6264853333333332
     1           d-2*gammaaa*t40*t41*t50*t73+6.505941333333333d-2*t132*t
     2           24*t38*t73+8.132426666666667d-3*gammaaa*t39*t44*t50-5.3
     3           33333333333333d+0*gammaaa*t38*t39*t50+t146+t145+t144+t1
     4           43+t142+t141+t140+t139+t138+t137+t136+t135)+t147)+t148+
     5           t134+t133)*wght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = (1.0d+0*rhoa*t14*t17*t22*(1.5918938
     1           86464d-4*gammaaa*t27*t28*t81*t92+1.591893886464d-4*t25*
     2           t29*t30*t92+1.591893886464d-4*t149*t23*t24*t92+5.306312
     3           95488d-5*gammaaa*t31*t49*t81-4.120704d-2*gammaaa*t23*t4
     4           9*t81+5.30631295488d-5*t25*t28*t32*t49-2.060352d-2*t25*
     5           t27*t28*t49-1.030176d-2*t25*t26*t31+2*t23*t25*t26)+5.30
     6           631295488d-5*t14*t17*t33*t49*t85-1.030176d-2*t14*t17*t1
     7           9*t26*t82-2.5d-1*t14*t16*t22*t82+1.28772d-3*t14*t16*t18
     8           *t26*t33+t152+t151+t150)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = (t152+t151+t150)*wght+Cmat2(iq,D2_G
     1           AA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = (t22*(1.0d+0*rhoa*t14*t17*(1.373568d-
     1           1*t28*t29*t49*t85*taua+3.4339200000000003d-2*t26*t32*t8
     2           5*taua-1.3333333333333333d+1*t26*t29*t85*taua+6.8678400
     3           00000001d-2*gammaaa*t27*t49*t84*taua+3.183787772928d-4*
     4           gammaaa*t27*t28*t48*t85*t92+3.183787772928d-4*t23*t24*t
     5           48*t84*t92+3.183787772928d-4*t19*t29*t30*t48*t92+1.0612
     6           62590976d-4*gammaaa*t31*t48*t49*t85-2.060352d-2*gammaaa
     7           *t27*t48*t49*t85+1.4422464000000002d-1*t23*t24*t49*t81+
     8           1.061262590976d-4*t19*t28*t32*t48*t49-4.120704d-2*t19*t
     9           28*t29*t48*t49+3.4339200000000003d-2*t18*t29*t30*t49+8.
     :           928192d-2*gammaaa*t25*t27*t28*t49-1.030176d-2*t19*t26*t
     ;           32*t48+1.7169600000000002d-2*t18*t26*t28*t32-3.33333333
     <           33333337d+0*t18*t22*t32+4.464096d-2*gammaaa*t25*t26*t31
     =           -6.666666666666667d+0*t18*t26*t28*t29-8.666666666666666
     >           d+0*gammaaa*t25*t26*t27)+1.25d-1*gammaaa*t33*t61*t88+1.
     ?           25d-1*gammaaa*t14*t51*t88+1.25d-1*gammaaa*t14*t15*t33*t
     @           88+1.0d+0*rhoa*t17*t61*t86+1.0d+0*t14*t17*t86)-6.4386d-
     1           4*gammaaa*t14*t26*t33*t48*t88-1.25d-1*gammaaa*t14*t15*t
     2           22*t33*t88-5.15088d-3*rhoa*t14*t17*t26*t48*t86+1.25d-1*
     3           gammaaa*t14*t15*t16*t22*t86+t37*(1.0d+0*t72*(2.11443093
     4           33333333d-1*t24*t38*t73*t81+2.033106666666667d-2*t18*t4
     5           2*t43*t73+7.319184000000001d-2*gammaaa*t25*t40*t41*t73+
     6           1.0165533333333335d-2*t18*t39*t41*t45-3.333333333333333
     7           7d+0*t18*t37*t45+3.6595920000000004d-2*gammaaa*t25*t39*
     8           t44-6.666666666666667d+0*t18*t39*t41*t42-1.2d+1*gammaaa
     9           *t25*t39*t40+t166+t165+t164+t163+t162+t161+t160+t159+t1
     :           58+t157+t156+t155)+t167)+1.0165533333333335d-2*t18*t39*
     ;           t46*t72+t19*t26*(1.7169600000000002d-2*t14*t17*t33-1.03
     <           0176d-2*t62)+1.061262590976d-4*t1*t14*t17*t33*t48*t49-1
     =           .28772d-3*gammaaa*t14*t16*t18*t26*t33+t168+t154+t153)*w
     >           ght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t37*(1.0d+0*t72*(1.3011882666666666d
     1           -1*t24*t38*t73*t81+3.2529706666666663d-2*gammaaa*t25*t4
     2           0*t41*t73+1.6264853333333332d-2*gammaaa*t25*t39*t44-5.3
     3           33333333333333d+0*gammaaa*t25*t39*t40+t166+t165+t164+t1
     4           63+t162+t161+t160+t159+t158+t157+t156+t155)+t167)+t168+
     5           t154+t153)*wght+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*rhoa*t14*t17*t22*(3.18378777
     1           2928d-4*t29*t30*t85*t92+3.183787772928d-4*gammaaa*t27*t
     2           28*t84*t92+3.183787772928d-4*t169*t23*t24*t92+1.0612625
     3           90976d-4*t28*t32*t49*t85-4.120704d-2*t28*t29*t49*t85-2.
     4           060352d-2*t27*t28*t49*t85-1.030176d-2*t26*t32*t85-1.030
     5           176d-2*t26*t31*t85+2.0d+0*t26*t27*t85+1.061262590976d-4
     6           *gammaaa*t31*t49*t84-2.060352d-2*gammaaa*t27*t49*t84-4.
     7           120704d-2*gammaaa*t23*t49*t84)-6.4386d-4*gammaaa*t14*t1
     8           8*t26*t33*t88+t131*t22*t88-5.15088d-3*t14*t17*t19*t26*t
     9           86-1.25d-1*t14*t16*t22*t86-1.030176d-2*t1*t14*t17*t26*t
     :           82+1.061262590976d-4*t14*t17*t170*t33*t49+1.28772d-3*t1
     ;           4*t16*t19*t26*t33+t174+t173+t172+t171)*wght+Mmat2(iq,D2
     <           _GAA_TA)
              Mmat2(iq,D2_GAA_TB) = (t174+t173+t172+t171)*wght+Mmat2(iq,
     1           D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = (-2.5d-1*gammaaa*t14*t22*t33/taua**3+
     1           2.122525181952d-4*t14*t17*t33*t49*t98+1.0d+0*rhoa*t14*t
     2           17*t22*(6.367575545856d-4*t170*t29*t30*t92+6.3675755458
     3           56d-4*gammaaa*t176*t27*t28*t92+6.367575545856d-4*t175*t
     4           23*t24*t92+2.122525181952d-4*t170*t28*t32*t49+2.1225251
     5           81952d-4*gammaaa*t176*t31*t49-1.6482816d-1*t170*t28*t29
     6           *t49-8.241408d-2*gammaaa*t176*t27*t49-4.120704d-2*t170*
     7           t26*t32+8.0d+0*t170*t26*t29)+2.5d-1*gammaaa*t14*t22*t86
     8           *t88-2.57544d-3*gammaaa*t14*t19*t26*t33*t88-2.060352d-2
     9           *t1*t14*t17*t26*t86+t179+t178+t177)*wght+Mmat2(iq,D2_TA
     :           _TA)
              Mmat2(iq,D2_TA_TB) = (t179+t178+t177)*wght+Mmat2(iq,D2_TA_
     1           TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = 1/rhoa**3.3333333333333337d+0
              t10 = param(9)
              t11 = param(8)
              t12 = param(11)
              t13 = 1.6d-99*t5*t8*t9+t4*t5*t7+4.0d-50*t1*t12*t5*t6+t10*t
     1           3*t6+4.0d-50*t1*t11*t3+param(7)
              t14 = 1/rhoa**6.666666666666666d-1
              t15 = rhoa**5.0d-1
              t16 = 1/t15
              t17 = 1/rhoa**3.333333333333333d-1
              t18 = 1/rhoa**1.6666666666666666d-1
              t19 = 1.1120374863094686d+1*t18+3.8447462374472113d+0*t17+
     1           1.644733775567609d+0*t16+2.4058712912881916d-1*t14
              t20 = 3.216395899738507d+1/t19+1.0d+0
              t21 = log(t20)
              t22 = 1.274696188700087d-1*t17+1.0d+0
              t23 = 5.982550435771079d+0*t18+2.2255694211506874d+0*t17+8
     1           .004286349993635d-1*t16+1.8970043257475583d-1*t14
              t24 = 1.6081979498692536d+1/t23+1.0d+0
              t25 = log(t24)
              t26 = 1.3256889990520176d-1*t17+1.0d+0
              t27 = -6.903522198342671d-18*t25*t26-3.1090699999999993d-2
     1           *t21*t22
              t28 = 3.04966d-3*(1.2d-49*t1-1.823119944d+1)+1.0d+0
              t29 = 1/t28
              t30 = param(6)
              t31 = 1/t28**2
              t32 = 4.0d-50*t1-1.823119944d+1
              t33 = t32**2
              t34 = param(4)
              t35 = param(3)
              t36 = param(2)
              t37 = param(5)
              t38 = 6.4d-99*t31*t34*t9+8.0d-50*t1*t31*t32*t37+8.0d-50*t1
     1           *t29*t36+t29*t32*t35+t30*t31*t33+param(1)
              t39 = -2*rhoa*t27
              t40 = 1/t24
              t41 = 1/t15**3
              t42 = 1/rhoa**1.3333333333333333d+0
              t43 = 1/rhoa**1.1666666666666667d+0
              t44 = -9.970917392951799d-1*t43-7.418564737168958d-1*t42-4
     1           .002143174996817d-1*t41-1.264669550498372d-1*t1
              t45 = 1/t23**2
              t46 = 1/t20
              t47 = -1.8533958105157808d+0*t43-1.2815820791490704d+0*t42
     1           -8.223668877838045d-1*t41-1.6039141941921276d-1*t1
              t48 = 1/t19**2
              t49 = 1.0d+0*t22*t46*t47*t48+1.1102230246251565d-16*t26*t4
     1           0*t44*t45+3.0506411443514264d-19*t25*t42+1.321039893133
     2           9265d-3*t21*t42
              t50 = 1/t2**3
              t51 = 1/rhoa**6
              t52 = 1/rhoa**4.333333333333333d+0
              t53 = 1/rhoa**2.6666666666666666d+0
              t54 = -5.333333333333334d-99*t5*t52*t8+1.6482816d-150*t50*
     1           t51*t8+1.030176d-51*t4*t50*t53*t7-6.666666666666666d-50
     2           *t4*t5*t53*t6-6.666666666666666d-50*t12*t5*t53*t6+5.150
     3           88d-52*t10*t5*t53*t6+4.1207039999999995d-101*t12*t50*t5
     4           2*t6-6.666666666666666d-50*t11*t3*t53-3.333333333333333
     5           d-50*t10*t3*t53-1.3333333333333333d-99*t12*t5*t52+2.060
     6           3519999999997d-101*t11*t5*t52
              t55 = 5.0d-1*rhoa*t27*t54+5.0d-1*rhoa*t13*t49+5.0d-1*t13*t
     1           27
              t56 = 6.299605249474366d-1
              t57 = 1.414213562373095d+0
              t58 = 1/t57
              t59 = 7.937005259840998d-1
              t60 = 8.908987181403393d-1
              t61 = 5.982550435771079d+0*t18*t60+2.2255694211506874d+0*t
     1           17*t59+8.004286349993635d-1*t16*t58+1.8970043257475583d
     2           -1*t14*t56
              t62 = 1.6081979498692536d+1/t61+1.0d+0
              t63 = log(t62)
              t64 = 1.3256889990520176d-1*t17*t59+1.0d+0
              t65 = t39-1.243628d-1*rhoa*t63*t64
              t66 = 1/t62
              t67 = 3.968502629920499d-1
              t68 = -7.418564737168958d-1*t42*t67-4.002143174996817d-1*t
     1           41/t57**3-4.4415387620319857d-1*t43-3.9834594695849657d
     2           -2*t1
              t69 = 1/t61**2
              t70 = 2*rhoa*(1.0d+0*t64*t66*t68*t69+2.747773264188437d-3*
     1           t42*t63*t67)-6.21814d-2*t63*t64-rhoa*t49+6.903522198342
     2           671d-18*t25*t26+3.1090699999999993d-2*t21*t22
              t71 = 1/t28**3
              t72 = 6.09932d-52*t30*t33*t53*t71+4.8794560000000003d-101*
     1           t32*t37*t52*t71+3.9035648d-150*t34*t51*t71-6.6666666666
     2           66666d-50*t31*t32*t37*t53-6.666666666666666d-50*t29*t36
     3           *t53+3.04966d-52*t31*t32*t35*t53-3.333333333333333d-50*
     4           t29*t35*t53-6.666666666666666d-50*t30*t31*t32*t53-2.666
     5           6666666666666d-99*t31*t37*t52+2.4397280000000002d-101*t
     6           31*t36*t52-1.0666666666666666d-98*t31*t34*t52
              t73 = 1.0d+0*t65*t72+1.0d+0*t38*t70
              t74 = t44**2
              t75 = 1/t15**5
              t76 = 1/rhoa**2.3333333333333334d+0
              t77 = 1/rhoa**2.1666666666666665d+0
              t78 = t47**2
              t79 = -2.0d+0*t22*t46*t78/t19**3+3.216395899738507d+1*t22*
     1           t78/(t19**4*t20**2)+1.0d+0*t22*t46*t48*(2.1622951122684
     2           114d+0*t77+1.7087761055320938d+0*t76+1.2335503316757068
     3           d+0*t75+2.673190323653546d-1*t53)+1.1102230246251565d-1
     4           6*t26*t40*t45*(1.1632736958443765d+0*t77+9.891419649558
     5           61d-1*t76+6.003214762495226d-1*t75+2.1077825841639536d-
     6           1*t53)-4.0675215258019015d-19*t25*t76-1.761386524178568
     7           4d-3*t21*t76-2.220446049250313d-16*t26*t40*t74/t23**3+1
     8           .7854583920998188d-15*t26*t74/(t23**4*t24**2)-8.4979745
     9           91333913d-2*t42*t46*t47*t48-9.812069668265515d-18*t40*t
     :           42*t44*t45
              t80 = 1/t2**4
              t81 = 1/rhoa**8.666666666666666d+0
              t82 = 1/rhoa**7
              t83 = 1/rhoa**5.333333333333333d+0
              t84 = 1/rhoa**3.6666666666666664d+0
              t85 = 1.86008522312d-103*t38*t65*t71*t83
              t86 = 2.0d+0*t70*t72
              t87 = 2.0d+0*t64*t66*t68*t69
              t88 = 5.495546528376875d-3*t42*t63*t67
              t89 = t68**2
              t90 = 1.6081979498692536d+1*t64*t89/(t61**4*t62**2)
              t91 = -2.0d+0*t64*t66*t89/t61**3
              t92 = 1.9842513149602492d-1
              t93 = 1.0d+0*t64*t66*t69*(9.89141964955861d-1*t76*t92+2.59
     1           08976111853255d-1*t77+6.003214762495226d-1*t75/t57**5+3
     2           .319549557987472d-2*t53)
              t94 = -3.663697685584583d-3*t63*t76*t92
              t95 = log(2.9608813203268075d+1/(8.157414703487641d+0*t18*
     1           t60+2.247591863577616d+0*t17*t59+4.3009724712766434d-1*
     2           t16*t58+1.9115125951273373d-1*t14*t56)+1.0d+0)
              t96 = 6.901399211255825d-2*t17*t59+1.0d+0
              t97 = 1/rhoa**2
              t98 = -8.837926660346784d-2*t42*t66*t67*t68*t69
              t99 = 1/t28**4
              t100 = 3.5713636283903993d-201*t34*t81*t99
              t101 = 1.488068178496d-152*t36*t71*t82
              t102 = -3.252970666666667d-150*t37*t71*t82
              t103 = 4.4642045354879994d-152*t32*t37*t82*t99
              t104 = -2.0331066666666667d-101*t31*t35*t83
              t105 = 2.222222222222222d-99*t30*t31*t83
              t106 = 5.580255669359999d-103*t30*t33*t83*t99
              t107 = 1.86008522312d-103*t32*t35*t71*t83
              t108 = -8.132426666666667d-101*t30*t32*t71*t83
              t109 = 3.04966d-52*t38*t70
              t110 = 3.04966d-52*t65*t72
              fnc(iq) = (1.0d+0*t29*t38*(t39-1.243628d-1*rhoa*(1.0522000
     1           558389212d-1*t17+1.0d+0)*log(1.6081979498692536d+1/(5.3
     2           29846514438383d+0*t18+1.766435620181429d+0*t17+5.659885
     3           156639418d-1*t16+1.19503784087549d-1*t14)+1.0d+0))+1.0d
     4           +0*rhoa*t13*t27*t3)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t29*t73+3.04966d-52*t31*t38*t53*t65+t3*t
     1           55+2.57544d-52*t1*t13*t27*t5)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t29*(1.0d+0*t38*(2*rhoa*(t98+8.44343
     1           1970194815d-3*t95*t96*t97+t94+t93+t91+t90)+t88+t87-rhoa
     2           *t79-2.0d+0*t22*t46*t47*t48-2.220446049250313d-16*t26*t
     3           40*t44*t45-6.101282288702853d-19*t25*t42-2.642079786267
     4           853d-3*t21*t42)+t86+1.0d+0*t65*(-1.6264853333333332d-51
     5           *t30*t33*t71*t84+1.7777777777777776d-49*t31*t32*t37*t84
     6           +1.7777777777777776d-49*t29*t36*t84-8.132426666666666d-
     7           52*t31*t32*t35*t84+8.888888888888888d-50*t29*t35*t84+1.
     8           7777777777777776d-49*t30*t31*t32*t84-2.1144309333333333
     9           d-100*t32*t37*t71*t83+1.1555555555555555d-98*t31*t37*t8
     :           3-1.0572154666666667d-100*t31*t36*t83+3.733333333333333
     ;           d-98*t31*t34*t83-2.3421388800000004d-149*t34*t71*t82+t1
     <           08+t107+t106+t105+t104+t103+t102+t101+t100))+t85+t3*(5.
     =           0d-1*rhoa*t27*(-2.747136d-51*t4*t50*t7*t84+1.7777777777
     >           777776d-49*t4*t5*t6*t84+1.7777777777777776d-49*t12*t5*t
     ?           6*t84-1.373568d-51*t10*t5*t6*t84+1.7777777777777776d-49
     @           *t11*t3*t84+8.888888888888888d-50*t10*t3*t84+1.59189388
     1           64639998d-102*t4*t7*t80*t83+2.3111111111111113d-98*t5*t
     2           8*t83-1.373568d-100*t4*t50*t6*t83-2.4724223999999997d-1
     3           00*t12*t50*t6*t83+5.306312954879999d-103*t10*t50*t6*t83
     4           +2.222222222222222d-99*t4*t5*t83+8.0d-99*t12*t5*t83-1.2
     5           362111999999999d-100*t11*t5*t83-3.43392d-101*t10*t5*t83
     6           +6.367575545855999d-152*t12*t6*t80*t82-1.53839616d-149*
     7           t50*t8*t82-2.7471359999999995d-150*t12*t50*t82+2.122525
     8           1819519997d-152*t11*t50*t82+2.5470302183424d-201*t8*t80
     9           *t81)+5.0d-1*rhoa*t13*t79+1.0d+0*rhoa*t49*t54+1.0d+0*t2
     :           7*t54+1.0d+0*t13*t49)-8.132426666666666d-52*t31*t38*t65
     ;           *t84+t31*t53*(3.04966d-52*t73+t110+t109)+t5*t53*(5.1508
     <           8d-52*t55-4.2923999999999995d-52*t13*t27)+t1*t5*(2.5754
     =           4d-52*t27*t54+2.57544d-52*t13*t49)+2.6531564774399996d-
     >           103*t13*t27*t50*t52)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t29*(1.0d+0*t38*(2*rhoa*(t98-8.44343
     1           1970194815d-3*t95*t96*t97+t94+t93+t91+t90)+t88+t87)+t86
     2           +1.0d+0*t65*(-8.132426666666667d-101*t32*t37*t71*t83+4.
     3           444444444444444d-99*t31*t37*t83-4.0662133333333333d-101
     4           *t31*t36*t83+8.888888888888888d-99*t31*t34*t83-1.301188
     5           2666666666d-149*t34*t71*t82+t108+t107+t106+t105+t104+t1
     6           03+t102+t101+t100))+t85+3.04966d-52*t31*t53*t73+(t110+t
     7           109)*t31*t53)*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = gammaaa*t18
              t20 = 1/rhoa**1.6666666666666669d+0
              t21 = 2.0d+0*t20*taua
              t22 = 5.15088d-3*(t21+t19-9.11559972d+0)+1.0d+0
              t23 = 1/t22
              t24 = param(7)
              t25 = param(10)
              t26 = gammaaa**2
              t27 = 1/rhoa**5.333333333333333d+0
              t28 = 1/t22**2
              t29 = param(11)
              t30 = t21-9.11559972d+0
              t31 = param(12)
              t32 = t30**2
              t33 = param(8)
              t34 = param(9)
              t35 = t23*t30*t34+gammaaa*t18*t23*t33+t28*t31*t32+gammaaa*
     1           t18*t28*t29*t30+t25*t26*t27*t28+t24
              t36 = 1/rhob**6.666666666666666d-1
              t37 = rhob**5.0d-1
              t38 = 1/t37
              t39 = 1/rhob**3.333333333333333d-1
              t40 = 1/rhob**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = 1/rhob
              t51 = 1/taub
              t52 = 1.0d+0-1.25d-1*gammabb*t50*t51
              t53 = 1/rhob**2.6666666666666666d+0
              t54 = gammabb*t53
              t55 = 1/rhob**1.6666666666666669d+0
              t56 = 2.0d+0*t55*taub
              t57 = 5.15088d-3*(t56+t54-9.11559972d+0)+1.0d+0
              t58 = 1/t57
              t59 = gammabb**2
              t60 = 1/rhob**5.333333333333333d+0
              t61 = 1/t57**2
              t62 = t56-9.11559972d+0
              t63 = t62**2
              t64 = t31*t61*t63+gammabb*t29*t53*t61*t62+t34*t58*t62+t25*
     1           t59*t60*t61+gammabb*t33*t53*t58+t24
              t65 = rhob+rhoa
              t66 = 1/t65**3.333333333333333d-1
              t67 = 1.3256889990520176d-1*t66+1.0d+0
              t68 = rhoa-rhob
              t69 = t68**4
              t70 = 1/t65**4
              t71 = 1/t65
              t72 = 1.0d+0-t68*t71
              t73 = t68*t71+1.0d+0
              t74 = t73**1.3333333333333333d+0+t72**1.3333333333333333d+
     1           0-2.0d+0
              t75 = -1.923661050931536d+0*t69*t70*t74
              t76 = t75+1.0d+0
              t77 = 1/t65**6.666666666666666d-1
              t78 = t65**5.0d-1
              t79 = 1/t78
              t80 = 1/t65**1.6666666666666666d-1
              t81 = 5.982550435771079d+0*t80+8.004286349993635d-1*t79+1.
     1           8970043257475583d-1*t77+2.2255694211506874d+0*t66
              t82 = 1.6081979498692536d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = -6.21814d-2*t67*t76*t83
              t85 = 6.901399211255825d-2*t66+1.0d+0
              t86 = t75+1.923661050931536d+0*t74
              t87 = 8.157414703487641d+0*t80+4.3009724712766434d-1*t79+1
     1           .9115125951273373d-1*t77+2.247591863577616d+0*t66
              t88 = 2.9608813203268075d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = 1.9751631321680768d-2*t85*t86*t89
              t91 = 1.274696188700087d-1*t66+1.0d+0
              t92 = 1.1120374863094686d+1*t80+1.644733775567609d+0*t79+2
     1           .4058712912881916d-1*t77+3.8447462374472113d+0*t66
              t93 = 3.216395899738507d+1/t92+1.0d+0
              t94 = log(t93)
              t95 = -5.980796863619711d-2*t69*t70*t74*t91*t94
              t96 = t65*(t95+t90+t84)-rhob*t49-rhoa*t14
              t97 = 3.04966d-3*(t56+t54+t21+t19-1.823119944d+1)+1.0d+0
              t98 = 1/t97
              t99 = param(4)
              t100 = t54+t19
              t101 = t100**2
              t102 = 1/t97**2
              t103 = param(5)
              t104 = t56+t21-1.823119944d+1
              t105 = param(6)
              t106 = t104**2
              t107 = param(2)
              t108 = param(3)
              t109 = t101*t102*t99+t104*t108*t98+t100*t107*t98+t102*t105
     1           *t106+t100*t102*t103*t104+param(1)
              t110 = 1/rhoa**3.6666666666666664d+0
              t111 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d
     1           +0*gammaaa*t110
              t112 = 1/t22**3
              t113 = 1/rhoa**6.333333333333333d+0
              t114 = -3.3333333333333337d+0*t18*t23*t34*taua-6.666666666
     1           666667d+0*t18*t28*t30*t31*taua-3.3333333333333337d+0*ga
     2           mmaaa*t27*t28*t29*taua-5.15088d-3*t111*t28*t30*t34-5.15
     3           088d-3*gammaaa*t111*t18*t28*t33-2.6666666666666666d+0*g
     4           ammaaa*t110*t23*t33-1.030176d-2*t111*t112*t31*t32-2.666
     5           6666666666666d+0*gammaaa*t110*t28*t29*t30-1.030176d-2*g
     6           ammaaa*t111*t112*t18*t29*t30-5.333333333333333d+0*t113*
     7           t25*t26*t28-1.030176d-2*t111*t112*t25*t26*t27
              t115 = 1/t11
              t116 = 1/t2**3
              t117 = 1/rhoa**1.3333333333333333d+0
              t118 = 1/rhoa**1.1666666666666667d+0
              t119 = -1.264669550498372d-1*t20-9.970917392951799d-1*t118
     1           -7.418564737168958d-1*t117-4.002143174996817d-1*t116
              t120 = 1/t10**2
              t121 = 1/t7
              t122 = -1.6039141941921276d-1*t20-1.8533958105157808d+0*t1
     1           18-1.2815820791490704d+0*t117-8.223668877838045d-1*t116
              t123 = 1/t6**2
              t124 = 1.0d+0*t121*t122*t123*t9+1.3210398931339265d-3*t117
     1           *t8+1.1102230246251565d-16*t115*t119*t120*t13+3.0506411
     2           443514264d-19*t117*t12
              t125 = 1.0d+0*t14*t17*t35+1.0d+0*rhoa*t124*t17*t35+1.0d+0*
     1           rhoa*t114*t14*t17
              t126 = 1/t97**3
              t127 = -3.3333333333333337d+0*t108*t18*t98*taua-6.66666666
     1           6666667d+0*t102*t104*t105*t18*taua-3.3333333333333337d+
     2           0*t100*t102*t103*t18*taua-6.09932d-3*t101*t111*t126*t99
     3           -5.333333333333333d+0*gammaaa*t100*t102*t110*t99-2.6666
     4           666666666666d+0*gammaaa*t107*t110*t98-6.09932d-3*t105*t
     5           106*t111*t126-6.09932d-3*t100*t103*t104*t111*t126-3.049
     6           66d-3*t102*t104*t108*t111-3.04966d-3*t100*t102*t107*t11
     7           1-2.6666666666666666d+0*gammaaa*t102*t103*t104*t110
              t128 = 1/t65**1.6666666666666669d+0
              t129 = 1/t78**3
              t130 = 1/t65**1.3333333333333333d+0
              t131 = 1/t65**1.1666666666666667d+0
              t132 = -9.970917392951799d-1*t131-7.418564737168958d-1*t13
     1           0-4.002143174996817d-1*t129-1.264669550498372d-1*t128
              t133 = 1/t81**2
              t134 = 1/t82
              t135 = 1.0d+0*t132*t133*t134*t67*t76
              t136 = -1.3595691172479402d+0*t131-7.491972878592053d-1*t1
     1           30-2.1504862356383217d-1*t129-1.2743417300848914d-1*t12
     2           8
              t137 = 1/t87**2
              t138 = 1/t88
              t139 = -5.848223622634647d-1*t136*t137*t138*t85*t86
              t140 = -1.8533958105157808d+0*t131-1.2815820791490704d+0*t
     1           130-8.223668877838045d-1*t129-1.6039141941921276d-1*t12
     2           8
              t141 = 1/t92**2
              t142 = 1/t93
              t143 = 1.923661050931536d+0*t140*t141*t142*t69*t70*t74*t91
              t144 = 1/t65**2
              t145 = t144*t68
              t146 = -t71
              t147 = t146+t145
              t148 = t72**3.333333333333333d-1
              t149 = -t144*t68
              t150 = t71+t149
              t151 = t73**3.333333333333333d-1
              t152 = 1.3333333333333333d+0*t150*t151+1.3333333333333333d
     1           +0*t147*t148
              t153 = -1.923661050931536d+0*t152*t69*t70
              t154 = 1/t65**5
              t155 = 7.694644203726144d+0*t154*t69*t74
              t156 = t68**3
              t157 = -7.694644203726144d+0*t156*t70*t74
              t158 = t157+t155+t153
              t159 = -6.21814d-2*t158*t67*t83
              t160 = 2.747773264188437d-3*t130*t76*t83
              t161 = t157+t155+t153+1.923661050931536d+0*t152
              t162 = 1.9751631321680768d-2*t161*t85*t89
              t163 = -4.5437964274821163d-4*t130*t86*t89
              t164 = -5.980796863619711d-2*t152*t69*t70*t91*t94
              t165 = 1/t65**5.333333333333333d+0
              t166 = 2.541232989148493d-3*t165*t69*t74*t94
              t167 = 2.3923187454478842d-1*t154*t69*t74*t91*t94
              t168 = t95+t65*(-2.3923187454478842d-1*t156*t70*t74*t91*t9
     1           4+t167+t166+t164+t163+t162+t160+t159+t143+t139+t135)+t9
     2           0+3.1090699999999993d-2*t8*t9+t84+6.903522198342671d-18
     3           *t12*t13-rhoa*t124
              t169 = 1.0d+0*t127*t96+1.0d+0*t109*t168
              t170 = 1/rhob**3.6666666666666664d+0
              t171 = -3.3333333333333337d+0*t53*taub-2.6666666666666666d
     1           +0*gammabb*t170
              t172 = 1/t57**3
              t173 = 1/rhob**6.333333333333333d+0
              t174 = -6.666666666666667d+0*t31*t53*t61*t62*taub-3.333333
     1           3333333337d+0*gammabb*t29*t60*t61*taub-3.33333333333333
     2           37d+0*t34*t53*t58*taub-1.030176d-2*t171*t172*t31*t63-5.
     3           15088d-3*t171*t34*t61*t62-2.6666666666666666d+0*gammabb
     4           *t170*t29*t61*t62-1.030176d-2*gammabb*t171*t172*t29*t53
     5           *t62-5.333333333333333d+0*t173*t25*t59*t61-5.15088d-3*g
     6           ammabb*t171*t33*t53*t61-1.030176d-2*t171*t172*t25*t59*t
     7           60-2.6666666666666666d+0*gammabb*t170*t33*t58
              t175 = 1/t46
              t176 = 1/t37**3
              t177 = 1/rhob**1.3333333333333333d+0
              t178 = 1/rhob**1.1666666666666667d+0
              t179 = -1.264669550498372d-1*t55-9.970917392951799d-1*t178
     1           -7.418564737168958d-1*t177-4.002143174996817d-1*t176
              t180 = 1/t45**2
              t181 = 1/t42
              t182 = -1.6039141941921276d-1*t55-1.8533958105157808d+0*t1
     1           78-1.2815820791490704d+0*t177-8.223668877838045d-1*t176
              t183 = 1/t41**2
              t184 = 1.1102230246251565d-16*t175*t179*t180*t48+3.0506411
     1           443514264d-19*t177*t47+1.0d+0*t181*t182*t183*t44+1.3210
     2           398931339265d-3*t177*t43
              t185 = 1.0d+0*t49*t52*t64+1.0d+0*rhob*t184*t52*t64+1.0d+0*
     1           rhob*t174*t49*t52
              t186 = -3.3333333333333337d+0*t108*t53*t98*taub-6.66666666
     1           6666667d+0*t102*t104*t105*t53*taub-3.3333333333333337d+
     2           0*t100*t102*t103*t53*taub-6.09932d-3*t101*t126*t171*t99
     3           -5.333333333333333d+0*gammabb*t100*t102*t170*t99-2.6666
     4           666666666666d+0*gammabb*t107*t170*t98-6.09932d-3*t105*t
     5           106*t126*t171-6.09932d-3*t100*t103*t104*t126*t171-3.049
     6           66d-3*t102*t104*t108*t171-3.04966d-3*t100*t102*t107*t17
     7           1-2.6666666666666666d+0*gammabb*t102*t103*t104*t170
              t187 = t71+t145
              t188 = t149+t146
              t189 = 1.3333333333333333d+0*t151*t188+1.3333333333333333d
     1           +0*t148*t187
              t190 = -1.923661050931536d+0*t189*t69*t70
              t191 = 7.694644203726144d+0*t156*t70*t74
              t192 = t191+t190+t155
              t193 = -6.21814d-2*t192*t67*t83
              t194 = t191+t190+1.923661050931536d+0*t189+t155
              t195 = 1.9751631321680768d-2*t194*t85*t89
              t196 = -5.980796863619711d-2*t189*t69*t70*t91*t94
              t197 = t95+t65*(2.3923187454478842d-1*t156*t70*t74*t91*t94
     1           +t196+t195+t193+t167+t166+t163+t160+t143+t139+t135)+t90
     2           +t84+6.903522198342671d-18*t47*t48+3.1090699999999993d-
     3           2*t43*t44-rhob*t184
              t198 = 1.0d+0*t186*t96+1.0d+0*t109*t197
              t199 = 1/rhoa**8
              t200 = -5.15088d-3*t18*t28*t30*t34-5.15088d-3*gammaaa*t27*
     1           t28*t33+t18*t23*t33-1.030176d-2*t112*t18*t31*t32+t18*t2
     2           8*t29*t30-1.030176d-2*gammaaa*t112*t27*t29*t30+2*gammaa
     3           a*t25*t27*t28-1.030176d-2*t112*t199*t25*t26
              t201 = -6.09932d-3*t101*t126*t18*t99+2*t100*t102*t18*t99+t
     1           107*t18*t98-6.09932d-3*t105*t106*t126*t18-6.09932d-3*t1
     2           00*t103*t104*t126*t18-3.04966d-3*t102*t104*t108*t18-3.0
     3           4966d-3*t100*t102*t107*t18+t102*t103*t104*t18
              t202 = 1/rhob**8
              t203 = -1.030176d-2*t172*t31*t53*t63-5.15088d-3*t34*t53*t6
     1           1*t62+t29*t53*t61*t62-1.030176d-2*gammabb*t172*t29*t60*
     2           t62-5.15088d-3*gammabb*t33*t60*t61+2*gammabb*t25*t60*t6
     3           1-1.030176d-2*t172*t202*t25*t59+t33*t53*t58
              t204 = -6.09932d-3*t101*t126*t53*t99+2*t100*t102*t53*t99+t
     1           107*t53*t98-6.09932d-3*t105*t106*t126*t53-6.09932d-3*t1
     2           00*t103*t104*t126*t53-3.04966d-3*t102*t104*t108*t53-3.0
     3           4966d-3*t100*t102*t107*t53+t102*t103*t104*t53
              t205 = 1/rhoa**7
              t206 = 1/rhoa**4.333333333333333d+0
              t207 = -1.030176d-2*t20*t28*t30*t34+2.0d+0*t20*t23*t34-1.0
     1           30176d-2*gammaaa*t206*t28*t33-2.060352d-2*t112*t20*t31*
     2           t32+4.0d+0*t20*t28*t30*t31-2.060352d-2*gammaaa*t112*t20
     3           6*t29*t30+2.0d+0*gammaaa*t206*t28*t29-2.060352d-2*t112*
     4           t205*t25*t26
              t208 = taua**2
              t209 = 1/t208
              t210 = -1.219864d-2*t101*t126*t20*t99+2.0d+0*t108*t20*t98-
     1           1.219864d-2*t105*t106*t126*t20-1.219864d-2*t100*t103*t1
     2           04*t126*t20-6.09932d-3*t102*t104*t108*t20-6.09932d-3*t1
     3           00*t102*t107*t20+4.0d+0*t102*t104*t105*t20+2.0d+0*t100*
     4           t102*t103*t20
              t211 = 1/rhob**7
              t212 = 1/rhob**4.333333333333333d+0
              t213 = -2.060352d-2*t172*t31*t55*t63-1.030176d-2*t34*t55*t
     1           61*t62+4.0d+0*t31*t55*t61*t62-2.060352d-2*gammabb*t172*
     2           t212*t29*t62-1.030176d-2*gammabb*t212*t33*t61+2.0d+0*ga
     3           mmabb*t212*t29*t61-2.060352d-2*t172*t211*t25*t59+2.0d+0
     4           *t34*t55*t58
              t214 = taub**2
              t215 = 1/t214
              t216 = -1.219864d-2*t101*t126*t55*t99+2.0d+0*t108*t55*t98-
     1           1.219864d-2*t105*t106*t126*t55-1.219864d-2*t100*t103*t1
     2           04*t126*t55-6.09932d-3*t102*t104*t108*t55-6.09932d-3*t1
     3           00*t102*t107*t55+4.0d+0*t102*t104*t105*t55+2.0d+0*t100*
     4           t102*t103*t55
              t217 = t111**2
              t218 = 1/rhoa**2
              t219 = 1/t22**4
              t220 = 1/rhoa**4.666666666666667d+0
              t221 = 8.88888888888889d+0*t110*taua+9.777777777777779d+0*
     1           gammaaa*t220
              t222 = 1/rhoa**7.333333333333333d+0
              t223 = t119**2
              t224 = 1/t2**5
              t225 = 1/rhoa**2.3333333333333334d+0
              t226 = 1/rhoa**2.1666666666666665d+0
              t227 = t122**2
              t228 = 3.216395899738507d+1*t227*t9/(t6**4*t7**2)-2.0d+0*t
     1           121*t227*t9/t6**3+1.0d+0*t121*t123*(2.1622951122684114d
     2           +0*t226+1.7087761055320938d+0*t225+1.2335503316757068d+
     3           0*t224+2.673190323653546d-1*t18)*t9-1.7613865241785684d
     4           -3*t225*t8+1.1102230246251565d-16*t115*t120*t13*(1.1632
     5           736958443765d+0*t226+9.89141964955861d-1*t225+6.0032147
     6           62495226d-1*t224+2.1077825841639536d-1*t18)-4.067521525
     7           8019015d-19*t12*t225-2.220446049250313d-16*t115*t13*t22
     8           3/t10**3+1.7854583920998188d-15*t13*t223/(t10**4*t11**2
     9           )-8.497974591333913d-2*t117*t121*t122*t123-9.8120696682
     :           65515d-18*t115*t117*t119*t120
              t229 = 1/t97**4
              t230 = 2.0d+0*t132*t133*t134*t67*t76
              t231 = -1.1696447245269295d+0*t136*t137*t138*t85*t86
              t232 = 3.847322101863072d+0*t140*t141*t142*t69*t70*t74*t91
              t233 = 5.495546528376875d-3*t130*t76*t83
              t234 = -9.087592854964233d-4*t130*t86*t89
              t235 = 5.082465978296986d-3*t165*t69*t74*t94
              t236 = 4.7846374908957684d-1*t154*t69*t74*t91*t94
              t237 = t132**2
              t238 = 1.6081979498692536d+1*t237*t67*t76/(t81**4*t82**2)
              t239 = -2.0d+0*t134*t237*t67*t76/t81**3
              t240 = -8.837926660346784d-2*t130*t132*t133*t134*t76
              t241 = 1/t65**2.6666666666666666d+0
              t242 = 1/t78**5
              t243 = 1/t65**2.3333333333333334d+0
              t244 = 1/t65**2.1666666666666665d+0
              t245 = 1.0d+0*t133*t134*(1.1632736958443765d+0*t244+9.8914
     1           1964955861d-1*t243+6.003214762495226d-1*t242+2.10778258
     2           41639536d-1*t241)*t67*t76
              t246 = t136**2
              t247 = -1.73158960813529d+1*t246*t85*t86/(t87**4*t88**2)
              t248 = 1.1696447245269295d+0*t138*t246*t85*t86/t87**3
              t249 = 2.690728393099896d-2*t130*t136*t137*t138*t86
              t250 = -5.848223622634647d-1*t137*t138*(1.5861639701225969
     1           d+0*t244+9.98929717145607d-1*t243+3.2257293534574827d-1
     2           *t242+2.1239028834748191d-1*t241)*t85*t86
              t251 = t140**2
              t252 = 6.187255516702861d+1*t251*t69*t70*t74*t91/(t92**4*t
     1           93**2)
              t253 = -3.847322101863072d+0*t142*t251*t69*t70*t74*t91/t92
     1           **3
              t254 = -1.6347222733154887d-1*t140*t141*t142*t165*t69*t74
              t255 = 1.923661050931536d+0*t141*t142*(2.1622951122684114d
     1           +0*t244+1.7087761055320938d+0*t243+1.2335503316757068d+
     2           0*t242+2.673190323653546d-1*t241)*t69*t70*t74*t91
              t256 = -1.538928840745229d+1*t140*t141*t142*t154*t69*t74*t
     1           91
              t257 = 1/t72**6.666666666666666d-1
              t258 = 1/t65**3
              t259 = -2*t258*t68
              t260 = 2*t144
              t261 = 1/t73**6.666666666666666d-1
              t262 = 2*t258*t68
              t263 = -2*t144
              t264 = 1.3333333333333333d+0*t151*(t263+t262)+4.4444444444
     1           44444d-1*t150**2*t261+1.3333333333333333d+0*t148*(t260+
     2           t259)+4.444444444444444d-1*t147**2*t257
              t265 = -1.923661050931536d+0*t264*t69*t70
              t266 = 1.5389288407452287d+1*t152*t154*t69
              t267 = -1.5389288407452287d+1*t152*t156*t70
              t268 = 1/t65**6
              t269 = -3.8473221018630716d+1*t268*t69*t74
              t270 = 6.155715362980915d+1*t154*t156*t74
              t271 = t68**2
              t272 = -2.3083932611178434d+1*t271*t70*t74
              t273 = -3.663697685584583d-3*t243*t76*t83
              t274 = 6.058395236642822d-4*t243*t86*t89
              t275 = -2.3718174565385935d-2*t69*t74*t94/t65**6.333333333
     1           333333d+0
              t276 = -1.1961593727239421d+0*t268*t69*t74*t91*t94
              t277 = -7.176956236343652d-1*t271*t70*t74*t91*t94
              t278 = 2.6666666666666666d+0*t151*t258*t68-2.6666666666666
     1           666d+0*t148*t258*t68+4.444444444444444d-1*t150*t188*t26
     2           1+4.444444444444444d-1*t147*t187*t257
              t279 = -1.923661050931536d+0*t278*t69*t70
              t280 = 7.694644203726144d+0*t154*t189*t69
              t281 = -7.694644203726144d+0*t156*t189*t70
              t282 = 7.694644203726144d+0*t152*t154*t69
              t283 = 7.694644203726144d+0*t152*t156*t70
              t284 = 2.3083932611178434d+1*t271*t70*t74
              t285 = t171**2
              t286 = 1/rhob**2
              t287 = 1/t57**4
              t288 = 1/rhob**4.666666666666667d+0
              t289 = 8.88888888888889d+0*t170*taub+9.777777777777779d+0*
     1           gammabb*t288
              t290 = 1/rhob**7.333333333333333d+0
              t291 = t179**2
              t292 = 1/t37**5
              t293 = 1/rhob**2.3333333333333334d+0
              t294 = 1/rhob**2.1666666666666665d+0
              t295 = t182**2
              t296 = 1.0d+0*t181*t183*t44*(2.673190323653546d-1*t53+2.16
     1           22951122684114d+0*t294+1.7087761055320938d+0*t293+1.233
     2           5503316757068d+0*t292)+1.1102230246251565d-16*t175*t180
     3           *t48*(2.1077825841639536d-1*t53+1.1632736958443765d+0*t
     4           294+9.89141964955861d-1*t293+6.003214762495226d-1*t292)
     5           +1.7854583920998188d-15*t291*t48/(t45**4*t46**2)-2.2204
     6           46049250313d-16*t175*t291*t48/t45**3-4.0675215258019015
     7           d-19*t293*t47+3.216395899738507d+1*t295*t44/(t41**4*t42
     8           **2)-2.0d+0*t181*t295*t44/t41**3-1.7613865241785684d-3*
     9           t293*t43-8.497974591333913d-2*t177*t181*t182*t183-9.812
     :           069668265515d-18*t175*t177*t179*t180
              t297 = 1.3333333333333333d+0*t148*(t263+t259)+1.3333333333
     1           333333d+0*t151*(t262+t260)+4.444444444444444d-1*t188**2
     2           *t261+4.444444444444444d-1*t187**2*t257
              t298 = -1.923661050931536d+0*t297*t69*t70
              t299 = 1.5389288407452287d+1*t154*t189*t69
              t300 = 1.5389288407452287d+1*t156*t189*t70
              t301 = -6.155715362980915d+1*t154*t156*t74
              t302 = 1.25d-1*t14*t35+1.25d-1*gammaaa*t14*t200
              t303 = 1.25d-1*t49*t64+1.25d-1*gammabb*t203*t49
              t304 = 1/rhoa**3.3333333333333337d+0
              t305 = 1/rhob**3.3333333333333337d+0
              t306 = 1/rhoa**6
              t307 = 1/rhob**6
              fnc(iq) = (1.0d+0*t109*t96*t98+1.0d+0*rhob*t49*t52*t58*t64
     1           +1.0d+0*rhoa*t14*t17*t23*t35)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t169*t98-3.04966d-3*t102*t109*t111*t96-5
     1           .15088d-3*rhoa*t111*t14*t17*t28*t35+1.25d-1*gammaaa*t14
     2           *t15*t16*t23*t35+t125*t23)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t198*t98-3.04966d-3*t102*t109*t171*t96-5
     1           .15088d-3*rhob*t171*t49*t52*t61*t64+1.25d-1*gammabb*t49
     2           *t50*t51*t58*t64+t185*t58)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (1.0d+0*t201*t96*t98-3.04966d-3*t102*t10
     1           9*t18*t96-5.15088d-3*t14*t17*t20*t28*t35-1.25d-1*t14*t1
     2           6*t23*t35+1.0d+0*rhoa*t14*t17*t200*t23)*wght+Cmat(iq,D1
     3           _GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (1.0d+0*t204*t96*t98-3.04966d-3*t102*t10
     1           9*t53*t96-5.15088d-3*t49*t52*t55*t61*t64-1.25d-1*t49*t5
     2           1*t58*t64+1.0d+0*rhob*t203*t49*t52*t58)*wght+Cmat(iq,D1
     3           _GBB)
              Mmat(iq,D1_TA) = (1.0d+0*t210*t96*t98-6.09932d-3*t102*t109
     1           *t20*t96-1.030176d-2*t1*t14*t17*t28*t35+1.25d-1*gammaaa
     2           *t14*t209*t23*t35+1.0d+0*rhoa*t14*t17*t207*t23)*wght+Mm
     3           at(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*t216*t96*t98-6.09932d-3*t102*t109
     1           *t55*t96-1.030176d-2*t36*t49*t52*t61*t64+1.25d-1*gammab
     2           b*t215*t49*t58*t64+1.0d+0*rhob*t213*t49*t52*t58)*wght+M
     3           mat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t98*(1.0d+0*t96*(8.88888888888889d+0
     1           *t108*t110*t98*taua+8.132426666666668d-2*t104*t105*t111
     2           *t126*t18*taua+4.066213333333334d-2*t100*t103*t111*t126
     3           *t18*taua+2.033106666666667d-2*t102*t108*t111*t18*taua+
     4           1.7777777777777778d+1*gammaaa*t102*t103*t113*taua+1.777
     5           7777777777778d+1*t102*t104*t105*t110*taua+8.88888888888
     6           889d+0*t100*t102*t103*t110*taua+1.4222222222222222d+1*t
     7           102*t222*t26*t99+5.580255669360001d-5*t101*t217*t229*t9
     8           9-6.09932d-3*t101*t126*t221*t99+1.9555555555555557d+1*g
     9           ammaaa*t100*t102*t220*t99+6.505941333333333d-2*gammaaa*
     :           t100*t110*t111*t126*t99+9.777777777777779d+0*gammaaa*t1
     ;           07*t220*t98+2.2222222222222224d+1*t102*t105*t208*t27+5.
     <           580255669360001d-5*t105*t106*t217*t229+5.58025566936000
     =           1d-5*t100*t103*t104*t217*t229-6.09932d-3*t105*t106*t126
     >           *t221-6.09932d-3*t100*t103*t104*t126*t221-3.04966d-3*t1
     ?           02*t104*t108*t221-3.04966d-3*t100*t102*t107*t221+9.7777
     @           77777777779d+0*gammaaa*t102*t103*t104*t220+1.8600852231
     1           2d-5*t104*t108*t126*t217+1.86008522312d-5*t100*t107*t12
     2           6*t217+3.2529706666666663d-2*gammaaa*t103*t104*t110*t11
     3           1*t126+1.6264853333333332d-2*gammaaa*t102*t107*t110*t11
     4           1)+1.0d+0*t109*(t65*(1.9138549963583074d+0*t154*t156*t7
     5           4*t91*t94-5.980796863619711d-2*t264*t69*t70*t91*t94-4.7
     6           846374908957684d-1*t152*t156*t70*t91*t94+4.784637490895
     7           7684d-1*t152*t154*t69*t91*t94+2.0329863913187946d-2*t15
     8           6*t165*t74*t94+5.082465978296986d-3*t152*t165*t69*t94+1
     9           .538928840745229d+1*t140*t141*t142*t156*t70*t74*t91+3.8
     :           47322101863072d+0*t140*t141*t142*t152*t69*t70*t91+1.975
     ;           1631321680768d-2*(t272+t270+t269+t267+t266+t265+1.92366
     <           1050931536d+0*t264)*t85*t89-9.087592854964233d-4*t130*t
     =           161*t89-1.1696447245269295d+0*t136*t137*t138*t161*t85-6
     >           .21814d-2*(t272+t270+t269+t267+t266+t265)*t67*t83+5.495
     ?           546528376875d-3*t130*t158*t83+2.0d+0*t132*t133*t134*t15
     @           8*t67+t277+t276+t275+t274+t273+t256+t255+t254+t253+t252
     1           +t250+t249+t248+t247+t245+t240+t239+t238)-4.78463749089
     2           57684d-1*t156*t70*t74*t91*t94-1.1961593727239421d-1*t15
     3           2*t69*t70*t91*t94-2.0d+0*t121*t122*t123*t9+3.9503262643
     4           361536d-2*t161*t85*t89-1.243628d-1*t158*t67*t83-2.64207
     5           9786267853d-3*t117*t8+t236+t235+t234+t233+t232+t231+t23
     6           0-rhoa*t228-2.220446049250313d-16*t115*t119*t120*t13-6.
     7           101282288702853d-19*t117*t12)+2.0d+0*t127*t168)+t23*(1.
     8           0d+0*rhoa*t14*t17*(3.4339200000000003d-2*t111*t18*t28*t
     9           34*taua+8.88888888888889d+0*t110*t23*t34*taua+1.7777777
     :           777777778d+1*t110*t28*t30*t31*taua+1.373568d-1*t111*t11
     ;           2*t18*t30*t31*taua+2.6666666666666666d+1*gammaaa*t113*t
     <           28*t29*taua+6.867840000000001d-2*gammaaa*t111*t112*t27*
     =           t29*taua-5.15088d-3*t221*t28*t30*t34+5.30631295488d-5*t
     >           112*t217*t30*t34-5.15088d-3*gammaaa*t18*t221*t28*t33+2.
     ?           747136d-2*gammaaa*t110*t111*t28*t33+9.777777777777779d+
     @           0*gammaaa*t220*t23*t33+5.30631295488d-5*gammaaa*t112*t1
     1           8*t217*t33-1.030176d-2*t112*t221*t31*t32+1.591893886464
     2           d-4*t217*t219*t31*t32+2.2222222222222224d+1*t208*t27*t2
     3           8*t31+9.777777777777779d+0*gammaaa*t220*t28*t29*t30-1.0
     4           30176d-2*gammaaa*t112*t18*t221*t29*t30+1.591893886464d-
     5           4*gammaaa*t18*t217*t219*t29*t30+5.494272d-2*gammaaa*t11
     6           0*t111*t112*t29*t30+3.377777777777778d+1*t222*t25*t26*t
     7           28-1.030176d-2*t112*t221*t25*t26*t27+1.591893886464d-4*
     8           t217*t219*t25*t26*t27+1.0988544d-1*t111*t112*t113*t25*t
     9           26)+1.0d+0*rhoa*t17*t228*t35+1.25d-1*gammaaa*t14*t16*t2
     :           18*t35+2.0d+0*t124*t17*t35+1.25d-1*gammaaa*t124*t15*t16
     ;           *t35+2.0d+0*t114*t14*t17+2.0d+0*rhoa*t114*t124*t17+1.25
     <           d-1*gammaaa*t114*t14*t15*t16)+t102*(-3.04966d-3*t109*t2
     =           21*t96-3.04966d-3*t111*t127*t96-3.04966d-3*t111*t169-3.
     >           04966d-3*t109*t111*t168)+1.86008522312d-5*t109*t126*t21
     ?           7*t96+t28*(-5.15088d-3*rhoa*t14*t17*t221*t35-5.15088d-3
     @           *t111*t14*t17*t35-5.15088d-3*rhoa*t111*t124*t17*t35-5.1
     1           5088d-3*rhoa*t111*t114*t14*t17-5.15088d-3*t111*t125)+t1
     2           5*t16*t23*(1.25d-1*gammaaa*t124*t35+1.25d-1*gammaaa*t11
     3           4*t14)-1.28772d-3*gammaaa*t111*t14*t15*t16*t28*t35-1.25
     4           d-1*gammaaa*t14*t16*t218*t23*t35+5.30631295488d-5*rhoa*
     5           t112*t14*t17*t217*t35)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t98*(1.0d+0*t96*(2.2222222222222224d
     1           +1*t102*t105*t18*t53*taua*taub+4.066213333333334d-2*t10
     2           4*t105*t111*t126*t53*taub+2.033106666666667d-2*t100*t10
     3           3*t111*t126*t53*taub+1.0165533333333335d-2*t102*t108*t1
     4           11*t53*taub+8.88888888888889d+0*gammaaa*t102*t103*t110*
     5           t53*taub+4.066213333333334d-2*t104*t105*t126*t171*t18*t
     6           aua+2.033106666666667d-2*t100*t103*t126*t171*t18*taua+1
     7           .0165533333333335d-2*t102*t108*t171*t18*taua+8.88888888
     8           888889d+0*gammabb*t102*t103*t170*t18*taua+5.58025566936
     9           0001d-5*t101*t111*t171*t229*t99+3.2529706666666663d-2*g
     :           ammaaa*t100*t110*t126*t171*t99+3.2529706666666663d-2*ga
     ;           mmabb*t100*t111*t126*t170*t99+1.4222222222222222d+1*gam
     <           maaa*gammabb*t102*t110*t170*t99+5.580255669360001d-5*t1
     =           05*t106*t111*t171*t229+5.580255669360001d-5*t100*t103*t
     >           104*t111*t171*t229+1.86008522312d-5*t104*t108*t111*t126
     ?           *t171+1.86008522312d-5*t100*t107*t111*t126*t171+1.62648
     @           53333333332d-2*gammaaa*t103*t104*t110*t126*t171+8.13242
     1           6666666667d-3*gammaaa*t102*t107*t110*t171+1.62648533333
     2           33332d-2*gammabb*t103*t104*t111*t126*t170+8.13242666666
     3           6667d-3*gammabb*t102*t107*t111*t170)+1.0d+0*t109*(t65*(
     4           7.176956236343652d-1*t271*t70*t74*t91*t94-5.98079686361
     5           9711d-2*t278*t69*t70*t91*t94-2.3923187454478842d-1*t156
     6           *t189*t70*t91*t94+2.3923187454478842d-1*t152*t156*t70*t
     7           91*t94+2.3923187454478842d-1*t154*t189*t69*t91*t94+2.39
     8           23187454478842d-1*t152*t154*t69*t91*t94+2.5412329891484
     9           93d-3*t165*t189*t69*t94+2.541232989148493d-3*t152*t165*
     :           t69*t94+1.923661050931536d+0*t140*t141*t142*t189*t69*t7
     ;           0*t91+1.923661050931536d+0*t140*t141*t142*t152*t69*t70*
     <           t91+1.9751631321680768d-2*(t284+t283+t282+t281+t280+t27
     =           9+1.923661050931536d+0*t278+t269)*t85*t89-4.54379642748
     >           21163d-4*t130*t194*t89-4.5437964274821163d-4*t130*t161*
     ?           t89-5.848223622634647d-1*t136*t137*t138*t194*t85-5.8482
     @           23622634647d-1*t136*t137*t138*t161*t85-6.21814d-2*(t284
     1           +t283+t282+t281+t280+t279+t269)*t67*t83+2.7477732641884
     2           37d-3*t130*t192*t83+2.747773264188437d-3*t130*t158*t83+
     3           1.0d+0*t132*t133*t134*t192*t67+1.0d+0*t132*t133*t134*t1
     4           58*t67+t276+t275+t274+t273+t256+t255+t254+t253+t252+t25
     5           0+t249+t248+t247+t245+t240+t239+t238)+t236+t235+t234+t2
     6           33+t232+t231+t230+t196+t195+t193+t164+t162+t159)+1.0d+0
     7           *t127*t197+1.0d+0*t168*t186)+t102*(-3.04966d-3*t111*t18
     8           6*t96-3.04966d-3*t109*t111*t197-3.04966d-3*t169*t171)+1
     9           .86008522312d-5*t109*t111*t126*t171*t96)*wght+Amat2(iq,
     :           D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t98*(1.0d+0*t96*(8.88888888888889d+0
     1           *t108*t170*t98*taub+8.132426666666668d-2*t104*t105*t126
     2           *t171*t53*taub+4.066213333333334d-2*t100*t103*t126*t171
     3           *t53*taub+2.033106666666667d-2*t102*t108*t171*t53*taub+
     4           1.7777777777777778d+1*gammabb*t102*t103*t173*taub+1.777
     5           7777777777778d+1*t102*t104*t105*t170*taub+8.88888888888
     6           889d+0*t100*t102*t103*t170*taub+1.4222222222222222d+1*t
     7           102*t290*t59*t99-6.09932d-3*t101*t126*t289*t99+1.955555
     8           5555555557d+1*gammabb*t100*t102*t288*t99+5.580255669360
     9           001d-5*t101*t229*t285*t99+6.505941333333333d-2*gammabb*
     :           t100*t126*t170*t171*t99+9.777777777777779d+0*gammabb*t1
     ;           07*t288*t98+2.2222222222222224d+1*t102*t105*t214*t60-6.
     <           09932d-3*t105*t106*t126*t289-6.09932d-3*t100*t103*t104*
     =           t126*t289-3.04966d-3*t102*t104*t108*t289-3.04966d-3*t10
     >           0*t102*t107*t289+9.777777777777779d+0*gammabb*t102*t103
     ?           *t104*t288+5.580255669360001d-5*t105*t106*t229*t285+5.5
     @           80255669360001d-5*t100*t103*t104*t229*t285+1.8600852231
     1           2d-5*t104*t108*t126*t285+1.86008522312d-5*t100*t107*t12
     2           6*t285+3.2529706666666663d-2*gammabb*t103*t104*t126*t17
     3           0*t171+1.6264853333333332d-2*gammabb*t102*t107*t170*t17
     4           1)+1.0d+0*t109*(t65*(-1.9138549963583074d+0*t154*t156*t
     5           74*t91*t94-5.980796863619711d-2*t297*t69*t70*t91*t94+4.
     6           7846374908957684d-1*t156*t189*t70*t91*t94+4.78463749089
     7           57684d-1*t154*t189*t69*t91*t94-2.0329863913187946d-2*t1
     8           56*t165*t74*t94+5.082465978296986d-3*t165*t189*t69*t94-
     9           1.538928840745229d+1*t140*t141*t142*t156*t70*t74*t91+3.
     :           847322101863072d+0*t140*t141*t142*t189*t69*t70*t91+1.97
     ;           51631321680768d-2*(t301+t300+t299+t298+1.92366105093153
     <           6d+0*t297+t272+t269)*t85*t89-9.087592854964233d-4*t130*
     =           t194*t89-1.1696447245269295d+0*t136*t137*t138*t194*t85-
     >           6.21814d-2*(t301+t300+t299+t298+t272+t269)*t67*t83+5.49
     ?           5546528376875d-3*t130*t192*t83+2.0d+0*t132*t133*t134*t1
     @           92*t67+t277+t276+t275+t274+t273+t256+t255+t254+t253+t25
     1           2+t250+t249+t248+t247+t245+t240+t239+t238)+4.7846374908
     2           957684d-1*t156*t70*t74*t91*t94-1.1961593727239421d-1*t1
     3           89*t69*t70*t91*t94+3.9503262643361536d-2*t194*t85*t89-1
     4           .243628d-1*t192*t67*t83-2.220446049250313d-16*t175*t179
     5           *t180*t48-6.101282288702853d-19*t177*t47-2.0d+0*t181*t1
     6           82*t183*t44-2.642079786267853d-3*t177*t43-rhob*t296+t23
     7           6+t235+t234+t233+t232+t231+t230)+2.0d+0*t186*t197)+t58*
     8           (1.0d+0*rhob*t49*t52*(1.7777777777777778d+1*t170*t31*t6
     9           1*t62*taub+1.373568d-1*t171*t172*t31*t53*t62*taub+3.433
     :           9200000000003d-2*t171*t34*t53*t61*taub+2.66666666666666
     ;           66d+1*gammabb*t173*t29*t61*taub+6.867840000000001d-2*ga
     <           mmabb*t171*t172*t29*t60*taub+8.88888888888889d+0*t170*t
     =           34*t58*taub-1.030176d-2*t172*t289*t31*t63+1.59189388646
     >           4d-4*t285*t287*t31*t63-5.15088d-3*t289*t34*t61*t62+9.77
     ?           7777777777779d+0*gammabb*t288*t29*t61*t62-1.030176d-2*g
     @           ammabb*t172*t289*t29*t53*t62+1.591893886464d-4*gammabb*
     1           t285*t287*t29*t53*t62+5.30631295488d-5*t172*t285*t34*t6
     2           2+5.494272d-2*gammabb*t170*t171*t172*t29*t62+2.22222222
     3           22222224d+1*t214*t31*t60*t61+3.377777777777778d+1*t25*t
     4           290*t59*t61-5.15088d-3*gammabb*t289*t33*t53*t61+2.74713
     5           6d-2*gammabb*t170*t171*t33*t61-1.030176d-2*t172*t25*t28
     6           9*t59*t60+1.591893886464d-4*t25*t285*t287*t59*t60+1.098
     7           8544d-1*t171*t172*t173*t25*t59+9.777777777777779d+0*gam
     8           mabb*t288*t33*t58+5.30631295488d-5*gammabb*t172*t285*t3
     9           3*t53)+1.0d+0*rhob*t296*t52*t64+2.0d+0*t184*t52*t64+1.2
     :           5d-1*gammabb*t184*t50*t51*t64+1.25d-1*gammabb*t286*t49*
     ;           t51*t64+2.0d+0*t174*t49*t52+2.0d+0*rhob*t174*t184*t52+1
     <           .25d-1*gammabb*t174*t49*t50*t51)+t102*(-3.04966d-3*t109
     =           *t289*t96-3.04966d-3*t171*t186*t96-3.04966d-3*t171*t198
     >           -3.04966d-3*t109*t171*t197)+1.86008522312d-5*t109*t126*
     ?           t285*t96+t61*(-5.15088d-3*rhob*t289*t49*t52*t64-5.15088
     @           d-3*t171*t49*t52*t64-5.15088d-3*rhob*t171*t184*t52*t64-
     1           5.15088d-3*rhob*t171*t174*t49*t52-5.15088d-3*t171*t185)
     2           +t50*t51*t58*(1.25d-1*gammabb*t184*t64+1.25d-1*gammabb*
     3           t174*t49)-1.28772d-3*gammabb*t171*t49*t50*t51*t61*t64-1
     4           .25d-1*gammabb*t286*t49*t51*t58*t64+5.30631295488d-5*rh
     5           ob*t172*t285*t49*t52*t64)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t23*(1.0d+0*rhoa*t14*t17*(1.7169600
     1           000000002d-2*t27*t28*t34*taua+6.867840000000001d-2*t112
     2           *t27*t30*t31*taua-3.3333333333333337d+0*t27*t28*t29*tau
     3           a+3.4339200000000003d-2*gammaaa*t112*t199*t29*taua+1.37
     4           3568d-2*t110*t28*t30*t34+5.30631295488d-5*t111*t112*t18
     5           *t30*t34-5.15088d-3*t111*t18*t28*t33+2.747136d-2*gammaa
     6           a*t113*t28*t33+5.30631295488d-5*gammaaa*t111*t112*t27*t
     7           33-2.6666666666666666d+0*t110*t23*t33+1.591893886464d-4
     8           *t111*t18*t219*t31*t32+2.747136d-2*t110*t112*t31*t32-2.
     9           6666666666666666d+0*t110*t28*t29*t30+1.591893886464d-4*
     :           gammaaa*t111*t219*t27*t29*t30-1.030176d-2*t111*t112*t18
     ;           *t29*t30+5.494272d-2*gammaaa*t112*t113*t29*t30-1.066666
     <           6666666666d+1*gammaaa*t113*t25*t28-2.060352d-2*gammaaa*
     =           t111*t112*t25*t27+1.591893886464d-4*t111*t199*t219*t25*
     >           t26+8.241408d-2*t112*t25*t26/rhoa**9)-1.25d-1*t14*t15*t
     ?           16*t35-1.25d-1*t124*t16*t35+1.0d+0*t14*t17*t200+1.0d+0*
     @           rhoa*t124*t17*t200-1.25d-1*t114*t14*t16)+t98*(1.0d+0*t9
     1           6*(4.066213333333334d-2*t104*t105*t126*t27*taua+2.03310
     2           6666666667d-2*t100*t103*t126*t27*taua+1.016553333333333
     3           5d-2*t102*t108*t27*taua-3.3333333333333337d+0*t102*t103
     4           *t27*taua+5.580255669360001d-5*t101*t111*t18*t229*t99-1
     5           .219864d-2*t100*t111*t126*t18*t99+3.2529706666666663d-2
     6           *gammaaa*t100*t113*t126*t99+1.6264853333333332d-2*t101*
     7           t110*t126*t99-5.333333333333333d+0*gammaaa*t102*t113*t9
     8           9-5.333333333333333d+0*t100*t102*t110*t99-2.66666666666
     9           66666d+0*t107*t110*t98+5.580255669360001d-5*t105*t106*t
     :           111*t18*t229+5.580255669360001d-5*t100*t103*t104*t111*t
     ;           18*t229+1.86008522312d-5*t104*t108*t111*t126*t18+1.8600
     <           8522312d-5*t100*t107*t111*t126*t18-6.09932d-3*t103*t104
     =           *t111*t126*t18-3.04966d-3*t102*t107*t111*t18+1.62648533
     >           33333332d-2*gammaaa*t103*t104*t113*t126+1.6264853333333
     ?           332d-2*t105*t106*t110*t126+1.6264853333333332d-2*t100*t
     @           103*t104*t110*t126+8.132426666666667d-3*gammaaa*t102*t1
     1           07*t113+8.132426666666667d-3*t102*t104*t108*t110+8.1324
     2           26666666667d-3*t100*t102*t107*t110-2.6666666666666666d+
     3           0*t102*t103*t104*t110)+1.0d+0*t168*t201)-3.04966d-3*t10
     4           2*t111*t201*t96+1.86008522312d-5*t109*t111*t126*t18*t96
     5           +8.132426666666667d-3*t102*t109*t110*t96+t18*t28*(1.373
     6           568d-2*t14*t17*t35-5.15088d-3*t125)+6.4386d-4*t111*t14*
     7           t16*t28*t35-6.4386d-4*gammaaa*t110*t14*t16*t28*t35+5.30
     8           631295488d-5*t111*t112*t14*t17*t20*t35+t15*t16*t23*t302
     9           -5.15088d-3*rhoa*t111*t14*t17*t200*t28-3.04966d-3*t102*
     :           t169*t18)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t98*(1.0d+0*t96*(4.066213333333334d
     1           -2*t104*t105*t126*t18*t53*taua+2.033106666666667d-2*t10
     2           0*t103*t126*t18*t53*taua+1.0165533333333335d-2*t102*t10
     3           8*t18*t53*taua-3.3333333333333337d+0*t102*t103*t18*t53*
     4           taua+5.580255669360001d-5*t101*t111*t229*t53*t99-1.2198
     5           64d-2*t100*t111*t126*t53*t99+3.2529706666666663d-2*gamm
     6           aaa*t100*t110*t126*t53*t99-5.333333333333333d+0*gammaaa
     7           *t102*t110*t53*t99+5.580255669360001d-5*t105*t106*t111*
     8           t229*t53+5.580255669360001d-5*t100*t103*t104*t111*t229*
     9           t53+1.86008522312d-5*t104*t108*t111*t126*t53+1.86008522
     :           312d-5*t100*t107*t111*t126*t53-6.09932d-3*t103*t104*t11
     ;           1*t126*t53+1.6264853333333332d-2*gammaaa*t103*t104*t110
     <           *t126*t53-3.04966d-3*t102*t107*t111*t53+8.1324266666666
     =           67d-3*gammaaa*t102*t107*t110*t53)+1.0d+0*t168*t204)+1.8
     >           6008522312d-5*t109*t111*t126*t53*t96-3.04966d-3*t102*t1
     ?           11*t204*t96-3.04966d-3*t102*t169*t53)*wght+Cmat2(iq,D2_
     @           RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (t98*(1.0d+0*t96*(4.066213333333334d
     1           -2*t104*t105*t126*t18*t53*taub+2.033106666666667d-2*t10
     2           0*t103*t126*t18*t53*taub+1.0165533333333335d-2*t102*t10
     3           8*t18*t53*taub-3.3333333333333337d+0*t102*t103*t18*t53*
     4           taub+5.580255669360001d-5*t101*t171*t18*t229*t99-1.2198
     5           64d-2*t100*t126*t171*t18*t99+3.2529706666666663d-2*gamm
     6           abb*t100*t126*t170*t18*t99-5.333333333333333d+0*gammabb
     7           *t102*t170*t18*t99+5.580255669360001d-5*t105*t106*t171*
     8           t18*t229+5.580255669360001d-5*t100*t103*t104*t171*t18*t
     9           229+1.86008522312d-5*t104*t108*t126*t171*t18+1.86008522
     :           312d-5*t100*t107*t126*t171*t18-6.09932d-3*t103*t104*t12
     ;           6*t171*t18-3.04966d-3*t102*t107*t171*t18+1.626485333333
     <           3332d-2*gammabb*t103*t104*t126*t170*t18+8.1324266666666
     =           67d-3*gammabb*t102*t107*t170*t18)+1.0d+0*t197*t201)-3.0
     >           4966d-3*t102*t171*t201*t96+1.86008522312d-5*t109*t126*t
     ?           171*t18*t96-3.04966d-3*t102*t18*t198)*wght+Cmat2(iq,D2_
     @           RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t58*(1.0d+0*rhob*t49*t52*(6.8678400
     1           00000001d-2*t172*t31*t60*t62*taub+1.7169600000000002d-2
     2           *t34*t60*t61*taub-3.3333333333333337d+0*t29*t60*t61*tau
     3           b+3.4339200000000003d-2*gammabb*t172*t202*t29*taub+1.59
     4           1893886464d-4*t171*t287*t31*t53*t63+2.747136d-2*t170*t1
     5           72*t31*t63+1.373568d-2*t170*t34*t61*t62-2.6666666666666
     6           666d+0*t170*t29*t61*t62+1.591893886464d-4*gammabb*t171*
     7           t287*t29*t60*t62+5.30631295488d-5*t171*t172*t34*t53*t62
     8           -1.030176d-2*t171*t172*t29*t53*t62+5.494272d-2*gammabb*
     9           t172*t173*t29*t62-5.15088d-3*t171*t33*t53*t61+2.747136d
     :           -2*gammabb*t173*t33*t61-1.0666666666666666d+1*gammabb*t
     ;           173*t25*t61+5.30631295488d-5*gammabb*t171*t172*t33*t60-
     <           2.060352d-2*gammabb*t171*t172*t25*t60+1.591893886464d-4
     =           *t171*t202*t25*t287*t59+8.241408d-2*t172*t25*t59/rhob**
     >           9-2.6666666666666666d+0*t170*t33*t58)-1.25d-1*t49*t50*t
     ?           51*t64-1.25d-1*t184*t51*t64+1.0d+0*t203*t49*t52+1.0d+0*
     @           rhob*t184*t203*t52-1.25d-1*t174*t49*t51)+t98*(1.0d+0*t9
     1           6*(4.066213333333334d-2*t104*t105*t126*t60*taub+2.03310
     2           6666666667d-2*t100*t103*t126*t60*taub+1.016553333333333
     3           5d-2*t102*t108*t60*taub-3.3333333333333337d+0*t102*t103
     4           *t60*taub+5.580255669360001d-5*t101*t171*t229*t53*t99-1
     5           .219864d-2*t100*t126*t171*t53*t99+3.2529706666666663d-2
     6           *gammabb*t100*t126*t173*t99-5.333333333333333d+0*gammab
     7           b*t102*t173*t99+1.6264853333333332d-2*t101*t126*t170*t9
     8           9-5.333333333333333d+0*t100*t102*t170*t99-2.66666666666
     9           66666d+0*t107*t170*t98+5.580255669360001d-5*t105*t106*t
     :           171*t229*t53+5.580255669360001d-5*t100*t103*t104*t171*t
     ;           229*t53+1.86008522312d-5*t104*t108*t126*t171*t53+1.8600
     <           8522312d-5*t100*t107*t126*t171*t53-6.09932d-3*t103*t104
     =           *t126*t171*t53-3.04966d-3*t102*t107*t171*t53+1.62648533
     >           33333332d-2*gammabb*t103*t104*t126*t173+8.1324266666666
     ?           67d-3*gammabb*t102*t107*t173+1.6264853333333332d-2*t105
     @           *t106*t126*t170+1.6264853333333332d-2*t100*t103*t104*t1
     1           26*t170+8.132426666666667d-3*t102*t104*t108*t170+8.1324
     2           26666666667d-3*t100*t102*t107*t170-2.6666666666666666d+
     3           0*t102*t103*t104*t170)+1.0d+0*t197*t204)+1.86008522312d
     4           -5*t109*t126*t171*t53*t96-3.04966d-3*t102*t171*t204*t96
     5           +8.132426666666667d-3*t102*t109*t170*t96+t53*t61*(1.373
     6           568d-2*t49*t52*t64-5.15088d-3*t185)+6.4386d-4*t171*t49*
     7           t51*t61*t64-6.4386d-4*gammabb*t170*t49*t51*t61*t64+5.30
     8           631295488d-5*t171*t172*t49*t52*t55*t64-5.15088d-3*rhob*
     9           t171*t203*t49*t52*t61+t303*t50*t51*t58-3.04966d-3*t102*
     :           t198*t53)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t96*t98*(5.580255669360001d
     1           -5*t101*t229*t27*t99-2.439728d-2*t100*t126*t27*t99+2*t1
     2           02*t27*t99+5.580255669360001d-5*t105*t106*t229*t27+5.58
     3           0255669360001d-5*t100*t103*t104*t229*t27+1.86008522312d
     4           -5*t104*t108*t126*t27+1.86008522312d-5*t100*t107*t126*t
     5           27-1.219864d-2*t103*t104*t126*t27-6.09932d-3*t102*t107*
     6           t27)+1.86008522312d-5*t109*t126*t27*t96-6.09932d-3*t102
     7           *t18*t201*t96+1.28772d-3*t14*t16*t18*t28*t35+5.30631295
     8           488d-5*t112*t14*t17*t206*t35+1.0d+0*rhoa*t14*t17*t23*(5
     9           .30631295488d-5*t112*t27*t30*t34-1.030176d-2*t27*t28*t3
     :           3+5.30631295488d-5*gammaaa*t112*t199*t33+1.591893886464
     ;           d-4*t219*t27*t31*t32-2.060352d-2*t112*t27*t29*t30+1.591
     <           893886464d-4*gammaaa*t199*t219*t29*t30+2*t25*t27*t28+1.
     =           591893886464d-4*t219*t25*t26/rhoa**1.0666666666666666d+
     >           1-4.120704d-2*gammaaa*t112*t199*t25)-1.030176d-2*t14*t1
     ?           7*t20*t200*t28-2.5d-1*t14*t16*t200*t23)*wght+Cmat2(iq,D
     @           2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = (1.0d+0*t96*t98*(5.580255669360001d
     1           -5*t101*t18*t229*t53*t99-2.439728d-2*t100*t126*t18*t53*
     2           t99+2*t102*t18*t53*t99+5.580255669360001d-5*t105*t106*t
     3           18*t229*t53+5.580255669360001d-5*t100*t103*t104*t18*t22
     4           9*t53+1.86008522312d-5*t104*t108*t126*t18*t53+1.8600852
     5           2312d-5*t100*t107*t126*t18*t53-1.219864d-2*t103*t104*t1
     6           26*t18*t53-6.09932d-3*t102*t107*t18*t53)-3.04966d-3*t10
     7           2*t201*t53*t96+1.86008522312d-5*t109*t126*t18*t53*t96-3
     8           .04966d-3*t102*t18*t204*t96)*wght+Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (1.0d+0*t96*t98*(5.580255669360001d
     1           -5*t101*t229*t60*t99-2.439728d-2*t100*t126*t60*t99+2*t1
     2           02*t60*t99+5.580255669360001d-5*t105*t106*t229*t60+5.58
     3           0255669360001d-5*t100*t103*t104*t229*t60+1.86008522312d
     4           -5*t104*t108*t126*t60+1.86008522312d-5*t100*t107*t126*t
     5           60-1.219864d-2*t103*t104*t126*t60-6.09932d-3*t102*t107*
     6           t60)+1.86008522312d-5*t109*t126*t60*t96-6.09932d-3*t102
     7           *t204*t53*t96+1.28772d-3*t49*t51*t53*t61*t64+5.30631295
     8           488d-5*t172*t212*t49*t52*t64+1.0d+0*rhob*t49*t52*t58*(1
     9           .591893886464d-4*t287*t31*t60*t63+5.30631295488d-5*t172
     :           *t34*t60*t62-2.060352d-2*t172*t29*t60*t62+1.59189388646
     ;           4d-4*gammabb*t202*t287*t29*t62-1.030176d-2*t33*t60*t61+
     <           2*t25*t60*t61+1.591893886464d-4*t25*t287*t59/rhob**1.06
     =           66666666666666d+1+5.30631295488d-5*gammabb*t172*t202*t3
     >           3-4.120704d-2*gammabb*t172*t202*t25)-1.030176d-2*t203*t
     ?           49*t52*t55*t61-2.5d-1*t203*t49*t51*t58)*wght+Cmat2(iq,D
     @           2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t23*(1.0d+0*rhoa*t14*t17*(3.43392000
     1           00000003d-2*t206*t28*t34*taua+1.373568d-1*t112*t206*t30
     2           *t31*taua-1.3333333333333333d+1*t206*t28*t31*taua+6.867
     3           840000000001d-2*gammaaa*t112*t205*t29*taua+1.7169600000
     4           000002d-2*t18*t28*t30*t34+1.061262590976d-4*t111*t112*t
     5           20*t30*t34-1.030176d-2*t111*t20*t28*t34-3.3333333333333
     6           337d+0*t18*t23*t34+4.464096d-2*gammaaa*t27*t28*t33+1.06
     7           1262590976d-4*gammaaa*t111*t112*t206*t33+3.183787772928
     8           d-4*t111*t20*t219*t31*t32+3.4339200000000003d-2*t112*t1
     9           8*t31*t32-6.666666666666667d+0*t18*t28*t30*t31-4.120704
     :           d-2*t111*t112*t20*t30*t31+8.928192d-2*gammaaa*t112*t27*
     ;           t29*t30+3.183787772928d-4*gammaaa*t111*t206*t219*t29*t3
     <           0-8.666666666666666d+0*gammaaa*t27*t28*t29-2.060352d-2*
     =           gammaaa*t111*t112*t206*t29+3.183787772928d-4*t111*t205*
     >           t219*t25*t26+1.4422464000000002d-1*t112*t199*t25*t26)+1
     ?           .25d-1*gammaaa*t14*t15*t209*t35+1.25d-1*gammaaa*t124*t2
     @           09*t35+1.25d-1*gammaaa*t114*t14*t209+1.0d+0*t14*t17*t20
     1           7+1.0d+0*rhoa*t124*t17*t207)+t98*(1.0d+0*t96*(8.1324266
     2           66666668d-2*t104*t105*t126*t206*taua+4.066213333333334d
     3           -2*t100*t103*t126*t206*taua+2.033106666666667d-2*t102*t
     4           108*t206*taua-1.3333333333333333d+1*t102*t105*t206*taua
     5           +6.505941333333333d-2*gammaaa*t100*t126*t27*t99+1.11605
     6           11338720001d-4*t101*t111*t20*t229*t99+2.033106666666667
     7           d-2*t101*t126*t18*t99-3.3333333333333337d+0*t108*t18*t9
     8           8+3.2529706666666663d-2*gammaaa*t103*t104*t126*t27+1.62
     9           64853333333332d-2*gammaaa*t102*t107*t27-5.3333333333333
     :           33d+0*gammaaa*t102*t103*t27+1.1160511338720001d-4*t105*
     ;           t106*t111*t20*t229+1.1160511338720001d-4*t100*t103*t104
     <           *t111*t20*t229+3.72017044624d-5*t104*t108*t111*t126*t20
     =           +3.72017044624d-5*t100*t107*t111*t126*t20-2.439728d-2*t
     >           104*t105*t111*t126*t20-1.219864d-2*t100*t103*t111*t126*
     ?           t20-6.09932d-3*t102*t108*t111*t20+2.033106666666667d-2*
     @           t105*t106*t126*t18+2.033106666666667d-2*t100*t103*t104*
     1           t126*t18+1.0165533333333335d-2*t102*t104*t108*t18+1.016
     2           5533333333335d-2*t100*t102*t107*t18-6.666666666666667d+
     3           0*t102*t104*t105*t18-3.3333333333333337d+0*t100*t102*t1
     4           03*t18)+1.0d+0*t168*t210)-3.04966d-3*t102*t111*t210*t96
     5           +3.72017044624d-5*t109*t111*t126*t20*t96+1.016553333333
     6           3335d-2*t102*t109*t18*t96+t20*t28*(1.7169600000000002d-
     7           2*t14*t17*t35-1.030176d-2*t125)-6.4386d-4*gammaaa*t111*
     8           t14*t209*t28*t35-1.28772d-3*gammaaa*t14*t16*t18*t28*t35
     9           -1.25d-1*gammaaa*t14*t15*t209*t23*t35+1.061262590976d-4
     :           *t1*t111*t112*t14*t17*t35-5.15088d-3*rhoa*t111*t14*t17*
     ;           t207*t28+1.25d-1*gammaaa*t14*t15*t16*t207*t23-6.09932d-
     <           3*t102*t169*t20)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t98*(1.0d+0*t96*(8.132426666666668d-
     1           2*t104*t105*t126*t18*t55*taua+4.066213333333334d-2*t100
     2           *t103*t126*t18*t55*taua+2.033106666666667d-2*t102*t108*
     3           t18*t55*taua-1.3333333333333333d+1*t102*t105*t18*t55*ta
     4           ua+1.1160511338720001d-4*t101*t111*t229*t55*t99+6.50594
     5           1333333333d-2*gammaaa*t100*t110*t126*t55*t99+1.11605113
     6           38720001d-4*t105*t106*t111*t229*t55+1.1160511338720001d
     7           -4*t100*t103*t104*t111*t229*t55+3.72017044624d-5*t104*t
     8           108*t111*t126*t55+3.72017044624d-5*t100*t107*t111*t126*
     9           t55-2.439728d-2*t104*t105*t111*t126*t55-1.219864d-2*t10
     :           0*t103*t111*t126*t55+3.2529706666666663d-2*gammaaa*t103
     ;           *t104*t110*t126*t55-6.09932d-3*t102*t108*t111*t55+1.626
     <           4853333333332d-2*gammaaa*t102*t107*t110*t55-5.333333333
     =           333333d+0*gammaaa*t102*t103*t110*t55)+1.0d+0*t168*t216)
     >           +3.72017044624d-5*t109*t111*t126*t55*t96-3.04966d-3*t10
     ?           2*t111*t216*t96-6.09932d-3*t102*t169*t55)*wght+Mmat2(iq
     @           ,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = (t98*(1.0d+0*t96*(8.132426666666668d-
     1           2*t104*t105*t126*t20*t53*taub+4.066213333333334d-2*t100
     2           *t103*t126*t20*t53*taub+2.033106666666667d-2*t102*t108*
     3           t20*t53*taub-1.3333333333333333d+1*t102*t105*t20*t53*ta
     4           ub+1.1160511338720001d-4*t101*t171*t20*t229*t99+6.50594
     5           1333333333d-2*gammabb*t100*t126*t170*t20*t99+1.11605113
     6           38720001d-4*t105*t106*t171*t20*t229+1.1160511338720001d
     7           -4*t100*t103*t104*t171*t20*t229+3.72017044624d-5*t104*t
     8           108*t126*t171*t20+3.72017044624d-5*t100*t107*t126*t171*
     9           t20-2.439728d-2*t104*t105*t126*t171*t20-1.219864d-2*t10
     :           0*t103*t126*t171*t20-6.09932d-3*t102*t108*t171*t20+3.25
     ;           29706666666663d-2*gammabb*t103*t104*t126*t170*t20+1.626
     <           4853333333332d-2*gammabb*t102*t107*t170*t20-5.333333333
     =           333333d+0*gammabb*t102*t103*t170*t20)+1.0d+0*t197*t210)
     >           -3.04966d-3*t102*t171*t210*t96+3.72017044624d-5*t109*t1
     ?           26*t171*t20*t96-6.09932d-3*t102*t198*t20)*wght+Mmat2(iq
     @           ,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t58*(1.0d+0*rhob*t49*t52*(1.373568d-
     1           1*t172*t212*t31*t62*taub+3.4339200000000003d-2*t212*t34
     2           *t61*taub-1.3333333333333333d+1*t212*t31*t61*taub+6.867
     3           840000000001d-2*gammabb*t172*t211*t29*taub+3.1837877729
     4           28d-4*t171*t287*t31*t55*t63+3.4339200000000003d-2*t172*
     5           t31*t53*t63+1.7169600000000002d-2*t34*t53*t61*t62-6.666
     6           666666666667d+0*t31*t53*t61*t62+8.928192d-2*gammabb*t17
     7           2*t29*t60*t62+1.061262590976d-4*t171*t172*t34*t55*t62-4
     8           .120704d-2*t171*t172*t31*t55*t62+3.183787772928d-4*gamm
     9           abb*t171*t212*t287*t29*t62+4.464096d-2*gammabb*t33*t60*
     :           t61-8.666666666666666d+0*gammabb*t29*t60*t61-1.030176d-
     ;           2*t171*t34*t55*t61+3.183787772928d-4*t171*t211*t25*t287
     <           *t59+1.4422464000000002d-1*t172*t202*t25*t59-3.33333333
     =           33333337d+0*t34*t53*t58+1.061262590976d-4*gammabb*t171*
     >           t172*t212*t33-2.060352d-2*gammabb*t171*t172*t212*t29)+1
     ?           .25d-1*gammabb*t215*t49*t50*t64+1.25d-1*gammabb*t184*t2
     @           15*t64+1.0d+0*t213*t49*t52+1.0d+0*rhob*t184*t213*t52+1.
     1           25d-1*gammabb*t174*t215*t49)+t98*(1.0d+0*t96*(8.1324266
     2           66666668d-2*t104*t105*t126*t212*taub+4.066213333333334d
     3           -2*t100*t103*t126*t212*taub+2.033106666666667d-2*t102*t
     4           108*t212*taub-1.3333333333333333d+1*t102*t105*t212*taub
     5           +6.505941333333333d-2*gammabb*t100*t126*t60*t99+1.11605
     6           11338720001d-4*t101*t171*t229*t55*t99+2.033106666666667
     7           d-2*t101*t126*t53*t99-3.3333333333333337d+0*t108*t53*t9
     8           8+3.2529706666666663d-2*gammabb*t103*t104*t126*t60+1.62
     9           64853333333332d-2*gammabb*t102*t107*t60-5.3333333333333
     :           33d+0*gammabb*t102*t103*t60+1.1160511338720001d-4*t105*
     ;           t106*t171*t229*t55+1.1160511338720001d-4*t100*t103*t104
     <           *t171*t229*t55+3.72017044624d-5*t104*t108*t126*t171*t55
     =           +3.72017044624d-5*t100*t107*t126*t171*t55-2.439728d-2*t
     >           104*t105*t126*t171*t55-1.219864d-2*t100*t103*t126*t171*
     ?           t55-6.09932d-3*t102*t108*t171*t55+2.033106666666667d-2*
     @           t105*t106*t126*t53+2.033106666666667d-2*t100*t103*t104*
     1           t126*t53+1.0165533333333335d-2*t102*t104*t108*t53+1.016
     2           5533333333335d-2*t100*t102*t107*t53-6.666666666666667d+
     3           0*t102*t104*t105*t53-3.3333333333333337d+0*t100*t102*t1
     4           03*t53)+1.0d+0*t197*t216)+3.72017044624d-5*t109*t126*t1
     5           71*t55*t96+1.0165533333333335d-2*t102*t109*t53*t96-3.04
     6           966d-3*t102*t171*t216*t96+t55*t61*(1.7169600000000002d-
     7           2*t49*t52*t64-1.030176d-2*t185)-1.28772d-3*gammabb*t49*
     8           t51*t53*t61*t64-6.4386d-4*gammabb*t171*t215*t49*t61*t64
     9           -1.25d-1*gammabb*t215*t49*t50*t58*t64+1.061262590976d-4
     :           *t171*t172*t36*t49*t52*t64-5.15088d-3*rhob*t171*t213*t4
     ;           9*t52*t61+1.25d-1*gammabb*t213*t49*t50*t51*t58-6.09932d
     <           -3*t102*t198*t55)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*t96*t98*(1.1160511338720001d
     1           -4*t101*t206*t229*t99-2.439728d-2*t100*t126*t206*t99+1.
     2           1160511338720001d-4*t105*t106*t206*t229+1.1160511338720
     3           001d-4*t100*t103*t104*t206*t229+3.72017044624d-5*t104*t
     4           108*t126*t206+3.72017044624d-5*t100*t107*t126*t206-2.43
     5           9728d-2*t104*t105*t126*t206-1.219864d-2*t103*t104*t126*
     6           t206-1.219864d-2*t100*t103*t126*t206-6.09932d-3*t102*t1
     7           08*t206-6.09932d-3*t102*t107*t206+2.0d+0*t102*t103*t206
     8           )-3.04966d-3*t102*t18*t210*t96+3.72017044624d-5*t109*t1
     9           26*t206*t96-6.09932d-3*t102*t20*t201*t96+1.061262590976
     :           d-4*t112*t14*t17*t304*t35-6.4386d-4*gammaaa*t14*t18*t20
     ;           9*t28*t35+1.28772d-3*t14*t16*t20*t28*t35+1.0d+0*rhoa*t1
     <           4*t17*t23*(1.061262590976d-4*t112*t206*t30*t34-1.030176
     =           d-2*t206*t28*t34-1.030176d-2*t206*t28*t33+1.06126259097
     >           6d-4*gammaaa*t112*t205*t33+3.183787772928d-4*t206*t219*
     ?           t31*t32-4.120704d-2*t112*t206*t30*t31+3.183787772928d-4
     @           *gammaaa*t205*t219*t29*t30-2.060352d-2*t112*t206*t29*t3
     1           0+2.0d+0*t206*t28*t29-2.060352d-2*gammaaa*t112*t205*t29
     2           +3.183787772928d-4*t219*t25*t26/rhoa**9.666666666666666
     3           d+0-4.120704d-2*gammaaa*t112*t205*t25)+t209*t23*t302-5.
     4           15088d-3*t14*t17*t20*t207*t28-1.030176d-2*t1*t14*t17*t2
     5           00*t28-1.25d-1*t14*t16*t207*t23)*wght+Mmat2(iq,D2_GAA_T
     6           A)
              Mmat2(iq,D2_GAA_TB) = (1.0d+0*t96*t98*(1.1160511338720001d
     1           -4*t101*t18*t229*t55*t99-2.439728d-2*t100*t126*t18*t55*
     2           t99+1.1160511338720001d-4*t105*t106*t18*t229*t55+1.1160
     3           511338720001d-4*t100*t103*t104*t18*t229*t55+3.720170446
     4           24d-5*t104*t108*t126*t18*t55+3.72017044624d-5*t100*t107
     5           *t126*t18*t55-2.439728d-2*t104*t105*t126*t18*t55-1.2198
     6           64d-2*t103*t104*t126*t18*t55-1.219864d-2*t100*t103*t126
     7           *t18*t55-6.09932d-3*t102*t108*t18*t55-6.09932d-3*t102*t
     8           107*t18*t55+2.0d+0*t102*t103*t18*t55)-6.09932d-3*t102*t
     9           201*t55*t96+3.72017044624d-5*t109*t126*t18*t55*t96-3.04
     :           966d-3*t102*t18*t216*t96)*wght+Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = (1.0d+0*t96*t98*(1.1160511338720001d
     1           -4*t101*t20*t229*t53*t99-2.439728d-2*t100*t126*t20*t53*
     2           t99+1.1160511338720001d-4*t105*t106*t20*t229*t53+1.1160
     3           511338720001d-4*t100*t103*t104*t20*t229*t53+3.720170446
     4           24d-5*t104*t108*t126*t20*t53+3.72017044624d-5*t100*t107
     5           *t126*t20*t53-2.439728d-2*t104*t105*t126*t20*t53-1.2198
     6           64d-2*t103*t104*t126*t20*t53-1.219864d-2*t100*t103*t126
     7           *t20*t53-6.09932d-3*t102*t108*t20*t53-6.09932d-3*t102*t
     8           107*t20*t53+2.0d+0*t102*t103*t20*t53)-3.04966d-3*t102*t
     9           210*t53*t96+3.72017044624d-5*t109*t126*t20*t53*t96-6.09
     :           932d-3*t102*t20*t204*t96)*wght+Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*t96*t98*(1.1160511338720001d
     1           -4*t101*t212*t229*t99-2.439728d-2*t100*t126*t212*t99+1.
     2           1160511338720001d-4*t105*t106*t212*t229+1.1160511338720
     3           001d-4*t100*t103*t104*t212*t229+3.72017044624d-5*t104*t
     4           108*t126*t212+3.72017044624d-5*t100*t107*t126*t212-2.43
     5           9728d-2*t104*t105*t126*t212-1.219864d-2*t103*t104*t126*
     6           t212-1.219864d-2*t100*t103*t126*t212-6.09932d-3*t102*t1
     7           08*t212-6.09932d-3*t102*t107*t212+2.0d+0*t102*t103*t212
     8           )-6.09932d-3*t102*t204*t55*t96-3.04966d-3*t102*t216*t53
     9           *t96+3.72017044624d-5*t109*t126*t212*t96+1.28772d-3*t49
     :           *t51*t55*t61*t64-6.4386d-4*gammabb*t215*t49*t53*t61*t64
     ;           +1.061262590976d-4*t172*t305*t49*t52*t64+1.0d+0*rhob*t4
     <           9*t52*t58*(3.183787772928d-4*t212*t287*t31*t63+1.061262
     =           590976d-4*t172*t212*t34*t62-4.120704d-2*t172*t212*t31*t
     >           62+3.183787772928d-4*gammabb*t211*t287*t29*t62-2.060352
     ?           d-2*t172*t212*t29*t62-1.030176d-2*t212*t34*t61-1.030176
     @           d-2*t212*t33*t61+2.0d+0*t212*t29*t61+3.183787772928d-4*
     1           t25*t287*t59/rhob**9.666666666666666d+0+1.061262590976d
     2           -4*gammabb*t172*t211*t33-2.060352d-2*gammabb*t172*t211*
     3           t29-4.120704d-2*gammabb*t172*t211*t25)-5.15088d-3*t213*
     4           t49*t52*t55*t61-1.030176d-2*t203*t36*t49*t52*t61-1.25d-
     5           1*t213*t49*t51*t58+t215*t303*t58)*wght+Mmat2(iq,D2_GBB_
     6           TB)
              Mmat2(iq,D2_TA_TA) = (-2.5d-1*gammaaa*t14*t23*t35/taua**3+
     1           1.0d+0*t96*t98*(2.2321022677440003d-4*t101*t229*t304*t9
     2           9+2.2321022677440003d-4*t105*t106*t229*t304+2.232102267
     3           7440003d-4*t100*t103*t104*t229*t304+7.44034089248d-5*t1
     4           04*t108*t126*t304+7.44034089248d-5*t100*t107*t126*t304-
     5           9.758912d-2*t104*t105*t126*t304-4.879456d-2*t100*t103*t
     6           126*t304-2.439728d-2*t102*t108*t304+8.0d+0*t102*t105*t3
     7           04)+7.44034089248d-5*t109*t126*t304*t96-1.219864d-2*t10
     8           2*t20*t210*t96-2.57544d-3*gammaaa*t14*t20*t209*t28*t35+
     9           2.122525181952d-4*t112*t14*t17*t225*t35+1.0d+0*rhoa*t14
     :           *t17*t23*(2.122525181952d-4*t112*t30*t304*t34-4.120704d
     ;           -2*t28*t304*t34+2.122525181952d-4*gammaaa*t112*t306*t33
     <           +6.367575545856d-4*t219*t304*t31*t32-1.6482816d-1*t112*
     =           t30*t304*t31+8.0d+0*t28*t304*t31+6.367575545856d-4*gamm
     >           aaa*t219*t29*t30*t306-8.241408d-2*gammaaa*t112*t29*t306
     ?           +6.367575545856d-4*t219*t25*t26/rhoa**8.666666666666666
     @           d+0)-2.060352d-2*t1*t14*t17*t207*t28+2.5d-1*gammaaa*t14
     1           *t207*t209*t23)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = (1.0d+0*t96*t98*(2.2321022677440003d-
     1           4*t101*t20*t229*t55*t99+2.2321022677440003d-4*t105*t106
     2           *t20*t229*t55+2.2321022677440003d-4*t100*t103*t104*t20*
     3           t229*t55+7.44034089248d-5*t104*t108*t126*t20*t55+7.4403
     4           4089248d-5*t100*t107*t126*t20*t55-9.758912d-2*t104*t105
     5           *t126*t20*t55-4.879456d-2*t100*t103*t126*t20*t55-2.4397
     6           28d-2*t102*t108*t20*t55+8.0d+0*t102*t105*t20*t55)-6.099
     7           32d-3*t102*t210*t55*t96+7.44034089248d-5*t109*t126*t20*
     8           t55*t96-6.09932d-3*t102*t20*t216*t96)*wght+Mmat2(iq,D2_
     9           TA_TB)
              Mmat2(iq,D2_TB_TB) = (-2.5d-1*gammabb*t49*t58*t64/taub**3+
     1           1.0d+0*t96*t98*(2.2321022677440003d-4*t101*t229*t305*t9
     2           9+2.2321022677440003d-4*t105*t106*t229*t305+2.232102267
     3           7440003d-4*t100*t103*t104*t229*t305+7.44034089248d-5*t1
     4           04*t108*t126*t305+7.44034089248d-5*t100*t107*t126*t305-
     5           9.758912d-2*t104*t105*t126*t305-4.879456d-2*t100*t103*t
     6           126*t305-2.439728d-2*t102*t108*t305+8.0d+0*t102*t105*t3
     7           05)-1.219864d-2*t102*t216*t55*t96+7.44034089248d-5*t109
     8           *t126*t305*t96-2.57544d-3*gammabb*t215*t49*t55*t61*t64+
     9           2.122525181952d-4*t172*t293*t49*t52*t64+1.0d+0*rhob*t49
     :           *t52*t58*(6.367575545856d-4*t287*t305*t31*t63+2.1225251
     ;           81952d-4*t172*t305*t34*t62-1.6482816d-1*t172*t305*t31*t
     <           62+6.367575545856d-4*gammabb*t287*t29*t307*t62-4.120704
     =           d-2*t305*t34*t61+8.0d+0*t305*t31*t61+6.367575545856d-4*
     >           t25*t287*t59/rhob**8.666666666666666d+0+2.122525181952d
     ?           -4*gammabb*t172*t307*t33-8.241408d-2*gammabb*t172*t29*t
     @           307)-2.060352d-2*t213*t36*t49*t52*t61+2.5d-1*gammabb*t2
     1           13*t215*t49*t58)*wght+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhob**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhob**6.666666666666666d-1
              t17 = rhob**5.0d-1
              t18 = 1/t17
              t19 = 1/rhob**3.333333333333333d-1
              t20 = 1/rhob**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = 1/rhoa**6.666666666666666d-1
              t31 = rhoa**5.0d-1
              t32 = 1/t31
              t33 = 1/rhoa**3.333333333333333d-1
              t34 = 1/rhoa**1.6666666666666666d-1
              t35 = 1.1120374863094686d+1*t34+3.8447462374472113d+0*t33+
     1           1.644733775567609d+0*t32+2.4058712912881916d-1*t30
              t36 = 3.216395899738507d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.274696188700087d-1*t33+1.0d+0
              t39 = 5.982550435771079d+0*t34+2.2255694211506874d+0*t33+8
     1           .004286349993635d-1*t32+1.8970043257475583d-1*t30
              t40 = 1.6081979498692536d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.3256889990520176d-1*t33+1.0d+0
              t43 = -6.903522198342671d-18*t41*t42-3.1090699999999993d-2
     1           *t37*t38
              t44 = 1/rhoa
              t45 = 1/taua
              t46 = 1.0d+0-1.25d-1*gammaaa*t44*t45
              t47 = 1/rhoa**2.6666666666666666d+0
              t48 = gammaaa*t47
              t49 = 1/rhoa**1.6666666666666669d+0
              t50 = 2.0d+0*t49*taua
              t51 = 5.15088d-3*(t50+t48-9.11559972d+0)+1.0d+0
              t52 = 1/t51
              t53 = gammaaa**2
              t54 = 1/rhoa**5.333333333333333d+0
              t55 = 1/t51**2
              t56 = t50-9.11559972d+0
              t57 = t56**2
              t58 = t55*t57*t6+gammaaa*t14*t47*t55*t56+t12*t52*t56+t11*t
     1           53*t54*t55+gammaaa*t13*t47*t52+t5
              t59 = rhob+rhoa
              t60 = 1/t59**3.333333333333333d-1
              t61 = 1.3256889990520176d-1*t60+1.0d+0
              t62 = rhoa-rhob
              t63 = t62**4
              t64 = 1/t59**4
              t65 = 1/t59
              t66 = 1.0d+0-t62*t65
              t67 = t62*t65+1.0d+0
              t68 = t67**1.3333333333333333d+0+t66**1.3333333333333333d+
     1           0-2.0d+0
              t69 = -1.923661050931536d+0*t63*t64*t68
              t70 = t69+1.0d+0
              t71 = 1/t59**6.666666666666666d-1
              t72 = t59**5.0d-1
              t73 = 1/t72
              t74 = 1/t59**1.6666666666666666d-1
              t75 = 5.982550435771079d+0*t74+8.004286349993635d-1*t73+1.
     1           8970043257475583d-1*t71+2.2255694211506874d+0*t60
              t76 = 1.6081979498692536d+1/t75+1.0d+0
              t77 = log(t76)
              t78 = -6.21814d-2*t61*t70*t77
              t79 = 6.901399211255825d-2*t60+1.0d+0
              t80 = t69+1.923661050931536d+0*t68
              t81 = 8.157414703487641d+0*t74+4.3009724712766434d-1*t73+1
     1           .9115125951273373d-1*t71+2.247591863577616d+0*t60
              t82 = 2.9608813203268075d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = 1.9751631321680768d-2*t79*t80*t83
              t85 = 1.274696188700087d-1*t60+1.0d+0
              t86 = 1.1120374863094686d+1*t74+1.644733775567609d+0*t73+2
     1           .4058712912881916d-1*t71+3.8447462374472113d+0*t60
              t87 = 3.216395899738507d+1/t86+1.0d+0
              t88 = log(t87)
              t89 = -5.980796863619711d-2*t63*t64*t68*t85*t88
              t90 = t59*(t89+t84+t78)-rhoa*t43-rhob*t29
              t91 = 3.04966d-3*(t50+t48+t2-1.823119944d+1)+1.0d+0
              t92 = 1/t91
              t93 = param(4)
              t94 = t48+4.0d-50*t1
              t95 = t94**2
              t96 = 1/t91**2
              t97 = param(5)
              t98 = t8+t50-1.823119944d+1
              t99 = param(6)
              t100 = t98**2
              t101 = param(2)
              t102 = param(3)
              t103 = t100*t96*t99+t94*t96*t97*t98+t102*t92*t98+t93*t95*t
     1           96+t101*t92*t94+param(1)
              t104 = 1/rhoa**3.6666666666666664d+0
              t105 = -3.3333333333333337d+0*t47*taua-2.6666666666666666d
     1           +0*gammaaa*t104
              t106 = 1/t51**3
              t107 = 1/rhoa**6.333333333333333d+0
              t108 = -6.666666666666667d+0*t47*t55*t56*t6*taua-3.3333333
     1           333333337d+0*gammaaa*t14*t54*t55*taua-3.333333333333333
     2           7d+0*t12*t47*t52*taua-1.030176d-2*t105*t106*t57*t6-2.66
     3           66666666666666d+0*gammaaa*t104*t14*t55*t56-5.15088d-3*t
     4           105*t12*t55*t56-1.030176d-2*gammaaa*t105*t106*t14*t47*t
     5           56-5.333333333333333d+0*t107*t11*t53*t55-5.15088d-3*gam
     6           maaa*t105*t13*t47*t55-1.030176d-2*t105*t106*t11*t53*t54
     7           -2.6666666666666666d+0*gammaaa*t104*t13*t52
              t109 = 1/t40
              t110 = 1/t31**3
              t111 = 1/rhoa**1.3333333333333333d+0
              t112 = 1/rhoa**1.1666666666666667d+0
              t113 = -1.264669550498372d-1*t49-9.970917392951799d-1*t112
     1           -7.418564737168958d-1*t111-4.002143174996817d-1*t110
              t114 = 1/t39**2
              t115 = 1/t36
              t116 = -1.6039141941921276d-1*t49-1.8533958105157808d+0*t1
     1           12-1.2815820791490704d+0*t111-8.223668877838045d-1*t110
              t117 = 1/t35**2
              t118 = 1.1102230246251565d-16*t109*t113*t114*t42+3.0506411
     1           443514264d-19*t111*t41+1.0d+0*t115*t116*t117*t38+1.3210
     2           398931339265d-3*t111*t37
              t119 = 1.0d+0*t43*t46*t58+1.0d+0*rhoa*t118*t46*t58+1.0d+0*
     1           rhoa*t108*t43*t46
              t120 = 1/t91**3
              t121 = -6.666666666666667d+0*t47*t96*t98*t99*taua-3.333333
     1           3333333337d+0*t47*t94*t96*t97*taua-3.3333333333333337d+
     2           0*t102*t47*t92*taua-6.09932d-3*t100*t105*t120*t99-2.666
     3           6666666666666d+0*gammaaa*t104*t96*t97*t98-6.09932d-3*t1
     4           05*t120*t94*t97*t98-3.04966d-3*t102*t105*t96*t98-5.3333
     5           33333333333d+0*gammaaa*t104*t93*t94*t96-3.04966d-3*t101
     6           *t105*t94*t96-6.09932d-3*t105*t120*t93*t95-2.6666666666
     7           666666d+0*gammaaa*t101*t104*t92
              t122 = 1/t59**1.6666666666666669d+0
              t123 = 1/t72**3
              t124 = 1/t59**1.3333333333333333d+0
              t125 = 1/t59**1.1666666666666667d+0
              t126 = -9.970917392951799d-1*t125-7.418564737168958d-1*t12
     1           4-4.002143174996817d-1*t123-1.264669550498372d-1*t122
              t127 = 1/t75**2
              t128 = 1/t76
              t129 = 1.0d+0*t126*t127*t128*t61*t70
              t130 = -1.3595691172479402d+0*t125-7.491972878592053d-1*t1
     1           24-2.1504862356383217d-1*t123-1.2743417300848914d-1*t12
     2           2
              t131 = 1/t81**2
              t132 = 1/t82
              t133 = -5.848223622634647d-1*t130*t131*t132*t79*t80
              t134 = -1.8533958105157808d+0*t125-1.2815820791490704d+0*t
     1           124-8.223668877838045d-1*t123-1.6039141941921276d-1*t12
     2           2
              t135 = 1/t86**2
              t136 = 1/t87
              t137 = 1.923661050931536d+0*t134*t135*t136*t63*t64*t68*t85
              t138 = 1/t59**2
              t139 = t138*t62
              t140 = -t65
              t141 = t140+t139
              t142 = t66**3.333333333333333d-1
              t143 = -t138*t62
              t144 = t65+t143
              t145 = t67**3.333333333333333d-1
              t146 = 1.3333333333333333d+0*t144*t145+1.3333333333333333d
     1           +0*t141*t142
              t147 = -1.923661050931536d+0*t146*t63*t64
              t148 = 1/t59**5
              t149 = 7.694644203726144d+0*t148*t63*t68
              t150 = t62**3
              t151 = -7.694644203726144d+0*t150*t64*t68
              t152 = t151+t149+t147
              t153 = -6.21814d-2*t152*t61*t77
              t154 = 2.747773264188437d-3*t124*t70*t77
              t155 = t151+t149+t147+1.923661050931536d+0*t146
              t156 = 1.9751631321680768d-2*t155*t79*t83
              t157 = -4.5437964274821163d-4*t124*t80*t83
              t158 = -5.980796863619711d-2*t146*t63*t64*t85*t88
              t159 = 1/t59**5.333333333333333d+0
              t160 = 2.541232989148493d-3*t159*t63*t68*t88
              t161 = 2.3923187454478842d-1*t148*t63*t68*t85*t88
              t162 = t89+t59*(-2.3923187454478842d-1*t150*t64*t68*t85*t8
     1           8+t161+t160+t158+t157+t156+t154+t153+t137+t133+t129)+t8
     2           4+t78+6.903522198342671d-18*t41*t42+3.1090699999999993d
     3           -2*t37*t38-rhoa*t118
              t163 = 1.0d+0*t121*t90+1.0d+0*t103*t162
              t164 = 1/t26
              t165 = 1/t17**3
              t166 = 1/rhob**1.3333333333333333d+0
              t167 = 1/rhob**1.1666666666666667d+0
              t168 = -9.970917392951799d-1*t167-7.418564737168958d-1*t16
     1           6-4.002143174996817d-1*t165-1.264669550498372d-1*t1
              t169 = 1/t25**2
              t170 = 1/t22
              t171 = -1.8533958105157808d+0*t167-1.2815820791490704d+0*t
     1           166-8.223668877838045d-1*t165-1.6039141941921276d-1*t1
              t172 = 1/t21**2
              t173 = 1.1102230246251565d-16*t164*t168*t169*t28+3.0506411
     1           443514264d-19*t166*t27+1.0d+0*t170*t171*t172*t24+1.3210
     2           398931339265d-3*t166*t23
              t174 = 1/t3**3
              t175 = 1/rhob**4.333333333333333d+0
              t176 = 1/rhob**2.6666666666666666d+0
              t177 = -6.666666666666666d-50*t176*t6*t7*t9-6.666666666666
     1           666d-50*t14*t176*t7*t9+5.15088d-52*t12*t176*t7*t9+4.120
     2           7039999999995d-101*t14*t174*t175*t9-1.3333333333333333d
     3           -99*t14*t175*t7+2.0603519999999997d-101*t13*t175*t7-5.3
     4           33333333333334d-99*t11*t175*t7+1.030176d-51*t10*t174*t1
     5           76*t6-6.666666666666666d-50*t13*t176*t4-3.3333333333333
     6           33d-50*t12*t176*t4+1.6482816d-150*t11*t174/rhob**6
              t178 = 5.0d-1*rhob*t177*t29+5.0d-1*t15*t29+5.0d-1*rhob*t15
     1           *t173
              t179 = -6.666666666666666d-50*t176*t96*t98*t99+6.09932d-52
     1           *t100*t120*t176*t99-6.666666666666666d-50*t176*t96*t97*
     2           t98+6.09932d-52*t120*t176*t94*t97*t98+3.04966d-52*t102*
     3           t176*t96*t98-3.333333333333333d-50*t176*t94*t96*t97-1.3
     4           333333333333333d-49*t176*t93*t94*t96+3.04966d-52*t101*t
     5           176*t94*t96+6.09932d-52*t120*t176*t93*t95-3.33333333333
     6           3333d-50*t102*t176*t92-6.666666666666666d-50*t101*t176*
     7           t92
              t180 = t65+t139
              t181 = t143+t140
              t182 = 1.3333333333333333d+0*t145*t181+1.3333333333333333d
     1           +0*t142*t180
              t183 = -1.923661050931536d+0*t182*t63*t64
              t184 = 7.694644203726144d+0*t150*t64*t68
              t185 = t184+t183+t149
              t186 = -6.21814d-2*t185*t61*t77
              t187 = t184+t183+1.923661050931536d+0*t182+t149
              t188 = 1.9751631321680768d-2*t187*t79*t83
              t189 = -5.980796863619711d-2*t182*t63*t64*t85*t88
              t190 = t89+t59*(2.3923187454478842d-1*t150*t64*t68*t85*t88
     1           +t189+t188+t186+t161+t160+t157+t154+t137+t133+t129)+t84
     2           +t78+6.903522198342671d-18*t27*t28+3.1090699999999993d-
     3           2*t23*t24-rhob*t173
              t191 = 1.0d+0*t179*t90+1.0d+0*t103*t190
              t192 = 1/rhoa**8
              t193 = -1.030176d-2*t106*t47*t57*t6+t14*t47*t55*t56-5.1508
     1           8d-3*t12*t47*t55*t56-1.030176d-2*gammaaa*t106*t14*t54*t
     2           56-5.15088d-3*gammaaa*t13*t54*t55+2*gammaaa*t11*t54*t55
     3           -1.030176d-2*t106*t11*t192*t53+t13*t47*t52
              t194 = -6.09932d-3*t100*t120*t47*t99+t47*t96*t97*t98-6.099
     1           32d-3*t120*t47*t94*t97*t98-3.04966d-3*t102*t47*t96*t98+
     2           2*t47*t93*t94*t96-3.04966d-3*t101*t47*t94*t96-6.09932d-
     3           3*t120*t47*t93*t95+t101*t47*t92
              t195 = 1/rhoa**7
              t196 = 1/rhoa**4.333333333333333d+0
              t197 = -2.060352d-2*t106*t49*t57*t6+4.0d+0*t49*t55*t56*t6-
     1           1.030176d-2*t12*t49*t55*t56-2.060352d-2*gammaaa*t106*t1
     2           4*t196*t56+2.0d+0*gammaaa*t14*t196*t55-1.030176d-2*gamm
     3           aaa*t13*t196*t55-2.060352d-2*t106*t11*t195*t53+2.0d+0*t
     4           12*t49*t52
              t198 = taua**2
              t199 = 1/t198
              t200 = 4.0d+0*t49*t96*t98*t99-1.219864d-2*t100*t120*t49*t9
     1           9-1.219864d-2*t120*t49*t94*t97*t98-6.09932d-3*t102*t49*
     2           t96*t98+2.0d+0*t49*t94*t96*t97-6.09932d-3*t101*t49*t94*
     3           t96-1.219864d-2*t120*t49*t93*t95+2.0d+0*t102*t49*t92
              t201 = t105**2
              t202 = 1/rhoa**2
              t203 = 1/t51**4
              t204 = 1/rhoa**4.666666666666667d+0
              t205 = 8.88888888888889d+0*t104*taua+9.777777777777779d+0*
     1           gammaaa*t204
              t206 = 1/rhoa**7.333333333333333d+0
              t207 = t113**2
              t208 = 1/t31**5
              t209 = 1/rhoa**2.3333333333333334d+0
              t210 = 1/rhoa**2.1666666666666665d+0
              t211 = t116**2
              t212 = 1.0d+0*t115*t117*t38*(2.673190323653546d-1*t47+2.16
     1           22951122684114d+0*t210+1.7087761055320938d+0*t209+1.233
     2           5503316757068d+0*t208)+1.1102230246251565d-16*t109*t114
     3           *t42*(2.1077825841639536d-1*t47+1.1632736958443765d+0*t
     4           210+9.89141964955861d-1*t209+6.003214762495226d-1*t208)
     5           +1.7854583920998188d-15*t207*t42/(t39**4*t40**2)-2.2204
     6           46049250313d-16*t109*t207*t42/t39**3-4.0675215258019015
     7           d-19*t209*t41+3.216395899738507d+1*t211*t38/(t35**4*t36
     8           **2)-2.0d+0*t115*t211*t38/t35**3-1.7613865241785684d-3*
     9           t209*t37-8.497974591333913d-2*t111*t115*t116*t117-9.812
     :           069668265515d-18*t109*t111*t113*t114
              t213 = 1/t91**4
              t214 = 2.0d+0*t126*t127*t128*t61*t70
              t215 = -1.1696447245269295d+0*t130*t131*t132*t79*t80
              t216 = 3.847322101863072d+0*t134*t135*t136*t63*t64*t68*t85
              t217 = 5.495546528376875d-3*t124*t70*t77
              t218 = -9.087592854964233d-4*t124*t80*t83
              t219 = 5.082465978296986d-3*t159*t63*t68*t88
              t220 = 4.7846374908957684d-1*t148*t63*t68*t85*t88
              t221 = t126**2
              t222 = 1.6081979498692536d+1*t221*t61*t70/(t75**4*t76**2)
              t223 = -2.0d+0*t128*t221*t61*t70/t75**3
              t224 = -8.837926660346784d-2*t124*t126*t127*t128*t70
              t225 = 1/t59**2.6666666666666666d+0
              t226 = 1/t72**5
              t227 = 1/t59**2.3333333333333334d+0
              t228 = 1/t59**2.1666666666666665d+0
              t229 = 1.0d+0*t127*t128*(1.1632736958443765d+0*t228+9.8914
     1           1964955861d-1*t227+6.003214762495226d-1*t226+2.10778258
     2           41639536d-1*t225)*t61*t70
              t230 = t130**2
              t231 = -1.73158960813529d+1*t230*t79*t80/(t81**4*t82**2)
              t232 = 1.1696447245269295d+0*t132*t230*t79*t80/t81**3
              t233 = 2.690728393099896d-2*t124*t130*t131*t132*t80
              t234 = -5.848223622634647d-1*t131*t132*(1.5861639701225969
     1           d+0*t228+9.98929717145607d-1*t227+3.2257293534574827d-1
     2           *t226+2.1239028834748191d-1*t225)*t79*t80
              t235 = t134**2
              t236 = 6.187255516702861d+1*t235*t63*t64*t68*t85/(t86**4*t
     1           87**2)
              t237 = -3.847322101863072d+0*t136*t235*t63*t64*t68*t85/t86
     1           **3
              t238 = -1.6347222733154887d-1*t134*t135*t136*t159*t63*t68
              t239 = 1.923661050931536d+0*t135*t136*(2.1622951122684114d
     1           +0*t228+1.7087761055320938d+0*t227+1.2335503316757068d+
     2           0*t226+2.673190323653546d-1*t225)*t63*t64*t68*t85
              t240 = -1.538928840745229d+1*t134*t135*t136*t148*t63*t68*t
     1           85
              t241 = 1/t66**6.666666666666666d-1
              t242 = 1/t59**3
              t243 = -2*t242*t62
              t244 = 2*t138
              t245 = 1/t67**6.666666666666666d-1
              t246 = 2*t242*t62
              t247 = -2*t138
              t248 = 1.3333333333333333d+0*t145*(t247+t246)+4.4444444444
     1           44444d-1*t144**2*t245+1.3333333333333333d+0*t142*(t244+
     2           t243)+4.444444444444444d-1*t141**2*t241
              t249 = -1.923661050931536d+0*t248*t63*t64
              t250 = 1.5389288407452287d+1*t146*t148*t63
              t251 = -1.5389288407452287d+1*t146*t150*t64
              t252 = 1/t59**6
              t253 = -3.8473221018630716d+1*t252*t63*t68
              t254 = 6.155715362980915d+1*t148*t150*t68
              t255 = t62**2
              t256 = -2.3083932611178434d+1*t255*t64*t68
              t257 = -3.663697685584583d-3*t227*t70*t77
              t258 = 6.058395236642822d-4*t227*t80*t83
              t259 = -2.3718174565385935d-2*t63*t68*t88/t59**6.333333333
     1           333333d+0
              t260 = -1.1961593727239421d+0*t252*t63*t68*t85*t88
              t261 = -7.176956236343652d-1*t255*t64*t68*t85*t88
              t262 = 2.6666666666666666d+0*t145*t242*t62-2.6666666666666
     1           666d+0*t142*t242*t62+4.444444444444444d-1*t144*t181*t24
     2           5+4.444444444444444d-1*t141*t180*t241
              t263 = -1.923661050931536d+0*t262*t63*t64
              t264 = 7.694644203726144d+0*t148*t182*t63
              t265 = -7.694644203726144d+0*t150*t182*t64
              t266 = 7.694644203726144d+0*t146*t148*t63
              t267 = 7.694644203726144d+0*t146*t150*t64
              t268 = 2.3083932611178434d+1*t255*t64*t68
              t269 = t168**2
              t270 = 1/t17**5
              t271 = 1/rhob**2.3333333333333334d+0
              t272 = 1/rhob**2.1666666666666665d+0
              t273 = t171**2
              t274 = 1.1102230246251565d-16*t164*t169*(1.163273695844376
     1           5d+0*t272+9.89141964955861d-1*t271+6.003214762495226d-1
     2           *t270+2.1077825841639536d-1*t176)*t28+1.785458392099818
     3           8d-15*t269*t28/(t25**4*t26**2)-2.220446049250313d-16*t1
     4           64*t269*t28/t25**3+3.216395899738507d+1*t24*t273/(t21**
     5           4*t22**2)-2.0d+0*t170*t24*t273/t21**3+1.0d+0*t170*t172*
     6           t24*(2.1622951122684114d+0*t272+1.7087761055320938d+0*t
     7           271+1.2335503316757068d+0*t270+2.673190323653546d-1*t17
     8           6)-4.0675215258019015d-19*t27*t271-1.7613865241785684d-
     9           3*t23*t271-8.497974591333913d-2*t166*t170*t171*t172-9.8
     :           12069668265515d-18*t164*t166*t168*t169
              t275 = 1/t3**4
              t276 = 1/rhob**7
              t277 = 1/rhob**5.333333333333333d+0
              t278 = 1/rhob**3.6666666666666664d+0
              t279 = 1.3333333333333333d+0*t142*(t247+t243)+1.3333333333
     1           333333d+0*t145*(t246+t244)+4.444444444444444d-1*t181**2
     2           *t245+4.444444444444444d-1*t180**2*t241
              t280 = -1.923661050931536d+0*t279*t63*t64
              t281 = 1.5389288407452287d+1*t148*t182*t63
              t282 = 1.5389288407452287d+1*t150*t182*t64
              t283 = -6.155715362980915d+1*t148*t150*t68
              t284 = 1.25d-1*t43*t58+1.25d-1*gammaaa*t193*t43
              t285 = 1/rhoa**3.3333333333333337d+0
              t286 = 1/rhoa**6
              fnc(iq) = (1.0d+0*t103*t90*t92+1.0d+0*rhoa*t43*t46*t52*t58
     1           +5.0d-1*rhob*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-3.04966d-3*t103*t105*t90*t96+t163*t92-5
     1           .15088d-3*rhoa*t105*t43*t46*t55*t58+1.25d-1*gammaaa*t43
     2           *t44*t45*t52*t58+t119*t52)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (3.04966d-52*t103*t176*t90*t96+t191*t92+2
     1           .57544d-52*t1*t15*t29*t7+t178*t4)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (-3.04966d-3*t103*t47*t90*t96+1.0d+0*t19
     1           4*t90*t92-5.15088d-3*t43*t46*t49*t55*t58-1.25d-1*t43*t4
     2           5*t52*t58+1.0d+0*rhoa*t193*t43*t46*t52)*wght+Cmat(iq,D1
     3           _GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (-6.09932d-3*t103*t49*t90*t96+1.0d+0*t200
     1           *t90*t92-1.030176d-2*t30*t43*t46*t55*t58+1.25d-1*gammaa
     2           a*t199*t43*t52*t58+1.0d+0*rhoa*t197*t43*t46*t52)*wght+M
     3           mat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t92*(1.0d+0*t90*(1.7777777777777778d
     1           +1*t104*t96*t98*t99*taua+8.132426666666668d-2*t105*t120
     2           *t47*t98*t99*taua+8.88888888888889d+0*t104*t94*t96*t97*
     3           taua+1.7777777777777778d+1*gammaaa*t107*t96*t97*taua+4.
     4           066213333333334d-2*t105*t120*t47*t94*t97*taua+2.0331066
     5           66666667d-2*t102*t105*t47*t96*taua+8.88888888888889d+0*
     6           t102*t104*t92*taua+2.2222222222222224d+1*t198*t54*t96*t
     7           99+5.580255669360001d-5*t100*t201*t213*t99-6.09932d-3*t
     8           100*t120*t205*t99+9.777777777777779d+0*gammaaa*t204*t96
     9           *t97*t98+5.580255669360001d-5*t201*t213*t94*t97*t98-6.0
     :           9932d-3*t120*t205*t94*t97*t98+3.2529706666666663d-2*gam
     ;           maaa*t104*t105*t120*t97*t98-3.04966d-3*t102*t205*t96*t9
     <           8+1.86008522312d-5*t102*t120*t201*t98+1.955555555555555
     =           7d+1*gammaaa*t204*t93*t94*t96-3.04966d-3*t101*t205*t94*
     >           t96+1.4222222222222222d+1*t206*t53*t93*t96+1.6264853333
     ?           333332d-2*gammaaa*t101*t104*t105*t96+5.580255669360001d
     @           -5*t201*t213*t93*t95-6.09932d-3*t120*t205*t93*t95+6.505
     1           941333333333d-2*gammaaa*t104*t105*t120*t93*t94+1.860085
     2           22312d-5*t101*t120*t201*t94+9.777777777777779d+0*gammaa
     3           a*t101*t204*t92)+1.0d+0*t103*(t59*(1.9138549963583074d+
     4           0*t148*t150*t68*t85*t88-5.980796863619711d-2*t248*t63*t
     5           64*t85*t88-4.7846374908957684d-1*t146*t150*t64*t85*t88+
     6           4.7846374908957684d-1*t146*t148*t63*t85*t88+2.032986391
     7           3187946d-2*t150*t159*t68*t88+5.082465978296986d-3*t146*
     8           t159*t63*t88+1.538928840745229d+1*t134*t135*t136*t150*t
     9           64*t68*t85+3.847322101863072d+0*t134*t135*t136*t146*t63
     :           *t64*t85+1.9751631321680768d-2*(t256+t254+t253+t251+t25
     ;           0+t249+1.923661050931536d+0*t248)*t79*t83-9.08759285496
     <           4233d-4*t124*t155*t83-1.1696447245269295d+0*t130*t131*t
     =           132*t155*t79-6.21814d-2*(t256+t254+t253+t251+t250+t249)
     >           *t61*t77+5.495546528376875d-3*t124*t152*t77+2.0d+0*t126
     ?           *t127*t128*t152*t61+t261+t260+t259+t258+t257+t240+t239+
     @           t238+t237+t236+t234+t233+t232+t231+t229+t224+t223+t222)
     1           -4.7846374908957684d-1*t150*t64*t68*t85*t88-1.196159372
     2           7239421d-1*t146*t63*t64*t85*t88+3.9503262643361536d-2*t
     3           155*t79*t83-1.243628d-1*t152*t61*t77-2.220446049250313d
     4           -16*t109*t113*t114*t42-6.101282288702853d-19*t111*t41-2
     5           .0d+0*t115*t116*t117*t38-2.642079786267853d-3*t111*t37+
     6           t220+t219+t218+t217+t216+t215+t214-rhoa*t212)+2.0d+0*t1
     7           21*t162)+t52*(1.0d+0*rhoa*t43*t46*(1.7777777777777778d+
     8           1*t104*t55*t56*t6*taua+1.373568d-1*t105*t106*t47*t56*t6
     9           *taua+3.4339200000000003d-2*t105*t12*t47*t55*taua+2.666
     :           6666666666666d+1*gammaaa*t107*t14*t55*taua+6.8678400000
     ;           00001d-2*gammaaa*t105*t106*t14*t54*taua+8.8888888888888
     <           9d+0*t104*t12*t52*taua-1.030176d-2*t106*t205*t57*t6+1.5
     =           91893886464d-4*t201*t203*t57*t6+2.2222222222222224d+1*t
     >           198*t54*t55*t6-5.15088d-3*t12*t205*t55*t56+9.7777777777
     ?           77779d+0*gammaaa*t14*t204*t55*t56-1.030176d-2*gammaaa*t
     @           106*t14*t205*t47*t56+1.591893886464d-4*gammaaa*t14*t201
     1           *t203*t47*t56+5.30631295488d-5*t106*t12*t201*t56+5.4942
     2           72d-2*gammaaa*t104*t105*t106*t14*t56+3.377777777777778d
     3           +1*t11*t206*t53*t55-5.15088d-3*gammaaa*t13*t205*t47*t55
     4           +2.747136d-2*gammaaa*t104*t105*t13*t55-1.030176d-2*t106
     5           *t11*t205*t53*t54+1.591893886464d-4*t11*t201*t203*t53*t
     6           54+1.0988544d-1*t105*t106*t107*t11*t53+9.77777777777777
     7           9d+0*gammaaa*t13*t204*t52+5.30631295488d-5*gammaaa*t106
     8           *t13*t201*t47)+1.0d+0*rhoa*t212*t46*t58+2.0d+0*t118*t46
     9           *t58+1.25d-1*gammaaa*t118*t44*t45*t58+1.25d-1*gammaaa*t
     :           202*t43*t45*t58+2.0d+0*t108*t43*t46+2.0d+0*rhoa*t108*t1
     ;           18*t46+1.25d-1*gammaaa*t108*t43*t44*t45)+(-3.04966d-3*t
     <           103*t205*t90-3.04966d-3*t105*t121*t90-3.04966d-3*t105*t
     =           163-3.04966d-3*t103*t105*t162)*t96+1.86008522312d-5*t10
     >           3*t120*t201*t90+t55*(-5.15088d-3*rhoa*t205*t43*t46*t58-
     ?           5.15088d-3*t105*t43*t46*t58-5.15088d-3*rhoa*t105*t118*t
     @           46*t58-5.15088d-3*rhoa*t105*t108*t43*t46-5.15088d-3*t10
     1           5*t119)+t44*t45*t52*(1.25d-1*gammaaa*t118*t58+1.25d-1*g
     2           ammaaa*t108*t43)-1.28772d-3*gammaaa*t105*t43*t44*t45*t5
     3           5*t58-1.25d-1*gammaaa*t202*t43*t45*t52*t58+5.3063129548
     4           8d-5*rhoa*t106*t201*t43*t46*t58)*wght+Amat2(iq,D2_RA_RA
     5           )
              Amat2(iq,D2_RA_RB) = (t92*(1.0d+0*t90*(-4.066213333333334d
     1           -51*t120*t176*t47*t98*t99*taua+2.222222222222222d-49*t1
     2           76*t47*t96*t99*taua+2.222222222222222d-49*t176*t47*t96*
     3           t97*taua-2.033106666666667d-51*t120*t176*t47*t94*t97*ta
     4           ua-1.0165533333333335d-51*t102*t176*t47*t96*taua+4.0662
     5           133333333333d-52*t105*t120*t176*t98*t99-5.58025566936d-
     6           54*t100*t105*t176*t213*t99-5.58025566936d-54*t105*t176*
     7           t213*t94*t97*t98+4.0662133333333333d-52*t105*t120*t176*
     8           t97*t98-1.6264853333333332d-51*gammaaa*t104*t120*t176*t
     9           97*t98-1.86008522312d-54*t102*t105*t120*t176*t98+8.8888
     :           88888888888d-50*gammaaa*t104*t176*t96*t97+2.03310666666
     ;           66667d-52*t105*t120*t176*t94*t97+3.555555555555555d-49*
     <           gammaaa*t104*t176*t93*t96+1.0165533333333333d-52*t102*t
     =           105*t176*t96+2.0331066666666667d-52*t101*t105*t176*t96-
     >           8.132426666666666d-52*gammaaa*t101*t104*t176*t96-5.5802
     ?           5566936d-54*t105*t176*t213*t93*t95+8.132426666666667d-5
     @           2*t105*t120*t176*t93*t94-3.2529706666666663d-51*gammaaa
     1           *t104*t120*t176*t93*t94-1.86008522312d-54*t101*t105*t12
     2           0*t176*t94)+1.0d+0*t103*(t59*(7.176956236343652d-1*t255
     3           *t64*t68*t85*t88-5.980796863619711d-2*t262*t63*t64*t85*
     4           t88-2.3923187454478842d-1*t150*t182*t64*t85*t88+2.39231
     5           87454478842d-1*t146*t150*t64*t85*t88+2.3923187454478842
     6           d-1*t148*t182*t63*t85*t88+2.3923187454478842d-1*t146*t1
     7           48*t63*t85*t88+2.541232989148493d-3*t159*t182*t63*t88+2
     8           .541232989148493d-3*t146*t159*t63*t88+1.923661050931536
     9           d+0*t134*t135*t136*t182*t63*t64*t85+1.923661050931536d+
     :           0*t134*t135*t136*t146*t63*t64*t85+1.9751631321680768d-2
     ;           *(t268+t267+t266+t265+t264+t263+1.923661050931536d+0*t2
     <           62+t253)*t79*t83-4.5437964274821163d-4*t124*t187*t83-4.
     =           5437964274821163d-4*t124*t155*t83-5.848223622634647d-1*
     >           t130*t131*t132*t187*t79-5.848223622634647d-1*t130*t131*
     ?           t132*t155*t79-6.21814d-2*(t268+t267+t266+t265+t264+t263
     @           +t253)*t61*t77+2.747773264188437d-3*t124*t185*t77+2.747
     1           773264188437d-3*t124*t152*t77+1.0d+0*t126*t127*t128*t18
     2           5*t61+1.0d+0*t126*t127*t128*t152*t61+t260+t259+t258+t25
     3           7+t240+t239+t238+t237+t236+t234+t233+t232+t231+t229+t22
     4           4+t223+t222)+t220+t219+t218+t217+t216+t215+t214+t189+t1
     5           88+t186+t158+t156+t153)+1.0d+0*t121*t190+1.0d+0*t162*t1
     6           79)+(-3.04966d-3*t105*t179*t90-3.04966d-3*t103*t105*t19
     7           0)*t96+3.04966d-52*t163*t176*t96-1.86008522312d-54*t103
     8           *t105*t120*t176*t90)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t92*(1.0d+0*t90*(1.7777777777777776d
     1           -49*t278*t96*t98*t99-8.132426666666667d-101*t120*t277*t
     2           98*t99+2.222222222222222d-99*t277*t96*t99-1.62648533333
     3           33332d-51*t100*t120*t278*t99+5.580255669359999d-103*t10
     4           0*t213*t277*t99+1.7777777777777776d-49*t278*t96*t97*t98
     5           -1.6264853333333332d-51*t120*t278*t94*t97*t98+5.5802556
     6           69359999d-103*t213*t277*t94*t97*t98-8.132426666666667d-
     7           101*t120*t277*t97*t98-8.132426666666666d-52*t102*t278*t
     8           96*t98+1.86008522312d-103*t102*t120*t277*t98+8.88888888
     9           8888888d-50*t278*t94*t96*t97+4.444444444444444d-99*t277
     :           *t96*t97-4.0662133333333333d-101*t120*t277*t94*t97+3.55
     ;           5555555555555d-49*t278*t93*t94*t96-8.132426666666666d-5
     <           2*t101*t278*t94*t96+8.888888888888888d-99*t277*t93*t96-
     =           2.0331066666666667d-101*t102*t277*t96-4.066213333333333
     >           3d-101*t101*t277*t96-1.6264853333333332d-51*t120*t278*t
     ?           93*t95+5.580255669359999d-103*t213*t277*t93*t95-1.62648
     @           53333333334d-100*t120*t277*t93*t94+1.86008522312d-103*t
     1           101*t120*t277*t94+8.888888888888888d-50*t102*t278*t92+1
     2           .7777777777777776d-49*t101*t278*t92)+1.0d+0*t103*(t59*(
     3           -1.9138549963583074d+0*t148*t150*t68*t85*t88-5.98079686
     4           3619711d-2*t279*t63*t64*t85*t88+4.7846374908957684d-1*t
     5           150*t182*t64*t85*t88+4.7846374908957684d-1*t148*t182*t6
     6           3*t85*t88-2.0329863913187946d-2*t150*t159*t68*t88+5.082
     7           465978296986d-3*t159*t182*t63*t88-1.538928840745229d+1*
     8           t134*t135*t136*t150*t64*t68*t85+3.847322101863072d+0*t1
     9           34*t135*t136*t182*t63*t64*t85+1.9751631321680768d-2*(t2
     :           83+t282+t281+t280+1.923661050931536d+0*t279+t256+t253)*
     ;           t79*t83-9.087592854964233d-4*t124*t187*t83-1.1696447245
     <           269295d+0*t130*t131*t132*t187*t79-6.21814d-2*(t283+t282
     =           +t281+t280+t256+t253)*t61*t77+5.495546528376875d-3*t124
     >           *t185*t77+2.0d+0*t126*t127*t128*t185*t61+t261+t260+t259
     ?           +t258+t257+t240+t239+t238+t237+t236+t234+t233+t232+t231
     @           +t229+t224+t223+t222)+4.7846374908957684d-1*t150*t64*t6
     1           8*t85*t88-1.1961593727239421d-1*t182*t63*t64*t85*t88+3.
     2           9503262643361536d-2*t187*t79*t83-1.243628d-1*t185*t61*t
     3           77-2.220446049250313d-16*t164*t168*t169*t28-rhob*t274-6
     4           .101282288702853d-19*t166*t27-2.0d+0*t170*t171*t172*t24
     5           -2.642079786267853d-3*t166*t23+t220+t219+t218+t217+t216
     6           +t215+t214)+2.0d+0*t179*t190)+t176*(3.04966d-52*t179*t9
     7           0+3.04966d-52*t191+3.04966d-52*t103*t190)*t96-8.1324266
     8           66666666d-52*t103*t278*t90*t96+1.86008522312d-103*t103*
     9           t120*t277*t90+t4*(5.0d-1*rhob*t29*(1.7777777777777776d-
     :           49*t278*t6*t7*t9+1.7777777777777776d-49*t14*t278*t7*t9-
     ;           1.373568d-51*t12*t278*t7*t9-1.373568d-100*t174*t277*t6*
     <           t9-2.4724223999999997d-100*t14*t174*t277*t9+5.306312954
     =           879999d-103*t12*t174*t277*t9+6.367575545855999d-152*t14
     >           *t275*t276*t9+2.222222222222222d-99*t277*t6*t7+8.0d-99*
     ?           t14*t277*t7-1.2362111999999999d-100*t13*t277*t7-3.43392
     @           d-101*t12*t277*t7+2.3111111111111113d-98*t11*t277*t7-2.
     1           747136d-51*t10*t174*t278*t6+1.5918938864639998d-102*t10
     2           *t275*t277*t6+1.7777777777777776d-49*t13*t278*t4+8.8888
     3           88888888888d-50*t12*t278*t4-2.7471359999999995d-150*t14
     4           *t174*t276+2.1225251819519997d-152*t13*t174*t276-1.5383
     5           9616d-149*t11*t174*t276+2.5470302183424d-201*t11*t275/r
     6           hob**8.666666666666666d+0)+1.0d+0*t177*t29+5.0d-1*rhob*
     7           t15*t274+1.0d+0*rhob*t173*t177+1.0d+0*t15*t173)+t1*(2.5
     8           7544d-52*t177*t29+2.57544d-52*t15*t173)*t7+t176*(5.1508
     9           8d-52*t178-4.2923999999999995d-52*t15*t29)*t7+2.6531564
     :           774399996d-103*t15*t174*t175*t29)*wght+Amat2(iq,D2_RB_R
     ;           B)
              Cmat2(iq,D2_RA_GAA) = (t92*(1.0d+0*t90*(4.066213333333334d
     1           -2*t120*t54*t98*t99*taua-3.3333333333333337d+0*t54*t96*
     2           t97*taua+2.033106666666667d-2*t120*t54*t94*t97*taua+1.0
     3           165533333333335d-2*t102*t54*t96*taua+5.580255669360001d
     4           -5*t100*t105*t213*t47*t99+1.6264853333333332d-2*t100*t1
     5           04*t120*t99-2.6666666666666666d+0*t104*t96*t97*t98+5.58
     6           0255669360001d-5*t105*t213*t47*t94*t97*t98+1.6264853333
     7           333332d-2*t104*t120*t94*t97*t98-6.09932d-3*t105*t120*t4
     8           7*t97*t98+1.6264853333333332d-2*gammaaa*t107*t120*t97*t
     9           98+8.132426666666667d-3*t102*t104*t96*t98+1.86008522312
     :           d-5*t102*t105*t120*t47*t98-5.333333333333333d+0*t104*t9
     ;           3*t94*t96+8.132426666666667d-3*t101*t104*t94*t96-5.3333
     <           33333333333d+0*gammaaa*t107*t93*t96-3.04966d-3*t101*t10
     =           5*t47*t96+8.132426666666667d-3*gammaaa*t101*t107*t96+5.
     >           580255669360001d-5*t105*t213*t47*t93*t95+1.626485333333
     ?           3332d-2*t104*t120*t93*t95-1.219864d-2*t105*t120*t47*t93
     @           *t94+3.2529706666666663d-2*gammaaa*t107*t120*t93*t94+1.
     1           86008522312d-5*t101*t105*t120*t47*t94-2.666666666666666
     2           6d+0*t101*t104*t92)+1.0d+0*t162*t194)+t52*(1.0d+0*rhoa*
     3           t43*t46*(6.867840000000001d-2*t106*t54*t56*t6*taua-3.33
     4           33333333333337d+0*t14*t54*t55*taua+1.7169600000000002d-
     5           2*t12*t54*t55*taua+3.4339200000000003d-2*gammaaa*t106*t
     6           14*t192*taua+1.591893886464d-4*t105*t203*t47*t57*t6+2.7
     7           47136d-2*t104*t106*t57*t6-2.6666666666666666d+0*t104*t1
     8           4*t55*t56+1.373568d-2*t104*t12*t55*t56+1.591893886464d-
     9           4*gammaaa*t105*t14*t203*t54*t56-1.030176d-2*t105*t106*t
     :           14*t47*t56+5.30631295488d-5*t105*t106*t12*t47*t56+5.494
     ;           272d-2*gammaaa*t106*t107*t14*t56-5.15088d-3*t105*t13*t4
     <           7*t55+2.747136d-2*gammaaa*t107*t13*t55-1.06666666666666
     =           66d+1*gammaaa*t107*t11*t55+5.30631295488d-5*gammaaa*t10
     >           5*t106*t13*t54-2.060352d-2*gammaaa*t105*t106*t11*t54+1.
     ?           591893886464d-4*t105*t11*t192*t203*t53+8.241408d-2*t106
     @           *t11*t53/rhoa**9-2.6666666666666666d+0*t104*t13*t52)-1.
     1           25d-1*t43*t44*t45*t58-1.25d-1*t118*t45*t58+1.0d+0*t193*
     2           t43*t46+1.0d+0*rhoa*t118*t193*t46-1.25d-1*t108*t43*t45)
     3           -3.04966d-3*t105*t194*t90*t96+8.132426666666667d-3*t103
     4           *t104*t90*t96-3.04966d-3*t163*t47*t96+1.86008522312d-5*
     5           t103*t105*t120*t47*t90+t47*t55*(1.373568d-2*t43*t46*t58
     6           -5.15088d-3*t119)+6.4386d-4*t105*t43*t45*t55*t58-6.4386
     7           d-4*gammaaa*t104*t43*t45*t55*t58+5.30631295488d-5*t105*
     8           t106*t43*t46*t49*t58-5.15088d-3*rhoa*t105*t193*t43*t46*
     9           t55+t284*t44*t45*t52)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (t92*(1.0d+0*t90*(4.0662133333333333
     1           d-52*t120*t176*t47*t98*t99-5.580255669360001d-54*t100*t
     2           176*t213*t47*t99-5.580255669360001d-54*t176*t213*t47*t9
     3           4*t97*t98+1.0165533333333333d-51*t120*t176*t47*t97*t98-
     4           1.86008522312d-54*t102*t120*t176*t47*t98-3.333333333333
     5           333d-50*t176*t47*t96*t97+2.0331066666666667d-52*t120*t1
     6           76*t47*t94*t97-1.3333333333333333d-49*t176*t47*t93*t96+
     7           1.0165533333333333d-52*t102*t176*t47*t96+5.082766666666
     8           666d-52*t101*t176*t47*t96-5.580255669360001d-54*t176*t2
     9           13*t47*t93*t95+2.0331066666666667d-51*t120*t176*t47*t93
     :           *t94-1.86008522312d-54*t101*t120*t176*t47*t94)+1.0d+0*t
     ;           190*t194)+3.04966d-52*t176*t194*t90*t96-3.04966d-3*t191
     <           *t47*t96-1.86008522312d-54*t103*t120*t176*t47*t90)*wght
     =           +Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t90*t92*(5.580255669360001d
     1           -5*t100*t213*t54*t99+5.580255669360001d-5*t213*t54*t94*
     2           t97*t98-1.219864d-2*t120*t54*t97*t98+1.86008522312d-5*t
     3           102*t120*t54*t98+2*t54*t93*t96-6.09932d-3*t101*t54*t96+
     4           5.580255669360001d-5*t213*t54*t93*t95-2.439728d-2*t120*
     5           t54*t93*t94+1.86008522312d-5*t101*t120*t54*t94)-6.09932
     6           d-3*t194*t47*t90*t96+1.86008522312d-5*t103*t120*t54*t90
     7           +1.0d+0*rhoa*t43*t46*t52*(1.591893886464d-4*t203*t54*t5
     8           7*t6-2.060352d-2*t106*t14*t54*t56+5.30631295488d-5*t106
     9           *t12*t54*t56+1.591893886464d-4*gammaaa*t14*t192*t203*t5
     :           6-1.030176d-2*t13*t54*t55+2*t11*t54*t55+1.591893886464d
     ;           -4*t11*t203*t53/rhoa**1.0666666666666666d+1+5.306312954
     <           88d-5*gammaaa*t106*t13*t192-4.120704d-2*gammaaa*t106*t1
     =           1*t192)+1.28772d-3*t43*t45*t47*t55*t58+5.30631295488d-5
     >           *t106*t196*t43*t46*t58-1.030176d-2*t193*t43*t46*t49*t55
     ?           -2.5d-1*t193*t43*t45*t52)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t92*(1.0d+0*t90*(8.132426666666668d-
     1           2*t120*t196*t98*t99*taua-1.3333333333333333d+1*t196*t96
     2           *t99*taua+4.066213333333334d-2*t120*t196*t94*t97*taua+2
     3           .033106666666667d-2*t102*t196*t96*taua-6.66666666666666
     4           7d+0*t47*t96*t98*t99-2.439728d-2*t105*t120*t49*t98*t99+
     5           1.1160511338720001d-4*t100*t105*t213*t49*t99+2.03310666
     6           6666667d-2*t100*t120*t47*t99+1.1160511338720001d-4*t105
     7           *t213*t49*t94*t97*t98+2.033106666666667d-2*t120*t47*t94
     8           *t97*t98+3.2529706666666663d-2*gammaaa*t120*t54*t97*t98
     9           +1.0165533333333335d-2*t102*t47*t96*t98+3.72017044624d-
     :           5*t102*t105*t120*t49*t98-3.3333333333333337d+0*t47*t94*
     ;           t96*t97-5.333333333333333d+0*gammaaa*t54*t96*t97-1.2198
     <           64d-2*t105*t120*t49*t94*t97+1.0165533333333335d-2*t101*
     =           t47*t94*t96+1.6264853333333332d-2*gammaaa*t101*t54*t96-
     >           6.09932d-3*t102*t105*t49*t96+1.1160511338720001d-4*t105
     ?           *t213*t49*t93*t95+2.033106666666667d-2*t120*t47*t93*t95
     @           +6.505941333333333d-2*gammaaa*t120*t54*t93*t94+3.720170
     1           44624d-5*t101*t105*t120*t49*t94-3.3333333333333337d+0*t
     2           102*t47*t92)+1.0d+0*t162*t200)+t52*(1.0d+0*rhoa*t43*t46
     3           *(1.373568d-1*t106*t196*t56*t6*taua-1.3333333333333333d
     4           +1*t196*t55*t6*taua+3.4339200000000003d-2*t12*t196*t55*
     5           taua+6.867840000000001d-2*gammaaa*t106*t14*t195*taua+3.
     6           183787772928d-4*t105*t203*t49*t57*t6+3.4339200000000003
     7           d-2*t106*t47*t57*t6-6.666666666666667d+0*t47*t55*t56*t6
     8           -4.120704d-2*t105*t106*t49*t56*t6+1.7169600000000002d-2
     9           *t12*t47*t55*t56+8.928192d-2*gammaaa*t106*t14*t54*t56+1
     :           .061262590976d-4*t105*t106*t12*t49*t56+3.183787772928d-
     ;           4*gammaaa*t105*t14*t196*t203*t56-8.666666666666666d+0*g
     <           ammaaa*t14*t54*t55+4.464096d-2*gammaaa*t13*t54*t55-1.03
     =           0176d-2*t105*t12*t49*t55+3.183787772928d-4*t105*t11*t19
     >           5*t203*t53+1.4422464000000002d-1*t106*t11*t192*t53-3.33
     ?           33333333333337d+0*t12*t47*t52-2.060352d-2*gammaaa*t105*
     @           t106*t14*t196+1.061262590976d-4*gammaaa*t105*t106*t13*t
     1           196)+1.25d-1*gammaaa*t199*t43*t44*t58+1.25d-1*gammaaa*t
     2           118*t199*t58+1.0d+0*t197*t43*t46+1.0d+0*rhoa*t118*t197*
     3           t46+1.25d-1*gammaaa*t108*t199*t43)+1.0165533333333335d-
     4           2*t103*t47*t90*t96-3.04966d-3*t105*t200*t90*t96-6.09932
     5           d-3*t163*t49*t96+3.72017044624d-5*t103*t105*t120*t49*t9
     6           0+t49*t55*(1.7169600000000002d-2*t43*t46*t58-1.030176d-
     7           2*t119)-1.28772d-3*gammaaa*t43*t45*t47*t55*t58-6.4386d-
     8           4*gammaaa*t105*t199*t43*t55*t58-1.25d-1*gammaaa*t199*t4
     9           3*t44*t52*t58+1.061262590976d-4*t105*t106*t30*t43*t46*t
     :           58-5.15088d-3*rhoa*t105*t197*t43*t46*t55+1.25d-1*gammaa
     ;           a*t197*t43*t44*t45*t52)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = (t92*(1.0d+0*t90*(3.252970666666667d-
     1           51*t120*t176*t49*t98*t99-1.3333333333333333d-49*t176*t4
     2           9*t96*t99-1.1160511338720003d-53*t100*t176*t213*t49*t99
     3           -1.1160511338720003d-53*t176*t213*t49*t94*t97*t98+8.132
     4           426666666667d-52*t120*t176*t49*t97*t98-3.72017044624d-5
     5           4*t102*t120*t176*t49*t98-1.3333333333333333d-49*t176*t4
     6           9*t96*t97+1.6264853333333334d-51*t120*t176*t49*t94*t97+
     7           8.132426666666667d-52*t102*t176*t49*t96+4.0662133333333
     8           333d-52*t101*t176*t49*t96-1.1160511338720003d-53*t176*t
     9           213*t49*t93*t95+1.6264853333333334d-51*t120*t176*t49*t9
     :           3*t94-3.72017044624d-54*t101*t120*t176*t49*t94)+1.0d+0*
     ;           t190*t200)+3.04966d-52*t176*t200*t90*t96-6.09932d-3*t19
     <           1*t49*t96-3.72017044624d-54*t103*t120*t176*t49*t90)*wgh
     =           t+Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*t90*t92*(-2.439728d-2*t120*t
     1           196*t98*t99+1.1160511338720001d-4*t100*t196*t213*t99+1.
     2           1160511338720001d-4*t196*t213*t94*t97*t98-1.219864d-2*t
     3           120*t196*t97*t98+3.72017044624d-5*t102*t120*t196*t98+2.
     4           0d+0*t196*t96*t97-1.219864d-2*t120*t196*t94*t97-6.09932
     5           d-3*t102*t196*t96-6.09932d-3*t101*t196*t96+1.1160511338
     6           720001d-4*t196*t213*t93*t95-2.439728d-2*t120*t196*t93*t
     7           94+3.72017044624d-5*t101*t120*t196*t94)-6.09932d-3*t194
     8           *t49*t90*t96-3.04966d-3*t200*t47*t90*t96+3.72017044624d
     9           -5*t103*t120*t196*t90+1.0d+0*rhoa*t43*t46*t52*(3.183787
     :           772928d-4*t196*t203*t57*t6-4.120704d-2*t106*t196*t56*t6
     ;           +3.183787772928d-4*gammaaa*t14*t195*t203*t56-2.060352d-
     <           2*t106*t14*t196*t56+1.061262590976d-4*t106*t12*t196*t56
     =           +2.0d+0*t14*t196*t55-1.030176d-2*t13*t196*t55-1.030176d
     >           -2*t12*t196*t55+3.183787772928d-4*t11*t203*t53/rhoa**9.
     ?           666666666666666d+0-2.060352d-2*gammaaa*t106*t14*t195+1.
     @           061262590976d-4*gammaaa*t106*t13*t195-4.120704d-2*gamma
     1           aa*t106*t11*t195)+1.28772d-3*t43*t45*t49*t55*t58-6.4386
     2           d-4*gammaaa*t199*t43*t47*t55*t58+1.061262590976d-4*t106
     3           *t285*t43*t46*t58-5.15088d-3*t197*t43*t46*t49*t55-1.030
     4           176d-2*t193*t30*t43*t46*t55-1.25d-1*t197*t43*t45*t52+t1
     5           99*t284*t52)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (-2.5d-1*gammaaa*t43*t52*t58/taua**3+
     1           1.0d+0*t90*t92*(-9.758912d-2*t120*t285*t98*t99+8.0d+0*t
     2           285*t96*t99+2.2321022677440003d-4*t100*t213*t285*t99+2.
     3           2321022677440003d-4*t213*t285*t94*t97*t98+7.44034089248
     4           d-5*t102*t120*t285*t98-4.879456d-2*t120*t285*t94*t97-2.
     5           439728d-2*t102*t285*t96+2.2321022677440003d-4*t213*t285
     6           *t93*t95+7.44034089248d-5*t101*t120*t285*t94)-1.219864d
     7           -2*t200*t49*t90*t96+7.44034089248d-5*t103*t120*t285*t90
     8           +1.0d+0*rhoa*t43*t46*t52*(6.367575545856d-4*t203*t285*t
     9           57*t6-1.6482816d-1*t106*t285*t56*t6+8.0d+0*t285*t55*t6+
     :           6.367575545856d-4*gammaaa*t14*t203*t286*t56+2.122525181
     ;           952d-4*t106*t12*t285*t56-4.120704d-2*t12*t285*t55+6.367
     <           575545856d-4*t11*t203*t53/rhoa**8.666666666666666d+0-8.
     =           241408d-2*gammaaa*t106*t14*t286+2.122525181952d-4*gamma
     >           aa*t106*t13*t286)-2.57544d-3*gammaaa*t199*t43*t49*t55*t
     ?           58+2.122525181952d-4*t106*t209*t43*t46*t58-2.060352d-2*
     @           t197*t30*t43*t46*t55+2.5d-1*gammaaa*t197*t199*t43*t52)*
     1           wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhoa**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhoa**6.666666666666666d-1
              t17 = rhoa**5.0d-1
              t18 = 1/t17
              t19 = 1/rhoa**3.333333333333333d-1
              t20 = 1/rhoa**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = 1/rhob**6.666666666666666d-1
              t31 = rhob**5.0d-1
              t32 = 1/t31
              t33 = 1/rhob**3.333333333333333d-1
              t34 = 1/rhob**1.6666666666666666d-1
              t35 = 1.1120374863094686d+1*t34+3.8447462374472113d+0*t33+
     1           1.644733775567609d+0*t32+2.4058712912881916d-1*t30
              t36 = 3.216395899738507d+1/t35+1.0d+0
              t37 = log(t36)
              t38 = 1.274696188700087d-1*t33+1.0d+0
              t39 = 5.982550435771079d+0*t34+2.2255694211506874d+0*t33+8
     1           .004286349993635d-1*t32+1.8970043257475583d-1*t30
              t40 = 1.6081979498692536d+1/t39+1.0d+0
              t41 = log(t40)
              t42 = 1.3256889990520176d-1*t33+1.0d+0
              t43 = -6.903522198342671d-18*t41*t42-3.1090699999999993d-2
     1           *t37*t38
              t44 = 1/rhob
              t45 = 1/taub
              t46 = 1.0d+0-1.25d-1*gammabb*t44*t45
              t47 = 1/rhob**2.6666666666666666d+0
              t48 = gammabb*t47
              t49 = 1/rhob**1.6666666666666669d+0
              t50 = 2.0d+0*t49*taub
              t51 = 5.15088d-3*(t50+t48-9.11559972d+0)+1.0d+0
              t52 = 1/t51
              t53 = gammabb**2
              t54 = 1/rhob**5.333333333333333d+0
              t55 = 1/t51**2
              t56 = t50-9.11559972d+0
              t57 = t56**2
              t58 = t55*t57*t6+gammabb*t14*t47*t55*t56+t12*t52*t56+t11*t
     1           53*t54*t55+gammabb*t13*t47*t52+t5
              t59 = rhob+rhoa
              t60 = 1/t59**3.333333333333333d-1
              t61 = 1.3256889990520176d-1*t60+1.0d+0
              t62 = rhoa-rhob
              t63 = t62**4
              t64 = 1/t59**4
              t65 = 1/t59
              t66 = 1.0d+0-t62*t65
              t67 = t62*t65+1.0d+0
              t68 = t67**1.3333333333333333d+0+t66**1.3333333333333333d+
     1           0-2.0d+0
              t69 = -1.923661050931536d+0*t63*t64*t68
              t70 = t69+1.0d+0
              t71 = 1/t59**6.666666666666666d-1
              t72 = t59**5.0d-1
              t73 = 1/t72
              t74 = 1/t59**1.6666666666666666d-1
              t75 = 5.982550435771079d+0*t74+8.004286349993635d-1*t73+1.
     1           8970043257475583d-1*t71+2.2255694211506874d+0*t60
              t76 = 1.6081979498692536d+1/t75+1.0d+0
              t77 = log(t76)
              t78 = -6.21814d-2*t61*t70*t77
              t79 = 6.901399211255825d-2*t60+1.0d+0
              t80 = t69+1.923661050931536d+0*t68
              t81 = 8.157414703487641d+0*t74+4.3009724712766434d-1*t73+1
     1           .9115125951273373d-1*t71+2.247591863577616d+0*t60
              t82 = 2.9608813203268075d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = 1.9751631321680768d-2*t79*t80*t83
              t85 = 1.274696188700087d-1*t60+1.0d+0
              t86 = 1.1120374863094686d+1*t74+1.644733775567609d+0*t73+2
     1           .4058712912881916d-1*t71+3.8447462374472113d+0*t60
              t87 = 3.216395899738507d+1/t86+1.0d+0
              t88 = log(t87)
              t89 = -5.980796863619711d-2*t63*t64*t68*t85*t88
              t90 = t59*(t89+t84+t78)-rhob*t43-rhoa*t29
              t91 = 3.04966d-3*(t50+t48+t2-1.823119944d+1)+1.0d+0
              t92 = 1/t91
              t93 = param(4)
              t94 = t48+4.0d-50*t1
              t95 = t94**2
              t96 = 1/t91**2
              t97 = param(5)
              t98 = t8+t50-1.823119944d+1
              t99 = param(6)
              t100 = t98**2
              t101 = param(2)
              t102 = param(3)
              t103 = t100*t96*t99+t94*t96*t97*t98+t102*t92*t98+t93*t95*t
     1           96+t101*t92*t94+param(1)
              t104 = 1/t26
              t105 = 1/t17**3
              t106 = 1/rhoa**1.3333333333333333d+0
              t107 = 1/rhoa**1.1666666666666667d+0
              t108 = -9.970917392951799d-1*t107-7.418564737168958d-1*t10
     1           6-4.002143174996817d-1*t105-1.264669550498372d-1*t1
              t109 = 1/t25**2
              t110 = 1/t22
              t111 = -1.8533958105157808d+0*t107-1.2815820791490704d+0*t
     1           106-8.223668877838045d-1*t105-1.6039141941921276d-1*t1
              t112 = 1/t21**2
              t113 = 1.1102230246251565d-16*t104*t108*t109*t28+3.0506411
     1           443514264d-19*t106*t27+1.0d+0*t110*t111*t112*t24+1.3210
     2           398931339265d-3*t106*t23
              t114 = 1/t3**3
              t115 = 1/rhoa**4.333333333333333d+0
              t116 = 1/rhoa**2.6666666666666666d+0
              t117 = -6.666666666666666d-50*t116*t6*t7*t9-6.666666666666
     1           666d-50*t116*t14*t7*t9+5.15088d-52*t116*t12*t7*t9+4.120
     2           7039999999995d-101*t114*t115*t14*t9-1.3333333333333333d
     3           -99*t115*t14*t7+2.0603519999999997d-101*t115*t13*t7-5.3
     4           33333333333334d-99*t11*t115*t7+1.030176d-51*t10*t114*t1
     5           16*t6-6.666666666666666d-50*t116*t13*t4-3.3333333333333
     6           33d-50*t116*t12*t4+1.6482816d-150*t11*t114/rhoa**6
              t118 = 5.0d-1*t15*t29+5.0d-1*rhoa*t117*t29+5.0d-1*rhoa*t11
     1           3*t15
              t119 = 1/t91**3
              t120 = -6.666666666666666d-50*t116*t96*t98*t99+6.09932d-52
     1           *t100*t116*t119*t99-6.666666666666666d-50*t116*t96*t97*
     2           t98+6.09932d-52*t116*t119*t94*t97*t98+3.04966d-52*t102*
     3           t116*t96*t98-3.333333333333333d-50*t116*t94*t96*t97-1.3
     4           333333333333333d-49*t116*t93*t94*t96+3.04966d-52*t101*t
     5           116*t94*t96+6.09932d-52*t116*t119*t93*t95-3.33333333333
     6           3333d-50*t102*t116*t92-6.666666666666666d-50*t101*t116*
     7           t92
              t121 = 1/t59**1.6666666666666669d+0
              t122 = 1/t72**3
              t123 = 1/t59**1.3333333333333333d+0
              t124 = 1/t59**1.1666666666666667d+0
              t125 = -9.970917392951799d-1*t124-7.418564737168958d-1*t12
     1           3-4.002143174996817d-1*t122-1.264669550498372d-1*t121
              t126 = 1/t75**2
              t127 = 1/t76
              t128 = 1.0d+0*t125*t126*t127*t61*t70
              t129 = -1.3595691172479402d+0*t124-7.491972878592053d-1*t1
     1           23-2.1504862356383217d-1*t122-1.2743417300848914d-1*t12
     2           1
              t130 = 1/t81**2
              t131 = 1/t82
              t132 = -5.848223622634647d-1*t129*t130*t131*t79*t80
              t133 = -1.8533958105157808d+0*t124-1.2815820791490704d+0*t
     1           123-8.223668877838045d-1*t122-1.6039141941921276d-1*t12
     2           1
              t134 = 1/t86**2
              t135 = 1/t87
              t136 = 1.923661050931536d+0*t133*t134*t135*t63*t64*t68*t85
              t137 = 1/t59**2
              t138 = t137*t62
              t139 = -t65
              t140 = t139+t138
              t141 = t66**3.333333333333333d-1
              t142 = -t137*t62
              t143 = t65+t142
              t144 = t67**3.333333333333333d-1
              t145 = 1.3333333333333333d+0*t143*t144+1.3333333333333333d
     1           +0*t140*t141
              t146 = -1.923661050931536d+0*t145*t63*t64
              t147 = 1/t59**5
              t148 = 7.694644203726144d+0*t147*t63*t68
              t149 = t62**3
              t150 = -7.694644203726144d+0*t149*t64*t68
              t151 = t150+t148+t146
              t152 = -6.21814d-2*t151*t61*t77
              t153 = 2.747773264188437d-3*t123*t70*t77
              t154 = t150+t148+t146+1.923661050931536d+0*t145
              t155 = 1.9751631321680768d-2*t154*t79*t83
              t156 = -4.5437964274821163d-4*t123*t80*t83
              t157 = -5.980796863619711d-2*t145*t63*t64*t85*t88
              t158 = 1/t59**5.333333333333333d+0
              t159 = 2.541232989148493d-3*t158*t63*t68*t88
              t160 = 2.3923187454478842d-1*t147*t63*t68*t85*t88
              t161 = t89+t59*(-2.3923187454478842d-1*t149*t64*t68*t85*t8
     1           8+t160+t159+t157+t156+t155+t153+t152+t136+t132+t128)+t8
     2           4+t78+6.903522198342671d-18*t27*t28+3.1090699999999993d
     3           -2*t23*t24-rhoa*t113
              t162 = 1.0d+0*t120*t90+1.0d+0*t103*t161
              t163 = 1/rhob**3.6666666666666664d+0
              t164 = -3.3333333333333337d+0*t47*taub-2.6666666666666666d
     1           +0*gammabb*t163
              t165 = 1/t51**3
              t166 = 1/rhob**6.333333333333333d+0
              t167 = -6.666666666666667d+0*t47*t55*t56*t6*taub-3.3333333
     1           333333337d+0*gammabb*t14*t54*t55*taub-3.333333333333333
     2           7d+0*t12*t47*t52*taub-1.030176d-2*t164*t165*t57*t6-5.15
     3           088d-3*t12*t164*t55*t56-2.6666666666666666d+0*gammabb*t
     4           14*t163*t55*t56-1.030176d-2*gammabb*t14*t164*t165*t47*t
     5           56-5.333333333333333d+0*t11*t166*t53*t55-5.15088d-3*gam
     6           mabb*t13*t164*t47*t55-1.030176d-2*t11*t164*t165*t53*t54
     7           -2.6666666666666666d+0*gammabb*t13*t163*t52
              t168 = 1/t40
              t169 = 1/t31**3
              t170 = 1/rhob**1.3333333333333333d+0
              t171 = 1/rhob**1.1666666666666667d+0
              t172 = -1.264669550498372d-1*t49-9.970917392951799d-1*t171
     1           -7.418564737168958d-1*t170-4.002143174996817d-1*t169
              t173 = 1/t39**2
              t174 = 1/t36
              t175 = -1.6039141941921276d-1*t49-1.8533958105157808d+0*t1
     1           71-1.2815820791490704d+0*t170-8.223668877838045d-1*t169
              t176 = 1/t35**2
              t177 = 1.1102230246251565d-16*t168*t172*t173*t42+3.0506411
     1           443514264d-19*t170*t41+1.0d+0*t174*t175*t176*t38+1.3210
     2           398931339265d-3*t170*t37
              t178 = 1.0d+0*t43*t46*t58+1.0d+0*rhob*t177*t46*t58+1.0d+0*
     1           rhob*t167*t43*t46
              t179 = -6.666666666666667d+0*t47*t96*t98*t99*taub-3.333333
     1           3333333337d+0*t47*t94*t96*t97*taub-3.3333333333333337d+
     2           0*t102*t47*t92*taub-6.09932d-3*t100*t119*t164*t99-2.666
     3           6666666666666d+0*gammabb*t163*t96*t97*t98-6.09932d-3*t1
     4           19*t164*t94*t97*t98-3.04966d-3*t102*t164*t96*t98-5.3333
     5           33333333333d+0*gammabb*t163*t93*t94*t96-3.04966d-3*t101
     6           *t164*t94*t96-6.09932d-3*t119*t164*t93*t95-2.6666666666
     7           666666d+0*gammabb*t101*t163*t92
              t180 = t65+t138
              t181 = t142+t139
              t182 = 1.3333333333333333d+0*t144*t181+1.3333333333333333d
     1           +0*t141*t180
              t183 = -1.923661050931536d+0*t182*t63*t64
              t184 = 7.694644203726144d+0*t149*t64*t68
              t185 = t184+t183+t148
              t186 = -6.21814d-2*t185*t61*t77
              t187 = t184+t183+1.923661050931536d+0*t182+t148
              t188 = 1.9751631321680768d-2*t187*t79*t83
              t189 = -5.980796863619711d-2*t182*t63*t64*t85*t88
              t190 = t89+t59*(2.3923187454478842d-1*t149*t64*t68*t85*t88
     1           +t189+t188+t186+t160+t159+t156+t153+t136+t132+t128)+t84
     2           +t78+6.903522198342671d-18*t41*t42+3.1090699999999993d-
     3           2*t37*t38-rhob*t177
              t191 = 1.0d+0*t179*t90+1.0d+0*t103*t190
              t192 = 1/rhob**8
              t193 = -1.030176d-2*t165*t47*t57*t6+t14*t47*t55*t56-5.1508
     1           8d-3*t12*t47*t55*t56-1.030176d-2*gammabb*t14*t165*t54*t
     2           56-5.15088d-3*gammabb*t13*t54*t55+2*gammabb*t11*t54*t55
     3           -1.030176d-2*t11*t165*t192*t53+t13*t47*t52
              t194 = -6.09932d-3*t100*t119*t47*t99+t47*t96*t97*t98-6.099
     1           32d-3*t119*t47*t94*t97*t98-3.04966d-3*t102*t47*t96*t98+
     2           2*t47*t93*t94*t96-3.04966d-3*t101*t47*t94*t96-6.09932d-
     3           3*t119*t47*t93*t95+t101*t47*t92
              t195 = 1/rhob**7
              t196 = 1/rhob**4.333333333333333d+0
              t197 = -2.060352d-2*t165*t49*t57*t6+4.0d+0*t49*t55*t56*t6-
     1           1.030176d-2*t12*t49*t55*t56-2.060352d-2*gammabb*t14*t16
     2           5*t196*t56+2.0d+0*gammabb*t14*t196*t55-1.030176d-2*gamm
     3           abb*t13*t196*t55-2.060352d-2*t11*t165*t195*t53+2.0d+0*t
     4           12*t49*t52
              t198 = taub**2
              t199 = 1/t198
              t200 = 4.0d+0*t49*t96*t98*t99-1.219864d-2*t100*t119*t49*t9
     1           9-1.219864d-2*t119*t49*t94*t97*t98-6.09932d-3*t102*t49*
     2           t96*t98+2.0d+0*t49*t94*t96*t97-6.09932d-3*t101*t49*t94*
     3           t96-1.219864d-2*t119*t49*t93*t95+2.0d+0*t102*t49*t92
              t201 = t108**2
              t202 = 1/t17**5
              t203 = 1/rhoa**2.3333333333333334d+0
              t204 = 1/rhoa**2.1666666666666665d+0
              t205 = t111**2
              t206 = 1.7854583920998188d-15*t201*t28/(t25**4*t26**2)-2.2
     1           20446049250313d-16*t104*t201*t28/t25**3+1.1102230246251
     2           565d-16*t104*t109*(1.1632736958443765d+0*t204+9.8914196
     3           4955861d-1*t203+6.003214762495226d-1*t202+2.10778258416
     4           39536d-1*t116)*t28-4.0675215258019015d-19*t203*t27+3.21
     5           6395899738507d+1*t205*t24/(t21**4*t22**2)-2.0d+0*t110*t
     6           205*t24/t21**3+1.0d+0*t110*t112*(2.1622951122684114d+0*
     7           t204+1.7087761055320938d+0*t203+1.2335503316757068d+0*t
     8           202+2.673190323653546d-1*t116)*t24-1.7613865241785684d-
     9           3*t203*t23-8.497974591333913d-2*t106*t110*t111*t112-9.8
     :           12069668265515d-18*t104*t106*t108*t109
              t207 = 1/t3**4
              t208 = 1/rhoa**7
              t209 = 1/rhoa**5.333333333333333d+0
              t210 = 1/rhoa**3.6666666666666664d+0
              t211 = 1/t91**4
              t212 = 2.0d+0*t125*t126*t127*t61*t70
              t213 = -1.1696447245269295d+0*t129*t130*t131*t79*t80
              t214 = 3.847322101863072d+0*t133*t134*t135*t63*t64*t68*t85
              t215 = 5.495546528376875d-3*t123*t70*t77
              t216 = -9.087592854964233d-4*t123*t80*t83
              t217 = 5.082465978296986d-3*t158*t63*t68*t88
              t218 = 4.7846374908957684d-1*t147*t63*t68*t85*t88
              t219 = t125**2
              t220 = 1.6081979498692536d+1*t219*t61*t70/(t75**4*t76**2)
              t221 = -2.0d+0*t127*t219*t61*t70/t75**3
              t222 = -8.837926660346784d-2*t123*t125*t126*t127*t70
              t223 = 1/t59**2.6666666666666666d+0
              t224 = 1/t72**5
              t225 = 1/t59**2.3333333333333334d+0
              t226 = 1/t59**2.1666666666666665d+0
              t227 = 1.0d+0*t126*t127*(1.1632736958443765d+0*t226+9.8914
     1           1964955861d-1*t225+6.003214762495226d-1*t224+2.10778258
     2           41639536d-1*t223)*t61*t70
              t228 = t129**2
              t229 = -1.73158960813529d+1*t228*t79*t80/(t81**4*t82**2)
              t230 = 1.1696447245269295d+0*t131*t228*t79*t80/t81**3
              t231 = 2.690728393099896d-2*t123*t129*t130*t131*t80
              t232 = -5.848223622634647d-1*t130*t131*(1.5861639701225969
     1           d+0*t226+9.98929717145607d-1*t225+3.2257293534574827d-1
     2           *t224+2.1239028834748191d-1*t223)*t79*t80
              t233 = t133**2
              t234 = 6.187255516702861d+1*t233*t63*t64*t68*t85/(t86**4*t
     1           87**2)
              t235 = -3.847322101863072d+0*t135*t233*t63*t64*t68*t85/t86
     1           **3
              t236 = -1.6347222733154887d-1*t133*t134*t135*t158*t63*t68
              t237 = 1.923661050931536d+0*t134*t135*(2.1622951122684114d
     1           +0*t226+1.7087761055320938d+0*t225+1.2335503316757068d+
     2           0*t224+2.673190323653546d-1*t223)*t63*t64*t68*t85
              t238 = -1.538928840745229d+1*t133*t134*t135*t147*t63*t68*t
     1           85
              t239 = 1/t66**6.666666666666666d-1
              t240 = 1/t59**3
              t241 = -2*t240*t62
              t242 = 2*t137
              t243 = 1/t67**6.666666666666666d-1
              t244 = 2*t240*t62
              t245 = -2*t137
              t246 = 1.3333333333333333d+0*t144*(t245+t244)+4.4444444444
     1           44444d-1*t143**2*t243+1.3333333333333333d+0*t141*(t242+
     2           t241)+4.444444444444444d-1*t140**2*t239
              t247 = -1.923661050931536d+0*t246*t63*t64
              t248 = 1.5389288407452287d+1*t145*t147*t63
              t249 = -1.5389288407452287d+1*t145*t149*t64
              t250 = 1/t59**6
              t251 = -3.8473221018630716d+1*t250*t63*t68
              t252 = 6.155715362980915d+1*t147*t149*t68
              t253 = t62**2
              t254 = -2.3083932611178434d+1*t253*t64*t68
              t255 = -3.663697685584583d-3*t225*t70*t77
              t256 = 6.058395236642822d-4*t225*t80*t83
              t257 = -2.3718174565385935d-2*t63*t68*t88/t59**6.333333333
     1           333333d+0
              t258 = -1.1961593727239421d+0*t250*t63*t68*t85*t88
              t259 = -7.176956236343652d-1*t253*t64*t68*t85*t88
              t260 = 2.6666666666666666d+0*t144*t240*t62-2.6666666666666
     1           666d+0*t141*t240*t62+4.444444444444444d-1*t143*t181*t24
     2           3+4.444444444444444d-1*t140*t180*t239
              t261 = -1.923661050931536d+0*t260*t63*t64
              t262 = 7.694644203726144d+0*t147*t182*t63
              t263 = -7.694644203726144d+0*t149*t182*t64
              t264 = 7.694644203726144d+0*t145*t147*t63
              t265 = 7.694644203726144d+0*t145*t149*t64
              t266 = 2.3083932611178434d+1*t253*t64*t68
              t267 = t164**2
              t268 = 1/rhob**2
              t269 = 1/t51**4
              t270 = 1/rhob**4.666666666666667d+0
              t271 = 8.88888888888889d+0*t163*taub+9.777777777777779d+0*
     1           gammabb*t270
              t272 = 1/rhob**7.333333333333333d+0
              t273 = t172**2
              t274 = 1/t31**5
              t275 = 1/rhob**2.3333333333333334d+0
              t276 = 1/rhob**2.1666666666666665d+0
              t277 = t175**2
              t278 = 1.0d+0*t174*t176*t38*(2.673190323653546d-1*t47+2.16
     1           22951122684114d+0*t276+1.7087761055320938d+0*t275+1.233
     2           5503316757068d+0*t274)+1.1102230246251565d-16*t168*t173
     3           *t42*(2.1077825841639536d-1*t47+1.1632736958443765d+0*t
     4           276+9.89141964955861d-1*t275+6.003214762495226d-1*t274)
     5           +1.7854583920998188d-15*t273*t42/(t39**4*t40**2)-2.2204
     6           46049250313d-16*t168*t273*t42/t39**3-4.0675215258019015
     7           d-19*t275*t41+3.216395899738507d+1*t277*t38/(t35**4*t36
     8           **2)-2.0d+0*t174*t277*t38/t35**3-1.7613865241785684d-3*
     9           t275*t37-8.497974591333913d-2*t170*t174*t175*t176-9.812
     :           069668265515d-18*t168*t170*t172*t173
              t279 = 1.3333333333333333d+0*t141*(t245+t241)+1.3333333333
     1           333333d+0*t144*(t244+t242)+4.444444444444444d-1*t181**2
     2           *t243+4.444444444444444d-1*t180**2*t239
              t280 = -1.923661050931536d+0*t279*t63*t64
              t281 = 1.5389288407452287d+1*t147*t182*t63
              t282 = 1.5389288407452287d+1*t149*t182*t64
              t283 = -6.155715362980915d+1*t147*t149*t68
              t284 = 1.25d-1*t43*t58+1.25d-1*gammabb*t193*t43
              t285 = 1/rhob**3.3333333333333337d+0
              t286 = 1/rhob**6
              fnc(iq) = (1.0d+0*t103*t90*t92+1.0d+0*rhob*t43*t46*t52*t58
     1           +5.0d-1*rhoa*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (3.04966d-52*t103*t116*t90*t96+t162*t92+2
     1           .57544d-52*t1*t15*t29*t7+t118*t4)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-3.04966d-3*t103*t164*t90*t96+t191*t92-5
     1           .15088d-3*rhob*t164*t43*t46*t55*t58+1.25d-1*gammabb*t43
     2           *t44*t45*t52*t58+t178*t52)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (-3.04966d-3*t103*t47*t90*t96+1.0d+0*t19
     1           4*t90*t92-5.15088d-3*t43*t46*t49*t55*t58-1.25d-1*t43*t4
     2           5*t52*t58+1.0d+0*rhob*t193*t43*t46*t52)*wght+Cmat(iq,D1
     3           _GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = (-6.09932d-3*t103*t49*t90*t96+1.0d+0*t200
     1           *t90*t92-1.030176d-2*t30*t43*t46*t55*t58+1.25d-1*gammab
     2           b*t199*t43*t52*t58+1.0d+0*rhob*t197*t43*t46*t52)*wght+M
     3           mat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t92*(1.0d+0*t90*(1.7777777777777776d
     1           -49*t210*t96*t98*t99-8.132426666666667d-101*t119*t209*t
     2           98*t99+2.222222222222222d-99*t209*t96*t99+5.58025566935
     3           9999d-103*t100*t209*t211*t99-1.6264853333333332d-51*t10
     4           0*t119*t210*t99+1.7777777777777776d-49*t210*t96*t97*t98
     5           +5.580255669359999d-103*t209*t211*t94*t97*t98-1.6264853
     6           333333332d-51*t119*t210*t94*t97*t98-8.132426666666667d-
     7           101*t119*t209*t97*t98-8.132426666666666d-52*t102*t210*t
     8           96*t98+1.86008522312d-103*t102*t119*t209*t98+8.88888888
     9           8888888d-50*t210*t94*t96*t97+4.444444444444444d-99*t209
     :           *t96*t97-4.0662133333333333d-101*t119*t209*t94*t97+3.55
     ;           5555555555555d-49*t210*t93*t94*t96-8.132426666666666d-5
     <           2*t101*t210*t94*t96+8.888888888888888d-99*t209*t93*t96-
     =           2.0331066666666667d-101*t102*t209*t96-4.066213333333333
     >           3d-101*t101*t209*t96+5.580255669359999d-103*t209*t211*t
     ?           93*t95-1.6264853333333332d-51*t119*t210*t93*t95-1.62648
     @           53333333334d-100*t119*t209*t93*t94+1.86008522312d-103*t
     1           101*t119*t209*t94+8.888888888888888d-50*t102*t210*t92+1
     2           .7777777777777776d-49*t101*t210*t92)+1.0d+0*t103*(t59*(
     3           1.9138549963583074d+0*t147*t149*t68*t85*t88-5.980796863
     4           619711d-2*t246*t63*t64*t85*t88-4.7846374908957684d-1*t1
     5           45*t149*t64*t85*t88+4.7846374908957684d-1*t145*t147*t63
     6           *t85*t88+2.0329863913187946d-2*t149*t158*t68*t88+5.0824
     7           65978296986d-3*t145*t158*t63*t88+1.538928840745229d+1*t
     8           133*t134*t135*t149*t64*t68*t85+3.847322101863072d+0*t13
     9           3*t134*t135*t145*t63*t64*t85+1.9751631321680768d-2*(t25
     :           4+t252+t251+t249+t248+t247+1.923661050931536d+0*t246)*t
     ;           79*t83-9.087592854964233d-4*t123*t154*t83-1.16964472452
     <           69295d+0*t129*t130*t131*t154*t79-6.21814d-2*(t254+t252+
     =           t251+t249+t248+t247)*t61*t77+5.495546528376875d-3*t123*
     >           t151*t77+2.0d+0*t125*t126*t127*t151*t61+t259+t258+t257+
     ?           t256+t255+t238+t237+t236+t235+t234+t232+t231+t230+t229+
     @           t227+t222+t221+t220)-4.7846374908957684d-1*t149*t64*t68
     1           *t85*t88-1.1961593727239421d-1*t145*t63*t64*t85*t88+3.9
     2           503262643361536d-2*t154*t79*t83-1.243628d-1*t151*t61*t7
     3           7-2.220446049250313d-16*t104*t108*t109*t28-6.1012822887
     4           02853d-19*t106*t27-2.0d+0*t110*t111*t112*t24-2.64207978
     5           6267853d-3*t106*t23+t218+t217+t216+t215+t214+t213+t212-
     6           rhoa*t206)+2.0d+0*t120*t161)+t116*(3.04966d-52*t120*t90
     7           +3.04966d-52*t162+3.04966d-52*t103*t161)*t96-8.13242666
     8           6666666d-52*t103*t210*t90*t96+1.86008522312d-103*t103*t
     9           119*t209*t90+t4*(5.0d-1*rhoa*t29*(1.7777777777777776d-4
     :           9*t210*t6*t7*t9+1.7777777777777776d-49*t14*t210*t7*t9-1
     ;           .373568d-51*t12*t210*t7*t9-1.373568d-100*t114*t209*t6*t
     <           9-2.4724223999999997d-100*t114*t14*t209*t9+5.3063129548
     =           79999d-103*t114*t12*t209*t9+6.367575545855999d-152*t14*
     >           t207*t208*t9+2.222222222222222d-99*t209*t6*t7+8.0d-99*t
     ?           14*t209*t7-1.2362111999999999d-100*t13*t209*t7-3.43392d
     @           -101*t12*t209*t7+2.3111111111111113d-98*t11*t209*t7-2.7
     1           47136d-51*t10*t114*t210*t6+1.5918938864639998d-102*t10*
     2           t207*t209*t6+1.7777777777777776d-49*t13*t210*t4+8.88888
     3           8888888888d-50*t12*t210*t4-2.7471359999999995d-150*t114
     4           *t14*t208+2.1225251819519997d-152*t114*t13*t208-1.53839
     5           616d-149*t11*t114*t208+2.5470302183424d-201*t11*t207/rh
     6           oa**8.666666666666666d+0)+1.0d+0*t117*t29+5.0d-1*rhoa*t
     7           15*t206+1.0d+0*t113*t15+1.0d+0*rhoa*t113*t117)+t116*(5.
     8           15088d-52*t118-4.2923999999999995d-52*t15*t29)*t7+t1*(2
     9           .57544d-52*t117*t29+2.57544d-52*t113*t15)*t7+2.65315647
     :           74399996d-103*t114*t115*t15*t29)*wght+Amat2(iq,D2_RA_RA
     ;           )
              Amat2(iq,D2_RA_RB) = (t92*(1.0d+0*t90*(-4.066213333333334d
     1           -51*t116*t119*t47*t98*t99*taub+2.222222222222222d-49*t1
     2           16*t47*t96*t99*taub+2.222222222222222d-49*t116*t47*t96*
     3           t97*taub-2.033106666666667d-51*t116*t119*t47*t94*t97*ta
     4           ub-1.0165533333333335d-51*t102*t116*t47*t96*taub+4.0662
     5           133333333333d-52*t116*t119*t164*t98*t99-5.5802556693600
     6           01d-54*t100*t116*t164*t211*t99-5.580255669360001d-54*t1
     7           16*t164*t211*t94*t97*t98+4.0662133333333333d-52*t116*t1
     8           19*t164*t97*t98-1.6264853333333332d-51*gammabb*t116*t11
     9           9*t163*t97*t98-1.86008522312d-54*t102*t116*t119*t164*t9
     :           8+8.888888888888888d-50*gammabb*t116*t163*t96*t97+2.033
     ;           1066666666667d-52*t116*t119*t164*t94*t97+3.555555555555
     <           555d-49*gammabb*t116*t163*t93*t96+1.0165533333333333d-5
     =           2*t102*t116*t164*t96+2.0331066666666667d-52*t101*t116*t
     >           164*t96-8.132426666666666d-52*gammabb*t101*t116*t163*t9
     ?           6-5.580255669360001d-54*t116*t164*t211*t93*t95+8.132426
     @           666666667d-52*t116*t119*t164*t93*t94-3.2529706666666663
     1           d-51*gammabb*t116*t119*t163*t93*t94-1.86008522312d-54*t
     2           101*t116*t119*t164*t94)+1.0d+0*t103*(t59*(7.17695623634
     3           3652d-1*t253*t64*t68*t85*t88-5.980796863619711d-2*t260*
     4           t63*t64*t85*t88-2.3923187454478842d-1*t149*t182*t64*t85
     5           *t88+2.3923187454478842d-1*t145*t149*t64*t85*t88+2.3923
     6           187454478842d-1*t147*t182*t63*t85*t88+2.392318745447884
     7           2d-1*t145*t147*t63*t85*t88+2.541232989148493d-3*t158*t1
     8           82*t63*t88+2.541232989148493d-3*t145*t158*t63*t88+1.923
     9           661050931536d+0*t133*t134*t135*t182*t63*t64*t85+1.92366
     :           1050931536d+0*t133*t134*t135*t145*t63*t64*t85+1.9751631
     ;           321680768d-2*(t266+t265+t264+t263+t262+t261+1.923661050
     <           931536d+0*t260+t251)*t79*t83-4.5437964274821163d-4*t123
     =           *t187*t83-4.5437964274821163d-4*t123*t154*t83-5.8482236
     >           22634647d-1*t129*t130*t131*t187*t79-5.848223622634647d-
     ?           1*t129*t130*t131*t154*t79-6.21814d-2*(t266+t265+t264+t2
     @           63+t262+t261+t251)*t61*t77+2.747773264188437d-3*t123*t1
     1           85*t77+2.747773264188437d-3*t123*t151*t77+1.0d+0*t125*t
     2           126*t127*t185*t61+1.0d+0*t125*t126*t127*t151*t61+t258+t
     3           257+t256+t255+t238+t237+t236+t235+t234+t232+t231+t230+t
     4           229+t227+t222+t221+t220)+t218+t217+t216+t215+t214+t213+
     5           t212+t189+t188+t186+t157+t155+t152)+1.0d+0*t120*t190+1.
     6           0d+0*t161*t179)+t116*(3.04966d-52*t179*t90+3.04966d-52*
     7           t103*t190)*t96-3.04966d-3*t162*t164*t96-1.86008522312d-
     8           54*t103*t116*t119*t164*t90)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t92*(1.0d+0*t90*(1.7777777777777778d
     1           +1*t163*t96*t98*t99*taub+8.132426666666668d-2*t119*t164
     2           *t47*t98*t99*taub+8.88888888888889d+0*t163*t94*t96*t97*
     3           taub+1.7777777777777778d+1*gammabb*t166*t96*t97*taub+4.
     4           066213333333334d-2*t119*t164*t47*t94*t97*taub+2.0331066
     5           66666667d-2*t102*t164*t47*t96*taub+8.88888888888889d+0*
     6           t102*t163*t92*taub+2.2222222222222224d+1*t198*t54*t96*t
     7           99-6.09932d-3*t100*t119*t271*t99+5.580255669360001d-5*t
     8           100*t211*t267*t99+9.777777777777779d+0*gammabb*t270*t96
     9           *t97*t98-6.09932d-3*t119*t271*t94*t97*t98+5.58025566936
     :           0001d-5*t211*t267*t94*t97*t98+3.2529706666666663d-2*gam
     ;           mabb*t119*t163*t164*t97*t98-3.04966d-3*t102*t271*t96*t9
     <           8+1.86008522312d-5*t102*t119*t267*t98+1.955555555555555
     =           7d+1*gammabb*t270*t93*t94*t96-3.04966d-3*t101*t271*t94*
     >           t96+1.4222222222222222d+1*t272*t53*t93*t96+1.6264853333
     ?           333332d-2*gammabb*t101*t163*t164*t96-6.09932d-3*t119*t2
     @           71*t93*t95+5.580255669360001d-5*t211*t267*t93*t95+6.505
     1           941333333333d-2*gammabb*t119*t163*t164*t93*t94+1.860085
     2           22312d-5*t101*t119*t267*t94+9.777777777777779d+0*gammab
     3           b*t101*t270*t92)+1.0d+0*t103*(t59*(-1.9138549963583074d
     4           +0*t147*t149*t68*t85*t88-5.980796863619711d-2*t279*t63*
     5           t64*t85*t88+4.7846374908957684d-1*t149*t182*t64*t85*t88
     6           +4.7846374908957684d-1*t147*t182*t63*t85*t88-2.03298639
     7           13187946d-2*t149*t158*t68*t88+5.082465978296986d-3*t158
     8           *t182*t63*t88-1.538928840745229d+1*t133*t134*t135*t149*
     9           t64*t68*t85+3.847322101863072d+0*t133*t134*t135*t182*t6
     :           3*t64*t85+1.9751631321680768d-2*(t283+t282+t281+t280+1.
     ;           923661050931536d+0*t279+t254+t251)*t79*t83-9.0875928549
     <           64233d-4*t123*t187*t83-1.1696447245269295d+0*t129*t130*
     =           t131*t187*t79-6.21814d-2*(t283+t282+t281+t280+t254+t251
     >           )*t61*t77+5.495546528376875d-3*t123*t185*t77+2.0d+0*t12
     ?           5*t126*t127*t185*t61+t259+t258+t257+t256+t255+t238+t237
     @           +t236+t235+t234+t232+t231+t230+t229+t227+t222+t221+t220
     1           )+4.7846374908957684d-1*t149*t64*t68*t85*t88-1.19615937
     2           27239421d-1*t182*t63*t64*t85*t88+3.9503262643361536d-2*
     3           t187*t79*t83-1.243628d-1*t185*t61*t77-2.220446049250313
     4           d-16*t168*t172*t173*t42-6.101282288702853d-19*t170*t41-
     5           2.0d+0*t174*t175*t176*t38-2.642079786267853d-3*t170*t37
     6           -rhob*t278+t218+t217+t216+t215+t214+t213+t212)+2.0d+0*t
     7           179*t190)+t52*(1.0d+0*rhob*t43*t46*(1.7777777777777778d
     8           +1*t163*t55*t56*t6*taub+1.373568d-1*t164*t165*t47*t56*t
     9           6*taub+3.4339200000000003d-2*t12*t164*t47*t55*taub+2.66
     :           66666666666666d+1*gammabb*t14*t166*t55*taub+6.867840000
     ;           000001d-2*gammabb*t14*t164*t165*t54*taub+8.888888888888
     <           89d+0*t12*t163*t52*taub-1.030176d-2*t165*t271*t57*t6+1.
     =           591893886464d-4*t267*t269*t57*t6+2.2222222222222224d+1*
     >           t198*t54*t55*t6-5.15088d-3*t12*t271*t55*t56+9.777777777
     ?           777779d+0*gammabb*t14*t270*t55*t56-1.030176d-2*gammabb*
     @           t14*t165*t271*t47*t56+1.591893886464d-4*gammabb*t14*t26
     1           7*t269*t47*t56+5.30631295488d-5*t12*t165*t267*t56+5.494
     2           272d-2*gammabb*t14*t163*t164*t165*t56+3.377777777777778
     3           d+1*t11*t272*t53*t55-5.15088d-3*gammabb*t13*t271*t47*t5
     4           5+2.747136d-2*gammabb*t13*t163*t164*t55-1.030176d-2*t11
     5           *t165*t271*t53*t54+1.591893886464d-4*t11*t267*t269*t53*
     6           t54+1.0988544d-1*t11*t164*t165*t166*t53+9.7777777777777
     7           79d+0*gammabb*t13*t270*t52+5.30631295488d-5*gammabb*t13
     8           *t165*t267*t47)+1.0d+0*rhob*t278*t46*t58+2.0d+0*t177*t4
     9           6*t58+1.25d-1*gammabb*t177*t44*t45*t58+1.25d-1*gammabb*
     :           t268*t43*t45*t58+2.0d+0*t167*t43*t46+2.0d+0*rhob*t167*t
     ;           177*t46+1.25d-1*gammabb*t167*t43*t44*t45)+(-3.04966d-3*
     <           t103*t271*t90-3.04966d-3*t164*t179*t90-3.04966d-3*t164*
     =           t191-3.04966d-3*t103*t164*t190)*t96+1.86008522312d-5*t1
     >           03*t119*t267*t90+t55*(-5.15088d-3*rhob*t271*t43*t46*t58
     ?           -5.15088d-3*t164*t43*t46*t58-5.15088d-3*rhob*t164*t177*
     @           t46*t58-5.15088d-3*rhob*t164*t167*t43*t46-5.15088d-3*t1
     1           64*t178)+t44*t45*t52*(1.25d-1*gammabb*t177*t58+1.25d-1*
     2           gammabb*t167*t43)-1.28772d-3*gammabb*t164*t43*t44*t45*t
     3           55*t58-1.25d-1*gammabb*t268*t43*t45*t52*t58+5.306312954
     4           88d-5*rhob*t165*t267*t43*t46*t58)*wght+Amat2(iq,D2_RB_R
     5           B)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t92*(1.0d+0*t90*(4.0662133333333333
     1           d-52*t116*t119*t47*t98*t99-5.580255669360001d-54*t100*t
     2           116*t211*t47*t99-5.580255669360001d-54*t116*t211*t47*t9
     3           4*t97*t98+1.0165533333333333d-51*t116*t119*t47*t97*t98-
     4           1.86008522312d-54*t102*t116*t119*t47*t98-3.333333333333
     5           333d-50*t116*t47*t96*t97+2.0331066666666667d-52*t116*t1
     6           19*t47*t94*t97-1.3333333333333333d-49*t116*t47*t93*t96+
     7           1.0165533333333333d-52*t102*t116*t47*t96+5.082766666666
     8           666d-52*t101*t116*t47*t96-5.580255669360001d-54*t116*t2
     9           11*t47*t93*t95+2.0331066666666667d-51*t116*t119*t47*t93
     :           *t94-1.86008522312d-54*t101*t116*t119*t47*t94)+1.0d+0*t
     ;           161*t194)+3.04966d-52*t116*t194*t90*t96-3.04966d-3*t162
     <           *t47*t96-1.86008522312d-54*t103*t116*t119*t47*t90)*wght
     =           +Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t92*(1.0d+0*t90*(4.066213333333334d
     1           -2*t119*t54*t98*t99*taub-3.3333333333333337d+0*t54*t96*
     2           t97*taub+2.033106666666667d-2*t119*t54*t94*t97*taub+1.0
     3           165533333333335d-2*t102*t54*t96*taub+5.580255669360001d
     4           -5*t100*t164*t211*t47*t99+1.6264853333333332d-2*t100*t1
     5           19*t163*t99-2.6666666666666666d+0*t163*t96*t97*t98+5.58
     6           0255669360001d-5*t164*t211*t47*t94*t97*t98+1.6264853333
     7           333332d-2*t119*t163*t94*t97*t98-6.09932d-3*t119*t164*t4
     8           7*t97*t98+1.6264853333333332d-2*gammabb*t119*t166*t97*t
     9           98+8.132426666666667d-3*t102*t163*t96*t98+1.86008522312
     :           d-5*t102*t119*t164*t47*t98-5.333333333333333d+0*t163*t9
     ;           3*t94*t96+8.132426666666667d-3*t101*t163*t94*t96-5.3333
     <           33333333333d+0*gammabb*t166*t93*t96-3.04966d-3*t101*t16
     =           4*t47*t96+8.132426666666667d-3*gammabb*t101*t166*t96+5.
     >           580255669360001d-5*t164*t211*t47*t93*t95+1.626485333333
     ?           3332d-2*t119*t163*t93*t95-1.219864d-2*t119*t164*t47*t93
     @           *t94+3.2529706666666663d-2*gammabb*t119*t166*t93*t94+1.
     1           86008522312d-5*t101*t119*t164*t47*t94-2.666666666666666
     2           6d+0*t101*t163*t92)+1.0d+0*t190*t194)+t52*(1.0d+0*rhob*
     3           t43*t46*(6.867840000000001d-2*t165*t54*t56*t6*taub-3.33
     4           33333333333337d+0*t14*t54*t55*taub+1.7169600000000002d-
     5           2*t12*t54*t55*taub+3.4339200000000003d-2*gammabb*t14*t1
     6           65*t192*taub+1.591893886464d-4*t164*t269*t47*t57*t6+2.7
     7           47136d-2*t163*t165*t57*t6-2.6666666666666666d+0*t14*t16
     8           3*t55*t56+1.373568d-2*t12*t163*t55*t56+1.591893886464d-
     9           4*gammabb*t14*t164*t269*t54*t56-1.030176d-2*t14*t164*t1
     :           65*t47*t56+5.30631295488d-5*t12*t164*t165*t47*t56+5.494
     ;           272d-2*gammabb*t14*t165*t166*t56-5.15088d-3*t13*t164*t4
     <           7*t55+2.747136d-2*gammabb*t13*t166*t55-1.06666666666666
     =           66d+1*gammabb*t11*t166*t55+5.30631295488d-5*gammabb*t13
     >           *t164*t165*t54-2.060352d-2*gammabb*t11*t164*t165*t54+1.
     ?           591893886464d-4*t11*t164*t192*t269*t53+8.241408d-2*t11*
     @           t165*t53/rhob**9-2.6666666666666666d+0*t13*t163*t52)-1.
     1           25d-1*t43*t44*t45*t58-1.25d-1*t177*t45*t58+1.0d+0*t193*
     2           t43*t46+1.0d+0*rhob*t177*t193*t46-1.25d-1*t167*t43*t45)
     3           -3.04966d-3*t164*t194*t90*t96+8.132426666666667d-3*t103
     4           *t163*t90*t96-3.04966d-3*t191*t47*t96+1.86008522312d-5*
     5           t103*t119*t164*t47*t90+t47*t55*(1.373568d-2*t43*t46*t58
     6           -5.15088d-3*t178)+6.4386d-4*t164*t43*t45*t55*t58-6.4386
     7           d-4*gammabb*t163*t43*t45*t55*t58+5.30631295488d-5*t164*
     8           t165*t43*t46*t49*t58-5.15088d-3*rhob*t164*t193*t43*t46*
     9           t55+t284*t44*t45*t52)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (1.0d+0*t90*t92*(5.580255669360001d
     1           -5*t100*t211*t54*t99+5.580255669360001d-5*t211*t54*t94*
     2           t97*t98-1.219864d-2*t119*t54*t97*t98+1.86008522312d-5*t
     3           102*t119*t54*t98+2*t54*t93*t96-6.09932d-3*t101*t54*t96+
     4           5.580255669360001d-5*t211*t54*t93*t95-2.439728d-2*t119*
     5           t54*t93*t94+1.86008522312d-5*t101*t119*t54*t94)-6.09932
     6           d-3*t194*t47*t90*t96+1.86008522312d-5*t103*t119*t54*t90
     7           +1.0d+0*rhob*t43*t46*t52*(1.591893886464d-4*t269*t54*t5
     8           7*t6-2.060352d-2*t14*t165*t54*t56+5.30631295488d-5*t12*
     9           t165*t54*t56+1.591893886464d-4*gammabb*t14*t192*t269*t5
     :           6-1.030176d-2*t13*t54*t55+2*t11*t54*t55+1.591893886464d
     ;           -4*t11*t269*t53/rhob**1.0666666666666666d+1+5.306312954
     <           88d-5*gammabb*t13*t165*t192-4.120704d-2*gammabb*t11*t16
     =           5*t192)+1.28772d-3*t43*t45*t47*t55*t58+5.30631295488d-5
     >           *t165*t196*t43*t46*t58-1.030176d-2*t193*t43*t46*t49*t55
     ?           -2.5d-1*t193*t43*t45*t52)*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t92*(1.0d+0*t90*(3.252970666666667d-
     1           51*t116*t119*t49*t98*t99-1.3333333333333333d-49*t116*t4
     2           9*t96*t99-1.1160511338720003d-53*t100*t116*t211*t49*t99
     3           -1.1160511338720003d-53*t116*t211*t49*t94*t97*t98+8.132
     4           426666666667d-52*t116*t119*t49*t97*t98-3.72017044624d-5
     5           4*t102*t116*t119*t49*t98-1.3333333333333333d-49*t116*t4
     6           9*t96*t97+1.6264853333333334d-51*t116*t119*t49*t94*t97+
     7           8.132426666666667d-52*t102*t116*t49*t96+4.0662133333333
     8           333d-52*t101*t116*t49*t96-1.1160511338720003d-53*t116*t
     9           211*t49*t93*t95+1.6264853333333334d-51*t116*t119*t49*t9
     :           3*t94-3.72017044624d-54*t101*t116*t119*t49*t94)+1.0d+0*
     ;           t161*t200)+3.04966d-52*t116*t200*t90*t96-6.09932d-3*t16
     <           2*t49*t96-3.72017044624d-54*t103*t116*t119*t49*t90)*wgh
     =           t+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t92*(1.0d+0*t90*(8.132426666666668d-
     1           2*t119*t196*t98*t99*taub-1.3333333333333333d+1*t196*t96
     2           *t99*taub+4.066213333333334d-2*t119*t196*t94*t97*taub+2
     3           .033106666666667d-2*t102*t196*t96*taub-6.66666666666666
     4           7d+0*t47*t96*t98*t99-2.439728d-2*t119*t164*t49*t98*t99+
     5           1.1160511338720001d-4*t100*t164*t211*t49*t99+2.03310666
     6           6666667d-2*t100*t119*t47*t99+1.1160511338720001d-4*t164
     7           *t211*t49*t94*t97*t98+2.033106666666667d-2*t119*t47*t94
     8           *t97*t98+3.2529706666666663d-2*gammabb*t119*t54*t97*t98
     9           +1.0165533333333335d-2*t102*t47*t96*t98+3.72017044624d-
     :           5*t102*t119*t164*t49*t98-3.3333333333333337d+0*t47*t94*
     ;           t96*t97-5.333333333333333d+0*gammabb*t54*t96*t97-1.2198
     <           64d-2*t119*t164*t49*t94*t97+1.0165533333333335d-2*t101*
     =           t47*t94*t96+1.6264853333333332d-2*gammabb*t101*t54*t96-
     >           6.09932d-3*t102*t164*t49*t96+1.1160511338720001d-4*t164
     ?           *t211*t49*t93*t95+2.033106666666667d-2*t119*t47*t93*t95
     @           +6.505941333333333d-2*gammabb*t119*t54*t93*t94+3.720170
     1           44624d-5*t101*t119*t164*t49*t94-3.3333333333333337d+0*t
     2           102*t47*t92)+1.0d+0*t190*t200)+t52*(1.0d+0*rhob*t43*t46
     3           *(1.373568d-1*t165*t196*t56*t6*taub-1.3333333333333333d
     4           +1*t196*t55*t6*taub+3.4339200000000003d-2*t12*t196*t55*
     5           taub+6.867840000000001d-2*gammabb*t14*t165*t195*taub+3.
     6           183787772928d-4*t164*t269*t49*t57*t6+3.4339200000000003
     7           d-2*t165*t47*t57*t6-6.666666666666667d+0*t47*t55*t56*t6
     8           -4.120704d-2*t164*t165*t49*t56*t6+1.7169600000000002d-2
     9           *t12*t47*t55*t56+8.928192d-2*gammabb*t14*t165*t54*t56+1
     :           .061262590976d-4*t12*t164*t165*t49*t56+3.183787772928d-
     ;           4*gammabb*t14*t164*t196*t269*t56-8.666666666666666d+0*g
     <           ammabb*t14*t54*t55+4.464096d-2*gammabb*t13*t54*t55-1.03
     =           0176d-2*t12*t164*t49*t55+3.183787772928d-4*t11*t164*t19
     >           5*t269*t53+1.4422464000000002d-1*t11*t165*t192*t53-3.33
     ?           33333333333337d+0*t12*t47*t52-2.060352d-2*gammabb*t14*t
     @           164*t165*t196+1.061262590976d-4*gammabb*t13*t164*t165*t
     1           196)+1.25d-1*gammabb*t199*t43*t44*t58+1.25d-1*gammabb*t
     2           177*t199*t58+1.0d+0*t197*t43*t46+1.0d+0*rhob*t177*t197*
     3           t46+1.25d-1*gammabb*t167*t199*t43)+1.0165533333333335d-
     4           2*t103*t47*t90*t96-3.04966d-3*t164*t200*t90*t96-6.09932
     5           d-3*t191*t49*t96+3.72017044624d-5*t103*t119*t164*t49*t9
     6           0+t49*t55*(1.7169600000000002d-2*t43*t46*t58-1.030176d-
     7           2*t178)-1.28772d-3*gammabb*t43*t45*t47*t55*t58-6.4386d-
     8           4*gammabb*t164*t199*t43*t55*t58-1.25d-1*gammabb*t199*t4
     9           3*t44*t52*t58+1.061262590976d-4*t164*t165*t30*t43*t46*t
     :           58-5.15088d-3*rhob*t164*t197*t43*t46*t55+1.25d-1*gammab
     ;           b*t197*t43*t44*t45*t52)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*t90*t92*(-2.439728d-2*t119*t
     1           196*t98*t99+1.1160511338720001d-4*t100*t196*t211*t99+1.
     2           1160511338720001d-4*t196*t211*t94*t97*t98-1.219864d-2*t
     3           119*t196*t97*t98+3.72017044624d-5*t102*t119*t196*t98+2.
     4           0d+0*t196*t96*t97-1.219864d-2*t119*t196*t94*t97-6.09932
     5           d-3*t102*t196*t96-6.09932d-3*t101*t196*t96+1.1160511338
     6           720001d-4*t196*t211*t93*t95-2.439728d-2*t119*t196*t93*t
     7           94+3.72017044624d-5*t101*t119*t196*t94)-6.09932d-3*t194
     8           *t49*t90*t96-3.04966d-3*t200*t47*t90*t96+3.72017044624d
     9           -5*t103*t119*t196*t90+1.0d+0*rhob*t43*t46*t52*(3.183787
     :           772928d-4*t196*t269*t57*t6-4.120704d-2*t165*t196*t56*t6
     ;           +3.183787772928d-4*gammabb*t14*t195*t269*t56-2.060352d-
     <           2*t14*t165*t196*t56+1.061262590976d-4*t12*t165*t196*t56
     =           +2.0d+0*t14*t196*t55-1.030176d-2*t13*t196*t55-1.030176d
     >           -2*t12*t196*t55+3.183787772928d-4*t11*t269*t53/rhob**9.
     ?           666666666666666d+0-2.060352d-2*gammabb*t14*t165*t195+1.
     @           061262590976d-4*gammabb*t13*t165*t195-4.120704d-2*gamma
     1           bb*t11*t165*t195)+1.28772d-3*t43*t45*t49*t55*t58-6.4386
     2           d-4*gammabb*t199*t43*t47*t55*t58+1.061262590976d-4*t165
     3           *t285*t43*t46*t58-5.15088d-3*t197*t43*t46*t49*t55-1.030
     4           176d-2*t193*t30*t43*t46*t55-1.25d-1*t197*t43*t45*t52+t1
     5           99*t284*t52)*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (-2.5d-1*gammabb*t43*t52*t58/taub**3+
     1           1.0d+0*t90*t92*(-9.758912d-2*t119*t285*t98*t99+8.0d+0*t
     2           285*t96*t99+2.2321022677440003d-4*t100*t211*t285*t99+2.
     3           2321022677440003d-4*t211*t285*t94*t97*t98+7.44034089248
     4           d-5*t102*t119*t285*t98-4.879456d-2*t119*t285*t94*t97-2.
     5           439728d-2*t102*t285*t96+2.2321022677440003d-4*t211*t285
     6           *t93*t95+7.44034089248d-5*t101*t119*t285*t94)-1.219864d
     7           -2*t200*t49*t90*t96+7.44034089248d-5*t103*t119*t285*t90
     8           +1.0d+0*rhob*t43*t46*t52*(6.367575545856d-4*t269*t285*t
     9           57*t6-1.6482816d-1*t165*t285*t56*t6+8.0d+0*t285*t55*t6+
     :           6.367575545856d-4*gammabb*t14*t269*t286*t56+2.122525181
     ;           952d-4*t12*t165*t285*t56-4.120704d-2*t12*t285*t55+6.367
     <           575545856d-4*t11*t269*t53/rhob**8.666666666666666d+0-8.
     =           241408d-2*gammabb*t14*t165*t286+2.122525181952d-4*gamma
     >           bb*t13*t165*t286)-2.57544d-3*gammabb*t199*t43*t49*t55*t
     ?           58+2.122525181952d-4*t165*t275*t43*t46*t58-2.060352d-2*
     @           t197*t30*t43*t46*t55+2.5d-1*gammabb*t197*t199*t43*t52)*
     1           wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = param(9)
              t13 = param(8)
              t14 = param(11)
              t15 = 4.0d-50*t1*t14*t7*t9+t12*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t7/rhoa**3.3333333333333337d+0+t5+4.0d-50*t1*t13*t4
              t16 = 1/rhoa**6.666666666666666d-1
              t17 = rhoa**5.0d-1
              t18 = 1/t17
              t19 = 1/rhoa**3.333333333333333d-1
              t20 = 1/rhoa**1.6666666666666666d-1
              t21 = 1.1120374863094686d+1*t20+3.8447462374472113d+0*t19+
     1           1.644733775567609d+0*t18+2.4058712912881916d-1*t16
              t22 = 3.216395899738507d+1/t21+1.0d+0
              t23 = log(t22)
              t24 = 1.274696188700087d-1*t19+1.0d+0
              t25 = 5.982550435771079d+0*t20+2.2255694211506874d+0*t19+8
     1           .004286349993635d-1*t18+1.8970043257475583d-1*t16
              t26 = 1.6081979498692536d+1/t25+1.0d+0
              t27 = log(t26)
              t28 = 1.3256889990520176d-1*t19+1.0d+0
              t29 = -6.903522198342671d-18*t27*t28-3.1090699999999993d-2
     1           *t23*t24
              t30 = 1/rhob**1.6666666666666669d+0
              t31 = 6.0d-50*t30
              t32 = 5.15088d-3*(t31-9.11559972d+0)+1.0d+0
              t33 = 1/t32
              t34 = 1/t32**2
              t35 = 2.0d-50*t30
              t36 = t35-9.11559972d+0
              t37 = t36**2
              t38 = t34*t37*t6+t5+4.0d-50*t14*t30*t34*t36+t12*t33*t36+1.
     1           6d-99*t11*t34/rhob**3.3333333333333337d+0+4.0d-50*t13*t
     2           30*t33
              t39 = 1/rhob**6.666666666666666d-1
              t40 = rhob**5.0d-1
              t41 = 1/t40
              t42 = 1/rhob**3.333333333333333d-1
              t43 = 1/rhob**1.6666666666666666d-1
              t44 = 1.1120374863094686d+1*t43+3.8447462374472113d+0*t42+
     1           1.644733775567609d+0*t41+2.4058712912881916d-1*t39
              t45 = 3.216395899738507d+1/t44+1.0d+0
              t46 = log(t45)
              t47 = 1.274696188700087d-1*t42+1.0d+0
              t48 = 5.982550435771079d+0*t43+2.2255694211506874d+0*t42+8
     1           .004286349993635d-1*t41+1.8970043257475583d-1*t39
              t49 = 1.6081979498692536d+1/t48+1.0d+0
              t50 = log(t49)
              t51 = 1.3256889990520176d-1*t42+1.0d+0
              t52 = -6.903522198342671d-18*t50*t51-3.1090699999999993d-2
     1           *t46*t47
              t53 = param(6)
              t54 = 3.04966d-3*(t31+t2-1.823119944d+1)+1.0d+0
              t55 = 1/t54**2
              t56 = t8+t35-1.823119944d+1
              t57 = t56**2
              t58 = param(4)
              t59 = 4.0d-50*t30+4.0d-50*t1
              t60 = t59**2
              t61 = param(3)
              t62 = 1/t54
              t63 = param(2)
              t64 = param(5)
              t65 = t55*t56*t59*t64+t59*t62*t63+t56*t61*t62+t55*t58*t60+
     1           t53*t55*t57+param(1)
              t66 = rhob+rhoa
              t67 = 1/t66**3.333333333333333d-1
              t68 = 1.3256889990520176d-1*t67+1.0d+0
              t69 = rhoa-rhob
              t70 = t69**4
              t71 = 1/t66**4
              t72 = 1/t66
              t73 = 1.0d+0-t69*t72
              t74 = t69*t72+1.0d+0
              t75 = t74**1.3333333333333333d+0+t73**1.3333333333333333d+
     1           0-2.0d+0
              t76 = -1.923661050931536d+0*t70*t71*t75
              t77 = t76+1.0d+0
              t78 = 1/t66**6.666666666666666d-1
              t79 = t66**5.0d-1
              t80 = 1/t79
              t81 = 1/t66**1.6666666666666666d-1
              t82 = 5.982550435771079d+0*t81+8.004286349993635d-1*t80+1.
     1           8970043257475583d-1*t78+2.2255694211506874d+0*t67
              t83 = 1.6081979498692536d+1/t82+1.0d+0
              t84 = log(t83)
              t85 = -6.21814d-2*t68*t77*t84
              t86 = 6.901399211255825d-2*t67+1.0d+0
              t87 = t76+1.923661050931536d+0*t75
              t88 = 8.157414703487641d+0*t81+4.3009724712766434d-1*t80+1
     1           .9115125951273373d-1*t78+2.247591863577616d+0*t67
              t89 = 2.9608813203268075d+1/t88+1.0d+0
              t90 = log(t89)
              t91 = 1.9751631321680768d-2*t86*t87*t90
              t92 = 1.274696188700087d-1*t67+1.0d+0
              t93 = 1.1120374863094686d+1*t81+1.644733775567609d+0*t80+2
     1           .4058712912881916d-1*t78+3.8447462374472113d+0*t67
              t94 = 3.216395899738507d+1/t93+1.0d+0
              t95 = log(t94)
              t96 = -5.980796863619711d-2*t70*t71*t75*t92*t95
              t97 = t66*(t96+t91+t85)-rhob*t52-rhoa*t29
              t98 = 1/t26
              t99 = 1/t17**3
              t100 = 1/rhoa**1.3333333333333333d+0
              t101 = 1/rhoa**1.1666666666666667d+0
              t102 = -4.002143174996817d-1*t99-9.970917392951799d-1*t101
     1           -7.418564737168958d-1*t100-1.264669550498372d-1*t1
              t103 = 1/t25**2
              t104 = 1/t22
              t105 = -8.223668877838045d-1*t99-1.8533958105157808d+0*t10
     1           1-1.2815820791490704d+0*t100-1.6039141941921276d-1*t1
              t106 = 1/t21**2
              t107 = 1.1102230246251565d-16*t102*t103*t28*t98+3.05064114
     1           43514264d-19*t100*t27+1.0d+0*t104*t105*t106*t24+1.32103
     2           98931339265d-3*t100*t23
              t108 = 1/t3**3
              t109 = 1/rhoa**4.333333333333333d+0
              t110 = 1/rhoa**2.6666666666666666d+0
              t111 = -6.666666666666666d-50*t110*t6*t7*t9-6.666666666666
     1           666d-50*t110*t14*t7*t9+5.15088d-52*t110*t12*t7*t9+4.120
     2           7039999999995d-101*t108*t109*t14*t9-1.3333333333333333d
     3           -99*t109*t14*t7+2.0603519999999997d-101*t109*t13*t7-5.3
     4           33333333333334d-99*t109*t11*t7+1.030176d-51*t10*t108*t1
     5           10*t6-6.666666666666666d-50*t110*t13*t4-3.3333333333333
     6           33d-50*t110*t12*t4+1.6482816d-150*t108*t11/rhoa**6
              t112 = 5.0d-1*t15*t29+5.0d-1*rhoa*t111*t29+5.0d-1*rhoa*t10
     1           7*t15
              t113 = 1/t66**1.6666666666666669d+0
              t114 = 1/t79**3
              t115 = 1/t66**1.3333333333333333d+0
              t116 = 1/t66**1.1666666666666667d+0
              t117 = -9.970917392951799d-1*t116-7.418564737168958d-1*t11
     1           5-4.002143174996817d-1*t114-1.264669550498372d-1*t113
              t118 = 1/t82**2
              t119 = 1/t83
              t120 = 1.0d+0*t117*t118*t119*t68*t77
              t121 = -1.3595691172479402d+0*t116-7.491972878592053d-1*t1
     1           15-2.1504862356383217d-1*t114-1.2743417300848914d-1*t11
     2           3
              t122 = 1/t88**2
              t123 = 1/t89
              t124 = -5.848223622634647d-1*t121*t122*t123*t86*t87
              t125 = -1.8533958105157808d+0*t116-1.2815820791490704d+0*t
     1           115-8.223668877838045d-1*t114-1.6039141941921276d-1*t11
     2           3
              t126 = 1/t93**2
              t127 = 1/t94
              t128 = 1.923661050931536d+0*t125*t126*t127*t70*t71*t75*t92
              t129 = 1/t66**2
              t130 = t129*t69
              t131 = -t72
              t132 = t131+t130
              t133 = t73**3.333333333333333d-1
              t134 = -t129*t69
              t135 = t72+t134
              t136 = t74**3.333333333333333d-1
              t137 = 1.3333333333333333d+0*t135*t136+1.3333333333333333d
     1           +0*t132*t133
              t138 = -1.923661050931536d+0*t137*t70*t71
              t139 = 1/t66**5
              t140 = 7.694644203726144d+0*t139*t70*t75
              t141 = t69**3
              t142 = -7.694644203726144d+0*t141*t71*t75
              t143 = t142+t140+t138
              t144 = -6.21814d-2*t143*t68*t84
              t145 = 2.747773264188437d-3*t115*t77*t84
              t146 = t142+t140+t138+1.923661050931536d+0*t137
              t147 = 1.9751631321680768d-2*t146*t86*t90
              t148 = -4.5437964274821163d-4*t115*t87*t90
              t149 = -5.980796863619711d-2*t137*t70*t71*t92*t95
              t150 = 1/t66**5.333333333333333d+0
              t151 = 2.541232989148493d-3*t150*t70*t75*t95
              t152 = 2.3923187454478842d-1*t139*t70*t75*t92*t95
              t153 = t96+t66*(-2.3923187454478842d-1*t141*t71*t75*t92*t9
     1           5+t152+t151+t149+t148+t147+t145+t144+t128+t124+t120)+t9
     2           1+t85+6.903522198342671d-18*t27*t28+3.1090699999999993d
     3           -2*t23*t24-rhoa*t107
              t154 = 1/t54**3
              t155 = 6.09932d-52*t110*t154*t56*t59*t64-3.333333333333333
     1           d-50*t110*t55*t59*t64-6.666666666666666d-50*t110*t55*t5
     2           6*t64-6.666666666666666d-50*t110*t62*t63+3.04966d-52*t1
     3           10*t55*t59*t63-3.333333333333333d-50*t110*t61*t62+3.049
     4           66d-52*t110*t55*t56*t61+6.09932d-52*t110*t154*t58*t60-1
     5           .3333333333333333d-49*t110*t55*t58*t59+6.09932d-52*t110
     6           *t154*t53*t57-6.666666666666666d-50*t110*t53*t55*t56
              t156 = 1.0d+0*t155*t97+1.0d+0*t153*t65
              t157 = 1/t49
              t158 = 1/t40**3
              t159 = 1/rhob**1.3333333333333333d+0
              t160 = 1/rhob**1.1666666666666667d+0
              t161 = -1.264669550498372d-1*t30-9.970917392951799d-1*t160
     1           -7.418564737168958d-1*t159-4.002143174996817d-1*t158
              t162 = 1/t48**2
              t163 = 1/t45
              t164 = -1.6039141941921276d-1*t30-1.8533958105157808d+0*t1
     1           60-1.2815820791490704d+0*t159-8.223668877838045d-1*t158
              t165 = 1/t44**2
              t166 = 1.1102230246251565d-16*t157*t161*t162*t51+3.0506411
     1           443514264d-19*t159*t50+1.0d+0*t163*t164*t165*t47+1.3210
     2           398931339265d-3*t159*t46
              t167 = 1/t32**3
              t168 = 1/rhob**4.333333333333333d+0
              t169 = 1/rhob**2.6666666666666666d+0
              t170 = 1.030176d-51*t167*t169*t37*t6-6.666666666666666d-50
     1           *t169*t34*t36*t6-6.666666666666666d-50*t14*t169*t34*t36
     2           +5.15088d-52*t12*t169*t34*t36+4.1207039999999995d-101*t
     3           14*t167*t168*t36-1.3333333333333333d-99*t14*t168*t34+2.
     4           0603519999999997d-101*t13*t168*t34-5.333333333333334d-9
     5           9*t11*t168*t34-6.666666666666666d-50*t13*t169*t33-3.333
     6           333333333333d-50*t12*t169*t33+1.6482816d-150*t11*t167/r
     7           hob**6
              t171 = 5.0d-1*t38*t52+5.0d-1*rhob*t170*t52+5.0d-1*rhob*t16
     1           6*t38
              t172 = t72+t130
              t173 = t134+t131
              t174 = 1.3333333333333333d+0*t136*t173+1.3333333333333333d
     1           +0*t133*t172
              t175 = -1.923661050931536d+0*t174*t70*t71
              t176 = 7.694644203726144d+0*t141*t71*t75
              t177 = t176+t175+t140
              t178 = -6.21814d-2*t177*t68*t84
              t179 = t176+t175+1.923661050931536d+0*t174+t140
              t180 = 1.9751631321680768d-2*t179*t86*t90
              t181 = -5.980796863619711d-2*t174*t70*t71*t92*t95
              t182 = t96+t66*(2.3923187454478842d-1*t141*t71*t75*t92*t95
     1           +t181+t180+t178+t152+t151+t148+t145+t128+t124+t120)+t91
     2           +t85+6.903522198342671d-18*t50*t51+3.1090699999999993d-
     3           2*t46*t47-rhob*t166
              t183 = 6.09932d-52*t154*t169*t56*t59*t64-3.333333333333333
     1           d-50*t169*t55*t59*t64-6.666666666666666d-50*t169*t55*t5
     2           6*t64-6.666666666666666d-50*t169*t62*t63+3.04966d-52*t1
     3           69*t55*t59*t63-3.333333333333333d-50*t169*t61*t62+3.049
     4           66d-52*t169*t55*t56*t61+6.09932d-52*t154*t169*t58*t60-1
     5           .3333333333333333d-49*t169*t55*t58*t59+6.09932d-52*t154
     6           *t169*t53*t57-6.666666666666666d-50*t169*t53*t55*t56
              t184 = 1.0d+0*t183*t97+1.0d+0*t182*t65
              t185 = t102**2
              t186 = 1/t17**5
              t187 = 1/rhoa**2.3333333333333334d+0
              t188 = 1/rhoa**2.1666666666666665d+0
              t189 = t105**2
              t190 = -2.220446049250313d-16*t185*t28*t98/t25**3+1.110223
     1           0246251565d-16*t103*(1.1632736958443765d+0*t188+9.89141
     2           964955861d-1*t187+6.003214762495226d-1*t186+2.107782584
     3           1639536d-1*t110)*t28*t98-9.812069668265515d-18*t100*t10
     4           2*t103*t98+1.7854583920998188d-15*t185*t28/(t25**4*t26*
     5           *2)-4.0675215258019015d-19*t187*t27+3.216395899738507d+
     6           1*t189*t24/(t21**4*t22**2)-2.0d+0*t104*t189*t24/t21**3+
     7           1.0d+0*t104*t106*(2.1622951122684114d+0*t188+1.70877610
     8           55320938d+0*t187+1.2335503316757068d+0*t186+2.673190323
     9           653546d-1*t110)*t24-1.7613865241785684d-3*t187*t23-8.49
     :           7974591333913d-2*t100*t104*t105*t106
              t191 = 1/t3**4
              t192 = 1/rhoa**7
              t193 = 1/rhoa**5.333333333333333d+0
              t194 = 1/rhoa**3.6666666666666664d+0
              t195 = 2.0d+0*t117*t118*t119*t68*t77
              t196 = -1.1696447245269295d+0*t121*t122*t123*t86*t87
              t197 = 3.847322101863072d+0*t125*t126*t127*t70*t71*t75*t92
              t198 = 5.495546528376875d-3*t115*t77*t84
              t199 = -9.087592854964233d-4*t115*t87*t90
              t200 = 5.082465978296986d-3*t150*t70*t75*t95
              t201 = 4.7846374908957684d-1*t139*t70*t75*t92*t95
              t202 = t117**2
              t203 = 1.6081979498692536d+1*t202*t68*t77/(t82**4*t83**2)
              t204 = -2.0d+0*t119*t202*t68*t77/t82**3
              t205 = -8.837926660346784d-2*t115*t117*t118*t119*t77
              t206 = 1/t66**2.6666666666666666d+0
              t207 = 1/t79**5
              t208 = 1/t66**2.3333333333333334d+0
              t209 = 1/t66**2.1666666666666665d+0
              t210 = 1.0d+0*t118*t119*(1.1632736958443765d+0*t209+9.8914
     1           1964955861d-1*t208+6.003214762495226d-1*t207+2.10778258
     2           41639536d-1*t206)*t68*t77
              t211 = t121**2
              t212 = -1.73158960813529d+1*t211*t86*t87/(t88**4*t89**2)
              t213 = 1.1696447245269295d+0*t123*t211*t86*t87/t88**3
              t214 = 2.690728393099896d-2*t115*t121*t122*t123*t87
              t215 = -5.848223622634647d-1*t122*t123*(1.5861639701225969
     1           d+0*t209+9.98929717145607d-1*t208+3.2257293534574827d-1
     2           *t207+2.1239028834748191d-1*t206)*t86*t87
              t216 = t125**2
              t217 = 6.187255516702861d+1*t216*t70*t71*t75*t92/(t93**4*t
     1           94**2)
              t218 = -3.847322101863072d+0*t127*t216*t70*t71*t75*t92/t93
     1           **3
              t219 = -1.6347222733154887d-1*t125*t126*t127*t150*t70*t75
              t220 = 1.923661050931536d+0*t126*t127*(2.1622951122684114d
     1           +0*t209+1.7087761055320938d+0*t208+1.2335503316757068d+
     2           0*t207+2.673190323653546d-1*t206)*t70*t71*t75*t92
              t221 = -1.538928840745229d+1*t125*t126*t127*t139*t70*t75*t
     1           92
              t222 = 1/t73**6.666666666666666d-1
              t223 = 1/t66**3
              t224 = -2*t223*t69
              t225 = 2*t129
              t226 = 1/t74**6.666666666666666d-1
              t227 = 2*t223*t69
              t228 = -2*t129
              t229 = 1.3333333333333333d+0*t136*(t228+t227)+4.4444444444
     1           44444d-1*t135**2*t226+1.3333333333333333d+0*t133*(t225+
     2           t224)+4.444444444444444d-1*t132**2*t222
              t230 = -1.923661050931536d+0*t229*t70*t71
              t231 = 1.5389288407452287d+1*t137*t139*t70
              t232 = -1.5389288407452287d+1*t137*t141*t71
              t233 = 1/t66**6
              t234 = -3.8473221018630716d+1*t233*t70*t75
              t235 = 6.155715362980915d+1*t139*t141*t75
              t236 = t69**2
              t237 = -2.3083932611178434d+1*t236*t71*t75
              t238 = -3.663697685584583d-3*t208*t77*t84
              t239 = 6.058395236642822d-4*t208*t87*t90
              t240 = -2.3718174565385935d-2*t70*t75*t95/t66**6.333333333
     1           333333d+0
              t241 = -1.1961593727239421d+0*t233*t70*t75*t92*t95
              t242 = -7.176956236343652d-1*t236*t71*t75*t92*t95
              t243 = 1/t54**4
              t244 = 2.6666666666666666d+0*t136*t223*t69-2.6666666666666
     1           666d+0*t133*t223*t69+4.444444444444444d-1*t135*t173*t22
     2           6+4.444444444444444d-1*t132*t172*t222
              t245 = -1.923661050931536d+0*t244*t70*t71
              t246 = 7.694644203726144d+0*t139*t174*t70
              t247 = -7.694644203726144d+0*t141*t174*t71
              t248 = 7.694644203726144d+0*t137*t139*t70
              t249 = 7.694644203726144d+0*t137*t141*t71
              t250 = 2.3083932611178434d+1*t236*t71*t75
              t251 = 3.04966d-52*t182*t65
              t252 = 3.04966d-52*t183*t97
              t253 = t161**2
              t254 = 1/t40**5
              t255 = 1/rhob**2.3333333333333334d+0
              t256 = 1/rhob**2.1666666666666665d+0
              t257 = t164**2
              t258 = 1.7854583920998188d-15*t253*t51/(t48**4*t49**2)-2.2
     1           20446049250313d-16*t157*t253*t51/t48**3+1.1102230246251
     2           565d-16*t157*t162*(1.1632736958443765d+0*t256+9.8914196
     3           4955861d-1*t255+6.003214762495226d-1*t254+2.10778258416
     4           39536d-1*t169)*t51-4.0675215258019015d-19*t255*t50+3.21
     5           6395899738507d+1*t257*t47/(t44**4*t45**2)-2.0d+0*t163*t
     6           257*t47/t44**3+1.0d+0*t163*t165*(2.1622951122684114d+0*
     7           t256+1.7087761055320938d+0*t255+1.2335503316757068d+0*t
     8           254+2.673190323653546d-1*t169)*t47-1.7613865241785684d-
     9           3*t255*t46-8.497974591333913d-2*t159*t163*t164*t165-9.8
     :           12069668265515d-18*t157*t159*t161*t162
              t259 = 1/t32**4
              t260 = 1/rhob**7
              t261 = 1/rhob**5.333333333333333d+0
              t262 = 1/rhob**3.6666666666666664d+0
              t263 = 1.3333333333333333d+0*t133*(t228+t224)+1.3333333333
     1           333333d+0*t136*(t227+t225)+4.444444444444444d-1*t173**2
     2           *t226+4.444444444444444d-1*t172**2*t222
              t264 = -1.923661050931536d+0*t263*t70*t71
              t265 = 1.5389288407452287d+1*t139*t174*t70
              t266 = 1.5389288407452287d+1*t141*t174*t71
              t267 = -6.155715362980915d+1*t139*t141*t75
              fnc(iq) = (1.0d+0*t62*t65*t97+5.0d-1*rhob*t33*t38*t52+5.0d
     1           -1*rhoa*t15*t29*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (3.04966d-52*t110*t55*t65*t97+2.57544d-52
     1           *t1*t15*t29*t7+t156*t62+t112*t4)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (3.04966d-52*t169*t55*t65*t97+t184*t62+2.
     1           57544d-52*t30*t34*t38*t52+t171*t33)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t62*(1.0d+0*t65*(-2.220446049250313d
     1           -16*t102*t103*t28*t98+t66*(1.9138549963583074d+0*t139*t
     2           141*t75*t92*t95-5.980796863619711d-2*t229*t70*t71*t92*t
     3           95-4.7846374908957684d-1*t137*t141*t71*t92*t95+4.784637
     4           4908957684d-1*t137*t139*t70*t92*t95+2.0329863913187946d
     5           -2*t141*t150*t75*t95+5.082465978296986d-3*t137*t150*t70
     6           *t95+1.538928840745229d+1*t125*t126*t127*t141*t71*t75*t
     7           92+3.847322101863072d+0*t125*t126*t127*t137*t70*t71*t92
     8           +1.9751631321680768d-2*(t237+t235+t234+t232+t231+t230+1
     9           .923661050931536d+0*t229)*t86*t90-9.087592854964233d-4*
     :           t115*t146*t90-1.1696447245269295d+0*t121*t122*t123*t146
     ;           *t86-6.21814d-2*(t237+t235+t234+t232+t231+t230)*t68*t84
     <           +5.495546528376875d-3*t115*t143*t84+2.0d+0*t117*t118*t1
     =           19*t143*t68+t242+t241+t240+t239+t238+t221+t220+t219+t21
     >           8+t217+t215+t214+t213+t212+t210+t205+t204+t203)-4.78463
     ?           74908957684d-1*t141*t71*t75*t92*t95-1.1961593727239421d
     @           -1*t137*t70*t71*t92*t95+3.9503262643361536d-2*t146*t86*
     1           t90-1.243628d-1*t143*t68*t84-6.101282288702853d-19*t100
     2           *t27-2.0d+0*t104*t105*t106*t24-2.642079786267853d-3*t10
     3           0*t23+t201+t200+t199+t198+t197+t196+t195-rhoa*t190)+1.0
     4           d+0*(5.580255669359999d-103*t193*t243*t56*t59*t64-1.626
     5           4853333333332d-51*t154*t194*t56*t59*t64+8.8888888888888
     6           88d-50*t194*t55*t59*t64-4.0662133333333333d-101*t154*t1
     7           93*t59*t64+1.7777777777777776d-49*t194*t55*t56*t64-8.13
     8           2426666666667d-101*t154*t193*t56*t64+4.444444444444444d
     9           -99*t193*t55*t64+1.7777777777777776d-49*t194*t62*t63-8.
     :           132426666666666d-52*t194*t55*t59*t63+1.86008522312d-103
     ;           *t154*t193*t59*t63-4.0662133333333333d-101*t193*t55*t63
     <           +8.888888888888888d-50*t194*t61*t62-8.132426666666666d-
     =           52*t194*t55*t56*t61+1.86008522312d-103*t154*t193*t56*t6
     >           1-2.0331066666666667d-101*t193*t55*t61+5.58025566935999
     ?           9d-103*t193*t243*t58*t60-1.6264853333333332d-51*t154*t1
     @           94*t58*t60+3.555555555555555d-49*t194*t55*t58*t59-1.626
     1           4853333333334d-100*t154*t193*t58*t59+8.888888888888888d
     2           -99*t193*t55*t58+5.580255669359999d-103*t193*t243*t53*t
     3           57-1.6264853333333332d-51*t154*t194*t53*t57+1.777777777
     4           7777776d-49*t194*t53*t55*t56-8.132426666666667d-101*t15
     5           4*t193*t53*t56+2.222222222222222d-99*t193*t53*t55)*t97+
     6           2.0d+0*t153*t155)+t110*t55*(3.04966d-52*t155*t97+3.0496
     7           6d-52*t153*t65+3.04966d-52*t156)-8.132426666666666d-52*
     8           t194*t55*t65*t97+1.86008522312d-103*t154*t193*t65*t97+t
     9           4*(5.0d-1*rhoa*t29*(1.7777777777777776d-49*t194*t6*t7*t
     :           9+1.7777777777777776d-49*t14*t194*t7*t9-1.373568d-51*t1
     ;           2*t194*t7*t9-1.373568d-100*t108*t193*t6*t9-2.4724223999
     <           999997d-100*t108*t14*t193*t9+5.306312954879999d-103*t10
     =           8*t12*t193*t9+6.367575545855999d-152*t14*t191*t192*t9+2
     >           .222222222222222d-99*t193*t6*t7+8.0d-99*t14*t193*t7-1.2
     ?           362111999999999d-100*t13*t193*t7-3.43392d-101*t12*t193*
     @           t7+2.3111111111111113d-98*t11*t193*t7-2.747136d-51*t10*
     1           t108*t194*t6+1.5918938864639998d-102*t10*t191*t193*t6+1
     2           .7777777777777776d-49*t13*t194*t4+8.888888888888888d-50
     3           *t12*t194*t4-2.7471359999999995d-150*t108*t14*t192+2.12
     4           25251819519997d-152*t108*t13*t192-1.53839616d-149*t108*
     5           t11*t192+2.5470302183424d-201*t11*t191/rhoa**8.66666666
     6           6666666d+0)+1.0d+0*t111*t29+5.0d-1*rhoa*t15*t190+1.0d+0
     7           *t107*t15+1.0d+0*rhoa*t107*t111)+t110*(5.15088d-52*t112
     8           -4.2923999999999995d-52*t15*t29)*t7+t1*(2.57544d-52*t11
     9           1*t29+2.57544d-52*t107*t15)*t7+2.6531564774399996d-103*
     :           t108*t109*t15*t29)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t62*(1.0d+0*(5.580255669359999d-103*
     1           t110*t169*t243*t56*t59*t64-4.0662133333333333d-101*t110
     2           *t154*t169*t59*t64-8.132426666666667d-101*t110*t154*t16
     3           9*t56*t64+4.444444444444444d-99*t110*t169*t55*t64+1.860
     4           08522312d-103*t110*t154*t169*t59*t63-4.0662133333333333
     5           d-101*t110*t169*t55*t63+1.86008522312d-103*t110*t154*t1
     6           69*t56*t61-2.0331066666666667d-101*t110*t169*t55*t61+5.
     7           580255669359999d-103*t110*t169*t243*t58*t60-1.626485333
     8           3333334d-100*t110*t154*t169*t58*t59+8.888888888888888d-
     9           99*t110*t169*t55*t58+5.580255669359999d-103*t110*t169*t
     :           243*t53*t57-8.132426666666667d-101*t110*t154*t169*t53*t
     ;           56+2.222222222222222d-99*t110*t169*t53*t55)*t97+1.0d+0*
     <           t65*(t66*(7.176956236343652d-1*t236*t71*t75*t92*t95-5.9
     =           80796863619711d-2*t244*t70*t71*t92*t95-2.39231874544788
     >           42d-1*t141*t174*t71*t92*t95+2.3923187454478842d-1*t137*
     ?           t141*t71*t92*t95+2.3923187454478842d-1*t139*t174*t70*t9
     @           2*t95+2.3923187454478842d-1*t137*t139*t70*t92*t95+2.541
     1           232989148493d-3*t150*t174*t70*t95+2.541232989148493d-3*
     2           t137*t150*t70*t95+1.923661050931536d+0*t125*t126*t127*t
     3           174*t70*t71*t92+1.923661050931536d+0*t125*t126*t127*t13
     4           7*t70*t71*t92+1.9751631321680768d-2*(t250+t249+t248+t24
     5           7+t246+t245+1.923661050931536d+0*t244+t234)*t86*t90-4.5
     6           437964274821163d-4*t115*t179*t90-4.5437964274821163d-4*
     7           t115*t146*t90-5.848223622634647d-1*t121*t122*t123*t179*
     8           t86-5.848223622634647d-1*t121*t122*t123*t146*t86-6.2181
     9           4d-2*(t250+t249+t248+t247+t246+t245+t234)*t68*t84+2.747
     :           773264188437d-3*t115*t177*t84+2.747773264188437d-3*t115
     ;           *t143*t84+1.0d+0*t117*t118*t119*t177*t68+1.0d+0*t117*t1
     <           18*t119*t143*t68+t241+t240+t239+t238+t221+t220+t219+t21
     =           8+t217+t215+t214+t213+t212+t210+t205+t204+t203)+t201+t2
     >           00+t199+t198+t197+t196+t195+t181+t180+t178+t149+t147+t1
     ?           44)+1.0d+0*t153*t183+1.0d+0*t155*t182)+1.86008522312d-1
     @           03*t110*t154*t169*t65*t97+t110*(t252+t251)*t55+3.04966d
     1           -52*t156*t169*t55)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t62*(1.0d+0*(-1.6264853333333332d-51
     1           *t154*t262*t56*t59*t64+5.580255669359999d-103*t243*t261
     2           *t56*t59*t64+8.888888888888888d-50*t262*t55*t59*t64-4.0
     3           662133333333333d-101*t154*t261*t59*t64+1.77777777777777
     4           76d-49*t262*t55*t56*t64-8.132426666666667d-101*t154*t26
     5           1*t56*t64+4.444444444444444d-99*t261*t55*t64+1.77777777
     6           77777776d-49*t262*t62*t63-8.132426666666666d-52*t262*t5
     7           5*t59*t63+1.86008522312d-103*t154*t261*t59*t63-4.066213
     8           3333333333d-101*t261*t55*t63+8.888888888888888d-50*t262
     9           *t61*t62-8.132426666666666d-52*t262*t55*t56*t61+1.86008
     :           522312d-103*t154*t261*t56*t61-2.0331066666666667d-101*t
     ;           261*t55*t61-1.6264853333333332d-51*t154*t262*t58*t60+5.
     <           580255669359999d-103*t243*t261*t58*t60+3.55555555555555
     =           5d-49*t262*t55*t58*t59-1.6264853333333334d-100*t154*t26
     >           1*t58*t59+8.888888888888888d-99*t261*t55*t58-1.62648533
     ?           33333332d-51*t154*t262*t53*t57+5.580255669359999d-103*t
     @           243*t261*t53*t57+1.7777777777777776d-49*t262*t53*t55*t5
     1           6-8.132426666666667d-101*t154*t261*t53*t56+2.2222222222
     2           22222d-99*t261*t53*t55)*t97+1.0d+0*t65*(t66*(-1.9138549
     3           963583074d+0*t139*t141*t75*t92*t95-5.980796863619711d-2
     4           *t263*t70*t71*t92*t95+4.7846374908957684d-1*t141*t174*t
     5           71*t92*t95+4.7846374908957684d-1*t139*t174*t70*t92*t95-
     6           2.0329863913187946d-2*t141*t150*t75*t95+5.0824659782969
     7           86d-3*t150*t174*t70*t95-1.538928840745229d+1*t125*t126*
     8           t127*t141*t71*t75*t92+3.847322101863072d+0*t125*t126*t1
     9           27*t174*t70*t71*t92+1.9751631321680768d-2*(t267+t266+t2
     :           65+t264+1.923661050931536d+0*t263+t237+t234)*t86*t90-9.
     ;           087592854964233d-4*t115*t179*t90-1.1696447245269295d+0*
     <           t121*t122*t123*t179*t86-6.21814d-2*(t267+t266+t265+t264
     =           +t237+t234)*t68*t84+5.495546528376875d-3*t115*t177*t84+
     >           2.0d+0*t117*t118*t119*t177*t68+t242+t241+t240+t239+t238
     ?           +t221+t220+t219+t218+t217+t215+t214+t213+t212+t210+t205
     @           +t204+t203)+4.7846374908957684d-1*t141*t71*t75*t92*t95-
     1           1.1961593727239421d-1*t174*t70*t71*t92*t95+3.9503262643
     2           361536d-2*t179*t86*t90-1.243628d-1*t177*t68*t84-2.22044
     3           6049250313d-16*t157*t161*t162*t51-6.101282288702853d-19
     4           *t159*t50-2.0d+0*t163*t164*t165*t47-2.642079786267853d-
     5           3*t159*t46-rhob*t258+t201+t200+t199+t198+t197+t196+t195
     6           )+2.0d+0*t182*t183)-8.132426666666666d-52*t262*t55*t65*
     7           t97+1.86008522312d-103*t154*t261*t65*t97+t33*(5.0d-1*rh
     8           ob*t52*(-2.747136d-51*t167*t262*t37*t6+1.59189388646399
     9           98d-102*t259*t261*t37*t6+1.7777777777777776d-49*t262*t3
     :           4*t36*t6-1.373568d-100*t167*t261*t36*t6+2.2222222222222
     ;           22d-99*t261*t34*t6+1.7777777777777776d-49*t14*t262*t34*
     <           t36-1.373568d-51*t12*t262*t34*t36-2.4724223999999997d-1
     =           00*t14*t167*t261*t36+5.306312954879999d-103*t12*t167*t2
     >           61*t36+6.367575545855999d-152*t14*t259*t260*t36+8.0d-99
     ?           *t14*t261*t34-1.2362111999999999d-100*t13*t261*t34-3.43
     @           392d-101*t12*t261*t34+2.3111111111111113d-98*t11*t261*t
     1           34+1.7777777777777776d-49*t13*t262*t33+8.88888888888888
     2           8d-50*t12*t262*t33-2.7471359999999995d-150*t14*t167*t26
     3           0+2.1225251819519997d-152*t13*t167*t260-1.53839616d-149
     4           *t11*t167*t260+2.5470302183424d-201*t11*t259/rhob**8.66
     5           6666666666666d+0)+1.0d+0*t170*t52+5.0d-1*rhob*t258*t38+
     6           1.0d+0*t166*t38+1.0d+0*rhob*t166*t170)+t169*(t252+t251+
     7           3.04966d-52*t184)*t55+t169*t34*(5.15088d-52*t171-4.2923
     8           999999999995d-52*t38*t52)+t30*t34*(2.57544d-52*t170*t52
     9           +2.57544d-52*t166*t38)+2.6531564774399996d-103*t167*t16
     :           8*t38*t52)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taua
              t21 = 5.15088d-3*(t20+gammaaa*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammaaa**2
              t25 = 1/rhoa**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammaaa*t18*t22*t31+t26*t29*t30+gammaaa*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = 1/rhoa**3.6666666666666664d+0
              t35 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d+
     1           0*gammaaa*t34
              t36 = 1/t21**3
              t37 = 1/rhoa**6.333333333333333d+0
              t38 = -3.3333333333333337d+0*t18*t22*t32*taua-6.6666666666
     1           66667d+0*t18*t26*t28*t29*taua-3.3333333333333337d+0*gam
     2           maaa*t25*t26*t27*taua-5.333333333333333d+0*t23*t24*t26*
     3           t37-1.030176d-2*t29*t30*t35*t36-1.030176d-2*gammaaa*t18
     4           *t27*t28*t35*t36-1.030176d-2*t23*t24*t25*t35*t36-5.1508
     5           8d-3*t26*t28*t32*t35-5.15088d-3*gammaaa*t18*t26*t31*t35
     6           -2.6666666666666666d+0*gammaaa*t22*t31*t34-2.6666666666
     7           666666d+0*gammaaa*t26*t27*t28*t34
              t39 = 1/t11
              t40 = 1/t2**3
              t41 = 1/rhoa**1.3333333333333333d+0
              t42 = 1/rhoa**1.1666666666666667d+0
              t43 = -9.970917392951799d-1*t42-7.418564737168958d-1*t41-4
     1           .002143174996817d-1*t40-1.264669550498372d-1*t19
              t44 = 1/t10**2
              t45 = 1/t7
              t46 = -1.8533958105157808d+0*t42-1.2815820791490704d+0*t41
     1           -8.223668877838045d-1*t40-1.6039141941921276d-1*t19
              t47 = 1/t6**2
              t48 = 1.0d+0*t45*t46*t47*t9+1.3210398931339265d-3*t41*t8+1
     1           .1102230246251565d-16*t13*t39*t43*t44+3.050641144351426
     2           4d-19*t12*t41
              t49 = 1.0d+0*rhoa*t17*t33*t48*wght+1.0d+0*rhoa*t14*t17*t38
     1           *wght+1.0d+0*t14*t17*t33*wght
              t50 = 1/rhoa**8
              t51 = -1.030176d-2*t23*t24*t36*t50-1.030176d-2*t18*t29*t30
     1           *t36-1.030176d-2*gammaaa*t25*t27*t28*t36-5.15088d-3*t18
     2           *t26*t28*t32-5.15088d-3*gammaaa*t25*t26*t31+t18*t22*t31
     3           +t18*t26*t27*t28+2*gammaaa*t23*t25*t26
              t52 = 1/rhoa**7
              t53 = 1/rhoa**4.333333333333333d+0
              t54 = -2.060352d-2*gammaaa*t27*t28*t36*t53-1.030176d-2*gam
     1           maaa*t26*t31*t53+2.0d+0*gammaaa*t26*t27*t53-2.060352d-2
     2           *t23*t24*t36*t52-2.060352d-2*t19*t29*t30*t36-1.030176d-
     3           2*t19*t26*t28*t32+2.0d+0*t19*t22*t32+4.0d+0*t19*t26*t28
     4           *t29
              t55 = taua**2
              t56 = 1/t55
              t57 = t35**2
              t58 = 1/rhoa**2
              t59 = 1/t21**4
              t60 = 1/rhoa**4.666666666666667d+0
              t61 = 8.88888888888889d+0*t34*taua+9.777777777777779d+0*ga
     1           mmaaa*t60
              t62 = t43**2
              t63 = 1/t2**5
              t64 = 1/rhoa**2.3333333333333334d+0
              t65 = 1/rhoa**2.1666666666666665d+0
              t66 = t46**2
              t67 = 1.25d-1*gammaaa*t14*t51*wght+1.25d-1*t14*t33*wght
              t68 = 1/rhoa**3.3333333333333337d+0
              t69 = 1/rhoa**6
              fnc(iq) = 1.0d+0*rhoa*t14*t17*t22*t33*wght+fnc(iq)
              Amat(iq,D1_RA) = -5.15088d-3*rhoa*t14*t17*t26*t33*t35*wght
     1           +1.25d-1*gammaaa*t14*t15*t16*t22*t33*wght+t22*t49+Amat(
     2           iq,D1_RA)
              Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t14*t17*t22*t51*wght-5.15088
     1           d-3*t14*t17*t19*t26*t33*wght-1.25d-1*t14*t16*t22*t33*wg
     2           ht+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = 1.25d-1*gammaaa*t14*t22*t33*t56*wght+1.0d
     1           +0*rhoa*t14*t17*t22*t54*wght-1.030176d-2*t1*t14*t17*t26
     2           *t33*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t22*(1.0d+0*rhoa*t14*t17*(2.666666666
     1           6666666d+1*gammaaa*t26*t27*t37*taua+1.373568d-1*t18*t28
     2           *t29*t35*t36*taua+6.867840000000001d-2*gammaaa*t25*t27*
     3           t35*t36*taua+3.4339200000000003d-2*t18*t26*t32*t35*taua
     4           +8.88888888888889d+0*t22*t32*t34*taua+1.777777777777777
     5           8d+1*t26*t28*t29*t34*taua-1.030176d-2*t29*t30*t36*t61-1
     6           .030176d-2*gammaaa*t18*t27*t28*t36*t61-1.030176d-2*t23*
     7           t24*t25*t36*t61-5.15088d-3*t26*t28*t32*t61-5.15088d-3*g
     8           ammaaa*t18*t26*t31*t61+9.777777777777779d+0*gammaaa*t22
     9           *t31*t60+9.777777777777779d+0*gammaaa*t26*t27*t28*t60+1
     :           .591893886464d-4*t29*t30*t57*t59+1.591893886464d-4*gamm
     ;           aaa*t18*t27*t28*t57*t59+1.591893886464d-4*t23*t24*t25*t
     <           57*t59+5.30631295488d-5*t28*t32*t36*t57+5.30631295488d-
     =           5*gammaaa*t18*t31*t36*t57+2.2222222222222224d+1*t25*t26
     >           *t29*t55+1.0988544d-1*t23*t24*t35*t36*t37+5.494272d-2*g
     ?           ammaaa*t27*t28*t34*t35*t36+2.747136d-2*gammaaa*t26*t31*
     @           t34*t35+3.377777777777778d+1*t23*t24*t26/rhoa**7.333333
     1           333333333d+0)*wght+1.0d+0*rhoa*t17*t33*(3.2163958997385
     2           07d+1*t66*t9/(t6**4*t7**2)-2.0d+0*t45*t66*t9/t6**3+1.0d
     3           +0*t45*t47*(2.1622951122684114d+0*t65+1.708776105532093
     4           8d+0*t64+1.2335503316757068d+0*t63+2.673190323653546d-1
     5           *t18)*t9-1.7613865241785684d-3*t64*t8+1.110223024625156
     6           5d-16*t13*t39*t44*(1.1632736958443765d+0*t65+9.89141964
     7           955861d-1*t64+6.003214762495226d-1*t63+2.10778258416395
     8           36d-1*t18)-4.0675215258019015d-19*t12*t64-2.22044604925
     9           0313d-16*t13*t39*t62/t10**3+1.7854583920998188d-15*t13*
     :           t62/(t10**4*t11**2)-8.497974591333913d-2*t41*t45*t46*t4
     ;           7-9.812069668265515d-18*t39*t41*t43*t44)*wght+1.25d-1*g
     <           ammaaa*t14*t16*t33*t58*wght+2.0d+0*rhoa*t17*t38*t48*wgh
     =           t+2.0d+0*t17*t33*t48*wght+1.25d-1*gammaaa*t15*t16*t33*t
     >           48*wght+2.0d+0*t14*t17*t38*wght+1.25d-1*gammaaa*t14*t15
     ?           *t16*t38*wght)+t26*(-5.15088d-3*rhoa*t14*t17*t33*t61*wg
     @           ht-5.15088d-3*rhoa*t17*t33*t35*t48*wght-5.15088d-3*rhoa
     1           *t14*t17*t35*t38*wght-5.15088d-3*t14*t17*t33*t35*wght-5
     2           .15088d-3*t35*t49)+t15*t16*t22*(1.25d-1*gammaaa*t33*t48
     3           *wght+1.25d-1*gammaaa*t14*t38*wght)-1.25d-1*gammaaa*t14
     4           *t16*t22*t33*t58*wght+5.30631295488d-5*rhoa*t14*t17*t33
     5           *t36*t57*wght-1.28772d-3*gammaaa*t14*t15*t16*t26*t33*t3
     6           5*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t22*(1.0d+0*rhoa*t14*t17*(3.43392000
     1           00000003d-2*gammaaa*t27*t36*t50*taua+6.867840000000001d
     2           -2*t25*t28*t29*t36*taua+1.7169600000000002d-2*t25*t26*t
     3           32*taua-3.3333333333333337d+0*t25*t26*t27*taua+1.591893
     4           886464d-4*t23*t24*t35*t50*t59+1.591893886464d-4*t18*t29
     5           *t30*t35*t59+1.591893886464d-4*gammaaa*t25*t27*t28*t35*
     6           t59+5.494272d-2*gammaaa*t27*t28*t36*t37+2.747136d-2*gam
     7           maaa*t26*t31*t37-1.0666666666666666d+1*gammaaa*t23*t26*
     8           t37+5.30631295488d-5*t18*t28*t32*t35*t36+5.30631295488d
     9           -5*gammaaa*t25*t31*t35*t36-1.030176d-2*t18*t27*t28*t35*
     :           t36-2.060352d-2*gammaaa*t23*t25*t35*t36+2.747136d-2*t29
     ;           *t30*t34*t36+8.241408d-2*t23*t24*t36/rhoa**9-5.15088d-3
     <           *t18*t26*t31*t35+1.373568d-2*t26*t28*t32*t34-2.66666666
     =           66666666d+0*t22*t31*t34-2.6666666666666666d+0*t26*t27*t
     >           28*t34)*wght+1.0d+0*rhoa*t17*t48*t51*wght+1.0d+0*t14*t1
     ?           7*t51*wght-1.25d-1*t16*t33*t48*wght-1.25d-1*t14*t16*t38
     @           *wght-1.25d-1*t14*t15*t16*t33*wght)+t18*t26*(1.373568d-
     1           2*t14*t17*t33*wght-5.15088d-3*t49)-5.15088d-3*rhoa*t14*
     2           t17*t26*t35*t51*wght+5.30631295488d-5*t14*t17*t19*t33*t
     3           35*t36*wght+6.4386d-4*t14*t16*t26*t33*t35*wght-6.4386d-
     4           4*gammaaa*t14*t16*t26*t33*t34*wght+t15*t16*t22*t67+Cmat
     5           2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = 1.0d+0*rhoa*t14*t17*t22*(1.59189388
     1           6464d-4*gammaaa*t27*t28*t50*t59+1.591893886464d-4*t25*t
     2           29*t30*t59+1.591893886464d-4*t23*t24*t59/rhoa**1.066666
     3           6666666666d+1+5.30631295488d-5*gammaaa*t31*t36*t50-4.12
     4           0704d-2*gammaaa*t23*t36*t50+5.30631295488d-5*t25*t28*t3
     5           2*t36-2.060352d-2*t25*t27*t28*t36-1.030176d-2*t25*t26*t
     6           31+2*t23*t25*t26)*wght+5.30631295488d-5*t14*t17*t33*t36
     7           *t53*wght-1.030176d-2*t14*t17*t19*t26*t51*wght-2.5d-1*t
     8           14*t16*t22*t51*wght+1.28772d-3*t14*t16*t18*t26*t33*wght
     9           +Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t22*(1.0d+0*rhoa*t14*t17*(1.373568d-1
     1           *t28*t29*t36*t53*taua+3.4339200000000003d-2*t26*t32*t53
     2           *taua-1.3333333333333333d+1*t26*t29*t53*taua+6.86784000
     3           0000001d-2*gammaaa*t27*t36*t52*taua+3.183787772928d-4*g
     4           ammaaa*t27*t28*t35*t53*t59+3.183787772928d-4*t23*t24*t3
     5           5*t52*t59+3.183787772928d-4*t19*t29*t30*t35*t59+1.06126
     6           2590976d-4*gammaaa*t31*t35*t36*t53-2.060352d-2*gammaaa*
     7           t27*t35*t36*t53+1.4422464000000002d-1*t23*t24*t36*t50+1
     8           .061262590976d-4*t19*t28*t32*t35*t36-4.120704d-2*t19*t2
     9           8*t29*t35*t36+3.4339200000000003d-2*t18*t29*t30*t36+8.9
     :           28192d-2*gammaaa*t25*t27*t28*t36-1.030176d-2*t19*t26*t3
     ;           2*t35+1.7169600000000002d-2*t18*t26*t28*t32-3.333333333
     <           3333337d+0*t18*t22*t32+4.464096d-2*gammaaa*t25*t26*t31-
     =           6.666666666666667d+0*t18*t26*t28*t29-8.666666666666666d
     >           +0*gammaaa*t25*t26*t27)*wght+1.25d-1*gammaaa*t33*t48*t5
     ?           6*wght+1.25d-1*gammaaa*t14*t38*t56*wght+1.25d-1*gammaaa
     @           *t14*t15*t33*t56*wght+1.0d+0*rhoa*t17*t48*t54*wght+1.0d
     1           +0*t14*t17*t54*wght)+t19*t26*(1.7169600000000002d-2*t14
     2           *t17*t33*wght-1.030176d-2*t49)-6.4386d-4*gammaaa*t14*t2
     3           6*t33*t35*t56*wght-1.25d-1*gammaaa*t14*t15*t22*t33*t56*
     4           wght-5.15088d-3*rhoa*t14*t17*t26*t35*t54*wght+1.25d-1*g
     5           ammaaa*t14*t15*t16*t22*t54*wght+1.061262590976d-4*t1*t1
     6           4*t17*t33*t35*t36*wght-1.28772d-3*gammaaa*t14*t16*t18*t
     7           26*t33*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.061262590976d-4*t14*t17*t33*t36*t6
     1           8*wght+1.0d+0*rhoa*t14*t17*t22*(3.183787772928d-4*t29*t
     2           30*t53*t59+3.183787772928d-4*gammaaa*t27*t28*t52*t59+3.
     3           183787772928d-4*t23*t24*t59/rhoa**9.666666666666666d+0+
     4           1.061262590976d-4*t28*t32*t36*t53-4.120704d-2*t28*t29*t
     5           36*t53-2.060352d-2*t27*t28*t36*t53-1.030176d-2*t26*t32*
     6           t53-1.030176d-2*t26*t31*t53+2.0d+0*t26*t27*t53+1.061262
     7           590976d-4*gammaaa*t31*t36*t52-2.060352d-2*gammaaa*t27*t
     8           36*t52-4.120704d-2*gammaaa*t23*t36*t52)*wght-6.4386d-4*
     9           gammaaa*t14*t18*t26*t33*t56*wght-5.15088d-3*t14*t17*t19
     :           *t26*t54*wght-1.25d-1*t14*t16*t22*t54*wght-1.030176d-2*
     ;           t1*t14*t17*t26*t51*wght+1.28772d-3*t14*t16*t19*t26*t33*
     <           wght+t22*t56*t67+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = -2.5d-1*gammaaa*t14*t22*t33*wght/taua
     1           **3+1.0d+0*rhoa*t14*t17*t22*(6.367575545856d-4*gammaaa*
     2           t27*t28*t59*t69+2.122525181952d-4*gammaaa*t31*t36*t69-8
     3           .241408d-2*gammaaa*t27*t36*t69+6.367575545856d-4*t29*t3
     4           0*t59*t68+2.122525181952d-4*t28*t32*t36*t68-1.6482816d-
     5           1*t28*t29*t36*t68-4.120704d-2*t26*t32*t68+8.0d+0*t26*t2
     6           9*t68+6.367575545856d-4*t23*t24*t59/rhoa**8.66666666666
     7           6666d+0)*wght+2.122525181952d-4*t14*t17*t33*t36*t64*wgh
     8           t+2.5d-1*gammaaa*t14*t22*t54*t56*wght-2.57544d-3*gammaa
     9           a*t14*t19*t26*t33*t56*wght-2.060352d-2*t1*t14*t17*t26*t
     :           54*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taua
              t21 = 5.15088d-3*(t20+gammaaa*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammaaa**2
              t25 = 1/rhoa**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammaaa*t18*t22*t31+t26*t29*t30+gammaaa*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = 1/rhoa**3.6666666666666664d+0
              t35 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d+
     1           0*gammaaa*t34
              t36 = 1/t21**3
              t37 = 1/rhoa**6.333333333333333d+0
              t38 = -3.3333333333333337d+0*t18*t22*t32*taua-6.6666666666
     1           66667d+0*t18*t26*t28*t29*taua-3.3333333333333337d+0*gam
     2           maaa*t25*t26*t27*taua-5.333333333333333d+0*t23*t24*t26*
     3           t37-1.030176d-2*t29*t30*t35*t36-1.030176d-2*gammaaa*t18
     4           *t27*t28*t35*t36-1.030176d-2*t23*t24*t25*t35*t36-5.1508
     5           8d-3*t26*t28*t32*t35-5.15088d-3*gammaaa*t18*t26*t31*t35
     6           -2.6666666666666666d+0*gammaaa*t22*t31*t34-2.6666666666
     7           666666d+0*gammaaa*t26*t27*t28*t34
              t39 = 1/t11
              t40 = 1/t2**3
              t41 = 1/rhoa**1.3333333333333333d+0
              t42 = 1/rhoa**1.1666666666666667d+0
              t43 = -9.970917392951799d-1*t42-7.418564737168958d-1*t41-4
     1           .002143174996817d-1*t40-1.264669550498372d-1*t19
              t44 = 1/t10**2
              t45 = 1/t7
              t46 = -1.8533958105157808d+0*t42-1.2815820791490704d+0*t41
     1           -8.223668877838045d-1*t40-1.6039141941921276d-1*t19
              t47 = 1/t6**2
              t48 = 1.0d+0*t45*t46*t47*t9+1.3210398931339265d-3*t41*t8+1
     1           .1102230246251565d-16*t13*t39*t43*t44+3.050641144351426
     2           4d-19*t12*t41
              t49 = 1.0d+0*rhoa*t17*t33*t48*wght+1.0d+0*rhoa*t14*t17*t38
     1           *wght+1.0d+0*t14*t17*t33*wght
              t50 = 1/rhoa**8
              t51 = -1.030176d-2*t23*t24*t36*t50-1.030176d-2*t18*t29*t30
     1           *t36-1.030176d-2*gammaaa*t25*t27*t28*t36-5.15088d-3*t18
     2           *t26*t28*t32-5.15088d-3*gammaaa*t25*t26*t31+t18*t22*t31
     3           +t18*t26*t27*t28+2*gammaaa*t23*t25*t26
              t52 = 1/rhoa**7
              t53 = 1/rhoa**4.333333333333333d+0
              t54 = -2.060352d-2*gammaaa*t27*t28*t36*t53-1.030176d-2*gam
     1           maaa*t26*t31*t53+2.0d+0*gammaaa*t26*t27*t53-2.060352d-2
     2           *t23*t24*t36*t52-2.060352d-2*t19*t29*t30*t36-1.030176d-
     3           2*t19*t26*t28*t32+2.0d+0*t19*t22*t32+4.0d+0*t19*t26*t28
     4           *t29
              t55 = taua**2
              t56 = 1/t55
              t57 = t35**2
              t58 = 1/rhoa**2
              t59 = 1/t21**4
              t60 = 1/rhoa**4.666666666666667d+0
              t61 = 8.88888888888889d+0*t34*taua+9.777777777777779d+0*ga
     1           mmaaa*t60
              t62 = t43**2
              t63 = 1/t2**5
              t64 = 1/rhoa**2.3333333333333334d+0
              t65 = 1/rhoa**2.1666666666666665d+0
              t66 = t46**2
              t67 = 1.25d-1*gammaaa*t14*t51*wght+1.25d-1*t14*t33*wght
              t68 = 1/rhoa**3.3333333333333337d+0
              t69 = 1/rhoa**6
              fnc(iq) = 1.0d+0*rhoa*t14*t17*t22*t33*wght+fnc(iq)
              Amat(iq,D1_RA) = -5.15088d-3*rhoa*t14*t17*t26*t33*t35*wght
     1           +1.25d-1*gammaaa*t14*t15*t16*t22*t33*wght+t22*t49+Amat(
     2           iq,D1_RA)
              Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t14*t17*t22*t51*wght-5.15088
     1           d-3*t14*t17*t19*t26*t33*wght-1.25d-1*t14*t16*t22*t33*wg
     2           ht+Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = 1.25d-1*gammaaa*t14*t22*t33*t56*wght+1.0d
     1           +0*rhoa*t14*t17*t22*t54*wght-1.030176d-2*t1*t14*t17*t26
     2           *t33*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t22*(1.0d+0*rhoa*t14*t17*(2.666666666
     1           6666666d+1*gammaaa*t26*t27*t37*taua+1.373568d-1*t18*t28
     2           *t29*t35*t36*taua+6.867840000000001d-2*gammaaa*t25*t27*
     3           t35*t36*taua+3.4339200000000003d-2*t18*t26*t32*t35*taua
     4           +8.88888888888889d+0*t22*t32*t34*taua+1.777777777777777
     5           8d+1*t26*t28*t29*t34*taua-1.030176d-2*t29*t30*t36*t61-1
     6           .030176d-2*gammaaa*t18*t27*t28*t36*t61-1.030176d-2*t23*
     7           t24*t25*t36*t61-5.15088d-3*t26*t28*t32*t61-5.15088d-3*g
     8           ammaaa*t18*t26*t31*t61+9.777777777777779d+0*gammaaa*t22
     9           *t31*t60+9.777777777777779d+0*gammaaa*t26*t27*t28*t60+1
     :           .591893886464d-4*t29*t30*t57*t59+1.591893886464d-4*gamm
     ;           aaa*t18*t27*t28*t57*t59+1.591893886464d-4*t23*t24*t25*t
     <           57*t59+5.30631295488d-5*t28*t32*t36*t57+5.30631295488d-
     =           5*gammaaa*t18*t31*t36*t57+2.2222222222222224d+1*t25*t26
     >           *t29*t55+1.0988544d-1*t23*t24*t35*t36*t37+5.494272d-2*g
     ?           ammaaa*t27*t28*t34*t35*t36+2.747136d-2*gammaaa*t26*t31*
     @           t34*t35+3.377777777777778d+1*t23*t24*t26/rhoa**7.333333
     1           333333333d+0)*wght+1.0d+0*rhoa*t17*t33*(3.2163958997385
     2           07d+1*t66*t9/(t6**4*t7**2)-2.0d+0*t45*t66*t9/t6**3+1.0d
     3           +0*t45*t47*(2.1622951122684114d+0*t65+1.708776105532093
     4           8d+0*t64+1.2335503316757068d+0*t63+2.673190323653546d-1
     5           *t18)*t9-1.7613865241785684d-3*t64*t8+1.110223024625156
     6           5d-16*t13*t39*t44*(1.1632736958443765d+0*t65+9.89141964
     7           955861d-1*t64+6.003214762495226d-1*t63+2.10778258416395
     8           36d-1*t18)-4.0675215258019015d-19*t12*t64-2.22044604925
     9           0313d-16*t13*t39*t62/t10**3+1.7854583920998188d-15*t13*
     :           t62/(t10**4*t11**2)-8.497974591333913d-2*t41*t45*t46*t4
     ;           7-9.812069668265515d-18*t39*t41*t43*t44)*wght+1.25d-1*g
     <           ammaaa*t14*t16*t33*t58*wght+2.0d+0*rhoa*t17*t38*t48*wgh
     =           t+2.0d+0*t17*t33*t48*wght+1.25d-1*gammaaa*t15*t16*t33*t
     >           48*wght+2.0d+0*t14*t17*t38*wght+1.25d-1*gammaaa*t14*t15
     ?           *t16*t38*wght)+t26*(-5.15088d-3*rhoa*t14*t17*t33*t61*wg
     @           ht-5.15088d-3*rhoa*t17*t33*t35*t48*wght-5.15088d-3*rhoa
     1           *t14*t17*t35*t38*wght-5.15088d-3*t14*t17*t33*t35*wght-5
     2           .15088d-3*t35*t49)+t15*t16*t22*(1.25d-1*gammaaa*t33*t48
     3           *wght+1.25d-1*gammaaa*t14*t38*wght)-1.25d-1*gammaaa*t14
     4           *t16*t22*t33*t58*wght+5.30631295488d-5*rhoa*t14*t17*t33
     5           *t36*t57*wght-1.28772d-3*gammaaa*t14*t15*t16*t26*t33*t3
     6           5*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = t22*(1.0d+0*rhoa*t14*t17*(3.43392000
     1           00000003d-2*gammaaa*t27*t36*t50*taua+6.867840000000001d
     2           -2*t25*t28*t29*t36*taua+1.7169600000000002d-2*t25*t26*t
     3           32*taua-3.3333333333333337d+0*t25*t26*t27*taua+1.591893
     4           886464d-4*t23*t24*t35*t50*t59+1.591893886464d-4*t18*t29
     5           *t30*t35*t59+1.591893886464d-4*gammaaa*t25*t27*t28*t35*
     6           t59+5.494272d-2*gammaaa*t27*t28*t36*t37+2.747136d-2*gam
     7           maaa*t26*t31*t37-1.0666666666666666d+1*gammaaa*t23*t26*
     8           t37+5.30631295488d-5*t18*t28*t32*t35*t36+5.30631295488d
     9           -5*gammaaa*t25*t31*t35*t36-1.030176d-2*t18*t27*t28*t35*
     :           t36-2.060352d-2*gammaaa*t23*t25*t35*t36+2.747136d-2*t29
     ;           *t30*t34*t36+8.241408d-2*t23*t24*t36/rhoa**9-5.15088d-3
     <           *t18*t26*t31*t35+1.373568d-2*t26*t28*t32*t34-2.66666666
     =           66666666d+0*t22*t31*t34-2.6666666666666666d+0*t26*t27*t
     >           28*t34)*wght+1.0d+0*rhoa*t17*t48*t51*wght+1.0d+0*t14*t1
     ?           7*t51*wght-1.25d-1*t16*t33*t48*wght-1.25d-1*t14*t16*t38
     @           *wght-1.25d-1*t14*t15*t16*t33*wght)+t18*t26*(1.373568d-
     1           2*t14*t17*t33*wght-5.15088d-3*t49)-5.15088d-3*rhoa*t14*
     2           t17*t26*t35*t51*wght+5.30631295488d-5*t14*t17*t19*t33*t
     3           35*t36*wght+6.4386d-4*t14*t16*t26*t33*t35*wght-6.4386d-
     4           4*gammaaa*t14*t16*t26*t33*t34*wght+t15*t16*t22*t67+Cmat
     5           2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = 1.0d+0*rhoa*t14*t17*t22*(1.59189388
     1           6464d-4*gammaaa*t27*t28*t50*t59+1.591893886464d-4*t25*t
     2           29*t30*t59+1.591893886464d-4*t23*t24*t59/rhoa**1.066666
     3           6666666666d+1+5.30631295488d-5*gammaaa*t31*t36*t50-4.12
     4           0704d-2*gammaaa*t23*t36*t50+5.30631295488d-5*t25*t28*t3
     5           2*t36-2.060352d-2*t25*t27*t28*t36-1.030176d-2*t25*t26*t
     6           31+2*t23*t25*t26)*wght+5.30631295488d-5*t14*t17*t33*t36
     7           *t53*wght-1.030176d-2*t14*t17*t19*t26*t51*wght-2.5d-1*t
     8           14*t16*t22*t51*wght+1.28772d-3*t14*t16*t18*t26*t33*wght
     9           +Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = t22*(1.0d+0*rhoa*t14*t17*(1.373568d-1
     1           *t28*t29*t36*t53*taua+3.4339200000000003d-2*t26*t32*t53
     2           *taua-1.3333333333333333d+1*t26*t29*t53*taua+6.86784000
     3           0000001d-2*gammaaa*t27*t36*t52*taua+3.183787772928d-4*g
     4           ammaaa*t27*t28*t35*t53*t59+3.183787772928d-4*t23*t24*t3
     5           5*t52*t59+3.183787772928d-4*t19*t29*t30*t35*t59+1.06126
     6           2590976d-4*gammaaa*t31*t35*t36*t53-2.060352d-2*gammaaa*
     7           t27*t35*t36*t53+1.4422464000000002d-1*t23*t24*t36*t50+1
     8           .061262590976d-4*t19*t28*t32*t35*t36-4.120704d-2*t19*t2
     9           8*t29*t35*t36+3.4339200000000003d-2*t18*t29*t30*t36+8.9
     :           28192d-2*gammaaa*t25*t27*t28*t36-1.030176d-2*t19*t26*t3
     ;           2*t35+1.7169600000000002d-2*t18*t26*t28*t32-3.333333333
     <           3333337d+0*t18*t22*t32+4.464096d-2*gammaaa*t25*t26*t31-
     =           6.666666666666667d+0*t18*t26*t28*t29-8.666666666666666d
     >           +0*gammaaa*t25*t26*t27)*wght+1.25d-1*gammaaa*t33*t48*t5
     ?           6*wght+1.25d-1*gammaaa*t14*t38*t56*wght+1.25d-1*gammaaa
     @           *t14*t15*t33*t56*wght+1.0d+0*rhoa*t17*t48*t54*wght+1.0d
     1           +0*t14*t17*t54*wght)+t19*t26*(1.7169600000000002d-2*t14
     2           *t17*t33*wght-1.030176d-2*t49)-6.4386d-4*gammaaa*t14*t2
     3           6*t33*t35*t56*wght-1.25d-1*gammaaa*t14*t15*t22*t33*t56*
     4           wght-5.15088d-3*rhoa*t14*t17*t26*t35*t54*wght+1.25d-1*g
     5           ammaaa*t14*t15*t16*t22*t54*wght+1.061262590976d-4*t1*t1
     6           4*t17*t33*t35*t36*wght-1.28772d-3*gammaaa*t14*t16*t18*t
     7           26*t33*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.061262590976d-4*t14*t17*t33*t36*t6
     1           8*wght+1.0d+0*rhoa*t14*t17*t22*(3.183787772928d-4*t29*t
     2           30*t53*t59+3.183787772928d-4*gammaaa*t27*t28*t52*t59+3.
     3           183787772928d-4*t23*t24*t59/rhoa**9.666666666666666d+0+
     4           1.061262590976d-4*t28*t32*t36*t53-4.120704d-2*t28*t29*t
     5           36*t53-2.060352d-2*t27*t28*t36*t53-1.030176d-2*t26*t32*
     6           t53-1.030176d-2*t26*t31*t53+2.0d+0*t26*t27*t53+1.061262
     7           590976d-4*gammaaa*t31*t36*t52-2.060352d-2*gammaaa*t27*t
     8           36*t52-4.120704d-2*gammaaa*t23*t36*t52)*wght-6.4386d-4*
     9           gammaaa*t14*t18*t26*t33*t56*wght-5.15088d-3*t14*t17*t19
     :           *t26*t54*wght-1.25d-1*t14*t16*t22*t54*wght-1.030176d-2*
     ;           t1*t14*t17*t26*t51*wght+1.28772d-3*t14*t16*t19*t26*t33*
     <           wght+t22*t56*t67+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = -2.5d-1*gammaaa*t14*t22*t33*wght/taua
     1           **3+1.0d+0*rhoa*t14*t17*t22*(6.367575545856d-4*gammaaa*
     2           t27*t28*t59*t69+2.122525181952d-4*gammaaa*t31*t36*t69-8
     3           .241408d-2*gammaaa*t27*t36*t69+6.367575545856d-4*t29*t3
     4           0*t59*t68+2.122525181952d-4*t28*t32*t36*t68-1.6482816d-
     5           1*t28*t29*t36*t68-4.120704d-2*t26*t32*t68+8.0d+0*t26*t2
     6           9*t68+6.367575545856d-4*t23*t24*t59/rhoa**8.66666666666
     7           6666d+0)*wght+2.122525181952d-4*t14*t17*t33*t36*t64*wgh
     8           t+2.5d-1*gammaaa*t14*t22*t54*t56*wght-2.57544d-3*gammaa
     9           a*t14*t19*t26*t33*t56*wght-2.060352d-2*t1*t14*t17*t26*t
     :           54*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhoa**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/t23
              t28 = 1/t14**3
              t29 = 1/rhoa**1.3333333333333333d+0
              t30 = 1/rhoa**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t1
              t32 = 1/t22**2
              t33 = 1/t19
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t1
              t35 = 1/t18**2
              t36 = 1.0d+0*t21*t33*t34*t35+1.1102230246251565d-16*t25*t2
     1           7*t31*t32+3.0506411443514264d-19*t24*t29+1.321039893133
     2           9265d-3*t20*t29
              t37 = 1/t2**3
              t38 = 1/rhoa**4.333333333333333d+0
              t39 = 1/rhoa**2.6666666666666666d+0
              t40 = 5.15088d-52*t39*t5*t6*t9-3.333333333333333d-50*t3*t3
     1           9*t9-5.333333333333334d-99*t38*t5*t8+1.6482816d-150*t37
     2           *t8/rhoa**6+1.030176d-51*t37*t39*t4*t7-6.66666666666666
     3           6d-50*t39*t4*t5*t6-6.666666666666666d-50*t11*t39*t5*t6+
     4           4.1207039999999995d-101*t11*t37*t38*t6-1.33333333333333
     5           33d-99*t11*t38*t5+2.0603519999999997d-101*t10*t38*t5-6.
     6           666666666666666d-50*t10*t3*t39
              t41 = 5.0d-1*rhoa*t26*t40*wght+5.0d-1*rhoa*t12*t36*wght+5.
     1           0d-1*t12*t26*wght
              t42 = t31**2
              t43 = 1/t14**5
              t44 = 1/rhoa**2.3333333333333334d+0
              t45 = 1/rhoa**2.1666666666666665d+0
              t46 = t34**2
              t47 = 1/t2**4
              t48 = 1/rhoa**7
              t49 = 1/rhoa**5.333333333333333d+0
              t50 = 1/rhoa**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhoa*t12*t26*t3*wght+fnc(iq)
              Amat(iq,D1_RA) = 2.57544d-52*t1*t12*t26*t5*wght+t3*t41+Ama
     1           t(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t3*(5.0d-1*rhoa*t26*(-1.373568d-51*t5
     1           *t50*t6*t9+5.306312954879999d-103*t37*t49*t6*t9+8.88888
     2           8888888888d-50*t3*t50*t9-3.43392d-101*t49*t5*t9+2.31111
     3           11111111113d-98*t49*t5*t8-1.53839616d-149*t37*t48*t8+2.
     4           5470302183424d-201*t47*t8/rhoa**8.666666666666666d+0-2.
     5           747136d-51*t37*t4*t50*t7+1.5918938864639998d-102*t4*t47
     6           *t49*t7+1.7777777777777776d-49*t4*t5*t50*t6+1.777777777
     7           7777776d-49*t11*t5*t50*t6-1.373568d-100*t37*t4*t49*t6-2
     8           .4724223999999997d-100*t11*t37*t49*t6+6.367575545855999
     9           d-152*t11*t47*t48*t6+1.7777777777777776d-49*t10*t3*t50+
     :           2.222222222222222d-99*t4*t49*t5+8.0d-99*t11*t49*t5-1.23
     ;           62111999999999d-100*t10*t49*t5-2.7471359999999995d-150*
     <           t11*t37*t48+2.1225251819519997d-152*t10*t37*t48)*wght+5
     =           .0d-1*rhoa*t12*(-2.0d+0*t21*t33*t46/t18**3+3.2163958997
     >           38507d+1*t21*t46/(t18**4*t19**2)+1.0d+0*t21*t33*t35*(2.
     ?           1622951122684114d+0*t45+1.7087761055320938d+0*t44+1.233
     @           5503316757068d+0*t43+2.673190323653546d-1*t39)+1.110223
     1           0246251565d-16*t25*t27*t32*(1.1632736958443765d+0*t45+9
     2           .89141964955861d-1*t44+6.003214762495226d-1*t43+2.10778
     3           25841639536d-1*t39)-4.0675215258019015d-19*t24*t44-1.76
     4           13865241785684d-3*t20*t44-2.220446049250313d-16*t25*t27
     5           *t42/t22**3+1.7854583920998188d-15*t25*t42/(t22**4*t23*
     6           *2)-8.497974591333913d-2*t29*t33*t34*t35-9.812069668265
     7           515d-18*t27*t29*t31*t32)*wght+1.0d+0*rhoa*t36*t40*wght+
     8           1.0d+0*t26*t40*wght+1.0d+0*t12*t36*wght)+t1*t5*(2.57544
     9           d-52*t26*t40*wght+2.57544d-52*t12*t36*wght)+t39*t5*(5.1
     :           5088d-52*t41-4.2923999999999995d-52*t12*t26*wght)+2.653
     ;           1564774399996d-103*t12*t26*t37*t38*wght+Amat2(iq,D2_RA_
     <           RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhoa**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhoa**6.666666666666666d-1
              t14 = rhoa**5.0d-1
              t15 = 1/t14
              t16 = 1/rhoa**3.333333333333333d-1
              t17 = 1/rhoa**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/t23
              t28 = 1/t14**3
              t29 = 1/rhoa**1.3333333333333333d+0
              t30 = 1/rhoa**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t1
              t32 = 1/t22**2
              t33 = 1/t19
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t1
              t35 = 1/t18**2
              t36 = 1.0d+0*t21*t33*t34*t35+1.1102230246251565d-16*t25*t2
     1           7*t31*t32+3.0506411443514264d-19*t24*t29+1.321039893133
     2           9265d-3*t20*t29
              t37 = 1/t2**3
              t38 = 1/rhoa**4.333333333333333d+0
              t39 = 1/rhoa**2.6666666666666666d+0
              t40 = 5.15088d-52*t39*t5*t6*t9-3.333333333333333d-50*t3*t3
     1           9*t9-5.333333333333334d-99*t38*t5*t8+1.6482816d-150*t37
     2           *t8/rhoa**6+1.030176d-51*t37*t39*t4*t7-6.66666666666666
     3           6d-50*t39*t4*t5*t6-6.666666666666666d-50*t11*t39*t5*t6+
     4           4.1207039999999995d-101*t11*t37*t38*t6-1.33333333333333
     5           33d-99*t11*t38*t5+2.0603519999999997d-101*t10*t38*t5-6.
     6           666666666666666d-50*t10*t3*t39
              t41 = 5.0d-1*rhoa*t26*t40*wght+5.0d-1*rhoa*t12*t36*wght+5.
     1           0d-1*t12*t26*wght
              t42 = t31**2
              t43 = 1/t14**5
              t44 = 1/rhoa**2.3333333333333334d+0
              t45 = 1/rhoa**2.1666666666666665d+0
              t46 = t34**2
              t47 = 1/t2**4
              t48 = 1/rhoa**7
              t49 = 1/rhoa**5.333333333333333d+0
              t50 = 1/rhoa**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhoa*t12*t26*t3*wght+fnc(iq)
              Amat(iq,D1_RA) = 2.57544d-52*t1*t12*t26*t5*wght+t3*t41+Ama
     1           t(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = t3*(5.0d-1*rhoa*t26*(-1.373568d-51*t5
     1           *t50*t6*t9+5.306312954879999d-103*t37*t49*t6*t9+8.88888
     2           8888888888d-50*t3*t50*t9-3.43392d-101*t49*t5*t9+2.31111
     3           11111111113d-98*t49*t5*t8-1.53839616d-149*t37*t48*t8+2.
     4           5470302183424d-201*t47*t8/rhoa**8.666666666666666d+0-2.
     5           747136d-51*t37*t4*t50*t7+1.5918938864639998d-102*t4*t47
     6           *t49*t7+1.7777777777777776d-49*t4*t5*t50*t6+1.777777777
     7           7777776d-49*t11*t5*t50*t6-1.373568d-100*t37*t4*t49*t6-2
     8           .4724223999999997d-100*t11*t37*t49*t6+6.367575545855999
     9           d-152*t11*t47*t48*t6+1.7777777777777776d-49*t10*t3*t50+
     :           2.222222222222222d-99*t4*t49*t5+8.0d-99*t11*t49*t5-1.23
     ;           62111999999999d-100*t10*t49*t5-2.7471359999999995d-150*
     <           t11*t37*t48+2.1225251819519997d-152*t10*t37*t48)*wght+5
     =           .0d-1*rhoa*t12*(-2.0d+0*t21*t33*t46/t18**3+3.2163958997
     >           38507d+1*t21*t46/(t18**4*t19**2)+1.0d+0*t21*t33*t35*(2.
     ?           1622951122684114d+0*t45+1.7087761055320938d+0*t44+1.233
     @           5503316757068d+0*t43+2.673190323653546d-1*t39)+1.110223
     1           0246251565d-16*t25*t27*t32*(1.1632736958443765d+0*t45+9
     2           .89141964955861d-1*t44+6.003214762495226d-1*t43+2.10778
     3           25841639536d-1*t39)-4.0675215258019015d-19*t24*t44-1.76
     4           13865241785684d-3*t20*t44-2.220446049250313d-16*t25*t27
     5           *t42/t22**3+1.7854583920998188d-15*t25*t42/(t22**4*t23*
     6           *2)-8.497974591333913d-2*t29*t33*t34*t35-9.812069668265
     7           515d-18*t27*t29*t31*t32)*wght+1.0d+0*rhoa*t36*t40*wght+
     8           1.0d+0*t26*t40*wght+1.0d+0*t12*t36*wght)+t1*t5*(2.57544
     9           d-52*t26*t40*wght+2.57544d-52*t12*t36*wght)+t39*t5*(5.1
     :           5088d-52*t41-4.2923999999999995d-52*t12*t26*wght)+2.653
     ;           1564774399996d-103*t12*t26*t37*t38*wght+Amat2(iq,D2_RA_
     <           RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**6.666666666666666d-1
              t2 = rhob**5.0d-1
              t3 = 1/t2
              t4 = 1/rhob**3.333333333333333d-1
              t5 = 1/rhob**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhob
              t16 = 1/taub
              t17 = 1.0d+0-1.25d-1*gammabb*t15*t16
              t18 = 1/rhob**2.6666666666666666d+0
              t19 = 1/rhob**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taub
              t21 = 5.15088d-3*(t20+gammabb*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammabb**2
              t25 = 1/rhob**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammabb*t18*t22*t31+t26*t29*t30+gammabb*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = 1/rhob**3.6666666666666664d+0
              t35 = -3.3333333333333337d+0*t18*taub-2.6666666666666666d+
     1           0*gammabb*t34
              t36 = 1/t21**3
              t37 = 1/rhob**6.333333333333333d+0
              t38 = -3.3333333333333337d+0*t18*t22*t32*taub-6.6666666666
     1           66667d+0*t18*t26*t28*t29*taub-3.3333333333333337d+0*gam
     2           mabb*t25*t26*t27*taub-5.333333333333333d+0*t23*t24*t26*
     3           t37-1.030176d-2*t29*t30*t35*t36-1.030176d-2*gammabb*t18
     4           *t27*t28*t35*t36-1.030176d-2*t23*t24*t25*t35*t36-5.1508
     5           8d-3*t26*t28*t32*t35-5.15088d-3*gammabb*t18*t26*t31*t35
     6           -2.6666666666666666d+0*gammabb*t22*t31*t34-2.6666666666
     7           666666d+0*gammabb*t26*t27*t28*t34
              t39 = 1/t11
              t40 = 1/t2**3
              t41 = 1/rhob**1.3333333333333333d+0
              t42 = 1/rhob**1.1666666666666667d+0
              t43 = -9.970917392951799d-1*t42-7.418564737168958d-1*t41-4
     1           .002143174996817d-1*t40-1.264669550498372d-1*t19
              t44 = 1/t10**2
              t45 = 1/t7
              t46 = -1.8533958105157808d+0*t42-1.2815820791490704d+0*t41
     1           -8.223668877838045d-1*t40-1.6039141941921276d-1*t19
              t47 = 1/t6**2
              t48 = 1.0d+0*t45*t46*t47*t9+1.3210398931339265d-3*t41*t8+1
     1           .1102230246251565d-16*t13*t39*t43*t44+3.050641144351426
     2           4d-19*t12*t41
              t49 = 1.0d+0*rhob*t17*t33*t48*wght+1.0d+0*rhob*t14*t17*t38
     1           *wght+1.0d+0*t14*t17*t33*wght
              t50 = 1/rhob**8
              t51 = -1.030176d-2*t23*t24*t36*t50-1.030176d-2*t18*t29*t30
     1           *t36-1.030176d-2*gammabb*t25*t27*t28*t36-5.15088d-3*t18
     2           *t26*t28*t32-5.15088d-3*gammabb*t25*t26*t31+t18*t22*t31
     3           +t18*t26*t27*t28+2*gammabb*t23*t25*t26
              t52 = 1/rhob**7
              t53 = 1/rhob**4.333333333333333d+0
              t54 = -2.060352d-2*gammabb*t27*t28*t36*t53-1.030176d-2*gam
     1           mabb*t26*t31*t53+2.0d+0*gammabb*t26*t27*t53-2.060352d-2
     2           *t23*t24*t36*t52-2.060352d-2*t19*t29*t30*t36-1.030176d-
     3           2*t19*t26*t28*t32+2.0d+0*t19*t22*t32+4.0d+0*t19*t26*t28
     4           *t29
              t55 = taub**2
              t56 = 1/t55
              t57 = t35**2
              t58 = 1/rhob**2
              t59 = 1/t21**4
              t60 = 1/rhob**4.666666666666667d+0
              t61 = 8.88888888888889d+0*t34*taub+9.777777777777779d+0*ga
     1           mmabb*t60
              t62 = t43**2
              t63 = 1/t2**5
              t64 = 1/rhob**2.3333333333333334d+0
              t65 = 1/rhob**2.1666666666666665d+0
              t66 = t46**2
              t67 = 1.25d-1*gammabb*t14*t51*wght+1.25d-1*t14*t33*wght
              t68 = 1/rhob**3.3333333333333337d+0
              t69 = 1/rhob**6
              fnc(iq) = 1.0d+0*rhob*t14*t17*t22*t33*wght+fnc(iq)
              Amat(iq,D1_RB) = -5.15088d-3*rhob*t14*t17*t26*t33*t35*wght
     1           +1.25d-1*gammabb*t14*t15*t16*t22*t33*wght+t22*t49+Amat(
     2           iq,D1_RB)
              Cmat(iq,D1_GBB) = 1.0d+0*rhob*t14*t17*t22*t51*wght-5.15088
     1           d-3*t14*t17*t19*t26*t33*wght-1.25d-1*t14*t16*t22*t33*wg
     2           ht+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = 1.25d-1*gammabb*t14*t22*t33*t56*wght+1.0d
     1           +0*rhob*t14*t17*t22*t54*wght-1.030176d-2*t1*t14*t17*t26
     2           *t33*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t22*(1.0d+0*rhob*t14*t17*(2.666666666
     1           6666666d+1*gammabb*t26*t27*t37*taub+1.373568d-1*t18*t28
     2           *t29*t35*t36*taub+6.867840000000001d-2*gammabb*t25*t27*
     3           t35*t36*taub+3.4339200000000003d-2*t18*t26*t32*t35*taub
     4           +8.88888888888889d+0*t22*t32*t34*taub+1.777777777777777
     5           8d+1*t26*t28*t29*t34*taub-1.030176d-2*t29*t30*t36*t61-1
     6           .030176d-2*gammabb*t18*t27*t28*t36*t61-1.030176d-2*t23*
     7           t24*t25*t36*t61-5.15088d-3*t26*t28*t32*t61-5.15088d-3*g
     8           ammabb*t18*t26*t31*t61+9.777777777777779d+0*gammabb*t22
     9           *t31*t60+9.777777777777779d+0*gammabb*t26*t27*t28*t60+1
     :           .591893886464d-4*t29*t30*t57*t59+1.591893886464d-4*gamm
     ;           abb*t18*t27*t28*t57*t59+1.591893886464d-4*t23*t24*t25*t
     <           57*t59+5.30631295488d-5*t28*t32*t36*t57+5.30631295488d-
     =           5*gammabb*t18*t31*t36*t57+2.2222222222222224d+1*t25*t26
     >           *t29*t55+1.0988544d-1*t23*t24*t35*t36*t37+5.494272d-2*g
     ?           ammabb*t27*t28*t34*t35*t36+2.747136d-2*gammabb*t26*t31*
     @           t34*t35+3.377777777777778d+1*t23*t24*t26/rhob**7.333333
     1           333333333d+0)*wght+1.0d+0*rhob*t17*t33*(3.2163958997385
     2           07d+1*t66*t9/(t6**4*t7**2)-2.0d+0*t45*t66*t9/t6**3+1.0d
     3           +0*t45*t47*(2.1622951122684114d+0*t65+1.708776105532093
     4           8d+0*t64+1.2335503316757068d+0*t63+2.673190323653546d-1
     5           *t18)*t9-1.7613865241785684d-3*t64*t8+1.110223024625156
     6           5d-16*t13*t39*t44*(1.1632736958443765d+0*t65+9.89141964
     7           955861d-1*t64+6.003214762495226d-1*t63+2.10778258416395
     8           36d-1*t18)-4.0675215258019015d-19*t12*t64-2.22044604925
     9           0313d-16*t13*t39*t62/t10**3+1.7854583920998188d-15*t13*
     :           t62/(t10**4*t11**2)-8.497974591333913d-2*t41*t45*t46*t4
     ;           7-9.812069668265515d-18*t39*t41*t43*t44)*wght+1.25d-1*g
     <           ammabb*t14*t16*t33*t58*wght+2.0d+0*rhob*t17*t38*t48*wgh
     =           t+2.0d+0*t17*t33*t48*wght+1.25d-1*gammabb*t15*t16*t33*t
     >           48*wght+2.0d+0*t14*t17*t38*wght+1.25d-1*gammabb*t14*t15
     ?           *t16*t38*wght)+t26*(-5.15088d-3*rhob*t14*t17*t33*t61*wg
     @           ht-5.15088d-3*rhob*t17*t33*t35*t48*wght-5.15088d-3*rhob
     1           *t14*t17*t35*t38*wght-5.15088d-3*t14*t17*t33*t35*wght-5
     2           .15088d-3*t35*t49)+t15*t16*t22*(1.25d-1*gammabb*t33*t48
     3           *wght+1.25d-1*gammabb*t14*t38*wght)-1.25d-1*gammabb*t14
     4           *t16*t22*t33*t58*wght+5.30631295488d-5*rhob*t14*t17*t33
     5           *t36*t57*wght-1.28772d-3*gammabb*t14*t15*t16*t26*t33*t3
     6           5*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t22*(1.0d+0*rhob*t14*t17*(3.43392000
     1           00000003d-2*gammabb*t27*t36*t50*taub+6.867840000000001d
     2           -2*t25*t28*t29*t36*taub+1.7169600000000002d-2*t25*t26*t
     3           32*taub-3.3333333333333337d+0*t25*t26*t27*taub+1.591893
     4           886464d-4*t23*t24*t35*t50*t59+1.591893886464d-4*t18*t29
     5           *t30*t35*t59+1.591893886464d-4*gammabb*t25*t27*t28*t35*
     6           t59+5.494272d-2*gammabb*t27*t28*t36*t37+2.747136d-2*gam
     7           mabb*t26*t31*t37-1.0666666666666666d+1*gammabb*t23*t26*
     8           t37+5.30631295488d-5*t18*t28*t32*t35*t36+5.30631295488d
     9           -5*gammabb*t25*t31*t35*t36-1.030176d-2*t18*t27*t28*t35*
     :           t36-2.060352d-2*gammabb*t23*t25*t35*t36+2.747136d-2*t29
     ;           *t30*t34*t36+8.241408d-2*t23*t24*t36/rhob**9-5.15088d-3
     <           *t18*t26*t31*t35+1.373568d-2*t26*t28*t32*t34-2.66666666
     =           66666666d+0*t22*t31*t34-2.6666666666666666d+0*t26*t27*t
     >           28*t34)*wght+1.0d+0*rhob*t17*t48*t51*wght+1.0d+0*t14*t1
     ?           7*t51*wght-1.25d-1*t16*t33*t48*wght-1.25d-1*t14*t16*t38
     @           *wght-1.25d-1*t14*t15*t16*t33*wght)+t18*t26*(1.373568d-
     1           2*t14*t17*t33*wght-5.15088d-3*t49)-5.15088d-3*rhob*t14*
     2           t17*t26*t35*t51*wght+5.30631295488d-5*t14*t17*t19*t33*t
     3           35*t36*wght+6.4386d-4*t14*t16*t26*t33*t35*wght-6.4386d-
     4           4*gammabb*t14*t16*t26*t33*t34*wght+t15*t16*t22*t67+Cmat
     5           2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = 1.0d+0*rhob*t14*t17*t22*(1.59189388
     1           6464d-4*gammabb*t27*t28*t50*t59+1.591893886464d-4*t25*t
     2           29*t30*t59+1.591893886464d-4*t23*t24*t59/rhob**1.066666
     3           6666666666d+1+5.30631295488d-5*gammabb*t31*t36*t50-4.12
     4           0704d-2*gammabb*t23*t36*t50+5.30631295488d-5*t25*t28*t3
     5           2*t36-2.060352d-2*t25*t27*t28*t36-1.030176d-2*t25*t26*t
     6           31+2*t23*t25*t26)*wght+5.30631295488d-5*t14*t17*t33*t36
     7           *t53*wght-1.030176d-2*t14*t17*t19*t26*t51*wght-2.5d-1*t
     8           14*t16*t22*t51*wght+1.28772d-3*t14*t16*t18*t26*t33*wght
     9           +Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t22*(1.0d+0*rhob*t14*t17*(1.373568d-1
     1           *t28*t29*t36*t53*taub+3.4339200000000003d-2*t26*t32*t53
     2           *taub-1.3333333333333333d+1*t26*t29*t53*taub+6.86784000
     3           0000001d-2*gammabb*t27*t36*t52*taub+3.183787772928d-4*g
     4           ammabb*t27*t28*t35*t53*t59+3.183787772928d-4*t23*t24*t3
     5           5*t52*t59+3.183787772928d-4*t19*t29*t30*t35*t59+1.06126
     6           2590976d-4*gammabb*t31*t35*t36*t53-2.060352d-2*gammabb*
     7           t27*t35*t36*t53+1.4422464000000002d-1*t23*t24*t36*t50+1
     8           .061262590976d-4*t19*t28*t32*t35*t36-4.120704d-2*t19*t2
     9           8*t29*t35*t36+3.4339200000000003d-2*t18*t29*t30*t36+8.9
     :           28192d-2*gammabb*t25*t27*t28*t36-1.030176d-2*t19*t26*t3
     ;           2*t35+1.7169600000000002d-2*t18*t26*t28*t32-3.333333333
     <           3333337d+0*t18*t22*t32+4.464096d-2*gammabb*t25*t26*t31-
     =           6.666666666666667d+0*t18*t26*t28*t29-8.666666666666666d
     >           +0*gammabb*t25*t26*t27)*wght+1.25d-1*gammabb*t33*t48*t5
     ?           6*wght+1.25d-1*gammabb*t14*t38*t56*wght+1.25d-1*gammabb
     @           *t14*t15*t33*t56*wght+1.0d+0*rhob*t17*t48*t54*wght+1.0d
     1           +0*t14*t17*t54*wght)+t19*t26*(1.7169600000000002d-2*t14
     2           *t17*t33*wght-1.030176d-2*t49)-6.4386d-4*gammabb*t14*t2
     3           6*t33*t35*t56*wght-1.25d-1*gammabb*t14*t15*t22*t33*t56*
     4           wght-5.15088d-3*rhob*t14*t17*t26*t35*t54*wght+1.25d-1*g
     5           ammabb*t14*t15*t16*t22*t54*wght+1.061262590976d-4*t1*t1
     6           4*t17*t33*t35*t36*wght-1.28772d-3*gammabb*t14*t16*t18*t
     7           26*t33*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.061262590976d-4*t14*t17*t33*t36*t6
     1           8*wght+1.0d+0*rhob*t14*t17*t22*(3.183787772928d-4*t29*t
     2           30*t53*t59+3.183787772928d-4*gammabb*t27*t28*t52*t59+3.
     3           183787772928d-4*t23*t24*t59/rhob**9.666666666666666d+0+
     4           1.061262590976d-4*t28*t32*t36*t53-4.120704d-2*t28*t29*t
     5           36*t53-2.060352d-2*t27*t28*t36*t53-1.030176d-2*t26*t32*
     6           t53-1.030176d-2*t26*t31*t53+2.0d+0*t26*t27*t53+1.061262
     7           590976d-4*gammabb*t31*t36*t52-2.060352d-2*gammabb*t27*t
     8           36*t52-4.120704d-2*gammabb*t23*t36*t52)*wght-6.4386d-4*
     9           gammabb*t14*t18*t26*t33*t56*wght-5.15088d-3*t14*t17*t19
     :           *t26*t54*wght-1.25d-1*t14*t16*t22*t54*wght-1.030176d-2*
     ;           t1*t14*t17*t26*t51*wght+1.28772d-3*t14*t16*t19*t26*t33*
     <           wght+t22*t56*t67+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = -2.5d-1*gammabb*t14*t22*t33*wght/taub
     1           **3+1.0d+0*rhob*t14*t17*t22*(6.367575545856d-4*gammabb*
     2           t27*t28*t59*t69+2.122525181952d-4*gammabb*t31*t36*t69-8
     3           .241408d-2*gammabb*t27*t36*t69+6.367575545856d-4*t29*t3
     4           0*t59*t68+2.122525181952d-4*t28*t32*t36*t68-1.6482816d-
     5           1*t28*t29*t36*t68-4.120704d-2*t26*t32*t68+8.0d+0*t26*t2
     6           9*t68+6.367575545856d-4*t23*t24*t59/rhob**8.66666666666
     7           6666d+0)*wght+2.122525181952d-4*t14*t17*t33*t36*t64*wgh
     8           t+2.5d-1*gammabb*t14*t22*t54*t56*wght-2.57544d-3*gammab
     9           b*t14*t19*t26*t33*t56*wght-2.060352d-2*t1*t14*t17*t26*t
     :           54*wght+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhob**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/t23
              t28 = 1/t14**3
              t29 = 1/rhob**1.3333333333333333d+0
              t30 = 1/rhob**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t1
              t32 = 1/t22**2
              t33 = 1/t19
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t1
              t35 = 1/t18**2
              t36 = 1.0d+0*t21*t33*t34*t35+1.1102230246251565d-16*t25*t2
     1           7*t31*t32+3.0506411443514264d-19*t24*t29+1.321039893133
     2           9265d-3*t20*t29
              t37 = 1/t2**3
              t38 = 1/rhob**4.333333333333333d+0
              t39 = 1/rhob**2.6666666666666666d+0
              t40 = 5.15088d-52*t39*t5*t6*t9-3.333333333333333d-50*t3*t3
     1           9*t9-5.333333333333334d-99*t38*t5*t8+1.6482816d-150*t37
     2           *t8/rhob**6+1.030176d-51*t37*t39*t4*t7-6.66666666666666
     3           6d-50*t39*t4*t5*t6-6.666666666666666d-50*t11*t39*t5*t6+
     4           4.1207039999999995d-101*t11*t37*t38*t6-1.33333333333333
     5           33d-99*t11*t38*t5+2.0603519999999997d-101*t10*t38*t5-6.
     6           666666666666666d-50*t10*t3*t39
              t41 = 5.0d-1*rhob*t26*t40*wght+5.0d-1*rhob*t12*t36*wght+5.
     1           0d-1*t12*t26*wght
              t42 = t31**2
              t43 = 1/t14**5
              t44 = 1/rhob**2.3333333333333334d+0
              t45 = 1/rhob**2.1666666666666665d+0
              t46 = t34**2
              t47 = 1/t2**4
              t48 = 1/rhob**7
              t49 = 1/rhob**5.333333333333333d+0
              t50 = 1/rhob**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhob*t12*t26*t3*wght+fnc(iq)
              Amat(iq,D1_RB) = 2.57544d-52*t1*t12*t26*t5*wght+t3*t41+Ama
     1           t(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t3*(5.0d-1*rhob*t26*(-1.373568d-51*t5
     1           *t50*t6*t9+5.306312954879999d-103*t37*t49*t6*t9+8.88888
     2           8888888888d-50*t3*t50*t9-3.43392d-101*t49*t5*t9+2.31111
     3           11111111113d-98*t49*t5*t8-1.53839616d-149*t37*t48*t8+2.
     4           5470302183424d-201*t47*t8/rhob**8.666666666666666d+0-2.
     5           747136d-51*t37*t4*t50*t7+1.5918938864639998d-102*t4*t47
     6           *t49*t7+1.7777777777777776d-49*t4*t5*t50*t6+1.777777777
     7           7777776d-49*t11*t5*t50*t6-1.373568d-100*t37*t4*t49*t6-2
     8           .4724223999999997d-100*t11*t37*t49*t6+6.367575545855999
     9           d-152*t11*t47*t48*t6+1.7777777777777776d-49*t10*t3*t50+
     :           2.222222222222222d-99*t4*t49*t5+8.0d-99*t11*t49*t5-1.23
     ;           62111999999999d-100*t10*t49*t5-2.7471359999999995d-150*
     <           t11*t37*t48+2.1225251819519997d-152*t10*t37*t48)*wght+5
     =           .0d-1*rhob*t12*(-2.0d+0*t21*t33*t46/t18**3+3.2163958997
     >           38507d+1*t21*t46/(t18**4*t19**2)+1.0d+0*t21*t33*t35*(2.
     ?           1622951122684114d+0*t45+1.7087761055320938d+0*t44+1.233
     @           5503316757068d+0*t43+2.673190323653546d-1*t39)+1.110223
     1           0246251565d-16*t25*t27*t32*(1.1632736958443765d+0*t45+9
     2           .89141964955861d-1*t44+6.003214762495226d-1*t43+2.10778
     3           25841639536d-1*t39)-4.0675215258019015d-19*t24*t44-1.76
     4           13865241785684d-3*t20*t44-2.220446049250313d-16*t25*t27
     5           *t42/t22**3+1.7854583920998188d-15*t25*t42/(t22**4*t23*
     6           *2)-8.497974591333913d-2*t29*t33*t34*t35-9.812069668265
     7           515d-18*t27*t29*t31*t32)*wght+1.0d+0*rhob*t36*t40*wght+
     8           1.0d+0*t26*t40*wght+1.0d+0*t12*t36*wght)+t1*t5*(2.57544
     9           d-52*t26*t40*wght+2.57544d-52*t12*t36*wght)+t39*t5*(5.1
     :           5088d-52*t41-4.2923999999999995d-52*t12*t26*wght)+2.653
     ;           1564774399996d-103*t12*t26*t37*t38*wght+Amat2(iq,D2_RB_
     <           RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhob**6.666666666666666d-1
              t2 = rhob**5.0d-1
              t3 = 1/t2
              t4 = 1/rhob**3.333333333333333d-1
              t5 = 1/rhob**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhob
              t16 = 1/taub
              t17 = 1.0d+0-1.25d-1*gammabb*t15*t16
              t18 = 1/rhob**2.6666666666666666d+0
              t19 = 1/rhob**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taub
              t21 = 5.15088d-3*(t20+gammabb*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammabb**2
              t25 = 1/rhob**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammabb*t18*t22*t31+t26*t29*t30+gammabb*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = 1/rhob**3.6666666666666664d+0
              t35 = -3.3333333333333337d+0*t18*taub-2.6666666666666666d+
     1           0*gammabb*t34
              t36 = 1/t21**3
              t37 = 1/rhob**6.333333333333333d+0
              t38 = -3.3333333333333337d+0*t18*t22*t32*taub-6.6666666666
     1           66667d+0*t18*t26*t28*t29*taub-3.3333333333333337d+0*gam
     2           mabb*t25*t26*t27*taub-5.333333333333333d+0*t23*t24*t26*
     3           t37-1.030176d-2*t29*t30*t35*t36-1.030176d-2*gammabb*t18
     4           *t27*t28*t35*t36-1.030176d-2*t23*t24*t25*t35*t36-5.1508
     5           8d-3*t26*t28*t32*t35-5.15088d-3*gammabb*t18*t26*t31*t35
     6           -2.6666666666666666d+0*gammabb*t22*t31*t34-2.6666666666
     7           666666d+0*gammabb*t26*t27*t28*t34
              t39 = 1/t11
              t40 = 1/t2**3
              t41 = 1/rhob**1.3333333333333333d+0
              t42 = 1/rhob**1.1666666666666667d+0
              t43 = -9.970917392951799d-1*t42-7.418564737168958d-1*t41-4
     1           .002143174996817d-1*t40-1.264669550498372d-1*t19
              t44 = 1/t10**2
              t45 = 1/t7
              t46 = -1.8533958105157808d+0*t42-1.2815820791490704d+0*t41
     1           -8.223668877838045d-1*t40-1.6039141941921276d-1*t19
              t47 = 1/t6**2
              t48 = 1.0d+0*t45*t46*t47*t9+1.3210398931339265d-3*t41*t8+1
     1           .1102230246251565d-16*t13*t39*t43*t44+3.050641144351426
     2           4d-19*t12*t41
              t49 = 1.0d+0*rhob*t17*t33*t48*wght+1.0d+0*rhob*t14*t17*t38
     1           *wght+1.0d+0*t14*t17*t33*wght
              t50 = 1/rhob**8
              t51 = -1.030176d-2*t23*t24*t36*t50-1.030176d-2*t18*t29*t30
     1           *t36-1.030176d-2*gammabb*t25*t27*t28*t36-5.15088d-3*t18
     2           *t26*t28*t32-5.15088d-3*gammabb*t25*t26*t31+t18*t22*t31
     3           +t18*t26*t27*t28+2*gammabb*t23*t25*t26
              t52 = 1/rhob**7
              t53 = 1/rhob**4.333333333333333d+0
              t54 = -2.060352d-2*gammabb*t27*t28*t36*t53-1.030176d-2*gam
     1           mabb*t26*t31*t53+2.0d+0*gammabb*t26*t27*t53-2.060352d-2
     2           *t23*t24*t36*t52-2.060352d-2*t19*t29*t30*t36-1.030176d-
     3           2*t19*t26*t28*t32+2.0d+0*t19*t22*t32+4.0d+0*t19*t26*t28
     4           *t29
              t55 = taub**2
              t56 = 1/t55
              t57 = t35**2
              t58 = 1/rhob**2
              t59 = 1/t21**4
              t60 = 1/rhob**4.666666666666667d+0
              t61 = 8.88888888888889d+0*t34*taub+9.777777777777779d+0*ga
     1           mmabb*t60
              t62 = t43**2
              t63 = 1/t2**5
              t64 = 1/rhob**2.3333333333333334d+0
              t65 = 1/rhob**2.1666666666666665d+0
              t66 = t46**2
              t67 = 1.25d-1*gammabb*t14*t51*wght+1.25d-1*t14*t33*wght
              t68 = 1/rhob**3.3333333333333337d+0
              t69 = 1/rhob**6
              fnc(iq) = 1.0d+0*rhob*t14*t17*t22*t33*wght+fnc(iq)
              Amat(iq,D1_RB) = -5.15088d-3*rhob*t14*t17*t26*t33*t35*wght
     1           +1.25d-1*gammabb*t14*t15*t16*t22*t33*wght+t22*t49+Amat(
     2           iq,D1_RB)
              Cmat(iq,D1_GBB) = 1.0d+0*rhob*t14*t17*t22*t51*wght-5.15088
     1           d-3*t14*t17*t19*t26*t33*wght-1.25d-1*t14*t16*t22*t33*wg
     2           ht+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = 1.25d-1*gammabb*t14*t22*t33*t56*wght+1.0d
     1           +0*rhob*t14*t17*t22*t54*wght-1.030176d-2*t1*t14*t17*t26
     2           *t33*wght+Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t22*(1.0d+0*rhob*t14*t17*(2.666666666
     1           6666666d+1*gammabb*t26*t27*t37*taub+1.373568d-1*t18*t28
     2           *t29*t35*t36*taub+6.867840000000001d-2*gammabb*t25*t27*
     3           t35*t36*taub+3.4339200000000003d-2*t18*t26*t32*t35*taub
     4           +8.88888888888889d+0*t22*t32*t34*taub+1.777777777777777
     5           8d+1*t26*t28*t29*t34*taub-1.030176d-2*t29*t30*t36*t61-1
     6           .030176d-2*gammabb*t18*t27*t28*t36*t61-1.030176d-2*t23*
     7           t24*t25*t36*t61-5.15088d-3*t26*t28*t32*t61-5.15088d-3*g
     8           ammabb*t18*t26*t31*t61+9.777777777777779d+0*gammabb*t22
     9           *t31*t60+9.777777777777779d+0*gammabb*t26*t27*t28*t60+1
     :           .591893886464d-4*t29*t30*t57*t59+1.591893886464d-4*gamm
     ;           abb*t18*t27*t28*t57*t59+1.591893886464d-4*t23*t24*t25*t
     <           57*t59+5.30631295488d-5*t28*t32*t36*t57+5.30631295488d-
     =           5*gammabb*t18*t31*t36*t57+2.2222222222222224d+1*t25*t26
     >           *t29*t55+1.0988544d-1*t23*t24*t35*t36*t37+5.494272d-2*g
     ?           ammabb*t27*t28*t34*t35*t36+2.747136d-2*gammabb*t26*t31*
     @           t34*t35+3.377777777777778d+1*t23*t24*t26/rhob**7.333333
     1           333333333d+0)*wght+1.0d+0*rhob*t17*t33*(3.2163958997385
     2           07d+1*t66*t9/(t6**4*t7**2)-2.0d+0*t45*t66*t9/t6**3+1.0d
     3           +0*t45*t47*(2.1622951122684114d+0*t65+1.708776105532093
     4           8d+0*t64+1.2335503316757068d+0*t63+2.673190323653546d-1
     5           *t18)*t9-1.7613865241785684d-3*t64*t8+1.110223024625156
     6           5d-16*t13*t39*t44*(1.1632736958443765d+0*t65+9.89141964
     7           955861d-1*t64+6.003214762495226d-1*t63+2.10778258416395
     8           36d-1*t18)-4.0675215258019015d-19*t12*t64-2.22044604925
     9           0313d-16*t13*t39*t62/t10**3+1.7854583920998188d-15*t13*
     :           t62/(t10**4*t11**2)-8.497974591333913d-2*t41*t45*t46*t4
     ;           7-9.812069668265515d-18*t39*t41*t43*t44)*wght+1.25d-1*g
     <           ammabb*t14*t16*t33*t58*wght+2.0d+0*rhob*t17*t38*t48*wgh
     =           t+2.0d+0*t17*t33*t48*wght+1.25d-1*gammabb*t15*t16*t33*t
     >           48*wght+2.0d+0*t14*t17*t38*wght+1.25d-1*gammabb*t14*t15
     ?           *t16*t38*wght)+t26*(-5.15088d-3*rhob*t14*t17*t33*t61*wg
     @           ht-5.15088d-3*rhob*t17*t33*t35*t48*wght-5.15088d-3*rhob
     1           *t14*t17*t35*t38*wght-5.15088d-3*t14*t17*t33*t35*wght-5
     2           .15088d-3*t35*t49)+t15*t16*t22*(1.25d-1*gammabb*t33*t48
     3           *wght+1.25d-1*gammabb*t14*t38*wght)-1.25d-1*gammabb*t14
     4           *t16*t22*t33*t58*wght+5.30631295488d-5*rhob*t14*t17*t33
     5           *t36*t57*wght-1.28772d-3*gammabb*t14*t15*t16*t26*t33*t3
     6           5*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = t22*(1.0d+0*rhob*t14*t17*(3.43392000
     1           00000003d-2*gammabb*t27*t36*t50*taub+6.867840000000001d
     2           -2*t25*t28*t29*t36*taub+1.7169600000000002d-2*t25*t26*t
     3           32*taub-3.3333333333333337d+0*t25*t26*t27*taub+1.591893
     4           886464d-4*t23*t24*t35*t50*t59+1.591893886464d-4*t18*t29
     5           *t30*t35*t59+1.591893886464d-4*gammabb*t25*t27*t28*t35*
     6           t59+5.494272d-2*gammabb*t27*t28*t36*t37+2.747136d-2*gam
     7           mabb*t26*t31*t37-1.0666666666666666d+1*gammabb*t23*t26*
     8           t37+5.30631295488d-5*t18*t28*t32*t35*t36+5.30631295488d
     9           -5*gammabb*t25*t31*t35*t36-1.030176d-2*t18*t27*t28*t35*
     :           t36-2.060352d-2*gammabb*t23*t25*t35*t36+2.747136d-2*t29
     ;           *t30*t34*t36+8.241408d-2*t23*t24*t36/rhob**9-5.15088d-3
     <           *t18*t26*t31*t35+1.373568d-2*t26*t28*t32*t34-2.66666666
     =           66666666d+0*t22*t31*t34-2.6666666666666666d+0*t26*t27*t
     >           28*t34)*wght+1.0d+0*rhob*t17*t48*t51*wght+1.0d+0*t14*t1
     ?           7*t51*wght-1.25d-1*t16*t33*t48*wght-1.25d-1*t14*t16*t38
     @           *wght-1.25d-1*t14*t15*t16*t33*wght)+t18*t26*(1.373568d-
     1           2*t14*t17*t33*wght-5.15088d-3*t49)-5.15088d-3*rhob*t14*
     2           t17*t26*t35*t51*wght+5.30631295488d-5*t14*t17*t19*t33*t
     3           35*t36*wght+6.4386d-4*t14*t16*t26*t33*t35*wght-6.4386d-
     4           4*gammabb*t14*t16*t26*t33*t34*wght+t15*t16*t22*t67+Cmat
     5           2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = 1.0d+0*rhob*t14*t17*t22*(1.59189388
     1           6464d-4*gammabb*t27*t28*t50*t59+1.591893886464d-4*t25*t
     2           29*t30*t59+1.591893886464d-4*t23*t24*t59/rhob**1.066666
     3           6666666666d+1+5.30631295488d-5*gammabb*t31*t36*t50-4.12
     4           0704d-2*gammabb*t23*t36*t50+5.30631295488d-5*t25*t28*t3
     5           2*t36-2.060352d-2*t25*t27*t28*t36-1.030176d-2*t25*t26*t
     6           31+2*t23*t25*t26)*wght+5.30631295488d-5*t14*t17*t33*t36
     7           *t53*wght-1.030176d-2*t14*t17*t19*t26*t51*wght-2.5d-1*t
     8           14*t16*t22*t51*wght+1.28772d-3*t14*t16*t18*t26*t33*wght
     9           +Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t22*(1.0d+0*rhob*t14*t17*(1.373568d-1
     1           *t28*t29*t36*t53*taub+3.4339200000000003d-2*t26*t32*t53
     2           *taub-1.3333333333333333d+1*t26*t29*t53*taub+6.86784000
     3           0000001d-2*gammabb*t27*t36*t52*taub+3.183787772928d-4*g
     4           ammabb*t27*t28*t35*t53*t59+3.183787772928d-4*t23*t24*t3
     5           5*t52*t59+3.183787772928d-4*t19*t29*t30*t35*t59+1.06126
     6           2590976d-4*gammabb*t31*t35*t36*t53-2.060352d-2*gammabb*
     7           t27*t35*t36*t53+1.4422464000000002d-1*t23*t24*t36*t50+1
     8           .061262590976d-4*t19*t28*t32*t35*t36-4.120704d-2*t19*t2
     9           8*t29*t35*t36+3.4339200000000003d-2*t18*t29*t30*t36+8.9
     :           28192d-2*gammabb*t25*t27*t28*t36-1.030176d-2*t19*t26*t3
     ;           2*t35+1.7169600000000002d-2*t18*t26*t28*t32-3.333333333
     <           3333337d+0*t18*t22*t32+4.464096d-2*gammabb*t25*t26*t31-
     =           6.666666666666667d+0*t18*t26*t28*t29-8.666666666666666d
     >           +0*gammabb*t25*t26*t27)*wght+1.25d-1*gammabb*t33*t48*t5
     ?           6*wght+1.25d-1*gammabb*t14*t38*t56*wght+1.25d-1*gammabb
     @           *t14*t15*t33*t56*wght+1.0d+0*rhob*t17*t48*t54*wght+1.0d
     1           +0*t14*t17*t54*wght)+t19*t26*(1.7169600000000002d-2*t14
     2           *t17*t33*wght-1.030176d-2*t49)-6.4386d-4*gammabb*t14*t2
     3           6*t33*t35*t56*wght-1.25d-1*gammabb*t14*t15*t22*t33*t56*
     4           wght-5.15088d-3*rhob*t14*t17*t26*t35*t54*wght+1.25d-1*g
     5           ammabb*t14*t15*t16*t22*t54*wght+1.061262590976d-4*t1*t1
     6           4*t17*t33*t35*t36*wght-1.28772d-3*gammabb*t14*t16*t18*t
     7           26*t33*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.061262590976d-4*t14*t17*t33*t36*t6
     1           8*wght+1.0d+0*rhob*t14*t17*t22*(3.183787772928d-4*t29*t
     2           30*t53*t59+3.183787772928d-4*gammabb*t27*t28*t52*t59+3.
     3           183787772928d-4*t23*t24*t59/rhob**9.666666666666666d+0+
     4           1.061262590976d-4*t28*t32*t36*t53-4.120704d-2*t28*t29*t
     5           36*t53-2.060352d-2*t27*t28*t36*t53-1.030176d-2*t26*t32*
     6           t53-1.030176d-2*t26*t31*t53+2.0d+0*t26*t27*t53+1.061262
     7           590976d-4*gammabb*t31*t36*t52-2.060352d-2*gammabb*t27*t
     8           36*t52-4.120704d-2*gammabb*t23*t36*t52)*wght-6.4386d-4*
     9           gammabb*t14*t18*t26*t33*t56*wght-5.15088d-3*t14*t17*t19
     :           *t26*t54*wght-1.25d-1*t14*t16*t22*t54*wght-1.030176d-2*
     ;           t1*t14*t17*t26*t51*wght+1.28772d-3*t14*t16*t19*t26*t33*
     <           wght+t22*t56*t67+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = -2.5d-1*gammabb*t14*t22*t33*wght/taub
     1           **3+1.0d+0*rhob*t14*t17*t22*(6.367575545856d-4*gammabb*
     2           t27*t28*t59*t69+2.122525181952d-4*gammabb*t31*t36*t69-8
     3           .241408d-2*gammabb*t27*t36*t69+6.367575545856d-4*t29*t3
     4           0*t59*t68+2.122525181952d-4*t28*t32*t36*t68-1.6482816d-
     5           1*t28*t29*t36*t68-4.120704d-2*t26*t32*t68+8.0d+0*t26*t2
     6           9*t68+6.367575545856d-4*t23*t24*t59/rhob**8.66666666666
     7           6666d+0)*wght+2.122525181952d-4*t14*t17*t33*t36*t64*wgh
     8           t+2.5d-1*gammabb*t14*t22*t54*t56*wght-2.57544d-3*gammab
     9           b*t14*t19*t26*t33*t56*wght-2.060352d-2*t1*t14*t17*t26*t
     :           54*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = param(9)
              t10 = param(8)
              t11 = param(11)
              t12 = t3*t6*t9+1.6d-99*t5*t8/rhob**3.3333333333333337d+0+t
     1           4*t5*t7+4.0d-50*t1*t11*t5*t6+4.0d-50*t1*t10*t3+param(7)
              t13 = 1/rhob**6.666666666666666d-1
              t14 = rhob**5.0d-1
              t15 = 1/t14
              t16 = 1/rhob**3.333333333333333d-1
              t17 = 1/rhob**1.6666666666666666d-1
              t18 = 1.1120374863094686d+1*t17+3.8447462374472113d+0*t16+
     1           1.644733775567609d+0*t15+2.4058712912881916d-1*t13
              t19 = 3.216395899738507d+1/t18+1.0d+0
              t20 = log(t19)
              t21 = 1.274696188700087d-1*t16+1.0d+0
              t22 = 5.982550435771079d+0*t17+2.2255694211506874d+0*t16+8
     1           .004286349993635d-1*t15+1.8970043257475583d-1*t13
              t23 = 1.6081979498692536d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.3256889990520176d-1*t16+1.0d+0
              t26 = -6.903522198342671d-18*t24*t25-3.1090699999999993d-2
     1           *t20*t21
              t27 = 1/t23
              t28 = 1/t14**3
              t29 = 1/rhob**1.3333333333333333d+0
              t30 = 1/rhob**1.1666666666666667d+0
              t31 = -9.970917392951799d-1*t30-7.418564737168958d-1*t29-4
     1           .002143174996817d-1*t28-1.264669550498372d-1*t1
              t32 = 1/t22**2
              t33 = 1/t19
              t34 = -1.8533958105157808d+0*t30-1.2815820791490704d+0*t29
     1           -8.223668877838045d-1*t28-1.6039141941921276d-1*t1
              t35 = 1/t18**2
              t36 = 1.0d+0*t21*t33*t34*t35+1.1102230246251565d-16*t25*t2
     1           7*t31*t32+3.0506411443514264d-19*t24*t29+1.321039893133
     2           9265d-3*t20*t29
              t37 = 1/t2**3
              t38 = 1/rhob**4.333333333333333d+0
              t39 = 1/rhob**2.6666666666666666d+0
              t40 = 5.15088d-52*t39*t5*t6*t9-3.333333333333333d-50*t3*t3
     1           9*t9-5.333333333333334d-99*t38*t5*t8+1.6482816d-150*t37
     2           *t8/rhob**6+1.030176d-51*t37*t39*t4*t7-6.66666666666666
     3           6d-50*t39*t4*t5*t6-6.666666666666666d-50*t11*t39*t5*t6+
     4           4.1207039999999995d-101*t11*t37*t38*t6-1.33333333333333
     5           33d-99*t11*t38*t5+2.0603519999999997d-101*t10*t38*t5-6.
     6           666666666666666d-50*t10*t3*t39
              t41 = 5.0d-1*rhob*t26*t40*wght+5.0d-1*rhob*t12*t36*wght+5.
     1           0d-1*t12*t26*wght
              t42 = t31**2
              t43 = 1/t14**5
              t44 = 1/rhob**2.3333333333333334d+0
              t45 = 1/rhob**2.1666666666666665d+0
              t46 = t34**2
              t47 = 1/t2**4
              t48 = 1/rhob**7
              t49 = 1/rhob**5.333333333333333d+0
              t50 = 1/rhob**3.6666666666666664d+0
              fnc(iq) = 5.0d-1*rhob*t12*t26*t3*wght+fnc(iq)
              Amat(iq,D1_RB) = 2.57544d-52*t1*t12*t26*t5*wght+t3*t41+Ama
     1           t(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = t3*(5.0d-1*rhob*t26*(-1.373568d-51*t5
     1           *t50*t6*t9+5.306312954879999d-103*t37*t49*t6*t9+8.88888
     2           8888888888d-50*t3*t50*t9-3.43392d-101*t49*t5*t9+2.31111
     3           11111111113d-98*t49*t5*t8-1.53839616d-149*t37*t48*t8+2.
     4           5470302183424d-201*t47*t8/rhob**8.666666666666666d+0-2.
     5           747136d-51*t37*t4*t50*t7+1.5918938864639998d-102*t4*t47
     6           *t49*t7+1.7777777777777776d-49*t4*t5*t50*t6+1.777777777
     7           7777776d-49*t11*t5*t50*t6-1.373568d-100*t37*t4*t49*t6-2
     8           .4724223999999997d-100*t11*t37*t49*t6+6.367575545855999
     9           d-152*t11*t47*t48*t6+1.7777777777777776d-49*t10*t3*t50+
     :           2.222222222222222d-99*t4*t49*t5+8.0d-99*t11*t49*t5-1.23
     ;           62111999999999d-100*t10*t49*t5-2.7471359999999995d-150*
     <           t11*t37*t48+2.1225251819519997d-152*t10*t37*t48)*wght+5
     =           .0d-1*rhob*t12*(-2.0d+0*t21*t33*t46/t18**3+3.2163958997
     >           38507d+1*t21*t46/(t18**4*t19**2)+1.0d+0*t21*t33*t35*(2.
     ?           1622951122684114d+0*t45+1.7087761055320938d+0*t44+1.233
     @           5503316757068d+0*t43+2.673190323653546d-1*t39)+1.110223
     1           0246251565d-16*t25*t27*t32*(1.1632736958443765d+0*t45+9
     2           .89141964955861d-1*t44+6.003214762495226d-1*t43+2.10778
     3           25841639536d-1*t39)-4.0675215258019015d-19*t24*t44-1.76
     4           13865241785684d-3*t20*t44-2.220446049250313d-16*t25*t27
     5           *t42/t22**3+1.7854583920998188d-15*t25*t42/(t22**4*t23*
     6           *2)-8.497974591333913d-2*t29*t33*t34*t35-9.812069668265
     7           515d-18*t27*t29*t31*t32)*wght+1.0d+0*rhob*t36*t40*wght+
     8           1.0d+0*t26*t40*wght+1.0d+0*t12*t36*wght)+t1*t5*(2.57544
     9           d-52*t26*t40*wght+2.57544d-52*t12*t36*wght)+t39*t5*(5.1
     :           5088d-52*t41-4.2923999999999995d-52*t12*t26*wght)+2.653
     ;           1564774399996d-103*t12*t26*t37*t38*wght+Amat2(iq,D2_RB_
     <           RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_vs98 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& {{1}\over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\sqrt{\rho_\alpha}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_5} &=& -6.903522198342671 \times 10^{-18}\,\log 
C>    \left({{16.08197949869254}\over{5.98255043577108\,{\it t_4}
C>    +2.225569421150687\,{\it t_3}+0.8004286349993635\,{\it t_2}
C>    +0.1897004325747558\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1325688999052018\,{\it t_3}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_4}+3.844746237447211\,{\it t_3}+1.644733775567609\,{
C>    \it t_2}+0.2405871291288192\,{\it t_1}}}+1.0\right)\,
C>    \left(0.1274696188700087\,{\it t_3}+1.0\right)\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}\,\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_8} &=& {{2.0\,\tau_\alpha}\over{\rho_\alpha^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_9} &=& 0.00515088\,\left({\it t_8}+{\it t_7}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{10}} &=& {{1}\over{{\it t_9}}}\\\\ 
C>   {\it t_{11}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{12}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_9}^2}}\\\\ 
C>   {\it t_{14}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{15}} &=& {\it t_8}-9.11559972\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{18}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\sqrt{\rho_\beta}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\beta^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{23}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{22}}+2.225569421150687\,{\it t_{21}}+0.8004286349993635
C>    \,{\it t_{20}}+0.1897004325747558\,{\it t_{19}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{21}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{22}}+3.844746237447211\,{\it t_{21}}+1.644733775567609
C>    \,{\it t_{20}}+0.2405871291288192\,{\it t_{19}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{21}}+1.0\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{25}} &=& {\it t_{24}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{26}} &=& {{2.0\,\tau_\beta}\over{\rho_\beta^{{{5}
C>    \over{3}}}}}\\\\ 
C>   {\it t_{27}} &=& 0.00515088\,\left({\it t_{26}}+{\it t_{25}}
C>    -9.11559972\right)+1.0\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{27}}}}\\\\ 
C>   {\it t_{29}} &=& {{1}\over{{\it t_{27}}^2}}\\\\ 
C>   {\it t_{30}} &=& {\it t_{26}}-9.11559972\\\\ 
C>   {\it t_{31}} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{31}}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{33}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{34}} &=& {\it t_{33}}^4\\\\ 
C>   {\it t_{35}} &=& {{1}\over{{\it t_{31}}^4}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{{\it t_{31}}}}\\\\ 
C>   {\it t_{37}} &=& \left({\it t_{33}}\,{\it t_{36}}
C>    +1.0\right)^{{{4}\over{3}}}+\left(1.0-{\it t_{33}}\,{
C>    \it t_{36}}\right)^{{{4}\over{3}}}-2.0\\\\ 
C>   {\it t_{38}} &=& -1.923661050931536\,{\it t_{34}}\,{\it t_{35}}
C>    \,{\it t_{37}}\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{31}}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\sqrt{{\it t_{31}}}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{31}}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{42}} &=& 0.00304966\,\left({\it t_{26}}+{\it t_8}+{
C>    \it t_{25}}+{\it t_7}-18.23119944\right)+1.0\\\\ 
C>   {\it t_{43}} &=& {{1}\over{{\it t_{42}}}}\\\\ 
C>   {\it t_{44}} &=& {\it t_{25}}+{\it t_7}\\\\ 
C>   {\it t_{45}} &=& {{1}\over{{\it t_{42}}^2}}\\\\ 
C>   {\it t_{46}} &=& {\it t_{26}}+{\it t_8}-18.23119944\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{51}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{52}} &=& {{2.0\,\tau_s}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{53}} &=& 0.00515088\,\left({\it t_{52}}+{\it t_{51}}
C>    \,\sigma_{ss}-9.11559972\right)+1.0\\\\ 
C>   {\it t_{54}} &=& {{1}\over{{\it t_{53}}}}\\\\ 
C>   {\it t_{55}} &=& {{1}\over{{\it t_{53}}^2}}\\\\ 
C>   {\it t_{56}} &=& {\it t_{52}}-9.11559972\\\\ 
C>   f &=& 1.0\,\left({\it t_{31}}\,\left(-0.0598079686361971\,{
C>    \it t_{34}}\,{\it t_{35}}\,\left(0.1274696188700087\,{
C>    \it t_{32}}+1.0\right)\,{\it t_{37}}\,\log 
C>    \left({{32.16395899738507}\over{11.12037486309469\,{\it t_{41}}
C>    +3.844746237447211\,{\it t_{32}}+1.644733775567609\,{\it t_{40}}
C>    +0.2405871291288192\,{\it t_{39}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_{32}}
C>    +1.0\right)\,\left({\it t_{38}}+1.923661050931536\,{
C>    \it t_{37}}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{41}}+2.247591863577616\,{
C>    \it t_{32}}+0.4300972471276643\,{\it t_{40}}
C>    +0.1911512595127337\,{\it t_{39}}}}+1.0\right)-0.0621814
C>    \,\left(0.1325688999052018\,{\it t_{32}}+1.0\right)\,\left({
C>    \it t_{38}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{41}}+2.225569421150687\,{
C>    \it t_{32}}+0.8004286349993635\,{\it t_{40}}
C>    +0.1897004325747558\,{\it t_{39}}}}+1.0\right)\right)-{
C>    \it t_{23}}\,\rho_\beta-{\it t_5}\,\rho_\alpha\right)\,{
C>    \it t_{43}}\,\left({\it param}\left(3\right)\,{\it t_{46}}
C>    \,{\it t_{43}}+{\it param}\left(2\right)\,{\it t_{44}}\,{
C>    \it t_{43}}+{\it param}\left(6\right)\,{\it t_{46}}^2\,{
C>    \it t_{45}}+{\it param}\left(5\right)\,{\it t_{44}}\,{
C>    \it t_{46}}\,{\it t_{45}}+{\it param}\left(4\right)\,{
C>    \it t_{44}}^2\,{\it t_{45}}+{\it param}\left(1\right)\right)
C>    +1.0\,{\it t_{23}}\,\rho_\beta\,\left(1.0-{{0.125\,
C>    \sigma_{\beta\beta}}\over{\rho_\beta\,\tau_\beta}}\right)\,{
C>    \it t_{28}}\,\left({\it t_{18}}\,{\it t_{30}}\,{\it t_{28}}
C>    +{\it t_{17}}\,{\it t_{24}}\,\sigma_{\beta\beta}\,{\it t_{28}}
C>    +{\it t_{16}}\,{\it t_{30}}^2\,{\it t_{29}}+{\it t_{14}}\,{
C>    \it t_{24}}\,\sigma_{\beta\beta}\,{\it t_{30}}\,{\it t_{29}}
C>    +{{{\it t_{12}}\,\sigma_{\beta\beta}^2\,{\it t_{29}}}
C>    \over{\rho_\beta^{{{16}\over{3}}}}}+{\it t_{11}}\right)+1.0
C>    \,{\it t_5}\,\rho_\alpha\,\left(1.0-{{0.125\,
C>    \sigma_{\alpha\alpha}}\over{\rho_\alpha\,\tau_\alpha}}\right)
C>    \,{\it t_{10}}\,\left({\it t_{18}}\,{\it t_{15}}\,{\it t_{10}}
C>    +{\it t_{17}}\,{\it t_6}\,\sigma_{\alpha\alpha}\,{\it t_{10}}
C>    +{\it t_{16}}\,{\it t_{15}}^2\,{\it t_{13}}+{\it t_{14}}\,{
C>    \it t_6}\,\sigma_{\alpha\alpha}\,{\it t_{15}}\,{\it t_{13}}
C>    +{{{\it t_{12}}\,\sigma_{\alpha\alpha}^2\,{\it t_{13}}}
C>    \over{\rho_\alpha^{{{16}\over{3}}}}}+{\it t_{11}}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{50}}+2.225569421150687\,{\it t_{49}}+0.8004286349993635
C>    \,{\it t_{48}}+0.1897004325747558\,{\it t_{47}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{49}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{50}}+3.844746237447211\,{\it t_{49}}+1.644733775567609
C>    \,{\it t_{48}}+0.2405871291288192\,{\it t_{47}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{49}}+1.0\right)\right)
C>    \,\rho_s\,\left(1.0-{{0.125\,\sigma_{ss}}\over{\rho_s
C>    \,\tau_s}}\right)\,{\it t_{54}}\,\left({\it t_{18}}\,{
C>    \it t_{56}}\,{\it t_{54}}+{\it t_{17}}\,{\it t_{51}}\,
C>    \sigma_{ss}\,{\it t_{54}}+{\it t_{16}}\,{\it t_{56}}^2\,{
C>    \it t_{55}}+{\it t_{14}}\,{\it t_{51}}\,\sigma_{ss}\,{
C>    \it t_{56}}\,{\it t_{55}}+{{{\it t_{12}}\,\sigma_{ss}^2\,{
C>    \it t_{55}}}\over{\rho_s^{{{16}\over{3}}}}}+{
C>    \it t_{11}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] T van Voorhis, GE Scuseria, J.Chem.Phys. 109, 400 (1998)  , DOI: 
C> <a href="https://doi.org/10.1063/1.3005348 "> 
C> 10.1063/1.3005348 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_vs98_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*t19*taua
              t21 = 5.15088d-3*(t20+gammaaa*t18-9.11559972d+0)+1.0d+0
              t22 = 1/t21
              t23 = param(10)
              t24 = gammaaa**2
              t25 = 1/rhoa**5.333333333333333d+0
              t26 = 1/t21**2
              t27 = param(11)
              t28 = t20-9.11559972d+0
              t29 = param(12)
              t30 = t28**2
              t31 = param(8)
              t32 = param(9)
              t33 = t22*t28*t32+gammaaa*t18*t22*t31+t26*t29*t30+gammaaa*
     1           t18*t26*t27*t28+t23*t24*t25*t26+param(7)
              t34 = -2*rhoa*t14
              t35 = 4.0d+0*t19*taua
              t36 = 3.04966d-3*(t35+2*gammaaa*t18-1.823119944d+1)+1.0d+0
              t37 = 1/t36
              t38 = param(4)
              t39 = 1/t36**2
              t40 = param(5)
              t41 = t35-1.823119944d+1
              t42 = param(6)
              t43 = t41**2
              t44 = param(2)
              t45 = param(3)
              t46 = t37*t41*t45+2*gammaaa*t18*t37*t44+t39*t42*t43+2*gamm
     1           aaa*t18*t39*t40*t41+4*t24*t25*t38*t39+param(1)
              t47 = 1/rhoa**3.6666666666666664d+0
              t48 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d+
     1           0*gammaaa*t47
              t49 = 1/t21**3
              t50 = 1/rhoa**6.333333333333333d+0
              t51 = -3.3333333333333337d+0*t18*t22*t32*taua-6.6666666666
     1           66667d+0*t18*t26*t28*t29*taua-3.3333333333333337d+0*gam
     2           maaa*t25*t26*t27*taua-5.333333333333333d+0*t23*t24*t26*
     3           t50-1.030176d-2*t29*t30*t48*t49-1.030176d-2*gammaaa*t18
     4           *t27*t28*t48*t49-1.030176d-2*t23*t24*t25*t48*t49-5.1508
     5           8d-3*t26*t28*t32*t48-5.15088d-3*gammaaa*t18*t26*t31*t48
     6           -2.6666666666666666d+0*gammaaa*t22*t31*t47-2.6666666666
     7           666666d+0*gammaaa*t26*t27*t28*t47
              t52 = 1/t11
              t53 = 1/t2**3
              t54 = 1/rhoa**1.3333333333333333d+0
              t55 = 1/rhoa**1.1666666666666667d+0
              t56 = -9.970917392951799d-1*t55-7.418564737168958d-1*t54-4
     1           .002143174996817d-1*t53-1.264669550498372d-1*t19
              t57 = 1/t10**2
              t58 = 1/t7
              t59 = -1.8533958105157808d+0*t55-1.2815820791490704d+0*t54
     1           -8.223668877838045d-1*t53-1.6039141941921276d-1*t19
              t60 = 1/t6**2
              t61 = 1.0d+0*t58*t59*t60*t9+1.3210398931339265d-3*t54*t8+1
     1           .1102230246251565d-16*t13*t52*t56*t57+3.050641144351426
     2           4d-19*t12*t54
              t62 = 1.0d+0*rhoa*t17*t33*t61+1.0d+0*rhoa*t14*t17*t51+1.0d
     1           +0*t14*t17*t33
              t63 = 6.299605249474366d-1
              t64 = 1.414213562373095d+0
              t65 = 1/t64
              t66 = 7.937005259840998d-1
              t67 = 8.908987181403393d-1
              t68 = 5.982550435771079d+0*t5*t67+2.2255694211506874d+0*t4
     1           *t66+8.004286349993635d-1*t3*t65+1.8970043257475583d-1*
     2           t1*t63
              t69 = 1.6081979498692536d+1/t68+1.0d+0
              t70 = log(t69)
              t71 = 1.3256889990520176d-1*t4*t66+1.0d+0
              t72 = t34-1.243628d-1*rhoa*t70*t71
              t73 = 1/t36**3
              t74 = -3.3333333333333337d+0*t18*t37*t45*taua-6.6666666666
     1           66667d+0*t18*t39*t41*t42*taua-6.666666666666667d+0*gamm
     2           aaa*t25*t39*t40*taua-6.09932d-3*t42*t43*t48*t73-1.21986
     3           4d-2*gammaaa*t18*t40*t41*t48*t73-2.439728d-2*t24*t25*t3
     4           8*t48*t73-1.0666666666666666d+1*t24*t38*t39*t50-3.04966
     5           d-3*t39*t41*t45*t48-6.09932d-3*gammaaa*t18*t39*t44*t48-
     6           2.6666666666666666d+0*gammaaa*t37*t44*t47-2.66666666666
     7           66666d+0*gammaaa*t39*t40*t41*t47
              t75 = 1/t69
              t76 = 3.149802624737183d-1
              t77 = 1/t64**3
              t78 = 3.968502629920499d-1
              t79 = 4.4544935907016964d-1
              t80 = -9.970917392951799d-1*t55*t79-7.418564737168958d-1*t
     1           54*t78-4.002143174996817d-1*t53*t77-1.264669550498372d-
     2           1*t19*t76
              t81 = 1/t68**2
              t82 = 3.1090699999999993d-2*t8*t9+2*rhoa*(1.0d+0*t71*t75*t
     1           80*t81+2.747773264188437d-3*t54*t70*t78)-6.21814d-2*t70
     2           *t71-rhoa*t61+6.903522198342671d-18*t12*t13
              t83 = 1.0d+0*t46*t82+1.0d+0*t72*t74
              t84 = 1/rhoa**8
              t85 = -1.030176d-2*t23*t24*t49*t84-1.030176d-2*t18*t29*t30
     1           *t49-1.030176d-2*gammaaa*t25*t27*t28*t49-5.15088d-3*t18
     2           *t26*t28*t32-5.15088d-3*gammaaa*t25*t26*t31+t18*t22*t31
     3           +t18*t26*t27*t28+2*gammaaa*t23*t25*t26
              t86 = -2.439728d-2*t24*t38*t73*t84-6.09932d-3*t18*t42*t43*
     1           t73-1.219864d-2*gammaaa*t25*t40*t41*t73-3.04966d-3*t18*
     2           t39*t41*t45-6.09932d-3*gammaaa*t25*t39*t44+t18*t37*t44+
     3           t18*t39*t40*t41+4*gammaaa*t25*t38*t39
              t87 = 1/rhoa**7
              t88 = 1/rhoa**4.333333333333333d+0
              t89 = -2.060352d-2*gammaaa*t27*t28*t49*t88-1.030176d-2*gam
     1           maaa*t26*t31*t88+2.0d+0*gammaaa*t26*t27*t88-2.060352d-2
     2           *t23*t24*t49*t87-2.060352d-2*t19*t29*t30*t49-1.030176d-
     3           2*t19*t26*t28*t32+2.0d+0*t19*t22*t32+4.0d+0*t19*t26*t28
     4           *t29
              t90 = taua**2
              t91 = 1/t90
              t92 = -2.439728d-2*gammaaa*t40*t41*t73*t88-1.219864d-2*gam
     1           maaa*t39*t44*t88+4.0d+0*gammaaa*t39*t40*t88-4.879456d-2
     2           *t24*t38*t73*t87-1.219864d-2*t19*t42*t43*t73-6.09932d-3
     3           *t19*t39*t41*t45+2.0d+0*t19*t37*t45+4.0d+0*t19*t39*t41*
     4           t42
              t93 = t48**2
              t94 = 1/rhoa**2
              t95 = 1.25d-1*gammaaa*t33*t61+1.25d-1*gammaaa*t14*t51
              t96 = 1/t21**4
              t97 = 1/rhoa**4.666666666666667d+0
              t98 = 8.88888888888889d+0*t47*taua+9.777777777777779d+0*ga
     1           mmaaa*t97
              t99 = 1/rhoa**7.333333333333333d+0
              t100 = 2.6666666666666666d+1*gammaaa*t26*t27*t50*taua+1.37
     1           3568d-1*t18*t28*t29*t48*t49*taua+6.867840000000001d-2*g
     2           ammaaa*t25*t27*t48*t49*taua+3.4339200000000003d-2*t18*t
     3           26*t32*t48*taua+8.88888888888889d+0*t22*t32*t47*taua+1.
     4           7777777777777778d+1*t26*t28*t29*t47*taua+3.377777777777
     5           778d+1*t23*t24*t26*t99-1.030176d-2*t29*t30*t49*t98-1.03
     6           0176d-2*gammaaa*t18*t27*t28*t49*t98-1.030176d-2*t23*t24
     7           *t25*t49*t98-5.15088d-3*t26*t28*t32*t98-5.15088d-3*gamm
     8           aaa*t18*t26*t31*t98+9.777777777777779d+0*gammaaa*t22*t3
     9           1*t97+9.777777777777779d+0*gammaaa*t26*t27*t28*t97+1.59
     :           1893886464d-4*t29*t30*t93*t96+1.591893886464d-4*gammaaa
     ;           *t18*t27*t28*t93*t96+1.591893886464d-4*t23*t24*t25*t93*
     <           t96+5.30631295488d-5*t28*t32*t49*t93+5.30631295488d-5*g
     =           ammaaa*t18*t31*t49*t93+2.2222222222222224d+1*t25*t26*t2
     >           9*t90+1.0988544d-1*t23*t24*t48*t49*t50+5.494272d-2*gamm
     ?           aaa*t27*t28*t47*t48*t49+2.747136d-2*gammaaa*t26*t31*t47
     @           *t48
              t101 = 1/t11**2
              t102 = t56**2
              t103 = 1/t10**4
              t104 = 1/t10**3
              t105 = 1/t2**5
              t106 = 1/rhoa**2.3333333333333334d+0
              t107 = 1/rhoa**2.1666666666666665d+0
              t108 = 2.1077825841639536d-1*t18+1.1632736958443765d+0*t10
     1           7+9.89141964955861d-1*t106+6.003214762495226d-1*t105
              t109 = 1/t7**2
              t110 = t59**2
              t111 = 1/t6**4
              t112 = 1/t6**3
              t113 = 2.673190323653546d-1*t18+2.1622951122684114d+0*t107
     1           +1.7087761055320938d+0*t106+1.2335503316757068d+0*t105
              t114 = 1.0d+0*t113*t58*t60*t9-2.0d+0*t110*t112*t58*t9+3.21
     1           6395899738507d+1*t109*t110*t111*t9-1.7613865241785684d-
     2           3*t106*t8-8.497974591333913d-2*t54*t58*t59*t60-9.812069
     3           668265515d-18*t52*t54*t56*t57+1.1102230246251565d-16*t1
     4           08*t13*t52*t57-2.220446049250313d-16*t102*t104*t13*t52+
     5           1.7854583920998188d-15*t101*t102*t103*t13-4.06752152580
     6           19015d-19*t106*t12
              t115 = 1.25d-1*gammaaa*t14*t16*t33*t94+2.0d+0*rhoa*t17*t51
     1           *t61+2.0d+0*t17*t33*t61+1.25d-1*gammaaa*t15*t16*t33*t61
     2           +2.0d+0*t14*t17*t51+1.25d-1*gammaaa*t14*t15*t16*t51+1.0
     3           d+0*rhoa*t114*t17*t33+1.0d+0*rhoa*t100*t14*t17
              t116 = -5.15088d-3*rhoa*t14*t17*t33*t98-5.15088d-3*t48*t62
     1           -5.15088d-3*rhoa*t17*t33*t48*t61-5.15088d-3*rhoa*t14*t1
     2           7*t48*t51-5.15088d-3*t14*t17*t33*t48
              t117 = 1.86008522312d-5*t46*t72*t73*t93
              t118 = 1/t36**4
              t119 = 1.1160511338720001d-4*gammaaa*t118*t18*t40*t41*t93
              t120 = 2.2321022677440003d-4*t118*t24*t25*t38*t93
              t121 = 5.580255669360001d-5*t118*t42*t43*t93
              t122 = 1.3011882666666666d-1*t24*t38*t48*t50*t73
              t123 = 8.132426666666668d-2*gammaaa*t25*t40*t48*t73*taua
              t124 = 3.2529706666666663d-2*gammaaa*t40*t41*t47*t48*t73
              t125 = 8.132426666666668d-2*t18*t41*t42*t48*t73*taua
              t126 = 1.86008522312d-5*t41*t45*t73*t93
              t127 = 3.72017044624d-5*gammaaa*t18*t44*t73*t93
              t128 = 1.6264853333333332d-2*gammaaa*t39*t44*t47*t48
              t129 = 2.033106666666667d-2*t18*t39*t45*t48*taua
              t130 = 2.2222222222222224d+1*t25*t39*t42*t90
              t131 = 3.5555555555555557d+1*gammaaa*t39*t40*t50*taua+8.88
     1           888888888889d+0*t37*t45*t47*taua+1.7777777777777778d+1*
     2           t39*t41*t42*t47*taua+5.333333333333333d+1*t24*t38*t39*t
     3           99-6.09932d-3*t42*t43*t73*t98-1.219864d-2*gammaaa*t18*t
     4           40*t41*t73*t98-2.439728d-2*t24*t25*t38*t73*t98-3.04966d
     5           -3*t39*t41*t45*t98-6.09932d-3*gammaaa*t18*t39*t44*t98+9
     6           .777777777777779d+0*gammaaa*t37*t44*t97+9.7777777777777
     7           79d+0*gammaaa*t39*t40*t41*t97+t130+t129+t128+t127+t126+
     8           t125+t124+t123+t122+t121+t120+t119
              t132 = 2.0d+0*t74*t82
              t133 = 2.0d+0*t71*t75*t80*t81
              t134 = 5.495546528376875d-3*t54*t70*t78
              t135 = 1/t69**2
              t136 = t80**2
              t137 = 1/t68**4
              t138 = 1.6081979498692536d+1*t135*t136*t137*t71
              t139 = 1/t68**3
              t140 = -2.0d+0*t136*t139*t71*t75
              t141 = 1.9842513149602492d-1
              t142 = 6.003214762495226d-1*t105/t64**5+3.319549557987472d
     1           -2*t18+9.89141964955861d-1*t106*t141+2.5908976111853255
     2           d-1*t107
              t143 = 1.0d+0*t142*t71*t75*t81
              t144 = -3.663697685584583d-3*t106*t141*t70
              t145 = 8.157414703487641d+0*t5*t67+2.247591863577616d+0*t4
     1           *t66+4.3009724712766434d-1*t3*t65+1.9115125951273373d-1
     2           *t1*t63
              t146 = 2.9608813203268075d+1/t145+1.0d+0
              t147 = log(t146)
              t148 = 6.901399211255825d-2*t4*t66+1.0d+0
              t149 = -8.837926660346784d-2*t54*t75*t78*t80*t81
              t150 = 2*rhoa*(8.443431970194815d-3*t147*t148*t94+t149+t14
     1           4+t143+t140+t138)-2.0d+0*t58*t59*t60*t9-2.6420797862678
     2           53d-3*t54*t8-2.220446049250313d-16*t13*t52*t56*t57-6.10
     3           1282288702853d-19*t12*t54+t134+t133-rhoa*t114
              t151 = 1.0d+0*t131*t72+1.0d+0*t150*t46+t132
              t152 = -3.04966d-3*t48*t72*t74
              t153 = -3.04966d-3*t46*t48*t82
              t154 = -3.04966d-3*t48*t83
              t155 = -3.04966d-3*t46*t72*t98+t154+t153+t152
              t156 = 1.7777777777777778d+1*gammaaa*t39*t40*t50*taua+1.42
     1           22222222222222d+1*t24*t38*t39*t99+t130+t129+t128+t127+t
     2           126+t125+t124+t123+t122+t121+t120+t119
              t157 = -8.443431970194815d-3*t147*t148*t94
              t158 = 2*rhoa*(t157+t149+t144+t143+t140+t138)+t134+t133
              t159 = 1.0d+0*t156*t72+1.0d+0*t158*t46+t132
              t160 = t154+t153+t152
              t161 = 1.25d-1*gammaaa*t14*t85+1.25d-1*t14*t33
              t162 = 1/rhoa**9
              t163 = 3.4339200000000003d-2*gammaaa*t27*t49*t84*taua+6.86
     1           7840000000001d-2*t25*t28*t29*t49*taua+1.716960000000000
     2           2d-2*t25*t26*t32*taua-3.3333333333333337d+0*t25*t26*t27
     3           *taua+1.591893886464d-4*t23*t24*t48*t84*t96+1.591893886
     4           464d-4*t18*t29*t30*t48*t96+1.591893886464d-4*gammaaa*t2
     5           5*t27*t28*t48*t96+5.494272d-2*gammaaa*t27*t28*t49*t50+2
     6           .747136d-2*gammaaa*t26*t31*t50-1.0666666666666666d+1*ga
     7           mmaaa*t23*t26*t50+5.30631295488d-5*t18*t28*t32*t48*t49+
     8           5.30631295488d-5*gammaaa*t25*t31*t48*t49-1.030176d-2*t1
     9           8*t27*t28*t48*t49-2.060352d-2*gammaaa*t23*t25*t48*t49+2
     :           .747136d-2*t29*t30*t47*t49+8.241408d-2*t162*t23*t24*t49
     ;           -5.15088d-3*t18*t26*t31*t48+1.373568d-2*t26*t28*t32*t47
     <           -2.6666666666666666d+0*t22*t31*t47-2.6666666666666666d+
     =           0*t26*t27*t28*t47
              t164 = 1.0d+0*rhoa*t17*t61*t85+1.0d+0*t14*t17*t85-1.25d-1*
     1           t16*t33*t61-1.25d-1*t14*t16*t51-1.25d-1*t14*t15*t16*t33
     2           +1.0d+0*rhoa*t14*t163*t17
              t165 = 1.373568d-2*t14*t17*t33-5.15088d-3*t62
              t166 = -3.04966d-3*t39*t48*t72*t86
              t167 = 1.86008522312d-5*t18*t46*t48*t72*t73
              t168 = 2.2321022677440003d-4*t118*t24*t38*t48*t84
              t169 = 1.1160511338720001d-4*gammaaa*t118*t25*t40*t41*t48
              t170 = 5.580255669360001d-5*t118*t18*t42*t43*t48
              t171 = 4.066213333333334d-2*gammaaa*t40*t73*t84*taua
              t172 = 3.72017044624d-5*gammaaa*t25*t44*t48*t73
              t173 = -2.439728d-2*gammaaa*t25*t38*t48*t73
              t174 = 4.066213333333334d-2*t25*t41*t42*t73*taua
              t175 = 1.86008522312d-5*t18*t41*t45*t48*t73
              t176 = -6.09932d-3*t18*t40*t41*t48*t73
              t177 = 1.0165533333333335d-2*t25*t39*t45*taua
              t178 = -3.3333333333333337d+0*t25*t39*t40*taua
              t179 = -3.04966d-3*t18*t39*t44*t48
              t180 = 4.879456d-2*gammaaa*t40*t41*t50*t73+1.6264853333333
     1           332d-2*t42*t43*t47*t73+1.3011882666666666d-1*t162*t24*t
     2           38*t73+2.439728d-2*gammaaa*t39*t44*t50-16*gammaaa*t38*t
     3           39*t50+8.132426666666667d-3*t39*t41*t45*t47-2.666666666
     4           6666666d+0*t37*t44*t47-2.6666666666666666d+0*t39*t40*t4
     5           1*t47+t179+t178+t177+t176+t175+t174+t173+t172+t171+t170
     6           +t169+t168
              t181 = 1.0d+0*t82*t86
              t182 = 1.0d+0*t180*t72+t181
              t183 = -3.04966d-3*t18*t39*t83
              t184 = 1.6264853333333332d-2*gammaaa*t40*t41*t50*t73+6.505
     1           941333333333d-2*t162*t24*t38*t73+8.132426666666667d-3*g
     2           ammaaa*t39*t44*t50-5.333333333333333d+0*gammaaa*t38*t39
     3           *t50+t179+t178+t177+t176+t175+t174+t173+t172+t171+t170+
     4           t169+t168
              t185 = 1.0d+0*t184*t72+t181
              t186 = 1/rhoa**1.0666666666666666d+1
              t187 = 1.591893886464d-4*gammaaa*t27*t28*t84*t96+1.5918938
     1           86464d-4*t25*t29*t30*t96+1.591893886464d-4*t186*t23*t24
     2           *t96+5.30631295488d-5*gammaaa*t31*t49*t84-4.120704d-2*g
     3           ammaaa*t23*t49*t84+5.30631295488d-5*t25*t28*t32*t49-2.0
     4           60352d-2*t25*t27*t28*t49-1.030176d-2*t25*t26*t31+2*t23*
     5           t25*t26
              t188 = 3.72017044624d-5*gammaaa*t44*t73*t84-4.879456d-2*ga
     1           mmaaa*t38*t73*t84+1.1160511338720001d-4*gammaaa*t118*t4
     2           0*t41*t84+1.86008522312d-5*t25*t41*t45*t73-1.219864d-2*
     3           t25*t40*t41*t73-6.09932d-3*t25*t39*t44+5.58025566936000
     4           1d-5*t118*t25*t42*t43+2*t25*t38*t39+2.2321022677440003d
     5           -4*t118*t186*t24*t38
              t189 = 1.0d+0*t188*t37*t72
              t190 = -6.09932d-3*t18*t39*t72*t86
              t191 = 1.86008522312d-5*t25*t46*t72*t73
              t192 = 1.373568d-1*t28*t29*t49*t88*taua+3.4339200000000003
     1           d-2*t26*t32*t88*taua-1.3333333333333333d+1*t26*t29*t88*
     2           taua+6.867840000000001d-2*gammaaa*t27*t49*t87*taua+3.18
     3           3787772928d-4*gammaaa*t27*t28*t48*t88*t96+3.18378777292
     4           8d-4*t23*t24*t48*t87*t96+3.183787772928d-4*t19*t29*t30*
     5           t48*t96+1.061262590976d-4*gammaaa*t31*t48*t49*t88-2.060
     6           352d-2*gammaaa*t27*t48*t49*t88+1.4422464000000002d-1*t2
     7           3*t24*t49*t84+1.061262590976d-4*t19*t28*t32*t48*t49-4.1
     8           20704d-2*t19*t28*t29*t48*t49+3.4339200000000003d-2*t18*
     9           t29*t30*t49+8.928192d-2*gammaaa*t25*t27*t28*t49-1.03017
     :           6d-2*t19*t26*t32*t48+1.7169600000000002d-2*t18*t26*t28*
     ;           t32-3.3333333333333337d+0*t18*t22*t32+4.464096d-2*gamma
     <           aa*t25*t26*t31-6.666666666666667d+0*t18*t26*t28*t29-8.6
     =           66666666666666d+0*gammaaa*t25*t26*t27
              t193 = 1.25d-1*gammaaa*t33*t61*t91+1.25d-1*gammaaa*t14*t51
     1           *t91+1.25d-1*gammaaa*t14*t15*t33*t91+1.0d+0*rhoa*t17*t6
     2           1*t89+1.0d+0*t14*t17*t89+1.0d+0*rhoa*t14*t17*t192
              t194 = -3.04966d-3*t39*t48*t72*t92
              t195 = 3.72017044624d-5*t19*t46*t48*t72*t73
              t196 = 4.4642045354880006d-4*t118*t24*t38*t48*t87
              t197 = 2.2321022677440003d-4*gammaaa*t118*t40*t41*t48*t88
              t198 = 1.1160511338720001d-4*t118*t19*t42*t43*t48
              t199 = 8.132426666666668d-2*gammaaa*t40*t73*t87*taua
              t200 = 7.44034089248d-5*gammaaa*t44*t48*t73*t88
              t201 = -2.439728d-2*gammaaa*t40*t48*t73*t88
              t202 = 8.132426666666668d-2*t41*t42*t73*t88*taua
              t203 = 3.72017044624d-5*t19*t41*t45*t48*t73
              t204 = -2.439728d-2*t19*t41*t42*t48*t73
              t205 = 2.033106666666667d-2*t39*t45*t88*taua
              t206 = -1.3333333333333333d+1*t39*t42*t88*taua
              t207 = -6.09932d-3*t19*t39*t45*t48
              t208 = 2.1144309333333333d-1*t24*t38*t73*t84+2.03310666666
     1           6667d-2*t18*t42*t43*t73+7.319184000000001d-2*gammaaa*t2
     2           5*t40*t41*t73+1.0165533333333335d-2*t18*t39*t41*t45-3.3
     3           333333333333337d+0*t18*t37*t45+3.6595920000000004d-2*ga
     4           mmaaa*t25*t39*t44-6.666666666666667d+0*t18*t39*t41*t42-
     5           1.2d+1*gammaaa*t25*t39*t40+t207+t206+t205+t204+t203+t20
     6           2+t201+t200+t199+t198+t197+t196
              t209 = 1.0d+0*t82*t92
              t210 = 1.0d+0*t208*t72+t209
              t211 = -6.09932d-3*t19*t39*t83
              t212 = 1.3011882666666666d-1*t24*t38*t73*t84+3.25297066666
     1           66663d-2*gammaaa*t25*t40*t41*t73+1.6264853333333332d-2*
     2           gammaaa*t25*t39*t44-5.333333333333333d+0*gammaaa*t25*t3
     3           9*t40+t207+t206+t205+t204+t203+t202+t201+t200+t199+t198
     4           +t197+t196
              t213 = 1.0d+0*t212*t72+t209
              t214 = 1/rhoa**9.666666666666666d+0
              t215 = 3.183787772928d-4*t29*t30*t88*t96+3.183787772928d-4
     1           *gammaaa*t27*t28*t87*t96+3.183787772928d-4*t214*t23*t24
     2           *t96+1.061262590976d-4*t28*t32*t49*t88-4.120704d-2*t28*
     3           t29*t49*t88-2.060352d-2*t27*t28*t49*t88-1.030176d-2*t26
     4           *t32*t88-1.030176d-2*t26*t31*t88+2.0d+0*t26*t27*t88+1.0
     5           61262590976d-4*gammaaa*t31*t49*t87-2.060352d-2*gammaaa*
     6           t27*t49*t87-4.120704d-2*gammaaa*t23*t49*t87
              t216 = 1/rhoa**3.3333333333333337d+0
              t217 = 3.72017044624d-5*t41*t45*t73*t88-2.439728d-2*t41*t4
     1           2*t73*t88-1.219864d-2*t40*t41*t73*t88-6.09932d-3*t39*t4
     2           5*t88-6.09932d-3*t39*t44*t88+1.1160511338720001d-4*t118
     3           *t42*t43*t88+2.0d+0*t39*t40*t88+7.44034089248d-5*gammaa
     4           a*t44*t73*t87-2.439728d-2*gammaaa*t40*t73*t87-4.879456d
     5           -2*gammaaa*t38*t73*t87+2.2321022677440003d-4*gammaaa*t1
     6           18*t40*t41*t87+4.4642045354880006d-4*t118*t214*t24*t38
              t218 = 1.0d+0*t217*t37*t72
              t219 = -6.09932d-3*t19*t39*t72*t86
              t220 = -3.04966d-3*t18*t39*t72*t92
              t221 = 3.72017044624d-5*t46*t72*t73*t88
              t222 = 1/rhoa**8.666666666666666d+0
              t223 = 1/rhoa**6
              t224 = 6.367575545856d-4*t216*t29*t30*t96+6.367575545856d-
     1           4*gammaaa*t223*t27*t28*t96+6.367575545856d-4*t222*t23*t
     2           24*t96+2.122525181952d-4*t216*t28*t32*t49+2.12252518195
     3           2d-4*gammaaa*t223*t31*t49-1.6482816d-1*t216*t28*t29*t49
     4           -8.241408d-2*gammaaa*t223*t27*t49-4.120704d-2*t216*t26*
     5           t32+8.0d+0*t216*t26*t29
              t225 = 1/taua**3
              t226 = 7.44034089248d-5*t216*t41*t45*t73+1.488068178496d-4
     1           *gammaaa*t223*t44*t73-9.758912d-2*t216*t41*t42*t73-9.75
     2           8912d-2*gammaaa*t223*t40*t73-2.439728d-2*t216*t39*t45+2
     3           .2321022677440003d-4*t118*t216*t42*t43+8.0d+0*t216*t39*
     4           t42+4.4642045354880006d-4*gammaaa*t118*t223*t40*t41+8.9
     5           28409070976001d-4*t118*t222*t24*t38
              t227 = 1.0d+0*t226*t37*t72
              t228 = -1.219864d-2*t19*t39*t72*t92
              t229 = 7.44034089248d-5*t216*t46*t72*t73
              t230 = t48**3
              t231 = 1/rhoa**3
              t232 = 1/t21**5
              t233 = 1/rhoa**5.666666666666667d+0
              t234 = -3.2592592592592595d+1*t97*taua-4.5629629629629626d
     1           +1*gammaaa*t233
              t235 = 1/rhoa**8.333333333333334d+0
              t236 = t56**3
              t237 = 1/t2**7
              t238 = 1/rhoa**3.1666666666666665d+0
              t239 = t59**3
              t240 = 2.0690405167709364d+3*t239*t9/(t6**6*t7**3)+1.0d+0*
     1           (-7.128507529742789d-1*t47-4.684972743248224d+0*t238-3.
     2           083875829189267d+0*t237-3.9871442462415524d+0*t216)*t58
     3           *t60*t9-1.9298375398431045d+2*t109*t239*t9/t6**5-6.0d+0
     4           *t112*t113*t58*t59*t9+9.649187699215522d+1*t109*t111*t1
     5           13*t59*t9+6.0d+0*t111*t239*t58*t9+4.1099018897499934d-3
     6           *t216*t8+1.6995949182667827d-1*t106*t58*t59*t60-1.27469
     7           6188700087d-1*t113*t54*t58*t60+2.549392377400174d-1*t11
     8           0*t112*t54*t58+1.962413933653103d-17*t106*t52*t56*t57-1
     9           .4718104502398274d-17*t108*t52*t54*t57+1.11022302462515
     :           65d-16*t13*(-5.620753557770543d-1*t47-2.520426340996149
     ;           d+0*t238-1.5008036906238065d+0*t237-2.3079979182303428d
     <           +0*t216)*t52*t57-6.661338147750939d-16*t104*t108*t13*t5
     =           2*t56+5.356375176299456d-15*t101*t103*t108*t13*t56+2.94
     >           3620900479655d-17*t102*t104*t52*t54-4.0999275947472624d
     ?           +0*t109*t110*t111*t54-2.3669625486718335d-16*t101*t102*
     @           t103*t54+6.661338147750939d-16*t103*t13*t236*t52+5.7427
     1           41051503565d-14*t13*t236/(t10**6*t11**3)-1.071275035259
     2           8913d-14*t101*t13*t236/t10**5+9.490883560204437d-19*t12
     3           *t216
              t241 = -1.7017882504620419d-7*t118*t230*t46*t72
              t242 = 1/t36**5
              t243 = -1.3614306003696336d-6*gammaaa*t18*t230*t242*t40*t4
     1           1
              t244 = -2.722861200739267d-6*t230*t24*t242*t25*t38
              t245 = -6.807153001848167d-7*t230*t242*t42*t43
              t246 = -4.464204535488d-4*gammaaa*t118*t40*t41*t47*t93
              t247 = -1.1160511338720001d-3*t118*t18*t41*t42*t93*taua
              t248 = -1.7017882504620419d-7*t118*t230*t41*t45
              t249 = -1.7856818141952002d-3*t118*t24*t38*t50*t93
              t250 = -1.1160511338720001d-3*gammaaa*t118*t25*t40*t93*tau
     1           a
              t251 = -3.4035765009240837d-7*gammaaa*t118*t18*t230*t44
              t252 = -4.066213333333334d-1*t25*t42*t48*t73*t90
              t253 = -1.4880681784959998d-4*gammaaa*t44*t47*t73*t93
              t254 = -1.8600852231200002d-4*t18*t45*t73*t93*taua
              t255 = 4.824593849607761d+1*t135*t136*t137*t71
              t256 = -6.0d+0*t136*t139*t71*t75
              t257 = 3.0d+0*t142*t71*t75*t81
              t258 = -1.099109305675375d-2*t106*t141*t70
              t259 = -2.6513779981040353d-1*t54*t75*t78*t80*t81
              t260 = t80**3
              t261 = 5.172601291927341d+2*t260*t71/(t68**6*t69**3)
              t262 = -9.649187699215522d+1*t135*t260*t71/t68**5
              t263 = 6.0d+0*t137*t260*t71*t75
              t264 = 4.824593849607761d+1*t135*t137*t142*t71*t80
              t265 = -6.0d+0*t139*t142*t71*t75*t80
              t266 = 9.921256574801247d-2
              t267 = 1.0d+0*(-1.5008036906238065d+0*t237/t64**7-4.426066
     1           0773166294d-2*t47-2.3079979182303428d+0*t216*t266-2.806
     2           8057454507694d-1*t238)*t71*t75*t81
              t268 = 8.548627933030694d-3*t216*t266*t70
              t269 = 1.767585332069357d-1*t106*t141*t75*t80*t81
              t270 = 1/t146
              t271 = -1.3595691172479402d+0*t55*t79-7.491972878592053d-1
     1           *t54*t78-2.1504862356383217d-1*t53*t77-1.27434173008489
     2           14d-1*t19*t76
              t272 = 1/t145**2
              t273 = -2.1319703304396778d+0*t135*t136*t137*t54*t78
              t274 = 2.6513779981040353d-1*t136*t139*t54*t75*t78
              t275 = -1.3256889990520176d-1*t142*t54*t75*t78*t81
              t276 = -6.09932d-3*t48*t74*t82
              t277 = 1.86008522312d-5*t72*t74*t93
              t278 = 1.86008522312d-5*t46*t82*t93
              t279 = -6.09932d-3*t155*t48
              t280 = -1.25d-1*gammaaa*t14*t85-1.25d-1*t14*t33
              t281 = 1/rhoa**10
              t282 = 1.86008522312d-5*t72*t73*t86*t93
              t283 = -1.7017882504620419d-7*t118*t18*t46*t72*t93
              t284 = -1.3614306003696336d-6*gammaaa*t242*t25*t40*t41*t93
              t285 = -2.722861200739267d-6*t24*t242*t38*t84*t93
              t286 = -6.807153001848167d-7*t18*t242*t42*t43*t93
              t287 = 2.2321022677440003d-4*t118*t24*t38*t84*t98
              t288 = -7.440340892480001d-4*gammaaa*t118*t40*t48*t84*taua
              t289 = 1.1160511338720001d-4*gammaaa*t118*t25*t40*t41*t98
              t290 = -7.440340892480001d-4*t118*t25*t41*t42*t48*taua
              t291 = -1.7017882504620419d-7*t118*t18*t41*t45*t93
              t292 = 5.580255669360001d-5*t118*t18*t40*t41*t93
              t293 = -3.4035765009240837d-7*gammaaa*t118*t25*t44*t93
              t294 = 2.2321022677440003d-4*gammaaa*t118*t25*t38*t93
              t295 = 5.580255669360001d-5*t118*t18*t42*t43*t98
              t296 = 3.72017044624d-5*gammaaa*t25*t44*t73*t98
              t297 = -2.439728d-2*gammaaa*t25*t38*t73*t98
              t298 = -1.2400568154133336d-4*t25*t45*t48*t73*taua
              t299 = 4.066213333333334d-2*t25*t40*t48*t73*taua
              t300 = 1.86008522312d-5*t18*t41*t45*t73*t98
              t301 = -6.09932d-3*t18*t40*t41*t73*t98
              t302 = -1.3554044444444446d-1*t42*t73*t84*t90
              t303 = 1.86008522312d-5*t18*t44*t73*t93
              t304 = -3.04966d-3*t18*t39*t44*t98
              t305 = 1.0d+0*t150*t86
              t306 = -3.04966d-3*t151*t18*t39
              t307 = -3.04966d-3*t72*t86*t98
              t308 = -3.04966d-3*t48*t82*t86
              t309 = 8.132426666666667d-3*t47*t72*t74
              t310 = 8.132426666666667d-3*t46*t47*t82
              t311 = -3.04966d-3*t182*t48
              t312 = -6.09932d-3*t155*t18*t73
              t313 = 8.88888888888889d+0*t39*t40*t50*taua
              t314 = -3.04966d-3*t184*t48*t72
              t315 = 2.5d-1*t14*t85+1.25d-1*gammaaa*t14*t187
              t316 = 1/rhoa**1.1666666666666665d+1
              t317 = -1.030176d-2*t164
              t318 = -3.04966d-3*t188*t39*t48*t72
              t319 = -2.722861200739267d-6*t186*t24*t242*t38*t48
              t320 = -1.3614306003696336d-6*gammaaa*t242*t40*t41*t48*t84
              t321 = -6.807153001848167d-7*t242*t25*t42*t43*t48
              t322 = -3.7201704462400004d-4*gammaaa*t118*t186*t40*taua
              t323 = -3.4035765009240837d-7*gammaaa*t118*t44*t48*t84
              t324 = 4.4642045354880006d-4*gammaaa*t118*t38*t48*t84
              t325 = -3.7201704462400004d-4*t118*t41*t42*t84*taua
              t326 = -1.7017882504620419d-7*t118*t25*t41*t45*t48
              t327 = 1.1160511338720001d-4*t118*t25*t40*t41*t48
              t328 = -6.200284077066668d-5*t45*t73*t84*taua
              t329 = 4.066213333333334d-2*t40*t73*t84*taua
              t330 = 3.72017044624d-5*t25*t44*t48*t73
              t331 = -1.219864d-2*t25*t38*t48*t73
              t332 = 1.0d+0*t188*t82
              t333 = 3.72017044624d-5*t18*t48*t72*t73*t86
              t334 = -1.7017882504620419d-7*t118*t25*t46*t48*t72
              t335 = 1.86008522312d-5*t25*t73*t83
              t336 = 1/rhoa**1.3333333333333333d+1
              t337 = 1.0d+0*t37*t72*(5.580255669359999d-5*t44*t73*t84-3.
     1           6595920000000004d-2*t38*t73*t84-1.7017882504620419d-7*t
     2           118*t41*t45*t84-6.807153001848167d-7*t242*t42*t43*t84+1
     3           .6740767008080004d-4*t118*t40*t41*t84-3.403576500924083
     4           7d-7*gammaaa*t118*t186*t44-1.3614306003696336d-6*gammaa
     5           a*t186*t242*t40*t41-2.722861200739267d-6*t24*t242*t336*
     6           t38+6.696306803232002d-4*gammaaa*t118*t186*t38)
              t338 = -9.148980000000001d-3*t18*t188*t39*t72
              t339 = 5.580255669359999d-5*t25*t72*t73*t86
              t340 = -1.7017882504620419d-7*t118*t46*t72*t84
              t341 = 1.86008522312d-5*t72*t73*t92*t93
              t342 = -3.4035765009240837d-7*t118*t19*t46*t72*t93
              t343 = -2.722861200739267d-6*gammaaa*t242*t40*t41*t88*t93
              t344 = -5.445722401478534d-6*t24*t242*t38*t87*t93
              t345 = -1.3614306003696336d-6*t19*t242*t42*t43*t93
              t346 = 4.4642045354880006d-4*t118*t24*t38*t87*t98
              t347 = -1.4880681784960004d-3*gammaaa*t118*t40*t48*t87*tau
     1           a
              t348 = 2.2321022677440003d-4*gammaaa*t118*t40*t41*t88*t98
              t349 = -1.4880681784960004d-3*t118*t41*t42*t48*t88*taua
              t350 = -3.4035765009240837d-7*t118*t19*t41*t45*t93
              t351 = 2.2321022677440003d-4*t118*t19*t41*t42*t93
              t352 = -6.807153001848167d-7*gammaaa*t118*t44*t88*t93
              t353 = 2.2321022677440003d-4*gammaaa*t118*t40*t88*t93
              t354 = 1.1160511338720001d-4*t118*t19*t42*t43*t98
              t355 = 7.44034089248d-5*gammaaa*t44*t73*t88*t98
              t356 = -2.439728d-2*gammaaa*t40*t73*t88*t98
              t357 = -2.4801136308266672d-4*t45*t48*t73*t88*taua
              t358 = 1.6264853333333334d-1*t42*t48*t73*t88*taua
              t359 = 3.72017044624d-5*t19*t41*t45*t73*t98
              t360 = -2.439728d-2*t19*t41*t42*t73*t98
              t361 = -2.710808888888889d-1*t42*t73*t87*t90
              t362 = 3.72017044624d-5*t19*t45*t73*t93
              t363 = -6.09932d-3*t19*t39*t45*t98
              t364 = 1.0d+0*t150*t92
              t365 = -6.09932d-3*t151*t19*t39
              t366 = -3.04966d-3*t72*t92*t98
              t367 = -3.04966d-3*t48*t82*t92
              t368 = 1.0165533333333335d-2*t18*t72*t74
              t369 = 1.0165533333333335d-2*t18*t46*t82
              t370 = -3.04966d-3*t210*t48
              t371 = -1.219864d-2*t155*t19*t73
              t372 = -3.04966d-3*t212*t48*t72
              t373 = -3.04966d-3*t217*t39*t48*t72
              t374 = -5.445722401478534d-6*t214*t24*t242*t38*t48
              t375 = -2.722861200739267d-6*gammaaa*t242*t40*t41*t48*t87
              t376 = -1.3614306003696336d-6*t242*t42*t43*t48*t88
              t377 = -7.440340892480001d-4*gammaaa*t118*t214*t40*taua
              t378 = -6.807153001848167d-7*gammaaa*t118*t44*t48*t87
              t379 = 4.4642045354880006d-4*gammaaa*t118*t38*t48*t87
              t380 = 2.2321022677440003d-4*gammaaa*t118*t40*t48*t87
              t381 = -7.440340892480001d-4*t118*t41*t42*t87*taua
              t382 = -3.4035765009240837d-7*t118*t41*t45*t48*t88
              t383 = 1.1160511338720001d-4*t118*t40*t41*t48*t88
              t384 = 2.2321022677440003d-4*t118*t41*t42*t48*t88
              t385 = -1.2400568154133336d-4*t45*t73*t87*taua
              t386 = 4.066213333333334d-2*t40*t73*t87*taua
              t387 = 8.132426666666668d-2*t42*t73*t87*taua
              t388 = 3.72017044624d-5*t44*t48*t73*t88
              t389 = 3.72017044624d-5*t45*t48*t73*t88
              t390 = -1.219864d-2*t40*t48*t73*t88
              t391 = 1.0d+0*t217*t82
              t392 = 3.72017044624d-5*t19*t48*t72*t73*t86
              t393 = 1.86008522312d-5*t18*t48*t72*t73*t92
              t394 = 8.132426666666667d-3*t39*t47*t72*t92
              t395 = -3.4035765009240837d-7*t118*t46*t48*t72*t88
              t396 = -6.09932d-3*t182*t19*t39
              t397 = 3.72017044624d-5*t73*t83*t88
              t398 = -3.04966d-3*t18*t213*t39
              t399 = -6.09932d-3*t185*t19*t39
              t400 = 1/rhoa**1.2333333333333334d+1
              t401 = 1.0d+0*t37*t72*(3.72017044624d-5*t45*t73*t87+7.4403
     1           4089248d-5*t44*t73*t87-2.439728d-2*t40*t73*t87-2.439728
     2           d-2*t38*t73*t87-3.4035765009240837d-7*t118*t41*t45*t87-
     3           1.3614306003696336d-6*t242*t42*t43*t87+2.23210226774400
     4           03d-4*t118*t41*t42*t87+2.2321022677440003d-4*t118*t40*t
     5           41*t87-6.807153001848167d-7*gammaaa*t118*t214*t44-2.722
     6           861200739267d-6*gammaaa*t214*t242*t40*t41-5.44572240147
     7           8534d-6*t24*t242*t38*t400+2.2321022677440003d-4*gammaaa
     8           *t118*t214*t40+8.928409070976001d-4*gammaaa*t118*t214*t
     9           38)
              t402 = -6.09932d-3*t188*t19*t39*t72
              t403 = -6.09932d-3*t18*t217*t39*t72
              t404 = 7.44034089248d-5*t72*t73*t86*t88
              t405 = 1.86008522312d-5*t25*t72*t73*t92
              t406 = -3.4035765009240837d-7*t118*t46*t72*t87
              t407 = (t406+t405+t404+t403+t402+t401)*wght
              t408 = 1/rhoa**1.0333333333333333d+1
              t409 = 1/rhoa**7.666666666666667d+0
              t410 = 1/rhoa**5
              t411 = 1.0d+0*t37*t72*(4.4642045354879994d-4*t410*t45*t73-
     1           2.9276736000000003d-1*t410*t42*t73-1.3614306003696336d-
     2           6*t118*t41*t410*t45-2.722861200739267d-6*gammaaa*t118*t
     3           409*t44-5.445722401478534d-6*t242*t410*t42*t43+2.678522
     4           721292801d-3*t118*t41*t410*t42-1.0891444802957069d-5*ga
     5           mmaaa*t242*t40*t409*t41+2.678522721292801d-3*gammaaa*t1
     6           18*t40*t409-2.1782889605914138d-5*t24*t242*t38*t408)
              t412 = -1.8297960000000002d-2*t19*t226*t39*t72
              t413 = 2.2321022677439997d-4*t216*t72*t73*t92
              t414 = -1.3614306003696336d-6*t118*t410*t46*t72
              fnc(iq) = (1.0d+0*t37*t46*(t34-1.243628d-1*rhoa*(1.0522000
     1           558389212d-1*t4+1.0d+0)*log(1.6081979498692536d+1/(5.32
     2           9846514438383d+0*t5+1.766435620181429d+0*t4+5.659885156
     3           639418d-1*t3+1.19503784087549d-1*t1)+1.0d+0))+2.0d+0*rh
     4           oa*t14*t17*t22*t33)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t37*t83-3.04966d-3*t39*t46*t48*t72+t22*t
     1           62-5.15088d-3*rhoa*t14*t17*t26*t33*t48+1.25d-1*gammaaa*
     2           t14*t15*t16*t22*t33)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = (1.0d+0*t37*t72*t86+1.0d+0*rhoa*t14*t17*
     1           t22*t85-3.04966d-3*t18*t39*t46*t72-5.15088d-3*t14*t17*t
     2           19*t26*t33-1.25d-1*t14*t16*t22*t33)*wght+Cmat(iq,D1_GAA
     3           )
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = (1.0d+0*t37*t72*t92+1.25d-1*gammaaa*t14*t
     1           22*t33*t91+1.0d+0*rhoa*t14*t17*t22*t89-6.09932d-3*t19*t
     2           39*t46*t72-1.030176d-2*t1*t14*t17*t26*t33)*wght+Mmat(iq
     3           ,D1_TA)
              Amat2(iq,D2_RA_RA) = (t15*t16*t22*t95-1.25d-1*gammaaa*t14*
     1           t16*t22*t33*t94+5.30631295488d-5*rhoa*t14*t17*t33*t49*t
     2           93-1.28772d-3*gammaaa*t14*t15*t16*t26*t33*t48+t155*t39+
     3           t151*t37+t116*t26+t115*t22+t117)*wght+Amat2(iq,D2_RA_RA
     4           )
              Amat2(iq,D2_RA_RB) = (t160*t39+t159*t37+t117)*wght+Amat2(i
     1           q,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = (-5.15088d-3*rhoa*t14*t17*t26*t48*t8
     1           5+8.132426666666667d-3*t39*t46*t47*t72+5.30631295488d-5
     2           *t14*t17*t19*t33*t48*t49+6.4386d-4*t14*t16*t26*t33*t48-
     3           6.4386d-4*gammaaa*t14*t16*t26*t33*t47+t182*t37+t165*t18
     4           *t26+t164*t22+t15*t16*t161*t22+t183+t167+t166)*wght+Cma
     5           t2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t185*t37+t183+t167+t166)*wght+Cmat2
     1           (iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = (5.30631295488d-5*t14*t17*t33*t49*t
     1           88-1.030176d-2*t14*t17*t19*t26*t85-2.5d-1*t14*t16*t22*t
     2           85+1.28772d-3*t14*t16*t18*t26*t33+1.0d+0*rhoa*t14*t17*t
     3           187*t22+t191+t190+t189)*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = (t191+t190+t189)*wght+Cmat2(iq,D2_G
     1           AA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = (-6.4386d-4*gammaaa*t14*t26*t33*t48*t
     1           91-1.25d-1*gammaaa*t14*t15*t22*t33*t91-5.15088d-3*rhoa*
     2           t14*t17*t26*t48*t89+1.25d-1*gammaaa*t14*t15*t16*t22*t89
     3           +1.0165533333333335d-2*t18*t39*t46*t72+t19*t26*(1.71696
     4           00000000002d-2*t14*t17*t33-1.030176d-2*t62)+1.061262590
     5           976d-4*t1*t14*t17*t33*t48*t49+t210*t37-1.28772d-3*gamma
     6           aa*t14*t16*t18*t26*t33+t193*t22+t211+t195+t194)*wght+Mm
     7           at2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t213*t37+t211+t195+t194)*wght+Mmat2(
     1           iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = (-6.4386d-4*gammaaa*t14*t18*t26*t33*
     1           t91+t161*t22*t91-5.15088d-3*t14*t17*t19*t26*t89-1.25d-1
     2           *t14*t16*t22*t89-1.030176d-2*t1*t14*t17*t26*t85+1.06126
     3           2590976d-4*t14*t17*t216*t33*t49+1.28772d-3*t14*t16*t19*
     4           t26*t33+t221+t220+1.0d+0*rhoa*t14*t17*t215*t22+t219+t21
     5           8)*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = (t221+t220+t219+t218)*wght+Mmat2(iq,
     1           D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = (2.5d-1*gammaaa*t14*t22*t89*t91-2.575
     1           44d-3*gammaaa*t14*t19*t26*t33*t91-2.060352d-2*t1*t14*t1
     2           7*t26*t89+2.122525181952d-4*t106*t14*t17*t33*t49-2.5d-1
     3           *gammaaa*t14*t22*t225*t33+t229+t228+t227+1.0d+0*rhoa*t1
     4           4*t17*t22*t224)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = (t229+t228+t227)*wght+Mmat2(iq,D2_TA_
     1           TB)
              Amat3(iq,D3_RA_RA_RA) = (t37*(1.0d+0*t72*(-2.3407407407407
     1           41d+2*gammaaa*t39*t40*t99*taua+1.2198640000000001d-1*t1
     2           8*t41*t42*t73*t98*taua+1.2198640000000001d-1*gammaaa*t2
     3           5*t40*t73*t98*taua+3.04966d-2*t18*t39*t45*t98*taua-3.25
     4           92592592592595d+1*t37*t45*t97*taua-6.518518518518519d+1
     5           *t39*t41*t42*t97*taua-6.505941333333334d-1*gammaaa*t40*
     6           t48*t50*t73*taua-3.252970666666667d-1*t41*t42*t47*t48*t
     7           73*taua-8.132426666666668d-2*t39*t45*t47*t48*taua-9.758
     8           912d-1*t24*t38*t48*t73*t99+1.9517824d-1*t24*t38*t50*t73
     9           *t98+5.580255669359999d-5*t41*t45*t48*t73*t98+1.1160511
     :           338719999d-4*gammaaa*t18*t44*t48*t73*t98+4.879456d-2*ga
     ;           mmaaa*t40*t41*t47*t73*t98+1.6740767008080004d-4*t118*t4
     <           2*t43*t48*t98+3.348153401616001d-4*gammaaa*t118*t18*t40
     =           *t41*t48*t98+6.696306803232002d-4*t118*t24*t25*t38*t48*
     >           t98+2.439728d-2*gammaaa*t39*t44*t47*t98-1.7891338666666
     ?           665d-1*gammaaa*t40*t41*t48*t73*t97-8.945669333333333d-2
     @           *gammaaa*t39*t44*t48*t97-1.777777777777778d+2*t39*t42*t
     1           50*t90-6.09932d-3*t234*t42*t43*t73-1.219864d-2*gammaaa*
     2           t18*t234*t40*t41*t73-2.439728d-2*t234*t24*t25*t38*t73-3
     3           .04966d-3*t234*t39*t41*t45-6.09932d-3*gammaaa*t18*t234*
     4           t39*t44-4.5629629629629626d+1*gammaaa*t233*t37*t44-4.56
     5           29629629629626d+1*gammaaa*t233*t39*t40*t41-3.3896296296
     6           296297d+2*t235*t24*t38*t39+t254+t253+t252+t251+t250+t24
     7           9+t248+t247+t246+t245+t244+t243)+1.0d+0*t46*(2*rhoa*(-7
     8           .5d-1*t148*t270*t271*t272*t94-5.82714947393947d-4*t147*
     9           t216*t78+t275+t274+t273+t269+t268+t267+t265+t264+t263+t
     :           262+t261-2.533029591058444d-2*t147*t148*t231)+2.5330295
     ;           910584444d-2*t147*t148*t94-3.0d+0*t113*t58*t60*t9+6.0d+
     <           0*t110*t112*t58*t9-9.649187699215522d+1*t109*t110*t111*
     =           t9+5.284159572535705d-3*t106*t8+2.549392377400174d-1*t5
     >           4*t58*t59*t60+2.943620900479655d-17*t52*t54*t56*t57-3.3
     ?           306690738754696d-16*t108*t13*t52*t57+6.661338147750939d
     @           -16*t102*t104*t13*t52+t259+t258+t257+t256+t255-rhoa*t24
     1           0-5.356375176299456d-15*t101*t102*t103*t13+1.2202564577
     2           405706d-18*t106*t12)+3.0d+0*t131*t82+3.0d+0*t150*t74)+t
     3           22*(1.0d+0*rhoa*t14*t17*(-2.0148148148148146d+2*gammaaa
     4           *t26*t27*t99*taua+2.060352d-1*t18*t28*t29*t49*t98*taua+
     5           1.030176d-1*gammaaa*t25*t27*t49*t98*taua+5.15088d-2*t18
     6           *t26*t32*t98*taua-3.2592592592592595d+1*t22*t32*t97*tau
     7           a-6.518518518518519d+1*t26*t28*t29*t97*taua-3.183787772
     8           928d-3*t18*t28*t29*t93*t96*taua-1.591893886464d-3*gamma
     9           aa*t25*t27*t93*t96*taua-5.30631295488d-4*t18*t32*t49*t9
     :           3*taua-8.241408d-1*gammaaa*t27*t48*t49*t50*taua-5.49427
     ;           2d-1*t28*t29*t47*t48*t49*taua-1.373568d-1*t26*t32*t47*t
     <           48*taua-1.0439116799999999d+0*t23*t24*t48*t49*t99+4.775
     =           6816593920004d-4*t29*t30*t48*t96*t98+4.7756816593920004
     >           d-4*gammaaa*t18*t27*t28*t48*t96*t98+4.7756816593920004d
     ?           -4*t23*t24*t25*t48*t96*t98+1.6482816d-1*t23*t24*t49*t50
     @           *t98+1.591893886464d-4*t28*t32*t48*t49*t98+1.5918938864
     1           64d-4*gammaaa*t18*t31*t48*t49*t98+8.241408d-2*gammaaa*t
     2           27*t28*t47*t49*t98+4.120704d-2*gammaaa*t26*t31*t47*t98-
     3           3.0218496d-1*gammaaa*t27*t28*t48*t49*t97-1.5109248d-1*g
     4           ammaaa*t26*t31*t48*t97-2.5470302183424004d-3*t23*t24*t5
     5           0*t93*t96-1.2735151091712002d-3*gammaaa*t27*t28*t47*t93
     6           *t96-8.199654381909689d-7*t230*t28*t32*t96-8.1996543819
     7           09689d-7*gammaaa*t18*t230*t31*t96-4.245050363904d-4*gam
     8           maaa*t31*t47*t49*t93-1.777777777777778d+2*t26*t29*t50*t
     9           90-6.867840000000001d-1*t25*t29*t48*t49*t90-1.030176d-2
     :           *t234*t29*t30*t49-1.030176d-2*gammaaa*t18*t234*t27*t28*
     ;           t49-1.030176d-2*t23*t234*t24*t25*t49-5.15088d-3*t234*t2
     <           6*t28*t32-5.15088d-3*gammaaa*t18*t234*t26*t31-4.5629629
     =           629629626d+1*gammaaa*t22*t233*t31-3.2798617527638757d-6
     >           *t230*t232*t29*t30-4.5629629629629626d+1*gammaaa*t233*t
     ?           26*t27*t28-3.2798617527638757d-6*gammaaa*t18*t230*t232*
     @           t27*t28-2.477037037037037d+2*t23*t235*t24*t26-3.2798617
     1           527638757d-6*t23*t230*t232*t24*t25)+2.5d-1*gammaaa*t16*
     2           t33*t61*t94+2.5d-1*gammaaa*t14*t16*t51*t94+6.0d+0*t17*t
     3           51*t61+5.0d-1*gammaaa*t15*t16*t51*t61+3.0d+0*rhoa*t100*
     4           t17*t61+3.0d+0*rhoa*t114*t17*t51+1.0d+0*rhoa*t17*t240*t
     5           33-2.5d-1*gammaaa*t14*t16*t231*t33+3.0d+0*t114*t17*t33+
     6           2.5d-1*gammaaa*t114*t15*t16*t33+3.0d+0*t100*t14*t17+2.5
     7           d-1*gammaaa*t100*t14*t15*t16)+t39*(-3.04966d-3*t83*t98-
     8           6.09932d-3*t46*t82*t98-6.09932d-3*t72*t74*t98-3.04966d-
     9           3*t131*t48*t72-3.04966d-3*t234*t46*t72-3.04966d-3*t150*
     :           t46*t48-6.09932d-3*t151*t48+t276)+t73*(3.72017044624d-5
     ;           *t46*t48*t72*t98+t279+t278+t277)+t26*(-5.15088d-3*t62*t
     <           98-1.030176d-2*rhoa*t17*t33*t61*t98-1.030176d-2*rhoa*t1
     =           4*t17*t51*t98-1.030176d-2*t14*t17*t33*t98-6.4386d-4*gam
     >           maaa*t14*t15*t16*t33*t98-6.4386d-4*gammaaa*t14*t16*t33*
     ?           t48*t94-1.030176d-2*rhoa*t17*t48*t51*t61-1.030176d-2*t1
     @           7*t33*t48*t61-6.4386d-4*gammaaa*t15*t16*t33*t48*t61-1.0
     1           30176d-2*t14*t17*t48*t51-6.4386d-4*gammaaa*t14*t15*t16*
     2           t48*t51-5.15088d-3*rhoa*t114*t17*t33*t48-5.15088d-3*rho
     3           a*t100*t14*t17*t48-1.030176d-2*t115*t48-5.15088d-3*rhoa
     4           *t14*t17*t234*t33)+t49*(1.061262590976d-4*rhoa*t14*t17*
     5           t33*t48*t98+5.30631295488d-5*rhoa*t17*t33*t61*t93+5.306
     6           31295488d-5*rhoa*t14*t17*t51*t93+5.30631295488d-5*t14*t
     7           17*t33*t93-1.030176d-2*t116*t48)+t15*t16*t26*(-1.28772d
     8           -3*gammaaa*t14*t33*t98-5.15088d-3*t48*t95-1.28772d-3*ga
     9           mmaaa*t33*t48*t61-1.28772d-3*gammaaa*t14*t48*t51)-8.199
     :           654381909689d-7*rhoa*t14*t17*t230*t33*t96+t16*t22*(-2.5
     ;           d-1*gammaaa*t33*t61-2.5d-1*gammaaa*t14*t51)*t94+1.93158
     <           d-3*gammaaa*t14*t16*t26*t33*t48*t94+1.9898673580800003d
     =           -5*gammaaa*t14*t15*t16*t33*t49*t93+t15*t16*t22*(2.5d-1*
     >           gammaaa*t51*t61+1.25d-1*gammaaa*t114*t33+1.25d-1*gammaa
     ?           a*t100*t14)+2.5d-1*gammaaa*t14*t16*t22*t231*t33+t241)*w
     @           ght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (t37*(1.0d+0*t72*(-5.6296296296296
     1           3d+1*gammaaa*t39*t40*t99*taua+4.066213333333334d-2*t18*
     2           t41*t42*t73*t98*taua+4.066213333333334d-2*gammaaa*t25*t
     3           40*t73*t98*taua+1.0165533333333335d-2*t18*t39*t45*t98*t
     4           aua-4.3372942222222227d-1*gammaaa*t40*t48*t50*t73*taua-
     5           1.0843235555555557d-1*t41*t42*t47*t48*t73*taua-2.710808
     6           888888889d-2*t39*t45*t47*t48*taua-4.9878883555555553d-1
     7           *t24*t38*t48*t73*t99+6.505941333333333d-2*t24*t38*t50*t
     8           73*t98+1.86008522312d-5*t41*t45*t48*t73*t98+3.720170446
     9           24d-5*gammaaa*t18*t44*t48*t73*t98+1.6264853333333332d-2
     :           *gammaaa*t40*t41*t47*t73*t98+5.580255669360001d-5*t118*
     ;           t42*t43*t48*t98+1.1160511338720001d-4*gammaaa*t118*t18*
     <           t40*t41*t48*t98+2.2321022677440003d-4*t118*t24*t25*t38*
     =           t48*t98+8.132426666666667d-3*gammaaa*t39*t44*t47*t98-5.
     >           963779555555556d-2*gammaaa*t40*t41*t48*t73*t97-2.981889
     ?           777777778d-2*gammaaa*t39*t44*t48*t97-5.925925925925927d
     @           +1*t39*t42*t50*t90-5.214814814814814d+1*t235*t24*t38*t3
     1           9+t254+t253+t252+t251+t250+t249+t248+t247+t246+t245+t24
     2           4+t243)+1.0d+0*t46*(2*rhoa*(2.5d-1*t148*t270*t271*t272*
     3           t94+1.9423831579798237d-4*t147*t216*t78+t275+t274+t273+
     4           t269+t268+t267+t265+t264+t263+t262+t261+8.4434319701948
     5           15d-3*t147*t148*t231)+t259+t258+t257+t256+t255+t157)+2.
     6           0d+0*t156*t82+1.0d+0*t131*t82+2.0d+0*t158*t74+1.0d+0*t1
     7           50*t74)+t39*(-3.04966d-3*t46*t82*t98-3.04966d-3*t72*t74
     8           *t98-3.04966d-3*t156*t48*t72-3.04966d-3*t158*t46*t48-3.
     9           04966d-3*t159*t48-3.04966d-3*t151*t48+t276)+(t279+t278+
     :           t277)*t73+t241)*wght+Amat3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t22*(1.0d+0*rhoa*t14*t17*(-1.061
     1           262590976d-3*gammaaa*t27*t48*t84*t96*taua-2.12252518195
     2           2d-3*t25*t28*t29*t48*t96*taua-5.494272d-1*t28*t29*t49*t
     3           50*taua-1.373568d-1*t26*t32*t50*taua+2.6666666666666666
     4           d+1*t26*t27*t50*taua-3.53754196992d-4*t25*t32*t48*t49*t
     5           aua+6.867840000000001d-2*t25*t27*t48*t49*taua-4.57856d-
     6           1*gammaaa*t162*t27*t49*taua-3.4797056000000004d-1*gamma
     7           aa*t27*t28*t49*t99-1.7398528000000002d-1*gammaaa*t26*t3
     8           1*t99+6.755555555555556d+1*gammaaa*t23*t26*t99+1.591893
     9           886464d-4*t23*t24*t84*t96*t98+1.591893886464d-4*t18*t29
     :           *t30*t96*t98+1.591893886464d-4*gammaaa*t25*t27*t28*t96*
     ;           t98+5.30631295488d-5*t18*t28*t32*t49*t98+5.30631295488d
     <           -5*gammaaa*t25*t31*t49*t98-1.030176d-2*t18*t27*t28*t49*
     =           t98-2.060352d-2*gammaaa*t23*t25*t49*t98-5.15088d-3*t18*
     >           t26*t31*t98-1.0072832000000001d-1*t29*t30*t49*t97-5.036
     ?           416d-2*t26*t28*t32*t97+9.777777777777779d+0*t22*t31*t97
     @           +9.777777777777779d+0*t26*t27*t28*t97-8.199654381909689
     1           d-7*t18*t28*t32*t93*t96-8.199654381909689d-7*gammaaa*t2
     2           5*t31*t93*t96+1.591893886464d-4*t18*t27*t28*t93*t96+3.1
     3           83787772928d-4*gammaaa*t23*t25*t93*t96-1.6980201455616d
     4           -3*gammaaa*t27*t28*t48*t50*t96-8.490100727808d-4*t29*t3
     5           0*t47*t48*t96-2.5470302183424004d-3*t162*t23*t24*t48*t9
     6           6-3.2798617527638757d-6*t23*t232*t24*t84*t93+5.30631295
     7           488d-5*t18*t31*t49*t93-3.2798617527638757d-6*t18*t232*t
     8           29*t30*t93-3.2798617527638757d-6*gammaaa*t232*t25*t27*t
     9           28*t93-2.2892800000000002d-1*t29*t49*t84*t90-5.66006715
     :           1872d-4*gammaaa*t31*t48*t49*t50+2.1977088d-1*gammaaa*t2
     ;           3*t48*t49*t50-2.830033575936d-4*t28*t32*t47*t48*t49+5.4
     <           94272d-2*t27*t28*t47*t48*t49-7.4172672d-1*t23*t24*t281*
     =           t49+2.747136d-2*t26*t31*t47*t48)+1.25d-1*gammaaa*t14*t1
     >           6*t85*t94+1.25d-1*t14*t16*t33*t94+2.0d+0*t17*t61*t85+1.
     ?           25d-1*gammaaa*t15*t16*t61*t85+1.0d+0*rhoa*t114*t17*t85-
     @           2.5d-1*t16*t51*t61-1.25d-1*t15*t16*t33*t61+2.0d+0*rhoa*
     1           t163*t17*t61-1.25d-1*t14*t15*t16*t51-1.25d-1*t114*t16*t
     2           33+2.0d+0*t14*t163*t17+1.25d-1*gammaaa*t14*t15*t16*t163
     3           -1.25d-1*t100*t14*t16)+t37*(1.0d+0*t72*(-3.252970666666
     4           667d-1*t41*t42*t50*t73*taua-4.3372942222222227d-1*gamma
     5           aa*t162*t40*t73*taua-8.132426666666668d-2*t39*t45*t50*t
     6           aua+2.6666666666666666d+1*t39*t40*t50*taua-2.6565927111
     7           11111d-1*gammaaa*t40*t41*t73*t99-1.3282963555555555d-1*
     8           gammaaa*t39*t44*t99+8.711111111111112d+1*gammaaa*t38*t3
     9           9*t99-5.963779555555556d-2*t42*t43*t73*t97-2.9818897777
     :           77778d-2*t39*t41*t45*t97+9.777777777777779d+0*t37*t44*t
     ;           97+9.777777777777779d+0*t39*t40*t41*t97-2.9761363569919
     <           996d-4*gammaaa*t44*t48*t50*t73+1.9517824d-1*gammaaa*t38
     =           *t48*t50*t73-9.920454523306665d-5*t41*t45*t47*t48*t73+3
     >           .2529706666666663d-2*t40*t41*t47*t48*t73-9.108317866666
     ?           666d-1*t24*t281*t38*t73-8.928409070976001d-4*gammaaa*t1
     @           18*t40*t41*t48*t50+1.6264853333333332d-2*t39*t44*t47*t4
     1           8-2.976136356992001d-4*t118*t42*t43*t47*t48-2.380909085
     2           5936005d-3*t118*t162*t24*t38*t48+t304+t303+t302+t301+t3
     3           00+t299+t298+t297+t296+t295+t294+t293+t292+t291+t290+t2
     4           89+t288+t287+t286+t285+t284)+2.0d+0*t180*t82+t305)+t26*
     5           (-5.15088d-3*rhoa*t14*t17*t85*t98+6.4386d-4*t14*t16*t33
     6           *t98-5.15088d-3*rhoa*t17*t48*t61*t85-5.15088d-3*t14*t17
     7           *t48*t85+1.373568d-2*t47*t62+6.4386d-4*t16*t33*t48*t61+
     8           1.373568d-2*t17*t18*t33*t61+6.4386d-4*t14*t16*t48*t51+1
     9           .373568d-2*t14*t17*t18*t51+6.4386d-4*t14*t15*t16*t33*t4
     :           8-5.15088d-3*rhoa*t14*t163*t17*t48-5.15088d-3*t164*t48-
     ;           3.662848000000001d-2*t14*t17*t33*t47)+t39*(-2.981889777
     <           777778d-2*t46*t72*t97+8.132426666666667d-3*t47*t83-3.04
     =           966d-3*t180*t48*t72+t311+t310+t309+t308+t307)+4.07778d-
     >           3*gammaaa*t14*t16*t26*t33*t97-8.199654381909689d-7*t14*
     ?           t17*t19*t33*t93*t96-5.15088d-3*t16*t26*t47*t95+t16*t22*
     @           t280*t94+5.30631295488d-5*rhoa*t14*t17*t49*t85*t93-6.63
     1           28911936d-6*t14*t16*t33*t49*t93+t15*t16*t22*(1.25d-1*ga
     2           mmaaa*t61*t85+1.25d-1*t33*t61+1.25d-1*t14*t51+1.25d-1*g
     3           ammaaa*t14*t163)+t15*t16*t26*(-1.28772d-3*gammaaa*t14*t
     4           48*t85-1.28772d-3*t14*t33*t48)-9.920454523306665d-5*t46
     5           *t47*t48*t72*t73+t18*(-2.830033575936d-4*t14*t17*t33*t4
     6           8-1.030176d-2*t116)*t49+1.32657823872d-5*gammaaa*t14*t1
     7           6*t33*t47*t48*t49+t312+t306+t283+t282-5.15088d-3*t115*t
     8           18*t26)*wght+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (t37*(1.0d+0*t72*(-1.084323555555
     1           5557d-1*t41*t42*t50*t73*taua-2.1686471111111114d-1*gamm
     2           aaa*t162*t40*t73*taua-2.710808888888889d-2*t39*t45*t50*
     3           taua-5.963779555555556d-2*gammaaa*t40*t41*t73*t99-2.981
     4           889777777778d-2*gammaaa*t39*t44*t99+1.9555555555555557d
     5           +1*gammaaa*t38*t39*t99-9.920454523306665d-5*gammaaa*t44
     6           *t48*t50*t73+6.505941333333333d-2*gammaaa*t38*t48*t50*t
     7           73-3.252970666666667d-1*t24*t281*t38*t73-2.976136356992
     8           d-4*gammaaa*t118*t40*t41*t48*t50-1.1904545427968d-3*t11
     9           8*t162*t24*t38*t48+t313+t304+t303+t302+t301+t300+t299+t
     :           298+t297+t296+t295+t294+t293+t292+t291+t290+t289+t288+t
     ;           287+t286+t285+t284)+2.0d+0*t184*t82+t305)+t39*(-3.04966
     <           d-3*t185*t48+t314+t308+t307)+t312+t306+t283+t282)*wght+
     =           Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (t37*(1.0d+0*t72*(-1.084323555555
     1           5555d-1*t41*t42*t50*t73*taua-2.168647111111111d-1*gamma
     2           aa*t162*t40*t73*taua-2.7108088888888887d-2*t39*t45*t50*
     3           taua-4.3372942222222216d-2*gammaaa*t40*t41*t73*t99-2.16
     4           86471111111108d-2*gammaaa*t39*t44*t99+1.422222222222222
     5           2d+1*gammaaa*t38*t39*t99-1.984090904661333d-4*gammaaa*t
     6           44*t48*t50*t73+1.3011882666666666d-1*gammaaa*t38*t48*t5
     7           0*t73-4.9602272616533327d-5*t41*t45*t47*t48*t73+1.62648
     8           53333333332d-2*t40*t41*t47*t48*t73-2.602376533333333d-1
     9           *t24*t281*t38*t73-5.952272713984001d-4*gammaaa*t118*t40
     :           *t41*t48*t50+8.132426666666667d-3*t39*t44*t47*t48-1.488
     ;           0681784960004d-4*t118*t42*t43*t47*t48-1.785681814195200
     <           2d-3*t118*t162*t24*t38*t48+t313+t303+t302+t299+t298+t29
     =           4+t293+t292+t291+t290+t288+t286+t285+t284)+1.0d+0*t158*
     >           t86+1.0d+0*t184*t82+1.0d+0*t180*t82)-4.9602272616533327
     ?           d-5*t46*t47*t48*t72*t73-6.09932d-3*t160*t18*t73+(t314+t
     @           311+t310+t309+t308)*t39-3.04966d-3*t159*t18*t39+t283+t2
     1           82)*wght+Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t22*(1.0d+0*rhoa*t14*t17*(-1.06
     1           1262590976d-3*t28*t29*t84*t96*taua-5.30631295488d-4*gam
     2           maaa*t186*t27*t96*taua-1.76877098496d-4*t32*t49*t84*tau
     3           a+6.867840000000001d-2*t27*t49*t84*taua-8.1996543819096
     4           89d-7*gammaaa*t31*t48*t84*t96+6.367575545856d-4*gammaaa
     5           *t23*t48*t84*t96-8.490100727808d-4*t29*t30*t50*t96-8.19
     6           9654381909689d-7*t25*t28*t32*t48*t96+3.183787772928d-4*
     7           t25*t27*t28*t48*t96-1.6980201455616d-3*t23*t24*t316*t96
     8           -1.2735151091712002d-3*gammaaa*t162*t27*t28*t96-3.27986
     9           17527638757d-6*gammaaa*t232*t27*t28*t48*t84-2.830033575
     :           936d-4*t28*t32*t49*t50+1.0988544d-1*t27*t28*t49*t50+5.4
     ;           94272d-2*t26*t31*t50-1.0666666666666666d+1*t23*t26*t50+
     <           1.061262590976d-4*t25*t31*t48*t49-2.060352d-2*t23*t25*t
     =           48*t49-4.245050363904d-4*gammaaa*t162*t31*t49+3.2965632
     >           d-1*gammaaa*t162*t23*t49-3.2798617527638757d-6*t232*t25
     ?           *t29*t30*t48-3.2798617527638757d-6*t186*t23*t232*t24*t4
     @           8)-2.5d-1*t16*t61*t85-2.5d-1*t14*t15*t16*t85+1.0d+0*rho
     1           a*t17*t187*t61+1.0d+0*t14*t17*t187-2.5d-1*t14*t16*t163)
     2           -8.199654381909689d-7*t14*t17*t33*t48*t88*t96+1.6264853
     3           333333332d-2*t39*t47*t72*t86+t18*t26*(2.747136d-2*t14*t
     4           17*t85-1.7169600000000002d-3*t14*t15*t16*t33+t317)+t16*
     5           t26*t47*(-6.4386d-4*gammaaa*t14*t85-2.3608200000000001d
     6           -3*t14*t33-5.15088d-3*t161)+1.061262590976d-4*t14*t17*t
     7           19*t48*t49*t85+1.28772d-3*t14*t16*t26*t48*t85+t37*(1.0d
     8           +0*t72*(-9.920454523306665d-5*t41*t45*t50*t73+6.5059413
     9           33333333d-2*t40*t41*t50*t73-2.4801136308266666d-4*gamma
     :           aa*t162*t44*t73+3.2529706666666663d-1*gammaaa*t162*t38*
     ;           t73+3.2529706666666663d-2*t39*t44*t50-2.976136356992001
     <           d-4*t118*t42*t43*t50-1.0666666666666666d+1*t38*t39*t50-
     =           7.440340892480001d-4*gammaaa*t118*t162*t40*t41-1.785681
     >           8141952002d-3*t118*t24*t316*t38+t331+t330+t329+t328+t32
     ?           7+t326+t325+t324+t323+t322+t321+t320+t319)+t332)-9.9204
     @           54523306665d-5*t46*t50*t72*t73+6.6328911936d-6*gammaaa*
     1           t14*t16*t33*t49*t50-1.32657823872d-5*t14*t16*t18*t33*t4
     2           8*t49+t25*(-1.415016787968d-4*t14*t17*t33-1.030176d-2*t
     3           165)*t49-5.15088d-3*rhoa*t14*t17*t187*t26*t48-6.09932d-
     4           3*t18*t182*t39+t335+t334+t333+t318+t15*t16*t22*t315)*wg
     5           ht+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = (8.132426666666667d-3*t39*t47*t7
     1           2*t86+t37*(1.0d+0*t72*(-4.9602272616533327d-5*t41*t45*t
     2           50*t73+3.2529706666666663d-2*t40*t41*t50*t73-1.48806817
     3           84959998d-4*gammaaa*t162*t44*t73+1.9517824d-1*gammaaa*t
     4           162*t38*t73+1.6264853333333332d-2*t39*t44*t50-1.4880681
     5           78496d-4*t118*t42*t43*t50-5.333333333333333d+0*t38*t39*
     6           t50-4.4642045354879994d-4*gammaaa*t118*t162*t40*t41-1.1
     7           904545427968d-3*t118*t24*t316*t38+t331+t330+t329+t328+t
     8           327+t326+t325+t324+t323+t322+t321+t320+t319)+t332)-4.96
     9           02272616533327d-5*t46*t50*t72*t73-3.04966d-3*t18*t185*t
     :           39-3.04966d-3*t18*t182*t39+t335+t334+t333+t318)*wght+Cm
     ;           at3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (t37*(1.0d+0*t72*(-4.96022726165
     1           33327d-5*gammaaa*t162*t44*t73+6.505941333333333d-2*gamm
     2           aaa*t162*t38*t73-1.488068178496d-4*gammaaa*t118*t162*t4
     3           0*t41-5.952272713984d-4*t118*t24*t316*t38+t331+t330+t32
     4           9+t328+t327+t326+t325+t324+t323+t322+t321+t320+t319)+t3
     5           32)-6.09932d-3*t18*t185*t39+t335+t334+t333+t318)*wght+C
     6           mat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (1.0d+0*rhoa*t14*t17*t22*(-8.19
     1           9654381909689d-7*t28*t32*t84*t96+4.7756816593920004d-4*
     2           t27*t28*t84*t96-8.199654381909689d-7*gammaaa*t186*t31*t
     3           96+9.551363318784001d-4*gammaaa*t186*t23*t96+1.59189388
     4           6464d-4*t31*t49*t84-6.181056d-2*t23*t49*t84-3.279861752
     5           7638757d-6*t232*t29*t30*t84-3.2798617527638757d-6*t23*t
     6           232*t24*t336-3.2798617527638757d-6*gammaaa*t186*t232*t2
     7           7*t28)-8.199654381909689d-7*t14*t17*t33*t87*t96+1.59189
     8           3886464d-4*t14*t17*t49*t85*t88+3.86316d-3*t14*t16*t18*t
     9           26*t85-1.9898673580800003d-5*t14*t16*t25*t33*t49+t340+t
     :           339+t338+t337-1.545264d-2*t14*t17*t187*t19*t26-3.75d-1*
     ;           t14*t16*t187*t22)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = (t340+t339+t338+t337)*wght+Cmat
     1           3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = (t22*(1.0d+0*rhoa*t14*t17*(-4.2450
     1           50363904d-3*t28*t29*t48*t88*t96*taua-2.122525181952d-3*
     2           gammaaa*t27*t48*t87*t96*taua-7.07508393984d-4*t32*t48*t
     3           49*t88*taua+2.747136d-1*t29*t48*t49*t88*taua-7.783552d-
     4           1*gammaaa*t27*t49*t84*taua-8.241408000000001d-1*t25*t28
     5           *t29*t49*taua-2.0603520000000003d-1*t25*t26*t32*taua+8.
     6           0d+1*t25*t26*t29*taua+3.183787772928d-4*gammaaa*t27*t28
     7           *t88*t96*t98+3.183787772928d-4*t23*t24*t87*t96*t98+3.18
     8           3787772928d-4*t19*t29*t30*t96*t98+1.061262590976d-4*gam
     9           maaa*t31*t49*t88*t98-2.060352d-2*gammaaa*t27*t49*t88*t9
     :           8+1.061262590976d-4*t19*t28*t32*t49*t98-4.120704d-2*t19
     ;           *t28*t29*t49*t98-1.030176d-2*t19*t26*t32*t98-1.63993087
     <           63819376d-6*gammaaa*t31*t88*t93*t96+3.183787772928d-4*g
     =           ammaaa*t27*t88*t93*t96-1.6399308763819376d-6*t19*t28*t3
     >           2*t93*t96+6.367575545856d-4*t19*t28*t29*t93*t96-4.45730
     ?           28820992006d-3*t23*t24*t48*t84*t96-1.0612625909760003d-
     @           3*t18*t29*t30*t48*t96-2.7592827365376d-3*gammaaa*t25*t2
     1           7*t28*t48*t96-6.559723505527751d-6*gammaaa*t232*t27*t28
     2           *t88*t93-6.559723505527751d-6*t23*t232*t24*t87*t93+1.06
     3           1262590976d-4*t19*t32*t49*t93-6.559723505527751d-6*t19*
     4           t232*t29*t30*t93-4.5785600000000004d-1*t29*t49*t87*t90-
     5           4.7617024d-1*gammaaa*t27*t28*t49*t50-2.3808512d-1*gamma
     6           aa*t26*t31*t50+4.622222222222223d+1*gammaaa*t26*t27*t50
     7           -3.5375419699200006d-4*t18*t28*t32*t48*t49-9.1976091217
     8           92001d-4*gammaaa*t25*t31*t48*t49+1.373568d-1*t18*t28*t2
     9           9*t48*t49+1.7856384d-1*gammaaa*t25*t27*t48*t49-9.157120
     :           000000001d-2*t29*t30*t47*t49-1.1537971200000001d+0*t162
     ;           *t23*t24*t49+3.4339200000000003d-2*t18*t26*t32*t48-4.57
     <           85600000000004d-2*t26*t28*t32*t47+8.88888888888889d+0*t
     =           22*t32*t47+1.7777777777777778d+1*t26*t28*t29*t47)-1.25d
     >           -1*gammaaa*t14*t33*t91*t94+1.25d-1*gammaaa*t14*t16*t89*
     ?           t94+2.5d-1*gammaaa*t51*t61*t91+1.25d-1*gammaaa*t15*t33*
     @           t61*t91+1.25d-1*gammaaa*t14*t15*t51*t91+1.25d-1*gammaaa
     1           *t114*t33*t91+1.25d-1*gammaaa*t100*t14*t91+2.0d+0*t17*t
     2           61*t89+1.25d-1*gammaaa*t15*t16*t61*t89+1.0d+0*rhoa*t114
     3           *t17*t89+2.0d+0*rhoa*t17*t192*t61+2.0d+0*t14*t17*t192+1
     4           .25d-1*gammaaa*t14*t15*t16*t192)+t37*(1.0d+0*t72*(-7.04
     5           8103111111113d-1*gammaaa*t40*t73*t84*taua-4.87945600000
     6           0001d-1*t25*t41*t42*t73*taua-1.2198640000000002d-1*t25*
     7           t39*t45*taua+8.0d+1*t25*t39*t42*taua-3.8689772640896003
     8           d-3*t118*t24*t38*t48*t84-3.3614030222222224d-1*gammaaa*
     9           t40*t41*t50*t73-1.2400568154133333d-4*t18*t41*t45*t48*t
     :           73-4.4642045354879994d-4*gammaaa*t25*t44*t48*t73+8.1324
     ;           26666666668d-2*t18*t41*t42*t48*t73+1.4638368000000002d-
     <           1*gammaaa*t25*t40*t48*t73-5.421617777777779d-2*t42*t43*
     =           t47*t73-1.301188266666667d+0*t162*t24*t38*t73-1.6807015
     >           111111112d-1*gammaaa*t39*t44*t50+5.511111111111111d+1*g
     ?           ammaaa*t39*t40*t50+2.033106666666667d-2*t18*t39*t45*t48
     @           -3.7201704462400004d-4*t118*t18*t42*t43*t48-1.339261360
     1           6464002d-3*gammaaa*t118*t25*t40*t41*t48-2.7108088888888
     2           89d-2*t39*t41*t45*t47+8.88888888888889d+0*t37*t45*t47+1
     3           .7777777777777778d+1*t39*t41*t42*t47+t363+t362+t361+t36
     4           0+t359+t358+t357+t356+t355+t354+t353+t352+t351+t350+t34
     5           9+t348+t347+t346+t345+t344+t343)+2.0d+0*t208*t82+t364)+
     6           t26*(-6.4386d-4*gammaaa*t14*t33*t91*t98-5.15088d-3*rhoa
     7           *t14*t17*t89*t98-6.4386d-4*gammaaa*t33*t48*t61*t91-6.43
     8           86d-4*gammaaa*t14*t48*t51*t91-6.4386d-4*gammaaa*t14*t15
     9           *t33*t48*t91-5.15088d-3*rhoa*t17*t48*t61*t89-5.15088d-3
     :           *t14*t17*t48*t89+1.7169600000000002d-2*t18*t62+1.716960
     ;           0000000002d-2*t17*t19*t33*t61+1.7169600000000002d-2*t14
     <           *t17*t19*t51-5.15088d-3*t193*t48-5.15088d-3*rhoa*t14*t1
     =           7*t192*t48-2.8616d-2*t14*t17*t18*t33)-1.639930876381937
     >           6d-6*t1*t14*t17*t33*t93*t96-1.030176d-2*t16*t18*t26*t95
     ?           +1.25d-1*gammaaa*t14*t22*t33*t91*t94-1.25d-1*gammaaa*t1
     @           4*t16*t22*t89*t94+6.6328911936d-6*gammaaa*t14*t33*t49*t
     1           91*t93+5.30631295488d-5*rhoa*t14*t17*t49*t89*t93+t15*t2
     2           2*(-1.25d-1*gammaaa*t33*t61-1.25d-1*gammaaa*t14*t51)*t9
     3           1+1.28772d-3*gammaaa*t14*t15*t26*t33*t48*t91+t15*t16*t2
     4           2*(1.25d-1*gammaaa*t61*t89+1.25d-1*gammaaa*t14*t192)-1.
     5           28772d-3*gammaaa*t14*t15*t16*t26*t48*t89+t39*(1.0165533
     6           333333335d-2*t18*t83-3.04966d-3*t208*t48*t72-2.71080888
     7           8888889d-2*t46*t47*t72+t370+t369+t368+t367+t366)-1.2400
     8           568154133333d-4*t18*t46*t48*t72*t73+t19*(-3.53754196992
     9           00006d-4*t14*t17*t33*t48-2.060352d-2*t116)*t49+2.653156
     :           47744d-5*gammaaa*t14*t16*t18*t33*t48*t49+5.58012d-3*gam
     ;           maaa*t14*t16*t26*t33*t47+t371+t365+t342+t341-1.030176d-
     <           2*t115*t19*t26)*wght+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = (t37*(1.0d+0*t72*(-4.3372942222222
     1           227d-1*gammaaa*t40*t73*t84*taua-2.1686471111111114d-1*t
     2           25*t41*t42*t73*taua-5.421617777777779d-2*t25*t39*t45*ta
     3           ua+3.5555555555555557d+1*t25*t39*t42*taua-2.38090908559
     4           36d-3*t118*t24*t38*t48*t84-1.1927559111111112d-1*gammaa
     5           a*t40*t41*t50*t73-1.984090904661333d-4*gammaaa*t25*t44*
     6           t48*t73+6.505941333333333d-2*gammaaa*t25*t40*t48*t73-6.
     7           505941333333334d-1*t162*t24*t38*t73-5.963779555555556d-
     8           2*gammaaa*t39*t44*t50+1.9555555555555557d+1*gammaaa*t39
     9           *t40*t50-5.952272713984d-4*gammaaa*t118*t25*t40*t41*t48
     :           +t363+t362+t361+t360+t359+t358+t357+t356+t355+t354+t353
     ;           +t352+t351+t350+t349+t348+t347+t346+t345+t344+t343)+2.0
     <           d+0*t212*t82+t364)+t39*(-3.04966d-3*t213*t48+t372+t367+
     =           t366)+t371+t365+t342+t341)*wght+Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = (t37*(1.0d+0*t72*(-3.5240515555555
     1           56d-1*gammaaa*t40*t73*t84*taua-1.3554044444444446d-1*t2
     2           5*t41*t42*t73*taua-3.3885111111111116d-2*t25*t39*t45*ta
     3           ua+2.2222222222222224d+1*t25*t39*t42*taua-3.12494317484
     4           16d-3*t118*t24*t38*t48*t84-5.421617777777777d-2*gammaaa
     5           *t40*t41*t50*t73-6.200284077066667d-5*t18*t41*t45*t48*t
     6           73-3.2241477200746665d-4*gammaaa*t25*t44*t48*t73+4.0662
     7           13333333334d-2*t18*t41*t42*t48*t73+1.0572154666666667d-
     8           1*gammaaa*t25*t40*t48*t73-3.9035648d-1*t162*t24*t38*t73
     9           -2.7108088888888887d-2*gammaaa*t39*t44*t50+8.8888888888
     :           8889d+0*gammaaa*t39*t40*t50+1.0165533333333335d-2*t18*t
     ;           39*t45*t48-1.8600852231200002d-4*t118*t18*t42*t43*t48-9
     <           .672443160224d-4*gammaaa*t118*t25*t40*t41*t48+t362+t361
     =           +t358+t357+t353+t352+t351+t350+t349+t347+t345+t344+t343
     >           )+1.0d+0*t158*t92+1.0d+0*t212*t82+1.0d+0*t208*t82)-6.20
     ?           0284077066667d-5*t18*t46*t48*t72*t73-1.219864d-2*t160*t
     @           19*t73+(t372+t370+t369+t368+t367)*t39-6.09932d-3*t159*t
     1           19*t39+t342+t341)*wght+Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = (t22*(1.0d+0*rhoa*t14*t17*(-2.122
     1           525181952d-3*t28*t29*t87*t96*taua-1.061262590976d-3*gam
     2           maaa*t214*t27*t96*taua-3.53754196992d-4*t32*t49*t87*tau
     3           a+1.373568d-1*t29*t49*t87*taua+6.867840000000001d-2*t27
     4           *t49*t87*taua-1.6399308763819376d-6*t28*t32*t48*t88*t96
     5           +6.367575545856d-4*t28*t29*t48*t88*t96+3.183787772928d-
     6           4*t27*t28*t48*t88*t96-1.6399308763819376d-6*gammaaa*t31
     7           *t48*t87*t96+3.183787772928d-4*gammaaa*t27*t48*t87*t96+
     8           6.367575545856d-4*gammaaa*t23*t48*t87*t96-2.22865144104
     9           96003d-3*gammaaa*t27*t28*t84*t96-1.3796413682688d-3*t25
     :           *t29*t30*t96-3.0776615138304003d-3*t186*t23*t24*t96+1.0
     ;           61262590976d-4*t32*t48*t49*t88+1.061262590976d-4*t31*t4
     <           8*t49*t88-2.060352d-2*t27*t48*t49*t88-6.559723505527751
     =           d-6*t232*t29*t30*t48*t88-6.559723505527751d-6*gammaaa*t
     >           232*t27*t28*t48*t87-7.428838136832d-4*gammaaa*t31*t49*t
     ?           84+1.4422464000000002d-1*gammaaa*t27*t49*t84+2.88449280
     @           00000003d-1*gammaaa*t23*t49*t84-4.5988045608960004d-4*t
     1           25*t28*t32*t49+1.7856384d-1*t25*t28*t29*t49+8.928192d-2
     2           *t25*t27*t28*t49-6.559723505527751d-6*t214*t23*t232*t24
     3           *t48+4.464096d-2*t25*t26*t32+4.464096d-2*t25*t26*t31-8.
     4           666666666666666d+0*t25*t26*t27)+1.25d-1*gammaaa*t61*t85
     5           *t91+1.25d-1*gammaaa*t14*t15*t85*t91+1.25d-1*t33*t61*t9
     6           1+1.25d-1*t14*t51*t91+1.25d-1*t14*t15*t33*t91+1.25d-1*g
     7           ammaaa*t14*t163*t91-1.25d-1*t16*t61*t89-1.25d-1*t14*t15
     8           *t16*t89+1.0d+0*rhoa*t17*t215*t61+1.0d+0*t14*t17*t215-1
     9           .25d-1*t14*t16*t192)-1.6399308763819376d-6*t14*t17*t216
     :           *t33*t48*t96+t18*t26*(1.7169600000000002d-3*gammaaa*t14
     ;           *t15*t33*t91+1.373568d-2*t14*t17*t89-5.15088d-3*t193)+t
     <           26*(-6.4386d-4*gammaaa*t14*t48*t85-6.4386d-4*t14*t33*t4
     =           8)*t91+6.6328911936d-6*gammaaa*t14*t18*t33*t48*t49*t91+
     >           6.4386d-4*gammaaa*t14*t26*t33*t47*t91+t15*t22*t280*t91+
     ?           t15*t16*t22*(1.25d-1*t14*t89+1.25d-1*gammaaa*t14*t215)+
     @           5.30631295488d-5*t14*t17*t19*t48*t49*t89+6.4386d-4*t14*
     1           t16*t26*t48*t89-6.4386d-4*gammaaa*t14*t16*t26*t47*t89+(
     2           -1.7687709849600003d-4*t14*t17*t33-2.060352d-2*t165)*t4
     3           9*t88+t18*t39*(1.0165533333333335d-2*t72*t86-3.04966d-3
     4           *t210)+t19*t26*(1.7169600000000002d-2*t14*t17*t85+t317)
     5           +1.061262590976d-4*t1*t14*t17*t48*t49*t85+t37*(1.0d+0*t
     6           72*(-4.2161931724053336d-4*gammaaa*t44*t73*t84+1.382512
     7           5333333332d-1*gammaaa*t40*t73*t84+2.7650250666666665d-1
     8           *gammaaa*t38*t73*t84-1.2648579517216d-3*gammaaa*t118*t4
     9           0*t41*t84-1.6120738600373333d-4*t25*t41*t45*t73+1.05721
     :           54666666667d-1*t25*t41*t42*t73+5.286077333333333d-2*t25
     ;           *t40*t41*t73+2.6430386666666666d-2*t25*t39*t45+2.643038
     <           6666666666d-2*t25*t39*t44-4.836221580112d-4*t118*t25*t4
     =           2*t43-8.666666666666666d+0*t25*t39*t40+t390+t389+t388+t
     >           387+t386+t385+t384+t383+t382+t381+t380-3.1249431748416d
     ?           -3*t118*t186*t24*t38+t379+t378+t377+t376+t375+t374)+t39
     @           1)-1.6120738600373333d-4*t25*t46*t72*t73-1.32657823872d
     1           -5*t14*t16*t19*t33*t48*t49+1.32657823872d-5*gammaaa*t14
     2           *t16*t25*t33*t49-5.15088d-3*rhoa*t14*t17*t215*t26*t48+t
     3           397+t396+t395+t394+t393+t392+t373+t16*t18*t26*(-2.1462d
     4           -3*t14*t33-1.030176d-2*t161))*wght+Mmat3(iq,D3_RA_GAA_T
     5           A)
              Mmat3(iq,D3_RA_GAA_TB) = (t37*(1.0d+0*t72*(-2.976136356991
     1           9996d-4*gammaaa*t44*t73*t84+9.758912d-2*gammaaa*t40*t73
     2           *t84+1.9517824d-1*gammaaa*t38*t73*t84-8.928409070975999
     3           d-4*gammaaa*t118*t40*t41*t84-9.920454523306665d-5*t25*t
     4           41*t45*t73+6.505941333333333d-2*t25*t41*t42*t73+3.25297
     5           06666666663d-2*t25*t40*t41*t73+1.6264853333333332d-2*t2
     6           5*t39*t45+1.6264853333333332d-2*t25*t39*t44-2.976136356
     7           992d-4*t118*t25*t42*t43-5.333333333333333d+0*t25*t39*t4
     8           0+t390+t389+t388+t387+t386+t385+t384+t383+t382+t381+t38
     9           0-2.3809090855936d-3*t118*t186*t24*t38+t379+t378+t377+t
     :           376+t375+t374)+t391)-9.920454523306665d-5*t25*t46*t72*t
     ;           73+t398+t397+t396+t395+t394+t393+t392+t373)*wght+Mmat3(
     <           iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = (1.0165533333333335d-2*t18*t39*t7
     1           2*t86+t37*(1.0d+0*t72*(-2.2321022677439997d-4*gammaaa*t
     2           44*t73*t84+7.319184000000001d-2*gammaaa*t40*t73*t84+1.4
     3           638368000000002d-1*gammaaa*t38*t73*t84-6.69630680323200
     4           1d-4*gammaaa*t118*t40*t41*t84-6.200284077066667d-5*t25*
     5           t41*t45*t73+4.066213333333334d-2*t25*t41*t42*t73+2.0331
     6           06666666667d-2*t25*t40*t41*t73+1.0165533333333335d-2*t2
     7           5*t39*t45+1.0165533333333335d-2*t25*t39*t44-1.860085223
     8           1200002d-4*t118*t25*t42*t43-3.3333333333333337d+0*t25*t
     9           39*t40+t390+t389+t388+t387+t386+t385+t384+t383+t382+t38
     :           1+t380-1.9344886320448001d-3*t118*t186*t24*t38+t379+t37
     ;           8+t377+t376+t375+t374)+t391)-6.200284077066667d-5*t25*t
     <           46*t72*t73+t399+t397+t395+t393+t392-3.04966d-3*t18*t210
     =           *t39+t373)*wght+Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = (t37*(1.0d+0*t72*(-9.920454523306
     1           665d-5*gammaaa*t44*t73*t84+3.2529706666666663d-2*gammaa
     2           a*t40*t73*t84+6.505941333333333d-2*gammaaa*t38*t73*t84-
     3           2.976136356992d-4*gammaaa*t118*t40*t41*t84+t390+t389+t3
     4           88+t387+t386+t385+t384+t383+t382+t381+t380-1.1904545427
     5           968d-3*t118*t186*t24*t38+t379+t378+t377+t376+t375+t374)
     6           +t391)+t399+t398+t397+t395+t393+t392+t373)*wght+Mmat3(i
     7           q,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = (1.0d+0*rhoa*t14*t17*t22*(-1.639
     1           9308763819376d-6*t28*t32*t87*t96+6.367575545856d-4*t28*
     2           t29*t87*t96+6.367575545856d-4*t27*t28*t87*t96-1.6399308
     3           763819376d-6*gammaaa*t214*t31*t96+3.183787772928d-4*gam
     4           maaa*t214*t27*t96+1.2735151091712002d-3*gammaaa*t214*t2
     5           3*t96+1.061262590976d-4*t32*t49*t87+2.122525181952d-4*t
     6           31*t49*t87-4.120704d-2*t27*t49*t87-4.120704d-2*t23*t49*
     7           t87-6.559723505527751d-6*t232*t29*t30*t87-6.55972350552
     8           7751d-6*t23*t232*t24*t400-6.559723505527751d-6*gammaaa*
     9           t214*t232*t27*t28)-1.6399308763819376d-6*t14*t17*t223*t
     :           33*t96+t18*t26*(-1.28772d-3*gammaaa*t14*t85-1.28772d-3*
     ;           t14*t33)*t91+6.6328911936d-6*gammaaa*t14*t25*t33*t49*t9
     <           1+t22*t315*t91+5.30631295488d-5*t14*t17*t49*t88*t89+1.2
     =           8772d-3*t14*t16*t18*t26*t89-2.65315647744d-5*t14*t16*t3
     >           3*t49*t88+2.122525181952d-4*t14*t17*t216*t49*t85+2.5754
     ?           4d-3*t14*t16*t19*t26*t85+t406+t405+t404+t403+t402+t401-
     @           1.030176d-2*t14*t17*t19*t215*t26-1.030176d-2*t1*t14*t17
     1           *t187*t26-2.5d-1*t14*t16*t215*t22)*wght+Mmat3(iq,D3_GAA
     2           _GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = t407+Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = t407+Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = (7.5d-1*gammaaa*t14*t22*t33/taua**
     1           4+1.0d+0*rhoa*t14*t17*t22*(-6.55972350552775d-6*t28*t32
     2           *t410*t96+7.641090655027201d-3*t28*t29*t410*t96-6.55972
     3           350552775d-6*gammaaa*t31*t409*t96+3.8205453275136003d-3
     4           *gammaaa*t27*t409*t96+1.2735151091712002d-3*t32*t410*t4
     5           9-4.9448448d-1*t29*t410*t49-2.623889402211101d-5*t232*t
     6           29*t30*t410-2.623889402211101d-5*gammaaa*t232*t27*t28*t
     7           409-2.623889402211101d-5*t23*t232*t24*t408)-6.559723505
     8           52775d-6*t14*t17*t33*t96/rhoa**4-7.72632d-3*gammaaa*t14
     9           *t19*t26*t89*t91+7.959469432320001d-5*gammaaa*t14*t216*
     :           t33*t49*t91+3.75d-1*gammaaa*t14*t22*t224*t91+6.36757554
     ;           5856d-4*t106*t14*t17*t49*t89-7.5d-1*gammaaa*t14*t22*t22
     <           5*t89+t414+t413+t412+t411+7.72632d-3*gammaaa*t14*t19*t2
     =           25*t26*t33-3.090528d-2*t1*t14*t17*t224*t26)*wght+Mmat3(
     >           iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = (t414+t413+t412+t411)*wght+Mmat3(i
     1           q,D3_TA_TA_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 5.15088d-3*(6.0d-50*t1-9.11559972d+0)+1.0d+0
              t3 = 1/t2
              t4 = param(12)
              t5 = 1/t2**2
              t6 = 2.0d-50*t1-9.11559972d+0
              t7 = t6**2
              t8 = param(10)
              t9 = 1/rhoa**3.3333333333333337d+0
              t10 = param(9)
              t11 = param(8)
              t12 = param(11)
              t13 = 1.6d-99*t5*t8*t9+t4*t5*t7+4.0d-50*t1*t12*t5*t6+t10*t
     1           3*t6+4.0d-50*t1*t11*t3+param(7)
              t14 = 1/rhoa**6.666666666666666d-1
              t15 = rhoa**5.0d-1
              t16 = 1/t15
              t17 = 1/rhoa**3.333333333333333d-1
              t18 = 1/rhoa**1.6666666666666666d-1
              t19 = 1.1120374863094686d+1*t18+3.8447462374472113d+0*t17+
     1           1.644733775567609d+0*t16+2.4058712912881916d-1*t14
              t20 = 3.216395899738507d+1/t19+1.0d+0
              t21 = log(t20)
              t22 = 1.274696188700087d-1*t17+1.0d+0
              t23 = 5.982550435771079d+0*t18+2.2255694211506874d+0*t17+8
     1           .004286349993635d-1*t16+1.8970043257475583d-1*t14
              t24 = 1.6081979498692536d+1/t23+1.0d+0
              t25 = log(t24)
              t26 = 1.3256889990520176d-1*t17+1.0d+0
              t27 = -6.903522198342671d-18*t25*t26-3.1090699999999993d-2
     1           *t21*t22
              t28 = 3.04966d-3*(1.2d-49*t1-1.823119944d+1)+1.0d+0
              t29 = 1/t28
              t30 = param(6)
              t31 = 1/t28**2
              t32 = 4.0d-50*t1-1.823119944d+1
              t33 = t32**2
              t34 = param(4)
              t35 = param(3)
              t36 = param(2)
              t37 = param(5)
              t38 = 6.4d-99*t31*t34*t9+8.0d-50*t1*t31*t32*t37+8.0d-50*t1
     1           *t29*t36+t29*t32*t35+t30*t31*t33+param(1)
              t39 = -2*rhoa*t27
              t40 = 1/t24
              t41 = 1/t15**3
              t42 = 1/rhoa**1.3333333333333333d+0
              t43 = 1/rhoa**1.1666666666666667d+0
              t44 = -9.970917392951799d-1*t43-7.418564737168958d-1*t42-4
     1           .002143174996817d-1*t41-1.264669550498372d-1*t1
              t45 = 1/t23**2
              t46 = 1/t20
              t47 = -1.8533958105157808d+0*t43-1.2815820791490704d+0*t42
     1           -8.223668877838045d-1*t41-1.6039141941921276d-1*t1
              t48 = 1/t19**2
              t49 = 1.0d+0*t22*t46*t47*t48+1.1102230246251565d-16*t26*t4
     1           0*t44*t45+3.0506411443514264d-19*t25*t42+1.321039893133
     2           9265d-3*t21*t42
              t50 = 1/t2**3
              t51 = 1/rhoa**6
              t52 = 1/rhoa**4.333333333333333d+0
              t53 = 1/rhoa**2.6666666666666666d+0
              t54 = -5.333333333333334d-99*t5*t52*t8+1.6482816d-150*t50*
     1           t51*t8+1.030176d-51*t4*t50*t53*t7-6.666666666666666d-50
     2           *t4*t5*t53*t6-6.666666666666666d-50*t12*t5*t53*t6+5.150
     3           88d-52*t10*t5*t53*t6+4.1207039999999995d-101*t12*t50*t5
     4           2*t6-6.666666666666666d-50*t11*t3*t53-3.333333333333333
     5           d-50*t10*t3*t53-1.3333333333333333d-99*t12*t5*t52+2.060
     6           3519999999997d-101*t11*t5*t52
              t55 = 5.0d-1*rhoa*t27*t54+5.0d-1*rhoa*t13*t49+5.0d-1*t13*t
     1           27
              t56 = 6.299605249474366d-1
              t57 = 1.414213562373095d+0
              t58 = 1/t57
              t59 = 7.937005259840998d-1
              t60 = 8.908987181403393d-1
              t61 = 5.982550435771079d+0*t18*t60+2.2255694211506874d+0*t
     1           17*t59+8.004286349993635d-1*t16*t58+1.8970043257475583d
     2           -1*t14*t56
              t62 = 1.6081979498692536d+1/t61+1.0d+0
              t63 = log(t62)
              t64 = 1.3256889990520176d-1*t17*t59+1.0d+0
              t65 = t39-1.243628d-1*rhoa*t63*t64
              t66 = 1/t62
              t67 = 3.149802624737183d-1
              t68 = 1/t57**3
              t69 = 3.968502629920499d-1
              t70 = 4.4544935907016964d-1
              t71 = -9.970917392951799d-1*t43*t70-7.418564737168958d-1*t
     1           42*t69-4.002143174996817d-1*t41*t68-1.264669550498372d-
     2           1*t1*t67
              t72 = 1/t61**2
              t73 = 2*rhoa*(1.0d+0*t64*t66*t71*t72+2.747773264188437d-3*
     1           t42*t63*t69)-6.21814d-2*t63*t64-rhoa*t49+6.903522198342
     2           671d-18*t25*t26+3.1090699999999993d-2*t21*t22
              t74 = 1/t28**3
              t75 = 6.09932d-52*t30*t33*t53*t74+4.8794560000000003d-101*
     1           t32*t37*t52*t74+3.9035648d-150*t34*t51*t74-6.6666666666
     2           66666d-50*t31*t32*t37*t53-6.666666666666666d-50*t29*t36
     3           *t53+3.04966d-52*t31*t32*t35*t53-3.333333333333333d-50*
     4           t29*t35*t53-6.666666666666666d-50*t30*t31*t32*t53-2.666
     5           6666666666666d-99*t31*t37*t52+2.4397280000000002d-101*t
     6           31*t36*t52-1.0666666666666666d-98*t31*t34*t52
              t76 = 1.0d+0*t65*t75+1.0d+0*t38*t73
              t77 = 2.57544d-52*t27*t54+2.57544d-52*t13*t49
              t78 = 1/t24**2
              t79 = t44**2
              t80 = 1/t23**4
              t81 = 1/t23**3
              t82 = 1/t15**5
              t83 = 1/rhoa**2.3333333333333334d+0
              t84 = 1/rhoa**2.1666666666666665d+0
              t85 = 1.1632736958443765d+0*t84+9.89141964955861d-1*t83+6.
     1           003214762495226d-1*t82+2.1077825841639536d-1*t53
              t86 = 1/t20**2
              t87 = t47**2
              t88 = 1/t19**4
              t89 = 1/t19**3
              t90 = 2.1622951122684114d+0*t84+1.7087761055320938d+0*t83+
     1           1.2335503316757068d+0*t82+2.673190323653546d-1*t53
              t91 = 1.0d+0*t22*t46*t48*t90-2.0d+0*t22*t46*t87*t89+3.2163
     1           95899738507d+1*t22*t86*t87*t88+1.1102230246251565d-16*t
     2           26*t40*t45*t85-4.0675215258019015d-19*t25*t83-1.7613865
     3           241785684d-3*t21*t83-2.220446049250313d-16*t26*t40*t79*
     4           t81+1.7854583920998188d-15*t26*t78*t79*t80-8.4979745913
     5           33913d-2*t42*t46*t47*t48-9.812069668265515d-18*t40*t42*
     6           t44*t45
              t92 = 1/t2**4
              t93 = 1/rhoa**8.666666666666666d+0
              t94 = 1/rhoa**7
              t95 = 1/rhoa**5.333333333333333d+0
              t96 = 1/rhoa**3.6666666666666664d+0
              t97 = -2.747136d-51*t4*t50*t7*t96+1.7777777777777776d-49*t
     1           4*t5*t6*t96+1.7777777777777776d-49*t12*t5*t6*t96-1.3735
     2           68d-51*t10*t5*t6*t96+1.7777777777777776d-49*t11*t3*t96+
     3           8.888888888888888d-50*t10*t3*t96+1.5918938864639998d-10
     4           2*t4*t7*t92*t95+2.3111111111111113d-98*t5*t8*t95-1.3735
     5           68d-100*t4*t50*t6*t95-2.4724223999999997d-100*t12*t50*t
     6           6*t95+5.306312954879999d-103*t10*t50*t6*t95+2.222222222
     7           222222d-99*t4*t5*t95+8.0d-99*t12*t5*t95-1.2362111999999
     8           999d-100*t11*t5*t95-3.43392d-101*t10*t5*t95+6.367575545
     9           855999d-152*t12*t6*t92*t94-1.53839616d-149*t50*t8*t94-2
     :           .7471359999999995d-150*t12*t50*t94+2.1225251819519997d-
     ;           152*t11*t50*t94+2.5470302183424d-201*t8*t92*t93
              t98 = 5.0d-1*rhoa*t27*t97+5.0d-1*rhoa*t13*t91+1.0d+0*rhoa*
     1           t49*t54+1.0d+0*t27*t54+1.0d+0*t13*t49
              t99 = 1.86008522312d-103*t38*t65*t74*t95
              t100 = 5.15088d-52*t55-4.2923999999999995d-52*t13*t27
              t101 = 2.0d+0*t73*t75
              t102 = 2.0d+0*t64*t66*t71*t72
              t103 = 5.495546528376875d-3*t42*t63*t69
              t104 = 1/t62**2
              t105 = t71**2
              t106 = 1/t61**4
              t107 = 1.6081979498692536d+1*t104*t105*t106*t64
              t108 = 1/t61**3
              t109 = -2.0d+0*t105*t108*t64*t66
              t110 = 1.9842513149602492d-1
              t111 = 2.5908976111853255d-1*t84+9.89141964955861d-1*t110*
     1           t83+6.003214762495226d-1*t82/t57**5+3.319549557987472d-
     2           2*t53
              t112 = 1.0d+0*t111*t64*t66*t72
              t113 = -3.663697685584583d-3*t110*t63*t83
              t114 = 8.157414703487641d+0*t18*t60+2.247591863577616d+0*t
     1           17*t59+4.3009724712766434d-1*t16*t58+1.9115125951273373
     2           d-1*t14*t56
              t115 = 2.9608813203268075d+1/t114+1.0d+0
              t116 = log(t115)
              t117 = 6.901399211255825d-2*t17*t59+1.0d+0
              t118 = 1/rhoa**2
              t119 = -8.837926660346784d-2*t42*t66*t69*t71*t72
              t120 = -rhoa*t91-2.0d+0*t22*t46*t47*t48-2.220446049250313d
     1           -16*t26*t40*t44*t45-6.101282288702853d-19*t25*t42-2.642
     2           079786267853d-3*t21*t42+2*rhoa*(t119+8.443431970194815d
     3           -3*t116*t117*t118+t113+t112+t109+t107)+t103+t102
              t121 = 1/t28**4
              t122 = 3.5713636283903993d-201*t121*t34*t93
              t123 = 1.488068178496d-152*t36*t74*t94
              t124 = -3.252970666666667d-150*t37*t74*t94
              t125 = 4.4642045354879994d-152*t121*t32*t37*t94
              t126 = -2.0331066666666667d-101*t31*t35*t95
              t127 = 2.222222222222222d-99*t30*t31*t95
              t128 = 5.580255669359999d-103*t121*t30*t33*t95
              t129 = 1.86008522312d-103*t32*t35*t74*t95
              t130 = -8.132426666666667d-101*t30*t32*t74*t95
              t131 = -1.6264853333333332d-51*t30*t33*t74*t96+1.777777777
     1           7777776d-49*t31*t32*t37*t96+1.7777777777777776d-49*t29*
     2           t36*t96-8.132426666666666d-52*t31*t32*t35*t96+8.8888888
     3           88888888d-50*t29*t35*t96+1.7777777777777776d-49*t30*t31
     4           *t32*t96-2.1144309333333333d-100*t32*t37*t74*t95+1.1555
     5           555555555555d-98*t31*t37*t95-1.0572154666666667d-100*t3
     6           1*t36*t95+3.733333333333333d-98*t31*t34*t95-2.342138880
     7           0000004d-149*t34*t74*t94+t130+t129+t128+t127+t126+t125+
     8           t124+t123+t122
              t132 = 1.0d+0*t131*t65+1.0d+0*t120*t38+t101
              t133 = 3.04966d-52*t38*t73
              t134 = 3.04966d-52*t65*t75
              t135 = 3.04966d-52*t76+t134+t133
              t136 = -8.443431970194815d-3*t116*t117*t118
              t137 = 2*rhoa*(t136+t119+t113+t112+t109+t107)+t103+t102
              t138 = -8.132426666666667d-101*t32*t37*t74*t95+4.444444444
     1           444444d-99*t31*t37*t95-4.0662133333333333d-101*t31*t36*
     2           t95+8.888888888888888d-99*t31*t34*t95-1.301188266666666
     3           6d-149*t34*t74*t94+t130+t129+t128+t127+t126+t125+t124+t
     4           123+t122
              t139 = 1.0d+0*t138*t65+1.0d+0*t137*t38+t101
              t140 = t44**3
              t141 = 1/t15**7
              t142 = 1/rhoa**3.1666666666666665d+0
              t143 = t47**3
              t144 = 1.1102230246251565d-16*t26*t40*t45*(-5.620753557770
     1           543d-1*t96-2.3079979182303428d+0*t9-2.520426340996149d+
     2           0*t142-1.5008036906238065d+0*t141)+1.0d+0*t22*t46*t48*(
     3           -7.128507529742789d-1*t96-3.9871442462415524d+0*t9-4.68
     4           4972743248224d+0*t142-3.083875829189267d+0*t141)-6.0d+0
     5           *t22*t46*t47*t89*t90+9.649187699215522d+1*t22*t47*t86*t
     6           88*t90-1.274696188700087d-1*t42*t46*t48*t90+9.490883560
     7           204437d-19*t25*t9+4.1099018897499934d-3*t21*t9+2.549392
     8           377400174d-1*t42*t46*t87*t89-4.0999275947472624d+0*t42*
     9           t86*t87*t88+6.0d+0*t143*t22*t46*t88-1.9298375398431045d
     :           +2*t143*t22*t86/t19**5-6.661338147750939d-16*t26*t40*t4
     ;           4*t81*t85+5.356375176299456d-15*t26*t44*t78*t80*t85-1.4
     <           718104502398274d-17*t40*t42*t45*t85+1.6995949182667827d
     =           -1*t46*t47*t48*t83+1.962413933653103d-17*t40*t44*t45*t8
     >           3+2.943620900479655d-17*t40*t42*t79*t81-2.3669625486718
     ?           335d-16*t42*t78*t79*t80+6.661338147750939d-16*t140*t26*
     @           t40*t80-1.0712750352598913d-14*t140*t26*t78/t23**5+5.74
     1           2741051503565d-14*t140*t26/(t23**6*t24**3)+2.0690405167
     2           709364d+3*t143*t22/(t19**6*t20**3)
              t145 = 1/t2**5
              t146 = 1/rhoa**1.1333333333333334d+1
              t147 = 1/rhoa**9.666666666666666d+0
              t148 = 1/rhoa**8
              t149 = 1/rhoa**6.333333333333333d+0
              t150 = 1/rhoa**4.666666666666667d+0
              t151 = 1.7017882504620416d-154*t121*t148*t38*t65
              t152 = 4.824593849607761d+1*t104*t105*t106*t64
              t153 = -6.0d+0*t105*t108*t64*t66
              t154 = 3.0d+0*t111*t64*t66*t72
              t155 = -1.099109305675375d-2*t110*t63*t83
              t156 = -2.6513779981040353d-1*t42*t66*t69*t71*t72
              t157 = t71**3
              t158 = 5.172601291927341d+2*t157*t64/(t61**6*t62**3)
              t159 = -9.649187699215522d+1*t104*t157*t64/t61**5
              t160 = 6.0d+0*t106*t157*t64*t66
              t161 = 4.824593849607761d+1*t104*t106*t111*t64*t71
              t162 = -6.0d+0*t108*t111*t64*t66*t71
              t163 = 9.921256574801247d-2
              t164 = 1.0d+0*t64*t66*t72*(-4.4260660773166294d-2*t96-2.30
     1           79979182303428d+0*t163*t9-1.5008036906238065d+0*t141/t5
     2           7**7-2.8068057454507694d-1*t142)
              t165 = 8.548627933030694d-3*t163*t63*t9
              t166 = 1/rhoa**3
              t167 = 1.767585332069357d-1*t110*t66*t71*t72*t83
              t168 = 1/t115
              t169 = -1.3595691172479402d+0*t43*t70-7.491972878592053d-1
     1           *t42*t69-2.1504862356383217d-1*t41*t68-1.27434173008489
     2           14d-1*t1*t67
              t170 = 1/t114**2
              t171 = -2.1319703304396778d+0*t104*t105*t106*t42*t69
              t172 = 2.6513779981040353d-1*t105*t108*t42*t66*t69
              t173 = -1.3256889990520176d-1*t111*t42*t66*t69*t72
              t174 = 1/t28**5
              t175 = 4.3565779211828265d-252*t146*t174*t34
              t176 = 1.3614306003696333d-203*t121*t147*t36
              t177 = -4.4642045354879994d-201*t121*t147*t37
              t178 = 5.445722401478533d-203*t147*t174*t32*t37
              t179 = -1.8600852231199996d-152*t148*t35*t74
              t180 = 4.066213333333333d-150*t148*t30*t74
              t181 = 6.807153001848166d-154*t148*t174*t30*t33
              t182 = 1.7017882504620416d-154*t121*t148*t32*t35
              t183 = -1.1160511338719999d-151*t121*t148*t30*t32
              t184 = t31*(-8.132426666666666d-52*t65*t75-8.1324266666666
     1           66d-52*t38*t73)*t96
              t185 = 6.09932d-52*t73*t75
              t186 = 1.86008522312d-103*t38*t73
              t187 = 1.86008522312d-103*t65*t75
              fnc(iq) = (1.0d+0*t29*t38*(t39-1.243628d-1*rhoa*(1.0522000
     1           558389212d-1*t17+1.0d+0)*log(1.6081979498692536d+1/(5.3
     2           29846514438383d+0*t18+1.766435620181429d+0*t17+5.659885
     3           156639418d-1*t16+1.19503784087549d-1*t14)+1.0d+0))+1.0d
     4           +0*rhoa*t13*t27*t3)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t29*t76+3.04966d-52*t31*t38*t53*t65+t3*t
     1           55+2.57544d-52*t1*t13*t27*t5)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t99+t3*t98-8.132426666666666d-52*t31
     1           *t38*t65*t96+t1*t5*t77+t100*t5*t53+t135*t31*t53+2.65315
     2           64774399996d-103*t13*t27*t50*t52+t132*t29)*wght+Amat2(i
     3           q,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t99+3.04966d-52*t31*t53*t76+(t134+t1
     1           33)*t31*t53+t139*t29)*wght+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = (t5*t53*(1.030176d-51*t98-4.292399
     1           9999999995d-52*t27*t54-4.2923999999999995d-52*t13*t49)+
     2           t3*(1.5d+0*rhoa*t49*t97+1.5d+0*t27*t97+5.0d-1*rhoa*t27*
     3           (-4.58465439301632d-200*t147*t8*t92-1.2735151091711996d
     4           -101*t149*t4*t7*t92-3.1837877729279995d-151*t148*t4*t6*
     5           t92-8.277848209612798d-151*t12*t148*t6*t92+8.1996543819
     6           09687d-154*t10*t148*t6*t92-6.367575545855999d-201*t12*t
     7           147*t92+3.2798617527638746d-203*t11*t147*t92+1.31496243
     8           2d-148*t148*t50*t8-1.2325925925925926d-97*t149*t5*t8+5.
     9           2477788044222d-252*t145*t146*t8+1.0072832d-50*t150*t4*t
     :           50*t7+3.279861752763875d-153*t145*t148*t4*t7+1.0988544d
     ;           -99*t149*t4*t50*t6+1.50176768d-99*t12*t149*t50*t6-4.245
     <           0503639039994d-102*t10*t149*t50*t6-6.518518518518518d-4
     =           9*t150*t4*t5*t6-6.518518518518518d-49*t12*t150*t5*t6+5.
     >           036415999999999d-51*t10*t150*t5*t6+1.31194470110555d-20
     ?           2*t12*t145*t147*t6+6.86784d-150*t148*t4*t50+3.571276799
     @           9999995d-149*t12*t148*t50-2.7592827365375994d-151*t11*t
     1           148*t50-5.30631295488d-152*t10*t148*t50-1.7777777777777
     2           776d-98*t149*t4*t5-4.8592592592592593d-98*t12*t149*t5+7
     3           .508838399999999d-100*t11*t149*t5+2.7471359999999995d-1
     4           00*t10*t149*t5-6.518518518518518d-49*t11*t150*t3-3.2592
     5           59259259259d-49*t10*t150*t3)+1.5d+0*rhoa*t54*t91+1.5d+0
     6           *t13*t91+3.0d+0*t49*t54+5.0d-1*rhoa*t13*t144)+t1*t5*(2.
     7           57544d-52*t27*t97+2.57544d-52*t13*t91+5.15088d-52*t49*t
     8           54)-2.6666666666666666d+0*t100*t5*t96-2.666666666666666
     9           6d+0*t135*t31*t96+(t187+t186+6.09932d-52*t135)*t74*t95+
     :           (1.030176d-51*t100-1.1497011402239997d-102*t13*t27)*t50
     ;           *t95+4.0998271909548434d-154*t13*t27*t92*t94+t29*(1.0d+
     <           0*t38*(-3.0d+0*t22*t46*t48*t90+2*rhoa*(-5.8271494739394
     =           7d-4*t116*t69*t9+t173+t172+t171-7.5d-1*t117*t118*t168*t
     >           169*t170+t167-2.533029591058444d-2*t116*t117*t166+t165+
     ?           t164+t162+t161+t160+t159+t158)+6.0d+0*t22*t46*t87*t89-9
     @           .649187699215522d+1*t22*t86*t87*t88-3.3306690738754696d
     1           -16*t26*t40*t45*t85+1.2202564577405706d-18*t25*t83+5.28
     2           4159572535705d-3*t21*t83+6.661338147750939d-16*t26*t40*
     3           t79*t81-5.356375176299456d-15*t26*t78*t79*t80+2.5493923
     4           77400174d-1*t42*t46*t47*t48+2.943620900479655d-17*t40*t
     5           42*t44*t45+t156+t155+t154+t153+t152-rhoa*t144+2.5330295
     6           910584444d-2*t116*t117*t118)+3.0d+0*t120*t75+1.0d+0*t65
     7           *(1.1276964977777776d-99*t149*t32*t37*t74+3.41561919999
     8           9999d-149*t148*t37*t74-1.5624715874207998d-151*t148*t36
     9           *t74-1.4880681784959998d-102*t149*t32*t35*t74+1.5852810
     :           38222222d-148*t148*t34*t74+5.963779555555554d-51*t150*t
     ;           30*t33*t74+6.505941333333333d-100*t149*t30*t32*t74-6.51
     <           8518518518518d-49*t150*t31*t32*t37-4.6874147622623996d-
     =           151*t121*t148*t32*t37-6.162962962962963d-98*t149*t31*t3
     >           7+5.638482488888887d-100*t149*t31*t36-6.518518518518518
     ?           d-49*t150*t29*t36+2.981889777777777d-51*t150*t31*t32*t3
     @           5+1.6264853333333332d-100*t149*t31*t35-3.25925925925925
     1           9d-49*t150*t29*t35-1.754074074074074d-97*t149*t31*t34-4
     2           .6427727169075195d-200*t121*t147*t34-4.4642045354879994
     3           d-102*t121*t149*t30*t33-6.518518518518518d-49*t150*t30*
     4           t31*t32-1.7777777777777776d-98*t149*t30*t31+t183+t182+t
     5           181+t180+t179+t178+t177+t176+t175)+3.0d+0*t131*t73)-1.6
     6           666666666666669d+0*t5*t53*t77+t50*t52*(1.030176d-51*t77
     7           +2.6531564774399996d-103*t27*t54+2.6531564774399996d-10
     8           3*t13*t49)-1.4880681784959998d-102*t149*t38*t65*t74+t31
     9           *t53*(3.04966d-52*t131*t65+3.04966d-52*t120*t38+t185+6.
     :           09932d-52*t132)+2.981889777777777d-51*t150*t31*t38*t65+
     ;           t184+t151)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = ((t187+t186)*t74*t95+6.09932d-52*t
     1           135*t74*t95+t29*(1.0d+0*t38*(2*rhoa*(1.9423831579798237
     2           d-4*t116*t69*t9+t173+t172+t171+2.5d-1*t117*t118*t168*t1
     3           69*t170+t167+8.443431970194815d-3*t116*t117*t166+t165+t
     4           164+t162+t161+t160+t159+t158)+t156+t155+t154+t153+t152+
     5           t136)+2.0d+0*t137*t75+1.0d+0*t120*t75+1.0d+0*t65*(2.168
     6           647111111111d-100*t149*t32*t37*t74+1.6807015111111112d-
     7           149*t148*t37*t74-7.688352255562666d-152*t148*t36*t74-4.
     8           960227261653333d-103*t149*t32*t35*t74+5.096320711111111
     9           d-149*t148*t34*t74+2.168647111111111d-100*t149*t30*t32*
     :           t74-2.3065056766687997d-151*t121*t148*t32*t37-1.1851851
     ;           851851851d-98*t149*t31*t37+1.0843235555555555d-100*t149
     <           *t31*t36+5.421617777777777d-101*t149*t31*t35-2.37037037
     =           03703702d-98*t149*t31*t34-2.7380454484326394d-200*t121*
     >           t147*t34-1.4880681784959998d-102*t121*t149*t30*t33-5.92
     ?           5925925925926d-99*t149*t30*t31+t183+t182+t181+t180+t179
     @           +t178+t177+t176+t175)+2.0d+0*t138*t73+1.0d+0*t131*t73)-
     1           4.960227261653333d-103*t149*t38*t65*t74+t31*t53*(3.0496
     2           6d-52*t138*t65+3.04966d-52*t137*t38+t185+3.04966d-52*t1
     3           39)+3.04966d-52*t132*t31*t53+t184+t151)*wght+Amat3(iq,D
     4           3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**6.666666666666666d-1
              t2 = rhoa**5.0d-1
              t3 = 1/t2
              t4 = 1/rhoa**3.333333333333333d-1
              t5 = 1/rhoa**1.6666666666666666d-1
              t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.6
     1           44733775567609d+0*t3+2.4058712912881916d-1*t1
              t7 = 3.216395899738507d+1/t6+1.0d+0
              t8 = log(t7)
              t9 = 1.274696188700087d-1*t4+1.0d+0
              t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.0
     1           04286349993635d-1*t3+1.8970043257475583d-1*t1
              t11 = 1.6081979498692536d+1/t10+1.0d+0
              t12 = log(t11)
              t13 = 1.3256889990520176d-1*t4+1.0d+0
              t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t
     1           12*t13
              t15 = 1/rhoa
              t16 = 1/taua
              t17 = 1.0d+0-1.25d-1*gammaaa*t15*t16
              t18 = 1/rhoa**2.6666666666666666d+0
              t19 = gammaaa*t18
              t20 = 1/rhoa**1.6666666666666669d+0
              t21 = 2.0d+0*t20*taua
              t22 = 5.15088d-3*(t21+t19-9.11559972d+0)+1.0d+0
              t23 = 1/t22
              t24 = param(7)
              t25 = param(10)
              t26 = gammaaa**2
              t27 = 1/rhoa**5.333333333333333d+0
              t28 = 1/t22**2
              t29 = param(11)
              t30 = t21-9.11559972d+0
              t31 = param(12)
              t32 = t30**2
              t33 = param(8)
              t34 = param(9)
              t35 = t23*t30*t34+gammaaa*t18*t23*t33+t28*t31*t32+gammaaa*
     1           t18*t28*t29*t30+t25*t26*t27*t28+t24
              t36 = 1/rhob**6.666666666666666d-1
              t37 = rhob**5.0d-1
              t38 = 1/t37
              t39 = 1/rhob**3.333333333333333d-1
              t40 = 1/rhob**1.6666666666666666d-1
              t41 = 1.1120374863094686d+1*t40+3.8447462374472113d+0*t39+
     1           1.644733775567609d+0*t38+2.4058712912881916d-1*t36
              t42 = 3.216395899738507d+1/t41+1.0d+0
              t43 = log(t42)
              t44 = 1.274696188700087d-1*t39+1.0d+0
              t45 = 5.982550435771079d+0*t40+2.2255694211506874d+0*t39+8
     1           .004286349993635d-1*t38+1.8970043257475583d-1*t36
              t46 = 1.6081979498692536d+1/t45+1.0d+0
              t47 = log(t46)
              t48 = 1.3256889990520176d-1*t39+1.0d+0
              t49 = -6.903522198342671d-18*t47*t48-3.1090699999999993d-2
     1           *t43*t44
              t50 = 1/rhob
              t51 = 1/taub
              t52 = 1.0d+0-1.25d-1*gammabb*t50*t51
              t53 = 1/rhob**2.6666666666666666d+0
              t54 = gammabb*t53
              t55 = 1/rhob**1.6666666666666669d+0
              t56 = 2.0d+0*t55*taub
              t57 = 5.15088d-3*(t56+t54-9.11559972d+0)+1.0d+0
              t58 = 1/t57
              t59 = gammabb**2
              t60 = 1/rhob**5.333333333333333d+0
              t61 = 1/t57**2
              t62 = t56-9.11559972d+0
              t63 = t62**2
              t64 = t31*t61*t63+gammabb*t29*t53*t61*t62+t34*t58*t62+t25*
     1           t59*t60*t61+gammabb*t33*t53*t58+t24
              t65 = rhob+rhoa
              t66 = 1/t65**3.333333333333333d-1
              t67 = 1.3256889990520176d-1*t66+1.0d+0
              t68 = rhoa-rhob
              t69 = t68**4
              t70 = 1/t65**4
              t71 = 1/t65
              t72 = 1.0d+0-t68*t71
              t73 = t68*t71+1.0d+0
              t74 = t73**1.3333333333333333d+0+t72**1.3333333333333333d+
     1           0-2.0d+0
              t75 = -1.923661050931536d+0*t69*t70*t74
              t76 = t75+1.0d+0
              t77 = 1/t65**6.666666666666666d-1
              t78 = t65**5.0d-1
              t79 = 1/t78
              t80 = 1/t65**1.6666666666666666d-1
              t81 = 5.982550435771079d+0*t80+8.004286349993635d-1*t79+1.
     1           8970043257475583d-1*t77+2.2255694211506874d+0*t66
              t82 = 1.6081979498692536d+1/t81+1.0d+0
              t83 = log(t82)
              t84 = -6.21814d-2*t67*t76*t83
              t85 = 6.901399211255825d-2*t66+1.0d+0
              t86 = t75+1.923661050931536d+0*t74
              t87 = 8.157414703487641d+0*t80+4.3009724712766434d-1*t79+1
     1           .9115125951273373d-1*t77+2.247591863577616d+0*t66
              t88 = 2.9608813203268075d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = 1.9751631321680768d-2*t85*t86*t89
              t91 = 1.274696188700087d-1*t66+1.0d+0
              t92 = 1.1120374863094686d+1*t80+1.644733775567609d+0*t79+2
     1           .4058712912881916d-1*t77+3.8447462374472113d+0*t66
              t93 = 3.216395899738507d+1/t92+1.0d+0
              t94 = log(t93)
              t95 = -5.980796863619711d-2*t69*t70*t74*t91*t94
              t96 = t65*(t95+t90+t84)-rhob*t49-rhoa*t14
              t97 = 3.04966d-3*(t56+t54+t21+t19-1.823119944d+1)+1.0d+0
              t98 = 1/t97
              t99 = param(4)
              t100 = t54+t19
              t101 = t100**2
              t102 = 1/t97**2
              t103 = param(5)
              t104 = t56+t21-1.823119944d+1
              t105 = param(6)
              t106 = t104**2
              t107 = param(2)
              t108 = param(3)
              t109 = t101*t102*t99+t104*t108*t98+t100*t107*t98+t102*t105
     1           *t106+t100*t102*t103*t104+param(1)
              t110 = 1/rhoa**3.6666666666666664d+0
              t111 = -3.3333333333333337d+0*t18*taua-2.6666666666666666d
     1           +0*gammaaa*t110
              t112 = 1/t22**3
              t113 = 1/rhoa**6.333333333333333d+0
              t114 = -3.3333333333333337d+0*t18*t23*t34*taua-6.666666666
     1           666667d+0*t18*t28*t30*t31*taua-3.3333333333333337d+0*ga
     2           mmaaa*t27*t28*t29*taua-5.15088d-3*t111*t28*t30*t34-5.15
     3           088d-3*gammaaa*t111*t18*t28*t33-2.6666666666666666d+0*g
     4           ammaaa*t110*t23*t33-1.030176d-2*t111*t112*t31*t32-2.666
     5           6666666666666d+0*gammaaa*t110*t28*t29*t30-1.030176d-2*g
     6           ammaaa*t111*t112*t18*t29*t30-5.333333333333333d+0*t113*
     7           t25*t26*t28-1.030176d-2*t111*t112*t25*t26*t27
              t115 = 1/t11
              t116 = 1/t2**3
              t117 = 1/rhoa**1.3333333333333333d+0
              t118 = 1/rhoa**1.1666666666666667d+0
              t119 = -1.264669550498372d-1*t20-9.970917392951799d-1*t118
     1           -7.418564737168958d-1*t117-4.002143174996817d-1*t116
              t120 = 1/t10**2
              t121 = 1/t7
              t122 = -1.6039141941921276d-1*t20-1.8533958105157808d+0*t1
     1           18-1.2815820791490704d+0*t117-8.223668877838045d-1*t116
              t123 = 1/t6**2
              t124 = 1.0d+0*t121*t122*t123*t9+1.3210398931339265d-3*t117
     1           *t8+1.1102230246251565d-16*t115*t119*t120*t13+3.0506411
     2           443514264d-19*t117*t12
              t125 = 1.0d+0*t14*t17*t35+1.0d+0*rhoa*t124*t17*t35+1.0d+0*
     1           rhoa*t114*t14*t17
              t126 = 1/t97**3
              t127 = -3.3333333333333337d+0*t108*t18*t98*taua-6.66666666
     1           6666667d+0*t102*t104*t105*t18*taua-3.3333333333333337d+
     2           0*t100*t102*t103*t18*taua-6.09932d-3*t101*t111*t126*t99
     3           -5.333333333333333d+0*gammaaa*t100*t102*t110*t99-2.6666
     4           666666666666d+0*gammaaa*t107*t110*t98-6.09932d-3*t105*t
     5           106*t111*t126-6.09932d-3*t100*t103*t104*t111*t126-3.049
     6           66d-3*t102*t104*t108*t111-3.04966d-3*t100*t102*t107*t11
     7           1-2.6666666666666666d+0*gammaaa*t102*t103*t104*t110
              t128 = 1/t65**1.6666666666666669d+0
              t129 = 1/t78**3
              t130 = 1/t65**1.3333333333333333d+0
              t131 = 1/t65**1.1666666666666667d+0
              t132 = -9.970917392951799d-1*t131-7.418564737168958d-1*t13
     1           0-4.002143174996817d-1*t129-1.264669550498372d-1*t128
              t133 = 1/t81**2
              t134 = 1/t82
              t135 = 1.0d+0*t132*t133*t134*t67*t76
              t136 = -1.3595691172479402d+0*t131-7.491972878592053d-1*t1
     1           30-2.1504862356383217d-1*t129-1.2743417300848914d-1*t12
     2           8
              t137 = 1/t87**2
              t138 = 1/t88
              t139 = -5.848223622634647d-1*t136*t137*t138*t85*t86
              t140 = -1.8533958105157808d+0*t131-1.2815820791490704d+0*t
     1           130-8.223668877838045d-1*t129-1.6039141941921276d-1*t12
     2           8
              t141 = 1/t92**2
              t142 = 1/t93
              t143 = 1.923661050931536d+0*t140*t141*t142*t69*t70*t74*t91
              t144 = 1/t65**2
              t145 = t144*t68
              t146 = -t71
              t147 = t146+t145
              t148 = t72**3.333333333333333d-1
              t149 = -t144*t68
              t150 = t71+t149
              t151 = t73**3.333333333333333d-1
              t152 = 1.3333333333333333d+0*t150*t151+1.3333333333333333d
     1           +0*t147*t148
              t153 = -1.923661050931536d+0*t152*t69*t70
              t154 = 1/t65**5
              t155 = 7.694644203726144d+0*t154*t69*t74
              t156 = t68**3
              t157 = -7.694644203726144d+0*t156*t70*t74
              t158 = t157+t155+t153
              t159 = -6.21814d-2*t158*t67*t83
              t160 = 2.747773264188437d-3*t130*t76*t83
              t161 = t157+t155+t153+1.923661050931536d+0*t152
              t162 = 1.9751631321680768d-2*t161*t85*t89
              t163 = -4.5437964274821163d-4*t130*t86*t89
              t164 = -5.980796863619711d-2*t152*t69*t70*t91*t94
              t165 = 1/t65**5.333333333333333d+0
              t166 = 2.541232989148493d-3*t165*t69*t74*t94
              t167 = 2.3923187454478842d-1*t154*t69*t74*t91*t94
              t168 = t95+t65*(-2.3923187454478842d-1*t156*t70*t74*t91*t9
     1           4+t167+t166+t164+t163+t162+t160+t159+t143+t139+t135)+t9
     2           0+3.1090699999999993d-2*t8*t9+t84+6.903522198342671d-18
     3           *t12*t13-rhoa*t124
              t169 = 1.0d+0*t127*t96+1.0d+0*t109*t168
              t170 = 1/rhob**3.6666666666666664d+0
              t171 = -3.3333333333333337d+0*t53*taub-2.6666666666666666d
     1           +0*gammabb*t170
              t172 = 1/t57**3
              t173 = 1/rhob**6.333333333333333d+0
              t174 = -6.666666666666667d+0*t31*t53*t61*t62*taub-3.333333
     1           3333333337d+0*gammabb*t29*t60*t61*taub-3.33333333333333
     2           37d+0*t34*t53*t58*taub-1.030176d-2*t171*t172*t31*t63-5.
     3           15088d-3*t171*t34*t61*t62-2.6666666666666666d+0*gammabb
     4           *t170*t29*t61*t62-1.030176d-2*gammabb*t171*t172*t29*t53
     5           *t62-5.333333333333333d+0*t173*t25*t59*t61-5.15088d-3*g
     6           ammabb*t171*t33*t53*t61-1.030176d-2*t171*t172*t25*t59*t
     7           60-2.6666666666666666d+0*gammabb*t170*t33*t58
              t175 = 1/t46
              t176 = 1/t37**3
              t177 = 1/rhob**1.3333333333333333d+0
              t178 = 1/rhob**1.1666666666666667d+0
              t179 = -1.264669550498372d-1*t55-9.970917392951799d-1*t178
     1           -7.418564737168958d-1*t177-4.002143174996817d-1*t176
              t180 = 1/t45**2
              t181 = 1/t42
              t182 = -1.6039141941921276d-1*t55-1.8533958105157808d+0*t1
     1           78-1.2815820791490704d+0*t177-8.223668877838045d-1*t176
              t183 = 1/t41**2
              t184 = 1.1102230246251565d-16*t175*t179*t180*t48+3.0506411
     1           443514264d-19*t177*t47+1.0d+0*t181*t182*t183*t44+1.3210
     2           398931339265d-3*t177*t43
              t185 = 1.0d+0*t49*t52*t64+1.0d+0*rhob*t184*t52*t64+1.0d+0*
     1           rhob*t174*t49*t52
              t186 = -3.3333333333333337d+0*t108*t53*t98*taub-6.66666666
     1           6666667d+0*t102*t104*t105*t53*taub-3.3333333333333337d+
     2           0*t100*t102*t103*t53*taub-6.09932d-3*t101*t126*t171*t99
     3           -5.333333333333333d+0*gammabb*t100*t102*t170*t99-2.6666
     4           666666666666d+0*gammabb*t107*t170*t98-6.09932d-3*t105*t
     5           106*t126*t171-6.09932d-3*t100*t103*t104*t126*t171-3.049
     6           66d-3*t102*t104*t108*t171-3.04966d-3*t100*t102*t107*t17
     7           1-2.6666666666666666d+0*gammabb*t102*t103*t104*t170
              t187 = t71+t145
              t188 = t149+t146
              t189 = 1.3333333333333333d+0*t151*t188+1.3333333333333333d
     1           +0*t148*t187
              t190 = -1.923661050931536d+0*t189*t69*t70
              t191 = 7.694644203726144d+0*t156*t70*t74
              t192 = t191+t190+t155
              t193 = -6.21814d-2*t192*t67*t83
              t194 = t191+t190+1.923661050931536d+0*t189+t155
              t195 = 1.9751631321680768d-2*t194*t85*t89
              t196 = -5.980796863619711d-2*t189*t69*t70*t91*t94
              t197 = t95+t65*(2.3923187454478842d-1*t156*t70*t74*t91*t94
     1           +t196+t195+t193+t167+t166+t163+t160+t143+t139+t135)+t90
     2           +t84+6.903522198342671d-18*t47*t48+3.1090699999999993d-
     3           2*t43*t44-rhob*t184
              t198 = 1.0d+0*t186*t96+1.0d+0*t109*t197
              t199 = 1/rhoa**8
              t200 = -5.15088d-3*t18*t28*t30*t34-5.15088d-3*gammaaa*t27*
     1           t28*t33+t18*t23*t33-1.030176d-2*t112*t18*t31*t32+t18*t2
     2           8*t29*t30-1.030176d-2*gammaaa*t112*t27*t29*t30+2*gammaa
     3           a*t25*t27*t28-1.030176d-2*t112*t199*t25*t26
              t201 = -6.09932d-3*t101*t126*t18*t99+2*t100*t102*t18*t99+t
     1           107*t18*t98-6.09932d-3*t105*t106*t126*t18-6.09932d-3*t1
     2           00*t103*t104*t126*t18-3.04966d-3*t102*t104*t108*t18-3.0
     3           4966d-3*t100*t102*t107*t18+t102*t103*t104*t18
              t202 = 1/rhob**8
              t203 = -1.030176d-2*t172*t31*t53*t63-5.15088d-3*t34*t53*t6
     1           1*t62+t29*t53*t61*t62-1.030176d-2*gammabb*t172*t29*t60*
     2           t62-5.15088d-3*gammabb*t33*t60*t61+2*gammabb*t25*t60*t6
     3           1-1.030176d-2*t172*t202*t25*t59+t33*t53*t58
              t204 = -6.09932d-3*t101*t126*t53*t99+2*t100*t102*t53*t99+t
     1           107*t53*t98-6.09932d-3*t105*t106*t126*t53-6.09932d-3*t1
     2           00*t103*t104*t126*t53-3.04966d-3*t102*t104*t108*t53-3.0
     3           4966d-3*t100*t102*t107*t53+t102*t103*t104*t53
              t205 = 1/rhoa**7
              t206 = 1/rhoa**4.333333333333333d+0
              t207 = -1.030176d-2*t20*t28*t30*t34+2.0d+0*t20*t23*t34-1.0
     1           30176d-2*gammaaa*t206*t28*t33-2.060352d-2*t112*t20*t31*
     2           t32+4.0d+0*t20*t28*t30*t31-2.060352d-2*gammaaa*t112*t20
     3           6*t29*t30+2.0d+0*gammaaa*t206*t28*t29-2.060352d-2*t112*
     4           t205*t25*t26
              t208 = taua**2
              t209 = 1/t208
              t210 = -1.219864d-2*t101*t126*t20*t99+2.0d+0*t108*t20*t98-
     1           1.219864d-2*t105*t106*t126*t20-1.219864d-2*t100*t103*t1
     2           04*t126*t20-6.09932d-3*t102*t104*t108*t20-6.09932d-3*t1
     3           00*t102*t107*t20+4.0d+0*t102*t104*t105*t20+2.0d+0*t100*
     4           t102*t103*t20
              t211 = 1/rhob**7
              t212 = 1/rhob**4.333333333333333d+0
              t213 = -2.060352d-2*t172*t31*t55*t63-1.030176d-2*t34*t55*t
     1           61*t62+4.0d+0*t31*t55*t61*t62-2.060352d-2*gammabb*t172*
     2           t212*t29*t62-1.030176d-2*gammabb*t212*t33*t61+2.0d+0*ga
     3           mmabb*t212*t29*t61-2.060352d-2*t172*t211*t25*t59+2.0d+0
     4           *t34*t55*t58
              t214 = taub**2
              t215 = 1/t214
              t216 = -1.219864d-2*t101*t126*t55*t99+2.0d+0*t108*t55*t98-
     1           1.219864d-2*t105*t106*t126*t55-1.219864d-2*t100*t103*t1
     2           04*t126*t55-6.09932d-3*t102*t104*t108*t55-6.09932d-3*t1
     3           00*t102*t107*t55+4.0d+0*t102*t104*t105*t55+2.0d+0*t100*
     4           t102*t103*t55
              t217 = t111**2
              t218 = 1/rhoa**2
              t219 = 1.25d-1*gammaaa*t124*t35+1.25d-1*gammaaa*t114*t14
              t220 = 1/t22**4
              t221 = 1/rhoa**4.666666666666667d+0
              t222 = 8.88888888888889d+0*t110*taua+9.777777777777779d+0*
     1           gammaaa*t221
              t223 = 1/rhoa**7.333333333333333d+0
              t224 = 3.4339200000000003d-2*t111*t18*t28*t34*taua+8.88888
     1           888888889d+0*t110*t23*t34*taua+1.7777777777777778d+1*t1
     2           10*t28*t30*t31*taua+1.373568d-1*t111*t112*t18*t30*t31*t
     3           aua+2.6666666666666666d+1*gammaaa*t113*t28*t29*taua+6.8
     4           67840000000001d-2*gammaaa*t111*t112*t27*t29*taua-5.1508
     5           8d-3*t222*t28*t30*t34+5.30631295488d-5*t112*t217*t30*t3
     6           4-5.15088d-3*gammaaa*t18*t222*t28*t33+2.747136d-2*gamma
     7           aa*t110*t111*t28*t33+9.777777777777779d+0*gammaaa*t221*
     8           t23*t33+5.30631295488d-5*gammaaa*t112*t18*t217*t33-1.03
     9           0176d-2*t112*t222*t31*t32+1.591893886464d-4*t217*t220*t
     :           31*t32+2.2222222222222224d+1*t208*t27*t28*t31+9.7777777
     ;           77777779d+0*gammaaa*t221*t28*t29*t30-1.030176d-2*gammaa
     <           a*t112*t18*t222*t29*t30+1.591893886464d-4*gammaaa*t18*t
     =           217*t220*t29*t30+5.494272d-2*gammaaa*t110*t111*t112*t29
     >           *t30+3.377777777777778d+1*t223*t25*t26*t28-1.030176d-2*
     ?           t112*t222*t25*t26*t27+1.591893886464d-4*t217*t220*t25*t
     @           26*t27+1.0988544d-1*t111*t112*t113*t25*t26
              t225 = 1/t11**2
              t226 = t119**2
              t227 = 1/t10**4
              t228 = 1/t10**3
              t229 = 1/t2**5
              t230 = 1/rhoa**2.3333333333333334d+0
              t231 = 1/rhoa**2.1666666666666665d+0
              t232 = 1.1632736958443765d+0*t231+9.89141964955861d-1*t230
     1           +6.003214762495226d-1*t229+2.1077825841639536d-1*t18
              t233 = 1/t7**2
              t234 = t122**2
              t235 = 1/t6**4
              t236 = 1/t6**3
              t237 = 2.1622951122684114d+0*t231+1.7087761055320938d+0*t2
     1           30+1.2335503316757068d+0*t229+2.673190323653546d-1*t18
              t238 = 1.0d+0*t121*t123*t237*t9-2.0d+0*t121*t234*t236*t9+3
     1           .216395899738507d+1*t233*t234*t235*t9-1.761386524178568
     2           4d-3*t230*t8+1.1102230246251565d-16*t115*t120*t13*t232-
     3           4.0675215258019015d-19*t12*t230-2.220446049250313d-16*t
     4           115*t13*t226*t228+1.7854583920998188d-15*t13*t225*t226*
     5           t227-8.497974591333913d-2*t117*t121*t122*t123-9.8120696
     6           68265515d-18*t115*t117*t119*t120
              t239 = 1.0d+0*rhoa*t17*t238*t35+1.25d-1*gammaaa*t14*t16*t2
     1           18*t35+2.0d+0*t124*t17*t35+1.25d-1*gammaaa*t124*t15*t16
     2           *t35+1.0d+0*rhoa*t14*t17*t224+2.0d+0*t114*t14*t17+2.0d+
     3           0*rhoa*t114*t124*t17+1.25d-1*gammaaa*t114*t14*t15*t16
              t240 = -5.15088d-3*rhoa*t14*t17*t222*t35-5.15088d-3*t111*t
     1           14*t17*t35-5.15088d-3*rhoa*t111*t124*t17*t35-5.15088d-3
     2           *rhoa*t111*t114*t14*t17-5.15088d-3*t111*t125
              t241 = 1/t97**4
              t242 = 8.88888888888889d+0*t108*t110*t98*taua+8.1324266666
     1           66668d-2*t104*t105*t111*t126*t18*taua+4.066213333333334
     2           d-2*t100*t103*t111*t126*t18*taua+2.033106666666667d-2*t
     3           102*t108*t111*t18*taua+1.7777777777777778d+1*gammaaa*t1
     4           02*t103*t113*taua+1.7777777777777778d+1*t102*t104*t105*
     5           t110*taua+8.88888888888889d+0*t100*t102*t103*t110*taua+
     6           1.4222222222222222d+1*t102*t223*t26*t99+5.5802556693600
     7           01d-5*t101*t217*t241*t99-6.09932d-3*t101*t126*t222*t99+
     8           1.9555555555555557d+1*gammaaa*t100*t102*t221*t99+6.5059
     9           41333333333d-2*gammaaa*t100*t110*t111*t126*t99+9.777777
     :           777777779d+0*gammaaa*t107*t221*t98+2.2222222222222224d+
     ;           1*t102*t105*t208*t27+5.580255669360001d-5*t105*t106*t21
     <           7*t241+5.580255669360001d-5*t100*t103*t104*t217*t241-6.
     =           09932d-3*t105*t106*t126*t222-6.09932d-3*t100*t103*t104*
     >           t126*t222-3.04966d-3*t102*t104*t108*t222-3.04966d-3*t10
     ?           0*t102*t107*t222+9.777777777777779d+0*gammaaa*t102*t103
     @           *t104*t221+1.86008522312d-5*t104*t108*t126*t217+1.86008
     1           522312d-5*t100*t107*t126*t217+3.2529706666666663d-2*gam
     2           maaa*t103*t104*t110*t111*t126+1.6264853333333332d-2*gam
     3           maaa*t102*t107*t110*t111
              t243 = 2.0d+0*t132*t133*t134*t67*t76
              t244 = -1.1696447245269295d+0*t136*t137*t138*t85*t86
              t245 = 3.847322101863072d+0*t140*t141*t142*t69*t70*t74*t91
              t246 = 5.495546528376875d-3*t130*t76*t83
              t247 = -9.087592854964233d-4*t130*t86*t89
              t248 = 5.082465978296986d-3*t165*t69*t74*t94
              t249 = 4.7846374908957684d-1*t154*t69*t74*t91*t94
              t250 = t132**2
              t251 = 1/t81**4
              t252 = 1/t82**2
              t253 = 1.6081979498692536d+1*t250*t251*t252*t67*t76
              t254 = 2.0d+0*t132*t133*t134*t158*t67
              t255 = 1/t81**3
              t256 = -2.0d+0*t134*t250*t255*t67*t76
              t257 = -8.837926660346784d-2*t130*t132*t133*t134*t76
              t258 = 1/t65**2.6666666666666666d+0
              t259 = 1/t78**5
              t260 = 1/t65**2.3333333333333334d+0
              t261 = 1/t65**2.1666666666666665d+0
              t262 = 1.1632736958443765d+0*t261+9.89141964955861d-1*t260
     1           +6.003214762495226d-1*t259+2.1077825841639536d-1*t258
              t263 = 1.0d+0*t133*t134*t262*t67*t76
              t264 = t136**2
              t265 = 1/t87**4
              t266 = 1/t88**2
              t267 = -1.73158960813529d+1*t264*t265*t266*t85*t86
              t268 = -1.1696447245269295d+0*t136*t137*t138*t161*t85
              t269 = 1/t87**3
              t270 = 1.1696447245269295d+0*t138*t264*t269*t85*t86
              t271 = 2.690728393099896d-2*t130*t136*t137*t138*t86
              t272 = 1.5861639701225969d+0*t261+9.98929717145607d-1*t260
     1           +3.2257293534574827d-1*t259+2.1239028834748191d-1*t258
              t273 = -5.848223622634647d-1*t137*t138*t272*t85*t86
              t274 = t140**2
              t275 = 1/t92**4
              t276 = 1/t93**2
              t277 = 6.187255516702861d+1*t274*t275*t276*t69*t70*t74*t91
              t278 = 3.847322101863072d+0*t140*t141*t142*t152*t69*t70*t9
     1           1
              t279 = 1/t92**3
              t280 = -3.847322101863072d+0*t142*t274*t279*t69*t70*t74*t9
     1           1
              t281 = -1.6347222733154887d-1*t140*t141*t142*t165*t69*t74
              t282 = 2.1622951122684114d+0*t261+1.7087761055320938d+0*t2
     1           60+1.2335503316757068d+0*t259+2.673190323653546d-1*t258
              t283 = 1.923661050931536d+0*t141*t142*t282*t69*t70*t74*t91
              t284 = -1.538928840745229d+1*t140*t141*t142*t154*t69*t74*t
     1           91
              t285 = 1.538928840745229d+1*t140*t141*t142*t156*t70*t74*t9
     1           1
              t286 = t147**2
              t287 = 1/t72**6.666666666666666d-1
              t288 = 1/t65**3
              t289 = -2*t288*t68
              t290 = 2*t144
              t291 = t290+t289
              t292 = t150**2
              t293 = 1/t73**6.666666666666666d-1
              t294 = 2*t288*t68
              t295 = -2*t144
              t296 = t295+t294
              t297 = 1.3333333333333333d+0*t151*t296+4.444444444444444d-
     1           1*t292*t293+1.3333333333333333d+0*t148*t291+4.444444444
     2           444444d-1*t286*t287
              t298 = -1.923661050931536d+0*t297*t69*t70
              t299 = 1.5389288407452287d+1*t152*t154*t69
              t300 = -1.5389288407452287d+1*t152*t156*t70
              t301 = 1/t65**6
              t302 = -3.8473221018630716d+1*t301*t69*t74
              t303 = 6.155715362980915d+1*t154*t156*t74
              t304 = t68**2
              t305 = -2.3083932611178434d+1*t304*t70*t74
              t306 = t305+t303+t302+t300+t299+t298
              t307 = -6.21814d-2*t306*t67*t83
              t308 = 5.495546528376875d-3*t130*t158*t83
              t309 = -3.663697685584583d-3*t260*t76*t83
              t310 = t305+t303+t302+t300+t299+t298+1.923661050931536d+0*
     1           t297
              t311 = 1.9751631321680768d-2*t310*t85*t89
              t312 = -9.087592854964233d-4*t130*t161*t89
              t313 = 6.058395236642822d-4*t260*t86*t89
              t314 = -5.980796863619711d-2*t297*t69*t70*t91*t94
              t315 = 5.082465978296986d-3*t152*t165*t69*t94
              t316 = 4.7846374908957684d-1*t152*t154*t69*t91*t94
              t317 = 1/t65**6.333333333333333d+0
              t318 = -2.3718174565385935d-2*t317*t69*t74*t94
              t319 = 2.0329863913187946d-2*t156*t165*t74*t94
              t320 = -1.1961593727239421d+0*t301*t69*t74*t91*t94
              t321 = 1.9138549963583074d+0*t154*t156*t74*t91*t94
              t322 = -7.176956236343652d-1*t304*t70*t74*t91*t94
              t323 = t65*(-4.7846374908957684d-1*t152*t156*t70*t91*t94+t
     1           322+t321+t320+t319+t318+t316+t315+t314+t313+t312+t311+t
     2           309+t308+t307+t285+t284+t283+t281+t280+t278+t277+t273+t
     3           271+t270+t268+t267+t263+t257+t256+t254+t253)-4.78463749
     4           08957684d-1*t156*t70*t74*t91*t94-1.1961593727239421d-1*
     5           t152*t69*t70*t91*t94-2.0d+0*t121*t122*t123*t9+3.9503262
     6           643361536d-2*t161*t85*t89-1.243628d-1*t158*t67*t83-2.64
     7           2079786267853d-3*t117*t8+t249+t248+t247+t246+t245+t244+
     8           t243-rhoa*t238-2.220446049250313d-16*t115*t119*t120*t13
     9           -6.101282288702853d-19*t117*t12
              t324 = 1.0d+0*t242*t96+1.0d+0*t109*t323+2.0d+0*t127*t168
              t325 = -3.04966d-3*t109*t222*t96-3.04966d-3*t111*t127*t96-
     1           3.04966d-3*t111*t169-3.04966d-3*t109*t111*t168
              t326 = 2.2222222222222224d+1*t102*t105*t18*t53*taua*taub+4
     1           .066213333333334d-2*t104*t105*t111*t126*t53*taub+2.0331
     2           06666666667d-2*t100*t103*t111*t126*t53*taub+1.016553333
     3           3333335d-2*t102*t108*t111*t53*taub+8.88888888888889d+0*
     4           gammaaa*t102*t103*t110*t53*taub+4.066213333333334d-2*t1
     5           04*t105*t126*t171*t18*taua+2.033106666666667d-2*t100*t1
     6           03*t126*t171*t18*taua+1.0165533333333335d-2*t102*t108*t
     7           171*t18*taua+8.88888888888889d+0*gammabb*t102*t103*t170
     8           *t18*taua+5.580255669360001d-5*t101*t111*t171*t241*t99+
     9           3.2529706666666663d-2*gammaaa*t100*t110*t126*t171*t99+3
     :           .2529706666666663d-2*gammabb*t100*t111*t126*t170*t99+1.
     ;           4222222222222222d+1*gammaaa*gammabb*t102*t110*t170*t99+
     <           5.580255669360001d-5*t105*t106*t111*t171*t241+5.5802556
     =           69360001d-5*t100*t103*t104*t111*t171*t241+1.86008522312
     >           d-5*t104*t108*t111*t126*t171+1.86008522312d-5*t100*t107
     ?           *t111*t126*t171+1.6264853333333332d-2*gammaaa*t103*t104
     @           *t110*t126*t171+8.132426666666667d-3*gammaaa*t102*t107*
     1           t110*t171+1.6264853333333332d-2*gammabb*t103*t104*t111*
     2           t126*t170+8.132426666666667d-3*gammabb*t102*t107*t111*t
     3           170
              t327 = 2.6666666666666666d+0*t151*t288*t68-2.6666666666666
     1           666d+0*t148*t288*t68+4.444444444444444d-1*t150*t188*t29
     2           3+4.444444444444444d-1*t147*t187*t287
              t328 = -1.923661050931536d+0*t327*t69*t70
              t329 = 7.694644203726144d+0*t154*t189*t69
              t330 = -7.694644203726144d+0*t156*t189*t70
              t331 = 7.694644203726144d+0*t152*t154*t69
              t332 = 7.694644203726144d+0*t152*t156*t70
              t333 = 2.3083932611178434d+1*t304*t70*t74
              t334 = t333+t332+t331+t330+t329+t328+t302
              t335 = t333+t332+t331+t330+t329+t328+1.923661050931536d+0*
     1           t327+t302
              t336 = 7.176956236343652d-1*t304*t70*t74*t91*t94
              t337 = t65*(-5.980796863619711d-2*t327*t69*t70*t91*t94-2.3
     1           923187454478842d-1*t156*t189*t70*t91*t94+2.392318745447
     2           8842d-1*t152*t156*t70*t91*t94+2.3923187454478842d-1*t15
     3           4*t189*t69*t91*t94+2.3923187454478842d-1*t152*t154*t69*
     4           t91*t94+2.541232989148493d-3*t165*t189*t69*t94+2.541232
     5           989148493d-3*t152*t165*t69*t94+1.923661050931536d+0*t14
     6           0*t141*t142*t189*t69*t70*t91+1.923661050931536d+0*t140*
     7           t141*t142*t152*t69*t70*t91+1.9751631321680768d-2*t335*t
     8           85*t89-4.5437964274821163d-4*t130*t194*t89-4.5437964274
     9           821163d-4*t130*t161*t89-5.848223622634647d-1*t136*t137*
     :           t138*t194*t85-5.848223622634647d-1*t136*t137*t138*t161*
     ;           t85-6.21814d-2*t334*t67*t83+2.747773264188437d-3*t130*t
     <           192*t83+2.747773264188437d-3*t130*t158*t83+1.0d+0*t132*
     =           t133*t134*t192*t67+1.0d+0*t132*t133*t134*t158*t67+t336+
     >           t320+t318+t313+t309+t284+t283+t281+t280+t277+t273+t271+
     ?           t270+t267+t263+t257+t256+t253)+t249+t248+t247+t246+t245
     @           +t244+t243+t196+t195+t193+t164+t162+t159
              t338 = 1.0d+0*t326*t96+1.0d+0*t109*t337+1.0d+0*t127*t197+1
     1           .0d+0*t168*t186
              t339 = -3.04966d-3*t111*t186*t96-3.04966d-3*t109*t111*t197
     1           -3.04966d-3*t169*t171
              t340 = t171**2
              t341 = 1/rhob**2
              t342 = 1.25d-1*gammabb*t184*t64+1.25d-1*gammabb*t174*t49
              t343 = 1/t57**4
              t344 = 1/rhob**4.666666666666667d+0
              t345 = 8.88888888888889d+0*t170*taub+9.777777777777779d+0*
     1           gammabb*t344
              t346 = 1/rhob**7.333333333333333d+0
              t347 = 1.7777777777777778d+1*t170*t31*t61*t62*taub+1.37356
     1           8d-1*t171*t172*t31*t53*t62*taub+3.4339200000000003d-2*t
     2           171*t34*t53*t61*taub+2.6666666666666666d+1*gammabb*t173
     3           *t29*t61*taub+6.867840000000001d-2*gammabb*t171*t172*t2
     4           9*t60*taub+8.88888888888889d+0*t170*t34*t58*taub-1.0301
     5           76d-2*t172*t31*t345*t63+1.591893886464d-4*t31*t340*t343
     6           *t63-5.15088d-3*t34*t345*t61*t62+9.777777777777779d+0*g
     7           ammabb*t29*t344*t61*t62-1.030176d-2*gammabb*t172*t29*t3
     8           45*t53*t62+1.591893886464d-4*gammabb*t29*t340*t343*t53*
     9           t62+5.30631295488d-5*t172*t34*t340*t62+5.494272d-2*gamm
     :           abb*t170*t171*t172*t29*t62+2.2222222222222224d+1*t214*t
     ;           31*t60*t61+3.377777777777778d+1*t25*t346*t59*t61-5.1508
     <           8d-3*gammabb*t33*t345*t53*t61+2.747136d-2*gammabb*t170*
     =           t171*t33*t61-1.030176d-2*t172*t25*t345*t59*t60+1.591893
     >           886464d-4*t25*t340*t343*t59*t60+1.0988544d-1*t171*t172*
     ?           t173*t25*t59+9.777777777777779d+0*gammabb*t33*t344*t58+
     @           5.30631295488d-5*gammabb*t172*t33*t340*t53
              t348 = 1/t46**2
              t349 = t179**2
              t350 = 1/t45**4
              t351 = 1/t45**3
              t352 = 1/t37**5
              t353 = 1/rhob**2.3333333333333334d+0
              t354 = 1/rhob**2.1666666666666665d+0
              t355 = 2.1077825841639536d-1*t53+1.1632736958443765d+0*t35
     1           4+9.89141964955861d-1*t353+6.003214762495226d-1*t352
              t356 = 1/t42**2
              t357 = t182**2
              t358 = 1/t41**4
              t359 = 1/t41**3
              t360 = 2.673190323653546d-1*t53+2.1622951122684114d+0*t354
     1           +1.7087761055320938d+0*t353+1.2335503316757068d+0*t352
              t361 = 1.1102230246251565d-16*t175*t180*t355*t48-2.2204460
     1           49250313d-16*t175*t349*t351*t48+1.7854583920998188d-15*
     2           t348*t349*t350*t48-4.0675215258019015d-19*t353*t47+1.0d
     3           +0*t181*t183*t360*t44-2.0d+0*t181*t357*t359*t44+3.21639
     4           5899738507d+1*t356*t357*t358*t44-1.7613865241785684d-3*
     5           t353*t43-8.497974591333913d-2*t177*t181*t182*t183-9.812
     6           069668265515d-18*t175*t177*t179*t180
              t362 = 1.0d+0*rhob*t361*t52*t64+2.0d+0*t184*t52*t64+1.25d-
     1           1*gammabb*t184*t50*t51*t64+1.25d-1*gammabb*t341*t49*t51
     2           *t64+1.0d+0*rhob*t347*t49*t52+2.0d+0*t174*t49*t52+2.0d+
     3           0*rhob*t174*t184*t52+1.25d-1*gammabb*t174*t49*t50*t51
              t363 = -5.15088d-3*rhob*t345*t49*t52*t64-5.15088d-3*t171*t
     1           49*t52*t64-5.15088d-3*rhob*t171*t184*t52*t64-5.15088d-3
     2           *rhob*t171*t174*t49*t52-5.15088d-3*t171*t185
              t364 = 8.88888888888889d+0*t108*t170*t98*taub+8.1324266666
     1           66668d-2*t104*t105*t126*t171*t53*taub+4.066213333333334
     2           d-2*t100*t103*t126*t171*t53*taub+2.033106666666667d-2*t
     3           102*t108*t171*t53*taub+1.7777777777777778d+1*gammabb*t1
     4           02*t103*t173*taub+1.7777777777777778d+1*t102*t104*t105*
     5           t170*taub+8.88888888888889d+0*t100*t102*t103*t170*taub+
     6           1.4222222222222222d+1*t102*t346*t59*t99-6.09932d-3*t101
     7           *t126*t345*t99+1.9555555555555557d+1*gammabb*t100*t102*
     8           t344*t99+5.580255669360001d-5*t101*t241*t340*t99+6.5059
     9           41333333333d-2*gammabb*t100*t126*t170*t171*t99+9.777777
     :           777777779d+0*gammabb*t107*t344*t98+2.2222222222222224d+
     ;           1*t102*t105*t214*t60-6.09932d-3*t105*t106*t126*t345-6.0
     <           9932d-3*t100*t103*t104*t126*t345-3.04966d-3*t102*t104*t
     =           108*t345-3.04966d-3*t100*t102*t107*t345+9.7777777777777
     >           79d+0*gammabb*t102*t103*t104*t344+5.580255669360001d-5*
     ?           t105*t106*t241*t340+5.580255669360001d-5*t100*t103*t104
     @           *t241*t340+1.86008522312d-5*t104*t108*t126*t340+1.86008
     1           522312d-5*t100*t107*t126*t340+3.2529706666666663d-2*gam
     2           mabb*t103*t104*t126*t170*t171+1.6264853333333332d-2*gam
     3           mabb*t102*t107*t170*t171
              t365 = 2.0d+0*t132*t133*t134*t192*t67
              t366 = -1.1696447245269295d+0*t136*t137*t138*t194*t85
              t367 = 3.847322101863072d+0*t140*t141*t142*t189*t69*t70*t9
     1           1
              t368 = -1.538928840745229d+1*t140*t141*t142*t156*t70*t74*t
     1           91
              t369 = t187**2
              t370 = t295+t289
              t371 = t188**2
              t372 = t294+t290
              t373 = 1.3333333333333333d+0*t151*t372+4.444444444444444d-
     1           1*t293*t371+1.3333333333333333d+0*t148*t370+4.444444444
     2           444444d-1*t287*t369
              t374 = -1.923661050931536d+0*t373*t69*t70
              t375 = 1.5389288407452287d+1*t154*t189*t69
              t376 = 1.5389288407452287d+1*t156*t189*t70
              t377 = -6.155715362980915d+1*t154*t156*t74
              t378 = t377+t376+t375+t374+t305+t302
              t379 = -6.21814d-2*t378*t67*t83
              t380 = 5.495546528376875d-3*t130*t192*t83
              t381 = t377+t376+t375+t374+1.923661050931536d+0*t373+t305+
     1           t302
              t382 = 1.9751631321680768d-2*t381*t85*t89
              t383 = -9.087592854964233d-4*t130*t194*t89
              t384 = -5.980796863619711d-2*t373*t69*t70*t91*t94
              t385 = 5.082465978296986d-3*t165*t189*t69*t94
              t386 = 4.7846374908957684d-1*t154*t189*t69*t91*t94
              t387 = -2.0329863913187946d-2*t156*t165*t74*t94
              t388 = -1.9138549963583074d+0*t154*t156*t74*t91*t94
              t389 = t65*(4.7846374908957684d-1*t156*t189*t70*t91*t94+t3
     1           88+t387+t386+t385+t384+t383+t382+t380+t379+t368+t367+t3
     2           66+t365+t322+t320+t318+t313+t309+t284+t283+t281+t280+t2
     3           77+t273+t271+t270+t267+t263+t257+t256+t253)+4.784637490
     4           8957684d-1*t156*t70*t74*t91*t94-1.1961593727239421d-1*t
     5           189*t69*t70*t91*t94+3.9503262643361536d-2*t194*t85*t89-
     6           1.243628d-1*t192*t67*t83-2.220446049250313d-16*t175*t17
     7           9*t180*t48-6.101282288702853d-19*t177*t47-2.0d+0*t181*t
     8           182*t183*t44-2.642079786267853d-3*t177*t43-rhob*t361+t2
     9           49+t248+t247+t246+t245+t244+t243
              t390 = 1.0d+0*t364*t96+1.0d+0*t109*t389+2.0d+0*t186*t197
              t391 = -3.04966d-3*t109*t345*t96-3.04966d-3*t171*t186*t96-
     1           3.04966d-3*t171*t198-3.04966d-3*t109*t171*t197
              t392 = 1.25d-1*t14*t35+1.25d-1*gammaaa*t14*t200
              t393 = 1/rhoa**9
              t394 = 1.7169600000000002d-2*t27*t28*t34*taua+6.8678400000
     1           00001d-2*t112*t27*t30*t31*taua-3.3333333333333337d+0*t2
     2           7*t28*t29*taua+3.4339200000000003d-2*gammaaa*t112*t199*
     3           t29*taua+8.241408d-2*t112*t25*t26*t393+1.373568d-2*t110
     4           *t28*t30*t34+5.30631295488d-5*t111*t112*t18*t30*t34-5.1
     5           5088d-3*t111*t18*t28*t33+2.747136d-2*gammaaa*t113*t28*t
     6           33+5.30631295488d-5*gammaaa*t111*t112*t27*t33-2.6666666
     7           666666666d+0*t110*t23*t33+1.591893886464d-4*t111*t18*t2
     8           20*t31*t32+2.747136d-2*t110*t112*t31*t32-2.666666666666
     9           6666d+0*t110*t28*t29*t30+1.591893886464d-4*gammaaa*t111
     :           *t220*t27*t29*t30-1.030176d-2*t111*t112*t18*t29*t30+5.4
     ;           94272d-2*gammaaa*t112*t113*t29*t30-1.0666666666666666d+
     <           1*gammaaa*t113*t25*t28-2.060352d-2*gammaaa*t111*t112*t2
     =           5*t27+1.591893886464d-4*t111*t199*t220*t25*t26
              t395 = 1.0d+0*rhoa*t14*t17*t394-1.25d-1*t14*t15*t16*t35-1.
     1           25d-1*t124*t16*t35+1.0d+0*t14*t17*t200+1.0d+0*rhoa*t124
     2           *t17*t200-1.25d-1*t114*t14*t16
              t396 = 1.373568d-2*t14*t17*t35-5.15088d-3*t125
              t397 = 4.066213333333334d-2*t104*t105*t126*t27*taua+2.0331
     1           06666666667d-2*t100*t103*t126*t27*taua+1.01655333333333
     2           35d-2*t102*t108*t27*taua-3.3333333333333337d+0*t102*t10
     3           3*t27*taua+5.580255669360001d-5*t101*t111*t18*t241*t99-
     4           1.219864d-2*t100*t111*t126*t18*t99+3.2529706666666663d-
     5           2*gammaaa*t100*t113*t126*t99+1.6264853333333332d-2*t101
     6           *t110*t126*t99-5.333333333333333d+0*gammaaa*t102*t113*t
     7           99-5.333333333333333d+0*t100*t102*t110*t99-2.6666666666
     8           666666d+0*t107*t110*t98+5.580255669360001d-5*t105*t106*
     9           t111*t18*t241+5.580255669360001d-5*t100*t103*t104*t111*
     :           t18*t241+1.86008522312d-5*t104*t108*t111*t126*t18+1.860
     ;           08522312d-5*t100*t107*t111*t126*t18-6.09932d-3*t103*t10
     <           4*t111*t126*t18-3.04966d-3*t102*t107*t111*t18+1.6264853
     =           333333332d-2*gammaaa*t103*t104*t113*t126+1.626485333333
     >           3332d-2*t105*t106*t110*t126+1.6264853333333332d-2*t100*
     ?           t103*t104*t110*t126+8.132426666666667d-3*gammaaa*t102*t
     @           107*t113+8.132426666666667d-3*t102*t104*t108*t110+8.132
     1           426666666667d-3*t100*t102*t107*t110-2.6666666666666666d
     2           +0*t102*t103*t104*t110
              t398 = 1.0d+0*t397*t96+1.0d+0*t168*t201
              t399 = 4.066213333333334d-2*t104*t105*t126*t18*t53*taua+2.
     1           033106666666667d-2*t100*t103*t126*t18*t53*taua+1.016553
     2           3333333335d-2*t102*t108*t18*t53*taua-3.3333333333333337
     3           d+0*t102*t103*t18*t53*taua+5.580255669360001d-5*t101*t1
     4           11*t241*t53*t99-1.219864d-2*t100*t111*t126*t53*t99+3.25
     5           29706666666663d-2*gammaaa*t100*t110*t126*t53*t99-5.3333
     6           33333333333d+0*gammaaa*t102*t110*t53*t99+5.580255669360
     7           001d-5*t105*t106*t111*t241*t53+5.580255669360001d-5*t10
     8           0*t103*t104*t111*t241*t53+1.86008522312d-5*t104*t108*t1
     9           11*t126*t53+1.86008522312d-5*t100*t107*t111*t126*t53-6.
     :           09932d-3*t103*t104*t111*t126*t53+1.6264853333333332d-2*
     ;           gammaaa*t103*t104*t110*t126*t53-3.04966d-3*t102*t107*t1
     <           11*t53+8.132426666666667d-3*gammaaa*t102*t107*t110*t53
              t400 = 1.0d+0*t399*t96+1.0d+0*t168*t204
              t401 = 4.066213333333334d-2*t104*t105*t126*t18*t53*taub+2.
     1           033106666666667d-2*t100*t103*t126*t18*t53*taub+1.016553
     2           3333333335d-2*t102*t108*t18*t53*taub-3.3333333333333337
     3           d+0*t102*t103*t18*t53*taub+5.580255669360001d-5*t101*t1
     4           71*t18*t241*t99-1.219864d-2*t100*t126*t171*t18*t99+3.25
     5           29706666666663d-2*gammabb*t100*t126*t170*t18*t99-5.3333
     6           33333333333d+0*gammabb*t102*t170*t18*t99+5.580255669360
     7           001d-5*t105*t106*t171*t18*t241+5.580255669360001d-5*t10
     8           0*t103*t104*t171*t18*t241+1.86008522312d-5*t104*t108*t1
     9           26*t171*t18+1.86008522312d-5*t100*t107*t126*t171*t18-6.
     :           09932d-3*t103*t104*t126*t171*t18-3.04966d-3*t102*t107*t
     ;           171*t18+1.6264853333333332d-2*gammabb*t103*t104*t126*t1
     <           70*t18+8.132426666666667d-3*gammabb*t102*t107*t170*t18
              t402 = 1.0d+0*t401*t96+1.0d+0*t197*t201
              t403 = 1.25d-1*t49*t64+1.25d-1*gammabb*t203*t49
              t404 = 1/rhob**9
              t405 = 6.867840000000001d-2*t172*t31*t60*t62*taub+1.716960
     1           0000000002d-2*t34*t60*t61*taub-3.3333333333333337d+0*t2
     2           9*t60*t61*taub+3.4339200000000003d-2*gammabb*t172*t202*
     3           t29*taub+1.591893886464d-4*t171*t31*t343*t53*t63+2.7471
     4           36d-2*t170*t172*t31*t63+1.373568d-2*t170*t34*t61*t62-2.
     5           6666666666666666d+0*t170*t29*t61*t62+1.591893886464d-4*
     6           gammabb*t171*t29*t343*t60*t62+5.30631295488d-5*t171*t17
     7           2*t34*t53*t62-1.030176d-2*t171*t172*t29*t53*t62+5.49427
     8           2d-2*gammabb*t172*t173*t29*t62-5.15088d-3*t171*t33*t53*
     9           t61+2.747136d-2*gammabb*t173*t33*t61-1.0666666666666666
     :           d+1*gammabb*t173*t25*t61+5.30631295488d-5*gammabb*t171*
     ;           t172*t33*t60-2.060352d-2*gammabb*t171*t172*t25*t60+8.24
     <           1408d-2*t172*t25*t404*t59+1.591893886464d-4*t171*t202*t
     =           25*t343*t59-2.6666666666666666d+0*t170*t33*t58
              t406 = -1.25d-1*t49*t50*t51*t64-1.25d-1*t184*t51*t64+1.0d+
     1           0*rhob*t405*t49*t52+1.0d+0*t203*t49*t52+1.0d+0*rhob*t18
     2           4*t203*t52-1.25d-1*t174*t49*t51
              t407 = 1.373568d-2*t49*t52*t64-5.15088d-3*t185
              t408 = 4.066213333333334d-2*t104*t105*t126*t60*taub+2.0331
     1           06666666667d-2*t100*t103*t126*t60*taub+1.01655333333333
     2           35d-2*t102*t108*t60*taub-3.3333333333333337d+0*t102*t10
     3           3*t60*taub+5.580255669360001d-5*t101*t171*t241*t53*t99-
     4           1.219864d-2*t100*t126*t171*t53*t99+3.2529706666666663d-
     5           2*gammabb*t100*t126*t173*t99-5.333333333333333d+0*gamma
     6           bb*t102*t173*t99+1.6264853333333332d-2*t101*t126*t170*t
     7           99-5.333333333333333d+0*t100*t102*t170*t99-2.6666666666
     8           666666d+0*t107*t170*t98+5.580255669360001d-5*t105*t106*
     9           t171*t241*t53+5.580255669360001d-5*t100*t103*t104*t171*
     :           t241*t53+1.86008522312d-5*t104*t108*t126*t171*t53+1.860
     ;           08522312d-5*t100*t107*t126*t171*t53-6.09932d-3*t103*t10
     <           4*t126*t171*t53-3.04966d-3*t102*t107*t171*t53+1.6264853
     =           333333332d-2*gammabb*t103*t104*t126*t173+8.132426666666
     >           667d-3*gammabb*t102*t107*t173+1.6264853333333332d-2*t10
     ?           5*t106*t126*t170+1.6264853333333332d-2*t100*t103*t104*t
     @           126*t170+8.132426666666667d-3*t102*t104*t108*t170+8.132
     1           426666666667d-3*t100*t102*t107*t170-2.6666666666666666d
     2           +0*t102*t103*t104*t170
              t409 = 1.0d+0*t408*t96+1.0d+0*t197*t204
              t410 = 1/rhoa**1.0666666666666666d+1
              t411 = 1.591893886464d-4*t220*t25*t26*t410+5.30631295488d-
     1           5*t112*t27*t30*t34-1.030176d-2*t27*t28*t33+5.3063129548
     2           8d-5*gammaaa*t112*t199*t33+1.591893886464d-4*t220*t27*t
     3           31*t32-2.060352d-2*t112*t27*t29*t30+1.591893886464d-4*g
     4           ammaaa*t199*t220*t29*t30+2*t25*t27*t28-4.120704d-2*gamm
     5           aaa*t112*t199*t25
              t412 = 5.580255669360001d-5*t101*t241*t27*t99-2.439728d-2*
     1           t100*t126*t27*t99+2*t102*t27*t99+5.580255669360001d-5*t
     2           105*t106*t241*t27+5.580255669360001d-5*t100*t103*t104*t
     3           241*t27+1.86008522312d-5*t104*t108*t126*t27+1.860085223
     4           12d-5*t100*t107*t126*t27-1.219864d-2*t103*t104*t126*t27
     5           -6.09932d-3*t102*t107*t27
              t413 = 5.580255669360001d-5*t101*t18*t241*t53*t99-2.439728
     1           d-2*t100*t126*t18*t53*t99+2*t102*t18*t53*t99+5.58025566
     2           9360001d-5*t105*t106*t18*t241*t53+5.580255669360001d-5*
     3           t100*t103*t104*t18*t241*t53+1.86008522312d-5*t104*t108*
     4           t126*t18*t53+1.86008522312d-5*t100*t107*t126*t18*t53-1.
     5           219864d-2*t103*t104*t126*t18*t53-6.09932d-3*t102*t107*t
     6           18*t53
              t414 = 1/rhob**1.0666666666666666d+1
              t415 = 1.591893886464d-4*t31*t343*t60*t63+5.30631295488d-5
     1           *t172*t34*t60*t62-2.060352d-2*t172*t29*t60*t62+1.591893
     2           886464d-4*gammabb*t202*t29*t343*t62-1.030176d-2*t33*t60
     3           *t61+2*t25*t60*t61+1.591893886464d-4*t25*t343*t414*t59+
     4           5.30631295488d-5*gammabb*t172*t202*t33-4.120704d-2*gamm
     5           abb*t172*t202*t25
              t416 = 5.580255669360001d-5*t101*t241*t60*t99-2.439728d-2*
     1           t100*t126*t60*t99+2*t102*t60*t99+5.580255669360001d-5*t
     2           105*t106*t241*t60+5.580255669360001d-5*t100*t103*t104*t
     3           241*t60+1.86008522312d-5*t104*t108*t126*t60+1.860085223
     4           12d-5*t100*t107*t126*t60-1.219864d-2*t103*t104*t126*t60
     5           -6.09932d-3*t102*t107*t60
              t417 = 3.4339200000000003d-2*t206*t28*t34*taua+1.373568d-1
     1           *t112*t206*t30*t31*taua-1.3333333333333333d+1*t206*t28*
     2           t31*taua+6.867840000000001d-2*gammaaa*t112*t205*t29*tau
     3           a+1.7169600000000002d-2*t18*t28*t30*t34+1.061262590976d
     4           -4*t111*t112*t20*t30*t34-1.030176d-2*t111*t20*t28*t34-3
     5           .3333333333333337d+0*t18*t23*t34+4.464096d-2*gammaaa*t2
     6           7*t28*t33+1.061262590976d-4*gammaaa*t111*t112*t206*t33+
     7           3.183787772928d-4*t111*t20*t220*t31*t32+3.4339200000000
     8           003d-2*t112*t18*t31*t32-6.666666666666667d+0*t18*t28*t3
     9           0*t31-4.120704d-2*t111*t112*t20*t30*t31+8.928192d-2*gam
     :           maaa*t112*t27*t29*t30+3.183787772928d-4*gammaaa*t111*t2
     ;           06*t220*t29*t30-8.666666666666666d+0*gammaaa*t27*t28*t2
     <           9-2.060352d-2*gammaaa*t111*t112*t206*t29+3.183787772928
     =           d-4*t111*t205*t220*t25*t26+1.4422464000000002d-1*t112*t
     >           199*t25*t26
              t418 = 1.0d+0*rhoa*t14*t17*t417+1.25d-1*gammaaa*t14*t15*t2
     1           09*t35+1.25d-1*gammaaa*t124*t209*t35+1.25d-1*gammaaa*t1
     2           14*t14*t209+1.0d+0*t14*t17*t207+1.0d+0*rhoa*t124*t17*t2
     3           07
              t419 = 8.132426666666668d-2*t104*t105*t126*t206*taua+4.066
     1           213333333334d-2*t100*t103*t126*t206*taua+2.033106666666
     2           667d-2*t102*t108*t206*taua-1.3333333333333333d+1*t102*t
     3           105*t206*taua+6.505941333333333d-2*gammaaa*t100*t126*t2
     4           7*t99+1.1160511338720001d-4*t101*t111*t20*t241*t99+2.03
     5           3106666666667d-2*t101*t126*t18*t99-3.3333333333333337d+
     6           0*t108*t18*t98+3.2529706666666663d-2*gammaaa*t103*t104*
     7           t126*t27+1.6264853333333332d-2*gammaaa*t102*t107*t27-5.
     8           333333333333333d+0*gammaaa*t102*t103*t27+1.116051133872
     9           0001d-4*t105*t106*t111*t20*t241+1.1160511338720001d-4*t
     :           100*t103*t104*t111*t20*t241+3.72017044624d-5*t104*t108*
     ;           t111*t126*t20+3.72017044624d-5*t100*t107*t111*t126*t20-
     <           2.439728d-2*t104*t105*t111*t126*t20-1.219864d-2*t100*t1
     =           03*t111*t126*t20-6.09932d-3*t102*t108*t111*t20+2.033106
     >           666666667d-2*t105*t106*t126*t18+2.033106666666667d-2*t1
     ?           00*t103*t104*t126*t18+1.0165533333333335d-2*t102*t104*t
     @           108*t18+1.0165533333333335d-2*t100*t102*t107*t18-6.6666
     1           66666666667d+0*t102*t104*t105*t18-3.3333333333333337d+0
     2           *t100*t102*t103*t18
              t420 = 1.0d+0*t419*t96+1.0d+0*t168*t210
              t421 = 8.132426666666668d-2*t104*t105*t126*t18*t55*taua+4.
     1           066213333333334d-2*t100*t103*t126*t18*t55*taua+2.033106
     2           666666667d-2*t102*t108*t18*t55*taua-1.3333333333333333d
     3           +1*t102*t105*t18*t55*taua+1.1160511338720001d-4*t101*t1
     4           11*t241*t55*t99+6.505941333333333d-2*gammaaa*t100*t110*
     5           t126*t55*t99+1.1160511338720001d-4*t105*t106*t111*t241*
     6           t55+1.1160511338720001d-4*t100*t103*t104*t111*t241*t55+
     7           3.72017044624d-5*t104*t108*t111*t126*t55+3.72017044624d
     8           -5*t100*t107*t111*t126*t55-2.439728d-2*t104*t105*t111*t
     9           126*t55-1.219864d-2*t100*t103*t111*t126*t55+3.252970666
     :           6666663d-2*gammaaa*t103*t104*t110*t126*t55-6.09932d-3*t
     ;           102*t108*t111*t55+1.6264853333333332d-2*gammaaa*t102*t1
     <           07*t110*t55-5.333333333333333d+0*gammaaa*t102*t103*t110
     =           *t55
              t422 = 1.0d+0*t421*t96+1.0d+0*t168*t216
              t423 = 8.132426666666668d-2*t104*t105*t126*t20*t53*taub+4.
     1           066213333333334d-2*t100*t103*t126*t20*t53*taub+2.033106
     2           666666667d-2*t102*t108*t20*t53*taub-1.3333333333333333d
     3           +1*t102*t105*t20*t53*taub+1.1160511338720001d-4*t101*t1
     4           71*t20*t241*t99+6.505941333333333d-2*gammabb*t100*t126*
     5           t170*t20*t99+1.1160511338720001d-4*t105*t106*t171*t20*t
     6           241+1.1160511338720001d-4*t100*t103*t104*t171*t20*t241+
     7           3.72017044624d-5*t104*t108*t126*t171*t20+3.72017044624d
     8           -5*t100*t107*t126*t171*t20-2.439728d-2*t104*t105*t126*t
     9           171*t20-1.219864d-2*t100*t103*t126*t171*t20-6.09932d-3*
     :           t102*t108*t171*t20+3.2529706666666663d-2*gammabb*t103*t
     ;           104*t126*t170*t20+1.6264853333333332d-2*gammabb*t102*t1
     <           07*t170*t20-5.333333333333333d+0*gammabb*t102*t103*t170
     =           *t20
              t424 = 1.0d+0*t423*t96+1.0d+0*t197*t210
              t425 = 1.373568d-1*t172*t212*t31*t62*taub+3.43392000000000
     1           03d-2*t212*t34*t61*taub-1.3333333333333333d+1*t212*t31*
     2           t61*taub+6.867840000000001d-2*gammabb*t172*t211*t29*tau
     3           b+3.183787772928d-4*t171*t31*t343*t55*t63+3.43392000000
     4           00003d-2*t172*t31*t53*t63+1.7169600000000002d-2*t34*t53
     5           *t61*t62-6.666666666666667d+0*t31*t53*t61*t62+8.928192d
     6           -2*gammabb*t172*t29*t60*t62+1.061262590976d-4*t171*t172
     7           *t34*t55*t62-4.120704d-2*t171*t172*t31*t55*t62+3.183787
     8           772928d-4*gammabb*t171*t212*t29*t343*t62+4.464096d-2*ga
     9           mmabb*t33*t60*t61-8.666666666666666d+0*gammabb*t29*t60*
     :           t61-1.030176d-2*t171*t34*t55*t61+3.183787772928d-4*t171
     ;           *t211*t25*t343*t59+1.4422464000000002d-1*t172*t202*t25*
     <           t59-3.3333333333333337d+0*t34*t53*t58+1.061262590976d-4
     =           *gammabb*t171*t172*t212*t33-2.060352d-2*gammabb*t171*t1
     >           72*t212*t29
              t426 = 1.25d-1*gammabb*t215*t49*t50*t64+1.25d-1*gammabb*t1
     1           84*t215*t64+1.0d+0*rhob*t425*t49*t52+1.0d+0*t213*t49*t5
     2           2+1.0d+0*rhob*t184*t213*t52+1.25d-1*gammabb*t174*t215*t
     3           49
              t427 = 8.132426666666668d-2*t104*t105*t126*t212*taub+4.066
     1           213333333334d-2*t100*t103*t126*t212*taub+2.033106666666
     2           667d-2*t102*t108*t212*taub-1.3333333333333333d+1*t102*t
     3           105*t212*taub+6.505941333333333d-2*gammabb*t100*t126*t6
     4           0*t99+1.1160511338720001d-4*t101*t171*t241*t55*t99+2.03
     5           3106666666667d-2*t101*t126*t53*t99-3.3333333333333337d+
     6           0*t108*t53*t98+3.2529706666666663d-2*gammabb*t103*t104*
     7           t126*t60+1.6264853333333332d-2*gammabb*t102*t107*t60-5.
     8           333333333333333d+0*gammabb*t102*t103*t60+1.116051133872
     9           0001d-4*t105*t106*t171*t241*t55+1.1160511338720001d-4*t
     :           100*t103*t104*t171*t241*t55+3.72017044624d-5*t104*t108*
     ;           t126*t171*t55+3.72017044624d-5*t100*t107*t126*t171*t55-
     <           2.439728d-2*t104*t105*t126*t171*t55-1.219864d-2*t100*t1
     =           03*t126*t171*t55-6.09932d-3*t102*t108*t171*t55+2.033106
     >           666666667d-2*t105*t106*t126*t53+2.033106666666667d-2*t1
     ?           00*t103*t104*t126*t53+1.0165533333333335d-2*t102*t104*t
     @           108*t53+1.0165533333333335d-2*t100*t102*t107*t53-6.6666
     1           66666666667d+0*t102*t104*t105*t53-3.3333333333333337d+0
     2           *t100*t102*t103*t53
              t428 = 1.0d+0*t427*t96+1.0d+0*t197*t216
              t429 = 1/rhoa**9.666666666666666d+0
              t430 = 3.183787772928d-4*t220*t25*t26*t429+1.061262590976d
     1           -4*t112*t206*t30*t34-1.030176d-2*t206*t28*t34-1.030176d
     2           -2*t206*t28*t33+1.061262590976d-4*gammaaa*t112*t205*t33
     3           +3.183787772928d-4*t206*t220*t31*t32-4.120704d-2*t112*t
     4           206*t30*t31+3.183787772928d-4*gammaaa*t205*t220*t29*t30
     5           -2.060352d-2*t112*t206*t29*t30+2.0d+0*t206*t28*t29-2.06
     6           0352d-2*gammaaa*t112*t205*t29-4.120704d-2*gammaaa*t112*
     7           t205*t25
              t431 = 1/rhoa**3.3333333333333337d+0
              t432 = 1.1160511338720001d-4*t101*t206*t241*t99-2.439728d-
     1           2*t100*t126*t206*t99+1.1160511338720001d-4*t105*t106*t2
     2           06*t241+1.1160511338720001d-4*t100*t103*t104*t206*t241+
     3           3.72017044624d-5*t104*t108*t126*t206+3.72017044624d-5*t
     4           100*t107*t126*t206-2.439728d-2*t104*t105*t126*t206-1.21
     5           9864d-2*t103*t104*t126*t206-1.219864d-2*t100*t103*t126*
     6           t206-6.09932d-3*t102*t108*t206-6.09932d-3*t102*t107*t20
     7           6+2.0d+0*t102*t103*t206
              t433 = 1.1160511338720001d-4*t101*t18*t241*t55*t99-2.43972
     1           8d-2*t100*t126*t18*t55*t99+1.1160511338720001d-4*t105*t
     2           106*t18*t241*t55+1.1160511338720001d-4*t100*t103*t104*t
     3           18*t241*t55+3.72017044624d-5*t104*t108*t126*t18*t55+3.7
     4           2017044624d-5*t100*t107*t126*t18*t55-2.439728d-2*t104*t
     5           105*t126*t18*t55-1.219864d-2*t103*t104*t126*t18*t55-1.2
     6           19864d-2*t100*t103*t126*t18*t55-6.09932d-3*t102*t108*t1
     7           8*t55-6.09932d-3*t102*t107*t18*t55+2.0d+0*t102*t103*t18
     8           *t55
              t434 = 1.1160511338720001d-4*t101*t20*t241*t53*t99-2.43972
     1           8d-2*t100*t126*t20*t53*t99+1.1160511338720001d-4*t105*t
     2           106*t20*t241*t53+1.1160511338720001d-4*t100*t103*t104*t
     3           20*t241*t53+3.72017044624d-5*t104*t108*t126*t20*t53+3.7
     4           2017044624d-5*t100*t107*t126*t20*t53-2.439728d-2*t104*t
     5           105*t126*t20*t53-1.219864d-2*t103*t104*t126*t20*t53-1.2
     6           19864d-2*t100*t103*t126*t20*t53-6.09932d-3*t102*t108*t2
     7           0*t53-6.09932d-3*t102*t107*t20*t53+2.0d+0*t102*t103*t20
     8           *t53
              t435 = 1/rhob**9.666666666666666d+0
              t436 = 3.183787772928d-4*t212*t31*t343*t63+3.183787772928d
     1           -4*gammabb*t211*t29*t343*t62+1.061262590976d-4*t172*t21
     2           2*t34*t62-4.120704d-2*t172*t212*t31*t62-2.060352d-2*t17
     3           2*t212*t29*t62-1.030176d-2*t212*t34*t61-1.030176d-2*t21
     4           2*t33*t61+2.0d+0*t212*t29*t61+3.183787772928d-4*t25*t34
     5           3*t435*t59+1.061262590976d-4*gammabb*t172*t211*t33-2.06
     6           0352d-2*gammabb*t172*t211*t29-4.120704d-2*gammabb*t172*
     7           t211*t25
              t437 = 1/rhob**3.3333333333333337d+0
              t438 = 1.1160511338720001d-4*t101*t212*t241*t99-2.439728d-
     1           2*t100*t126*t212*t99+1.1160511338720001d-4*t105*t106*t2
     2           12*t241+1.1160511338720001d-4*t100*t103*t104*t212*t241+
     3           3.72017044624d-5*t104*t108*t126*t212+3.72017044624d-5*t
     4           100*t107*t126*t212-2.439728d-2*t104*t105*t126*t212-1.21
     5           9864d-2*t103*t104*t126*t212-1.219864d-2*t100*t103*t126*
     6           t212-6.09932d-3*t102*t108*t212-6.09932d-3*t102*t107*t21
     7           2+2.0d+0*t102*t103*t212
              t439 = 1/rhoa**8.666666666666666d+0
              t440 = 1/rhoa**6
              t441 = 2.122525181952d-4*gammaaa*t112*t33*t440+6.367575545
     1           856d-4*gammaaa*t220*t29*t30*t440-8.241408d-2*gammaaa*t1
     2           12*t29*t440+6.367575545856d-4*t220*t25*t26*t439+2.12252
     3           5181952d-4*t112*t30*t34*t431-4.120704d-2*t28*t34*t431+6
     4           .367575545856d-4*t220*t31*t32*t431-1.6482816d-1*t112*t3
     5           0*t31*t431+8.0d+0*t28*t31*t431
              t442 = 1/taua**3
              t443 = 2.2321022677440003d-4*t101*t241*t431*t99+2.23210226
     1           77440003d-4*t105*t106*t241*t431+2.2321022677440003d-4*t
     2           100*t103*t104*t241*t431+7.44034089248d-5*t104*t108*t126
     3           *t431+7.44034089248d-5*t100*t107*t126*t431-9.758912d-2*
     4           t104*t105*t126*t431-4.879456d-2*t100*t103*t126*t431-2.4
     5           39728d-2*t102*t108*t431+8.0d+0*t102*t105*t431
              t444 = 2.2321022677440003d-4*t101*t20*t241*t55*t99+2.23210
     1           22677440003d-4*t105*t106*t20*t241*t55+2.232102267744000
     2           3d-4*t100*t103*t104*t20*t241*t55+7.44034089248d-5*t104*
     3           t108*t126*t20*t55+7.44034089248d-5*t100*t107*t126*t20*t
     4           55-9.758912d-2*t104*t105*t126*t20*t55-4.879456d-2*t100*
     5           t103*t126*t20*t55-2.439728d-2*t102*t108*t20*t55+8.0d+0*
     6           t102*t105*t20*t55
              t445 = 1/rhob**8.666666666666666d+0
              t446 = 1/rhob**6
              t447 = 6.367575545856d-4*t31*t343*t437*t63+6.367575545856d
     1           -4*gammabb*t29*t343*t446*t62+2.122525181952d-4*t172*t34
     2           *t437*t62-1.6482816d-1*t172*t31*t437*t62-4.120704d-2*t3
     3           4*t437*t61+8.0d+0*t31*t437*t61+6.367575545856d-4*t25*t3
     4           43*t445*t59+2.122525181952d-4*gammabb*t172*t33*t446-8.2
     5           41408d-2*gammabb*t172*t29*t446
              t448 = 1/taub**3
              t449 = 2.2321022677440003d-4*t101*t241*t437*t99+2.23210226
     1           77440003d-4*t105*t106*t241*t437+2.2321022677440003d-4*t
     2           100*t103*t104*t241*t437+7.44034089248d-5*t104*t108*t126
     3           *t437+7.44034089248d-5*t100*t107*t126*t437-9.758912d-2*
     4           t104*t105*t126*t437-4.879456d-2*t100*t103*t126*t437-2.4
     5           39728d-2*t102*t108*t437+8.0d+0*t102*t105*t437
              t450 = t111**3
              t451 = 1/rhoa**3
              t452 = 1/t22**5
              t453 = 1/rhoa**5.666666666666667d+0
              t454 = -3.2592592592592595d+1*t221*taua-4.5629629629629626
     1           d+1*gammaaa*t453
              t455 = 1/rhoa**8.333333333333334d+0
              t456 = t119**3
              t457 = 1/t2**7
              t458 = 1/rhoa**3.1666666666666665d+0
              t459 = t122**3
              t460 = 2.0690405167709364d+3*t459*t9/(t6**6*t7**3)-1.92983
     1           75398431045d+2*t233*t459*t9/t6**5+6.0d+0*t121*t235*t459
     2           *t9+1.0d+0*t121*t123*(-4.684972743248224d+0*t458-3.0838
     3           75829189267d+0*t457-3.9871442462415524d+0*t431-7.128507
     4           529742789d-1*t110)*t9-6.0d+0*t121*t122*t236*t237*t9+9.6
     5           49187699215522d+1*t122*t233*t235*t237*t9+4.109901889749
     6           9934d-3*t431*t8+1.1102230246251565d-16*t115*t120*t13*(-
     7           2.520426340996149d+0*t458-1.5008036906238065d+0*t457-2.
     8           3079979182303428d+0*t431-5.620753557770543d-1*t110)+6.6
     9           61338147750939d-16*t115*t13*t227*t456-1.071275035259891
     :           3d-14*t13*t225*t456/t10**5+5.742741051503565d-14*t13*t4
     ;           56/(t10**6*t11**3)+9.490883560204437d-19*t12*t431-1.274
     <           696188700087d-1*t117*t121*t123*t237+2.549392377400174d-
     =           1*t117*t121*t234*t236-4.0999275947472624d+0*t117*t233*t
     >           234*t235-6.661338147750939d-16*t115*t119*t13*t228*t232+
     ?           5.356375176299456d-15*t119*t13*t225*t227*t232-1.4718104
     @           502398274d-17*t115*t117*t120*t232+1.6995949182667827d-1
     1           *t121*t122*t123*t230+1.962413933653103d-17*t115*t119*t1
     2           20*t230+2.943620900479655d-17*t115*t117*t226*t228-2.366
     3           9625486718335d-16*t117*t225*t226*t227
              t461 = 1/t97**5
              t462 = 4.824593849607761d+1*t250*t251*t252*t67*t76
              t463 = -6.0d+0*t134*t250*t255*t67*t76
              t464 = -2.6513779981040353d-1*t130*t132*t133*t134*t76
              t465 = 3.0d+0*t133*t134*t262*t67*t76
              t466 = -5.19476882440587d+1*t264*t265*t266*t85*t86
              t467 = 3.5089341735807883d+0*t138*t264*t269*t85*t86
              t468 = 8.072185179299687d-2*t130*t136*t137*t138*t86
              t469 = -1.7544670867903941d+0*t137*t138*t272*t85*t86
              t470 = 1.856176655010858d+2*t274*t275*t276*t69*t70*t74*t91
              t471 = -1.1541966305589217d+1*t142*t274*t279*t69*t70*t74*t
     1           91
              t472 = -4.904166819946466d-1*t140*t141*t142*t165*t69*t74
              t473 = 5.770983152794609d+0*t141*t142*t282*t69*t70*t74*t91
              t474 = -4.616786522235687d+1*t140*t141*t142*t154*t69*t74*t
     1           91
              t475 = -1.099109305675375d-2*t260*t76*t83
              t476 = 1.8175185709928465d-3*t260*t86*t89
              t477 = -7.11545236961578d-2*t317*t69*t74*t94
              t478 = -3.588478118171826d+0*t301*t69*t74*t91*t94
              t479 = -2.1530868709030954d+0*t304*t70*t74*t91*t94
              t480 = t132**3
              t481 = 5.172601291927341d+2*t480*t67*t76/(t81**6*t82**3)
              t482 = -9.649187699215522d+1*t252*t480*t67*t76/t81**5
              t483 = 4.824593849607761d+1*t132*t251*t252*t262*t67*t76
              t484 = -2.1319703304396778d+0*t130*t250*t251*t252*t76
              t485 = 6.0d+0*t134*t251*t480*t67*t76
              t486 = -6.0d+0*t132*t134*t255*t262*t67*t76
              t487 = 2.6513779981040353d-1*t130*t134*t250*t255*t76
              t488 = -1.3256889990520176d-1*t130*t133*t134*t262*t76
              t489 = 1.767585332069357d-1*t132*t133*t134*t260*t76
              t490 = 1/t65**3.6666666666666664d+0
              t491 = 1/t78**7
              t492 = 1/t65**3.3333333333333337d+0
              t493 = 1/t65**3.1666666666666665d+0
              t494 = 1.0d+0*t133*t134*(-2.520426340996149d+0*t493-2.3079
     1           979182303428d+0*t492-1.5008036906238065d+0*t491-5.62075
     2           3557770543d-1*t490)*t67*t76
              t495 = t136**3
              t496 = -1.0254062650399592d+3*t495*t85*t86/(t87**6*t88**3)
              t497 = 1.0389537648811739d+2*t266*t495*t85*t86/t87**5
              t498 = -5.19476882440587d+1*t136*t265*t266*t272*t85*t86
              t499 = 1.1950391155803675d+0*t130*t264*t265*t266*t86
              t500 = -3.5089341735807883d+0*t138*t265*t495*t85*t86
              t501 = 3.5089341735807883d+0*t136*t138*t269*t272*t85*t86
              t502 = -8.072185179299687d-2*t130*t138*t264*t269*t86
              t503 = 4.0360925896498434d-2*t130*t137*t138*t272*t86
              t504 = -5.381456786199791d-2*t136*t137*t138*t260*t86
              t505 = -5.848223622634647d-1*t137*t138*(-3.436688601932293
     1           d+0*t493-2.3308360066730832d+0*t492-8.064323383643707d-
     2           1*t491-5.663741022599518d-1*t490)*t85*t86
              t506 = t140**3
              t507 = 3.9801326549115085d+3*t506*t69*t70*t74*t91/(t92**6*
     1           t93**3)
              t508 = -3.712353310021716d+2*t276*t506*t69*t70*t74*t91/t92
     1           **5
              t509 = 1.856176655010858d+2*t140*t275*t276*t282*t69*t70*t7
     1           4*t91
              t510 = -7.424706620043432d+2*t154*t274*t275*t276*t69*t74*t
     1           91
              t511 = -7.886871025654724d+0*t165*t274*t275*t276*t69*t74
              t512 = 1.1541966305589217d+1*t142*t275*t506*t69*t70*t74*t9
     1           1
              t513 = -1.1541966305589217d+1*t140*t142*t279*t282*t69*t70*
     1           t74*t91
              t514 = 4.616786522235687d+1*t142*t154*t274*t279*t69*t74*t9
     1           1
              t515 = 4.904166819946466d-1*t142*t165*t274*t279*t69*t74
              t516 = -2.452083409973233d-1*t141*t142*t165*t282*t69*t74
              t517 = 2.2886111826416838d+0*t140*t141*t142*t317*t69*t74
              t518 = 1.923661050931536d+0*t141*t142*(-4.684972743248224d
     1           +0*t493-3.9871442462415524d+0*t492-3.083875829189267d+0
     2           *t491-7.128507529742789d-1*t490)*t69*t70*t74*t91
              t519 = -2.3083932611178434d+1*t141*t142*t154*t282*t69*t74*
     1           t91
              t520 = 1.1541966305589217d+2*t140*t141*t142*t301*t69*t74*t
     1           91
              t521 = 6.925179783353531d+1*t140*t141*t142*t304*t70*t74*t9
     1           1
              t522 = 8.548627933030694d-3*t492*t76*t83
              t523 = 1/t72**1.6666666666666669d+0
              t524 = 6*t68*t70
              t525 = -6*t288
              t526 = 1/t73**1.6666666666666669d+0
              t527 = -6*t68*t70
              t528 = 6*t288
              t529 = 1.3333333333333333d+0*t151*(t528+t527)-2.9629629629
     1           62963d-1*t150**3*t526+1.3333333333333333d+0*t148*(t525+
     2           t524)-2.962962962962963d-1*t147**3*t523+1.3333333333333
     3           333d+0*t150*t293*t296+1.3333333333333333d+0*t147*t287*t
     4           291
              t530 = -1.923661050931536d+0*t529*t69*t70
              t531 = 2.3083932611178434d+1*t154*t297*t69
              t532 = -2.3083932611178434d+1*t156*t297*t70
              t533 = -1.1541966305589216d+2*t152*t301*t69
              t534 = 1.8467146088942746d+2*t152*t154*t156
              t535 = -6.925179783353531d+1*t152*t304*t70
              t536 = 1/t65**7
              t537 = 2.3083932611178432d+2*t536*t69*t74
              t538 = -4.6167865222356863d+2*t156*t301*t74
              t539 = 2.770071913341412d+2*t154*t304*t74
              t540 = -4.616786522235687d+1*t68*t70*t74
              t541 = -1.4136255552166585d-3*t492*t86*t89
              t542 = 2.0103976536374746d-1*t69*t74*t94/t65**7.3333333333
     1           33333d+0
              t543 = 9.148438760934575d-2*t165*t304*t74*t94
              t544 = 7.176956236343652d+0*t536*t69*t74*t91*t94
              t545 = 8.612347483612381d+0*t154*t304*t74*t91*t94
              t546 = -1.4353912472687305d+0*t68*t70*t74*t91*t94
              t547 = -1.243628d-1*t334*t67*t83
              t548 = 3.9503262643361536d-2*t335*t85*t89
              t549 = -1.1961593727239421d-1*t327*t69*t70*t91*t94
              t550 = 2.0d+0*t132*t133*t134*t334*t67
              t551 = -1.1696447245269295d+0*t136*t137*t138*t335*t85
              t552 = 3.847322101863072d+0*t140*t141*t142*t327*t69*t70*t9
     1           1
              t553 = -2.3083932611178434d+1*t140*t141*t142*t304*t70*t74*
     1           t91
              t554 = 5.495546528376875d-3*t130*t334*t83
              t555 = 1.5389288407452287d+1*t154*t327*t69
              t556 = -1.5389288407452287d+1*t156*t327*t70
              t557 = 1.7777777777777776d+0*t150*t288*t293*t68-1.77777777
     1           77777776d+0*t147*t287*t288*t68+1.3333333333333333d+0*t1
     2           51*(t527+2*t288)-2.962962962962963d-1*t188*t292*t526+1.
     3           3333333333333333d+0*t148*(t524-2*t288)-2.96296296296296
     4           3d-1*t187*t286*t523+4.444444444444444d-1*t188*t293*t296
     5           +4.444444444444444d-1*t187*t287*t291
              t558 = -1.923661050931536d+0*t557*t69*t70
              t559 = 7.694644203726144d+0*t154*t297*t69
              t560 = 7.694644203726144d+0*t156*t297*t70
              t561 = -3.8473221018630716d+1*t189*t301*t69
              t562 = 6.155715362980915d+1*t154*t156*t189
              t563 = -2.3083932611178434d+1*t189*t304*t70
              t564 = -7.694644203726143d+1*t152*t301*t69
              t565 = 4.616786522235687d+1*t152*t304*t70
              t566 = -1.5389288407452287d+2*t156*t301*t74
              t567 = -9.233573044471374d+1*t154*t304*t74
              t568 = 4.616786522235687d+1*t68*t70*t74
              t569 = -9.087592854964233d-4*t130*t335*t89
              t570 = 5.082465978296986d-3*t165*t327*t69*t94
              t571 = 4.7846374908957684d-1*t154*t327*t69*t91*t94
              t572 = -2.870782494537461d+0*t154*t304*t74*t91*t94
              t573 = 1.4353912472687305d+0*t68*t70*t74*t91*t94
              t574 = -8*t151*t68*t70+8*t148*t68*t70+1.7777777777777776d+
     1           0*t188*t288*t293*t68-1.7777777777777776d+0*t187*t287*t2
     2           88*t68-2.962962962962963d-1*t150*t371*t526-2.9629629629
     3           62963d-1*t147*t369*t523+4.444444444444444d-1*t150*t293*
     4           t372+4.444444444444444d-1*t147*t287*t370-2.666666666666
     5           6666d+0*t151*t288+2.6666666666666666d+0*t148*t288
              t575 = -1.923661050931536d+0*t574*t69*t70
              t576 = 1.5389288407452287d+1*t156*t327*t70
              t577 = 7.694644203726144d+0*t154*t373*t69
              t578 = -7.694644203726144d+0*t156*t373*t70
              t579 = -7.694644203726143d+1*t189*t301*t69
              t580 = 4.616786522235687d+1*t189*t304*t70
              t581 = -3.8473221018630716d+1*t152*t301*t69
              t582 = -6.155715362980915d+1*t152*t154*t156
              t583 = -2.3083932611178434d+1*t152*t304*t70
              t584 = 1.5389288407452287d+2*t156*t301*t74
              t585 = t171**3
              t586 = 1/rhob**3
              t587 = 1/t57**5
              t588 = 1/rhob**5.666666666666667d+0
              t589 = -3.2592592592592595d+1*t344*taub-4.5629629629629626
     1           d+1*gammabb*t588
              t590 = 1/rhob**8.333333333333334d+0
              t591 = t179**3
              t592 = 1/t37**7
              t593 = 1/rhob**3.1666666666666665d+0
              t594 = t182**3
              t595 = 2.0690405167709364d+3*t44*t594/(t41**6*t42**3)-1.92
     1           98375398431045d+2*t356*t44*t594/t41**5+6.0d+0*t181*t358
     2           *t44*t594+1.1102230246251565d-16*t175*t180*t48*(-2.5204
     3           26340996149d+0*t593-1.5008036906238065d+0*t592-2.307997
     4           9182303428d+0*t437-5.620753557770543d-1*t170)+1.0d+0*t1
     5           81*t183*t44*(-4.684972743248224d+0*t593-3.0838758291892
     6           67d+0*t592-3.9871442462415524d+0*t437-7.128507529742789
     7           d-1*t170)+5.742741051503565d-14*t48*t591/(t45**6*t46**3
     8           )-1.0712750352598913d-14*t348*t48*t591/t45**5+6.6613381
     9           47750939d-16*t175*t350*t48*t591-6.661338147750939d-16*t
     :           175*t179*t351*t355*t48+5.356375176299456d-15*t179*t348*
     ;           t350*t355*t48+9.490883560204437d-19*t437*t47-6.0d+0*t18
     <           1*t182*t359*t360*t44+9.649187699215522d+1*t182*t356*t35
     =           8*t360*t44+4.1099018897499934d-3*t43*t437-1.27469618870
     >           0087d-1*t177*t181*t183*t360+2.549392377400174d-1*t177*t
     ?           181*t357*t359-4.0999275947472624d+0*t177*t356*t357*t358
     @           -1.4718104502398274d-17*t175*t177*t180*t355+1.699594918
     1           2667827d-1*t181*t182*t183*t353+1.962413933653103d-17*t1
     2           75*t179*t180*t353+2.943620900479655d-17*t175*t177*t349*
     3           t351-2.3669625486718335d-16*t177*t348*t349*t350
              t596 = 1.3333333333333333d+0*t148*(t528+t524)+1.3333333333
     1           333333d+0*t151*(t527+t525)-2.962962962962963d-1*t188**3
     2           *t526-2.962962962962963d-1*t187**3*t523+1.3333333333333
     3           333d+0*t188*t293*t372+1.3333333333333333d+0*t187*t287*t
     4           370
              t597 = -1.923661050931536d+0*t596*t69*t70
              t598 = 2.3083932611178434d+1*t154*t373*t69
              t599 = 2.3083932611178434d+1*t156*t373*t70
              t600 = -1.1541966305589216d+2*t189*t301*t69
              t601 = -1.8467146088942746d+2*t154*t156*t189
              t602 = -6.925179783353531d+1*t189*t304*t70
              t603 = 4.6167865222356863d+2*t156*t301*t74
              t604 = -1.25d-1*t14*t35-1.25d-1*gammaaa*t14*t200
              t605 = 1/rhoa**10
              t606 = -1.25d-1*t49*t64-1.25d-1*gammabb*t203*t49
              t607 = 1/rhob**10
              t608 = 1.25d-1*gammaaa*t14*t411+2.5d-1*t14*t200
              t609 = -1.030176d-2*t395
              t610 = 1.25d-1*gammabb*t415*t49+2.5d-1*t203*t49
              t611 = -1.030176d-2*t406
              t612 = -1.030176d-2*t392
              t613 = -1.8600852231200002d-4*t101*t18*t241*t53*t99
              t614 = -1.8600852231200002d-4*t100*t103*t104*t18*t241*t53
              t615 = -1.8600852231200002d-4*t105*t106*t18*t241*t53
              t616 = -6.200284077066667d-5*t100*t107*t126*t18*t53
              t617 = 4.066213333333334d-2*t100*t126*t18*t53*t99
              t618 = 2.033106666666667d-2*t100*t103*t126*t18*t53
              t619 = -6.200284077066667d-5*t104*t108*t126*t18*t53
              t620 = 2.033106666666667d-2*t103*t104*t126*t18*t53
              t621 = 4.066213333333334d-2*t104*t105*t126*t18*t53
              t622 = 1.0165533333333335d-2*t102*t107*t18*t53
              t623 = 1.0165533333333335d-2*t102*t108*t18*t53
              t624 = -3.3333333333333337d+0*t102*t103*t18*t53
              t625 = -6.200284077066667d-5*t109*t126*t18*t53*t96
              t626 = -1.030176d-2*t403
              t627 = -1.28772d-3*gammaaa*t14*t200
              t628 = -1.28772d-3*t14*t35
              t629 = -1.28772d-3*gammabb*t203*t49
              t630 = -1.28772d-3*t49*t64
              t631 = 1/rhoa**5
              t632 = 1/rhob**5
              t633 = 1/rhoa**7.666666666666667d+0
              t634 = 1/rhob**7.666666666666667d+0
              fnc(iq) = (1.0d+0*t109*t96*t98+1.0d+0*rhob*t49*t52*t58*t64
     1           +1.0d+0*rhoa*t14*t17*t23*t35)*wght+fnc(iq)
              Amat(iq,D1_RA) = (t169*t98-3.04966d-3*t102*t109*t111*t96-5
     1           .15088d-3*rhoa*t111*t14*t17*t28*t35+1.25d-1*gammaaa*t14
     2           *t15*t16*t23*t35+t125*t23)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (t198*t98-3.04966d-3*t102*t109*t171*t96-5
     1           .15088d-3*rhob*t171*t49*t52*t61*t64+1.25d-1*gammabb*t49
     2           *t50*t51*t58*t64+t185*t58)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (1.0d+0*t201*t96*t98-3.04966d-3*t102*t10
     1           9*t18*t96-5.15088d-3*t14*t17*t20*t28*t35-1.25d-1*t14*t1
     2           6*t23*t35+1.0d+0*rhoa*t14*t17*t200*t23)*wght+Cmat(iq,D1
     3           _GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = (1.0d+0*t204*t96*t98-3.04966d-3*t102*t10
     1           9*t53*t96-5.15088d-3*t49*t52*t55*t61*t64-1.25d-1*t49*t5
     2           1*t58*t64+1.0d+0*rhob*t203*t49*t52*t58)*wght+Cmat(iq,D1
     3           _GBB)
              Mmat(iq,D1_TA) = (1.0d+0*t210*t96*t98-6.09932d-3*t102*t109
     1           *t20*t96-1.030176d-2*t1*t14*t17*t28*t35+1.25d-1*gammaaa
     2           *t14*t209*t23*t35+1.0d+0*rhoa*t14*t17*t207*t23)*wght+Mm
     3           at(iq,D1_TA)
              Mmat(iq,D1_TB) = (1.0d+0*t216*t96*t98-6.09932d-3*t102*t109
     1           *t55*t96-1.030176d-2*t36*t49*t52*t61*t64+1.25d-1*gammab
     2           b*t215*t49*t58*t64+1.0d+0*rhob*t213*t49*t52*t58)*wght+M
     3           mat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t324*t98+1.86008522312d-5*t109*t126*
     1           t217*t96-1.28772d-3*gammaaa*t111*t14*t15*t16*t28*t35-1.
     2           25d-1*gammaaa*t14*t16*t218*t23*t35+5.30631295488d-5*rho
     3           a*t112*t14*t17*t217*t35+t102*t325+t240*t28+t23*t239+t15
     4           *t16*t219*t23)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t338*t98+1.86008522312d-5*t109*t111*
     1           t126*t171*t96+t102*t339)*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t390*t98+1.86008522312d-5*t109*t126*
     1           t340*t96-1.28772d-3*gammabb*t171*t49*t50*t51*t61*t64-1.
     2           25d-1*gammabb*t341*t49*t51*t58*t64+5.30631295488d-5*rho
     3           b*t172*t340*t49*t52*t64+t363*t61+t342*t50*t51*t58+t362*
     4           t58+t102*t391)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t398*t98-3.04966d-3*t102*t111*t201*
     1           t96+1.86008522312d-5*t109*t111*t126*t18*t96+8.132426666
     2           666667d-3*t102*t109*t110*t96+t18*t28*t396+t23*t395+t15*
     3           t16*t23*t392+6.4386d-4*t111*t14*t16*t28*t35-6.4386d-4*g
     4           ammaaa*t110*t14*t16*t28*t35+5.30631295488d-5*t111*t112*
     5           t14*t17*t20*t35-5.15088d-3*rhoa*t111*t14*t17*t200*t28-3
     6           .04966d-3*t102*t169*t18)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = (t400*t98+1.86008522312d-5*t109*t111
     1           *t126*t53*t96-3.04966d-3*t102*t111*t204*t96-3.04966d-3*
     2           t102*t169*t53)*wght+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (t402*t98-3.04966d-3*t102*t171*t201*
     1           t96+1.86008522312d-5*t109*t126*t171*t18*t96-3.04966d-3*
     2           t102*t18*t198)*wght+Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t409*t98+1.86008522312d-5*t109*t126
     1           *t171*t53*t96-3.04966d-3*t102*t171*t204*t96+8.132426666
     2           666667d-3*t102*t109*t170*t96+6.4386d-4*t171*t49*t51*t61
     3           *t64-6.4386d-4*gammabb*t170*t49*t51*t61*t64+5.306312954
     4           88d-5*t171*t172*t49*t52*t55*t64+t407*t53*t61-5.15088d-3
     5           *rhob*t171*t203*t49*t52*t61+t403*t50*t51*t58+t406*t58-3
     6           .04966d-3*t102*t198*t53)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t412*t96*t98+1.86008522312d
     1           -5*t109*t126*t27*t96-6.09932d-3*t102*t18*t201*t96+1.0d+
     2           0*rhoa*t14*t17*t23*t411+1.28772d-3*t14*t16*t18*t28*t35+
     3           5.30631295488d-5*t112*t14*t17*t206*t35-1.030176d-2*t14*
     4           t17*t20*t200*t28-2.5d-1*t14*t16*t200*t23)*wght+Cmat2(iq
     5           ,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = (1.0d+0*t413*t96*t98-3.04966d-3*t10
     1           2*t201*t53*t96+1.86008522312d-5*t109*t126*t18*t53*t96-3
     2           .04966d-3*t102*t18*t204*t96)*wght+Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = (1.0d+0*t416*t96*t98+1.86008522312d
     1           -5*t109*t126*t60*t96-6.09932d-3*t102*t204*t53*t96+1.287
     2           72d-3*t49*t51*t53*t61*t64+5.30631295488d-5*t172*t212*t4
     3           9*t52*t64-1.030176d-2*t203*t49*t52*t55*t61+1.0d+0*rhob*
     4           t415*t49*t52*t58-2.5d-1*t203*t49*t51*t58)*wght+Cmat2(iq
     5           ,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (t420*t98-3.04966d-3*t102*t111*t210*t
     1           96+3.72017044624d-5*t109*t111*t126*t20*t96+1.0165533333
     2           333335d-2*t102*t109*t18*t96+t23*t418+t20*t28*(1.7169600
     3           000000002d-2*t14*t17*t35-1.030176d-2*t125)-6.4386d-4*ga
     4           mmaaa*t111*t14*t209*t28*t35-1.28772d-3*gammaaa*t14*t16*
     5           t18*t28*t35-1.25d-1*gammaaa*t14*t15*t209*t23*t35+1.0612
     6           62590976d-4*t1*t111*t112*t14*t17*t35-5.15088d-3*rhoa*t1
     7           11*t14*t17*t207*t28+1.25d-1*gammaaa*t14*t15*t16*t207*t2
     8           3-6.09932d-3*t102*t169*t20)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = (t422*t98+3.72017044624d-5*t109*t111*
     1           t126*t55*t96-3.04966d-3*t102*t111*t216*t96-6.09932d-3*t
     2           102*t169*t55)*wght+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = (t424*t98-3.04966d-3*t102*t171*t210*t
     1           96+3.72017044624d-5*t109*t126*t171*t20*t96-6.09932d-3*t
     2           102*t198*t20)*wght+Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (t428*t98+3.72017044624d-5*t109*t126*
     1           t171*t55*t96+1.0165533333333335d-2*t102*t109*t53*t96-3.
     2           04966d-3*t102*t171*t216*t96+t55*t61*(1.7169600000000002
     3           d-2*t49*t52*t64-1.030176d-2*t185)-1.28772d-3*gammabb*t4
     4           9*t51*t53*t61*t64-6.4386d-4*gammabb*t171*t215*t49*t61*t
     5           64-1.25d-1*gammabb*t215*t49*t50*t58*t64+1.061262590976d
     6           -4*t171*t172*t36*t49*t52*t64-5.15088d-3*rhob*t171*t213*
     7           t49*t52*t61+1.25d-1*gammabb*t213*t49*t50*t51*t58+t426*t
     8           58-6.09932d-3*t102*t198*t55)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (1.0d+0*t432*t96*t98-3.04966d-3*t102
     1           *t18*t210*t96+3.72017044624d-5*t109*t126*t206*t96-6.099
     2           32d-3*t102*t20*t201*t96+1.061262590976d-4*t112*t14*t17*
     3           t35*t431+1.0d+0*rhoa*t14*t17*t23*t430+t209*t23*t392-6.4
     4           386d-4*gammaaa*t14*t18*t209*t28*t35+1.28772d-3*t14*t16*
     5           t20*t28*t35-5.15088d-3*t14*t17*t20*t207*t28-1.030176d-2
     6           *t1*t14*t17*t200*t28-1.25d-1*t14*t16*t207*t23)*wght+Mma
     7           t2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = (1.0d+0*t433*t96*t98-6.09932d-3*t102
     1           *t201*t55*t96+3.72017044624d-5*t109*t126*t18*t55*t96-3.
     2           04966d-3*t102*t18*t216*t96)*wght+Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = (1.0d+0*t434*t96*t98-3.04966d-3*t102
     1           *t210*t53*t96+3.72017044624d-5*t109*t126*t20*t53*t96-6.
     2           09932d-3*t102*t20*t204*t96)*wght+Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = (1.0d+0*t438*t96*t98-6.09932d-3*t102
     1           *t204*t55*t96-3.04966d-3*t102*t216*t53*t96+3.7201704462
     2           4d-5*t109*t126*t212*t96+1.28772d-3*t49*t51*t55*t61*t64-
     3           6.4386d-4*gammabb*t215*t49*t53*t61*t64+1.061262590976d-
     4           4*t172*t437*t49*t52*t64-5.15088d-3*t213*t49*t52*t55*t61
     5           -1.030176d-2*t203*t36*t49*t52*t61+1.0d+0*rhob*t436*t49*
     6           t52*t58-1.25d-1*t213*t49*t51*t58+t215*t403*t58)*wght+Mm
     7           at2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (1.0d+0*t443*t96*t98+7.44034089248d-5
     1           *t109*t126*t431*t96-1.219864d-2*t102*t20*t210*t96-2.5d-
     2           1*gammaaa*t14*t23*t35*t442+1.0d+0*rhoa*t14*t17*t23*t441
     3           -2.57544d-3*gammaaa*t14*t20*t209*t28*t35+2.122525181952
     4           d-4*t112*t14*t17*t230*t35-2.060352d-2*t1*t14*t17*t207*t
     5           28+2.5d-1*gammaaa*t14*t207*t209*t23)*wght+Mmat2(iq,D2_T
     6           A_TA)
              Mmat2(iq,D2_TA_TB) = (1.0d+0*t444*t96*t98-6.09932d-3*t102*
     1           t210*t55*t96+7.44034089248d-5*t109*t126*t20*t55*t96-6.0
     2           9932d-3*t102*t20*t216*t96)*wght+Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = (1.0d+0*t449*t96*t98-1.219864d-2*t102
     1           *t216*t55*t96+7.44034089248d-5*t109*t126*t437*t96-2.575
     2           44d-3*gammabb*t215*t49*t55*t61*t64-2.5d-1*gammabb*t448*
     3           t49*t58*t64+2.122525181952d-4*t172*t353*t49*t52*t64-2.0
     4           60352d-2*t213*t36*t49*t52*t61+1.0d+0*rhob*t447*t49*t52*
     5           t58+2.5d-1*gammabb*t213*t215*t49*t58)*wght+Mmat2(iq,D2_
     6           TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t98*(1.0d+0*t96*(-3.2592592592592
     1           595d+1*t108*t221*t98*taua-1.1160511338720001d-3*t104*t1
     2           05*t18*t217*t241*taua-5.58025566936d-4*t100*t103*t18*t2
     3           17*t241*taua-1.6888888888888892d+2*gammaaa*t102*t103*t2
     4           23*taua+1.2198640000000001d-1*t104*t105*t126*t18*t222*t
     5           aua+6.09932d-2*t100*t103*t126*t18*t222*taua+3.04966d-2*
     6           t102*t108*t18*t222*taua-6.518518518518519d+1*t102*t104*
     7           t105*t221*taua-3.2592592592592595d+1*t100*t102*t103*t22
     8           1*taua-1.8600852231200002d-4*t108*t126*t18*t217*taua-3.
     9           252970666666667d-1*gammaaa*t103*t111*t113*t126*taua-3.2
     :           52970666666667d-1*t104*t105*t110*t111*t126*taua-1.62648
     ;           53333333334d-1*t100*t103*t110*t111*t126*taua-8.13242666
     <           6666668d-2*t102*t108*t110*t111*taua-6.807153001848167d-
     =           7*t101*t450*t461*t99-1.5644444444444447d+2*t102*t26*t45
     >           5*t99-6.09932d-3*t101*t126*t454*t99-9.125925925925925d+
     ?           1*gammaaa*t100*t102*t453*t99-2.602376533333333d-1*t111*
     @           t126*t223*t26*t99+1.6740767008080004d-4*t101*t111*t222*
     1           t241*t99-8.928409070976d-4*gammaaa*t100*t110*t217*t241*
     2           t99+9.758912d-2*gammaaa*t100*t110*t126*t222*t99-3.57826
     3           7733333333d-1*gammaaa*t100*t111*t126*t221*t99-4.5629629
     4           629629626d+1*gammaaa*t107*t453*t98-6.807153001848167d-7
     5           *t105*t106*t450*t461-6.807153001848167d-7*t100*t103*t10
     6           4*t450*t461-6.09932d-3*t105*t106*t126*t454-6.09932d-3*t
     7           100*t103*t104*t126*t454-3.04966d-3*t102*t104*t108*t454-
     8           3.04966d-3*t100*t102*t107*t454-4.5629629629629626d+1*ga
     9           mmaaa*t102*t103*t104*t453-1.7017882504620419d-7*t104*t1
     :           08*t241*t450-1.7017882504620419d-7*t100*t107*t241*t450-
     ;           4.066213333333334d-1*t105*t111*t126*t208*t27+1.67407670
     <           08080004d-4*t105*t106*t111*t222*t241+1.6740767008080004
     =           d-4*t100*t103*t104*t111*t222*t241-4.464204535488d-4*gam
     >           maaa*t103*t104*t110*t217*t241+5.580255669359999d-5*t104
     ?           *t108*t111*t126*t222+5.580255669359999d-5*t100*t107*t11
     @           1*t126*t222+4.879456d-2*gammaaa*t103*t104*t110*t126*t22
     1           2+2.439728d-2*gammaaa*t102*t107*t110*t222-1.78913386666
     2           66665d-1*gammaaa*t103*t104*t111*t126*t221-8.94566933333
     3           3333d-2*gammaaa*t102*t107*t111*t221-1.4880681784959998d
     4           -4*gammaaa*t107*t110*t126*t217-1.777777777777778d+2*t10
     5           2*t105*t113*t208)+1.0d+0*t109*(t65*(-1.4353912472687305
     6           d+1*t156*t301*t74*t91*t94-5.980796863619711d-2*t529*t69
     7           *t70*t91*t94-2.1530868709030954d+0*t152*t304*t70*t91*t9
     8           4-7.176956236343652d-1*t156*t297*t70*t91*t94-3.58847811
     9           8171826d+0*t152*t301*t69*t91*t94+7.176956236343652d-1*t
     :           154*t297*t69*t91*t94+5.741564989074922d+0*t152*t154*t15
     ;           6*t91*t94-2.8461809478463124d-1*t156*t317*t74*t94-7.115
     <           45236961578d-2*t152*t317*t69*t94+7.623698967445479d-3*t
     =           165*t297*t69*t94+6.098959173956384d-2*t152*t156*t165*t9
     >           4+2.3083932611178434d+1*t141*t142*t156*t282*t70*t74*t91
     ?           -4.616786522235687d+1*t142*t156*t274*t279*t70*t74*t91+7
     @           .424706620043432d+2*t156*t274*t275*t276*t70*t74*t91-1.8
     1           467146088942746d+2*t140*t141*t142*t154*t156*t74*t91+5.7
     2           70983152794609d+0*t140*t141*t142*t297*t69*t70*t91+5.770
     3           983152794609d+0*t141*t142*t152*t282*t69*t70*t91-1.15419
     4           66305589217d+1*t142*t152*t274*t279*t69*t70*t91+1.856176
     5           655010858d+2*t152*t274*t275*t276*t69*t70*t91+4.61678652
     6           2235687d+1*t140*t141*t142*t152*t156*t70*t91-4.616786522
     7           235687d+1*t140*t141*t142*t152*t154*t69*t91+1.9751631321
     8           680768d-2*(t540+t539+t538+t537+t535+t534+t533+t532+t531
     9           +t530+1.923661050931536d+0*t529)*t85*t89-1.363138928244
     :           635d-3*t130*t310*t89+1.8175185709928465d-3*t161*t260*t8
     ;           9-1.7544670867903941d+0*t136*t137*t138*t310*t85-1.75446
     <           70867903941d+0*t137*t138*t161*t272*t85+3.50893417358078
     =           83d+0*t138*t161*t264*t269*t85-5.19476882440587d+1*t161*
     >           t264*t265*t266*t85-6.21814d-2*(t540+t539+t538+t537+t535
     ?           +t534+t533+t532+t531+t530)*t67*t83+8.243319792565312d-3
     @           *t130*t306*t83-1.099109305675375d-2*t158*t260*t83-1.961
     1           6667279785865d+0*t140*t141*t142*t156*t165*t74-4.9041668
     2           19946466d-1*t140*t141*t142*t152*t165*t69+3.0d+0*t132*t1
     3           33*t134*t306*t67+3.0d+0*t133*t134*t158*t262*t67-6.0d+0*
     4           t134*t158*t250*t255*t67+4.824593849607761d+1*t158*t250*
     5           t251*t252*t67+t546+t545+t544+t543+t542+t541+t522+t521+t
     6           520+t519+t518+t517+t516+t515+t514+t513+t512+t511+t510+t
     7           509+t508+t507+t505+t504+t503+t502+t501+t500+t499+t498+t
     8           497+t496+t494+t489+t488+t487+t486+t485+t484+t483+t482+t
     9           481+8.072185179299687d-2*t130*t136*t137*t138*t161-2.651
     :           3779981040353d-1*t130*t132*t133*t134*t158)+5.7415649890
     ;           74922d+0*t154*t156*t74*t91*t94-1.794239059085913d-1*t29
     <           7*t69*t70*t91*t94-1.4353912472687305d+0*t152*t156*t70*t
     =           91*t94+1.4353912472687305d+0*t152*t154*t69*t91*t94+6.09
     >           8959173956384d-2*t156*t165*t74*t94+1.524739793489096d-2
     ?           *t152*t165*t69*t94+4.616786522235687d+1*t140*t141*t142*
     @           t156*t70*t74*t91+1.1541966305589217d+1*t140*t141*t142*t
     1           152*t69*t70*t91-3.0d+0*t121*t123*t237*t9+6.0d+0*t121*t2
     2           34*t236*t9-9.649187699215522d+1*t233*t234*t235*t9+5.925
     3           48939650423d-2*t310*t85*t89-2.72627785648927d-3*t130*t1
     4           61*t89-3.5089341735807883d+0*t136*t137*t138*t161*t85-1.
     5           865442d-1*t306*t67*t83+1.6486639585130625d-2*t130*t158*
     6           t83+5.284159572535705d-3*t230*t8+6.0d+0*t132*t133*t134*
     7           t158*t67+t479+t478+t477+t476+t475+t474+t473+t472+t471+t
     8           470+t469+t468+t467+t466+t465+t464+t463+t462-rhoa*t460-3
     9           .3306690738754696d-16*t115*t120*t13*t232+1.220256457740
     :           5706d-18*t12*t230+6.661338147750939d-16*t115*t13*t226*t
     ;           228-5.356375176299456d-15*t13*t225*t226*t227+2.54939237
     <           7400174d-1*t117*t121*t122*t123+2.943620900479655d-17*t1
     =           15*t117*t119*t120)+3.0d+0*t127*t323+3.0d+0*t168*t242)+t
     >           23*(1.0d+0*rhoa*t14*t17*(5.15088d-2*t18*t222*t28*t34*ta
     ?           ua-1.373568d-1*t110*t111*t28*t34*taua-3.259259259259259
     @           5d+1*t221*t23*t34*taua-5.30631295488d-4*t112*t18*t217*t
     1           34*taua-6.518518518518519d+1*t221*t28*t30*t31*taua+2.06
     2           0352d-1*t112*t18*t222*t30*t31*taua-3.183787772928d-3*t1
     3           8*t217*t220*t30*t31*taua-5.494272d-1*t110*t111*t112*t30
     4           *t31*taua-2.0148148148148146d+2*gammaaa*t223*t28*t29*ta
     5           ua+1.030176d-1*gammaaa*t112*t222*t27*t29*taua-1.5918938
     6           86464d-3*gammaaa*t217*t220*t27*t29*taua-8.241408d-1*gam
     7           maaa*t111*t112*t113*t29*taua-2.477037037037037d+2*t25*t
     8           26*t28*t455-5.15088d-3*t28*t30*t34*t454-5.15088d-3*gamm
     9           aaa*t18*t28*t33*t454-1.030176d-2*t112*t31*t32*t454-1.03
     :           0176d-2*gammaaa*t112*t18*t29*t30*t454-1.030176d-2*t112*
     ;           t25*t26*t27*t454-4.5629629629629626d+1*gammaaa*t23*t33*
     <           t453-4.5629629629629626d+1*gammaaa*t28*t29*t30*t453-3.2
     =           798617527638757d-6*t31*t32*t450*t452-3.2798617527638757
     >           d-6*gammaaa*t18*t29*t30*t450*t452-3.2798617527638757d-6
     ?           *t25*t26*t27*t450*t452-8.199654381909689d-7*t220*t30*t3
     @           4*t450-8.199654381909689d-7*gammaaa*t18*t220*t33*t450+1
     1           .591893886464d-4*t111*t112*t222*t30*t34+4.120704d-2*gam
     2           maaa*t110*t222*t28*t33-1.5109248d-1*gammaaa*t111*t221*t
     3           28*t33+1.591893886464d-4*gammaaa*t111*t112*t18*t222*t33
     4           -4.245050363904d-4*gammaaa*t110*t112*t217*t33+4.7756816
     5           593920004d-4*t111*t220*t222*t31*t32-1.777777777777778d+
     6           2*t113*t208*t28*t31-6.867840000000001d-1*t111*t112*t208
     7           *t27*t31+4.7756816593920004d-4*gammaaa*t111*t18*t220*t2
     8           22*t29*t30+8.241408d-2*gammaaa*t110*t112*t222*t29*t30-3
     9           .0218496d-1*gammaaa*t111*t112*t221*t29*t30-1.2735151091
     :           712002d-3*gammaaa*t110*t217*t220*t29*t30+4.775681659392
     ;           0004d-4*t111*t220*t222*t25*t26*t27-1.0439116799999999d+
     <           0*t111*t112*t223*t25*t26+1.6482816d-1*t112*t113*t222*t2
     =           5*t26-2.5470302183424004d-3*t113*t217*t220*t25*t26)+1.0
     >           d+0*rhoa*t17*t35*t460-2.5d-1*gammaaa*t14*t16*t35*t451+3
     ?           .0d+0*t17*t238*t35+2.5d-1*gammaaa*t15*t16*t238*t35+2.5d
     @           -1*gammaaa*t124*t16*t218*t35+3.0d+0*rhoa*t114*t17*t238+
     1           3.0d+0*t14*t17*t224+3.0d+0*rhoa*t124*t17*t224+2.5d-1*ga
     2           mmaaa*t14*t15*t16*t224+2.5d-1*gammaaa*t114*t14*t16*t218
     3           +6.0d+0*t114*t124*t17+5.0d-1*gammaaa*t114*t124*t15*t16)
     4           +t102*(-3.04966d-3*t109*t454*t96-3.04966d-3*t111*t242*t
     5           96-6.09932d-3*t127*t222*t96-6.09932d-3*t111*t324-3.0496
     6           6d-3*t109*t111*t323-3.04966d-3*t169*t222-6.09932d-3*t10
     7           9*t168*t222-6.09932d-3*t111*t127*t168)+t126*(3.72017044
     8           624d-5*t109*t111*t222*t96+1.86008522312d-5*t127*t217*t9
     9           6-6.09932d-3*t111*t325+1.86008522312d-5*t109*t168*t217)
     :           -1.7017882504620419d-7*t109*t241*t450*t96+t28*(-5.15088
     ;           d-3*rhoa*t14*t17*t35*t454-5.15088d-3*rhoa*t111*t17*t238
     <           *t35-1.030176d-2*t14*t17*t222*t35-1.030176d-2*rhoa*t124
     =           *t17*t222*t35-6.4386d-4*gammaaa*t14*t15*t16*t222*t35-6.
     >           4386d-4*gammaaa*t111*t14*t16*t218*t35-1.030176d-2*t111*
     ?           t124*t17*t35-6.4386d-4*gammaaa*t111*t124*t15*t16*t35-1.
     @           030176d-2*t111*t239-5.15088d-3*rhoa*t111*t14*t17*t224-1
     1           .030176d-2*rhoa*t114*t14*t17*t222-5.15088d-3*t125*t222-
     2           1.030176d-2*t111*t114*t14*t17-1.030176d-2*rhoa*t111*t11
     3           4*t124*t17-6.4386d-4*gammaaa*t111*t114*t14*t15*t16)+2.5
     4           d-1*gammaaa*t14*t16*t23*t35*t451-8.199654381909689d-7*r
     5           hoa*t14*t17*t220*t35*t450+t15*t16*t23*(1.25d-1*gammaaa*
     6           t238*t35+1.25d-1*gammaaa*t14*t224+2.5d-1*gammaaa*t114*t
     7           124)+t112*(1.061262590976d-4*rhoa*t111*t14*t17*t222*t35
     8           +5.30631295488d-5*t14*t17*t217*t35+5.30631295488d-5*rho
     9           a*t124*t17*t217*t35-1.030176d-2*t111*t240+5.30631295488
     :           d-5*rhoa*t114*t14*t17*t217)+t15*t16*t28*(-1.28772d-3*ga
     ;           mmaaa*t14*t222*t35-1.28772d-3*gammaaa*t111*t124*t35-5.1
     <           5088d-3*t111*t219-1.28772d-3*gammaaa*t111*t114*t14)+t16
     =           *t218*t23*(-2.5d-1*gammaaa*t124*t35-2.5d-1*gammaaa*t114
     >           *t14)+1.93158d-3*gammaaa*t111*t14*t16*t218*t28*t35+1.98
     ?           98673580800003d-5*gammaaa*t112*t14*t15*t16*t217*t35)*wg
     @           ht+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (t98*(1.0d+0*t96*(-2.7108088888888
     1           89d-1*t105*t111*t126*t18*t53*taua*taub-5.92592592592592
     2           7d+1*t102*t105*t110*t53*taua*taub-3.7201704462400004d-4
     3           *t104*t105*t217*t241*t53*taub-1.8600852231200002d-4*t10
     4           0*t103*t217*t241*t53*taub+4.066213333333334d-2*t104*t10
     5           5*t126*t222*t53*taub+2.033106666666667d-2*t100*t103*t12
     6           6*t222*t53*taub+1.0165533333333335d-2*t102*t108*t222*t5
     7           3*taub-3.2592592592592595d+1*gammaaa*t102*t103*t221*t53
     8           *taub-6.200284077066667d-5*t108*t126*t217*t53*taub-1.08
     9           43235555555555d-1*gammaaa*t103*t110*t111*t126*t53*taub-
     :           7.440340892480001d-4*t104*t105*t111*t171*t18*t241*taua-
     ;           3.7201704462400004d-4*t100*t103*t111*t171*t18*t241*taua
     <           -1.2400568154133336d-4*t108*t111*t126*t171*t18*taua-1.0
     =           843235555555555d-1*gammabb*t103*t111*t126*t170*t18*taua
     >           -1.0843235555555557d-1*gammaaa*t103*t113*t126*t171*taua
     ?           -1.0843235555555557d-1*t104*t105*t110*t126*t171*taua-5.
     @           421617777777779d-2*t100*t103*t110*t126*t171*taua-2.7108
     1           08888888889d-2*t102*t108*t110*t171*taua-2.3703703703703
     2           702d+1*gammabb*t102*t103*t110*t170*taua-6.8071530018481
     3           67d-7*t101*t171*t217*t461*t99-8.674588444444443d-2*t126
     4           *t171*t223*t26*t99+5.580255669360001d-5*t101*t171*t222*
     5           t241*t99-2.976136356992001d-4*gammabb*t100*t170*t217*t2
     6           41*t99-5.952272713984d-4*gammaaa*t100*t110*t111*t171*t2
     7           41*t99+3.2529706666666663d-2*gammabb*t100*t126*t170*t22
     8           2*t99-1.1927559111111112d-1*gammaaa*t100*t126*t171*t221
     9           *t99-5.214814814814814d+1*gammaaa*gammabb*t102*t170*t22
     :           1*t99-1.7349176888888887d-1*gammaaa*gammabb*t110*t111*t
     ;           126*t170*t99-6.807153001848167d-7*t105*t106*t171*t217*t
     <           461-6.807153001848167d-7*t100*t103*t104*t171*t217*t461-
     =           1.3554044444444446d-1*t105*t126*t171*t208*t27+5.5802556
     >           69360001d-5*t105*t106*t171*t222*t241+5.580255669360001d
     ?           -5*t100*t103*t104*t171*t222*t241-1.7017882504620419d-7*
     @           t104*t108*t171*t217*t241-1.7017882504620419d-7*t100*t10
     1           7*t171*t217*t241-1.4880681784960004d-4*gammabb*t103*t10
     2           4*t170*t217*t241-2.976136356992d-4*gammaaa*t103*t104*t1
     3           10*t111*t171*t241+1.86008522312d-5*t104*t108*t126*t171*
     4           t222+1.86008522312d-5*t100*t107*t126*t171*t222+1.626485
     5           3333333332d-2*gammabb*t103*t104*t126*t170*t222+8.132426
     6           666666667d-3*gammabb*t102*t107*t170*t222-5.963779555555
     7           556d-2*gammaaa*t103*t104*t126*t171*t221-2.9818897777777
     8           78d-2*gammaaa*t102*t107*t171*t221-4.9602272616533327d-5
     9           *gammabb*t107*t126*t170*t217-9.920454523306665d-5*gamma
     :           aa*t107*t110*t111*t126*t171)+1.0d+0*t109*(t65*(-4.78463
     ;           74908957684d+0*t156*t301*t74*t91*t94-5.980796863619711d
     <           -2*t557*t69*t70*t91*t94-4.7846374908957684d-1*t156*t327
     =           *t70*t91*t94-7.176956236343652d-1*t189*t304*t70*t91*t94
     >           +1.4353912472687305d+0*t152*t304*t70*t91*t94+2.39231874
     ?           54478842d-1*t156*t297*t70*t91*t94-1.1961593727239421d+0
     @           *t189*t301*t69*t91*t94-2.3923187454478842d+0*t152*t301*
     1           t69*t91*t94+2.3923187454478842d-1*t154*t297*t69*t91*t94
     2           +1.9138549963583074d+0*t154*t156*t189*t91*t94-9.4872698
     3           26154375d-2*t156*t317*t74*t94-3.049479586978192d-2*t165
     4           *t304*t74*t94-2.3718174565385935d-2*t189*t317*t69*t94-4
     5           .743634913077187d-2*t152*t317*t69*t94+2.541232989148493
     6           d-3*t165*t297*t69*t94+2.0329863913187946d-2*t156*t165*t
     7           189*t94+7.694644203726144d+0*t141*t142*t156*t282*t70*t7
     8           4*t91-1.538928840745229d+1*t142*t156*t274*t279*t70*t74*
     9           t91+2.4749022066811444d+2*t156*t274*t275*t276*t70*t74*t
     :           91-6.155715362980916d+1*t140*t141*t142*t154*t156*t74*t9
     ;           1+1.923661050931536d+0*t140*t141*t142*t297*t69*t70*t91+
     <           1.923661050931536d+0*t141*t142*t189*t282*t69*t70*t91+3.
     =           847322101863072d+0*t141*t142*t152*t282*t69*t70*t91-3.84
     >           7322101863072d+0*t142*t189*t274*t279*t69*t70*t91-7.6946
     ?           44203726144d+0*t142*t152*t274*t279*t69*t70*t91+6.187255
     @           516702861d+1*t189*t274*t275*t276*t69*t70*t91+1.23745110
     1           33405722d+2*t152*t274*t275*t276*t69*t70*t91+1.538928840
     2           745229d+1*t140*t141*t142*t156*t189*t70*t91-1.5389288407
     3           45229d+1*t140*t141*t142*t154*t189*t69*t91-3.07785768149
     4           0458d+1*t140*t141*t142*t152*t154*t69*t91+1.975163132168
     5           0768d-2*(t568+t567+t566+t565+t564+t563+t562+t561+t560+t
     6           559+t558+1.923661050931536d+0*t557+t556+t555+t537)*t85*
     7           t89-4.5437964274821163d-4*t130*t310*t89+6.0583952366428
     8           22d-4*t194*t260*t89+1.2116790473285642d-3*t161*t260*t89
     9           -5.848223622634647d-1*t136*t137*t138*t310*t85-5.8482236
     :           22634647d-1*t137*t138*t194*t272*t85-1.1696447245269295d
     ;           +0*t137*t138*t161*t272*t85+1.1696447245269295d+0*t138*t
     <           194*t264*t269*t85+2.339289449053859d+0*t138*t161*t264*t
     =           269*t85-1.73158960813529d+1*t194*t264*t265*t266*t85-3.4
     >           6317921627058d+1*t161*t264*t265*t266*t85-6.21814d-2*(t5
     ?           68+t567+t566+t565+t564+t563+t562+t561+t560+t559+t558+t5
     @           56+t555+t537)*t67*t83+2.747773264188437d-3*t130*t306*t8
     1           3-3.663697685584583d-3*t192*t260*t83-7.327395371169166d
     2           -3*t158*t260*t83-6.538889093261956d-1*t140*t141*t142*t1
     3           56*t165*t74-1.6347222733154887d-1*t140*t141*t142*t165*t
     4           189*t69-3.2694445466309774d-1*t140*t141*t142*t152*t165*
     5           t69+1.0d+0*t132*t133*t134*t306*t67+1.0d+0*t133*t134*t19
     6           2*t262*t67+2.0d+0*t133*t134*t158*t262*t67-2.0d+0*t134*t
     7           192*t250*t255*t67-4.0d+0*t134*t158*t250*t255*t67+1.6081
     8           979498692536d+1*t192*t250*t251*t252*t67+3.2163958997385
     9           07d+1*t158*t250*t251*t252*t67+t573+t572+t571+t570+t569+
     :           t554+t553+t552+t551+t550+t544+t542+t541+t522+t520+t519+
     ;           t518+t517+t516+t515+t514+t513+t512+t511+t510+t509+t508+
     <           t507+t505+t504+t503+t502+t501+t500+t499+t498+t497+t496+
     =           t494+t489+t488+t487+t486+t485+t484+t483+t482+t481+2.690
     >           728393099896d-2*t130*t136*t137*t138*t194-8.837926660346
     ?           784d-2*t130*t132*t133*t134*t192+5.381456786199792d-2*t1
     @           30*t136*t137*t138*t161-1.767585332069357d-1*t130*t132*t
     1           133*t134*t158)-4.7846374908957684d-1*t156*t189*t70*t91*
     2           t94+9.569274981791537d-1*t152*t154*t69*t91*t94+1.016493
     3           1956593973d-2*t152*t165*t69*t94+7.694644203726144d+0*t1
     4           40*t141*t142*t152*t69*t70*t91-1.8175185709928465d-3*t13
     5           0*t161*t89-2.339289449053859d+0*t136*t137*t138*t161*t85
     6           +1.099109305675375d-2*t130*t158*t83+4.0d+0*t132*t133*t1
     7           34*t158*t67+t549+t548+t547+t478+t477+t476+t475+t474+t47
     8           3+t472+t471+t470+t469+t468+t467+t466+t465+t464+t463+t46
     9           2+t386+t385+t383+t380+t367+t366+t365+t336+t321+t319+t31
     :           4+t311+t307+t285)+2.0d+0*t127*t337+2.0d+0*t168*t326+1.0
     ;           d+0*t186*t323+1.0d+0*t197*t242)+t102*(-3.04966d-3*t111*
     <           t326*t96-3.04966d-3*t186*t222*t96-3.04966d-3*t111*t338-
     =           3.04966d-3*t109*t111*t337-3.04966d-3*t171*t324-3.04966d
     >           -3*t109*t197*t222-3.04966d-3*t111*t127*t197-3.04966d-3*
     ?           t111*t168*t186)+t126*(1.86008522312d-5*t186*t217*t96-6.
     @           09932d-3*t171*t325+1.86008522312d-5*t109*t197*t217)-1.7
     1           017882504620419d-7*t109*t171*t217*t241*t96)*wght+Amat3(
     2           iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (t98*(1.0d+0*t96*(-2.7108088888888
     1           89d-1*t105*t126*t171*t18*t53*taua*taub-5.92592592592592
     2           7d+1*t102*t105*t170*t18*taua*taub-7.440340892480001d-4*
     3           t104*t105*t111*t171*t241*t53*taub-3.7201704462400004d-4
     4           *t100*t103*t111*t171*t241*t53*taub-1.2400568154133336d-
     5           4*t108*t111*t126*t171*t53*taub-1.0843235555555555d-1*ga
     6           mmaaa*t103*t110*t126*t171*t53*taub-1.0843235555555555d-
     7           1*gammabb*t103*t111*t126*t173*taub-1.0843235555555555d-
     8           1*t104*t105*t111*t126*t170*taub-5.421617777777777d-2*t1
     9           00*t103*t111*t126*t170*taub-2.7108088888888887d-2*t102*
     :           t108*t111*t170*taub-2.3703703703703702d+1*gammaaa*t102*
     ;           t103*t110*t170*taub+4.066213333333334d-2*t104*t105*t126
     <           *t18*t345*taua+2.033106666666667d-2*t100*t103*t126*t18*
     =           t345*taua+1.0165533333333335d-2*t102*t108*t18*t345*taua
     >           -3.2592592592592595d+1*gammabb*t102*t103*t18*t344*taua-
     ?           3.7201704462400004d-4*t104*t105*t18*t241*t340*taua-1.86
     @           00852231200002d-4*t100*t103*t18*t241*t340*taua-6.200284
     1           077066668d-5*t108*t126*t18*t340*taua-1.0843235555555555
     2           d-1*gammabb*t103*t126*t170*t171*t18*taua-8.674588444444
     3           443d-2*t111*t126*t346*t59*t99-6.807153001848167d-7*t101
     4           *t111*t340*t461*t99+5.580255669360001d-5*t101*t111*t241
     5           *t345*t99+3.2529706666666663d-2*gammaaa*t100*t110*t126*
     6           t345*t99-1.1927559111111109d-1*gammabb*t100*t111*t126*t
     7           344*t99-5.214814814814814d+1*gammaaa*gammabb*t102*t110*
     8           t344*t99-2.976136356992d-4*gammaaa*t100*t110*t241*t340*
     9           t99-5.952272713984001d-4*gammabb*t100*t111*t170*t171*t2
     :           41*t99-1.7349176888888887d-1*gammaaa*gammabb*t110*t126*
     ;           t170*t171*t99-1.3554044444444446d-1*t105*t111*t126*t214
     <           *t60-6.807153001848167d-7*t105*t106*t111*t340*t461-6.80
     =           7153001848167d-7*t100*t103*t104*t111*t340*t461+5.580255
     >           669360001d-5*t105*t106*t111*t241*t345+5.580255669360001
     ?           d-5*t100*t103*t104*t111*t241*t345+1.86008522312d-5*t104
     @           *t108*t111*t126*t345+1.86008522312d-5*t100*t107*t111*t1
     1           26*t345+1.6264853333333332d-2*gammaaa*t103*t104*t110*t1
     2           26*t345+8.132426666666667d-3*gammaaa*t102*t107*t110*t34
     3           5-5.963779555555555d-2*gammabb*t103*t104*t111*t126*t344
     4           -2.9818897777777775d-2*gammabb*t102*t107*t111*t344-1.70
     5           17882504620419d-7*t104*t108*t111*t241*t340-1.7017882504
     6           620419d-7*t100*t107*t111*t241*t340-1.488068178496d-4*ga
     7           mmaaa*t103*t104*t110*t241*t340-4.9602272616533327d-5*ga
     8           mmaaa*t107*t110*t126*t340-2.976136356992001d-4*gammabb*
     9           t103*t104*t111*t170*t171*t241-9.920454523306665d-5*gamm
     :           abb*t107*t111*t126*t170*t171)+1.0d+0*t109*(t65*(4.78463
     ;           74908957684d+0*t156*t301*t74*t91*t94-5.980796863619711d
     <           -2*t574*t69*t70*t91*t94-2.3923187454478842d-1*t156*t373
     =           *t70*t91*t94+4.7846374908957684d-1*t156*t327*t70*t91*t9
     >           4+1.4353912472687305d+0*t189*t304*t70*t91*t94-7.1769562
     ?           36343652d-1*t152*t304*t70*t91*t94+2.3923187454478842d-1
     @           *t154*t373*t69*t91*t94-2.3923187454478842d+0*t189*t301*
     1           t69*t91*t94-1.1961593727239421d+0*t152*t301*t69*t91*t94
     2           -1.9138549963583074d+0*t152*t154*t156*t91*t94+9.4872698
     3           26154374d-2*t156*t317*t74*t94-3.0494795869781915d-2*t16
     4           5*t304*t74*t94+2.541232989148493d-3*t165*t373*t69*t94-4
     5           .743634913077187d-2*t189*t317*t69*t94-2.371817456538593
     6           5d-2*t152*t317*t69*t94-2.0329863913187946d-2*t152*t156*
     7           t165*t94-7.694644203726144d+0*t141*t142*t156*t282*t70*t
     8           74*t91+1.538928840745229d+1*t142*t156*t274*t279*t70*t74
     9           *t91-2.4749022066811444d+2*t156*t274*t275*t276*t70*t74*
     :           t91+6.155715362980916d+1*t140*t141*t142*t154*t156*t74*t
     ;           91+1.923661050931536d+0*t140*t141*t142*t373*t69*t70*t91
     <           +3.847322101863072d+0*t141*t142*t189*t282*t69*t70*t91+1
     =           .923661050931536d+0*t141*t142*t152*t282*t69*t70*t91-7.6
     >           94644203726144d+0*t142*t189*t274*t279*t69*t70*t91-3.847
     ?           322101863072d+0*t142*t152*t274*t279*t69*t70*t91+1.23745
     @           11033405722d+2*t189*t274*t275*t276*t69*t70*t91+6.187255
     1           516702861d+1*t152*t274*t275*t276*t69*t70*t91-1.53892884
     2           0745229d+1*t140*t141*t142*t152*t156*t70*t91-3.077857681
     3           490458d+1*t140*t141*t142*t154*t189*t69*t91-1.5389288407
     4           45229d+1*t140*t141*t142*t152*t154*t69*t91+1.97516313216
     5           80768d-2*(t584+t583+t582+t581+t580+t579+t578+t577+t576+
     6           t575+1.923661050931536d+0*t574+t567+t555+t540+t537)*t85
     7           *t89-4.5437964274821163d-4*t130*t381*t89+1.211679047328
     8           5642d-3*t194*t260*t89+6.058395236642822d-4*t161*t260*t8
     9           9-5.848223622634647d-1*t136*t137*t138*t381*t85-1.169644
     :           7245269295d+0*t137*t138*t194*t272*t85-5.848223622634647
     ;           d-1*t137*t138*t161*t272*t85+2.339289449053859d+0*t138*t
     <           194*t264*t269*t85+1.1696447245269295d+0*t138*t161*t264*
     =           t269*t85-3.46317921627058d+1*t194*t264*t265*t266*t85-1.
     >           73158960813529d+1*t161*t264*t265*t266*t85-6.21814d-2*(t
     ?           584+t583+t582+t581+t580+t579+t578+t577+t576+t575+t567+t
     @           555+t540+t537)*t67*t83+2.747773264188437d-3*t130*t378*t
     1           83-7.327395371169166d-3*t192*t260*t83-3.663697685584583
     2           d-3*t158*t260*t83+6.538889093261955d-1*t140*t141*t142*t
     3           156*t165*t74-3.2694445466309774d-1*t140*t141*t142*t165*
     4           t189*t69-1.6347222733154887d-1*t140*t141*t142*t152*t165
     5           *t69+1.0d+0*t132*t133*t134*t378*t67+2.0d+0*t133*t134*t1
     6           92*t262*t67+1.0d+0*t133*t134*t158*t262*t67-4.0d+0*t134*
     7           t192*t250*t255*t67-2.0d+0*t134*t158*t250*t255*t67+3.216
     8           395899738507d+1*t192*t250*t251*t252*t67+1.6081979498692
     9           536d+1*t158*t250*t251*t252*t67+t572+t571+t570+t569+t554
     :           +t553+t552+t551+t550+t546+t544+t542+t541+t522+t520+t519
     ;           +t518+t517+t516+t515+t514+t513+t512+t511+t510+t509+t508
     <           +t507+t505+t504+t503+t502+t501+t500+t499+t498+t497+t496
     =           +t494+t489+t488+t487+t486+t485+t484+t483+t482+t481+5.38
     >           1456786199792d-2*t130*t136*t137*t138*t194-1.76758533206
     ?           9357d-1*t130*t132*t133*t134*t192+2.690728393099896d-2*t
     @           130*t136*t137*t138*t161-8.837926660346784d-2*t130*t132*
     1           t133*t134*t158)+4.7846374908957684d-1*t152*t156*t70*t91
     2           *t94+9.569274981791537d-1*t154*t189*t69*t91*t94+1.01649
     3           31956593973d-2*t165*t189*t69*t94+7.694644203726144d+0*t
     4           140*t141*t142*t189*t69*t70*t91-1.8175185709928465d-3*t1
     5           30*t194*t89-2.339289449053859d+0*t136*t137*t138*t194*t8
     6           5+1.099109305675375d-2*t130*t192*t83+4.0d+0*t132*t133*t
     7           134*t192*t67+t549+t548+t547+t478+t477+t476+t475+t474+t4
     8           73+t472+t471+t470+t469+t468+t467+t466+t465+t464+t463+t4
     9           62+t388+t387+t384+t382+t379+t368+t336+t316+t315+t312+t3
     :           08+t278+t268+t254)+1.0d+0*t127*t389+1.0d+0*t168*t364+2.
     ;           0d+0*t186*t337+2.0d+0*t197*t326)+t102*(-3.04966d-3*t111
     <           *t364*t96-3.04966d-3*t109*t111*t389-3.04966d-3*t169*t34
     =           5-6.09932d-3*t171*t338-6.09932d-3*t111*t186*t197)+t126*
     >           (1.86008522312d-5*t109*t111*t345*t96+1.86008522312d-5*t
     ?           111*t171*t186*t96-6.09932d-3*t171*t339+1.86008522312d-5
     @           *t109*t111*t171*t197)-1.7017882504620419d-7*t109*t111*t
     1           241*t340*t96)*wght+Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (t98*(1.0d+0*t96*(-3.2592592592592
     1           595d+1*t108*t344*t98*taub+1.2198640000000001d-1*t104*t1
     2           05*t126*t345*t53*taub+6.09932d-2*t100*t103*t126*t345*t5
     3           3*taub+3.04966d-2*t102*t108*t345*t53*taub-1.11605113387
     4           20001d-3*t104*t105*t241*t340*t53*taub-5.58025566936d-4*
     5           t100*t103*t241*t340*t53*taub-1.8600852231200002d-4*t108
     6           *t126*t340*t53*taub-1.6888888888888892d+2*gammabb*t102*
     7           t103*t346*taub-6.518518518518519d+1*t102*t104*t105*t344
     8           *taub-3.2592592592592595d+1*t100*t102*t103*t344*taub-3.
     9           252970666666667d-1*gammabb*t103*t126*t171*t173*taub-3.2
     :           52970666666667d-1*t104*t105*t126*t170*t171*taub-1.62648
     ;           53333333334d-1*t100*t103*t126*t170*t171*taub-8.13242666
     <           6666668d-2*t102*t108*t170*t171*taub-1.5644444444444447d
     =           +2*t102*t59*t590*t99-2.602376533333333d-1*t126*t171*t34
     >           6*t59*t99-6.09932d-3*t101*t126*t589*t99-9.1259259259259
     ?           25d+1*gammabb*t100*t102*t588*t99-6.807153001848167d-7*t
     @           101*t461*t585*t99+1.6740767008080004d-4*t101*t171*t241*
     1           t345*t99+9.758912d-2*gammabb*t100*t126*t170*t345*t99-3.
     2           578267733333333d-1*gammabb*t100*t126*t171*t344*t99-8.92
     3           8409070976d-4*gammabb*t100*t170*t241*t340*t99-4.5629629
     4           629629626d+1*gammabb*t107*t588*t98-4.066213333333334d-1
     5           *t105*t126*t171*t214*t60-6.09932d-3*t105*t106*t126*t589
     6           -6.09932d-3*t100*t103*t104*t126*t589-3.04966d-3*t102*t1
     7           04*t108*t589-3.04966d-3*t100*t102*t107*t589-4.562962962
     8           9629626d+1*gammabb*t102*t103*t104*t588-6.80715300184816
     9           7d-7*t105*t106*t461*t585-6.807153001848167d-7*t100*t103
     :           *t104*t461*t585-1.7017882504620419d-7*t104*t108*t241*t5
     ;           85-1.7017882504620419d-7*t100*t107*t241*t585+1.67407670
     <           08080004d-4*t105*t106*t171*t241*t345+1.6740767008080004
     =           d-4*t100*t103*t104*t171*t241*t345+5.580255669359999d-5*
     >           t104*t108*t126*t171*t345+5.580255669359999d-5*t100*t107
     ?           *t126*t171*t345+4.879456d-2*gammabb*t103*t104*t126*t170
     @           *t345+2.439728d-2*gammabb*t102*t107*t170*t345-1.7891338
     1           666666665d-1*gammabb*t103*t104*t126*t171*t344-8.9456693
     2           33333333d-2*gammabb*t102*t107*t171*t344-4.464204535488d
     3           -4*gammabb*t103*t104*t170*t241*t340-1.4880681784959998d
     4           -4*gammabb*t107*t126*t170*t340-1.777777777777778d+2*t10
     5           2*t105*t173*t214)+1.0d+0*t109*(t65*(1.4353912472687305d
     6           +1*t156*t301*t74*t91*t94-5.980796863619711d-2*t596*t69*
     7           t70*t91*t94+7.176956236343652d-1*t156*t373*t70*t91*t94-
     8           2.1530868709030954d+0*t189*t304*t70*t91*t94+7.176956236
     9           343652d-1*t154*t373*t69*t91*t94-3.588478118171826d+0*t1
     :           89*t301*t69*t91*t94-5.741564989074922d+0*t154*t156*t189
     ;           *t91*t94+2.8461809478463124d-1*t156*t317*t74*t94+7.6236
     <           98967445479d-3*t165*t373*t69*t94-7.11545236961578d-2*t1
     =           89*t317*t69*t94-6.098959173956384d-2*t156*t165*t189*t94
     >           -2.3083932611178434d+1*t141*t142*t156*t282*t70*t74*t91+
     ?           4.616786522235687d+1*t142*t156*t274*t279*t70*t74*t91-7.
     @           424706620043432d+2*t156*t274*t275*t276*t70*t74*t91+1.84
     1           67146088942746d+2*t140*t141*t142*t154*t156*t74*t91+5.77
     2           0983152794609d+0*t140*t141*t142*t373*t69*t70*t91+5.7709
     3           83152794609d+0*t141*t142*t189*t282*t69*t70*t91-1.154196
     4           6305589217d+1*t142*t189*t274*t279*t69*t70*t91+1.8561766
     5           55010858d+2*t189*t274*t275*t276*t69*t70*t91-4.616786522
     6           235687d+1*t140*t141*t142*t156*t189*t70*t91-4.6167865222
     7           35687d+1*t140*t141*t142*t154*t189*t69*t91+1.97516313216
     8           80768d-2*(t603+t602+t601+t600+t599+t598+t597+1.92366105
     9           0931536d+0*t596+t568+t539+t537)*t85*t89-1.3631389282446
     :           35d-3*t130*t381*t89+1.8175185709928465d-3*t194*t260*t89
     ;           -1.7544670867903941d+0*t136*t137*t138*t381*t85-1.754467
     <           0867903941d+0*t137*t138*t194*t272*t85+3.508934173580788
     =           3d+0*t138*t194*t264*t269*t85-5.19476882440587d+1*t194*t
     >           264*t265*t266*t85-6.21814d-2*(t603+t602+t601+t600+t599+
     ?           t598+t597+t568+t539+t537)*t67*t83+8.243319792565312d-3*
     @           t130*t378*t83-1.099109305675375d-2*t192*t260*t83+1.9616
     1           667279785865d+0*t140*t141*t142*t156*t165*t74-4.90416681
     2           9946466d-1*t140*t141*t142*t165*t189*t69+3.0d+0*t132*t13
     3           3*t134*t378*t67+3.0d+0*t133*t134*t192*t262*t67-6.0d+0*t
     4           134*t192*t250*t255*t67+4.824593849607761d+1*t192*t250*t
     5           251*t252*t67+t573+t545+t544+t543+t542+t541+t522+t521+t5
     6           20+t519+t518+t517+t516+t515+t514+t513+t512+t511+t510+t5
     7           09+t508+t507+t505+t504+t503+t502+t501+t500+t499+t498+t4
     8           97+t496+t494+t489+t488+t487+t486+t485+t484+t483+t482+t4
     9           81+8.072185179299687d-2*t130*t136*t137*t138*t194-2.6513
     :           779981040353d-1*t130*t132*t133*t134*t192)-5.74156498907
     ;           4922d+0*t154*t156*t74*t91*t94-1.794239059085913d-1*t373
     <           *t69*t70*t91*t94+1.4353912472687305d+0*t156*t189*t70*t9
     =           1*t94+1.4353912472687305d+0*t154*t189*t69*t91*t94-6.098
     >           959173956384d-2*t156*t165*t74*t94+1.524739793489096d-2*
     ?           t165*t189*t69*t94-4.616786522235687d+1*t140*t141*t142*t
     @           156*t70*t74*t91+1.1541966305589217d+1*t140*t141*t142*t1
     1           89*t69*t70*t91+5.92548939650423d-2*t381*t85*t89-2.72627
     2           785648927d-3*t130*t194*t89-3.5089341735807883d+0*t136*t
     3           137*t138*t194*t85-1.865442d-1*t378*t67*t83+1.6486639585
     4           130625d-2*t130*t192*t83+6.0d+0*t132*t133*t134*t192*t67-
     5           rhob*t595-3.3306690738754696d-16*t175*t180*t355*t48+6.6
     6           61338147750939d-16*t175*t349*t351*t48-5.356375176299456
     7           d-15*t348*t349*t350*t48+t479+t478+t477+t476+t475+t474+t
     8           473+t472+t471+t470+1.2202564577405706d-18*t353*t47+t469
     9           +t468+t467+t466+t465+t464+t463+t462-3.0d+0*t181*t183*t3
     :           60*t44+6.0d+0*t181*t357*t359*t44-9.649187699215522d+1*t
     ;           356*t357*t358*t44+5.284159572535705d-3*t353*t43+2.54939
     <           2377400174d-1*t177*t181*t182*t183+2.943620900479655d-17
     =           *t175*t177*t179*t180)+3.0d+0*t186*t389+3.0d+0*t197*t364
     >           )+t58*(1.0d+0*rhob*t49*t52*(-6.518518518518519d+1*t31*t
     ?           344*t61*t62*taub+2.060352d-1*t172*t31*t345*t53*t62*taub
     @           -3.183787772928d-3*t31*t340*t343*t53*t62*taub-5.494272d
     1           -1*t170*t171*t172*t31*t62*taub+5.15088d-2*t34*t345*t53*
     2           t61*taub-2.0148148148148146d+2*gammabb*t29*t346*t61*tau
     3           b-1.373568d-1*t170*t171*t34*t61*taub+1.030176d-1*gammab
     4           b*t172*t29*t345*t60*taub-1.591893886464d-3*gammabb*t29*
     5           t340*t343*t60*taub-3.2592592592592595d+1*t34*t344*t58*t
     6           aub-5.30631295488d-4*t172*t34*t340*t53*taub-8.241408d-1
     7           *gammabb*t171*t172*t173*t29*taub-1.030176d-2*t172*t31*t
     8           589*t63-3.2798617527638757d-6*t31*t585*t587*t63+4.77568
     9           16593920004d-4*t171*t31*t343*t345*t63-5.15088d-3*t34*t5
     :           89*t61*t62-4.5629629629629626d+1*gammabb*t29*t588*t61*t
     ;           62-1.030176d-2*gammabb*t172*t29*t53*t589*t62-3.27986175
     <           27638757d-6*gammabb*t29*t53*t585*t587*t62-8.19965438190
     =           9689d-7*t34*t343*t585*t62+4.7756816593920004d-4*gammabb
     >           *t171*t29*t343*t345*t53*t62+1.591893886464d-4*t171*t172
     ?           *t34*t345*t62+8.241408d-2*gammabb*t170*t172*t29*t345*t6
     @           2-3.0218496d-1*gammabb*t171*t172*t29*t344*t62-1.2735151
     1           091712002d-3*gammabb*t170*t29*t340*t343*t62-2.477037037
     2           037037d+2*t25*t59*t590*t61-5.15088d-3*gammabb*t33*t53*t
     3           589*t61+4.120704d-2*gammabb*t170*t33*t345*t61-1.5109248
     4           d-1*gammabb*t171*t33*t344*t61-1.777777777777778d+2*t173
     5           *t214*t31*t61-1.030176d-2*t172*t25*t589*t59*t60-3.27986
     6           17527638757d-6*t25*t585*t587*t59*t60+4.7756816593920004
     7           d-4*t171*t25*t343*t345*t59*t60-6.867840000000001d-1*t17
     8           1*t172*t214*t31*t60-1.0439116799999999d+0*t171*t172*t25
     9           *t346*t59+1.6482816d-1*t172*t173*t25*t345*t59-2.5470302
     :           183424004d-3*t173*t25*t340*t343*t59-4.5629629629629626d
     ;           +1*gammabb*t33*t58*t588-8.199654381909689d-7*gammabb*t3
     <           3*t343*t53*t585+1.591893886464d-4*gammabb*t171*t172*t33
     =           *t345*t53-4.245050363904d-4*gammabb*t170*t172*t33*t340)
     >           +1.0d+0*rhob*t52*t595*t64-2.5d-1*gammabb*t49*t51*t586*t
     ?           64+3.0d+0*t361*t52*t64+2.5d-1*gammabb*t361*t50*t51*t64+
     @           2.5d-1*gammabb*t184*t341*t51*t64+3.0d+0*t347*t49*t52+3.
     1           0d+0*rhob*t174*t361*t52+3.0d+0*rhob*t184*t347*t52+6.0d+
     2           0*t174*t184*t52+2.5d-1*gammabb*t347*t49*t50*t51+5.0d-1*
     3           gammabb*t174*t184*t50*t51+2.5d-1*gammabb*t174*t341*t49*
     4           t51)+t102*(-3.04966d-3*t109*t589*t96-3.04966d-3*t171*t3
     5           64*t96-6.09932d-3*t186*t345*t96-6.09932d-3*t171*t390-3.
     6           04966d-3*t109*t171*t389-3.04966d-3*t198*t345-6.09932d-3
     7           *t109*t197*t345-6.09932d-3*t171*t186*t197)+t126*(3.7201
     8           7044624d-5*t109*t171*t345*t96+1.86008522312d-5*t186*t34
     9           0*t96-6.09932d-3*t171*t391+1.86008522312d-5*t109*t197*t
     :           340)-1.7017882504620419d-7*t109*t241*t585*t96+t61*(-5.1
     ;           5088d-3*rhob*t49*t52*t589*t64-1.030176d-2*t345*t49*t52*
     <           t64-5.15088d-3*rhob*t171*t361*t52*t64-1.030176d-2*rhob*
     =           t184*t345*t52*t64-1.030176d-2*t171*t184*t52*t64-6.4386d
     >           -4*gammabb*t345*t49*t50*t51*t64-6.4386d-4*gammabb*t171*
     ?           t184*t50*t51*t64-6.4386d-4*gammabb*t171*t341*t49*t51*t6
     @           4-5.15088d-3*rhob*t171*t347*t49*t52-1.030176d-2*rhob*t1
     1           74*t345*t49*t52-1.030176d-2*t171*t174*t49*t52-1.030176d
     2           -2*rhob*t171*t174*t184*t52-6.4386d-4*gammabb*t171*t174*
     3           t49*t50*t51-1.030176d-2*t171*t362-5.15088d-3*t185*t345)
     4           +t172*(1.061262590976d-4*rhob*t171*t345*t49*t52*t64+5.3
     5           0631295488d-5*t340*t49*t52*t64+5.30631295488d-5*rhob*t1
     6           84*t340*t52*t64+5.30631295488d-5*rhob*t174*t340*t49*t52
     7           -1.030176d-2*t171*t363)+t50*t51*t61*(-1.28772d-3*gammab
     8           b*t345*t49*t64-1.28772d-3*gammabb*t171*t184*t64-1.28772
     9           d-3*gammabb*t171*t174*t49-5.15088d-3*t171*t342)+t50*t51
     :           *t58*(1.25d-1*gammabb*t361*t64+1.25d-1*gammabb*t347*t49
     ;           +2.5d-1*gammabb*t174*t184)+t341*t51*t58*(-2.5d-1*gammab
     <           b*t184*t64-2.5d-1*gammabb*t174*t49)+1.93158d-3*gammabb*
     =           t171*t341*t49*t51*t61*t64+2.5d-1*gammabb*t49*t51*t58*t5
     >           86*t64-8.199654381909689d-7*rhob*t343*t49*t52*t585*t64+
     ?           1.9898673580800003d-5*gammabb*t172*t340*t49*t50*t51*t64
     @           )*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t23*(1.0d+0*rhoa*t14*t17*(-4.578
     1           56d-1*gammaaa*t112*t29*t393*taua-1.373568d-1*t113*t28*t
     2           34*taua-3.53754196992d-4*t111*t112*t27*t34*taua-2.12252
     3           5181952d-3*t111*t220*t27*t30*t31*taua-5.494272d-1*t112*
     4           t113*t30*t31*taua+2.6666666666666666d+1*t113*t28*t29*ta
     5           ua+6.867840000000001d-2*t111*t112*t27*t29*taua-1.061262
     6           590976d-3*gammaaa*t111*t199*t220*t29*taua-7.4172672d-1*
     7           t112*t25*t26*t605-3.2798617527638757d-6*t18*t217*t31*t3
     8           2*t452-3.2798617527638757d-6*gammaaa*t217*t27*t29*t30*t
     9           452-3.2798617527638757d-6*t199*t217*t25*t26*t452-2.5470
     :           302183424004d-3*t111*t220*t25*t26*t393-5.036416d-2*t221
     ;           *t28*t30*t34+5.30631295488d-5*t112*t18*t222*t30*t34-8.1
     <           99654381909689d-7*t18*t217*t220*t30*t34-2.830033575936d
     =           -4*t110*t111*t112*t30*t34-1.7398528000000002d-1*gammaaa
     >           *t223*t28*t33-5.15088d-3*t18*t222*t28*t33+2.747136d-2*t
     ?           110*t111*t28*t33+5.30631295488d-5*gammaaa*t112*t222*t27
     @           *t33-8.199654381909689d-7*gammaaa*t217*t220*t27*t33+9.7
     1           77777777777779d+0*t221*t23*t33+5.30631295488d-5*t112*t1
     2           8*t217*t33-5.660067151872d-4*gammaaa*t111*t112*t113*t33
     3           +1.591893886464d-4*t18*t220*t222*t31*t32-1.007283200000
     4           0001d-1*t112*t221*t31*t32-8.490100727808d-4*t110*t111*t
     5           220*t31*t32-2.2892800000000002d-1*t112*t199*t208*t31+9.
     6           777777777777779d+0*t221*t28*t29*t30+1.591893886464d-4*g
     7           ammaaa*t220*t222*t27*t29*t30-3.4797056000000004d-1*gamm
     8           aaa*t112*t223*t29*t30-1.030176d-2*t112*t18*t222*t29*t30
     9           +1.591893886464d-4*t18*t217*t220*t29*t30-1.698020145561
     :           6d-3*gammaaa*t111*t113*t220*t29*t30+5.494272d-2*t110*t1
     ;           11*t112*t29*t30+6.755555555555556d+1*gammaaa*t223*t25*t
     <           28-2.060352d-2*gammaaa*t112*t222*t25*t27+3.183787772928
     =           d-4*gammaaa*t217*t220*t25*t27+1.591893886464d-4*t199*t2
     >           20*t222*t25*t26+2.1977088d-1*gammaaa*t111*t112*t113*t25
     ?           )+2.0d+0*t14*t17*t394+2.0d+0*rhoa*t124*t17*t394+1.25d-1
     @           *gammaaa*t14*t15*t16*t394-1.25d-1*t16*t238*t35+1.25d-1*
     1           t14*t16*t218*t35-1.25d-1*t124*t15*t16*t35+1.0d+0*rhoa*t
     2           17*t200*t238-1.25d-1*t14*t16*t224+1.25d-1*gammaaa*t14*t
     3           16*t200*t218+2.0d+0*t124*t17*t200+1.25d-1*gammaaa*t124*
     4           t15*t16*t200-1.25d-1*t114*t14*t15*t16-2.5d-1*t114*t124*
     5           t16)+t98*(1.0d+0*t96*(-1.0843235555555557d-1*gammaaa*t1
     6           03*t126*t393*taua-7.440340892480001d-4*t104*t105*t111*t
     7           241*t27*taua-3.7201704462400004d-4*t100*t103*t111*t241*
     8           t27*taua-1.2400568154133336d-4*t108*t111*t126*t27*taua+
     9           4.066213333333334d-2*t103*t111*t126*t27*taua-3.25297066
     :           6666667d-1*t104*t105*t113*t126*taua-1.6264853333333334d
     ;           -1*t100*t103*t113*t126*taua-8.132426666666668d-2*t102*t
     <           108*t113*taua+2.6666666666666666d+1*t102*t103*t113*taua
     =           -8.674588444444443d-2*t126*t26*t605*t99-6.8071530018481
     >           67d-7*t101*t18*t217*t461*t99+5.580255669360001d-5*t101*
     ?           t18*t222*t241*t99+1.1160511338720001d-4*t100*t18*t217*t
     @           241*t99-5.952272713984d-4*gammaaa*t100*t111*t113*t241*t
     1           99-2.976136356992001d-4*t101*t110*t111*t241*t99-2.92767
     2           36d-1*gammaaa*t100*t126*t223*t99+48*gammaaa*t102*t223*t
     3           99-1.219864d-2*t100*t126*t18*t222*t99-5.963779555555556
     4           d-2*t101*t126*t221*t99+1.9555555555555557d+1*t100*t102*
     5           t221*t99+6.505941333333333d-2*gammaaa*t111*t113*t126*t9
     6           9+6.505941333333333d-2*t100*t110*t111*t126*t99+9.777777
     7           777777779d+0*t107*t221*t98-6.807153001848167d-7*t105*t1
     8           06*t18*t217*t461-6.807153001848167d-7*t100*t103*t104*t1
     9           8*t217*t461+5.580255669360001d-5*t105*t106*t18*t222*t24
     :           1+5.580255669360001d-5*t100*t103*t104*t18*t222*t241-1.7
     ;           017882504620419d-7*t104*t108*t18*t217*t241-1.7017882504
     <           620419d-7*t100*t107*t18*t217*t241+5.580255669360001d-5*
     =           t103*t104*t18*t217*t241-2.976136356992d-4*gammaaa*t103*
     >           t104*t111*t113*t241-2.976136356992001d-4*t105*t106*t110
     ?           *t111*t241-2.976136356992001d-4*t100*t103*t104*t110*t11
     @           1*t241-1.4638368d-1*gammaaa*t103*t104*t126*t223-7.31918
     1           4d-2*gammaaa*t102*t107*t223+1.86008522312d-5*t104*t108*
     2           t126*t18*t222+1.86008522312d-5*t100*t107*t126*t18*t222-
     3           6.09932d-3*t103*t104*t126*t18*t222-3.04966d-3*t102*t107
     4           *t18*t222-5.963779555555556d-2*t105*t106*t126*t221-5.96
     5           3779555555556d-2*t100*t103*t104*t126*t221-2.98188977777
     6           7778d-2*t102*t104*t108*t221-2.981889777777778d-2*t100*t
     7           102*t107*t221+9.777777777777779d+0*t102*t103*t104*t221+
     8           1.86008522312d-5*t107*t126*t18*t217-1.3554044444444446d
     9           -1*t105*t126*t199*t208-9.920454523306665d-5*gammaaa*t10
     :           7*t111*t113*t126-9.920454523306665d-5*t104*t108*t110*t1
     ;           11*t126-9.920454523306665d-5*t100*t107*t110*t111*t126+3
     <           .2529706666666663d-2*t103*t104*t110*t111*t126+1.6264853
     =           333333332d-2*t102*t107*t110*t111)+2.0d+0*t168*t397+1.0d
     >           +0*t201*t323)+t102*(-3.04966d-3*t111*t397*t96-3.04966d-
     ?           3*t201*t222*t96-2.981889777777778d-2*t109*t221*t96+8.13
     @           2426666666667d-3*t110*t127*t96-3.04966d-3*t111*t398-3.0
     1           4966d-3*t111*t168*t201+8.132426666666667d-3*t110*t169+8
     2           .132426666666667d-3*t109*t110*t168)-1.7017882504620419d
     3           -7*t109*t18*t217*t241*t96+1.86008522312d-5*t126*t201*t2
     4           17*t96-9.920454523306665d-5*t109*t110*t111*t126*t96+t16
     5           *t218*t23*t604+t28*(-5.15088d-3*t111*t395-5.15088d-3*rh
     6           oa*t111*t14*t17*t394+6.4386d-4*t14*t16*t222*t35+1.37356
     7           8d-2*t124*t17*t18*t35-3.662848000000001d-2*t110*t14*t17
     8           *t35+6.4386d-4*t111*t14*t15*t16*t35+6.4386d-4*t111*t124
     9           *t16*t35-5.15088d-3*rhoa*t14*t17*t200*t222-5.15088d-3*t
     :           111*t14*t17*t200-5.15088d-3*rhoa*t111*t124*t17*t200+1.3
     ;           73568d-2*t114*t14*t17*t18+6.4386d-4*t111*t114*t14*t16+1
     <           .373568d-2*t110*t125)+t15*t16*t23*(1.25d-1*gammaaa*t14*
     =           t394+1.25d-1*t124*t35+1.25d-1*gammaaa*t124*t200+1.25d-1
     >           *t114*t14)+t112*t18*(-2.830033575936d-4*t111*t14*t17*t3
     ?           5-1.030176d-2*t240)+t15*t16*t28*(-1.28772d-3*t111*t14*t
     @           35-1.28772d-3*gammaaa*t111*t14*t200)+4.07778d-3*gammaaa
     1           *t14*t16*t221*t28*t35-8.199654381909689d-7*t14*t17*t20*
     2           t217*t220*t35-6.6328911936d-6*t112*t14*t16*t217*t35+1.3
     3           2657823872d-5*gammaaa*t110*t111*t112*t14*t16*t35-6.0993
     4           2d-3*t126*t18*t325-3.04966d-3*t102*t18*t324-5.15088d-3*
     5           t18*t239*t28-5.15088d-3*t110*t16*t219*t28+5.30631295488
     6           d-5*rhoa*t112*t14*t17*t200*t217)*wght+Cmat3(iq,D3_RA_RA
     7           _GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = (t98*(1.0d+0*t96*(-7.440340892480
     1           001d-4*t104*t105*t111*t18*t241*t53*taua-3.7201704462400
     2           004d-4*t100*t103*t111*t18*t241*t53*taua-1.2400568154133
     3           336d-4*t108*t111*t126*t18*t53*taua+4.066213333333334d-2
     4           *t103*t111*t126*t18*t53*taua-1.0843235555555557d-1*gamm
     5           aaa*t103*t113*t126*t53*taua-1.0843235555555557d-1*t104*
     6           t105*t110*t126*t53*taua-5.421617777777779d-2*t100*t103*
     7           t110*t126*t53*taua-2.710808888888889d-2*t102*t108*t110*
     8           t53*taua+8.88888888888889d+0*t102*t103*t110*t53*taua-6.
     9           807153001848167d-7*t101*t217*t461*t53*t99-8.67458844444
     :           4443d-2*t126*t223*t26*t53*t99+5.580255669360001d-5*t101
     ;           *t222*t241*t53*t99+1.1160511338720001d-4*t100*t217*t241
     <           *t53*t99-5.952272713984d-4*gammaaa*t100*t110*t111*t241*
     =           t53*t99-1.219864d-2*t100*t126*t222*t53*t99-1.1927559111
     >           111112d-1*gammaaa*t100*t126*t221*t53*t99+1.955555555555
     ?           5557d+1*gammaaa*t102*t221*t53*t99+6.505941333333333d-2*
     @           gammaaa*t110*t111*t126*t53*t99-6.807153001848167d-7*t10
     1           5*t106*t217*t461*t53-6.807153001848167d-7*t100*t103*t10
     2           4*t217*t461*t53-1.3554044444444446d-1*t105*t126*t208*t2
     3           7*t53+5.580255669360001d-5*t105*t106*t222*t241*t53+5.58
     4           0255669360001d-5*t100*t103*t104*t222*t241*t53-1.7017882
     5           504620419d-7*t104*t108*t217*t241*t53-1.7017882504620419
     6           d-7*t100*t107*t217*t241*t53+5.580255669360001d-5*t103*t
     7           104*t217*t241*t53-2.976136356992d-4*gammaaa*t103*t104*t
     8           110*t111*t241*t53+1.86008522312d-5*t104*t108*t126*t222*
     9           t53+1.86008522312d-5*t100*t107*t126*t222*t53-6.09932d-3
     :           *t103*t104*t126*t222*t53-3.04966d-3*t102*t107*t222*t53-
     ;           5.963779555555556d-2*gammaaa*t103*t104*t126*t221*t53-2.
     <           981889777777778d-2*gammaaa*t102*t107*t221*t53+1.8600852
     =           2312d-5*t107*t126*t217*t53-9.920454523306665d-5*gammaaa
     >           *t107*t110*t111*t126*t53)+2.0d+0*t168*t399+1.0d+0*t204*
     ?           t323)+t102*(-3.04966d-3*t111*t399*t96-3.04966d-3*t204*t
     @           222*t96-3.04966d-3*t111*t400-3.04966d-3*t111*t168*t204)
     1           -1.7017882504620419d-7*t109*t217*t241*t53*t96+1.8600852
     2           2312d-5*t126*t204*t217*t96-6.09932d-3*t126*t325*t53-3.0
     3           4966d-3*t102*t324*t53)*wght+Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (t98*(1.0d+0*t96*(-1.355404444444
     1           4446d-1*t105*t126*t27*t53*taua*taub-3.7201704462400004d
     2           -4*t104*t105*t111*t18*t241*t53*taub-1.8600852231200002d
     3           -4*t100*t103*t111*t18*t241*t53*taub-6.200284077066668d-
     4           5*t108*t111*t126*t18*t53*taub+2.033106666666667d-2*t103
     5           *t111*t126*t18*t53*taub-5.421617777777779d-2*gammaaa*t1
     6           03*t113*t126*t53*taub-1.0843235555555555d-1*t104*t105*t
     7           110*t126*t53*taub-5.421617777777777d-2*t100*t103*t110*t
     8           126*t53*taub-2.7108088888888887d-2*t102*t108*t110*t53*t
     9           aub+8.88888888888889d+0*t102*t103*t110*t53*taub-3.72017
     :           04462400004d-4*t104*t105*t171*t241*t27*taua-1.860085223
     ;           1200002d-4*t100*t103*t171*t241*t27*taua-6.2002840770666
     <           68d-5*t108*t126*t171*t27*taua+2.033106666666667d-2*t103
     =           *t126*t171*t27*taua-5.421617777777779d-2*gammabb*t103*t
     >           126*t170*t27*taua-6.807153001848167d-7*t101*t111*t171*t
     ?           18*t461*t99+1.1160511338720001d-4*t100*t111*t171*t18*t2
     @           41*t99-2.976136356992d-4*gammabb*t100*t111*t170*t18*t24
     1           1*t99-2.976136356992d-4*gammaaa*t100*t113*t171*t241*t99
     2           -1.4880681784960004d-4*t101*t110*t171*t241*t99+3.252970
     3           6666666663d-2*gammabb*t111*t126*t170*t18*t99+3.25297066
     4           66666663d-2*gammaaa*t113*t126*t171*t99+3.25297066666666
     5           63d-2*t100*t110*t126*t171*t99-8.674588444444443d-2*gamm
     6           aaa*gammabb*t113*t126*t170*t99-8.674588444444443d-2*gam
     7           mabb*t100*t110*t126*t170*t99+1.4222222222222222d+1*gamm
     8           abb*t102*t110*t170*t99-6.807153001848167d-7*t105*t106*t
     9           111*t171*t18*t461-6.807153001848167d-7*t100*t103*t104*t
     :           111*t171*t18*t461-1.7017882504620419d-7*t104*t108*t111*
     ;           t171*t18*t241-1.7017882504620419d-7*t100*t107*t111*t171
     <           *t18*t241+5.580255669360001d-5*t103*t104*t111*t171*t18*
     =           t241-1.488068178496d-4*gammabb*t103*t104*t111*t170*t18*
     >           t241-1.488068178496d-4*gammaaa*t103*t104*t113*t171*t241
     ?           -1.4880681784960004d-4*t105*t106*t110*t171*t241-1.48806
     @           81784960004d-4*t100*t103*t104*t110*t171*t241+1.86008522
     1           312d-5*t107*t111*t126*t171*t18-4.9602272616533327d-5*ga
     2           mmabb*t107*t111*t126*t170*t18-4.9602272616533327d-5*gam
     3           maaa*t107*t113*t126*t171-4.9602272616533327d-5*t104*t10
     4           8*t110*t126*t171-4.9602272616533327d-5*t100*t107*t110*t
     5           126*t171+1.6264853333333332d-2*t103*t104*t110*t126*t171
     6           +8.132426666666667d-3*t102*t107*t110*t171-4.33729422222
     7           22216d-2*gammabb*t103*t104*t110*t126*t170-2.16864711111
     8           11108d-2*gammabb*t102*t107*t110*t170)+1.0d+0*t168*t401+
     9           1.0d+0*t197*t397+1.0d+0*t201*t337)+t102*(-3.04966d-3*t1
     :           11*t401*t96+8.132426666666667d-3*t110*t186*t96-3.04966d
     ;           -3*t171*t398-3.04966d-3*t111*t197*t201+8.13242666666666
     <           7d-3*t109*t110*t197)-1.7017882504620419d-7*t109*t111*t1
     =           71*t18*t241*t96+1.86008522312d-5*t111*t126*t171*t201*t9
     >           6-4.9602272616533327d-5*t109*t110*t126*t171*t96-6.09932
     ?           d-3*t126*t18*t339-3.04966d-3*t102*t18*t338)*wght+Cmat3(
     @           iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = (t98*(1.0d+0*t96*(-1.355404444444
     1           4446d-1*t105*t126*t18*t60*taua*taub-3.7201704462400004d
     2           -4*t104*t105*t111*t241*t60*taub-1.8600852231200002d-4*t
     3           100*t103*t111*t241*t60*taub-6.200284077066668d-5*t108*t
     4           111*t126*t60*taub+2.033106666666667d-2*t103*t111*t126*t
     5           60*taub-5.421617777777779d-2*gammaaa*t103*t110*t126*t60
     6           *taub-3.7201704462400004d-4*t104*t105*t171*t18*t241*t53
     7           *taua-1.8600852231200002d-4*t100*t103*t171*t18*t241*t53
     8           *taua-6.200284077066668d-5*t108*t126*t171*t18*t53*taua+
     9           2.033106666666667d-2*t103*t126*t171*t18*t53*taua-5.4216
     :           17777777779d-2*gammabb*t103*t126*t173*t18*taua-1.084323
     ;           5555555555d-1*t104*t105*t126*t170*t18*taua-5.4216177777
     <           77777d-2*t100*t103*t126*t170*t18*taua-2.710808888888888
     =           7d-2*t102*t108*t170*t18*taua+8.88888888888889d+0*t102*t
     >           103*t170*t18*taua-6.807153001848167d-7*t101*t111*t171*t
     ?           461*t53*t99+1.1160511338720001d-4*t100*t111*t171*t241*t
     @           53*t99-2.976136356992d-4*gammaaa*t100*t110*t171*t241*t5
     1           3*t99+3.2529706666666663d-2*gammaaa*t110*t126*t171*t53*
     2           t99-2.976136356992d-4*gammabb*t100*t111*t173*t241*t99-1
     3           .4880681784960004d-4*t101*t111*t170*t241*t99+3.25297066
     4           66666663d-2*gammabb*t111*t126*t173*t99-8.67458844444444
     5           3d-2*gammaaa*gammabb*t110*t126*t173*t99+3.2529706666666
     6           663d-2*t100*t111*t126*t170*t99-8.674588444444443d-2*gam
     7           maaa*t100*t110*t126*t170*t99+1.4222222222222222d+1*gamm
     8           aaa*t102*t110*t170*t99-6.807153001848167d-7*t105*t106*t
     9           111*t171*t461*t53-6.807153001848167d-7*t100*t103*t104*t
     :           111*t171*t461*t53-1.7017882504620419d-7*t104*t108*t111*
     ;           t171*t241*t53-1.7017882504620419d-7*t100*t107*t111*t171
     <           *t241*t53+5.580255669360001d-5*t103*t104*t111*t171*t241
     =           *t53-1.488068178496d-4*gammaaa*t103*t104*t110*t171*t241
     >           *t53+1.86008522312d-5*t107*t111*t126*t171*t53-4.9602272
     ?           616533327d-5*gammaaa*t107*t110*t126*t171*t53-1.48806817
     @           8496d-4*gammabb*t103*t104*t111*t173*t241-1.488068178496
     1           0004d-4*t105*t106*t111*t170*t241-1.4880681784960004d-4*
     2           t100*t103*t104*t111*t170*t241-4.9602272616533327d-5*gam
     3           mabb*t107*t111*t126*t173-4.9602272616533327d-5*t104*t10
     4           8*t111*t126*t170-4.9602272616533327d-5*t100*t107*t111*t
     5           126*t170+1.6264853333333332d-2*t103*t104*t111*t126*t170
     6           -4.3372942222222216d-2*gammaaa*t103*t104*t110*t126*t170
     7           +8.132426666666667d-3*t102*t107*t111*t170-2.16864711111
     8           11108d-2*gammaaa*t102*t107*t110*t170)+1.0d+0*t168*t408+
     9           1.0d+0*t197*t399+1.0d+0*t204*t337)+t102*(-3.04966d-3*t1
     :           11*t408*t96-3.04966d-3*t171*t400-3.04966d-3*t111*t197*t
     ;           204+8.132426666666667d-3*t169*t170)-1.7017882504620419d
     <           -7*t109*t111*t171*t241*t53*t96+1.86008522312d-5*t111*t1
     =           26*t171*t204*t96-4.9602272616533327d-5*t109*t111*t126*t
     >           170*t96-6.09932d-3*t126*t339*t53-3.04966d-3*t102*t338*t
     ?           53)*wght+Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = (t98*(1.0d+0*t96*(-7.440340892480
     1           001d-4*t104*t105*t171*t18*t241*t53*taub-3.7201704462400
     2           004d-4*t100*t103*t171*t18*t241*t53*taub-1.2400568154133
     3           336d-4*t108*t126*t171*t18*t53*taub+4.066213333333334d-2
     4           *t103*t126*t171*t18*t53*taub-1.0843235555555557d-1*gamm
     5           abb*t103*t126*t173*t18*taub-1.0843235555555557d-1*t104*
     6           t105*t126*t170*t18*taub-5.421617777777779d-2*t100*t103*
     7           t126*t170*t18*taub-2.710808888888889d-2*t102*t108*t170*
     8           t18*taub+8.88888888888889d+0*t102*t103*t170*t18*taub-8.
     9           674588444444443d-2*t126*t18*t346*t59*t99-6.807153001848
     :           167d-7*t101*t18*t340*t461*t99+5.580255669360001d-5*t101
     ;           *t18*t241*t345*t99-1.219864d-2*t100*t126*t18*t345*t99-1
     <           .1927559111111112d-1*gammabb*t100*t126*t18*t344*t99+1.9
     =           555555555555557d+1*gammabb*t102*t18*t344*t99+1.11605113
     >           38720001d-4*t100*t18*t241*t340*t99-5.952272713984d-4*ga
     ?           mmabb*t100*t170*t171*t18*t241*t99+6.505941333333333d-2*
     @           gammabb*t126*t170*t171*t18*t99-1.3554044444444446d-1*t1
     1           05*t126*t18*t214*t60-6.807153001848167d-7*t105*t106*t18
     2           *t340*t461-6.807153001848167d-7*t100*t103*t104*t18*t340
     3           *t461+5.580255669360001d-5*t105*t106*t18*t241*t345+5.58
     4           0255669360001d-5*t100*t103*t104*t18*t241*t345+1.8600852
     5           2312d-5*t104*t108*t126*t18*t345+1.86008522312d-5*t100*t
     6           107*t126*t18*t345-6.09932d-3*t103*t104*t126*t18*t345-3.
     7           04966d-3*t102*t107*t18*t345-5.963779555555556d-2*gammab
     8           b*t103*t104*t126*t18*t344-2.981889777777778d-2*gammabb*
     9           t102*t107*t18*t344-1.7017882504620419d-7*t104*t108*t18*
     :           t241*t340-1.7017882504620419d-7*t100*t107*t18*t241*t340
     ;           +5.580255669360001d-5*t103*t104*t18*t241*t340+1.8600852
     <           2312d-5*t107*t126*t18*t340-2.976136356992d-4*gammabb*t1
     =           03*t104*t170*t171*t18*t241-9.920454523306665d-5*gammabb
     >           *t107*t126*t170*t171*t18)+2.0d+0*t197*t401+1.0d+0*t201*
     ?           t389)+t102*(-3.04966d-3*t171*t401*t96-3.04966d-3*t201*t
     @           345*t96-3.04966d-3*t171*t402-3.04966d-3*t171*t197*t201)
     1           -1.7017882504620419d-7*t109*t18*t241*t340*t96+1.8600852
     2           2312d-5*t126*t201*t340*t96-6.09932d-3*t126*t18*t391-3.0
     3           4966d-3*t102*t18*t390)*wght+Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = (t58*(1.0d+0*rhob*t49*t52*(-2.122
     1           525181952d-3*t171*t31*t343*t60*t62*taub-5.494272d-1*t17
     2           2*t173*t31*t62*taub-1.373568d-1*t173*t34*t61*taub+2.666
     3           6666666666666d+1*t173*t29*t61*taub-3.53754196992d-4*t17
     4           1*t172*t34*t60*taub+6.867840000000001d-2*t171*t172*t29*
     5           t60*taub-4.57856d-1*gammabb*t172*t29*t404*taub-1.061262
     6           590976d-3*gammabb*t171*t202*t29*t343*taub-3.27986175276
     7           38757d-6*t31*t340*t53*t587*t63+1.591893886464d-4*t31*t3
     8           43*t345*t53*t63-1.0072832000000001d-1*t172*t31*t344*t63
     9           -8.490100727808d-4*t170*t171*t31*t343*t63-5.036416d-2*t
     :           34*t344*t61*t62+9.777777777777779d+0*t29*t344*t61*t62-3
     ;           .2798617527638757d-6*gammabb*t29*t340*t587*t60*t62+1.59
     <           1893886464d-4*gammabb*t29*t343*t345*t60*t62+5.306312954
     =           88d-5*t172*t34*t345*t53*t62-1.030176d-2*t172*t29*t345*t
     >           53*t62-8.199654381909689d-7*t34*t340*t343*t53*t62+1.591
     ?           893886464d-4*t29*t340*t343*t53*t62-3.4797056000000004d-
     @           1*gammabb*t172*t29*t346*t62-1.6980201455616d-3*gammabb*
     1           t171*t173*t29*t343*t62-2.830033575936d-4*t170*t171*t172
     2           *t34*t62+5.494272d-2*t170*t171*t172*t29*t62-5.15088d-3*
     3           t33*t345*t53*t61-1.7398528000000002d-1*gammabb*t33*t346
     4           *t61+6.755555555555556d+1*gammabb*t25*t346*t61+2.747136
     5           d-2*t170*t171*t33*t61-7.4172672d-1*t172*t25*t59*t607+5.
     6           30631295488d-5*gammabb*t172*t33*t345*t60-2.060352d-2*ga
     7           mmabb*t172*t25*t345*t60-8.199654381909689d-7*gammabb*t3
     8           3*t340*t343*t60+3.183787772928d-4*gammabb*t25*t340*t343
     9           *t60-3.2798617527638757d-6*t202*t25*t340*t587*t59-2.547
     :           0302183424004d-3*t171*t25*t343*t404*t59+1.591893886464d
     ;           -4*t202*t25*t343*t345*t59+9.777777777777779d+0*t33*t344
     <           *t58+5.30631295488d-5*t172*t33*t340*t53-5.660067151872d
     =           -4*gammabb*t171*t172*t173*t33-2.2892800000000002d-1*t17
     >           2*t202*t214*t31+2.1977088d-1*gammabb*t171*t172*t173*t25
     ?           )-1.25d-1*t184*t50*t51*t64+1.25d-1*t341*t49*t51*t64-1.2
     @           5d-1*t361*t51*t64+2.0d+0*t405*t49*t52+2.0d+0*rhob*t184*
     1           t405*t52+1.0d+0*rhob*t203*t361*t52+2.0d+0*t184*t203*t52
     2           +1.25d-1*gammabb*t405*t49*t50*t51-1.25d-1*t174*t49*t50*
     3           t51+1.25d-1*gammabb*t184*t203*t50*t51-1.25d-1*t347*t49*
     4           t51+1.25d-1*gammabb*t203*t341*t49*t51-2.5d-1*t174*t184*
     5           t51)+t98*(1.0d+0*t96*(-7.440340892480001d-4*t104*t105*t
     6           171*t241*t60*taub-3.7201704462400004d-4*t100*t103*t171*
     7           t241*t60*taub-1.2400568154133336d-4*t108*t126*t171*t60*
     8           taub+4.066213333333334d-2*t103*t126*t171*t60*taub-1.084
     9           3235555555557d-1*gammabb*t103*t126*t404*taub-3.25297066
     :           6666667d-1*t104*t105*t126*t173*taub-1.6264853333333334d
     ;           -1*t100*t103*t126*t173*taub-8.132426666666668d-2*t102*t
     <           108*t173*taub+2.6666666666666666d+1*t102*t103*t173*taub
     =           -8.674588444444443d-2*t126*t59*t607*t99-6.8071530018481
     >           67d-7*t101*t340*t461*t53*t99+5.580255669360001d-5*t101*
     ?           t241*t345*t53*t99-1.219864d-2*t100*t126*t345*t53*t99+1.
     @           1160511338720001d-4*t100*t241*t340*t53*t99-2.9276736d-1
     1           *gammabb*t100*t126*t346*t99+48*gammabb*t102*t346*t99-5.
     2           963779555555556d-2*t101*t126*t344*t99+1.955555555555555
     3           7d+1*t100*t102*t344*t99-5.952272713984d-4*gammabb*t100*
     4           t171*t173*t241*t99-2.976136356992001d-4*t101*t170*t171*
     5           t241*t99+6.505941333333333d-2*gammabb*t126*t171*t173*t9
     6           9+6.505941333333333d-2*t100*t126*t170*t171*t99+9.777777
     7           777777779d+0*t107*t344*t98-6.807153001848167d-7*t105*t1
     8           06*t340*t461*t53-6.807153001848167d-7*t100*t103*t104*t3
     9           40*t461*t53+5.580255669360001d-5*t105*t106*t241*t345*t5
     :           3+5.580255669360001d-5*t100*t103*t104*t241*t345*t53+1.8
     ;           6008522312d-5*t104*t108*t126*t345*t53+1.86008522312d-5*
     <           t100*t107*t126*t345*t53-6.09932d-3*t103*t104*t126*t345*
     =           t53-3.04966d-3*t102*t107*t345*t53-1.7017882504620419d-7
     >           *t104*t108*t241*t340*t53-1.7017882504620419d-7*t100*t10
     ?           7*t241*t340*t53+5.580255669360001d-5*t103*t104*t241*t34
     @           0*t53+1.86008522312d-5*t107*t126*t340*t53-1.4638368d-1*
     1           gammabb*t103*t104*t126*t346-7.319184d-2*gammabb*t102*t1
     2           07*t346-5.963779555555556d-2*t105*t106*t126*t344-5.9637
     3           79555555556d-2*t100*t103*t104*t126*t344-2.9818897777777
     4           78d-2*t102*t104*t108*t344-2.981889777777778d-2*t100*t10
     5           2*t107*t344+9.777777777777779d+0*t102*t103*t104*t344-2.
     6           976136356992d-4*gammabb*t103*t104*t171*t173*t241-2.9761
     7           36356992001d-4*t105*t106*t170*t171*t241-2.9761363569920
     8           01d-4*t100*t103*t104*t170*t171*t241-1.3554044444444446d
     9           -1*t105*t126*t202*t214-9.920454523306665d-5*gammabb*t10
     :           7*t126*t171*t173-9.920454523306665d-5*t104*t108*t126*t1
     ;           70*t171-9.920454523306665d-5*t100*t107*t126*t170*t171+3
     <           .2529706666666663d-2*t103*t104*t126*t170*t171+1.6264853
     =           333333332d-2*t102*t107*t170*t171)+2.0d+0*t197*t408+1.0d
     >           +0*t204*t389)+t102*(-3.04966d-3*t171*t408*t96-3.04966d-
     ?           3*t204*t345*t96-2.981889777777778d-2*t109*t344*t96+8.13
     @           2426666666667d-3*t170*t186*t96-3.04966d-3*t171*t409-3.0
     1           4966d-3*t171*t197*t204+8.132426666666667d-3*t170*t198+8
     2           .132426666666667d-3*t109*t170*t197)-1.7017882504620419d
     3           -7*t109*t241*t340*t53*t96+1.86008522312d-5*t126*t204*t3
     4           40*t96-9.920454523306665d-5*t109*t126*t170*t171*t96+t61
     5           *(1.373568d-2*t184*t52*t53*t64-3.662848000000001d-2*t17
     6           0*t49*t52*t64+6.4386d-4*t171*t49*t50*t51*t64+6.4386d-4*
     7           t345*t49*t51*t64+6.4386d-4*t171*t184*t51*t64+1.373568d-
     8           2*t174*t49*t52*t53-5.15088d-3*rhob*t171*t405*t49*t52-5.
     9           15088d-3*rhob*t203*t345*t49*t52-5.15088d-3*t171*t203*t4
     :           9*t52-5.15088d-3*rhob*t171*t184*t203*t52+6.4386d-4*t171
     ;           *t174*t49*t51-5.15088d-3*t171*t406+1.373568d-2*t170*t18
     <           5)+t172*t53*(-2.830033575936d-4*t171*t49*t52*t64-1.0301
     =           76d-2*t363)+t50*t51*t61*(-1.28772d-3*t171*t49*t64-1.287
     >           72d-3*gammabb*t171*t203*t49)+t50*t51*t58*(1.25d-1*t184*
     ?           t64+1.25d-1*gammabb*t405*t49+1.25d-1*t174*t49+1.25d-1*g
     @           ammabb*t184*t203)+4.07778d-3*gammabb*t344*t49*t51*t61*t
     1           64-8.199654381909689d-7*t340*t343*t49*t52*t55*t64-6.632
     2           8911936d-6*t172*t340*t49*t51*t64+1.32657823872d-5*gamma
     3           bb*t170*t171*t172*t49*t51*t64-5.15088d-3*t362*t53*t61-5
     4           .15088d-3*t170*t342*t51*t61+t341*t51*t58*t606-6.09932d-
     5           3*t126*t391*t53-3.04966d-3*t102*t390*t53+5.30631295488d
     6           -5*rhob*t172*t203*t340*t49*t52)*wght+Cmat3(iq,D3_RB_RB_
     7           GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t23*(1.0d+0*rhoa*t14*t17*(-5.30
     1           631295488d-4*gammaaa*t220*t29*t410*taua-1.76877098496d-
     2           4*t112*t199*t34*taua-1.061262590976d-3*t199*t220*t30*t3
     3           1*taua+6.867840000000001d-2*t112*t199*t29*taua-3.279861
     4           7527638757d-6*t111*t25*t26*t410*t452-3.2798617527638757
     5           d-6*t111*t27*t31*t32*t452-3.2798617527638757d-6*gammaaa
     6           *t111*t199*t29*t30*t452-4.245050363904d-4*gammaaa*t112*
     7           t33*t393-1.2735151091712002d-3*gammaaa*t220*t29*t30*t39
     8           3+3.2965632d-1*gammaaa*t112*t25*t393-8.199654381909689d
     9           -7*t111*t220*t27*t30*t34-2.830033575936d-4*t112*t113*t3
     :           0*t34+5.494272d-2*t113*t28*t33+1.061262590976d-4*t111*t
     ;           112*t27*t33-8.199654381909689d-7*gammaaa*t111*t199*t220
     <           *t33-8.490100727808d-4*t113*t220*t31*t32+3.183787772928
     =           d-4*t111*t220*t27*t29*t30+1.0988544d-1*t112*t113*t29*t3
     >           0-1.0666666666666666d+1*t113*t25*t28-2.060352d-2*t111*t
     ?           112*t25*t27-1.6980201455616d-3*t220*t25*t26/rhoa**1.166
     @           6666666666665d+1+6.367575545856d-4*gammaaa*t111*t199*t2
     1           20*t25)+1.0d+0*t14*t17*t411+1.0d+0*rhoa*t124*t17*t411-2
     2           .5d-1*t14*t16*t394-2.5d-1*t14*t15*t16*t200-2.5d-1*t124*
     3           t16*t200)+t98*(1.0d+0*t96*(-3.7201704462400004d-4*t104*
     4           t105*t199*t241*taua-1.8600852231200002d-4*t100*t103*t19
     5           9*t241*taua-6.200284077066668d-5*t108*t126*t199*taua+4.
     6           066213333333334d-2*t103*t126*t199*taua-6.80715300184816
     7           7d-7*t101*t111*t27*t461*t99-2.976136356992d-4*gammaaa*t
     8           100*t241*t393*t99+6.505941333333333d-2*gammaaa*t126*t39
     9           3*t99+2.2321022677440003d-4*t100*t111*t241*t27*t99-1.21
     :           9864d-2*t111*t126*t27*t99-2.976136356992001d-4*t101*t11
     ;           3*t241*t99+1.3011882666666666d-1*t100*t113*t126*t99-1.0
     <           666666666666666d+1*t102*t113*t99-6.807153001848167d-7*t
     =           105*t106*t111*t27*t461-6.807153001848167d-7*t100*t103*t
     >           104*t111*t27*t461-1.488068178496d-4*gammaaa*t103*t104*t
     ?           241*t393-4.9602272616533327d-5*gammaaa*t107*t126*t393-1
     @           .7017882504620419d-7*t104*t108*t111*t241*t27-1.70178825
     1           04620419d-7*t100*t107*t111*t241*t27+1.1160511338720001d
     2           -4*t103*t104*t111*t241*t27+3.72017044624d-5*t107*t111*t
     3           126*t27-2.976136356992001d-4*t105*t106*t113*t241-2.9761
     4           36356992001d-4*t100*t103*t104*t113*t241-9.9204545233066
     5           65d-5*t104*t108*t113*t126-9.920454523306665d-5*t100*t10
     6           7*t113*t126+6.505941333333333d-2*t103*t104*t113*t126+3.
     7           2529706666666663d-2*t102*t107*t113)+1.0d+0*t168*t412)-3
     8           .04966d-3*t102*t111*t412*t96-1.7017882504620419d-7*t109
     9           *t111*t241*t27*t96+3.72017044624d-5*t111*t126*t18*t201*
     :           t96+1.6264853333333332d-2*t102*t110*t201*t96-9.92045452
     ;           3306665d-5*t109*t113*t126*t96+t18*t28*(t609-1.716960000
     <           0000002d-3*t14*t15*t16*t35+2.747136d-2*t14*t17*t200)+t1
     =           5*t16*t23*t608-5.15088d-3*rhoa*t111*t14*t17*t28*t411-6.
     >           09932d-3*t102*t18*t398+t112*t27*(-1.030176d-2*t396-1.41
     ?           5016787968d-4*t14*t17*t35)+t110*t16*t28*(-5.15088d-3*t3
     @           92-2.3608200000000001d-3*t14*t35-6.4386d-4*gammaaa*t14*
     1           t200)-8.199654381909689d-7*t111*t14*t17*t206*t220*t35-1
     2           .32657823872d-5*t111*t112*t14*t16*t18*t35+6.6328911936d
     3           -6*gammaaa*t112*t113*t14*t16*t35+1.28772d-3*t111*t14*t1
     4           6*t200*t28+1.86008522312d-5*t126*t169*t27+1.06126259097
     5           6d-4*t111*t112*t14*t17*t20*t200)*wght+Cmat3(iq,D3_RA_GA
     6           A_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = (t98*(1.0d+0*t96*(-3.72017044624
     1           00004d-4*t104*t105*t241*t27*t53*taua-1.8600852231200002
     2           d-4*t100*t103*t241*t27*t53*taua-6.200284077066668d-5*t1
     3           08*t126*t27*t53*taua+4.066213333333334d-2*t103*t126*t27
     4           *t53*taua-6.807153001848167d-7*t101*t111*t18*t461*t53*t
     5           99+2.2321022677440003d-4*t100*t111*t18*t241*t53*t99-2.9
     6           76136356992d-4*gammaaa*t100*t113*t241*t53*t99-1.4880681
     7           78496d-4*t101*t110*t241*t53*t99-1.219864d-2*t111*t126*t
     8           18*t53*t99+6.505941333333333d-2*gammaaa*t113*t126*t53*t
     9           99+6.505941333333333d-2*t100*t110*t126*t53*t99-5.333333
     :           333333333d+0*t102*t110*t53*t99-6.807153001848167d-7*t10
     ;           5*t106*t111*t18*t461*t53-6.807153001848167d-7*t100*t103
     <           *t104*t111*t18*t461*t53-1.7017882504620419d-7*t104*t108
     =           *t111*t18*t241*t53-1.7017882504620419d-7*t100*t107*t111
     >           *t18*t241*t53+1.1160511338720001d-4*t103*t104*t111*t18*
     ?           t241*t53-1.488068178496d-4*gammaaa*t103*t104*t113*t241*
     @           t53-1.488068178496d-4*t105*t106*t110*t241*t53-1.4880681
     1           78496d-4*t100*t103*t104*t110*t241*t53+3.72017044624d-5*
     2           t107*t111*t126*t18*t53-4.9602272616533327d-5*gammaaa*t1
     3           07*t113*t126*t53-4.9602272616533327d-5*t104*t108*t110*t
     4           126*t53-4.9602272616533327d-5*t100*t107*t110*t126*t53+3
     5           .2529706666666663d-2*t103*t104*t110*t126*t53+1.62648533
     6           33333332d-2*t102*t107*t110*t53)+1.0d+0*t168*t413)-1.701
     7           7882504620419d-7*t109*t111*t18*t241*t53*t96+1.860085223
     8           12d-5*t111*t126*t201*t53*t96-4.9602272616533327d-5*t109
     9           *t110*t126*t53*t96-3.04966d-3*t102*t111*t413*t96+1.8600
     :           8522312d-5*t111*t126*t18*t204*t96+8.132426666666667d-3*
     ;           t102*t110*t204*t96-3.04966d-3*t102*t398*t53+1.860085223
     <           12d-5*t126*t169*t18*t53-3.04966d-3*t102*t18*t400)*wght+
     =           Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = (t98*(1.0d+0*t96*(-3.72017044624
     1           00004d-4*t104*t105*t18*t241*t60*taua-1.8600852231200002
     2           d-4*t100*t103*t18*t241*t60*taua-6.200284077066668d-5*t1
     3           08*t126*t18*t60*taua+4.066213333333334d-2*t103*t126*t18
     4           *t60*taua-6.807153001848167d-7*t101*t111*t461*t60*t99+2
     5           .2321022677440003d-4*t100*t111*t241*t60*t99-2.976136356
     6           992d-4*gammaaa*t100*t110*t241*t60*t99-1.219864d-2*t111*
     7           t126*t60*t99+6.505941333333333d-2*gammaaa*t110*t126*t60
     8           *t99-6.807153001848167d-7*t105*t106*t111*t461*t60-6.807
     9           153001848167d-7*t100*t103*t104*t111*t461*t60-1.70178825
     :           04620419d-7*t104*t108*t111*t241*t60-1.7017882504620419d
     ;           -7*t100*t107*t111*t241*t60+1.1160511338720001d-4*t103*t
     <           104*t111*t241*t60-1.488068178496d-4*gammaaa*t103*t104*t
     =           110*t241*t60+3.72017044624d-5*t107*t111*t126*t60-4.9602
     >           272616533327d-5*gammaaa*t107*t110*t126*t60)+1.0d+0*t168
     ?           *t416)-1.7017882504620419d-7*t109*t111*t241*t60*t96+3.7
     @           2017044624d-5*t111*t126*t204*t53*t96-3.04966d-3*t102*t1
     1           11*t416*t96+1.86008522312d-5*t126*t169*t60-6.09932d-3*t
     2           102*t400*t53)*wght+Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = (t98*(1.0d+0*t96*(-3.72017044624
     1           00004d-4*t104*t105*t241*t27*t53*taub-1.8600852231200002
     2           d-4*t100*t103*t241*t27*t53*taub-6.200284077066668d-5*t1
     3           08*t126*t27*t53*taub+4.066213333333334d-2*t103*t126*t27
     4           *t53*taub-6.807153001848167d-7*t101*t171*t27*t461*t99+2
     5           .2321022677440003d-4*t100*t171*t241*t27*t99-2.976136356
     6           992d-4*gammabb*t100*t170*t241*t27*t99-1.219864d-2*t126*
     7           t171*t27*t99+6.505941333333333d-2*gammabb*t126*t170*t27
     8           *t99-6.807153001848167d-7*t105*t106*t171*t27*t461-6.807
     9           153001848167d-7*t100*t103*t104*t171*t27*t461-1.70178825
     :           04620419d-7*t104*t108*t171*t241*t27-1.7017882504620419d
     ;           -7*t100*t107*t171*t241*t27+1.1160511338720001d-4*t103*t
     <           104*t171*t241*t27-1.488068178496d-4*gammabb*t103*t104*t
     =           170*t241*t27+3.72017044624d-5*t107*t126*t171*t27-4.9602
     >           272616533327d-5*gammabb*t107*t126*t170*t27)+1.0d+0*t197
     ?           *t412)-3.04966d-3*t102*t171*t412*t96-1.7017882504620419
     @           d-7*t109*t171*t241*t27*t96+3.72017044624d-5*t126*t171*t
     1           18*t201*t96-6.09932d-3*t102*t18*t402+1.86008522312d-5*t
     2           126*t198*t27)*wght+Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = (t98*(1.0d+0*t96*(-3.72017044624
     1           00004d-4*t104*t105*t18*t241*t60*taub-1.8600852231200002
     2           d-4*t100*t103*t18*t241*t60*taub-6.200284077066668d-5*t1
     3           08*t126*t18*t60*taub+4.066213333333334d-2*t103*t126*t18
     4           *t60*taub-6.807153001848167d-7*t101*t171*t18*t461*t53*t
     5           99+2.2321022677440003d-4*t100*t171*t18*t241*t53*t99-1.2
     6           19864d-2*t126*t171*t18*t53*t99-2.976136356992d-4*gammab
     7           b*t100*t173*t18*t241*t99-1.4880681784960004d-4*t101*t17
     8           0*t18*t241*t99+6.505941333333333d-2*gammabb*t126*t173*t
     9           18*t99+6.505941333333333d-2*t100*t126*t170*t18*t99-5.33
     :           3333333333333d+0*t102*t170*t18*t99-6.807153001848167d-7
     ;           *t105*t106*t171*t18*t461*t53-6.807153001848167d-7*t100*
     <           t103*t104*t171*t18*t461*t53-1.7017882504620419d-7*t104*
     =           t108*t171*t18*t241*t53-1.7017882504620419d-7*t100*t107*
     >           t171*t18*t241*t53+1.1160511338720001d-4*t103*t104*t171*
     ?           t18*t241*t53+3.72017044624d-5*t107*t126*t171*t18*t53-1.
     @           488068178496d-4*gammabb*t103*t104*t173*t18*t241-1.48806
     1           81784960004d-4*t105*t106*t170*t18*t241-1.48806817849600
     2           04d-4*t100*t103*t104*t170*t18*t241-4.9602272616533327d-
     3           5*gammabb*t107*t126*t173*t18-4.9602272616533327d-5*t104
     4           *t108*t126*t170*t18-4.9602272616533327d-5*t100*t107*t12
     5           6*t170*t18+3.2529706666666663d-2*t103*t104*t126*t170*t1
     6           8+1.6264853333333332d-2*t102*t107*t170*t18)+1.0d+0*t197
     7           *t413)-1.7017882504620419d-7*t109*t171*t18*t241*t53*t96
     8           +1.86008522312d-5*t126*t171*t201*t53*t96-3.04966d-3*t10
     9           2*t171*t413*t96+1.86008522312d-5*t126*t171*t18*t204*t96
     :           +8.132426666666667d-3*t102*t170*t201*t96-4.960227261653
     ;           3327d-5*t109*t126*t170*t18*t96-3.04966d-3*t102*t402*t53
     <           +1.86008522312d-5*t126*t18*t198*t53-3.04966d-3*t102*t18
     =           *t409)*wght+Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t58*(1.0d+0*rhob*t49*t52*(-1.06
     1           1262590976d-3*t202*t31*t343*t62*taub-5.30631295488d-4*g
     2           ammabb*t29*t343*t414*taub-1.76877098496d-4*t172*t202*t3
     3           4*taub+6.867840000000001d-2*t172*t202*t29*taub-3.279861
     4           7527638757d-6*t171*t31*t587*t60*t63-8.490100727808d-4*t
     5           173*t31*t343*t63-8.199654381909689d-7*t171*t34*t343*t60
     6           *t62+3.183787772928d-4*t171*t29*t343*t60*t62-3.27986175
     7           27638757d-6*gammabb*t171*t202*t29*t587*t62-1.2735151091
     8           712002d-3*gammabb*t29*t343*t404*t62-2.830033575936d-4*t
     9           172*t173*t34*t62+1.0988544d-1*t172*t173*t29*t62+5.49427
     :           2d-2*t173*t33*t61-1.0666666666666666d+1*t173*t25*t61+1.
     ;           061262590976d-4*t171*t172*t33*t60-2.060352d-2*t171*t172
     <           *t25*t60-3.2798617527638757d-6*t171*t25*t414*t587*t59-1
     =           .6980201455616d-3*t25*t343*t59/rhob**1.1666666666666665
     >           d+1-4.245050363904d-4*gammabb*t172*t33*t404+3.2965632d-
     ?           1*gammabb*t172*t25*t404-8.199654381909689d-7*gammabb*t1
     @           71*t202*t33*t343+6.367575545856d-4*gammabb*t171*t202*t2
     1           5*t343)+1.0d+0*t415*t49*t52+1.0d+0*rhob*t184*t415*t52-2
     2           .5d-1*t203*t49*t50*t51-2.5d-1*t405*t49*t51-2.5d-1*t184*
     3           t203*t51)+t98*(1.0d+0*t96*(-3.7201704462400004d-4*t104*
     4           t105*t202*t241*taub-1.8600852231200002d-4*t100*t103*t20
     5           2*t241*taub-6.200284077066668d-5*t108*t126*t202*taub+4.
     6           066213333333334d-2*t103*t126*t202*taub-6.80715300184816
     7           7d-7*t101*t171*t461*t60*t99+2.2321022677440003d-4*t100*
     8           t171*t241*t60*t99-1.219864d-2*t126*t171*t60*t99-2.97613
     9           6356992d-4*gammabb*t100*t241*t404*t99+6.505941333333333
     :           d-2*gammabb*t126*t404*t99-2.976136356992001d-4*t101*t17
     ;           3*t241*t99+1.3011882666666666d-1*t100*t126*t173*t99-1.0
     <           666666666666666d+1*t102*t173*t99-6.807153001848167d-7*t
     =           105*t106*t171*t461*t60-6.807153001848167d-7*t100*t103*t
     >           104*t171*t461*t60-1.7017882504620419d-7*t104*t108*t171*
     ?           t241*t60-1.7017882504620419d-7*t100*t107*t171*t241*t60+
     @           1.1160511338720001d-4*t103*t104*t171*t241*t60+3.7201704
     1           4624d-5*t107*t126*t171*t60-1.488068178496d-4*gammabb*t1
     2           03*t104*t241*t404-4.9602272616533327d-5*gammabb*t107*t1
     3           26*t404-2.976136356992001d-4*t105*t106*t173*t241-2.9761
     4           36356992001d-4*t100*t103*t104*t173*t241-9.9204545233066
     5           65d-5*t104*t108*t126*t173-9.920454523306665d-5*t100*t10
     6           7*t126*t173+6.505941333333333d-2*t103*t104*t126*t173+3.
     7           2529706666666663d-2*t102*t107*t173)+1.0d+0*t197*t416)-1
     8           .7017882504620419d-7*t109*t171*t241*t60*t96+3.720170446
     9           24d-5*t126*t171*t204*t53*t96-3.04966d-3*t102*t171*t416*
     :           t96+1.6264853333333332d-2*t102*t170*t204*t96-9.92045452
     ;           3306665d-5*t109*t126*t173*t96+t172*t60*(-1.415016787968
     <           d-4*t49*t52*t64-1.030176d-2*t407)+t53*t61*(-1.716960000
     =           0000002d-3*t49*t50*t51*t64+t611+2.747136d-2*t203*t49*t5
     >           2)+t170*t51*t61*(-2.3608200000000001d-3*t49*t64-6.4386d
     ?           -4*gammabb*t203*t49-5.15088d-3*t403)-1.32657823872d-5*t
     @           171*t172*t49*t51*t53*t64-8.199654381909689d-7*t171*t212
     1           *t343*t49*t52*t64+6.6328911936d-6*gammabb*t172*t173*t49
     2           *t51*t64+t50*t51*t58*t610-5.15088d-3*rhob*t171*t415*t49
     3           *t52*t61+1.28772d-3*t171*t203*t49*t51*t61+1.86008522312
     4           d-5*t126*t198*t60+1.061262590976d-4*t171*t172*t203*t49*
     5           t52*t55-6.09932d-3*t102*t409*t53)*wght+Cmat3(iq,D3_RB_G
     6           BB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (1.0d+0*t96*t98*(-6.80715300184
     1           8167d-7*t101*t199*t461*t99+3.348153401616001d-4*t100*t1
     2           99*t241*t99-3.6595920000000004d-2*t126*t199*t99-6.80715
     3           3001848167d-7*t105*t106*t199*t461-6.807153001848167d-7*
     4           t100*t103*t104*t199*t461-1.7017882504620419d-7*t104*t10
     5           8*t199*t241-1.7017882504620419d-7*t100*t107*t199*t241+1
     6           .6740767008080004d-4*t103*t104*t199*t241+5.580255669359
     7           999d-5*t107*t126*t199)-9.148980000000001d-3*t102*t18*t4
     8           12*t96+5.580255669359999d-5*t126*t201*t27*t96-1.7017882
     9           504620419d-7*t109*t199*t241*t96+1.0d+0*rhoa*t14*t17*t23
     :           *(-3.2798617527638757d-6*gammaaa*t29*t30*t410*t452-3.27
     ;           98617527638757d-6*t199*t31*t32*t452-3.2798617527638757d
     <           -6*t25*t26*t452/rhoa**1.3333333333333333d+1-8.199654381
     =           909689d-7*gammaaa*t220*t33*t410+9.551363318784001d-4*ga
     >           mmaaa*t220*t25*t410-8.199654381909689d-7*t199*t220*t30*
     ?           t34+1.591893886464d-4*t112*t199*t33+4.7756816593920004d
     @           -4*t199*t220*t29*t30-6.181056d-2*t112*t199*t25)-1.54526
     1           4d-2*t14*t17*t20*t28*t411-3.75d-1*t14*t16*t23*t411-1.98
     2           98673580800003d-5*t112*t14*t16*t27*t35-8.19965438190968
     3           9d-7*t14*t17*t205*t220*t35+3.86316d-3*t14*t16*t18*t200*
     4           t28+1.591893886464d-4*t112*t14*t17*t200*t206)*wght+Cmat
     5           3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = (1.0d+0*t96*t98*(-6.80715300184
     1           8167d-7*t101*t27*t461*t53*t99+3.348153401616001d-4*t100
     2           *t241*t27*t53*t99-3.6595920000000004d-2*t126*t27*t53*t9
     3           9-6.807153001848167d-7*t105*t106*t27*t461*t53-6.8071530
     4           01848167d-7*t100*t103*t104*t27*t461*t53-1.7017882504620
     5           419d-7*t104*t108*t241*t27*t53-1.7017882504620419d-7*t10
     6           0*t107*t241*t27*t53+1.6740767008080004d-4*t103*t104*t24
     7           1*t27*t53+5.580255669359999d-5*t107*t126*t27*t53)-3.049
     8           66d-3*t102*t412*t53*t96-1.7017882504620419d-7*t109*t241
     9           *t27*t53*t96+3.72017044624d-5*t126*t18*t201*t53*t96-6.0
     :           9932d-3*t102*t18*t413*t96+1.86008522312d-5*t126*t204*t2
     ;           7*t96)*wght+Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = (1.0d+0*t96*t98*(-6.80715300184
     1           8167d-7*t101*t18*t461*t60*t99+3.348153401616001d-4*t100
     2           *t18*t241*t60*t99-3.6595920000000004d-2*t126*t18*t60*t9
     3           9-6.807153001848167d-7*t105*t106*t18*t461*t60-6.8071530
     4           01848167d-7*t100*t103*t104*t18*t461*t60-1.7017882504620
     5           419d-7*t104*t108*t18*t241*t60-1.7017882504620419d-7*t10
     6           0*t107*t18*t241*t60+1.6740767008080004d-4*t103*t104*t18
     7           *t241*t60+5.580255669359999d-5*t107*t126*t18*t60)-1.701
     8           7882504620419d-7*t109*t18*t241*t60*t96+1.86008522312d-5
     9           *t126*t201*t60*t96-6.09932d-3*t102*t413*t53*t96+3.72017
     :           044624d-5*t126*t18*t204*t53*t96-3.04966d-3*t102*t18*t41
     ;           6*t96)*wght+Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = (1.0d+0*t96*t98*(-6.80715300184
     1           8167d-7*t101*t202*t461*t99+3.348153401616001d-4*t100*t2
     2           02*t241*t99-3.6595920000000004d-2*t126*t202*t99-6.80715
     3           3001848167d-7*t105*t106*t202*t461-6.807153001848167d-7*
     4           t100*t103*t104*t202*t461-1.7017882504620419d-7*t104*t10
     5           8*t202*t241-1.7017882504620419d-7*t100*t107*t202*t241+1
     6           .6740767008080004d-4*t103*t104*t202*t241+5.580255669359
     7           999d-5*t107*t126*t202)+5.580255669359999d-5*t126*t204*t
     8           60*t96-9.148980000000001d-3*t102*t416*t53*t96-1.7017882
     9           504620419d-7*t109*t202*t241*t96-1.9898673580800003d-5*t
     :           172*t49*t51*t60*t64-8.199654381909689d-7*t211*t343*t49*
     ;           t52*t64+1.0d+0*rhob*t49*t52*t58*(-3.2798617527638757d-6
     <           *t202*t31*t587*t63-3.2798617527638757d-6*gammabb*t29*t4
     =           14*t587*t62-8.199654381909689d-7*t202*t34*t343*t62+4.77
     >           56816593920004d-4*t202*t29*t343*t62-3.2798617527638757d
     ?           -6*t25*t587*t59/rhob**1.3333333333333333d+1-8.199654381
     @           909689d-7*gammabb*t33*t343*t414+9.551363318784001d-4*ga
     1           mmabb*t25*t343*t414+1.591893886464d-4*t172*t202*t33-6.1
     2           81056d-2*t172*t202*t25)-1.545264d-2*t415*t49*t52*t55*t6
     3           1+3.86316d-3*t203*t49*t51*t53*t61-3.75d-1*t415*t49*t51*
     4           t58+1.591893886464d-4*t172*t203*t212*t49*t52)*wght+Cmat
     5           3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = (t23*(1.0d+0*rhoa*t14*t17*(-2.0603
     1           520000000003d-1*t27*t28*t34*taua-7.07508393984d-4*t111*
     2           t112*t206*t34*taua-8.241408000000001d-1*t112*t27*t30*t3
     3           1*taua-4.245050363904d-3*t111*t206*t220*t30*t31*taua+8.
     4           0d+1*t27*t28*t31*taua+2.747136d-1*t111*t112*t206*t31*ta
     5           ua-2.122525181952d-3*gammaaa*t111*t205*t220*t29*taua-7.
     6           783552d-1*gammaaa*t112*t199*t29*taua-6.559723505527751d
     7           -6*t20*t217*t31*t32*t452-6.559723505527751d-6*gammaaa*t
     8           206*t217*t29*t30*t452-6.559723505527751d-6*t205*t217*t2
     9           5*t26*t452-1.1537971200000001d+0*t112*t25*t26*t393-4.57
     :           85600000000004d-2*t110*t28*t30*t34+1.061262590976d-4*t1
     ;           12*t20*t222*t30*t34-1.6399308763819376d-6*t20*t217*t220
     <           *t30*t34-3.5375419699200006d-4*t111*t112*t18*t30*t34-1.
     =           030176d-2*t20*t222*t28*t34+3.4339200000000003d-2*t111*t
     >           18*t28*t34+8.88888888888889d+0*t110*t23*t34+1.061262590
     ?           976d-4*t112*t20*t217*t34-2.3808512d-1*gammaaa*t113*t28*
     @           t33-9.197609121792001d-4*gammaaa*t111*t112*t27*t33+1.06
     1           1262590976d-4*gammaaa*t112*t206*t222*t33-1.639930876381
     2           9376d-6*gammaaa*t206*t217*t220*t33+3.183787772928d-4*t2
     3           0*t220*t222*t31*t32-1.0612625909760003d-3*t111*t18*t220
     4           *t31*t32-9.157120000000001d-2*t110*t112*t31*t32+1.77777
     5           77777777778d+1*t110*t28*t30*t31-4.120704d-2*t112*t20*t2
     6           22*t30*t31+6.367575545856d-4*t20*t217*t220*t30*t31+1.37
     7           3568d-1*t111*t112*t18*t30*t31-4.5785600000000004d-1*t11
     8           2*t205*t208*t31-2.7592827365376d-3*gammaaa*t111*t220*t2
     9           7*t29*t30+3.183787772928d-4*gammaaa*t206*t220*t222*t29*
     :           t30-4.7617024d-1*gammaaa*t112*t113*t29*t30+4.6222222222
     ;           22223d+1*gammaaa*t113*t28*t29+1.7856384d-1*gammaaa*t111
     <           *t112*t27*t29-2.060352d-2*gammaaa*t112*t206*t222*t29+3.
     =           183787772928d-4*gammaaa*t206*t217*t220*t29+3.1837877729
     >           28d-4*t205*t220*t222*t25*t26-4.4573028820992006d-3*t111
     ?           *t199*t220*t25*t26)+2.0d+0*t14*t17*t417+2.0d+0*rhoa*t12
     @           4*t17*t417+1.25d-1*gammaaa*t14*t15*t16*t417+1.25d-1*gam
     1           maaa*t209*t238*t35-1.25d-1*gammaaa*t14*t209*t218*t35+1.
     2           25d-1*gammaaa*t124*t15*t209*t35+1.0d+0*rhoa*t17*t207*t2
     3           38+1.25d-1*gammaaa*t14*t209*t224+1.25d-1*gammaaa*t14*t1
     4           6*t207*t218+1.25d-1*gammaaa*t114*t14*t15*t209+2.5d-1*ga
     5           mmaaa*t114*t124*t209+2.0d+0*t124*t17*t207+1.25d-1*gamma
     6           aa*t124*t15*t16*t207)+t98*(1.0d+0*t96*(-4.8794560000000
     7           01d-1*t104*t105*t126*t27*taua-2.4397280000000005d-1*t10
     8           0*t103*t126*t27*taua-1.2198640000000002d-1*t102*t108*t2
     9           7*taua+8.0d+1*t102*t105*t27*taua-1.4880681784960004d-3*
     :           t104*t105*t111*t206*t241*taua-7.440340892480001d-4*t100
     ;           *t103*t111*t206*t241*taua-2.4801136308266672d-4*t108*t1
     <           11*t126*t206*taua+1.6264853333333334d-1*t105*t111*t126*
     =           t206*taua-2.1686471111111114d-1*gammaaa*t103*t126*t199*
     >           taua-1.3614306003696336d-6*t101*t20*t217*t461*t99-1.734
     ?           9176888888887d-1*t126*t26*t393*t99-1.1904545427968d-3*g
     @           ammaaa*t100*t111*t241*t27*t99+1.1160511338720001d-4*t10
     1           1*t20*t222*t241*t99-3.7201704462400004d-4*t101*t111*t18
     2           *t241*t99-4.554158933333333d-1*gammaaa*t100*t113*t126*t
     3           99-5.421617777777779d-2*t101*t110*t126*t99+8.8888888888
     4           8889d+0*t108*t110*t98-1.3614306003696336d-6*t105*t106*t
     5           20*t217*t461-1.3614306003696336d-6*t100*t103*t104*t20*t
     6           217*t461-5.952272713984d-4*gammaaa*t103*t104*t111*t241*
     7           t27-1.984090904661333d-4*gammaaa*t107*t111*t126*t27+6.5
     8           05941333333333d-2*gammaaa*t103*t111*t126*t27+1.11605113
     9           38720001d-4*t105*t106*t20*t222*t241+1.1160511338720001d
     :           -4*t100*t103*t104*t20*t222*t241-3.4035765009240837d-7*t
     ;           104*t108*t20*t217*t241-3.4035765009240837d-7*t100*t107*
     <           t20*t217*t241+2.2321022677440003d-4*t104*t105*t20*t217*
     =           t241+1.1160511338720001d-4*t100*t103*t20*t217*t241-3.72
     >           01704462400004d-4*t105*t106*t111*t18*t241-3.72017044624
     ?           00004d-4*t100*t103*t104*t111*t18*t241+3.72017044624d-5*
     @           t104*t108*t126*t20*t222+3.72017044624d-5*t100*t107*t126
     1           *t20*t222-2.439728d-2*t104*t105*t126*t20*t222-1.219864d
     2           -2*t100*t103*t126*t20*t222-6.09932d-3*t102*t108*t20*t22
     3           2+3.72017044624d-5*t108*t126*t20*t217-2.710808888888889
     4           d-1*t105*t126*t205*t208-1.2400568154133333d-4*t104*t108
     5           *t111*t126*t18-1.2400568154133333d-4*t100*t107*t111*t12
     6           6*t18+8.132426666666668d-2*t104*t105*t111*t126*t18+4.06
     7           6213333333334d-2*t100*t103*t111*t126*t18+2.033106666666
     8           667d-2*t102*t108*t111*t18-2.2770794666666666d-1*gammaaa
     9           *t103*t104*t113*t126-5.421617777777779d-2*t105*t106*t11
     :           0*t126-5.421617777777779d-2*t100*t103*t104*t110*t126-1.
     ;           1385397333333333d-1*gammaaa*t102*t107*t113+3.7333333333
     <           333335d+1*gammaaa*t102*t103*t113-2.710808888888889d-2*t
     =           102*t104*t108*t110-2.710808888888889d-2*t100*t102*t107*
     >           t110+1.7777777777777778d+1*t102*t104*t105*t110+8.888888
     ?           88888889d+0*t100*t102*t103*t110)+2.0d+0*t168*t419+1.0d+
     @           0*t210*t323)+t102*(-3.04966d-3*t111*t419*t96-3.04966d-3
     1           *t210*t222*t96+1.0165533333333335d-2*t127*t18*t96-2.710
     2           808888888889d-2*t109*t110*t96-3.04966d-3*t111*t420-3.04
     3           966d-3*t111*t168*t210+1.0165533333333335d-2*t169*t18+1.
     4           0165533333333335d-2*t109*t168*t18)-3.4035765009240837d-
     5           7*t109*t20*t217*t241*t96+1.86008522312d-5*t126*t210*t21
     6           7*t96-1.2400568154133333d-4*t109*t111*t126*t18*t96+t28*
     7           (-5.15088d-3*t111*t418-5.15088d-3*rhoa*t111*t14*t17*t41
     8           7-6.4386d-4*gammaaa*t14*t209*t222*t35-6.4386d-4*gammaaa
     9           *t111*t14*t15*t209*t35-6.4386d-4*gammaaa*t111*t124*t209
     :           *t35+1.7169600000000002d-2*t124*t17*t20*t35-2.8616d-2*t
     ;           14*t17*t18*t35-5.15088d-3*rhoa*t14*t17*t207*t222-6.4386
     <           d-4*gammaaa*t111*t114*t14*t209-5.15088d-3*t111*t14*t17*
     =           t207-5.15088d-3*rhoa*t111*t124*t17*t207+1.7169600000000
     >           002d-2*t114*t14*t17*t20+1.7169600000000002d-2*t125*t18)
     ?           +t15*t16*t23*(1.25d-1*gammaaa*t14*t417+1.25d-1*gammaaa*
     @           t124*t207)+t112*t20*(-3.5375419699200006d-4*t111*t14*t1
     1           7*t35-2.060352d-2*t240)+t15*t209*t23*(-1.25d-1*gammaaa*
     2           t124*t35-1.25d-1*gammaaa*t114*t14)+1.28772d-3*gammaaa*t
     3           111*t14*t15*t209*t28*t35+5.58012d-3*gammaaa*t110*t14*t1
     4           6*t28*t35+1.25d-1*gammaaa*t14*t209*t218*t23*t35-1.63993
     5           08763819376d-6*t1*t14*t17*t217*t220*t35+6.6328911936d-6
     6           *gammaaa*t112*t14*t209*t217*t35+2.65315647744d-5*gammaa
     7           a*t111*t112*t14*t16*t18*t35-1.219864d-2*t126*t20*t325-6
     8           .09932d-3*t102*t20*t324-1.030176d-2*t20*t239*t28-1.0301
     9           76d-2*t16*t18*t219*t28-1.28772d-3*gammaaa*t111*t14*t15*
     :           t16*t207*t28-1.25d-1*gammaaa*t14*t16*t207*t218*t23+5.30
     ;           631295488d-5*rhoa*t112*t14*t17*t207*t217)*wght+Mmat3(iq
     <           ,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = (t98*(1.0d+0*t96*(-1.4880681784960
     1           004d-3*t104*t105*t111*t18*t241*t55*taua-7.4403408924800
     2           01d-4*t100*t103*t111*t18*t241*t55*taua-2.48011363082666
     3           72d-4*t108*t111*t126*t18*t55*taua+1.6264853333333334d-1
     4           *t105*t111*t126*t18*t55*taua-2.1686471111111114d-1*gamm
     5           aaa*t103*t113*t126*t55*taua-2.1686471111111114d-1*t104*
     6           t105*t110*t126*t55*taua-1.0843235555555557d-1*t100*t103
     7           *t110*t126*t55*taua-5.421617777777779d-2*t102*t108*t110
     8           *t55*taua+3.5555555555555557d+1*t102*t105*t110*t55*taua
     9           -1.3614306003696336d-6*t101*t217*t461*t55*t99-1.7349176
     :           888888887d-1*t126*t223*t26*t55*t99+1.1160511338720001d-
     ;           4*t101*t222*t241*t55*t99-1.1904545427968d-3*gammaaa*t10
     <           0*t110*t111*t241*t55*t99-2.3855118222222224d-1*gammaaa*
     =           t100*t126*t221*t55*t99-1.3614306003696336d-6*t105*t106*
     >           t217*t461*t55-1.3614306003696336d-6*t100*t103*t104*t217
     ?           *t461*t55-2.710808888888889d-1*t105*t126*t208*t27*t55+1
     @           .1160511338720001d-4*t105*t106*t222*t241*t55+1.11605113
     1           38720001d-4*t100*t103*t104*t222*t241*t55-3.403576500924
     2           0837d-7*t104*t108*t217*t241*t55-3.4035765009240837d-7*t
     3           100*t107*t217*t241*t55+2.2321022677440003d-4*t104*t105*
     4           t217*t241*t55+1.1160511338720001d-4*t100*t103*t217*t241
     5           *t55-5.952272713984d-4*gammaaa*t103*t104*t110*t111*t241
     6           *t55+3.72017044624d-5*t104*t108*t126*t222*t55+3.7201704
     7           4624d-5*t100*t107*t126*t222*t55-2.439728d-2*t104*t105*t
     8           126*t222*t55-1.219864d-2*t100*t103*t126*t222*t55-6.0993
     9           2d-3*t102*t108*t222*t55-1.1927559111111112d-1*gammaaa*t
     :           103*t104*t126*t221*t55-5.963779555555556d-2*gammaaa*t10
     ;           2*t107*t221*t55+1.9555555555555557d+1*gammaaa*t102*t103
     <           *t221*t55+3.72017044624d-5*t108*t126*t217*t55-1.9840909
     =           04661333d-4*gammaaa*t107*t110*t111*t126*t55+6.505941333
     >           333333d-2*gammaaa*t103*t110*t111*t126*t55)+2.0d+0*t168*
     ?           t421+1.0d+0*t216*t323)+t102*(-3.04966d-3*t111*t421*t96-
     @           3.04966d-3*t216*t222*t96-3.04966d-3*t111*t422-3.04966d-
     1           3*t111*t168*t216)-3.4035765009240837d-7*t109*t217*t241*
     2           t55*t96+1.86008522312d-5*t126*t216*t217*t96-1.219864d-2
     3           *t126*t325*t55-6.09932d-3*t102*t324*t55)*wght+Mmat3(iq,
     4           D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = (t98*(1.0d+0*t96*(-2.7108088888888
     1           89d-1*t105*t126*t206*t53*taua*taub-1.0843235555555557d-
     2           1*gammaaa*t103*t126*t27*t53*taub-7.440340892480001d-4*t
     3           104*t105*t111*t20*t241*t53*taub-3.7201704462400004d-4*t
     4           100*t103*t111*t20*t241*t53*taub-1.2400568154133336d-4*t
     5           108*t111*t126*t20*t53*taub+8.132426666666668d-2*t105*t1
     6           11*t126*t20*t53*taub-1.3554044444444446d-1*t104*t105*t1
     7           26*t18*t53*taub-6.777022222222223d-2*t100*t103*t126*t18
     8           *t53*taub-3.3885111111111116d-2*t102*t108*t18*t53*taub+
     9           2.2222222222222224d+1*t102*t105*t18*t53*taub-7.44034089
     :           2480001d-4*t104*t105*t171*t206*t241*taua-3.720170446240
     ;           0004d-4*t100*t103*t171*t206*t241*taua-1.240056815413333
     <           6d-4*t108*t126*t171*t206*taua+8.132426666666668d-2*t105
     =           *t126*t171*t206*taua-1.0843235555555557d-1*gammabb*t103
     >           *t126*t170*t206*taua-1.3614306003696336d-6*t101*t111*t1
     ?           71*t20*t461*t99-5.952272713984d-4*gammaaa*t100*t171*t24
     @           1*t27*t99-1.7349176888888887d-1*gammaaa*gammabb*t126*t1
     1           70*t27*t99-5.952272713984d-4*gammabb*t100*t111*t170*t20
     2           *t241*t99-1.8600852231200002d-4*t101*t171*t18*t241*t99-
     3           1.0843235555555555d-1*gammabb*t100*t126*t170*t18*t99-1.
     4           3614306003696336d-6*t105*t106*t111*t171*t20*t461-1.3614
     5           306003696336d-6*t100*t103*t104*t111*t171*t20*t461-2.976
     6           136356992d-4*gammaaa*t103*t104*t171*t241*t27-9.92045452
     7           3306665d-5*gammaaa*t107*t126*t171*t27+3.252970666666666
     8           3d-2*gammaaa*t103*t126*t171*t27-3.4035765009240837d-7*t
     9           104*t108*t111*t171*t20*t241-3.4035765009240837d-7*t100*
     :           t107*t111*t171*t20*t241+2.2321022677440003d-4*t104*t105
     ;           *t111*t171*t20*t241+1.1160511338720001d-4*t100*t103*t11
     <           1*t171*t20*t241-2.976136356992d-4*gammabb*t103*t104*t11
     =           1*t170*t20*t241-1.8600852231200002d-4*t105*t106*t171*t1
     >           8*t241-1.8600852231200002d-4*t100*t103*t104*t171*t18*t2
     ?           41+3.72017044624d-5*t108*t111*t126*t171*t20-9.920454523
     @           306665d-5*gammabb*t107*t111*t126*t170*t20+3.25297066666
     1           66663d-2*gammabb*t103*t111*t126*t170*t20-6.200284077066
     2           667d-5*t104*t108*t126*t171*t18-6.200284077066667d-5*t10
     3           0*t107*t126*t171*t18+4.066213333333334d-2*t104*t105*t12
     4           6*t171*t18+2.033106666666667d-2*t100*t103*t126*t171*t18
     5           +1.0165533333333335d-2*t102*t108*t171*t18-5.42161777777
     6           7777d-2*gammabb*t103*t104*t126*t170*t18-2.7108088888888
     7           887d-2*gammabb*t102*t107*t170*t18+8.88888888888889d+0*g
     8           ammabb*t102*t103*t170*t18)+1.0d+0*t168*t423+1.0d+0*t197
     9           *t419+1.0d+0*t210*t337)+t102*(-3.04966d-3*t111*t423*t96
     :           +1.0165533333333335d-2*t18*t186*t96-3.04966d-3*t171*t42
     ;           0-3.04966d-3*t111*t197*t210+1.0165533333333335d-2*t109*
     <           t18*t197)-3.4035765009240837d-7*t109*t111*t171*t20*t241
     =           *t96+1.86008522312d-5*t111*t126*t171*t210*t96-6.2002840
     >           77066667d-5*t109*t126*t171*t18*t96-1.219864d-2*t126*t20
     ?           *t339-6.09932d-3*t102*t20*t338)*wght+Mmat3(iq,D3_RA_RB_
     @           TA)
              Mmat3(iq,D3_RA_RB_TB) = (t98*(1.0d+0*t96*(-2.7108088888888
     1           89d-1*t105*t126*t18*t212*taua*taub-7.440340892480001d-4
     2           *t104*t105*t111*t212*t241*taub-3.7201704462400004d-4*t1
     3           00*t103*t111*t212*t241*taub-1.2400568154133336d-4*t108*
     4           t111*t126*t212*taub+8.132426666666668d-2*t105*t111*t126
     5           *t212*taub-1.0843235555555557d-1*gammaaa*t103*t110*t126
     6           *t212*taub-1.0843235555555557d-1*gammabb*t103*t126*t18*
     7           t60*taua-7.440340892480001d-4*t104*t105*t171*t18*t241*t
     8           55*taua-3.7201704462400004d-4*t100*t103*t171*t18*t241*t
     9           55*taua-1.2400568154133336d-4*t108*t126*t171*t18*t55*ta
     :           ua+8.132426666666668d-2*t105*t126*t171*t18*t55*taua-1.3
     ;           554044444444446d-1*t104*t105*t126*t18*t53*taua-6.777022
     <           222222223d-2*t100*t103*t126*t18*t53*taua-3.388511111111
     =           1116d-2*t102*t108*t18*t53*taua+2.2222222222222224d+1*t1
     >           02*t105*t18*t53*taua-5.952272713984d-4*gammabb*t100*t11
     ?           1*t241*t60*t99-1.7349176888888887d-1*gammaaa*gammabb*t1
     @           10*t126*t60*t99-1.3614306003696336d-6*t101*t111*t171*t4
     1           61*t55*t99-5.952272713984d-4*gammaaa*t100*t110*t171*t24
     2           1*t55*t99-1.8600852231200002d-4*t101*t111*t241*t53*t99-
     3           1.0843235555555555d-1*gammaaa*t100*t110*t126*t53*t99-2.
     4           976136356992d-4*gammabb*t103*t104*t111*t241*t60-9.92045
     5           4523306665d-5*gammabb*t107*t111*t126*t60+3.252970666666
     6           6663d-2*gammabb*t103*t111*t126*t60-1.3614306003696336d-
     7           6*t105*t106*t111*t171*t461*t55-1.3614306003696336d-6*t1
     8           00*t103*t104*t111*t171*t461*t55-3.4035765009240837d-7*t
     9           104*t108*t111*t171*t241*t55-3.4035765009240837d-7*t100*
     :           t107*t111*t171*t241*t55+2.2321022677440003d-4*t104*t105
     ;           *t111*t171*t241*t55+1.1160511338720001d-4*t100*t103*t11
     <           1*t171*t241*t55-2.976136356992d-4*gammaaa*t103*t104*t11
     =           0*t171*t241*t55+3.72017044624d-5*t108*t111*t126*t171*t5
     >           5-9.920454523306665d-5*gammaaa*t107*t110*t126*t171*t55+
     ?           3.2529706666666663d-2*gammaaa*t103*t110*t126*t171*t55-1
     @           .8600852231200002d-4*t105*t106*t111*t241*t53-1.86008522
     1           31200002d-4*t100*t103*t104*t111*t241*t53-6.200284077066
     2           667d-5*t104*t108*t111*t126*t53-6.200284077066667d-5*t10
     3           0*t107*t111*t126*t53+4.066213333333334d-2*t104*t105*t11
     4           1*t126*t53+2.033106666666667d-2*t100*t103*t111*t126*t53
     5           -5.421617777777777d-2*gammaaa*t103*t104*t110*t126*t53+1
     6           .0165533333333335d-2*t102*t108*t111*t53-2.7108088888888
     7           887d-2*gammaaa*t102*t107*t110*t53+8.88888888888889d+0*g
     8           ammaaa*t102*t103*t110*t53)+1.0d+0*t168*t427+1.0d+0*t197
     9           *t421+1.0d+0*t216*t337)+t102*(-3.04966d-3*t111*t427*t96
     :           +1.0165533333333335d-2*t169*t53-3.04966d-3*t171*t422-3.
     ;           04966d-3*t111*t197*t216)-3.4035765009240837d-7*t109*t11
     <           1*t171*t241*t55*t96-6.200284077066667d-5*t109*t111*t126
     =           *t53*t96+1.86008522312d-5*t111*t126*t171*t216*t96-1.219
     >           864d-2*t126*t339*t55-6.09932d-3*t102*t338*t55)*wght+Mma
     ?           t3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = (t98*(1.0d+0*t96*(-1.4880681784960
     1           004d-3*t104*t105*t171*t20*t241*t53*taub-7.4403408924800
     2           01d-4*t100*t103*t171*t20*t241*t53*taub-2.48011363082666
     3           72d-4*t108*t126*t171*t20*t53*taub+1.6264853333333334d-1
     4           *t105*t126*t171*t20*t53*taub-2.1686471111111114d-1*gamm
     5           abb*t103*t126*t173*t20*taub-2.1686471111111114d-1*t104*
     6           t105*t126*t170*t20*taub-1.0843235555555557d-1*t100*t103
     7           *t126*t170*t20*taub-5.421617777777779d-2*t102*t108*t170
     8           *t20*taub+3.5555555555555557d+1*t102*t105*t170*t20*taub
     9           -1.7349176888888887d-1*t126*t20*t346*t59*t99-1.36143060
     :           03696336d-6*t101*t20*t340*t461*t99+1.1160511338720001d-
     ;           4*t101*t20*t241*t345*t99-2.3855118222222224d-1*gammabb*
     <           t100*t126*t20*t344*t99-1.1904545427968d-3*gammabb*t100*
     =           t170*t171*t20*t241*t99-2.710808888888889d-1*t105*t126*t
     >           20*t214*t60-1.3614306003696336d-6*t105*t106*t20*t340*t4
     ?           61-1.3614306003696336d-6*t100*t103*t104*t20*t340*t461+1
     @           .1160511338720001d-4*t105*t106*t20*t241*t345+1.11605113
     1           38720001d-4*t100*t103*t104*t20*t241*t345+3.72017044624d
     2           -5*t104*t108*t126*t20*t345+3.72017044624d-5*t100*t107*t
     3           126*t20*t345-2.439728d-2*t104*t105*t126*t20*t345-1.2198
     4           64d-2*t100*t103*t126*t20*t345-6.09932d-3*t102*t108*t20*
     5           t345-1.1927559111111112d-1*gammabb*t103*t104*t126*t20*t
     6           344-5.963779555555556d-2*gammabb*t102*t107*t20*t344+1.9
     7           555555555555557d+1*gammabb*t102*t103*t20*t344-3.4035765
     8           009240837d-7*t104*t108*t20*t241*t340-3.4035765009240837
     9           d-7*t100*t107*t20*t241*t340+2.2321022677440003d-4*t104*
     :           t105*t20*t241*t340+1.1160511338720001d-4*t100*t103*t20*
     ;           t241*t340+3.72017044624d-5*t108*t126*t20*t340-5.9522727
     <           13984d-4*gammabb*t103*t104*t170*t171*t20*t241-1.9840909
     =           04661333d-4*gammabb*t107*t126*t170*t171*t20+6.505941333
     >           333333d-2*gammabb*t103*t126*t170*t171*t20)+2.0d+0*t197*
     ?           t423+1.0d+0*t210*t389)+t102*(-3.04966d-3*t171*t423*t96-
     @           3.04966d-3*t210*t345*t96-3.04966d-3*t171*t424-3.04966d-
     1           3*t171*t197*t210)-3.4035765009240837d-7*t109*t20*t241*t
     2           340*t96+1.86008522312d-5*t126*t210*t340*t96-1.219864d-2
     3           *t126*t20*t391-6.09932d-3*t102*t20*t390)*wght+Mmat3(iq,
     4           D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (t58*(1.0d+0*rhob*t49*t52*(-8.2414
     1           08000000001d-1*t172*t31*t60*t62*taub-4.245050363904d-3*
     2           t171*t212*t31*t343*t62*taub-2.0603520000000003d-1*t34*t
     3           60*t61*taub+8.0d+1*t31*t60*t61*taub-2.122525181952d-3*g
     4           ammabb*t171*t211*t29*t343*taub-7.07508393984d-4*t171*t1
     5           72*t212*t34*taub+2.747136d-1*t171*t172*t212*t31*taub-7.
     6           783552d-1*gammabb*t172*t202*t29*taub-6.559723505527751d
     7           -6*t31*t340*t55*t587*t63+3.183787772928d-4*t31*t343*t34
     8           5*t55*t63-1.0612625909760003d-3*t171*t31*t343*t53*t63-9
     9           .157120000000001d-2*t170*t172*t31*t63-4.578560000000000
     :           4d-2*t170*t34*t61*t62+1.7777777777777778d+1*t170*t31*t6
     ;           1*t62-2.7592827365376d-3*gammabb*t171*t29*t343*t60*t62-
     <           6.559723505527751d-6*gammabb*t212*t29*t340*t587*t62+1.0
     =           61262590976d-4*t172*t34*t345*t55*t62-4.120704d-2*t172*t
     >           31*t345*t55*t62-1.6399308763819376d-6*t34*t340*t343*t55
     ?           *t62+6.367575545856d-4*t31*t340*t343*t55*t62-3.53754196
     @           99200006d-4*t171*t172*t34*t53*t62+1.373568d-1*t171*t172
     1           *t31*t53*t62+3.183787772928d-4*gammabb*t212*t29*t343*t3
     2           45*t62-4.7617024d-1*gammabb*t172*t173*t29*t62-1.030176d
     3           -2*t34*t345*t55*t61+3.4339200000000003d-2*t171*t34*t53*
     4           t61-2.3808512d-1*gammabb*t173*t33*t61+4.622222222222223
     5           d+1*gammabb*t173*t29*t61-9.197609121792001d-4*gammabb*t
     6           171*t172*t33*t60+1.7856384d-1*gammabb*t171*t172*t29*t60
     7           -6.559723505527751d-6*t211*t25*t340*t587*t59-1.15379712
     8           00000001d+0*t172*t25*t404*t59+3.183787772928d-4*t211*t2
     9           5*t343*t345*t59-4.4573028820992006d-3*t171*t202*t25*t34
     :           3*t59+8.88888888888889d+0*t170*t34*t58+1.061262590976d-
     ;           4*t172*t34*t340*t55+1.061262590976d-4*gammabb*t172*t212
     <           *t33*t345-2.060352d-2*gammabb*t172*t212*t29*t345-1.6399
     =           308763819376d-6*gammabb*t212*t33*t340*t343+3.1837877729
     >           28d-4*gammabb*t212*t29*t340*t343-4.5785600000000004d-1*
     ?           t172*t211*t214*t31)+1.25d-1*gammabb*t184*t215*t50*t64-1
     @           .25d-1*gammabb*t215*t341*t49*t64+1.25d-1*gammabb*t215*t
     1           361*t64+2.0d+0*t425*t49*t52+2.0d+0*rhob*t184*t425*t52+1
     2           .0d+0*rhob*t213*t361*t52+2.0d+0*t184*t213*t52+1.25d-1*g
     3           ammabb*t425*t49*t50*t51+1.25d-1*gammabb*t184*t213*t50*t
     4           51+1.25d-1*gammabb*t213*t341*t49*t51+1.25d-1*gammabb*t1
     5           74*t215*t49*t50+1.25d-1*gammabb*t215*t347*t49+2.5d-1*ga
     6           mmabb*t174*t184*t215)+t98*(1.0d+0*t96*(-4.8794560000000
     7           01d-1*t104*t105*t126*t60*taub-2.4397280000000005d-1*t10
     8           0*t103*t126*t60*taub-1.2198640000000002d-1*t102*t108*t6
     9           0*taub+8.0d+1*t102*t105*t60*taub-1.4880681784960004d-3*
     :           t104*t105*t171*t212*t241*taub-7.440340892480001d-4*t100
     ;           *t103*t171*t212*t241*taub-2.4801136308266672d-4*t108*t1
     <           26*t171*t212*taub+1.6264853333333334d-1*t105*t126*t171*
     =           t212*taub-2.1686471111111114d-1*gammabb*t103*t126*t202*
     >           taub-1.1904545427968d-3*gammabb*t100*t171*t241*t60*t99-
     ?           1.7349176888888887d-1*t126*t404*t59*t99-1.3614306003696
     @           336d-6*t101*t340*t461*t55*t99+1.1160511338720001d-4*t10
     1           1*t241*t345*t55*t99-3.7201704462400004d-4*t101*t171*t24
     2           1*t53*t99-4.554158933333333d-1*gammabb*t100*t126*t173*t
     3           99-5.421617777777779d-2*t101*t126*t170*t99+8.8888888888
     4           8889d+0*t108*t170*t98-5.952272713984d-4*gammabb*t103*t1
     5           04*t171*t241*t60-1.984090904661333d-4*gammabb*t107*t126
     6           *t171*t60+6.505941333333333d-2*gammabb*t103*t126*t171*t
     7           60-1.3614306003696336d-6*t105*t106*t340*t461*t55-1.3614
     8           306003696336d-6*t100*t103*t104*t340*t461*t55+1.11605113
     9           38720001d-4*t105*t106*t241*t345*t55+1.1160511338720001d
     :           -4*t100*t103*t104*t241*t345*t55+3.72017044624d-5*t104*t
     ;           108*t126*t345*t55+3.72017044624d-5*t100*t107*t126*t345*
     <           t55-2.439728d-2*t104*t105*t126*t345*t55-1.219864d-2*t10
     =           0*t103*t126*t345*t55-6.09932d-3*t102*t108*t345*t55-3.40
     >           35765009240837d-7*t104*t108*t241*t340*t55-3.40357650092
     ?           40837d-7*t100*t107*t241*t340*t55+2.2321022677440003d-4*
     @           t104*t105*t241*t340*t55+1.1160511338720001d-4*t100*t103
     1           *t241*t340*t55+3.72017044624d-5*t108*t126*t340*t55-3.72
     2           01704462400004d-4*t105*t106*t171*t241*t53-3.72017044624
     3           00004d-4*t100*t103*t104*t171*t241*t53-1.240056815413333
     4           3d-4*t104*t108*t126*t171*t53-1.2400568154133333d-4*t100
     5           *t107*t126*t171*t53+8.132426666666668d-2*t104*t105*t126
     6           *t171*t53+4.066213333333334d-2*t100*t103*t126*t171*t53+
     7           2.033106666666667d-2*t102*t108*t171*t53-2.7108088888888
     8           89d-1*t105*t126*t211*t214-2.2770794666666666d-1*gammabb
     9           *t103*t104*t126*t173-1.1385397333333333d-1*gammabb*t102
     :           *t107*t173+3.7333333333333335d+1*gammabb*t102*t103*t173
     ;           -5.421617777777779d-2*t105*t106*t126*t170-5.42161777777
     <           7779d-2*t100*t103*t104*t126*t170-2.710808888888889d-2*t
     =           102*t104*t108*t170-2.710808888888889d-2*t100*t102*t107*
     >           t170+1.7777777777777778d+1*t102*t104*t105*t170+8.888888
     ?           88888889d+0*t100*t102*t103*t170)+2.0d+0*t197*t427+1.0d+
     @           0*t216*t389)+t102*(1.0165533333333335d-2*t186*t53*t96-3
     1           .04966d-3*t171*t427*t96-3.04966d-3*t216*t345*t96-2.7108
     2           08888888889d-2*t109*t170*t96+1.0165533333333335d-2*t198
     3           *t53+1.0165533333333335d-2*t109*t197*t53-3.04966d-3*t17
     4           1*t428-3.04966d-3*t171*t197*t216)-3.4035765009240837d-7
     5           *t109*t241*t340*t55*t96-1.2400568154133333d-4*t109*t126
     6           *t171*t53*t96+1.86008522312d-5*t126*t216*t340*t96+t61*(
     7           1.7169600000000002d-2*t184*t52*t55*t64-2.8616d-2*t49*t5
     8           2*t53*t64-6.4386d-4*gammabb*t171*t215*t49*t50*t64-6.438
     9           6d-4*gammabb*t215*t345*t49*t64-6.4386d-4*gammabb*t171*t
     :           184*t215*t64+1.7169600000000002d-2*t174*t49*t52*t55+1.7
     ;           169600000000002d-2*t185*t53-5.15088d-3*rhob*t171*t425*t
     <           49*t52-5.15088d-3*rhob*t213*t345*t49*t52-5.15088d-3*t17
     =           1*t213*t49*t52-5.15088d-3*rhob*t171*t184*t213*t52-6.438
     >           6d-4*gammabb*t171*t174*t215*t49-5.15088d-3*t171*t426)+t
     ?           172*t55*(-3.5375419699200006d-4*t171*t49*t52*t64-2.0603
     @           52d-2*t363)+t215*t50*t58*(-1.25d-1*gammabb*t184*t64-1.2
     1           5d-1*gammabb*t174*t49)+5.58012d-3*gammabb*t170*t49*t51*
     2           t61*t64+1.28772d-3*gammabb*t171*t215*t49*t50*t61*t64+1.
     3           25d-1*gammabb*t215*t341*t49*t58*t64+2.65315647744d-5*ga
     4           mmabb*t171*t172*t49*t51*t53*t64-1.6399308763819376d-6*t
     5           340*t343*t36*t49*t52*t64+6.6328911936d-6*gammabb*t172*t
     6           215*t340*t49*t64-1.030176d-2*t362*t55*t61-1.030176d-2*t
     7           342*t51*t53*t61-1.28772d-3*gammabb*t171*t213*t49*t50*t5
     8           1*t61+(1.25d-1*gammabb*t425*t49+1.25d-1*gammabb*t184*t2
     9           13)*t50*t51*t58-1.25d-1*gammabb*t213*t341*t49*t51*t58-1
     :           .219864d-2*t126*t391*t55-6.09932d-3*t102*t390*t55+5.306
     ;           31295488d-5*rhob*t172*t213*t340*t49*t52)*wght+Mmat3(iq,
     <           D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (t23*(1.0d+0*rhoa*t14*t17*(-1.061
     1           262590976d-3*gammaaa*t220*t29*t429*taua-3.53754196992d-
     2           4*t112*t205*t34*taua-2.122525181952d-3*t205*t220*t30*t3
     3           1*taua+1.373568d-1*t112*t205*t31*taua+6.867840000000001
     4           d-2*t112*t205*t29*taua-6.559723505527751d-6*t111*t25*t2
     5           6*t429*t452-6.559723505527751d-6*t111*t206*t31*t32*t452
     6           -6.559723505527751d-6*gammaaa*t111*t205*t29*t30*t452-3.
     7           0776615138304003d-3*t220*t25*t26*t410-4.598804560896000
     8           4d-4*t112*t27*t30*t34-1.6399308763819376d-6*t111*t206*t
     9           220*t30*t34+4.464096d-2*t27*t28*t34+1.061262590976d-4*t
     :           111*t112*t206*t34+4.464096d-2*t27*t28*t33-1.63993087638
     ;           19376d-6*gammaaa*t111*t205*t220*t33+1.061262590976d-4*t
     <           111*t112*t206*t33-7.428838136832d-4*gammaaa*t112*t199*t
     =           33-1.3796413682688d-3*t220*t27*t31*t32+1.7856384d-1*t11
     >           2*t27*t30*t31+6.367575545856d-4*t111*t206*t220*t30*t31+
     ?           8.928192d-2*t112*t27*t29*t30+3.183787772928d-4*t111*t20
     @           6*t220*t29*t30-2.2286514410496003d-3*gammaaa*t199*t220*
     1           t29*t30-8.666666666666666d+0*t27*t28*t29+3.183787772928
     2           d-4*gammaaa*t111*t205*t220*t29-2.060352d-2*t111*t112*t2
     3           06*t29+1.4422464000000002d-1*gammaaa*t112*t199*t29+6.36
     4           7575545856d-4*gammaaa*t111*t205*t220*t25+2.884492800000
     5           0003d-1*gammaaa*t112*t199*t25)+1.0d+0*t14*t17*t430+1.0d
     6           +0*rhoa*t124*t17*t430-1.25d-1*t14*t16*t417+1.25d-1*gamm
     7           aaa*t14*t209*t394+1.25d-1*t14*t15*t209*t35+1.25d-1*t124
     8           *t209*t35+1.25d-1*gammaaa*t14*t15*t200*t209+1.25d-1*gam
     9           maaa*t124*t200*t209+1.25d-1*t114*t14*t209-1.25d-1*t14*t
     :           15*t16*t207-1.25d-1*t124*t16*t207)+t98*(1.0d+0*t96*(-7.
     ;           440340892480001d-4*t104*t105*t205*t241*taua-3.720170446
     <           2400004d-4*t100*t103*t205*t241*taua-1.2400568154133336d
     =           -4*t108*t126*t205*taua+8.132426666666668d-2*t105*t126*t
     >           205*taua+4.066213333333334d-2*t103*t126*t205*taua-1.361
     ?           4306003696336d-6*t101*t111*t206*t461*t99-4.836221580112
     @           d-4*t101*t241*t27*t99+1.0572154666666667d-1*t100*t126*t
     1           27*t99+2.2321022677440003d-4*t100*t111*t206*t241*t99-5.
     2           952272713984d-4*gammaaa*t100*t199*t241*t99+6.5059413333
     3           33333d-2*gammaaa*t126*t199*t99-1.3614306003696336d-6*t1
     4           05*t106*t111*t206*t461-1.3614306003696336d-6*t100*t103*
     5           t104*t111*t206*t461-4.836221580112d-4*t105*t106*t241*t2
     6           7-4.836221580112d-4*t100*t103*t104*t241*t27-1.612073860
     7           0373333d-4*t104*t108*t126*t27-1.6120738600373333d-4*t10
     8           0*t107*t126*t27+1.0572154666666667d-1*t104*t105*t126*t2
     9           7+5.286077333333333d-2*t103*t104*t126*t27+5.28607733333
     :           3333d-2*t100*t103*t126*t27+2.6430386666666666d-2*t102*t
     ;           108*t27+2.6430386666666666d-2*t102*t107*t27-8.666666666
     <           666666d+0*t102*t103*t27-3.4035765009240837d-7*t104*t108
     =           *t111*t206*t241-3.4035765009240837d-7*t100*t107*t111*t2
     >           06*t241+2.2321022677440003d-4*t104*t105*t111*t206*t241+
     ?           1.1160511338720001d-4*t103*t104*t111*t206*t241+1.116051
     @           1338720001d-4*t100*t103*t111*t206*t241-2.976136356992d-
     1           4*gammaaa*t103*t104*t199*t241+3.72017044624d-5*t108*t11
     2           1*t126*t206+3.72017044624d-5*t107*t111*t126*t206-1.2198
     3           64d-2*t103*t111*t126*t206-9.920454523306665d-5*gammaaa*
     4           t107*t126*t199+3.2529706666666663d-2*gammaaa*t103*t126*
     5           t199)+1.0d+0*t168*t432)+t102*t18*(1.0165533333333335d-2
     6           *t201*t96-3.04966d-3*t420)-3.04966d-3*t102*t111*t432*t9
     7           6-1.6120738600373333d-4*t109*t126*t27*t96-3.40357650092
     8           40837d-7*t109*t111*t206*t241*t96+1.86008522312d-5*t111*
     9           t126*t18*t210*t96+8.132426666666667d-3*t102*t110*t210*t
     :           96+3.72017044624d-5*t111*t126*t20*t201*t96+t16*t18*t28*
     ;           (t612-2.1462d-3*t14*t35)+t20*t28*(t609+1.71696000000000
     <           02d-2*t14*t17*t200)+t15*t209*t23*t604-1.639930876381937
     =           6d-6*t111*t14*t17*t220*t35*t431+t15*t16*t23*(1.25d-1*ga
     >           mmaaa*t14*t430+1.25d-1*t14*t207)-5.15088d-3*rhoa*t111*t
     ?           14*t17*t28*t430+t18*t28*(-5.15088d-3*t418+1.71696000000
     @           00002d-3*gammaaa*t14*t15*t209*t35+1.373568d-2*t14*t17*t
     1           207)-6.09932d-3*t102*t20*t398+t112*t206*(-2.060352d-2*t
     2           396-1.7687709849600003d-4*t14*t17*t35)+t209*t28*(-6.438
     3           6d-4*t111*t14*t35-6.4386d-4*gammaaa*t111*t14*t200)+6.43
     4           86d-4*gammaaa*t110*t14*t209*t28*t35+1.32657823872d-5*ga
     5           mmaaa*t112*t14*t16*t27*t35+6.6328911936d-6*gammaaa*t111
     6           *t112*t14*t18*t209*t35-1.32657823872d-5*t111*t112*t14*t
     7           16*t20*t35+6.4386d-4*t111*t14*t16*t207*t28-6.4386d-4*ga
     8           mmaaa*t110*t14*t16*t207*t28+5.30631295488d-5*t111*t112*
     9           t14*t17*t20*t207+3.72017044624d-5*t126*t169*t206+1.0612
     :           62590976d-4*t1*t111*t112*t14*t17*t200)*wght+Mmat3(iq,D3
     ;           _RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = (t98*(1.0d+0*t96*(-7.440340892480
     1           001d-4*t104*t105*t241*t27*t55*taua-3.7201704462400004d-
     2           4*t100*t103*t241*t27*t55*taua-1.2400568154133336d-4*t10
     3           8*t126*t27*t55*taua+8.132426666666668d-2*t105*t126*t27*
     4           t55*taua+4.066213333333334d-2*t103*t126*t27*t55*taua-1.
     5           3614306003696336d-6*t101*t111*t18*t461*t55*t99+2.232102
     6           2677440003d-4*t100*t111*t18*t241*t55*t99-5.952272713984
     7           d-4*gammaaa*t100*t113*t241*t55*t99-2.976136356992d-4*t1
     8           01*t110*t241*t55*t99+6.505941333333333d-2*gammaaa*t113*
     9           t126*t55*t99+6.505941333333333d-2*t100*t110*t126*t55*t9
     :           9-1.3614306003696336d-6*t105*t106*t111*t18*t461*t55-1.3
     ;           614306003696336d-6*t100*t103*t104*t111*t18*t461*t55-3.4
     <           035765009240837d-7*t104*t108*t111*t18*t241*t55-3.403576
     =           5009240837d-7*t100*t107*t111*t18*t241*t55+2.23210226774
     >           40003d-4*t104*t105*t111*t18*t241*t55+1.1160511338720001
     ?           d-4*t103*t104*t111*t18*t241*t55+1.1160511338720001d-4*t
     @           100*t103*t111*t18*t241*t55-2.976136356992d-4*gammaaa*t1
     1           03*t104*t113*t241*t55-2.976136356992d-4*t105*t106*t110*
     2           t241*t55-2.976136356992d-4*t100*t103*t104*t110*t241*t55
     3           +3.72017044624d-5*t108*t111*t126*t18*t55+3.72017044624d
     4           -5*t107*t111*t126*t18*t55-1.219864d-2*t103*t111*t126*t1
     5           8*t55-9.920454523306665d-5*gammaaa*t107*t113*t126*t55+3
     6           .2529706666666663d-2*gammaaa*t103*t113*t126*t55-9.92045
     7           4523306665d-5*t104*t108*t110*t126*t55-9.920454523306665
     8           d-5*t100*t107*t110*t126*t55+6.505941333333333d-2*t104*t
     9           105*t110*t126*t55+3.2529706666666663d-2*t103*t104*t110*
     :           t126*t55+3.2529706666666663d-2*t100*t103*t110*t126*t55+
     ;           1.6264853333333332d-2*t102*t108*t110*t55+1.626485333333
     <           3332d-2*t102*t107*t110*t55-5.333333333333333d+0*t102*t1
     =           03*t110*t55)+1.0d+0*t168*t433)-3.4035765009240837d-7*t1
     >           09*t111*t18*t241*t55*t96+3.72017044624d-5*t111*t126*t20
     ?           1*t55*t96-9.920454523306665d-5*t109*t110*t126*t55*t96-3
     @           .04966d-3*t102*t111*t433*t96+1.86008522312d-5*t111*t126
     1           *t18*t216*t96+8.132426666666667d-3*t102*t110*t216*t96-6
     2           .09932d-3*t102*t398*t55+3.72017044624d-5*t126*t169*t18*
     3           t55-3.04966d-3*t102*t18*t422)*wght+Mmat3(iq,D3_RA_GAA_T
     4           B)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = (t98*(1.0d+0*t96*(-7.440340892480
     1           001d-4*t104*t105*t206*t241*t53*taua-3.7201704462400004d
     2           -4*t100*t103*t206*t241*t53*taua-1.2400568154133336d-4*t
     3           108*t126*t206*t53*taua+8.132426666666668d-2*t105*t126*t
     4           206*t53*taua+4.066213333333334d-2*t103*t126*t206*t53*ta
     5           ua-1.3614306003696336d-6*t101*t111*t20*t461*t53*t99-5.9
     6           52272713984d-4*gammaaa*t100*t241*t27*t53*t99+6.50594133
     7           3333333d-2*gammaaa*t126*t27*t53*t99+2.2321022677440003d
     8           -4*t100*t111*t20*t241*t53*t99+t624+t623+t622+t621+t620+
     9           t619+t618+t617+t616+t615+t614+t613-1.3614306003696336d-
     :           6*t105*t106*t111*t20*t461*t53-1.3614306003696336d-6*t10
     ;           0*t103*t104*t111*t20*t461*t53-2.976136356992d-4*gammaaa
     <           *t103*t104*t241*t27*t53-9.920454523306665d-5*gammaaa*t1
     =           07*t126*t27*t53+3.2529706666666663d-2*gammaaa*t103*t126
     >           *t27*t53-3.4035765009240837d-7*t104*t108*t111*t20*t241*
     ?           t53-3.4035765009240837d-7*t100*t107*t111*t20*t241*t53+2
     @           .2321022677440003d-4*t104*t105*t111*t20*t241*t53+1.1160
     1           511338720001d-4*t103*t104*t111*t20*t241*t53+1.116051133
     2           8720001d-4*t100*t103*t111*t20*t241*t53+3.72017044624d-5
     3           *t108*t111*t126*t20*t53+3.72017044624d-5*t107*t111*t126
     4           *t20*t53-1.219864d-2*t103*t111*t126*t20*t53)+1.0d+0*t16
     5           8*t434)-3.4035765009240837d-7*t109*t111*t20*t241*t53*t9
     6           6+1.86008522312d-5*t111*t126*t210*t53*t96-3.04966d-3*t1
     7           02*t111*t434*t96+3.72017044624d-5*t111*t126*t20*t204*t9
     8           6+1.0165533333333335d-2*t102*t18*t204*t96+t625-3.04966d
     9           -3*t102*t420*t53+3.72017044624d-5*t126*t169*t20*t53-6.0
     :           9932d-3*t102*t20*t400)*wght+Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = (t98*(1.0d+0*t96*(-7.440340892480
     1           001d-4*t104*t105*t18*t212*t241*taua-3.7201704462400004d
     2           -4*t100*t103*t18*t212*t241*taua-1.2400568154133336d-4*t
     3           108*t126*t18*t212*taua+8.132426666666668d-2*t105*t126*t
     4           18*t212*taua+4.066213333333334d-2*t103*t126*t18*t212*ta
     5           ua-1.3614306003696336d-6*t101*t111*t212*t461*t99+2.2321
     6           022677440003d-4*t100*t111*t212*t241*t99-5.952272713984d
     7           -4*gammaaa*t100*t110*t212*t241*t99+6.505941333333333d-2
     8           *gammaaa*t110*t126*t212*t99-1.3614306003696336d-6*t105*
     9           t106*t111*t212*t461-1.3614306003696336d-6*t100*t103*t10
     :           4*t111*t212*t461-3.4035765009240837d-7*t104*t108*t111*t
     ;           212*t241-3.4035765009240837d-7*t100*t107*t111*t212*t241
     <           +2.2321022677440003d-4*t104*t105*t111*t212*t241+1.11605
     =           11338720001d-4*t103*t104*t111*t212*t241+1.1160511338720
     >           001d-4*t100*t103*t111*t212*t241-2.976136356992d-4*gamma
     ?           aa*t103*t104*t110*t212*t241+3.72017044624d-5*t108*t111*
     @           t126*t212+3.72017044624d-5*t107*t111*t126*t212-1.219864
     1           d-2*t103*t111*t126*t212-9.920454523306665d-5*gammaaa*t1
     2           07*t110*t126*t212+3.2529706666666663d-2*gammaaa*t103*t1
     3           10*t126*t212)+1.0d+0*t168*t438)+3.72017044624d-5*t111*t
     4           126*t204*t55*t96+1.86008522312d-5*t111*t126*t216*t53*t9
     5           6-3.04966d-3*t102*t111*t438*t96-3.4035765009240837d-7*t
     6           109*t111*t212*t241*t96-6.09932d-3*t102*t400*t55-3.04966
     7           d-3*t102*t422*t53+3.72017044624d-5*t126*t169*t212)*wght
     8           +Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = (t98*(1.0d+0*t96*(-7.440340892480
     1           001d-4*t104*t105*t206*t241*t53*taub-3.7201704462400004d
     2           -4*t100*t103*t206*t241*t53*taub-1.2400568154133336d-4*t
     3           108*t126*t206*t53*taub+8.132426666666668d-2*t105*t126*t
     4           206*t53*taub+4.066213333333334d-2*t103*t126*t206*t53*ta
     5           ub-1.3614306003696336d-6*t101*t171*t206*t461*t99+2.2321
     6           022677440003d-4*t100*t171*t206*t241*t99-5.952272713984d
     7           -4*gammabb*t100*t170*t206*t241*t99+6.505941333333333d-2
     8           *gammabb*t126*t170*t206*t99-1.3614306003696336d-6*t105*
     9           t106*t171*t206*t461-1.3614306003696336d-6*t100*t103*t10
     :           4*t171*t206*t461-3.4035765009240837d-7*t104*t108*t171*t
     ;           206*t241-3.4035765009240837d-7*t100*t107*t171*t206*t241
     <           +2.2321022677440003d-4*t104*t105*t171*t206*t241+1.11605
     =           11338720001d-4*t103*t104*t171*t206*t241+1.1160511338720
     >           001d-4*t100*t103*t171*t206*t241-2.976136356992d-4*gamma
     ?           bb*t103*t104*t170*t206*t241+3.72017044624d-5*t108*t126*
     @           t171*t206+3.72017044624d-5*t107*t126*t171*t206-1.219864
     1           d-2*t103*t126*t171*t206-9.920454523306665d-5*gammabb*t1
     2           07*t126*t170*t206+3.2529706666666663d-2*gammabb*t103*t1
     3           26*t170*t206)+1.0d+0*t197*t432)-3.04966d-3*t102*t171*t4
     4           32*t96-3.4035765009240837d-7*t109*t171*t206*t241*t96+1.
     5           86008522312d-5*t126*t171*t18*t210*t96+3.72017044624d-5*
     6           t126*t171*t20*t201*t96-3.04966d-3*t102*t18*t424-6.09932
     7           d-3*t102*t20*t402+3.72017044624d-5*t126*t198*t206)*wght
     8           +Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = (t98*(1.0d+0*t96*(-7.440340892480
     1           001d-4*t104*t105*t18*t212*t241*taub-3.7201704462400004d
     2           -4*t100*t103*t18*t212*t241*taub-1.2400568154133336d-4*t
     3           108*t126*t18*t212*taub+8.132426666666668d-2*t105*t126*t
     4           18*t212*taub+4.066213333333334d-2*t103*t126*t18*t212*ta
     5           ub-5.952272713984d-4*gammabb*t100*t18*t241*t60*t99+6.50
     6           5941333333333d-2*gammabb*t126*t18*t60*t99-1.36143060036
     7           96336d-6*t101*t171*t18*t461*t55*t99+2.2321022677440003d
     8           -4*t100*t171*t18*t241*t55*t99+t624+t623+t622+t621+t620+
     9           t619+t618+t617+t616+t615+t614+t613-2.976136356992d-4*ga
     :           mmabb*t103*t104*t18*t241*t60-9.920454523306665d-5*gamma
     ;           bb*t107*t126*t18*t60+3.2529706666666663d-2*gammabb*t103
     <           *t126*t18*t60-1.3614306003696336d-6*t105*t106*t171*t18*
     =           t461*t55-1.3614306003696336d-6*t100*t103*t104*t171*t18*
     >           t461*t55-3.4035765009240837d-7*t104*t108*t171*t18*t241*
     ?           t55-3.4035765009240837d-7*t100*t107*t171*t18*t241*t55+2
     @           .2321022677440003d-4*t104*t105*t171*t18*t241*t55+1.1160
     1           511338720001d-4*t103*t104*t171*t18*t241*t55+1.116051133
     2           8720001d-4*t100*t103*t171*t18*t241*t55+3.72017044624d-5
     3           *t108*t126*t171*t18*t55+3.72017044624d-5*t107*t126*t171
     4           *t18*t55-1.219864d-2*t103*t126*t171*t18*t55)+1.0d+0*t19
     5           7*t433)-3.4035765009240837d-7*t109*t171*t18*t241*t55*t9
     6           6+3.72017044624d-5*t126*t171*t201*t55*t96+1.01655333333
     7           33335d-2*t102*t201*t53*t96-3.04966d-3*t102*t171*t433*t9
     8           6+1.86008522312d-5*t126*t171*t18*t216*t96+t625-6.09932d
     9           -3*t102*t402*t55+3.72017044624d-5*t126*t18*t198*t55-3.0
     :           4966d-3*t102*t18*t428)*wght+Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = (t98*(1.0d+0*t96*(-7.440340892480
     1           001d-4*t104*t105*t20*t241*t60*taub-3.7201704462400004d-
     2           4*t100*t103*t20*t241*t60*taub-1.2400568154133336d-4*t10
     3           8*t126*t20*t60*taub+8.132426666666668d-2*t105*t126*t20*
     4           t60*taub+4.066213333333334d-2*t103*t126*t20*t60*taub-1.
     5           3614306003696336d-6*t101*t171*t20*t461*t53*t99+2.232102
     6           2677440003d-4*t100*t171*t20*t241*t53*t99-5.952272713984
     7           d-4*gammabb*t100*t173*t20*t241*t99-2.976136356992d-4*t1
     8           01*t170*t20*t241*t99+6.505941333333333d-2*gammabb*t126*
     9           t173*t20*t99+6.505941333333333d-2*t100*t126*t170*t20*t9
     :           9-1.3614306003696336d-6*t105*t106*t171*t20*t461*t53-1.3
     ;           614306003696336d-6*t100*t103*t104*t171*t20*t461*t53-3.4
     <           035765009240837d-7*t104*t108*t171*t20*t241*t53-3.403576
     =           5009240837d-7*t100*t107*t171*t20*t241*t53+2.23210226774
     >           40003d-4*t104*t105*t171*t20*t241*t53+1.1160511338720001
     ?           d-4*t103*t104*t171*t20*t241*t53+1.1160511338720001d-4*t
     @           100*t103*t171*t20*t241*t53+3.72017044624d-5*t108*t126*t
     1           171*t20*t53+3.72017044624d-5*t107*t126*t171*t20*t53-1.2
     2           19864d-2*t103*t126*t171*t20*t53-2.976136356992d-4*gamma
     3           bb*t103*t104*t173*t20*t241-2.976136356992d-4*t105*t106*
     4           t170*t20*t241-2.976136356992d-4*t100*t103*t104*t170*t20
     5           *t241-9.920454523306665d-5*gammabb*t107*t126*t173*t20+3
     6           .2529706666666663d-2*gammabb*t103*t126*t173*t20-9.92045
     7           4523306665d-5*t104*t108*t126*t170*t20-9.920454523306665
     8           d-5*t100*t107*t126*t170*t20+6.505941333333333d-2*t104*t
     9           105*t126*t170*t20+3.2529706666666663d-2*t103*t104*t126*
     :           t170*t20+3.2529706666666663d-2*t100*t103*t126*t170*t20+
     ;           1.6264853333333332d-2*t102*t108*t170*t20+1.626485333333
     <           3332d-2*t102*t107*t170*t20-5.333333333333333d+0*t102*t1
     =           03*t170*t20)+1.0d+0*t197*t434)-3.4035765009240837d-7*t1
     >           09*t171*t20*t241*t53*t96+1.86008522312d-5*t126*t171*t21
     ?           0*t53*t96-3.04966d-3*t102*t171*t434*t96+8.1324266666666
     @           67d-3*t102*t170*t210*t96+3.72017044624d-5*t126*t171*t20
     1           *t204*t96-9.920454523306665d-5*t109*t126*t170*t20*t96-3
     2           .04966d-3*t102*t424*t53+3.72017044624d-5*t126*t198*t20*
     3           t53-6.09932d-3*t102*t20*t409)*wght+Mmat3(iq,D3_RB_GBB_T
     4           A)
              Mmat3(iq,D3_RB_GBB_TB) = (t58*(1.0d+0*rhob*t49*t52*(-2.122
     1           525181952d-3*t211*t31*t343*t62*taub-1.061262590976d-3*g
     2           ammabb*t29*t343*t435*taub-3.53754196992d-4*t172*t211*t3
     3           4*taub+1.373568d-1*t172*t211*t31*taub+6.867840000000001
     4           d-2*t172*t211*t29*taub-1.3796413682688d-3*t31*t343*t60*
     5           t63-6.559723505527751d-6*t171*t212*t31*t587*t63-4.59880
     6           45608960004d-4*t172*t34*t60*t62+1.7856384d-1*t172*t31*t
     7           60*t62+8.928192d-2*t172*t29*t60*t62-6.559723505527751d-
     8           6*gammabb*t171*t211*t29*t587*t62-1.6399308763819376d-6*
     9           t171*t212*t34*t343*t62+6.367575545856d-4*t171*t212*t31*
     :           t343*t62+3.183787772928d-4*t171*t212*t29*t343*t62-2.228
     ;           6514410496003d-3*gammabb*t202*t29*t343*t62+4.464096d-2*
     <           t34*t60*t61+4.464096d-2*t33*t60*t61-8.666666666666666d+
     =           0*t29*t60*t61-6.559723505527751d-6*t171*t25*t435*t587*t
     >           59-3.0776615138304003d-3*t25*t343*t414*t59-1.6399308763
     ?           819376d-6*gammabb*t171*t211*t33*t343+3.183787772928d-4*
     @           gammabb*t171*t211*t29*t343+6.367575545856d-4*gammabb*t1
     1           71*t211*t25*t343+1.061262590976d-4*t171*t172*t212*t34+1
     2           .061262590976d-4*t171*t172*t212*t33-7.428838136832d-4*g
     3           ammabb*t172*t202*t33-2.060352d-2*t171*t172*t212*t29+1.4
     4           422464000000002d-1*gammabb*t172*t202*t29+2.884492800000
     5           0003d-1*gammabb*t172*t202*t25)+1.25d-1*t215*t49*t50*t64
     6           +1.25d-1*t184*t215*t64+1.0d+0*t436*t49*t52+1.0d+0*rhob*
     7           t184*t436*t52-1.25d-1*t213*t49*t50*t51-1.25d-1*t425*t49
     8           *t51-1.25d-1*t184*t213*t51+1.25d-1*gammabb*t203*t215*t4
     9           9*t50+1.25d-1*gammabb*t215*t405*t49+1.25d-1*t174*t215*t
     :           49+1.25d-1*gammabb*t184*t203*t215)+t98*(1.0d+0*t96*(-7.
     ;           440340892480001d-4*t104*t105*t211*t241*taub-3.720170446
     <           2400004d-4*t100*t103*t211*t241*taub-1.2400568154133336d
     =           -4*t108*t126*t211*taub+8.132426666666668d-2*t105*t126*t
     >           211*taub+4.066213333333334d-2*t103*t126*t211*taub-4.836
     ?           221580112d-4*t101*t241*t60*t99+1.0572154666666667d-1*t1
     @           00*t126*t60*t99-1.3614306003696336d-6*t101*t171*t212*t4
     1           61*t99+2.2321022677440003d-4*t100*t171*t212*t241*t99-5.
     2           952272713984d-4*gammabb*t100*t202*t241*t99+6.5059413333
     3           33333d-2*gammabb*t126*t202*t99-4.836221580112d-4*t105*t
     4           106*t241*t60-4.836221580112d-4*t100*t103*t104*t241*t60-
     5           1.6120738600373333d-4*t104*t108*t126*t60-1.612073860037
     6           3333d-4*t100*t107*t126*t60+1.0572154666666667d-1*t104*t
     7           105*t126*t60+5.286077333333333d-2*t103*t104*t126*t60+5.
     8           286077333333333d-2*t100*t103*t126*t60+2.643038666666666
     9           6d-2*t102*t108*t60+2.6430386666666666d-2*t102*t107*t60-
     :           8.666666666666666d+0*t102*t103*t60-1.3614306003696336d-
     ;           6*t105*t106*t171*t212*t461-1.3614306003696336d-6*t100*t
     <           103*t104*t171*t212*t461-3.4035765009240837d-7*t104*t108
     =           *t171*t212*t241-3.4035765009240837d-7*t100*t107*t171*t2
     >           12*t241+2.2321022677440003d-4*t104*t105*t171*t212*t241+
     ?           1.1160511338720001d-4*t103*t104*t171*t212*t241+1.116051
     @           1338720001d-4*t100*t103*t171*t212*t241-2.976136356992d-
     1           4*gammabb*t103*t104*t202*t241+3.72017044624d-5*t108*t12
     2           6*t171*t212+3.72017044624d-5*t107*t126*t171*t212-1.2198
     3           64d-2*t103*t126*t171*t212-9.920454523306665d-5*gammabb*
     4           t107*t126*t202+3.2529706666666663d-2*gammabb*t103*t126*
     5           t202)+1.0d+0*t197*t438)+t102*t53*(1.0165533333333335d-2
     6           *t204*t96-3.04966d-3*t428)-1.6120738600373333d-4*t109*t
     7           126*t60*t96+3.72017044624d-5*t126*t171*t204*t55*t96+1.8
     8           6008522312d-5*t126*t171*t216*t53*t96-3.04966d-3*t102*t1
     9           71*t438*t96-3.4035765009240837d-7*t109*t171*t212*t241*t
     :           96+8.132426666666667d-3*t102*t170*t216*t96+t172*t212*(-
     ;           1.7687709849600003d-4*t49*t52*t64-2.060352d-2*t407)+t53
     <           *t61*(1.7169600000000002d-3*gammabb*t215*t49*t50*t64+1.
     =           373568d-2*t213*t49*t52-5.15088d-3*t426)+t215*t61*(-6.43
     >           86d-4*t171*t49*t64-6.4386d-4*gammabb*t171*t203*t49)+t51
     ?           *t53*t61*(t626-2.1462d-3*t49*t64)+6.4386d-4*gammabb*t17
     @           0*t215*t49*t61*t64+1.32657823872d-5*gammabb*t172*t49*t5
     1           1*t60*t64-1.32657823872d-5*t171*t172*t49*t51*t55*t64+6.
     2           6328911936d-6*gammabb*t171*t172*t215*t49*t53*t64-1.6399
     3           308763819376d-6*t171*t343*t437*t49*t52*t64+t55*t61*(t61
     4           1+1.7169600000000002d-2*t203*t49*t52)-5.15088d-3*rhob*t
     5           171*t436*t49*t52*t61+6.4386d-4*t171*t213*t49*t51*t61-6.
     6           4386d-4*gammabb*t170*t213*t49*t51*t61+t215*t50*t58*t606
     7           +(1.25d-1*gammabb*t436*t49+1.25d-1*t213*t49)*t50*t51*t5
     8           8+5.30631295488d-5*t171*t172*t213*t49*t52*t55-6.09932d-
     9           3*t102*t409*t55+1.061262590976d-4*t171*t172*t203*t36*t4
     :           9*t52+3.72017044624d-5*t126*t198*t212)*wght+Mmat3(iq,D3
     ;           _RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = (1.0d+0*t96*t98*(-1.36143060036963
     1           36d-6*t101*t205*t461*t99+4.4642045354880006d-4*t100*t20
     2           5*t241*t99-2.439728d-2*t126*t205*t99-1.3614306003696336
     3           d-6*t105*t106*t205*t461-1.3614306003696336d-6*t100*t103
     4           *t104*t205*t461-3.4035765009240837d-7*t104*t108*t205*t2
     5           41-3.4035765009240837d-7*t100*t107*t205*t241+2.23210226
     6           77440003d-4*t104*t105*t205*t241+2.2321022677440003d-4*t
     7           103*t104*t205*t241+1.1160511338720001d-4*t100*t103*t205
     8           *t241+3.72017044624d-5*t108*t126*t205+7.44034089248d-5*
     9           t107*t126*t205-2.439728d-2*t103*t126*t205)-6.09932d-3*t
     :           102*t18*t432*t96-6.09932d-3*t102*t20*t412*t96+1.8600852
     ;           2312d-5*t126*t210*t27*t96-3.4035765009240837d-7*t109*t2
     <           05*t241*t96+7.44034089248d-5*t126*t201*t206*t96+t18*t20
     =           9*t28*(t628+t627)+t209*t23*t608+1.0d+0*rhoa*t14*t17*t23
     >           *(-6.559723505527751d-6*gammaaa*t29*t30*t429*t452-6.559
     ?           723505527751d-6*t205*t31*t32*t452-6.559723505527751d-6*
     @           t25*t26*t452/rhoa**1.2333333333333334d+1-1.639930876381
     1           9376d-6*gammaaa*t220*t33*t429+3.183787772928d-4*gammaaa
     2           *t220*t29*t429+1.2735151091712002d-3*gammaaa*t220*t25*t
     3           429-1.6399308763819376d-6*t205*t220*t30*t34+1.061262590
     4           976d-4*t112*t205*t34+2.122525181952d-4*t112*t205*t33+6.
     5           367575545856d-4*t205*t220*t30*t31+6.367575545856d-4*t20
     6           5*t220*t29*t30-4.120704d-2*t112*t205*t29-4.120704d-2*t1
     7           12*t205*t25)-1.6399308763819376d-6*t14*t17*t220*t35*t44
     8           0+2.122525181952d-4*t112*t14*t17*t200*t431-1.030176d-2*
     9           t14*t17*t20*t28*t430-2.5d-1*t14*t16*t23*t430-1.030176d-
     :           2*t1*t14*t17*t28*t411+6.6328911936d-6*gammaaa*t112*t14*
     ;           t209*t27*t35-2.65315647744d-5*t112*t14*t16*t206*t35+1.2
     <           8772d-3*t14*t16*t18*t207*t28+2.57544d-3*t14*t16*t20*t20
     =           0*t28+5.30631295488d-5*t112*t14*t17*t206*t207)*wght+Mma
     >           t3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = (1.0d+0*t96*t98*(-1.36143060036963
     1           36d-6*t101*t27*t461*t55*t99+4.4642045354880006d-4*t100*
     2           t241*t27*t55*t99-2.439728d-2*t126*t27*t55*t99-1.3614306
     3           003696336d-6*t105*t106*t27*t461*t55-1.3614306003696336d
     4           -6*t100*t103*t104*t27*t461*t55-3.4035765009240837d-7*t1
     5           04*t108*t241*t27*t55-3.4035765009240837d-7*t100*t107*t2
     6           41*t27*t55+2.2321022677440003d-4*t104*t105*t241*t27*t55
     7           +2.2321022677440003d-4*t103*t104*t241*t27*t55+1.1160511
     8           338720001d-4*t100*t103*t241*t27*t55+3.72017044624d-5*t1
     9           08*t126*t27*t55+7.44034089248d-5*t107*t126*t27*t55-2.43
     :           9728d-2*t103*t126*t27*t55)-6.09932d-3*t102*t412*t55*t96
     ;           -3.4035765009240837d-7*t109*t241*t27*t55*t96+7.44034089
     <           248d-5*t126*t18*t201*t55*t96-6.09932d-3*t102*t18*t433*t
     =           96+1.86008522312d-5*t126*t216*t27*t96)*wght+Mmat3(iq,D3
     >           _RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = (1.0d+0*t96*t98*(-1.36143060036963
     1           36d-6*t101*t206*t461*t53*t99+4.4642045354880006d-4*t100
     2           *t206*t241*t53*t99-2.439728d-2*t126*t206*t53*t99-1.3614
     3           306003696336d-6*t105*t106*t206*t461*t53-1.3614306003696
     4           336d-6*t100*t103*t104*t206*t461*t53-3.4035765009240837d
     5           -7*t104*t108*t206*t241*t53-3.4035765009240837d-7*t100*t
     6           107*t206*t241*t53+2.2321022677440003d-4*t104*t105*t206*
     7           t241*t53+2.2321022677440003d-4*t103*t104*t206*t241*t53+
     8           1.1160511338720001d-4*t100*t103*t206*t241*t53+3.7201704
     9           4624d-5*t108*t126*t206*t53+7.44034089248d-5*t107*t126*t
     :           206*t53-2.439728d-2*t103*t126*t206*t53)-3.04966d-3*t102
     ;           *t432*t53*t96-3.4035765009240837d-7*t109*t206*t241*t53*
     <           t96+1.86008522312d-5*t126*t18*t210*t53*t96+3.7201704462
     =           4d-5*t126*t20*t201*t53*t96-3.04966d-3*t102*t18*t434*t96
     >           -6.09932d-3*t102*t20*t413*t96+3.72017044624d-5*t126*t20
     ?           4*t206*t96)*wght+Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = (1.0d+0*t96*t98*(-1.36143060036963
     1           36d-6*t101*t18*t212*t461*t99+4.4642045354880006d-4*t100
     2           *t18*t212*t241*t99-2.439728d-2*t126*t18*t212*t99-1.3614
     3           306003696336d-6*t105*t106*t18*t212*t461-1.3614306003696
     4           336d-6*t100*t103*t104*t18*t212*t461-3.4035765009240837d
     5           -7*t104*t108*t18*t212*t241-3.4035765009240837d-7*t100*t
     6           107*t18*t212*t241+2.2321022677440003d-4*t104*t105*t18*t
     7           212*t241+2.2321022677440003d-4*t103*t104*t18*t212*t241+
     8           1.1160511338720001d-4*t100*t103*t18*t212*t241+3.7201704
     9           4624d-5*t108*t126*t18*t212+7.44034089248d-5*t107*t126*t
     :           18*t212-2.439728d-2*t103*t126*t18*t212)-6.09932d-3*t102
     ;           *t413*t55*t96+3.72017044624d-5*t126*t18*t204*t55*t96-3.
     <           04966d-3*t102*t433*t53*t96+1.86008522312d-5*t126*t18*t2
     =           16*t53*t96-3.04966d-3*t102*t18*t438*t96-3.4035765009240
     >           837d-7*t109*t18*t212*t241*t96+3.72017044624d-5*t126*t20
     ?           1*t212*t96)*wght+Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = (1.0d+0*t96*t98*(-1.361430600369
     1           6336d-6*t101*t20*t461*t60*t99+4.4642045354880006d-4*t10
     2           0*t20*t241*t60*t99-2.439728d-2*t126*t20*t60*t99-1.36143
     3           06003696336d-6*t105*t106*t20*t461*t60-1.361430600369633
     4           6d-6*t100*t103*t104*t20*t461*t60-3.4035765009240837d-7*
     5           t104*t108*t20*t241*t60-3.4035765009240837d-7*t100*t107*
     6           t20*t241*t60+2.2321022677440003d-4*t104*t105*t20*t241*t
     7           60+2.2321022677440003d-4*t103*t104*t20*t241*t60+1.11605
     8           11338720001d-4*t100*t103*t20*t241*t60+3.72017044624d-5*
     9           t108*t126*t20*t60+7.44034089248d-5*t107*t126*t20*t60-2.
     :           439728d-2*t103*t126*t20*t60)-3.4035765009240837d-7*t109
     ;           *t20*t241*t60*t96+1.86008522312d-5*t126*t210*t60*t96-6.
     <           09932d-3*t102*t434*t53*t96+7.44034089248d-5*t126*t20*t2
     =           04*t53*t96-6.09932d-3*t102*t20*t416*t96)*wght+Mmat3(iq,
     >           D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = (1.0d+0*t96*t98*(-1.361430600369
     1           6336d-6*t101*t211*t461*t99+4.4642045354880006d-4*t100*t
     2           211*t241*t99-2.439728d-2*t126*t211*t99-1.36143060036963
     3           36d-6*t105*t106*t211*t461-1.3614306003696336d-6*t100*t1
     4           03*t104*t211*t461-3.4035765009240837d-7*t104*t108*t211*
     5           t241-3.4035765009240837d-7*t100*t107*t211*t241+2.232102
     6           2677440003d-4*t104*t105*t211*t241+2.2321022677440003d-4
     7           *t103*t104*t211*t241+1.1160511338720001d-4*t100*t103*t2
     8           11*t241+3.72017044624d-5*t108*t126*t211+7.44034089248d-
     9           5*t107*t126*t211-2.439728d-2*t103*t126*t211)+1.86008522
     :           312d-5*t126*t216*t60*t96-6.09932d-3*t102*t416*t55*t96-6
     ;           .09932d-3*t102*t438*t53*t96-3.4035765009240837d-7*t109*
     <           t211*t241*t96+7.44034089248d-5*t126*t204*t212*t96+6.632
     =           8911936d-6*gammabb*t172*t215*t49*t60*t64-1.639930876381
     >           9376d-6*t343*t446*t49*t52*t64-2.65315647744d-5*t172*t21
     ?           2*t49*t51*t64+t215*t53*t61*(t630+t629)+1.0d+0*rhob*t49*
     @           t52*t58*(-6.559723505527751d-6*t211*t31*t587*t63-6.5597
     1           23505527751d-6*gammabb*t29*t435*t587*t62-1.639930876381
     2           9376d-6*t211*t34*t343*t62+6.367575545856d-4*t211*t31*t3
     3           43*t62+6.367575545856d-4*t211*t29*t343*t62-6.5597235055
     4           27751d-6*t25*t587*t59/rhob**1.2333333333333334d+1-1.639
     5           9308763819376d-6*gammabb*t33*t343*t435+3.183787772928d-
     6           4*gammabb*t29*t343*t435+1.2735151091712002d-3*gammabb*t
     7           25*t343*t435+1.061262590976d-4*t172*t211*t34+2.12252518
     8           1952d-4*t172*t211*t33-4.120704d-2*t172*t211*t29-4.12070
     9           4d-2*t172*t211*t25)+t215*t58*t610-1.030176d-2*t436*t49*
     :           t52*t55*t61+2.57544d-3*t203*t49*t51*t55*t61+1.28772d-3*
     ;           t213*t49*t51*t53*t61-1.030176d-2*t36*t415*t49*t52*t61-2
     <           .5d-1*t436*t49*t51*t58+2.122525181952d-4*t172*t203*t437
     =           *t49*t52+5.30631295488d-5*t172*t212*t213*t49*t52)*wght+
     >           Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = (1.0d+0*t96*t98*(-2.722861200739
     1           267d-6*t101*t440*t461*t99+4.4642045354880006d-4*t100*t2
     2           41*t440*t99-2.722861200739267d-6*t105*t106*t440*t461-2.
     3           722861200739267d-6*t100*t103*t104*t440*t461-6.807153001
     4           848167d-7*t104*t108*t241*t440-6.807153001848167d-7*t100
     5           *t107*t241*t440+8.928409070976001d-4*t104*t105*t241*t44
     6           0+2.2321022677440003d-4*t103*t104*t241*t440+4.464204535
     7           4880006d-4*t100*t103*t241*t440+1.488068178496d-4*t108*t
     8           126*t440+7.44034089248d-5*t107*t126*t440-4.879456d-2*t1
     9           05*t126*t440-4.879456d-2*t103*t126*t440)-3.04966d-3*t10
     :           2*t18*t443*t96-6.807153001848167d-7*t109*t241*t440*t96-
     ;           1.219864d-2*t102*t20*t432*t96+7.44034089248d-5*t126*t20
     <           1*t431*t96+7.44034089248d-5*t126*t206*t210*t96-3.279861
     =           752763875d-6*t14*t17*t220*t35*t631+t20*t209*t28*(t628+t
     >           627+t612)+1.0d+0*rhoa*t14*t17*t23*(-1.3119447011055504d
     ?           -5*t31*t32*t440*t452-1.3119447011055504d-5*gammaaa*t29*
     @           t30*t439*t452-1.3119447011055504d-5*t25*t26*t452/rhoa**
     1           1.1333333333333334d+1-3.279861752763875d-6*t220*t30*t34
     2           *t440+4.245050363904d-4*t112*t34*t440+2.122525181952d-4
     3           *t112*t33*t440+2.5470302183424004d-3*t220*t30*t31*t440-
     4           8.241408d-2*t112*t31*t440+6.367575545856d-4*t220*t29*t3
     5           0*t440-8.241408d-2*t112*t29*t440-3.279861752763875d-6*g
     6           ammaaa*t220*t33*t439+1.2735151091712002d-3*gammaaa*t220
     7           *t29*t439+1.2735151091712002d-3*gammaaa*t220*t25*t439)-
     8           2*t23*t392*t442+1.28772d-3*gammaaa*t14*t18*t28*t35*t442
     9           -5.15088d-3*t14*t17*t20*t28*t441-1.25d-1*t14*t16*t23*t4
     :           41-2.65315647744d-5*t112*t14*t16*t35*t431+2.12252518195
     ;           2d-4*t112*t14*t17*t207*t431+t209*t23*(2.5d-1*gammaaa*t1
     <           4*t430+2.5d-1*t14*t207)-2.060352d-2*t1*t14*t17*t28*t430
     =           +2.65315647744d-5*gammaaa*t112*t14*t206*t209*t35-1.2877
     >           2d-3*gammaaa*t14*t18*t207*t209*t28+2.57544d-3*t14*t16*t
     ?           20*t207*t28+2.122525181952d-4*t112*t14*t17*t200*t230)*w
     @           ght+Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = (1.0d+0*t96*t98*(-2.722861200739
     1           267d-6*t101*t206*t461*t55*t99+4.4642045354880006d-4*t10
     2           0*t206*t241*t55*t99-2.722861200739267d-6*t105*t106*t206
     3           *t461*t55-2.722861200739267d-6*t100*t103*t104*t206*t461
     4           *t55-6.807153001848167d-7*t104*t108*t206*t241*t55-6.807
     5           153001848167d-7*t100*t107*t206*t241*t55+8.9284090709760
     6           01d-4*t104*t105*t206*t241*t55+2.2321022677440003d-4*t10
     7           3*t104*t206*t241*t55+4.4642045354880006d-4*t100*t103*t2
     8           06*t241*t55+1.488068178496d-4*t108*t126*t206*t55+7.4403
     9           4089248d-5*t107*t126*t206*t55-4.879456d-2*t105*t126*t20
     :           6*t55-4.879456d-2*t103*t126*t206*t55)-6.09932d-3*t102*t
     ;           432*t55*t96-6.807153001848167d-7*t109*t206*t241*t55*t96
     <           +3.72017044624d-5*t126*t18*t210*t55*t96+7.44034089248d-
     =           5*t126*t20*t201*t55*t96-3.04966d-3*t102*t18*t444*t96-6.
     >           09932d-3*t102*t20*t433*t96+3.72017044624d-5*t126*t206*t
     ?           216*t96)*wght+Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = (1.0d+0*t96*t98*(-2.722861200739
     1           267d-6*t101*t18*t437*t461*t99+4.4642045354880006d-4*t10
     2           0*t18*t241*t437*t99-2.722861200739267d-6*t105*t106*t18*
     3           t437*t461-2.722861200739267d-6*t100*t103*t104*t18*t437*
     4           t461-6.807153001848167d-7*t104*t108*t18*t241*t437-6.807
     5           153001848167d-7*t100*t107*t18*t241*t437+8.9284090709760
     6           01d-4*t104*t105*t18*t241*t437+2.2321022677440003d-4*t10
     7           3*t104*t18*t241*t437+4.4642045354880006d-4*t100*t103*t1
     8           8*t241*t437+1.488068178496d-4*t108*t126*t18*t437+7.4403
     9           4089248d-5*t107*t126*t18*t437-4.879456d-2*t105*t126*t18
     :           *t437-4.879456d-2*t103*t126*t18*t437)-1.219864d-2*t102*
     ;           t433*t55*t96+7.44034089248d-5*t126*t18*t216*t55*t96-3.0
     <           4966d-3*t102*t18*t449*t96-6.807153001848167d-7*t109*t18
     =           *t241*t437*t96+7.44034089248d-5*t126*t201*t437*t96)*wgh
     >           t+Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = (1.0d+0*t96*t98*(-2.7228612007392
     1           67d-6*t101*t431*t461*t53*t99+4.4642045354880006d-4*t100
     2           *t241*t431*t53*t99-2.722861200739267d-6*t105*t106*t431*
     3           t461*t53-2.722861200739267d-6*t100*t103*t104*t431*t461*
     4           t53-6.807153001848167d-7*t104*t108*t241*t431*t53-6.8071
     5           53001848167d-7*t100*t107*t241*t431*t53+8.92840907097600
     6           1d-4*t104*t105*t241*t431*t53+2.2321022677440003d-4*t103
     7           *t104*t241*t431*t53+4.4642045354880006d-4*t100*t103*t24
     8           1*t431*t53+1.488068178496d-4*t108*t126*t431*t53+7.44034
     9           089248d-5*t107*t126*t431*t53-4.879456d-2*t105*t126*t431
     :           *t53-4.879456d-2*t103*t126*t431*t53)-3.04966d-3*t102*t4
     ;           43*t53*t96-6.807153001848167d-7*t109*t241*t431*t53*t96+
     <           7.44034089248d-5*t126*t20*t210*t53*t96-1.219864d-2*t102
     =           *t20*t434*t96+7.44034089248d-5*t126*t204*t431*t96)*wght
     >           +Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = (1.0d+0*t96*t98*(-2.7228612007392
     1           67d-6*t101*t20*t212*t461*t99+4.4642045354880006d-4*t100
     2           *t20*t212*t241*t99-2.722861200739267d-6*t105*t106*t20*t
     3           212*t461-2.722861200739267d-6*t100*t103*t104*t20*t212*t
     4           461-6.807153001848167d-7*t104*t108*t20*t212*t241-6.8071
     5           53001848167d-7*t100*t107*t20*t212*t241+8.92840907097600
     6           1d-4*t104*t105*t20*t212*t241+2.2321022677440003d-4*t103
     7           *t104*t20*t212*t241+4.4642045354880006d-4*t100*t103*t20
     8           *t212*t241+1.488068178496d-4*t108*t126*t20*t212+7.44034
     9           089248d-5*t107*t126*t20*t212-4.879456d-2*t105*t126*t20*
     :           t212-4.879456d-2*t103*t126*t20*t212)-6.09932d-3*t102*t4
     ;           34*t55*t96+7.44034089248d-5*t126*t20*t204*t55*t96-3.049
     <           66d-3*t102*t444*t53*t96+3.72017044624d-5*t126*t20*t216*
     =           t53*t96-6.09932d-3*t102*t20*t438*t96-6.807153001848167d
     >           -7*t109*t20*t212*t241*t96+3.72017044624d-5*t126*t210*t2
     ?           12*t96)*wght+Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = (1.0d+0*t96*t98*(-2.7228612007392
     1           67d-6*t101*t446*t461*t99+4.4642045354880006d-4*t100*t24
     2           1*t446*t99-2.722861200739267d-6*t105*t106*t446*t461-2.7
     3           22861200739267d-6*t100*t103*t104*t446*t461-6.8071530018
     4           48167d-7*t104*t108*t241*t446-6.807153001848167d-7*t100*
     5           t107*t241*t446+8.928409070976001d-4*t104*t105*t241*t446
     6           +2.2321022677440003d-4*t103*t104*t241*t446+4.4642045354
     7           880006d-4*t100*t103*t241*t446+1.488068178496d-4*t108*t1
     8           26*t446+7.44034089248d-5*t107*t126*t446-4.879456d-2*t10
     9           5*t126*t446-4.879456d-2*t103*t126*t446)-1.219864d-2*t10
     :           2*t438*t55*t96-3.04966d-3*t102*t449*t53*t96-6.807153001
     ;           848167d-7*t109*t241*t446*t96+7.44034089248d-5*t126*t204
     <           *t437*t96+7.44034089248d-5*t126*t212*t216*t96-3.2798617
     =           52763875d-6*t343*t49*t52*t632*t64+1.28772d-3*gammabb*t4
     >           48*t49*t53*t61*t64-2.65315647744d-5*t172*t437*t49*t51*t
     ?           64+2.65315647744d-5*gammabb*t172*t212*t215*t49*t64+t215
     @           *t55*t61*(t630+t629+t626)+1.0d+0*rhob*t49*t52*t58*(-1.3
     1           119447011055504d-5*t31*t446*t587*t63-1.3119447011055504
     2           d-5*gammabb*t29*t445*t587*t62-3.279861752763875d-6*t34*
     3           t343*t446*t62+2.5470302183424004d-3*t31*t343*t446*t62+6
     4           .367575545856d-4*t29*t343*t446*t62-1.3119447011055504d-
     5           5*t25*t587*t59/rhob**1.1333333333333334d+1+4.2450503639
     6           04d-4*t172*t34*t446+2.122525181952d-4*t172*t33*t446-8.2
     7           41408d-2*t172*t31*t446-8.241408d-2*t172*t29*t446-3.2798
     8           61752763875d-6*gammabb*t33*t343*t445+1.2735151091712002
     9           d-3*gammabb*t29*t343*t445+1.2735151091712002d-3*gammabb
     :           *t25*t343*t445)-5.15088d-3*t447*t49*t52*t55*t61+2.57544
     ;           d-3*t213*t49*t51*t55*t61-1.28772d-3*gammabb*t213*t215*t
     <           49*t53*t61-2.060352d-2*t36*t436*t49*t52*t61-1.25d-1*t44
     =           7*t49*t51*t58+t215*(2.5d-1*gammabb*t436*t49+2.5d-1*t213
     >           *t49)*t58-2*t403*t448*t58+2.122525181952d-4*t172*t213*t
     ?           437*t49*t52+2.122525181952d-4*t172*t203*t353*t49*t52)*w
     @           ght+Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = (7.5d-1*gammaaa*t14*t23*t35/taua*
     1           *4+1.0d+0*t96*t98*(-5.445722401478534d-6*t101*t461*t631
     2           *t99-5.445722401478534d-6*t105*t106*t461*t631-5.4457224
     3           01478534d-6*t100*t103*t104*t461*t631-1.3614306003696336
     4           d-6*t104*t108*t241*t631-1.3614306003696336d-6*t100*t107
     5           *t241*t631+2.678522721292801d-3*t104*t105*t241*t631+1.3
     6           392613606464004d-3*t100*t103*t241*t631+4.46420453548799
     7           94d-4*t108*t126*t631-2.9276736000000003d-1*t105*t126*t6
     8           31)-1.3614306003696336d-6*t109*t241*t631*t96-1.82979600
     9           00000002d-2*t102*t20*t443*t96+2.2321022677439997d-4*t12
     :           6*t210*t431*t96+1.0d+0*rhoa*t14*t17*t23*(-2.62388940221
     ;           1101d-5*gammaaa*t29*t30*t452*t633-6.55972350552775d-6*g
     <           ammaaa*t220*t33*t633+3.8205453275136003d-3*gammaaa*t220
     =           *t29*t633-2.623889402211101d-5*t31*t32*t452*t631-6.5597
     >           2350552775d-6*t220*t30*t34*t631+1.2735151091712002d-3*t
     ?           112*t34*t631+7.641090655027201d-3*t220*t30*t31*t631-4.9
     @           448448d-1*t112*t31*t631-2.623889402211101d-5*t25*t26*t4
     1           52/rhoa**1.0333333333333333d+1)+7.72632d-3*gammaaa*t14*
     2           t20*t28*t35*t442-7.5d-1*gammaaa*t14*t207*t23*t442-3.090
     3           528d-2*t1*t14*t17*t28*t441+3.75d-1*gammaaa*t14*t209*t23
     4           *t441+7.959469432320001d-5*gammaaa*t112*t14*t209*t35*t4
     5           31-6.55972350552775d-6*t14*t17*t220*t35/rhoa**4-7.72632
     6           d-3*gammaaa*t14*t20*t207*t209*t28+6.367575545856d-4*t11
     7           2*t14*t17*t207*t230)*wght+Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = (1.0d+0*t96*t98*(-5.4457224014785
     1           34d-6*t101*t431*t461*t55*t99-5.445722401478534d-6*t105*
     2           t106*t431*t461*t55-5.445722401478534d-6*t100*t103*t104*
     3           t431*t461*t55-1.3614306003696336d-6*t104*t108*t241*t431
     4           *t55-1.3614306003696336d-6*t100*t107*t241*t431*t55+2.67
     5           8522721292801d-3*t104*t105*t241*t431*t55+1.339261360646
     6           4004d-3*t100*t103*t241*t431*t55+4.4642045354879994d-4*t
     7           108*t126*t431*t55-2.9276736000000003d-1*t105*t126*t431*
     8           t55)-6.09932d-3*t102*t443*t55*t96-1.3614306003696336d-6
     9           *t109*t241*t431*t55*t96+1.488068178496d-4*t126*t20*t210
     :           *t55*t96-1.219864d-2*t102*t20*t444*t96+7.44034089248d-5
     ;           *t126*t216*t431*t96)*wght+Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = (1.0d+0*t96*t98*(-5.4457224014785
     1           34d-6*t101*t20*t437*t461*t99-5.445722401478534d-6*t105*
     2           t106*t20*t437*t461-5.445722401478534d-6*t100*t103*t104*
     3           t20*t437*t461-1.3614306003696336d-6*t104*t108*t20*t241*
     4           t437-1.3614306003696336d-6*t100*t107*t20*t241*t437+2.67
     5           8522721292801d-3*t104*t105*t20*t241*t437+1.339261360646
     6           4004d-3*t100*t103*t20*t241*t437+4.4642045354879994d-4*t
     7           108*t126*t20*t437-2.9276736000000003d-1*t105*t126*t20*t
     8           437)-1.219864d-2*t102*t444*t55*t96+1.488068178496d-4*t1
     9           26*t20*t216*t55*t96-6.09932d-3*t102*t20*t449*t96-1.3614
     :           306003696336d-6*t109*t20*t241*t437*t96+7.44034089248d-5
     ;           *t126*t210*t437*t96)*wght+Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = (7.5d-1*gammabb*t49*t58*t64/taub*
     1           *4+1.0d+0*t96*t98*(-5.445722401478534d-6*t101*t461*t632
     2           *t99-5.445722401478534d-6*t105*t106*t461*t632-5.4457224
     3           01478534d-6*t100*t103*t104*t461*t632-1.3614306003696336
     4           d-6*t104*t108*t241*t632-1.3614306003696336d-6*t100*t107
     5           *t241*t632+2.678522721292801d-3*t104*t105*t241*t632+1.3
     6           392613606464004d-3*t100*t103*t241*t632+4.46420453548799
     7           94d-4*t108*t126*t632-2.9276736000000003d-1*t105*t126*t6
     8           32)-1.3614306003696336d-6*t109*t241*t632*t96-1.82979600
     9           00000002d-2*t102*t449*t55*t96+2.2321022677439997d-4*t12
     :           6*t216*t437*t96+7.72632d-3*gammabb*t448*t49*t55*t61*t64
     ;           -6.55972350552775d-6*t343*t49*t52*t64/rhob**4+7.9594694
     <           32320001d-5*gammabb*t172*t215*t437*t49*t64+1.0d+0*rhob*
     =           t49*t52*t58*(-2.623889402211101d-5*gammabb*t29*t587*t62
     >           *t634-6.55972350552775d-6*gammabb*t33*t343*t634+3.82054
     ?           53275136003d-3*gammabb*t29*t343*t634-2.623889402211101d
     @           -5*t31*t587*t63*t632-6.55972350552775d-6*t34*t343*t62*t
     1           632+7.641090655027201d-3*t31*t343*t62*t632+1.2735151091
     2           712002d-3*t172*t34*t632-4.9448448d-1*t172*t31*t632-2.62
     3           3889402211101d-5*t25*t587*t59/rhob**1.0333333333333333d
     4           +1)-7.72632d-3*gammabb*t213*t215*t49*t55*t61-3.090528d-
     5           2*t36*t447*t49*t52*t61-7.5d-1*gammabb*t213*t448*t49*t58
     6           +3.75d-1*gammabb*t215*t447*t49*t58+6.367575545856d-4*t1
     7           72*t213*t353*t49*t52)*wght+Mmat3(iq,D3_GBB_TA_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = 1/rhob**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = 1/rhob**3.3333333333333337d+0
              t13 = param(9)
              t14 = param(8)
              t15 = param(11)
              t16 = 4.0d-50*t1*t15*t7*t9+t13*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t12*t7+t5+4.0d-50*t1*t14*t4
              t17 = 1/rhob**6.666666666666666d-1
              t18 = rhob**5.0d-1
              t19 = 1/t18
              t20 = 1/rhob**3.333333333333333d-1
              t21 = 1/rhob**1.6666666666666666d-1
              t22 = 1.1120374863094686d+1*t21+3.8447462374472113d+0*t20+
     1           1.644733775567609d+0*t19+2.4058712912881916d-1*t17
              t23 = 3.216395899738507d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.274696188700087d-1*t20+1.0d+0
              t26 = 5.982550435771079d+0*t21+2.2255694211506874d+0*t20+8
     1           .004286349993635d-1*t19+1.8970043257475583d-1*t17
              t27 = 1.6081979498692536d+1/t26+1.0d+0
              t28 = log(t27)
              t29 = 1.3256889990520176d-1*t20+1.0d+0
              t30 = -6.903522198342671d-18*t28*t29-3.1090699999999993d-2
     1           *t24*t25
              t31 = 1/rhoa**6.666666666666666d-1
              t32 = rhoa**5.0d-1
              t33 = 1/t32
              t34 = 1/rhoa**3.333333333333333d-1
              t35 = 1/rhoa**1.6666666666666666d-1
              t36 = 1.1120374863094686d+1*t35+3.8447462374472113d+0*t34+
     1           1.644733775567609d+0*t33+2.4058712912881916d-1*t31
              t37 = 3.216395899738507d+1/t36+1.0d+0
              t38 = log(t37)
              t39 = 1.274696188700087d-1*t34+1.0d+0
              t40 = 5.982550435771079d+0*t35+2.2255694211506874d+0*t34+8
     1           .004286349993635d-1*t33+1.8970043257475583d-1*t31
              t41 = 1.6081979498692536d+1/t40+1.0d+0
              t42 = log(t41)
              t43 = 1.3256889990520176d-1*t34+1.0d+0
              t44 = -6.903522198342671d-18*t42*t43-3.1090699999999993d-2
     1           *t38*t39
              t45 = 1/rhoa
              t46 = 1/taua
              t47 = 1.0d+0-1.25d-1*gammaaa*t45*t46
              t48 = 1/rhoa**2.6666666666666666d+0
              t49 = gammaaa*t48
              t50 = 1/rhoa**1.6666666666666669d+0
              t51 = 2.0d+0*t50*taua
              t52 = 5.15088d-3*(t51+t49-9.11559972d+0)+1.0d+0
              t53 = 1/t52
              t54 = gammaaa**2
              t55 = 1/rhoa**5.333333333333333d+0
              t56 = 1/t52**2
              t57 = t51-9.11559972d+0
              t58 = t57**2
              t59 = t56*t58*t6+gammaaa*t15*t48*t56*t57+t13*t53*t57+t11*t
     1           54*t55*t56+gammaaa*t14*t48*t53+t5
              t60 = rhob+rhoa
              t61 = 1/t60**3.333333333333333d-1
              t62 = 1.3256889990520176d-1*t61+1.0d+0
              t63 = rhoa-rhob
              t64 = t63**4
              t65 = 1/t60**4
              t66 = 1/t60
              t67 = 1.0d+0-t63*t66
              t68 = t63*t66+1.0d+0
              t69 = t68**1.3333333333333333d+0+t67**1.3333333333333333d+
     1           0-2.0d+0
              t70 = -1.923661050931536d+0*t64*t65*t69
              t71 = t70+1.0d+0
              t72 = 1/t60**6.666666666666666d-1
              t73 = t60**5.0d-1
              t74 = 1/t73
              t75 = 1/t60**1.6666666666666666d-1
              t76 = 5.982550435771079d+0*t75+8.004286349993635d-1*t74+1.
     1           8970043257475583d-1*t72+2.2255694211506874d+0*t61
              t77 = 1.6081979498692536d+1/t76+1.0d+0
              t78 = log(t77)
              t79 = -6.21814d-2*t62*t71*t78
              t80 = 6.901399211255825d-2*t61+1.0d+0
              t81 = t70+1.923661050931536d+0*t69
              t82 = 8.157414703487641d+0*t75+4.3009724712766434d-1*t74+1
     1           .9115125951273373d-1*t72+2.247591863577616d+0*t61
              t83 = 2.9608813203268075d+1/t82+1.0d+0
              t84 = log(t83)
              t85 = 1.9751631321680768d-2*t80*t81*t84
              t86 = 1.274696188700087d-1*t61+1.0d+0
              t87 = 1.1120374863094686d+1*t75+1.644733775567609d+0*t74+2
     1           .4058712912881916d-1*t72+3.8447462374472113d+0*t61
              t88 = 3.216395899738507d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = -5.980796863619711d-2*t64*t65*t69*t86*t89
              t91 = t60*(t90+t85+t79)-rhoa*t44-rhob*t30
              t92 = 3.04966d-3*(t51+t49+t2-1.823119944d+1)+1.0d+0
              t93 = 1/t92
              t94 = param(4)
              t95 = t49+4.0d-50*t1
              t96 = t95**2
              t97 = 1/t92**2
              t98 = param(5)
              t99 = t8+t51-1.823119944d+1
              t100 = param(6)
              t101 = t99**2
              t102 = param(2)
              t103 = param(3)
              t104 = t95*t97*t98*t99+t103*t93*t99+t94*t96*t97+t100*t101*
     1           t97+t102*t93*t95+param(1)
              t105 = 1/rhoa**3.6666666666666664d+0
              t106 = -3.3333333333333337d+0*t48*taua-2.6666666666666666d
     1           +0*gammaaa*t105
              t107 = 1/t52**3
              t108 = 1/rhoa**6.333333333333333d+0
              t109 = -6.666666666666667d+0*t48*t56*t57*t6*taua-3.3333333
     1           333333337d+0*gammaaa*t15*t55*t56*taua-3.333333333333333
     2           7d+0*t13*t48*t53*taua-1.030176d-2*t106*t107*t58*t6-2.66
     3           66666666666666d+0*gammaaa*t105*t15*t56*t57-5.15088d-3*t
     4           106*t13*t56*t57-1.030176d-2*gammaaa*t106*t107*t15*t48*t
     5           57-5.333333333333333d+0*t108*t11*t54*t56-5.15088d-3*gam
     6           maaa*t106*t14*t48*t56-1.030176d-2*t106*t107*t11*t54*t55
     7           -2.6666666666666666d+0*gammaaa*t105*t14*t53
              t110 = 1/t41
              t111 = 1/t32**3
              t112 = 1/rhoa**1.3333333333333333d+0
              t113 = 1/rhoa**1.1666666666666667d+0
              t114 = -1.264669550498372d-1*t50-9.970917392951799d-1*t113
     1           -7.418564737168958d-1*t112-4.002143174996817d-1*t111
              t115 = 1/t40**2
              t116 = 1/t37
              t117 = -1.6039141941921276d-1*t50-1.8533958105157808d+0*t1
     1           13-1.2815820791490704d+0*t112-8.223668877838045d-1*t111
              t118 = 1/t36**2
              t119 = 1.1102230246251565d-16*t110*t114*t115*t43+3.0506411
     1           443514264d-19*t112*t42+1.0d+0*t116*t117*t118*t39+1.3210
     2           398931339265d-3*t112*t38
              t120 = 1.0d+0*t44*t47*t59+1.0d+0*rhoa*t119*t47*t59+1.0d+0*
     1           rhoa*t109*t44*t47
              t121 = 1/t92**3
              t122 = -6.666666666666667d+0*t100*t48*t97*t99*taua-3.33333
     1           33333333337d+0*t48*t95*t97*t98*taua-3.3333333333333337d
     2           +0*t103*t48*t93*taua-2.6666666666666666d+0*gammaaa*t105
     3           *t97*t98*t99-6.09932d-3*t106*t121*t95*t98*t99-3.04966d-
     4           3*t103*t106*t97*t99-5.333333333333333d+0*gammaaa*t105*t
     5           94*t95*t97-3.04966d-3*t102*t106*t95*t97-6.09932d-3*t106
     6           *t121*t94*t96-2.6666666666666666d+0*gammaaa*t102*t105*t
     7           93-6.09932d-3*t100*t101*t106*t121
              t123 = 1/t60**1.6666666666666669d+0
              t124 = 1/t73**3
              t125 = 1/t60**1.3333333333333333d+0
              t126 = 1/t60**1.1666666666666667d+0
              t127 = -9.970917392951799d-1*t126-7.418564737168958d-1*t12
     1           5-4.002143174996817d-1*t124-1.264669550498372d-1*t123
              t128 = 1/t76**2
              t129 = 1/t77
              t130 = 1.0d+0*t127*t128*t129*t62*t71
              t131 = -1.3595691172479402d+0*t126-7.491972878592053d-1*t1
     1           25-2.1504862356383217d-1*t124-1.2743417300848914d-1*t12
     2           3
              t132 = 1/t82**2
              t133 = 1/t83
              t134 = -5.848223622634647d-1*t131*t132*t133*t80*t81
              t135 = -1.8533958105157808d+0*t126-1.2815820791490704d+0*t
     1           125-8.223668877838045d-1*t124-1.6039141941921276d-1*t12
     2           3
              t136 = 1/t87**2
              t137 = 1/t88
              t138 = 1.923661050931536d+0*t135*t136*t137*t64*t65*t69*t86
              t139 = 1/t60**2
              t140 = t139*t63
              t141 = -t66
              t142 = t141+t140
              t143 = t67**3.333333333333333d-1
              t144 = -t139*t63
              t145 = t66+t144
              t146 = t68**3.333333333333333d-1
              t147 = 1.3333333333333333d+0*t145*t146+1.3333333333333333d
     1           +0*t142*t143
              t148 = -1.923661050931536d+0*t147*t64*t65
              t149 = 1/t60**5
              t150 = 7.694644203726144d+0*t149*t64*t69
              t151 = t63**3
              t152 = -7.694644203726144d+0*t151*t65*t69
              t153 = t152+t150+t148
              t154 = -6.21814d-2*t153*t62*t78
              t155 = 2.747773264188437d-3*t125*t71*t78
              t156 = t152+t150+t148+1.923661050931536d+0*t147
              t157 = 1.9751631321680768d-2*t156*t80*t84
              t158 = -4.5437964274821163d-4*t125*t81*t84
              t159 = -5.980796863619711d-2*t147*t64*t65*t86*t89
              t160 = 1/t60**5.333333333333333d+0
              t161 = 2.541232989148493d-3*t160*t64*t69*t89
              t162 = 2.3923187454478842d-1*t149*t64*t69*t86*t89
              t163 = t90+t60*(-2.3923187454478842d-1*t151*t65*t69*t86*t8
     1           9+t162+t161+t159+t158+t157+t155+t154+t138+t134+t130)+t8
     2           5+t79+6.903522198342671d-18*t42*t43+3.1090699999999993d
     3           -2*t38*t39-rhoa*t119
              t164 = 1.0d+0*t122*t91+1.0d+0*t104*t163
              t165 = 1/t27
              t166 = 1/t18**3
              t167 = 1/rhob**1.3333333333333333d+0
              t168 = 1/rhob**1.1666666666666667d+0
              t169 = -9.970917392951799d-1*t168-7.418564737168958d-1*t16
     1           7-4.002143174996817d-1*t166-1.264669550498372d-1*t1
              t170 = 1/t26**2
              t171 = 1/t23
              t172 = -1.8533958105157808d+0*t168-1.2815820791490704d+0*t
     1           167-8.223668877838045d-1*t166-1.6039141941921276d-1*t1
              t173 = 1/t22**2
              t174 = 1.1102230246251565d-16*t165*t169*t170*t29+3.0506411
     1           443514264d-19*t167*t28+1.0d+0*t171*t172*t173*t25+1.3210
     2           398931339265d-3*t167*t24
              t175 = 1/t3**3
              t176 = 1/rhob**4.333333333333333d+0
              t177 = 1/rhob**2.6666666666666666d+0
              t178 = -6.666666666666666d-50*t177*t6*t7*t9-6.666666666666
     1           666d-50*t15*t177*t7*t9+5.15088d-52*t13*t177*t7*t9+4.120
     2           7039999999995d-101*t15*t175*t176*t9-1.3333333333333333d
     3           -99*t15*t176*t7+2.0603519999999997d-101*t14*t176*t7-5.3
     4           33333333333334d-99*t11*t176*t7+1.030176d-51*t10*t175*t1
     5           77*t6-6.666666666666666d-50*t14*t177*t4-3.3333333333333
     6           33d-50*t13*t177*t4+1.6482816d-150*t11*t175/rhob**6
              t179 = 5.0d-1*rhob*t178*t30+5.0d-1*t16*t30+5.0d-1*rhob*t16
     1           *t174
              t180 = -6.666666666666666d-50*t177*t97*t98*t99+6.09932d-52
     1           *t121*t177*t95*t98*t99+3.04966d-52*t103*t177*t97*t99-6.
     2           666666666666666d-50*t100*t177*t97*t99-3.333333333333333
     3           d-50*t177*t95*t97*t98-1.3333333333333333d-49*t177*t94*t
     4           95*t97+3.04966d-52*t102*t177*t95*t97+6.09932d-52*t121*t
     5           177*t94*t96-3.333333333333333d-50*t103*t177*t93-6.66666
     6           6666666666d-50*t102*t177*t93+6.09932d-52*t100*t101*t121
     7           *t177
              t181 = t66+t140
              t182 = t144+t141
              t183 = 1.3333333333333333d+0*t146*t182+1.3333333333333333d
     1           +0*t143*t181
              t184 = -1.923661050931536d+0*t183*t64*t65
              t185 = 7.694644203726144d+0*t151*t65*t69
              t186 = t185+t184+t150
              t187 = -6.21814d-2*t186*t62*t78
              t188 = t185+t184+1.923661050931536d+0*t183+t150
              t189 = 1.9751631321680768d-2*t188*t80*t84
              t190 = -5.980796863619711d-2*t183*t64*t65*t86*t89
              t191 = t90+t60*(2.3923187454478842d-1*t151*t65*t69*t86*t89
     1           +t190+t189+t187+t162+t161+t158+t155+t138+t134+t130)+t85
     2           +t79+6.903522198342671d-18*t28*t29+3.1090699999999993d-
     3           2*t24*t25-rhob*t174
              t192 = 1.0d+0*t180*t91+1.0d+0*t104*t191
              t193 = 1/rhoa**8
              t194 = -1.030176d-2*t107*t48*t58*t6+t15*t48*t56*t57-5.1508
     1           8d-3*t13*t48*t56*t57-1.030176d-2*gammaaa*t107*t15*t55*t
     2           57-5.15088d-3*gammaaa*t14*t55*t56+2*gammaaa*t11*t55*t56
     3           -1.030176d-2*t107*t11*t193*t54+t14*t48*t53
              t195 = t48*t97*t98*t99-6.09932d-3*t121*t48*t95*t98*t99-3.0
     1           4966d-3*t103*t48*t97*t99+2*t48*t94*t95*t97-3.04966d-3*t
     2           102*t48*t95*t97-6.09932d-3*t121*t48*t94*t96+t102*t48*t9
     3           3-6.09932d-3*t100*t101*t121*t48
              t196 = 1/rhoa**7
              t197 = 1/rhoa**4.333333333333333d+0
              t198 = -2.060352d-2*t107*t50*t58*t6+4.0d+0*t50*t56*t57*t6-
     1           1.030176d-2*t13*t50*t56*t57-2.060352d-2*gammaaa*t107*t1
     2           5*t197*t57+2.0d+0*gammaaa*t15*t197*t56-1.030176d-2*gamm
     3           aaa*t14*t197*t56-2.060352d-2*t107*t11*t196*t54+2.0d+0*t
     4           13*t50*t53
              t199 = taua**2
              t200 = 1/t199
              t201 = -1.219864d-2*t121*t50*t95*t98*t99-6.09932d-3*t103*t
     1           50*t97*t99+4.0d+0*t100*t50*t97*t99+2.0d+0*t50*t95*t97*t
     2           98-6.09932d-3*t102*t50*t95*t97-1.219864d-2*t121*t50*t94
     3           *t96+2.0d+0*t103*t50*t93-1.219864d-2*t100*t101*t121*t50
              t202 = t106**2
              t203 = 1/rhoa**2
              t204 = 1.25d-1*gammaaa*t119*t59+1.25d-1*gammaaa*t109*t44
              t205 = 1/t52**4
              t206 = 1/rhoa**4.666666666666667d+0
              t207 = 8.88888888888889d+0*t105*taua+9.777777777777779d+0*
     1           gammaaa*t206
              t208 = 1/rhoa**7.333333333333333d+0
              t209 = 1.7777777777777778d+1*t105*t56*t57*t6*taua+1.373568
     1           d-1*t106*t107*t48*t57*t6*taua+3.4339200000000003d-2*t10
     2           6*t13*t48*t56*taua+2.6666666666666666d+1*gammaaa*t108*t
     3           15*t56*taua+6.867840000000001d-2*gammaaa*t106*t107*t15*
     4           t55*taua+8.88888888888889d+0*t105*t13*t53*taua-1.030176
     5           d-2*t107*t207*t58*t6+1.591893886464d-4*t202*t205*t58*t6
     6           +2.2222222222222224d+1*t199*t55*t56*t6-5.15088d-3*t13*t
     7           207*t56*t57+9.777777777777779d+0*gammaaa*t15*t206*t56*t
     8           57-1.030176d-2*gammaaa*t107*t15*t207*t48*t57+1.59189388
     9           6464d-4*gammaaa*t15*t202*t205*t48*t57+5.30631295488d-5*
     :           t107*t13*t202*t57+5.494272d-2*gammaaa*t105*t106*t107*t1
     ;           5*t57+3.377777777777778d+1*t11*t208*t54*t56-5.15088d-3*
     <           gammaaa*t14*t207*t48*t56+2.747136d-2*gammaaa*t105*t106*
     =           t14*t56-1.030176d-2*t107*t11*t207*t54*t55+1.59189388646
     >           4d-4*t11*t202*t205*t54*t55+1.0988544d-1*t106*t107*t108*
     ?           t11*t54+9.777777777777779d+0*gammaaa*t14*t206*t53+5.306
     @           31295488d-5*gammaaa*t107*t14*t202*t48
              t210 = 1/t41**2
              t211 = t114**2
              t212 = 1/t40**4
              t213 = 1/t40**3
              t214 = 1/t32**5
              t215 = 1/rhoa**2.3333333333333334d+0
              t216 = 1/rhoa**2.1666666666666665d+0
              t217 = 2.1077825841639536d-1*t48+1.1632736958443765d+0*t21
     1           6+9.89141964955861d-1*t215+6.003214762495226d-1*t214
              t218 = 1/t37**2
              t219 = t117**2
              t220 = 1/t36**4
              t221 = 1/t36**3
              t222 = 2.673190323653546d-1*t48+2.1622951122684114d+0*t216
     1           +1.7087761055320938d+0*t215+1.2335503316757068d+0*t214
              t223 = 1.1102230246251565d-16*t110*t115*t217*t43-2.2204460
     1           49250313d-16*t110*t211*t213*t43+1.7854583920998188d-15*
     2           t210*t211*t212*t43-4.0675215258019015d-19*t215*t42+1.0d
     3           +0*t116*t118*t222*t39-2.0d+0*t116*t219*t221*t39+3.21639
     4           5899738507d+1*t218*t219*t220*t39-1.7613865241785684d-3*
     5           t215*t38-8.497974591333913d-2*t112*t116*t117*t118-9.812
     6           069668265515d-18*t110*t112*t114*t115
              t224 = 1.0d+0*rhoa*t223*t47*t59+2.0d+0*t119*t47*t59+1.25d-
     1           1*gammaaa*t119*t45*t46*t59+1.25d-1*gammaaa*t203*t44*t46
     2           *t59+1.0d+0*rhoa*t209*t44*t47+2.0d+0*t109*t44*t47+2.0d+
     3           0*rhoa*t109*t119*t47+1.25d-1*gammaaa*t109*t44*t45*t46
              t225 = -5.15088d-3*rhoa*t207*t44*t47*t59-5.15088d-3*t106*t
     1           44*t47*t59-5.15088d-3*rhoa*t106*t119*t47*t59-5.15088d-3
     2           *rhoa*t106*t109*t44*t47-5.15088d-3*t106*t120
              t226 = 1/t92**4
              t227 = 1.7777777777777778d+1*t100*t105*t97*t99*taua+8.1324
     1           26666666668d-2*t100*t106*t121*t48*t99*taua+8.8888888888
     2           8889d+0*t105*t95*t97*t98*taua+1.7777777777777778d+1*gam
     3           maaa*t108*t97*t98*taua+4.066213333333334d-2*t106*t121*t
     4           48*t95*t98*taua+2.033106666666667d-2*t103*t106*t48*t97*
     5           taua+8.88888888888889d+0*t103*t105*t93*taua+9.777777777
     6           777779d+0*gammaaa*t206*t97*t98*t99+5.580255669360001d-5
     7           *t202*t226*t95*t98*t99-6.09932d-3*t121*t207*t95*t98*t99
     8           +3.2529706666666663d-2*gammaaa*t105*t106*t121*t98*t99-3
     9           .04966d-3*t103*t207*t97*t99+1.86008522312d-5*t103*t121*
     :           t202*t99+1.9555555555555557d+1*gammaaa*t206*t94*t95*t97
     ;           -3.04966d-3*t102*t207*t95*t97+1.4222222222222222d+1*t20
     <           8*t54*t94*t97+2.2222222222222224d+1*t100*t199*t55*t97+1
     =           .6264853333333332d-2*gammaaa*t102*t105*t106*t97+5.58025
     >           5669360001d-5*t202*t226*t94*t96-6.09932d-3*t121*t207*t9
     ?           4*t96+6.505941333333333d-2*gammaaa*t105*t106*t121*t94*t
     @           95+1.86008522312d-5*t102*t121*t202*t95+9.77777777777777
     1           9d+0*gammaaa*t102*t206*t93+5.580255669360001d-5*t100*t1
     2           01*t202*t226-6.09932d-3*t100*t101*t121*t207
              t228 = 2.0d+0*t127*t128*t129*t62*t71
              t229 = -1.1696447245269295d+0*t131*t132*t133*t80*t81
              t230 = 3.847322101863072d+0*t135*t136*t137*t64*t65*t69*t86
              t231 = 5.495546528376875d-3*t125*t71*t78
              t232 = -9.087592854964233d-4*t125*t81*t84
              t233 = 5.082465978296986d-3*t160*t64*t69*t89
              t234 = 4.7846374908957684d-1*t149*t64*t69*t86*t89
              t235 = t127**2
              t236 = 1/t76**4
              t237 = 1/t77**2
              t238 = 1.6081979498692536d+1*t235*t236*t237*t62*t71
              t239 = 2.0d+0*t127*t128*t129*t153*t62
              t240 = 1/t76**3
              t241 = -2.0d+0*t129*t235*t240*t62*t71
              t242 = -8.837926660346784d-2*t125*t127*t128*t129*t71
              t243 = 1/t60**2.6666666666666666d+0
              t244 = 1/t73**5
              t245 = 1/t60**2.3333333333333334d+0
              t246 = 1/t60**2.1666666666666665d+0
              t247 = 1.1632736958443765d+0*t246+9.89141964955861d-1*t245
     1           +6.003214762495226d-1*t244+2.1077825841639536d-1*t243
              t248 = 1.0d+0*t128*t129*t247*t62*t71
              t249 = t131**2
              t250 = 1/t82**4
              t251 = 1/t83**2
              t252 = -1.73158960813529d+1*t249*t250*t251*t80*t81
              t253 = -1.1696447245269295d+0*t131*t132*t133*t156*t80
              t254 = 1/t82**3
              t255 = 1.1696447245269295d+0*t133*t249*t254*t80*t81
              t256 = 2.690728393099896d-2*t125*t131*t132*t133*t81
              t257 = 1.5861639701225969d+0*t246+9.98929717145607d-1*t245
     1           +3.2257293534574827d-1*t244+2.1239028834748191d-1*t243
              t258 = -5.848223622634647d-1*t132*t133*t257*t80*t81
              t259 = t135**2
              t260 = 1/t87**4
              t261 = 1/t88**2
              t262 = 6.187255516702861d+1*t259*t260*t261*t64*t65*t69*t86
              t263 = 3.847322101863072d+0*t135*t136*t137*t147*t64*t65*t8
     1           6
              t264 = 1/t87**3
              t265 = -3.847322101863072d+0*t137*t259*t264*t64*t65*t69*t8
     1           6
              t266 = -1.6347222733154887d-1*t135*t136*t137*t160*t64*t69
              t267 = 2.1622951122684114d+0*t246+1.7087761055320938d+0*t2
     1           45+1.2335503316757068d+0*t244+2.673190323653546d-1*t243
              t268 = 1.923661050931536d+0*t136*t137*t267*t64*t65*t69*t86
              t269 = -1.538928840745229d+1*t135*t136*t137*t149*t64*t69*t
     1           86
              t270 = 1.538928840745229d+1*t135*t136*t137*t151*t65*t69*t8
     1           6
              t271 = t142**2
              t272 = 1/t67**6.666666666666666d-1
              t273 = 1/t60**3
              t274 = -2*t273*t63
              t275 = 2*t139
              t276 = t275+t274
              t277 = t145**2
              t278 = 1/t68**6.666666666666666d-1
              t279 = 2*t273*t63
              t280 = -2*t139
              t281 = t280+t279
              t282 = 1.3333333333333333d+0*t146*t281+4.444444444444444d-
     1           1*t277*t278+1.3333333333333333d+0*t143*t276+4.444444444
     2           444444d-1*t271*t272
              t283 = -1.923661050931536d+0*t282*t64*t65
              t284 = 1.5389288407452287d+1*t147*t149*t64
              t285 = -1.5389288407452287d+1*t147*t151*t65
              t286 = 1/t60**6
              t287 = -3.8473221018630716d+1*t286*t64*t69
              t288 = 6.155715362980915d+1*t149*t151*t69
              t289 = t63**2
              t290 = -2.3083932611178434d+1*t289*t65*t69
              t291 = t290+t288+t287+t285+t284+t283
              t292 = -6.21814d-2*t291*t62*t78
              t293 = 5.495546528376875d-3*t125*t153*t78
              t294 = -3.663697685584583d-3*t245*t71*t78
              t295 = t290+t288+t287+t285+t284+t283+1.923661050931536d+0*
     1           t282
              t296 = 1.9751631321680768d-2*t295*t80*t84
              t297 = -9.087592854964233d-4*t125*t156*t84
              t298 = 6.058395236642822d-4*t245*t81*t84
              t299 = -5.980796863619711d-2*t282*t64*t65*t86*t89
              t300 = 5.082465978296986d-3*t147*t160*t64*t89
              t301 = 4.7846374908957684d-1*t147*t149*t64*t86*t89
              t302 = 1/t60**6.333333333333333d+0
              t303 = -2.3718174565385935d-2*t302*t64*t69*t89
              t304 = 2.0329863913187946d-2*t151*t160*t69*t89
              t305 = -1.1961593727239421d+0*t286*t64*t69*t86*t89
              t306 = 1.9138549963583074d+0*t149*t151*t69*t86*t89
              t307 = -7.176956236343652d-1*t289*t65*t69*t86*t89
              t308 = t60*(-4.7846374908957684d-1*t147*t151*t65*t86*t89+t
     1           307+t306+t305+t304+t303+t301+t300+t299+t298+t297+t296+t
     2           294+t293+t292+t270+t269+t268+t266+t265+t263+t262+t258+t
     3           256+t255+t253+t252+t248+t242+t241+t239+t238)-4.78463749
     4           08957684d-1*t151*t65*t69*t86*t89-1.1961593727239421d-1*
     5           t147*t64*t65*t86*t89+3.9503262643361536d-2*t156*t80*t84
     6           -1.243628d-1*t153*t62*t78-2.220446049250313d-16*t110*t1
     7           14*t115*t43-6.101282288702853d-19*t112*t42-2.0d+0*t116*
     8           t117*t118*t39-2.642079786267853d-3*t112*t38+t234+t233+t
     9           232+t231+t230+t229+t228-rhoa*t223
              t309 = 1.0d+0*t227*t91+1.0d+0*t104*t308+2.0d+0*t122*t163
              t310 = -3.04966d-3*t104*t207*t91-3.04966d-3*t106*t122*t91-
     1           3.04966d-3*t106*t164-3.04966d-3*t104*t106*t163
              t311 = -4.066213333333334d-51*t100*t121*t177*t48*t99*taua+
     1           2.222222222222222d-49*t177*t48*t97*t98*taua-2.033106666
     2           666667d-51*t121*t177*t48*t95*t98*taua-1.016553333333333
     3           5d-51*t103*t177*t48*t97*taua+2.222222222222222d-49*t100
     4           *t177*t48*t97*taua-5.58025566936d-54*t106*t177*t226*t95
     5           *t98*t99+4.0662133333333333d-52*t106*t121*t177*t98*t99-
     6           1.6264853333333332d-51*gammaaa*t105*t121*t177*t98*t99-1
     7           .86008522312d-54*t103*t106*t121*t177*t99+4.066213333333
     8           3333d-52*t100*t106*t121*t177*t99+8.888888888888888d-50*
     9           gammaaa*t105*t177*t97*t98+2.0331066666666667d-52*t106*t
     :           121*t177*t95*t98+3.555555555555555d-49*gammaaa*t105*t17
     ;           7*t94*t97+1.0165533333333333d-52*t103*t106*t177*t97+2.0
     <           331066666666667d-52*t102*t106*t177*t97-8.13242666666666
     =           6d-52*gammaaa*t102*t105*t177*t97-5.58025566936d-54*t106
     >           *t177*t226*t94*t96+8.132426666666667d-52*t106*t121*t177
     ?           *t94*t95-3.2529706666666663d-51*gammaaa*t105*t121*t177*
     @           t94*t95-1.86008522312d-54*t102*t106*t121*t177*t95-5.580
     1           25566936d-54*t100*t101*t106*t177*t226
              t312 = 2.6666666666666666d+0*t146*t273*t63-2.6666666666666
     1           666d+0*t143*t273*t63+4.444444444444444d-1*t145*t182*t27
     2           8+4.444444444444444d-1*t142*t181*t272
              t313 = -1.923661050931536d+0*t312*t64*t65
              t314 = 7.694644203726144d+0*t149*t183*t64
              t315 = -7.694644203726144d+0*t151*t183*t65
              t316 = 7.694644203726144d+0*t147*t149*t64
              t317 = 7.694644203726144d+0*t147*t151*t65
              t318 = 2.3083932611178434d+1*t289*t65*t69
              t319 = t318+t317+t316+t315+t314+t313+t287
              t320 = t318+t317+t316+t315+t314+t313+1.923661050931536d+0*
     1           t312+t287
              t321 = 7.176956236343652d-1*t289*t65*t69*t86*t89
              t322 = t60*(-5.980796863619711d-2*t312*t64*t65*t86*t89-2.3
     1           923187454478842d-1*t151*t183*t65*t86*t89+2.392318745447
     2           8842d-1*t147*t151*t65*t86*t89+2.3923187454478842d-1*t14
     3           9*t183*t64*t86*t89+2.3923187454478842d-1*t147*t149*t64*
     4           t86*t89+2.541232989148493d-3*t160*t183*t64*t89+2.541232
     5           989148493d-3*t147*t160*t64*t89+1.923661050931536d+0*t13
     6           5*t136*t137*t183*t64*t65*t86+1.923661050931536d+0*t135*
     7           t136*t137*t147*t64*t65*t86+1.9751631321680768d-2*t320*t
     8           80*t84-4.5437964274821163d-4*t125*t188*t84-4.5437964274
     9           821163d-4*t125*t156*t84-5.848223622634647d-1*t131*t132*
     :           t133*t188*t80-5.848223622634647d-1*t131*t132*t133*t156*
     ;           t80-6.21814d-2*t319*t62*t78+2.747773264188437d-3*t125*t
     <           186*t78+2.747773264188437d-3*t125*t153*t78+1.0d+0*t127*
     =           t128*t129*t186*t62+1.0d+0*t127*t128*t129*t153*t62+t321+
     >           t305+t303+t298+t294+t269+t268+t266+t265+t262+t258+t256+
     ?           t255+t252+t248+t242+t241+t238)+t234+t233+t232+t231+t230
     @           +t229+t228+t190+t189+t187+t159+t157+t154
              t323 = 1.0d+0*t311*t91+1.0d+0*t104*t322+1.0d+0*t122*t191+1
     1           .0d+0*t163*t180
              t324 = -3.04966d-3*t106*t180*t91-3.04966d-3*t104*t106*t191
              t325 = 2.57544d-52*t178*t30+2.57544d-52*t16*t174
              t326 = 1/t27**2
              t327 = t169**2
              t328 = 1/t26**4
              t329 = 1/t26**3
              t330 = 1/t18**5
              t331 = 1/rhob**2.3333333333333334d+0
              t332 = 1/rhob**2.1666666666666665d+0
              t333 = 1.1632736958443765d+0*t332+9.89141964955861d-1*t331
     1           +6.003214762495226d-1*t330+2.1077825841639536d-1*t177
              t334 = 1/t23**2
              t335 = t172**2
              t336 = 1/t22**4
              t337 = 1/t22**3
              t338 = 2.1622951122684114d+0*t332+1.7087761055320938d+0*t3
     1           31+1.2335503316757068d+0*t330+2.673190323653546d-1*t177
              t339 = 1.0d+0*t171*t173*t25*t338-2.0d+0*t171*t25*t335*t337
     1           +3.216395899738507d+1*t25*t334*t335*t336+1.110223024625
     2           1565d-16*t165*t170*t29*t333-4.0675215258019015d-19*t28*
     3           t331-1.7613865241785684d-3*t24*t331-2.220446049250313d-
     4           16*t165*t29*t327*t329+1.7854583920998188d-15*t29*t326*t
     5           327*t328-8.497974591333913d-2*t167*t171*t172*t173-9.812
     6           069668265515d-18*t165*t167*t169*t170
              t340 = 1/t3**4
              t341 = 1/rhob**7
              t342 = 1/rhob**5.333333333333333d+0
              t343 = 1/rhob**3.6666666666666664d+0
              t344 = 1.7777777777777776d-49*t343*t6*t7*t9+1.777777777777
     1           7776d-49*t15*t343*t7*t9-1.373568d-51*t13*t343*t7*t9-1.3
     2           73568d-100*t175*t342*t6*t9-2.4724223999999997d-100*t15*
     3           t175*t342*t9+5.306312954879999d-103*t13*t175*t342*t9+6.
     4           367575545855999d-152*t15*t340*t341*t9+2.222222222222222
     5           d-99*t342*t6*t7+8.0d-99*t15*t342*t7-1.2362111999999999d
     6           -100*t14*t342*t7-3.43392d-101*t13*t342*t7+2.31111111111
     7           11113d-98*t11*t342*t7-2.747136d-51*t10*t175*t343*t6+1.5
     8           918938864639998d-102*t10*t340*t342*t6+1.777777777777777
     9           6d-49*t14*t343*t4+8.888888888888888d-50*t13*t343*t4-2.7
     :           471359999999995d-150*t15*t175*t341+2.1225251819519997d-
     ;           152*t14*t175*t341-1.53839616d-149*t11*t175*t341+2.54703
     <           02183424d-201*t11*t340/rhob**8.666666666666666d+0
              t345 = 5.0d-1*rhob*t30*t344+5.0d-1*rhob*t16*t339+1.0d+0*t1
     1           78*t30+1.0d+0*rhob*t174*t178+1.0d+0*t16*t174
              t346 = 5.15088d-52*t179-4.2923999999999995d-52*t16*t30
              t347 = 1.7777777777777776d-49*t343*t97*t98*t99-1.626485333
     1           3333332d-51*t121*t343*t95*t98*t99+5.580255669359999d-10
     2           3*t226*t342*t95*t98*t99-8.132426666666667d-101*t121*t34
     3           2*t98*t99-8.132426666666666d-52*t103*t343*t97*t99+1.777
     4           7777777777776d-49*t100*t343*t97*t99+1.86008522312d-103*
     5           t103*t121*t342*t99-8.132426666666667d-101*t100*t121*t34
     6           2*t99+8.888888888888888d-50*t343*t95*t97*t98+4.44444444
     7           4444444d-99*t342*t97*t98-4.0662133333333333d-101*t121*t
     8           342*t95*t98+3.555555555555555d-49*t343*t94*t95*t97-8.13
     9           2426666666666d-52*t102*t343*t95*t97+8.888888888888888d-
     :           99*t342*t94*t97-2.0331066666666667d-101*t103*t342*t97-4
     ;           .0662133333333333d-101*t102*t342*t97+2.222222222222222d
     <           -99*t100*t342*t97-1.6264853333333332d-51*t121*t343*t94*
     =           t96+5.580255669359999d-103*t226*t342*t94*t96-1.62648533
     >           33333334d-100*t121*t342*t94*t95+1.86008522312d-103*t102
     ?           *t121*t342*t95+8.888888888888888d-50*t103*t343*t93+1.77
     @           77777777777776d-49*t102*t343*t93-1.6264853333333332d-51
     1           *t100*t101*t121*t343+5.580255669359999d-103*t100*t101*t
     2           226*t342
              t348 = 2.0d+0*t127*t128*t129*t186*t62
              t349 = -1.1696447245269295d+0*t131*t132*t133*t188*t80
              t350 = 3.847322101863072d+0*t135*t136*t137*t183*t64*t65*t8
     1           6
              t351 = -1.538928840745229d+1*t135*t136*t137*t151*t65*t69*t
     1           86
              t352 = t181**2
              t353 = t280+t274
              t354 = t182**2
              t355 = t279+t275
              t356 = 1.3333333333333333d+0*t146*t355+4.444444444444444d-
     1           1*t278*t354+1.3333333333333333d+0*t143*t353+4.444444444
     2           444444d-1*t272*t352
              t357 = -1.923661050931536d+0*t356*t64*t65
              t358 = 1.5389288407452287d+1*t149*t183*t64
              t359 = 1.5389288407452287d+1*t151*t183*t65
              t360 = -6.155715362980915d+1*t149*t151*t69
              t361 = t360+t359+t358+t357+t290+t287
              t362 = -6.21814d-2*t361*t62*t78
              t363 = 5.495546528376875d-3*t125*t186*t78
              t364 = t360+t359+t358+t357+1.923661050931536d+0*t356+t290+
     1           t287
              t365 = 1.9751631321680768d-2*t364*t80*t84
              t366 = -9.087592854964233d-4*t125*t188*t84
              t367 = -5.980796863619711d-2*t356*t64*t65*t86*t89
              t368 = 5.082465978296986d-3*t160*t183*t64*t89
              t369 = 4.7846374908957684d-1*t149*t183*t64*t86*t89
              t370 = -2.0329863913187946d-2*t151*t160*t69*t89
              t371 = -1.9138549963583074d+0*t149*t151*t69*t86*t89
              t372 = t60*(4.7846374908957684d-1*t151*t183*t65*t86*t89+t3
     1           71+t370+t369+t368+t367+t366+t365+t363+t362+t351+t350+t3
     2           49+t348+t307+t305+t303+t298+t294+t269+t268+t266+t265+t2
     3           62+t258+t256+t255+t252+t248+t242+t241+t238)+4.784637490
     4           8957684d-1*t151*t65*t69*t86*t89-1.1961593727239421d-1*t
     5           183*t64*t65*t86*t89+3.9503262643361536d-2*t188*t80*t84-
     6           1.243628d-1*t186*t62*t78-rhob*t339-2.220446049250313d-1
     7           6*t165*t169*t170*t29-6.101282288702853d-19*t167*t28-2.0
     8           d+0*t171*t172*t173*t25-2.642079786267853d-3*t167*t24+t2
     9           34+t233+t232+t231+t230+t229+t228
              t373 = 1.0d+0*t347*t91+1.0d+0*t104*t372+2.0d+0*t180*t191
              t374 = 3.04966d-52*t180*t91+3.04966d-52*t192+3.04966d-52*t
     1           104*t191
              t375 = 1.25d-1*t44*t59+1.25d-1*gammaaa*t194*t44
              t376 = 1/rhoa**9
              t377 = 6.867840000000001d-2*t107*t55*t57*t6*taua-3.3333333
     1           333333337d+0*t15*t55*t56*taua+1.7169600000000002d-2*t13
     2           *t55*t56*taua+3.4339200000000003d-2*gammaaa*t107*t15*t1
     3           93*taua+1.591893886464d-4*t106*t205*t48*t58*t6+2.747136
     4           d-2*t105*t107*t58*t6-2.6666666666666666d+0*t105*t15*t56
     5           *t57+1.373568d-2*t105*t13*t56*t57+1.591893886464d-4*gam
     6           maaa*t106*t15*t205*t55*t57-1.030176d-2*t106*t107*t15*t4
     7           8*t57+5.30631295488d-5*t106*t107*t13*t48*t57+5.494272d-
     8           2*gammaaa*t107*t108*t15*t57-5.15088d-3*t106*t14*t48*t56
     9           +2.747136d-2*gammaaa*t108*t14*t56-1.0666666666666666d+1
     :           *gammaaa*t108*t11*t56+5.30631295488d-5*gammaaa*t106*t10
     ;           7*t14*t55-2.060352d-2*gammaaa*t106*t107*t11*t55+8.24140
     <           8d-2*t107*t11*t376*t54+1.591893886464d-4*t106*t11*t193*
     =           t205*t54-2.6666666666666666d+0*t105*t14*t53
              t378 = -1.25d-1*t44*t45*t46*t59-1.25d-1*t119*t46*t59+1.0d+
     1           0*rhoa*t377*t44*t47+1.0d+0*t194*t44*t47+1.0d+0*rhoa*t11
     2           9*t194*t47-1.25d-1*t109*t44*t46
              t379 = 1.373568d-2*t44*t47*t59-5.15088d-3*t120
              t380 = 4.066213333333334d-2*t100*t121*t55*t99*taua-3.33333
     1           33333333337d+0*t55*t97*t98*taua+2.033106666666667d-2*t1
     2           21*t55*t95*t98*taua+1.0165533333333335d-2*t103*t55*t97*
     3           taua-2.6666666666666666d+0*t105*t97*t98*t99+5.580255669
     4           360001d-5*t106*t226*t48*t95*t98*t99+1.6264853333333332d
     5           -2*t105*t121*t95*t98*t99-6.09932d-3*t106*t121*t48*t98*t
     6           99+1.6264853333333332d-2*gammaaa*t108*t121*t98*t99+8.13
     7           2426666666667d-3*t103*t105*t97*t99+1.86008522312d-5*t10
     8           3*t106*t121*t48*t99-5.333333333333333d+0*t105*t94*t95*t
     9           97+8.132426666666667d-3*t102*t105*t95*t97-5.33333333333
     :           3333d+0*gammaaa*t108*t94*t97-3.04966d-3*t102*t106*t48*t
     ;           97+8.132426666666667d-3*gammaaa*t102*t108*t97+5.5802556
     <           69360001d-5*t106*t226*t48*t94*t96+1.6264853333333332d-2
     =           *t105*t121*t94*t96-1.219864d-2*t106*t121*t48*t94*t95+3.
     >           2529706666666663d-2*gammaaa*t108*t121*t94*t95+1.8600852
     ?           2312d-5*t102*t106*t121*t48*t95-2.6666666666666666d+0*t1
     @           02*t105*t93+5.580255669360001d-5*t100*t101*t106*t226*t4
     1           8+1.6264853333333332d-2*t100*t101*t105*t121
              t381 = 1.0d+0*t380*t91+1.0d+0*t163*t195
              t382 = -5.580255669360001d-54*t177*t226*t48*t95*t98*t99+1.
     1           0165533333333333d-51*t121*t177*t48*t98*t99-1.8600852231
     2           2d-54*t103*t121*t177*t48*t99+4.0662133333333333d-52*t10
     3           0*t121*t177*t48*t99-3.333333333333333d-50*t177*t48*t97*
     4           t98+2.0331066666666667d-52*t121*t177*t48*t95*t98-1.3333
     5           333333333333d-49*t177*t48*t94*t97+1.0165533333333333d-5
     6           2*t103*t177*t48*t97+5.082766666666666d-52*t102*t177*t48
     7           *t97-5.580255669360001d-54*t177*t226*t48*t94*t96+2.0331
     8           066666666667d-51*t121*t177*t48*t94*t95-1.86008522312d-5
     9           4*t102*t121*t177*t48*t95-5.580255669360001d-54*t100*t10
     :           1*t177*t226*t48
              t383 = 1.0d+0*t382*t91+1.0d+0*t191*t195
              t384 = 1/rhoa**1.0666666666666666d+1
              t385 = 1.591893886464d-4*t205*t55*t58*t6-2.060352d-2*t107*
     1           t15*t55*t57+5.30631295488d-5*t107*t13*t55*t57+1.5918938
     2           86464d-4*gammaaa*t15*t193*t205*t57-1.030176d-2*t14*t55*
     3           t56+2*t11*t55*t56+1.591893886464d-4*t11*t205*t384*t54+5
     4           .30631295488d-5*gammaaa*t107*t14*t193-4.120704d-2*gamma
     5           aa*t107*t11*t193
              t386 = 5.580255669360001d-5*t226*t55*t95*t98*t99-1.219864d
     1           -2*t121*t55*t98*t99+1.86008522312d-5*t103*t121*t55*t99+
     2           2*t55*t94*t97-6.09932d-3*t102*t55*t97+5.580255669360001
     3           d-5*t226*t55*t94*t96-2.439728d-2*t121*t55*t94*t95+1.860
     4           08522312d-5*t102*t121*t55*t95+5.580255669360001d-5*t100
     5           *t101*t226*t55
              t387 = 1.373568d-1*t107*t197*t57*t6*taua-1.333333333333333
     1           3d+1*t197*t56*t6*taua+3.4339200000000003d-2*t13*t197*t5
     2           6*taua+6.867840000000001d-2*gammaaa*t107*t15*t196*taua+
     3           3.183787772928d-4*t106*t205*t50*t58*t6+3.43392000000000
     4           03d-2*t107*t48*t58*t6-6.666666666666667d+0*t48*t56*t57*
     5           t6-4.120704d-2*t106*t107*t50*t57*t6+1.7169600000000002d
     6           -2*t13*t48*t56*t57+8.928192d-2*gammaaa*t107*t15*t55*t57
     7           +1.061262590976d-4*t106*t107*t13*t50*t57+3.183787772928
     8           d-4*gammaaa*t106*t15*t197*t205*t57-8.666666666666666d+0
     9           *gammaaa*t15*t55*t56+4.464096d-2*gammaaa*t14*t55*t56-1.
     :           030176d-2*t106*t13*t50*t56+3.183787772928d-4*t106*t11*t
     ;           196*t205*t54+1.4422464000000002d-1*t107*t11*t193*t54-3.
     <           3333333333333337d+0*t13*t48*t53-2.060352d-2*gammaaa*t10
     =           6*t107*t15*t197+1.061262590976d-4*gammaaa*t106*t107*t14
     >           *t197
              t388 = 1.25d-1*gammaaa*t200*t44*t45*t59+1.25d-1*gammaaa*t1
     1           19*t200*t59+1.0d+0*rhoa*t387*t44*t47+1.0d+0*t198*t44*t4
     2           7+1.0d+0*rhoa*t119*t198*t47+1.25d-1*gammaaa*t109*t200*t
     3           44
              t389 = 8.132426666666668d-2*t100*t121*t197*t99*taua+4.0662
     1           13333333334d-2*t121*t197*t95*t98*taua+2.033106666666667
     2           d-2*t103*t197*t97*taua-1.3333333333333333d+1*t100*t197*
     3           t97*taua+1.1160511338720001d-4*t106*t226*t50*t95*t98*t9
     4           9+2.033106666666667d-2*t121*t48*t95*t98*t99+3.252970666
     5           6666663d-2*gammaaa*t121*t55*t98*t99+1.0165533333333335d
     6           -2*t103*t48*t97*t99-6.666666666666667d+0*t100*t48*t97*t
     7           99+3.72017044624d-5*t103*t106*t121*t50*t99-2.439728d-2*
     8           t100*t106*t121*t50*t99-3.3333333333333337d+0*t48*t95*t9
     9           7*t98-5.333333333333333d+0*gammaaa*t55*t97*t98-1.219864
     :           d-2*t106*t121*t50*t95*t98+1.0165533333333335d-2*t102*t4
     ;           8*t95*t97+1.6264853333333332d-2*gammaaa*t102*t55*t97-6.
     <           09932d-3*t103*t106*t50*t97+1.1160511338720001d-4*t106*t
     =           226*t50*t94*t96+2.033106666666667d-2*t121*t48*t94*t96+6
     >           .505941333333333d-2*gammaaa*t121*t55*t94*t95+3.72017044
     ?           624d-5*t102*t106*t121*t50*t95-3.3333333333333337d+0*t10
     @           3*t48*t93+1.1160511338720001d-4*t100*t101*t106*t226*t50
     1           +2.033106666666667d-2*t100*t101*t121*t48
              t390 = 1.0d+0*t389*t91+1.0d+0*t163*t201
              t391 = -1.1160511338720003d-53*t177*t226*t50*t95*t98*t99+8
     1           .132426666666667d-52*t121*t177*t50*t98*t99-3.7201704462
     2           4d-54*t103*t121*t177*t50*t99+3.252970666666667d-51*t100
     3           *t121*t177*t50*t99-1.3333333333333333d-49*t177*t50*t97*
     4           t98+1.6264853333333334d-51*t121*t177*t50*t95*t98+8.1324
     5           26666666667d-52*t103*t177*t50*t97+4.0662133333333333d-5
     6           2*t102*t177*t50*t97-1.3333333333333333d-49*t100*t177*t5
     7           0*t97-1.1160511338720003d-53*t177*t226*t50*t94*t96+1.62
     8           64853333333334d-51*t121*t177*t50*t94*t95-3.72017044624d
     9           -54*t102*t121*t177*t50*t95-1.1160511338720003d-53*t100*
     :           t101*t177*t226*t50
              t392 = 1.0d+0*t391*t91+1.0d+0*t191*t201
              t393 = 1/rhoa**9.666666666666666d+0
              t394 = 3.183787772928d-4*t197*t205*t58*t6-4.120704d-2*t107
     1           *t197*t57*t6+3.183787772928d-4*gammaaa*t15*t196*t205*t5
     2           7-2.060352d-2*t107*t15*t197*t57+1.061262590976d-4*t107*
     3           t13*t197*t57+2.0d+0*t15*t197*t56-1.030176d-2*t14*t197*t
     4           56-1.030176d-2*t13*t197*t56+3.183787772928d-4*t11*t205*
     5           t393*t54-2.060352d-2*gammaaa*t107*t15*t196+1.0612625909
     6           76d-4*gammaaa*t107*t14*t196-4.120704d-2*gammaaa*t107*t1
     7           1*t196
              t395 = 1/rhoa**3.3333333333333337d+0
              t396 = 1.1160511338720001d-4*t197*t226*t95*t98*t99-1.21986
     1           4d-2*t121*t197*t98*t99+3.72017044624d-5*t103*t121*t197*
     2           t99-2.439728d-2*t100*t121*t197*t99+2.0d+0*t197*t97*t98-
     3           1.219864d-2*t121*t197*t95*t98-6.09932d-3*t103*t197*t97-
     4           6.09932d-3*t102*t197*t97+1.1160511338720001d-4*t197*t22
     5           6*t94*t96-2.439728d-2*t121*t197*t94*t95+3.72017044624d-
     6           5*t102*t121*t197*t95+1.1160511338720001d-4*t100*t101*t1
     7           97*t226
              t397 = 1/rhoa**8.666666666666666d+0
              t398 = 1/rhoa**6
              t399 = 6.367575545856d-4*t205*t395*t58*t6-1.6482816d-1*t10
     1           7*t395*t57*t6+8.0d+0*t395*t56*t6+6.367575545856d-4*gamm
     2           aaa*t15*t205*t398*t57+2.122525181952d-4*t107*t13*t395*t
     3           57-4.120704d-2*t13*t395*t56+6.367575545856d-4*t11*t205*
     4           t397*t54-8.241408d-2*gammaaa*t107*t15*t398+2.1225251819
     5           52d-4*gammaaa*t107*t14*t398
              t400 = 1/taua**3
              t401 = 2.2321022677440003d-4*t226*t395*t95*t98*t99+7.44034
     1           089248d-5*t103*t121*t395*t99-9.758912d-2*t100*t121*t395
     2           *t99-4.879456d-2*t121*t395*t95*t98-2.439728d-2*t103*t39
     3           5*t97+8.0d+0*t100*t395*t97+2.2321022677440003d-4*t226*t
     4           395*t94*t96+7.44034089248d-5*t102*t121*t395*t95+2.23210
     5           22677440003d-4*t100*t101*t226*t395
              t402 = t106**3
              t403 = 1/rhoa**3
              t404 = 1/t52**5
              t405 = 1/rhoa**5.666666666666667d+0
              t406 = -3.2592592592592595d+1*t206*taua-4.5629629629629626
     1           d+1*gammaaa*t405
              t407 = 1/rhoa**8.333333333333334d+0
              t408 = t114**3
              t409 = 1/t32**7
              t410 = 1/rhoa**3.1666666666666665d+0
              t411 = t117**3
              t412 = 1.1102230246251565d-16*t110*t115*(-2.52042634099614
     1           9d+0*t410-1.5008036906238065d+0*t409-2.3079979182303428
     2           d+0*t395-5.620753557770543d-1*t105)*t43+5.7427410515035
     3           65d-14*t408*t43/(t40**6*t41**3)-1.0712750352598913d-14*
     4           t210*t408*t43/t40**5+6.661338147750939d-16*t110*t212*t4
     5           08*t43-6.661338147750939d-16*t110*t114*t213*t217*t43+5.
     6           356375176299456d-15*t114*t210*t212*t217*t43+9.490883560
     7           204437d-19*t395*t42+2.0690405167709364d+3*t39*t411/(t36
     8           **6*t37**3)-1.9298375398431045d+2*t218*t39*t411/t36**5+
     9           6.0d+0*t116*t220*t39*t411+1.0d+0*t116*t118*t39*(-4.6849
     :           72743248224d+0*t410-3.083875829189267d+0*t409-3.9871442
     ;           462415524d+0*t395-7.128507529742789d-1*t105)+4.10990188
     <           97499934d-3*t38*t395-6.0d+0*t116*t117*t221*t222*t39+9.6
     =           49187699215522d+1*t117*t218*t220*t222*t39-1.27469618870
     >           0087d-1*t112*t116*t118*t222+2.549392377400174d-1*t112*t
     ?           116*t219*t221-4.0999275947472624d+0*t112*t218*t219*t220
     @           -1.4718104502398274d-17*t110*t112*t115*t217+1.699594918
     1           2667827d-1*t116*t117*t118*t215+1.962413933653103d-17*t1
     2           10*t114*t115*t215+2.943620900479655d-17*t110*t112*t211*
     3           t213-2.3669625486718335d-16*t112*t210*t211*t212
              t413 = 1/t92**5
              t414 = 4.824593849607761d+1*t235*t236*t237*t62*t71
              t415 = -6.0d+0*t129*t235*t240*t62*t71
              t416 = -2.6513779981040353d-1*t125*t127*t128*t129*t71
              t417 = 3.0d+0*t128*t129*t247*t62*t71
              t418 = -5.19476882440587d+1*t249*t250*t251*t80*t81
              t419 = 3.5089341735807883d+0*t133*t249*t254*t80*t81
              t420 = 8.072185179299687d-2*t125*t131*t132*t133*t81
              t421 = -1.7544670867903941d+0*t132*t133*t257*t80*t81
              t422 = 1.856176655010858d+2*t259*t260*t261*t64*t65*t69*t86
              t423 = -1.1541966305589217d+1*t137*t259*t264*t64*t65*t69*t
     1           86
              t424 = -4.904166819946466d-1*t135*t136*t137*t160*t64*t69
              t425 = 5.770983152794609d+0*t136*t137*t267*t64*t65*t69*t86
              t426 = -4.616786522235687d+1*t135*t136*t137*t149*t64*t69*t
     1           86
              t427 = -1.099109305675375d-2*t245*t71*t78
              t428 = 1.8175185709928465d-3*t245*t81*t84
              t429 = -7.11545236961578d-2*t302*t64*t69*t89
              t430 = -3.588478118171826d+0*t286*t64*t69*t86*t89
              t431 = -2.1530868709030954d+0*t289*t65*t69*t86*t89
              t432 = t127**3
              t433 = 5.172601291927341d+2*t432*t62*t71/(t76**6*t77**3)
              t434 = -9.649187699215522d+1*t237*t432*t62*t71/t76**5
              t435 = 4.824593849607761d+1*t127*t236*t237*t247*t62*t71
              t436 = -2.1319703304396778d+0*t125*t235*t236*t237*t71
              t437 = 6.0d+0*t129*t236*t432*t62*t71
              t438 = -6.0d+0*t127*t129*t240*t247*t62*t71
              t439 = 2.6513779981040353d-1*t125*t129*t235*t240*t71
              t440 = -1.3256889990520176d-1*t125*t128*t129*t247*t71
              t441 = 1.767585332069357d-1*t127*t128*t129*t245*t71
              t442 = 1/t60**3.6666666666666664d+0
              t443 = 1/t73**7
              t444 = 1/t60**3.3333333333333337d+0
              t445 = 1/t60**3.1666666666666665d+0
              t446 = 1.0d+0*t128*t129*(-2.520426340996149d+0*t445-2.3079
     1           979182303428d+0*t444-1.5008036906238065d+0*t443-5.62075
     2           3557770543d-1*t442)*t62*t71
              t447 = t131**3
              t448 = -1.0254062650399592d+3*t447*t80*t81/(t82**6*t83**3)
              t449 = 1.0389537648811739d+2*t251*t447*t80*t81/t82**5
              t450 = -5.19476882440587d+1*t131*t250*t251*t257*t80*t81
              t451 = 1.1950391155803675d+0*t125*t249*t250*t251*t81
              t452 = -3.5089341735807883d+0*t133*t250*t447*t80*t81
              t453 = 3.5089341735807883d+0*t131*t133*t254*t257*t80*t81
              t454 = -8.072185179299687d-2*t125*t133*t249*t254*t81
              t455 = 4.0360925896498434d-2*t125*t132*t133*t257*t81
              t456 = -5.381456786199791d-2*t131*t132*t133*t245*t81
              t457 = -5.848223622634647d-1*t132*t133*(-3.436688601932293
     1           d+0*t445-2.3308360066730832d+0*t444-8.064323383643707d-
     2           1*t443-5.663741022599518d-1*t442)*t80*t81
              t458 = t135**3
              t459 = 3.9801326549115085d+3*t458*t64*t65*t69*t86/(t87**6*
     1           t88**3)
              t460 = -3.712353310021716d+2*t261*t458*t64*t65*t69*t86/t87
     1           **5
              t461 = 1.856176655010858d+2*t135*t260*t261*t267*t64*t65*t6
     1           9*t86
              t462 = -7.424706620043432d+2*t149*t259*t260*t261*t64*t69*t
     1           86
              t463 = -7.886871025654724d+0*t160*t259*t260*t261*t64*t69
              t464 = 1.1541966305589217d+1*t137*t260*t458*t64*t65*t69*t8
     1           6
              t465 = -1.1541966305589217d+1*t135*t137*t264*t267*t64*t65*
     1           t69*t86
              t466 = 4.616786522235687d+1*t137*t149*t259*t264*t64*t69*t8
     1           6
              t467 = 4.904166819946466d-1*t137*t160*t259*t264*t64*t69
              t468 = -2.452083409973233d-1*t136*t137*t160*t267*t64*t69
              t469 = 2.2886111826416838d+0*t135*t136*t137*t302*t64*t69
              t470 = 1.923661050931536d+0*t136*t137*(-4.684972743248224d
     1           +0*t445-3.9871442462415524d+0*t444-3.083875829189267d+0
     2           *t443-7.128507529742789d-1*t442)*t64*t65*t69*t86
              t471 = -2.3083932611178434d+1*t136*t137*t149*t267*t64*t69*
     1           t86
              t472 = 1.1541966305589217d+2*t135*t136*t137*t286*t64*t69*t
     1           86
              t473 = 6.925179783353531d+1*t135*t136*t137*t289*t65*t69*t8
     1           6
              t474 = 8.548627933030694d-3*t444*t71*t78
              t475 = 1/t67**1.6666666666666669d+0
              t476 = 6*t63*t65
              t477 = -6*t273
              t478 = 1/t68**1.6666666666666669d+0
              t479 = -6*t63*t65
              t480 = 6*t273
              t481 = 1.3333333333333333d+0*t146*(t480+t479)-2.9629629629
     1           62963d-1*t145**3*t478+1.3333333333333333d+0*t143*(t477+
     2           t476)-2.962962962962963d-1*t142**3*t475+1.3333333333333
     3           333d+0*t145*t278*t281+1.3333333333333333d+0*t142*t272*t
     4           276
              t482 = -1.923661050931536d+0*t481*t64*t65
              t483 = 2.3083932611178434d+1*t149*t282*t64
              t484 = -2.3083932611178434d+1*t151*t282*t65
              t485 = -1.1541966305589216d+2*t147*t286*t64
              t486 = 1.8467146088942746d+2*t147*t149*t151
              t487 = -6.925179783353531d+1*t147*t289*t65
              t488 = 1/t60**7
              t489 = 2.3083932611178432d+2*t488*t64*t69
              t490 = -4.6167865222356863d+2*t151*t286*t69
              t491 = 2.770071913341412d+2*t149*t289*t69
              t492 = -4.616786522235687d+1*t63*t65*t69
              t493 = -1.4136255552166585d-3*t444*t81*t84
              t494 = 2.0103976536374746d-1*t64*t69*t89/t60**7.3333333333
     1           33333d+0
              t495 = 9.148438760934575d-2*t160*t289*t69*t89
              t496 = 7.176956236343652d+0*t488*t64*t69*t86*t89
              t497 = 8.612347483612381d+0*t149*t289*t69*t86*t89
              t498 = -1.4353912472687305d+0*t63*t65*t69*t86*t89
              t499 = -1.243628d-1*t319*t62*t78
              t500 = 3.9503262643361536d-2*t320*t80*t84
              t501 = -1.1961593727239421d-1*t312*t64*t65*t86*t89
              t502 = 2.0d+0*t127*t128*t129*t319*t62
              t503 = -1.1696447245269295d+0*t131*t132*t133*t320*t80
              t504 = 3.847322101863072d+0*t135*t136*t137*t312*t64*t65*t8
     1           6
              t505 = -2.3083932611178434d+1*t135*t136*t137*t289*t65*t69*
     1           t86
              t506 = 5.495546528376875d-3*t125*t319*t78
              t507 = 1.5389288407452287d+1*t149*t312*t64
              t508 = -1.5389288407452287d+1*t151*t312*t65
              t509 = 1.7777777777777776d+0*t145*t273*t278*t63-1.77777777
     1           77777776d+0*t142*t272*t273*t63+1.3333333333333333d+0*t1
     2           46*(t479+2*t273)-2.962962962962963d-1*t182*t277*t478+1.
     3           3333333333333333d+0*t143*(t476-2*t273)-2.96296296296296
     4           3d-1*t181*t271*t475+4.444444444444444d-1*t182*t278*t281
     5           +4.444444444444444d-1*t181*t272*t276
              t510 = -1.923661050931536d+0*t509*t64*t65
              t511 = 7.694644203726144d+0*t149*t282*t64
              t512 = 7.694644203726144d+0*t151*t282*t65
              t513 = -3.8473221018630716d+1*t183*t286*t64
              t514 = 6.155715362980915d+1*t149*t151*t183
              t515 = -2.3083932611178434d+1*t183*t289*t65
              t516 = -7.694644203726143d+1*t147*t286*t64
              t517 = 4.616786522235687d+1*t147*t289*t65
              t518 = -1.5389288407452287d+2*t151*t286*t69
              t519 = -9.233573044471374d+1*t149*t289*t69
              t520 = 4.616786522235687d+1*t63*t65*t69
              t521 = -9.087592854964233d-4*t125*t320*t84
              t522 = 5.082465978296986d-3*t160*t312*t64*t89
              t523 = 4.7846374908957684d-1*t149*t312*t64*t86*t89
              t524 = -2.870782494537461d+0*t149*t289*t69*t86*t89
              t525 = 1.4353912472687305d+0*t63*t65*t69*t86*t89
              t526 = -8*t146*t63*t65+8*t143*t63*t65+1.7777777777777776d+
     1           0*t182*t273*t278*t63-1.7777777777777776d+0*t181*t272*t2
     2           73*t63-2.962962962962963d-1*t145*t354*t478-2.9629629629
     3           62963d-1*t142*t352*t475+4.444444444444444d-1*t145*t278*
     4           t355+4.444444444444444d-1*t142*t272*t353-2.666666666666
     5           6666d+0*t146*t273+2.6666666666666666d+0*t143*t273
              t527 = -1.923661050931536d+0*t526*t64*t65
              t528 = 1.5389288407452287d+1*t151*t312*t65
              t529 = 7.694644203726144d+0*t149*t356*t64
              t530 = -7.694644203726144d+0*t151*t356*t65
              t531 = -7.694644203726143d+1*t183*t286*t64
              t532 = 4.616786522235687d+1*t183*t289*t65
              t533 = -3.8473221018630716d+1*t147*t286*t64
              t534 = -6.155715362980915d+1*t147*t149*t151
              t535 = -2.3083932611178434d+1*t147*t289*t65
              t536 = 1.5389288407452287d+2*t151*t286*t69
              t537 = t169**3
              t538 = 1/t18**7
              t539 = 1/rhob**3.1666666666666665d+0
              t540 = t172**3
              t541 = 6.0d+0*t171*t25*t336*t540-1.9298375398431045d+2*t25
     1           *t334*t540/t22**5+2.0690405167709364d+3*t25*t540/(t22**
     2           6*t23**3)+1.1102230246251565d-16*t165*t170*t29*(-2.5204
     3           26340996149d+0*t539-1.5008036906238065d+0*t538-5.620753
     4           557770543d-1*t343-2.3079979182303428d+0*t12)+1.0d+0*t17
     5           1*t173*t25*(-4.684972743248224d+0*t539-3.08387582918926
     6           7d+0*t538-7.128507529742789d-1*t343-3.9871442462415524d
     7           +0*t12)+6.661338147750939d-16*t165*t29*t328*t537-1.0712
     8           750352598913d-14*t29*t326*t537/t26**5+5.742741051503565
     9           d-14*t29*t537/(t26**6*t27**3)-6.0d+0*t171*t172*t25*t337
     :           *t338+9.649187699215522d+1*t172*t25*t334*t336*t338-1.27
     ;           4696188700087d-1*t167*t171*t173*t338+2.549392377400174d
     <           -1*t167*t171*t335*t337-4.0999275947472624d+0*t167*t334*
     =           t335*t336-6.661338147750939d-16*t165*t169*t29*t329*t333
     >           +5.356375176299456d-15*t169*t29*t326*t328*t333-1.471810
     ?           4502398274d-17*t165*t167*t170*t333+1.6995949182667827d-
     @           1*t171*t172*t173*t331+1.962413933653103d-17*t165*t169*t
     1           170*t331+2.943620900479655d-17*t165*t167*t327*t329-2.36
     2           69625486718335d-16*t167*t326*t327*t328+9.49088356020443
     3           7d-19*t12*t28+4.1099018897499934d-3*t12*t24
              t542 = 1/t3**5
              t543 = 1/rhob**9.666666666666666d+0
              t544 = 1/rhob**8
              t545 = 1/rhob**6.333333333333333d+0
              t546 = 1/rhob**4.666666666666667d+0
              t547 = 1.3333333333333333d+0*t143*(t480+t476)+1.3333333333
     1           333333d+0*t146*(t479+t477)-2.962962962962963d-1*t182**3
     2           *t478-2.962962962962963d-1*t181**3*t475+1.3333333333333
     3           333d+0*t182*t278*t355+1.3333333333333333d+0*t181*t272*t
     4           353
              t548 = -1.923661050931536d+0*t547*t64*t65
              t549 = 2.3083932611178434d+1*t149*t356*t64
              t550 = 2.3083932611178434d+1*t151*t356*t65
              t551 = -1.1541966305589216d+2*t183*t286*t64
              t552 = -1.8467146088942746d+2*t149*t151*t183
              t553 = -6.925179783353531d+1*t183*t289*t65
              t554 = 4.6167865222356863d+2*t151*t286*t69
              t555 = -1.25d-1*t44*t59-1.25d-1*gammaaa*t194*t44
              t556 = 1/rhoa**10
              t557 = 1.25d-1*gammaaa*t385*t44+2.5d-1*t194*t44
              t558 = -1.030176d-2*t378
              t559 = -1.030176d-2*t375
              t560 = -1.28772d-3*gammaaa*t194*t44
              t561 = -1.28772d-3*t44*t59
              t562 = 1/rhoa**5
              t563 = 1/rhoa**7.666666666666667d+0
              fnc(iq) = (1.0d+0*t104*t91*t93+1.0d+0*rhoa*t44*t47*t53*t59
     1           +5.0d-1*rhob*t16*t30*t4)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-3.04966d-3*t104*t106*t91*t97+t164*t93-5
     1           .15088d-3*rhoa*t106*t44*t47*t56*t59+1.25d-1*gammaaa*t44
     2           *t45*t46*t53*t59+t120*t53)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (3.04966d-52*t104*t177*t91*t97+t192*t93+2
     1           .57544d-52*t1*t16*t30*t7+t179*t4)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = (-3.04966d-3*t104*t48*t91*t97+1.0d+0*t19
     1           5*t91*t93-5.15088d-3*t44*t47*t50*t56*t59-1.25d-1*t44*t4
     2           6*t53*t59+1.0d+0*rhoa*t194*t44*t47*t53)*wght+Cmat(iq,D1
     3           _GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = (-6.09932d-3*t104*t50*t91*t97+1.0d+0*t201
     1           *t91*t93-1.030176d-2*t31*t44*t47*t56*t59+1.25d-1*gammaa
     2           a*t200*t44*t53*t59+1.0d+0*rhoa*t198*t44*t47*t53)*wght+M
     3           mat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t310*t97+t309*t93+1.86008522312d-5*t
     1           104*t121*t202*t91-1.28772d-3*gammaaa*t106*t44*t45*t46*t
     2           56*t59-1.25d-1*gammaaa*t203*t44*t46*t53*t59+5.306312954
     3           88d-5*rhoa*t107*t202*t44*t47*t59+t225*t56+t204*t45*t46*
     4           t53+t224*t53)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = (t324*t97+3.04966d-52*t164*t177*t97+t
     1           323*t93-1.86008522312d-54*t104*t106*t121*t177*t91)*wght
     2           +Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (-8.132426666666666d-52*t104*t343*t91
     1           *t97+t177*t374*t97+t373*t93+1.86008522312d-103*t104*t12
     2           1*t342*t91+t177*t346*t7+t1*t325*t7+t345*t4+2.6531564774
     3           399996d-103*t16*t175*t176*t30)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (-3.04966d-3*t106*t195*t91*t97+8.132
     1           426666666667d-3*t104*t105*t91*t97-3.04966d-3*t164*t48*t
     2           97+t381*t93+1.86008522312d-5*t104*t106*t121*t48*t91+6.4
     3           386d-4*t106*t44*t46*t56*t59-6.4386d-4*gammaaa*t105*t44*
     4           t46*t56*t59+5.30631295488d-5*t106*t107*t44*t47*t50*t59+
     5           t379*t48*t56-5.15088d-3*rhoa*t106*t194*t44*t47*t56+t375
     6           *t45*t46*t53+t378*t53)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = (3.04966d-52*t177*t195*t91*t97-3.049
     1           66d-3*t192*t48*t97+t383*t93-1.86008522312d-54*t104*t121
     2           *t177*t48*t91)*wght+Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = (-6.09932d-3*t195*t48*t91*t97+1.0d+
     1           0*t386*t91*t93+1.86008522312d-5*t104*t121*t55*t91+1.287
     2           72d-3*t44*t46*t48*t56*t59+5.30631295488d-5*t107*t197*t4
     3           4*t47*t59-1.030176d-2*t194*t44*t47*t50*t56+1.0d+0*rhoa*
     4           t385*t44*t47*t53-2.5d-1*t194*t44*t46*t53)*wght+Cmat2(iq
     5           ,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (1.0165533333333335d-2*t104*t48*t91*t
     1           97-3.04966d-3*t106*t201*t91*t97-6.09932d-3*t164*t50*t97
     2           +t390*t93+3.72017044624d-5*t104*t106*t121*t50*t91+t50*t
     3           56*(1.7169600000000002d-2*t44*t47*t59-1.030176d-2*t120)
     4           -1.28772d-3*gammaaa*t44*t46*t48*t56*t59-6.4386d-4*gamma
     5           aa*t106*t200*t44*t56*t59-1.25d-1*gammaaa*t200*t44*t45*t
     6           53*t59+1.061262590976d-4*t106*t107*t31*t44*t47*t59-5.15
     7           088d-3*rhoa*t106*t198*t44*t47*t56+1.25d-1*gammaaa*t198*
     8           t44*t45*t46*t53+t388*t53)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = (3.04966d-52*t177*t201*t91*t97-6.0993
     1           2d-3*t192*t50*t97+t392*t93-3.72017044624d-54*t104*t121*
     2           t177*t50*t91)*wght+Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = (-6.09932d-3*t195*t50*t91*t97-3.0496
     1           6d-3*t201*t48*t91*t97+1.0d+0*t396*t91*t93+3.72017044624
     2           d-5*t104*t121*t197*t91+1.28772d-3*t44*t46*t50*t56*t59-6
     3           .4386d-4*gammaaa*t200*t44*t48*t56*t59+1.061262590976d-4
     4           *t107*t395*t44*t47*t59-5.15088d-3*t198*t44*t47*t50*t56-
     5           1.030176d-2*t194*t31*t44*t47*t56+1.0d+0*rhoa*t394*t44*t
     6           47*t53-1.25d-1*t198*t44*t46*t53+t200*t375*t53)*wght+Mma
     7           t2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = (-1.219864d-2*t201*t50*t91*t97+1.0d+0
     1           *t401*t91*t93+7.44034089248d-5*t104*t121*t395*t91-2.575
     2           44d-3*gammaaa*t200*t44*t50*t56*t59-2.5d-1*gammaaa*t400*
     3           t44*t53*t59+2.122525181952d-4*t107*t215*t44*t47*t59-2.0
     4           60352d-2*t198*t31*t44*t47*t56+1.0d+0*rhoa*t399*t44*t47*
     5           t53+2.5d-1*gammaaa*t198*t200*t44*t53)*wght+Mmat2(iq,D2_
     6           TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t93*(1.0d+0*t91*(-6.5185185185185
     1           19d+1*t100*t206*t97*t99*taua-1.1160511338720001d-3*t100
     2           *t202*t226*t48*t99*taua+1.2198640000000001d-1*t100*t121
     3           *t207*t48*t99*taua-3.252970666666667d-1*t100*t105*t106*
     4           t121*t99*taua-3.2592592592592595d+1*t206*t95*t97*t98*ta
     5           ua-1.6888888888888892d+2*gammaaa*t208*t97*t98*taua-5.58
     6           025566936d-4*t202*t226*t48*t95*t98*taua+6.09932d-2*t121
     7           *t207*t48*t95*t98*taua-1.6264853333333334d-1*t105*t106*
     8           t121*t95*t98*taua-3.252970666666667d-1*gammaaa*t106*t10
     9           8*t121*t98*taua+3.04966d-2*t103*t207*t48*t97*taua-8.132
     :           426666666668d-2*t103*t105*t106*t97*taua-3.2592592592592
     ;           595d+1*t103*t206*t93*taua-1.8600852231200002d-4*t103*t1
     <           21*t202*t48*taua-4.5629629629629626d+1*gammaaa*t405*t97
     =           *t98*t99-6.807153001848167d-7*t402*t413*t95*t98*t99-6.0
     >           9932d-3*t121*t406*t95*t98*t99+1.6740767008080004d-4*t10
     ?           6*t207*t226*t95*t98*t99-4.464204535488d-4*gammaaa*t105*
     @           t202*t226*t98*t99+4.879456d-2*gammaaa*t105*t121*t207*t9
     1           8*t99-1.7891338666666665d-1*gammaaa*t106*t121*t206*t98*
     2           t99-3.04966d-3*t103*t406*t97*t99-1.7017882504620419d-7*
     3           t103*t226*t402*t99+5.580255669359999d-5*t103*t106*t121*
     4           t207*t99-9.125925925925925d+1*gammaaa*t405*t94*t95*t97-
     5           3.04966d-3*t102*t406*t95*t97-1.5644444444444447d+2*t407
     6           *t54*t94*t97+2.439728d-2*gammaaa*t102*t105*t207*t97-8.9
     7           45669333333333d-2*gammaaa*t102*t106*t206*t97-1.77777777
     8           7777778d+2*t100*t108*t199*t97-6.807153001848167d-7*t402
     9           *t413*t94*t96-6.09932d-3*t121*t406*t94*t96+1.6740767008
     :           080004d-4*t106*t207*t226*t94*t96-8.928409070976d-4*gamm
     ;           aaa*t105*t202*t226*t94*t95+9.758912d-2*gammaaa*t105*t12
     <           1*t207*t94*t95-3.578267733333333d-1*gammaaa*t106*t121*t
     =           206*t94*t95-1.7017882504620419d-7*t102*t226*t402*t95+5.
     >           580255669359999d-5*t102*t106*t121*t207*t95-2.6023765333
     ?           33333d-1*t106*t121*t208*t54*t94-4.5629629629629626d+1*g
     @           ammaaa*t102*t405*t93-4.066213333333334d-1*t100*t106*t12
     1           1*t199*t55-6.807153001848167d-7*t100*t101*t402*t413-6.0
     2           9932d-3*t100*t101*t121*t406+1.6740767008080004d-4*t100*
     3           t101*t106*t207*t226-1.4880681784959998d-4*gammaaa*t102*
     4           t105*t121*t202)+1.0d+0*t104*(t60*(-1.4353912472687305d+
     5           1*t151*t286*t69*t86*t89-5.980796863619711d-2*t481*t64*t
     6           65*t86*t89-2.1530868709030954d+0*t147*t289*t65*t86*t89-
     7           7.176956236343652d-1*t151*t282*t65*t86*t89-3.5884781181
     8           71826d+0*t147*t286*t64*t86*t89+7.176956236343652d-1*t14
     9           9*t282*t64*t86*t89+5.741564989074922d+0*t147*t149*t151*
     :           t86*t89-2.8461809478463124d-1*t151*t302*t69*t89-7.11545
     ;           236961578d-2*t147*t302*t64*t89+7.623698967445479d-3*t16
     <           0*t282*t64*t89+6.098959173956384d-2*t147*t151*t160*t89+
     =           2.3083932611178434d+1*t136*t137*t151*t267*t65*t69*t86-4
     >           .616786522235687d+1*t137*t151*t259*t264*t65*t69*t86+7.4
     ?           24706620043432d+2*t151*t259*t260*t261*t65*t69*t86-1.846
     @           7146088942746d+2*t135*t136*t137*t149*t151*t69*t86+5.770
     1           983152794609d+0*t135*t136*t137*t282*t64*t65*t86+5.77098
     2           3152794609d+0*t136*t137*t147*t267*t64*t65*t86-1.1541966
     3           305589217d+1*t137*t147*t259*t264*t64*t65*t86+1.85617665
     4           5010858d+2*t147*t259*t260*t261*t64*t65*t86+4.6167865222
     5           35687d+1*t135*t136*t137*t147*t151*t65*t86-4.61678652223
     6           5687d+1*t135*t136*t137*t147*t149*t64*t86+1.975163132168
     7           0768d-2*(t492+t491+t490+t489+t487+t486+t485+t484+t483+t
     8           482+1.923661050931536d+0*t481)*t80*t84-1.36313892824463
     9           5d-3*t125*t295*t84+1.8175185709928465d-3*t156*t245*t84-
     :           1.7544670867903941d+0*t131*t132*t133*t295*t80-1.7544670
     ;           867903941d+0*t132*t133*t156*t257*t80+3.5089341735807883
     <           d+0*t133*t156*t249*t254*t80-5.19476882440587d+1*t156*t2
     =           49*t250*t251*t80-6.21814d-2*(t492+t491+t490+t489+t487+t
     >           486+t485+t484+t483+t482)*t62*t78+8.243319792565312d-3*t
     ?           125*t291*t78-1.099109305675375d-2*t153*t245*t78-1.96166
     @           67279785865d+0*t135*t136*t137*t151*t160*t69-4.904166819
     1           946466d-1*t135*t136*t137*t147*t160*t64+3.0d+0*t127*t128
     2           *t129*t291*t62+3.0d+0*t128*t129*t153*t247*t62-6.0d+0*t1
     3           29*t153*t235*t240*t62+4.824593849607761d+1*t153*t235*t2
     4           36*t237*t62+t498+t497+t496+t495+t494+t493+t474+t473+t47
     5           2+t471+t470+t469+t468+t467+t466+t465+t464+t463+t462+t46
     6           1+t460+t459+t457+t456+t455+t454+t453+t452+t451+t450+t44
     7           9+t448+t446+t441+t440+t439+t438+t437+t436+t435+t434+t43
     8           3+8.072185179299687d-2*t125*t131*t132*t133*t156-2.65137
     9           79981040353d-1*t125*t127*t128*t129*t153)+5.741564989074
     :           922d+0*t149*t151*t69*t86*t89-1.794239059085913d-1*t282*
     ;           t64*t65*t86*t89-1.4353912472687305d+0*t147*t151*t65*t86
     <           *t89+1.4353912472687305d+0*t147*t149*t64*t86*t89+6.0989
     =           59173956384d-2*t151*t160*t69*t89+1.524739793489096d-2*t
     >           147*t160*t64*t89+4.616786522235687d+1*t135*t136*t137*t1
     ?           51*t65*t69*t86+1.1541966305589217d+1*t135*t136*t137*t14
     @           7*t64*t65*t86+5.92548939650423d-2*t295*t80*t84-2.726277
     1           85648927d-3*t125*t156*t84-3.5089341735807883d+0*t131*t1
     2           32*t133*t156*t80-1.865442d-1*t291*t62*t78+1.64866395851
     3           30625d-2*t125*t153*t78+6.0d+0*t127*t128*t129*t153*t62+t
     4           431+t430-3.3306690738754696d-16*t110*t115*t217*t43+6.66
     5           1338147750939d-16*t110*t211*t213*t43-5.356375176299456d
     6           -15*t210*t211*t212*t43+t429+t428+t427+t426+t425+t424+t4
     7           23+t422+t421+t420+1.2202564577405706d-18*t215*t42+t419+
     8           t418+t417+t416+t415+t414-rhoa*t412-3.0d+0*t116*t118*t22
     9           2*t39+6.0d+0*t116*t219*t221*t39-9.649187699215522d+1*t2
     :           18*t219*t220*t39+5.284159572535705d-3*t215*t38+2.549392
     ;           377400174d-1*t112*t116*t117*t118+2.943620900479655d-17*
     <           t110*t112*t114*t115)+3.0d+0*t122*t308+3.0d+0*t163*t227)
     =           +t53*(1.0d+0*rhoa*t44*t47*(-6.518518518518519d+1*t206*t
     >           56*t57*t6*taua+2.060352d-1*t107*t207*t48*t57*t6*taua-3.
     ?           183787772928d-3*t202*t205*t48*t57*t6*taua-5.494272d-1*t
     @           105*t106*t107*t57*t6*taua+5.15088d-2*t13*t207*t48*t56*t
     1           aua-2.0148148148148146d+2*gammaaa*t15*t208*t56*taua-1.3
     2           73568d-1*t105*t106*t13*t56*taua+1.030176d-1*gammaaa*t10
     3           7*t15*t207*t55*taua-1.591893886464d-3*gammaaa*t15*t202*
     4           t205*t55*taua-3.2592592592592595d+1*t13*t206*t53*taua-5
     5           .30631295488d-4*t107*t13*t202*t48*taua-8.241408d-1*gamm
     6           aaa*t106*t107*t108*t15*taua-1.030176d-2*t107*t406*t58*t
     7           6-3.2798617527638757d-6*t402*t404*t58*t6+4.775681659392
     8           0004d-4*t106*t205*t207*t58*t6-1.777777777777778d+2*t108
     9           *t199*t56*t6-6.867840000000001d-1*t106*t107*t199*t55*t6
     :           -5.15088d-3*t13*t406*t56*t57-4.5629629629629626d+1*gamm
     ;           aaa*t15*t405*t56*t57-1.030176d-2*gammaaa*t107*t15*t406*
     <           t48*t57-3.2798617527638757d-6*gammaaa*t15*t402*t404*t48
     =           *t57+4.7756816593920004d-4*gammaaa*t106*t15*t205*t207*t
     >           48*t57-8.199654381909689d-7*t13*t205*t402*t57+8.241408d
     ?           -2*gammaaa*t105*t107*t15*t207*t57+1.591893886464d-4*t10
     @           6*t107*t13*t207*t57-3.0218496d-1*gammaaa*t106*t107*t15*
     1           t206*t57-1.2735151091712002d-3*gammaaa*t105*t15*t202*t2
     2           05*t57-2.477037037037037d+2*t11*t407*t54*t56-5.15088d-3
     3           *gammaaa*t14*t406*t48*t56+4.120704d-2*gammaaa*t105*t14*
     4           t207*t56-1.5109248d-1*gammaaa*t106*t14*t206*t56-1.03017
     5           6d-2*t107*t11*t406*t54*t55-3.2798617527638757d-6*t11*t4
     6           02*t404*t54*t55+4.7756816593920004d-4*t106*t11*t205*t20
     7           7*t54*t55-1.0439116799999999d+0*t106*t107*t11*t208*t54+
     8           1.6482816d-1*t107*t108*t11*t207*t54-2.5470302183424004d
     9           -3*t108*t11*t202*t205*t54-4.5629629629629626d+1*gammaaa
     :           *t14*t405*t53-8.199654381909689d-7*gammaaa*t14*t205*t40
     ;           2*t48+1.591893886464d-4*gammaaa*t106*t107*t14*t207*t48-
     <           4.245050363904d-4*gammaaa*t105*t107*t14*t202)+1.0d+0*rh
     =           oa*t412*t47*t59+3.0d+0*t223*t47*t59+2.5d-1*gammaaa*t223
     >           *t45*t46*t59-2.5d-1*gammaaa*t403*t44*t46*t59+2.5d-1*gam
     ?           maaa*t119*t203*t46*t59+3.0d+0*t209*t44*t47+3.0d+0*rhoa*
     @           t109*t223*t47+3.0d+0*rhoa*t119*t209*t47+6.0d+0*t109*t11
     1           9*t47+2.5d-1*gammaaa*t209*t44*t45*t46+5.0d-1*gammaaa*t1
     2           09*t119*t45*t46+2.5d-1*gammaaa*t109*t203*t44*t46)+(-3.0
     3           4966d-3*t104*t406*t91-3.04966d-3*t106*t227*t91-6.09932d
     4           -3*t122*t207*t91-6.09932d-3*t106*t309-3.04966d-3*t104*t
     5           106*t308-3.04966d-3*t164*t207-6.09932d-3*t104*t163*t207
     6           -6.09932d-3*t106*t122*t163)*t97+t121*(3.72017044624d-5*
     7           t104*t106*t207*t91+1.86008522312d-5*t122*t202*t91-6.099
     8           32d-3*t106*t310+1.86008522312d-5*t104*t163*t202)-1.7017
     9           882504620419d-7*t104*t226*t402*t91+t56*(-5.15088d-3*rho
     :           a*t406*t44*t47*t59-1.030176d-2*t207*t44*t47*t59-5.15088
     ;           d-3*rhoa*t106*t223*t47*t59-1.030176d-2*rhoa*t119*t207*t
     <           47*t59-1.030176d-2*t106*t119*t47*t59-6.4386d-4*gammaaa*
     =           t207*t44*t45*t46*t59-6.4386d-4*gammaaa*t106*t119*t45*t4
     >           6*t59-6.4386d-4*gammaaa*t106*t203*t44*t46*t59-5.15088d-
     ?           3*rhoa*t106*t209*t44*t47-1.030176d-2*rhoa*t109*t207*t44
     @           *t47-1.030176d-2*t106*t109*t44*t47-1.030176d-2*rhoa*t10
     1           6*t109*t119*t47-6.4386d-4*gammaaa*t106*t109*t44*t45*t46
     2           -1.030176d-2*t106*t224-5.15088d-3*t120*t207)+t107*(1.06
     3           1262590976d-4*rhoa*t106*t207*t44*t47*t59+5.30631295488d
     4           -5*t202*t44*t47*t59+5.30631295488d-5*rhoa*t119*t202*t47
     5           *t59+5.30631295488d-5*rhoa*t109*t202*t44*t47-1.030176d-
     6           2*t106*t225)+t45*t46*t56*(-1.28772d-3*gammaaa*t207*t44*
     7           t59-1.28772d-3*gammaaa*t106*t119*t59-1.28772d-3*gammaaa
     8           *t106*t109*t44-5.15088d-3*t106*t204)+t45*t46*t53*(1.25d
     9           -1*gammaaa*t223*t59+1.25d-1*gammaaa*t209*t44+2.5d-1*gam
     :           maaa*t109*t119)+t203*t46*t53*(-2.5d-1*gammaaa*t119*t59-
     ;           2.5d-1*gammaaa*t109*t44)+1.93158d-3*gammaaa*t106*t203*t
     <           44*t46*t56*t59+2.5d-1*gammaaa*t403*t44*t46*t53*t59-8.19
     =           9654381909689d-7*rhoa*t205*t402*t44*t47*t59+1.989867358
     >           0800003d-5*gammaaa*t107*t202*t44*t45*t46*t59)*wght+Amat
     ?           3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = (t93*(1.0d+0*t91*(7.44034089248000
     1           1d-53*t100*t106*t177*t226*t48*t99*taua+1.08432355555555
     2           57d-50*t100*t105*t121*t177*t99*taua-5.925925925925926d-
     3           49*t105*t177*t97*t98*taua+3.7201704462400004d-53*t106*t
     4           177*t226*t48*t95*t98*taua+5.421617777777779d-51*t105*t1
     5           21*t177*t95*t98*taua-2.710808888888889d-51*t106*t121*t1
     6           77*t48*t98*taua+1.0843235555555557d-50*gammaaa*t108*t12
     7           1*t177*t98*taua+2.710808888888889d-51*t103*t105*t177*t9
     8           7*taua-5.925925925925926d-49*t100*t105*t177*t97*taua+1.
     9           2400568154133336d-53*t103*t106*t121*t177*t48*taua-2.710
     :           808888888889d-51*t100*t106*t121*t177*t48*taua+6.8071530
     ;           01848167d-56*t177*t202*t413*t95*t98*t99-5.58025566936d-
     <           54*t177*t207*t226*t95*t98*t99-3.7201704462400004d-54*t1
     =           77*t202*t226*t98*t99+2.9761363569919996d-53*gammaaa*t10
     >           5*t106*t177*t226*t98*t99+4.0662133333333333d-52*t121*t1
     ?           77*t207*t98*t99+5.963779555555556d-51*gammaaa*t121*t177
     @           *t206*t98*t99+1.7017882504620416d-56*t103*t177*t202*t22
     1           6*t99-3.7201704462400004d-54*t100*t177*t202*t226*t99-1.
     2           86008522312d-54*t103*t121*t177*t207*t99+4.0662133333333
     3           333d-52*t100*t121*t177*t207*t99-3.2592592592592595d-49*
     4           gammaaa*t177*t206*t97*t98-1.8600852231200002d-54*t177*t
     5           202*t226*t95*t98+2.0331066666666667d-52*t121*t177*t207*
     6           t95*t98-1.0843235555555554d-51*gammaaa*t105*t106*t121*t
     7           177*t98-1.3037037037037036d-48*gammaaa*t177*t206*t94*t9
     8           7+1.0165533333333333d-52*t103*t177*t207*t97+2.033106666
     9           6666667d-52*t102*t177*t207*t97+2.981889777777778d-51*ga
     :           mmaaa*t102*t177*t206*t97+6.807153001848167d-56*t177*t20
     ;           2*t413*t94*t96-5.58025566936d-54*t177*t207*t226*t94*t96
     <           -7.440340892480001d-54*t177*t202*t226*t94*t95+5.9522727
     =           13983999d-53*gammaaa*t105*t106*t177*t226*t94*t95+8.1324
     >           26666666667d-52*t121*t177*t207*t94*t95+1.19275591111111
     ?           13d-50*gammaaa*t121*t177*t206*t94*t95+1.701788250462041
     @           6d-56*t102*t177*t202*t226*t95-1.86008522312d-54*t102*t1
     1           21*t177*t207*t95+8.674588444444443d-51*t121*t177*t208*t
     2           54*t94-4.3372942222222216d-51*gammaaa*t105*t106*t121*t1
     3           77*t94+1.3554044444444446d-50*t100*t121*t177*t199*t55+6
     4           .807153001848167d-56*t100*t101*t177*t202*t413-5.5802556
     5           6936d-54*t100*t101*t177*t207*t226-6.200284077066667d-55
     6           *t103*t121*t177*t202-1.2400568154133333d-54*t102*t121*t
     7           177*t202+9.920454523306665d-54*gammaaa*t102*t105*t106*t
     8           121*t177)+1.0d+0*t104*(t60*(-4.7846374908957684d+0*t151
     9           *t286*t69*t86*t89-5.980796863619711d-2*t509*t64*t65*t86
     :           *t89-4.7846374908957684d-1*t151*t312*t65*t86*t89-7.1769
     ;           56236343652d-1*t183*t289*t65*t86*t89+1.4353912472687305
     <           d+0*t147*t289*t65*t86*t89+2.3923187454478842d-1*t151*t2
     =           82*t65*t86*t89-1.1961593727239421d+0*t183*t286*t64*t86*
     >           t89-2.3923187454478842d+0*t147*t286*t64*t86*t89+2.39231
     ?           87454478842d-1*t149*t282*t64*t86*t89+1.9138549963583074
     @           d+0*t149*t151*t183*t86*t89-9.487269826154375d-2*t151*t3
     1           02*t69*t89-3.049479586978192d-2*t160*t289*t69*t89-2.371
     2           8174565385935d-2*t183*t302*t64*t89-4.743634913077187d-2
     3           *t147*t302*t64*t89+2.541232989148493d-3*t160*t282*t64*t
     4           89+2.0329863913187946d-2*t151*t160*t183*t89+7.694644203
     5           726144d+0*t136*t137*t151*t267*t65*t69*t86-1.53892884074
     6           5229d+1*t137*t151*t259*t264*t65*t69*t86+2.4749022066811
     7           444d+2*t151*t259*t260*t261*t65*t69*t86-6.15571536298091
     8           6d+1*t135*t136*t137*t149*t151*t69*t86+1.923661050931536
     9           d+0*t135*t136*t137*t282*t64*t65*t86+1.923661050931536d+
     :           0*t136*t137*t183*t267*t64*t65*t86+3.847322101863072d+0*
     ;           t136*t137*t147*t267*t64*t65*t86-3.847322101863072d+0*t1
     <           37*t183*t259*t264*t64*t65*t86-7.694644203726144d+0*t137
     =           *t147*t259*t264*t64*t65*t86+6.187255516702861d+1*t183*t
     >           259*t260*t261*t64*t65*t86+1.2374511033405722d+2*t147*t2
     ?           59*t260*t261*t64*t65*t86+1.538928840745229d+1*t135*t136
     @           *t137*t151*t183*t65*t86-1.538928840745229d+1*t135*t136*
     1           t137*t149*t183*t64*t86-3.077857681490458d+1*t135*t136*t
     2           137*t147*t149*t64*t86+1.9751631321680768d-2*(t520+t519+
     3           t518+t517+t516+t515+t514+t513+t512+t511+t510+1.92366105
     4           0931536d+0*t509+t508+t507+t489)*t80*t84-4.5437964274821
     5           163d-4*t125*t295*t84+6.058395236642822d-4*t188*t245*t84
     6           +1.2116790473285642d-3*t156*t245*t84-5.848223622634647d
     7           -1*t131*t132*t133*t295*t80-5.848223622634647d-1*t132*t1
     8           33*t188*t257*t80-1.1696447245269295d+0*t132*t133*t156*t
     9           257*t80+1.1696447245269295d+0*t133*t188*t249*t254*t80+2
     :           .339289449053859d+0*t133*t156*t249*t254*t80-1.731589608
     ;           13529d+1*t188*t249*t250*t251*t80-3.46317921627058d+1*t1
     <           56*t249*t250*t251*t80-6.21814d-2*(t520+t519+t518+t517+t
     =           516+t515+t514+t513+t512+t511+t510+t508+t507+t489)*t62*t
     >           78+2.747773264188437d-3*t125*t291*t78-3.663697685584583
     ?           d-3*t186*t245*t78-7.327395371169166d-3*t153*t245*t78-6.
     @           538889093261956d-1*t135*t136*t137*t151*t160*t69-1.63472
     1           22733154887d-1*t135*t136*t137*t160*t183*t64-3.269444546
     2           6309774d-1*t135*t136*t137*t147*t160*t64+1.0d+0*t127*t12
     3           8*t129*t291*t62+1.0d+0*t128*t129*t186*t247*t62+2.0d+0*t
     4           128*t129*t153*t247*t62-2.0d+0*t129*t186*t235*t240*t62-4
     5           .0d+0*t129*t153*t235*t240*t62+1.6081979498692536d+1*t18
     6           6*t235*t236*t237*t62+3.216395899738507d+1*t153*t235*t23
     7           6*t237*t62+t525+t524+t523+t522+t521+t506+t505+t504+t503
     8           +t502+t496+t494+t493+t474+t472+t471+t470+t469+t468+t467
     9           +t466+t465+t464+t463+t462+t461+t460+t459+t457+t456+t455
     :           +t454+t453+t452+t451+t450+t449+t448+t446+t441+t440+t439
     ;           +t438+t437+t436+t435+t434+t433+2.690728393099896d-2*t12
     <           5*t131*t132*t133*t188-8.837926660346784d-2*t125*t127*t1
     =           28*t129*t186+5.381456786199792d-2*t125*t131*t132*t133*t
     >           156-1.767585332069357d-1*t125*t127*t128*t129*t153)-4.78
     ?           46374908957684d-1*t151*t183*t65*t86*t89+9.5692749817915
     @           37d-1*t147*t149*t64*t86*t89+1.0164931956593973d-2*t147*
     1           t160*t64*t89+7.694644203726144d+0*t135*t136*t137*t147*t
     2           64*t65*t86-1.8175185709928465d-3*t125*t156*t84-2.339289
     3           449053859d+0*t131*t132*t133*t156*t80+1.099109305675375d
     4           -2*t125*t153*t78+4.0d+0*t127*t128*t129*t153*t62+t501+t5
     5           00+t499+t430+t429+t428+t427+t426+t425+t424+t423+t422+t4
     6           21+t420+t419+t418+t417+t416+t415+t414+t369+t368+t366+t3
     7           63+t350+t349+t348+t321+t306+t304+t299+t296+t292+t270)+2
     8           .0d+0*t122*t322+2.0d+0*t163*t311+1.0d+0*t180*t308+1.0d+
     9           0*t191*t227)+(-3.04966d-3*t106*t311*t91-3.04966d-3*t180
     :           *t207*t91-3.04966d-3*t106*t323-3.04966d-3*t104*t106*t32
     ;           2-3.04966d-3*t104*t191*t207-3.04966d-3*t106*t122*t191-3
     <           .04966d-3*t106*t163*t180)*t97+3.04966d-52*t177*t309*t97
     =           +t121*(1.86008522312d-5*t180*t202*t91+1.86008522312d-5*
     >           t104*t191*t202)+1.7017882504620416d-56*t104*t177*t202*t
     ?           226*t91+6.09932d-52*t121*t177*t310)*wght+Amat3(iq,D3_RA
     @           _RA_RB)
              Amat3(iq,D3_RA_RB_RB) = (t93*(1.0d+0*t91*(1.08432355555555
     1           57d-50*t100*t121*t343*t48*t99*taua-3.72017044624d-102*t
     2           100*t226*t342*t48*t99*taua-5.925925925925926d-49*t343*t
     3           48*t97*t98*taua+5.421617777777779d-51*t121*t343*t48*t95
     4           *t98*taua-1.86008522312d-102*t226*t342*t48*t95*t98*taua
     5           +2.710808888888889d-100*t121*t342*t48*t98*taua+2.710808
     6           888888889d-51*t103*t343*t48*t97*taua-5.925925925925926d
     7           -49*t100*t343*t48*t97*taua-6.200284077066667d-103*t103*
     8           t121*t342*t48*taua+2.710808888888889d-100*t100*t121*t34
     9           2*t48*taua-6.807153001848167d-105*t106*t342*t413*t95*t9
     :           8*t99+1.4880681784959998d-53*t106*t226*t343*t95*t98*t99
     ;           -1.0843235555555555d-51*t106*t121*t343*t98*t99+4.337294
     <           2222222216d-51*gammaaa*t105*t121*t343*t98*t99+7.4403408
     =           9248d-103*t106*t226*t342*t98*t99-1.4880681784959998d-10
     >           2*gammaaa*t105*t226*t342*t98*t99+4.9602272616533327d-54
     ?           *t103*t106*t121*t343*t99-1.0843235555555555d-51*t100*t1
     @           06*t121*t343*t99-1.7017882504620416d-105*t103*t106*t226
     1           *t342*t99+7.44034089248d-103*t100*t106*t226*t342*t99-2.
     2           37037037037037d-49*gammaaa*t105*t343*t97*t98-5.42161777
     3           7777777d-52*t106*t121*t343*t95*t98+3.72017044624d-103*t
     4           106*t226*t342*t95*t98-2.710808888888889d-101*t106*t121*
     5           t342*t98+1.0843235555555555d-100*gammaaa*t105*t121*t342
     6           *t98-9.48148148148148d-49*gammaaa*t105*t343*t94*t97-2.7
     7           108088888888887d-52*t103*t106*t343*t97-5.42161777777777
     8           7d-52*t102*t106*t343*t97+2.1686471111111108d-51*gammaaa
     9           *t102*t105*t343*t97-6.807153001848167d-105*t106*t342*t4
     :           13*t94*t96+1.4880681784959998d-53*t106*t226*t343*t94*t9
     ;           6-2.168647111111111d-51*t106*t121*t343*t94*t95+8.674588
     <           444444443d-51*gammaaa*t105*t121*t343*t94*t95+1.48806817
     =           84959998d-102*t106*t226*t342*t94*t95-2.9761363569919996
     >           d-102*gammaaa*t105*t226*t342*t94*t95+4.9602272616533327
     ?           d-54*t102*t106*t121*t343*t95-1.7017882504620416d-105*t1
     @           02*t106*t226*t342*t95-5.421617777777779d-101*t106*t121*
     1           t342*t94+4.337294222222222d-100*gammaaa*t105*t121*t342*
     2           t94-6.807153001848167d-105*t100*t101*t106*t342*t413+1.4
     3           880681784959998d-53*t100*t101*t106*t226*t343+1.24005681
     4           54133333d-103*t103*t106*t121*t342+2.4801136308266666d-1
     5           03*t102*t106*t121*t342-1.3554044444444446d-101*t100*t10
     6           6*t121*t342-4.960227261653333d-103*gammaaa*t102*t105*t1
     7           21*t342)+1.0d+0*t104*(t60*(4.7846374908957684d+0*t151*t
     8           286*t69*t86*t89-5.980796863619711d-2*t526*t64*t65*t86*t
     9           89-2.3923187454478842d-1*t151*t356*t65*t86*t89+4.784637
     :           4908957684d-1*t151*t312*t65*t86*t89+1.4353912472687305d
     ;           +0*t183*t289*t65*t86*t89-7.176956236343652d-1*t147*t289
     <           *t65*t86*t89+2.3923187454478842d-1*t149*t356*t64*t86*t8
     =           9-2.3923187454478842d+0*t183*t286*t64*t86*t89-1.1961593
     >           727239421d+0*t147*t286*t64*t86*t89-1.9138549963583074d+
     ?           0*t147*t149*t151*t86*t89+9.487269826154374d-2*t151*t302
     @           *t69*t89-3.0494795869781915d-2*t160*t289*t69*t89+2.5412
     1           32989148493d-3*t160*t356*t64*t89-4.743634913077187d-2*t
     2           183*t302*t64*t89-2.3718174565385935d-2*t147*t302*t64*t8
     3           9-2.0329863913187946d-2*t147*t151*t160*t89-7.6946442037
     4           26144d+0*t136*t137*t151*t267*t65*t69*t86+1.538928840745
     5           229d+1*t137*t151*t259*t264*t65*t69*t86-2.47490220668114
     6           44d+2*t151*t259*t260*t261*t65*t69*t86+6.155715362980916
     7           d+1*t135*t136*t137*t149*t151*t69*t86+1.923661050931536d
     8           +0*t135*t136*t137*t356*t64*t65*t86+3.847322101863072d+0
     9           *t136*t137*t183*t267*t64*t65*t86+1.923661050931536d+0*t
     :           136*t137*t147*t267*t64*t65*t86-7.694644203726144d+0*t13
     ;           7*t183*t259*t264*t64*t65*t86-3.847322101863072d+0*t137*
     <           t147*t259*t264*t64*t65*t86+1.2374511033405722d+2*t183*t
     =           259*t260*t261*t64*t65*t86+6.187255516702861d+1*t147*t25
     >           9*t260*t261*t64*t65*t86-1.538928840745229d+1*t135*t136*
     ?           t137*t147*t151*t65*t86-3.077857681490458d+1*t135*t136*t
     @           137*t149*t183*t64*t86-1.538928840745229d+1*t135*t136*t1
     1           37*t147*t149*t64*t86+1.9751631321680768d-2*(t536+t535+t
     2           534+t533+t532+t531+t530+t529+t528+t527+1.92366105093153
     3           6d+0*t526+t519+t507+t492+t489)*t80*t84-4.54379642748211
     4           63d-4*t125*t364*t84+1.2116790473285642d-3*t188*t245*t84
     5           +6.058395236642822d-4*t156*t245*t84-5.848223622634647d-
     6           1*t131*t132*t133*t364*t80-1.1696447245269295d+0*t132*t1
     7           33*t188*t257*t80-5.848223622634647d-1*t132*t133*t156*t2
     8           57*t80+2.339289449053859d+0*t133*t188*t249*t254*t80+1.1
     9           696447245269295d+0*t133*t156*t249*t254*t80-3.4631792162
     :           7058d+1*t188*t249*t250*t251*t80-1.73158960813529d+1*t15
     ;           6*t249*t250*t251*t80-6.21814d-2*(t536+t535+t534+t533+t5
     <           32+t531+t530+t529+t528+t527+t519+t507+t492+t489)*t62*t7
     =           8+2.747773264188437d-3*t125*t361*t78-7.327395371169166d
     >           -3*t186*t245*t78-3.663697685584583d-3*t153*t245*t78+6.5
     ?           38889093261955d-1*t135*t136*t137*t151*t160*t69-3.269444
     @           5466309774d-1*t135*t136*t137*t160*t183*t64-1.6347222733
     1           154887d-1*t135*t136*t137*t147*t160*t64+1.0d+0*t127*t128
     2           *t129*t361*t62+2.0d+0*t128*t129*t186*t247*t62+1.0d+0*t1
     3           28*t129*t153*t247*t62-4.0d+0*t129*t186*t235*t240*t62-2.
     4           0d+0*t129*t153*t235*t240*t62+3.216395899738507d+1*t186*
     5           t235*t236*t237*t62+1.6081979498692536d+1*t153*t235*t236
     6           *t237*t62+t524+t523+t522+t521+t506+t505+t504+t503+t502+
     7           t498+t496+t494+t493+t474+t472+t471+t470+t469+t468+t467+
     8           t466+t465+t464+t463+t462+t461+t460+t459+t457+t456+t455+
     9           t454+t453+t452+t451+t450+t449+t448+t446+t441+t440+t439+
     :           t438+t437+t436+t435+t434+t433+5.381456786199792d-2*t125
     ;           *t131*t132*t133*t188-1.767585332069357d-1*t125*t127*t12
     <           8*t129*t186+2.690728393099896d-2*t125*t131*t132*t133*t1
     =           56-8.837926660346784d-2*t125*t127*t128*t129*t153)+4.784
     >           6374908957684d-1*t147*t151*t65*t86*t89+9.56927498179153
     ?           7d-1*t149*t183*t64*t86*t89+1.0164931956593973d-2*t160*t
     @           183*t64*t89+7.694644203726144d+0*t135*t136*t137*t183*t6
     1           4*t65*t86-1.8175185709928465d-3*t125*t188*t84-2.3392894
     2           49053859d+0*t131*t132*t133*t188*t80+1.099109305675375d-
     3           2*t125*t186*t78+4.0d+0*t127*t128*t129*t186*t62+t501+t50
     4           0+t499+t430+t429+t428+t427+t426+t425+t424+t423+t422+t42
     5           1+t420+t419+t418+t417+t416+t415+t414+t371+t370+t367+t36
     6           5+t362+t351+t321+t301+t300+t297+t293+t263+t253+t239)+1.
     7           0d+0*t122*t372+1.0d+0*t163*t347+2.0d+0*t180*t322+2.0d+0
     8           *t191*t311)+(-3.04966d-3*t106*t347*t91-3.04966d-3*t104*
     9           t106*t372-6.09932d-3*t106*t180*t191)*t97-8.132426666666
     :           666d-52*t164*t343*t97+6.09932d-52*t177*t323*t97+t121*t1
     ;           77*(-1.86008522312d-54*t106*t180*t91+6.09932d-52*t324-1
     <           .86008522312d-54*t104*t106*t191)+4.9602272616533327d-54
     =           *t104*t106*t121*t343*t91-1.7017882504620416d-105*t104*t
     >           106*t226*t342*t91+1.86008522312d-103*t121*t164*t342)*wg
     ?           ht+Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (t93*(1.0d+0*t91*(-6.5185185185185
     1           18d-49*t546*t97*t98*t99+5.963779555555554d-51*t121*t546
     2           *t95*t98*t99-4.4642045354879994d-102*t226*t545*t95*t98*
     3           t99+6.807153001848166d-154*t413*t544*t95*t98*t99+6.5059
     4           41333333333d-100*t121*t545*t98*t99-1.1160511338719999d-
     5           151*t226*t544*t98*t99+2.981889777777777d-51*t103*t546*t
     6           97*t99-6.518518518518518d-49*t100*t546*t97*t99-1.488068
     7           1784959998d-102*t103*t121*t545*t99+6.505941333333333d-1
     8           00*t100*t121*t545*t99+1.7017882504620416d-154*t103*t226
     9           *t544*t99-1.1160511338719999d-151*t100*t226*t544*t99-3.
     :           259259259259259d-49*t546*t95*t97*t98-3.555555555555555d
     ;           -98*t545*t97*t98+3.2529706666666663d-100*t121*t545*t95*
     <           t98-5.580255669359999d-152*t226*t544*t95*t98+8.13242666
     =           6666666d-150*t121*t544*t98-1.3037037037037036d-48*t546*
     >           t94*t95*t97+2.981889777777777d-51*t102*t546*t95*t97-7.1
     ?           1111111111111d-98*t545*t94*t97+1.6264853333333332d-100*
     @           t103*t545*t97+3.2529706666666663d-100*t102*t545*t97-1.7
     1           777777777777776d-98*t100*t545*t97+5.963779555555554d-51
     2           *t121*t546*t94*t96-4.4642045354879994d-102*t226*t545*t9
     3           4*t96+6.807153001848166d-154*t413*t544*t94*t96+1.301188
     4           2666666666d-99*t121*t545*t94*t95-2.2321022677439997d-15
     5           1*t226*t544*t94*t95-1.4880681784959998d-102*t102*t121*t
     6           545*t95+1.7017882504620416d-154*t102*t226*t544*t95+1.62
     7           64853333333332d-149*t121*t544*t94-3.259259259259259d-49
     8           *t103*t546*t93-6.518518518518518d-49*t102*t546*t93+5.96
     9           3779555555554d-51*t100*t101*t121*t546-4.464204535487999
     :           4d-102*t100*t101*t226*t545+6.807153001848166d-154*t100*
     ;           t101*t413*t544-1.8600852231199996d-152*t103*t121*t544-3
     <           .720170446239999d-152*t102*t121*t544+4.066213333333333d
     =           -150*t100*t121*t544)+1.0d+0*t104*(t60*(1.43539124726873
     >           05d+1*t151*t286*t69*t86*t89-5.980796863619711d-2*t547*t
     ?           64*t65*t86*t89+7.176956236343652d-1*t151*t356*t65*t86*t
     @           89-2.1530868709030954d+0*t183*t289*t65*t86*t89+7.176956
     1           236343652d-1*t149*t356*t64*t86*t89-3.588478118171826d+0
     2           *t183*t286*t64*t86*t89-5.741564989074922d+0*t149*t151*t
     3           183*t86*t89+2.8461809478463124d-1*t151*t302*t69*t89+7.6
     4           23698967445479d-3*t160*t356*t64*t89-7.11545236961578d-2
     5           *t183*t302*t64*t89-6.098959173956384d-2*t151*t160*t183*
     6           t89-2.3083932611178434d+1*t136*t137*t151*t267*t65*t69*t
     7           86+4.616786522235687d+1*t137*t151*t259*t264*t65*t69*t86
     8           -7.424706620043432d+2*t151*t259*t260*t261*t65*t69*t86+1
     9           .8467146088942746d+2*t135*t136*t137*t149*t151*t69*t86+5
     :           .770983152794609d+0*t135*t136*t137*t356*t64*t65*t86+5.7
     ;           70983152794609d+0*t136*t137*t183*t267*t64*t65*t86-1.154
     <           1966305589217d+1*t137*t183*t259*t264*t64*t65*t86+1.8561
     =           76655010858d+2*t183*t259*t260*t261*t64*t65*t86-4.616786
     >           522235687d+1*t135*t136*t137*t151*t183*t65*t86-4.6167865
     ?           22235687d+1*t135*t136*t137*t149*t183*t64*t86+1.97516313
     @           21680768d-2*(t554+t553+t552+t551+t550+t549+t548+1.92366
     1           1050931536d+0*t547+t520+t491+t489)*t80*t84-1.3631389282
     2           44635d-3*t125*t364*t84+1.8175185709928465d-3*t188*t245*
     3           t84-1.7544670867903941d+0*t131*t132*t133*t364*t80-1.754
     4           4670867903941d+0*t132*t133*t188*t257*t80+3.508934173580
     5           7883d+0*t133*t188*t249*t254*t80-5.19476882440587d+1*t18
     6           8*t249*t250*t251*t80-6.21814d-2*(t554+t553+t552+t551+t5
     7           50+t549+t548+t520+t491+t489)*t62*t78+8.243319792565312d
     8           -3*t125*t361*t78-1.099109305675375d-2*t186*t245*t78+1.9
     9           616667279785865d+0*t135*t136*t137*t151*t160*t69-4.90416
     :           6819946466d-1*t135*t136*t137*t160*t183*t64+3.0d+0*t127*
     ;           t128*t129*t361*t62+3.0d+0*t128*t129*t186*t247*t62-6.0d+
     <           0*t129*t186*t235*t240*t62+4.824593849607761d+1*t186*t23
     =           5*t236*t237*t62+t525+t497+t496+t495+t494+t493+t474+t473
     >           +t472+t471+t470+t469+t468+t467+t466+t465+t464+t463+t462
     ?           +t461+t460+t459+t457+t456+t455+t454+t453+t452+t451+t450
     @           +t449+t448+t446+t441+t440+t439+t438+t437+t436+t435+t434
     1           +t433+8.072185179299687d-2*t125*t131*t132*t133*t188-2.6
     2           513779981040353d-1*t125*t127*t128*t129*t186)-5.74156498
     3           9074922d+0*t149*t151*t69*t86*t89-1.794239059085913d-1*t
     4           356*t64*t65*t86*t89+1.4353912472687305d+0*t151*t183*t65
     5           *t86*t89+1.4353912472687305d+0*t149*t183*t64*t86*t89-6.
     6           098959173956384d-2*t151*t160*t69*t89+1.524739793489096d
     7           -2*t160*t183*t64*t89-4.616786522235687d+1*t135*t136*t13
     8           7*t151*t65*t69*t86+1.1541966305589217d+1*t135*t136*t137
     9           *t183*t64*t65*t86+5.92548939650423d-2*t364*t80*t84-2.72
     :           627785648927d-3*t125*t188*t84-3.5089341735807883d+0*t13
     ;           1*t132*t133*t188*t80-1.865442d-1*t361*t62*t78+1.6486639
     <           585130625d-2*t125*t186*t78+6.0d+0*t127*t128*t129*t186*t
     =           62-rhob*t541+t431+t430+t429+t428+t427+t426+t425+t424+t4
     >           23+t422+t421+t420+t419+t418+t417+t416+t415+t414-3.0d+0*
     ?           t171*t173*t25*t338+6.0d+0*t171*t25*t335*t337-9.64918769
     @           9215522d+1*t25*t334*t335*t336-3.3306690738754696d-16*t1
     1           65*t170*t29*t333+1.2202564577405706d-18*t28*t331+5.2841
     2           59572535705d-3*t24*t331+6.661338147750939d-16*t165*t29*
     3           t327*t329-5.356375176299456d-15*t29*t326*t327*t328+2.54
     4           9392377400174d-1*t167*t171*t172*t173+2.943620900479655d
     5           -17*t165*t167*t169*t170)+3.0d+0*t180*t372+3.0d+0*t191*t
     6           347)+t177*(3.04966d-52*t347*t91+6.09932d-52*t373+3.0496
     7           6d-52*t104*t372+6.09932d-52*t180*t191)*t97+t343*(-8.132
     8           426666666666d-52*t180*t91-8.132426666666666d-52*t104*t1
     9           91)*t97+2.981889777777777d-51*t104*t546*t91*t97-2.66666
     :           66666666666d+0*t343*t374*t97+t121*t342*(1.86008522312d-
     ;           103*t180*t91+6.09932d-52*t374+1.86008522312d-103*t104*t
     <           191)-1.4880681784959998d-102*t104*t121*t545*t91+1.70178
     =           82504620416d-154*t104*t226*t544*t91+t4*(5.0d-1*rhob*t30
     >           *(-6.518518518518518d-49*t546*t6*t7*t9-6.51851851851851
     ?           8d-49*t15*t546*t7*t9+5.036415999999999d-51*t13*t546*t7*
     @           t9+1.0988544d-99*t175*t545*t6*t9-3.1837877729279995d-15
     1           1*t340*t544*t6*t9+1.50176768d-99*t15*t175*t545*t9-4.245
     2           0503639039994d-102*t13*t175*t545*t9-8.277848209612798d-
     3           151*t15*t340*t544*t9+8.199654381909687d-154*t13*t340*t5
     4           44*t9+1.31194470110555d-202*t15*t542*t543*t9-1.77777777
     5           77777776d-98*t545*t6*t7-4.8592592592592593d-98*t15*t545
     6           *t7+7.508838399999999d-100*t14*t545*t7+2.74713599999999
     7           95d-100*t13*t545*t7-1.2325925925925926d-97*t11*t545*t7+
     8           1.0072832d-50*t10*t175*t546*t6-1.2735151091711996d-101*
     9           t10*t340*t545*t6+3.279861752763875d-153*t10*t542*t544*t
     :           6+6.86784d-150*t175*t544*t6-6.518518518518518d-49*t14*t
     ;           4*t546-3.259259259259259d-49*t13*t4*t546+3.571276799999
     <           9995d-149*t15*t175*t544-2.7592827365375994d-151*t14*t17
     =           5*t544-5.30631295488d-152*t13*t175*t544+1.314962432d-14
     >           8*t11*t175*t544-6.367575545855999d-201*t15*t340*t543+3.
     ?           2798617527638746d-203*t14*t340*t543-4.58465439301632d-2
     @           00*t11*t340*t543+5.2477788044222d-252*t11*t542/rhob**1.
     1           1333333333333334d+1)+5.0d-1*rhob*t16*t541+1.5d+0*t30*t3
     2           44+1.5d+0*rhob*t174*t344+1.5d+0*rhob*t178*t339+1.5d+0*t
     3           16*t339+3.0d+0*t174*t178)-2.6666666666666666d+0*t343*t3
     4           46*t7+t177*(1.030176d-51*t345-4.2923999999999995d-52*t1
     5           78*t30-4.2923999999999995d-52*t16*t174)*t7+t1*(2.57544d
     6           -52*t30*t344+2.57544d-52*t16*t339+5.15088d-52*t174*t178
     7           )*t7-1.6666666666666669d+0*t177*t325*t7+t175*t342*(1.03
     8           0176d-51*t346-1.1497011402239997d-102*t16*t30)+4.099827
     9           1909548434d-154*t16*t30*t340*t341+t175*t176*(1.030176d-
     :           51*t325+2.6531564774399996d-103*t178*t30+2.653156477439
     ;           9996d-103*t16*t174))*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t93*(1.0d+0*t91*(-7.440340892480
     1           001d-4*t100*t106*t226*t55*t99*taua-3.252970666666667d-1
     2           *t100*t108*t121*t99*taua+2.6666666666666666d+1*t108*t97
     3           *t98*taua-3.7201704462400004d-4*t106*t226*t55*t95*t98*t
     4           aua-1.6264853333333334d-1*t108*t121*t95*t98*taua+4.0662
     5           13333333334d-2*t106*t121*t55*t98*taua-1.084323555555555
     6           7d-1*gammaaa*t121*t376*t98*taua-8.132426666666668d-2*t1
     7           03*t108*t97*taua-1.2400568154133336d-4*t103*t106*t121*t
     8           55*taua+9.777777777777779d+0*t206*t97*t98*t99-6.8071530
     9           01848167d-7*t202*t413*t48*t95*t98*t99+5.580255669360001
     :           d-5*t207*t226*t48*t95*t98*t99-2.976136356992001d-4*t105
     ;           *t106*t226*t95*t98*t99-5.963779555555556d-2*t121*t206*t
     <           95*t98*t99+5.580255669360001d-5*t202*t226*t48*t98*t99-6
     =           .09932d-3*t121*t207*t48*t98*t99-2.976136356992d-4*gamma
     >           aa*t106*t108*t226*t98*t99-1.4638368d-1*gammaaa*t121*t20
     ?           8*t98*t99+3.2529706666666663d-2*t105*t106*t121*t98*t99-
     @           2.981889777777778d-2*t103*t206*t97*t99-1.70178825046204
     1           19d-7*t103*t202*t226*t48*t99+1.86008522312d-5*t103*t121
     2           *t207*t48*t99-9.920454523306665d-5*t103*t105*t106*t121*
     3           t99+1.9555555555555557d+1*t206*t94*t95*t97-2.9818897777
     4           77778d-2*t102*t206*t95*t97+48*gammaaa*t208*t94*t97-3.04
     5           966d-3*t102*t207*t48*t97-7.319184d-2*gammaaa*t102*t208*
     6           t97+1.6264853333333332d-2*t102*t105*t106*t97-6.80715300
     7           1848167d-7*t202*t413*t48*t94*t96+5.580255669360001d-5*t
     8           207*t226*t48*t94*t96-2.976136356992001d-4*t105*t106*t22
     9           6*t94*t96-5.963779555555556d-2*t121*t206*t94*t96+1.1160
     :           511338720001d-4*t202*t226*t48*t94*t95-1.219864d-2*t121*
     ;           t207*t48*t94*t95-5.952272713984d-4*gammaaa*t106*t108*t2
     <           26*t94*t95-2.9276736d-1*gammaaa*t121*t208*t94*t95+6.505
     =           941333333333d-2*t105*t106*t121*t94*t95-1.70178825046204
     >           19d-7*t102*t202*t226*t48*t95+1.86008522312d-5*t102*t121
     ?           *t207*t48*t95-9.920454523306665d-5*t102*t105*t106*t121*
     @           t95-8.674588444444443d-2*t121*t54*t556*t94+6.5059413333
     1           33333d-2*gammaaa*t106*t108*t121*t94+9.777777777777779d+
     2           0*t102*t206*t93-6.807153001848167d-7*t100*t101*t202*t41
     3           3*t48+5.580255669360001d-5*t100*t101*t207*t226*t48+1.86
     4           008522312d-5*t102*t121*t202*t48-2.976136356992001d-4*t1
     5           00*t101*t105*t106*t226-5.963779555555556d-2*t100*t101*t
     6           121*t206-1.3554044444444446d-1*t100*t121*t193*t199-9.92
     7           0454523306665d-5*gammaaa*t102*t106*t108*t121)+2.0d+0*t1
     8           63*t380+1.0d+0*t195*t308)+t53*(1.0d+0*rhoa*t44*t47*(-2.
     9           122525181952d-3*t106*t205*t55*t57*t6*taua-5.494272d-1*t
     :           107*t108*t57*t6*taua+2.6666666666666666d+1*t108*t15*t56
     ;           *taua-1.373568d-1*t108*t13*t56*taua+6.867840000000001d-
     <           2*t106*t107*t15*t55*taua-3.53754196992d-4*t106*t107*t13
     =           *t55*taua-4.57856d-1*gammaaa*t107*t15*t376*taua-1.06126
     >           2590976d-3*gammaaa*t106*t15*t193*t205*taua-3.2798617527
     ?           638757d-6*t202*t404*t48*t58*t6+1.591893886464d-4*t205*t
     @           207*t48*t58*t6-1.0072832000000001d-1*t107*t206*t58*t6-8
     1           .490100727808d-4*t105*t106*t205*t58*t6-2.28928000000000
     2           02d-1*t107*t193*t199*t6+9.777777777777779d+0*t15*t206*t
     3           56*t57-5.036416d-2*t13*t206*t56*t57-3.2798617527638757d
     4           -6*gammaaa*t15*t202*t404*t55*t57+1.591893886464d-4*gamm
     5           aaa*t15*t205*t207*t55*t57-1.030176d-2*t107*t15*t207*t48
     6           *t57+5.30631295488d-5*t107*t13*t207*t48*t57+1.591893886
     7           464d-4*t15*t202*t205*t48*t57-8.199654381909689d-7*t13*t
     8           202*t205*t48*t57-3.4797056000000004d-1*gammaaa*t107*t15
     9           *t208*t57-1.6980201455616d-3*gammaaa*t106*t108*t15*t205
     :           *t57+5.494272d-2*t105*t106*t107*t15*t57-2.830033575936d
     ;           -4*t105*t106*t107*t13*t57-5.15088d-3*t14*t207*t48*t56-1
     <           .7398528000000002d-1*gammaaa*t14*t208*t56+6.75555555555
     =           5556d+1*gammaaa*t11*t208*t56+2.747136d-2*t105*t106*t14*
     >           t56-7.4172672d-1*t107*t11*t54*t556+5.30631295488d-5*gam
     ?           maaa*t107*t14*t207*t55-2.060352d-2*gammaaa*t107*t11*t20
     @           7*t55-8.199654381909689d-7*gammaaa*t14*t202*t205*t55+3.
     1           183787772928d-4*gammaaa*t11*t202*t205*t55-3.27986175276
     2           38757d-6*t11*t193*t202*t404*t54-2.5470302183424004d-3*t
     3           106*t11*t205*t376*t54+1.591893886464d-4*t11*t193*t205*t
     4           207*t54+9.777777777777779d+0*t14*t206*t53+5.30631295488
     5           d-5*t107*t14*t202*t48-5.660067151872d-4*gammaaa*t106*t1
     6           07*t108*t14+2.1977088d-1*gammaaa*t106*t107*t108*t11)-1.
     7           25d-1*t119*t45*t46*t59+1.25d-1*t203*t44*t46*t59-1.25d-1
     8           *t223*t46*t59+2.0d+0*t377*t44*t47+2.0d+0*rhoa*t119*t377
     9           *t47+1.0d+0*rhoa*t194*t223*t47+2.0d+0*t119*t194*t47+1.2
     :           5d-1*gammaaa*t377*t44*t45*t46-1.25d-1*t109*t44*t45*t46+
     ;           1.25d-1*gammaaa*t119*t194*t45*t46-1.25d-1*t209*t44*t46+
     <           1.25d-1*gammaaa*t194*t203*t44*t46-2.5d-1*t109*t119*t46)
     =           +(-3.04966d-3*t106*t380*t91-3.04966d-3*t195*t207*t91-2.
     >           981889777777778d-2*t104*t206*t91+8.132426666666667d-3*t
     ?           105*t122*t91-3.04966d-3*t106*t381-3.04966d-3*t106*t163*
     @           t195+8.132426666666667d-3*t105*t164+8.132426666666667d-
     1           3*t104*t105*t163)*t97-3.04966d-3*t309*t48*t97-1.7017882
     2           504620419d-7*t104*t202*t226*t48*t91+1.86008522312d-5*t1
     3           21*t195*t202*t91-9.920454523306665d-5*t104*t105*t106*t1
     4           21*t91+t56*(1.373568d-2*t119*t47*t48*t59-3.662848000000
     5           001d-2*t105*t44*t47*t59+6.4386d-4*t106*t44*t45*t46*t59+
     6           6.4386d-4*t207*t44*t46*t59+6.4386d-4*t106*t119*t46*t59+
     7           1.373568d-2*t109*t44*t47*t48-5.15088d-3*rhoa*t106*t377*
     8           t44*t47-5.15088d-3*rhoa*t194*t207*t44*t47-5.15088d-3*t1
     9           06*t194*t44*t47-5.15088d-3*rhoa*t106*t119*t194*t47+6.43
     :           86d-4*t106*t109*t44*t46-5.15088d-3*t106*t378+1.373568d-
     ;           2*t105*t120)+t107*t48*(-2.830033575936d-4*t106*t44*t47*
     <           t59-1.030176d-2*t225)+t45*t46*t56*(-1.28772d-3*t106*t44
     =           *t59-1.28772d-3*gammaaa*t106*t194*t44)+t45*t46*t53*(1.2
     >           5d-1*t119*t59+1.25d-1*gammaaa*t377*t44+1.25d-1*t109*t44
     ?           +1.25d-1*gammaaa*t119*t194)+4.07778d-3*gammaaa*t206*t44
     @           *t46*t56*t59-8.199654381909689d-7*t202*t205*t44*t47*t50
     1           *t59-6.6328911936d-6*t107*t202*t44*t46*t59+1.3265782387
     2           2d-5*gammaaa*t105*t106*t107*t44*t46*t59-5.15088d-3*t224
     3           *t48*t56-5.15088d-3*t105*t204*t46*t56+t203*t46*t53*t555
     4           -6.09932d-3*t121*t310*t48+5.30631295488d-5*rhoa*t107*t1
     5           94*t202*t44*t47)*wght+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = (t93*(1.0d+0*t91*(3.7201704462400
     1           004d-53*t100*t177*t226*t55*t99*taua+1.8600852231200002d
     2           -53*t177*t226*t55*t95*t98*taua-3.388511111111111d-51*t1
     3           21*t177*t55*t98*taua+6.200284077066668d-54*t103*t121*t1
     4           77*t55*taua-1.3554044444444444d-51*t100*t121*t177*t55*t
     5           aua+6.807153001848167d-56*t106*t177*t413*t48*t95*t98*t9
     6           9+1.4880681784959998d-53*t105*t177*t226*t95*t98*t99-9.3
     7           004261156d-54*t106*t177*t226*t48*t98*t99+1.488068178495
     8           9998d-53*gammaaa*t108*t177*t226*t98*t99-2.7108088888888
     9           887d-51*t105*t121*t177*t98*t99+1.7017882504620419d-56*t
     :           103*t106*t177*t226*t48*t99-3.7201704462400004d-54*t100*
     ;           t106*t177*t226*t48*t99+4.9602272616533327d-54*t103*t105
     <           *t121*t177*t99-1.0843235555555555d-51*t100*t105*t121*t1
     =           77*t99+8.888888888888888d-50*t105*t177*t97*t98-1.860085
     >           2231200002d-54*t106*t177*t226*t48*t95*t98-5.42161777777
     ?           7777d-52*t105*t121*t177*t95*t98+2.0331066666666667d-52*
     @           t106*t121*t177*t48*t98-5.421617777777777d-52*gammaaa*t1
     1           08*t121*t177*t98+3.555555555555555d-49*t105*t177*t94*t9
     2           7-2.7108088888888887d-52*t103*t105*t177*t97-1.355404444
     3           4444444d-51*t102*t105*t177*t97+6.807153001848167d-56*t1
     4           06*t177*t413*t48*t94*t96+1.4880681784959998d-53*t105*t1
     5           77*t226*t94*t96-1.8600852231200002d-53*t106*t177*t226*t
     6           48*t94*t95+2.9761363569919996d-53*gammaaa*t108*t177*t22
     7           6*t94*t95-5.421617777777777d-51*t105*t121*t177*t94*t95+
     8           1.7017882504620419d-56*t102*t106*t177*t226*t48*t95+4.96
     9           02272616533327d-54*t102*t105*t121*t177*t95+8.1324266666
     :           66667d-52*t106*t121*t177*t48*t94-5.421617777777777d-51*
     ;           gammaaa*t108*t121*t177*t94+6.807153001848167d-56*t100*t
     <           101*t106*t177*t413*t48-6.200284077066667d-55*t103*t106*
     =           t121*t177*t48-3.1001420385333334d-54*t102*t106*t121*t17
     >           7*t48+1.4880681784959998d-53*t100*t101*t105*t177*t226+4
     ?           .9602272616533327d-54*gammaaa*t102*t108*t121*t177)+1.0d
     @           +0*t163*t382+1.0d+0*t191*t380+1.0d+0*t195*t322)+(-3.049
     1           66d-3*t106*t382*t91+8.132426666666667d-3*t105*t180*t91-
     2           3.04966d-3*t106*t191*t195+8.132426666666667d-3*t104*t10
     3           5*t191)*t97-3.04966d-3*t323*t48*t97+3.04966d-52*t177*t3
     4           81*t97+1.7017882504620419d-56*t104*t106*t177*t226*t48*t
     5           91-1.86008522312d-54*t106*t121*t177*t195*t91+4.96022726
     6           16533327d-54*t104*t105*t121*t177*t91-6.09932d-3*t121*t3
     7           24*t48-1.86008522312d-54*t121*t164*t177*t48)*wght+Cmat3
     8           (iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = (t93*(1.0d+0*t91*(-6.807153001848
     1           166d-105*t342*t413*t48*t95*t98*t99+1.4880681784959998d-
     2           53*t226*t343*t48*t95*t98*t99-2.7108088888888887d-51*t12
     3           1*t343*t48*t98*t99+1.302059656184d-102*t226*t342*t48*t9
     4           8*t99+4.9602272616533327d-54*t103*t121*t343*t48*t99-1.0
     5           843235555555554d-51*t100*t121*t343*t48*t99-1.7017882504
     6           620419d-105*t103*t226*t342*t48*t99+7.440340892480001d-1
     7           03*t100*t226*t342*t48*t99+8.888888888888888d-50*t343*t4
     8           8*t97*t98-5.421617777777777d-52*t121*t343*t48*t95*t98+3
     9           .7201704462400004d-103*t226*t342*t48*t95*t98-6.77702222
     :           2222223d-101*t121*t342*t48*t98+3.555555555555555d-49*t3
     ;           43*t48*t94*t97-2.7108088888888887d-52*t103*t343*t48*t97
     <           -1.3554044444444444d-51*t102*t343*t48*t97-6.80715300184
     =           8166d-105*t342*t413*t48*t94*t96+1.4880681784959998d-53*
     >           t226*t343*t48*t94*t96-5.421617777777777d-51*t121*t343*t
     ?           48*t94*t95+2.604119312368d-102*t226*t342*t48*t94*t95+4.
     @           9602272616533327d-54*t102*t121*t343*t48*t95-1.701788250
     1           4620419d-105*t102*t226*t342*t48*t95-2.168647111111111d-
     2           100*t121*t342*t48*t94-6.807153001848166d-105*t100*t101*
     3           t342*t413*t48+1.4880681784959998d-53*t100*t101*t226*t34
     4           3*t48+1.2400568154133333d-103*t103*t121*t342*t48+4.3401
     5           98853946667d-103*t102*t121*t342*t48-1.3554044444444444d
     6           -101*t100*t121*t342*t48)+2.0d+0*t191*t382+1.0d+0*t195*t
     7           372)+t177*(3.04966d-52*t382*t91+3.04966d-52*t383+3.0496
     8           6d-52*t191*t195)*t97-8.132426666666666d-52*t195*t343*t9
     9           1*t97-3.04966d-3*t373*t48*t97+4.9602272616533327d-54*t1
     :           04*t121*t343*t48*t91-1.7017882504620419d-105*t104*t226*
     ;           t342*t48*t91+1.86008522312d-103*t121*t195*t342*t91-6.09
     <           932d-3*t121*t177*t374*t48)*wght+Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t93*(1.0d+0*t91*(-3.72017044624
     1           00004d-4*t100*t193*t226*t99*taua-1.8600852231200002d-4*
     2           t193*t226*t95*t98*taua+4.066213333333334d-2*t121*t193*t
     3           98*taua-6.200284077066668d-5*t103*t121*t193*taua-6.8071
     4           53001848167d-7*t106*t413*t55*t95*t98*t99-2.976136356992
     5           001d-4*t108*t226*t95*t98*t99+1.1160511338720001d-4*t106
     6           *t226*t55*t98*t99-1.488068178496d-4*gammaaa*t226*t376*t
     7           98*t99+6.505941333333333d-2*t108*t121*t98*t99-1.7017882
     8           504620419d-7*t103*t106*t226*t55*t99-9.920454523306665d-
     9           5*t103*t108*t121*t99-1.0666666666666666d+1*t108*t94*t97
     :           +3.2529706666666663d-2*t102*t108*t97-6.807153001848167d
     ;           -7*t106*t413*t55*t94*t96-2.976136356992001d-4*t108*t226
     <           *t94*t96+2.2321022677440003d-4*t106*t226*t55*t94*t95-2.
     =           976136356992d-4*gammaaa*t226*t376*t94*t95+1.30118826666
     >           66666d-1*t108*t121*t94*t95-1.7017882504620419d-7*t102*t
     ?           106*t226*t55*t95-9.920454523306665d-5*t102*t108*t121*t9
     @           5-1.219864d-2*t106*t121*t55*t94+6.505941333333333d-2*ga
     1           mmaaa*t121*t376*t94-6.807153001848167d-7*t100*t101*t106
     2           *t413*t55+3.72017044624d-5*t102*t106*t121*t55-4.9602272
     3           616533327d-5*gammaaa*t102*t121*t376-2.976136356992001d-
     4           4*t100*t101*t108*t226)+1.0d+0*t163*t386)+t53*(1.0d+0*rh
     5           oa*t44*t47*(-1.061262590976d-3*t193*t205*t57*t6*taua-5.
     6           30631295488d-4*gammaaa*t15*t205*t384*taua+6.86784000000
     7           0001d-2*t107*t15*t193*taua-1.76877098496d-4*t107*t13*t1
     8           93*taua-3.2798617527638757d-6*t106*t404*t55*t58*t6-8.49
     9           0100727808d-4*t108*t205*t58*t6+3.183787772928d-4*t106*t
     :           15*t205*t55*t57-8.199654381909689d-7*t106*t13*t205*t55*
     ;           t57-3.2798617527638757d-6*gammaaa*t106*t15*t193*t404*t5
     <           7-1.2735151091712002d-3*gammaaa*t15*t205*t376*t57+1.098
     =           8544d-1*t107*t108*t15*t57-2.830033575936d-4*t107*t108*t
     >           13*t57+5.494272d-2*t108*t14*t56-1.0666666666666666d+1*t
     ?           108*t11*t56+1.061262590976d-4*t106*t107*t14*t55-2.06035
     @           2d-2*t106*t107*t11*t55-3.2798617527638757d-6*t106*t11*t
     1           384*t404*t54-1.6980201455616d-3*t11*t205*t54/rhoa**1.16
     2           66666666666665d+1-4.245050363904d-4*gammaaa*t107*t14*t3
     3           76+3.2965632d-1*gammaaa*t107*t11*t376-8.199654381909689
     4           d-7*gammaaa*t106*t14*t193*t205+6.367575545856d-4*gammaa
     5           a*t106*t11*t193*t205)+1.0d+0*t385*t44*t47+1.0d+0*rhoa*t
     6           119*t385*t47-2.5d-1*t194*t44*t45*t46-2.5d-1*t377*t44*t4
     7           6-2.5d-1*t119*t194*t46)-3.04966d-3*t106*t386*t91*t97+1.
     8           6264853333333332d-2*t105*t195*t91*t97-6.09932d-3*t381*t
     9           48*t97-1.7017882504620419d-7*t104*t106*t226*t55*t91+3.7
     :           2017044624d-5*t106*t121*t195*t48*t91-9.920454523306665d
     ;           -5*t104*t108*t121*t91+t107*t55*(-1.415016787968d-4*t44*
     <           t47*t59-1.030176d-2*t379)+t48*t56*(-1.7169600000000002d
     =           -3*t44*t45*t46*t59+t558+2.747136d-2*t194*t44*t47)+t105*
     >           t46*t56*(-2.3608200000000001d-3*t44*t59-6.4386d-4*gamma
     ?           aa*t194*t44-5.15088d-3*t375)-1.32657823872d-5*t106*t107
     @           *t44*t46*t48*t59-8.199654381909689d-7*t106*t197*t205*t4
     1           4*t47*t59+6.6328911936d-6*gammaaa*t107*t108*t44*t46*t59
     2           -5.15088d-3*rhoa*t106*t385*t44*t47*t56+1.28772d-3*t106*
     3           t194*t44*t46*t56+t45*t46*t53*t557+1.86008522312d-5*t121
     4           *t164*t55+1.061262590976d-4*t106*t107*t194*t44*t47*t50)
     5           *wght+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = (t93*(1.0d+0*t91*(6.807153001848
     1           169d-56*t177*t413*t55*t95*t98*t99-1.488068178496d-53*t1
     2           77*t226*t55*t98*t99+1.7017882504620419d-56*t103*t177*t2
     3           26*t55*t99-3.7201704462400004d-54*t100*t177*t226*t55*t9
     4           9-1.8600852231200002d-54*t177*t226*t55*t95*t98+4.066213
     5           3333333333d-52*t121*t177*t55*t98+6.807153001848169d-56*
     6           t177*t413*t55*t94*t96-2.976136356992d-53*t177*t226*t55*
     7           t94*t95+1.7017882504620419d-56*t102*t177*t226*t55*t95+2
     8           .8463493333333334d-51*t121*t177*t55*t94+6.8071530018481
     9           69d-56*t100*t101*t177*t413*t55-6.200284077066667d-55*t1
     :           03*t121*t177*t55-4.960227261653333d-54*t102*t121*t177*t
     ;           55)+1.0d+0*t191*t386)+3.04966d-52*t177*t386*t91*t97-6.0
     <           9932d-3*t383*t48*t97+1.7017882504620419d-56*t104*t177*t
     =           226*t55*t91-3.72017044624d-54*t121*t177*t195*t48*t91+1.
     >           86008522312d-5*t121*t192*t55)*wght+Cmat3(iq,D3_RB_GAA_G
     ?           AA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = (1.0d+0*t91*t93*(-6.80715300184
     1           8167d-7*t193*t413*t95*t98*t99+1.6740767008080004d-4*t19
     2           3*t226*t98*t99-1.7017882504620419d-7*t103*t193*t226*t99
     3           -6.807153001848167d-7*t193*t413*t94*t96+3.3481534016160
     4           01d-4*t193*t226*t94*t95-1.7017882504620419d-7*t102*t193
     5           *t226*t95-3.6595920000000004d-2*t121*t193*t94-6.8071530
     6           01848167d-7*t100*t101*t193*t413+5.580255669359999d-5*t1
     7           02*t121*t193)-9.148980000000001d-3*t386*t48*t91*t97+5.5
     8           80255669359999d-5*t121*t195*t55*t91-1.7017882504620419d
     9           -7*t104*t193*t226*t91+1.0d+0*rhoa*t44*t47*t53*(-3.27986
     :           17527638757d-6*t193*t404*t58*t6-3.2798617527638757d-6*g
     ;           ammaaa*t15*t384*t404*t57+4.7756816593920004d-4*t15*t193
     <           *t205*t57-8.199654381909689d-7*t13*t193*t205*t57-3.2798
     =           617527638757d-6*t11*t404*t54/rhoa**1.3333333333333333d+
     >           1-8.199654381909689d-7*gammaaa*t14*t205*t384+9.55136331
     ?           8784001d-4*gammaaa*t11*t205*t384+1.591893886464d-4*t107
     @           *t14*t193-6.181056d-2*t107*t11*t193)-1.9898673580800003
     1           d-5*t107*t44*t46*t55*t59-8.199654381909689d-7*t196*t205
     2           *t44*t47*t59-1.545264d-2*t385*t44*t47*t50*t56+3.86316d-
     3           3*t194*t44*t46*t48*t56-3.75d-1*t385*t44*t46*t53+1.59189
     4           3886464d-4*t107*t194*t197*t44*t47)*wght+Cmat3(iq,D3_GAA
     5           _GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = (t93*(1.0d+0*t91*(-4.8794560000000
     1           01d-1*t100*t121*t55*t99*taua-1.4880681784960004d-3*t100
     2           *t106*t197*t226*t99*taua-2.4397280000000005d-1*t121*t55
     3           *t95*t98*taua-7.440340892480001d-4*t106*t197*t226*t95*t
     4           98*taua-2.1686471111111114d-1*gammaaa*t121*t193*t98*tau
     5           a-1.2198640000000002d-1*t103*t55*t97*taua+8.0d+1*t100*t
     6           55*t97*taua-2.4801136308266672d-4*t103*t106*t121*t197*t
     7           aua+1.6264853333333334d-1*t100*t106*t121*t197*taua-1.36
     8           14306003696336d-6*t202*t413*t50*t95*t98*t99+1.116051133
     9           8720001d-4*t207*t226*t50*t95*t98*t99-3.7201704462400004
     :           d-4*t106*t226*t48*t95*t98*t99-5.421617777777779d-2*t105
     ;           *t121*t95*t98*t99-5.952272713984d-4*gammaaa*t106*t226*t
     <           55*t98*t99-2.2770794666666666d-1*gammaaa*t108*t121*t98*
     =           t99-2.710808888888889d-2*t103*t105*t97*t99+1.7777777777
     >           777778d+1*t100*t105*t97*t99-3.4035765009240837d-7*t103*
     ?           t202*t226*t50*t99+2.2321022677440003d-4*t100*t202*t226*
     @           t50*t99+3.72017044624d-5*t103*t121*t207*t50*t99-2.43972
     1           8d-2*t100*t121*t207*t50*t99-1.2400568154133333d-4*t103*
     2           t106*t121*t48*t99+8.132426666666668d-2*t100*t106*t121*t
     3           48*t99+8.88888888888889d+0*t105*t95*t97*t98+3.733333333
     4           3333335d+1*gammaaa*t108*t97*t98+1.1160511338720001d-4*t
     5           202*t226*t50*t95*t98-1.219864d-2*t121*t207*t50*t95*t98+
     6           4.066213333333334d-2*t106*t121*t48*t95*t98+6.5059413333
     7           33333d-2*gammaaa*t106*t121*t55*t98-2.710808888888889d-2
     8           *t102*t105*t95*t97-6.09932d-3*t103*t207*t50*t97+2.03310
     9           6666666667d-2*t103*t106*t48*t97-1.1385397333333333d-1*g
     :           ammaaa*t102*t108*t97-1.3614306003696336d-6*t202*t413*t5
     ;           0*t94*t96+1.1160511338720001d-4*t207*t226*t50*t94*t96-3
     <           .7201704462400004d-4*t106*t226*t48*t94*t96-5.4216177777
     =           77779d-2*t105*t121*t94*t96-1.1904545427968d-3*gammaaa*t
     >           106*t226*t55*t94*t95-4.554158933333333d-1*gammaaa*t108*
     ?           t121*t94*t95-3.4035765009240837d-7*t102*t202*t226*t50*t
     @           95+3.72017044624d-5*t102*t121*t207*t50*t95-1.2400568154
     1           133333d-4*t102*t106*t121*t48*t95-1.7349176888888887d-1*
     2           t121*t376*t54*t94+8.88888888888889d+0*t103*t105*t93-1.9
     3           84090904661333d-4*gammaaa*t102*t106*t121*t55-1.36143060
     4           03696336d-6*t100*t101*t202*t413*t50+1.1160511338720001d
     5           -4*t100*t101*t207*t226*t50+3.72017044624d-5*t103*t121*t
     6           202*t50-3.7201704462400004d-4*t100*t101*t106*t226*t48-2
     7           .710808888888889d-1*t100*t121*t196*t199-5.4216177777777
     8           79d-2*t100*t101*t105*t121)+2.0d+0*t163*t389+1.0d+0*t201
     9           *t308)+t53*(1.0d+0*rhoa*t44*t47*(-8.241408000000001d-1*
     :           t107*t55*t57*t6*taua-4.245050363904d-3*t106*t197*t205*t
     ;           57*t6*taua+8.0d+1*t55*t56*t6*taua+2.747136d-1*t106*t107
     <           *t197*t6*taua-2.0603520000000003d-1*t13*t55*t56*taua-2.
     =           122525181952d-3*gammaaa*t106*t15*t196*t205*taua-7.07508
     >           393984d-4*t106*t107*t13*t197*taua-7.783552d-1*gammaaa*t
     ?           107*t15*t193*taua-6.559723505527751d-6*t202*t404*t50*t5
     @           8*t6+3.183787772928d-4*t205*t207*t50*t58*t6-1.061262590
     1           9760003d-3*t106*t205*t48*t58*t6-9.157120000000001d-2*t1
     2           05*t107*t58*t6+1.7777777777777778d+1*t105*t56*t57*t6-4.
     3           120704d-2*t107*t207*t50*t57*t6+6.367575545856d-4*t202*t
     4           205*t50*t57*t6+1.373568d-1*t106*t107*t48*t57*t6-4.57856
     5           00000000004d-1*t107*t196*t199*t6-4.5785600000000004d-2*
     6           t105*t13*t56*t57-2.7592827365376d-3*gammaaa*t106*t15*t2
     7           05*t55*t57+1.061262590976d-4*t107*t13*t207*t50*t57-1.63
     8           99308763819376d-6*t13*t202*t205*t50*t57-3.5375419699200
     9           006d-4*t106*t107*t13*t48*t57-6.559723505527751d-6*gamma
     :           aa*t15*t197*t202*t404*t57+3.183787772928d-4*gammaaa*t15
     ;           *t197*t205*t207*t57-4.7617024d-1*gammaaa*t107*t108*t15*
     <           t57-1.030176d-2*t13*t207*t50*t56+3.4339200000000003d-2*
     =           t106*t13*t48*t56+4.622222222222223d+1*gammaaa*t108*t15*
     >           t56-2.3808512d-1*gammaaa*t108*t14*t56+1.7856384d-1*gamm
     ?           aaa*t106*t107*t15*t55-9.197609121792001d-4*gammaaa*t106
     @           *t107*t14*t55-6.559723505527751d-6*t11*t196*t202*t404*t
     1           54-1.1537971200000001d+0*t107*t11*t376*t54+3.1837877729
     2           28d-4*t11*t196*t205*t207*t54-4.4573028820992006d-3*t106
     3           *t11*t193*t205*t54+8.88888888888889d+0*t105*t13*t53+1.0
     4           61262590976d-4*t107*t13*t202*t50-2.060352d-2*gammaaa*t1
     5           07*t15*t197*t207+1.061262590976d-4*gammaaa*t107*t14*t19
     6           7*t207+3.183787772928d-4*gammaaa*t15*t197*t202*t205-1.6
     7           399308763819376d-6*gammaaa*t14*t197*t202*t205)+1.25d-1*
     8           gammaaa*t119*t200*t45*t59-1.25d-1*gammaaa*t200*t203*t44
     9           *t59+1.25d-1*gammaaa*t200*t223*t59+2.0d+0*t387*t44*t47+
     :           2.0d+0*rhoa*t119*t387*t47+1.0d+0*rhoa*t198*t223*t47+2.0
     ;           d+0*t119*t198*t47+1.25d-1*gammaaa*t387*t44*t45*t46+1.25
     <           d-1*gammaaa*t119*t198*t45*t46+1.25d-1*gammaaa*t198*t203
     =           *t44*t46+1.25d-1*gammaaa*t109*t200*t44*t45+1.25d-1*gamm
     >           aaa*t200*t209*t44+2.5d-1*gammaaa*t109*t119*t200)+(1.016
     ?           5533333333335d-2*t122*t48*t91-3.04966d-3*t106*t389*t91-
     @           3.04966d-3*t201*t207*t91-2.710808888888889d-2*t104*t105
     1           *t91+1.0165533333333335d-2*t164*t48+1.0165533333333335d
     2           -2*t104*t163*t48-3.04966d-3*t106*t390-3.04966d-3*t106*t
     3           163*t201)*t97-6.09932d-3*t309*t50*t97-3.403576500924083
     4           7d-7*t104*t202*t226*t50*t91-1.2400568154133333d-4*t104*
     5           t106*t121*t48*t91+1.86008522312d-5*t121*t201*t202*t91+t
     6           56*(1.7169600000000002d-2*t119*t47*t50*t59-2.8616d-2*t4
     7           4*t47*t48*t59-6.4386d-4*gammaaa*t106*t200*t44*t45*t59-6
     8           .4386d-4*gammaaa*t200*t207*t44*t59-6.4386d-4*gammaaa*t1
     9           06*t119*t200*t59+1.7169600000000002d-2*t109*t44*t47*t50
     :           +1.7169600000000002d-2*t120*t48-5.15088d-3*rhoa*t106*t3
     ;           87*t44*t47-5.15088d-3*rhoa*t198*t207*t44*t47-5.15088d-3
     <           *t106*t198*t44*t47-5.15088d-3*rhoa*t106*t119*t198*t47-6
     =           .4386d-4*gammaaa*t106*t109*t200*t44-5.15088d-3*t106*t38
     >           8)+t107*t50*(-3.5375419699200006d-4*t106*t44*t47*t59-2.
     ?           060352d-2*t225)+t200*t45*t53*(-1.25d-1*gammaaa*t119*t59
     @           -1.25d-1*gammaaa*t109*t44)+5.58012d-3*gammaaa*t105*t44*
     1           t46*t56*t59+1.28772d-3*gammaaa*t106*t200*t44*t45*t56*t5
     2           9+1.25d-1*gammaaa*t200*t203*t44*t53*t59+2.65315647744d-
     3           5*gammaaa*t106*t107*t44*t46*t48*t59-1.6399308763819376d
     4           -6*t202*t205*t31*t44*t47*t59+6.6328911936d-6*gammaaa*t1
     5           07*t200*t202*t44*t59-1.030176d-2*t224*t50*t56-1.030176d
     6           -2*t204*t46*t48*t56-1.28772d-3*gammaaa*t106*t198*t44*t4
     7           5*t46*t56+(1.25d-1*gammaaa*t387*t44+1.25d-1*gammaaa*t11
     8           9*t198)*t45*t46*t53-1.25d-1*gammaaa*t198*t203*t44*t46*t
     9           53-1.219864d-2*t121*t310*t50+5.30631295488d-5*rhoa*t107
     :           *t198*t202*t44*t47)*wght+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = (t93*(1.0d+0*t91*(7.44034089248000
     1           1d-53*t100*t177*t197*t226*t99*taua+3.7201704462400004d-
     2           53*t177*t197*t226*t95*t98*taua-2.7108088888888887d-51*t
     3           121*t177*t197*t98*taua+1.2400568154133336d-53*t103*t121
     4           *t177*t197*taua-1.0843235555555557d-50*t100*t121*t177*t
     5           197*taua+1.3614306003696333d-55*t106*t177*t413*t50*t95*
     6           t98*t99+1.8600852231200002d-53*t177*t226*t48*t95*t98*t9
     7           9+2.9761363569919996d-53*gammaaa*t177*t226*t55*t98*t99-
     8           7.440340892480001d-54*t106*t177*t226*t50*t98*t99-1.3554
     9           044444444446d-51*t121*t177*t48*t98*t99+3.40357650092408
     :           37d-56*t103*t106*t177*t226*t50*t99-2.976136356992d-53*t
     ;           100*t106*t177*t226*t50*t99+6.200284077066667d-54*t103*t
     <           121*t177*t48*t99-5.421617777777779d-51*t100*t121*t177*t
     =           48*t99+2.222222222222222d-49*t177*t48*t97*t98-1.4880681
     >           78496d-53*t106*t177*t226*t50*t95*t98-2.710808888888889d
     ?           -51*t121*t177*t48*t95*t98-4.3372942222222216d-51*gammaa
     @           a*t121*t177*t55*t98+8.132426666666667d-52*t106*t121*t17
     1           7*t50*t98-1.3554044444444446d-51*t103*t177*t48*t97-6.77
     2           7022222222223d-52*t102*t177*t48*t97+2.222222222222222d-
     3           49*t100*t177*t48*t97+1.3614306003696333d-55*t106*t177*t
     4           413*t50*t94*t96+1.8600852231200002d-53*t177*t226*t48*t9
     5           4*t96+5.952272713983999d-53*gammaaa*t177*t226*t55*t94*t
     6           95-1.488068178496d-53*t106*t177*t226*t50*t94*t95-2.7108
     7           08888888889d-51*t121*t177*t48*t94*t95+3.403576500924083
     8           7d-56*t102*t106*t177*t226*t50*t95+6.200284077066667d-54
     9           *t102*t121*t177*t48*t95-4.3372942222222216d-51*gammaaa*
     :           t121*t177*t55*t94+9.920454523306665d-54*gammaaa*t102*t1
     ;           21*t177*t55+1.3614306003696333d-55*t100*t101*t106*t177*
     <           t413*t50-4.960227261653333d-54*t103*t106*t121*t177*t50-
     =           2.4801136308266666d-54*t102*t106*t121*t177*t50+8.132426
     >           666666667d-52*t100*t106*t121*t177*t50+1.860085223120000
     ?           2d-53*t100*t101*t177*t226*t48)+1.0d+0*t163*t391+1.0d+0*
     @           t191*t389+1.0d+0*t201*t322)+(1.0165533333333335d-2*t180
     1           *t48*t91-3.04966d-3*t106*t391*t91+1.0165533333333335d-2
     2           *t104*t191*t48-3.04966d-3*t106*t191*t201)*t97-6.09932d-
     3           3*t323*t50*t97+3.04966d-52*t177*t390*t97+3.403576500924
     4           0837d-56*t104*t106*t177*t226*t50*t91+6.200284077066667d
     5           -54*t104*t121*t177*t48*t91-1.86008522312d-54*t106*t121*
     6           t177*t201*t91-1.219864d-2*t121*t324*t50-3.72017044624d-
     7           54*t121*t164*t177*t50)*wght+Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = (t93*(1.0d+0*t91*(-1.3614306003696
     1           333d-104*t342*t413*t50*t95*t98*t99+2.9761363569919996d-
     2           53*t226*t343*t50*t95*t98*t99-2.1686471111111108d-51*t12
     3           1*t343*t50*t98*t99+1.488068178496d-102*t226*t342*t50*t9
     4           8*t99+9.920454523306665d-54*t103*t121*t343*t50*t99-8.67
     5           4588444444443d-51*t100*t121*t343*t50*t99-3.403576500924
     6           0837d-105*t103*t226*t342*t50*t99+3.72017044624d-102*t10
     7           0*t226*t342*t50*t99+3.555555555555555d-49*t343*t50*t97*
     8           t98-4.3372942222222216d-51*t121*t343*t50*t95*t98+1.8600
     9           8522312d-102*t226*t342*t50*t95*t98-2.168647111111111d-1
     :           00*t121*t342*t50*t98-2.1686471111111108d-51*t103*t343*t
     ;           50*t97-1.0843235555555554d-51*t102*t343*t50*t97+3.55555
     <           5555555555d-49*t100*t343*t50*t97-1.3614306003696333d-10
     =           4*t342*t413*t50*t94*t96+2.9761363569919996d-53*t226*t34
     >           3*t50*t94*t96-4.3372942222222216d-51*t121*t343*t50*t94*
     ?           t95+2.976136356992d-102*t226*t342*t50*t94*t95+9.9204545
     @           23306665d-54*t102*t121*t343*t50*t95-3.4035765009240837d
     1           -105*t102*t226*t342*t50*t95-1.0843235555555555d-100*t12
     2           1*t342*t50*t94-1.3614306003696333d-104*t100*t101*t342*t
     3           413*t50+2.9761363569919996d-53*t100*t101*t226*t343*t50+
     4           6.200284077066666d-103*t103*t121*t342*t50+4.96022726165
     5           3333d-103*t102*t121*t342*t50-1.8975662222222223d-100*t1
     6           00*t121*t342*t50)+2.0d+0*t191*t391+1.0d+0*t201*t372)+t1
     7           77*(3.04966d-52*t391*t91+3.04966d-52*t392+3.04966d-52*t
     8           191*t201)*t97-8.132426666666666d-52*t201*t343*t91*t97-6
     9           .09932d-3*t373*t50*t97+9.920454523306665d-54*t104*t121*
     :           t343*t50*t91-3.4035765009240837d-105*t104*t226*t342*t50
     ;           *t91+1.86008522312d-103*t121*t201*t342*t91-1.219864d-2*
     <           t121*t177*t374*t50)*wght+Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (t93*(1.0d+0*t91*(-7.440340892480
     1           001d-4*t100*t196*t226*t99*taua-3.7201704462400004d-4*t1
     2           96*t226*t95*t98*taua+4.066213333333334d-2*t121*t196*t98
     3           *taua-1.2400568154133336d-4*t103*t121*t196*taua+8.13242
     4           6666666668d-2*t100*t121*t196*taua-4.836221580112d-4*t22
     5           6*t55*t95*t98*t99-1.3614306003696336d-6*t106*t197*t413*
     6           t95*t98*t99+5.286077333333333d-2*t121*t55*t98*t99+1.116
     7           0511338720001d-4*t106*t197*t226*t98*t99-2.976136356992d
     8           -4*gammaaa*t193*t226*t98*t99-1.6120738600373333d-4*t103
     9           *t121*t55*t99+1.0572154666666667d-1*t100*t121*t55*t99-3
     :           .4035765009240837d-7*t103*t106*t197*t226*t99+2.23210226
     ;           77440003d-4*t100*t106*t197*t226*t99-8.666666666666666d+
     <           0*t55*t97*t98+5.286077333333333d-2*t121*t55*t95*t98+1.1
     =           160511338720001d-4*t106*t197*t226*t95*t98-1.219864d-2*t
     >           106*t121*t197*t98+3.2529706666666663d-2*gammaaa*t121*t1
     ?           93*t98+2.6430386666666666d-2*t103*t55*t97+2.64303866666
     @           66666d-2*t102*t55*t97-4.836221580112d-4*t226*t55*t94*t9
     1           6-1.3614306003696336d-6*t106*t197*t413*t94*t96+1.057215
     2           4666666667d-1*t121*t55*t94*t95+2.2321022677440003d-4*t1
     3           06*t197*t226*t94*t95-5.952272713984d-4*gammaaa*t193*t22
     4           6*t94*t95-1.6120738600373333d-4*t102*t121*t55*t95-3.403
     5           5765009240837d-7*t102*t106*t197*t226*t95+6.505941333333
     6           333d-2*gammaaa*t121*t193*t94-4.836221580112d-4*t100*t10
     7           1*t226*t55-1.3614306003696336d-6*t100*t101*t106*t197*t4
     8           13+3.72017044624d-5*t103*t106*t121*t197+3.72017044624d-
     9           5*t102*t106*t121*t197-9.920454523306665d-5*gammaaa*t102
     :           *t121*t193)+1.0d+0*t163*t396)+t53*(1.0d+0*rhoa*t44*t47*
     ;           (-2.122525181952d-3*t196*t205*t57*t6*taua+1.373568d-1*t
     <           107*t196*t6*taua-1.061262590976d-3*gammaaa*t15*t205*t39
     =           3*taua+6.867840000000001d-2*t107*t15*t196*taua-3.537541
     >           96992d-4*t107*t13*t196*taua-1.3796413682688d-3*t205*t55
     ?           *t58*t6-6.559723505527751d-6*t106*t197*t404*t58*t6+1.78
     @           56384d-1*t107*t55*t57*t6+6.367575545856d-4*t106*t197*t2
     1           05*t57*t6+8.928192d-2*t107*t15*t55*t57-4.59880456089600
     2           04d-4*t107*t13*t55*t57-6.559723505527751d-6*gammaaa*t10
     3           6*t15*t196*t404*t57+3.183787772928d-4*t106*t15*t197*t20
     4           5*t57-1.6399308763819376d-6*t106*t13*t197*t205*t57-2.22
     5           86514410496003d-3*gammaaa*t15*t193*t205*t57-8.666666666
     6           666666d+0*t15*t55*t56+4.464096d-2*t14*t55*t56+4.464096d
     7           -2*t13*t55*t56-6.559723505527751d-6*t106*t11*t393*t404*
     8           t54-3.0776615138304003d-3*t11*t205*t384*t54+3.183787772
     9           928d-4*gammaaa*t106*t15*t196*t205-1.6399308763819376d-6
     :           *gammaaa*t106*t14*t196*t205+6.367575545856d-4*gammaaa*t
     ;           106*t11*t196*t205-2.060352d-2*t106*t107*t15*t197+1.0612
     <           62590976d-4*t106*t107*t14*t197+1.061262590976d-4*t106*t
     =           107*t13*t197+1.4422464000000002d-1*gammaaa*t107*t15*t19
     >           3-7.428838136832d-4*gammaaa*t107*t14*t193+2.88449280000
     ?           00003d-1*gammaaa*t107*t11*t193)+1.25d-1*t200*t44*t45*t5
     @           9+1.25d-1*t119*t200*t59+1.0d+0*t394*t44*t47+1.0d+0*rhoa
     1           *t119*t394*t47-1.25d-1*t198*t44*t45*t46-1.25d-1*t387*t4
     2           4*t46-1.25d-1*t119*t198*t46+1.25d-1*gammaaa*t194*t200*t
     3           44*t45+1.25d-1*gammaaa*t200*t377*t44+1.25d-1*t109*t200*
     4           t44+1.25d-1*gammaaa*t119*t194*t200)+t48*(1.016553333333
     5           3335d-2*t195*t91-3.04966d-3*t390)*t97-3.04966d-3*t106*t
     6           396*t91*t97+8.132426666666667d-3*t105*t201*t91*t97-6.09
     7           932d-3*t381*t50*t97-1.6120738600373333d-4*t104*t121*t55
     8           *t91+3.72017044624d-5*t106*t121*t195*t50*t91+1.86008522
     9           312d-5*t106*t121*t201*t48*t91-3.4035765009240837d-7*t10
     :           4*t106*t197*t226*t91+t107*t197*(-1.7687709849600003d-4*
     ;           t44*t47*t59-2.060352d-2*t379)+t48*t56*(1.71696000000000
     <           02d-3*gammaaa*t200*t44*t45*t59+1.373568d-2*t198*t44*t47
     =           -5.15088d-3*t388)+t200*t56*(-6.4386d-4*t106*t44*t59-6.4
     >           386d-4*gammaaa*t106*t194*t44)+t46*t48*t56*(t559-2.1462d
     ?           -3*t44*t59)+6.4386d-4*gammaaa*t105*t200*t44*t56*t59+1.3
     @           2657823872d-5*gammaaa*t107*t44*t46*t55*t59-1.3265782387
     1           2d-5*t106*t107*t44*t46*t50*t59+6.6328911936d-6*gammaaa*
     2           t106*t107*t200*t44*t48*t59-1.6399308763819376d-6*t106*t
     3           205*t395*t44*t47*t59+t50*(t558+1.7169600000000002d-2*t1
     4           94*t44*t47)*t56-5.15088d-3*rhoa*t106*t394*t44*t47*t56+6
     5           .4386d-4*t106*t198*t44*t46*t56-6.4386d-4*gammaaa*t105*t
     6           198*t44*t46*t56+t200*t45*t53*t555+(1.25d-1*gammaaa*t394
     7           *t44+1.25d-1*t198*t44)*t45*t46*t53+5.30631295488d-5*t10
     8           6*t107*t198*t44*t47*t50+1.061262590976d-4*t106*t107*t19
     9           4*t31*t44*t47+3.72017044624d-5*t121*t164*t197)*wght+Mma
     :           t3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = (t93*(1.0d+0*t91*(1.3614306003696
     1           34d-55*t177*t197*t413*t95*t98*t99-1.8600852231200002d-5
     2           3*t177*t197*t226*t98*t99+3.4035765009240837d-56*t103*t1
     3           77*t197*t226*t99-2.976136356992d-53*t100*t177*t197*t226
     4           *t99-1.488068178496d-53*t177*t197*t226*t95*t98+2.439728
     5           d-51*t121*t177*t197*t98+1.361430600369634d-55*t177*t197
     6           *t413*t94*t96-3.7201704462400004d-53*t177*t197*t226*t94
     7           *t95+3.4035765009240837d-56*t102*t177*t197*t226*t95+1.6
     8           264853333333334d-51*t121*t177*t197*t94+1.36143060036963
     9           4d-55*t100*t101*t177*t197*t413-4.960227261653333d-54*t1
     :           03*t121*t177*t197-6.200284077066667d-54*t102*t121*t177*
     ;           t197+8.132426666666667d-52*t100*t121*t177*t197)+1.0d+0*
     <           t191*t396)+3.04966d-52*t177*t396*t91*t97-6.09932d-3*t38
     =           3*t50*t97-3.04966d-3*t392*t48*t97-3.72017044624d-54*t12
     >           1*t177*t195*t50*t91-1.86008522312d-54*t121*t177*t201*t4
     ?           8*t91+3.4035765009240837d-56*t104*t177*t197*t226*t91+3.
     @           72017044624d-5*t121*t192*t197)*wght+Mmat3(iq,D3_RB_GAA_
     1           TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = (1.0d+0*t91*t93*(-1.36143060036963
     1           36d-6*t196*t413*t95*t98*t99+2.2321022677440003d-4*t196*
     2           t226*t98*t99-3.4035765009240837d-7*t103*t196*t226*t99+2
     3           .2321022677440003d-4*t100*t196*t226*t99+1.1160511338720
     4           001d-4*t196*t226*t95*t98-2.439728d-2*t121*t196*t98-1.36
     5           14306003696336d-6*t196*t413*t94*t96+4.4642045354880006d
     6           -4*t196*t226*t94*t95-3.4035765009240837d-7*t102*t196*t2
     7           26*t95-2.439728d-2*t121*t196*t94-1.3614306003696336d-6*
     8           t100*t101*t196*t413+3.72017044624d-5*t103*t121*t196+7.4
     9           4034089248d-5*t102*t121*t196)-6.09932d-3*t386*t50*t91*t
     :           97-6.09932d-3*t396*t48*t91*t97+1.86008522312d-5*t121*t2
     ;           01*t55*t91-3.4035765009240837d-7*t104*t196*t226*t91+7.4
     <           4034089248d-5*t121*t195*t197*t91+1.0d+0*rhoa*t44*t47*t5
     =           3*(-6.559723505527751d-6*t196*t404*t58*t6+6.36757554585
     >           6d-4*t196*t205*t57*t6-6.559723505527751d-6*gammaaa*t15*
     ?           t393*t404*t57+6.367575545856d-4*t15*t196*t205*t57-1.639
     @           9308763819376d-6*t13*t196*t205*t57-6.559723505527751d-6
     1           *t11*t404*t54/rhoa**1.2333333333333334d+1+3.18378777292
     2           8d-4*gammaaa*t15*t205*t393-1.6399308763819376d-6*gammaa
     3           a*t14*t205*t393+1.2735151091712002d-3*gammaaa*t11*t205*
     4           t393-4.120704d-2*t107*t15*t196+2.122525181952d-4*t107*t
     5           14*t196+1.061262590976d-4*t107*t13*t196-4.120704d-2*t10
     6           7*t11*t196)+6.6328911936d-6*gammaaa*t107*t200*t44*t55*t
     7           59-1.6399308763819376d-6*t205*t398*t44*t47*t59-2.653156
     8           47744d-5*t107*t197*t44*t46*t59+t200*t48*t56*(t561+t560)
     9           -1.030176d-2*t394*t44*t47*t50*t56+2.57544d-3*t194*t44*t
     :           46*t50*t56+1.28772d-3*t198*t44*t46*t48*t56-1.030176d-2*
     ;           t31*t385*t44*t47*t56+t200*t53*t557-2.5d-1*t394*t44*t46*
     <           t53+2.122525181952d-4*t107*t194*t395*t44*t47+5.30631295
     =           488d-5*t107*t197*t198*t44*t47)*wght+Mmat3(iq,D3_RA_TA_T
     >           A)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = (1.0d+0*t91*t93*(-2.722861200739
     1           267d-6*t398*t413*t95*t98*t99+2.2321022677440003d-4*t226
     2           *t398*t98*t99-6.807153001848167d-7*t103*t226*t398*t99+8
     3           .928409070976001d-4*t100*t226*t398*t99+4.46420453548800
     4           06d-4*t226*t398*t95*t98-4.879456d-2*t121*t398*t98-2.722
     5           861200739267d-6*t398*t413*t94*t96+4.4642045354880006d-4
     6           *t226*t398*t94*t95-6.807153001848167d-7*t102*t226*t398*
     7           t95-2.722861200739267d-6*t100*t101*t398*t413+1.48806817
     8           8496d-4*t103*t121*t398+7.44034089248d-5*t102*t121*t398-
     9           4.879456d-2*t100*t121*t398)-1.219864d-2*t396*t50*t91*t9
     :           7-3.04966d-3*t401*t48*t91*t97-6.807153001848167d-7*t104
     ;           *t226*t398*t91+7.44034089248d-5*t121*t195*t395*t91+7.44
     <           034089248d-5*t121*t197*t201*t91+1.0d+0*rhoa*t44*t47*t53
     =           *(-1.3119447011055504d-5*t398*t404*t58*t6+2.54703021834
     >           24004d-3*t205*t398*t57*t6-8.241408d-2*t107*t398*t6-1.31
     ?           19447011055504d-5*gammaaa*t15*t397*t404*t57+6.367575545
     @           856d-4*t15*t205*t398*t57-3.279861752763875d-6*t13*t205*
     1           t398*t57-1.3119447011055504d-5*t11*t404*t54/rhoa**1.133
     2           3333333333334d+1-8.241408d-2*t107*t15*t398+2.1225251819
     3           52d-4*t107*t14*t398+4.245050363904d-4*t107*t13*t398+1.2
     4           735151091712002d-3*gammaaa*t15*t205*t397-3.279861752763
     5           875d-6*gammaaa*t14*t205*t397+1.2735151091712002d-3*gamm
     6           aaa*t11*t205*t397)-3.279861752763875d-6*t205*t44*t47*t5
     7           62*t59+1.28772d-3*gammaaa*t400*t44*t48*t56*t59-2.653156
     8           47744d-5*t107*t395*t44*t46*t59+2.65315647744d-5*gammaaa
     9           *t107*t197*t200*t44*t59+t200*t50*t56*(t561+t560+t559)-5
     :           .15088d-3*t399*t44*t47*t50*t56+2.57544d-3*t198*t44*t46*
     ;           t50*t56-1.28772d-3*gammaaa*t198*t200*t44*t48*t56-2.0603
     <           52d-2*t31*t394*t44*t47*t56-1.25d-1*t399*t44*t46*t53+t20
     =           0*(2.5d-1*gammaaa*t394*t44+2.5d-1*t198*t44)*t53-2*t375*
     >           t400*t53+2.122525181952d-4*t107*t198*t395*t44*t47+2.122
     ?           525181952d-4*t107*t194*t215*t44*t47)*wght+Mmat3(iq,D3_G
     @           AB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = (7.5d-1*gammaaa*t44*t53*t59/taua*
     1           *4+1.0d+0*t91*t93*(-5.445722401478534d-6*t413*t562*t95*
     2           t98*t99-1.3614306003696336d-6*t103*t226*t562*t99+2.6785
     3           22721292801d-3*t100*t226*t562*t99+1.3392613606464004d-3
     4           *t226*t562*t95*t98-5.445722401478534d-6*t413*t562*t94*t
     5           96-1.3614306003696336d-6*t102*t226*t562*t95-5.445722401
     6           478534d-6*t100*t101*t413*t562+4.4642045354879994d-4*t10
     7           3*t121*t562-2.9276736000000003d-1*t100*t121*t562)-1.829
     8           7960000000002d-2*t401*t50*t91*t97-1.3614306003696336d-6
     9           *t104*t226*t562*t91+2.2321022677439997d-4*t121*t201*t39
     :           5*t91+1.0d+0*rhoa*t44*t47*t53*(-2.623889402211101d-5*t4
     ;           04*t562*t58*t6+7.641090655027201d-3*t205*t562*t57*t6-4.
     <           9448448d-1*t107*t562*t6-2.623889402211101d-5*gammaaa*t1
     =           5*t404*t563*t57-6.55972350552775d-6*t13*t205*t562*t57+3
     >           .8205453275136003d-3*gammaaa*t15*t205*t563-6.5597235055
     ?           2775d-6*gammaaa*t14*t205*t563+1.2735151091712002d-3*t10
     @           7*t13*t562-2.623889402211101d-5*t11*t404*t54/rhoa**1.03
     1           33333333333333d+1)+7.72632d-3*gammaaa*t400*t44*t50*t56*
     2           t59-6.55972350552775d-6*t205*t44*t47*t59/rhoa**4+7.9594
     3           69432320001d-5*gammaaa*t107*t200*t395*t44*t59-7.72632d-
     4           3*gammaaa*t198*t200*t44*t50*t56-3.090528d-2*t31*t399*t4
     5           4*t47*t56-7.5d-1*gammaaa*t198*t400*t44*t53+3.75d-1*gamm
     6           aaa*t200*t399*t44*t53+6.367575545856d-4*t107*t198*t215*
     7           t44*t47)*wght+Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 6.0d-50*t1
              t3 = 5.15088d-3*(t2-9.11559972d+0)+1.0d+0
              t4 = 1/t3
              t5 = param(7)
              t6 = param(12)
              t7 = 1/t3**2
              t8 = 2.0d-50*t1
              t9 = t8-9.11559972d+0
              t10 = t9**2
              t11 = param(10)
              t12 = 1/rhoa**3.3333333333333337d+0
              t13 = param(9)
              t14 = param(8)
              t15 = param(11)
              t16 = 4.0d-50*t1*t15*t7*t9+t13*t4*t9+t10*t6*t7+1.6d-99*t11
     1           *t12*t7+t5+4.0d-50*t1*t14*t4
              t17 = 1/rhoa**6.666666666666666d-1
              t18 = rhoa**5.0d-1
              t19 = 1/t18
              t20 = 1/rhoa**3.333333333333333d-1
              t21 = 1/rhoa**1.6666666666666666d-1
              t22 = 1.1120374863094686d+1*t21+3.8447462374472113d+0*t20+
     1           1.644733775567609d+0*t19+2.4058712912881916d-1*t17
              t23 = 3.216395899738507d+1/t22+1.0d+0
              t24 = log(t23)
              t25 = 1.274696188700087d-1*t20+1.0d+0
              t26 = 5.982550435771079d+0*t21+2.2255694211506874d+0*t20+8
     1           .004286349993635d-1*t19+1.8970043257475583d-1*t17
              t27 = 1.6081979498692536d+1/t26+1.0d+0
              t28 = log(t27)
              t29 = 1.3256889990520176d-1*t20+1.0d+0
              t30 = -6.903522198342671d-18*t28*t29-3.1090699999999993d-2
     1           *t24*t25
              t31 = 1/rhob**6.666666666666666d-1
              t32 = rhob**5.0d-1
              t33 = 1/t32
              t34 = 1/rhob**3.333333333333333d-1
              t35 = 1/rhob**1.6666666666666666d-1
              t36 = 1.1120374863094686d+1*t35+3.8447462374472113d+0*t34+
     1           1.644733775567609d+0*t33+2.4058712912881916d-1*t31
              t37 = 3.216395899738507d+1/t36+1.0d+0
              t38 = log(t37)
              t39 = 1.274696188700087d-1*t34+1.0d+0
              t40 = 5.982550435771079d+0*t35+2.2255694211506874d+0*t34+8
     1           .004286349993635d-1*t33+1.8970043257475583d-1*t31
              t41 = 1.6081979498692536d+1/t40+1.0d+0
              t42 = log(t41)
              t43 = 1.3256889990520176d-1*t34+1.0d+0
              t44 = -6.903522198342671d-18*t42*t43-3.1090699999999993d-2
     1           *t38*t39
              t45 = 1/rhob
              t46 = 1/taub
              t47 = 1.0d+0-1.25d-1*gammabb*t45*t46
              t48 = 1/rhob**2.6666666666666666d+0
              t49 = gammabb*t48
              t50 = 1/rhob**1.6666666666666669d+0
              t51 = 2.0d+0*t50*taub
              t52 = 5.15088d-3*(t51+t49-9.11559972d+0)+1.0d+0
              t53 = 1/t52
              t54 = gammabb**2
              t55 = 1/rhob**5.333333333333333d+0
              t56 = 1/t52**2
              t57 = t51-9.11559972d+0
              t58 = t57**2
              t59 = t56*t58*t6+gammabb*t15*t48*t56*t57+t13*t53*t57+t11*t
     1           54*t55*t56+gammabb*t14*t48*t53+t5
              t60 = rhob+rhoa
              t61 = 1/t60**3.333333333333333d-1
              t62 = 1.3256889990520176d-1*t61+1.0d+0
              t63 = rhoa-rhob
              t64 = t63**4
              t65 = 1/t60**4
              t66 = 1/t60
              t67 = 1.0d+0-t63*t66
              t68 = t63*t66+1.0d+0
              t69 = t68**1.3333333333333333d+0+t67**1.3333333333333333d+
     1           0-2.0d+0
              t70 = -1.923661050931536d+0*t64*t65*t69
              t71 = t70+1.0d+0
              t72 = 1/t60**6.666666666666666d-1
              t73 = t60**5.0d-1
              t74 = 1/t73
              t75 = 1/t60**1.6666666666666666d-1
              t76 = 5.982550435771079d+0*t75+8.004286349993635d-1*t74+1.
     1           8970043257475583d-1*t72+2.2255694211506874d+0*t61
              t77 = 1.6081979498692536d+1/t76+1.0d+0
              t78 = log(t77)
              t79 = -6.21814d-2*t62*t71*t78
              t80 = 6.901399211255825d-2*t61+1.0d+0
              t81 = t70+1.923661050931536d+0*t69
              t82 = 8.157414703487641d+0*t75+4.3009724712766434d-1*t74+1
     1           .9115125951273373d-1*t72+2.247591863577616d+0*t61
              t83 = 2.9608813203268075d+1/t82+1.0d+0
              t84 = log(t83)
              t85 = 1.9751631321680768d-2*t80*t81*t84
              t86 = 1.274696188700087d-1*t61+1.0d+0
              t87 = 1.1120374863094686d+1*t75+1.644733775567609d+0*t74+2
     1           .4058712912881916d-1*t72+3.8447462374472113d+0*t61
              t88 = 3.216395899738507d+1/t87+1.0d+0
              t89 = log(t88)
              t90 = -5.980796863619711d-2*t64*t65*t69*t86*t89
              t91 = t60*(t90+t85+t79)-rhob*t44-rhoa*t30
              t92 = 3.04966d-3*(t51+t49+t2-1.823119944d+1)+1.0d+0
              t93 = 1/t92
              t94 = param(4)
              t95 = t49+4.0d-50*t1
              t96 = t95**2
              t97 = 1/t92**2
              t98 = param(5)
              t99 = t8+t51-1.823119944d+1
              t100 = param(6)
              t101 = t99**2
              t102 = param(2)
              t103 = param(3)
              t104 = t95*t97*t98*t99+t103*t93*t99+t94*t96*t97+t100*t101*
     1           t97+t102*t93*t95+param(1)
              t105 = 1/t27
              t106 = 1/t18**3
              t107 = 1/rhoa**1.3333333333333333d+0
              t108 = 1/rhoa**1.1666666666666667d+0
              t109 = -9.970917392951799d-1*t108-7.418564737168958d-1*t10
     1           7-4.002143174996817d-1*t106-1.264669550498372d-1*t1
              t110 = 1/t26**2
              t111 = 1/t23
              t112 = -1.8533958105157808d+0*t108-1.2815820791490704d+0*t
     1           107-8.223668877838045d-1*t106-1.6039141941921276d-1*t1
              t113 = 1/t22**2
              t114 = 1.1102230246251565d-16*t105*t109*t110*t29+3.0506411
     1           443514264d-19*t107*t28+1.0d+0*t111*t112*t113*t25+1.3210
     2           398931339265d-3*t107*t24
              t115 = 1/t3**3
              t116 = 1/rhoa**4.333333333333333d+0
              t117 = 1/rhoa**2.6666666666666666d+0
              t118 = -6.666666666666666d-50*t117*t6*t7*t9-6.666666666666
     1           666d-50*t117*t15*t7*t9+5.15088d-52*t117*t13*t7*t9+4.120
     2           7039999999995d-101*t115*t116*t15*t9-1.3333333333333333d
     3           -99*t116*t15*t7+2.0603519999999997d-101*t116*t14*t7-5.3
     4           33333333333334d-99*t11*t116*t7+1.030176d-51*t10*t115*t1
     5           17*t6-6.666666666666666d-50*t117*t14*t4-3.3333333333333
     6           33d-50*t117*t13*t4+1.6482816d-150*t11*t115/rhoa**6
              t119 = 5.0d-1*t16*t30+5.0d-1*rhoa*t118*t30+5.0d-1*rhoa*t11
     1           4*t16
              t120 = 1/t92**3
              t121 = -6.666666666666666d-50*t117*t97*t98*t99+6.09932d-52
     1           *t117*t120*t95*t98*t99+3.04966d-52*t103*t117*t97*t99-6.
     2           666666666666666d-50*t100*t117*t97*t99-3.333333333333333
     3           d-50*t117*t95*t97*t98-1.3333333333333333d-49*t117*t94*t
     4           95*t97+3.04966d-52*t102*t117*t95*t97+6.09932d-52*t117*t
     5           120*t94*t96-3.333333333333333d-50*t103*t117*t93-6.66666
     6           6666666666d-50*t102*t117*t93+6.09932d-52*t100*t101*t117
     7           *t120
              t122 = 1/t60**1.6666666666666669d+0
              t123 = 1/t73**3
              t124 = 1/t60**1.3333333333333333d+0
              t125 = 1/t60**1.1666666666666667d+0
              t126 = -9.970917392951799d-1*t125-7.418564737168958d-1*t12
     1           4-4.002143174996817d-1*t123-1.264669550498372d-1*t122
              t127 = 1/t76**2
              t128 = 1/t77
              t129 = 1.0d+0*t126*t127*t128*t62*t71
              t130 = -1.3595691172479402d+0*t125-7.491972878592053d-1*t1
     1           24-2.1504862356383217d-1*t123-1.2743417300848914d-1*t12
     2           2
              t131 = 1/t82**2
              t132 = 1/t83
              t133 = -5.848223622634647d-1*t130*t131*t132*t80*t81
              t134 = -1.8533958105157808d+0*t125-1.2815820791490704d+0*t
     1           124-8.223668877838045d-1*t123-1.6039141941921276d-1*t12
     2           2
              t135 = 1/t87**2
              t136 = 1/t88
              t137 = 1.923661050931536d+0*t134*t135*t136*t64*t65*t69*t86
              t138 = 1/t60**2
              t139 = t138*t63
              t140 = -t66
              t141 = t140+t139
              t142 = t67**3.333333333333333d-1
              t143 = -t138*t63
              t144 = t66+t143
              t145 = t68**3.333333333333333d-1
              t146 = 1.3333333333333333d+0*t144*t145+1.3333333333333333d
     1           +0*t141*t142
              t147 = -1.923661050931536d+0*t146*t64*t65
              t148 = 1/t60**5
              t149 = 7.694644203726144d+0*t148*t64*t69
              t150 = t63**3
              t151 = -7.694644203726144d+0*t150*t65*t69
              t152 = t151+t149+t147
              t153 = -6.21814d-2*t152*t62*t78
              t154 = 2.747773264188437d-3*t124*t71*t78
              t155 = t151+t149+t147+1.923661050931536d+0*t146
              t156 = 1.9751631321680768d-2*t155*t80*t84
              t157 = -4.5437964274821163d-4*t124*t81*t84
              t158 = -5.980796863619711d-2*t146*t64*t65*t86*t89
              t159 = 1/t60**5.333333333333333d+0
              t160 = 2.541232989148493d-3*t159*t64*t69*t89
              t161 = 2.3923187454478842d-1*t148*t64*t69*t86*t89
              t162 = t90+t60*(-2.3923187454478842d-1*t150*t65*t69*t86*t8
     1           9+t161+t160+t158+t157+t156+t154+t153+t137+t133+t129)+t8
     2           5+t79+6.903522198342671d-18*t28*t29+3.1090699999999993d
     3           -2*t24*t25-rhoa*t114
              t163 = 1.0d+0*t121*t91+1.0d+0*t104*t162
              t164 = 1/rhob**3.6666666666666664d+0
              t165 = -3.3333333333333337d+0*t48*taub-2.6666666666666666d
     1           +0*gammabb*t164
              t166 = 1/t52**3
              t167 = 1/rhob**6.333333333333333d+0
              t168 = -6.666666666666667d+0*t48*t56*t57*t6*taub-3.3333333
     1           333333337d+0*gammabb*t15*t55*t56*taub-3.333333333333333
     2           7d+0*t13*t48*t53*taub-1.030176d-2*t165*t166*t58*t6-5.15
     3           088d-3*t13*t165*t56*t57-2.6666666666666666d+0*gammabb*t
     4           15*t164*t56*t57-1.030176d-2*gammabb*t15*t165*t166*t48*t
     5           57-5.333333333333333d+0*t11*t167*t54*t56-5.15088d-3*gam
     6           mabb*t14*t165*t48*t56-1.030176d-2*t11*t165*t166*t54*t55
     7           -2.6666666666666666d+0*gammabb*t14*t164*t53
              t169 = 1/t41
              t170 = 1/t32**3
              t171 = 1/rhob**1.3333333333333333d+0
              t172 = 1/rhob**1.1666666666666667d+0
              t173 = -1.264669550498372d-1*t50-9.970917392951799d-1*t172
     1           -7.418564737168958d-1*t171-4.002143174996817d-1*t170
              t174 = 1/t40**2
              t175 = 1/t37
              t176 = -1.6039141941921276d-1*t50-1.8533958105157808d+0*t1
     1           72-1.2815820791490704d+0*t171-8.223668877838045d-1*t170
              t177 = 1/t36**2
              t178 = 1.1102230246251565d-16*t169*t173*t174*t43+3.0506411
     1           443514264d-19*t171*t42+1.0d+0*t175*t176*t177*t39+1.3210
     2           398931339265d-3*t171*t38
              t179 = 1.0d+0*t44*t47*t59+1.0d+0*rhob*t178*t47*t59+1.0d+0*
     1           rhob*t168*t44*t47
              t180 = -6.666666666666667d+0*t100*t48*t97*t99*taub-3.33333
     1           33333333337d+0*t48*t95*t97*t98*taub-3.3333333333333337d
     2           +0*t103*t48*t93*taub-2.6666666666666666d+0*gammabb*t164
     3           *t97*t98*t99-6.09932d-3*t120*t165*t95*t98*t99-3.04966d-
     4           3*t103*t165*t97*t99-5.333333333333333d+0*gammabb*t164*t
     5           94*t95*t97-3.04966d-3*t102*t165*t95*t97-6.09932d-3*t120
     6           *t165*t94*t96-2.6666666666666666d+0*gammabb*t102*t164*t
     7           93-6.09932d-3*t100*t101*t120*t165
              t181 = t66+t139
              t182 = t143+t140
              t183 = 1.3333333333333333d+0*t145*t182+1.3333333333333333d
     1           +0*t142*t181
              t184 = -1.923661050931536d+0*t183*t64*t65
              t185 = 7.694644203726144d+0*t150*t65*t69
              t186 = t185+t184+t149
              t187 = -6.21814d-2*t186*t62*t78
              t188 = t185+t184+1.923661050931536d+0*t183+t149
              t189 = 1.9751631321680768d-2*t188*t80*t84
              t190 = -5.980796863619711d-2*t183*t64*t65*t86*t89
              t191 = t90+t60*(2.3923187454478842d-1*t150*t65*t69*t86*t89
     1           +t190+t189+t187+t161+t160+t157+t154+t137+t133+t129)+t85
     2           +t79+6.903522198342671d-18*t42*t43+3.1090699999999993d-
     3           2*t38*t39-rhob*t178
              t192 = 1.0d+0*t180*t91+1.0d+0*t104*t191
              t193 = 1/rhob**8
              t194 = -1.030176d-2*t166*t48*t58*t6+t15*t48*t56*t57-5.1508
     1           8d-3*t13*t48*t56*t57-1.030176d-2*gammabb*t15*t166*t55*t
     2           57-5.15088d-3*gammabb*t14*t55*t56+2*gammabb*t11*t55*t56
     3           -1.030176d-2*t11*t166*t193*t54+t14*t48*t53
              t195 = t48*t97*t98*t99-6.09932d-3*t120*t48*t95*t98*t99-3.0
     1           4966d-3*t103*t48*t97*t99+2*t48*t94*t95*t97-3.04966d-3*t
     2           102*t48*t95*t97-6.09932d-3*t120*t48*t94*t96+t102*t48*t9
     3           3-6.09932d-3*t100*t101*t120*t48
              t196 = 1/rhob**7
              t197 = 1/rhob**4.333333333333333d+0
              t198 = -2.060352d-2*t166*t50*t58*t6+4.0d+0*t50*t56*t57*t6-
     1           1.030176d-2*t13*t50*t56*t57-2.060352d-2*gammabb*t15*t16
     2           6*t197*t57+2.0d+0*gammabb*t15*t197*t56-1.030176d-2*gamm
     3           abb*t14*t197*t56-2.060352d-2*t11*t166*t196*t54+2.0d+0*t
     4           13*t50*t53
              t199 = taub**2
              t200 = 1/t199
              t201 = -1.219864d-2*t120*t50*t95*t98*t99-6.09932d-3*t103*t
     1           50*t97*t99+4.0d+0*t100*t50*t97*t99+2.0d+0*t50*t95*t97*t
     2           98-6.09932d-3*t102*t50*t95*t97-1.219864d-2*t120*t50*t94
     3           *t96+2.0d+0*t103*t50*t93-1.219864d-2*t100*t101*t120*t50
              t202 = 2.57544d-52*t118*t30+2.57544d-52*t114*t16
              t203 = 1/t27**2
              t204 = t109**2
              t205 = 1/t26**4
              t206 = 1/t26**3
              t207 = 1/t18**5
              t208 = 1/rhoa**2.3333333333333334d+0
              t209 = 1/rhoa**2.1666666666666665d+0
              t210 = 1.1632736958443765d+0*t209+9.89141964955861d-1*t208
     1           +6.003214762495226d-1*t207+2.1077825841639536d-1*t117
              t211 = 1/t23**2
              t212 = t112**2
              t213 = 1/t22**4
              t214 = 1/t22**3
              t215 = 2.1622951122684114d+0*t209+1.7087761055320938d+0*t2
     1           08+1.2335503316757068d+0*t207+2.673190323653546d-1*t117
              t216 = 1.1102230246251565d-16*t105*t110*t210*t29-2.2204460
     1           49250313d-16*t105*t204*t206*t29+1.7854583920998188d-15*
     2           t203*t204*t205*t29-4.0675215258019015d-19*t208*t28+1.0d
     3           +0*t111*t113*t215*t25-2.0d+0*t111*t212*t214*t25+3.21639
     4           5899738507d+1*t211*t212*t213*t25-1.7613865241785684d-3*
     5           t208*t24-8.497974591333913d-2*t107*t111*t112*t113-9.812
     6           069668265515d-18*t105*t107*t109*t110
              t217 = 1/t3**4
              t218 = 1/rhoa**7
              t219 = 1/rhoa**5.333333333333333d+0
              t220 = 1/rhoa**3.6666666666666664d+0
              t221 = 1.7777777777777776d-49*t220*t6*t7*t9+1.777777777777
     1           7776d-49*t15*t220*t7*t9-1.373568d-51*t13*t220*t7*t9-1.3
     2           73568d-100*t115*t219*t6*t9-2.4724223999999997d-100*t115
     3           *t15*t219*t9+5.306312954879999d-103*t115*t13*t219*t9+6.
     4           367575545855999d-152*t15*t217*t218*t9+2.222222222222222
     5           d-99*t219*t6*t7+8.0d-99*t15*t219*t7-1.2362111999999999d
     6           -100*t14*t219*t7-3.43392d-101*t13*t219*t7+2.31111111111
     7           11113d-98*t11*t219*t7-2.747136d-51*t10*t115*t220*t6+1.5
     8           918938864639998d-102*t10*t217*t219*t6+1.777777777777777
     9           6d-49*t14*t220*t4+8.888888888888888d-50*t13*t220*t4-2.7
     :           471359999999995d-150*t115*t15*t218+2.1225251819519997d-
     ;           152*t115*t14*t218-1.53839616d-149*t11*t115*t218+2.54703
     <           02183424d-201*t11*t217/rhoa**8.666666666666666d+0
              t222 = 5.0d-1*rhoa*t221*t30+1.0d+0*t118*t30+5.0d-1*rhoa*t1
     1           6*t216+1.0d+0*t114*t16+1.0d+0*rhoa*t114*t118
              t223 = 5.15088d-52*t119-4.2923999999999995d-52*t16*t30
              t224 = 1/t92**4
              t225 = 1.7777777777777776d-49*t220*t97*t98*t99+5.580255669
     1           359999d-103*t219*t224*t95*t98*t99-1.6264853333333332d-5
     2           1*t120*t220*t95*t98*t99-8.132426666666667d-101*t120*t21
     3           9*t98*t99-8.132426666666666d-52*t103*t220*t97*t99+1.777
     4           7777777777776d-49*t100*t220*t97*t99+1.86008522312d-103*
     5           t103*t120*t219*t99-8.132426666666667d-101*t100*t120*t21
     6           9*t99+8.888888888888888d-50*t220*t95*t97*t98+4.44444444
     7           4444444d-99*t219*t97*t98-4.0662133333333333d-101*t120*t
     8           219*t95*t98+3.555555555555555d-49*t220*t94*t95*t97-8.13
     9           2426666666666d-52*t102*t220*t95*t97+8.888888888888888d-
     :           99*t219*t94*t97-2.0331066666666667d-101*t103*t219*t97-4
     ;           .0662133333333333d-101*t102*t219*t97+2.222222222222222d
     <           -99*t100*t219*t97+5.580255669359999d-103*t219*t224*t94*
     =           t96-1.6264853333333332d-51*t120*t220*t94*t96-1.62648533
     >           33333334d-100*t120*t219*t94*t95+1.86008522312d-103*t102
     ?           *t120*t219*t95+8.888888888888888d-50*t103*t220*t93+1.77
     @           77777777777776d-49*t102*t220*t93+5.580255669359999d-103
     1           *t100*t101*t219*t224-1.6264853333333332d-51*t100*t101*t
     2           120*t220
              t226 = 2.0d+0*t126*t127*t128*t62*t71
              t227 = -1.1696447245269295d+0*t130*t131*t132*t80*t81
              t228 = 3.847322101863072d+0*t134*t135*t136*t64*t65*t69*t86
              t229 = 5.495546528376875d-3*t124*t71*t78
              t230 = -9.087592854964233d-4*t124*t81*t84
              t231 = 5.082465978296986d-3*t159*t64*t69*t89
              t232 = 4.7846374908957684d-1*t148*t64*t69*t86*t89
              t233 = t126**2
              t234 = 1/t76**4
              t235 = 1/t77**2
              t236 = 1.6081979498692536d+1*t233*t234*t235*t62*t71
              t237 = 2.0d+0*t126*t127*t128*t152*t62
              t238 = 1/t76**3
              t239 = -2.0d+0*t128*t233*t238*t62*t71
              t240 = -8.837926660346784d-2*t124*t126*t127*t128*t71
              t241 = 1/t60**2.6666666666666666d+0
              t242 = 1/t73**5
              t243 = 1/t60**2.3333333333333334d+0
              t244 = 1/t60**2.1666666666666665d+0
              t245 = 1.1632736958443765d+0*t244+9.89141964955861d-1*t243
     1           +6.003214762495226d-1*t242+2.1077825841639536d-1*t241
              t246 = 1.0d+0*t127*t128*t245*t62*t71
              t247 = t130**2
              t248 = 1/t82**4
              t249 = 1/t83**2
              t250 = -1.73158960813529d+1*t247*t248*t249*t80*t81
              t251 = -1.1696447245269295d+0*t130*t131*t132*t155*t80
              t252 = 1/t82**3
              t253 = 1.1696447245269295d+0*t132*t247*t252*t80*t81
              t254 = 2.690728393099896d-2*t124*t130*t131*t132*t81
              t255 = 1.5861639701225969d+0*t244+9.98929717145607d-1*t243
     1           +3.2257293534574827d-1*t242+2.1239028834748191d-1*t241
              t256 = -5.848223622634647d-1*t131*t132*t255*t80*t81
              t257 = t134**2
              t258 = 1/t87**4
              t259 = 1/t88**2
              t260 = 6.187255516702861d+1*t257*t258*t259*t64*t65*t69*t86
              t261 = 3.847322101863072d+0*t134*t135*t136*t146*t64*t65*t8
     1           6
              t262 = 1/t87**3
              t263 = -3.847322101863072d+0*t136*t257*t262*t64*t65*t69*t8
     1           6
              t264 = -1.6347222733154887d-1*t134*t135*t136*t159*t64*t69
              t265 = 2.1622951122684114d+0*t244+1.7087761055320938d+0*t2
     1           43+1.2335503316757068d+0*t242+2.673190323653546d-1*t241
              t266 = 1.923661050931536d+0*t135*t136*t265*t64*t65*t69*t86
              t267 = -1.538928840745229d+1*t134*t135*t136*t148*t64*t69*t
     1           86
              t268 = 1.538928840745229d+1*t134*t135*t136*t150*t65*t69*t8
     1           6
              t269 = t141**2
              t270 = 1/t67**6.666666666666666d-1
              t271 = 1/t60**3
              t272 = -2*t271*t63
              t273 = 2*t138
              t274 = t273+t272
              t275 = t144**2
              t276 = 1/t68**6.666666666666666d-1
              t277 = 2*t271*t63
              t278 = -2*t138
              t279 = t278+t277
              t280 = 1.3333333333333333d+0*t145*t279+4.444444444444444d-
     1           1*t275*t276+1.3333333333333333d+0*t142*t274+4.444444444
     2           444444d-1*t269*t270
              t281 = -1.923661050931536d+0*t280*t64*t65
              t282 = 1.5389288407452287d+1*t146*t148*t64
              t283 = -1.5389288407452287d+1*t146*t150*t65
              t284 = 1/t60**6
              t285 = -3.8473221018630716d+1*t284*t64*t69
              t286 = 6.155715362980915d+1*t148*t150*t69
              t287 = t63**2
              t288 = -2.3083932611178434d+1*t287*t65*t69
              t289 = t288+t286+t285+t283+t282+t281
              t290 = -6.21814d-2*t289*t62*t78
              t291 = 5.495546528376875d-3*t124*t152*t78
              t292 = -3.663697685584583d-3*t243*t71*t78
              t293 = t288+t286+t285+t283+t282+t281+1.923661050931536d+0*
     1           t280
              t294 = 1.9751631321680768d-2*t293*t80*t84
              t295 = -9.087592854964233d-4*t124*t155*t84
              t296 = 6.058395236642822d-4*t243*t81*t84
              t297 = -5.980796863619711d-2*t280*t64*t65*t86*t89
              t298 = 5.082465978296986d-3*t146*t159*t64*t89
              t299 = 4.7846374908957684d-1*t146*t148*t64*t86*t89
              t300 = 1/t60**6.333333333333333d+0
              t301 = -2.3718174565385935d-2*t300*t64*t69*t89
              t302 = 2.0329863913187946d-2*t150*t159*t69*t89
              t303 = -1.1961593727239421d+0*t284*t64*t69*t86*t89
              t304 = 1.9138549963583074d+0*t148*t150*t69*t86*t89
              t305 = -7.176956236343652d-1*t287*t65*t69*t86*t89
              t306 = t60*(-4.7846374908957684d-1*t146*t150*t65*t86*t89+t
     1           305+t304+t303+t302+t301+t299+t298+t297+t296+t295+t294+t
     2           292+t291+t290+t268+t267+t266+t264+t263+t261+t260+t256+t
     3           254+t253+t251+t250+t246+t240+t239+t237+t236)-4.78463749
     4           08957684d-1*t150*t65*t69*t86*t89-1.1961593727239421d-1*
     5           t146*t64*t65*t86*t89+3.9503262643361536d-2*t155*t80*t84
     6           -1.243628d-1*t152*t62*t78-2.220446049250313d-16*t105*t1
     7           09*t110*t29-6.101282288702853d-19*t107*t28-2.0d+0*t111*
     8           t112*t113*t25-2.642079786267853d-3*t107*t24+t232+t231+t
     9           230+t229+t228+t227+t226-rhoa*t216
              t307 = 1.0d+0*t225*t91+1.0d+0*t104*t306+2.0d+0*t121*t162
              t308 = 3.04966d-52*t121*t91+3.04966d-52*t163+3.04966d-52*t
     1           104*t162
              t309 = -4.066213333333334d-51*t100*t117*t120*t48*t99*taub+
     1           2.222222222222222d-49*t117*t48*t97*t98*taub-2.033106666
     2           666667d-51*t117*t120*t48*t95*t98*taub-1.016553333333333
     3           5d-51*t103*t117*t48*t97*taub+2.222222222222222d-49*t100
     4           *t117*t48*t97*taub-5.580255669360001d-54*t117*t165*t224
     5           *t95*t98*t99+4.0662133333333333d-52*t117*t120*t165*t98*
     6           t99-1.6264853333333332d-51*gammabb*t117*t120*t164*t98*t
     7           99-1.86008522312d-54*t103*t117*t120*t165*t99+4.06621333
     8           33333333d-52*t100*t117*t120*t165*t99+8.888888888888888d
     9           -50*gammabb*t117*t164*t97*t98+2.0331066666666667d-52*t1
     :           17*t120*t165*t95*t98+3.555555555555555d-49*gammabb*t117
     ;           *t164*t94*t97+1.0165533333333333d-52*t103*t117*t165*t97
     <           +2.0331066666666667d-52*t102*t117*t165*t97-8.1324266666
     =           66666d-52*gammabb*t102*t117*t164*t97-5.580255669360001d
     >           -54*t117*t165*t224*t94*t96+8.132426666666667d-52*t117*t
     ?           120*t165*t94*t95-3.2529706666666663d-51*gammabb*t117*t1
     @           20*t164*t94*t95-1.86008522312d-54*t102*t117*t120*t165*t
     1           95-5.580255669360001d-54*t100*t101*t117*t165*t224
              t310 = 2.6666666666666666d+0*t145*t271*t63-2.6666666666666
     1           666d+0*t142*t271*t63+4.444444444444444d-1*t144*t182*t27
     2           6+4.444444444444444d-1*t141*t181*t270
              t311 = -1.923661050931536d+0*t310*t64*t65
              t312 = 7.694644203726144d+0*t148*t183*t64
              t313 = -7.694644203726144d+0*t150*t183*t65
              t314 = 7.694644203726144d+0*t146*t148*t64
              t315 = 7.694644203726144d+0*t146*t150*t65
              t316 = 2.3083932611178434d+1*t287*t65*t69
              t317 = t316+t315+t314+t313+t312+t311+t285
              t318 = t316+t315+t314+t313+t312+t311+1.923661050931536d+0*
     1           t310+t285
              t319 = 7.176956236343652d-1*t287*t65*t69*t86*t89
              t320 = t60*(-5.980796863619711d-2*t310*t64*t65*t86*t89-2.3
     1           923187454478842d-1*t150*t183*t65*t86*t89+2.392318745447
     2           8842d-1*t146*t150*t65*t86*t89+2.3923187454478842d-1*t14
     3           8*t183*t64*t86*t89+2.3923187454478842d-1*t146*t148*t64*
     4           t86*t89+2.541232989148493d-3*t159*t183*t64*t89+2.541232
     5           989148493d-3*t146*t159*t64*t89+1.923661050931536d+0*t13
     6           4*t135*t136*t183*t64*t65*t86+1.923661050931536d+0*t134*
     7           t135*t136*t146*t64*t65*t86+1.9751631321680768d-2*t318*t
     8           80*t84-4.5437964274821163d-4*t124*t188*t84-4.5437964274
     9           821163d-4*t124*t155*t84-5.848223622634647d-1*t130*t131*
     :           t132*t188*t80-5.848223622634647d-1*t130*t131*t132*t155*
     ;           t80-6.21814d-2*t317*t62*t78+2.747773264188437d-3*t124*t
     <           186*t78+2.747773264188437d-3*t124*t152*t78+1.0d+0*t126*
     =           t127*t128*t186*t62+1.0d+0*t126*t127*t128*t152*t62+t319+
     >           t303+t301+t296+t292+t267+t266+t264+t263+t260+t256+t254+
     ?           t253+t250+t246+t240+t239+t236)+t232+t231+t230+t229+t228
     @           +t227+t226+t190+t189+t187+t158+t156+t153
              t321 = 1.0d+0*t309*t91+1.0d+0*t104*t320+1.0d+0*t121*t191+1
     1           .0d+0*t162*t180
              t322 = 3.04966d-52*t180*t91+3.04966d-52*t104*t191
              t323 = t165**2
              t324 = 1/rhob**2
              t325 = 1.25d-1*gammabb*t178*t59+1.25d-1*gammabb*t168*t44
              t326 = 1/t52**4
              t327 = 1/rhob**4.666666666666667d+0
              t328 = 8.88888888888889d+0*t164*taub+9.777777777777779d+0*
     1           gammabb*t327
              t329 = 1/rhob**7.333333333333333d+0
              t330 = 1.7777777777777778d+1*t164*t56*t57*t6*taub+1.373568
     1           d-1*t165*t166*t48*t57*t6*taub+3.4339200000000003d-2*t13
     2           *t165*t48*t56*taub+2.6666666666666666d+1*gammabb*t15*t1
     3           67*t56*taub+6.867840000000001d-2*gammabb*t15*t165*t166*
     4           t55*taub+8.88888888888889d+0*t13*t164*t53*taub-1.030176
     5           d-2*t166*t328*t58*t6+1.591893886464d-4*t323*t326*t58*t6
     6           +2.2222222222222224d+1*t199*t55*t56*t6-5.15088d-3*t13*t
     7           328*t56*t57+9.777777777777779d+0*gammabb*t15*t327*t56*t
     8           57-1.030176d-2*gammabb*t15*t166*t328*t48*t57+1.59189388
     9           6464d-4*gammabb*t15*t323*t326*t48*t57+5.30631295488d-5*
     :           t13*t166*t323*t57+5.494272d-2*gammabb*t15*t164*t165*t16
     ;           6*t57+3.377777777777778d+1*t11*t329*t54*t56-5.15088d-3*
     <           gammabb*t14*t328*t48*t56+2.747136d-2*gammabb*t14*t164*t
     =           165*t56-1.030176d-2*t11*t166*t328*t54*t55+1.59189388646
     >           4d-4*t11*t323*t326*t54*t55+1.0988544d-1*t11*t165*t166*t
     ?           167*t54+9.777777777777779d+0*gammabb*t14*t327*t53+5.306
     @           31295488d-5*gammabb*t14*t166*t323*t48
              t331 = 1/t41**2
              t332 = t173**2
              t333 = 1/t40**4
              t334 = 1/t40**3
              t335 = 1/t32**5
              t336 = 1/rhob**2.3333333333333334d+0
              t337 = 1/rhob**2.1666666666666665d+0
              t338 = 2.1077825841639536d-1*t48+1.1632736958443765d+0*t33
     1           7+9.89141964955861d-1*t336+6.003214762495226d-1*t335
              t339 = 1/t37**2
              t340 = t176**2
              t341 = 1/t36**4
              t342 = 1/t36**3
              t343 = 2.673190323653546d-1*t48+2.1622951122684114d+0*t337
     1           +1.7087761055320938d+0*t336+1.2335503316757068d+0*t335
              t344 = 1.1102230246251565d-16*t169*t174*t338*t43-2.2204460
     1           49250313d-16*t169*t332*t334*t43+1.7854583920998188d-15*
     2           t331*t332*t333*t43-4.0675215258019015d-19*t336*t42+1.0d
     3           +0*t175*t177*t343*t39-2.0d+0*t175*t340*t342*t39+3.21639
     4           5899738507d+1*t339*t340*t341*t39-1.7613865241785684d-3*
     5           t336*t38-8.497974591333913d-2*t171*t175*t176*t177-9.812
     6           069668265515d-18*t169*t171*t173*t174
              t345 = 1.0d+0*rhob*t344*t47*t59+2.0d+0*t178*t47*t59+1.25d-
     1           1*gammabb*t178*t45*t46*t59+1.25d-1*gammabb*t324*t44*t46
     2           *t59+1.0d+0*rhob*t330*t44*t47+2.0d+0*t168*t44*t47+2.0d+
     3           0*rhob*t168*t178*t47+1.25d-1*gammabb*t168*t44*t45*t46
              t346 = -5.15088d-3*rhob*t328*t44*t47*t59-5.15088d-3*t165*t
     1           44*t47*t59-5.15088d-3*rhob*t165*t178*t47*t59-5.15088d-3
     2           *rhob*t165*t168*t44*t47-5.15088d-3*t165*t179
              t347 = 1.7777777777777778d+1*t100*t164*t97*t99*taub+8.1324
     1           26666666668d-2*t100*t120*t165*t48*t99*taub+8.8888888888
     2           8889d+0*t164*t95*t97*t98*taub+1.7777777777777778d+1*gam
     3           mabb*t167*t97*t98*taub+4.066213333333334d-2*t120*t165*t
     4           48*t95*t98*taub+2.033106666666667d-2*t103*t165*t48*t97*
     5           taub+8.88888888888889d+0*t103*t164*t93*taub+9.777777777
     6           777779d+0*gammabb*t327*t97*t98*t99-6.09932d-3*t120*t328
     7           *t95*t98*t99+5.580255669360001d-5*t224*t323*t95*t98*t99
     8           +3.2529706666666663d-2*gammabb*t120*t164*t165*t98*t99-3
     9           .04966d-3*t103*t328*t97*t99+1.86008522312d-5*t103*t120*
     :           t323*t99+1.9555555555555557d+1*gammabb*t327*t94*t95*t97
     ;           -3.04966d-3*t102*t328*t95*t97+1.4222222222222222d+1*t32
     <           9*t54*t94*t97+2.2222222222222224d+1*t100*t199*t55*t97+1
     =           .6264853333333332d-2*gammabb*t102*t164*t165*t97-6.09932
     >           d-3*t120*t328*t94*t96+5.580255669360001d-5*t224*t323*t9
     ?           4*t96+6.505941333333333d-2*gammabb*t120*t164*t165*t94*t
     @           95+1.86008522312d-5*t102*t120*t323*t95+9.77777777777777
     1           9d+0*gammabb*t102*t327*t93-6.09932d-3*t100*t101*t120*t3
     2           28+5.580255669360001d-5*t100*t101*t224*t323
              t348 = 2.0d+0*t126*t127*t128*t186*t62
              t349 = -1.1696447245269295d+0*t130*t131*t132*t188*t80
              t350 = 3.847322101863072d+0*t134*t135*t136*t183*t64*t65*t8
     1           6
              t351 = -1.538928840745229d+1*t134*t135*t136*t150*t65*t69*t
     1           86
              t352 = t181**2
              t353 = t278+t272
              t354 = t182**2
              t355 = t277+t273
              t356 = 1.3333333333333333d+0*t145*t355+4.444444444444444d-
     1           1*t276*t354+1.3333333333333333d+0*t142*t353+4.444444444
     2           444444d-1*t270*t352
              t357 = -1.923661050931536d+0*t356*t64*t65
              t358 = 1.5389288407452287d+1*t148*t183*t64
              t359 = 1.5389288407452287d+1*t150*t183*t65
              t360 = -6.155715362980915d+1*t148*t150*t69
              t361 = t360+t359+t358+t357+t288+t285
              t362 = -6.21814d-2*t361*t62*t78
              t363 = 5.495546528376875d-3*t124*t186*t78
              t364 = t360+t359+t358+t357+1.923661050931536d+0*t356+t288+
     1           t285
              t365 = 1.9751631321680768d-2*t364*t80*t84
              t366 = -9.087592854964233d-4*t124*t188*t84
              t367 = -5.980796863619711d-2*t356*t64*t65*t86*t89
              t368 = 5.082465978296986d-3*t159*t183*t64*t89
              t369 = 4.7846374908957684d-1*t148*t183*t64*t86*t89
              t370 = -2.0329863913187946d-2*t150*t159*t69*t89
              t371 = -1.9138549963583074d+0*t148*t150*t69*t86*t89
              t372 = t60*(4.7846374908957684d-1*t150*t183*t65*t86*t89+t3
     1           71+t370+t369+t368+t367+t366+t365+t363+t362+t351+t350+t3
     2           49+t348+t305+t303+t301+t296+t292+t267+t266+t264+t263+t2
     3           60+t256+t254+t253+t250+t246+t240+t239+t236)+4.784637490
     4           8957684d-1*t150*t65*t69*t86*t89-1.1961593727239421d-1*t
     5           183*t64*t65*t86*t89+3.9503262643361536d-2*t188*t80*t84-
     6           1.243628d-1*t186*t62*t78-2.220446049250313d-16*t169*t17
     7           3*t174*t43-6.101282288702853d-19*t171*t42-2.0d+0*t175*t
     8           176*t177*t39-2.642079786267853d-3*t171*t38-rhob*t344+t2
     9           32+t231+t230+t229+t228+t227+t226
              t373 = 1.0d+0*t347*t91+1.0d+0*t104*t372+2.0d+0*t180*t191
              t374 = -3.04966d-3*t104*t328*t91-3.04966d-3*t165*t180*t91-
     1           3.04966d-3*t165*t192-3.04966d-3*t104*t165*t191
              t375 = -5.580255669360001d-54*t117*t224*t48*t95*t98*t99+1.
     1           0165533333333333d-51*t117*t120*t48*t98*t99-1.8600852231
     2           2d-54*t103*t117*t120*t48*t99+4.0662133333333333d-52*t10
     3           0*t117*t120*t48*t99-3.333333333333333d-50*t117*t48*t97*
     4           t98+2.0331066666666667d-52*t117*t120*t48*t95*t98-1.3333
     5           333333333333d-49*t117*t48*t94*t97+1.0165533333333333d-5
     6           2*t103*t117*t48*t97+5.082766666666666d-52*t102*t117*t48
     7           *t97-5.580255669360001d-54*t117*t224*t48*t94*t96+2.0331
     8           066666666667d-51*t117*t120*t48*t94*t95-1.86008522312d-5
     9           4*t102*t117*t120*t48*t95-5.580255669360001d-54*t100*t10
     :           1*t117*t224*t48
              t376 = 1.0d+0*t375*t91+1.0d+0*t162*t195
              t377 = 1.25d-1*t44*t59+1.25d-1*gammabb*t194*t44
              t378 = 1/rhob**9
              t379 = 6.867840000000001d-2*t166*t55*t57*t6*taub-3.3333333
     1           333333337d+0*t15*t55*t56*taub+1.7169600000000002d-2*t13
     2           *t55*t56*taub+3.4339200000000003d-2*gammabb*t15*t166*t1
     3           93*taub+1.591893886464d-4*t165*t326*t48*t58*t6+2.747136
     4           d-2*t164*t166*t58*t6-2.6666666666666666d+0*t15*t164*t56
     5           *t57+1.373568d-2*t13*t164*t56*t57+1.591893886464d-4*gam
     6           mabb*t15*t165*t326*t55*t57-1.030176d-2*t15*t165*t166*t4
     7           8*t57+5.30631295488d-5*t13*t165*t166*t48*t57+5.494272d-
     8           2*gammabb*t15*t166*t167*t57-5.15088d-3*t14*t165*t48*t56
     9           +2.747136d-2*gammabb*t14*t167*t56-1.0666666666666666d+1
     :           *gammabb*t11*t167*t56+5.30631295488d-5*gammabb*t14*t165
     ;           *t166*t55-2.060352d-2*gammabb*t11*t165*t166*t55+8.24140
     <           8d-2*t11*t166*t378*t54+1.591893886464d-4*t11*t165*t193*
     =           t326*t54-2.6666666666666666d+0*t14*t164*t53
              t380 = -1.25d-1*t44*t45*t46*t59-1.25d-1*t178*t46*t59+1.0d+
     1           0*rhob*t379*t44*t47+1.0d+0*t194*t44*t47+1.0d+0*rhob*t17
     2           8*t194*t47-1.25d-1*t168*t44*t46
              t381 = 1.373568d-2*t44*t47*t59-5.15088d-3*t179
              t382 = 4.066213333333334d-2*t100*t120*t55*t99*taub-3.33333
     1           33333333337d+0*t55*t97*t98*taub+2.033106666666667d-2*t1
     2           20*t55*t95*t98*taub+1.0165533333333335d-2*t103*t55*t97*
     3           taub-2.6666666666666666d+0*t164*t97*t98*t99+5.580255669
     4           360001d-5*t165*t224*t48*t95*t98*t99+1.6264853333333332d
     5           -2*t120*t164*t95*t98*t99-6.09932d-3*t120*t165*t48*t98*t
     6           99+1.6264853333333332d-2*gammabb*t120*t167*t98*t99+8.13
     7           2426666666667d-3*t103*t164*t97*t99+1.86008522312d-5*t10
     8           3*t120*t165*t48*t99-5.333333333333333d+0*t164*t94*t95*t
     9           97+8.132426666666667d-3*t102*t164*t95*t97-5.33333333333
     :           3333d+0*gammabb*t167*t94*t97-3.04966d-3*t102*t165*t48*t
     ;           97+8.132426666666667d-3*gammabb*t102*t167*t97+5.5802556
     <           69360001d-5*t165*t224*t48*t94*t96+1.6264853333333332d-2
     =           *t120*t164*t94*t96-1.219864d-2*t120*t165*t48*t94*t95+3.
     >           2529706666666663d-2*gammabb*t120*t167*t94*t95+1.8600852
     ?           2312d-5*t102*t120*t165*t48*t95-2.6666666666666666d+0*t1
     @           02*t164*t93+5.580255669360001d-5*t100*t101*t165*t224*t4
     1           8+1.6264853333333332d-2*t100*t101*t120*t164
              t383 = 1.0d+0*t382*t91+1.0d+0*t191*t195
              t384 = 1/rhob**1.0666666666666666d+1
              t385 = 1.591893886464d-4*t326*t55*t58*t6-2.060352d-2*t15*t
     1           166*t55*t57+5.30631295488d-5*t13*t166*t55*t57+1.5918938
     2           86464d-4*gammabb*t15*t193*t326*t57-1.030176d-2*t14*t55*
     3           t56+2*t11*t55*t56+1.591893886464d-4*t11*t326*t384*t54+5
     4           .30631295488d-5*gammabb*t14*t166*t193-4.120704d-2*gamma
     5           bb*t11*t166*t193
              t386 = 5.580255669360001d-5*t224*t55*t95*t98*t99-1.219864d
     1           -2*t120*t55*t98*t99+1.86008522312d-5*t103*t120*t55*t99+
     2           2*t55*t94*t97-6.09932d-3*t102*t55*t97+5.580255669360001
     3           d-5*t224*t55*t94*t96-2.439728d-2*t120*t55*t94*t95+1.860
     4           08522312d-5*t102*t120*t55*t95+5.580255669360001d-5*t100
     5           *t101*t224*t55
              t387 = -1.1160511338720003d-53*t117*t224*t50*t95*t98*t99+8
     1           .132426666666667d-52*t117*t120*t50*t98*t99-3.7201704462
     2           4d-54*t103*t117*t120*t50*t99+3.252970666666667d-51*t100
     3           *t117*t120*t50*t99-1.3333333333333333d-49*t117*t50*t97*
     4           t98+1.6264853333333334d-51*t117*t120*t50*t95*t98+8.1324
     5           26666666667d-52*t103*t117*t50*t97+4.0662133333333333d-5
     6           2*t102*t117*t50*t97-1.3333333333333333d-49*t100*t117*t5
     7           0*t97-1.1160511338720003d-53*t117*t224*t50*t94*t96+1.62
     8           64853333333334d-51*t117*t120*t50*t94*t95-3.72017044624d
     9           -54*t102*t117*t120*t50*t95-1.1160511338720003d-53*t100*
     :           t101*t117*t224*t50
              t388 = 1.0d+0*t387*t91+1.0d+0*t162*t201
              t389 = 1.373568d-1*t166*t197*t57*t6*taub-1.333333333333333
     1           3d+1*t197*t56*t6*taub+3.4339200000000003d-2*t13*t197*t5
     2           6*taub+6.867840000000001d-2*gammabb*t15*t166*t196*taub+
     3           3.183787772928d-4*t165*t326*t50*t58*t6+3.43392000000000
     4           03d-2*t166*t48*t58*t6-6.666666666666667d+0*t48*t56*t57*
     5           t6-4.120704d-2*t165*t166*t50*t57*t6+1.7169600000000002d
     6           -2*t13*t48*t56*t57+8.928192d-2*gammabb*t15*t166*t55*t57
     7           +1.061262590976d-4*t13*t165*t166*t50*t57+3.183787772928
     8           d-4*gammabb*t15*t165*t197*t326*t57-8.666666666666666d+0
     9           *gammabb*t15*t55*t56+4.464096d-2*gammabb*t14*t55*t56-1.
     :           030176d-2*t13*t165*t50*t56+3.183787772928d-4*t11*t165*t
     ;           196*t326*t54+1.4422464000000002d-1*t11*t166*t193*t54-3.
     <           3333333333333337d+0*t13*t48*t53-2.060352d-2*gammabb*t15
     =           *t165*t166*t197+1.061262590976d-4*gammabb*t14*t165*t166
     >           *t197
              t390 = 1.25d-1*gammabb*t200*t44*t45*t59+1.25d-1*gammabb*t1
     1           78*t200*t59+1.0d+0*rhob*t389*t44*t47+1.0d+0*t198*t44*t4
     2           7+1.0d+0*rhob*t178*t198*t47+1.25d-1*gammabb*t168*t200*t
     3           44
              t391 = 8.132426666666668d-2*t100*t120*t197*t99*taub+4.0662
     1           13333333334d-2*t120*t197*t95*t98*taub+2.033106666666667
     2           d-2*t103*t197*t97*taub-1.3333333333333333d+1*t100*t197*
     3           t97*taub+1.1160511338720001d-4*t165*t224*t50*t95*t98*t9
     4           9+2.033106666666667d-2*t120*t48*t95*t98*t99+3.252970666
     5           6666663d-2*gammabb*t120*t55*t98*t99+1.0165533333333335d
     6           -2*t103*t48*t97*t99-6.666666666666667d+0*t100*t48*t97*t
     7           99+3.72017044624d-5*t103*t120*t165*t50*t99-2.439728d-2*
     8           t100*t120*t165*t50*t99-3.3333333333333337d+0*t48*t95*t9
     9           7*t98-5.333333333333333d+0*gammabb*t55*t97*t98-1.219864
     :           d-2*t120*t165*t50*t95*t98+1.0165533333333335d-2*t102*t4
     ;           8*t95*t97+1.6264853333333332d-2*gammabb*t102*t55*t97-6.
     <           09932d-3*t103*t165*t50*t97+1.1160511338720001d-4*t165*t
     =           224*t50*t94*t96+2.033106666666667d-2*t120*t48*t94*t96+6
     >           .505941333333333d-2*gammabb*t120*t55*t94*t95+3.72017044
     ?           624d-5*t102*t120*t165*t50*t95-3.3333333333333337d+0*t10
     @           3*t48*t93+1.1160511338720001d-4*t100*t101*t165*t224*t50
     1           +2.033106666666667d-2*t100*t101*t120*t48
              t392 = 1.0d+0*t391*t91+1.0d+0*t191*t201
              t393 = 1/rhob**9.666666666666666d+0
              t394 = 3.183787772928d-4*t197*t326*t58*t6-4.120704d-2*t166
     1           *t197*t57*t6+3.183787772928d-4*gammabb*t15*t196*t326*t5
     2           7-2.060352d-2*t15*t166*t197*t57+1.061262590976d-4*t13*t
     3           166*t197*t57+2.0d+0*t15*t197*t56-1.030176d-2*t14*t197*t
     4           56-1.030176d-2*t13*t197*t56+3.183787772928d-4*t11*t326*
     5           t393*t54-2.060352d-2*gammabb*t15*t166*t196+1.0612625909
     6           76d-4*gammabb*t14*t166*t196-4.120704d-2*gammabb*t11*t16
     7           6*t196
              t395 = 1/rhob**3.3333333333333337d+0
              t396 = 1.1160511338720001d-4*t197*t224*t95*t98*t99-1.21986
     1           4d-2*t120*t197*t98*t99+3.72017044624d-5*t103*t120*t197*
     2           t99-2.439728d-2*t100*t120*t197*t99+2.0d+0*t197*t97*t98-
     3           1.219864d-2*t120*t197*t95*t98-6.09932d-3*t103*t197*t97-
     4           6.09932d-3*t102*t197*t97+1.1160511338720001d-4*t197*t22
     5           4*t94*t96-2.439728d-2*t120*t197*t94*t95+3.72017044624d-
     6           5*t102*t120*t197*t95+1.1160511338720001d-4*t100*t101*t1
     7           97*t224
              t397 = 1/rhob**8.666666666666666d+0
              t398 = 1/rhob**6
              t399 = 6.367575545856d-4*t326*t395*t58*t6-1.6482816d-1*t16
     1           6*t395*t57*t6+8.0d+0*t395*t56*t6+6.367575545856d-4*gamm
     2           abb*t15*t326*t398*t57+2.122525181952d-4*t13*t166*t395*t
     3           57-4.120704d-2*t13*t395*t56+6.367575545856d-4*t11*t326*
     4           t397*t54-8.241408d-2*gammabb*t15*t166*t398+2.1225251819
     5           52d-4*gammabb*t14*t166*t398
              t400 = 1/taub**3
              t401 = 2.2321022677440003d-4*t224*t395*t95*t98*t99+7.44034
     1           089248d-5*t103*t120*t395*t99-9.758912d-2*t100*t120*t395
     2           *t99-4.879456d-2*t120*t395*t95*t98-2.439728d-2*t103*t39
     3           5*t97+8.0d+0*t100*t395*t97+2.2321022677440003d-4*t224*t
     4           395*t94*t96+7.44034089248d-5*t102*t120*t395*t95+2.23210
     5           22677440003d-4*t100*t101*t224*t395
              t402 = t109**3
              t403 = 1/t18**7
              t404 = 1/rhoa**3.1666666666666665d+0
              t405 = t112**3
              t406 = 2.0690405167709364d+3*t25*t405/(t22**6*t23**3)-1.92
     1           98375398431045d+2*t211*t25*t405/t22**5+6.0d+0*t111*t213
     2           *t25*t405+1.1102230246251565d-16*t105*t110*t29*(-2.5204
     3           26340996149d+0*t404-1.5008036906238065d+0*t403-5.620753
     4           557770543d-1*t220-2.3079979182303428d+0*t12)+1.0d+0*t11
     5           1*t113*t25*(-4.684972743248224d+0*t404-3.08387582918926
     6           7d+0*t403-7.128507529742789d-1*t220-3.9871442462415524d
     7           +0*t12)+5.742741051503565d-14*t29*t402/(t26**6*t27**3)-
     8           1.0712750352598913d-14*t203*t29*t402/t26**5+6.661338147
     9           750939d-16*t105*t205*t29*t402-6.661338147750939d-16*t10
     :           5*t109*t206*t210*t29+5.356375176299456d-15*t109*t203*t2
     ;           05*t210*t29+9.490883560204437d-19*t12*t28-6.0d+0*t111*t
     <           112*t214*t215*t25+9.649187699215522d+1*t112*t211*t213*t
     =           215*t25+4.1099018897499934d-3*t12*t24-1.274696188700087
     >           d-1*t107*t111*t113*t215+2.549392377400174d-1*t107*t111*
     ?           t212*t214-4.0999275947472624d+0*t107*t211*t212*t213-1.4
     @           718104502398274d-17*t105*t107*t110*t210+1.6995949182667
     1           827d-1*t111*t112*t113*t208+1.962413933653103d-17*t105*t
     2           109*t110*t208+2.943620900479655d-17*t105*t107*t204*t206
     3           -2.3669625486718335d-16*t107*t203*t204*t205
              t407 = 1/t3**5
              t408 = 1/rhoa**9.666666666666666d+0
              t409 = 1/rhoa**8
              t410 = 1/rhoa**6.333333333333333d+0
              t411 = 1/rhoa**4.666666666666667d+0
              t412 = 1/t92**5
              t413 = 4.824593849607761d+1*t233*t234*t235*t62*t71
              t414 = -6.0d+0*t128*t233*t238*t62*t71
              t415 = -2.6513779981040353d-1*t124*t126*t127*t128*t71
              t416 = 3.0d+0*t127*t128*t245*t62*t71
              t417 = -5.19476882440587d+1*t247*t248*t249*t80*t81
              t418 = 3.5089341735807883d+0*t132*t247*t252*t80*t81
              t419 = 8.072185179299687d-2*t124*t130*t131*t132*t81
              t420 = -1.7544670867903941d+0*t131*t132*t255*t80*t81
              t421 = 1.856176655010858d+2*t257*t258*t259*t64*t65*t69*t86
              t422 = -1.1541966305589217d+1*t136*t257*t262*t64*t65*t69*t
     1           86
              t423 = -4.904166819946466d-1*t134*t135*t136*t159*t64*t69
              t424 = 5.770983152794609d+0*t135*t136*t265*t64*t65*t69*t86
              t425 = -4.616786522235687d+1*t134*t135*t136*t148*t64*t69*t
     1           86
              t426 = -1.099109305675375d-2*t243*t71*t78
              t427 = 1.8175185709928465d-3*t243*t81*t84
              t428 = -7.11545236961578d-2*t300*t64*t69*t89
              t429 = -3.588478118171826d+0*t284*t64*t69*t86*t89
              t430 = -2.1530868709030954d+0*t287*t65*t69*t86*t89
              t431 = t126**3
              t432 = 5.172601291927341d+2*t431*t62*t71/(t76**6*t77**3)
              t433 = -9.649187699215522d+1*t235*t431*t62*t71/t76**5
              t434 = 4.824593849607761d+1*t126*t234*t235*t245*t62*t71
              t435 = -2.1319703304396778d+0*t124*t233*t234*t235*t71
              t436 = 6.0d+0*t128*t234*t431*t62*t71
              t437 = -6.0d+0*t126*t128*t238*t245*t62*t71
              t438 = 2.6513779981040353d-1*t124*t128*t233*t238*t71
              t439 = -1.3256889990520176d-1*t124*t127*t128*t245*t71
              t440 = 1.767585332069357d-1*t126*t127*t128*t243*t71
              t441 = 1/t60**3.6666666666666664d+0
              t442 = 1/t73**7
              t443 = 1/t60**3.3333333333333337d+0
              t444 = 1/t60**3.1666666666666665d+0
              t445 = 1.0d+0*t127*t128*(-2.520426340996149d+0*t444-2.3079
     1           979182303428d+0*t443-1.5008036906238065d+0*t442-5.62075
     2           3557770543d-1*t441)*t62*t71
              t446 = t130**3
              t447 = -1.0254062650399592d+3*t446*t80*t81/(t82**6*t83**3)
              t448 = 1.0389537648811739d+2*t249*t446*t80*t81/t82**5
              t449 = -5.19476882440587d+1*t130*t248*t249*t255*t80*t81
              t450 = 1.1950391155803675d+0*t124*t247*t248*t249*t81
              t451 = -3.5089341735807883d+0*t132*t248*t446*t80*t81
              t452 = 3.5089341735807883d+0*t130*t132*t252*t255*t80*t81
              t453 = -8.072185179299687d-2*t124*t132*t247*t252*t81
              t454 = 4.0360925896498434d-2*t124*t131*t132*t255*t81
              t455 = -5.381456786199791d-2*t130*t131*t132*t243*t81
              t456 = -5.848223622634647d-1*t131*t132*(-3.436688601932293
     1           d+0*t444-2.3308360066730832d+0*t443-8.064323383643707d-
     2           1*t442-5.663741022599518d-1*t441)*t80*t81
              t457 = t134**3
              t458 = 3.9801326549115085d+3*t457*t64*t65*t69*t86/(t87**6*
     1           t88**3)
              t459 = -3.712353310021716d+2*t259*t457*t64*t65*t69*t86/t87
     1           **5
              t460 = 1.856176655010858d+2*t134*t258*t259*t265*t64*t65*t6
     1           9*t86
              t461 = -7.424706620043432d+2*t148*t257*t258*t259*t64*t69*t
     1           86
              t462 = -7.886871025654724d+0*t159*t257*t258*t259*t64*t69
              t463 = 1.1541966305589217d+1*t136*t258*t457*t64*t65*t69*t8
     1           6
              t464 = -1.1541966305589217d+1*t134*t136*t262*t265*t64*t65*
     1           t69*t86
              t465 = 4.616786522235687d+1*t136*t148*t257*t262*t64*t69*t8
     1           6
              t466 = 4.904166819946466d-1*t136*t159*t257*t