// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _gp_Hypr2d_HeaderFile
#define _gp_Hypr2d_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _gp_Ax22d_HeaderFile
#include <gp_Ax22d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Ax2d_HeaderFile
#include <gp_Ax2d.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class Standard_DomainError;
class gp_Ax2d;
class gp_Ax22d;
class gp_Pnt2d;
class gp_Trsf2d;
class gp_Vec2d;


Standard_EXPORT const Handle(Standard_Type)& STANDARD_TYPE(gp_Hypr2d);


//! Describes a branch of a hyperbola in the plane (2D space). <br>
//! A hyperbola is defined by its major and minor radii, and <br>
//! positioned in the plane with a coordinate system (a <br>
//! gp_Ax22d object) of which: <br>
//! -   the origin is the center of the hyperbola, <br>
//! -   the "X Direction" defines the major axis of the hyperbola, and <br>
//! -   the "Y Direction" defines the minor axis of the hyperbola. <br>
//!   This coordinate system is the "local coordinate system" <br>
//! of the hyperbola. The orientation of this coordinate <br>
//! system (direct or indirect) gives an implicit orientation to <br>
//! the hyperbola. In this coordinate system, the equation of <br>
//! the hyperbola is: <br>
//! X*X/(MajorRadius**2)-Y*Y/(MinorRadius**2) = 1.0 <br>
//! The branch of the hyperbola described is the one located <br>
//! on the positive side of the major axis. <br>
//! The following schema shows the plane of the hyperbola, <br>
//! and in it, the respective positions of the three branches of <br>
//! hyperbolas constructed with the functions OtherBranch, <br>
//! ConjugateBranch1, and ConjugateBranch2: <br>
//!                         ^YAxis <br>
//!                         | <br>
//!                  FirstConjugateBranch <br>
//!                         | <br>
//!        Other            |                Main <br>
//!   --------------------- C ------------------------------>XAxis <br>
//!        Branch           |                Branch <br>
//!                         | <br>
//!                         | <br>
//!                   SecondConjugateBranch <br>
//!                         | <br>
//! <br>
//! Warning <br>
//! The major radius can be less than the minor radius. <br>
//! See Also <br>
//! gce_MakeHypr2d which provides functions for more <br>
//! complex hyperbola constructions <br>
//! Geom2d_Hyperbola which provides additional functions <br>
//! for constructing hyperbolas and works, in particular, with <br>
//! the parametric equations of hyperbolas <br>
class gp_Hypr2d  {

public:

  DEFINE_STANDARD_ALLOC

  //! Creates of an indefinite hyperbola. <br>
      gp_Hypr2d();
  
//!  Creates a hyperbola with radii MajorRadius and <br>
//!   MinorRadius, centered on the origin of MajorAxis <br>
//!   and where the unit vector of MajorAxis is the "X <br>
//!   Direction" of the local coordinate system of the <br>
//!   hyperbola. This coordinate system is direct if Sense <br>
//!   is true (the default value), and indirect if Sense is false. <br>
//!  Warnings : <br>
//!  It is yet  possible to create an Hyperbola with <br>
//!  MajorRadius <= MinorRadius. <br>
//! Raises ConstructionError if MajorRadius < 0.0 or MinorRadius < 0.0 <br>
  Standard_EXPORT   gp_Hypr2d(const gp_Ax2d& MajorAxis,const Standard_Real MajorRadius,const Standard_Real MinorRadius,const Standard_Boolean Sense = Standard_True);
  
//!  a hyperbola with radii MajorRadius and <br>
//!   MinorRadius, positioned in the plane by coordinate system A where: <br>
//!   -   the origin of A is the center of the hyperbola, <br>
//!   -   the "X Direction" of A defines the major axis of <br>
//!    the hyperbola, that is, the major radius <br>
//!    MajorRadius is measured along this axis, and <br>
//!   -   the "Y Direction" of A defines the minor axis of <br>
//!    the hyperbola, that is, the minor radius <br>
//!    MinorRadius is measured along this axis, and <br>
//!   -   the orientation (direct or indirect sense) of A <br>
//!    gives the implicit orientation of the hyperbola. <br>
//!  Warnings : <br>
//!  It is yet  possible to create an Hyperbola with <br>
//!  MajorRadius <= MinorRadius. <br>
//! Raises ConstructionError if MajorRadius < 0.0 or MinorRadius < 0.0 <br>
      gp_Hypr2d(const gp_Ax22d& A,const Standard_Real MajorRadius,const Standard_Real MinorRadius);
  //! Modifies this hyperbola, by redefining its local <br>
//! coordinate system so that its origin becomes P. <br>
        void SetLocation(const gp_Pnt2d& P) ;
  //! Modifies the major or minor radius of this hyperbola. <br>
//! Exceptions <br>
//! Standard_ConstructionError if MajorRadius or <br>
//! MinorRadius is negative. <br>
        void SetMajorRadius(const Standard_Real MajorRadius) ;
  //! Modifies the major or minor radius of this hyperbola. <br>
//! Exceptions <br>
//! Standard_ConstructionError if MajorRadius or <br>
//! MinorRadius is negative. <br>
        void SetMinorRadius(const Standard_Real MinorRadius) ;
  //! Modifies this hyperbola, by redefining its local <br>
//! coordinate system so that it becomes A. <br>
        void SetAxis(const gp_Ax22d& A) ;
  
//!  Changes the major axis of the hyperbola. The minor axis is <br>
//!  recomputed and the location of the hyperbola too. <br>
        void SetXAxis(const gp_Ax2d& A) ;
  
//!  Changes the minor axis of the hyperbola.The minor axis is <br>
//!  recomputed and the location of the hyperbola too. <br>
        void SetYAxis(const gp_Ax2d& A) ;
  
//!  In the local coordinate system of the hyperbola the equation of <br>
//!  the hyperbola is (X*X)/(A*A) - (Y*Y)/(B*B) = 1.0 and the <br>
//!  equation of the first asymptote is Y = (B/A)*X <br>
//!  where A is the major radius of the hyperbola and B the minor <br>
//!  radius of the hyperbola. <br>
//! Raises ConstructionError if MajorRadius = 0.0 <br>
        gp_Ax2d Asymptote1() const;
  
//!  In the local coordinate system of the hyperbola the equation of <br>
//!  the hyperbola is (X*X)/(A*A) - (Y*Y)/(B*B) = 1.0 and the <br>
//!  equation of the first asymptote is Y = -(B/A)*X <br>
//!  where A is the major radius of the hyperbola and B the minor <br>
//!  radius of the hyperbola. <br>
//! Raises ConstructionError if MajorRadius = 0.0 <br>
        gp_Ax2d Asymptote2() const;
  
//!  Computes the coefficients of the implicit equation of <br>
//!  the hyperbola : <br>
//!  A * (X**2) + B * (Y**2) + 2*C*(X*Y) + 2*D*X + 2*E*Y + F = 0. <br>
  Standard_EXPORT     void Coefficients(Standard_Real& A,Standard_Real& B,Standard_Real& C,Standard_Real& D,Standard_Real& E,Standard_Real& F) const;
  
//!  Computes the branch of hyperbola which is on the positive side of the <br>
//!  "YAxis" of <me>. <br>
        gp_Hypr2d ConjugateBranch1() const;
  
//! Computes the branch of hyperbola which is on the negative side of the <br>
//!  "YAxis" of <me>. <br>
        gp_Hypr2d ConjugateBranch2() const;
  
//!  Computes the directrix which is the line normal to the XAxis of the hyperbola <br>
//!  in the local plane (Z = 0) at a distance d = MajorRadius / e <br>
//!  from the center of the hyperbola, where e is the eccentricity of <br>
//!  the hyperbola. <br>
//!  This line is parallel to the "YAxis". The intersection point <br>
//!  between the "Directrix1" and the "XAxis" is the "Location" point <br>
//!  of the "Directrix1". <br>
//!  This point is on the positive side of the "XAxis". <br>
        gp_Ax2d Directrix1() const;
  
//!  This line is obtained by the symmetrical transformation <br>
//!  of "Directrix1" with respect to the "YAxis" of the hyperbola. <br>
        gp_Ax2d Directrix2() const;
  
//!  Returns the excentricity of the hyperbola (e > 1). <br>
//!  If f is the distance between the location of the hyperbola <br>
//!  and the Focus1 then the eccentricity e = f / MajorRadius. Raises DomainError if MajorRadius = 0.0. <br>
        Standard_Real Eccentricity() const;
  
//!  Computes the focal distance. It is the distance between the <br>
//!  "Location" of the hyperbola and "Focus1" or "Focus2". <br>
        Standard_Real Focal() const;
  
//!  Returns the first focus of the hyperbola. This focus is on the <br>
//!  positive side of the "XAxis" of the hyperbola. <br>
        gp_Pnt2d Focus1() const;
  
//!  Returns the second focus of the hyperbola. This focus is on the <br>
//!  negative side of the "XAxis" of the hyperbola. <br>
        gp_Pnt2d Focus2() const;
  
//!  Returns  the location point of the hyperbola. <br>
//!  It is the intersection point between the "XAxis" and <br>
//!  the "YAxis". <br>
       const gp_Pnt2d& Location() const;
  
//!  Returns the major radius of the hyperbola (it is the radius <br>
//!  corresponding to the "XAxis" of the hyperbola). <br>
        Standard_Real MajorRadius() const;
  
//!  Returns the minor radius of the hyperbola (it is the radius <br>
//!  corresponding to the "YAxis" of the hyperbola). <br>
        Standard_Real MinorRadius() const;
  
//!  Returns the branch of hyperbola obtained by doing the <br>
//!  symmetrical transformation of <me> with respect to the <br>
//!  "YAxis" of <me>. <br>
        gp_Hypr2d OtherBranch() const;
  
//!  Returns p = (e * e - 1) * MajorRadius where e is the <br>
//!  eccentricity of the hyperbola. <br>
//! Raises DomainError if MajorRadius = 0.0 <br>
        Standard_Real Parameter() const;
  //! Returns the axisplacement of the hyperbola. <br>
       const gp_Ax22d& Axis() const;
  //! Computes an axis whose <br>
//! -   the origin is the center of this hyperbola, and <br>
//! -   the unit vector is the "X Direction" or "Y Direction" <br>
//! respectively of the local coordinate system of this hyperbola <br>
//!        Returns the major axis of the hyperbola. <br>
  Standard_EXPORT     gp_Ax2d XAxis() const;
  //! Computes an axis whose <br>
//! -   the origin is the center of this hyperbola, and <br>
//! -   the unit vector is the "X Direction" or "Y Direction" <br>
//!  respectively of the local coordinate system of this hyperbola <br>
//!  Returns the minor axis of the hyperbola. <br>
        gp_Ax2d YAxis() const;
  
        void Reverse() ;
  //! Reverses the orientation of the local coordinate system <br>
//! of this hyperbola (the "Y Axis" is reversed). Therefore, <br>
//! the implicit orientation of this hyperbola is reversed. <br>
//! Note: <br>
//! -   Reverse assigns the result to this hyperbola, while <br>
//! -   Reversed creates a new one. <br>
        gp_Hypr2d Reversed() const;
  //! Returns true if the local coordinate system is direct <br>
//!            and false in the other case. <br>
        Standard_Boolean IsDirect() const;
  
  Standard_EXPORT     void Mirror(const gp_Pnt2d& P) ;
  
//!  Performs the symmetrical transformation of an hyperbola with <br>
//!  respect  to the point P which is the center of the symmetry. <br>
  Standard_EXPORT     gp_Hypr2d Mirrored(const gp_Pnt2d& P) const;
  
  Standard_EXPORT     void Mirror(const gp_Ax2d& A) ;
  
//!  Performs the symmetrical transformation of an hyperbola with <br>
//!  respect to an axis placement which is the axis of the symmetry. <br>
  Standard_EXPORT     gp_Hypr2d Mirrored(const gp_Ax2d& A) const;
  
        void Rotate(const gp_Pnt2d& P,const Standard_Real Ang) ;
  
//!  Rotates an hyperbola. P is the center of the rotation. <br>
//!  Ang is the angular value of the rotation in radians. <br>
        gp_Hypr2d Rotated(const gp_Pnt2d& P,const Standard_Real Ang) const;
  
        void Scale(const gp_Pnt2d& P,const Standard_Real S) ;
  
//!  Scales an hyperbola. <S> is the scaling value. <br>
//!  If <S> is positive only the location point is <br>
//!  modified. But if <S> is negative the "XAxis" is <br>
//!  reversed and the "YAxis" too. <br>
        gp_Hypr2d Scaled(const gp_Pnt2d& P,const Standard_Real S) const;
  
        void Transform(const gp_Trsf2d& T) ;
  
//!  Transforms an hyperbola with the transformation T from <br>
//!  class Trsf2d. <br>
        gp_Hypr2d Transformed(const gp_Trsf2d& T) const;
  
        void Translate(const gp_Vec2d& V) ;
  
//!  Translates an hyperbola in the direction of the vector V. <br>
//!  The magnitude of the translation is the vector's magnitude. <br>
        gp_Hypr2d Translated(const gp_Vec2d& V) const;
  
        void Translate(const gp_Pnt2d& P1,const gp_Pnt2d& P2) ;
  
//!  Translates an hyperbola from the point P1 to the point P2. <br>
        gp_Hypr2d Translated(const gp_Pnt2d& P1,const gp_Pnt2d& P2) const;
    const gp_Ax22d& _CSFDB_Getgp_Hypr2dpos() const { return pos; }
    Standard_Real _CSFDB_Getgp_Hypr2dmajorRadius() const { return majorRadius; }
    void _CSFDB_Setgp_Hypr2dmajorRadius(const Standard_Real p) { majorRadius = p; }
    Standard_Real _CSFDB_Getgp_Hypr2dminorRadius() const { return minorRadius; }
    void _CSFDB_Setgp_Hypr2dminorRadius(const Standard_Real p) { minorRadius = p; }



protected:




private: 


gp_Ax22d pos;
Standard_Real majorRadius;
Standard_Real minorRadius;


};


#include <gp_Hypr2d.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
