/*
-----------------------------------------------------------------------------
This source file is part of OGRE
(Object-oriented Graphics Rendering Engine)
For the latest info, see http://www.ogre3d.org

Copyright (c) 2000-present Torus Knot Software Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
-----------------------------------------------------------------------------
*/

#ifndef _Ogre_GL3PlusReadOnlyBufferPacked_H_
#define _Ogre_GL3PlusReadOnlyBufferPacked_H_

#include "OgreGL3PlusPrerequisites.h"

#include "Vao/OgreReadOnlyBufferPacked.h"

namespace Ogre
{
    class GL3PlusBufferInterface;

    class _OgreGL3PlusExport GL3PlusReadOnlyTexBufferPacked : public ReadOnlyBufferPacked
    {
        GLuint mTexName;
        GLenum mInternalFormat;

        inline void bindBuffer( uint16 slot, size_t offset, size_t sizeBytes );

    public:
        GL3PlusReadOnlyTexBufferPacked( size_t internalBufStartBytes, size_t numElements,
                                        uint32 bytesPerElement, uint32 numElementsPadding,
                                        BufferType bufferType, void *initialData, bool keepAsShadow,
                                        VaoManager *vaoManager, GL3PlusBufferInterface *bufferInterface,
                                        PixelFormatGpu pf );
        virtual ~GL3PlusReadOnlyTexBufferPacked();

        virtual void bindBufferVS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferPS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferGS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferDS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferHS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferCS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );

        virtual void _bindBufferDirectly( uint16 slot, size_t offset, size_t sizeBytes );
    };

    class _OgreGL3PlusExport GL3PlusReadOnlyUavBufferPacked : public ReadOnlyBufferPacked
    {
        inline void bindBuffer( uint16 slot, size_t offset, size_t sizeBytes );

    public:
        GL3PlusReadOnlyUavBufferPacked( size_t internalBufStartBytes, size_t numElements,
                                        uint32 bytesPerElement, uint32 numElementsPadding,
                                        BufferType bufferType, void *initialData, bool keepAsShadow,
                                        VaoManager *vaoManager, GL3PlusBufferInterface *bufferInterface,
                                        PixelFormatGpu pf );
        virtual ~GL3PlusReadOnlyUavBufferPacked();

        virtual void bindBufferVS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferPS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferGS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferDS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferHS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferCS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );

        virtual void _bindBufferDirectly( uint16 slot, size_t offset, size_t sizeBytes );
    };

    class _OgreGL3PlusExport GL3PlusReadOnlyBufferEmulatedPacked : public ReadOnlyBufferPacked
    {
        GLuint mTexName;
        GLenum mInternalFormat;

        GLenum mOriginFormat;
        GLenum mOriginDataType;
        size_t mMaxTexSize;
        size_t mInternalNumElemBytes;
        size_t mInternalNumElements;

        inline void bindBuffer( size_t offset, size_t sizeBytes );
        inline void bindBuffer( uint16 slot, size_t offset, size_t sizeBytes );

    public:
        GL3PlusReadOnlyBufferEmulatedPacked( size_t internalBufStartBytes, size_t numElements,
                                             uint32 bytesPerElement, uint32 numElementsPadding,
                                             BufferType bufferType, void *initialData, bool keepAsShadow,
                                             VaoManager *vaoManager,
                                             GL3PlusBufferInterface *bufferInterface,
                                             PixelFormatGpu pf );
        virtual ~GL3PlusReadOnlyBufferEmulatedPacked();

        virtual void bindBufferVS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferPS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferGS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferDS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferHS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );
        virtual void bindBufferCS( uint16 slot, size_t offset = 0, size_t sizeBytes = 0 );

        virtual void _bindBufferDirectly( uint16 slot, size_t offset, size_t sizeBytes );
    };
}  // namespace Ogre

#endif
