/*
 *  Copyright (c) 2011 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "OperatorOverloadCenter_p.h"
#include <list>

#include "Macros_p.h"
#include "AST/Expression.h"

using namespace GTLCore;

//--------------------------- OperatorOverloadCenter ---------------------------//

struct OperatorOverloadCenter::Private {
  std::list< OperatorOverloadExpressionFactory* > factories;
};

OperatorOverloadCenter::OperatorOverloadCenter() : d(new Private)
{
}

OperatorOverloadCenter::~OperatorOverloadCenter()
{
  delete d;
}

AST::BinaryExpression* OperatorOverloadCenter::createBinaryExpression( AST::Expression* value1, AST::Expression* value2, Operator::Type type  ) const
{
  foreach( OperatorOverloadExpressionFactory* cef, d->factories )
  {
    if(cef->canOverload(value1->type(), value2->type(), type))
    {
      return cef->create(value1, value2, type);
    }
  }
  return 0;
}

void OperatorOverloadCenter::addOperatorOverloadExpressionFactory( OperatorOverloadExpressionFactory* _factory)
{
  d->factories.push_back(_factory);
}

//--------------------------- ConvertExpressionFactory ---------------------------//

struct OperatorOverloadExpressionFactory::Private {
};

OperatorOverloadExpressionFactory::OperatorOverloadExpressionFactory( ) : d(new Private)
{
}

OperatorOverloadExpressionFactory::~OperatorOverloadExpressionFactory()
{
  delete d;
}

