###############################################################################
# OpenVAS Vulnerability Test
# $Id: PowerPhlogger_37150.nasl 7671 2010-05-12 17:34:03Z mime $
#
# Power Phlogger Cross-site Scripting Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100368);
 script_tag(name:"cvss_base", value:"4.3");
 script_cve_id("CVE-2009-4253");
 script_bugtraq_id(37150);
 script_version ("1.0-$Revision: 7671 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Power Phlogger Cross-site Scripting Vulnerability");

desc = "Overview:
Power Phlogger is prone to a cross-site scripting vulnerability
because the application fails to properly sanitize user-
supplied input.

Attackers can exploit this issue to steal cookie-based authentication
credentials or to control how the site is rendered to the user.

Power Phlogger 2.2.5 is vulnerable; other versions may also be
affected.

References:
http://www.securityfocus.com/bid/37150
http://www.websecurity.com.ua/1845
http://www.phpee.com/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine the PowerPhlogger version");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("PowerPhlogger_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/PowerPhlogger")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "2.2.5")   || 
     version_is_equal(version: vers, test_version: "2.2.2.a") ||
     version_is_equal(version: vers, test_version: "2.2.1")   ||
     version_is_equal(version: vers, test_version: "2.0.9")) {
        security_warning(port:port);
        exit(0);
  }

}

exit(0);
