# -*- coding: utf-8 -*-
# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Igor Kekeljevic (http://www.admiror-ns.co.yu).

# Follows PEP8

from core import ct, models
from lib.reverse_translation import _t

#no need to lazily import these as they are always imported
import os


class Action(models.Action):
    label = _t('Rename Tag')
    author = 'Juho Vepsäläinen'
    email = 'bebraw@gmail.com'
    version = '0.1'
    tags = [_t('metadata')]
    __doc__ = _t('Rename a tag')

    def interface(self, fields):
        fields[_t('From (Exif, Iptc)')] = self.ExifItpcField(
            'Exif_Image_ImageDescription', choices=self.EXIF_IPTC)
        fields[_t('To (Exif, Iptc)')] = self.ExifItpcField(
            'Exif_Image_ImageDescription', choices=self.EXIF_IPTC)

    def apply(self, photo, setting, cache):
        info = photo.info
        old_name = self.get_field('From (Exif, Iptc)', info).strip()
        new_name = self.get_field('To (Exif, Iptc)', info).strip()
        if not (new_name and old_name):
            return photo
        if old_name in info and old_name != new_name:
            info[new_name] = info[old_name]
            del info[old_name]
        return photo

    #FIXME: replace this icon with another one (Nadia?)
    icon = \
'x\xda\x01j\x0c\x95\xf3\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0c!IDATh\x81\xd5\x9a}p\x1c\xe5}\xc7?\xcf\xbe\xdc\x9b\
\xacW\x9f,\xdb\x92lY\x92-\xf9M\x06\xcb\x06\xdb\x10L\xe2\x84\xd6\t\x89&\xa45\
\xd3\x12\xd2\xce0\x81\xa14\x1e&\x990d\xa6\x04\n\xa1\xc53L\x92:%@;\x9d\xb6\
\xa4\xc4\xc1\xb1\x85\xed\xb6P\xfcBc\xd9\xc6\x98\x18\xcb\xef\xd8\x91\x90\xb1^\
\xac\xb7;I\xa7\xb3t/{\xbbO\xff\xd8=\xdd\xe9$Y\x92\x11\x93twV\xbb\xb7\xf7\xec\
\xee\xf7\xfb\xfb}\x7f/\xcf\x9e\x84\x94\x92\xff\xcf\x8b\xf2\xfb\x06\xf0i\x17\
\xed\xf7\r`\xb2\xe5\xd8\x97K\x96\x84g{\xee\x94\xc1\xa1C\x9b\xdf\xea\xbc\x9a\
\xf9\xbd\xf8C\x95\xd0\xd1{\xe6.\xeaY;\xef`_EN\xb9aJ\x12Q\x93\xdc\xe6\xd0\x19\
ogh\xfd\x9f\xeel\x8b$\xc7\xdd\xb4\x07\xea\xea\xea\xe6\x97\x96\x96n\xa8\xac\
\xac\xfcB$\x12\xe9kjj:\x18\x0c\x06?\xdc\xbbwo\xf8\xd3\x82\xbf8G\xcc\xed{p\
\xf9\xa9`eN\x9eaHb1\x0b3a\xd1Q\x9c\xb5jN\xc2:\x08\xdc\x91\x1c;m\x0fl\xdd\xba\
\xf5\x81\x8d\x1b7n////\x18\x1e\x1e\xa6\xad\xad\rUU\xf1\xfb\xfd$\x12\t\x9a\
\x9a\x9a\x1a\x8f\x1c9\xf2\xe0\x8e\x1d;.\xdc,\xf8\x98\xcfs\xf8\xe4Sk\x97\x18\
\x86\xe4\xfd\xe3\x92\x96\x8f-\xca+,*\x16\x9b\x107%j\x9d\xf6\xf4\xd3O[\xd3"PW\
WWt\xf7\xddw\xbf\xb3z\xf5\xeaU\r\r\r\x9c8q\x02\xd34\xa3\xd1h\xb4\r\xd0<\x1e\
\x8f\xdf\xe3\xf1d\xaf[\xb7\x8e\xb2\xb22\xab\xb1\xb1\xf1_\xb7m\xdb\xf6m9\r\
\x0b]\x9c#\xe6\x9ah\xff\x1b,\xcd\xae\xbe\xf0\xed\xe5Dc\x16\xf5;%\xa6i\xa1\
\xa8&\x9f\xdfdb\xc4-juu\xe9\xfd\xcf}x\t&\x90\x90\x10B`g(\x01\xb0|\xf9re\xcb\
\x96-\xfb\xe7\xcc\x99S\xb3}\xfb\xf6xss\xf3\xfftuu5\x07\x02\x81\x1e\xcb\xb2L\
\xc0\x02\xd4\xfc\xfc\xfc\xfc\xde\xde\xde{JJJVo\xda\xb4\xe9\xa1G\x1ey$ \x84\
\xf8\xc1TH$\xc1G$\xd5\xb2k\x18#nb%$\x0b\xcbL\xae\xb4H\x16.4\x89\xc7-\x14C\
\xca\xfb_8u9y\xdd\x18\x02B\x08\x05p\x01\xbe\xd2\x07\x99\xe7\xf2\xa0\xdf\x96\
\xb8mkyyy\xcd\xae]\xbb\x06\x8e\x1f?\xfeFww\xf7%\xa0\x03\xe8\x06\x02@\x14\xf0\
\xf5\xf7\xf7\xe7\x1c;v\xec\xfc\x82\x05\x0b\xd6k\x9a\xf6pMM\xcd\x13uuuG\x85\
\x10\xff}#\x12\xe9\xe0\xa3\x12\x8ch\x82\xac\xf7\xba\xe8\xb9\xc5\xcf\xe2*\x8b\
\xb2r\x0b\xc3\xb0\x88\xc7L\xaa\x86\x13\x07 u\xafQ\x04\xd2\xc0\xcfY\xfb\xcf<\
\xea\x99\xcf\x9f\x08ET\x947.\xa2\xe1\xb7\x87\x12\x1f/}\xfbj\xe1\xda\xd8\x92\
\xe2|r\x15\x8d\xb8P\xb0\x00\x0b\x05S\xd11:\xde\xe4?\xdb\xeb9\xde\xda\xdaz\
\xf9\x83\x0f>\x90\xf9\xf9\xf9\x8f\xf9\xfd\xfe\x1f\x02\xef\x00\xc6T\xc0G\xa5d\
X\xc2\xacC\xed\x84#&C\xcb\x0b\x88\x9b\x12c\xc8\xa0\xb8{\xf8B\xa1X\xfb\xe5\
\xf4\xebG\x08\xa4\xc9\xc6\x87JE\xe1F\xbe\xa3\xe7\x91%[rqk\x1e\x82\xb5\'\xb4\
\xf2\xcd\xb1U\x13Y\x11\xc0\x7f\'\x7f\x91\xbb\x82m\x17\x9e\xe5\x8d\xa6\xa6\
\xa6\x7f\xa9\xae\xae\xfe\\QQ\xd1\n \x0b\x18\x98*\xf8\xa8\x84X\xc2\xc2{\xb8\
\x03\xff\x91k\x0c\xf94|\xd7\x8d=\xdf\x0b\x99\xf7!\xaf\x8c\xf2df%V\x00\xaf\
\xaaS\xace\x93\x05\xa0\x7fR\xc4@h\x80\xd6\x9e+\xb2\xef}H\x0cML@\xcb"\xab\xf2\
1\xe5o\xef\xd8\xa5\xfeX\xcfE\xef\xe8\xe8xSJ\xe9]\xbat\xe9\x1a!\x84:U\xf0Q \
\x92<NX\xf8\x06\xe3\x0e\xf8\xb12\xcc$\xa0\x02\xbe\xc2\x8d,K>.tV\x18\xa1\x81P\
\xf4\xe4\x13\xd1\xd7N>\xc2+\xcd\xffH\xbf\xd1?\x16\xbc@AEC\x13\x9a\x98\xb7Q\
\xfb\xca\x17\x0f\xb8w\x0e\xcd\xbe6\x1c\x0e\x87\xb1,k!\xa0O\x17|DJ\xdc\xb0\
\xe7{ak\\\xf0\x99\x04\x04\xb6\xa4\xb2\xe7\x7f\x95{\x01\xa4\t\x1d\x07\x8c\xa3\
\xb1X\xccSZRz&\xd2\xc3\xbbM?\xe7\xa5\xe0{\xc43\x81\xabh\xa8\xc2\xd9\xd0\xc9]\
\xe4ZT\xf3\xf3\xc8\xb3\x01\xb3\xfd\xea\xe0\xe0`\x0e\xe0\x15B(\xa7\n\xc5\xbc\
\x99\x02?B\xc0\xd1\xbf\n\xf8\xf2\xd7P\xee-a\x19\x80P\xc1uG@\x04\x83A\xaa\xab\
\xab\xef\xc2\xe4\x9a\x15\xa3\xd7[\x865\x1a\xb8\x8e&tT\x92\x9bM\xc2\x9d\xafy\
\x8b_iZ\xb0\xe4\x85\xa1-z.\xe5/\xe4P\xa9\x8b\x99\x03\x0fN!s\xb2\x8f\x17(Y\
\xfd\x12?\xcd*\xe7\x8f\x0bj\xed\x01\xb1\x00f\xe4\x995\xfd\x9eP\x81\xb7\xdd{\
\xee\xf5\xac\xafw\xdeV\xbcY\xbdE\xa0\xa0\n\x15\x81\x82Br\xaf \x84\x82@A8g@\
\xd8\xeb)\xa3\xfd\xe1o\xf5\x0b\x91\xa0x\xa6\xc0\'e\x93\x94N~\xfez\xd6\xd4<C\
\xbd\xd0q\xe7\xae\x18=PZ\xa0(\xb6\xdd\x954\xe0J\x92\x80\x03\\!\xb5\xc79r\x87\
%\xf7\xdf\xdf\x8b\xbb%\xc1L\x82\x87T\x1a\xd5\x80YU\x8f\xf2\x10*n\xc53v\xa0\
\xa28\x80E\x12\xb8\x9a\xb2\xbcPG\x01\x17\x8e\'\x92$\x16\x1d\x19\xfeL\xc0\'\
\x81\'\xf3\xbf\xc74p!A\xf3f\xba\xc9\x06\xad\nu\x14\xf8LO$\xc9dJh\xdeG\xda\
\xa4\xe0]7\x01\x1eRYH\x02\xe6\xe9\'\xd8m\x0c\x12\xd2\xb2&\x02\xaf\xa56\xa1\
\xd9\xe7\x9d@V\x84\x1d\xcc\xc9\xcf\x1a:\n\x1a\x9a\xd0qG\xb3n\x08^\xc2\xfe\
\x17\xc3\xd67\x85\x9dO\xc4t\tH \x01\\7B\xb4\xb7\xee`O\xe8\x1c\x98\xc3\xe3\
\x81OY^M\x03o\xa7\xce\xd1\x9b"l\xf0\xde~\x85\xd0\x8a"\x06\x16f\x8f\x0b\xde\
\xfcR.\xa7__\xa4\xf6\xe5\xb2\x04\xc8\x06\xd4\xe9\x90P\x9c&\xcb\x04\xc2$\xe8l\
\x7f\x93\xfdC\xad\\\xee9\x06\xd1N1\xael\xd4t/\x8c\xeb\x89\x14\x91\xd9\r*\x11\
\xc3\xa2\xf3\xbe\n\x06\x96\xe4\x8d\x02\x1f\xbd=\x9b+\x8f\x97\x92W<k\xd3\x96\
\xfa\xa5\xffUqo\xcef\xc0\x0f\xe8Nf\x9ctI\xa6Q\x81])\xf3\xd1\xa8\xc8Z\xc8\xe7\
j_\xe2\x99x\x1f\x9eYs]\x14\xae\xf48\x80\x93\xe0U\'pm?L\x14\x0fX\n\xd6\xdf(\
\x04\x86\x15\xaa\xab\x0c\xf4`\x04kp\x98A\x8fA\xa0\xdaGd\xb1\x07UWP\\\xa0\xb9\
\x05\x12\x19\xbb\xfcv\xcf\xcf\x1a~\xd8\xf12\xd0\x85\xed0y\xa3NvdB\xe30\xf6\
\x00E\xa8,\xafz\x9c\xbf,\xb9\x8foD\xbbA5]\x94\xde\x91\x83\xee\xd2\xc6\x12I#3\
\x92R\x9d`\xc6\x10\x88\x17#\xc4\x0c\x83\x9e2\x83\xf8l\x1d\xcd\xa5\xa0j\n\xaa\
KAu\t\x14]\xa0\xb8\x04\x8a\x8e\xfd\xd9\x8d\xec\xbc0px\xdfC\xbf\xfb\xae\x11\
\xa2\x05\x18\x02\xcc\x89H\xa4\x13HV\xe3Y\xc0BTVm\xf85\xcfy\xe7\xb1 \x1e\x84D\
\x9fF\xd9\xed\xb3\xc9\xf2{F$3\x99\'\x04\nfD\xd2\xd7\x1ce\xb0#\x86\x90\xc2\
\xb6\xb8.l\x02\xbaMb\x84\x88\x0e\xc2%Qt\xc1\xf5\xfeHG\xc3\xdf\xb7<\xfe\xbb\
\xfa\xd0\x11\xa0\x1fHH)\xad\t\t\xa4\x91p\x01\x05h,\x99]\xcb\x17o\xdd\xce\x93\
\x12\xb4D\x18\xa2\x1d\x82\xf9\x8b\x0b\x99[\x95;5O8\xb5\xc0\x8cB\xa85J\xa8=\
\x8a\xb4@s\xa96p\x87\x8c\xe2\x12\xa8\xba@qI\x9b\x84\x06\x8a\x1b\x12\x89D\xf4\
\xec\xae\xf6\x9f\x1c\xfa~\xdb\xab@\x0f\x10\xcb$1fN\xecH\xc9\x07\xccCe\xc5\
\xca\xe7\xf9\xeb\xb9\xf7\xf0\x05\x99\x003\n\xb1.\xc8\xf6\xe4\xb1x]1\xaa\xa6\
\x8d\xf1\xc4\x887F\xea\x81M\xc2\x8aC\xb83F\xa8#\x8a\x942%#] 4G>.\x1c/\x80\
\xe2\x02\xa1YH\xcd\x92\xad\xa7\x02\xfbw?\xf0\xd1c\xb1\x1e\xda\x00#]N\xe3E\
\xba\xc4\x0e\x9e>LZ/>\xcb\xaf\xe2\x01\x02B\x03\xcd\x07\x9e\x12\x18V\x078{\
\xb0\x85X\xd8\x1c\x95\x99\x92)\xd5\xceL\xa9z\xa0\n\x1d\x97\xdbE~q6\x85\x8br\
\xf0\xfa<\xb8\\.tMGSutMGUS\xd7\xda{\x15U\xd1\xd0\x14M,\xb8\xd5\xff\xa5M?*\
\xdb\xe2\xa8cb\teH\xc9\r\xf8\xd1\xa8\x9e\x7f/_]\xf14\xdfA"$v\x9b\x9d\x18\x84\
x\x97F\xd5\x8aJ\x8a\x16\xf8\x9d\x14\xaaf\xc4G*\x16\x92\xd5\x19\x0bLC\x92\x88\
[\x98q\x133aa\x9a\x16\x12\x0b\xa1H\xd0m\xcb\x0b]"tI,\x1a3\x0en\xbb\xf4o\x1f\
\xfe\xac{;\xf01\x10M\xf7\xc0\x84\xafU\x9c\x19\x94\x0f(Ae\xe5\x9aW\xf8\xfe\
\xec\xdbX#%`\xd9\xcd\x9d\x19\x85h\x17\xcc/X@\xf5-\x95\xa8\xca\xf8\x92R\xd2\
\x08$\xd3\xbb\x94\xf6\x1f)-,goZ&\xa64\xb10\x91\x98\xf4w\x0f^\xdf\xfd\xd8\xe9\
\x97\xdb\x1a\xc2{\x81K@\x88\x8c\x8ct#\x02\xc9.5\x0f\x9dr\xb7\x9f\xf5w\xd6\
\xf3\x9c6\x8bY8a$-\xb0\x0c\x88\xf7\x817V@\xed\xed\xb7\xe2\xf3\xf8F\x05wf\xb3\
\xe74\xd7\x8eV\x93\xabe\xaf2E\xe0J\xe3\xb5\xae\xd7\xff\xec\xb7/\x0eu%\x0e\
\x03\x9f\x00\x83d\xe8\x1fn\xf0v:\xadB_\xc7\xa0+\xd6\xc3\xe5\xab\xffN\xbdP\
\xed\x89\x8eP\xedl\xa1z\xc13\x17\x8c\x82>\x8e\x1e=J_\xef\xc0\xa8\xca=\xb6\
\xcd\xd0G\xfa\xa9\xd1\xe7S-J\xe3\x9e\x8f\xcf\xff\xd3\xa6\xe3O\x0eu%\xde\x01\
\x9a\x1d\xcb\x8f\x01\x7fC\x0f\xa4yA\xc1\xae\r\xa5\xa8\xac\xda\xb0\x93\xa7r\
\x96Q\xe5\x980E\xd8\x91T\xacS\xb0\xa4\xa8\x86eU\xcb\xc7\xf5\xc4X\x0f\xd8\x96\
\xb70\x89Fc\xe6\xdb\xffp\xe2\xe0\xbb\xcf7\xbf\n\x9c\xc5N\x9d\x11\xa6R\xc8&!\
\x91l3\x16\xe7.e\xe3\xba\xd7yJq\xe3\x1e\xeb6\x90\x06D\x03P`\x94\xb2\xa1\xf6.\
<\xbawL\x8dH\r\x97X\xd8\xe0\xfb\x83\xa1\xd8/\xbf\xfb\x9b_\x9c\xaf\xef\xdc\
\x89\xad\xf7\x00\x10\x07\xac\x1b\xb5\x12\x936L\xce\xc5\t\x9cf/t\x91s\xed{8 T\
\x10J\xc6\xa6\x81\xe2\x05_1\x0c\xe6\xb5\xb1\xff\x83}\x0c\x84\xfaG\xa5Y\xc5\
\x99C\xa7w\xb7\x9d\x1d\x9d\xc6O\xfeh\xdf\x8f\xcf\xd7w\xbe\x06\x9c\x03z\xb1\
\x8b\xd6\x84\x96\x9f2\x81\x11c\xd9\xd6\xe8\xc3\xa4\xed\xc2\x8f\xa8\x1fn\xa5c\
\x14\t5\xb5W\\\xe0\xf6\x83\xb20\xcc\xc1\x8f\xf6\xd0\xdcziDB\xaaH\xd6\x06;\
\xed\x9eoi\xe4X\xef>\xbd\xe8[C\x06p\x15\xfb\x05X|\xbc\xb6\xe1\xa6\t\xa4\x05\
\xf40\xd0\x8d\xc5\'\x1f\xfd\x1d\xff\x01\x98#\x01=\x0e\t=\x1b\xb2*L\x1a\x07\
\xdf\xe5\xc8\xb9\x03X\xa65\xe2\x05iI~s\xe6-.\xc4\x8f\xe0+\x93\x94}\x93\xbf\
\x9a\xfb5f\xa5\x19lJ\xcb\xb4~\x1fHk3\xe6\xa3\xb2\xb2\xf6e\xb6\xce\xdf\xcc]\
\xa9\x01\xe9\x83m2`\x07x<\x08\xee\xdeB\xeeY\xf9\r\\\xaa\x9b\xb7\xce\xec$\xe2\
\xef\xc45\xdbn\x1f\x00\xa2\xdd\xecxg%\x0f\x03\xc3S\xf5\xc0t\t$kC\x0eP\xae\
\x17P\xfb\xf9C<\xef\x9eCAj\x0c#\xef:F\x8eq\xaaw\x18\x12A\x17\xba\xa2c\xe5\r\
\xa1\xe7\xd8$\x87[\xb92x\x91\x03\x9d\xfbx\xadu7g\x81\xa1\xcf\x84@\x1a\t7P\
\x88Fu\xd9\x03|\xbd\xe6\x05\x1eM\x02\x1d\x99\x0c\x8e3)\x94\x16\xc8\x84}\x1c\
\xed\xa4+p\x82\xc6O~AC\xffI.c\xd2\x8e\xfd\xca\xbe\x8fi\xc4\xc0M\xfd\xc8\xe7\
\xb4\x19Y8m\xc6\x86_\xf3d\xe1\x9d\xdc2\xd9u\x91n\x02}\xefq\xba\xf5\r\x8e\xf6\
\x1c\xe62\x82 \x82~\x0c\x06\xb0\x8b\xd5\x10\x10c\x92\xd49\x13\x04\x92\xb5!\
\xcf\x99\x82\xae\xbf{?\xcfi\xd9\xf82\xc7\xc6\x83\x0c\x04\xdf\xe7l\xdbn\x8eu\
\xbe\xcd\xf9\x0c\xd0\xd7\xb1\x13C\x1c\xfb\xf7\x03\x93I\xa6\x903B\xc0!\x91>\
\x05]\xba\xec\x07\xfc\xf9\xe2\xad<\x00`\x0c\x10\x0e\x9e\xe4\xfc\xb5\xbd\xbc\
\xd7\xb6\x8b\xd3@\x10\x85>\x0cB@\xd8\x01\x1d\xc3\xae/&v\xd6\x99\x16\xf0\x99 \
\x90>\x05-F\xa5r\xcd\xab<\xd8\xf7>\xad-\xafq\x06\x93\x00\x82>\x12\x0cd\x80\
\x1e\xb1\xf4\xcd\x82\x9e\x11\x02i$t\xec\xf79~\xec\xec\x04\xb6\x96\xc7\x03m1\
\x03\xa0Ga\xf8\xb4\xf7r\xa4\xa4ag&\x1d\x1bd\x82\xcf\x10\xf4\xa8\xe7\xcf\xc4}\
\x1dO\xa4e\xfd\x99\x91\xc7\x94\x9e\xfd\x87\xfa\xbf\x12S]\xfe\x0f\xca\xb4Jp`A\
Vn\x00\x00\x00\x00IEND\xaeB`\x82_\xfb\r\xf3'
