# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VariableCreateOrUpdateParameters(Model):
    """The parameters supplied to the create or update variable operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the name of the variable.
    :type name: str
    :param value: Gets or sets the value of the variable.
    :type value: str
    :param description: Gets or sets the description of the variable.
    :type description: str
    :param is_encrypted: Gets or sets the encrypted flag of the variable.
    :type is_encrypted: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_encrypted': {'key': 'properties.isEncrypted', 'type': 'bool'},
    }

    def __init__(self, *, name: str, value: str=None, description: str=None, is_encrypted: bool=None, **kwargs) -> None:
        super(VariableCreateOrUpdateParameters, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.description = description
        self.is_encrypted = is_encrypted
