# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ErrorResponse(Model):
    """Response on Error.

    All required parameters must be populated in order to send to Azure.

    :param message: Required. Describes the error in detail and provides
     debugging information
    :type message: str
    :param code: Required. String that can be used to programmatically
     identify the error.
    :type code: str
    :param target: The target of the particular error
    :type target: str
    :param details: An array of JSON objects that MUST contain name/value
     pairs for code and message, and MAY contain a name/value pair for target,
     as described above.The contents of this section are service-defined but
     must adhere to the aforementioned schema.
    :type details: str
    """

    _validation = {
        'message': {'required': True},
        'code': {'required': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(self, *, message: str, code: str, target: str=None, details: str=None, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.message = message
        self.code = code
        self.target = target
        self.details = details


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)
