## helpers --------------------------------------------------------------------
test_that(".rescale works", {
    expect_identical(.rescale(c(0, 0.5, 1)), c(0.025, 0.5, 0.975))
})

test_that(".isValidColor works", {
    expect_identical(.isValidColor(c("white", "#FFFFFF", "#ffffff", "wheti")), c(TRUE, 
        TRUE, TRUE, FALSE))
})

## letters --------------------------------------------------------------------
test_that("letters' functions and addLetter for A work", {
    out <- list(x = c(0.025, 0.405, 0.595, 0.215, 0.025, 0.405, 0.595, 0.975, 0.785, 
        0.405, 0.329, 0.671, 0.633, 0.367, 0.329), y = c(0, 1, 1, 0, 0, 1, 1, 0, 
        0, 1, 0.3, 0.3, 0.4, 0.4, 0.3), id = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 
        3, 3, 3), fill = c("#61D04F", "#61D04F", "#61D04F"))
    expect_equal(letterA(0, 0, 1, 1, fill = "#61D04F", id = NULL), out)
    expect_equal(letterA(0, 0, 1, 1, fill = "#61D04F", id = 1), out)
    expect_equal(addLetter(list(), "A", 0, 0, 1, 1, fills), out)
    expect_error(addLetter(list(), "AA", 0, 0, 1, 1, fills), "must be one of") 
})

test_that("letters' functions and addLetter for T work", {
    out <- list(x = c(0.025, 0.975, 0.975, 0.595, 0.595, 0.405, 0.405, 0.025), y = c(1, 
        1, 0.9, 0.9, 0, 0, 0.9, 0.9), id = c(1, 1, 1, 1, 1, 1, 1, 1), fill = "#DF536B")
    expect_equal(letterT(0, 0, 1, 1, fill = "#DF536B", id = NULL), out)
    expect_equal(letterT(0, 0, 1, 1, fill = "#DF536B", id = 1), out)
    expect_equal(addLetter(list(), "T", 0, 0, 1, 1, fills), out) 
})

test_that("letters' functions and addLetter for U work", {
    fills2 = c(A = "#61D04F", C = "#2297E6", G = "#F5C710", U = "#DF536B")
    out <- list(x = c(0.975, 0.974940210645091, 0.974760857632013, 0.974461986111929, 
        0.974043671324145, 0.973506018577173, 0.972849163222215, 0.972073270619096, 
        0.971178536094628, 0.970165184893443, 0.969033472121287, 0.967783682680799, 
        0.966416131199786, 0.96493116195202, 0.963329148770568, 0.961610494953682, 
        0.959775633163269, 0.957825025315972, 0.955759162466886, 0.953578564685935, 
        0.951283780926949, 0.948875388889467, 0.946353994873307, 0.943720233625926, 
        0.940974768182634, 0.938118289699676, 0.935151517280233, 0.932075197793396, 
        0.928890105686145, 0.925597042788385, 0.922196838111089, 0.918690347637601, 
        0.915078454108148, 0.911362066797608, 0.907542121286614, 0.903619579226019, 
        0.899595428094811, 0.895470680951516, 0.891246376179171, 0.88692357722391, 
        0.882503372327253, 0.877986874252145, 0.873375220002824, 0.868669570538585, 
        0.863871110481515, 0.858981047818273, 0.854000613595984, 0.848931061612328, 
        0.843773668099908, 0.83852973140496, 0.833200571660502, 0.827787530454003, 
        0.822291970489638, 0.816715275245238, 0.81105884862401, 0.805324114601106, 
        0.799512516865148, 0.793625518454788, 0.787664601390392, 0.781631266300954, 
        0.775527032046319, 0.769353435334816, 0.763112030336402, 0.756804388291409, 
        0.750432097114989, 0.743996760997368, 0.7375, 0.730943449647723, 0.724328760517024, 
        0.71765759782052, 0.710931640987743, 0.704152583242357, 0.697322131175896, 
        0.690442004318142, 0.683513934704236, 0.676539666438656, 0.669520955256139, 
        0.662459568079693, 0.655357282575775, 0.648215886706781, 0.641037178280931, 
        0.633822964499679, 0.626575061502767, 0.619295293911013, 0.611985494366978, 
        0.604647503073607, 0.597283167330966, 0.589894341071195, 0.582482884391792, 
        0.575050663087341, 0.567599548179811, 0.560131415447531, 0.55264814495298, 
        0.545151620569487, 0.537643729506975, 0.530126361836868, 0.522601410016278, 
        0.515070768411582, 0.507536332821534, 0.5, 0.5, 0.492463667178466, 0.484929231588418, 
        0.477398589983723, 0.469873638163132, 0.462356270493025, 0.454848379430513, 
        0.44735185504702, 0.439868584552469, 0.43240045182019, 0.424949336912659, 
        0.417517115608208, 0.410105658928805, 0.402716832669034, 0.395352496926393, 
        0.388014505633022, 0.380704706088987, 0.373424938497233, 0.366177035500321, 
        0.358962821719069, 0.351784113293219, 0.344642717424225, 0.337540431920307, 
        0.330479044743861, 0.323460333561345, 0.316486065295764, 0.309557995681858, 
        0.302677868824104, 0.295847416757643, 0.289068359012257, 0.28234240217948, 
        0.275671239482976, 0.269056550352277, 0.2625, 0.256003239002632, 0.249567902885011, 
        0.243195611708591, 0.236887969663598, 0.230646564665184, 0.224472967953681, 
        0.218368733699046, 0.212335398609608, 0.206374481545212, 0.200487483134852, 
        0.194675885398894, 0.18894115137599, 0.183284724754762, 0.177708029510362, 
        0.172212469545997, 0.166799428339497, 0.16147026859504, 0.156226331900092, 
        0.151068938387672, 0.145999386404017, 0.141018952181727, 0.136128889518485, 
        0.131330429461416, 0.126624779997176, 0.122013125747855, 0.117496627672747, 
        0.113076422776091, 0.10875362382083, 0.104529319048484, 0.100404571905189, 
        0.0963804207739808, 0.0924578787133859, 0.0886379332023916, 0.0849215458918522, 
        0.0813096523623987, 0.0778031618889114, 0.0744029572116154, 0.071109894313855, 
        0.0679248022066037, 0.064848482719767, 0.0618817103003239, 0.0590252318173656, 
        0.0562797663740743, 0.0536460051266935, 0.0511246111105325, 0.0487162190730509, 
        0.046421435314065, 0.0442408375331138, 0.0421749746840276, 0.0402243668367308, 
        0.0383895050463177, 0.0366708512294317, 0.0350688380479801, 0.0335838688002144, 
        0.0322163173192012, 0.0309665278787127, 0.029834815106557, 0.0288214639053722, 
        0.0279267293809043, 0.0271508367777848, 0.0264939814228274, 0.0259563286758549, 
        0.0255380138880712, 0.0252391423679871, 0.0250597893549093, 0.025, 0.025, 
        0.215, 0.215, 0.215, 0.215035873612946, 0.215143485420792, 0.215322808332843, 
        0.215573797205513, 0.215896388853696, 0.216290502066671, 0.216756037628543, 
        0.217292878343223, 0.217900889063934, 0.218579916727228, 0.219329790391521, 
        0.220150321280129, 0.221041302828788, 0.222002510737659, 0.223033703027791, 
        0.224134620102038, 0.225304984810417, 0.226544502519868, 0.227852861188439, 
        0.229229731443831, 0.23067476666632, 0.232187603076016, 0.233767859824445, 
        0.235415139090419, 0.237129026180194, 0.23890908963186, 0.240754881323962, 
        0.242665936588313, 0.244641774326969, 0.246681897133347, 0.248785791417439, 
        0.250952927535111, 0.253182759921435, 0.255474727228032, 0.257828252464388, 
        0.260242743143113, 0.26271759142909, 0.265252174292498, 0.267845853665654, 
        0.270497976603648, 0.273207875448713, 0.275974867998306, 0.278798257676849, 
        0.281677333711091, 0.284611371309036, 0.28759963184241, 0.290641363032603, 
        0.293735799140055, 0.296882161157024, 0.300079657003698, 0.303327481727598, 
        0.306624817706217, 0.309970834852857, 0.313364690825594, 0.316805531239336, 
        0.320292489880911, 0.323824688927128, 0.327401239165765, 0.331021240219428, 
        0.334683780772209, 0.33838793879911, 0.342132781798159, 0.345917367025155, 
        0.349740741731007, 0.353601943401579, 0.3575, 0.361433930211366, 0.365402743689785, 
        0.369405441307688, 0.373441015407354, 0.377508450054586, 0.381606721294462, 
        0.385734797409115, 0.389891639177458, 0.394076200136807, 0.398287426846317, 
        0.402524259152184, 0.406785630454535, 0.411070467975931, 0.415377693031442, 
        0.419706221300193, 0.42405496309834, 0.428422823653393, 0.432808703379813, 
        0.437211498155836, 0.441630099601421, 0.446063395357283, 0.450510269364925, 
        0.454969602147595, 0.459440271092114, 0.463921150731481, 0.468411113028212, 
        0.472909027658308, 0.477413762295815, 0.481924182897879, 0.486439153990234, 
        0.490957538953051, 0.49547820030708, 0.5, 0.5, 0.50452179969292, 0.509042461046949, 
        0.513560846009766, 0.518075817102121, 0.522586237704185, 0.527090972341692, 
        0.531588886971788, 0.536078849268519, 0.540559728907886, 0.545030397852405, 
        0.549489730635075, 0.553936604642717, 0.558369900398579, 0.562788501844164, 
        0.567191296620187, 0.571577176346608, 0.57594503690166, 0.580293778699807, 
        0.584622306968558, 0.588929532024069, 0.593214369545465, 0.597475740847816, 
        0.601712573153683, 0.605923799863193, 0.610108360822542, 0.614265202590885, 
        0.618393278705538, 0.622491549945414, 0.626558984592646, 0.630594558692312, 
        0.634597256310214, 0.638566069788634, 0.6425, 0.646398056598421, 0.650259258268993, 
        0.654082632974845, 0.657867218201841, 0.66161206120089, 0.665316219227791, 
        0.668978759780572, 0.672598760834235, 0.676175311072873, 0.679707510119089, 
        0.683194468760664, 0.686635309174406, 0.690029165147143, 0.693375182293783, 
        0.696672518272402, 0.699920342996301, 0.703117838842976, 0.706264200859945, 
        0.709358636967397, 0.71240036815759, 0.715388628690964, 0.718322666288909, 
        0.721201742323151, 0.724025132001694, 0.726792124551287, 0.729502023396352, 
        0.732154146334346, 0.734747825707502, 0.73728240857091, 0.739757256856887, 
        0.742171747535612, 0.744525272771969, 0.746817240078565, 0.749047072464889, 
        0.751214208582561, 0.753318102866653, 0.755358225673031, 0.757334063411687, 
        0.759245118676038, 0.76109091036814, 0.762870973819806, 0.764584860909581, 
        0.766232140175555, 0.767812396923984, 0.76932523333368, 0.770770268556169, 
        0.772147138811561, 0.773455497480132, 0.774695015189584, 0.775865379897962, 
        0.776966296972209, 0.777997489262341, 0.778958697171212, 0.779849678719871, 
        0.780670209608479, 0.781420083272772, 0.782099110936066, 0.782707121656777, 
        0.783243962371457, 0.783709497933329, 0.784103611146304, 0.784426202794487, 
        0.784677191667157, 0.784856514579208, 0.784964126387054, 0.785, 0.785, 0.785, 
        0.975, 0.975), y = c(0.5, 0.492067018082596, 0.484136033250966, 0.476209042088129, 
        0.468288040171718, 0.460375021571606, 0.452471978347909, 0.444580900049495, 
        0.436703773213125, 0.428842580863357, 0.420999302013325, 0.413175911166535, 
        0.405374377819795, 0.397596665967405, 0.38984473360673, 0.382120532245286, 
        0.37442600640946, 0.366763093154983, 0.359133721579285, 0.351539812335863, 
        0.343983277150756, 0.336466018341289, 0.328989928337166, 0.321556889204064, 
        0.314168772169836, 0.306827437153436, 0.299534732296693, 0.292292493499057, 
        0.285102543955414, 0.277966693697113, 0.270886739136295, 0.263864462613659, 
        0.256901631949766, 0.25, 0.243161304213297, 0.236387266194749, 0.229679591272201, 
        0.223039968066945, 0.216470068068615, 0.209971545214401, 0.20354603547268, 
        0.197195156431167, 0.190920506889697, 0.184723666457739, 0.17860619515673, 
        0.172569633027358, 0.166615499741854, 0.160745294221434, 0.154960494258944, 
        0.149262556146839, 0.143652914310569, 0.138132980947465, 0.132704145671233, 
        0.127367775162123, 0.122125212822871, 0.116977778440511, 0.111926767854122, 
        0.106973452628606, 0.102119079734584, 0.0973648712344707, 0.0927120239748321, 
        0.0881617092850837, 0.0837150726826144, 0.0793732335844095, 0.0751372850252429, 
        0.0710082933825115, 0.0669872981077806, 0.0630753114651075, 0.059273318276209, 
        0.0555822756725383, 0.052003112854332, 0.0485367308566894, 0.0451840023227408, 
        0.0419457712839653, 0.0388228529477093, 0.0358160334919637, 0.0329260698674467, 
        0.0301536896070458, 0.0274995906426658, 0.0249644411295273, 0.0225488792779631, 
        0.0202535131927513, 0.018078920720029, 0.0160256493018219, 0.0140942158382292, 
        0.0122851065572965, 0.0105987768926106, 0.0090356513686467, 0.00759612349389593, 
        0.00628055566180286, 0.00508927905953366, 0.00402259358460233, 0.00308076776937294, 
        0.00226403871345771, 0.00157261202402886, 0.00100666176405778, 0.000566330408496019, 
        0.000251728808407459, 6.29361630624659e-05, 0, 0, 6.29361630624659e-05, 0.000251728808407403, 
        0.000566330408496019, 0.00100666176405778, 0.00157261202402881, 0.00226403871345771, 
        0.00308076776937294, 0.00402259358460233, 0.0050892790595336, 0.0062805556618028, 
        0.00759612349389593, 0.00903565136864665, 0.0105987768926106, 0.0122851065572965, 
        0.0140942158382291, 0.0160256493018218, 0.0180789207200289, 0.0202535131927513, 
        0.0225488792779631, 0.0249644411295273, 0.0274995906426658, 0.0301536896070458, 
        0.0329260698674466, 0.0358160334919637, 0.0388228529477093, 0.0419457712839652, 
        0.0451840023227408, 0.0485367308566894, 0.0520031128543321, 0.0555822756725383, 
        0.059273318276209, 0.0630753114651075, 0.0669872981077807, 0.0710082933825114, 
        0.0751372850252428, 0.0793732335844094, 0.0837150726826143, 0.0881617092850836, 
        0.0927120239748321, 0.0973648712344706, 0.102119079734584, 0.106973452628606, 
        0.111926767854122, 0.116977778440511, 0.122125212822871, 0.127367775162123, 
        0.132704145671233, 0.138132980947465, 0.143652914310569, 0.149262556146839, 
        0.154960494258944, 0.160745294221434, 0.166615499741854, 0.172569633027357, 
        0.17860619515673, 0.184723666457739, 0.190920506889697, 0.197195156431167, 
        0.20354603547268, 0.209971545214401, 0.216470068068614, 0.223039968066945, 
        0.229679591272201, 0.236387266194749, 0.243161304213297, 0.25, 0.256901631949766, 
        0.263864462613658, 0.270886739136295, 0.277966693697113, 0.285102543955414, 
        0.292292493499057, 0.299534732296693, 0.306827437153436, 0.314168772169836, 
        0.321556889204064, 0.328989928337166, 0.336466018341289, 0.343983277150756, 
        0.351539812335862, 0.359133721579285, 0.366763093154982, 0.37442600640946, 
        0.382120532245287, 0.38984473360673, 0.397596665967405, 0.405374377819795, 
        0.413175911166535, 0.420999302013325, 0.428842580863357, 0.436703773213125, 
        0.444580900049494, 0.452471978347909, 0.460375021571606, 0.468288040171718, 
        0.476209042088129, 0.484136033250966, 0.492067018082596, 0.5, 1, 1, 0.5, 
        0.5, 0.494446912657817, 0.488895223275676, 0.48334632946169, 0.477801628120202, 
        0.472262515100124, 0.466730384843536, 0.461206630034646, 0.455692641249188, 
        0.45018980660435, 0.444699511409327, 0.439223137816574, 0.433762064473856, 
        0.428317666177183, 0.422891313524711, 0.417484372571701, 0.412098204486622, 
        0.406734165208488, 0.4013936051055, 0.396077868635104, 0.39078829400553, 
        0.385526212838902, 0.380292949836016, 0.375089822442845, 0.369918140518885, 
        0.364779206007405, 0.359674312607685, 0.35460474544934, 0.34957178076879, 
        0.344576685587979, 0.339620717395406, 0.334705123829561, 0.329831142364836, 
        0.325, 0.320212912949308, 0.315471086336324, 0.310775713890541, 0.306127977646861, 
        0.30152904764803, 0.296980081650081, 0.292482224830876, 0.288036609501817, 
        0.283644354822788, 0.279306566520417, 0.275024336609711, 0.27079874311915, 
        0.266630849819298, 0.262521705955004, 0.258472345981261, 0.254483789302788, 
        0.250557040017398, 0.246693086663225, 0.242892901969863, 0.239157442613486, 
        0.23548764897601, 0.231884444908358, 0.228348737497885, 0.224881416840024, 
        0.221483355814209, 0.218155409864129, 0.214898416782382, 0.211713196499559, 
        0.20860055087783, 0.205561263509087, 0.20259609951767, 0.199705805367758, 
        0.196891108675447, 0.194152718025575, 0.191491322793346, 0.188907592970777, 
        0.186402178998032, 0.183975711599683, 0.181628801625919, 0.179362039898776, 
        0.177175997063396, 0.175071223444375, 0.173048248907213, 0.171107582724932, 
        0.169249713449866, 0.167475108790669, 0.165784215494574, 0.164177459234926, 
        0.16265524450402, 0.161217954511275, 0.15986595108676, 0.158599574590108, 
        0.157419143824827, 0.156324955958053, 0.155317286445727, 0.154396388963262, 
        0.153562495341674, 0.152815815509222, 0.152156537438561, 0.15158482709942, 
        0.15110082841682, 0.15070466323484, 0.150396431285947, 0.150176210165885, 
        0.150044055314144, 0.15, 0.15, 0.150044055314144, 0.150176210165885, 0.150396431285947, 
        0.15070466323484, 0.15110082841682, 0.15158482709942, 0.152156537438561, 
        0.152815815509222, 0.153562495341674, 0.154396388963262, 0.155317286445727, 
        0.156324955958053, 0.157419143824827, 0.158599574590108, 0.15986595108676, 
        0.161217954511275, 0.16265524450402, 0.164177459234926, 0.165784215494574, 
        0.167475108790669, 0.169249713449866, 0.171107582724932, 0.173048248907213, 
        0.175071223444375, 0.177175997063397, 0.179362039898776, 0.181628801625919, 
        0.183975711599683, 0.186402178998032, 0.188907592970777, 0.191491322793346, 
        0.194152718025575, 0.196891108675446, 0.199705805367758, 0.20259609951767, 
        0.205561263509087, 0.20860055087783, 0.211713196499559, 0.214898416782383, 
        0.21815540986413, 0.221483355814209, 0.224881416840024, 0.228348737497885, 
        0.231884444908358, 0.23548764897601, 0.239157442613486, 0.242892901969863, 
        0.246693086663225, 0.250557040017398, 0.254483789302788, 0.258472345981261, 
        0.262521705955004, 0.266630849819298, 0.27079874311915, 0.275024336609711, 
        0.279306566520417, 0.283644354822788, 0.288036609501817, 0.292482224830876, 
        0.296980081650081, 0.30152904764803, 0.306127977646861, 0.310775713890541, 
        0.315471086336324, 0.320212912949308, 0.325, 0.329831142364836, 0.334705123829561, 
        0.339620717395406, 0.344576685587979, 0.34957178076879, 0.35460474544934, 
        0.359674312607685, 0.364779206007405, 0.369918140518885, 0.375089822442845, 
        0.380292949836016, 0.385526212838902, 0.39078829400553, 0.396077868635104, 
        0.4013936051055, 0.406734165208488, 0.412098204486622, 0.417484372571701, 
        0.422891313524711, 0.428317666177183, 0.433762064473856, 0.439223137816574, 
        0.444699511409328, 0.45018980660435, 0.455692641249188, 0.461206630034646, 
        0.466730384843536, 0.472262515100124, 0.477801628120202, 0.48334632946169, 
        0.488895223275676, 0.494446912657817, 0.5, 0.5, 1, 1, 0.85), id = c(1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1), fill = "#DF536B")
    expect_equal(letterU(0, 0, 1, 1, fill = "#DF536B", id = NULL), out)
    expect_equal(letterU(0, 0, 1, 1, fill = "#DF536B", id = 1), out)
    expect_equal(addLetter(list(), "U", 0, 0, 1, 1, fills2), out) 
})

test_that("letters' functions and addLetter for C work", {
    out <- list(x = c(0.975, 0.973118791873872, 0.971161416153933, 0.969128195355054, 
        0.967019464489026, 0.964835571009361, 0.962576874754039, 0.960243747886219, 
        0.957836574832923, 0.955355752221685, 0.952801688815208, 0.950174805444006, 
        0.947475534937069, 0.944704322050544, 0.941861623394451, 0.938947907357454, 
        0.935963654029676, 0.932909355123605, 0.929785513893065, 0.926592645050305, 
        0.923331274681183, 0.920001940158487, 0.916605190053391, 0.91314158404507, 
        0.909611692828479, 0.906016098020321, 0.902355392063216, 0.898630178128085, 
        0.894841070014764, 0.890988692050868, 0.887073678988927, 0.883096675901792, 
        0.87905833807635, 0.874959330905552, 0.870800329778778, 0.866582019970552, 
        0.862305096527634, 0.857970264154492, 0.853578237097192, 0.849129739025714, 
        0.844625502914707, 0.840066270922727, 0.835452794269944, 0.830785833114369, 
        0.826066156426601, 0.821294541863125, 0.816471775638179, 0.811598652394212, 
        0.806675975070947, 0.801704554773084, 0.796685210636656, 0.79161876969406, 
        0.786506066737787, 0.781347944182873, 0.7761452519281, 0.770898847215951, 
        0.765609594491372, 0.760278365259331, 0.754906037941226, 0.749493497730144, 
        0.744041636445013, 0.738551352383653, 0.73302355017477, 0.727459140628896, 
        0.72185904058832, 0.716224172776016, 0.710555465643612, 0.704853853218407, 
        0.699120274949471, 0.693355675552857, 0.687561004855937, 0.681737217640902, 
        0.675885273487444, 0.670006136614645, 0.664100775722105, 0.65817016383033, 
        0.652215278120407, 0.646237099772999, 0.640236613806671, 0.634214808915594, 
        0.628172677306638, 0.622111214535883, 0.61603141934459, 0.609934293494632, 
        0.603820841603438, 0.597692070978463, 0.591548991451215, 0.585392615210865, 
        0.579223956637471, 0.573044032134839, 0.566853859963051, 0.560654460070687, 
        0.554446853926769, 0.548232064352457, 0.542011115352515, 0.535785031946592, 
        0.529554840000326, 0.523321566056317, 0.51708623716498, 0.510849880715326, 
        0.510849880715326, 0.503141404078751, 0.495434868009946, 0.487732212588154, 
        0.480035376915686, 0.472346298629761, 0.464666913414718, 0.456999154514718, 
        0.44934495224706, 0.44170623351623, 0.434084921328819, 0.426482934309414, 
        0.418902186217594, 0.41134458546615, 0.403812034640655, 0.396306430020499, 
        0.388829661101505, 0.381383610120265, 0.373970151580294, 0.366591151780134, 
        0.359248468343524, 0.351943949751752, 0.344679434878311, 0.337456752525972, 
        0.330277720966391, 0.323144147482372, 0.316057827912891, 0.309020546201004, 
        0.302034073944748, 0.295100169951152, 0.288220579793465, 0.281397035371719, 
        0.274631254476733, 0.267924940357663, 0.261279781293227, 0.254697450166681, 
        0.248179604044688, 0.241727883760151, 0.23534391349915, 0.229029300392059, 
        0.222785634108958, 0.216614486459445, 0.210517410996938, 0.20449594262758, 
        0.198551597223831, 0.192685871242858, 0.186900241349809, 0.181196164046067, 
        0.175575075302592, 0.170038390198413, 0.164587502564397, 0.159223784632356, 
        0.153948586689596, 0.148763236738988, 0.143669040164651, 0.138667279403332, 
        0.133759213621554, 0.12894607839863, 0.124229085415613, 0.119609422150261, 
        0.115088251578097, 0.110666711879634, 0.106345916153846, 0.10212695213795, 
        0.0980108819335754, 0.0939987417393841, 0.0900915415902144, 0.0862902651028091, 
        0.0825958692281955, 0.0790092840107782, 0.0755314123542057, 0.0721631297940689, 
        0.0689052842774892, 0.0657586959496537, 0.0627241569473464, 0.0598024311995334, 
        0.0569942542350469, 0.0543003329974203, 0.051721345666919, 0.0492579414898112, 
        0.0469107406149253, 0.044680333937529, 0.0425672829505759, 0.0405721196033516, 
        0.0386953461675594, 0.0369374351108752, 0.0352988289780065, 0.0337799402792845, 
        0.0323811513868165, 0.0311028144382258, 0.0299452512480029, 0.0289087532264906, 
        0.0279935813065229, 0.0271999658777366, 0.0265281067285718, 0.0259781729959763, 
        0.0255503031228265, 0.0252446048230748, 0.0250611550546332, 0.025, 0.025, 
        0.0250611550546332, 0.0252446048230748, 0.0255503031228265, 0.0259781729959763, 
        0.0265281067285718, 0.0271999658777366, 0.0279935813065229, 0.0289087532264906, 
        0.0299452512480029, 0.0311028144382258, 0.0323811513868165, 0.0337799402792845, 
        0.0352988289780065, 0.0369374351108752, 0.0386953461675594, 0.0405721196033516, 
        0.0425672829505759, 0.044680333937529, 0.0469107406149253, 0.0492579414898112, 
        0.051721345666919, 0.0543003329974203, 0.0569942542350469, 0.0598024311995334, 
        0.0627241569473464, 0.0657586959496537, 0.0689052842774892, 0.0721631297940689, 
        0.0755314123542057, 0.0790092840107782, 0.0825958692281955, 0.0862902651028091, 
        0.0900915415902144, 0.0939987417393841, 0.0980108819335754, 0.10212695213795, 
        0.106345916153846, 0.110666711879634, 0.115088251578097, 0.119609422150261, 
        0.124229085415613, 0.12894607839863, 0.133759213621554, 0.138667279403332, 
        0.143669040164651, 0.148763236738988, 0.153948586689596, 0.159223784632356, 
        0.164587502564397, 0.170038390198413, 0.175575075302592, 0.181196164046067, 
        0.186900241349809, 0.192685871242858, 0.198551597223831, 0.20449594262758, 
        0.210517410996938, 0.216614486459445, 0.222785634108958, 0.229029300392059, 
        0.23534391349915, 0.241727883760151, 0.248179604044688, 0.254697450166681, 
        0.261279781293227, 0.267924940357663, 0.274631254476733, 0.281397035371719, 
        0.288220579793465, 0.295100169951152, 0.302034073944748, 0.309020546201004, 
        0.316057827912891, 0.323144147482372, 0.330277720966391, 0.337456752525972, 
        0.344679434878311, 0.351943949751752, 0.359248468343524, 0.366591151780134, 
        0.373970151580294, 0.381383610120265, 0.388829661101505, 0.396306430020499, 
        0.403812034640655, 0.41134458546615, 0.418902186217594, 0.426482934309414, 
        0.434084921328819, 0.44170623351623, 0.44934495224706, 0.456999154514718, 
        0.464666913414718, 0.472346298629761, 0.480035376915686, 0.487732212588154, 
        0.495434868009946, 0.503141404078751, 0.510849880715326, 0.510849880715326, 
        0.51708623716498, 0.523321566056317, 0.529554840000326, 0.535785031946592, 
        0.542011115352515, 0.548232064352457, 0.554446853926769, 0.560654460070687, 
        0.566853859963051, 0.573044032134839, 0.579223956637471, 0.585392615210865, 
        0.591548991451215, 0.597692070978463, 0.603820841603438, 0.609934293494632, 
        0.61603141934459, 0.622111214535883, 0.628172677306638, 0.634214808915594, 
        0.640236613806671, 0.646237099772999, 0.652215278120407, 0.65817016383033, 
        0.664100775722105, 0.670006136614645, 0.675885273487444, 0.681737217640902, 
        0.687561004855937, 0.693355675552857, 0.699120274949471, 0.704853853218407, 
        0.710555465643612, 0.716224172776016, 0.72185904058832, 0.727459140628896, 
        0.73302355017477, 0.738551352383653, 0.744041636445013, 0.749493497730144, 
        0.754906037941226, 0.760278365259331, 0.765609594491372, 0.770898847215951, 
        0.7761452519281, 0.781347944182873, 0.786506066737787, 0.79161876969406, 
        0.796685210636656, 0.801704554773084, 0.806675975070947, 0.811598652394212, 
        0.816471775638179, 0.821294541863125, 0.826066156426601, 0.830785833114369, 
        0.835452794269944, 0.840066270922727, 0.844625502914707, 0.849129739025714, 
        0.853578237097192, 0.857970264154492, 0.862305096527634, 0.866582019970552, 
        0.870800329778778, 0.874959330905552, 0.87905833807635, 0.883096675901792, 
        0.887073678988927, 0.890988692050868, 0.894841070014764, 0.898630178128085, 
        0.902355392063216, 0.906016098020321, 0.909611692828479, 0.91314158404507, 
        0.916605190053391, 0.920001940158487, 0.923331274681183, 0.926592645050305, 
        0.929785513893065, 0.932909355123605, 0.935963654029676, 0.938947907357454, 
        0.941861623394451, 0.944704322050544, 0.947475534937069, 0.950174805444006, 
        0.952801688815208, 0.955355752221685, 0.957836574832923, 0.960243747886219, 
        0.962576874754039, 0.964835571009361, 0.967019464489026, 0.969128195355054, 
        0.971161416153933, 0.973118791873872, 0.975, 0.818377328025402, 0.816487838670546, 
        0.814547989649978, 0.812558100590714, 0.810518499364815, 0.808429522035371, 
        0.806291512801121, 0.804104823939743, 0.801869815749811, 0.799586856491426, 
        0.797256322325539, 0.794878597251972, 0.792454073046147, 0.789983149194533, 
        0.787466232828822, 0.784903738658849, 0.782296088904258, 0.779643713224932, 
        0.776947048650205, 0.774206539506847, 0.771422637345852, 0.768595800868043, 
        0.765726495848484, 0.762815195059742, 0.759862378193984, 0.756868531783942, 
        0.753834149122742, 0.750759730182633, 0.747645781532598, 0.744492816254893, 
        0.741301353860507, 0.738071920203559, 0.734805047394656, 0.731501273713218, 
        0.728161143518785, 0.724785207161323, 0.721374020890546, 0.71792814676426, 
        0.714448152555756, 0.710934611660257, 0.70738810300044, 0.703809210931049, 
        0.700198525142609, 0.696556640564268, 0.692884157265764, 0.689181680358558, 
        0.68544981989613, 0.681689190773456, 0.677900412625699, 0.674084109726107, 
        0.670240910883155, 0.666371449336937, 0.662476362654825, 0.658556292626422, 
        0.654611885157809, 0.650643790165126, 0.646652661467482, 0.642639156679227, 
        0.638603937101597, 0.634547667613753, 0.630471016563229, 0.626374655655809, 
        0.622259259844849, 0.618125507220071, 0.613974078895829, 0.609805658898883, 
        0.605620934055697, 0.601420593879268, 0.597205330455514, 0.592975838329244, 
        0.588732814389716, 0.584476957755811, 0.58020896966084, 0.575929553337004, 
        0.571639413899522, 0.567339258230448, 0.563029794862203, 0.558711733860828, 
        0.554385786708985, 0.550052666188734, 0.545713086264079, 0.541367761963336, 
        0.537017409261318, 0.532662744961358, 0.528304486577212, 0.523943352214826, 
        0.519580060454019, 0.515215330230084, 0.510849880715326, 0.510849880715326, 
        0.505453947069723, 0.50005937182156, 0.494667513026306, 0.489279728055578, 
        0.48389737325543, 0.4785218036049, 0.473154372374901, 0.467796430787539, 
        0.462449327675958, 0.457114409144771, 0.451793018231188, 0.446486494566913, 
        0.441196174040903, 0.435923388463057, 0.430669465228947, 0.425435726985651, 
        0.420223491298783, 0.415034070320803, 0.409868770460691, 0.404728892055065, 
        0.399615729040824, 0.394530568629416, 0.389474690982778, 0.384449368891071, 
        0.379455867452258, 0.374495443753621, 0.3695693465553, 0.364678815975921, 
        0.359825083180404, 0.355009370070023, 0.350232888974801, 0.345496842348311, 
        0.340802422464962, 0.336150811119857, 0.331543179331275, 0.326980687045879, 
        0.322464482846703, 0.317995703664003, 0.313575474489039, 0.309204908090868, 
        0.304885104736209, 0.300617151912454, 0.296402124053904, 0.29224108227128, 
        0.288135074084599, 0.284085133159464, 0.280092279046845, 0.276157516926412, 
        0.272281837353487, 0.268466216009676, 0.264711613457247, 0.261018974897315, 
        0.257389229931889, 0.253823292329854, 0.25032205979693, 0.246886413749686, 
        0.243517219093639, 0.240215324005527, 0.236981559719781, 0.233816740319266, 
        0.230721662530342, 0.22769710552229, 0.224743830711163, 0.221862581568101, 
        0.219054083432167, 0.216319043327748, 0.213658149786564, 0.211072072674335, 
        0.208561463022143, 0.206126952862542, 0.203769155070446, 0.20148866320884, 
        0.199286051379355, 0.19716187407774, 0.195116666054271, 0.193150942179131, 
        0.191265197312792, 0.189459906181441, 0.187735523257466, 0.186092482645046, 
        0.184531197970868, 0.183052062280001, 0.181655447936944, 0.180341706531889, 
        0.17911116879221, 0.177964144499202, 0.176900922410097, 0.175921770185369, 
        0.175026934321356, 0.1742166400882, 0.173491091473141, 0.172850471129164, 
        0.172294940329013, 0.171824638924598, 0.171439685311781, 0.171140176400576, 
        0.17092618759075, 0.170797772752841, 0.170754964214598, 0.170754964214598, 
        0.170797772752841, 0.17092618759075, 0.171140176400576, 0.171439685311781, 
        0.171824638924598, 0.172294940329013, 0.172850471129164, 0.173491091473141, 
        0.1742166400882, 0.175026934321356, 0.175921770185369, 0.176900922410097, 
        0.177964144499202, 0.17911116879221, 0.180341706531889, 0.181655447936944, 
        0.183052062280001, 0.184531197970868, 0.186092482645046, 0.187735523257466, 
        0.189459906181441, 0.191265197312792, 0.193150942179131, 0.195116666054271, 
        0.19716187407774, 0.199286051379355, 0.20148866320884, 0.203769155070446, 
        0.206126952862542, 0.208561463022143, 0.211072072674335, 0.213658149786564, 
        0.216319043327748, 0.219054083432167, 0.221862581568101, 0.224743830711163, 
        0.22769710552229, 0.230721662530342, 0.233816740319266, 0.236981559719781, 
        0.240215324005527, 0.243517219093639, 0.246886413749686, 0.25032205979693, 
        0.253823292329854, 0.257389229931889, 0.261018974897315, 0.264711613457247, 
        0.268466216009676, 0.272281837353487, 0.276157516926412, 0.280092279046845, 
        0.284085133159464, 0.288135074084599, 0.29224108227128, 0.296402124053904, 
        0.300617151912454, 0.304885104736209, 0.309204908090868, 0.313575474489039, 
        0.317995703664003, 0.322464482846703, 0.326980687045879, 0.331543179331275, 
        0.336150811119857, 0.340802422464962, 0.345496842348311, 0.350232888974801, 
        0.355009370070023, 0.359825083180404, 0.364678815975921, 0.3695693465553, 
        0.374495443753621, 0.379455867452258, 0.384449368891071, 0.389474690982778, 
        0.394530568629416, 0.399615729040824, 0.404728892055065, 0.409868770460691, 
        0.415034070320803, 0.420223491298783, 0.425435726985651, 0.430669465228947, 
        0.435923388463057, 0.441196174040903, 0.446486494566913, 0.451793018231188, 
        0.457114409144771, 0.462449327675958, 0.467796430787539, 0.473154372374901, 
        0.4785218036049, 0.48389737325543, 0.489279728055578, 0.494667513026306, 
        0.50005937182156, 0.505453947069723, 0.510849880715326, 0.510849880715326, 
        0.515215330230084, 0.519580060454019, 0.523943352214826, 0.528304486577212, 
        0.532662744961358, 0.537017409261318, 0.541367761963336, 0.545713086264079, 
        0.550052666188734, 0.554385786708985, 0.558711733860828, 0.563029794862203, 
        0.567339258230448, 0.571639413899522, 0.575929553337004, 0.58020896966084, 
        0.584476957755811, 0.588732814389716, 0.592975838329244, 0.597205330455514, 
        0.601420593879268, 0.605620934055697, 0.609805658898883, 0.613974078895829, 
        0.618125507220071, 0.622259259844849, 0.626374655655809, 0.630471016563229, 
        0.634547667613753, 0.638603937101597, 0.642639156679227, 0.646652661467482, 
        0.650643790165126, 0.654611885157809, 0.658556292626422, 0.662476362654825, 
        0.666371449336937, 0.670240910883155, 0.674084109726107, 0.677900412625699, 
        0.681689190773456, 0.68544981989613, 0.689181680358558, 0.692884157265764, 
        0.696556640564268, 0.700198525142609, 0.703809210931049, 0.70738810300044, 
        0.710934611660257, 0.714448152555756, 0.71792814676426, 0.721374020890546, 
        0.724785207161323, 0.728161143518785, 0.731501273713218, 0.734805047394656, 
        0.738071920203559, 0.741301353860507, 0.744492816254893, 0.747645781532598, 
        0.750759730182633, 0.753834149122742, 0.756868531783942, 0.759862378193984, 
        0.762815195059742, 0.765726495848484, 0.768595800868043, 0.771422637345852, 
        0.774206539506847, 0.776947048650205, 0.779643713224932, 0.782296088904258, 
        0.784903738658849, 0.787466232828822, 0.789983149194533, 0.792454073046147, 
        0.794878597251972, 0.797256322325539, 0.799586856491426, 0.801869815749811, 
        0.804104823939743, 0.806291512801121, 0.808429522035371, 0.810518499364815, 
        0.812558100590714, 0.814547989649978, 0.816487838670546, 0.818377328025402), 
        y = c(0.35223989666933, 0.34612073263227, 0.340026923130741, 0.33395947223574, 
            0.327919379675185, 0.321907640669185, 0.315925245766064, 0.309973180679145, 
            0.304052426124338, 0.298163957658548, 0.292308745518931, 0.286487754463035, 
            0.280701943609828, 0.274952266281675, 0.269239669847253, 0.263565095565459, 
            0.257929478430315, 0.252333747016914, 0.246778823328416, 0.241265622644135, 
            0.235795053368724, 0.230368016882501, 0.224985407392931, 0.219648111787286, 
            0.214357009486512, 0.209112972300331, 0.203916864283593, 0.198769541593905, 
            0.193671852350563, 0.188624636494809, 0.183628725651438, 0.178684942991763, 
            0.173794103097991, 0.168957011829001, 0.164174466187564, 0.159447254189021, 
            0.154776154731443, 0.150161937467294, 0.145605362676613, 0.141107181141748, 
            0.136668134023645, 0.132288952739732, 0.127970358843401, 0.123713063905123, 
            0.119517769395194, 0.115385166568167, 0.111315936348944, 0.107310749220585, 
            0.103370265113835, 0.0994951332983836, 0.0956859922758889, 0.0919434696747705, 
            0.0882681821467963, 0.0846607352654773, 0.0811217234262882, 0.0776517297487281, 
            0.0742513259802431, 0.0709210724020169, 0.0676615177366564, 0.0644731990577775, 
            0.0613566417015131, 0.0583123591799534, 0.0553408530965351, 0.0524426130633929, 
            0.0496181166206864, 0.0468678291579163, 0.0441922038372426, 0.041591681518818, 
            0.0390666906881467, 0.0366176473854847, 0.0342449551372879, 0.0319490048897243, 
            0.029730174944258, 0.0275888308953167, 0.0255253255700531, 0.0235399989702101, 
            0.0216331782160988, 0.0198051774926994, 0.018056297997893, 0.0163868278928337, 
            0.0147970422544689, 0.0132872030302144, 0.0118575589947941, 0.0105083457092496, 
            0.00923978548212689, 0.00805208733284685, 0.00694544695726534, 0.00592004669542862, 
            0.00497605550152913, 0.00411362891606754, 0.00333290904022399, 0.0026340245124446, 
            0.00201709048724547, 0.00148220861623921, 0.00102946703138557, 0.000658940330470259, 
            0.000370689564813231, 0.000164762229209747, 4.11922541042609e-05, 0, 
            0, 6.29361630624659e-05, 0.000251728808407403, 0.000566330408496019, 
            0.00100666176405778, 0.00157261202402881, 0.00226403871345771, 0.00308076776937294, 
            0.00402259358460233, 0.0050892790595336, 0.0062805556618028, 0.00759612349389593, 
            0.00903565136864665, 0.0105987768926106, 0.0122851065572965, 0.0140942158382291, 
            0.0160256493018218, 0.0180789207200289, 0.0202535131927513, 0.0225488792779631, 
            0.0249644411295273, 0.0274995906426658, 0.0301536896070458, 0.0329260698674466, 
            0.0358160334919637, 0.0388228529477093, 0.0419457712839652, 0.0451840023227408, 
            0.0485367308566894, 0.0520031128543321, 0.0555822756725383, 0.059273318276209, 
            0.0630753114651075, 0.0669872981077807, 0.0710082933825114, 0.0751372850252428, 
            0.0793732335844094, 0.0837150726826143, 0.0881617092850836, 0.0927120239748321, 
            0.0973648712344706, 0.102119079734584, 0.106973452628606, 0.111926767854122, 
            0.116977778440511, 0.122125212822871, 0.127367775162123, 0.132704145671233, 
            0.138132980947465, 0.143652914310569, 0.149262556146839, 0.154960494258944, 
            0.160745294221434, 0.166615499741854, 0.172569633027357, 0.17860619515673, 
            0.184723666457739, 0.190920506889697, 0.197195156431167, 0.20354603547268, 
            0.209971545214401, 0.216470068068614, 0.223039968066945, 0.229679591272201, 
            0.236387266194749, 0.243161304213297, 0.25, 0.256901631949766, 0.263864462613658, 
            0.270886739136295, 0.277966693697113, 0.285102543955414, 0.292292493499057, 
            0.299534732296693, 0.306827437153436, 0.314168772169836, 0.321556889204064, 
            0.328989928337166, 0.336466018341289, 0.343983277150756, 0.351539812335862, 
            0.359133721579285, 0.366763093154982, 0.37442600640946, 0.382120532245287, 
            0.38984473360673, 0.397596665967405, 0.405374377819795, 0.413175911166535, 
            0.420999302013325, 0.428842580863357, 0.436703773213125, 0.444580900049494, 
            0.452471978347909, 0.460375021571606, 0.468288040171718, 0.476209042088129, 
            0.484136033250966, 0.492067018082596, 0.5, 0.5, 0.507932981917404, 0.515863966749034, 
            0.523790957911871, 0.531711959828282, 0.539624978428394, 0.547528021652091, 
            0.555419099950506, 0.563296226786875, 0.571157419136643, 0.579000697986675, 
            0.586824088833465, 0.594625622180205, 0.602403334032595, 0.61015526639327, 
            0.617879467754713, 0.62557399359054, 0.633236906845018, 0.640866278420715, 
            0.648460187664138, 0.656016722849244, 0.663533981658711, 0.671010071662834, 
            0.678443110795936, 0.685831227830164, 0.693172562846564, 0.700465267703307, 
            0.707707506500943, 0.714897456044586, 0.722033306302887, 0.729113260863705, 
            0.736135537386342, 0.743098368050234, 0.75, 0.756838695786703, 0.763612733805251, 
            0.770320408727799, 0.776960031933055, 0.783529931931386, 0.790028454785599, 
            0.79645396452732, 0.802804843568833, 0.809079493110303, 0.815276333542261, 
            0.82139380484327, 0.827430366972643, 0.833384500258146, 0.839254705778566, 
            0.845039505741056, 0.850737443853161, 0.856347085689431, 0.861867019052535, 
            0.867295854328767, 0.872632224837877, 0.877874787177129, 0.883022221559489, 
            0.888073232145878, 0.893026547371394, 0.897880920265416, 0.902635128765529, 
            0.907287976025168, 0.911838290714916, 0.916284927317386, 0.920626766415591, 
            0.924862714974757, 0.928991706617489, 0.933012701892219, 0.936924688534893, 
            0.940726681723791, 0.944417724327462, 0.947996887145668, 0.951463269143311, 
            0.954815997677259, 0.958054228716035, 0.961177147052291, 0.964183966508036, 
            0.967073930132553, 0.969846310392954, 0.972500409357334, 0.975035558870473, 
            0.977451120722037, 0.979746486807249, 0.981921079279971, 0.983974350698178, 
            0.985905784161771, 0.987714893442704, 0.989401223107389, 0.990964348631353, 
            0.992403876506104, 0.993719444338197, 0.994910720940466, 0.995977406415398, 
            0.996919232230627, 0.997735961286542, 0.998427387975971, 0.998993338235942, 
            0.999433669591504, 0.999748271191593, 0.999937063836938, 1, 1, 0.999958807745896, 
            0.99983523777079, 0.999629310435187, 0.99934105966953, 0.998970532968614, 
            0.998517791383761, 0.997982909512755, 0.997365975487555, 0.996667090959776, 
            0.995886371083933, 0.995023944498471, 0.994079953304571, 0.993054553042735, 
            0.991947912667153, 0.990760214517873, 0.98949165429075, 0.988142441005206, 
            0.986712796969786, 0.985202957745531, 0.983613172107166, 0.981943702002107, 
            0.980194822507301, 0.978366821783901, 0.97646000102979, 0.974474674429947, 
            0.972411169104683, 0.970269825055742, 0.968050995110276, 0.965755044862712, 
            0.963382352614515, 0.960933309311853, 0.958408318481182, 0.955807796162757, 
            0.953132170842084, 0.950381883379314, 0.947557386936607, 0.944659146903465, 
            0.941687640820047, 0.938643358298487, 0.935526800942222, 0.932338482263344, 
            0.929078927597983, 0.925748674019757, 0.922348270251272, 0.918878276573712, 
            0.915339264734523, 0.911731817853204, 0.908056530325229, 0.904314007724111, 
            0.900504866701616, 0.896629734886165, 0.892689250779415, 0.888684063651056, 
            0.884614833431833, 0.880482230604806, 0.876286936094878, 0.872029641156599, 
            0.867711047260268, 0.863331865976355, 0.858892818858252, 0.854394637323387, 
            0.849838062532706, 0.845223845268557, 0.840552745810979, 0.835825533812436, 
            0.831042988170999, 0.826205896902009, 0.821315057008237, 0.816371274348562, 
            0.811375363505191, 0.806328147649437, 0.801230458406095, 0.796083135716407, 
            0.790887027699669, 0.785642990513488, 0.780351888212714, 0.775014592607069, 
            0.769631983117499, 0.764204946631276, 0.758734377355865, 0.753221176671584, 
            0.747666252983086, 0.742070521569685, 0.736434904434541, 0.730760330152747, 
            0.725047733718325, 0.719298056390172, 0.713512245536965, 0.707691254481069, 
            0.701836042341452, 0.695947573875662, 0.690026819320855, 0.684074754233936, 
            0.678092359330815, 0.672080620324815, 0.66604052776426, 0.659973076869259, 
            0.65387926736773, 0.64776010333067, 0.64776010333067, 0.65350863947312, 
            0.657533413602828, 0.661532231106922, 0.665504433104179, 0.669449365098779, 
            0.67336637708816, 0.677254823670108, 0.681114064149106, 0.684943462641894, 
            0.688742388182249, 0.692510214824948, 0.6962463217489, 0.699950093359442, 
            0.703620919389768, 0.707258195001485, 0.710861320884267, 0.714429703354606, 
            0.717962754453633, 0.721459892043994, 0.724920539905766, 0.728344127831406, 
            0.731730091719699, 0.735077873668705, 0.738386922067685, 0.74165669168799, 
            0.744886643772894, 0.748076246126371, 0.751224973200776, 0.754332306183448, 
            0.757397733082188, 0.760420748809619, 0.763400855266414, 0.766337561423364, 
            0.769230383402283, 0.772078844555739, 0.77488247554559, 0.777640814420316, 
            0.780353406691132, 0.783019805406878, 0.785639571227661, 0.788212272497243, 
            0.790737485314166, 0.793214793601598, 0.79564378917589, 0.79802407181383, 
            0.800355249318588, 0.802636937584341, 0.804868760659556, 0.807050350808941, 
            0.809181348574033, 0.811261402832425, 0.813290170855625, 0.815267318365519, 
            0.817192519589459, 0.81906545731393, 0.820885822936827, 0.822653316518297, 
            0.824367646830161, 0.826028531403898, 0.827635696577193, 0.829188877539019, 
            0.830687818373278, 0.832132272100963, 0.833522000720853, 0.834856775248731, 
            0.83613637575511, 0.837360591401475, 0.838529220475016, 0.839642070421872, 
            0.84069895787885, 0.841699708703644, 0.842644158003525, 0.843532150162511, 
            0.844363538867007, 0.845138187129914, 0.8458559673132, 0.84651676114893, 
            0.847120459758753, 0.847666963671843, 0.848156182841289, 0.848588036658928, 
            0.848962453968632, 0.84927937307803, 0.849538741768671, 0.849740517304631, 
            0.849884666439553, 0.849971165422127, 0.85, 0.85, 0.849955944685856, 
            0.849823789834115, 0.849603568714053, 0.84929533676516, 0.84889917158318, 
            0.84841517290058, 0.847843462561439, 0.847184184490778, 0.846437504658326, 
            0.845603611036738, 0.844682713554273, 0.843675044041947, 0.842580856175173, 
            0.841400425409892, 0.84013404891324, 0.838782045488725, 0.83734475549598, 
            0.835822540765074, 0.834215784505426, 0.832524891209331, 0.830750286550134, 
            0.828892417275068, 0.826951751092787, 0.824928776555625, 0.822824002936604, 
            0.820637960101224, 0.818371198374081, 0.816024288400317, 0.813597821001968, 
            0.811092407029223, 0.808508677206654, 0.805847281974425, 0.803108891324553, 
            0.800294194632242, 0.79740390048233, 0.794438736490913, 0.79139944912217, 
            0.788286803500441, 0.785101583217618, 0.781844590135871, 0.778516644185791, 
            0.775118583159976, 0.771651262502115, 0.768115555091642, 0.76451235102399, 
            0.760842557386514, 0.757107098030137, 0.753306913336775, 0.749442959982602, 
            0.745516210697212, 0.741527654018739, 0.737478294044996, 0.733369150180702, 
            0.72920125688085, 0.724975663390289, 0.720693433479583, 0.716355645177212, 
            0.711963390498183, 0.707517775169124, 0.703019918349919, 0.69847095235197, 
            0.693872022353139, 0.689224286109459, 0.684528913663676, 0.679787087050692, 
            0.675, 0.670168857635164, 0.665294876170439, 0.660379282604594, 0.655423314412021, 
            0.65042821923121, 0.64539525455066, 0.640325687392315, 0.635220793992595, 
            0.630081859481115, 0.624910177557155, 0.619707050163984, 0.614473787161098, 
            0.60921170599447, 0.603922131364896, 0.5986063948945, 0.593265834791512, 
            0.587901795513378, 0.582515627428299, 0.577108686475289, 0.571682333822817, 
            0.566237935526144, 0.560776862183426, 0.555300488590673, 0.54981019339565, 
            0.544307358750812, 0.538793369965354, 0.533269615156464, 0.527737484899876, 
            0.522198371879798, 0.51665367053831, 0.511104776724324, 0.505553087342183, 
            0.5, 0.5, 0.494446912657817, 0.488895223275676, 0.48334632946169, 0.477801628120202, 
            0.472262515100124, 0.466730384843536, 0.461206630034646, 0.455692641249188, 
            0.45018980660435, 0.444699511409327, 0.439223137816574, 0.433762064473856, 
            0.428317666177183, 0.422891313524711, 0.417484372571701, 0.412098204486622, 
            0.406734165208488, 0.4013936051055, 0.396077868635104, 0.39078829400553, 
            0.385526212838902, 0.380292949836016, 0.375089822442845, 0.369918140518885, 
            0.364779206007405, 0.359674312607685, 0.35460474544934, 0.34957178076879, 
            0.344576685587979, 0.339620717395406, 0.334705123829561, 0.329831142364836, 
            0.325, 0.320212912949308, 0.315471086336324, 0.310775713890541, 0.306127977646861, 
            0.30152904764803, 0.296980081650081, 0.292482224830876, 0.288036609501817, 
            0.283644354822788, 0.279306566520417, 0.275024336609711, 0.27079874311915, 
            0.266630849819298, 0.262521705955004, 0.258472345981261, 0.254483789302788, 
            0.250557040017398, 0.246693086663225, 0.242892901969863, 0.239157442613486, 
            0.23548764897601, 0.231884444908358, 0.228348737497885, 0.224881416840024, 
            0.221483355814209, 0.218155409864129, 0.214898416782382, 0.211713196499559, 
            0.20860055087783, 0.205561263509087, 0.20259609951767, 0.199705805367758, 
            0.196891108675447, 0.194152718025575, 0.191491322793346, 0.188907592970777, 
            0.186402178998032, 0.183975711599683, 0.181628801625919, 0.179362039898776, 
            0.177175997063396, 0.175071223444375, 0.173048248907213, 0.171107582724932, 
            0.169249713449866, 0.167475108790669, 0.165784215494574, 0.164177459234926, 
            0.16265524450402, 0.161217954511275, 0.15986595108676, 0.158599574590108, 
            0.157419143824827, 0.156324955958053, 0.155317286445727, 0.154396388963262, 
            0.153562495341674, 0.152815815509222, 0.152156537438561, 0.15158482709942, 
            0.15110082841682, 0.15070466323484, 0.150396431285947, 0.150176210165885, 
            0.150044055314144, 0.15, 0.15, 0.150028834577873, 0.150115333560447, 
            0.150259482695369, 0.150461258231329, 0.15072062692197, 0.151037546031367, 
            0.151411963341072, 0.151843817158711, 0.152333036328157, 0.152879540241247, 
            0.15348323885107, 0.1541440326868, 0.154861812870086, 0.155636461132993, 
            0.156467849837489, 0.157355841996475, 0.158300291296356, 0.15930104212115, 
            0.160357929578128, 0.161470779524984, 0.162639408598525, 0.16386362424489, 
            0.165143224751269, 0.166477999279147, 0.167867727899037, 0.169312181626722, 
            0.170811122460981, 0.172364303422807, 0.173971468596102, 0.175632353169839, 
            0.177346683481703, 0.179114177063173, 0.18093454268607, 0.182807480410541, 
            0.18473268163448, 0.186709829144375, 0.188738597167575, 0.190818651425967, 
            0.192949649191059, 0.195131239340444, 0.197363062415659, 0.199644750681412, 
            0.20197592818617, 0.20435621082411, 0.206785206398402, 0.209262514685834, 
            0.211787727502757, 0.214360428772339, 0.216980194593122, 0.219646593308869, 
            0.222359185579684, 0.22511752445441, 0.227921155444261, 0.230769616597717, 
            0.233662438576636, 0.236599144733586, 0.239579251190381, 0.242602266917812, 
            0.245667693816552, 0.248775026799224, 0.251923753873629, 0.255113356227106, 
            0.25834330831201, 0.261613077932315, 0.264922126331295, 0.268269908280301, 
            0.271655872168594, 0.275079460094234, 0.278540107956006, 0.282037245546367, 
            0.285570296645394, 0.289138679115733, 0.292741804998515, 0.296379080610232, 
            0.300049906640558, 0.3037536782511, 0.307489785175052, 0.311257611817751, 
            0.315056537358106, 0.318885935850894, 0.322745176329892, 0.32663362291184, 
            0.330550634901221, 0.334495566895821, 0.338467768893077, 0.342466586397172, 
            0.34649136052688, 0.35223989666933), id = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1), fill = "#2297E6")
    expect_equal(letterC(0, 0, 1, 1, fill = "#2297E6", id = NULL), out)
    expect_equal(letterC(0, 0, 1, 1, fill = "#2297E6", id = 1), out)
    expect_equal(addLetter(list(), "C", 0, 0, 1, 1, fills), out) 
})

test_that("letters' functions and addLetter for G work", {
    out <- list(x = c(0.818377328025402, 0.816487838670546, 0.814547989649978, 0.812558100590714, 
        0.810518499364815, 0.808429522035371, 0.806291512801121, 0.804104823939743, 
        0.801869815749811, 0.799586856491426, 0.797256322325539, 0.794878597251972, 
        0.792454073046147, 0.789983149194533, 0.787466232828822, 0.784903738658849, 
        0.782296088904258, 0.779643713224932, 0.776947048650205, 0.774206539506847, 
        0.771422637345852, 0.768595800868043, 0.765726495848484, 0.762815195059742, 
        0.759862378193984, 0.756868531783942, 0.753834149122742, 0.750759730182633, 
        0.747645781532598, 0.744492816254893, 0.741301353860507, 0.738071920203559, 
        0.734805047394656, 0.731501273713218, 0.728161143518785, 0.724785207161323, 
        0.721374020890546, 0.71792814676426, 0.714448152555756, 0.710934611660257, 
        0.70738810300044, 0.703809210931049, 0.700198525142609, 0.696556640564268, 
        0.692884157265764, 0.689181680358558, 0.68544981989613, 0.681689190773456, 
        0.677900412625699, 0.674084109726107, 0.670240910883155, 0.666371449336937, 
        0.662476362654825, 0.658556292626422, 0.654611885157809, 0.650643790165126, 
        0.646652661467482, 0.642639156679227, 0.638603937101597, 0.634547667613753, 
        0.630471016563229, 0.626374655655809, 0.622259259844849, 0.618125507220071, 
        0.613974078895829, 0.609805658898883, 0.605620934055697, 0.601420593879268, 
        0.597205330455514, 0.592975838329244, 0.588732814389716, 0.584476957755811, 
        0.58020896966084, 0.575929553337004, 0.571639413899522, 0.567339258230448, 
        0.563029794862203, 0.558711733860828, 0.554385786708985, 0.550052666188734, 
        0.545713086264079, 0.541367761963336, 0.537017409261318, 0.532662744961358, 
        0.528304486577212, 0.523943352214826, 0.519580060454019, 0.515215330230084, 
        0.510849880715326, 0.510849880715326, 0.505453947069723, 0.50005937182156, 
        0.494667513026306, 0.489279728055578, 0.48389737325543, 0.4785218036049, 
        0.473154372374901, 0.467796430787539, 0.462449327675958, 0.457114409144771, 
        0.451793018231188, 0.446486494566913, 0.441196174040903, 0.435923388463057, 
        0.430669465228947, 0.425435726985651, 0.420223491298783, 0.415034070320803, 
        0.409868770460691, 0.404728892055065, 0.399615729040824, 0.394530568629416, 
        0.389474690982778, 0.384449368891071, 0.379455867452258, 0.374495443753621, 
        0.3695693465553, 0.364678815975921, 0.359825083180404, 0.355009370070023, 
        0.350232888974801, 0.345496842348311, 0.340802422464962, 0.336150811119857, 
        0.331543179331275, 0.326980687045879, 0.322464482846703, 0.317995703664003, 
        0.313575474489039, 0.309204908090868, 0.304885104736209, 0.300617151912454, 
        0.296402124053904, 0.29224108227128, 0.288135074084599, 0.284085133159464, 
        0.280092279046845, 0.276157516926412, 0.272281837353487, 0.268466216009676, 
        0.264711613457247, 0.261018974897315, 0.257389229931889, 0.253823292329854, 
        0.25032205979693, 0.246886413749686, 0.243517219093639, 0.240215324005527, 
        0.236981559719781, 0.233816740319266, 0.230721662530342, 0.22769710552229, 
        0.224743830711163, 0.221862581568101, 0.219054083432167, 0.216319043327748, 
        0.213658149786564, 0.211072072674335, 0.208561463022143, 0.206126952862542, 
        0.203769155070446, 0.20148866320884, 0.199286051379355, 0.19716187407774, 
        0.195116666054271, 0.193150942179131, 0.191265197312792, 0.189459906181441, 
        0.187735523257466, 0.186092482645046, 0.184531197970868, 0.183052062280001, 
        0.181655447936944, 0.180341706531889, 0.17911116879221, 0.177964144499202, 
        0.176900922410097, 0.175921770185369, 0.175026934321356, 0.1742166400882, 
        0.173491091473141, 0.172850471129164, 0.172294940329013, 0.171824638924598, 
        0.171439685311781, 0.171140176400576, 0.17092618759075, 0.170797772752841, 
        0.170754964214598, 0.170754964214598, 0.170797772752841, 0.17092618759075, 
        0.171140176400576, 0.171439685311781, 0.171824638924598, 0.172294940329013, 
        0.172850471129164, 0.173491091473141, 0.1742166400882, 0.175026934321356, 
        0.175921770185369, 0.176900922410097, 0.177964144499202, 0.17911116879221, 
        0.180341706531889, 0.181655447936944, 0.183052062280001, 0.184531197970868, 
        0.186092482645046, 0.187735523257466, 0.189459906181441, 0.191265197312792, 
        0.193150942179131, 0.195116666054271, 0.19716187407774, 0.199286051379355, 
        0.20148866320884, 0.203769155070446, 0.206126952862542, 0.208561463022143, 
        0.211072072674335, 0.213658149786564, 0.216319043327748, 0.219054083432167, 
        0.221862581568101, 0.224743830711163, 0.22769710552229, 0.230721662530342, 
        0.233816740319266, 0.236981559719781, 0.240215324005527, 0.243517219093639, 
        0.246886413749686, 0.25032205979693, 0.253823292329854, 0.257389229931889, 
        0.261018974897315, 0.264711613457247, 0.268466216009676, 0.272281837353487, 
        0.276157516926412, 0.280092279046845, 0.284085133159464, 0.288135074084599, 
        0.29224108227128, 0.296402124053904, 0.300617151912454, 0.304885104736209, 
        0.309204908090868, 0.313575474489039, 0.317995703664003, 0.322464482846703, 
        0.326980687045879, 0.331543179331275, 0.336150811119857, 0.340802422464962, 
        0.345496842348311, 0.350232888974801, 0.355009370070023, 0.359825083180404, 
        0.364678815975921, 0.3695693465553, 0.374495443753621, 0.379455867452258, 
        0.384449368891071, 0.389474690982778, 0.394530568629416, 0.399615729040824, 
        0.404728892055065, 0.409868770460691, 0.415034070320803, 0.420223491298783, 
        0.425435726985651, 0.430669465228947, 0.435923388463057, 0.441196174040903, 
        0.446486494566913, 0.451793018231188, 0.457114409144771, 0.462449327675958, 
        0.467796430787539, 0.473154372374901, 0.4785218036049, 0.48389737325543, 
        0.489279728055578, 0.494667513026306, 0.50005937182156, 0.505453947069723, 
        0.510849880715326, 0.510849880715326, 0.515215330230084, 0.519580060454019, 
        0.523943352214826, 0.528304486577212, 0.532662744961358, 0.537017409261318, 
        0.541367761963336, 0.545713086264079, 0.550052666188734, 0.554385786708985, 
        0.558711733860828, 0.563029794862203, 0.567339258230448, 0.571639413899522, 
        0.575929553337004, 0.58020896966084, 0.584476957755811, 0.588732814389716, 
        0.592975838329244, 0.597205330455514, 0.601420593879268, 0.605620934055697, 
        0.609805658898883, 0.613974078895829, 0.618125507220071, 0.622259259844849, 
        0.626374655655809, 0.630471016563229, 0.634547667613753, 0.638603937101597, 
        0.642639156679227, 0.646652661467482, 0.650643790165126, 0.654611885157809, 
        0.658556292626422, 0.662476362654825, 0.666371449336937, 0.670240910883155, 
        0.674084109726107, 0.677900412625699, 0.681689190773456, 0.68544981989613, 
        0.689181680358558, 0.692884157265764, 0.696556640564268, 0.700198525142609, 
        0.703809210931049, 0.70738810300044, 0.710934611660257, 0.714448152555756, 
        0.71792814676426, 0.721374020890546, 0.724785207161323, 0.728161143518785, 
        0.731501273713218, 0.734805047394656, 0.738071920203559, 0.741301353860507, 
        0.744492816254893, 0.747645781532598, 0.750759730182633, 0.753834149122742, 
        0.756868531783942, 0.759862378193984, 0.762815195059742, 0.765726495848484, 
        0.768595800868043, 0.771422637345852, 0.774206539506847, 0.776947048650205, 
        0.779643713224932, 0.782296088904258, 0.784903738658849, 0.787466232828822, 
        0.789983149194533, 0.792454073046147, 0.794878597251972, 0.797256322325539, 
        0.799586856491426, 0.801869815749811, 0.804104823939743, 0.806291512801121, 
        0.808429522035371, 0.810518499364815, 0.812558100590714, 0.814547989649978, 
        0.816487838670546, 0.818377328025402, 0.975, 0.973118791873872, 0.971161416153933, 
        0.969128195355054, 0.967019464489026, 0.964835571009361, 0.962576874754039, 
        0.960243747886219, 0.957836574832923, 0.955355752221685, 0.952801688815208, 
        0.950174805444006, 0.947475534937069, 0.944704322050544, 0.941861623394451, 
        0.938947907357454, 0.935963654029676, 0.932909355123605, 0.929785513893065, 
        0.926592645050305, 0.923331274681183, 0.920001940158487, 0.916605190053391, 
        0.91314158404507, 0.909611692828479, 0.906016098020321, 0.902355392063216, 
        0.898630178128085, 0.894841070014764, 0.890988692050868, 0.887073678988927, 
        0.883096675901792, 0.87905833807635, 0.874959330905552, 0.870800329778778, 
        0.866582019970552, 0.862305096527634, 0.857970264154492, 0.853578237097192, 
        0.849129739025714, 0.844625502914707, 0.840066270922727, 0.835452794269944, 
        0.830785833114369, 0.826066156426601, 0.821294541863125, 0.816471775638179, 
        0.811598652394212, 0.806675975070947, 0.801704554773084, 0.796685210636656, 
        0.79161876969406, 0.786506066737787, 0.781347944182873, 0.7761452519281, 
        0.770898847215951, 0.765609594491372, 0.760278365259331, 0.754906037941226, 
        0.749493497730144, 0.744041636445013, 0.738551352383653, 0.73302355017477, 
        0.727459140628896, 0.72185904058832, 0.716224172776016, 0.710555465643612, 
        0.704853853218407, 0.699120274949471, 0.693355675552857, 0.687561004855937, 
        0.681737217640902, 0.675885273487444, 0.670006136614645, 0.664100775722105, 
        0.65817016383033, 0.652215278120407, 0.646237099772999, 0.640236613806671, 
        0.634214808915594, 0.628172677306638, 0.622111214535883, 0.61603141934459, 
        0.609934293494632, 0.603820841603438, 0.597692070978463, 0.591548991451215, 
        0.585392615210865, 0.579223956637471, 0.573044032134839, 0.566853859963051, 
        0.560654460070687, 0.554446853926769, 0.548232064352457, 0.542011115352515, 
        0.535785031946592, 0.529554840000326, 0.523321566056317, 0.51708623716498, 
        0.510849880715326, 0.510849880715326, 0.503141404078751, 0.495434868009946, 
        0.487732212588154, 0.480035376915686, 0.472346298629761, 0.464666913414718, 
        0.456999154514718, 0.44934495224706, 0.44170623351623, 0.434084921328819, 
        0.426482934309414, 0.418902186217594, 0.41134458546615, 0.403812034640655, 
        0.396306430020499, 0.388829661101505, 0.381383610120265, 0.373970151580294, 
        0.366591151780134, 0.359248468343524, 0.351943949751752, 0.344679434878311, 
        0.337456752525972, 0.330277720966391, 0.323144147482372, 0.316057827912891, 
        0.309020546201004, 0.302034073944748, 0.295100169951152, 0.288220579793465, 
        0.281397035371719, 0.274631254476733, 0.267924940357663, 0.261279781293227, 
        0.254697450166681, 0.248179604044688, 0.241727883760151, 0.23534391349915, 
        0.229029300392059, 0.222785634108958, 0.216614486459445, 0.210517410996938, 
        0.20449594262758, 0.198551597223831, 0.192685871242858, 0.186900241349809, 
        0.181196164046067, 0.175575075302592, 0.170038390198413, 0.164587502564397, 
        0.159223784632356, 0.153948586689596, 0.148763236738988, 0.143669040164651, 
        0.138667279403332, 0.133759213621554, 0.12894607839863, 0.124229085415613, 
        0.119609422150261, 0.115088251578097, 0.110666711879634, 0.106345916153846, 
        0.10212695213795, 0.0980108819335754, 0.0939987417393841, 0.0900915415902144, 
        0.0862902651028091, 0.0825958692281955, 0.0790092840107782, 0.0755314123542057, 
        0.0721631297940689, 0.0689052842774892, 0.0657586959496537, 0.0627241569473464, 
        0.0598024311995334, 0.0569942542350469, 0.0543003329974203, 0.051721345666919, 
        0.0492579414898112, 0.0469107406149253, 0.044680333937529, 0.0425672829505759, 
        0.0405721196033516, 0.0386953461675594, 0.0369374351108752, 0.0352988289780065, 
        0.0337799402792845, 0.0323811513868165, 0.0311028144382258, 0.0299452512480029, 
        0.0289087532264906, 0.0279935813065229, 0.0271999658777366, 0.0265281067285718, 
        0.0259781729959763, 0.0255503031228265, 0.0252446048230748, 0.0250611550546332, 
        0.025, 0.025, 0.0250611550546332, 0.0252446048230748, 0.0255503031228265, 
        0.0259781729959763, 0.0265281067285718, 0.0271999658777366, 0.0279935813065229, 
        0.0289087532264906, 0.0299452512480029, 0.0311028144382258, 0.0323811513868165, 
        0.0337799402792845, 0.0352988289780065, 0.0369374351108752, 0.0386953461675594, 
        0.0405721196033516, 0.0425672829505759, 0.044680333937529, 0.0469107406149253, 
        0.0492579414898112, 0.051721345666919, 0.0543003329974203, 0.0569942542350469, 
        0.0598024311995334, 0.0627241569473464, 0.0657586959496537, 0.0689052842774892, 
        0.0721631297940689, 0.0755314123542057, 0.0790092840107782, 0.0825958692281955, 
        0.0862902651028091, 0.0900915415902144, 0.0939987417393841, 0.0980108819335754, 
        0.10212695213795, 0.106345916153846, 0.110666711879634, 0.115088251578097, 
        0.119609422150261, 0.124229085415613, 0.12894607839863, 0.133759213621554, 
        0.138667279403332, 0.143669040164651, 0.148763236738988, 0.153948586689596, 
        0.159223784632356, 0.164587502564397, 0.170038390198413, 0.175575075302592, 
        0.181196164046067, 0.186900241349809, 0.192685871242858, 0.198551597223831, 
        0.20449594262758, 0.210517410996938, 0.216614486459445, 0.222785634108958, 
        0.229029300392059, 0.23534391349915, 0.241727883760151, 0.248179604044688, 
        0.254697450166681, 0.261279781293227, 0.267924940357663, 0.274631254476733, 
        0.281397035371719, 0.288220579793465, 0.295100169951152, 0.302034073944748, 
        0.309020546201004, 0.316057827912891, 0.323144147482372, 0.330277720966391, 
        0.337456752525972, 0.344679434878311, 0.351943949751752, 0.359248468343524, 
        0.366591151780134, 0.373970151580294, 0.381383610120265, 0.388829661101505, 
        0.396306430020499, 0.403812034640655, 0.41134458546615, 0.418902186217594, 
        0.426482934309414, 0.434084921328819, 0.44170623351623, 0.44934495224706, 
        0.456999154514718, 0.464666913414718, 0.472346298629761, 0.480035376915686, 
        0.487732212588154, 0.495434868009946, 0.503141404078751, 0.510849880715326, 
        0.510849880715326, 0.51708623716498, 0.523321566056317, 0.529554840000326, 
        0.535785031946592, 0.542011115352515, 0.548232064352457, 0.554446853926769, 
        0.560654460070687, 0.566853859963051, 0.573044032134839, 0.579223956637471, 
        0.585392615210865, 0.591548991451215, 0.597692070978463, 0.603820841603438, 
        0.609934293494632, 0.61603141934459, 0.622111214535883, 0.628172677306638, 
        0.634214808915594, 0.640236613806671, 0.646237099772999, 0.652215278120407, 
        0.65817016383033, 0.664100775722105, 0.670006136614645, 0.675885273487444, 
        0.681737217640902, 0.687561004855937, 0.693355675552857, 0.699120274949471, 
        0.704853853218407, 0.710555465643612, 0.716224172776016, 0.72185904058832, 
        0.727459140628896, 0.73302355017477, 0.738551352383653, 0.744041636445013, 
        0.749493497730144, 0.754906037941226, 0.760278365259331, 0.765609594491372, 
        0.770898847215951, 0.7761452519281, 0.781347944182873, 0.786506066737787, 
        0.79161876969406, 0.796685210636656, 0.801704554773084, 0.806675975070947, 
        0.811598652394212, 0.816471775638179, 0.821294541863125, 0.826066156426601, 
        0.830785833114369, 0.835452794269944, 0.840066270922727, 0.844625502914707, 
        0.849129739025714, 0.853578237097192, 0.857970264154492, 0.862305096527634, 
        0.866582019970552, 0.870800329778778, 0.874959330905552, 0.87905833807635, 
        0.883096675901792, 0.887073678988927, 0.890988692050868, 0.894841070014764, 
        0.898630178128085, 0.902355392063216, 0.906016098020321, 0.909611692828479, 
        0.91314158404507, 0.916605190053391, 0.920001940158487, 0.923331274681183, 
        0.926592645050305, 0.929785513893065, 0.932909355123605, 0.935963654029676, 
        0.938947907357454, 0.941861623394451, 0.944704322050544, 0.947475534937069, 
        0.950174805444006, 0.952801688815208, 0.955355752221685, 0.957836574832923, 
        0.960243747886219, 0.962576874754039, 0.964835571009361, 0.967019464489026, 
        0.969128195355054, 0.971161416153933, 0.973118791873872, 0.975, 0.975, 0.510849880715326, 
        0.510849880715326, 0.78066004771387, 0.78066004771387, 0.975, 0.975), y = c(0.35223989666933, 
        0.34649136052688, 0.342466586397172, 0.338467768893077, 0.334495566895821, 
        0.330550634901221, 0.32663362291184, 0.322745176329892, 0.318885935850894, 
        0.315056537358106, 0.311257611817751, 0.307489785175052, 0.3037536782511, 
        0.300049906640558, 0.296379080610232, 0.292741804998515, 0.289138679115733, 
        0.285570296645394, 0.282037245546367, 0.278540107956006, 0.275079460094234, 
        0.271655872168594, 0.268269908280301, 0.264922126331295, 0.261613077932315, 
        0.25834330831201, 0.255113356227106, 0.251923753873629, 0.248775026799224, 
        0.245667693816552, 0.242602266917812, 0.239579251190381, 0.236599144733586, 
        0.233662438576636, 0.230769616597717, 0.227921155444261, 0.22511752445441, 
        0.222359185579684, 0.219646593308869, 0.216980194593122, 0.214360428772339, 
        0.211787727502757, 0.209262514685834, 0.206785206398402, 0.20435621082411, 
        0.20197592818617, 0.199644750681412, 0.197363062415659, 0.195131239340444, 
        0.192949649191059, 0.190818651425967, 0.188738597167575, 0.186709829144375, 
        0.18473268163448, 0.182807480410541, 0.18093454268607, 0.179114177063173, 
        0.177346683481703, 0.175632353169839, 0.173971468596102, 0.172364303422807, 
        0.170811122460981, 0.169312181626722, 0.167867727899037, 0.166477999279147, 
        0.165143224751269, 0.16386362424489, 0.162639408598525, 0.161470779524984, 
        0.160357929578128, 0.15930104212115, 0.158300291296356, 0.157355841996475, 
        0.156467849837489, 0.155636461132993, 0.154861812870086, 0.1541440326868, 
        0.15348323885107, 0.152879540241247, 0.152333036328157, 0.151843817158711, 
        0.151411963341072, 0.151037546031367, 0.15072062692197, 0.150461258231329, 
        0.150259482695369, 0.150115333560447, 0.150028834577873, 0.15, 0.15, 0.150044055314144, 
        0.150176210165885, 0.150396431285947, 0.15070466323484, 0.15110082841682, 
        0.15158482709942, 0.152156537438561, 0.152815815509222, 0.153562495341674, 
        0.154396388963262, 0.155317286445727, 0.156324955958053, 0.157419143824827, 
        0.158599574590108, 0.15986595108676, 0.161217954511275, 0.16265524450402, 
        0.164177459234926, 0.165784215494574, 0.167475108790669, 0.169249713449866, 
        0.171107582724932, 0.173048248907213, 0.175071223444375, 0.177175997063396, 
        0.179362039898776, 0.181628801625919, 0.183975711599683, 0.186402178998032, 
        0.188907592970777, 0.191491322793346, 0.194152718025575, 0.196891108675447, 
        0.199705805367758, 0.20259609951767, 0.205561263509087, 0.20860055087783, 
        0.211713196499559, 0.214898416782382, 0.218155409864129, 0.221483355814209, 
        0.224881416840024, 0.228348737497885, 0.231884444908358, 0.23548764897601, 
        0.239157442613486, 0.242892901969863, 0.246693086663225, 0.250557040017398, 
        0.254483789302788, 0.258472345981261, 0.262521705955004, 0.266630849819298, 
        0.27079874311915, 0.275024336609711, 0.279306566520417, 0.283644354822788, 
        0.288036609501817, 0.292482224830876, 0.296980081650081, 0.30152904764803, 
        0.306127977646861, 0.310775713890541, 0.315471086336324, 0.320212912949308, 
        0.325, 0.329831142364836, 0.334705123829561, 0.339620717395406, 0.344576685587979, 
        0.34957178076879, 0.35460474544934, 0.359674312607685, 0.364779206007405, 
        0.369918140518885, 0.375089822442845, 0.380292949836016, 0.385526212838902, 
        0.39078829400553, 0.396077868635104, 0.4013936051055, 0.406734165208488, 
        0.412098204486622, 0.417484372571701, 0.422891313524711, 0.428317666177183, 
        0.433762064473856, 0.439223137816574, 0.444699511409327, 0.45018980660435, 
        0.455692641249188, 0.461206630034646, 0.466730384843536, 0.472262515100124, 
        0.477801628120202, 0.48334632946169, 0.488895223275676, 0.494446912657817, 
        0.5, 0.5, 0.505553087342183, 0.511104776724324, 0.51665367053831, 0.522198371879798, 
        0.527737484899876, 0.533269615156464, 0.538793369965354, 0.544307358750812, 
        0.54981019339565, 0.555300488590673, 0.560776862183426, 0.566237935526144, 
        0.571682333822817, 0.577108686475289, 0.582515627428299, 0.587901795513378, 
        0.593265834791512, 0.5986063948945, 0.603922131364896, 0.60921170599447, 
        0.614473787161098, 0.619707050163984, 0.624910177557155, 0.630081859481115, 
        0.635220793992595, 0.640325687392315, 0.64539525455066, 0.65042821923121, 
        0.655423314412021, 0.660379282604594, 0.665294876170439, 0.670168857635164, 
        0.675, 0.679787087050692, 0.684528913663676, 0.689224286109459, 0.693872022353139, 
        0.69847095235197, 0.703019918349919, 0.707517775169124, 0.711963390498183, 
        0.716355645177212, 0.720693433479583, 0.724975663390289, 0.72920125688085, 
        0.733369150180702, 0.737478294044996, 0.741527654018739, 0.745516210697212, 
        0.749442959982602, 0.753306913336775, 0.757107098030137, 0.760842557386514, 
        0.76451235102399, 0.768115555091642, 0.771651262502115, 0.775118583159976, 
        0.778516644185791, 0.781844590135871, 0.785101583217618, 0.788286803500441, 
        0.79139944912217, 0.794438736490913, 0.79740390048233, 0.800294194632242, 
        0.803108891324553, 0.805847281974425, 0.808508677206654, 0.811092407029223, 
        0.813597821001968, 0.816024288400317, 0.818371198374081, 0.820637960101224, 
        0.822824002936604, 0.824928776555625, 0.826951751092787, 0.828892417275068, 
        0.830750286550134, 0.832524891209331, 0.834215784505426, 0.835822540765074, 
        0.83734475549598, 0.838782045488725, 0.84013404891324, 0.841400425409892, 
        0.842580856175173, 0.843675044041947, 0.844682713554273, 0.845603611036738, 
        0.846437504658326, 0.847184184490778, 0.847843462561439, 0.84841517290058, 
        0.84889917158318, 0.84929533676516, 0.849603568714053, 0.849823789834115, 
        0.849955944685856, 0.85, 0.85, 0.849971165422127, 0.849884666439553, 0.849740517304631, 
        0.849538741768671, 0.84927937307803, 0.848962453968632, 0.848588036658928, 
        0.848156182841289, 0.847666963671843, 0.847120459758753, 0.84651676114893, 
        0.8458559673132, 0.845138187129914, 0.844363538867007, 0.843532150162511, 
        0.842644158003525, 0.841699708703644, 0.84069895787885, 0.839642070421872, 
        0.838529220475016, 0.837360591401475, 0.83613637575511, 0.834856775248731, 
        0.833522000720853, 0.832132272100963, 0.830687818373278, 0.829188877539019, 
        0.827635696577193, 0.826028531403898, 0.824367646830161, 0.822653316518297, 
        0.820885822936827, 0.81906545731393, 0.817192519589459, 0.815267318365519, 
        0.813290170855625, 0.811261402832425, 0.809181348574033, 0.807050350808941, 
        0.804868760659556, 0.802636937584341, 0.800355249318588, 0.79802407181383, 
        0.79564378917589, 0.793214793601598, 0.790737485314166, 0.788212272497243, 
        0.785639571227661, 0.783019805406878, 0.780353406691132, 0.777640814420316, 
        0.77488247554559, 0.772078844555739, 0.769230383402283, 0.766337561423364, 
        0.763400855266414, 0.760420748809619, 0.757397733082188, 0.754332306183448, 
        0.751224973200776, 0.748076246126371, 0.744886643772894, 0.74165669168799, 
        0.738386922067685, 0.735077873668705, 0.731730091719699, 0.728344127831406, 
        0.724920539905766, 0.721459892043994, 0.717962754453633, 0.714429703354606, 
        0.710861320884267, 0.707258195001485, 0.703620919389768, 0.699950093359442, 
        0.6962463217489, 0.692510214824948, 0.688742388182249, 0.684943462641894, 
        0.681114064149106, 0.677254823670108, 0.67336637708816, 0.669449365098779, 
        0.665504433104179, 0.661532231106922, 0.657533413602828, 0.65350863947312, 
        0.64776010333067, 0.64776010333067, 0.65387926736773, 0.659973076869259, 
        0.66604052776426, 0.672080620324815, 0.678092359330815, 0.684074754233936, 
        0.690026819320855, 0.695947573875662, 0.701836042341452, 0.707691254481069, 
        0.713512245536965, 0.719298056390172, 0.725047733718325, 0.730760330152747, 
        0.736434904434541, 0.742070521569685, 0.747666252983086, 0.753221176671584, 
        0.758734377355865, 0.764204946631276, 0.769631983117499, 0.775014592607069, 
        0.780351888212714, 0.785642990513488, 0.790887027699669, 0.796083135716407, 
        0.801230458406095, 0.806328147649437, 0.811375363505191, 0.816371274348562, 
        0.821315057008237, 0.826205896902009, 0.831042988170999, 0.835825533812436, 
        0.840552745810979, 0.845223845268557, 0.849838062532706, 0.854394637323387, 
        0.858892818858252, 0.863331865976355, 0.867711047260268, 0.872029641156599, 
        0.876286936094878, 0.880482230604806, 0.884614833431833, 0.888684063651056, 
        0.892689250779415, 0.896629734886165, 0.900504866701616, 0.904314007724111, 
        0.908056530325229, 0.911731817853204, 0.915339264734523, 0.918878276573712, 
        0.922348270251272, 0.925748674019757, 0.929078927597983, 0.932338482263344, 
        0.935526800942222, 0.938643358298487, 0.941687640820047, 0.944659146903465, 
        0.947557386936607, 0.950381883379314, 0.953132170842084, 0.955807796162757, 
        0.958408318481182, 0.960933309311853, 0.963382352614515, 0.965755044862712, 
        0.968050995110276, 0.970269825055742, 0.972411169104683, 0.974474674429947, 
        0.97646000102979, 0.978366821783901, 0.980194822507301, 0.981943702002107, 
        0.983613172107166, 0.985202957745531, 0.986712796969786, 0.988142441005206, 
        0.98949165429075, 0.990760214517873, 0.991947912667153, 0.993054553042735, 
        0.994079953304571, 0.995023944498471, 0.995886371083933, 0.996667090959776, 
        0.997365975487555, 0.997982909512755, 0.998517791383761, 0.998970532968614, 
        0.99934105966953, 0.999629310435187, 0.99983523777079, 0.999958807745896, 
        1, 1, 0.999937063836938, 0.999748271191593, 0.999433669591504, 0.998993338235942, 
        0.998427387975971, 0.997735961286542, 0.996919232230627, 0.995977406415398, 
        0.994910720940466, 0.993719444338197, 0.992403876506104, 0.990964348631353, 
        0.989401223107389, 0.987714893442704, 0.985905784161771, 0.983974350698178, 
        0.981921079279971, 0.979746486807249, 0.977451120722037, 0.975035558870473, 
        0.972500409357334, 0.969846310392954, 0.967073930132553, 0.964183966508036, 
        0.961177147052291, 0.958054228716035, 0.954815997677259, 0.951463269143311, 
        0.947996887145668, 0.944417724327462, 0.940726681723791, 0.936924688534893, 
        0.933012701892219, 0.928991706617489, 0.924862714974757, 0.920626766415591, 
        0.916284927317386, 0.911838290714916, 0.907287976025168, 0.902635128765529, 
        0.897880920265416, 0.893026547371394, 0.888073232145878, 0.883022221559489, 
        0.877874787177129, 0.872632224837877, 0.867295854328767, 0.861867019052535, 
        0.856347085689431, 0.850737443853161, 0.845039505741056, 0.839254705778566, 
        0.833384500258146, 0.827430366972643, 0.82139380484327, 0.815276333542261, 
        0.809079493110303, 0.802804843568833, 0.79645396452732, 0.790028454785599, 
        0.783529931931386, 0.776960031933055, 0.770320408727799, 0.763612733805251, 
        0.756838695786703, 0.75, 0.743098368050234, 0.736135537386342, 0.729113260863705, 
        0.722033306302887, 0.714897456044586, 0.707707506500943, 0.700465267703307, 
        0.693172562846564, 0.685831227830164, 0.678443110795936, 0.671010071662834, 
        0.663533981658711, 0.656016722849244, 0.648460187664138, 0.640866278420715, 
        0.633236906845018, 0.62557399359054, 0.617879467754713, 0.61015526639327, 
        0.602403334032595, 0.594625622180205, 0.586824088833465, 0.579000697986675, 
        0.571157419136643, 0.563296226786875, 0.555419099950506, 0.547528021652091, 
        0.539624978428394, 0.531711959828282, 0.523790957911871, 0.515863966749034, 
        0.507932981917404, 0.5, 0.5, 0.492067018082596, 0.484136033250966, 0.476209042088129, 
        0.468288040171718, 0.460375021571606, 0.452471978347909, 0.444580900049494, 
        0.436703773213125, 0.428842580863357, 0.420999302013325, 0.413175911166535, 
        0.405374377819795, 0.397596665967405, 0.38984473360673, 0.382120532245287, 
        0.37442600640946, 0.366763093154982, 0.359133721579285, 0.351539812335862, 
        0.343983277150756, 0.336466018341289, 0.328989928337166, 0.321556889204064, 
        0.314168772169836, 0.306827437153436, 0.299534732296693, 0.292292493499057, 
        0.285102543955414, 0.277966693697113, 0.270886739136295, 0.263864462613658, 
        0.256901631949766, 0.25, 0.243161304213297, 0.236387266194749, 0.229679591272201, 
        0.223039968066945, 0.216470068068614, 0.209971545214401, 0.20354603547268, 
        0.197195156431167, 0.190920506889697, 0.184723666457739, 0.17860619515673, 
        0.172569633027357, 0.166615499741854, 0.160745294221434, 0.154960494258944, 
        0.149262556146839, 0.143652914310569, 0.138132980947465, 0.132704145671233, 
        0.127367775162123, 0.122125212822871, 0.116977778440511, 0.111926767854122, 
        0.106973452628606, 0.102119079734584, 0.0973648712344706, 0.0927120239748321, 
        0.0881617092850836, 0.0837150726826143, 0.0793732335844094, 0.0751372850252428, 
        0.0710082933825114, 0.0669872981077807, 0.0630753114651075, 0.059273318276209, 
        0.0555822756725383, 0.0520031128543321, 0.0485367308566894, 0.0451840023227408, 
        0.0419457712839652, 0.0388228529477093, 0.0358160334919637, 0.0329260698674466, 
        0.0301536896070458, 0.0274995906426658, 0.0249644411295273, 0.0225488792779631, 
        0.0202535131927513, 0.0180789207200289, 0.0160256493018218, 0.0140942158382291, 
        0.0122851065572965, 0.0105987768926106, 0.00903565136864665, 0.00759612349389593, 
        0.0062805556618028, 0.0050892790595336, 0.00402259358460233, 0.00308076776937294, 
        0.00226403871345771, 0.00157261202402881, 0.00100666176405778, 0.000566330408496019, 
        0.000251728808407403, 6.29361630624659e-05, 0, 0, 4.11922541042609e-05, 0.000164762229209747, 
        0.000370689564813231, 0.000658940330470259, 0.00102946703138557, 0.00148220861623921, 
        0.00201709048724547, 0.0026340245124446, 0.00333290904022399, 0.00411362891606754, 
        0.00497605550152913, 0.00592004669542862, 0.00694544695726534, 0.00805208733284685, 
        0.00923978548212689, 0.0105083457092496, 0.0118575589947941, 0.0132872030302144, 
        0.0147970422544689, 0.0163868278928337, 0.018056297997893, 0.0198051774926994, 
        0.0216331782160988, 0.0235399989702101, 0.0255253255700531, 0.0275888308953167, 
        0.029730174944258, 0.0319490048897243, 0.0342449551372879, 0.0366176473854847, 
        0.0390666906881467, 0.041591681518818, 0.0441922038372426, 0.0468678291579163, 
        0.0496181166206864, 0.0524426130633929, 0.0553408530965351, 0.0583123591799534, 
        0.0613566417015131, 0.0644731990577775, 0.0676615177366564, 0.0709210724020169, 
        0.0742513259802431, 0.0776517297487281, 0.0811217234262882, 0.0846607352654773, 
        0.0882681821467963, 0.0919434696747705, 0.0956859922758889, 0.0994951332983836, 
        0.103370265113835, 0.107310749220585, 0.111315936348944, 0.115385166568167, 
        0.119517769395194, 0.123713063905123, 0.127970358843401, 0.132288952739732, 
        0.136668134023645, 0.141107181141748, 0.145605362676613, 0.150161937467294, 
        0.154776154731443, 0.159447254189021, 0.164174466187564, 0.168957011829001, 
        0.173794103097991, 0.178684942991763, 0.183628725651438, 0.188624636494809, 
        0.193671852350563, 0.198769541593905, 0.203916864283593, 0.209112972300331, 
        0.214357009486512, 0.219648111787286, 0.224985407392931, 0.230368016882501, 
        0.235795053368724, 0.241265622644135, 0.246778823328416, 0.252333747016914, 
        0.257929478430315, 0.263565095565459, 0.269239669847253, 0.274952266281675, 
        0.280701943609828, 0.286487754463035, 0.292308745518931, 0.298163957658548, 
        0.304052426124338, 0.309973180679145, 0.315925245766064, 0.321907640669185, 
        0.327919379675185, 0.33395947223574, 0.340026923130741, 0.34612073263227, 
        0.35223989666933, 0.4, 0.4, 0.3, 0.3, 0, 0, 0.4), id = c(1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 
        2, 2, 2, 2), fill = c("#F5C710", "#F5C710"))
    expect_equal(letterG(0, 0, 1, 1, fill = "#F5C710", id = NULL), out)
    expect_equal(letterG(0, 0, 1, 1, fill = "#F5C710", id = 1), out)
    expect_equal(addLetter(list(), "G", 0, 0, 1, 1, fills), out)
})

## seqLogo --------------------------------------------------------------------

test_that("seqLogo works", {
    expect_null(seqLogo(mDNA))
    expect_null(seqLogo(makePWM(mDNA)))
    expect_null(seqLogo(makePWM(mDNA), ic.scale=FALSE))
    expect_null(seqLogo(makePWM(mRNA, alphabet="RNA")))
    expect_error(seqLogo(""), "pwm must be of class")
    expect_error(seqLogo(mDNA, fill=c("red")), "\"fill\" must be named character vector of length")
})

