% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-roundtrip.R
\docType{data}
\name{spec_result_roundtrip}
\alias{spec_result_roundtrip}
\title{spec_result_roundtrip}
\description{
spec_result_roundtrip
}
\section{Specification}{

The column types of the returned data frame depend on the data returned:
\itemize{
\item \link{integer} for integer values between -2^31 and 2^31 - 1
\item \link{numeric} for numbers with a fractional component
\item \link{logical} for Boolean values (some backends may return an integer)
\item \link{character} for text
\item lists of \link{raw} for blobs (with \code{NULL} entries for SQL NULL values)
\item coercible using \code{\link[=as.Date]{as.Date()}} for dates
(also applies to the return value of the SQL function \code{current_date})
\item coercible using \code{\link[hms:as.hms]{hms::as.hms()}} for times
(also applies to the return value of the SQL function \code{current_time})
\item coercible using \code{\link[=as.POSIXct]{as.POSIXct()}} for timestamps
(also applies to the return value of the SQL function \code{current_timestamp})
\item \link{NA} for SQL \code{NULL} values
}

If dates and timestamps are supported by the backend, the following R types are
used:
\itemize{
\item \link{Date} for dates
(also applies to the return value of the SQL function \code{current_date})
\item \link{POSIXct} for timestamps
(also applies to the return value of the SQL function \code{current_timestamp})
}

R has no built-in type with lossless support for the full range of 64-bit
or larger integers. If 64-bit integers are returned from a query,
the following rules apply:
\itemize{
\item Values are returned in a container with support for the full range of
valid 64-bit values (such as the \code{integer64} class of the \pkg{bit64}
package)
\item Coercion to numeric always returns a number that is as close as possible
to the true value
\item Loss of precision when converting to numeric gives a warning
\item Conversion to character always returns a lossless decimal representation
of the data
}
}

