//  MacPmem - Rekall Memory Forensics
//  Copyright (c) 2015 Google Inc. All rights reserved.
//
//  Implements the /dev/pmem device to provide read/write access to
//  physical memory.
//
//  Authors:
//   Adam Sindelar (adam.sindelar@gmail.com)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "tests.h"
#include "rangemap.h"
#include "logging.h"

int assert_rangemap_test(pmem_rangemap *r, addr64_t offset, int flags);

// Test rangemap with real data.
// The code below was autogenerated from EFI ranges on my machine.
int test_rangemap_real() {
    pmem_rangemap *r = pmem_rangemap_make(0x10);
    if (!pmem_rangemap_add(r, 0x00000000000000, 0x00000000057fff, 1)) {
        pmem_warn("Failed to add 0x00000000000000 - 0x00000000057fff flags: 1");
        return -1;
    }

    if (!pmem_rangemap_add(r, 0x00000000059000, 0x0000000008efff, 1)) {
        pmem_warn("Failed to add 0x00000000059000 - 0x0000000008efff flags: 1");
        return -3;
    }

    if (!pmem_rangemap_add(r, 0x00000000090000, 0x0000000009ffff, 1)) {
        pmem_warn("Failed to add 0x00000000090000 - 0x0000000009ffff flags: 1");
        return -5;
    }

    if (!pmem_rangemap_add(r, 0x00000000100000, 0x000000096fffff, 1)) {
        pmem_warn("Failed to add 0x00000000100000 - 0x000000096fffff flags: 1");
        return -7;
    }

    if (!pmem_rangemap_add(r, 0x00000009700000, 0x00000009712fff, 1)) {
        pmem_warn("Failed to add 0x00000009700000 - 0x00000009712fff flags: 1");
        return -8;
    }

    if (!pmem_rangemap_add(r, 0x00000009713000, 0x000000097fffff, 1)) {
        pmem_warn("Failed to add 0x00000009713000 - 0x000000097fffff flags: 1");
        return -9;
    }

    if (!pmem_rangemap_add(r, 0x00000009800000, 0x0000000c433fff, 1)) {
        pmem_warn("Failed to add 0x00000009800000 - 0x0000000c433fff flags: 1");
        return -10;
    }

    if (!pmem_rangemap_add(r, 0x0000000c434000, 0x0000000c489fff, 1)) {
        pmem_warn("Failed to add 0x0000000c434000 - 0x0000000c489fff flags: 1");
        return -11;
    }

    if (!pmem_rangemap_add(r, 0x0000000c48a000, 0x0000000c4b8fff, 1)) {
        pmem_warn("Failed to add 0x0000000c48a000 - 0x0000000c4b8fff flags: 1");
        return -12;
    }

    if (!pmem_rangemap_add(r, 0x0000000c4b9000, 0x0000000c4fcfff, 1)) {
        pmem_warn("Failed to add 0x0000000c4b9000 - 0x0000000c4fcfff flags: 1");
        return -13;
    }

    if (!pmem_rangemap_add(r, 0x0000000c4fd000, 0x0000006a79bfff, 1)) {
        pmem_warn("Failed to add 0x0000000c4fd000 - 0x0000006a79bfff flags: 1");
        return -14;
    }

    if (!pmem_rangemap_add(r, 0x0000006a79c000, 0x0000006d1dffff, 1)) {
        pmem_warn("Failed to add 0x0000006a79c000 - 0x0000006d1dffff flags: 1");
        return -15;
    }

    if (!pmem_rangemap_add(r, 0x0000006d1e0000, 0x0000006d1f1fff, 1)) {
        pmem_warn("Failed to add 0x0000006d1e0000 - 0x0000006d1f1fff flags: 1");
        return -16;
    }

    if (!pmem_rangemap_add(r, 0x0000006d1f2000, 0x0000006d1f4fff, 1)) {
        pmem_warn("Failed to add 0x0000006d1f2000 - 0x0000006d1f4fff flags: 1");
        return -17;
    }

    if (!pmem_rangemap_add(r, 0x0000006d1f5000, 0x0000006d1f6fff, 1)) {
        pmem_warn("Failed to add 0x0000006d1f5000 - 0x0000006d1f6fff flags: 1");
        return -18;
    }

    if (!pmem_rangemap_add(r, 0x0000006d1f7000, 0x0000006e77ffff, 1)) {
        pmem_warn("Failed to add 0x0000006d1f7000 - 0x0000006e77ffff flags: 1");
        return -19;
    }

    if (!pmem_rangemap_add(r, 0x0000006e780000, 0x0000006e8abfff, 1)) {
        pmem_warn("Failed to add 0x0000006e780000 - 0x0000006e8abfff flags: 1");
        return -20;
    }

    if (!pmem_rangemap_add(r, 0x0000006e8ac000, 0x0000006ea3efff, 1)) {
        pmem_warn("Failed to add 0x0000006e8ac000 - 0x0000006ea3efff flags: 1");
        return -21;
    }

    if (!pmem_rangemap_add(r, 0x0000006ea3f000, 0x0000006ea65fff, 1)) {
        pmem_warn("Failed to add 0x0000006ea3f000 - 0x0000006ea65fff flags: 1");
        return -22;
    }

    if (!pmem_rangemap_add(r, 0x0000006ea66000, 0x0000006ea8bfff, 1)) {
        pmem_warn("Failed to add 0x0000006ea66000 - 0x0000006ea8bfff flags: 1");
        return -23;
    }

    if (!pmem_rangemap_add(r, 0x0000006ea8c000, 0x0000006ea91fff, 1)) {
        pmem_warn("Failed to add 0x0000006ea8c000 - 0x0000006ea91fff flags: 1");
        return -24;
    }

    if (!pmem_rangemap_add(r, 0x0000006ea92000, 0x0000006ea98fff, 1)) {
        pmem_warn("Failed to add 0x0000006ea92000 - 0x0000006ea98fff flags: 1");
        return -25;
    }

    if (!pmem_rangemap_add(r, 0x0000006ea99000, 0x0000006eaadfff, 1)) {
        pmem_warn("Failed to add 0x0000006ea99000 - 0x0000006eaadfff flags: 1");
        return -26;
    }

    if (!pmem_rangemap_add(r, 0x0000006eaae000, 0x0000006eab4fff, 1)) {
        pmem_warn("Failed to add 0x0000006eaae000 - 0x0000006eab4fff flags: 1");
        return -27;
    }

    if (!pmem_rangemap_add(r, 0x0000006eab5000, 0x0000006eac5fff, 1)) {
        pmem_warn("Failed to add 0x0000006eab5000 - 0x0000006eac5fff flags: 1");
        return -28;
    }

    if (!pmem_rangemap_add(r, 0x0000006eac6000, 0x0000006eac6fff, 1)) {
        pmem_warn("Failed to add 0x0000006eac6000 - 0x0000006eac6fff flags: 1");
        return -29;
    }

    if (!pmem_rangemap_add(r, 0x0000006eac7000, 0x0000006eacafff, 1)) {
        pmem_warn("Failed to add 0x0000006eac7000 - 0x0000006eacafff flags: 1");
        return -30;
    }

    if (!pmem_rangemap_add(r, 0x0000006eacb000, 0x0000006ead1fff, 1)) {
        pmem_warn("Failed to add 0x0000006eacb000 - 0x0000006ead1fff flags: 1");
        return -31;
    }

    if (!pmem_rangemap_add(r, 0x0000006ead2000, 0x0000006ead4fff, 1)) {
        pmem_warn("Failed to add 0x0000006ead2000 - 0x0000006ead4fff flags: 1");
        return -32;
    }

    if (!pmem_rangemap_add(r, 0x0000006ead5000, 0x00000073b5ffff, 1)) {
        pmem_warn("Failed to add 0x0000006ead5000 - 0x00000073b5ffff flags: 1");
        return -33;
    }

    if (!pmem_rangemap_add(r, 0x00000073b60000, 0x00000073b75fff, 1)) {
        pmem_warn("Failed to add 0x00000073b60000 - 0x00000073b75fff flags: 1");
        return -34;
    }

    if (!pmem_rangemap_add(r, 0x00000073b76000, 0x00000073b76fff, 1)) {
        pmem_warn("Failed to add 0x00000073b76000 - 0x00000073b76fff flags: 1");
        return -35;
    }

    if (!pmem_rangemap_add(r, 0x00000073b77000, 0x00000073b87fff, 1)) {
        pmem_warn("Failed to add 0x00000073b77000 - 0x00000073b87fff flags: 1");
        return -36;
    }

    if (!pmem_rangemap_add(r, 0x00000073b88000, 0x00000073b89fff, 1)) {
        pmem_warn("Failed to add 0x00000073b88000 - 0x00000073b89fff flags: 1");
        return -37;
    }

    if (!pmem_rangemap_add(r, 0x00000073b8a000, 0x00000073b8dfff, 1)) {
        pmem_warn("Failed to add 0x00000073b8a000 - 0x00000073b8dfff flags: 1");
        return -38;
    }

    if (!pmem_rangemap_add(r, 0x00000073b8e000, 0x00000073b8ffff, 1)) {
        pmem_warn("Failed to add 0x00000073b8e000 - 0x00000073b8ffff flags: 1");
        return -39;
    }

    if (!pmem_rangemap_add(r, 0x00000073b90000, 0x00000073b90fff, 1)) {
        pmem_warn("Failed to add 0x00000073b90000 - 0x00000073b90fff flags: 1");
        return -40;
    }

    if (!pmem_rangemap_add(r, 0x00000073b91000, 0x00000073b93fff, 1)) {
        pmem_warn("Failed to add 0x00000073b91000 - 0x00000073b93fff flags: 1");
        return -41;
    }

    if (!pmem_rangemap_add(r, 0x00000073b94000, 0x00000073bb1fff, 1)) {
        pmem_warn("Failed to add 0x00000073b94000 - 0x00000073bb1fff flags: 1");
        return -42;
    }

    if (!pmem_rangemap_add(r, 0x00000073bb2000, 0x00000073bb2fff, 1)) {
        pmem_warn("Failed to add 0x00000073bb2000 - 0x00000073bb2fff flags: 1");
        return -43;
    }

    if (!pmem_rangemap_add(r, 0x00000073bb3000, 0x00000073bb5fff, 1)) {
        pmem_warn("Failed to add 0x00000073bb3000 - 0x00000073bb5fff flags: 1");
        return -44;
    }

    if (!pmem_rangemap_add(r, 0x00000073bb6000, 0x00000073bb8fff, 1)) {
        pmem_warn("Failed to add 0x00000073bb6000 - 0x00000073bb8fff flags: 1");
        return -45;
    }

    if (!pmem_rangemap_add(r, 0x00000073bb9000, 0x00000073bbcfff, 1)) {
        pmem_warn("Failed to add 0x00000073bb9000 - 0x00000073bbcfff flags: 1");
        return -46;
    }

    if (!pmem_rangemap_add(r, 0x00000073bbd000, 0x00000073bc3fff, 1)) {
        pmem_warn("Failed to add 0x00000073bbd000 - 0x00000073bc3fff flags: 1");
        return -47;
    }

    if (!pmem_rangemap_add(r, 0x00000073bc4000, 0x00000073bd5fff, 1)) {
        pmem_warn("Failed to add 0x00000073bc4000 - 0x00000073bd5fff flags: 1");
        return -48;
    }

    if (!pmem_rangemap_add(r, 0x00000073bd6000, 0x00000073bd7fff, 1)) {
        pmem_warn("Failed to add 0x00000073bd6000 - 0x00000073bd7fff flags: 1");
        return -49;
    }

    if (!pmem_rangemap_add(r, 0x00000073bd8000, 0x00000073bdefff, 1)) {
        pmem_warn("Failed to add 0x00000073bd8000 - 0x00000073bdefff flags: 1");
        return -50;
    }

    if (!pmem_rangemap_add(r, 0x00000073bdf000, 0x00000073be0fff, 1)) {
        pmem_warn("Failed to add 0x00000073bdf000 - 0x00000073be0fff flags: 1");
        return -51;
    }

    if (!pmem_rangemap_add(r, 0x00000073be1000, 0x00000073be4fff, 1)) {
        pmem_warn("Failed to add 0x00000073be1000 - 0x00000073be4fff flags: 1");
        return -52;
    }

    if (!pmem_rangemap_add(r, 0x00000073be5000, 0x00000076eddfff, 1)) {
        pmem_warn("Failed to add 0x00000073be5000 - 0x00000076eddfff flags: 1");
        return -53;
    }

    if (!pmem_rangemap_add(r, 0x00000076ede000, 0x00000076ee2fff, 1)) {
        pmem_warn("Failed to add 0x00000076ede000 - 0x00000076ee2fff flags: 1");
        return -54;
    }

    if (!pmem_rangemap_add(r, 0x00000076ee3000, 0x00000076ee3fff, 1)) {
        pmem_warn("Failed to add 0x00000076ee3000 - 0x00000076ee3fff flags: 1");
        return -55;
    }

    if (!pmem_rangemap_add(r, 0x00000076ee4000, 0x00000076ee6fff, 1)) {
        pmem_warn("Failed to add 0x00000076ee4000 - 0x00000076ee6fff flags: 1");
        return -56;
    }

    if (!pmem_rangemap_add(r, 0x00000076ee7000, 0x00000076ee7fff, 1)) {
        pmem_warn("Failed to add 0x00000076ee7000 - 0x00000076ee7fff flags: 1");
        return -57;
    }

    if (!pmem_rangemap_add(r, 0x00000076ee8000, 0x00000076eecfff, 1)) {
        pmem_warn("Failed to add 0x00000076ee8000 - 0x00000076eecfff flags: 1");
        return -58;
    }

    if (!pmem_rangemap_add(r, 0x00000076eed000, 0x00000076eeffff, 1)) {
        pmem_warn("Failed to add 0x00000076eed000 - 0x00000076eeffff flags: 1");
        return -59;
    }

    if (!pmem_rangemap_add(r, 0x00000076ef0000, 0x00000076ef0fff, 1)) {
        pmem_warn("Failed to add 0x00000076ef0000 - 0x00000076ef0fff flags: 1");
        return -60;
    }

    if (!pmem_rangemap_add(r, 0x00000076ef1000, 0x00000077414fff, 1)) {
        pmem_warn("Failed to add 0x00000076ef1000 - 0x00000077414fff flags: 1");
        return -61;
    }

    if (!pmem_rangemap_add(r, 0x00000077415000, 0x00000077419fff, 1)) {
        pmem_warn("Failed to add 0x00000077415000 - 0x00000077419fff flags: 1");
        return -62;
    }

    if (!pmem_rangemap_add(r, 0x0000007741a000, 0x000000777aafff, 1)) {
        pmem_warn("Failed to add 0x0000007741a000 - 0x000000777aafff flags: 1");
        return -63;
    }

    if (!pmem_rangemap_add(r, 0x000000777ab000, 0x0000007783afff, 1)) {
        pmem_warn("Failed to add 0x000000777ab000 - 0x0000007783afff flags: 1");
        return -64;
    }

    if (!pmem_rangemap_add(r, 0x0000007783b000, 0x000000778bafff, 1)) {
        pmem_warn("Failed to add 0x0000007783b000 - 0x000000778bafff flags: 1");
        return -65;
    }

    if (!pmem_rangemap_add(r, 0x000000778bb000, 0x000000778bbfff, 1)) {
        pmem_warn("Failed to add 0x000000778bb000 - 0x000000778bbfff flags: 1");
        return -66;
    }

    if (!pmem_rangemap_add(r, 0x000000778bc000, 0x000000778bdfff, 1)) {
        pmem_warn("Failed to add 0x000000778bc000 - 0x000000778bdfff flags: 1");
        return -67;
    }

    if (!pmem_rangemap_add(r, 0x000000778be000, 0x000000778bffff, 1)) {
        pmem_warn("Failed to add 0x000000778be000 - 0x000000778bffff flags: 1");
        return -68;
    }

    if (!pmem_rangemap_add(r, 0x000000778c0000, 0x000000778c1fff, 1)) {
        pmem_warn("Failed to add 0x000000778c0000 - 0x000000778c1fff flags: 1");
        return -69;
    }

    if (!pmem_rangemap_add(r, 0x000000778c2000, 0x000000778c3fff, 1)) {
        pmem_warn("Failed to add 0x000000778c2000 - 0x000000778c3fff flags: 1");
        return -70;
    }

    if (!pmem_rangemap_add(r, 0x000000778c4000, 0x00000079446fff, 1)) {
        pmem_warn("Failed to add 0x000000778c4000 - 0x00000079446fff flags: 1");
        return -71;
    }

    if (!pmem_rangemap_add(r, 0x00000079447000, 0x00000079456fff, 1)) {
        pmem_warn("Failed to add 0x00000079447000 - 0x00000079456fff flags: 1");
        return -72;
    }

    if (!pmem_rangemap_add(r, 0x00000079457000, 0x0000007946dfff, 1)) {
        pmem_warn("Failed to add 0x00000079457000 - 0x0000007946dfff flags: 1");
        return -73;
    }

    if (!pmem_rangemap_add(r, 0x0000007946e000, 0x0000007946ffff, 1)) {
        pmem_warn("Failed to add 0x0000007946e000 - 0x0000007946ffff flags: 1");
        return -74;
    }

    if (!pmem_rangemap_add(r, 0x00000079470000, 0x00000079471fff, 1)) {
        pmem_warn("Failed to add 0x00000079470000 - 0x00000079471fff flags: 1");
        return -75;
    }

    if (!pmem_rangemap_add(r, 0x00000079472000, 0x00000079472fff, 1)) {
        pmem_warn("Failed to add 0x00000079472000 - 0x00000079472fff flags: 1");
        return -76;
    }

    if (!pmem_rangemap_add(r, 0x00000079473000, 0x00000079475fff, 1)) {
        pmem_warn("Failed to add 0x00000079473000 - 0x00000079475fff flags: 1");
        return -77;
    }

    if (!pmem_rangemap_add(r, 0x00000079476000, 0x0000007947efff, 1)) {
        pmem_warn("Failed to add 0x00000079476000 - 0x0000007947efff flags: 1");
        return -78;
    }

    if (!pmem_rangemap_add(r, 0x0000007947f000, 0x00000079482fff, 1)) {
        pmem_warn("Failed to add 0x0000007947f000 - 0x00000079482fff flags: 1");
        return -79;
    }

    if (!pmem_rangemap_add(r, 0x00000079483000, 0x00000079483fff, 1)) {
        pmem_warn("Failed to add 0x00000079483000 - 0x00000079483fff flags: 1");
        return -80;
    }

    if (!pmem_rangemap_add(r, 0x00000079484000, 0x00000079485fff, 1)) {
        pmem_warn("Failed to add 0x00000079484000 - 0x00000079485fff flags: 1");
        return -81;
    }

    if (!pmem_rangemap_add(r, 0x00000079486000, 0x0000007948dfff, 1)) {
        pmem_warn("Failed to add 0x00000079486000 - 0x0000007948dfff flags: 1");
        return -82;
    }

    if (!pmem_rangemap_add(r, 0x0000007948e000, 0x00000079495fff, 1)) {
        pmem_warn("Failed to add 0x0000007948e000 - 0x00000079495fff flags: 1");
        return -83;
    }

    if (!pmem_rangemap_add(r, 0x00000079496000, 0x0000007949afff, 1)) {
        pmem_warn("Failed to add 0x00000079496000 - 0x0000007949afff flags: 1");
        return -84;
    }

    if (!pmem_rangemap_add(r, 0x0000007949b000, 0x000000794a3fff, 1)) {
        pmem_warn("Failed to add 0x0000007949b000 - 0x000000794a3fff flags: 1");
        return -85;
    }

    if (!pmem_rangemap_add(r, 0x000000794a4000, 0x000000794a4fff, 1)) {
        pmem_warn("Failed to add 0x000000794a4000 - 0x000000794a4fff flags: 1");
        return -86;
    }

    if (!pmem_rangemap_add(r, 0x000000794a5000, 0x000000794b3fff, 1)) {
        pmem_warn("Failed to add 0x000000794a5000 - 0x000000794b3fff flags: 1");
        return -87;
    }

    if (!pmem_rangemap_add(r, 0x000000794b4000, 0x000000794b7fff, 1)) {
        pmem_warn("Failed to add 0x000000794b4000 - 0x000000794b7fff flags: 1");
        return -88;
    }

    if (!pmem_rangemap_add(r, 0x000000794b8000, 0x000000794bdfff, 1)) {
        pmem_warn("Failed to add 0x000000794b8000 - 0x000000794bdfff flags: 1");
        return -89;
    }

    if (!pmem_rangemap_add(r, 0x000000794be000, 0x000000794befff, 1)) {
        pmem_warn("Failed to add 0x000000794be000 - 0x000000794befff flags: 1");
        return -90;
    }

    if (!pmem_rangemap_add(r, 0x000000794bf000, 0x000000794bffff, 1)) {
        pmem_warn("Failed to add 0x000000794bf000 - 0x000000794bffff flags: 1");
        return -91;
    }

    if (!pmem_rangemap_add(r, 0x000000794c0000, 0x000000794c0fff, 1)) {
        pmem_warn("Failed to add 0x000000794c0000 - 0x000000794c0fff flags: 1");
        return -92;
    }

    if (!pmem_rangemap_add(r, 0x000000794c1000, 0x000000794dafff, 1)) {
        pmem_warn("Failed to add 0x000000794c1000 - 0x000000794dafff flags: 1");
        return -93;
    }

    if (!pmem_rangemap_add(r, 0x000000794db000, 0x000000794dcfff, 1)) {
        pmem_warn("Failed to add 0x000000794db000 - 0x000000794dcfff flags: 1");
        return -94;
    }

    if (!pmem_rangemap_add(r, 0x000000794dd000, 0x0000007950efff, 1)) {
        pmem_warn("Failed to add 0x000000794dd000 - 0x0000007950efff flags: 1");
        return -95;
    }

    if (!pmem_rangemap_add(r, 0x0000007950f000, 0x00000079517fff, 1)) {
        pmem_warn("Failed to add 0x0000007950f000 - 0x00000079517fff flags: 1");
        return -96;
    }

    if (!pmem_rangemap_add(r, 0x00000079518000, 0x0000007951cfff, 1)) {
        pmem_warn("Failed to add 0x00000079518000 - 0x0000007951cfff flags: 1");
        return -97;
    }

    if (!pmem_rangemap_add(r, 0x0000007951d000, 0x0000007951ffff, 1)) {
        pmem_warn("Failed to add 0x0000007951d000 - 0x0000007951ffff flags: 1");
        return -98;
    }

    if (!pmem_rangemap_add(r, 0x00000079520000, 0x00000079533fff, 1)) {
        pmem_warn("Failed to add 0x00000079520000 - 0x00000079533fff flags: 1");
        return -99;
    }

    if (!pmem_rangemap_add(r, 0x00000079534000, 0x0000007956efff, 1)) {
        pmem_warn("Failed to add 0x00000079534000 - 0x0000007956efff flags: 1");
        return -100;
    }

    if (!pmem_rangemap_add(r, 0x0000007956f000, 0x00000079592fff, 1)) {
        pmem_warn("Failed to add 0x0000007956f000 - 0x00000079592fff flags: 1");
        return -101;
    }

    if (!pmem_rangemap_add(r, 0x00000079593000, 0x000000795a4fff, 1)) {
        pmem_warn("Failed to add 0x00000079593000 - 0x000000795a4fff flags: 1");
        return -102;
    }

    if (!pmem_rangemap_add(r, 0x000000795a5000, 0x000000795befff, 1)) {
        pmem_warn("Failed to add 0x000000795a5000 - 0x000000795befff flags: 1");
        return -103;
    }

    if (!pmem_rangemap_add(r, 0x000000795bf000, 0x000000795c8fff, 1)) {
        pmem_warn("Failed to add 0x000000795bf000 - 0x000000795c8fff flags: 1");
        return -104;
    }

    if (!pmem_rangemap_add(r, 0x000000795c9000, 0x000000795cafff, 1)) {
        pmem_warn("Failed to add 0x000000795c9000 - 0x000000795cafff flags: 1");
        return -105;
    }

    if (!pmem_rangemap_add(r, 0x000000795cb000, 0x000000795e6fff, 1)) {
        pmem_warn("Failed to add 0x000000795cb000 - 0x000000795e6fff flags: 1");
        return -106;
    }

    if (!pmem_rangemap_add(r, 0x000000795e7000, 0x000000795e9fff, 1)) {
        pmem_warn("Failed to add 0x000000795e7000 - 0x000000795e9fff flags: 1");
        return -107;
    }

    if (!pmem_rangemap_add(r, 0x000000795ea000, 0x000000795ebfff, 1)) {
        pmem_warn("Failed to add 0x000000795ea000 - 0x000000795ebfff flags: 1");
        return -108;
    }

    if (!pmem_rangemap_add(r, 0x000000795ec000, 0x000000795eefff, 1)) {
        pmem_warn("Failed to add 0x000000795ec000 - 0x000000795eefff flags: 1");
        return -109;
    }

    if (!pmem_rangemap_add(r, 0x000000795ef000, 0x000000795f1fff, 1)) {
        pmem_warn("Failed to add 0x000000795ef000 - 0x000000795f1fff flags: 1");
        return -110;
    }

    if (!pmem_rangemap_add(r, 0x000000795f2000, 0x000000795f3fff, 1)) {
        pmem_warn("Failed to add 0x000000795f2000 - 0x000000795f3fff flags: 1");
        return -111;
    }

    if (!pmem_rangemap_add(r, 0x000000795f4000, 0x000000795fffff, 1)) {
        pmem_warn("Failed to add 0x000000795f4000 - 0x000000795fffff flags: 1");
        return -112;
    }

    if (!pmem_rangemap_add(r, 0x00000079600000, 0x00000079603fff, 1)) {
        pmem_warn("Failed to add 0x00000079600000 - 0x00000079603fff flags: 1");
        return -113;
    }

    if (!pmem_rangemap_add(r, 0x00000079604000, 0x00000079604fff, 1)) {
        pmem_warn("Failed to add 0x00000079604000 - 0x00000079604fff flags: 1");
        return -114;
    }

    if (!pmem_rangemap_add(r, 0x00000079605000, 0x00000079607fff, 1)) {
        pmem_warn("Failed to add 0x00000079605000 - 0x00000079607fff flags: 1");
        return -115;
    }

    if (!pmem_rangemap_add(r, 0x00000079608000, 0x00000079608fff, 1)) {
        pmem_warn("Failed to add 0x00000079608000 - 0x00000079608fff flags: 1");
        return -116;
    }

    if (!pmem_rangemap_add(r, 0x00000079609000, 0x00000079609fff, 1)) {
        pmem_warn("Failed to add 0x00000079609000 - 0x00000079609fff flags: 1");
        return -117;
    }

    if (!pmem_rangemap_add(r, 0x0000007960a000, 0x0000007960afff, 1)) {
        pmem_warn("Failed to add 0x0000007960a000 - 0x0000007960afff flags: 1");
        return -118;
    }

    if (!pmem_rangemap_add(r, 0x0000007960b000, 0x0000007960cfff, 1)) {
        pmem_warn("Failed to add 0x0000007960b000 - 0x0000007960cfff flags: 1");
        return -119;
    }

    if (!pmem_rangemap_add(r, 0x0000007960d000, 0x0000007960efff, 1)) {
        pmem_warn("Failed to add 0x0000007960d000 - 0x0000007960efff flags: 1");
        return -120;
    }

    if (!pmem_rangemap_add(r, 0x0000007960f000, 0x0000007960ffff, 1)) {
        pmem_warn("Failed to add 0x0000007960f000 - 0x0000007960ffff flags: 1");
        return -121;
    }

    if (!pmem_rangemap_add(r, 0x00000079610000, 0x00000079610fff, 1)) {
        pmem_warn("Failed to add 0x00000079610000 - 0x00000079610fff flags: 1");
        return -122;
    }

    if (!pmem_rangemap_add(r, 0x00000079611000, 0x00000079613fff, 1)) {
        pmem_warn("Failed to add 0x00000079611000 - 0x00000079613fff flags: 1");
        return -123;
    }

    if (!pmem_rangemap_add(r, 0x00000079614000, 0x0000007961dfff, 1)) {
        pmem_warn("Failed to add 0x00000079614000 - 0x0000007961dfff flags: 1");
        return -124;
    }

    if (!pmem_rangemap_add(r, 0x0000007961e000, 0x00000079620fff, 1)) {
        pmem_warn("Failed to add 0x0000007961e000 - 0x00000079620fff flags: 1");
        return -125;
    }

    if (!pmem_rangemap_add(r, 0x00000079621000, 0x00000079622fff, 1)) {
        pmem_warn("Failed to add 0x00000079621000 - 0x00000079622fff flags: 1");
        return -126;
    }

    if (!pmem_rangemap_add(r, 0x00000079623000, 0x00000079624fff, 1)) {
        pmem_warn("Failed to add 0x00000079623000 - 0x00000079624fff flags: 1");
        return -127;
    }

    if (!pmem_rangemap_add(r, 0x00000079625000, 0x0000007962efff, 1)) {
        pmem_warn("Failed to add 0x00000079625000 - 0x0000007962efff flags: 1");
        return -128;
    }

    if (!pmem_rangemap_add(r, 0x0000007962f000, 0x0000007962ffff, 1)) {
        pmem_warn("Failed to add 0x0000007962f000 - 0x0000007962ffff flags: 1");
        return -129;
    }

    if (!pmem_rangemap_add(r, 0x00000079630000, 0x00000079635fff, 1)) {
        pmem_warn("Failed to add 0x00000079630000 - 0x00000079635fff flags: 1");
        return -130;
    }

    if (!pmem_rangemap_add(r, 0x00000079636000, 0x00000079640fff, 1)) {
        pmem_warn("Failed to add 0x00000079636000 - 0x00000079640fff flags: 1");
        return -131;
    }

    if (!pmem_rangemap_add(r, 0x00000079641000, 0x00000079645fff, 1)) {
        pmem_warn("Failed to add 0x00000079641000 - 0x00000079645fff flags: 1");
        return -132;
    }

    if (!pmem_rangemap_add(r, 0x00000079646000, 0x0000007964bfff, 1)) {
        pmem_warn("Failed to add 0x00000079646000 - 0x0000007964bfff flags: 1");
        return -133;
    }

    if (!pmem_rangemap_add(r, 0x0000007964c000, 0x00000079665fff, 1)) {
        pmem_warn("Failed to add 0x0000007964c000 - 0x00000079665fff flags: 1");
        return -134;
    }

    if (!pmem_rangemap_add(r, 0x00000079666000, 0x00000079668fff, 1)) {
        pmem_warn("Failed to add 0x00000079666000 - 0x00000079668fff flags: 1");
        return -135;
    }

    if (!pmem_rangemap_add(r, 0x00000079669000, 0x00000079678fff, 1)) {
        pmem_warn("Failed to add 0x00000079669000 - 0x00000079678fff flags: 1");
        return -136;
    }

    if (!pmem_rangemap_add(r, 0x00000079679000, 0x0000007967dfff, 1)) {
        pmem_warn("Failed to add 0x00000079679000 - 0x0000007967dfff flags: 1");
        return -137;
    }

    if (!pmem_rangemap_add(r, 0x0000007967e000, 0x00000079690fff, 1)) {
        pmem_warn("Failed to add 0x0000007967e000 - 0x00000079690fff flags: 1");
        return -138;
    }

    if (!pmem_rangemap_add(r, 0x00000079691000, 0x00000079691fff, 1)) {
        pmem_warn("Failed to add 0x00000079691000 - 0x00000079691fff flags: 1");
        return -139;
    }

    if (!pmem_rangemap_add(r, 0x00000079692000, 0x00000079695fff, 1)) {
        pmem_warn("Failed to add 0x00000079692000 - 0x00000079695fff flags: 1");
        return -140;
    }

    if (!pmem_rangemap_add(r, 0x00000079696000, 0x00000079699fff, 1)) {
        pmem_warn("Failed to add 0x00000079696000 - 0x00000079699fff flags: 1");
        return -141;
    }

    if (!pmem_rangemap_add(r, 0x0000007969a000, 0x0000007969dfff, 1)) {
        pmem_warn("Failed to add 0x0000007969a000 - 0x0000007969dfff flags: 1");
        return -142;
    }

    if (!pmem_rangemap_add(r, 0x0000007969e000, 0x000000796a5fff, 1)) {
        pmem_warn("Failed to add 0x0000007969e000 - 0x000000796a5fff flags: 1");
        return -143;
    }

    if (!pmem_rangemap_add(r, 0x000000796a6000, 0x000000796a6fff, 1)) {
        pmem_warn("Failed to add 0x000000796a6000 - 0x000000796a6fff flags: 1");
        return -144;
    }

    if (!pmem_rangemap_add(r, 0x000000796a7000, 0x000000796a7fff, 1)) {
        pmem_warn("Failed to add 0x000000796a7000 - 0x000000796a7fff flags: 1");
        return -145;
    }

    if (!pmem_rangemap_add(r, 0x000000796a8000, 0x000000796bdfff, 1)) {
        pmem_warn("Failed to add 0x000000796a8000 - 0x000000796bdfff flags: 1");
        return -146;
    }

    if (!pmem_rangemap_add(r, 0x000000796be000, 0x000000796c2fff, 1)) {
        pmem_warn("Failed to add 0x000000796be000 - 0x000000796c2fff flags: 1");
        return -147;
    }

    if (!pmem_rangemap_add(r, 0x000000796c3000, 0x000000796c4fff, 1)) {
        pmem_warn("Failed to add 0x000000796c3000 - 0x000000796c4fff flags: 1");
        return -148;
    }

    if (!pmem_rangemap_add(r, 0x000000796c5000, 0x000000796c9fff, 1)) {
        pmem_warn("Failed to add 0x000000796c5000 - 0x000000796c9fff flags: 1");
        return -149;
    }

    if (!pmem_rangemap_add(r, 0x000000796ca000, 0x000000796cafff, 1)) {
        pmem_warn("Failed to add 0x000000796ca000 - 0x000000796cafff flags: 1");
        return -150;
    }

    if (!pmem_rangemap_add(r, 0x000000796cb000, 0x000000796cbfff, 1)) {
        pmem_warn("Failed to add 0x000000796cb000 - 0x000000796cbfff flags: 1");
        return -151;
    }

    if (!pmem_rangemap_add(r, 0x000000796cc000, 0x000000796ebfff, 1)) {
        pmem_warn("Failed to add 0x000000796cc000 - 0x000000796ebfff flags: 1");
        return -152;
    }

    if (!pmem_rangemap_add(r, 0x000000796ec000, 0x000000796edfff, 1)) {
        pmem_warn("Failed to add 0x000000796ec000 - 0x000000796edfff flags: 1");
        return -153;
    }

    if (!pmem_rangemap_add(r, 0x000000796ee000, 0x000000796f4fff, 1)) {
        pmem_warn("Failed to add 0x000000796ee000 - 0x000000796f4fff flags: 1");
        return -154;
    }

    if (!pmem_rangemap_add(r, 0x000000796f5000, 0x000000796f8fff, 1)) {
        pmem_warn("Failed to add 0x000000796f5000 - 0x000000796f8fff flags: 1");
        return -155;
    }

    if (!pmem_rangemap_add(r, 0x000000796f9000, 0x000000796fbfff, 1)) {
        pmem_warn("Failed to add 0x000000796f9000 - 0x000000796fbfff flags: 1");
        return -156;
    }

    if (!pmem_rangemap_add(r, 0x000000796fc000, 0x000000796fcfff, 1)) {
        pmem_warn("Failed to add 0x000000796fc000 - 0x000000796fcfff flags: 1");
        return -157;
    }

    if (!pmem_rangemap_add(r, 0x000000796fd000, 0x000000796fffff, 1)) {
        pmem_warn("Failed to add 0x000000796fd000 - 0x000000796fffff flags: 1");
        return -158;
    }

    if (!pmem_rangemap_add(r, 0x00000079700000, 0x00000079700fff, 1)) {
        pmem_warn("Failed to add 0x00000079700000 - 0x00000079700fff flags: 1");
        return -159;
    }

    if (!pmem_rangemap_add(r, 0x00000079701000, 0x00000079706fff, 1)) {
        pmem_warn("Failed to add 0x00000079701000 - 0x00000079706fff flags: 1");
        return -160;
    }

    if (!pmem_rangemap_add(r, 0x00000079707000, 0x00000079708fff, 1)) {
        pmem_warn("Failed to add 0x00000079707000 - 0x00000079708fff flags: 1");
        return -161;
    }

    if (!pmem_rangemap_add(r, 0x00000079709000, 0x00000079709fff, 1)) {
        pmem_warn("Failed to add 0x00000079709000 - 0x00000079709fff flags: 1");
        return -162;
    }

    if (!pmem_rangemap_add(r, 0x0000007970a000, 0x0000007970bfff, 1)) {
        pmem_warn("Failed to add 0x0000007970a000 - 0x0000007970bfff flags: 1");
        return -163;
    }

    if (!pmem_rangemap_add(r, 0x0000007970c000, 0x0000007970cfff, 1)) {
        pmem_warn("Failed to add 0x0000007970c000 - 0x0000007970cfff flags: 1");
        return -164;
    }

    if (!pmem_rangemap_add(r, 0x0000007970d000, 0x00000079712fff, 1)) {
        pmem_warn("Failed to add 0x0000007970d000 - 0x00000079712fff flags: 1");
        return -165;
    }

    if (!pmem_rangemap_add(r, 0x00000079713000, 0x00000079713fff, 1)) {
        pmem_warn("Failed to add 0x00000079713000 - 0x00000079713fff flags: 1");
        return -166;
    }

    if (!pmem_rangemap_add(r, 0x00000079714000, 0x00000079714fff, 1)) {
        pmem_warn("Failed to add 0x00000079714000 - 0x00000079714fff flags: 1");
        return -167;
    }

    if (!pmem_rangemap_add(r, 0x00000079715000, 0x00000079716fff, 1)) {
        pmem_warn("Failed to add 0x00000079715000 - 0x00000079716fff flags: 1");
        return -168;
    }

    if (!pmem_rangemap_add(r, 0x00000079717000, 0x00000079719fff, 1)) {
        pmem_warn("Failed to add 0x00000079717000 - 0x00000079719fff flags: 1");
        return -169;
    }

    if (!pmem_rangemap_add(r, 0x0000007971a000, 0x0000007971afff, 1)) {
        pmem_warn("Failed to add 0x0000007971a000 - 0x0000007971afff flags: 1");
        return -170;
    }

    if (!pmem_rangemap_add(r, 0x0000007971b000, 0x0000007971cfff, 1)) {
        pmem_warn("Failed to add 0x0000007971b000 - 0x0000007971cfff flags: 1");
        return -171;
    }

    if (!pmem_rangemap_add(r, 0x0000007971d000, 0x0000007971efff, 1)) {
        pmem_warn("Failed to add 0x0000007971d000 - 0x0000007971efff flags: 1");
        return -172;
    }

    if (!pmem_rangemap_add(r, 0x0000007971f000, 0x0000007971ffff, 1)) {
        pmem_warn("Failed to add 0x0000007971f000 - 0x0000007971ffff flags: 1");
        return -173;
    }

    if (!pmem_rangemap_add(r, 0x00000079720000, 0x00000079722fff, 1)) {
        pmem_warn("Failed to add 0x00000079720000 - 0x00000079722fff flags: 1");
        return -174;
    }

    if (!pmem_rangemap_add(r, 0x00000079723000, 0x0000007972afff, 1)) {
        pmem_warn("Failed to add 0x00000079723000 - 0x0000007972afff flags: 1");
        return -175;
    }

    if (!pmem_rangemap_add(r, 0x0000007972b000, 0x0000007972cfff, 1)) {
        pmem_warn("Failed to add 0x0000007972b000 - 0x0000007972cfff flags: 1");
        return -176;
    }

    if (!pmem_rangemap_add(r, 0x0000007972d000, 0x0000007972ffff, 1)) {
        pmem_warn("Failed to add 0x0000007972d000 - 0x0000007972ffff flags: 1");
        return -177;
    }

    if (!pmem_rangemap_add(r, 0x00000079730000, 0x00000079733fff, 1)) {
        pmem_warn("Failed to add 0x00000079730000 - 0x00000079733fff flags: 1");
        return -178;
    }

    if (!pmem_rangemap_add(r, 0x00000079734000, 0x00000079738fff, 1)) {
        pmem_warn("Failed to add 0x00000079734000 - 0x00000079738fff flags: 1");
        return -179;
    }

    if (!pmem_rangemap_add(r, 0x00000079739000, 0x00000079739fff, 1)) {
        pmem_warn("Failed to add 0x00000079739000 - 0x00000079739fff flags: 1");
        return -180;
    }

    if (!pmem_rangemap_add(r, 0x0000007973a000, 0x0000007973ffff, 1)) {
        pmem_warn("Failed to add 0x0000007973a000 - 0x0000007973ffff flags: 1");
        return -181;
    }

    if (!pmem_rangemap_add(r, 0x00000079740000, 0x00000079741fff, 1)) {
        pmem_warn("Failed to add 0x00000079740000 - 0x00000079741fff flags: 1");
        return -182;
    }

    if (!pmem_rangemap_add(r, 0x00000079742000, 0x00000079744fff, 1)) {
        pmem_warn("Failed to add 0x00000079742000 - 0x00000079744fff flags: 1");
        return -183;
    }

    if (!pmem_rangemap_add(r, 0x00000079745000, 0x00000079745fff, 1)) {
        pmem_warn("Failed to add 0x00000079745000 - 0x00000079745fff flags: 1");
        return -184;
    }

    if (!pmem_rangemap_add(r, 0x00000079746000, 0x0000007974afff, 1)) {
        pmem_warn("Failed to add 0x00000079746000 - 0x0000007974afff flags: 1");
        return -185;
    }

    if (!pmem_rangemap_add(r, 0x0000007974b000, 0x0000007974cfff, 1)) {
        pmem_warn("Failed to add 0x0000007974b000 - 0x0000007974cfff flags: 1");
        return -186;
    }

    if (!pmem_rangemap_add(r, 0x0000007974d000, 0x0000007975ffff, 1)) {
        pmem_warn("Failed to add 0x0000007974d000 - 0x0000007975ffff flags: 1");
        return -187;
    }

    if (!pmem_rangemap_add(r, 0x00000079760000, 0x0000007976dfff, 1)) {
        pmem_warn("Failed to add 0x00000079760000 - 0x0000007976dfff flags: 1");
        return -188;
    }

    if (!pmem_rangemap_add(r, 0x0000007976e000, 0x00000079782fff, 1)) {
        pmem_warn("Failed to add 0x0000007976e000 - 0x00000079782fff flags: 1");
        return -189;
    }

    if (!pmem_rangemap_add(r, 0x00000079783000, 0x00000079785fff, 1)) {
        pmem_warn("Failed to add 0x00000079783000 - 0x00000079785fff flags: 1");
        return -190;
    }

    if (!pmem_rangemap_add(r, 0x00000079786000, 0x000000797b8fff, 1)) {
        pmem_warn("Failed to add 0x00000079786000 - 0x000000797b8fff flags: 1");
        return -191;
    }

    if (!pmem_rangemap_add(r, 0x000000797b9000, 0x000000797cafff, 1)) {
        pmem_warn("Failed to add 0x000000797b9000 - 0x000000797cafff flags: 1");
        return -192;
    }

    if (!pmem_rangemap_add(r, 0x000000797cb000, 0x000000797cbfff, 1)) {
        pmem_warn("Failed to add 0x000000797cb000 - 0x000000797cbfff flags: 1");
        return -193;
    }

    if (!pmem_rangemap_add(r, 0x000000797cc000, 0x000000797cffff, 1)) {
        pmem_warn("Failed to add 0x000000797cc000 - 0x000000797cffff flags: 1");
        return -194;
    }

    if (!pmem_rangemap_add(r, 0x000000797d0000, 0x000000797dcfff, 1)) {
        pmem_warn("Failed to add 0x000000797d0000 - 0x000000797dcfff flags: 1");
        return -195;
    }

    if (!pmem_rangemap_add(r, 0x000000797dd000, 0x000000797e2fff, 1)) {
        pmem_warn("Failed to add 0x000000797dd000 - 0x000000797e2fff flags: 1");
        return -196;
    }

    if (!pmem_rangemap_add(r, 0x000000797e3000, 0x000000797f4fff, 1)) {
        pmem_warn("Failed to add 0x000000797e3000 - 0x000000797f4fff flags: 1");
        return -197;
    }

    if (!pmem_rangemap_add(r, 0x000000797f5000, 0x000000797f6fff, 1)) {
        pmem_warn("Failed to add 0x000000797f5000 - 0x000000797f6fff flags: 1");
        return -198;
    }

    if (!pmem_rangemap_add(r, 0x000000797f7000, 0x000000797fefff, 1)) {
        pmem_warn("Failed to add 0x000000797f7000 - 0x000000797fefff flags: 1");
        return -199;
    }

    if (!pmem_rangemap_add(r, 0x000000797ff000, 0x00000079805fff, 1)) {
        pmem_warn("Failed to add 0x000000797ff000 - 0x00000079805fff flags: 1");
        return -200;
    }

    if (!pmem_rangemap_add(r, 0x00000079806000, 0x0000007980dfff, 1)) {
        pmem_warn("Failed to add 0x00000079806000 - 0x0000007980dfff flags: 1");
        return -201;
    }

    if (!pmem_rangemap_add(r, 0x0000007980e000, 0x0000007980efff, 1)) {
        pmem_warn("Failed to add 0x0000007980e000 - 0x0000007980efff flags: 1");
        return -202;
    }

    if (!pmem_rangemap_add(r, 0x0000007980f000, 0x0000007980ffff, 1)) {
        pmem_warn("Failed to add 0x0000007980f000 - 0x0000007980ffff flags: 1");
        return -203;
    }

    if (!pmem_rangemap_add(r, 0x00000079810000, 0x00000079810fff, 1)) {
        pmem_warn("Failed to add 0x00000079810000 - 0x00000079810fff flags: 1");
        return -204;
    }

    if (!pmem_rangemap_add(r, 0x00000079811000, 0x00000079811fff, 1)) {
        pmem_warn("Failed to add 0x00000079811000 - 0x00000079811fff flags: 1");
        return -205;
    }

    if (!pmem_rangemap_add(r, 0x00000079812000, 0x00000079812fff, 1)) {
        pmem_warn("Failed to add 0x00000079812000 - 0x00000079812fff flags: 1");
        return -206;
    }

    if (!pmem_rangemap_add(r, 0x00000079813000, 0x00000079816fff, 1)) {
        pmem_warn("Failed to add 0x00000079813000 - 0x00000079816fff flags: 1");
        return -207;
    }

    if (!pmem_rangemap_add(r, 0x00000079817000, 0x00000079817fff, 1)) {
        pmem_warn("Failed to add 0x00000079817000 - 0x00000079817fff flags: 1");
        return -208;
    }

    if (!pmem_rangemap_add(r, 0x00000079818000, 0x0000007982efff, 1)) {
        pmem_warn("Failed to add 0x00000079818000 - 0x0000007982efff flags: 1");
        return -209;
    }

    if (!pmem_rangemap_add(r, 0x0000007982f000, 0x00000079837fff, 1)) {
        pmem_warn("Failed to add 0x0000007982f000 - 0x00000079837fff flags: 1");
        return -210;
    }

    if (!pmem_rangemap_add(r, 0x00000079838000, 0x0000007983bfff, 1)) {
        pmem_warn("Failed to add 0x00000079838000 - 0x0000007983bfff flags: 1");
        return -211;
    }

    if (!pmem_rangemap_add(r, 0x0000007983c000, 0x0000007984bfff, 1)) {
        pmem_warn("Failed to add 0x0000007983c000 - 0x0000007984bfff flags: 1");
        return -212;
    }

    if (!pmem_rangemap_add(r, 0x0000007984c000, 0x00000079858fff, 1)) {
        pmem_warn("Failed to add 0x0000007984c000 - 0x00000079858fff flags: 1");
        return -213;
    }

    if (!pmem_rangemap_add(r, 0x00000079859000, 0x00000079859fff, 1)) {
        pmem_warn("Failed to add 0x00000079859000 - 0x00000079859fff flags: 1");
        return -214;
    }

    if (!pmem_rangemap_add(r, 0x0000007985a000, 0x0000007985afff, 1)) {
        pmem_warn("Failed to add 0x0000007985a000 - 0x0000007985afff flags: 1");
        return -215;
    }

    if (!pmem_rangemap_add(r, 0x0000007985b000, 0x0000007985bfff, 1)) {
        pmem_warn("Failed to add 0x0000007985b000 - 0x0000007985bfff flags: 1");
        return -216;
    }

    if (!pmem_rangemap_add(r, 0x0000007985c000, 0x0000007985ffff, 1)) {
        pmem_warn("Failed to add 0x0000007985c000 - 0x0000007985ffff flags: 1");
        return -217;
    }

    if (!pmem_rangemap_add(r, 0x00000079860000, 0x00000079860fff, 1)) {
        pmem_warn("Failed to add 0x00000079860000 - 0x00000079860fff flags: 1");
        return -218;
    }

    if (!pmem_rangemap_add(r, 0x00000079861000, 0x00000079863fff, 1)) {
        pmem_warn("Failed to add 0x00000079861000 - 0x00000079863fff flags: 1");
        return -219;
    }

    if (!pmem_rangemap_add(r, 0x00000079864000, 0x00000079865fff, 1)) {
        pmem_warn("Failed to add 0x00000079864000 - 0x00000079865fff flags: 1");
        return -220;
    }

    if (!pmem_rangemap_add(r, 0x00000079866000, 0x00000079867fff, 1)) {
        pmem_warn("Failed to add 0x00000079866000 - 0x00000079867fff flags: 1");
        return -221;
    }

    if (!pmem_rangemap_add(r, 0x00000079868000, 0x00000079869fff, 1)) {
        pmem_warn("Failed to add 0x00000079868000 - 0x00000079869fff flags: 1");
        return -222;
    }

    if (!pmem_rangemap_add(r, 0x0000007986a000, 0x00000079c8dfff, 1)) {
        pmem_warn("Failed to add 0x0000007986a000 - 0x00000079c8dfff flags: 1");
        return -223;
    }

    if (!pmem_rangemap_add(r, 0x00000079c8e000, 0x00000079c97fff, 1)) {
        pmem_warn("Failed to add 0x00000079c8e000 - 0x00000079c97fff flags: 1");
        return -224;
    }

    if (!pmem_rangemap_add(r, 0x00000079c98000, 0x00000079c9bfff, 1)) {
        pmem_warn("Failed to add 0x00000079c98000 - 0x00000079c9bfff flags: 1");
        return -225;
    }

    if (!pmem_rangemap_add(r, 0x00000079c9c000, 0x00000079c9dfff, 1)) {
        pmem_warn("Failed to add 0x00000079c9c000 - 0x00000079c9dfff flags: 1");
        return -226;
    }

    if (!pmem_rangemap_add(r, 0x00000079c9e000, 0x00000079ca3fff, 1)) {
        pmem_warn("Failed to add 0x00000079c9e000 - 0x00000079ca3fff flags: 1");
        return -227;
    }

    if (!pmem_rangemap_add(r, 0x00000079ca4000, 0x00000079ca4fff, 1)) {
        pmem_warn("Failed to add 0x00000079ca4000 - 0x00000079ca4fff flags: 1");
        return -228;
    }

    if (!pmem_rangemap_add(r, 0x00000079ca5000, 0x00000079d32fff, 1)) {
        pmem_warn("Failed to add 0x00000079ca5000 - 0x00000079d32fff flags: 1");
        return -229;
    }

    if (!pmem_rangemap_add(r, 0x00000079d33000, 0x00000079d33fff, 1)) {
        pmem_warn("Failed to add 0x00000079d33000 - 0x00000079d33fff flags: 1");
        return -230;
    }

    if (!pmem_rangemap_add(r, 0x00000079d34000, 0x00000079d35fff, 1)) {
        pmem_warn("Failed to add 0x00000079d34000 - 0x00000079d35fff flags: 1");
        return -231;
    }

    if (!pmem_rangemap_add(r, 0x00000079d36000, 0x00000079d37fff, 1)) {
        pmem_warn("Failed to add 0x00000079d36000 - 0x00000079d37fff flags: 1");
        return -232;
    }

    if (!pmem_rangemap_add(r, 0x00000079d38000, 0x00000079d38fff, 1)) {
        pmem_warn("Failed to add 0x00000079d38000 - 0x00000079d38fff flags: 1");
        return -233;
    }

    if (!pmem_rangemap_add(r, 0x00000079d39000, 0x00000079d3bfff, 1)) {
        pmem_warn("Failed to add 0x00000079d39000 - 0x00000079d3bfff flags: 1");
        return -234;
    }

    if (!pmem_rangemap_add(r, 0x00000079d3c000, 0x00000079d3efff, 1)) {
        pmem_warn("Failed to add 0x00000079d3c000 - 0x00000079d3efff flags: 1");
        return -235;
    }

    if (!pmem_rangemap_add(r, 0x00000079d3f000, 0x00000079d3ffff, 1)) {
        pmem_warn("Failed to add 0x00000079d3f000 - 0x00000079d3ffff flags: 1");
        return -236;
    }

    if (!pmem_rangemap_add(r, 0x00000079d40000, 0x00000079d43fff, 1)) {
        pmem_warn("Failed to add 0x00000079d40000 - 0x00000079d43fff flags: 1");
        return -237;
    }

    if (!pmem_rangemap_add(r, 0x00000079d44000, 0x00000079d44fff, 1)) {
        pmem_warn("Failed to add 0x00000079d44000 - 0x00000079d44fff flags: 1");
        return -238;
    }

    if (!pmem_rangemap_add(r, 0x00000079d45000, 0x0000007ad02fff, 1)) {
        pmem_warn("Failed to add 0x00000079d45000 - 0x0000007ad02fff flags: 1");
        return -239;
    }

    if (!pmem_rangemap_add(r, 0x0000007ad03000, 0x0000007ad13fff, 1)) {
        pmem_warn("Failed to add 0x0000007ad03000 - 0x0000007ad13fff flags: 1");
        return -240;
    }

    if (!pmem_rangemap_add(r, 0x0000007ad14000, 0x0000007ad52fff, 1)) {
        pmem_warn("Failed to add 0x0000007ad14000 - 0x0000007ad52fff flags: 1");
        return -241;
    }

    if (!pmem_rangemap_add(r, 0x0000007ad53000, 0x0000007ad5efff, 1)) {
        pmem_warn("Failed to add 0x0000007ad53000 - 0x0000007ad5efff flags: 1");
        return -242;
    }

    if (!pmem_rangemap_add(r, 0x0000007ad5f000, 0x0000007ad8efff, 1)) {
        pmem_warn("Failed to add 0x0000007ad5f000 - 0x0000007ad8efff flags: 1");
        return -243;
    }

    if (!pmem_rangemap_add(r, 0x0000007ad8f000, 0x0000007ae38fff, 1)) {
        pmem_warn("Failed to add 0x0000007ad8f000 - 0x0000007ae38fff flags: 1");
        return -244;
    }

    if (!pmem_rangemap_add(r, 0x0000007ae39000, 0x0000007ae8efff, 1)) {
        pmem_warn("Failed to add 0x0000007ae39000 - 0x0000007ae8efff flags: 1");
        return -245;
    }

    if (!pmem_rangemap_add(r, 0x0000007ae8f000, 0x0000007aecffff, 1)) {
        pmem_warn("Failed to add 0x0000007ae8f000 - 0x0000007aecffff flags: 1");
        return -246;
    }

    if (!pmem_rangemap_add(r, 0x0000007aed0000, 0x0000007aefefff, 1)) {
        pmem_warn("Failed to add 0x0000007aed0000 - 0x0000007aefefff flags: 1");
        return -247;
    }

    if (!pmem_rangemap_add(r, 0x0000007aeff000, 0x0000007af7afff, 1)) {
        pmem_warn("Failed to add 0x0000007aeff000 - 0x0000007af7afff flags: 1");
        return -248;
    }

    if (!pmem_rangemap_add(r, 0x0000007afe5000, 0x0000007affffff, 1)) {
        pmem_warn("Failed to add 0x0000007afe5000 - 0x0000007affffff flags: 1");
        return -250;
    }

    if (!pmem_rangemap_add(r, 0x00000100000000, 0x0000047f5fffff, 1)) {
        pmem_warn("Failed to add 0x00000100000000 - 0x0000047f5fffff flags: 1");
        return -255;
    }

    if (!assert_rangemap_test(r, 0x00000000000000, 1)) {
        pmem_warn("Failed assert: 0x00000000000000 = 1");
        return -61441;
    }

    if (!assert_rangemap_test(r, 0x00000000057fff, 1)) {
        pmem_warn("Failed assert: 0x00000000057fff = 1");
        return -3841;
    }

    if (!assert_rangemap_test(r, 0x00000000058000, 0)) {
        pmem_warn("Failed assert: 0x00000000058000 = 0");
        return -61442;
    }

    if (!assert_rangemap_test(r, 0x00000000058fff, 0)) {
        pmem_warn("Failed assert: 0x00000000058fff = 0");
        return -3842;
    }

    if (!assert_rangemap_test(r, 0x00000000059000, 1)) {
        pmem_warn("Failed assert: 0x00000000059000 = 1");
        return -61443;
    }

    if (!assert_rangemap_test(r, 0x0000000008efff, 1)) {
        pmem_warn("Failed assert: 0x0000000008efff = 1");
        return -3843;
    }

    if (!assert_rangemap_test(r, 0x0000000008f000, 0)) {
        pmem_warn("Failed assert: 0x0000000008f000 = 0");
        return -61444;
    }

    if (!assert_rangemap_test(r, 0x0000000008ffff, 0)) {
        pmem_warn("Failed assert: 0x0000000008ffff = 0");
        return -3844;
    }

    if (!assert_rangemap_test(r, 0x00000000090000, 1)) {
        pmem_warn("Failed assert: 0x00000000090000 = 1");
        return -61445;
    }

    if (!assert_rangemap_test(r, 0x0000000009ffff, 1)) {
        pmem_warn("Failed assert: 0x0000000009ffff = 1");
        return -3845;
    }

    if (!assert_rangemap_test(r, 0x000000000a0000, 0)) {
        pmem_warn("Failed assert: 0x000000000a0000 = 0");
        return -61446;
    }

    if (!assert_rangemap_test(r, 0x000000000bffff, 0)) {
        pmem_warn("Failed assert: 0x000000000bffff = 0");
        return -3846;
    }

    if (!assert_rangemap_test(r, 0x00000000100000, 1)) {
        pmem_warn("Failed assert: 0x00000000100000 = 1");
        return -61447;
    }

    if (!assert_rangemap_test(r, 0x000000096fffff, 1)) {
        pmem_warn("Failed assert: 0x000000096fffff = 1");
        return -3847;
    }

    if (!assert_rangemap_test(r, 0x00000009700000, 1)) {
        pmem_warn("Failed assert: 0x00000009700000 = 1");
        return -61448;
    }

    if (!assert_rangemap_test(r, 0x00000009712fff, 1)) {
        pmem_warn("Failed assert: 0x00000009712fff = 1");
        return -3848;
    }

    if (!assert_rangemap_test(r, 0x00000009713000, 1)) {
        pmem_warn("Failed assert: 0x00000009713000 = 1");
        return -61449;
    }

    if (!assert_rangemap_test(r, 0x000000097fffff, 1)) {
        pmem_warn("Failed assert: 0x000000097fffff = 1");
        return -3849;
    }

    if (!assert_rangemap_test(r, 0x00000009800000, 1)) {
        pmem_warn("Failed assert: 0x00000009800000 = 1");
        return -61450;
    }

    if (!assert_rangemap_test(r, 0x0000000c433fff, 1)) {
        pmem_warn("Failed assert: 0x0000000c433fff = 1");
        return -3850;
    }

    if (!assert_rangemap_test(r, 0x0000000c434000, 1)) {
        pmem_warn("Failed assert: 0x0000000c434000 = 1");
        return -61451;
    }

    if (!assert_rangemap_test(r, 0x0000000c489fff, 1)) {
        pmem_warn("Failed assert: 0x0000000c489fff = 1");
        return -3851;
    }

    if (!assert_rangemap_test(r, 0x0000000c48a000, 1)) {
        pmem_warn("Failed assert: 0x0000000c48a000 = 1");
        return -61452;
    }

    if (!assert_rangemap_test(r, 0x0000000c4b8fff, 1)) {
        pmem_warn("Failed assert: 0x0000000c4b8fff = 1");
        return -3852;
    }

    if (!assert_rangemap_test(r, 0x0000000c4b9000, 1)) {
        pmem_warn("Failed assert: 0x0000000c4b9000 = 1");
        return -61453;
    }

    if (!assert_rangemap_test(r, 0x0000000c4fcfff, 1)) {
        pmem_warn("Failed assert: 0x0000000c4fcfff = 1");
        return -3853;
    }

    if (!assert_rangemap_test(r, 0x0000000c4fd000, 1)) {
        pmem_warn("Failed assert: 0x0000000c4fd000 = 1");
        return -61454;
    }

    if (!assert_rangemap_test(r, 0x0000006a79bfff, 1)) {
        pmem_warn("Failed assert: 0x0000006a79bfff = 1");
        return -3854;
    }

    if (!assert_rangemap_test(r, 0x0000006a79c000, 1)) {
        pmem_warn("Failed assert: 0x0000006a79c000 = 1");
        return -61455;
    }

    if (!assert_rangemap_test(r, 0x0000006d1dffff, 1)) {
        pmem_warn("Failed assert: 0x0000006d1dffff = 1");
        return -3855;
    }

    if (!assert_rangemap_test(r, 0x0000006d1e0000, 1)) {
        pmem_warn("Failed assert: 0x0000006d1e0000 = 1");
        return -61456;
    }

    if (!assert_rangemap_test(r, 0x0000006d1f1fff, 1)) {
        pmem_warn("Failed assert: 0x0000006d1f1fff = 1");
        return -3856;
    }

    if (!assert_rangemap_test(r, 0x0000006d1f2000, 1)) {
        pmem_warn("Failed assert: 0x0000006d1f2000 = 1");
        return -61457;
    }

    if (!assert_rangemap_test(r, 0x0000006d1f4fff, 1)) {
        pmem_warn("Failed assert: 0x0000006d1f4fff = 1");
        return -3857;
    }

    if (!assert_rangemap_test(r, 0x0000006d1f5000, 1)) {
        pmem_warn("Failed assert: 0x0000006d1f5000 = 1");
        return -61458;
    }

    if (!assert_rangemap_test(r, 0x0000006d1f6fff, 1)) {
        pmem_warn("Failed assert: 0x0000006d1f6fff = 1");
        return -3858;
    }

    if (!assert_rangemap_test(r, 0x0000006d1f7000, 1)) {
        pmem_warn("Failed assert: 0x0000006d1f7000 = 1");
        return -61459;
    }

    if (!assert_rangemap_test(r, 0x0000006e77ffff, 1)) {
        pmem_warn("Failed assert: 0x0000006e77ffff = 1");
        return -3859;
    }

    if (!assert_rangemap_test(r, 0x0000006e780000, 1)) {
        pmem_warn("Failed assert: 0x0000006e780000 = 1");
        return -61460;
    }

    if (!assert_rangemap_test(r, 0x0000006e8abfff, 1)) {
        pmem_warn("Failed assert: 0x0000006e8abfff = 1");
        return -3860;
    }

    if (!assert_rangemap_test(r, 0x0000006e8ac000, 1)) {
        pmem_warn("Failed assert: 0x0000006e8ac000 = 1");
        return -61461;
    }

    if (!assert_rangemap_test(r, 0x0000006ea3efff, 1)) {
        pmem_warn("Failed assert: 0x0000006ea3efff = 1");
        return -3861;
    }

    if (!assert_rangemap_test(r, 0x0000006ea3f000, 1)) {
        pmem_warn("Failed assert: 0x0000006ea3f000 = 1");
        return -61462;
    }

    if (!assert_rangemap_test(r, 0x0000006ea65fff, 1)) {
        pmem_warn("Failed assert: 0x0000006ea65fff = 1");
        return -3862;
    }

    if (!assert_rangemap_test(r, 0x0000006ea66000, 1)) {
        pmem_warn("Failed assert: 0x0000006ea66000 = 1");
        return -61463;
    }

    if (!assert_rangemap_test(r, 0x0000006ea8bfff, 1)) {
        pmem_warn("Failed assert: 0x0000006ea8bfff = 1");
        return -3863;
    }

    if (!assert_rangemap_test(r, 0x0000006ea8c000, 1)) {
        pmem_warn("Failed assert: 0x0000006ea8c000 = 1");
        return -61464;
    }

    if (!assert_rangemap_test(r, 0x0000006ea91fff, 1)) {
        pmem_warn("Failed assert: 0x0000006ea91fff = 1");
        return -3864;
    }

    if (!assert_rangemap_test(r, 0x0000006ea92000, 1)) {
        pmem_warn("Failed assert: 0x0000006ea92000 = 1");
        return -61465;
    }

    if (!assert_rangemap_test(r, 0x0000006ea98fff, 1)) {
        pmem_warn("Failed assert: 0x0000006ea98fff = 1");
        return -3865;
    }

    if (!assert_rangemap_test(r, 0x0000006ea99000, 1)) {
        pmem_warn("Failed assert: 0x0000006ea99000 = 1");
        return -61466;
    }

    if (!assert_rangemap_test(r, 0x0000006eaadfff, 1)) {
        pmem_warn("Failed assert: 0x0000006eaadfff = 1");
        return -3866;
    }

    if (!assert_rangemap_test(r, 0x0000006eaae000, 1)) {
        pmem_warn("Failed assert: 0x0000006eaae000 = 1");
        return -61467;
    }

    if (!assert_rangemap_test(r, 0x0000006eab4fff, 1)) {
        pmem_warn("Failed assert: 0x0000006eab4fff = 1");
        return -3867;
    }

    if (!assert_rangemap_test(r, 0x0000006eab5000, 1)) {
        pmem_warn("Failed assert: 0x0000006eab5000 = 1");
        return -61468;
    }

    if (!assert_rangemap_test(r, 0x0000006eac5fff, 1)) {
        pmem_warn("Failed assert: 0x0000006eac5fff = 1");
        return -3868;
    }

    if (!assert_rangemap_test(r, 0x0000006eac6000, 1)) {
        pmem_warn("Failed assert: 0x0000006eac6000 = 1");
        return -61469;
    }

    if (!assert_rangemap_test(r, 0x0000006eac6fff, 1)) {
        pmem_warn("Failed assert: 0x0000006eac6fff = 1");
        return -3869;
    }

    if (!assert_rangemap_test(r, 0x0000006eac7000, 1)) {
        pmem_warn("Failed assert: 0x0000006eac7000 = 1");
        return -61470;
    }

    if (!assert_rangemap_test(r, 0x0000006eacafff, 1)) {
        pmem_warn("Failed assert: 0x0000006eacafff = 1");
        return -3870;
    }

    if (!assert_rangemap_test(r, 0x0000006eacb000, 1)) {
        pmem_warn("Failed assert: 0x0000006eacb000 = 1");
        return -61471;
    }

    if (!assert_rangemap_test(r, 0x0000006ead1fff, 1)) {
        pmem_warn("Failed assert: 0x0000006ead1fff = 1");
        return -3871;
    }

    if (!assert_rangemap_test(r, 0x0000006ead2000, 1)) {
        pmem_warn("Failed assert: 0x0000006ead2000 = 1");
        return -61472;
    }

    if (!assert_rangemap_test(r, 0x0000006ead4fff, 1)) {
        pmem_warn("Failed assert: 0x0000006ead4fff = 1");
        return -3872;
    }

    if (!assert_rangemap_test(r, 0x0000006ead5000, 1)) {
        pmem_warn("Failed assert: 0x0000006ead5000 = 1");
        return -61473;
    }

    if (!assert_rangemap_test(r, 0x00000073b5ffff, 1)) {
        pmem_warn("Failed assert: 0x00000073b5ffff = 1");
        return -3873;
    }

    if (!assert_rangemap_test(r, 0x00000073b60000, 1)) {
        pmem_warn("Failed assert: 0x00000073b60000 = 1");
        return -61474;
    }

    if (!assert_rangemap_test(r, 0x00000073b75fff, 1)) {
        pmem_warn("Failed assert: 0x00000073b75fff = 1");
        return -3874;
    }

    if (!assert_rangemap_test(r, 0x00000073b76000, 1)) {
        pmem_warn("Failed assert: 0x00000073b76000 = 1");
        return -61475;
    }

    if (!assert_rangemap_test(r, 0x00000073b76fff, 1)) {
        pmem_warn("Failed assert: 0x00000073b76fff = 1");
        return -3875;
    }

    if (!assert_rangemap_test(r, 0x00000073b77000, 1)) {
        pmem_warn("Failed assert: 0x00000073b77000 = 1");
        return -61476;
    }

    if (!assert_rangemap_test(r, 0x00000073b87fff, 1)) {
        pmem_warn("Failed assert: 0x00000073b87fff = 1");
        return -3876;
    }

    if (!assert_rangemap_test(r, 0x00000073b88000, 1)) {
        pmem_warn("Failed assert: 0x00000073b88000 = 1");
        return -61477;
    }

    if (!assert_rangemap_test(r, 0x00000073b89fff, 1)) {
        pmem_warn("Failed assert: 0x00000073b89fff = 1");
        return -3877;
    }

    if (!assert_rangemap_test(r, 0x00000073b8a000, 1)) {
        pmem_warn("Failed assert: 0x00000073b8a000 = 1");
        return -61478;
    }

    if (!assert_rangemap_test(r, 0x00000073b8dfff, 1)) {
        pmem_warn("Failed assert: 0x00000073b8dfff = 1");
        return -3878;
    }

    if (!assert_rangemap_test(r, 0x00000073b8e000, 1)) {
        pmem_warn("Failed assert: 0x00000073b8e000 = 1");
        return -61479;
    }

    if (!assert_rangemap_test(r, 0x00000073b8ffff, 1)) {
        pmem_warn("Failed assert: 0x00000073b8ffff = 1");
        return -3879;
    }

    if (!assert_rangemap_test(r, 0x00000073b90000, 1)) {
        pmem_warn("Failed assert: 0x00000073b90000 = 1");
        return -61480;
    }

    if (!assert_rangemap_test(r, 0x00000073b90fff, 1)) {
        pmem_warn("Failed assert: 0x00000073b90fff = 1");
        return -3880;
    }

    if (!assert_rangemap_test(r, 0x00000073b91000, 1)) {
        pmem_warn("Failed assert: 0x00000073b91000 = 1");
        return -61481;
    }

    if (!assert_rangemap_test(r, 0x00000073b93fff, 1)) {
        pmem_warn("Failed assert: 0x00000073b93fff = 1");
        return -3881;
    }

    if (!assert_rangemap_test(r, 0x00000073b94000, 1)) {
        pmem_warn("Failed assert: 0x00000073b94000 = 1");
        return -61482;
    }

    if (!assert_rangemap_test(r, 0x00000073bb1fff, 1)) {
        pmem_warn("Failed assert: 0x00000073bb1fff = 1");
        return -3882;
    }

    if (!assert_rangemap_test(r, 0x00000073bb2000, 1)) {
        pmem_warn("Failed assert: 0x00000073bb2000 = 1");
        return -61483;
    }

    if (!assert_rangemap_test(r, 0x00000073bb2fff, 1)) {
        pmem_warn("Failed assert: 0x00000073bb2fff = 1");
        return -3883;
    }

    if (!assert_rangemap_test(r, 0x00000073bb3000, 1)) {
        pmem_warn("Failed assert: 0x00000073bb3000 = 1");
        return -61484;
    }

    if (!assert_rangemap_test(r, 0x00000073bb5fff, 1)) {
        pmem_warn("Failed assert: 0x00000073bb5fff = 1");
        return -3884;
    }

    if (!assert_rangemap_test(r, 0x00000073bb6000, 1)) {
        pmem_warn("Failed assert: 0x00000073bb6000 = 1");
        return -61485;
    }

    if (!assert_rangemap_test(r, 0x00000073bb8fff, 1)) {
        pmem_warn("Failed assert: 0x00000073bb8fff = 1");
        return -3885;
    }

    if (!assert_rangemap_test(r, 0x00000073bb9000, 1)) {
        pmem_warn("Failed assert: 0x00000073bb9000 = 1");
        return -61486;
    }

    if (!assert_rangemap_test(r, 0x00000073bbcfff, 1)) {
        pmem_warn("Failed assert: 0x00000073bbcfff = 1");
        return -3886;
    }

    if (!assert_rangemap_test(r, 0x00000073bbd000, 1)) {
        pmem_warn("Failed assert: 0x00000073bbd000 = 1");
        return -61487;
    }

    if (!assert_rangemap_test(r, 0x00000073bc3fff, 1)) {
        pmem_warn("Failed assert: 0x00000073bc3fff = 1");
        return -3887;
    }

    if (!assert_rangemap_test(r, 0x00000073bc4000, 1)) {
        pmem_warn("Failed assert: 0x00000073bc4000 = 1");
        return -61488;
    }

    if (!assert_rangemap_test(r, 0x00000073bd5fff, 1)) {
        pmem_warn("Failed assert: 0x00000073bd5fff = 1");
        return -3888;
    }

    if (!assert_rangemap_test(r, 0x00000073bd6000, 1)) {
        pmem_warn("Failed assert: 0x00000073bd6000 = 1");
        return -61489;
    }

    if (!assert_rangemap_test(r, 0x00000073bd7fff, 1)) {
        pmem_warn("Failed assert: 0x00000073bd7fff = 1");
        return -3889;
    }

    if (!assert_rangemap_test(r, 0x00000073bd8000, 1)) {
        pmem_warn("Failed assert: 0x00000073bd8000 = 1");
        return -61490;
    }

    if (!assert_rangemap_test(r, 0x00000073bdefff, 1)) {
        pmem_warn("Failed assert: 0x00000073bdefff = 1");
        return -3890;
    }

    if (!assert_rangemap_test(r, 0x00000073bdf000, 1)) {
        pmem_warn("Failed assert: 0x00000073bdf000 = 1");
        return -61491;
    }

    if (!assert_rangemap_test(r, 0x00000073be0fff, 1)) {
        pmem_warn("Failed assert: 0x00000073be0fff = 1");
        return -3891;
    }

    if (!assert_rangemap_test(r, 0x00000073be1000, 1)) {
        pmem_warn("Failed assert: 0x00000073be1000 = 1");
        return -61492;
    }

    if (!assert_rangemap_test(r, 0x00000073be4fff, 1)) {
        pmem_warn("Failed assert: 0x00000073be4fff = 1");
        return -3892;
    }

    if (!assert_rangemap_test(r, 0x00000073be5000, 1)) {
        pmem_warn("Failed assert: 0x00000073be5000 = 1");
        return -61493;
    }

    if (!assert_rangemap_test(r, 0x00000076eddfff, 1)) {
        pmem_warn("Failed assert: 0x00000076eddfff = 1");
        return -3893;
    }

    if (!assert_rangemap_test(r, 0x00000076ede000, 1)) {
        pmem_warn("Failed assert: 0x00000076ede000 = 1");
        return -61494;
    }

    if (!assert_rangemap_test(r, 0x00000076ee2fff, 1)) {
        pmem_warn("Failed assert: 0x00000076ee2fff = 1");
        return -3894;
    }

    if (!assert_rangemap_test(r, 0x00000076ee3000, 1)) {
        pmem_warn("Failed assert: 0x00000076ee3000 = 1");
        return -61495;
    }

    if (!assert_rangemap_test(r, 0x00000076ee3fff, 1)) {
        pmem_warn("Failed assert: 0x00000076ee3fff = 1");
        return -3895;
    }

    if (!assert_rangemap_test(r, 0x00000076ee4000, 1)) {
        pmem_warn("Failed assert: 0x00000076ee4000 = 1");
        return -61496;
    }

    if (!assert_rangemap_test(r, 0x00000076ee6fff, 1)) {
        pmem_warn("Failed assert: 0x00000076ee6fff = 1");
        return -3896;
    }

    if (!assert_rangemap_test(r, 0x00000076ee7000, 1)) {
        pmem_warn("Failed assert: 0x00000076ee7000 = 1");
        return -61497;
    }

    if (!assert_rangemap_test(r, 0x00000076ee7fff, 1)) {
        pmem_warn("Failed assert: 0x00000076ee7fff = 1");
        return -3897;
    }

    if (!assert_rangemap_test(r, 0x00000076ee8000, 1)) {
        pmem_warn("Failed assert: 0x00000076ee8000 = 1");
        return -61498;
    }

    if (!assert_rangemap_test(r, 0x00000076eecfff, 1)) {
        pmem_warn("Failed assert: 0x00000076eecfff = 1");
        return -3898;
    }

    if (!assert_rangemap_test(r, 0x00000076eed000, 1)) {
        pmem_warn("Failed assert: 0x00000076eed000 = 1");
        return -61499;
    }

    if (!assert_rangemap_test(r, 0x00000076eeffff, 1)) {
        pmem_warn("Failed assert: 0x00000076eeffff = 1");
        return -3899;
    }

    if (!assert_rangemap_test(r, 0x00000076ef0000, 1)) {
        pmem_warn("Failed assert: 0x00000076ef0000 = 1");
        return -61500;
    }

    if (!assert_rangemap_test(r, 0x00000076ef0fff, 1)) {
        pmem_warn("Failed assert: 0x00000076ef0fff = 1");
        return -3900;
    }

    if (!assert_rangemap_test(r, 0x00000076ef1000, 1)) {
        pmem_warn("Failed assert: 0x00000076ef1000 = 1");
        return -61501;
    }

    if (!assert_rangemap_test(r, 0x00000077414fff, 1)) {
        pmem_warn("Failed assert: 0x00000077414fff = 1");
        return -3901;
    }

    if (!assert_rangemap_test(r, 0x00000077415000, 1)) {
        pmem_warn("Failed assert: 0x00000077415000 = 1");
        return -61502;
    }

    if (!assert_rangemap_test(r, 0x00000077419fff, 1)) {
        pmem_warn("Failed assert: 0x00000077419fff = 1");
        return -3902;
    }

    if (!assert_rangemap_test(r, 0x0000007741a000, 1)) {
        pmem_warn("Failed assert: 0x0000007741a000 = 1");
        return -61503;
    }

    if (!assert_rangemap_test(r, 0x000000777aafff, 1)) {
        pmem_warn("Failed assert: 0x000000777aafff = 1");
        return -3903;
    }

    if (!assert_rangemap_test(r, 0x000000777ab000, 1)) {
        pmem_warn("Failed assert: 0x000000777ab000 = 1");
        return -61504;
    }

    if (!assert_rangemap_test(r, 0x0000007783afff, 1)) {
        pmem_warn("Failed assert: 0x0000007783afff = 1");
        return -3904;
    }

    if (!assert_rangemap_test(r, 0x0000007783b000, 1)) {
        pmem_warn("Failed assert: 0x0000007783b000 = 1");
        return -61505;
    }

    if (!assert_rangemap_test(r, 0x000000778bafff, 1)) {
        pmem_warn("Failed assert: 0x000000778bafff = 1");
        return -3905;
    }

    if (!assert_rangemap_test(r, 0x000000778bb000, 1)) {
        pmem_warn("Failed assert: 0x000000778bb000 = 1");
        return -61506;
    }

    if (!assert_rangemap_test(r, 0x000000778bbfff, 1)) {
        pmem_warn("Failed assert: 0x000000778bbfff = 1");
        return -3906;
    }

    if (!assert_rangemap_test(r, 0x000000778bc000, 1)) {
        pmem_warn("Failed assert: 0x000000778bc000 = 1");
        return -61507;
    }

    if (!assert_rangemap_test(r, 0x000000778bdfff, 1)) {
        pmem_warn("Failed assert: 0x000000778bdfff = 1");
        return -3907;
    }

    if (!assert_rangemap_test(r, 0x000000778be000, 1)) {
        pmem_warn("Failed assert: 0x000000778be000 = 1");
        return -61508;
    }

    if (!assert_rangemap_test(r, 0x000000778bffff, 1)) {
        pmem_warn("Failed assert: 0x000000778bffff = 1");
        return -3908;
    }

    if (!assert_rangemap_test(r, 0x000000778c0000, 1)) {
        pmem_warn("Failed assert: 0x000000778c0000 = 1");
        return -61509;
    }

    if (!assert_rangemap_test(r, 0x000000778c1fff, 1)) {
        pmem_warn("Failed assert: 0x000000778c1fff = 1");
        return -3909;
    }

    if (!assert_rangemap_test(r, 0x000000778c2000, 1)) {
        pmem_warn("Failed assert: 0x000000778c2000 = 1");
        return -61510;
    }

    if (!assert_rangemap_test(r, 0x000000778c3fff, 1)) {
        pmem_warn("Failed assert: 0x000000778c3fff = 1");
        return -3910;
    }

    if (!assert_rangemap_test(r, 0x000000778c4000, 1)) {
        pmem_warn("Failed assert: 0x000000778c4000 = 1");
        return -61511;
    }

    if (!assert_rangemap_test(r, 0x00000079446fff, 1)) {
        pmem_warn("Failed assert: 0x00000079446fff = 1");
        return -3911;
    }

    if (!assert_rangemap_test(r, 0x00000079447000, 1)) {
        pmem_warn("Failed assert: 0x00000079447000 = 1");
        return -61512;
    }

    if (!assert_rangemap_test(r, 0x00000079456fff, 1)) {
        pmem_warn("Failed assert: 0x00000079456fff = 1");
        return -3912;
    }

    if (!assert_rangemap_test(r, 0x00000079457000, 1)) {
        pmem_warn("Failed assert: 0x00000079457000 = 1");
        return -61513;
    }

    if (!assert_rangemap_test(r, 0x0000007946dfff, 1)) {
        pmem_warn("Failed assert: 0x0000007946dfff = 1");
        return -3913;
    }

    if (!assert_rangemap_test(r, 0x0000007946e000, 1)) {
        pmem_warn("Failed assert: 0x0000007946e000 = 1");
        return -61514;
    }

    if (!assert_rangemap_test(r, 0x0000007946ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007946ffff = 1");
        return -3914;
    }

    if (!assert_rangemap_test(r, 0x00000079470000, 1)) {
        pmem_warn("Failed assert: 0x00000079470000 = 1");
        return -61515;
    }

    if (!assert_rangemap_test(r, 0x00000079471fff, 1)) {
        pmem_warn("Failed assert: 0x00000079471fff = 1");
        return -3915;
    }

    if (!assert_rangemap_test(r, 0x00000079472000, 1)) {
        pmem_warn("Failed assert: 0x00000079472000 = 1");
        return -61516;
    }

    if (!assert_rangemap_test(r, 0x00000079472fff, 1)) {
        pmem_warn("Failed assert: 0x00000079472fff = 1");
        return -3916;
    }

    if (!assert_rangemap_test(r, 0x00000079473000, 1)) {
        pmem_warn("Failed assert: 0x00000079473000 = 1");
        return -61517;
    }

    if (!assert_rangemap_test(r, 0x00000079475fff, 1)) {
        pmem_warn("Failed assert: 0x00000079475fff = 1");
        return -3917;
    }

    if (!assert_rangemap_test(r, 0x00000079476000, 1)) {
        pmem_warn("Failed assert: 0x00000079476000 = 1");
        return -61518;
    }

    if (!assert_rangemap_test(r, 0x0000007947efff, 1)) {
        pmem_warn("Failed assert: 0x0000007947efff = 1");
        return -3918;
    }

    if (!assert_rangemap_test(r, 0x0000007947f000, 1)) {
        pmem_warn("Failed assert: 0x0000007947f000 = 1");
        return -61519;
    }

    if (!assert_rangemap_test(r, 0x00000079482fff, 1)) {
        pmem_warn("Failed assert: 0x00000079482fff = 1");
        return -3919;
    }

    if (!assert_rangemap_test(r, 0x00000079483000, 1)) {
        pmem_warn("Failed assert: 0x00000079483000 = 1");
        return -61520;
    }

    if (!assert_rangemap_test(r, 0x00000079483fff, 1)) {
        pmem_warn("Failed assert: 0x00000079483fff = 1");
        return -3920;
    }

    if (!assert_rangemap_test(r, 0x00000079484000, 1)) {
        pmem_warn("Failed assert: 0x00000079484000 = 1");
        return -61521;
    }

    if (!assert_rangemap_test(r, 0x00000079485fff, 1)) {
        pmem_warn("Failed assert: 0x00000079485fff = 1");
        return -3921;
    }

    if (!assert_rangemap_test(r, 0x00000079486000, 1)) {
        pmem_warn("Failed assert: 0x00000079486000 = 1");
        return -61522;
    }

    if (!assert_rangemap_test(r, 0x0000007948dfff, 1)) {
        pmem_warn("Failed assert: 0x0000007948dfff = 1");
        return -3922;
    }

    if (!assert_rangemap_test(r, 0x0000007948e000, 1)) {
        pmem_warn("Failed assert: 0x0000007948e000 = 1");
        return -61523;
    }

    if (!assert_rangemap_test(r, 0x00000079495fff, 1)) {
        pmem_warn("Failed assert: 0x00000079495fff = 1");
        return -3923;
    }

    if (!assert_rangemap_test(r, 0x00000079496000, 1)) {
        pmem_warn("Failed assert: 0x00000079496000 = 1");
        return -61524;
    }

    if (!assert_rangemap_test(r, 0x0000007949afff, 1)) {
        pmem_warn("Failed assert: 0x0000007949afff = 1");
        return -3924;
    }

    if (!assert_rangemap_test(r, 0x0000007949b000, 1)) {
        pmem_warn("Failed assert: 0x0000007949b000 = 1");
        return -61525;
    }

    if (!assert_rangemap_test(r, 0x000000794a3fff, 1)) {
        pmem_warn("Failed assert: 0x000000794a3fff = 1");
        return -3925;
    }

    if (!assert_rangemap_test(r, 0x000000794a4000, 1)) {
        pmem_warn("Failed assert: 0x000000794a4000 = 1");
        return -61526;
    }

    if (!assert_rangemap_test(r, 0x000000794a4fff, 1)) {
        pmem_warn("Failed assert: 0x000000794a4fff = 1");
        return -3926;
    }

    if (!assert_rangemap_test(r, 0x000000794a5000, 1)) {
        pmem_warn("Failed assert: 0x000000794a5000 = 1");
        return -61527;
    }

    if (!assert_rangemap_test(r, 0x000000794b3fff, 1)) {
        pmem_warn("Failed assert: 0x000000794b3fff = 1");
        return -3927;
    }

    if (!assert_rangemap_test(r, 0x000000794b4000, 1)) {
        pmem_warn("Failed assert: 0x000000794b4000 = 1");
        return -61528;
    }

    if (!assert_rangemap_test(r, 0x000000794b7fff, 1)) {
        pmem_warn("Failed assert: 0x000000794b7fff = 1");
        return -3928;
    }

    if (!assert_rangemap_test(r, 0x000000794b8000, 1)) {
        pmem_warn("Failed assert: 0x000000794b8000 = 1");
        return -61529;
    }

    if (!assert_rangemap_test(r, 0x000000794bdfff, 1)) {
        pmem_warn("Failed assert: 0x000000794bdfff = 1");
        return -3929;
    }

    if (!assert_rangemap_test(r, 0x000000794be000, 1)) {
        pmem_warn("Failed assert: 0x000000794be000 = 1");
        return -61530;
    }

    if (!assert_rangemap_test(r, 0x000000794befff, 1)) {
        pmem_warn("Failed assert: 0x000000794befff = 1");
        return -3930;
    }

    if (!assert_rangemap_test(r, 0x000000794bf000, 1)) {
        pmem_warn("Failed assert: 0x000000794bf000 = 1");
        return -61531;
    }

    if (!assert_rangemap_test(r, 0x000000794bffff, 1)) {
        pmem_warn("Failed assert: 0x000000794bffff = 1");
        return -3931;
    }

    if (!assert_rangemap_test(r, 0x000000794c0000, 1)) {
        pmem_warn("Failed assert: 0x000000794c0000 = 1");
        return -61532;
    }

    if (!assert_rangemap_test(r, 0x000000794c0fff, 1)) {
        pmem_warn("Failed assert: 0x000000794c0fff = 1");
        return -3932;
    }

    if (!assert_rangemap_test(r, 0x000000794c1000, 1)) {
        pmem_warn("Failed assert: 0x000000794c1000 = 1");
        return -61533;
    }

    if (!assert_rangemap_test(r, 0x000000794dafff, 1)) {
        pmem_warn("Failed assert: 0x000000794dafff = 1");
        return -3933;
    }

    if (!assert_rangemap_test(r, 0x000000794db000, 1)) {
        pmem_warn("Failed assert: 0x000000794db000 = 1");
        return -61534;
    }

    if (!assert_rangemap_test(r, 0x000000794dcfff, 1)) {
        pmem_warn("Failed assert: 0x000000794dcfff = 1");
        return -3934;
    }

    if (!assert_rangemap_test(r, 0x000000794dd000, 1)) {
        pmem_warn("Failed assert: 0x000000794dd000 = 1");
        return -61535;
    }

    if (!assert_rangemap_test(r, 0x0000007950efff, 1)) {
        pmem_warn("Failed assert: 0x0000007950efff = 1");
        return -3935;
    }

    if (!assert_rangemap_test(r, 0x0000007950f000, 1)) {
        pmem_warn("Failed assert: 0x0000007950f000 = 1");
        return -61536;
    }

    if (!assert_rangemap_test(r, 0x00000079517fff, 1)) {
        pmem_warn("Failed assert: 0x00000079517fff = 1");
        return -3936;
    }

    if (!assert_rangemap_test(r, 0x00000079518000, 1)) {
        pmem_warn("Failed assert: 0x00000079518000 = 1");
        return -61537;
    }

    if (!assert_rangemap_test(r, 0x0000007951cfff, 1)) {
        pmem_warn("Failed assert: 0x0000007951cfff = 1");
        return -3937;
    }

    if (!assert_rangemap_test(r, 0x0000007951d000, 1)) {
        pmem_warn("Failed assert: 0x0000007951d000 = 1");
        return -61538;
    }

    if (!assert_rangemap_test(r, 0x0000007951ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007951ffff = 1");
        return -3938;
    }

    if (!assert_rangemap_test(r, 0x00000079520000, 1)) {
        pmem_warn("Failed assert: 0x00000079520000 = 1");
        return -61539;
    }

    if (!assert_rangemap_test(r, 0x00000079533fff, 1)) {
        pmem_warn("Failed assert: 0x00000079533fff = 1");
        return -3939;
    }

    if (!assert_rangemap_test(r, 0x00000079534000, 1)) {
        pmem_warn("Failed assert: 0x00000079534000 = 1");
        return -61540;
    }

    if (!assert_rangemap_test(r, 0x0000007956efff, 1)) {
        pmem_warn("Failed assert: 0x0000007956efff = 1");
        return -3940;
    }

    if (!assert_rangemap_test(r, 0x0000007956f000, 1)) {
        pmem_warn("Failed assert: 0x0000007956f000 = 1");
        return -61541;
    }

    if (!assert_rangemap_test(r, 0x00000079592fff, 1)) {
        pmem_warn("Failed assert: 0x00000079592fff = 1");
        return -3941;
    }

    if (!assert_rangemap_test(r, 0x00000079593000, 1)) {
        pmem_warn("Failed assert: 0x00000079593000 = 1");
        return -61542;
    }

    if (!assert_rangemap_test(r, 0x000000795a4fff, 1)) {
        pmem_warn("Failed assert: 0x000000795a4fff = 1");
        return -3942;
    }

    if (!assert_rangemap_test(r, 0x000000795a5000, 1)) {
        pmem_warn("Failed assert: 0x000000795a5000 = 1");
        return -61543;
    }

    if (!assert_rangemap_test(r, 0x000000795befff, 1)) {
        pmem_warn("Failed assert: 0x000000795befff = 1");
        return -3943;
    }

    if (!assert_rangemap_test(r, 0x000000795bf000, 1)) {
        pmem_warn("Failed assert: 0x000000795bf000 = 1");
        return -61544;
    }

    if (!assert_rangemap_test(r, 0x000000795c8fff, 1)) {
        pmem_warn("Failed assert: 0x000000795c8fff = 1");
        return -3944;
    }

    if (!assert_rangemap_test(r, 0x000000795c9000, 1)) {
        pmem_warn("Failed assert: 0x000000795c9000 = 1");
        return -61545;
    }

    if (!assert_rangemap_test(r, 0x000000795cafff, 1)) {
        pmem_warn("Failed assert: 0x000000795cafff = 1");
        return -3945;
    }

    if (!assert_rangemap_test(r, 0x000000795cb000, 1)) {
        pmem_warn("Failed assert: 0x000000795cb000 = 1");
        return -61546;
    }

    if (!assert_rangemap_test(r, 0x000000795e6fff, 1)) {
        pmem_warn("Failed assert: 0x000000795e6fff = 1");
        return -3946;
    }

    if (!assert_rangemap_test(r, 0x000000795e7000, 1)) {
        pmem_warn("Failed assert: 0x000000795e7000 = 1");
        return -61547;
    }

    if (!assert_rangemap_test(r, 0x000000795e9fff, 1)) {
        pmem_warn("Failed assert: 0x000000795e9fff = 1");
        return -3947;
    }

    if (!assert_rangemap_test(r, 0x000000795ea000, 1)) {
        pmem_warn("Failed assert: 0x000000795ea000 = 1");
        return -61548;
    }

    if (!assert_rangemap_test(r, 0x000000795ebfff, 1)) {
        pmem_warn("Failed assert: 0x000000795ebfff = 1");
        return -3948;
    }

    if (!assert_rangemap_test(r, 0x000000795ec000, 1)) {
        pmem_warn("Failed assert: 0x000000795ec000 = 1");
        return -61549;
    }

    if (!assert_rangemap_test(r, 0x000000795eefff, 1)) {
        pmem_warn("Failed assert: 0x000000795eefff = 1");
        return -3949;
    }

    if (!assert_rangemap_test(r, 0x000000795ef000, 1)) {
        pmem_warn("Failed assert: 0x000000795ef000 = 1");
        return -61550;
    }

    if (!assert_rangemap_test(r, 0x000000795f1fff, 1)) {
        pmem_warn("Failed assert: 0x000000795f1fff = 1");
        return -3950;
    }

    if (!assert_rangemap_test(r, 0x000000795f2000, 1)) {
        pmem_warn("Failed assert: 0x000000795f2000 = 1");
        return -61551;
    }

    if (!assert_rangemap_test(r, 0x000000795f3fff, 1)) {
        pmem_warn("Failed assert: 0x000000795f3fff = 1");
        return -3951;
    }

    if (!assert_rangemap_test(r, 0x000000795f4000, 1)) {
        pmem_warn("Failed assert: 0x000000795f4000 = 1");
        return -61552;
    }

    if (!assert_rangemap_test(r, 0x000000795fffff, 1)) {
        pmem_warn("Failed assert: 0x000000795fffff = 1");
        return -3952;
    }

    if (!assert_rangemap_test(r, 0x00000079600000, 1)) {
        pmem_warn("Failed assert: 0x00000079600000 = 1");
        return -61553;
    }

    if (!assert_rangemap_test(r, 0x00000079603fff, 1)) {
        pmem_warn("Failed assert: 0x00000079603fff = 1");
        return -3953;
    }

    if (!assert_rangemap_test(r, 0x00000079604000, 1)) {
        pmem_warn("Failed assert: 0x00000079604000 = 1");
        return -61554;
    }

    if (!assert_rangemap_test(r, 0x00000079604fff, 1)) {
        pmem_warn("Failed assert: 0x00000079604fff = 1");
        return -3954;
    }

    if (!assert_rangemap_test(r, 0x00000079605000, 1)) {
        pmem_warn("Failed assert: 0x00000079605000 = 1");
        return -61555;
    }

    if (!assert_rangemap_test(r, 0x00000079607fff, 1)) {
        pmem_warn("Failed assert: 0x00000079607fff = 1");
        return -3955;
    }

    if (!assert_rangemap_test(r, 0x00000079608000, 1)) {
        pmem_warn("Failed assert: 0x00000079608000 = 1");
        return -61556;
    }

    if (!assert_rangemap_test(r, 0x00000079608fff, 1)) {
        pmem_warn("Failed assert: 0x00000079608fff = 1");
        return -3956;
    }

    if (!assert_rangemap_test(r, 0x00000079609000, 1)) {
        pmem_warn("Failed assert: 0x00000079609000 = 1");
        return -61557;
    }

    if (!assert_rangemap_test(r, 0x00000079609fff, 1)) {
        pmem_warn("Failed assert: 0x00000079609fff = 1");
        return -3957;
    }

    if (!assert_rangemap_test(r, 0x0000007960a000, 1)) {
        pmem_warn("Failed assert: 0x0000007960a000 = 1");
        return -61558;
    }

    if (!assert_rangemap_test(r, 0x0000007960afff, 1)) {
        pmem_warn("Failed assert: 0x0000007960afff = 1");
        return -3958;
    }

    if (!assert_rangemap_test(r, 0x0000007960b000, 1)) {
        pmem_warn("Failed assert: 0x0000007960b000 = 1");
        return -61559;
    }

    if (!assert_rangemap_test(r, 0x0000007960cfff, 1)) {
        pmem_warn("Failed assert: 0x0000007960cfff = 1");
        return -3959;
    }

    if (!assert_rangemap_test(r, 0x0000007960d000, 1)) {
        pmem_warn("Failed assert: 0x0000007960d000 = 1");
        return -61560;
    }

    if (!assert_rangemap_test(r, 0x0000007960efff, 1)) {
        pmem_warn("Failed assert: 0x0000007960efff = 1");
        return -3960;
    }

    if (!assert_rangemap_test(r, 0x0000007960f000, 1)) {
        pmem_warn("Failed assert: 0x0000007960f000 = 1");
        return -61561;
    }

    if (!assert_rangemap_test(r, 0x0000007960ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007960ffff = 1");
        return -3961;
    }

    if (!assert_rangemap_test(r, 0x00000079610000, 1)) {
        pmem_warn("Failed assert: 0x00000079610000 = 1");
        return -61562;
    }

    if (!assert_rangemap_test(r, 0x00000079610fff, 1)) {
        pmem_warn("Failed assert: 0x00000079610fff = 1");
        return -3962;
    }

    if (!assert_rangemap_test(r, 0x00000079611000, 1)) {
        pmem_warn("Failed assert: 0x00000079611000 = 1");
        return -61563;
    }

    if (!assert_rangemap_test(r, 0x00000079613fff, 1)) {
        pmem_warn("Failed assert: 0x00000079613fff = 1");
        return -3963;
    }

    if (!assert_rangemap_test(r, 0x00000079614000, 1)) {
        pmem_warn("Failed assert: 0x00000079614000 = 1");
        return -61564;
    }

    if (!assert_rangemap_test(r, 0x0000007961dfff, 1)) {
        pmem_warn("Failed assert: 0x0000007961dfff = 1");
        return -3964;
    }

    if (!assert_rangemap_test(r, 0x0000007961e000, 1)) {
        pmem_warn("Failed assert: 0x0000007961e000 = 1");
        return -61565;
    }

    if (!assert_rangemap_test(r, 0x00000079620fff, 1)) {
        pmem_warn("Failed assert: 0x00000079620fff = 1");
        return -3965;
    }

    if (!assert_rangemap_test(r, 0x00000079621000, 1)) {
        pmem_warn("Failed assert: 0x00000079621000 = 1");
        return -61566;
    }

    if (!assert_rangemap_test(r, 0x00000079622fff, 1)) {
        pmem_warn("Failed assert: 0x00000079622fff = 1");
        return -3966;
    }

    if (!assert_rangemap_test(r, 0x00000079623000, 1)) {
        pmem_warn("Failed assert: 0x00000079623000 = 1");
        return -61567;
    }

    if (!assert_rangemap_test(r, 0x00000079624fff, 1)) {
        pmem_warn("Failed assert: 0x00000079624fff = 1");
        return -3967;
    }

    if (!assert_rangemap_test(r, 0x00000079625000, 1)) {
        pmem_warn("Failed assert: 0x00000079625000 = 1");
        return -61568;
    }

    if (!assert_rangemap_test(r, 0x0000007962efff, 1)) {
        pmem_warn("Failed assert: 0x0000007962efff = 1");
        return -3968;
    }

    if (!assert_rangemap_test(r, 0x0000007962f000, 1)) {
        pmem_warn("Failed assert: 0x0000007962f000 = 1");
        return -61569;
    }

    if (!assert_rangemap_test(r, 0x0000007962ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007962ffff = 1");
        return -3969;
    }

    if (!assert_rangemap_test(r, 0x00000079630000, 1)) {
        pmem_warn("Failed assert: 0x00000079630000 = 1");
        return -61570;
    }

    if (!assert_rangemap_test(r, 0x00000079635fff, 1)) {
        pmem_warn("Failed assert: 0x00000079635fff = 1");
        return -3970;
    }

    if (!assert_rangemap_test(r, 0x00000079636000, 1)) {
        pmem_warn("Failed assert: 0x00000079636000 = 1");
        return -61571;
    }

    if (!assert_rangemap_test(r, 0x00000079640fff, 1)) {
        pmem_warn("Failed assert: 0x00000079640fff = 1");
        return -3971;
    }

    if (!assert_rangemap_test(r, 0x00000079641000, 1)) {
        pmem_warn("Failed assert: 0x00000079641000 = 1");
        return -61572;
    }

    if (!assert_rangemap_test(r, 0x00000079645fff, 1)) {
        pmem_warn("Failed assert: 0x00000079645fff = 1");
        return -3972;
    }

    if (!assert_rangemap_test(r, 0x00000079646000, 1)) {
        pmem_warn("Failed assert: 0x00000079646000 = 1");
        return -61573;
    }

    if (!assert_rangemap_test(r, 0x0000007964bfff, 1)) {
        pmem_warn("Failed assert: 0x0000007964bfff = 1");
        return -3973;
    }

    if (!assert_rangemap_test(r, 0x0000007964c000, 1)) {
        pmem_warn("Failed assert: 0x0000007964c000 = 1");
        return -61574;
    }

    if (!assert_rangemap_test(r, 0x00000079665fff, 1)) {
        pmem_warn("Failed assert: 0x00000079665fff = 1");
        return -3974;
    }

    if (!assert_rangemap_test(r, 0x00000079666000, 1)) {
        pmem_warn("Failed assert: 0x00000079666000 = 1");
        return -61575;
    }

    if (!assert_rangemap_test(r, 0x00000079668fff, 1)) {
        pmem_warn("Failed assert: 0x00000079668fff = 1");
        return -3975;
    }

    if (!assert_rangemap_test(r, 0x00000079669000, 1)) {
        pmem_warn("Failed assert: 0x00000079669000 = 1");
        return -61576;
    }

    if (!assert_rangemap_test(r, 0x00000079678fff, 1)) {
        pmem_warn("Failed assert: 0x00000079678fff = 1");
        return -3976;
    }

    if (!assert_rangemap_test(r, 0x00000079679000, 1)) {
        pmem_warn("Failed assert: 0x00000079679000 = 1");
        return -61577;
    }

    if (!assert_rangemap_test(r, 0x0000007967dfff, 1)) {
        pmem_warn("Failed assert: 0x0000007967dfff = 1");
        return -3977;
    }

    if (!assert_rangemap_test(r, 0x0000007967e000, 1)) {
        pmem_warn("Failed assert: 0x0000007967e000 = 1");
        return -61578;
    }

    if (!assert_rangemap_test(r, 0x00000079690fff, 1)) {
        pmem_warn("Failed assert: 0x00000079690fff = 1");
        return -3978;
    }

    if (!assert_rangemap_test(r, 0x00000079691000, 1)) {
        pmem_warn("Failed assert: 0x00000079691000 = 1");
        return -61579;
    }

    if (!assert_rangemap_test(r, 0x00000079691fff, 1)) {
        pmem_warn("Failed assert: 0x00000079691fff = 1");
        return -3979;
    }

    if (!assert_rangemap_test(r, 0x00000079692000, 1)) {
        pmem_warn("Failed assert: 0x00000079692000 = 1");
        return -61580;
    }

    if (!assert_rangemap_test(r, 0x00000079695fff, 1)) {
        pmem_warn("Failed assert: 0x00000079695fff = 1");
        return -3980;
    }

    if (!assert_rangemap_test(r, 0x00000079696000, 1)) {
        pmem_warn("Failed assert: 0x00000079696000 = 1");
        return -61581;
    }

    if (!assert_rangemap_test(r, 0x00000079699fff, 1)) {
        pmem_warn("Failed assert: 0x00000079699fff = 1");
        return -3981;
    }

    if (!assert_rangemap_test(r, 0x0000007969a000, 1)) {
        pmem_warn("Failed assert: 0x0000007969a000 = 1");
        return -61582;
    }

    if (!assert_rangemap_test(r, 0x0000007969dfff, 1)) {
        pmem_warn("Failed assert: 0x0000007969dfff = 1");
        return -3982;
    }

    if (!assert_rangemap_test(r, 0x0000007969e000, 1)) {
        pmem_warn("Failed assert: 0x0000007969e000 = 1");
        return -61583;
    }

    if (!assert_rangemap_test(r, 0x000000796a5fff, 1)) {
        pmem_warn("Failed assert: 0x000000796a5fff = 1");
        return -3983;
    }

    if (!assert_rangemap_test(r, 0x000000796a6000, 1)) {
        pmem_warn("Failed assert: 0x000000796a6000 = 1");
        return -61584;
    }

    if (!assert_rangemap_test(r, 0x000000796a6fff, 1)) {
        pmem_warn("Failed assert: 0x000000796a6fff = 1");
        return -3984;
    }

    if (!assert_rangemap_test(r, 0x000000796a7000, 1)) {
        pmem_warn("Failed assert: 0x000000796a7000 = 1");
        return -61585;
    }

    if (!assert_rangemap_test(r, 0x000000796a7fff, 1)) {
        pmem_warn("Failed assert: 0x000000796a7fff = 1");
        return -3985;
    }

    if (!assert_rangemap_test(r, 0x000000796a8000, 1)) {
        pmem_warn("Failed assert: 0x000000796a8000 = 1");
        return -61586;
    }

    if (!assert_rangemap_test(r, 0x000000796bdfff, 1)) {
        pmem_warn("Failed assert: 0x000000796bdfff = 1");
        return -3986;
    }

    if (!assert_rangemap_test(r, 0x000000796be000, 1)) {
        pmem_warn("Failed assert: 0x000000796be000 = 1");
        return -61587;
    }

    if (!assert_rangemap_test(r, 0x000000796c2fff, 1)) {
        pmem_warn("Failed assert: 0x000000796c2fff = 1");
        return -3987;
    }

    if (!assert_rangemap_test(r, 0x000000796c3000, 1)) {
        pmem_warn("Failed assert: 0x000000796c3000 = 1");
        return -61588;
    }

    if (!assert_rangemap_test(r, 0x000000796c4fff, 1)) {
        pmem_warn("Failed assert: 0x000000796c4fff = 1");
        return -3988;
    }

    if (!assert_rangemap_test(r, 0x000000796c5000, 1)) {
        pmem_warn("Failed assert: 0x000000796c5000 = 1");
        return -61589;
    }

    if (!assert_rangemap_test(r, 0x000000796c9fff, 1)) {
        pmem_warn("Failed assert: 0x000000796c9fff = 1");
        return -3989;
    }

    if (!assert_rangemap_test(r, 0x000000796ca000, 1)) {
        pmem_warn("Failed assert: 0x000000796ca000 = 1");
        return -61590;
    }

    if (!assert_rangemap_test(r, 0x000000796cafff, 1)) {
        pmem_warn("Failed assert: 0x000000796cafff = 1");
        return -3990;
    }

    if (!assert_rangemap_test(r, 0x000000796cb000, 1)) {
        pmem_warn("Failed assert: 0x000000796cb000 = 1");
        return -61591;
    }

    if (!assert_rangemap_test(r, 0x000000796cbfff, 1)) {
        pmem_warn("Failed assert: 0x000000796cbfff = 1");
        return -3991;
    }

    if (!assert_rangemap_test(r, 0x000000796cc000, 1)) {
        pmem_warn("Failed assert: 0x000000796cc000 = 1");
        return -61592;
    }

    if (!assert_rangemap_test(r, 0x000000796ebfff, 1)) {
        pmem_warn("Failed assert: 0x000000796ebfff = 1");
        return -3992;
    }

    if (!assert_rangemap_test(r, 0x000000796ec000, 1)) {
        pmem_warn("Failed assert: 0x000000796ec000 = 1");
        return -61593;
    }

    if (!assert_rangemap_test(r, 0x000000796edfff, 1)) {
        pmem_warn("Failed assert: 0x000000796edfff = 1");
        return -3993;
    }

    if (!assert_rangemap_test(r, 0x000000796ee000, 1)) {
        pmem_warn("Failed assert: 0x000000796ee000 = 1");
        return -61594;
    }

    if (!assert_rangemap_test(r, 0x000000796f4fff, 1)) {
        pmem_warn("Failed assert: 0x000000796f4fff = 1");
        return -3994;
    }

    if (!assert_rangemap_test(r, 0x000000796f5000, 1)) {
        pmem_warn("Failed assert: 0x000000796f5000 = 1");
        return -61595;
    }

    if (!assert_rangemap_test(r, 0x000000796f8fff, 1)) {
        pmem_warn("Failed assert: 0x000000796f8fff = 1");
        return -3995;
    }

    if (!assert_rangemap_test(r, 0x000000796f9000, 1)) {
        pmem_warn("Failed assert: 0x000000796f9000 = 1");
        return -61596;
    }

    if (!assert_rangemap_test(r, 0x000000796fbfff, 1)) {
        pmem_warn("Failed assert: 0x000000796fbfff = 1");
        return -3996;
    }

    if (!assert_rangemap_test(r, 0x000000796fc000, 1)) {
        pmem_warn("Failed assert: 0x000000796fc000 = 1");
        return -61597;
    }

    if (!assert_rangemap_test(r, 0x000000796fcfff, 1)) {
        pmem_warn("Failed assert: 0x000000796fcfff = 1");
        return -3997;
    }

    if (!assert_rangemap_test(r, 0x000000796fd000, 1)) {
        pmem_warn("Failed assert: 0x000000796fd000 = 1");
        return -61598;
    }

    if (!assert_rangemap_test(r, 0x000000796fffff, 1)) {
        pmem_warn("Failed assert: 0x000000796fffff = 1");
        return -3998;
    }

    if (!assert_rangemap_test(r, 0x00000079700000, 1)) {
        pmem_warn("Failed assert: 0x00000079700000 = 1");
        return -61599;
    }

    if (!assert_rangemap_test(r, 0x00000079700fff, 1)) {
        pmem_warn("Failed assert: 0x00000079700fff = 1");
        return -3999;
    }

    if (!assert_rangemap_test(r, 0x00000079701000, 1)) {
        pmem_warn("Failed assert: 0x00000079701000 = 1");
        return -61600;
    }

    if (!assert_rangemap_test(r, 0x00000079706fff, 1)) {
        pmem_warn("Failed assert: 0x00000079706fff = 1");
        return -4000;
    }

    if (!assert_rangemap_test(r, 0x00000079707000, 1)) {
        pmem_warn("Failed assert: 0x00000079707000 = 1");
        return -61601;
    }

    if (!assert_rangemap_test(r, 0x00000079708fff, 1)) {
        pmem_warn("Failed assert: 0x00000079708fff = 1");
        return -4001;
    }

    if (!assert_rangemap_test(r, 0x00000079709000, 1)) {
        pmem_warn("Failed assert: 0x00000079709000 = 1");
        return -61602;
    }

    if (!assert_rangemap_test(r, 0x00000079709fff, 1)) {
        pmem_warn("Failed assert: 0x00000079709fff = 1");
        return -4002;
    }

    if (!assert_rangemap_test(r, 0x0000007970a000, 1)) {
        pmem_warn("Failed assert: 0x0000007970a000 = 1");
        return -61603;
    }

    if (!assert_rangemap_test(r, 0x0000007970bfff, 1)) {
        pmem_warn("Failed assert: 0x0000007970bfff = 1");
        return -4003;
    }

    if (!assert_rangemap_test(r, 0x0000007970c000, 1)) {
        pmem_warn("Failed assert: 0x0000007970c000 = 1");
        return -61604;
    }

    if (!assert_rangemap_test(r, 0x0000007970cfff, 1)) {
        pmem_warn("Failed assert: 0x0000007970cfff = 1");
        return -4004;
    }

    if (!assert_rangemap_test(r, 0x0000007970d000, 1)) {
        pmem_warn("Failed assert: 0x0000007970d000 = 1");
        return -61605;
    }

    if (!assert_rangemap_test(r, 0x00000079712fff, 1)) {
        pmem_warn("Failed assert: 0x00000079712fff = 1");
        return -4005;
    }

    if (!assert_rangemap_test(r, 0x00000079713000, 1)) {
        pmem_warn("Failed assert: 0x00000079713000 = 1");
        return -61606;
    }

    if (!assert_rangemap_test(r, 0x00000079713fff, 1)) {
        pmem_warn("Failed assert: 0x00000079713fff = 1");
        return -4006;
    }

    if (!assert_rangemap_test(r, 0x00000079714000, 1)) {
        pmem_warn("Failed assert: 0x00000079714000 = 1");
        return -61607;
    }

    if (!assert_rangemap_test(r, 0x00000079714fff, 1)) {
        pmem_warn("Failed assert: 0x00000079714fff = 1");
        return -4007;
    }

    if (!assert_rangemap_test(r, 0x00000079715000, 1)) {
        pmem_warn("Failed assert: 0x00000079715000 = 1");
        return -61608;
    }

    if (!assert_rangemap_test(r, 0x00000079716fff, 1)) {
        pmem_warn("Failed assert: 0x00000079716fff = 1");
        return -4008;
    }

    if (!assert_rangemap_test(r, 0x00000079717000, 1)) {
        pmem_warn("Failed assert: 0x00000079717000 = 1");
        return -61609;
    }

    if (!assert_rangemap_test(r, 0x00000079719fff, 1)) {
        pmem_warn("Failed assert: 0x00000079719fff = 1");
        return -4009;
    }

    if (!assert_rangemap_test(r, 0x0000007971a000, 1)) {
        pmem_warn("Failed assert: 0x0000007971a000 = 1");
        return -61610;
    }

    if (!assert_rangemap_test(r, 0x0000007971afff, 1)) {
        pmem_warn("Failed assert: 0x0000007971afff = 1");
        return -4010;
    }

    if (!assert_rangemap_test(r, 0x0000007971b000, 1)) {
        pmem_warn("Failed assert: 0x0000007971b000 = 1");
        return -61611;
    }

    if (!assert_rangemap_test(r, 0x0000007971cfff, 1)) {
        pmem_warn("Failed assert: 0x0000007971cfff = 1");
        return -4011;
    }

    if (!assert_rangemap_test(r, 0x0000007971d000, 1)) {
        pmem_warn("Failed assert: 0x0000007971d000 = 1");
        return -61612;
    }

    if (!assert_rangemap_test(r, 0x0000007971efff, 1)) {
        pmem_warn("Failed assert: 0x0000007971efff = 1");
        return -4012;
    }

    if (!assert_rangemap_test(r, 0x0000007971f000, 1)) {
        pmem_warn("Failed assert: 0x0000007971f000 = 1");
        return -61613;
    }

    if (!assert_rangemap_test(r, 0x0000007971ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007971ffff = 1");
        return -4013;
    }

    if (!assert_rangemap_test(r, 0x00000079720000, 1)) {
        pmem_warn("Failed assert: 0x00000079720000 = 1");
        return -61614;
    }

    if (!assert_rangemap_test(r, 0x00000079722fff, 1)) {
        pmem_warn("Failed assert: 0x00000079722fff = 1");
        return -4014;
    }

    if (!assert_rangemap_test(r, 0x00000079723000, 1)) {
        pmem_warn("Failed assert: 0x00000079723000 = 1");
        return -61615;
    }

    if (!assert_rangemap_test(r, 0x0000007972afff, 1)) {
        pmem_warn("Failed assert: 0x0000007972afff = 1");
        return -4015;
    }

    if (!assert_rangemap_test(r, 0x0000007972b000, 1)) {
        pmem_warn("Failed assert: 0x0000007972b000 = 1");
        return -61616;
    }

    if (!assert_rangemap_test(r, 0x0000007972cfff, 1)) {
        pmem_warn("Failed assert: 0x0000007972cfff = 1");
        return -4016;
    }

    if (!assert_rangemap_test(r, 0x0000007972d000, 1)) {
        pmem_warn("Failed assert: 0x0000007972d000 = 1");
        return -61617;
    }

    if (!assert_rangemap_test(r, 0x0000007972ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007972ffff = 1");
        return -4017;
    }

    if (!assert_rangemap_test(r, 0x00000079730000, 1)) {
        pmem_warn("Failed assert: 0x00000079730000 = 1");
        return -61618;
    }

    if (!assert_rangemap_test(r, 0x00000079733fff, 1)) {
        pmem_warn("Failed assert: 0x00000079733fff = 1");
        return -4018;
    }

    if (!assert_rangemap_test(r, 0x00000079734000, 1)) {
        pmem_warn("Failed assert: 0x00000079734000 = 1");
        return -61619;
    }

    if (!assert_rangemap_test(r, 0x00000079738fff, 1)) {
        pmem_warn("Failed assert: 0x00000079738fff = 1");
        return -4019;
    }

    if (!assert_rangemap_test(r, 0x00000079739000, 1)) {
        pmem_warn("Failed assert: 0x00000079739000 = 1");
        return -61620;
    }

    if (!assert_rangemap_test(r, 0x00000079739fff, 1)) {
        pmem_warn("Failed assert: 0x00000079739fff = 1");
        return -4020;
    }

    if (!assert_rangemap_test(r, 0x0000007973a000, 1)) {
        pmem_warn("Failed assert: 0x0000007973a000 = 1");
        return -61621;
    }

    if (!assert_rangemap_test(r, 0x0000007973ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007973ffff = 1");
        return -4021;
    }

    if (!assert_rangemap_test(r, 0x00000079740000, 1)) {
        pmem_warn("Failed assert: 0x00000079740000 = 1");
        return -61622;
    }

    if (!assert_rangemap_test(r, 0x00000079741fff, 1)) {
        pmem_warn("Failed assert: 0x00000079741fff = 1");
        return -4022;
    }

    if (!assert_rangemap_test(r, 0x00000079742000, 1)) {
        pmem_warn("Failed assert: 0x00000079742000 = 1");
        return -61623;
    }

    if (!assert_rangemap_test(r, 0x00000079744fff, 1)) {
        pmem_warn("Failed assert: 0x00000079744fff = 1");
        return -4023;
    }

    if (!assert_rangemap_test(r, 0x00000079745000, 1)) {
        pmem_warn("Failed assert: 0x00000079745000 = 1");
        return -61624;
    }

    if (!assert_rangemap_test(r, 0x00000079745fff, 1)) {
        pmem_warn("Failed assert: 0x00000079745fff = 1");
        return -4024;
    }
    
    if (!assert_rangemap_test(r, 0x00000079746000, 1)) {
        pmem_warn("Failed assert: 0x00000079746000 = 1");
        return -61625;
    }
    
    if (!assert_rangemap_test(r, 0x0000007974afff, 1)) {
        pmem_warn("Failed assert: 0x0000007974afff = 1");
        return -4025;
    }
    
    if (!assert_rangemap_test(r, 0x0000007974b000, 1)) {
        pmem_warn("Failed assert: 0x0000007974b000 = 1");
        return -61626;
    }
    
    if (!assert_rangemap_test(r, 0x0000007974cfff, 1)) {
        pmem_warn("Failed assert: 0x0000007974cfff = 1");
        return -4026;
    }
    
    if (!assert_rangemap_test(r, 0x0000007974d000, 1)) {
        pmem_warn("Failed assert: 0x0000007974d000 = 1");
        return -61627;
    }
    
    if (!assert_rangemap_test(r, 0x0000007975ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007975ffff = 1");
        return -4027;
    }
    
    if (!assert_rangemap_test(r, 0x00000079760000, 1)) {
        pmem_warn("Failed assert: 0x00000079760000 = 1");
        return -61628;
    }
    
    if (!assert_rangemap_test(r, 0x0000007976dfff, 1)) {
        pmem_warn("Failed assert: 0x0000007976dfff = 1");
        return -4028;
    }
    
    if (!assert_rangemap_test(r, 0x0000007976e000, 1)) {
        pmem_warn("Failed assert: 0x0000007976e000 = 1");
        return -61629;
    }
    
    if (!assert_rangemap_test(r, 0x00000079782fff, 1)) {
        pmem_warn("Failed assert: 0x00000079782fff = 1");
        return -4029;
    }
    
    if (!assert_rangemap_test(r, 0x00000079783000, 1)) {
        pmem_warn("Failed assert: 0x00000079783000 = 1");
        return -61630;
    }
    
    if (!assert_rangemap_test(r, 0x00000079785fff, 1)) {
        pmem_warn("Failed assert: 0x00000079785fff = 1");
        return -4030;
    }
    
    if (!assert_rangemap_test(r, 0x00000079786000, 1)) {
        pmem_warn("Failed assert: 0x00000079786000 = 1");
        return -61631;
    }
    
    if (!assert_rangemap_test(r, 0x000000797b8fff, 1)) {
        pmem_warn("Failed assert: 0x000000797b8fff = 1");
        return -4031;
    }
    
    if (!assert_rangemap_test(r, 0x000000797b9000, 1)) {
        pmem_warn("Failed assert: 0x000000797b9000 = 1");
        return -61632;
    }
    
    if (!assert_rangemap_test(r, 0x000000797cafff, 1)) {
        pmem_warn("Failed assert: 0x000000797cafff = 1");
        return -4032;
    }
    
    if (!assert_rangemap_test(r, 0x000000797cb000, 1)) {
        pmem_warn("Failed assert: 0x000000797cb000 = 1");
        return -61633;
    }
    
    if (!assert_rangemap_test(r, 0x000000797cbfff, 1)) {
        pmem_warn("Failed assert: 0x000000797cbfff = 1");
        return -4033;
    }
    
    if (!assert_rangemap_test(r, 0x000000797cc000, 1)) {
        pmem_warn("Failed assert: 0x000000797cc000 = 1");
        return -61634;
    }
    
    if (!assert_rangemap_test(r, 0x000000797cffff, 1)) {
        pmem_warn("Failed assert: 0x000000797cffff = 1");
        return -4034;
    }
    
    if (!assert_rangemap_test(r, 0x000000797d0000, 1)) {
        pmem_warn("Failed assert: 0x000000797d0000 = 1");
        return -61635;
    }
    
    if (!assert_rangemap_test(r, 0x000000797dcfff, 1)) {
        pmem_warn("Failed assert: 0x000000797dcfff = 1");
        return -4035;
    }
    
    if (!assert_rangemap_test(r, 0x000000797dd000, 1)) {
        pmem_warn("Failed assert: 0x000000797dd000 = 1");
        return -61636;
    }
    
    if (!assert_rangemap_test(r, 0x000000797e2fff, 1)) {
        pmem_warn("Failed assert: 0x000000797e2fff = 1");
        return -4036;
    }
    
    if (!assert_rangemap_test(r, 0x000000797e3000, 1)) {
        pmem_warn("Failed assert: 0x000000797e3000 = 1");
        return -61637;
    }
    
    if (!assert_rangemap_test(r, 0x000000797f4fff, 1)) {
        pmem_warn("Failed assert: 0x000000797f4fff = 1");
        return -4037;
    }
    
    if (!assert_rangemap_test(r, 0x000000797f5000, 1)) {
        pmem_warn("Failed assert: 0x000000797f5000 = 1");
        return -61638;
    }
    
    if (!assert_rangemap_test(r, 0x000000797f6fff, 1)) {
        pmem_warn("Failed assert: 0x000000797f6fff = 1");
        return -4038;
    }
    
    if (!assert_rangemap_test(r, 0x000000797f7000, 1)) {
        pmem_warn("Failed assert: 0x000000797f7000 = 1");
        return -61639;
    }
    
    if (!assert_rangemap_test(r, 0x000000797fefff, 1)) {
        pmem_warn("Failed assert: 0x000000797fefff = 1");
        return -4039;
    }
    
    if (!assert_rangemap_test(r, 0x000000797ff000, 1)) {
        pmem_warn("Failed assert: 0x000000797ff000 = 1");
        return -61640;
    }
    
    if (!assert_rangemap_test(r, 0x00000079805fff, 1)) {
        pmem_warn("Failed assert: 0x00000079805fff = 1");
        return -4040;
    }
    
    if (!assert_rangemap_test(r, 0x00000079806000, 1)) {
        pmem_warn("Failed assert: 0x00000079806000 = 1");
        return -61641;
    }
    
    if (!assert_rangemap_test(r, 0x0000007980dfff, 1)) {
        pmem_warn("Failed assert: 0x0000007980dfff = 1");
        return -4041;
    }
    
    if (!assert_rangemap_test(r, 0x0000007980e000, 1)) {
        pmem_warn("Failed assert: 0x0000007980e000 = 1");
        return -61642;
    }
    
    if (!assert_rangemap_test(r, 0x0000007980efff, 1)) {
        pmem_warn("Failed assert: 0x0000007980efff = 1");
        return -4042;
    }
    
    if (!assert_rangemap_test(r, 0x0000007980f000, 1)) {
        pmem_warn("Failed assert: 0x0000007980f000 = 1");
        return -61643;
    }
    
    if (!assert_rangemap_test(r, 0x0000007980ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007980ffff = 1");
        return -4043;
    }
    
    if (!assert_rangemap_test(r, 0x00000079810000, 1)) {
        pmem_warn("Failed assert: 0x00000079810000 = 1");
        return -61644;
    }
    
    if (!assert_rangemap_test(r, 0x00000079810fff, 1)) {
        pmem_warn("Failed assert: 0x00000079810fff = 1");
        return -4044;
    }
    
    if (!assert_rangemap_test(r, 0x00000079811000, 1)) {
        pmem_warn("Failed assert: 0x00000079811000 = 1");
        return -61645;
    }
    
    if (!assert_rangemap_test(r, 0x00000079811fff, 1)) {
        pmem_warn("Failed assert: 0x00000079811fff = 1");
        return -4045;
    }
    
    if (!assert_rangemap_test(r, 0x00000079812000, 1)) {
        pmem_warn("Failed assert: 0x00000079812000 = 1");
        return -61646;
    }
    
    if (!assert_rangemap_test(r, 0x00000079812fff, 1)) {
        pmem_warn("Failed assert: 0x00000079812fff = 1");
        return -4046;
    }
    
    if (!assert_rangemap_test(r, 0x00000079813000, 1)) {
        pmem_warn("Failed assert: 0x00000079813000 = 1");
        return -61647;
    }
    
    if (!assert_rangemap_test(r, 0x00000079816fff, 1)) {
        pmem_warn("Failed assert: 0x00000079816fff = 1");
        return -4047;
    }
    
    if (!assert_rangemap_test(r, 0x00000079817000, 1)) {
        pmem_warn("Failed assert: 0x00000079817000 = 1");
        return -61648;
    }
    
    if (!assert_rangemap_test(r, 0x00000079817fff, 1)) {
        pmem_warn("Failed assert: 0x00000079817fff = 1");
        return -4048;
    }
    
    if (!assert_rangemap_test(r, 0x00000079818000, 1)) {
        pmem_warn("Failed assert: 0x00000079818000 = 1");
        return -61649;
    }
    
    if (!assert_rangemap_test(r, 0x0000007982efff, 1)) {
        pmem_warn("Failed assert: 0x0000007982efff = 1");
        return -4049;
    }
    
    if (!assert_rangemap_test(r, 0x0000007982f000, 1)) {
        pmem_warn("Failed assert: 0x0000007982f000 = 1");
        return -61650;
    }
    
    if (!assert_rangemap_test(r, 0x00000079837fff, 1)) {
        pmem_warn("Failed assert: 0x00000079837fff = 1");
        return -4050;
    }
    
    if (!assert_rangemap_test(r, 0x00000079838000, 1)) {
        pmem_warn("Failed assert: 0x00000079838000 = 1");
        return -61651;
    }
    
    if (!assert_rangemap_test(r, 0x0000007983bfff, 1)) {
        pmem_warn("Failed assert: 0x0000007983bfff = 1");
        return -4051;
    }
    
    if (!assert_rangemap_test(r, 0x0000007983c000, 1)) {
        pmem_warn("Failed assert: 0x0000007983c000 = 1");
        return -61652;
    }
    
    if (!assert_rangemap_test(r, 0x0000007984bfff, 1)) {
        pmem_warn("Failed assert: 0x0000007984bfff = 1");
        return -4052;
    }
    
    if (!assert_rangemap_test(r, 0x0000007984c000, 1)) {
        pmem_warn("Failed assert: 0x0000007984c000 = 1");
        return -61653;
    }
    
    if (!assert_rangemap_test(r, 0x00000079858fff, 1)) {
        pmem_warn("Failed assert: 0x00000079858fff = 1");
        return -4053;
    }
    
    if (!assert_rangemap_test(r, 0x00000079859000, 1)) {
        pmem_warn("Failed assert: 0x00000079859000 = 1");
        return -61654;
    }
    
    if (!assert_rangemap_test(r, 0x00000079859fff, 1)) {
        pmem_warn("Failed assert: 0x00000079859fff = 1");
        return -4054;
    }
    
    if (!assert_rangemap_test(r, 0x0000007985a000, 1)) {
        pmem_warn("Failed assert: 0x0000007985a000 = 1");
        return -61655;
    }
    
    if (!assert_rangemap_test(r, 0x0000007985afff, 1)) {
        pmem_warn("Failed assert: 0x0000007985afff = 1");
        return -4055;
    }
    
    if (!assert_rangemap_test(r, 0x0000007985b000, 1)) {
        pmem_warn("Failed assert: 0x0000007985b000 = 1");
        return -61656;
    }
    
    if (!assert_rangemap_test(r, 0x0000007985bfff, 1)) {
        pmem_warn("Failed assert: 0x0000007985bfff = 1");
        return -4056;
    }
    
    if (!assert_rangemap_test(r, 0x0000007985c000, 1)) {
        pmem_warn("Failed assert: 0x0000007985c000 = 1");
        return -61657;
    }
    
    if (!assert_rangemap_test(r, 0x0000007985ffff, 1)) {
        pmem_warn("Failed assert: 0x0000007985ffff = 1");
        return -4057;
    }
    
    if (!assert_rangemap_test(r, 0x00000079860000, 1)) {
        pmem_warn("Failed assert: 0x00000079860000 = 1");
        return -61658;
    }
    
    if (!assert_rangemap_test(r, 0x00000079860fff, 1)) {
        pmem_warn("Failed assert: 0x00000079860fff = 1");
        return -4058;
    }
    
    if (!assert_rangemap_test(r, 0x00000079861000, 1)) {
        pmem_warn("Failed assert: 0x00000079861000 = 1");
        return -61659;
    }
    
    if (!assert_rangemap_test(r, 0x00000079863fff, 1)) {
        pmem_warn("Failed assert: 0x00000079863fff = 1");
        return -4059;
    }
    
    if (!assert_rangemap_test(r, 0x00000079864000, 1)) {
        pmem_warn("Failed assert: 0x00000079864000 = 1");
        return -61660;
    }
    
    if (!assert_rangemap_test(r, 0x00000079865fff, 1)) {
        pmem_warn("Failed assert: 0x00000079865fff = 1");
        return -4060;
    }
    
    if (!assert_rangemap_test(r, 0x00000079866000, 1)) {
        pmem_warn("Failed assert: 0x00000079866000 = 1");
        return -61661;
    }
    
    if (!assert_rangemap_test(r, 0x00000079867fff, 1)) {
        pmem_warn("Failed assert: 0x00000079867fff = 1");
        return -4061;
    }
    
    if (!assert_rangemap_test(r, 0x00000079868000, 1)) {
        pmem_warn("Failed assert: 0x00000079868000 = 1");
        return -61662;
    }
    
    if (!assert_rangemap_test(r, 0x00000079869fff, 1)) {
        pmem_warn("Failed assert: 0x00000079869fff = 1");
        return -4062;
    }
    
    if (!assert_rangemap_test(r, 0x0000007986a000, 1)) {
        pmem_warn("Failed assert: 0x0000007986a000 = 1");
        return -61663;
    }
    
    if (!assert_rangemap_test(r, 0x00000079c8dfff, 1)) {
        pmem_warn("Failed assert: 0x00000079c8dfff = 1");
        return -4063;
    }
    
    if (!assert_rangemap_test(r, 0x00000079c8e000, 1)) {
        pmem_warn("Failed assert: 0x00000079c8e000 = 1");
        return -61664;
    }
    
    if (!assert_rangemap_test(r, 0x00000079c97fff, 1)) {
        pmem_warn("Failed assert: 0x00000079c97fff = 1");
        return -4064;
    }
    
    if (!assert_rangemap_test(r, 0x00000079c98000, 1)) {
        pmem_warn("Failed assert: 0x00000079c98000 = 1");
        return -61665;
    }
    
    if (!assert_rangemap_test(r, 0x00000079c9bfff, 1)) {
        pmem_warn("Failed assert: 0x00000079c9bfff = 1");
        return -4065;
    }
    
    if (!assert_rangemap_test(r, 0x00000079c9c000, 1)) {
        pmem_warn("Failed assert: 0x00000079c9c000 = 1");
        return -61666;
    }
    
    if (!assert_rangemap_test(r, 0x00000079c9dfff, 1)) {
        pmem_warn("Failed assert: 0x00000079c9dfff = 1");
        return -4066;
    }
    
    if (!assert_rangemap_test(r, 0x00000079c9e000, 1)) {
        pmem_warn("Failed assert: 0x00000079c9e000 = 1");
        return -61667;
    }
    
    if (!assert_rangemap_test(r, 0x00000079ca3fff, 1)) {
        pmem_warn("Failed assert: 0x00000079ca3fff = 1");
        return -4067;
    }
    
    if (!assert_rangemap_test(r, 0x00000079ca4000, 1)) {
        pmem_warn("Failed assert: 0x00000079ca4000 = 1");
        return -61668;
    }
    
    if (!assert_rangemap_test(r, 0x00000079ca4fff, 1)) {
        pmem_warn("Failed assert: 0x00000079ca4fff = 1");
        return -4068;
    }
    
    if (!assert_rangemap_test(r, 0x00000079ca5000, 1)) {
        pmem_warn("Failed assert: 0x00000079ca5000 = 1");
        return -61669;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d32fff, 1)) {
        pmem_warn("Failed assert: 0x00000079d32fff = 1");
        return -4069;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d33000, 1)) {
        pmem_warn("Failed assert: 0x00000079d33000 = 1");
        return -61670;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d33fff, 1)) {
        pmem_warn("Failed assert: 0x00000079d33fff = 1");
        return -4070;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d34000, 1)) {
        pmem_warn("Failed assert: 0x00000079d34000 = 1");
        return -61671;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d35fff, 1)) {
        pmem_warn("Failed assert: 0x00000079d35fff = 1");
        return -4071;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d36000, 1)) {
        pmem_warn("Failed assert: 0x00000079d36000 = 1");
        return -61672;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d37fff, 1)) {
        pmem_warn("Failed assert: 0x00000079d37fff = 1");
        return -4072;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d38000, 1)) {
        pmem_warn("Failed assert: 0x00000079d38000 = 1");
        return -61673;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d38fff, 1)) {
        pmem_warn("Failed assert: 0x00000079d38fff = 1");
        return -4073;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d39000, 1)) {
        pmem_warn("Failed assert: 0x00000079d39000 = 1");
        return -61674;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d3bfff, 1)) {
        pmem_warn("Failed assert: 0x00000079d3bfff = 1");
        return -4074;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d3c000, 1)) {
        pmem_warn("Failed assert: 0x00000079d3c000 = 1");
        return -61675;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d3efff, 1)) {
        pmem_warn("Failed assert: 0x00000079d3efff = 1");
        return -4075;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d3f000, 1)) {
        pmem_warn("Failed assert: 0x00000079d3f000 = 1");
        return -61676;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d3ffff, 1)) {
        pmem_warn("Failed assert: 0x00000079d3ffff = 1");
        return -4076;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d40000, 1)) {
        pmem_warn("Failed assert: 0x00000079d40000 = 1");
        return -61677;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d43fff, 1)) {
        pmem_warn("Failed assert: 0x00000079d43fff = 1");
        return -4077;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d44000, 1)) {
        pmem_warn("Failed assert: 0x00000079d44000 = 1");
        return -61678;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d44fff, 1)) {
        pmem_warn("Failed assert: 0x00000079d44fff = 1");
        return -4078;
    }
    
    if (!assert_rangemap_test(r, 0x00000079d45000, 1)) {
        pmem_warn("Failed assert: 0x00000079d45000 = 1");
        return -61679;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad02fff, 1)) {
        pmem_warn("Failed assert: 0x0000007ad02fff = 1");
        return -4079;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad03000, 1)) {
        pmem_warn("Failed assert: 0x0000007ad03000 = 1");
        return -61680;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad13fff, 1)) {
        pmem_warn("Failed assert: 0x0000007ad13fff = 1");
        return -4080;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad14000, 1)) {
        pmem_warn("Failed assert: 0x0000007ad14000 = 1");
        return -61681;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad52fff, 1)) {
        pmem_warn("Failed assert: 0x0000007ad52fff = 1");
        return -4081;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad53000, 1)) {
        pmem_warn("Failed assert: 0x0000007ad53000 = 1");
        return -61682;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad5efff, 1)) {
        pmem_warn("Failed assert: 0x0000007ad5efff = 1");
        return -4082;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad5f000, 1)) {
        pmem_warn("Failed assert: 0x0000007ad5f000 = 1");
        return -61683;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad8efff, 1)) {
        pmem_warn("Failed assert: 0x0000007ad8efff = 1");
        return -4083;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ad8f000, 1)) {
        pmem_warn("Failed assert: 0x0000007ad8f000 = 1");
        return -61684;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ae38fff, 1)) {
        pmem_warn("Failed assert: 0x0000007ae38fff = 1");
        return -4084;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ae39000, 1)) {
        pmem_warn("Failed assert: 0x0000007ae39000 = 1");
        return -61685;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ae8efff, 1)) {
        pmem_warn("Failed assert: 0x0000007ae8efff = 1");
        return -4085;
    }
    
    if (!assert_rangemap_test(r, 0x0000007ae8f000, 1)) {
        pmem_warn("Failed assert: 0x0000007ae8f000 = 1");
        return -61686;
    }
    
    if (!assert_rangemap_test(r, 0x0000007aecffff, 1)) {
        pmem_warn("Failed assert: 0x0000007aecffff = 1");
        return -4086;
    }
    
    if (!assert_rangemap_test(r, 0x0000007aed0000, 1)) {
        pmem_warn("Failed assert: 0x0000007aed0000 = 1");
        return -61687;
    }
    
    if (!assert_rangemap_test(r, 0x0000007aefefff, 1)) {
        pmem_warn("Failed assert: 0x0000007aefefff = 1");
        return -4087;
    }
    
    if (!assert_rangemap_test(r, 0x0000007aeff000, 1)) {
        pmem_warn("Failed assert: 0x0000007aeff000 = 1");
        return -61688;
    }
    
    if (!assert_rangemap_test(r, 0x0000007af7afff, 1)) {
        pmem_warn("Failed assert: 0x0000007af7afff = 1");
        return -4088;
    }
    
    if (!assert_rangemap_test(r, 0x0000007af7b000, 0)) {
        pmem_warn("Failed assert: 0x0000007af7b000 = 0");
        return -61689;
    }
    
    if (!assert_rangemap_test(r, 0x0000007afe4fff, 0)) {
        pmem_warn("Failed assert: 0x0000007afe4fff = 0");
        return -4089;
    }
    
    if (!assert_rangemap_test(r, 0x0000007afe5000, 1)) {
        pmem_warn("Failed assert: 0x0000007afe5000 = 1");
        return -61690;
    }
    
    if (!assert_rangemap_test(r, 0x0000007affffff, 1)) {
        pmem_warn("Failed assert: 0x0000007affffff = 1");
        return -4090;
    }
    
    if (!assert_rangemap_test(r, 0x0000007b000000, 0)) {
        pmem_warn("Failed assert: 0x0000007b000000 = 0");
        return -61691;
    }
    
    if (!assert_rangemap_test(r, 0x0000007f9fffff, 0)) {
        pmem_warn("Failed assert: 0x0000007f9fffff = 0");
        return -4091;
    }
    
    if (!assert_rangemap_test(r, 0x000000e00f8000, 0)) {
        pmem_warn("Failed assert: 0x000000e00f8000 = 0");
        return -61692;
    }
    
    if (!assert_rangemap_test(r, 0x000000e00f8fff, 0)) {
        pmem_warn("Failed assert: 0x000000e00f8fff = 0");
        return -4092;
    }
    
    if (!assert_rangemap_test(r, 0x000000fed1c000, 0)) {
        pmem_warn("Failed assert: 0x000000fed1c000 = 0");
        return -61693;
    }
    
    if (!assert_rangemap_test(r, 0x000000fed1ffff, 0)) {
        pmem_warn("Failed assert: 0x000000fed1ffff = 0");
        return -4093;
    }
    
    if (!assert_rangemap_test(r, 0x000000ffe10000, 0)) {
        pmem_warn("Failed assert: 0x000000ffe10000 = 0");
        return -61694;
    }
    
    if (!assert_rangemap_test(r, 0x000000ffe3ffff, 0)) {
        pmem_warn("Failed assert: 0x000000ffe3ffff = 0");
        return -4094;
    }
    
    if (!assert_rangemap_test(r, 0x00000100000000, 1)) {
        pmem_warn("Failed assert: 0x00000100000000 = 1");
        return -61695;
    }
    
    if (!assert_rangemap_test(r, 0x0000047f5fffff, 1)) {
        pmem_warn("Failed assert: 0x0000047f5fffff = 1");
        return -4095;
    }
    
    return 0;
}
