# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `spoom` gem.
# Please instead update this file by running `bin/tapioca gem spoom`.

# source://spoom//lib/spoom.rb#7
module Spoom; end

# source://spoom//lib/spoom/cli/helper.rb#9
module Spoom::Cli; end

# source://spoom//lib/spoom/cli/bump.rb#9
class Spoom::Cli::Bump < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli/bump.rb#49
  sig { params(directory: ::String).void }
  def bump(directory = T.unsafe(nil)); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/bump.rb#170
  def print_changes(files, command:, from: T.unsafe(nil), to: T.unsafe(nil), dry: T.unsafe(nil), path: T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/bump.rb#192
  def undo_changes(files, from_strictness); end
end

# source://spoom//lib/spoom/cli/config.rb#9
class Spoom::Cli::Config < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/config.rb#15
  def show; end
end

# source://spoom//lib/spoom/cli/coverage.rb#9
class Spoom::Cli::Coverage < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli/coverage.rb#198
  def bundle_install(path, sha); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/coverage.rb#210
  def message_no_data(file); end

  # source://spoom//lib/spoom/cli/coverage.rb#173
  def open(file = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/coverage.rb#189
  def parse_time(string, option); end

  # source://spoom//lib/spoom/cli/coverage.rb#142
  def report; end

  # source://spoom//lib/spoom/cli/coverage.rb#20
  def snapshot; end

  # source://spoom//lib/spoom/cli/coverage.rb#42
  def timeline; end
end

# source://spoom//lib/spoom/cli/coverage.rb#12
Spoom::Cli::Coverage::DATA_DIR = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/cli/helper.rb#10
module Spoom::Cli::Helper
  include ::Spoom::Colorize

  requires_ancestor { Thor }

  # source://spoom//lib/spoom/cli/helper.rb#119
  sig { params(string: ::String).returns(::String) }
  def blue(string); end

  # Is the `--color` option true?
  #
  # source://spoom//lib/spoom/cli/helper.rb#83
  sig { returns(T::Boolean) }
  def color?; end

  # Colorize a string if `color?`
  #
  # source://spoom//lib/spoom/cli/helper.rb#112
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def colorize(string, *color); end

  # Returns the context at `--path` (by default the current working directory)
  #
  # source://spoom//lib/spoom/cli/helper.rb#51
  sig { returns(::Spoom::Context) }
  def context; end

  # Raise if `spoom` is not ran inside a context with a `sorbet/config` file
  #
  # source://spoom//lib/spoom/cli/helper.rb#57
  sig { returns(::Spoom::Context) }
  def context_requiring_sorbet!; end

  # source://spoom//lib/spoom/cli/helper.rb#124
  sig { params(string: ::String).returns(::String) }
  def cyan(string); end

  # Return the path specified through `--path`
  #
  # source://spoom//lib/spoom/cli/helper.rb#72
  sig { returns(::String) }
  def exec_path; end

  # source://spoom//lib/spoom/cli/helper.rb#129
  sig { params(string: ::String).returns(::String) }
  def gray(string); end

  # source://spoom//lib/spoom/cli/helper.rb#134
  sig { params(string: ::String).returns(::String) }
  def green(string); end

  # source://spoom//lib/spoom/cli/helper.rb#88
  sig { params(string: ::String).returns(::String) }
  def highlight(string); end

  # source://spoom//lib/spoom/cli/helper.rb#139
  sig { params(string: ::String).returns(::String) }
  def red(string); end

  # Print `message` on `$stdout`
  #
  # source://spoom//lib/spoom/cli/helper.rb#20
  sig { params(message: ::String).void }
  def say(message); end

  # Print `message` on `$stderr`
  #
  # The message is prefixed by a status (default: `Error`).
  #
  # source://spoom//lib/spoom/cli/helper.rb#39
  sig { params(message: ::String, status: T.nilable(::String), nl: T::Boolean).void }
  def say_error(message, status: T.unsafe(nil), nl: T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/helper.rb#144
  sig { params(string: ::String).returns(::String) }
  def yellow(string); end
end

# source://spoom//lib/spoom/cli/lsp.rb#10
class Spoom::Cli::LSP < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/lsp.rb#55
  def defs(file, line, col); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/lsp.rb#65
  def find(query); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/lsp.rb#41
  def hover(file, line, col); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/lsp.rb#26
  def list; end

  # source://spoom//lib/spoom/cli/lsp.rb#114
  def lsp_client; end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/lsp.rb#85
  def refs(file, line, col); end

  # source://spoom//lib/spoom/cli/lsp.rb#137
  def run(&block); end

  # source://spoom//lib/spoom/cli/lsp.rb#16
  def show; end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/lsp.rb#95
  def sigs(file, line, col); end

  # source://spoom//lib/spoom/cli/lsp.rb#129
  def symbol_printer; end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/lsp.rb#75
  def symbols(file); end

  # source://spoom//lib/spoom/cli/lsp.rb#162
  def to_uri(path); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/lsp.rb#105
  def types(file, line, col); end
end

# source://spoom//lib/spoom/cli.rb#16
class Spoom::Cli::Main < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli.rb#61
  def __print_version; end

  # source://thor/1.2.2/lib/thor.rb#239
  def bump(*args); end

  # source://thor/1.2.2/lib/thor.rb#239
  def config(*args); end

  # source://thor/1.2.2/lib/thor.rb#239
  def coverage(*args); end

  # source://spoom//lib/spoom/cli.rb#43
  def files; end

  # source://thor/1.2.2/lib/thor.rb#239
  def lsp(*args); end

  # source://thor/1.2.2/lib/thor.rb#239
  def tc(*args); end

  class << self
    # @return [Boolean]
    #
    # source://spoom//lib/spoom/cli.rb#68
    def exit_on_failure?; end
  end
end

# source://spoom//lib/spoom/cli/run.rb#6
class Spoom::Cli::Run < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli/run.rb#131
  def colorize_message(message); end

  # source://spoom//lib/spoom/cli/run.rb#122
  def format_error(error, format); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/run.rb#26
  def tc(*paths_to_select); end
end

# source://spoom//lib/spoom/cli/run.rb#15
Spoom::Cli::Run::DEFAULT_FORMAT = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/cli/run.rb#11
Spoom::Cli::Run::SORT_CODE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/cli/run.rb#13
Spoom::Cli::Run::SORT_ENUM = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/cli/run.rb#12
Spoom::Cli::Run::SORT_LOC = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/colors.rb#5
class Spoom::Color < ::T::Enum
  enums do
    CLEAR = new
    BOLD = new
    BLACK = new
    RED = new
    GREEN = new
    YELLOW = new
    BLUE = new
    MAGENTA = new
    CYAN = new
    WHITE = new
    LIGHT_BLACK = new
    LIGHT_RED = new
    LIGHT_GREEN = new
    LIGHT_YELLOW = new
    LIGHT_BLUE = new
    LIGHT_MAGENTA = new
    LIGHT_CYAN = new
    LIGHT_WHITE = new
  end

  # source://spoom//lib/spoom/colors.rb#32
  sig { returns(::String) }
  def ansi_code; end
end

# source://spoom//lib/spoom/colors.rb#37
module Spoom::Colorize
  # source://spoom//lib/spoom/colors.rb#41
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def set_color(string, *color); end
end

# An abstraction to a Ruby project context
#
# A context maps to a directory in the file system.
# It is used to manipulate files and run commands in the context of this directory.
#
# source://spoom//lib/spoom/context/bundle.rb#5
class Spoom::Context
  include ::Spoom::Context::Bundle
  include ::Spoom::Context::Exec
  include ::Spoom::Context::FileSystem
  include ::Spoom::Context::Git
  include ::Spoom::Context::Sorbet

  # Create a new context about `absolute_path`
  #
  # The directory will not be created if it doesn't exist.
  # Call `#make!` to create it.
  #
  # source://spoom//lib/spoom/context.rb#51
  sig { params(absolute_path: ::String).void }
  def initialize(absolute_path); end

  # The absolute path to the directory this context is about
  #
  # source://spoom//lib/spoom/context.rb#44
  sig { returns(::String) }
  def absolute_path; end

  class << self
    # Create a new context in the system's temporary directory
    #
    # `name` is used as prefix to the temporary directory name.
    # The directory will be created if it doesn't exist.
    #
    # source://spoom//lib/spoom/context.rb#37
    sig { params(name: T.nilable(::String)).returns(T.attached_class) }
    def mktmp!(name = T.unsafe(nil)); end
  end
end

# Bundle features for a context
#
# source://spoom//lib/spoom/context/bundle.rb#7
module Spoom::Context::Bundle
  requires_ancestor { Spoom::Context }

  # Run a command with `bundle` in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#27
  sig { params(command: ::String, version: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def bundle(command, version: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # Run a command `bundle exec` in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#40
  sig { params(command: ::String, version: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def bundle_exec(command, version: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # Run `bundle install` in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#34
  sig { params(version: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def bundle_install!(version: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # Get `gem` version from the `Gemfile.lock` content
  #
  # Returns `nil` if `gem` cannot be found in the Gemfile.
  #
  # source://spoom//lib/spoom/context/bundle.rb#48
  sig { params(gem: ::String).returns(T.nilable(::String)) }
  def gem_version_from_gemfile_lock(gem); end

  # Read the `contents` of the Gemfile in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#15
  sig { returns(T.nilable(::String)) }
  def read_gemfile; end

  # Set the `contents` of the Gemfile in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#21
  sig { params(contents: ::String, append: T::Boolean).void }
  def write_gemfile!(contents, append: T.unsafe(nil)); end
end

# Execution features for a context
#
# source://spoom//lib/spoom/context/exec.rb#27
module Spoom::Context::Exec
  requires_ancestor { Spoom::Context }

  # Run a command in this context directory
  #
  # source://spoom//lib/spoom/context/exec.rb#35
  sig { params(command: ::String, capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def exec(command, capture_err: T.unsafe(nil)); end
end

# File System features for a context
#
# source://spoom//lib/spoom/context/file_system.rb#7
module Spoom::Context::FileSystem
  requires_ancestor { Spoom::Context }

  # Returns the absolute path to `relative_path` in the context's directory
  #
  # source://spoom//lib/spoom/context/file_system.rb#15
  sig { params(relative_path: ::String).returns(::String) }
  def absolute_path_to(relative_path); end

  # Delete this context and its content
  #
  # Warning: it will `rm -rf` the context directory on the file system.
  #
  # source://spoom//lib/spoom/context/file_system.rb#88
  sig { void }
  def destroy!; end

  # Does the context directory at `absolute_path` exist and is a directory?
  #
  # source://spoom//lib/spoom/context/file_system.rb#21
  sig { returns(T::Boolean) }
  def exist?; end

  # Does `relative_path` point to an existing file in this context directory?
  #
  # source://spoom//lib/spoom/context/file_system.rb#48
  sig { params(relative_path: ::String).returns(T::Boolean) }
  def file?(relative_path); end

  # List all files in this context matching `pattern`
  #
  # source://spoom//lib/spoom/context/file_system.rb#34
  sig { params(pattern: ::String).returns(T::Array[::String]) }
  def glob(pattern = T.unsafe(nil)); end

  # List all files at the top level of this context directory
  #
  # source://spoom//lib/spoom/context/file_system.rb#42
  sig { returns(T::Array[::String]) }
  def list; end

  # Create the context directory at `absolute_path`
  #
  # source://spoom//lib/spoom/context/file_system.rb#27
  sig { void }
  def mkdir!; end

  # Move the file or directory from `from_relative_path` to `to_relative_path`
  #
  # source://spoom//lib/spoom/context/file_system.rb#78
  sig { params(from_relative_path: ::String, to_relative_path: ::String).void }
  def move!(from_relative_path, to_relative_path); end

  # Return the contents of the file at `relative_path` in this context directory
  #
  # Will raise if the file doesn't exist.
  #
  # source://spoom//lib/spoom/context/file_system.rb#56
  sig { params(relative_path: ::String).returns(::String) }
  def read(relative_path); end

  # Remove the path at `relative_path` (recursive + force) in this context directory
  #
  # source://spoom//lib/spoom/context/file_system.rb#72
  sig { params(relative_path: ::String).void }
  def remove!(relative_path); end

  # Write `contents` in the file at `relative_path` in this context directory
  #
  # Append to the file if `append` is true.
  #
  # source://spoom//lib/spoom/context/file_system.rb#64
  sig { params(relative_path: ::String, contents: ::String, append: T::Boolean).void }
  def write!(relative_path, contents = T.unsafe(nil), append: T.unsafe(nil)); end
end

# Git features for a context
#
# source://spoom//lib/spoom/context/git.rb#35
module Spoom::Context::Git
  requires_ancestor { Spoom::Context }

  # Run a command prefixed by `git` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#43
  sig { params(command: ::String).returns(::Spoom::ExecResult) }
  def git(command); end

  # Run `git checkout` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#62
  sig { params(ref: ::String).returns(::Spoom::ExecResult) }
  def git_checkout!(ref: T.unsafe(nil)); end

  # Run `git add . && git commit` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#68
  sig { params(message: ::String, time: ::Time, allow_empty: T::Boolean).void }
  def git_commit!(message: T.unsafe(nil), time: T.unsafe(nil), allow_empty: T.unsafe(nil)); end

  # Get the current git branch in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#79
  sig { returns(T.nilable(::String)) }
  def git_current_branch; end

  # Run `git diff` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#88
  sig { params(arg: ::String).returns(::Spoom::ExecResult) }
  def git_diff(*arg); end

  # Run `git init` in this context directory
  #
  # Warning: passing a branch will run `git init -b <branch>` which is only available in git 2.28+.
  # In older versions, use `git_init!` followed by `git("checkout -b <branch>")`.
  #
  # source://spoom//lib/spoom/context/git.rb#52
  sig { params(branch: T.nilable(::String)).returns(::Spoom::ExecResult) }
  def git_init!(branch: T.unsafe(nil)); end

  # Get the last commit in the currently checked out branch
  #
  # source://spoom//lib/spoom/context/git.rb#94
  sig { params(short_sha: T::Boolean).returns(T.nilable(::Spoom::Git::Commit)) }
  def git_last_commit(short_sha: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/git.rb#105
  sig { params(arg: ::String).returns(::Spoom::ExecResult) }
  def git_log(*arg); end

  # source://spoom//lib/spoom/context/git.rb#110
  sig { params(arg: ::String).returns(::Spoom::ExecResult) }
  def git_show(*arg); end

  # Is there uncommited changes in this context directory?
  #
  # source://spoom//lib/spoom/context/git.rb#116
  sig { params(path: ::String).returns(T::Boolean) }
  def git_workdir_clean?(path: T.unsafe(nil)); end
end

# Sorbet features for a context
#
# source://spoom//lib/spoom/context/sorbet.rb#7
module Spoom::Context::Sorbet
  requires_ancestor { Spoom::Context }

  # Does this context has a `sorbet/config` file?
  #
  # source://spoom//lib/spoom/context/sorbet.rb#102
  sig { returns(T::Boolean) }
  def has_sorbet_config?; end

  # Read the strictness sigil from the file at `relative_path` (returns `nil` if no sigil)
  #
  # source://spoom//lib/spoom/context/sorbet.rb#125
  sig { params(relative_path: ::String).returns(T.nilable(::String)) }
  def read_file_strictness(relative_path); end

  # Read the contents of `sorbet/config` in this context directory
  #
  # source://spoom//lib/spoom/context/sorbet.rb#113
  sig { returns(::String) }
  def read_sorbet_config; end

  # source://spoom//lib/spoom/context/sorbet.rb#107
  sig { returns(::Spoom::Sorbet::Config) }
  def sorbet_config; end

  # Get the commit introducing the `sorbet/config` file
  #
  # source://spoom//lib/spoom/context/sorbet.rb#131
  sig { returns(T.nilable(::Spoom::Git::Commit)) }
  def sorbet_intro_commit; end

  # Get the commit removing the `sorbet/config` file
  #
  # source://spoom//lib/spoom/context/sorbet.rb#143
  sig { returns(T.nilable(::Spoom::Git::Commit)) }
  def sorbet_removal_commit; end

  # Run `bundle exec srb` in this context directory
  #
  # source://spoom//lib/spoom/context/sorbet.rb#15
  sig { params(arg: ::String, sorbet_bin: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def srb(*arg, sorbet_bin: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # List all files typechecked by Sorbet from its `config`
  #
  # source://spoom//lib/spoom/context/sorbet.rb#65
  sig { params(with_config: T.nilable(::Spoom::Sorbet::Config), include_rbis: T::Boolean).returns(T::Array[::String]) }
  def srb_files(with_config: T.unsafe(nil), include_rbis: T.unsafe(nil)); end

  # List all files typechecked by Sorbet from its `config` that matches `strictness`
  #
  # source://spoom//lib/spoom/context/sorbet.rb#87
  sig do
    params(
      strictness: ::String,
      with_config: T.nilable(::Spoom::Sorbet::Config),
      include_rbis: T::Boolean
    ).returns(T::Array[::String])
  end
  def srb_files_with_strictness(strictness, with_config: T.unsafe(nil), include_rbis: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/sorbet.rb#45
  sig do
    params(
      arg: ::String,
      sorbet_bin: T.nilable(::String),
      capture_err: T::Boolean
    ).returns(T.nilable(T::Hash[::String, ::Integer]))
  end
  def srb_metrics(*arg, sorbet_bin: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/sorbet.rb#33
  sig { params(arg: ::String, sorbet_bin: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def srb_tc(*arg, sorbet_bin: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/sorbet.rb#93
  sig { params(arg: ::String, sorbet_bin: T.nilable(::String), capture_err: T::Boolean).returns(T.nilable(::String)) }
  def srb_version(*arg, sorbet_bin: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # Set the `contents` of `sorbet/config` in this context directory
  #
  # source://spoom//lib/spoom/context/sorbet.rb#119
  sig { params(contents: ::String, append: T::Boolean).void }
  def write_sorbet_config!(contents, append: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/snapshot.rb#5
module Spoom::Coverage
  class << self
    # source://spoom//lib/spoom/coverage.rb#103
    sig { params(context: ::Spoom::Context).returns(::Spoom::FileTree) }
    def file_tree(context); end

    # source://spoom//lib/spoom/coverage.rb#83
    sig do
      params(
        context: ::Spoom::Context,
        snapshots: T::Array[::Spoom::Coverage::Snapshot],
        palette: ::Spoom::Coverage::D3::ColorPalette
      ).returns(::Spoom::Coverage::Report)
    end
    def report(context, snapshots, palette:); end

    # source://spoom//lib/spoom/coverage.rb#16
    sig do
      params(
        context: ::Spoom::Context,
        rbi: T::Boolean,
        sorbet_bin: T.nilable(::String)
      ).returns(::Spoom::Coverage::Snapshot)
    end
    def snapshot(context, rbi: T.unsafe(nil), sorbet_bin: T.unsafe(nil)); end
  end
end

# source://spoom//lib/spoom/coverage/report.rb#88
module Spoom::Coverage::Cards; end

# source://spoom//lib/spoom/coverage/report.rb#89
class Spoom::Coverage::Cards::Card < ::Spoom::Coverage::Template
  # source://spoom//lib/spoom/coverage/report.rb#98
  sig { params(template: ::String, title: T.nilable(::String), body: T.nilable(::String)).void }
  def initialize(template: T.unsafe(nil), title: T.unsafe(nil), body: T.unsafe(nil)); end

  # @return [String, nil]
  #
  # source://spoom//lib/spoom/coverage/report.rb#95
  def body; end

  # source://spoom//lib/spoom/coverage/report.rb#95
  sig { returns(T.nilable(::String)) }
  def title; end
end

# source://spoom//lib/spoom/coverage/report.rb#92
Spoom::Coverage::Cards::Card::TEMPLATE = T.let(T.unsafe(nil), String)

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/report.rb#105
class Spoom::Coverage::Cards::Erb < ::Spoom::Coverage::Cards::Card
  abstract!

  # source://spoom//lib/spoom/coverage/report.rb#112
  sig { void }
  def initialize; end

  # @abstract
  #
  # source://spoom//lib/spoom/coverage/report.rb#120
  sig { abstract.returns(::String) }
  def erb; end

  # source://spoom//lib/spoom/coverage/report.rb#115
  sig { override.returns(::String) }
  def html; end
end

# source://spoom//lib/spoom/coverage/report.rb#153
class Spoom::Coverage::Cards::Map < ::Spoom::Coverage::Cards::Card
  # source://spoom//lib/spoom/coverage/report.rb#164
  sig do
    params(
      file_tree: ::Spoom::FileTree,
      nodes_strictnesses: T::Hash[::Spoom::FileTree::Node, T.nilable(::String)],
      nodes_strictness_scores: T::Hash[::Spoom::FileTree::Node, ::Float],
      title: ::String
    ).void
  end
  def initialize(file_tree:, nodes_strictnesses:, nodes_strictness_scores:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#123
class Spoom::Coverage::Cards::Snapshot < ::Spoom::Coverage::Cards::Card
  # source://spoom//lib/spoom/coverage/report.rb#132
  sig { params(snapshot: ::Spoom::Coverage::Snapshot, title: ::String).void }
  def initialize(snapshot:, title: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/report.rb#143
  sig { returns(::Spoom::Coverage::D3::Pie::Calls) }
  def pie_calls; end

  # source://spoom//lib/spoom/coverage/report.rb#138
  sig { returns(::Spoom::Coverage::D3::Pie::Sigils) }
  def pie_sigils; end

  # source://spoom//lib/spoom/coverage/report.rb#148
  sig { returns(::Spoom::Coverage::D3::Pie::Sigs) }
  def pie_sigs; end

  # source://spoom//lib/spoom/coverage/report.rb#129
  sig { returns(::Spoom::Coverage::Snapshot) }
  def snapshot; end
end

# source://spoom//lib/spoom/coverage/report.rb#126
Spoom::Coverage::Cards::Snapshot::TEMPLATE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/report.rb#240
class Spoom::Coverage::Cards::SorbetIntro < ::Spoom::Coverage::Cards::Erb
  # source://spoom//lib/spoom/coverage/report.rb#244
  sig { params(sorbet_intro_commit: T.nilable(::String), sorbet_intro_date: T.nilable(::Time)).void }
  def initialize(sorbet_intro_commit: T.unsafe(nil), sorbet_intro_date: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/report.rb#250
  sig { override.returns(::String) }
  def erb; end
end

# source://spoom//lib/spoom/coverage/report.rb#177
class Spoom::Coverage::Cards::Timeline < ::Spoom::Coverage::Cards::Card
  # source://spoom//lib/spoom/coverage/report.rb#181
  sig { params(title: ::String, timeline: ::Spoom::Coverage::D3::Timeline).void }
  def initialize(title:, timeline:); end
end

# source://spoom//lib/spoom/coverage/report.rb#194
class Spoom::Coverage::Cards::Timeline::Calls < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#198
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#212
class Spoom::Coverage::Cards::Timeline::RBIs < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#216
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#230
class Spoom::Coverage::Cards::Timeline::Runtimes < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#234
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#185
class Spoom::Coverage::Cards::Timeline::Sigils < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#189
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#203
class Spoom::Coverage::Cards::Timeline::Sigs < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#207
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#221
class Spoom::Coverage::Cards::Timeline::Versions < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#225
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/d3/base.rb#6
module Spoom::Coverage::D3
  class << self
    # source://spoom//lib/spoom/coverage/d3.rb#61
    sig { params(palette: ::Spoom::Coverage::D3::ColorPalette).returns(::String) }
    def header_script(palette); end

    # source://spoom//lib/spoom/coverage/d3.rb#21
    sig { returns(::String) }
    def header_style; end
  end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/d3/base.rb#7
class Spoom::Coverage::D3::Base
  abstract!

  # source://spoom//lib/spoom/coverage/d3/base.rb#17
  sig { params(id: ::String, data: T.untyped).void }
  def initialize(id, data); end

  # source://spoom//lib/spoom/coverage/d3/base.rb#37
  sig { returns(::String) }
  def html; end

  # source://spoom//lib/spoom/coverage/d3/base.rb#14
  sig { returns(::String) }
  def id; end

  # @abstract
  #
  # source://spoom//lib/spoom/coverage/d3/base.rb#50
  sig { abstract.returns(::String) }
  def script; end

  # source://spoom//lib/spoom/coverage/d3/base.rb#45
  sig { returns(::String) }
  def tooltip; end

  class << self
    # source://spoom//lib/spoom/coverage/d3/base.rb#31
    sig { returns(::String) }
    def header_script; end

    # source://spoom//lib/spoom/coverage/d3/base.rb#26
    sig { returns(::String) }
    def header_style; end
  end
end

# source://spoom//lib/spoom/coverage/d3.rb#12
Spoom::Coverage::D3::COLOR_FALSE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3.rb#11
Spoom::Coverage::D3::COLOR_IGNORE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3.rb#14
Spoom::Coverage::D3::COLOR_STRICT = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3.rb#15
Spoom::Coverage::D3::COLOR_STRONG = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3.rb#13
Spoom::Coverage::D3::COLOR_TRUE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3/circle_map.rb#9
class Spoom::Coverage::D3::CircleMap < ::Spoom::Coverage::D3::Base
  # source://spoom//lib/spoom/coverage/d3/circle_map.rb#59
  sig { override.returns(::String) }
  def script; end

  class << self
    # source://spoom//lib/spoom/coverage/d3/circle_map.rb#40
    sig { returns(::String) }
    def header_script; end

    # source://spoom//lib/spoom/coverage/d3/circle_map.rb#14
    sig { returns(::String) }
    def header_style; end
  end
end

# source://spoom//lib/spoom/coverage/d3/circle_map.rb#148
class Spoom::Coverage::D3::CircleMap::Sigils < ::Spoom::Coverage::D3::CircleMap
  # source://spoom//lib/spoom/coverage/d3/circle_map.rb#159
  sig do
    params(
      id: ::String,
      file_tree: ::Spoom::FileTree,
      nodes_strictnesses: T::Hash[::Spoom::FileTree::Node, T.nilable(::String)],
      nodes_scores: T::Hash[::Spoom::FileTree::Node, ::Float]
    ).void
  end
  def initialize(id, file_tree, nodes_strictnesses, nodes_scores); end

  # source://spoom//lib/spoom/coverage/d3/circle_map.rb#166
  sig { params(node: ::Spoom::FileTree::Node).returns(T::Hash[::Symbol, T.untyped]) }
  def tree_node_to_json(node); end
end

# source://spoom//lib/spoom/coverage/d3.rb#103
class Spoom::Coverage::D3::ColorPalette < ::T::Struct
  prop :ignore, ::String
  prop :false, ::String
  prop :true, ::String
  prop :strict, ::String
  prop :strong, ::String

  class << self
    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/d3/pie.rb#9
class Spoom::Coverage::D3::Pie < ::Spoom::Coverage::D3::Base
  abstract!

  # source://spoom//lib/spoom/coverage/d3/pie.rb#16
  sig { params(id: ::String, title: ::String, data: T.untyped).void }
  def initialize(id, title, data); end

  # source://spoom//lib/spoom/coverage/d3/pie.rb#56
  sig { override.returns(::String) }
  def script; end

  class << self
    # source://spoom//lib/spoom/coverage/d3/pie.rb#43
    sig { returns(::String) }
    def header_script; end

    # source://spoom//lib/spoom/coverage/d3/pie.rb#25
    sig { returns(::String) }
    def header_style; end
  end
end

# source://spoom//lib/spoom/coverage/d3/pie.rb#141
class Spoom::Coverage::D3::Pie::Calls < ::Spoom::Coverage::D3::Pie
  # source://spoom//lib/spoom/coverage/d3/pie.rb#145
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  # source://spoom//lib/spoom/coverage/d3/pie.rb#150
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/pie.rb#123
class Spoom::Coverage::D3::Pie::Sigils < ::Spoom::Coverage::D3::Pie
  # source://spoom//lib/spoom/coverage/d3/pie.rb#127
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  # source://spoom//lib/spoom/coverage/d3/pie.rb#132
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/pie.rb#159
class Spoom::Coverage::D3::Pie::Sigs < ::Spoom::Coverage::D3::Pie
  # source://spoom//lib/spoom/coverage/d3/pie.rb#163
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  # source://spoom//lib/spoom/coverage/d3/pie.rb#172
  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/d3/timeline.rb#9
class Spoom::Coverage::D3::Timeline < ::Spoom::Coverage::D3::Base
  abstract!

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#16
  sig { params(id: ::String, data: T.untyped, keys: T::Array[::String]).void }
  def initialize(id, data, keys); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#187
  sig { params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def area(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#203
  sig { params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # @abstract
  #
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#126
  sig { abstract.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#217
  sig { params(y: ::String).returns(::String) }
  def points(y:); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#101
  sig { override.returns(::String) }
  def script; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#129
  sig { returns(::String) }
  def x_scale; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#145
  sig { returns(::String) }
  def x_ticks; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#158
  sig { params(min: ::String, max: ::String, ticks: ::String).returns(::String) }
  def y_scale(min:, max:, ticks:); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#174
  sig { params(ticks: ::String, format: ::String, padding: ::Integer).returns(::String) }
  def y_ticks(ticks:, format:, padding:); end

  class << self
    # source://spoom//lib/spoom/coverage/d3/timeline.rb#79
    sig { returns(::String) }
    def header_script; end

    # source://spoom//lib/spoom/coverage/d3/timeline.rb#25
    sig { returns(::String) }
    def header_style; end
  end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#448
class Spoom::Coverage::D3::Timeline::Calls < ::Spoom::Coverage::D3::Timeline::Stacked
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#452
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#466
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#505
class Spoom::Coverage::D3::Timeline::RBIs < ::Spoom::Coverage::D3::Timeline::Stacked
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#509
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#577
  sig { override.params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#617
  sig { override.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#537
  sig { override.returns(::String) }
  def script; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#523
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#282
class Spoom::Coverage::D3::Timeline::Runtimes < ::Spoom::Coverage::D3::Timeline
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#286
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#311
  sig { override.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#298
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#421
class Spoom::Coverage::D3::Timeline::Sigils < ::Spoom::Coverage::D3::Timeline::Stacked
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#425
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#439
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#475
class Spoom::Coverage::D3::Timeline::Sigs < ::Spoom::Coverage::D3::Timeline::Stacked
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#479
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#496
  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/d3/timeline.rb#329
class Spoom::Coverage::D3::Timeline::Stacked < ::Spoom::Coverage::D3::Timeline
  abstract!

  # source://sorbet-runtime/0.5.10598/lib/types/private/abstract/declare.rb#37
  def initialize(*args, **_arg1, &blk); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#388
  sig { override.params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#377
  sig { override.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#336
  sig { override.returns(::String) }
  def script; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#232
class Spoom::Coverage::D3::Timeline::Versions < ::Spoom::Coverage::D3::Timeline
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#236
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#263
  sig { override.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#249
  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/report.rb#38
class Spoom::Coverage::Page < ::Spoom::Coverage::Template
  abstract!

  # source://spoom//lib/spoom/coverage/report.rb#53
  sig { params(title: ::String, palette: ::Spoom::Coverage::D3::ColorPalette, template: ::String).void }
  def initialize(title:, palette:, template: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/report.rb#75
  sig { returns(::String) }
  def body_html; end

  # @abstract
  #
  # source://spoom//lib/spoom/coverage/report.rb#80
  sig { abstract.returns(T::Array[::Spoom::Coverage::Cards::Card]) }
  def cards; end

  # source://spoom//lib/spoom/coverage/report.rb#83
  sig { returns(::String) }
  def footer_html; end

  # source://spoom//lib/spoom/coverage/report.rb#70
  sig { returns(::String) }
  def header_html; end

  # source://spoom//lib/spoom/coverage/report.rb#65
  sig { returns(::String) }
  def header_script; end

  # source://spoom//lib/spoom/coverage/report.rb#60
  sig { returns(::String) }
  def header_style; end

  # source://spoom//lib/spoom/coverage/report.rb#50
  sig { returns(::Spoom::Coverage::D3::ColorPalette) }
  def palette; end

  # source://spoom//lib/spoom/coverage/report.rb#47
  sig { returns(::String) }
  def title; end
end

# source://spoom//lib/spoom/coverage/report.rb#44
Spoom::Coverage::Page::TEMPLATE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/report.rb#261
class Spoom::Coverage::Report < ::Spoom::Coverage::Page
  # source://spoom//lib/spoom/coverage/report.rb#276
  sig do
    params(
      project_name: ::String,
      palette: ::Spoom::Coverage::D3::ColorPalette,
      snapshots: T::Array[::Spoom::Coverage::Snapshot],
      file_tree: ::Spoom::FileTree,
      nodes_strictnesses: T::Hash[::Spoom::FileTree::Node, T.nilable(::String)],
      nodes_strictness_scores: T::Hash[::Spoom::FileTree::Node, ::Float],
      sorbet_intro_commit: T.nilable(::String),
      sorbet_intro_date: T.nilable(::Time)
    ).void
  end
  def initialize(project_name:, palette:, snapshots:, file_tree:, nodes_strictnesses:, nodes_strictness_scores:, sorbet_intro_commit: T.unsafe(nil), sorbet_intro_date: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/report.rb#308
  sig { override.returns(T::Array[::Spoom::Coverage::Cards::Card]) }
  def cards; end

  # source://spoom//lib/spoom/coverage/report.rb#297
  sig { override.returns(::String) }
  def header_html; end
end

# source://spoom//lib/spoom/coverage/snapshot.rb#6
class Spoom::Coverage::Snapshot < ::T::Struct
  prop :timestamp, ::Integer, default: T.unsafe(nil)
  prop :version_static, T.nilable(::String), default: T.unsafe(nil)
  prop :version_runtime, T.nilable(::String), default: T.unsafe(nil)
  prop :duration, ::Integer, default: T.unsafe(nil)
  prop :commit_sha, T.nilable(::String), default: T.unsafe(nil)
  prop :commit_timestamp, T.nilable(::Integer), default: T.unsafe(nil)
  prop :files, ::Integer, default: T.unsafe(nil)
  prop :rbi_files, ::Integer, default: T.unsafe(nil)
  prop :modules, ::Integer, default: T.unsafe(nil)
  prop :classes, ::Integer, default: T.unsafe(nil)
  prop :singleton_classes, ::Integer, default: T.unsafe(nil)
  prop :methods_without_sig, ::Integer, default: T.unsafe(nil)
  prop :methods_with_sig, ::Integer, default: T.unsafe(nil)
  prop :calls_untyped, ::Integer, default: T.unsafe(nil)
  prop :calls_typed, ::Integer, default: T.unsafe(nil)
  prop :sigils, T::Hash[::String, ::Integer], default: T.unsafe(nil)
  prop :methods_with_sig_excluding_rbis, ::Integer, default: T.unsafe(nil)
  prop :methods_without_sig_excluding_rbis, ::Integer, default: T.unsafe(nil)
  prop :sigils_excluding_rbis, T::Hash[::String, ::Integer], default: T.unsafe(nil)

  # source://spoom//lib/spoom/coverage/snapshot.rb#33
  sig { params(out: T.any(::IO, ::StringIO), colors: T::Boolean, indent_level: ::Integer).void }
  def print(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/snapshot.rb#39
  sig { params(arg: T.untyped).returns(::String) }
  def to_json(*arg); end

  class << self
    # source://spoom//lib/spoom/coverage/snapshot.rb#47
    sig { params(json: ::String).returns(::Spoom::Coverage::Snapshot) }
    def from_json(json); end

    # source://spoom//lib/spoom/coverage/snapshot.rb#52
    sig { params(obj: T::Hash[::String, T.untyped]).returns(::Spoom::Coverage::Snapshot) }
    def from_obj(obj); end

    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# The strictness name as found in the Sorbet metrics file
#
# source://spoom//lib/spoom/coverage/snapshot.rb#30
Spoom::Coverage::Snapshot::STRICTNESSES = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/coverage/snapshot.rb#95
class Spoom::Coverage::SnapshotPrinter < ::Spoom::Printer
  # source://spoom//lib/spoom/coverage/snapshot.rb#99
  sig { params(snapshot: ::Spoom::Coverage::Snapshot).void }
  def print_snapshot(snapshot); end

  private

  # source://spoom//lib/spoom/coverage/snapshot.rb#158
  sig { params(value: T.nilable(::Integer), total: T.nilable(::Integer)).returns(::String) }
  def percent(value, total); end

  # source://spoom//lib/spoom/coverage/snapshot.rb#147
  sig { params(hash: T::Hash[::String, ::Integer], total: ::Integer).void }
  def print_map(hash, total); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/report.rb#10
class Spoom::Coverage::Template
  abstract!

  # Create a new template from an Erb file path
  #
  # source://spoom//lib/spoom/coverage/report.rb#18
  sig { params(template: ::String).void }
  def initialize(template:); end

  # source://spoom//lib/spoom/coverage/report.rb#23
  sig { returns(::String) }
  def erb; end

  # source://spoom//lib/spoom/coverage/report.rb#33
  sig { returns(::Binding) }
  def get_binding; end

  # source://spoom//lib/spoom/coverage/report.rb#28
  sig { returns(::String) }
  def html; end
end

# source://spoom//lib/spoom.rb#12
class Spoom::Error < ::StandardError; end

# source://spoom//lib/spoom/context/exec.rb#5
class Spoom::ExecResult < ::T::Struct
  const :out, ::String
  const :err, T.nilable(::String)
  const :status, T::Boolean
  const :exit_code, ::Integer

  # source://spoom//lib/spoom/context/exec.rb#14
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/file_collector.rb#5
class Spoom::FileCollector
  # Initialize a new file collector
  #
  # If `allow_extensions` is empty, all files are collected.
  # If `allow_extensions` is an array of extensions, only files with one of these extensions are collected.
  #
  # source://spoom//lib/spoom/file_collector.rb#21
  sig { params(allow_extensions: T::Array[::String], exclude_patterns: T::Array[::String]).void }
  def initialize(allow_extensions: T.unsafe(nil), exclude_patterns: T.unsafe(nil)); end

  # source://spoom//lib/spoom/file_collector.rb#9
  sig { returns(T::Array[::String]) }
  def files; end

  # source://spoom//lib/spoom/file_collector.rb#33
  sig { params(path: ::String).void }
  def visit_path(path); end

  # source://spoom//lib/spoom/file_collector.rb#28
  sig { params(paths: T::Array[::String]).void }
  def visit_paths(paths); end

  private

  # source://spoom//lib/spoom/file_collector.rb#50
  sig { params(path: ::String).returns(::String) }
  def clean_path(path); end

  # source://spoom//lib/spoom/file_collector.rb#67
  sig { params(path: ::String).returns(T::Boolean) }
  def excluded_file?(path); end

  # source://spoom//lib/spoom/file_collector.rb#75
  sig { params(path: ::String).returns(T::Boolean) }
  def excluded_path?(path); end

  # source://spoom//lib/spoom/file_collector.rb#62
  sig { params(path: ::String).void }
  def visit_directory(path); end

  # source://spoom//lib/spoom/file_collector.rb#55
  sig { params(path: ::String).void }
  def visit_file(path); end
end

# Build a file hierarchy from a set of file paths.
#
# source://spoom//lib/spoom/file_tree.rb#6
class Spoom::FileTree
  # source://spoom//lib/spoom/file_tree.rb#10
  sig { params(paths: T::Enumerable[::String]).void }
  def initialize(paths = T.unsafe(nil)); end

  # Add a `path` to the tree
  #
  # This will create all nodes until the root of `path`.
  #
  # source://spoom//lib/spoom/file_tree.rb#25
  sig { params(path: ::String).returns(::Spoom::FileTree::Node) }
  def add_path(path); end

  # Add all `paths` to the tree
  #
  # source://spoom//lib/spoom/file_tree.rb#17
  sig { params(paths: T::Enumerable[::String]).void }
  def add_paths(paths); end

  # All the nodes in this tree
  #
  # source://spoom//lib/spoom/file_tree.rb#45
  sig { returns(T::Array[::Spoom::FileTree::Node]) }
  def nodes; end

  # Return a map of typing scores for each node in the tree
  #
  # source://spoom//lib/spoom/file_tree.rb#67
  sig { params(context: ::Spoom::Context).returns(T::Hash[::Spoom::FileTree::Node, ::Float]) }
  def nodes_strictness_scores(context); end

  # Return a map of strictnesses for each node in the tree
  #
  # source://spoom//lib/spoom/file_tree.rb#59
  sig { params(context: ::Spoom::Context).returns(T::Hash[::Spoom::FileTree::Node, T.nilable(::String)]) }
  def nodes_strictnesses(context); end

  # All the paths in this tree
  #
  # source://spoom//lib/spoom/file_tree.rb#53
  sig { returns(T::Array[::String]) }
  def paths; end

  # Return a map of typing scores for each path in the tree
  #
  # source://spoom//lib/spoom/file_tree.rb#75
  sig { params(context: ::Spoom::Context).returns(T::Hash[::String, ::Float]) }
  def paths_strictness_scores(context); end

  # source://spoom//lib/spoom/file_tree.rb#80
  sig { params(out: T.any(::IO, ::StringIO), colors: T::Boolean).void }
  def print(out: T.unsafe(nil), colors: T.unsafe(nil)); end

  # source://spoom//lib/spoom/file_tree.rb#86
  sig { params(context: ::Spoom::Context, out: T.any(::IO, ::StringIO), colors: T::Boolean).void }
  def print_with_strictnesses(context, out: T.unsafe(nil), colors: T.unsafe(nil)); end

  # All root nodes
  #
  # source://spoom//lib/spoom/file_tree.rb#39
  sig { returns(T::Array[::Spoom::FileTree::Node]) }
  def roots; end
end

# A visitor that collects all the nodes in a tree
#
# source://spoom//lib/spoom/file_tree.rb#140
class Spoom::FileTree::CollectNodes < ::Spoom::FileTree::Visitor
  # source://spoom//lib/spoom/file_tree.rb#147
  sig { void }
  def initialize; end

  # source://spoom//lib/spoom/file_tree.rb#144
  sig { returns(T::Array[::Spoom::FileTree::Node]) }
  def nodes; end

  # source://spoom//lib/spoom/file_tree.rb#153
  sig { override.params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end
end

# A visitor that collects the typing score of each node in a tree
#
# source://spoom//lib/spoom/file_tree.rb#183
class Spoom::FileTree::CollectScores < ::Spoom::FileTree::CollectStrictnesses
  # source://spoom//lib/spoom/file_tree.rb#190
  sig { params(context: ::Spoom::Context).void }
  def initialize(context); end

  # source://spoom//lib/spoom/file_tree.rb#187
  sig { returns(T::Hash[::Spoom::FileTree::Node, ::Float]) }
  def scores; end

  # source://spoom//lib/spoom/file_tree.rb#197
  sig { override.params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end

  private

  # source://spoom//lib/spoom/file_tree.rb#206
  sig { params(node: ::Spoom::FileTree::Node).returns(::Float) }
  def node_score(node); end

  # source://spoom//lib/spoom/file_tree.rb#215
  sig { params(strictness: T.nilable(::String)).returns(::Float) }
  def strictness_score(strictness); end
end

# A visitor that collects the strictness of each node in a tree
#
# source://spoom//lib/spoom/file_tree.rb#160
class Spoom::FileTree::CollectStrictnesses < ::Spoom::FileTree::Visitor
  # source://spoom//lib/spoom/file_tree.rb#167
  sig { params(context: ::Spoom::Context).void }
  def initialize(context); end

  # source://spoom//lib/spoom/file_tree.rb#164
  sig { returns(T::Hash[::Spoom::FileTree::Node, T.nilable(::String)]) }
  def strictnesses; end

  # source://spoom//lib/spoom/file_tree.rb#174
  sig { override.params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end
end

# A node representing either a file or a directory inside a FileTree
#
# source://spoom//lib/spoom/file_tree.rb#94
class Spoom::FileTree::Node < ::T::Struct
  const :parent, T.nilable(::Spoom::FileTree::Node)
  const :name, ::String
  const :children, T::Hash[::String, ::Spoom::FileTree::Node], default: T.unsafe(nil)

  # Full path to this node from root
  #
  # source://spoom//lib/spoom/file_tree.rb#108
  sig { returns(::String) }
  def path; end

  class << self
    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# An internal class used to print a FileTree
#
# See `FileTree#print`
#
# source://spoom//lib/spoom/file_tree.rb#228
class Spoom::FileTree::Printer < ::Spoom::FileTree::Visitor
  # source://spoom//lib/spoom/file_tree.rb#238
  sig do
    params(
      strictnesses: T::Hash[::Spoom::FileTree::Node, T.nilable(::String)],
      out: T.any(::IO, ::StringIO),
      colors: T::Boolean
    ).void
  end
  def initialize(strictnesses, out: T.unsafe(nil), colors: T.unsafe(nil)); end

  # source://spoom//lib/spoom/file_tree.rb#246
  sig { override.params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end

  private

  # source://spoom//lib/spoom/file_tree.rb#271
  sig { params(strictness: T.nilable(::String)).returns(::Spoom::Color) }
  def strictness_color(strictness); end
end

# An abstract visitor for FileTree
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/file_tree.rb#117
class Spoom::FileTree::Visitor
  abstract!

  # source://sorbet-runtime/0.5.10598/lib/types/private/abstract/declare.rb#37
  def initialize(*args, **_arg1, &blk); end

  # source://spoom//lib/spoom/file_tree.rb#129
  sig { params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end

  # source://spoom//lib/spoom/file_tree.rb#134
  sig { params(nodes: T::Array[::Spoom::FileTree::Node]).void }
  def visit_nodes(nodes); end

  # source://spoom//lib/spoom/file_tree.rb#124
  sig { params(tree: ::Spoom::FileTree).void }
  def visit_tree(tree); end
end

# source://spoom//lib/spoom/context/git.rb#5
module Spoom::Git; end

# source://spoom//lib/spoom/context/git.rb#6
class Spoom::Git::Commit < ::T::Struct
  const :sha, ::String
  const :time, ::Time

  # source://spoom//lib/spoom/context/git.rb#27
  sig { returns(::Integer) }
  def timestamp; end

  class << self
    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end

    # Parse a line formated as `%h %at` into a `Commit`
    #
    # source://spoom//lib/spoom/context/git.rb#14
    sig { params(string: ::String).returns(T.nilable(::Spoom::Git::Commit)) }
    def parse_line(string); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/base.rb#5
module Spoom::LSP; end

# source://spoom//lib/spoom/sorbet/lsp.rb#13
class Spoom::LSP::Client
  # source://spoom//lib/spoom/sorbet/lsp.rb#17
  sig { params(sorbet_bin: ::String, sorbet_args: ::String, path: ::String).void }
  def initialize(sorbet_bin, *sorbet_args, path: T.unsafe(nil)); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#229
  sig { void }
  def close; end

  # source://spoom//lib/spoom/sorbet/lsp.rb#131
  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::Location]) }
  def definitions(uri, line, column); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#212
  sig { params(uri: ::String).returns(T::Array[::Spoom::LSP::DocumentSymbol]) }
  def document_symbols(uri); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#89
  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T.nilable(::Spoom::LSP::Hover)) }
  def hover(uri, line, column); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#27
  sig { returns(::Integer) }
  def next_id; end

  # LSP requests
  #
  # @raise [Error::AlreadyOpen]
  #
  # source://spoom//lib/spoom/sorbet/lsp.rb#72
  sig { params(workspace_path: ::String).void }
  def open(workspace_path); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#54
  sig { returns(T.nilable(T::Hash[T.untyped, T.untyped])) }
  def read; end

  # @raise [Error::BadHeaders]
  #
  # source://spoom//lib/spoom/sorbet/lsp.rb#43
  sig { returns(T.nilable(::String)) }
  def read_raw; end

  # source://spoom//lib/spoom/sorbet/lsp.rb#173
  sig do
    params(
      uri: ::String,
      line: ::Integer,
      column: ::Integer,
      include_decl: T::Boolean
    ).returns(T::Array[::Spoom::LSP::Location])
  end
  def references(uri, line, column, include_decl = T.unsafe(nil)); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#37
  sig { params(message: ::Spoom::LSP::Message).returns(T.nilable(T::Hash[T.untyped, T.untyped])) }
  def send(message); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#32
  sig { params(json_string: ::String).void }
  def send_raw(json_string); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#110
  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::SignatureHelp]) }
  def signatures(uri, line, column); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#197
  sig { params(query: ::String).returns(T::Array[::Spoom::LSP::DocumentSymbol]) }
  def symbols(query); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#152
  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::Location]) }
  def type_definitions(uri, line, column); end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#178
class Spoom::LSP::Diagnostic < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :range, ::Spoom::LSP::Range
  const :code, ::Integer
  const :message, ::String
  const :informations, ::Object

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#202
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#207
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#191
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Diagnostic) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#212
class Spoom::LSP::DocumentSymbol < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :name, ::String
  const :detail, T.nilable(::String)
  const :kind, ::Integer
  const :location, T.nilable(::Spoom::LSP::Location)
  const :range, T.nilable(::Spoom::LSP::Range)
  const :children, T::Array[::Spoom::LSP::DocumentSymbol]

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#240
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#272
  sig { returns(::String) }
  def kind_string; end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#267
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#227
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::DocumentSymbol) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#276
Spoom::LSP::DocumentSymbol::SYMBOL_KINDS = T.let(T.unsafe(nil), Hash)

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#6
class Spoom::LSP::Error < ::StandardError; end

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#7
class Spoom::LSP::Error::AlreadyOpen < ::Spoom::LSP::Error; end

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#8
class Spoom::LSP::Error::BadHeaders < ::Spoom::LSP::Error; end

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#10
class Spoom::LSP::Error::Diagnostics < ::Spoom::LSP::Error
  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#32
  sig { params(uri: ::String, diagnostics: T::Array[::Spoom::LSP::Diagnostic]).void }
  def initialize(uri, diagnostics); end

  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#17
  sig { returns(T::Array[::Spoom::LSP::Diagnostic]) }
  def diagnostics; end

  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#14
  sig { returns(::String) }
  def uri; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/errors.rb#23
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Error::Diagnostics) }
    def from_json(json); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#19
class Spoom::LSP::Hover < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :contents, ::String
  const :range, T.nilable(T::Range[T.untyped])

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#39
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#45
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#30
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Hover) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#112
class Spoom::LSP::Location < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :uri, ::String
  const :range, ::Spoom::LSP::Range

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#132
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#138
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#123
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Location) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# A general message as defined by JSON-RPC.
#
# The language server protocol always uses `"2.0"` as the `jsonrpc` version.
#
# source://spoom//lib/spoom/sorbet/lsp/base.rb#12
class Spoom::LSP::Message
  # source://spoom//lib/spoom/sorbet/lsp/base.rb#19
  sig { void }
  def initialize; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#24
  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def as_json; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#16
  sig { returns(::String) }
  def jsonrpc; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#32
  sig { params(args: T.untyped).returns(::String) }
  def to_json(*args); end
end

# A notification message.
#
# A processed notification message must not send a response back. They work like events.
#
# source://spoom//lib/spoom/sorbet/lsp/base.rb#64
class Spoom::LSP::Notification < ::Spoom::LSP::Message
  # source://spoom//lib/spoom/sorbet/lsp/base.rb#74
  sig { params(method: ::String, params: T::Hash[T.untyped, T.untyped]).void }
  def initialize(method, params); end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#68
  sig { returns(::String) }
  def method; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#71
  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def params; end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#50
class Spoom::LSP::Position < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :line, ::Integer
  const :char, ::Integer

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#70
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#75
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#61
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Position) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# @abstract Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/sorbet/lsp/structures.rb#9
module Spoom::LSP::PrintableSymbol
  interface!

  # @abstract
  #
  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#16
  sig { abstract.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#80
class Spoom::LSP::Range < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :start, ::Spoom::LSP::Position
  const :end, ::Spoom::LSP::Position

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#100
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#107
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#91
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Range) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# A request message to describe a request between the client and the server.
#
# Every processed request must send a response back to the sender of the request.
#
# source://spoom//lib/spoom/sorbet/lsp/base.rb#40
class Spoom::LSP::Request < ::Spoom::LSP::Message
  # source://spoom//lib/spoom/sorbet/lsp/base.rb#53
  sig { params(id: ::Integer, method: ::String, params: T::Hash[T.untyped, T.untyped]).void }
  def initialize(id, method, params); end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#44
  sig { returns(::Integer) }
  def id; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#47
  sig { returns(::String) }
  def method; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#50
  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def params; end
end

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#40
class Spoom::LSP::ResponseError < ::Spoom::LSP::Error
  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#63
  sig { params(code: ::Integer, message: ::String, data: T::Hash[T.untyped, T.untyped]).void }
  def initialize(code, message, data); end

  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#44
  sig { returns(::Integer) }
  def code; end

  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#47
  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def data; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/errors.rb#53
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::ResponseError) }
    def from_json(json); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#143
class Spoom::LSP::SignatureHelp < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :label, T.nilable(::String)
  const :doc, ::Object
  const :params, T::Array[T.untyped]

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#165
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#173
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#155
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::SignatureHelp) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.10598/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#309
class Spoom::LSP::SymbolPrinter < ::Spoom::Printer
  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#326
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      colors: T::Boolean,
      indent_level: ::Integer,
      prefix: T.nilable(::String)
    ).void
  end
  def initialize(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil), prefix: T.unsafe(nil)); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#348
  sig { params(uri: ::String).returns(::String) }
  def clean_uri(uri); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#316
  sig { returns(T.nilable(::String)) }
  def prefix; end

  # @return [String, nil]
  #
  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#316
  def prefix=(_arg0); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#356
  sig { params(objects: T::Array[::Spoom::LSP::PrintableSymbol]).void }
  def print_list(objects); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#336
  sig { params(object: T.nilable(::Spoom::LSP::PrintableSymbol)).void }
  def print_object(object); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#343
  sig { params(objects: T::Array[::Spoom::LSP::PrintableSymbol]).void }
  def print_objects(objects); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#313
  sig { returns(T::Set[::Integer]) }
  def seen; end

  # @return [Set<Integer>]
  #
  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#313
  def seen=(_arg0); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/printer.rb#7
class Spoom::Printer
  include ::Spoom::Colorize

  abstract!

  # source://spoom//lib/spoom/printer.rb#19
  sig { params(out: T.any(::IO, ::StringIO), colors: T::Boolean, indent_level: ::Integer).void }
  def initialize(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil)); end

  # Colorize `string` with color if `@colors`
  #
  # source://spoom//lib/spoom/printer.rb#80
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def colorize(string, *color); end

  # Decrease indent level
  #
  # source://spoom//lib/spoom/printer.rb#33
  sig { void }
  def dedent; end

  # Increase indent level
  #
  # source://spoom//lib/spoom/printer.rb#27
  sig { void }
  def indent; end

  # source://spoom//lib/spoom/printer.rb#16
  sig { returns(T.any(::IO, ::StringIO)) }
  def out; end

  # @return [IO, StringIO]
  #
  # source://spoom//lib/spoom/printer.rb#16
  def out=(_arg0); end

  # Print `string` into `out`
  #
  # source://spoom//lib/spoom/printer.rb#39
  sig { params(string: T.nilable(::String)).void }
  def print(string); end

  # Print `string` colored with `color` into `out`
  #
  # Does not use colors unless `@colors`.
  #
  # source://spoom//lib/spoom/printer.rb#49
  sig { params(string: T.nilable(::String), color: ::Spoom::Color).void }
  def print_colored(string, *color); end

  # Print `string` with indent and newline
  #
  # source://spoom//lib/spoom/printer.rb#64
  sig { params(string: T.nilable(::String)).void }
  def printl(string); end

  # Print a new line into `out`
  #
  # source://spoom//lib/spoom/printer.rb#58
  sig { void }
  def printn; end

  # Print an indent space into `out`
  #
  # source://spoom//lib/spoom/printer.rb#74
  sig { void }
  def printt; end
end

# source://spoom//lib/spoom.rb#10
Spoom::SPOOM_PATH = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/config.rb#5
module Spoom::Sorbet; end

# source://spoom//lib/spoom/sorbet.rb#38
Spoom::Sorbet::BIN_PATH = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet.rb#36
Spoom::Sorbet::CONFIG_PATH = T.let(T.unsafe(nil), String)

# Parse Sorbet config files
#
# Parses a Sorbet config file:
#
# ```ruby
# config = Spoom::Sorbet::Config.parse_file("sorbet/config")
# puts config.paths   # "."
# ```
#
# Parses a Sorbet config string:
#
# ```ruby
# config = Spoom::Sorbet::Config.parse_string(<<~CONFIG)
#   a
#   --file=b
#   --ignore=c
# CONFIG
# puts config.paths   # "a", "b"
# puts config.ignore  # "c"
# ```
#
# source://spoom//lib/spoom/sorbet/config.rb#26
class Spoom::Sorbet::Config
  # source://spoom//lib/spoom/sorbet/config.rb#38
  sig { void }
  def initialize; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def allowed_extensions; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def allowed_extensions=(_arg0); end

  # source://spoom//lib/spoom/sorbet/config.rb#46
  sig { returns(::Spoom::Sorbet::Config) }
  def copy; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def ignore; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def ignore=(_arg0); end

  # source://spoom//lib/spoom/sorbet/config.rb#35
  sig { returns(T::Boolean) }
  def no_stdlib; end

  # @return [Boolean]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#35
  def no_stdlib=(_arg0); end

  # Returns self as a string of options that can be passed to Sorbet
  #
  # Example:
  # ~~~rb
  # config = Sorbet::Config.new
  # config.paths << "/foo"
  # config.paths << "/bar"
  # config.ignore << "/baz"
  # config.allowed_extensions << ".rb"
  #
  # puts config.options_string # "/foo /bar --ignore /baz --allowed-extension .rb"
  # ~~~
  #
  # source://spoom//lib/spoom/sorbet/config.rb#68
  sig { returns(::String) }
  def options_string; end

  # source://spoom//lib/spoom/sorbet/config.rb#32
  sig { returns(T::Array[::String]) }
  def paths; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def paths=(_arg0); end

  class << self
    # source://spoom//lib/spoom/sorbet/config.rb#81
    sig { params(sorbet_config_path: ::String).returns(::Spoom::Sorbet::Config) }
    def parse_file(sorbet_config_path); end

    # source://spoom//lib/spoom/sorbet/config.rb#86
    sig { params(sorbet_config: ::String).returns(::Spoom::Sorbet::Config) }
    def parse_string(sorbet_config); end

    private

    # source://spoom//lib/spoom/sorbet/config.rb#150
    sig { params(line: ::String).returns(::String) }
    def parse_option(line); end
  end
end

# source://spoom//lib/spoom/sorbet/config.rb#29
Spoom::Sorbet::Config::DEFAULT_ALLOWED_EXTENSIONS = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/sorbet.rb#14
class Spoom::Sorbet::Error < ::StandardError
  # source://spoom//lib/spoom/sorbet.rb#29
  sig { params(message: ::String, result: ::Spoom::ExecResult).void }
  def initialize(message, result); end

  # source://spoom//lib/spoom/sorbet.rb#21
  sig { returns(::Spoom::ExecResult) }
  def result; end
end

# source://spoom//lib/spoom/sorbet.rb#17
class Spoom::Sorbet::Error::Killed < ::Spoom::Sorbet::Error; end

# source://spoom//lib/spoom/sorbet.rb#18
class Spoom::Sorbet::Error::Segfault < ::Spoom::Sorbet::Error; end

# source://spoom//lib/spoom/sorbet/errors.rb#6
module Spoom::Sorbet::Errors
  class << self
    # source://spoom//lib/spoom/sorbet/errors.rb#13
    sig { params(errors: T::Array[::Spoom::Sorbet::Errors::Error]).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
    def sort_errors_by_code(errors); end
  end
end

# source://spoom//lib/spoom/sorbet/errors.rb#7
Spoom::Sorbet::Errors::DEFAULT_ERROR_URL_BASE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/errors.rb#125
class Spoom::Sorbet::Errors::Error
  include ::Comparable

  # source://spoom//lib/spoom/sorbet/errors.rb#151
  sig do
    params(
      file: T.nilable(::String),
      line: T.nilable(::Integer),
      message: T.nilable(::String),
      code: T.nilable(::Integer),
      more: T::Array[::String]
    ).void
  end
  def initialize(file, line, message, code, more = T.unsafe(nil)); end

  # By default errors are sorted by location
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#162
  sig { params(other: T.untyped).returns(::Integer) }
  def <=>(other); end

  # @return [Integer, nil]
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#133
  def code; end

  # source://spoom//lib/spoom/sorbet/errors.rb#130
  sig { returns(T.nilable(::String)) }
  def file; end

  # Other files associated with the error
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#140
  sig { returns(T::Set[::String]) }
  def files_from_error_sections; end

  # source://spoom//lib/spoom/sorbet/errors.rb#133
  sig { returns(T.nilable(::Integer)) }
  def line; end

  # @return [String, nil]
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#130
  def message; end

  # source://spoom//lib/spoom/sorbet/errors.rb#136
  sig { returns(T::Array[::String]) }
  def more; end

  # source://spoom//lib/spoom/sorbet/errors.rb#169
  sig { returns(::String) }
  def to_s; end
end

# Parse errors from Sorbet output
#
# source://spoom//lib/spoom/sorbet/errors.rb#18
class Spoom::Sorbet::Errors::Parser
  # source://spoom//lib/spoom/sorbet/errors.rb#43
  sig { params(error_url_base: ::String).void }
  def initialize(error_url_base: T.unsafe(nil)); end

  # source://spoom//lib/spoom/sorbet/errors.rb#50
  sig { params(output: ::String).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
  def parse(output); end

  private

  # source://spoom//lib/spoom/sorbet/errors.rb#114
  sig { params(line: ::String).void }
  def append_error(line); end

  # source://spoom//lib/spoom/sorbet/errors.rb#106
  sig { void }
  def close_error; end

  # source://spoom//lib/spoom/sorbet/errors.rb#73
  sig { params(error_url_base: ::String).returns(::Regexp) }
  def error_line_match_regexp(error_url_base); end

  # source://spoom//lib/spoom/sorbet/errors.rb#90
  sig { params(line: ::String).returns(T.nilable(::Spoom::Sorbet::Errors::Error)) }
  def match_error_line(line); end

  # source://spoom//lib/spoom/sorbet/errors.rb#99
  sig { params(error: ::Spoom::Sorbet::Errors::Error).void }
  def open_error(error); end

  class << self
    # source://spoom//lib/spoom/sorbet/errors.rb#36
    sig { params(output: ::String, error_url_base: ::String).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
    def parse_string(output, error_url_base: T.unsafe(nil)); end
  end
end

# source://spoom//lib/spoom/sorbet/errors.rb#21
Spoom::Sorbet::Errors::Parser::HEADER = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/sorbet.rb#37
Spoom::Sorbet::GEM_PATH = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet.rb#40
Spoom::Sorbet::KILLED_CODE = T.let(T.unsafe(nil), Integer)

# source://spoom//lib/spoom/sorbet/metrics.rb#8
module Spoom::Sorbet::MetricsParser
  class << self
    # source://spoom//lib/spoom/sorbet/metrics.rb#15
    sig { params(path: ::String, prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_file(path, prefix = T.unsafe(nil)); end

    # source://spoom//lib/spoom/sorbet/metrics.rb#25
    sig { params(obj: T::Hash[::String, T.untyped], prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_hash(obj, prefix = T.unsafe(nil)); end

    # source://spoom//lib/spoom/sorbet/metrics.rb#20
    sig { params(string: ::String, prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_string(string, prefix = T.unsafe(nil)); end
  end
end

# source://spoom//lib/spoom/sorbet/metrics.rb#9
Spoom::Sorbet::MetricsParser::DEFAULT_PREFIX = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet.rb#41
Spoom::Sorbet::SEGFAULT_CODE = T.let(T.unsafe(nil), Integer)

# source://spoom//lib/spoom/sorbet/sigils.rb#9
module Spoom::Sorbet::Sigils
  class << self
    # changes the sigil in the file at the passed path to the specified new strictness
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#72
    sig { params(path: T.any(::Pathname, ::String), new_strictness: ::String).returns(T::Boolean) }
    def change_sigil_in_file(path, new_strictness); end

    # changes the sigil to have a new strictness in a list of files
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#83
    sig { params(path_list: T::Array[::String], new_strictness: ::String).returns(T::Array[::String]) }
    def change_sigil_in_files(path_list, new_strictness); end

    # returns a string containing the strictness of a sigil in a file at the passed path
    # * returns nil if no sigil
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#63
    sig { params(path: T.any(::Pathname, ::String)).returns(T.nilable(::String)) }
    def file_strictness(path); end

    # returns the full sigil comment string for the passed strictness
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#38
    sig { params(strictness: ::String).returns(::String) }
    def sigil_string(strictness); end

    # returns the strictness of a sigil in the passed file content string (nil if no sigil)
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#50
    sig { params(content: ::String).returns(T.nilable(::String)) }
    def strictness_in_content(content); end

    # returns a string which is the passed content but with the sigil updated to a new strictness
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#56
    sig { params(content: ::String, new_strictness: ::String).returns(::String) }
    def update_sigil(content, new_strictness); end

    # returns true if the passed string is a valid strictness (else false)
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#44
    sig { params(strictness: ::String).returns(T::Boolean) }
    def valid_strictness?(strictness); end
  end
end

# source://spoom//lib/spoom/sorbet/sigils.rb#31
Spoom::Sorbet::Sigils::SIGIL_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://spoom//lib/spoom/sorbet/sigils.rb#13
Spoom::Sorbet::Sigils::STRICTNESS_FALSE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#12
Spoom::Sorbet::Sigils::STRICTNESS_IGNORE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#17
Spoom::Sorbet::Sigils::STRICTNESS_INTERNAL = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#15
Spoom::Sorbet::Sigils::STRICTNESS_STRICT = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#16
Spoom::Sorbet::Sigils::STRICTNESS_STRONG = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#14
Spoom::Sorbet::Sigils::STRICTNESS_TRUE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#19
Spoom::Sorbet::Sigils::VALID_STRICTNESS = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/timeline.rb#5
class Spoom::Timeline
  # source://spoom//lib/spoom/timeline.rb#9
  sig { params(context: ::Spoom::Context, from: ::Time, to: ::Time).void }
  def initialize(context, from, to); end

  # Return one commit for each date in `dates`
  #
  # source://spoom//lib/spoom/timeline.rb#36
  sig { params(dates: T::Array[::Time]).returns(T::Array[::Spoom::Git::Commit]) }
  def commits_for_dates(dates); end

  # Return all months between `from` and `to`
  #
  # source://spoom//lib/spoom/timeline.rb#23
  sig { returns(T::Array[::Time]) }
  def months; end

  # Return one commit for each month between `from` and `to`
  #
  # source://spoom//lib/spoom/timeline.rb#17
  sig { returns(T::Array[::Spoom::Git::Commit]) }
  def ticks; end
end

# source://spoom//lib/spoom/version.rb#5
Spoom::VERSION = T.let(T.unsafe(nil), String)
