#!/bin/bash
# bbou@ac-toulouse.fr
# 2006-02-04 09:50:30 
# conf/sync-clocks-sh

### P A R A M S
MYSERVER="$1"
if [ ! -z "${MYSERVER}" ]; then
	serveropt="-S ${MYSERVER}"
fi

### I N C L U D E S
. ./_include.sh

### S T A R T

function setnettime0()
{
net time set $1 > /dev/null
return $?
}

function setnettime()
{
if ! net time system $1 > /dev/null; then
	return 1
fi
t=`net time system $1`
date $t > /dev/null
return $?
}

echo "+sync clocks with kdc"
echo -n "local time was: "
date "+%Y-%m-%d %H:%M.%S"
echo "synchronizing with ${MYSERVER}"
if ! setnettime "${serveropt}"; then
	echo "error with net time (will continue without syncing clocks)" >&2
	exit
fi

echo -n "net time is now:"
nettime=`net time ${serveropt}`
date -d "${nettime}" "+%Y-%m-%d %H:%M.%S"

echo -n "local time is now:"
date "+%Y-%m-%d %H:%M.%S"
