#!/usr/bin/env python
"""Execute the tests for the tree_recomb program.

The golden test outputs are generated by the script generate_outputs.sh.

You have to give the root paths to the source and the binaries as arguments to
the program.  These are the paths to the directory that contains the 'projects'
directory.

Usage:  run_tests.py SOURCE_ROOT_PATH BINARY_ROOT_PATH
"""
import os.path
import sys

# Automagically add util/py_lib to PYTHONPATH environment variable.
path = os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..',
                                    '..', '..', 'util', 'py_lib'))
sys.path.insert(0, path)

import seqan.app_tests as app_tests

def main(source_base, binary_base):
    """Main entry point of the script."""

    print 'Executing test for tree_recomb'
    print '=============================='
    print
    
    ph = app_tests.TestPathHelper(
        source_base, binary_base,
        'core/apps/tree_recon/tests')  # tests dir

    # ============================================================
    # Auto-detect the binary path.
    # ============================================================

    path_to_program = app_tests.autolocateBinary(
      binary_base, 'core/apps/tree_recon', 'tree_recon')

    # ============================================================
    # Built TestConf list.
    # ============================================================

    # Build list with TestConf objects, analoguely to how the output
    # was generated in generate_outputs.sh.
    conf_list = []
    for i in [1, 2, 3]:
        conf = app_tests.TestConf(
            program=path_to_program,
            args=['-m', ph.inFile('example%d.dist' % i),
                  '-o', ph.outFile('example%d.dot' % i)],
            to_diff=[(ph.inFile('example%d.dot' % i),
                      ph.outFile('example%d.dot' % i))])
        conf_list.append(conf)
    for i in [1, 2, 3]:
        for b in ['nj', 'min', 'max', 'avg', 'wavg']:
            if i == 1 and b == 'avg':
                continue  # Skip, rounding problems MSVC vs GCC.
            conf = app_tests.TestConf(
                program=path_to_program,
                args=['-b', b,
                      '-m', ph.inFile('example%d.dist' % i),
                      '-o', ph.outFile('example%d.%s.dot' % (i, b))],
                to_diff=[(ph.inFile('example%d.%s.dot' % (i, b)),
                          ph.outFile('example%d.%s.dot' % (i, b)))])
            conf_list.append(conf)
    for i in [1, 2, 3]:
        for f in ['dot', 'newick']:
            conf = app_tests.TestConf(
                program=path_to_program,
                args=['-m', ph.inFile('example%d.dist' % i),
                      '-o', ph.outFile('example%d.%s' % (i, f))],
                to_diff=[(ph.inFile('example%d.%s' % (i, f)),
                          ph.outFile('example%d.%s' % (i, f)))])
            conf_list.append(conf)
    
    # Execute the tests.
    failures = 0
    for conf in conf_list:
        res = app_tests.runTest(conf)
        # Output to the user.
        print ' '.join(['tree_recomb'] + conf.args),
        if res:
             print 'OK'
        else:
            failures += 1
            print 'FAILED'

    # Cleanup.
    ph.deleteTempDir()

    print '=============================='
    print '     total tests: %d' % len(conf_list)
    print '    failed tests: %d' % failures
    print 'successful tests: %d' % (len(conf_list) - failures)
    print '=============================='
    # Compute and return return code.
    return failures != 0


if __name__ == '__main__':
    sys.exit(app_tests.main(main))
