/* Public domain. */

#include "uint64.h"
#include "uint64alloc.h"
#include "bitarray.h"

#define div64(n) ((n) ? 1 + (((n) - 1) >> 6) : 0)


void bitarray_clearsetn (register bitarray *x, register unsigned int a, register unsigned int b, register unsigned char h)
{
  if (!b) return ;
  b += a ;
  if ((a >> 6) == ((b-1) >> 6))
  {
    register uint64 mask = ((1 << (a & 63)) - 1) ^ ((a << (b & 63)) - 1) ;
    if (h) x->x.s[a>>6] |= mask ;
    else x->x.s[a>>6] &= ~mask ;
  }
  else
  {
    register uint64 mask = ~((1 << (a & 63)) - 1) ;
    register unsigned int i = (a>>6) + 1 ;
    if (h) x->x.s[a>>6] |= mask ; else x->x.s[a>>6] &= ~mask ;
    mask = h ? ~((uint64)0) : (uint64)0 ;
    for (; i < (b>>6) - 1 ; i++) x->x.s[i] = mask ;
    mask = (1 << (b & 63)) - 1 ;
    if (h) x->x.s[b>>6] |= mask ; else x->x.s[b>>6] &= ~mask ;
  }
}

void bitarray_free (register bitarray *b)
{
  uint64alloc_free(&b->x) ;
}

int bitarray_ready (register bitarray *b, register unsigned int n)
{
  register unsigned int old = b->x.a << 6 ;
  if (n < old) return 1 ;
  if (!uint64alloc_ready(&b->x, div64(n))) return 0 ;
  bitarray_clearn(b, old, (b->x.a << 6) - old) ;
  return 1 ;
}

int bitarray_readyplus (register bitarray *b, register unsigned int n)
{
  return bitarray_ready(b, n + (b->x.a << 6)) ;
}

int bitarray_peek (register bitarray const *b, register unsigned int n)
{
  return (b->x.s[n>>6] & ((uint64)1 << (n & 63))) ? 1 : 0 ;
}

void bitarray_clear (register bitarray *b, register unsigned int n)
{
  b->x.s[n>>6] &= ~((uint64)1 << (n & 63)) ;
}

void bitarray_set (register bitarray *b, register unsigned int n)
{
  b->x.s[n>>6] |= (uint64)1 << (n & 63) ;
}

int bitarray_testandpoke (register bitarray *b, register unsigned int n, register unsigned char h)
{
  register uint64 mask = (uint64)1 << (n & 63) ;
  register uint64 z = b->x.s[n>>6] ;
  b->x.s[n>>6] = h ? z | mask : z & ~mask ;
  return (z & mask) ? 1 : 0 ;
}

unsigned int bitarray_firstclear (register bitarray const *b)
{
  register uint64 z = ~(uint64)0 ;
  register unsigned int i = 0 ;
  for (; i < b->x.a ; i++) if (b->x.s[i] != z) break ;
  if (i >= b->x.a) return i << 6 ;
  z = b->x.s[i] ;
  i <<= 6 ;
  {
    register unsigned int j = 64 ;
    while (j >>= 1)
    {
      register uint64 k = ((uint64)1 << j) - 1 ;
      if ((z & k) == k)
      {
        i += j ;
        z >>= j ;
      }
    }
  }
  return i ;
}
