from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


FIELD_TYPE = _Mock()

FIELD_TYPE_OUT = _Mock()

TAG_ID = _Mock()

numpy = _Mock()

os = _Mock()

struct = _Mock()

sys = _Mock()

ALLOW_MULTIPLE_STRIPS = _Mock()

DEBUG = 0

SAMPLE_FORMAT_COMPLEXIEEEFP = 6

SAMPLE_FORMAT_COMPLEXINT = 5

SAMPLE_FORMAT_FLOAT = 3

SAMPLE_FORMAT_INT = 2

SAMPLE_FORMAT_UINT = 1

SAMPLE_FORMAT_VOID = 4

TAG_BITS_PER_SAMPLE = 258

TAG_COLORMAP = 320

TAG_COMPRESSION = 259

TAG_DATE = 306

TAG_IMAGE_DESCRIPTION = 270

TAG_NUMBER_OF_COLUMNS = 256

TAG_NUMBER_OF_ROWS = 257

TAG_PHOTOMETRIC_INTERPRETATION = 262

TAG_ROWS_PER_STRIP = 278

TAG_SAMPLE_FORMAT = 339

TAG_SOFTWARE = 305

TAG_STRIP_BYTE_COUNTS = 279

TAG_STRIP_OFFSETS = 273

class TiffIO(_Mock):
  pass


